import{s as rs,z as is,o as ls,n as rt}from"../chunks/scheduler.18a86fab.js";import{S as ms,i as ds,g as m,s,r as h,A as cs,h as d,f as t,c as n,j as $,u as f,x as p,k as v,y as a,a as i,v as u,d as _,t as b,w as M}from"../chunks/index.98837b22.js";import{T as as}from"../chunks/Tip.77304350.js";import{D as N}from"../chunks/Docstring.6758ea23.js";import{C as Vt}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Xt}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as B}from"../chunks/Heading.7e7e0c5b.js";import{E as ps}from"../chunks/index.92f616ba.js";function gs(C){let l,w="Examples:",g,c,k;return c=new Vt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hc2syRm9ybWVyQ29uZmlnJTJDJTIwTWFzazJGb3JtZXJNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBNYXNrMkZvcm1lciUyMGZhY2Vib29rJTJGbWFzazJmb3JtZXItc3dpbi1zbWFsbC1jb2NvLWluc3RhbmNlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBNYXNrMkZvcm1lckNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBmYWNlYm9vayUyRm1hc2syZm9ybWVyLXN3aW4tc21hbGwtY29jby1pbnN0YW5jZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwTWFzazJGb3JtZXJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Mask2FormerConfig, Mask2FormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Mask2Former facebook/mask2former-swin-small-coco-instance configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Mask2FormerConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the facebook/mask2former-swin-small-coco-instance style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){l=m("p"),l.textContent=w,g=s(),h(c.$$.fragment)},l(r){l=d(r,"P",{"data-svelte-h":!0}),p(l)!=="svelte-kvfsh7"&&(l.textContent=w),g=n(r),f(c.$$.fragment,r)},m(r,y){i(r,l,y),i(r,g,y),u(c,r,y),k=!0},p:rt,i(r){k||(_(c.$$.fragment,r),k=!0)},o(r){b(c.$$.fragment,r),k=!1},d(r){r&&(t(l),t(g)),M(c,r)}}}function hs(C){let l,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=m("p"),l.innerHTML=w},l(g){l=d(g,"P",{"data-svelte-h":!0}),p(l)!=="svelte-fincs2"&&(l.innerHTML=w)},m(g,c){i(g,l,c)},p:rt,d(g){g&&t(l)}}}function fs(C){let l,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=m("p"),l.innerHTML=w},l(g){l=d(g,"P",{"data-svelte-h":!0}),p(l)!=="svelte-fincs2"&&(l.innerHTML=w)},m(g,c){i(g,l,c)},p:rt,d(g){g&&t(l)}}}function us(C){let l,w="Instance segmentation example:",g,c,k;return c=new Vt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyME1hc2syRm9ybWVyRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQSUyMyUyMExvYWQlMjBNYXNrMkZvcm1lciUyMHRyYWluZWQlMjBvbiUyMENPQ08lMjBpbnN0YW5jZSUyMHNlZ21lbnRhdGlvbiUyMGRhdGFzZXQlMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbWFzazJmb3JtZXItc3dpbi1zbWFsbC1jb2NvLWluc3RhbmNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwTWFzazJGb3JtZXJGb3JVbml2ZXJzYWxTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGbWFzazJmb3JtZXItc3dpbi1zbWFsbC1jb2NvLWluc3RhbmNlJTIyJTBBKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwTW9kZWwlMjBwcmVkaWN0cyUyMGNsYXNzX3F1ZXJpZXNfbG9naXRzJTIwb2YlMjBzaGFwZSUyMCU2MChiYXRjaF9zaXplJTJDJTIwbnVtX3F1ZXJpZXMpJTYwJTBBJTIzJTIwYW5kJTIwbWFza3NfcXVlcmllc19sb2dpdHMlMjBvZiUyMHNoYXBlJTIwJTYwKGJhdGNoX3NpemUlMkMlMjBudW1fcXVlcmllcyUyQyUyMGhlaWdodCUyQyUyMHdpZHRoKSU2MCUwQWNsYXNzX3F1ZXJpZXNfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5jbGFzc19xdWVyaWVzX2xvZ2l0cyUwQW1hc2tzX3F1ZXJpZXNfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5tYXNrc19xdWVyaWVzX2xvZ2l0cyUwQSUwQSUyMyUyMFBlcmZvcm0lMjBwb3N0LXByb2Nlc3NpbmclMjB0byUyMGdldCUyMGluc3RhbmNlJTIwc2VnbWVudGF0aW9uJTIwbWFwJTBBcHJlZF9pbnN0YW5jZV9tYXAlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX2luc3RhbmNlX3NlZ21lbnRhdGlvbiglMEElMjAlMjAlMjAlMjBvdXRwdXRzJTJDJTIwdGFyZ2V0X3NpemVzJTNEJTVCKGltYWdlLmhlaWdodCUyQyUyMGltYWdlLndpZHRoKSU1RCUwQSklNUIwJTVEJTBBcHJpbnQocHJlZF9pbnN0YW5jZV9tYXAuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Mask2FormerForUniversalSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load Mask2Former trained on COCO instance segmentation dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-coco-instance&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerForUniversalSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/mask2former-swin-small-coco-instance&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Perform post-processing to get instance segmentation map</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred_instance_map = image_processor.post_process_instance_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[(image.height, image.width)]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(pred_instance_map.shape)
torch.Size([<span class="hljs-number">480</span>, <span class="hljs-number">640</span>])`,wrap:!1}}),{c(){l=m("p"),l.textContent=w,g=s(),h(c.$$.fragment)},l(r){l=d(r,"P",{"data-svelte-h":!0}),p(l)!=="svelte-1xhxiwz"&&(l.textContent=w),g=n(r),f(c.$$.fragment,r)},m(r,y){i(r,l,y),i(r,g,y),u(c,r,y),k=!0},p:rt,i(r){k||(_(c.$$.fragment,r),k=!0)},o(r){b(c.$$.fragment,r),k=!1},d(r){r&&(t(l),t(g)),M(c,r)}}}function _s(C){let l,w="Semantic segmentation example:",g,c,k;return c=new Vt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyME1hc2syRm9ybWVyRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQSUyMyUyMExvYWQlMjBNYXNrMkZvcm1lciUyMHRyYWluZWQlMjBvbiUyMEFERTIwayUyMHNlbWFudGljJTIwc2VnbWVudGF0aW9uJTIwZGF0YXNldCUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYXNrMmZvcm1lci1zd2luLXNtYWxsLWFkZS1zZW1hbnRpYyUyMiklMEFtb2RlbCUyMCUzRCUyME1hc2syRm9ybWVyRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm1hc2syZm9ybWVyLXN3aW4tc21hbGwtYWRlLXNlbWFudGljJTIyKSUwQSUwQXVybCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZml4dHVyZXNfYWRlMjBrJTJGcmVzb2x2ZSUyRm1haW4lMkZBREVfdmFsXzAwMDAwMDAxLmpwZyUyMiUwQSklMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwTW9kZWwlMjBwcmVkaWN0cyUyMGNsYXNzX3F1ZXJpZXNfbG9naXRzJTIwb2YlMjBzaGFwZSUyMCU2MChiYXRjaF9zaXplJTJDJTIwbnVtX3F1ZXJpZXMpJTYwJTBBJTIzJTIwYW5kJTIwbWFza3NfcXVlcmllc19sb2dpdHMlMjBvZiUyMHNoYXBlJTIwJTYwKGJhdGNoX3NpemUlMkMlMjBudW1fcXVlcmllcyUyQyUyMGhlaWdodCUyQyUyMHdpZHRoKSU2MCUwQWNsYXNzX3F1ZXJpZXNfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5jbGFzc19xdWVyaWVzX2xvZ2l0cyUwQW1hc2tzX3F1ZXJpZXNfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5tYXNrc19xdWVyaWVzX2xvZ2l0cyUwQSUwQSUyMyUyMFBlcmZvcm0lMjBwb3N0LXByb2Nlc3NpbmclMjB0byUyMGdldCUyMHNlbWFudGljJTIwc2VnbWVudGF0aW9uJTIwbWFwJTBBcHJlZF9zZW1hbnRpY19tYXAlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX3NlbWFudGljX3NlZ21lbnRhdGlvbiglMEElMjAlMjAlMjAlMjBvdXRwdXRzJTJDJTIwdGFyZ2V0X3NpemVzJTNEJTVCKGltYWdlLmhlaWdodCUyQyUyMGltYWdlLndpZHRoKSU1RCUwQSklNUIwJTVEJTBBcHJpbnQocHJlZF9zZW1hbnRpY19tYXAuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Mask2FormerForUniversalSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load Mask2Former trained on ADE20k semantic segmentation dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-ade-semantic&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerForUniversalSegmentation.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-ade-semantic&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_ade20k/resolve/main/ADE_val_00000001.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Perform post-processing to get semantic segmentation map</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred_semantic_map = image_processor.post_process_semantic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[(image.height, image.width)]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(pred_semantic_map.shape)
torch.Size([<span class="hljs-number">512</span>, <span class="hljs-number">683</span>])`,wrap:!1}}),{c(){l=m("p"),l.textContent=w,g=s(),h(c.$$.fragment)},l(r){l=d(r,"P",{"data-svelte-h":!0}),p(l)!=="svelte-ec2k7m"&&(l.textContent=w),g=n(r),f(c.$$.fragment,r)},m(r,y){i(r,l,y),i(r,g,y),u(c,r,y),k=!0},p:rt,i(r){k||(_(c.$$.fragment,r),k=!0)},o(r){b(c.$$.fragment,r),k=!1},d(r){r&&(t(l),t(g)),M(c,r)}}}function bs(C){let l,w="Panoptic segmentation example:",g,c,k;return c=new Vt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Mask2FormerForUniversalSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load Mask2Former trained on CityScapes panoptic segmentation dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-cityscapes-panoptic&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerForUniversalSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/mask2former-swin-small-cityscapes-panoptic&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://cdn-media.huggingface.co/Inference-API/Sample-results-on-the-Cityscapes-dataset-The-above-images-show-how-our-method-can-handle.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Perform post-processing to get panoptic segmentation map</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred_panoptic_map = image_processor.post_process_panoptic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[(image.height, image.width)]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(pred_panoptic_map.shape)
torch.Size([<span class="hljs-number">338</span>, <span class="hljs-number">676</span>])`,wrap:!1}}),{c(){l=m("p"),l.textContent=w,g=s(),h(c.$$.fragment)},l(r){l=d(r,"P",{"data-svelte-h":!0}),p(l)!=="svelte-1hqqxa2"&&(l.textContent=w),g=n(r),f(c.$$.fragment,r)},m(r,y){i(r,l,y),i(r,g,y),u(c,r,y),k=!0},p:rt,i(r){k||(_(c.$$.fragment,r),k=!0)},o(r){b(c.$$.fragment,r),k=!1},d(r){r&&(t(l),t(g)),M(c,r)}}}function Ms(C){let l,w,g,c,k,r,y,vo='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',lt,te,mt,oe,To='The Mask2Former model was proposed in <a href="https://arxiv.org/abs/2112.01527" rel="nofollow">Masked-attention Mask Transformer for Universal Image Segmentation</a> by Bowen Cheng, Ishan Misra, Alexander G. Schwing, Alexander Kirillov, Rohit Girdhar. Mask2Former is a unified framework for panoptic, instance and semantic segmentation and features significant performance and efficiency improvements over <a href="maskformer">MaskFormer</a>.',dt,se,xo="The abstract from the paper is the following:",ct,ne,Uo=`<em>Image segmentation groups pixels with different semantics, e.g., category or instance membership. Each choice
of semantics defines a task. While only the semantics of each task differ, current research focuses on designing specialized architectures for each task. We present Masked-attention Mask Transformer (Mask2Former), a new architecture capable of addressing any image segmentation task (panoptic, instance or semantic). Its key components include masked attention, which extracts localized features by constraining cross-attention within predicted mask regions. In addition to reducing the research effort by at least three times, it outperforms the best specialized architectures by a significant margin on four popular datasets. Most notably, Mask2Former sets a new state-of-the-art for panoptic segmentation (57.8 PQ on COCO), instance segmentation (50.1 AP on COCO) and semantic segmentation (57.7 mIoU on ADE20K).</em>`,pt,G,$o,gt,ae,jo='Mask2Former architecture. Taken from the <a href="https://arxiv.org/abs/2112.01527">original paper.</a>',ht,re,zo='This model was contributed by <a href="https://huggingface.co/shivi" rel="nofollow">Shivalika Singh</a> and <a href="https://huggingface.co/adirik" rel="nofollow">Alara Dirik</a>. The original code can be found <a href="https://github.com/facebookresearch/Mask2Former" rel="nofollow">here</a>.',ft,ie,ut,le,Io='<li>Mask2Former uses the same preprocessing and postprocessing steps as <a href="maskformer">MaskFormer</a>. Use <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor">Mask2FormerImageProcessor</a> or <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a> to prepare images and optional targets for the model.</li> <li>To get the final segmentation, depending on the task, you can call <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a>. All three tasks can be solved using <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a> output, panoptic segmentation accepts an optional <code>label_ids_to_fuse</code> argument to fuse instances of the target object/s (e.g. sky) together.</li>',_t,me,bt,de,Co="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with Mask2Former.",Mt,ce,Jo='<li>Demo notebooks regarding inference + fine-tuning Mask2Former on custom data can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Mask2Former" rel="nofollow">here</a>.</li> <li>Scripts for finetuning <code>Mask2Former</code> with <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a> or <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> can be found <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/instance-segmentation" rel="nofollow">here</a>.</li>',kt,pe,No=`If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we will review it.
The resource should ideally demonstrate something new instead of duplicating an existing resource.`,yt,ge,wt,x,he,Rt,We,Wo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerModel">Mask2FormerModel</a>. It is used to instantiate a
Mask2Former model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Mask2Former
<a href="https://huggingface.co/facebook/mask2former-swin-small-coco-instance" rel="nofollow">facebook/mask2former-swin-small-coco-instance</a>
architecture.`,St,Ze,Zo=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Pt,Le,Lo='Currently, Mask2Former only supports the <a href="swin">Swin Transformer</a> as backbone.',Bt,H,Gt,q,fe,Ht,Xe,Xo='Instantiate a <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerConfig">Mask2FormerConfig</a> (or a derived class) from a pre-trained backbone model configuration.',Ft,ue,vt,R,_e,qt,Ve,Vo='Class for outputs of <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerModel">Mask2FormerModel</a>. This class returns all the needed hidden states to compute the logits.',Tt,Z,be,Ot,Re,Ro="Class for outputs of <code>Mask2FormerForUniversalSegmentationOutput</code>.",Et,Se,So=`This output can be directly passed to <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or
<a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or
<a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a> to compute final segmentation maps. Please, see
[\`~Mask2FormerImageProcessor] for details regarding usage.`,xt,Me,Ut,j,ke,Yt,Pe,Po="The bare Mask2Former Model outputting raw hidden-states without any specific head on top.",Qt,Be,Bo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,At,Ge,Go=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Dt,L,ye,Kt,He,Ho='The <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerModel">Mask2FormerModel</a> forward method, overrides the <code>__call__</code> special method.',eo,O,$t,we,jt,z,Fe,to,qe,qo="The Mask2Former Model with heads on top for instance/semantic/panoptic segmentation.",oo,Oe,Oo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,so,Ee,Eo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,no,T,ve,ao,Ye,Yo='The <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a> forward method, overrides the <code>__call__</code> special method.',ro,E,io,Qe,Qo="Examples:",lo,Y,mo,Q,co,A,zt,Te,It,F,xe,po,Ae,Ao=`Constructs a Mask2Former image processor. The image processor can be used to prepare image(s) and optional targets
for the model.`,go,De,Do=`This image processor inherits from <a href="/docs/transformers/main/en/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,ho,Ke,Ue,fo,X,$e,uo,et,Ko="Pad images up to the largest image in a batch and create a corresponding <code>pixel_mask</code>.",_o,tt,es=`Mask2Former addresses semantic segmentation with a mask classification paradigm, thus input segmentation maps
will be converted to lists of binary masks and their respective labels. Let’s see an example, assuming
<code>segmentation_maps = [[2,6,7,9]]</code>, the output will contain <code>mask_labels = [[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]]</code> (four binary masks) and <code>class_labels = [2,6,7,9]</code>, the labels for
each mask.`,bo,D,je,Mo,ot,ts=`Converts the output of <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a> into semantic segmentation maps. Only supports
PyTorch.`,ko,K,ze,yo,st,os=`Converts the output of <code>Mask2FormerForUniversalSegmentationOutput</code> into instance segmentation predictions.
Only supports PyTorch. If instances could overlap, set either return_coco_annotation or return_binary_maps
to <code>True</code> to get the correct segmentation result.`,wo,ee,Ie,Fo,nt,ss=`Converts the output of <code>Mask2FormerForUniversalSegmentationOutput</code> into image panoptic segmentation
predictions. Only supports PyTorch.`,Ct,Ce,Jt,it,Nt;return k=new B({props:{title:"Mask2Former",local:"mask2former",headingTag:"h1"}}),te=new B({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ie=new B({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),me=new B({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ge=new B({props:{title:"Mask2FormerConfig",local:"transformers.Mask2FormerConfig",headingTag:"h2"}}),he=new N({props:{name:"class transformers.Mask2FormerConfig",anchor:"transformers.Mask2FormerConfig",parameters:[{name:"backbone_config",val:": typing.Optional[typing.Dict] = None"},{name:"feature_size",val:": int = 256"},{name:"mask_feature_size",val:": int = 256"},{name:"hidden_dim",val:": int = 256"},{name:"encoder_feedforward_dim",val:": int = 1024"},{name:"activation_function",val:": str = 'relu'"},{name:"encoder_layers",val:": int = 6"},{name:"decoder_layers",val:": int = 10"},{name:"num_attention_heads",val:": int = 8"},{name:"dropout",val:": float = 0.0"},{name:"dim_feedforward",val:": int = 2048"},{name:"pre_norm",val:": bool = False"},{name:"enforce_input_projection",val:": bool = False"},{name:"common_stride",val:": int = 4"},{name:"ignore_value",val:": int = 255"},{name:"num_queries",val:": int = 100"},{name:"no_object_weight",val:": float = 0.1"},{name:"class_weight",val:": float = 2.0"},{name:"mask_weight",val:": float = 5.0"},{name:"dice_weight",val:": float = 5.0"},{name:"train_num_points",val:": int = 12544"},{name:"oversample_ratio",val:": float = 3.0"},{name:"importance_sample_ratio",val:": float = 0.75"},{name:"init_std",val:": float = 0.02"},{name:"init_xavier_std",val:": float = 1.0"},{name:"use_auxiliary_loss",val:": bool = True"},{name:"feature_strides",val:": typing.List[int] = [4, 8, 16, 32]"},{name:"output_auxiliary_logits",val:": typing.Optional[bool] = None"},{name:"backbone",val:": typing.Optional[str] = None"},{name:"use_pretrained_backbone",val:": bool = False"},{name:"use_timm_backbone",val:": bool = False"},{name:"backbone_kwargs",val:": typing.Optional[typing.Dict] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Mask2FormerConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>, defaults to <code>SwinConfig()</code>) &#x2014;
The configuration of the backbone model. If unset, the configuration corresponding to
<code>swin-base-patch4-window12-384</code> will be used.`,name:"backbone_config"},{anchor:"transformers.Mask2FormerConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.Mask2FormerConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.Mask2FormerConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, <code>False</code>) &#x2014;
Whether to load <code>backbone</code> from the timm library. If <code>False</code>, the backbone is loaded from the transformers
library.`,name:"use_timm_backbone"},{anchor:"transformers.Mask2FormerConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.Mask2FormerConfig.feature_size",description:`<strong>feature_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The features (channels) of the resulting feature maps.`,name:"feature_size"},{anchor:"transformers.Mask2FormerConfig.mask_feature_size",description:`<strong>mask_feature_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The masks&#x2019; features size, this value will also be used to specify the Feature Pyramid Network features&#x2019;
size.`,name:"mask_feature_size"},{anchor:"transformers.Mask2FormerConfig.hidden_dim",description:`<strong>hidden_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the encoder layers.`,name:"hidden_dim"},{anchor:"transformers.Mask2FormerConfig.encoder_feedforward_dim",description:`<strong>encoder_feedforward_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimension of feedforward network for deformable detr encoder used as part of pixel decoder.`,name:"encoder_feedforward_dim"},{anchor:"transformers.Mask2FormerConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of layers in the deformable detr encoder used as part of pixel decoder.`,name:"encoder_layers"},{anchor:"transformers.Mask2FormerConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
Number of layers in the Transformer decoder.`,name:"decoder_layers"},{anchor:"transformers.Mask2FormerConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer.`,name:"num_attention_heads"},{anchor:"transformers.Mask2FormerConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder.`,name:"dropout"},{anchor:"transformers.Mask2FormerConfig.dim_feedforward",description:`<strong>dim_feedforward</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Feature dimension in feedforward network for transformer decoder.`,name:"dim_feedforward"},{anchor:"transformers.Mask2FormerConfig.pre_norm",description:`<strong>pre_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pre-LayerNorm or not for transformer decoder.`,name:"pre_norm"},{anchor:"transformers.Mask2FormerConfig.enforce_input_projection",description:`<strong>enforce_input_projection</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add an input projection 1x1 convolution even if the input channels and hidden dim are identical
in the Transformer decoder.`,name:"enforce_input_projection"},{anchor:"transformers.Mask2FormerConfig.common_stride",description:`<strong>common_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Parameter used for determining number of FPN levels used as part of pixel decoder.`,name:"common_stride"},{anchor:"transformers.Mask2FormerConfig.ignore_value",description:`<strong>ignore_value</strong> (<code>int</code>, <em>optional</em>, defaults to 255) &#x2014;
Category id to be ignored during training.`,name:"ignore_value"},{anchor:"transformers.Mask2FormerConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Number of queries for the decoder.`,name:"num_queries"},{anchor:"transformers.Mask2FormerConfig.no_object_weight",description:`<strong>no_object_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The weight to apply to the null (no object) class.`,name:"no_object_weight"},{anchor:"transformers.Mask2FormerConfig.class_weight",description:`<strong>class_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 2.0) &#x2014;
The weight for the cross entropy loss.`,name:"class_weight"},{anchor:"transformers.Mask2FormerConfig.mask_weight",description:`<strong>mask_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 5.0) &#x2014;
The weight for the mask loss.`,name:"mask_weight"},{anchor:"transformers.Mask2FormerConfig.dice_weight",description:`<strong>dice_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 5.0) &#x2014;
The weight for the dice loss.`,name:"dice_weight"},{anchor:"transformers.Mask2FormerConfig.train_num_points",description:`<strong>train_num_points</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to 12544) &#x2014;
Number of points used for sampling during loss calculation.`,name:"train_num_points"},{anchor:"transformers.Mask2FormerConfig.oversample_ratio",description:`<strong>oversample_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
Oversampling parameter used for calculating no. of sampled points`,name:"oversample_ratio"},{anchor:"transformers.Mask2FormerConfig.importance_sample_ratio",description:`<strong>importance_sample_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 0.75) &#x2014;
Ratio of points that are sampled via importance sampling.`,name:"importance_sample_ratio"},{anchor:"transformers.Mask2FormerConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.Mask2FormerConfig.init_xavier_std",description:`<strong>init_xavier_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The scaling factor used for the Xavier initialization gain in the HM Attention map module.`,name:"init_xavier_std"},{anchor:"transformers.Mask2FormerConfig.use_auxiliary_loss",description:"<strong>use_auxiliary_loss</strong> (<code>boolean``, *optional*, defaults to </code>True<code>) -- If </code>True<code> </code>Mask2FormerForUniversalSegmentationOutput` will contain the auxiliary losses computed using\nthe logits from each decoder&#x2019;s stage.",name:"use_auxiliary_loss"},{anchor:"transformers.Mask2FormerConfig.feature_strides",description:`<strong>feature_strides</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 8, 16, 32]</code>) &#x2014;
Feature strides corresponding to features generated from backbone network.`,name:"feature_strides"},{anchor:"transformers.Mask2FormerConfig.output_auxiliary_logits",description:`<strong>output_auxiliary_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Should the model output its <code>auxiliary_logits</code> or not.`,name:"output_auxiliary_logits"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/configuration_mask2former.py#L28"}}),H=new Xt({props:{anchor:"transformers.Mask2FormerConfig.example",$$slots:{default:[gs]},$$scope:{ctx:C}}}),fe=new N({props:{name:"from_backbone_config",anchor:"transformers.Mask2FormerConfig.from_backbone_config",parameters:[{name:"backbone_config",val:": PretrainedConfig"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Mask2FormerConfig.from_backbone_config.backbone_config",description:`<strong>backbone_config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The backbone configuration.`,name:"backbone_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/configuration_mask2former.py#L239",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerConfig"
>Mask2FormerConfig</a></p>
`}}),ue=new B({props:{title:"MaskFormer specific outputs",local:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput",headingTag:"h2"}}),_e=new N({props:{name:"class transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput",anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput",parameters:[{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pixel_decoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"pixel_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"transformer_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"transformer_decoder_intermediate_states",val:": typing.Tuple[torch.FloatTensor] = None"},{name:"masks_queries_logits",val:": typing.Tuple[torch.FloatTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>, <em>optional</em>) &#x2014;
Last hidden states (final feature map) of the last stage of the encoder model (backbone). Returned when
<code>output_hidden_states=True</code> is passed.`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.`,name:"encoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.pixel_decoder_last_hidden_state",description:`<strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>, <em>optional</em>) &#x2014;
Last hidden states (final feature map) of the last stage of the pixel decoder model.`,name:"pixel_decoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, , <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.transformer_decoder_last_hidden_state",description:`<strong>transformer_decoder_last_hidden_state</strong> (<code>tuple(torch.FloatTensor)</code>) &#x2014;
Final output of the transformer decoder <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"transformer_decoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.transformer_decoder_intermediate_states",description:`<strong>transformer_decoder_intermediate_states</strong> (<code>tuple(torch.FloatTensor)</code> of shape <code>(num_queries, 1, hidden_size)</code>) &#x2014;
Intermediate decoder activations, i.e. the output of each decoder layer, each of them gone through a
layernorm.`,name:"transformer_decoder_intermediate_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.masks_queries_logits",description:`<strong>masks_queries_logits</strong> (<code>tuple(torch.FloatTensor)</code> of shape <code>(batch_size, num_queries, height, width)</code>) &#x2014;
Mask Predictions from each layer in the transformer decoder.`,name:"masks_queries_logits"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self attentions weights from transformer decoder.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/modeling_mask2former.py#L132"}}),be=new N({props:{name:"class transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput",anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"class_queries_logits",val:": typing.Optional[torch.FloatTensor] = None"},{name:"masks_queries_logits",val:": typing.Optional[torch.FloatTensor] = None"},{name:"auxiliary_logits",val:": typing.Optional[typing.List[typing.Dict[str, torch.FloatTensor]]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pixel_decoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"pixel_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"transformer_decoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.loss",description:`<strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
The computed loss, returned when labels are present.`,name:"loss"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.class_queries_logits",description:`<strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.`,name:"class_queries_logits"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.masks_queries_logits",description:`<strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.`,name:"masks_queries_logits"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.auxiliary_logits",description:`<strong>auxiliary_logits</strong> (<code>List[Dict(str, torch.FloatTensor)]</code>, <em>optional</em>) &#x2014;
List of class and mask predictions from each layer of the transformer decoder.`,name:"auxiliary_logits"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the encoder model (backbone).`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.`,name:"encoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.pixel_decoder_last_hidden_state",description:`<strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the pixel decoder model.`,name:"pixel_decoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.transformer_decoder_last_hidden_state",description:`<strong>transformer_decoder_last_hidden_state</strong> (<code>tuple(torch.FloatTensor)</code>) &#x2014;
Final output of the transformer decoder <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"transformer_decoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/modeling_mask2former.py#L178"}}),Me=new B({props:{title:"Mask2FormerModel",local:"transformers.Mask2FormerModel",headingTag:"h2"}}),ke=new N({props:{name:"class transformers.Mask2FormerModel",anchor:"transformers.Mask2FormerModel",parameters:[{name:"config",val:": Mask2FormerConfig"}],parametersDescription:[{anchor:"transformers.Mask2FormerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerConfig">Mask2FormerConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/modeling_mask2former.py#L2164"}}),ye=new N({props:{name:"forward",anchor:"transformers.Mask2FormerModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"pixel_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.Mask2FormerModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.Mask2FormerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Mask2FormerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Mask2FormerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/modeling_mask2former.py#L2175",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/mask2former#transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput"
>transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerConfig"
>Mask2FormerConfig</a>) and inputs.</p>
<ul>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>, <em>optional</em>) — Last hidden states (final feature map) of the last stage of the encoder model (backbone). Returned when
<code>output_hidden_states=True</code> is passed.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.</li>
<li><strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>, <em>optional</em>) — Last hidden states (final feature map) of the last stage of the pixel decoder model.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, , <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.</li>
<li><strong>transformer_decoder_last_hidden_state</strong> (<code>tuple(torch.FloatTensor)</code>) — Final output of the transformer decoder <code>(batch_size, sequence_length, hidden_size)</code>.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.</li>
<li><strong>transformer_decoder_intermediate_states</strong> (<code>tuple(torch.FloatTensor)</code> of shape <code>(num_queries, 1, hidden_size)</code>) — Intermediate decoder activations, i.e. the output of each decoder layer, each of them gone through a
layernorm.</li>
<li><strong>masks_queries_logits</strong> (<code>tuple(torch.FloatTensor)</code> of shape <code>(batch_size, num_queries, height, width)</code>)
Mask Predictions from each layer in the transformer decoder.</li>
<li><strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed) — Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self attentions weights from transformer decoder.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/mask2former#transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput"
>transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),O=new as({props:{$$slots:{default:[hs]},$$scope:{ctx:C}}}),we=new B({props:{title:"Mask2FormerForUniversalSegmentation",local:"transformers.Mask2FormerForUniversalSegmentation",headingTag:"h2"}}),Fe=new N({props:{name:"class transformers.Mask2FormerForUniversalSegmentation",anchor:"transformers.Mask2FormerForUniversalSegmentation",parameters:[{name:"config",val:": Mask2FormerConfig"}],parametersDescription:[{anchor:"transformers.Mask2FormerForUniversalSegmentation.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerConfig">Mask2FormerConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/modeling_mask2former.py#L2235"}}),ve=new N({props:{name:"forward",anchor:"transformers.Mask2FormerForUniversalSegmentation.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"mask_labels",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"class_labels",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"pixel_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_auxiliary_logits",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.mask_labels",description:`<strong>mask_labels</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
List of mask labels of shape <code>(num_labels, height, width)</code> to be fed to a model`,name:"mask_labels"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.class_labels",description:`<strong>class_labels</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
list of target class labels of shape <code>(num_labels, height, width)</code> to be fed to a model. They identify the
labels of <code>mask_labels</code>, e.g. the label of <code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.`,name:"class_labels"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.output_auxiliary_logits",description:`<strong>output_auxiliary_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to output auxiliary logits.`,name:"output_auxiliary_logits"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/modeling_mask2former.py#L2293",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/mask2former#transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput"
>transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerConfig"
>Mask2FormerConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) — The computed loss, returned when labels are present.</li>
<li><strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.</li>
<li><strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.</li>
<li><strong>auxiliary_logits</strong> (<code>List[Dict(str, torch.FloatTensor)]</code>, <em>optional</em>) — List of class and mask predictions from each layer of the transformer decoder.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the encoder model (backbone).</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.</li>
<li><strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the pixel decoder model.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.</li>
<li><strong>transformer_decoder_last_hidden_state</strong> (<code>tuple(torch.FloatTensor)</code>) — Final output of the transformer decoder <code>(batch_size, sequence_length, hidden_size)</code>.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.</li>
<li><strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/mask2former#transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput"
>transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),E=new as({props:{$$slots:{default:[fs]},$$scope:{ctx:C}}}),Y=new Xt({props:{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.example",$$slots:{default:[us]},$$scope:{ctx:C}}}),Q=new Xt({props:{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.example-2",$$slots:{default:[_s]},$$scope:{ctx:C}}}),A=new Xt({props:{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.example-3",$$slots:{default:[bs]},$$scope:{ctx:C}}}),Te=new B({props:{title:"Mask2FormerImageProcessor",local:"transformers.Mask2FormerImageProcessor",headingTag:"h2"}}),xe=new N({props:{name:"class transformers.Mask2FormerImageProcessor",anchor:"transformers.Mask2FormerImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"size_divisor",val:": int = 32"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"num_labels",val:": typing.Optional[int] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the input to a certain <code>size</code>.`,name:"do_resize"},{anchor:"transformers.Mask2FormerImageProcessor.size",description:`<strong>size</strong> (<code>int</code>, <em>optional</em>, defaults to 800) &#x2014;
Resize the input to the given size. Only has an effect if <code>do_resize</code> is set to <code>True</code>. If size is a
sequence like <code>(width, height)</code>, output size will be matched to this. If size is an int, smaller edge of
the image will be matched to this number. i.e, if <code>height &gt; width</code>, then image will be rescaled to <code>(size * height / width, size)</code>.`,name:"size"},{anchor:"transformers.Mask2FormerImageProcessor.size_divisor",description:`<strong>size_divisor</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Some backbones need images divisible by a certain number. If not passed, it defaults to the value used in
Swin Transformer.`,name:"size_divisor"},{anchor:"transformers.Mask2FormerImageProcessor.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
An optional resampling filter. This can be one of <code>PIL.Image.Resampling.NEAREST</code>,
<code>PIL.Image.Resampling.BOX</code>, <code>PIL.Image.Resampling.BILINEAR</code>, <code>PIL.Image.Resampling.HAMMING</code>,
<code>PIL.Image.Resampling.BICUBIC</code> or <code>PIL.Image.Resampling.LANCZOS</code>. Only has an effect if <code>do_resize</code> is set
to <code>True</code>.`,name:"resample"},{anchor:"transformers.Mask2FormerImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the input to a certain <code>scale</code>.`,name:"do_rescale"},{anchor:"transformers.Mask2FormerImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1/ 255</code>) &#x2014;
Rescale the input by the given factor. Only has an effect if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.Mask2FormerImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to normalize the input with mean and standard deviation.`,name:"do_normalize"},{anchor:"transformers.Mask2FormerImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.485, 0.456, 0.406]</code>) &#x2014;
The sequence of means for each channel, to be used when normalizing images. Defaults to the ImageNet mean.`,name:"image_mean"},{anchor:"transformers.Mask2FormerImageProcessor.image_std",description:`<strong>image_std</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.229, 0.224, 0.225]</code>) &#x2014;
The sequence of standard deviations for each channel, to be used when normalizing images. Defaults to the
ImageNet std.`,name:"image_std"},{anchor:"transformers.Mask2FormerImageProcessor.ignore_index",description:`<strong>ignore_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Label to be assigned to background pixels in segmentation maps. If provided, segmentation map pixels
denoted with 0 (background) will be replaced with <code>ignore_index</code>.`,name:"ignore_index"},{anchor:"transformers.Mask2FormerImageProcessor.do_reduce_labels",description:`<strong>do_reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to decrement all label values of segmentation maps by 1. Usually used for datasets where 0
is used for background, and background itself is not included in all classes of a dataset (e.g. ADE20k).
The background label will be replaced by <code>ignore_index</code>.`,name:"do_reduce_labels"},{anchor:"transformers.Mask2FormerImageProcessor.num_labels",description:`<strong>num_labels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of labels in the segmentation map.`,name:"num_labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/image_processing_mask2former.py#L352"}}),Ue=new N({props:{name:"preprocess",anchor:"transformers.Mask2FormerImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor'], NoneType] = None"},{name:"instance_id_to_semantic_id",val:": typing.Optional[typing.Dict[int, int]] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"size_divisor",val:": typing.Optional[int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"do_reduce_labels",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/image_processing_mask2former.py#L678"}}),$e=new N({props:{name:"encode_inputs",anchor:"transformers.Mask2FormerImageProcessor.encode_inputs",parameters:[{name:"pixel_values_list",val:": typing.List[typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']] = None"},{name:"instance_id_to_semantic_id",val:": typing.Union[typing.List[typing.Dict[int, int]], typing.Dict[int, int], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.pixel_values_list",description:`<strong>pixel_values_list</strong> (<code>List[ImageInput]</code>) &#x2014;
List of images (pixel values) to be padded. Each image should be a tensor of shape <code>(channels, height, width)</code>.`,name:"pixel_values_list"},{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.segmentation_maps",description:`<strong>segmentation_maps</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
The corresponding semantic segmentation maps with the pixel-wise annotations.</p>
<p>(<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to pad images up to the largest image in a batch and create a pixel mask.</p>
<p>If left to the default, will return a pixel mask that is:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>`,name:"segmentation_maps"},{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.instance_id_to_semantic_id",description:`<strong>instance_id_to_semantic_id</strong> (<code>List[Dict[int, int]]</code> or <code>Dict[int, int]</code>, <em>optional</em>) &#x2014;
A mapping between object instance ids and class ids. If passed, <code>segmentation_maps</code> is treated as an
instance segmentation map where each pixel represents an instance id. Can be provided as a single
dictionary with a global/dataset-level mapping or as a list of dictionaries (one per image), to map
instance ids in each image separately.`,name:"instance_id_to_semantic_id"},{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of NumPy arrays. If set to <code>&apos;pt&apos;</code>, return PyTorch <code>torch.Tensor</code>
objects.`,name:"return_tensors"},{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/image_processing_mask2former.py#L863",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model.</li>
<li><strong>pixel_mask</strong> — Pixel mask to be fed to a model (when <code>=True</code> or if <code>pixel_mask</code> is in
<code>self.model_input_names</code>).</li>
<li><strong>mask_labels</strong> — Optional list of mask labels of shape <code>(labels, height, width)</code> to be fed to a model
(when <code>annotations</code> are provided).</li>
<li><strong>class_labels</strong> — Optional list of class labels of shape <code>(labels)</code> to be fed to a model (when
<code>annotations</code> are provided). They identify the labels of <code>mask_labels</code>, e.g. the label of
<code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),je=new N({props:{name:"post_process_semantic_segmentation",anchor:"transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.Optional[typing.List[typing.Tuple[int, int]]] = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/image_processing_mask2former.py#L970",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code></p>
`}}),ze=new N({props:{name:"post_process_instance_segmentation",anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": typing.Optional[typing.List[typing.Tuple[int, int]]] = None"},{name:"return_coco_annotation",val:": typing.Optional[bool] = False"},{name:"return_binary_maps",val:": typing.Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned in COCO run-length encoding (RLE) format.`,name:"return_coco_annotation"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.return_binary_maps",description:`<strong>return_binary_maps</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned as a concatenated tensor of binary segmentation maps
(one per detected instance).`,name:"return_binary_maps"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/image_processing_mask2former.py#L1025",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — A tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, or
<code>List[List]</code> run-length encoding (RLE) of the segmentation map if return_coco_annotation is set to
<code>True</code>, or a tensor of shape <code>(num_instances, height, width)</code> if return_binary_maps is set to <code>True</code>.
Set to <code>None</code> if no mask if found above <code>threshold</code>.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — An integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Ie=new N({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": typing.Optional[typing.Set[int]] = None"},{name:"target_sizes",val:": typing.Optional[typing.List[typing.Tuple[int, int]]] = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<code>Mask2FormerForUniversalSegmentationOutput</code>) &#x2014;
The outputs from <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a>.`,name:"outputs"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If left to None, predictions will not be
resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/image_processing_mask2former.py#L1146",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, set
to <code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized
to the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Ce=new ps({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/mask2former.md"}}),{c(){l=m("meta"),w=s(),g=m("p"),c=s(),h(k.$$.fragment),r=s(),y=m("div"),y.innerHTML=vo,lt=s(),h(te.$$.fragment),mt=s(),oe=m("p"),oe.innerHTML=To,dt=s(),se=m("p"),se.textContent=xo,ct=s(),ne=m("p"),ne.innerHTML=Uo,pt=s(),G=m("img"),gt=s(),ae=m("small"),ae.innerHTML=jo,ht=s(),re=m("p"),re.innerHTML=zo,ft=s(),h(ie.$$.fragment),ut=s(),le=m("ul"),le.innerHTML=Io,_t=s(),h(me.$$.fragment),bt=s(),de=m("p"),de.textContent=Co,Mt=s(),ce=m("ul"),ce.innerHTML=Jo,kt=s(),pe=m("p"),pe.textContent=No,yt=s(),h(ge.$$.fragment),wt=s(),x=m("div"),h(he.$$.fragment),Rt=s(),We=m("p"),We.innerHTML=Wo,St=s(),Ze=m("p"),Ze.innerHTML=Zo,Pt=s(),Le=m("p"),Le.innerHTML=Lo,Bt=s(),h(H.$$.fragment),Gt=s(),q=m("div"),h(fe.$$.fragment),Ht=s(),Xe=m("p"),Xe.innerHTML=Xo,Ft=s(),h(ue.$$.fragment),vt=s(),R=m("div"),h(_e.$$.fragment),qt=s(),Ve=m("p"),Ve.innerHTML=Vo,Tt=s(),Z=m("div"),h(be.$$.fragment),Ot=s(),Re=m("p"),Re.innerHTML=Ro,Et=s(),Se=m("p"),Se.innerHTML=So,xt=s(),h(Me.$$.fragment),Ut=s(),j=m("div"),h(ke.$$.fragment),Yt=s(),Pe=m("p"),Pe.textContent=Po,Qt=s(),Be=m("p"),Be.innerHTML=Bo,At=s(),Ge=m("p"),Ge.innerHTML=Go,Dt=s(),L=m("div"),h(ye.$$.fragment),Kt=s(),He=m("p"),He.innerHTML=Ho,eo=s(),h(O.$$.fragment),$t=s(),h(we.$$.fragment),jt=s(),z=m("div"),h(Fe.$$.fragment),to=s(),qe=m("p"),qe.textContent=qo,oo=s(),Oe=m("p"),Oe.innerHTML=Oo,so=s(),Ee=m("p"),Ee.innerHTML=Eo,no=s(),T=m("div"),h(ve.$$.fragment),ao=s(),Ye=m("p"),Ye.innerHTML=Yo,ro=s(),h(E.$$.fragment),io=s(),Qe=m("p"),Qe.textContent=Qo,lo=s(),h(Y.$$.fragment),mo=s(),h(Q.$$.fragment),co=s(),h(A.$$.fragment),zt=s(),h(Te.$$.fragment),It=s(),F=m("div"),h(xe.$$.fragment),po=s(),Ae=m("p"),Ae.textContent=Ao,go=s(),De=m("p"),De.innerHTML=Do,ho=s(),Ke=m("div"),h(Ue.$$.fragment),fo=s(),X=m("div"),h($e.$$.fragment),uo=s(),et=m("p"),et.innerHTML=Ko,_o=s(),tt=m("p"),tt.innerHTML=es,bo=s(),D=m("div"),h(je.$$.fragment),Mo=s(),ot=m("p"),ot.innerHTML=ts,ko=s(),K=m("div"),h(ze.$$.fragment),yo=s(),st=m("p"),st.innerHTML=os,wo=s(),ee=m("div"),h(Ie.$$.fragment),Fo=s(),nt=m("p"),nt.innerHTML=ss,Ct=s(),h(Ce.$$.fragment),Jt=s(),it=m("p"),this.h()},l(e){const o=cs("svelte-u9bgzb",document.head);l=d(o,"META",{name:!0,content:!0}),o.forEach(t),w=n(e),g=d(e,"P",{}),$(g).forEach(t),c=n(e),f(k.$$.fragment,e),r=n(e),y=d(e,"DIV",{class:!0,"data-svelte-h":!0}),p(y)!=="svelte-13t8s2t"&&(y.innerHTML=vo),lt=n(e),f(te.$$.fragment,e),mt=n(e),oe=d(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-vv3e67"&&(oe.innerHTML=To),dt=n(e),se=d(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-vfdo9a"&&(se.textContent=xo),ct=n(e),ne=d(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-12dpxkq"&&(ne.innerHTML=Uo),pt=n(e),G=d(e,"IMG",{src:!0,alt:!0,width:!0}),gt=n(e),ae=d(e,"SMALL",{"data-svelte-h":!0}),p(ae)!=="svelte-1qlm9ke"&&(ae.innerHTML=jo),ht=n(e),re=d(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-12ct8xd"&&(re.innerHTML=zo),ft=n(e),f(ie.$$.fragment,e),ut=n(e),le=d(e,"UL",{"data-svelte-h":!0}),p(le)!=="svelte-192jmvq"&&(le.innerHTML=Io),_t=n(e),f(me.$$.fragment,e),bt=n(e),de=d(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-m0sdby"&&(de.textContent=Co),Mt=n(e),ce=d(e,"UL",{"data-svelte-h":!0}),p(ce)!=="svelte-jric7z"&&(ce.innerHTML=Jo),kt=n(e),pe=d(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1rggs50"&&(pe.textContent=No),yt=n(e),f(ge.$$.fragment,e),wt=n(e),x=d(e,"DIV",{class:!0});var I=$(x);f(he.$$.fragment,I),Rt=n(I),We=d(I,"P",{"data-svelte-h":!0}),p(We)!=="svelte-ib30qi"&&(We.innerHTML=Wo),St=n(I),Ze=d(I,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-o55m63"&&(Ze.innerHTML=Zo),Pt=n(I),Le=d(I,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-938vl7"&&(Le.innerHTML=Lo),Bt=n(I),f(H.$$.fragment,I),Gt=n(I),q=d(I,"DIV",{class:!0});var Je=$(q);f(fe.$$.fragment,Je),Ht=n(Je),Xe=d(Je,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-iwqgdj"&&(Xe.innerHTML=Xo),Je.forEach(t),I.forEach(t),Ft=n(e),f(ue.$$.fragment,e),vt=n(e),R=d(e,"DIV",{class:!0});var Ne=$(R);f(_e.$$.fragment,Ne),qt=n(Ne),Ve=d(Ne,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-11ltned"&&(Ve.innerHTML=Vo),Ne.forEach(t),Tt=n(e),Z=d(e,"DIV",{class:!0});var S=$(Z);f(be.$$.fragment,S),Ot=n(S),Re=d(S,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-1cgna0v"&&(Re.innerHTML=Ro),Et=n(S),Se=d(S,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1ufbz4t"&&(Se.innerHTML=So),S.forEach(t),xt=n(e),f(Me.$$.fragment,e),Ut=n(e),j=d(e,"DIV",{class:!0});var W=$(j);f(ke.$$.fragment,W),Yt=n(W),Pe=d(W,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-14a0e8j"&&(Pe.textContent=Po),Qt=n(W),Be=d(W,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-6pahdo"&&(Be.innerHTML=Bo),At=n(W),Ge=d(W,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-hswkmf"&&(Ge.innerHTML=Go),Dt=n(W),L=d(W,"DIV",{class:!0});var P=$(L);f(ye.$$.fragment,P),Kt=n(P),He=d(P,"P",{"data-svelte-h":!0}),p(He)!=="svelte-1bj7biw"&&(He.innerHTML=Ho),eo=n(P),f(O.$$.fragment,P),P.forEach(t),W.forEach(t),$t=n(e),f(we.$$.fragment,e),jt=n(e),z=d(e,"DIV",{class:!0});var V=$(z);f(Fe.$$.fragment,V),to=n(V),qe=d(V,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-1ovykju"&&(qe.textContent=qo),oo=n(V),Oe=d(V,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-6pahdo"&&(Oe.innerHTML=Oo),so=n(V),Ee=d(V,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-hswkmf"&&(Ee.innerHTML=Eo),no=n(V),T=d(V,"DIV",{class:!0});var J=$(T);f(ve.$$.fragment,J),ao=n(J),Ye=d(J,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-1y2q3l0"&&(Ye.innerHTML=Yo),ro=n(J),f(E.$$.fragment,J),io=n(J),Qe=d(J,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-kvfsh7"&&(Qe.textContent=Qo),lo=n(J),f(Y.$$.fragment,J),mo=n(J),f(Q.$$.fragment,J),co=n(J),f(A.$$.fragment,J),J.forEach(t),V.forEach(t),zt=n(e),f(Te.$$.fragment,e),It=n(e),F=d(e,"DIV",{class:!0});var U=$(F);f(xe.$$.fragment,U),po=n(U),Ae=d(U,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-1te0494"&&(Ae.textContent=Ao),go=n(U),De=d(U,"P",{"data-svelte-h":!0}),p(De)!=="svelte-1o6r6pd"&&(De.innerHTML=Do),ho=n(U),Ke=d(U,"DIV",{class:!0});var ns=$(Ke);f(Ue.$$.fragment,ns),ns.forEach(t),fo=n(U),X=d(U,"DIV",{class:!0});var at=$(X);f($e.$$.fragment,at),uo=n(at),et=d(at,"P",{"data-svelte-h":!0}),p(et)!=="svelte-1tetyua"&&(et.innerHTML=Ko),_o=n(at),tt=d(at,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-1gqhxe4"&&(tt.innerHTML=es),at.forEach(t),bo=n(U),D=d(U,"DIV",{class:!0});var Wt=$(D);f(je.$$.fragment,Wt),Mo=n(Wt),ot=d(Wt,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-h41nf"&&(ot.innerHTML=ts),Wt.forEach(t),ko=n(U),K=d(U,"DIV",{class:!0});var Zt=$(K);f(ze.$$.fragment,Zt),yo=n(Zt),st=d(Zt,"P",{"data-svelte-h":!0}),p(st)!=="svelte-h98l3d"&&(st.innerHTML=os),Zt.forEach(t),wo=n(U),ee=d(U,"DIV",{class:!0});var Lt=$(ee);f(Ie.$$.fragment,Lt),Fo=n(Lt),nt=d(Lt,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-ay0y3u"&&(nt.innerHTML=ss),Lt.forEach(t),U.forEach(t),Ct=n(e),f(Ce.$$.fragment,e),Jt=n(e),it=d(e,"P",{}),$(it).forEach(t),this.h()},h(){v(l,"name","hf:doc:metadata"),v(l,"content",ks),v(y,"class","flex flex-wrap space-x-1"),is(G.src,$o="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/mask2former_architecture.jpg")||v(G,"src",$o),v(G,"alt","drawing"),v(G,"width","600"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){a(document.head,l),i(e,w,o),i(e,g,o),i(e,c,o),u(k,e,o),i(e,r,o),i(e,y,o),i(e,lt,o),u(te,e,o),i(e,mt,o),i(e,oe,o),i(e,dt,o),i(e,se,o),i(e,ct,o),i(e,ne,o),i(e,pt,o),i(e,G,o),i(e,gt,o),i(e,ae,o),i(e,ht,o),i(e,re,o),i(e,ft,o),u(ie,e,o),i(e,ut,o),i(e,le,o),i(e,_t,o),u(me,e,o),i(e,bt,o),i(e,de,o),i(e,Mt,o),i(e,ce,o),i(e,kt,o),i(e,pe,o),i(e,yt,o),u(ge,e,o),i(e,wt,o),i(e,x,o),u(he,x,null),a(x,Rt),a(x,We),a(x,St),a(x,Ze),a(x,Pt),a(x,Le),a(x,Bt),u(H,x,null),a(x,Gt),a(x,q),u(fe,q,null),a(q,Ht),a(q,Xe),i(e,Ft,o),u(ue,e,o),i(e,vt,o),i(e,R,o),u(_e,R,null),a(R,qt),a(R,Ve),i(e,Tt,o),i(e,Z,o),u(be,Z,null),a(Z,Ot),a(Z,Re),a(Z,Et),a(Z,Se),i(e,xt,o),u(Me,e,o),i(e,Ut,o),i(e,j,o),u(ke,j,null),a(j,Yt),a(j,Pe),a(j,Qt),a(j,Be),a(j,At),a(j,Ge),a(j,Dt),a(j,L),u(ye,L,null),a(L,Kt),a(L,He),a(L,eo),u(O,L,null),i(e,$t,o),u(we,e,o),i(e,jt,o),i(e,z,o),u(Fe,z,null),a(z,to),a(z,qe),a(z,oo),a(z,Oe),a(z,so),a(z,Ee),a(z,no),a(z,T),u(ve,T,null),a(T,ao),a(T,Ye),a(T,ro),u(E,T,null),a(T,io),a(T,Qe),a(T,lo),u(Y,T,null),a(T,mo),u(Q,T,null),a(T,co),u(A,T,null),i(e,zt,o),u(Te,e,o),i(e,It,o),i(e,F,o),u(xe,F,null),a(F,po),a(F,Ae),a(F,go),a(F,De),a(F,ho),a(F,Ke),u(Ue,Ke,null),a(F,fo),a(F,X),u($e,X,null),a(X,uo),a(X,et),a(X,_o),a(X,tt),a(F,bo),a(F,D),u(je,D,null),a(D,Mo),a(D,ot),a(F,ko),a(F,K),u(ze,K,null),a(K,yo),a(K,st),a(F,wo),a(F,ee),u(Ie,ee,null),a(ee,Fo),a(ee,nt),i(e,Ct,o),u(Ce,e,o),i(e,Jt,o),i(e,it,o),Nt=!0},p(e,[o]){const I={};o&2&&(I.$$scope={dirty:o,ctx:e}),H.$set(I);const Je={};o&2&&(Je.$$scope={dirty:o,ctx:e}),O.$set(Je);const Ne={};o&2&&(Ne.$$scope={dirty:o,ctx:e}),E.$set(Ne);const S={};o&2&&(S.$$scope={dirty:o,ctx:e}),Y.$set(S);const W={};o&2&&(W.$$scope={dirty:o,ctx:e}),Q.$set(W);const P={};o&2&&(P.$$scope={dirty:o,ctx:e}),A.$set(P)},i(e){Nt||(_(k.$$.fragment,e),_(te.$$.fragment,e),_(ie.$$.fragment,e),_(me.$$.fragment,e),_(ge.$$.fragment,e),_(he.$$.fragment,e),_(H.$$.fragment,e),_(fe.$$.fragment,e),_(ue.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),_(Me.$$.fragment,e),_(ke.$$.fragment,e),_(ye.$$.fragment,e),_(O.$$.fragment,e),_(we.$$.fragment,e),_(Fe.$$.fragment,e),_(ve.$$.fragment,e),_(E.$$.fragment,e),_(Y.$$.fragment,e),_(Q.$$.fragment,e),_(A.$$.fragment,e),_(Te.$$.fragment,e),_(xe.$$.fragment,e),_(Ue.$$.fragment,e),_($e.$$.fragment,e),_(je.$$.fragment,e),_(ze.$$.fragment,e),_(Ie.$$.fragment,e),_(Ce.$$.fragment,e),Nt=!0)},o(e){b(k.$$.fragment,e),b(te.$$.fragment,e),b(ie.$$.fragment,e),b(me.$$.fragment,e),b(ge.$$.fragment,e),b(he.$$.fragment,e),b(H.$$.fragment,e),b(fe.$$.fragment,e),b(ue.$$.fragment,e),b(_e.$$.fragment,e),b(be.$$.fragment,e),b(Me.$$.fragment,e),b(ke.$$.fragment,e),b(ye.$$.fragment,e),b(O.$$.fragment,e),b(we.$$.fragment,e),b(Fe.$$.fragment,e),b(ve.$$.fragment,e),b(E.$$.fragment,e),b(Y.$$.fragment,e),b(Q.$$.fragment,e),b(A.$$.fragment,e),b(Te.$$.fragment,e),b(xe.$$.fragment,e),b(Ue.$$.fragment,e),b($e.$$.fragment,e),b(je.$$.fragment,e),b(ze.$$.fragment,e),b(Ie.$$.fragment,e),b(Ce.$$.fragment,e),Nt=!1},d(e){e&&(t(w),t(g),t(c),t(r),t(y),t(lt),t(mt),t(oe),t(dt),t(se),t(ct),t(ne),t(pt),t(G),t(gt),t(ae),t(ht),t(re),t(ft),t(ut),t(le),t(_t),t(bt),t(de),t(Mt),t(ce),t(kt),t(pe),t(yt),t(wt),t(x),t(Ft),t(vt),t(R),t(Tt),t(Z),t(xt),t(Ut),t(j),t($t),t(jt),t(z),t(zt),t(It),t(F),t(Ct),t(Jt),t(it)),t(l),M(k,e),M(te,e),M(ie,e),M(me,e),M(ge,e),M(he),M(H),M(fe),M(ue,e),M(_e),M(be),M(Me,e),M(ke),M(ye),M(O),M(we,e),M(Fe),M(ve),M(E),M(Y),M(Q),M(A),M(Te,e),M(xe),M(Ue),M($e),M(je),M(ze),M(Ie),M(Ce,e)}}}const ks='{"title":"Mask2Former","local":"mask2former","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"Mask2FormerConfig","local":"transformers.Mask2FormerConfig","sections":[],"depth":2},{"title":"MaskFormer specific outputs","local":"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput","sections":[],"depth":2},{"title":"Mask2FormerModel","local":"transformers.Mask2FormerModel","sections":[],"depth":2},{"title":"Mask2FormerForUniversalSegmentation","local":"transformers.Mask2FormerForUniversalSegmentation","sections":[],"depth":2},{"title":"Mask2FormerImageProcessor","local":"transformers.Mask2FormerImageProcessor","sections":[],"depth":2}],"depth":1}';function ys(C){return ls(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zs extends ms{constructor(l){super(),ds(this,l,ys,Ms,rs,{})}}export{zs as component};
