import{s as Lo,o as Zo,n as $e}from"../chunks/scheduler.18a86fab.js";import{S as Po,i as Ro,g as h,s as a,r as g,A as Eo,h as p,f as s,c as r,j as J,u as _,x as m,k as N,y as c,a as i,v as y,d as b,t as v,w as T}from"../chunks/index.98837b22.js";import{T as fo}from"../chunks/Tip.77304350.js";import{D as he}from"../chunks/Docstring.6758ea23.js";import{C as _o}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as go}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as xe}from"../chunks/Heading.7e7e0c5b.js";import{E as So}from"../chunks/index.92f616ba.js";function Vo(C){let n,M="Example:",l,d,u;return d=new _o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1vb25zaGluZU1vZGVsJTJDJTIwTW9vbnNoaW5lQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME1vb25zaGluZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBNb29uc2hpbmVDb25maWcoKS5mcm9tX3ByZXRyYWluZWQoJTIyVXNlZnVsU2Vuc29ycyUyRm1vb25zaGluZS10aW55JTIyKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBNb29uc2hpbmVNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MoonshineModel, MoonshineConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Moonshine style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MoonshineConfig().from_pretrained(<span class="hljs-string">&quot;UsefulSensors/moonshine-tiny&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoonshineModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=h("p"),n.textContent=M,l=a(),g(d.$$.fragment)},l(o){n=p(o,"P",{"data-svelte-h":!0}),m(n)!=="svelte-11lpom8"&&(n.textContent=M),l=r(o),_(d.$$.fragment,o)},m(o,f){i(o,n,f),i(o,l,f),y(d,o,f),u=!0},p:$e,i(o){u||(b(d.$$.fragment,o),u=!0)},o(o){v(d.$$.fragment,o),u=!1},d(o){o&&(s(n),s(l)),T(d,o)}}}function Ho(C){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=h("p"),n.innerHTML=M},l(l){n=p(l,"P",{"data-svelte-h":!0}),m(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(l,d){i(l,n,d)},p:$e,d(l){l&&s(n)}}}function Oo(C){let n,M="Example:",l,d,u;return d=new _o({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBNb29uc2hpbmVNb2RlbCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQW1vZGVsJTIwJTNEJTIwTW9vbnNoaW5lTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMlVzZWZ1bFNlbnNvcnMlMkZtb29uc2hpbmUtdGlueSUyMiklMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJVc2VmdWxTZW5zb3JzJTJGbW9vbnNoaW5lLXRpbnklMjIpJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWlucHV0cyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKGRzJTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWlucHV0X3ZhbHVlcyUyMCUzRCUyMGlucHV0cy5pbnB1dF92YWx1ZXMlMEFkZWNvZGVyX2lucHV0X2lkcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIlNUIxJTJDJTIwMSU1RCU1RCklMjAqJTIwbW9kZWwuY29uZmlnLmRlY29kZXJfc3RhcnRfdG9rZW5faWQlMEFsYXN0X2hpZGRlbl9zdGF0ZSUyMCUzRCUyMG1vZGVsKGlucHV0X3ZhbHVlcyUyQyUyMGRlY29kZXJfaW5wdXRfaWRzJTNEZGVjb2Rlcl9pbnB1dF9pZHMpLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZS5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, MoonshineModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoonshineModel.from_pretrained(<span class="hljs-string">&quot;UsefulSensors/moonshine-tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;UsefulSensors/moonshine-tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = inputs.input_values
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = torch.tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>]]) * model.config.decoder_start_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = model(input_values, decoder_input_ids=decoder_input_ids).last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_state.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">288</span>]`,wrap:!1}}),{c(){n=h("p"),n.textContent=M,l=a(),g(d.$$.fragment)},l(o){n=p(o,"P",{"data-svelte-h":!0}),m(n)!=="svelte-11lpom8"&&(n.textContent=M),l=r(o),_(d.$$.fragment,o)},m(o,f){i(o,n,f),i(o,l,f),y(d,o,f),u=!0},p:$e,i(o){u||(b(d.$$.fragment,o),u=!0)},o(o){v(d.$$.fragment,o),u=!1},d(o){o&&(s(n),s(l)),T(d,o)}}}function Xo(C){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=h("p"),n.innerHTML=M},l(l){n=p(l,"P",{"data-svelte-h":!0}),m(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(l,d){i(l,n,d)},p:$e,d(l){l&&s(n)}}}function Ao(C){let n,M="Example:",l,d,u;return d=new _o({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyME1vb25zaGluZUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMlVzZWZ1bFNlbnNvcnMlMkZtb29uc2hpbmUtdGlueSUyMiklMEFtb2RlbCUyMCUzRCUyME1vb25zaGluZUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyVXNlZnVsU2Vuc29ycyUyRm1vb25zaGluZS10aW55JTIyKSUwQSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfdmFsdWVzJTIwJTNEJTIwaW5wdXRzLmlucHV0X3ZhbHVlcyUwQSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dF92YWx1ZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCklMEElMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQXRyYW5zY3JpcHRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MoonshineForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;UsefulSensors/moonshine-tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoonshineForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;UsefulSensors/moonshine-tiny&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = inputs.input_values

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(input_values, max_new_tokens=<span class="hljs-number">100</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription
<span class="hljs-string">&#x27;Mr. Quilter is the apostle of the middle classes, and we are glad to welcome his gospel.&#x27;</span>`,wrap:!1}}),{c(){n=h("p"),n.textContent=M,l=a(),g(d.$$.fragment)},l(o){n=p(o,"P",{"data-svelte-h":!0}),m(n)!=="svelte-11lpom8"&&(n.textContent=M),l=r(o),_(d.$$.fragment,o)},m(o,f){i(o,n,f),i(o,l,f),y(d,o,f),u=!0},p:$e,i(o){u||(b(d.$$.fragment,o),u=!0)},o(o){v(d.$$.fragment,o),u=!1},d(o){o&&(s(n),s(l)),T(d,o)}}}function Do(C){let n,M=`Most generation-controlling parameters are set in <code>generation_config</code> which, if not passed, will be set to the
model’s default generation configuration. You can override any <code>generation_config</code> by passing the corresponding
parameters to generate(), e.g. <code>.generate(inputs, num_beams=4, do_sample=True)</code>.`,l,d,u=`For an overview of generation strategies and code examples, check out the <a href="../generation_strategies">following
guide</a>.`;return{c(){n=h("p"),n.innerHTML=M,l=a(),d=h("p"),d.innerHTML=u},l(o){n=p(o,"P",{"data-svelte-h":!0}),m(n)!=="svelte-1c5u34l"&&(n.innerHTML=M),l=r(o),d=p(o,"P",{"data-svelte-h":!0}),m(d)!=="svelte-fvlq1g"&&(d.innerHTML=u)},m(o,f){i(o,n,f),i(o,l,f),i(o,d,f)},p:$e,d(o){o&&(s(n),s(l),s(d))}}}function Bo(C){let n,M,l,d,u,o,f,yo='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',ze,V,Fe,H,bo='The Moonshine model was proposed in <a href="https://arxiv.org/abs/2410.15608" rel="nofollow">Moonshine: Speech Recognition for Live Transcription and Voice Commands</a> by Nat Jeffries, Evan King, Manjunath Kudlur, Guy Nicholson, James Wang, Pete Warden.',Ge,O,vo="The abstract from the paper is the following:",Ue,X,To="<em>This paper introduces Moonshine, a family of speech recognition models optimized for live transcription and voice command processing. Moonshine is based on an encoder-decoder transformer architecture and employs Rotary Position Embedding (RoPE) instead of traditional absolute position embeddings. The model is trained on speech segments of various lengths, but without using zero-padding, leading to greater efficiency for the encoder during inference time. When benchmarked against OpenAI’s Whisper tiny-en, Moonshine Tiny demonstrates a 5x reduction in compute requirements for transcribing a 10-second speech segment while incurring no increase in word error rates across standard evaluation datasets. These results highlight Moonshine’s potential for real-time and resource-constrained applications.</em>",qe,A,Mo="Tips:",je,D,wo="<li>Moonshine improves upon Whisper’s architecture:<ol><li>It uses SwiGLU activation instead of GELU in the decoder layers</li> <li>Most importantly, it replaces absolute position embeddings with Rotary Position Embeddings (RoPE). This allows Moonshine to handle audio inputs of any length, unlike Whisper which is restricted to fixed 30-second windows.</li></ol></li>",Ie,B,ko=`This model was contributed by <a href="https://huggingface.co/eustlb" rel="nofollow">Eustache Le Bihan (eustlb)</a>.
The original code can be found <a href="https://github.com/usefulsensors/moonshine" rel="nofollow">here</a>.`,Ne,Q,Je,Y,xo='<li><a href="../tasks/asr">Automatic speech recognition task guide</a></li>',We,K,Le,z,ee,Oe,pe,$o=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineModel">MoonshineModel</a>. It is used to instantiate a Moonshine
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the Moonshine
<a href="https://huggingface.co/UsefulSensors/moonshine-tiny" rel="nofollow">UsefulSensors/moonshine-tiny</a>.`,Xe,me,Co=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ae,W,Ze,oe,Pe,w,ne,De,ue,zo="The bare Moonshine Model outputting raw hidden-states without any specific head on top.",Be,fe,Fo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Qe,ge,Go=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ye,F,te,Ke,_e,Uo='The <a href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineModel">MoonshineModel</a> forward method, overrides the <code>__call__</code> special method.',eo,L,oo,Z,no,P,se,to,ye,qo=`Masks extracted features along time axis and/or along feature axis according to
<a href="https://arxiv.org/abs/1904.08779" rel="nofollow">SpecAugment</a>.`,Re,ae,Ee,k,re,so,be,jo="The Moonshine Model with a language modeling head. Can be used for automatic speech recognition.",ao,ve,Io=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ro,Te,No=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,io,G,ie,co,Me,Jo='The <a href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineForConditionalGeneration">MoonshineForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',lo,R,ho,E,po,I,de,mo,we,Wo="Generates sequences of token ids for models with a language modeling head.",uo,S,Se,ce,Ve,Ce,He;return u=new xe({props:{title:"Moonshine",local:"moonshine",headingTag:"h1"}}),V=new xe({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Q=new xe({props:{title:"Resources",local:"resources",headingTag:"h2"}}),K=new xe({props:{title:"MoonshineConfig",local:"transformers.MoonshineConfig",headingTag:"h2"}}),ee=new he({props:{name:"class transformers.MoonshineConfig",anchor:"transformers.MoonshineConfig",parameters:[{name:"vocab_size",val:" = 32768"},{name:"hidden_size",val:" = 288"},{name:"intermediate_size",val:" = 1152"},{name:"encoder_num_hidden_layers",val:" = 6"},{name:"decoder_num_hidden_layers",val:" = 6"},{name:"encoder_num_attention_heads",val:" = 8"},{name:"decoder_num_attention_heads",val:" = 8"},{name:"encoder_num_key_value_heads",val:" = None"},{name:"decoder_num_key_value_heads",val:" = None"},{name:"pad_head_dim_to_multiple_of",val:" = None"},{name:"encoder_hidden_act",val:" = 'gelu'"},{name:"decoder_hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 512"},{name:"initializer_range",val:" = 0.02"},{name:"decoder_start_token_id",val:" = 1"},{name:"use_cache",val:" = True"},{name:"rope_theta",val:" = 10000.0"},{name:"rope_scaling",val:" = None"},{name:"partial_rotary_factor",val:" = 0.9"},{name:"is_encoder_decoder",val:" = True"},{name:"attention_bias",val:" = False"},{name:"attention_dropout",val:" = 0.0"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MoonshineConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32768) &#x2014;
Vocabulary size of the Moonshine model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineModel">MoonshineModel</a>.`,name:"vocab_size"},{anchor:"transformers.MoonshineConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 288) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.MoonshineConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1152) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.MoonshineConfig.encoder_num_hidden_layers",description:`<strong>encoder_num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"encoder_num_hidden_layers"},{anchor:"transformers.MoonshineConfig.decoder_num_hidden_layers",description:`<strong>decoder_num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"decoder_num_hidden_layers"},{anchor:"transformers.MoonshineConfig.encoder_num_attention_heads",description:`<strong>encoder_num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"encoder_num_attention_heads"},{anchor:"transformers.MoonshineConfig.decoder_num_attention_heads",description:`<strong>decoder_num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_num_attention_heads"},{anchor:"transformers.MoonshineConfig.encoder_num_key_value_heads",description:`<strong>encoder_num_key_value_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>encoder_num_key_value_heads=encoder_num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>encoder_num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to
<code>num_attention_heads</code>.`,name:"encoder_num_key_value_heads"},{anchor:"transformers.MoonshineConfig.decoder_num_key_value_heads",description:`<strong>decoder_num_key_value_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>decoder_num_key_value_heads=decoder_num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>decoder_num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to
<code>decoder_num_attention_heads</code>.`,name:"decoder_num_key_value_heads"},{anchor:"transformers.MoonshineConfig.pad_head_dim_to_multiple_of",description:`<strong>pad_head_dim_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Pad head dimension in encoder and decoder to the next multiple of this value. Necessary for using certain
optimized attention implementations.`,name:"pad_head_dim_to_multiple_of"},{anchor:"transformers.MoonshineConfig.encoder_hidden_act",description:`<strong>encoder_hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder.`,name:"encoder_hidden_act"},{anchor:"transformers.MoonshineConfig.decoder_hidden_act",description:`<strong>decoder_hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"decoder_hidden_act"},{anchor:"transformers.MoonshineConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sequence length that this model might ever be used with.`,name:"max_position_embeddings"},{anchor:"transformers.MoonshineConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.MoonshineConfig.decoder_start_token_id",description:`<strong>decoder_start_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Corresponds to the &#x201D;&lt;|startoftranscript|&gt;&#x201D; token, which is automatically used when no <code>decoder_input_ids</code>
are provided to the <code>generate</code> function. It is used to guide the model\`s generation process depending on
the task.`,name:"decoder_start_token_id"},{anchor:"transformers.MoonshineConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"},{anchor:"transformers.MoonshineConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.MoonshineConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. NOTE: if you apply new rope type
and you expect the model to work on longer <code>max_position_embeddings</code>, we recommend you to update this value
accordingly.
Expected contents:
<code>rope_type</code> (<code>str</code>):
The sub-variant of RoPE to use. Can be one of [&#x2018;default&#x2019;, &#x2018;linear&#x2019;, &#x2018;dynamic&#x2019;, &#x2018;yarn&#x2019;, &#x2018;longrope&#x2019;,
&#x2018;llama3&#x2019;], with &#x2018;default&#x2019; being the original RoPE implementation.
<code>factor</code> (<code>float</code>, <em>optional</em>):
Used with all rope types except &#x2018;default&#x2019;. The scaling factor to apply to the RoPE embeddings. In
most scaling types, a <code>factor</code> of x will enable the model to handle sequences of length x <em>
original maximum pre-trained length.
<code>original_max_position_embeddings</code> (<code>int</code>, </em>optional<em>):
Used with &#x2018;dynamic&#x2019;, &#x2018;longrope&#x2019; and &#x2018;llama3&#x2019;. The original max position embeddings used during
pretraining.
<code>attention_factor</code> (<code>float</code>, </em>optional<em>):
Used with &#x2018;yarn&#x2019; and &#x2018;longrope&#x2019;. The scaling factor to be applied on the attention
computation. If unspecified, it defaults to value recommended by the implementation, using the
<code>factor</code> field to infer the suggested value.
<code>beta_fast</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for extrapolation (only) in the linear
ramp function. If unspecified, it defaults to 32.
<code>beta_slow</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for interpolation (only) in the linear
ramp function. If unspecified, it defaults to 1.
<code>short_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to short contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>long_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to long contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>low_freq_factor</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to low frequency components of the RoPE
<code>high_freq_factor</code> (<code>float</code>, </em>optional*):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to high frequency components of the RoPE`,name:"rope_scaling"},{anchor:"transformers.MoonshineConfig.partial_rotary_factor",description:`<strong>partial_rotary_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.9) &#x2014;
Percentage of the query and keys which will have rotary embedding.`,name:"partial_rotary_factor"},{anchor:"transformers.MoonshineConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the model is used as an encoder/decoder or not.`,name:"is_encoder_decoder"},{anchor:"transformers.MoonshineConfig.attention_bias",description:`<strong>attention_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in the query, key, value and output projection layers during self-attention.`,name:"attention_bias"},{anchor:"transformers.MoonshineConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.MoonshineConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Denotes beginning of sequences token id.`,name:"bos_token_id"},{anchor:"transformers.MoonshineConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Denotes end of sequences token id.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moonshine/configuration_moonshine.py#L25"}}),W=new go({props:{anchor:"transformers.MoonshineConfig.example",$$slots:{default:[Vo]},$$scope:{ctx:C}}}),oe=new xe({props:{title:"MoonshineModel",local:"transformers.MoonshineModel",headingTag:"h2"}}),ne=new he({props:{name:"class transformers.MoonshineModel",anchor:"transformers.MoonshineModel",parameters:[{name:"config",val:": MoonshineConfig"}],parametersDescription:[{anchor:"transformers.MoonshineModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineConfig">MoonshineConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moonshine/modeling_moonshine.py#L1072"}}),te=new he({props:{name:"forward",anchor:"transformers.MoonshineModel.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.EncoderDecoderCache, typing.Tuple[torch.FloatTensor], NoneType] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_position_ids",val:": typing.Optional[typing.Tuple[torch.LongTensor]] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.MoonshineModel.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, audio_length)</code>) &#x2014;
Float values of the raw speech waveform. Raw speech waveform can be
obtained by loading a <code>.flac</code> or <code>.wav</code> audio file into an array of type <code>List[float]</code> or a
<code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into
<code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoFeatureExtractor">AutoFeatureExtractor</a> should be used for padding
and conversion into a tensor of type <code>torch.FloatTensor</code>.`,name:"input_values"},{anchor:"transformers.MoonshineModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MoonshineModel.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"decoder_input_ids"},{anchor:"transformers.MoonshineModel.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_attention_mask"},{anchor:"transformers.MoonshineModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.MoonshineModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Union[~cache_utils.EncoderDecoderCache, Tuple[torch.FloatTensor], NoneType]</code>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MoonshineModel.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>Tuple[torch.FloatTensor]</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>decoder_input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MoonshineModel.forward.decoder_position_ids",description:`<strong>decoder_position_ids</strong> (<code>Tuple[torch.LongTensor]</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"decoder_position_ids"},{anchor:"transformers.MoonshineModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MoonshineModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MoonshineModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MoonshineModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moonshine/modeling_moonshine.py#L1144",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqModelOutput"
>transformers.modeling_outputs.Seq2SeqModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineConfig"
>MoonshineConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>EncoderDecoderCache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.EncoderDecoderCache"
>EncoderDecoderCache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqModelOutput"
>transformers.modeling_outputs.Seq2SeqModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),L=new fo({props:{$$slots:{default:[Ho]},$$scope:{ctx:C}}}),Z=new go({props:{anchor:"transformers.MoonshineModel.forward.example",$$slots:{default:[Oo]},$$scope:{ctx:C}}}),se=new he({props:{name:"_mask_input_features",anchor:"transformers.MoonshineModel._mask_input_features",parameters:[{name:"input_features",val:": FloatTensor"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moonshine/modeling_moonshine.py#L1101"}}),ae=new xe({props:{title:"MoonshineForConditionalGeneration",local:"transformers.MoonshineForConditionalGeneration",headingTag:"h2"}}),re=new he({props:{name:"class transformers.MoonshineForConditionalGeneration",anchor:"transformers.MoonshineForConditionalGeneration",parameters:[{name:"config",val:": MoonshineConfig"}],parametersDescription:[{anchor:"transformers.MoonshineForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineConfig">MoonshineConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moonshine/modeling_moonshine.py#L1288"}}),ie=new he({props:{name:"forward",anchor:"transformers.MoonshineForConditionalGeneration.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.EncoderDecoderCache, typing.Tuple[torch.FloatTensor], NoneType] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_position_ids",val:": typing.Optional[typing.Tuple[torch.LongTensor]] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.MoonshineForConditionalGeneration.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, audio_length)</code>) &#x2014;
Float values of the raw speech waveform. Raw speech waveform can be
obtained by loading a <code>.flac</code> or <code>.wav</code> audio file into an array of type <code>List[float]</code> or a
<code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into
<code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoFeatureExtractor">AutoFeatureExtractor</a> should be used for padding
and conversion into a tensor of type <code>torch.FloatTensor</code>.`,name:"input_values"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"decoder_input_ids"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_attention_mask"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Union[~cache_utils.EncoderDecoderCache, Tuple[torch.FloatTensor], NoneType]</code>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>Tuple[torch.FloatTensor]</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>decoder_input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.decoder_position_ids",description:`<strong>decoder_position_ids</strong> (<code>Tuple[torch.LongTensor]</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"decoder_position_ids"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code>
or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored (masked), the loss is
only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moonshine/modeling_moonshine.py#L1319",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineConfig"
>MoonshineConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>EncoderDecoderCache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.EncoderDecoderCache"
>EncoderDecoderCache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),R=new fo({props:{$$slots:{default:[Xo]},$$scope:{ctx:C}}}),E=new go({props:{anchor:"transformers.MoonshineForConditionalGeneration.forward.example",$$slots:{default:[Ao]},$$scope:{ctx:C}}}),de=new he({props:{name:"generate",anchor:"transformers.MoonshineForConditionalGeneration.generate",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"prefix_allowed_tokens_fn",val:": typing.Optional[typing.Callable[[int, torch.Tensor], typing.List[int]]] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = None"},{name:"assistant_model",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"streamer",val:": typing.Optional[ForwardRef('BaseStreamer')] = None"},{name:"negative_prompt_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"use_model_defaults",val:": typing.Optional[bool] = None"},{name:"custom_generate",val:": typing.Optional[str] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MoonshineForConditionalGeneration.generate.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should be in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.MoonshineForConditionalGeneration.generate.generation_config",description:`<strong>generation_config</strong> (<a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which has the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.MoonshineForConditionalGeneration.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.MoonshineForConditionalGeneration.generate.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
Custom stopping criteria that complements the default stopping criteria built from arguments and a
generation config. If a stopping criteria is passed that is already created with the arguments or a
generation config an error is thrown. If your stopping criteria depends on the <code>scores</code> input, make
sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>. This feature is
intended for advanced users.`,name:"stopping_criteria"},{anchor:"transformers.MoonshineForConditionalGeneration.generate.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>, <em>optional</em>) &#x2014;
If provided, this function constraints the beam search to allowed tokens only at each step. If not
provided no constraint is applied. This function takes 2 arguments: the batch ID <code>batch_id</code> and
<code>input_ids</code>. It has to return a list with the allowed tokens for the next generation step conditioned
on the batch ID <code>batch_id</code> and the previously generated tokens <code>inputs_ids</code>. This argument is useful
for constrained generation conditioned on the prefix, as described in <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity
Retrieval</a>.`,name:"prefix_allowed_tokens_fn"},{anchor:"transformers.MoonshineForConditionalGeneration.generate.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to continue running the while loop until max_length. Unless overridden, this flag will be set
to <code>True</code> if using <code>FullyShardedDataParallel</code> or DeepSpeed ZeRO Stage 3 with multiple GPUs to avoid
deadlocking if one GPU finishes generating before other GPUs. Otherwise, defaults to <code>False</code>.`,name:"synced_gpus"},{anchor:"transformers.MoonshineForConditionalGeneration.generate.assistant_model",description:`<strong>assistant_model</strong> (<code>PreTrainedModel</code>, <em>optional</em>) &#x2014;
An assistant model that can be used to accelerate generation. The assistant model must have the exact
same tokenizer. The acceleration is achieved when forecasting candidate tokens with the assistant model
is much faster than running generation with the model you&#x2019;re calling generate from. As such, the
assistant model should be much smaller.`,name:"assistant_model"},{anchor:"transformers.MoonshineForConditionalGeneration.generate.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.`,name:"streamer"},{anchor:"transformers.MoonshineForConditionalGeneration.generate.negative_prompt_ids",description:`<strong>negative_prompt_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
The negative prompt needed for some processors such as CFG. The batch size must match the input batch
size. This is an experimental feature, subject to breaking API changes in future versions.`,name:"negative_prompt_ids"},{anchor:"transformers.MoonshineForConditionalGeneration.generate.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention_mask for <code>negative_prompt_ids</code>.`,name:"negative_prompt_attention_mask"},{anchor:"transformers.MoonshineForConditionalGeneration.generate.use_model_defaults",description:`<strong>use_model_defaults</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
When it is <code>True</code>, unset parameters in <code>generation_config</code> will be set to the model-specific default
generation configuration (<code>model.generation_config</code>), as opposed to the global defaults
(<code>GenerationConfig()</code>). If unset, models saved starting from <code>v4.50</code> will consider this flag to be
<code>True</code>.`,name:"use_model_defaults"},{anchor:"transformers.MoonshineForConditionalGeneration.generate.custom_generate",description:`<strong>custom_generate</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string containing the name of a huggingface.co repository. If provided, the custom <code>generate</code>
function defined in that reposity&#x2019;s <code>custom_generate/generate.py</code> file will be executed instead of the
standard <code>generate</code> method. Note that the logic is for generation is entirely defined in that
repository, and the return type may be different from the standard <code>generate</code> method.`,name:"custom_generate"},{anchor:"transformers.MoonshineForConditionalGeneration.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generation_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L2225",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code>
or when <code>config.return_dict_in_generate=True</code>) or a <code>torch.LongTensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateDecoderOnlyOutput"
>GenerateDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateBeamDecoderOnlyOutput"
>GenerateBeamDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateEncoderDecoderOutput"
>GenerateEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateBeamEncoderDecoderOutput"
>GenerateBeamEncoderDecoderOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>torch.LongTensor</code></p>
`}}),S=new fo({props:{warning:!0,$$slots:{default:[Do]},$$scope:{ctx:C}}}),ce=new So({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/moonshine.md"}}),{c(){n=h("meta"),M=a(),l=h("p"),d=a(),g(u.$$.fragment),o=a(),f=h("div"),f.innerHTML=yo,ze=a(),g(V.$$.fragment),Fe=a(),H=h("p"),H.innerHTML=bo,Ge=a(),O=h("p"),O.textContent=vo,Ue=a(),X=h("p"),X.innerHTML=To,qe=a(),A=h("p"),A.textContent=Mo,je=a(),D=h("ul"),D.innerHTML=wo,Ie=a(),B=h("p"),B.innerHTML=ko,Ne=a(),g(Q.$$.fragment),Je=a(),Y=h("ul"),Y.innerHTML=xo,We=a(),g(K.$$.fragment),Le=a(),z=h("div"),g(ee.$$.fragment),Oe=a(),pe=h("p"),pe.innerHTML=$o,Xe=a(),me=h("p"),me.innerHTML=Co,Ae=a(),g(W.$$.fragment),Ze=a(),g(oe.$$.fragment),Pe=a(),w=h("div"),g(ne.$$.fragment),De=a(),ue=h("p"),ue.textContent=zo,Be=a(),fe=h("p"),fe.innerHTML=Fo,Qe=a(),ge=h("p"),ge.innerHTML=Go,Ye=a(),F=h("div"),g(te.$$.fragment),Ke=a(),_e=h("p"),_e.innerHTML=Uo,eo=a(),g(L.$$.fragment),oo=a(),g(Z.$$.fragment),no=a(),P=h("div"),g(se.$$.fragment),to=a(),ye=h("p"),ye.innerHTML=qo,Re=a(),g(ae.$$.fragment),Ee=a(),k=h("div"),g(re.$$.fragment),so=a(),be=h("p"),be.textContent=jo,ao=a(),ve=h("p"),ve.innerHTML=Io,ro=a(),Te=h("p"),Te.innerHTML=No,io=a(),G=h("div"),g(ie.$$.fragment),co=a(),Me=h("p"),Me.innerHTML=Jo,lo=a(),g(R.$$.fragment),ho=a(),g(E.$$.fragment),po=a(),I=h("div"),g(de.$$.fragment),mo=a(),we=h("p"),we.textContent=Wo,uo=a(),g(S.$$.fragment),Se=a(),g(ce.$$.fragment),Ve=a(),Ce=h("p"),this.h()},l(e){const t=Eo("svelte-u9bgzb",document.head);n=p(t,"META",{name:!0,content:!0}),t.forEach(s),M=r(e),l=p(e,"P",{}),J(l).forEach(s),d=r(e),_(u.$$.fragment,e),o=r(e),f=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(f)!=="svelte-b95w5j"&&(f.innerHTML=yo),ze=r(e),_(V.$$.fragment,e),Fe=r(e),H=p(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-102gja4"&&(H.innerHTML=bo),Ge=r(e),O=p(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-vfdo9a"&&(O.textContent=vo),Ue=r(e),X=p(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-hjmi0f"&&(X.innerHTML=To),qe=r(e),A=p(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-axv494"&&(A.textContent=Mo),je=r(e),D=p(e,"UL",{"data-svelte-h":!0}),m(D)!=="svelte-701nga"&&(D.innerHTML=wo),Ie=r(e),B=p(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-py8twc"&&(B.innerHTML=ko),Ne=r(e),_(Q.$$.fragment,e),Je=r(e),Y=p(e,"UL",{"data-svelte-h":!0}),m(Y)!=="svelte-c521vh"&&(Y.innerHTML=xo),We=r(e),_(K.$$.fragment,e),Le=r(e),z=p(e,"DIV",{class:!0});var U=J(z);_(ee.$$.fragment,U),Oe=r(U),pe=p(U,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-hx4u80"&&(pe.innerHTML=$o),Xe=r(U),me=p(U,"P",{"data-svelte-h":!0}),m(me)!=="svelte-o55m63"&&(me.innerHTML=Co),Ae=r(U),_(W.$$.fragment,U),U.forEach(s),Ze=r(e),_(oe.$$.fragment,e),Pe=r(e),w=p(e,"DIV",{class:!0});var x=J(w);_(ne.$$.fragment,x),De=r(x),ue=p(x,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-1609zgi"&&(ue.textContent=zo),Be=r(x),fe=p(x,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-6pahdo"&&(fe.innerHTML=Fo),Qe=r(x),ge=p(x,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-hswkmf"&&(ge.innerHTML=Go),Ye=r(x),F=p(x,"DIV",{class:!0});var q=J(F);_(te.$$.fragment,q),Ke=r(q),_e=p(q,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-1vn92r5"&&(_e.innerHTML=Uo),eo=r(q),_(L.$$.fragment,q),oo=r(q),_(Z.$$.fragment,q),q.forEach(s),no=r(x),P=p(x,"DIV",{class:!0});var le=J(P);_(se.$$.fragment,le),to=r(le),ye=p(le,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-1iyovru"&&(ye.innerHTML=qo),le.forEach(s),x.forEach(s),Re=r(e),_(ae.$$.fragment,e),Ee=r(e),k=p(e,"DIV",{class:!0});var $=J(k);_(re.$$.fragment,$),so=r($),be=p($,"P",{"data-svelte-h":!0}),m(be)!=="svelte-1lctgbj"&&(be.textContent=jo),ao=r($),ve=p($,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-6pahdo"&&(ve.innerHTML=Io),ro=r($),Te=p($,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-hswkmf"&&(Te.innerHTML=No),io=r($),G=p($,"DIV",{class:!0});var j=J(G);_(ie.$$.fragment,j),co=r(j),Me=p(j,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-n5grur"&&(Me.innerHTML=Jo),lo=r(j),_(R.$$.fragment,j),ho=r(j),_(E.$$.fragment,j),j.forEach(s),po=r($),I=p($,"DIV",{class:!0});var ke=J(I);_(de.$$.fragment,ke),mo=r(ke),we=p(ke,"P",{"data-svelte-h":!0}),m(we)!=="svelte-s5ko3x"&&(we.textContent=Wo),uo=r(ke),_(S.$$.fragment,ke),ke.forEach(s),$.forEach(s),Se=r(e),_(ce.$$.fragment,e),Ve=r(e),Ce=p(e,"P",{}),J(Ce).forEach(s),this.h()},h(){N(n,"name","hf:doc:metadata"),N(n,"content",Qo),N(f,"class","flex flex-wrap space-x-1"),N(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){c(document.head,n),i(e,M,t),i(e,l,t),i(e,d,t),y(u,e,t),i(e,o,t),i(e,f,t),i(e,ze,t),y(V,e,t),i(e,Fe,t),i(e,H,t),i(e,Ge,t),i(e,O,t),i(e,Ue,t),i(e,X,t),i(e,qe,t),i(e,A,t),i(e,je,t),i(e,D,t),i(e,Ie,t),i(e,B,t),i(e,Ne,t),y(Q,e,t),i(e,Je,t),i(e,Y,t),i(e,We,t),y(K,e,t),i(e,Le,t),i(e,z,t),y(ee,z,null),c(z,Oe),c(z,pe),c(z,Xe),c(z,me),c(z,Ae),y(W,z,null),i(e,Ze,t),y(oe,e,t),i(e,Pe,t),i(e,w,t),y(ne,w,null),c(w,De),c(w,ue),c(w,Be),c(w,fe),c(w,Qe),c(w,ge),c(w,Ye),c(w,F),y(te,F,null),c(F,Ke),c(F,_e),c(F,eo),y(L,F,null),c(F,oo),y(Z,F,null),c(w,no),c(w,P),y(se,P,null),c(P,to),c(P,ye),i(e,Re,t),y(ae,e,t),i(e,Ee,t),i(e,k,t),y(re,k,null),c(k,so),c(k,be),c(k,ao),c(k,ve),c(k,ro),c(k,Te),c(k,io),c(k,G),y(ie,G,null),c(G,co),c(G,Me),c(G,lo),y(R,G,null),c(G,ho),y(E,G,null),c(k,po),c(k,I),y(de,I,null),c(I,mo),c(I,we),c(I,uo),y(S,I,null),i(e,Se,t),y(ce,e,t),i(e,Ve,t),i(e,Ce,t),He=!0},p(e,[t]){const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),W.$set(U);const x={};t&2&&(x.$$scope={dirty:t,ctx:e}),L.$set(x);const q={};t&2&&(q.$$scope={dirty:t,ctx:e}),Z.$set(q);const le={};t&2&&(le.$$scope={dirty:t,ctx:e}),R.$set(le);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),E.$set($);const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),S.$set(j)},i(e){He||(b(u.$$.fragment,e),b(V.$$.fragment,e),b(Q.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(W.$$.fragment,e),b(oe.$$.fragment,e),b(ne.$$.fragment,e),b(te.$$.fragment,e),b(L.$$.fragment,e),b(Z.$$.fragment,e),b(se.$$.fragment,e),b(ae.$$.fragment,e),b(re.$$.fragment,e),b(ie.$$.fragment,e),b(R.$$.fragment,e),b(E.$$.fragment,e),b(de.$$.fragment,e),b(S.$$.fragment,e),b(ce.$$.fragment,e),He=!0)},o(e){v(u.$$.fragment,e),v(V.$$.fragment,e),v(Q.$$.fragment,e),v(K.$$.fragment,e),v(ee.$$.fragment,e),v(W.$$.fragment,e),v(oe.$$.fragment,e),v(ne.$$.fragment,e),v(te.$$.fragment,e),v(L.$$.fragment,e),v(Z.$$.fragment,e),v(se.$$.fragment,e),v(ae.$$.fragment,e),v(re.$$.fragment,e),v(ie.$$.fragment,e),v(R.$$.fragment,e),v(E.$$.fragment,e),v(de.$$.fragment,e),v(S.$$.fragment,e),v(ce.$$.fragment,e),He=!1},d(e){e&&(s(M),s(l),s(d),s(o),s(f),s(ze),s(Fe),s(H),s(Ge),s(O),s(Ue),s(X),s(qe),s(A),s(je),s(D),s(Ie),s(B),s(Ne),s(Je),s(Y),s(We),s(Le),s(z),s(Ze),s(Pe),s(w),s(Re),s(Ee),s(k),s(Se),s(Ve),s(Ce)),s(n),T(u,e),T(V,e),T(Q,e),T(K,e),T(ee),T(W),T(oe,e),T(ne),T(te),T(L),T(Z),T(se),T(ae,e),T(re),T(ie),T(R),T(E),T(de),T(S),T(ce,e)}}}const Qo='{"title":"Moonshine","local":"moonshine","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"MoonshineConfig","local":"transformers.MoonshineConfig","sections":[],"depth":2},{"title":"MoonshineModel","local":"transformers.MoonshineModel","sections":[],"depth":2},{"title":"MoonshineForConditionalGeneration","local":"transformers.MoonshineForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Yo(C){return Zo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dn extends Po{constructor(n){super(),Ro(this,n,Yo,Bo,Lo,{})}}export{dn as component};
