import{s as bs,o as ys,n as zt}from"../chunks/scheduler.18a86fab.js";import{S as Ts,i as vs,g as r,s,r as p,A as ws,h as i,f as n,c as a,j as G,u,x as c,k as $,y as l,a as o,v as h,d as g,t as f,w as _}from"../chunks/index.98837b22.js";import{T as wo}from"../chunks/Tip.77304350.js";import{D as N}from"../chunks/Docstring.6758ea23.js";import{C as W}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as ko}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as U}from"../chunks/Heading.7e7e0c5b.js";import{E as ks}from"../chunks/index.92f616ba.js";function js(Z){let d,y="Example:",M,b,T;return b=new W({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBNdXNpY2dlbkNvbmZpZyUyQyUwQSUyMCUyMCUyMCUyME11c2ljZ2VuRGVjb2RlckNvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMFQ1Q29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwRW5jb2RlY0NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTBBKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMHRleHQlMjBlbmNvZGVyJTJDJTIwYXVkaW8lMjBlbmNvZGVyJTJDJTIwYW5kJTIwZGVjb2RlciUyMG1vZGVsJTIwY29uZmlndXJhdGlvbnMlMEF0ZXh0X2VuY29kZXJfY29uZmlnJTIwJTNEJTIwVDVDb25maWcoKSUwQWF1ZGlvX2VuY29kZXJfY29uZmlnJTIwJTNEJTIwRW5jb2RlY0NvbmZpZygpJTBBZGVjb2Rlcl9jb25maWclMjAlM0QlMjBNdXNpY2dlbkRlY29kZXJDb25maWcoKSUwQSUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBNdXNpY2dlbkNvbmZpZy5mcm9tX3N1Yl9tb2RlbHNfY29uZmlnKCUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl9jb25maWclMkMlMjBhdWRpb19lbmNvZGVyX2NvbmZpZyUyQyUyMGRlY29kZXJfY29uZmlnJTBBKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwTXVzaWNnZW5Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmlnJTBBY29uZmlnX3RleHRfZW5jb2RlciUyMCUzRCUyMG1vZGVsLmNvbmZpZy50ZXh0X2VuY29kZXIlMEFjb25maWdfYXVkaW9fZW5jb2RlciUyMCUzRCUyMG1vZGVsLmNvbmZpZy5hdWRpb19lbmNvZGVyJTBBY29uZmlnX2RlY29kZXIlMjAlM0QlMjBtb2RlbC5jb25maWcuZGVjb2RlciUwQSUwQSUyMyUyMFNhdmluZyUyMHRoZSUyMG1vZGVsJTJDJTIwaW5jbHVkaW5nJTIwaXRzJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJtdXNpY2dlbi1tb2RlbCUyMiklMEElMEElMjMlMjBsb2FkaW5nJTIwbW9kZWwlMjBhbmQlMjBjb25maWclMjBmcm9tJTIwcHJldHJhaW5lZCUyMGZvbGRlciUwQW11c2ljZ2VuX2NvbmZpZyUyMCUzRCUyME11c2ljZ2VuQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJtdXNpY2dlbi1tb2RlbCUyMiklMEFtb2RlbCUyMCUzRCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtdXNpY2dlbi1tb2RlbCUyMiUyQyUyMGNvbmZpZyUzRG11c2ljZ2VuX2NvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    MusicgenConfig,
<span class="hljs-meta">... </span>    MusicgenDecoderConfig,
<span class="hljs-meta">... </span>    T5Config,
<span class="hljs-meta">... </span>    EncodecConfig,
<span class="hljs-meta">... </span>    MusicgenForConditionalGeneration,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing text encoder, audio encoder, and decoder model configurations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder_config = T5Config()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_encoder_config = EncodecConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_config = MusicgenDecoderConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MusicgenConfig.from_sub_models_config(
<span class="hljs-meta">... </span>    text_encoder_config, audio_encoder_config, decoder_config
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a MusicgenForConditionalGeneration (with random weights) from the facebook/musicgen-small style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config
<span class="hljs-meta">&gt;&gt;&gt; </span>config_text_encoder = model.config.text_encoder
<span class="hljs-meta">&gt;&gt;&gt; </span>config_audio_encoder = model.config.audio_encoder
<span class="hljs-meta">&gt;&gt;&gt; </span>config_decoder = model.config.decoder

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Saving the model, including its configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;musicgen-model&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># loading model and config from pretrained folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>musicgen_config = MusicgenConfig.from_pretrained(<span class="hljs-string">&quot;musicgen-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;musicgen-model&quot;</span>, config=musicgen_config)`,wrap:!1}}),{c(){d=r("p"),d.textContent=y,M=s(),p(b.$$.fragment)},l(m){d=i(m,"P",{"data-svelte-h":!0}),c(d)!=="svelte-11lpom8"&&(d.textContent=y),M=a(m),u(b.$$.fragment,m)},m(m,v){o(m,d,v),o(m,M,v),h(b,m,v),T=!0},p:zt,i(m){T||(g(b.$$.fragment,m),T=!0)},o(m){f(b.$$.fragment,m),T=!1},d(m){m&&(n(d),n(M)),_(b,m)}}}function Cs(Z){let d,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=r("p"),d.innerHTML=y},l(M){d=i(M,"P",{"data-svelte-h":!0}),c(d)!=="svelte-fincs2"&&(d.innerHTML=y)},m(M,b){o(M,d,b)},p:zt,d(M){M&&n(d)}}}function Js(Z){let d,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=r("p"),d.innerHTML=y},l(M){d=i(M,"P",{"data-svelte-h":!0}),c(d)!=="svelte-fincs2"&&(d.innerHTML=y)},m(M,b){o(M,d,b)},p:zt,d(M){M&&n(d)}}}function $s(Z){let d,y="Example:",M,b,T;return b=new W({props:{code:"",highlighted:"",wrap:!1}}),{c(){d=r("p"),d.textContent=y,M=s(),p(b.$$.fragment)},l(m){d=i(m,"P",{"data-svelte-h":!0}),c(d)!=="svelte-11lpom8"&&(d.textContent=y),M=a(m),u(b.$$.fragment,m)},m(m,v){o(m,d,v),o(m,M,v),h(b,m,v),T=!0},p:zt,i(m){T||(g(b.$$.fragment,m),T=!0)},o(m){f(b.$$.fragment,m),T=!1},d(m){m&&(n(d),n(M)),_(b,m)}}}function Us(Z){let d,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=r("p"),d.innerHTML=y},l(M){d=i(M,"P",{"data-svelte-h":!0}),c(d)!=="svelte-fincs2"&&(d.innerHTML=y)},m(M,b){o(M,d,b)},p:zt,d(M){M&&n(d)}}}function Zs(Z){let d,y="Examples:",M,b,T;return b=new W({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEFtb2RlbCUyMCUzRCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm11c2ljZ2VuLXNtYWxsJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTVCJTIyODBzJTIwcG9wJTIwdHJhY2slMjB3aXRoJTIwYmFzc3klMjBkcnVtcyUyMGFuZCUyMHN5bnRoJTIyJTJDJTIwJTIyOTBzJTIwcm9jayUyMHNvbmclMjB3aXRoJTIwbG91ZCUyMGd1aXRhcnMlMjBhbmQlMjBoZWF2eSUyMGRydW1zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTBBKSUwQSUwQXBhZF90b2tlbl9pZCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRpb25fY29uZmlnLnBhZF90b2tlbl9pZCUwQWRlY29kZXJfaW5wdXRfaWRzJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm9uZXMoKGlucHV0cy5pbnB1dF9pZHMuc2hhcGUlNUIwJTVEJTIwKiUyMG1vZGVsLmRlY29kZXIubnVtX2NvZGVib29rcyUyQyUyMDEpJTJDJTIwZHR5cGUlM0R0b3JjaC5sb25nKSUwQSUyMCUyMCUyMCUyMColMjBwYWRfdG9rZW5faWQlMEEpJTBBJTBBbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBkZWNvZGVyX2lucHV0X2lkcyUzRGRlY29kZXJfaW5wdXRfaWRzKS5sb2dpdHMlMEFsb2dpdHMuc2hhcGUlMjAlMjAlMjMlMjAoYnN6JTIwKiUyMG51bV9jb2RlYm9va3MlMkMlMjB0Z3RfbGVuJTJDJTIwdm9jYWJfc2l6ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pad_token_id = model.generation_config.pad_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = (
<span class="hljs-meta">... </span>    torch.ones((inputs.input_ids.shape[<span class="hljs-number">0</span>] * model.decoder.num_codebooks, <span class="hljs-number">1</span>), dtype=torch.long)
<span class="hljs-meta">... </span>    * pad_token_id
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs, decoder_input_ids=decoder_input_ids).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>logits.shape  <span class="hljs-comment"># (bsz * num_codebooks, tgt_len, vocab_size)</span>
torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2048</span>])`,wrap:!1}}),{c(){d=r("p"),d.textContent=y,M=s(),p(b.$$.fragment)},l(m){d=i(m,"P",{"data-svelte-h":!0}),c(d)!=="svelte-kvfsh7"&&(d.textContent=y),M=a(m),u(b.$$.fragment,m)},m(m,v){o(m,d,v),o(m,M,v),h(b,m,v),T=!0},p:zt,i(m){T||(g(b.$$.fragment,m),T=!0)},o(m){f(b.$$.fragment,m),T=!1},d(m){m&&(n(d),n(M)),_(b,m)}}}function Gs(Z){let d,y,M,b,T,m,v,jo='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Nt,te,Xt,ne,Co=`The MusicGen model was proposed in the paper <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">Simple and Controllable Music Generation</a>
by Jade Copet, Felix Kreuk, Itai Gat, Tal Remez, David Kant, Gabriel Synnaeve, Yossi Adi and Alexandre Défossez.`,Bt,oe,Jo=`MusicGen is a single stage auto-regressive Transformer model capable of generating high-quality music samples conditioned
on text descriptions or audio prompts. The text descriptions are passed through a frozen text encoder model to obtain a
sequence of hidden-state representations. MusicGen is then trained to predict discrete audio tokens, or <em>audio codes</em>,
conditioned on these hidden-states. These audio tokens are then decoded using an audio compression model, such as EnCodec,
to recover the audio waveform.`,Rt,se,$o=`Through an efficient token interleaving pattern, MusicGen does not require a self-supervised semantic representation of
the text/audio prompts, thus eliminating the need to cascade multiple models to predict a set of codebooks (e.g.
hierarchically or upsampling). Instead, it is able to generate all the codebooks in a single forward pass.`,qt,ae,Uo="The abstract from the paper is the following:",Vt,re,Zo=`<em>We tackle the task of conditional music generation. We introduce MusicGen, a single Language Model (LM) that operates
over several streams of compressed discrete music representation, i.e., tokens. Unlike prior work, MusicGen is comprised
of a single-stage transformer LM together with efficient token interleaving patterns, which eliminates the need for
cascading several models, e.g., hierarchically or upsampling. Following this approach, we demonstrate how MusicGen
can generate high-quality samples, while being conditioned on textual description or melodic features, allowing better
controls over the generated output. We conduct extensive empirical evaluation, considering both automatic and human
studies, showing the proposed approach is superior to the evaluated baselines on a standard text-to-music benchmark.
Through ablation studies, we shed light over the importance of each of the components comprising MusicGen.</em>`,Et,ie,Go=`This model was contributed by <a href="https://huggingface.co/sanchit-gandhi" rel="nofollow">sanchit-gandhi</a>. The original code can be found
<a href="https://github.com/facebookresearch/audiocraft" rel="nofollow">here</a>. The pre-trained checkpoints can be found on the
<a href="https://huggingface.co/models?sort=downloads&amp;search=facebook%2Fmusicgen-" rel="nofollow">Hugging Face Hub</a>.`,Yt,le,Ht,de,xo=`<li>After downloading the original checkpoints from <a href="https://github.com/facebookresearch/audiocraft/blob/main/docs/MUSICGEN.md#importing--exporting-models" rel="nofollow">here</a> , you can convert them using the <strong>conversion script</strong> available at
<code>src/transformers/models/musicgen/convert_musicgen_transformers.py</code> with the following command:</li>`,Lt,ce,Pt,me,Fo=`<p>[!NOTE]
The <code>head_mask</code> argument is ignored when using all attention implementation other than “eager”. If you have a <code>head_mask</code> and want it to have effect, load the model with <code>XXXModel.from_pretrained(model_id, attn_implementation=&quot;eager&quot;)</code></p>`,Qt,pe,St,ue,Wo=`MusicGen is compatible with two generation modes: greedy and sampling. In practice, sampling leads to significantly
better results than greedy, thus we encourage sampling mode to be used where possible. Sampling is enabled by default,
and can be explicitly specified by setting <code>do_sample=True</code> in the call to <code>MusicgenForConditionalGeneration.generate()</code>,
or by overriding the model’s generation config (see below).`,Dt,he,zo=`Generation is limited by the sinusoidal positional embeddings to 30 second inputs. Meaning, MusicGen cannot generate more
than 30 seconds of audio (1503 tokens), and input audio passed by Audio-Prompted Generation contributes to this limit so,
given an input of 20 seconds of audio, MusicGen cannot generate more than 10 seconds of additional audio.`,At,ge,Io=`Transformers supports both mono (1-channel) and stereo (2-channel) variants of MusicGen. The mono channel versions
generate a single set of codebooks. The stereo versions generate 2 sets of codebooks, 1 for each channel (left/right),
and each set of codebooks is decoded independently through the audio compression model. The audio streams for each
channel are combined to give the final stereo output.`,Ot,fe,Kt,_e,No=`The inputs for unconditional (or ‘null’) generation can be obtained through the method
<code>MusicgenForConditionalGeneration.get_unconditional_inputs()</code>:`,en,Me,tn,be,Xo=`The audio outputs are a three-dimensional Torch tensor of shape <code>(batch_size, num_channels, sequence_length)</code>. To listen
to the generated audio samples, you can either play them in an ipynb notebook:`,nn,ye,on,Te,Bo="Or save them as a <code>.wav</code> file using a third-party library, e.g. <code>scipy</code>:",sn,ve,an,we,rn,ke,Ro=`The model can generate an audio sample conditioned on a text prompt through use of the <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenProcessor">MusicgenProcessor</a> to pre-process
the inputs:`,ln,je,dn,Ce,qo=`The <code>guidance_scale</code> is used in classifier free guidance (CFG), setting the weighting between the conditional logits
(which are predicted from the text prompts) and the unconditional logits (which are predicted from an unconditional or
‘null’ prompt). Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer audio quality. CFG is enabled by setting <code>guidance_scale &gt; 1</code>. For best results,
use <code>guidance_scale=3</code> (default).`,cn,Je,mn,$e,Vo=`The same <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenProcessor">MusicgenProcessor</a> can be used to pre-process an audio prompt that is used for audio continuation. In the
following example, we load an audio file using the 🤗 Datasets library, which can be pip installed through the command
below:`,pn,Ue,un,Ze,hn,Ge,Eo=`For batched audio-prompted generation, the generated <code>audio_values</code> can be post-processed to remove padding by using the
<a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenProcessor">MusicgenProcessor</a> class:`,gn,xe,fn,Fe,_n,We,Yo=`The default parameters that control the generation process, such as sampling, guidance scale and number of generated
tokens, can be found in the model’s generation config, and updated as desired:`,Mn,ze,bn,Ie,Ho=`Note that any arguments passed to the generate method will <strong>supersede</strong> those in the generation config, so setting
<code>do_sample=False</code> in the call to generate will supersede the setting of <code>model.generation_config.do_sample</code> in the
generation config.`,yn,Ne,Tn,Xe,Lo="The MusicGen model can be de-composed into three distinct stages:",vn,Be,Po="<li>Text encoder: maps the text inputs to a sequence of hidden-state representations. The pre-trained MusicGen models use a frozen text encoder from either T5 or Flan-T5</li> <li>MusicGen decoder: a language model (LM) that auto-regressively generates audio tokens (or codes) conditional on the encoder hidden-state representations</li> <li>Audio encoder/decoder: used to encode an audio prompt to use as prompt tokens, and recover the audio waveform from the audio tokens predicted by the decoder</li>",wn,Re,Qo=`Thus, the MusicGen model can either be used as a standalone decoder model, corresponding to the class <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenForCausalLM">MusicgenForCausalLM</a>,
or as a composite model that includes the text encoder and audio encoder/decoder, corresponding to the class
<a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenForConditionalGeneration">MusicgenForConditionalGeneration</a>. If only the decoder needs to be loaded from the pre-trained checkpoint, it can be loaded by first
specifying the correct config, or be accessed through the <code>.decoder</code> attribute of the composite model:`,kn,qe,jn,Ve,So=`Since the text encoder and audio encoder/decoder models are frozen during training, the MusicGen decoder <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenForCausalLM">MusicgenForCausalLM</a>
can be trained standalone on a dataset of encoder hidden-states and audio codes. For inference, the trained decoder can
be combined with the frozen text encoder and audio encoder/decoders to recover the composite <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenForConditionalGeneration">MusicgenForConditionalGeneration</a>
model.`,Cn,Ee,Do="Tips:",Jn,Ye,Ao="<li>MusicGen is trained on the 32kHz checkpoint of Encodec. You should ensure you use a compatible version of the Encodec model.</li> <li>Sampling mode tends to deliver better results than greedy - you can toggle sampling with the variable <code>do_sample</code> in the call to <code>MusicgenForConditionalGeneration.generate()</code></li>",$n,He,Un,X,Le,En,ut,Oo=`This is the configuration class to store the configuration of an <code>MusicgenDecoder</code>. It is used to instantiate a
MusicGen decoder according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the MusicGen
<a href="https://huggingface.co/facebook/musicgen-small" rel="nofollow">facebook/musicgen-small</a> architecture.`,Yn,ht,Ko=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Zn,Pe,Gn,w,Qe,Hn,gt,es=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenModel">MusicgenModel</a>. It is used to instantiate a
MusicGen model according to the specified arguments, defining the text encoder, audio encoder and MusicGen decoder
configs.`,Ln,ft,ts=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Pn,Y,Qn,H,Se,Sn,_t,ns=`Instantiate a <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenConfig">MusicgenConfig</a> (or a derived class) from text encoder, audio encoder and decoder
configurations.`,xn,De,Fn,k,Ae,Dn,Mt,os=`Constructs a MusicGen processor which wraps an EnCodec feature extractor and a T5 tokenizer into a single processor
class.`,An,bt,ss=`<a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenProcessor">MusicgenProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecFeatureExtractor">EncodecFeatureExtractor</a> and <code>TTokenizer</code>. See
<code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenProcessor.decode">decode()</a> for more information.`,On,L,Oe,Kn,yt,as=`This method is used to decode either batches of audio outputs from the MusicGen model, or batches of token ids
from the tokenizer. In the case of decoding token ids, this method forwards all its arguments to T5Tokenizer’s
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please refer to the docstring of this method for more information.`,eo,P,Ke,to,Tt,rs=`This method forwards all its arguments to T5Tokenizer’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to the
docstring of this method for more information.`,Wn,et,zn,j,tt,no,vt,is="The bare Musicgen Model outputting raw hidden-states without any specific head on top.",oo,wt,ls=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,so,kt,ds=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ao,B,nt,ro,jt,cs='The <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenModel">MusicgenModel</a> forward method, overrides the <code>__call__</code> special method.',io,Q,In,ot,Nn,C,st,lo,Ct,ms="The MusicGen decoder model with a language modelling head on top.",co,Jt,ps=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,mo,$t,us=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,po,z,at,uo,Ut,hs='The <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenForCausalLM">MusicgenForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',ho,S,go,D,Xn,rt,Bn,J,it,fo,Zt,gs="The composite MusicGen model with a text encoder, audio encoder and Musicgen decoder,",_o,Gt,fs=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Mo,xt,_s=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,bo,I,lt,yo,Ft,Ms='The <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenForConditionalGeneration">MusicgenForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',To,A,vo,O,Rn,dt,qn,It,Vn;return T=new U({props:{title:"MusicGen",local:"musicgen",headingTag:"h1"}}),te=new U({props:{title:"Overview",local:"overview",headingTag:"h2"}}),le=new U({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),ce=new W({props:{code:"cHl0aG9uJTIwc3JjJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGbXVzaWNnZW4lMkZjb252ZXJ0X211c2ljZ2VuX3RyYW5zZm9ybWVycy5weSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY2hlY2twb2ludCUyMHNtYWxsJTIwLS1weXRvcmNoX2R1bXBfZm9sZGVyJTIwJTJGb3V0cHV0JTJGcGF0aCUyMC0tc2FmZV9zZXJpYWxpemF0aW9uJTIw",highlighted:`python src/transformers/models/musicgen/convert_musicgen_transformers.py \\
    --checkpoint small --pytorch_dump_folder /output/path --safe_serialization `,wrap:!1}}),pe=new U({props:{title:"Generation",local:"generation",headingTag:"h2"}}),fe=new U({props:{title:"Unconditional Generation",local:"unconditional-generation",headingTag:"h3"}}),Me=new W({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEF1bmNvbmRpdGlvbmFsX2lucHV0cyUyMCUzRCUyMG1vZGVsLmdldF91bmNvbmRpdGlvbmFsX2lucHV0cyhudW1fc2FtcGxlcyUzRDEpJTBBJTBBYXVkaW9fdmFsdWVzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKip1bmNvbmRpdGlvbmFsX2lucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>unconditional_inputs = model.get_unconditional_inputs(num_samples=<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**unconditional_inputs, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),ye=new W({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMG1vZGVsLmNvbmZpZy5hdWRpb19lbmNvZGVyLnNhbXBsaW5nX3JhdGUlMEFBdWRpbyhhdWRpb192YWx1ZXMlNUIwJTVELm51bXB5KCklMkMlMjByYXRlJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

sampling_rate = model.config.audio_encoder.sampling_rate
Audio(audio_values[<span class="hljs-number">0</span>].numpy(), rate=sampling_rate)`,wrap:!1}}),ve=new W({props:{code:"aW1wb3J0JTIwc2NpcHklMEElMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwbW9kZWwuY29uZmlnLmF1ZGlvX2VuY29kZXIuc2FtcGxpbmdfcmF0ZSUwQXNjaXB5LmlvLndhdmZpbGUud3JpdGUoJTIybXVzaWNnZW5fb3V0LndhdiUyMiUyQyUyMHJhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwZGF0YSUzRGF1ZGlvX3ZhbHVlcyU1QjAlMkMlMjAwJTVELm51bXB5KCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> scipy

<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = model.config.audio_encoder.sampling_rate
<span class="hljs-meta">&gt;&gt;&gt; </span>scipy.io.wavfile.write(<span class="hljs-string">&quot;musicgen_out.wav&quot;</span>, rate=sampling_rate, data=audio_values[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>].numpy())`,wrap:!1}}),we=new U({props:{title:"Text-Conditional Generation",local:"text-conditional-generation",headingTag:"h3"}}),je=new W({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMjgwcyUyMHBvcCUyMHRyYWNrJTIwd2l0aCUyMGJhc3N5JTIwZHJ1bXMlMjBhbmQlMjBzeW50aCUyMiUyQyUyMCUyMjkwcyUyMHJvY2slMjBzb25nJTIwd2l0aCUyMGxvdWQlMjBndWl0YXJzJTIwYW5kJTIwaGVhdnklMjBkcnVtcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSklMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),Je=new U({props:{title:"Audio-Prompted Generation",local:"audio-prompted-generation",headingTag:"h3"}}),Ue=new W({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMHBpcCUwQXBpcCUyMGluc3RhbGwlMjBkYXRhc2V0cyU1QmF1ZGlvJTVE",highlighted:`pip install --upgrade pip
pip install datasets[audio]`,wrap:!1}}),Ze=new W({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnNhbmNoaXQtZ2FuZGhpJTJGZ3R6YW4lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFzYW1wbGUlMjAlM0QlMjBuZXh0KGl0ZXIoZGF0YXNldCkpJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjMlMjB0YWtlJTIwdGhlJTIwZmlyc3QlMjBoYWxmJTIwb2YlMjB0aGUlMjBhdWRpbyUyMHNhbXBsZSUwQXNhbXBsZSU1QiUyMmFycmF5JTIyJTVEJTIwJTNEJTIwc2FtcGxlJTVCJTIyYXJyYXklMjIlNUQlNUIlM0ElMjBsZW4oc2FtcGxlJTVCJTIyYXJyYXklMjIlNUQpJTIwJTJGJTJGJTIwMiU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjBhdWRpbyUzRHNhbXBsZSU1QiUyMmFycmF5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsZSU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTVCJTIyODBzJTIwYmx1ZXMlMjB0cmFjayUyMHdpdGglMjBncm9vdnklMjBzYXhvcGhvbmUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMEEpJTBBYXVkaW9fdmFsdWVzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyNTYp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;sanchit-gandhi/gtzan&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))[<span class="hljs-string">&quot;audio&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># take the first half of the audio sample</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sample[<span class="hljs-string">&quot;array&quot;</span>] = sample[<span class="hljs-string">&quot;array&quot;</span>][: <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;array&quot;</span>]) // <span class="hljs-number">2</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    audio=sample[<span class="hljs-string">&quot;array&quot;</span>],
<span class="hljs-meta">... </span>    sampling_rate=sample[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s blues track with groovy saxophone&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),xe=new W({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnNhbmNoaXQtZ2FuZGhpJTJGZ3R6YW4lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFzYW1wbGUlMjAlM0QlMjBuZXh0KGl0ZXIoZGF0YXNldCkpJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjMlMjB0YWtlJTIwdGhlJTIwZmlyc3QlMjBxdWFydGVyJTIwb2YlMjB0aGUlMjBhdWRpbyUyMHNhbXBsZSUwQXNhbXBsZV8xJTIwJTNEJTIwc2FtcGxlJTVCJTIyYXJyYXklMjIlNUQlNUIlM0ElMjBsZW4oc2FtcGxlJTVCJTIyYXJyYXklMjIlNUQpJTIwJTJGJTJGJTIwNCU1RCUwQSUwQSUyMyUyMHRha2UlMjB0aGUlMjBmaXJzdCUyMGhhbGYlMjBvZiUyMHRoZSUyMGF1ZGlvJTIwc2FtcGxlJTBBc2FtcGxlXzIlMjAlM0QlMjBzYW1wbGUlNUIlMjJhcnJheSUyMiU1RCU1QiUzQSUyMGxlbihzYW1wbGUlNUIlMjJhcnJheSUyMiU1RCklMjAlMkYlMkYlMjAyJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMGF1ZGlvJTNEJTVCc2FtcGxlXzElMkMlMjBzYW1wbGVfMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGUlNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMjgwcyUyMGJsdWVzJTIwdHJhY2slMjB3aXRoJTIwZ3Jvb3Z5JTIwc2F4b3Bob25lJTIyJTJDJTIwJTIyOTBzJTIwcm9jayUyMHNvbmclMjB3aXRoJTIwbG91ZCUyMGd1aXRhcnMlMjBhbmQlMjBoZWF2eSUyMGRydW1zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTBBKSUwQWF1ZGlvX3ZhbHVlcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KSUwQSUwQSUyMyUyMHBvc3QtcHJvY2VzcyUyMHRvJTIwcmVtb3ZlJTIwcGFkZGluZyUyMGZyb20lMjB0aGUlMjBiYXRjaGVkJTIwYXVkaW8lMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGF1ZGlvX3ZhbHVlcyUyQyUyMHBhZGRpbmdfbWFzayUzRGlucHV0cy5wYWRkaW5nX21hc2sp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;sanchit-gandhi/gtzan&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))[<span class="hljs-string">&quot;audio&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># take the first quarter of the audio sample</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sample_1 = sample[<span class="hljs-string">&quot;array&quot;</span>][: <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;array&quot;</span>]) // <span class="hljs-number">4</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># take the first half of the audio sample</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sample_2 = sample[<span class="hljs-string">&quot;array&quot;</span>][: <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;array&quot;</span>]) // <span class="hljs-number">2</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    audio=[sample_1, sample_2],
<span class="hljs-meta">... </span>    sampling_rate=sample[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s blues track with groovy saxophone&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># post-process to remove padding from the batched audio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = processor.batch_decode(audio_values, padding_mask=inputs.padding_mask)`,wrap:!1}}),Fe=new U({props:{title:"Generation Configuration",local:"generation-configuration",headingTag:"h3"}}),ze=new W({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEElMjMlMjBpbnNwZWN0JTIwdGhlJTIwZGVmYXVsdCUyMGdlbmVyYXRpb24lMjBjb25maWclMEFtb2RlbC5nZW5lcmF0aW9uX2NvbmZpZyUwQSUwQSUyMyUyMGluY3JlYXNlJTIwdGhlJTIwZ3VpZGFuY2UlMjBzY2FsZSUyMHRvJTIwNC4wJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuZ3VpZGFuY2Vfc2NhbGUlMjAlM0QlMjA0LjAlMEElMEElMjMlMjBkZWNyZWFzZSUyMHRoZSUyMG1heCUyMGxlbmd0aCUyMHRvJTIwMjU2JTIwdG9rZW5zJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcubWF4X2xlbmd0aCUyMCUzRCUyMDI1Ng==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inspect the default generation config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># increase the guidance scale to 4.0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.guidance_scale = <span class="hljs-number">4.0</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># decrease the max length to 256 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.max_length = <span class="hljs-number">256</span>`,wrap:!1}}),Ne=new U({props:{title:"Model Structure",local:"model-structure",headingTag:"h2"}}),qe=new W({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBNdXNpY2dlbkZvckNhdXNhbExNJTJDJTIwTXVzaWNnZW5Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEElMjMlMjBPcHRpb24lMjAxJTNBJTIwZ2V0JTIwZGVjb2RlciUyMGNvbmZpZyUyMGFuZCUyMHBhc3MlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQlNjAlMEFkZWNvZGVyX2NvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpLmRlY29kZXIlMEFkZWNvZGVyJTIwJTNEJTIwTXVzaWNnZW5Gb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiUyQyUyMCoqZGVjb2Rlcl9jb25maWcpJTBBJTBBJTIzJTIwT3B0aW9uJTIwMiUzQSUyMGxvYWQlMjB0aGUlMjBlbnRpcmUlMjBjb21wb3NpdGUlMjBtb2RlbCUyQyUyMGJ1dCUyMG9ubHklMjByZXR1cm4lMjB0aGUlMjBkZWNvZGVyJTBBZGVjb2RlciUyMCUzRCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm11c2ljZ2VuLXNtYWxsJTIyKS5kZWNvZGVy",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, MusicgenForCausalLM, MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Option 1: get decoder config and pass to \`.from_pretrained\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>).decoder
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = MusicgenForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>, **decoder_config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Option 2: load the entire composite model, but only return the decoder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>).decoder`,wrap:!1}}),He=new U({props:{title:"MusicgenDecoderConfig",local:"transformers.MusicgenDecoderConfig",headingTag:"h2"}}),Le=new N({props:{name:"class transformers.MusicgenDecoderConfig",anchor:"transformers.MusicgenDecoderConfig",parameters:[{name:"vocab_size",val:" = 2048"},{name:"max_position_embeddings",val:" = 2048"},{name:"num_hidden_layers",val:" = 24"},{name:"ffn_dim",val:" = 4096"},{name:"num_attention_heads",val:" = 16"},{name:"layerdrop",val:" = 0.0"},{name:"use_cache",val:" = True"},{name:"activation_function",val:" = 'gelu'"},{name:"hidden_size",val:" = 1024"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"initializer_factor",val:" = 0.02"},{name:"scale_embedding",val:" = False"},{name:"num_codebooks",val:" = 4"},{name:"audio_channels",val:" = 1"},{name:"pad_token_id",val:" = 2048"},{name:"bos_token_id",val:" = 2048"},{name:"eos_token_id",val:" = None"},{name:"tie_word_embeddings",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenDecoderConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Vocabulary size of the MusicgenDecoder model. Defines the number of different tokens that can be
represented by the <code>inputs_ids</code> passed when calling <code>MusicgenDecoder</code>.`,name:"vocab_size"},{anchor:"transformers.MusicgenDecoderConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimensionality of the layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.MusicgenDecoderConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of decoder layers.`,name:"num_hidden_layers"},{anchor:"transformers.MusicgenDecoderConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer block.`,name:"num_attention_heads"},{anchor:"transformers.MusicgenDecoderConfig.ffn_dim",description:`<strong>ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer block.`,name:"ffn_dim"},{anchor:"transformers.MusicgenDecoderConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.MusicgenDecoderConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, text_encoder, and pooler.`,name:"dropout"},{anchor:"transformers.MusicgenDecoderConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.MusicgenDecoderConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.MusicgenDecoderConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that this model might ever be used with. Typically, set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.MusicgenDecoderConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_factor"},{anchor:"transformers.MusicgenDecoderConfig.layerdrop",description:`<strong>layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the decoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"layerdrop"},{anchor:"transformers.MusicgenDecoderConfig.scale_embedding",description:`<strong>scale_embedding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Scale embeddings by diving by sqrt(hidden_size).`,name:"scale_embedding"},{anchor:"transformers.MusicgenDecoderConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the model should return the last key/values attentions (not used by all models)`,name:"use_cache"},{anchor:"transformers.MusicgenDecoderConfig.num_codebooks",description:`<strong>num_codebooks</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of parallel codebooks forwarded to the model.`,name:"num_codebooks"},{anchor:"transformers.MusicgenDecoderConfig.tie_word_embeddings(bool,",description:`<strong>tie_word_embeddings(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether input and output word embeddings should be tied.`,name:"tie_word_embeddings(bool,"},{anchor:"transformers.MusicgenDecoderConfig.audio_channels",description:`<strong>audio_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 1 &#x2014;
Number of channels in the audio data. Either 1 for mono or 2 for stereo. Stereo models generate a separate
audio stream for the left/right output channels. Mono models generate a single audio stream output.`,name:"audio_channels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/configuration_musicgen.py#L25"}}),Pe=new U({props:{title:"MusicgenConfig",local:"transformers.MusicgenConfig",headingTag:"h2"}}),Qe=new N({props:{name:"class transformers.MusicgenConfig",anchor:"transformers.MusicgenConfig",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments. Notably:</p>
<ul>
<li><strong>text_encoder</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that
defines the text encoder config.</li>
<li><strong>audio_encoder</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that
defines the audio encoder config.</li>
<li><strong>decoder</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that defines
the decoder config.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/configuration_musicgen.py#L135"}}),Y=new ko({props:{anchor:"transformers.MusicgenConfig.example",$$slots:{default:[js]},$$scope:{ctx:Z}}}),Se=new N({props:{name:"from_sub_models_config",anchor:"transformers.MusicgenConfig.from_sub_models_config",parameters:[{name:"text_encoder_config",val:": PretrainedConfig"},{name:"audio_encoder_config",val:": PretrainedConfig"},{name:"decoder_config",val:": MusicgenDecoderConfig"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/configuration_musicgen.py#L218",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenConfig"
>MusicgenConfig</a></p>
`}}),De=new U({props:{title:"MusicgenProcessor",local:"transformers.MusicgenProcessor",headingTag:"h2"}}),Ae=new N({props:{name:"class transformers.MusicgenProcessor",anchor:"transformers.MusicgenProcessor",parameters:[{name:"feature_extractor",val:""},{name:"tokenizer",val:""}],parametersDescription:[{anchor:"transformers.MusicgenProcessor.feature_extractor",description:`<strong>feature_extractor</strong> (<code>EncodecFeatureExtractor</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecFeatureExtractor">EncodecFeatureExtractor</a>. The feature extractor is a required input.`,name:"feature_extractor"},{anchor:"transformers.MusicgenProcessor.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/t5#transformers.T5Tokenizer">T5Tokenizer</a>. The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/processing_musicgen.py#L27"}}),Oe=new N({props:{name:"batch_decode",anchor:"transformers.MusicgenProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/processing_musicgen.py#L91"}}),Ke=new N({props:{name:"decode",anchor:"transformers.MusicgenProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/processing_musicgen.py#L109"}}),et=new U({props:{title:"MusicgenModel",local:"transformers.MusicgenModel",headingTag:"h2"}}),tt=new N({props:{name:"class transformers.MusicgenModel",anchor:"transformers.MusicgenModel",parameters:[{name:"config",val:": MusicgenDecoderConfig"}],parametersDescription:[{anchor:"transformers.MusicgenModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenDecoderConfig">MusicgenDecoderConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/modeling_musicgen.py#L955"}}),nt=new N({props:{name:"forward",anchor:"transformers.MusicgenModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MusicgenModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_codebooks, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the sequence of audio codes.</p>
<p>Indices can be obtained by encoding an audio prompt with an audio encoder model to predict audio codes,
such as with the <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>. See <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel.encode">EncodecModel.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The <code>input_ids</code> will automatically be converted from shape <code>(batch_size * num_codebooks, target_sequence_length)</code> to <code>(batch_size, num_codebooks, target_sequence_length)</code> in the forward pass. If
you obtain audio codes from an audio encoding model, such as <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>, ensure that the number of
frames is equal to 1, and that you reshape the audio codes from <code>(frames, batch_size, num_codebooks, target_sequence_length)</code> to <code>(batch_size * num_codebooks, target_sequence_length)</code> prior to passing them as
<code>input_ids</code>.</p>

					</div>`,name:"input_ids"},{anchor:"transformers.MusicgenModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MusicgenModel.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention of
the decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.MusicgenModel.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, encoder_sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing cross-attention on padding tokens indices of encoder input_ids. Mask values
selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"encoder_attention_mask"},{anchor:"transformers.MusicgenModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MusicgenModel.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder to avoid performing
cross-attention on hidden heads. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MusicgenModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MusicgenModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MusicgenModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MusicgenModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MusicgenModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MusicgenModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/modeling_musicgen.py#L972",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenConfig"
>MusicgenConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Q=new wo({props:{$$slots:{default:[Cs]},$$scope:{ctx:Z}}}),ot=new U({props:{title:"MusicgenForCausalLM",local:"transformers.MusicgenForCausalLM",headingTag:"h2"}}),st=new N({props:{name:"class transformers.MusicgenForCausalLM",anchor:"transformers.MusicgenForCausalLM",parameters:[{name:"config",val:": MusicgenDecoderConfig"}],parametersDescription:[{anchor:"transformers.MusicgenForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenDecoderConfig">MusicgenDecoderConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/modeling_musicgen.py#L1060"}}),at=new N({props:{name:"forward",anchor:"transformers.MusicgenForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_codebooks, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the sequence of audio codes.</p>
<p>Indices can be obtained by encoding an audio prompt with an audio encoder model to predict audio codes,
such as with the <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>. See <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel.encode">EncodecModel.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The <code>input_ids</code> will automatically be converted from shape <code>(batch_size * num_codebooks, target_sequence_length)</code> to <code>(batch_size, num_codebooks, target_sequence_length)</code> in the forward pass. If
you obtain audio codes from an audio encoding model, such as <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>, ensure that the number of
frames is equal to 1, and that you reshape the audio codes from <code>(frames, batch_size, num_codebooks, target_sequence_length)</code> to <code>(batch_size * num_codebooks, target_sequence_length)</code> prior to passing them as
<code>input_ids</code>.</p>

					</div>`,name:"input_ids"},{anchor:"transformers.MusicgenForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MusicgenForCausalLM.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention of
the decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.MusicgenForCausalLM.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, encoder_sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing cross-attention on padding tokens indices of encoder input_ids. Mask values
selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"encoder_attention_mask"},{anchor:"transformers.MusicgenForCausalLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MusicgenForCausalLM.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder to avoid performing
cross-attention on hidden heads. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MusicgenForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MusicgenForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MusicgenForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, num_codebooks)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"},{anchor:"transformers.MusicgenForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MusicgenForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MusicgenForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MusicgenForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/modeling_musicgen.py#L1097",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenConfig"
>MusicgenConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),S=new wo({props:{$$slots:{default:[Js]},$$scope:{ctx:Z}}}),D=new ko({props:{anchor:"transformers.MusicgenForCausalLM.forward.example",$$slots:{default:[$s]},$$scope:{ctx:Z}}}),rt=new U({props:{title:"MusicgenForConditionalGeneration",local:"transformers.MusicgenForConditionalGeneration",headingTag:"h2"}}),it=new N({props:{name:"class transformers.MusicgenForConditionalGeneration",anchor:"transformers.MusicgenForConditionalGeneration",parameters:[{name:"config",val:": typing.Optional[transformers.models.musicgen.configuration_musicgen.MusicgenConfig] = None"},{name:"text_encoder",val:": typing.Optional[transformers.modeling_utils.PreTrainedModel] = None"},{name:"audio_encoder",val:": typing.Optional[transformers.modeling_utils.PreTrainedModel] = None"},{name:"decoder",val:": typing.Optional[transformers.models.musicgen.modeling_musicgen.MusicgenForCausalLM] = None"}],parametersDescription:[{anchor:"transformers.MusicgenForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenConfig">MusicgenConfig</a>, <em>optional</em>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.MusicgenForConditionalGeneration.text_encoder",description:`<strong>text_encoder</strong> (<code>~modeling_utils.PreTrainedModel</code>, <em>optional</em>) &#x2014;
The text encoder model that encodes text into hidden states for conditioning.`,name:"text_encoder"},{anchor:"transformers.MusicgenForConditionalGeneration.audio_encoder",description:`<strong>audio_encoder</strong> (<code>~modeling_utils.PreTrainedModel</code>, <em>optional</em>) &#x2014;
The audio encoder model that encodes audio into hidden states for conditioning.`,name:"audio_encoder"},{anchor:"transformers.MusicgenForConditionalGeneration.decoder",description:`<strong>decoder</strong> (<code>~models.musicgen.modeling_musicgen.MusicgenForCausalLM</code>, <em>optional</em>) &#x2014;
The decoder model that generates audio tokens based on conditioning signals.`,name:"decoder"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/modeling_musicgen.py#L1550"}}),lt=new N({props:{name:"forward",anchor:"transformers.MusicgenForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"input_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"padding_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <code>{processor_class}.__call__</code> for details.`,name:"input_values"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.padding_mask",description:`<strong>padding_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"padding_mask"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_codebooks, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary, corresponding to the sequence of audio codes.</p>
<p>Indices can be obtained by encoding an audio prompt with an audio encoder model to predict audio codes,
such as with the <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>. See <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel.encode">EncodecModel.encode()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The <code>decoder_input_ids</code> will automatically be converted from shape <code>(batch_size * num_codebooks, target_sequence_length)</code> to <code>(batch_size, num_codebooks, target_sequence_length)</code> in the forward pass. If
you obtain audio codes from an audio encoding model, such as <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>, ensure that the number of
frames is equal to 1, and that you reshape the audio codes from <code>(frames, batch_size, num_codebooks, target_sequence_length)</code> to <code>(batch_size * num_codebooks, target_sequence_length)</code> prior to passing them as
<code>decoder_input_ids</code>.</p>

					</div>`,name:"decoder_input_ids"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>Tuple[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, num_codebooks)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/modeling_musicgen.py#L1899",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenConfig"
>MusicgenConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>EncoderDecoderCache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.EncoderDecoderCache"
>EncoderDecoderCache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),A=new wo({props:{$$slots:{default:[Us]},$$scope:{ctx:Z}}}),O=new ko({props:{anchor:"transformers.MusicgenForConditionalGeneration.forward.example",$$slots:{default:[Zs]},$$scope:{ctx:Z}}}),dt=new ks({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/musicgen.md"}}),{c(){d=r("meta"),y=s(),M=r("p"),b=s(),p(T.$$.fragment),m=s(),v=r("div"),v.innerHTML=jo,Nt=s(),p(te.$$.fragment),Xt=s(),ne=r("p"),ne.innerHTML=Co,Bt=s(),oe=r("p"),oe.innerHTML=Jo,Rt=s(),se=r("p"),se.textContent=$o,qt=s(),ae=r("p"),ae.textContent=Uo,Vt=s(),re=r("p"),re.innerHTML=Zo,Et=s(),ie=r("p"),ie.innerHTML=Go,Yt=s(),p(le.$$.fragment),Ht=s(),de=r("ul"),de.innerHTML=xo,Lt=s(),p(ce.$$.fragment),Pt=s(),me=r("blockquote"),me.innerHTML=Fo,Qt=s(),p(pe.$$.fragment),St=s(),ue=r("p"),ue.innerHTML=Wo,Dt=s(),he=r("p"),he.textContent=zo,At=s(),ge=r("p"),ge.textContent=Io,Ot=s(),p(fe.$$.fragment),Kt=s(),_e=r("p"),_e.innerHTML=No,en=s(),p(Me.$$.fragment),tn=s(),be=r("p"),be.innerHTML=Xo,nn=s(),p(ye.$$.fragment),on=s(),Te=r("p"),Te.innerHTML=Bo,sn=s(),p(ve.$$.fragment),an=s(),p(we.$$.fragment),rn=s(),ke=r("p"),ke.innerHTML=Ro,ln=s(),p(je.$$.fragment),dn=s(),Ce=r("p"),Ce.innerHTML=qo,cn=s(),p(Je.$$.fragment),mn=s(),$e=r("p"),$e.innerHTML=Vo,pn=s(),p(Ue.$$.fragment),un=s(),p(Ze.$$.fragment),hn=s(),Ge=r("p"),Ge.innerHTML=Eo,gn=s(),p(xe.$$.fragment),fn=s(),p(Fe.$$.fragment),_n=s(),We=r("p"),We.textContent=Yo,Mn=s(),p(ze.$$.fragment),bn=s(),Ie=r("p"),Ie.innerHTML=Ho,yn=s(),p(Ne.$$.fragment),Tn=s(),Xe=r("p"),Xe.textContent=Lo,vn=s(),Be=r("ol"),Be.innerHTML=Po,wn=s(),Re=r("p"),Re.innerHTML=Qo,kn=s(),p(qe.$$.fragment),jn=s(),Ve=r("p"),Ve.innerHTML=So,Cn=s(),Ee=r("p"),Ee.textContent=Do,Jn=s(),Ye=r("ul"),Ye.innerHTML=Ao,$n=s(),p(He.$$.fragment),Un=s(),X=r("div"),p(Le.$$.fragment),En=s(),ut=r("p"),ut.innerHTML=Oo,Yn=s(),ht=r("p"),ht.innerHTML=Ko,Zn=s(),p(Pe.$$.fragment),Gn=s(),w=r("div"),p(Qe.$$.fragment),Hn=s(),gt=r("p"),gt.innerHTML=es,Ln=s(),ft=r("p"),ft.innerHTML=ts,Pn=s(),p(Y.$$.fragment),Qn=s(),H=r("div"),p(Se.$$.fragment),Sn=s(),_t=r("p"),_t.innerHTML=ns,xn=s(),p(De.$$.fragment),Fn=s(),k=r("div"),p(Ae.$$.fragment),Dn=s(),Mt=r("p"),Mt.textContent=os,An=s(),bt=r("p"),bt.innerHTML=ss,On=s(),L=r("div"),p(Oe.$$.fragment),Kn=s(),yt=r("p"),yt.innerHTML=as,eo=s(),P=r("div"),p(Ke.$$.fragment),to=s(),Tt=r("p"),Tt.innerHTML=rs,Wn=s(),p(et.$$.fragment),zn=s(),j=r("div"),p(tt.$$.fragment),no=s(),vt=r("p"),vt.textContent=is,oo=s(),wt=r("p"),wt.innerHTML=ls,so=s(),kt=r("p"),kt.innerHTML=ds,ao=s(),B=r("div"),p(nt.$$.fragment),ro=s(),jt=r("p"),jt.innerHTML=cs,io=s(),p(Q.$$.fragment),In=s(),p(ot.$$.fragment),Nn=s(),C=r("div"),p(st.$$.fragment),lo=s(),Ct=r("p"),Ct.textContent=ms,co=s(),Jt=r("p"),Jt.innerHTML=ps,mo=s(),$t=r("p"),$t.innerHTML=us,po=s(),z=r("div"),p(at.$$.fragment),uo=s(),Ut=r("p"),Ut.innerHTML=hs,ho=s(),p(S.$$.fragment),go=s(),p(D.$$.fragment),Xn=s(),p(rt.$$.fragment),Bn=s(),J=r("div"),p(it.$$.fragment),fo=s(),Zt=r("p"),Zt.textContent=gs,_o=s(),Gt=r("p"),Gt.innerHTML=fs,Mo=s(),xt=r("p"),xt.innerHTML=_s,bo=s(),I=r("div"),p(lt.$$.fragment),yo=s(),Ft=r("p"),Ft.innerHTML=Ms,To=s(),p(A.$$.fragment),vo=s(),p(O.$$.fragment),Rn=s(),p(dt.$$.fragment),qn=s(),It=r("p"),this.h()},l(e){const t=ws("svelte-u9bgzb",document.head);d=i(t,"META",{name:!0,content:!0}),t.forEach(n),y=a(e),M=i(e,"P",{}),G(M).forEach(n),b=a(e),u(T.$$.fragment,e),m=a(e),v=i(e,"DIV",{class:!0,"data-svelte-h":!0}),c(v)!=="svelte-b95w5j"&&(v.innerHTML=jo),Nt=a(e),u(te.$$.fragment,e),Xt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-1glsc0y"&&(ne.innerHTML=Co),Bt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-8d0j4l"&&(oe.innerHTML=Jo),Rt=a(e),se=i(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-cdry7g"&&(se.textContent=$o),qt=a(e),ae=i(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-vfdo9a"&&(ae.textContent=Uo),Vt=a(e),re=i(e,"P",{"data-svelte-h":!0}),c(re)!=="svelte-6qc9b"&&(re.innerHTML=Zo),Et=a(e),ie=i(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-1o040cl"&&(ie.innerHTML=Go),Yt=a(e),u(le.$$.fragment,e),Ht=a(e),de=i(e,"UL",{"data-svelte-h":!0}),c(de)!=="svelte-12e77r4"&&(de.innerHTML=xo),Lt=a(e),u(ce.$$.fragment,e),Pt=a(e),me=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),c(me)!=="svelte-1fwzni2"&&(me.innerHTML=Fo),Qt=a(e),u(pe.$$.fragment,e),St=a(e),ue=i(e,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-1rrub89"&&(ue.innerHTML=Wo),Dt=a(e),he=i(e,"P",{"data-svelte-h":!0}),c(he)!=="svelte-1tppmp9"&&(he.textContent=zo),At=a(e),ge=i(e,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-1e09glx"&&(ge.textContent=Io),Ot=a(e),u(fe.$$.fragment,e),Kt=a(e),_e=i(e,"P",{"data-svelte-h":!0}),c(_e)!=="svelte-hslupw"&&(_e.innerHTML=No),en=a(e),u(Me.$$.fragment,e),tn=a(e),be=i(e,"P",{"data-svelte-h":!0}),c(be)!=="svelte-c9ap2j"&&(be.innerHTML=Xo),nn=a(e),u(ye.$$.fragment,e),on=a(e),Te=i(e,"P",{"data-svelte-h":!0}),c(Te)!=="svelte-1endcdl"&&(Te.innerHTML=Bo),sn=a(e),u(ve.$$.fragment,e),an=a(e),u(we.$$.fragment,e),rn=a(e),ke=i(e,"P",{"data-svelte-h":!0}),c(ke)!=="svelte-1lsquh5"&&(ke.innerHTML=Ro),ln=a(e),u(je.$$.fragment,e),dn=a(e),Ce=i(e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-78k595"&&(Ce.innerHTML=qo),cn=a(e),u(Je.$$.fragment,e),mn=a(e),$e=i(e,"P",{"data-svelte-h":!0}),c($e)!=="svelte-6hk8z3"&&($e.innerHTML=Vo),pn=a(e),u(Ue.$$.fragment,e),un=a(e),u(Ze.$$.fragment,e),hn=a(e),Ge=i(e,"P",{"data-svelte-h":!0}),c(Ge)!=="svelte-1sawt4q"&&(Ge.innerHTML=Eo),gn=a(e),u(xe.$$.fragment,e),fn=a(e),u(Fe.$$.fragment,e),_n=a(e),We=i(e,"P",{"data-svelte-h":!0}),c(We)!=="svelte-1qo0662"&&(We.textContent=Yo),Mn=a(e),u(ze.$$.fragment,e),bn=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-132s853"&&(Ie.innerHTML=Ho),yn=a(e),u(Ne.$$.fragment,e),Tn=a(e),Xe=i(e,"P",{"data-svelte-h":!0}),c(Xe)!=="svelte-52mell"&&(Xe.textContent=Lo),vn=a(e),Be=i(e,"OL",{"data-svelte-h":!0}),c(Be)!=="svelte-12ipaq0"&&(Be.innerHTML=Po),wn=a(e),Re=i(e,"P",{"data-svelte-h":!0}),c(Re)!=="svelte-153gzk7"&&(Re.innerHTML=Qo),kn=a(e),u(qe.$$.fragment,e),jn=a(e),Ve=i(e,"P",{"data-svelte-h":!0}),c(Ve)!=="svelte-1sxrkse"&&(Ve.innerHTML=So),Cn=a(e),Ee=i(e,"P",{"data-svelte-h":!0}),c(Ee)!=="svelte-axv494"&&(Ee.textContent=Do),Jn=a(e),Ye=i(e,"UL",{"data-svelte-h":!0}),c(Ye)!=="svelte-1upux1z"&&(Ye.innerHTML=Ao),$n=a(e),u(He.$$.fragment,e),Un=a(e),X=i(e,"DIV",{class:!0});var E=G(X);u(Le.$$.fragment,E),En=a(E),ut=i(E,"P",{"data-svelte-h":!0}),c(ut)!=="svelte-13s74fx"&&(ut.innerHTML=Oo),Yn=a(E),ht=i(E,"P",{"data-svelte-h":!0}),c(ht)!=="svelte-o55m63"&&(ht.innerHTML=Ko),E.forEach(n),Zn=a(e),u(Pe.$$.fragment,e),Gn=a(e),w=i(e,"DIV",{class:!0});var x=G(w);u(Qe.$$.fragment,x),Hn=a(x),gt=i(x,"P",{"data-svelte-h":!0}),c(gt)!=="svelte-wifzd"&&(gt.innerHTML=es),Ln=a(x),ft=i(x,"P",{"data-svelte-h":!0}),c(ft)!=="svelte-o55m63"&&(ft.innerHTML=ts),Pn=a(x),u(Y.$$.fragment,x),Qn=a(x),H=i(x,"DIV",{class:!0});var ct=G(H);u(Se.$$.fragment,ct),Sn=a(ct),_t=i(ct,"P",{"data-svelte-h":!0}),c(_t)!=="svelte-1rh3axm"&&(_t.innerHTML=ns),ct.forEach(n),x.forEach(n),xn=a(e),u(De.$$.fragment,e),Fn=a(e),k=i(e,"DIV",{class:!0});var F=G(k);u(Ae.$$.fragment,F),Dn=a(F),Mt=i(F,"P",{"data-svelte-h":!0}),c(Mt)!=="svelte-12wttjh"&&(Mt.textContent=os),An=a(F),bt=i(F,"P",{"data-svelte-h":!0}),c(bt)!=="svelte-11tke2g"&&(bt.innerHTML=ss),On=a(F),L=i(F,"DIV",{class:!0});var mt=G(L);u(Oe.$$.fragment,mt),Kn=a(mt),yt=i(mt,"P",{"data-svelte-h":!0}),c(yt)!=="svelte-b90dsi"&&(yt.innerHTML=as),mt.forEach(n),eo=a(F),P=i(F,"DIV",{class:!0});var pt=G(P);u(Ke.$$.fragment,pt),to=a(pt),Tt=i(pt,"P",{"data-svelte-h":!0}),c(Tt)!=="svelte-xtplha"&&(Tt.innerHTML=rs),pt.forEach(n),F.forEach(n),Wn=a(e),u(et.$$.fragment,e),zn=a(e),j=i(e,"DIV",{class:!0});var R=G(j);u(tt.$$.fragment,R),no=a(R),vt=i(R,"P",{"data-svelte-h":!0}),c(vt)!=="svelte-1u3x61j"&&(vt.textContent=is),oo=a(R),wt=i(R,"P",{"data-svelte-h":!0}),c(wt)!=="svelte-6pahdo"&&(wt.innerHTML=ls),so=a(R),kt=i(R,"P",{"data-svelte-h":!0}),c(kt)!=="svelte-hswkmf"&&(kt.innerHTML=ds),ao=a(R),B=i(R,"DIV",{class:!0});var Wt=G(B);u(nt.$$.fragment,Wt),ro=a(Wt),jt=i(Wt,"P",{"data-svelte-h":!0}),c(jt)!=="svelte-dfxyle"&&(jt.innerHTML=cs),io=a(Wt),u(Q.$$.fragment,Wt),Wt.forEach(n),R.forEach(n),In=a(e),u(ot.$$.fragment,e),Nn=a(e),C=i(e,"DIV",{class:!0});var q=G(C);u(st.$$.fragment,q),lo=a(q),Ct=i(q,"P",{"data-svelte-h":!0}),c(Ct)!=="svelte-1l370y5"&&(Ct.textContent=ms),co=a(q),Jt=i(q,"P",{"data-svelte-h":!0}),c(Jt)!=="svelte-6pahdo"&&(Jt.innerHTML=ps),mo=a(q),$t=i(q,"P",{"data-svelte-h":!0}),c($t)!=="svelte-hswkmf"&&($t.innerHTML=us),po=a(q),z=i(q,"DIV",{class:!0});var K=G(z);u(at.$$.fragment,K),uo=a(K),Ut=i(K,"P",{"data-svelte-h":!0}),c(Ut)!=="svelte-102g1jm"&&(Ut.innerHTML=hs),ho=a(K),u(S.$$.fragment,K),go=a(K),u(D.$$.fragment,K),K.forEach(n),q.forEach(n),Xn=a(e),u(rt.$$.fragment,e),Bn=a(e),J=i(e,"DIV",{class:!0});var V=G(J);u(it.$$.fragment,V),fo=a(V),Zt=i(V,"P",{"data-svelte-h":!0}),c(Zt)!=="svelte-4vubq6"&&(Zt.textContent=gs),_o=a(V),Gt=i(V,"P",{"data-svelte-h":!0}),c(Gt)!=="svelte-6pahdo"&&(Gt.innerHTML=fs),Mo=a(V),xt=i(V,"P",{"data-svelte-h":!0}),c(xt)!=="svelte-hswkmf"&&(xt.innerHTML=_s),bo=a(V),I=i(V,"DIV",{class:!0});var ee=G(I);u(lt.$$.fragment,ee),yo=a(ee),Ft=i(ee,"P",{"data-svelte-h":!0}),c(Ft)!=="svelte-wf1hrq"&&(Ft.innerHTML=Ms),To=a(ee),u(A.$$.fragment,ee),vo=a(ee),u(O.$$.fragment,ee),ee.forEach(n),V.forEach(n),Rn=a(e),u(dt.$$.fragment,e),qn=a(e),It=i(e,"P",{}),G(It).forEach(n),this.h()},h(){$(d,"name","hf:doc:metadata"),$(d,"content",xs),$(v,"class","flex flex-wrap space-x-1"),$(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,d),o(e,y,t),o(e,M,t),o(e,b,t),h(T,e,t),o(e,m,t),o(e,v,t),o(e,Nt,t),h(te,e,t),o(e,Xt,t),o(e,ne,t),o(e,Bt,t),o(e,oe,t),o(e,Rt,t),o(e,se,t),o(e,qt,t),o(e,ae,t),o(e,Vt,t),o(e,re,t),o(e,Et,t),o(e,ie,t),o(e,Yt,t),h(le,e,t),o(e,Ht,t),o(e,de,t),o(e,Lt,t),h(ce,e,t),o(e,Pt,t),o(e,me,t),o(e,Qt,t),h(pe,e,t),o(e,St,t),o(e,ue,t),o(e,Dt,t),o(e,he,t),o(e,At,t),o(e,ge,t),o(e,Ot,t),h(fe,e,t),o(e,Kt,t),o(e,_e,t),o(e,en,t),h(Me,e,t),o(e,tn,t),o(e,be,t),o(e,nn,t),h(ye,e,t),o(e,on,t),o(e,Te,t),o(e,sn,t),h(ve,e,t),o(e,an,t),h(we,e,t),o(e,rn,t),o(e,ke,t),o(e,ln,t),h(je,e,t),o(e,dn,t),o(e,Ce,t),o(e,cn,t),h(Je,e,t),o(e,mn,t),o(e,$e,t),o(e,pn,t),h(Ue,e,t),o(e,un,t),h(Ze,e,t),o(e,hn,t),o(e,Ge,t),o(e,gn,t),h(xe,e,t),o(e,fn,t),h(Fe,e,t),o(e,_n,t),o(e,We,t),o(e,Mn,t),h(ze,e,t),o(e,bn,t),o(e,Ie,t),o(e,yn,t),h(Ne,e,t),o(e,Tn,t),o(e,Xe,t),o(e,vn,t),o(e,Be,t),o(e,wn,t),o(e,Re,t),o(e,kn,t),h(qe,e,t),o(e,jn,t),o(e,Ve,t),o(e,Cn,t),o(e,Ee,t),o(e,Jn,t),o(e,Ye,t),o(e,$n,t),h(He,e,t),o(e,Un,t),o(e,X,t),h(Le,X,null),l(X,En),l(X,ut),l(X,Yn),l(X,ht),o(e,Zn,t),h(Pe,e,t),o(e,Gn,t),o(e,w,t),h(Qe,w,null),l(w,Hn),l(w,gt),l(w,Ln),l(w,ft),l(w,Pn),h(Y,w,null),l(w,Qn),l(w,H),h(Se,H,null),l(H,Sn),l(H,_t),o(e,xn,t),h(De,e,t),o(e,Fn,t),o(e,k,t),h(Ae,k,null),l(k,Dn),l(k,Mt),l(k,An),l(k,bt),l(k,On),l(k,L),h(Oe,L,null),l(L,Kn),l(L,yt),l(k,eo),l(k,P),h(Ke,P,null),l(P,to),l(P,Tt),o(e,Wn,t),h(et,e,t),o(e,zn,t),o(e,j,t),h(tt,j,null),l(j,no),l(j,vt),l(j,oo),l(j,wt),l(j,so),l(j,kt),l(j,ao),l(j,B),h(nt,B,null),l(B,ro),l(B,jt),l(B,io),h(Q,B,null),o(e,In,t),h(ot,e,t),o(e,Nn,t),o(e,C,t),h(st,C,null),l(C,lo),l(C,Ct),l(C,co),l(C,Jt),l(C,mo),l(C,$t),l(C,po),l(C,z),h(at,z,null),l(z,uo),l(z,Ut),l(z,ho),h(S,z,null),l(z,go),h(D,z,null),o(e,Xn,t),h(rt,e,t),o(e,Bn,t),o(e,J,t),h(it,J,null),l(J,fo),l(J,Zt),l(J,_o),l(J,Gt),l(J,Mo),l(J,xt),l(J,bo),l(J,I),h(lt,I,null),l(I,yo),l(I,Ft),l(I,To),h(A,I,null),l(I,vo),h(O,I,null),o(e,Rn,t),h(dt,e,t),o(e,qn,t),o(e,It,t),Vn=!0},p(e,[t]){const E={};t&2&&(E.$$scope={dirty:t,ctx:e}),Y.$set(E);const x={};t&2&&(x.$$scope={dirty:t,ctx:e}),Q.$set(x);const ct={};t&2&&(ct.$$scope={dirty:t,ctx:e}),S.$set(ct);const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),D.$set(F);const mt={};t&2&&(mt.$$scope={dirty:t,ctx:e}),A.$set(mt);const pt={};t&2&&(pt.$$scope={dirty:t,ctx:e}),O.$set(pt)},i(e){Vn||(g(T.$$.fragment,e),g(te.$$.fragment,e),g(le.$$.fragment,e),g(ce.$$.fragment,e),g(pe.$$.fragment,e),g(fe.$$.fragment,e),g(Me.$$.fragment,e),g(ye.$$.fragment,e),g(ve.$$.fragment,e),g(we.$$.fragment,e),g(je.$$.fragment,e),g(Je.$$.fragment,e),g(Ue.$$.fragment,e),g(Ze.$$.fragment,e),g(xe.$$.fragment,e),g(Fe.$$.fragment,e),g(ze.$$.fragment,e),g(Ne.$$.fragment,e),g(qe.$$.fragment,e),g(He.$$.fragment,e),g(Le.$$.fragment,e),g(Pe.$$.fragment,e),g(Qe.$$.fragment,e),g(Y.$$.fragment,e),g(Se.$$.fragment,e),g(De.$$.fragment,e),g(Ae.$$.fragment,e),g(Oe.$$.fragment,e),g(Ke.$$.fragment,e),g(et.$$.fragment,e),g(tt.$$.fragment,e),g(nt.$$.fragment,e),g(Q.$$.fragment,e),g(ot.$$.fragment,e),g(st.$$.fragment,e),g(at.$$.fragment,e),g(S.$$.fragment,e),g(D.$$.fragment,e),g(rt.$$.fragment,e),g(it.$$.fragment,e),g(lt.$$.fragment,e),g(A.$$.fragment,e),g(O.$$.fragment,e),g(dt.$$.fragment,e),Vn=!0)},o(e){f(T.$$.fragment,e),f(te.$$.fragment,e),f(le.$$.fragment,e),f(ce.$$.fragment,e),f(pe.$$.fragment,e),f(fe.$$.fragment,e),f(Me.$$.fragment,e),f(ye.$$.fragment,e),f(ve.$$.fragment,e),f(we.$$.fragment,e),f(je.$$.fragment,e),f(Je.$$.fragment,e),f(Ue.$$.fragment,e),f(Ze.$$.fragment,e),f(xe.$$.fragment,e),f(Fe.$$.fragment,e),f(ze.$$.fragment,e),f(Ne.$$.fragment,e),f(qe.$$.fragment,e),f(He.$$.fragment,e),f(Le.$$.fragment,e),f(Pe.$$.fragment,e),f(Qe.$$.fragment,e),f(Y.$$.fragment,e),f(Se.$$.fragment,e),f(De.$$.fragment,e),f(Ae.$$.fragment,e),f(Oe.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(nt.$$.fragment,e),f(Q.$$.fragment,e),f(ot.$$.fragment,e),f(st.$$.fragment,e),f(at.$$.fragment,e),f(S.$$.fragment,e),f(D.$$.fragment,e),f(rt.$$.fragment,e),f(it.$$.fragment,e),f(lt.$$.fragment,e),f(A.$$.fragment,e),f(O.$$.fragment,e),f(dt.$$.fragment,e),Vn=!1},d(e){e&&(n(y),n(M),n(b),n(m),n(v),n(Nt),n(Xt),n(ne),n(Bt),n(oe),n(Rt),n(se),n(qt),n(ae),n(Vt),n(re),n(Et),n(ie),n(Yt),n(Ht),n(de),n(Lt),n(Pt),n(me),n(Qt),n(St),n(ue),n(Dt),n(he),n(At),n(ge),n(Ot),n(Kt),n(_e),n(en),n(tn),n(be),n(nn),n(on),n(Te),n(sn),n(an),n(rn),n(ke),n(ln),n(dn),n(Ce),n(cn),n(mn),n($e),n(pn),n(un),n(hn),n(Ge),n(gn),n(fn),n(_n),n(We),n(Mn),n(bn),n(Ie),n(yn),n(Tn),n(Xe),n(vn),n(Be),n(wn),n(Re),n(kn),n(jn),n(Ve),n(Cn),n(Ee),n(Jn),n(Ye),n($n),n(Un),n(X),n(Zn),n(Gn),n(w),n(xn),n(Fn),n(k),n(Wn),n(zn),n(j),n(In),n(Nn),n(C),n(Xn),n(Bn),n(J),n(Rn),n(qn),n(It)),n(d),_(T,e),_(te,e),_(le,e),_(ce,e),_(pe,e),_(fe,e),_(Me,e),_(ye,e),_(ve,e),_(we,e),_(je,e),_(Je,e),_(Ue,e),_(Ze,e),_(xe,e),_(Fe,e),_(ze,e),_(Ne,e),_(qe,e),_(He,e),_(Le),_(Pe,e),_(Qe),_(Y),_(Se),_(De,e),_(Ae),_(Oe),_(Ke),_(et,e),_(tt),_(nt),_(Q),_(ot,e),_(st),_(at),_(S),_(D),_(rt,e),_(it),_(lt),_(A),_(O),_(dt,e)}}}const xs='{"title":"MusicGen","local":"musicgen","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Generation","local":"generation","sections":[{"title":"Unconditional Generation","local":"unconditional-generation","sections":[],"depth":3},{"title":"Text-Conditional Generation","local":"text-conditional-generation","sections":[],"depth":3},{"title":"Audio-Prompted Generation","local":"audio-prompted-generation","sections":[],"depth":3},{"title":"Generation Configuration","local":"generation-configuration","sections":[],"depth":3}],"depth":2},{"title":"Model Structure","local":"model-structure","sections":[],"depth":2},{"title":"MusicgenDecoderConfig","local":"transformers.MusicgenDecoderConfig","sections":[],"depth":2},{"title":"MusicgenConfig","local":"transformers.MusicgenConfig","sections":[],"depth":2},{"title":"MusicgenProcessor","local":"transformers.MusicgenProcessor","sections":[],"depth":2},{"title":"MusicgenModel","local":"transformers.MusicgenModel","sections":[],"depth":2},{"title":"MusicgenForCausalLM","local":"transformers.MusicgenForCausalLM","sections":[],"depth":2},{"title":"MusicgenForConditionalGeneration","local":"transformers.MusicgenForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Fs(Z){return ys(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vs extends Ts{constructor(d){super(),vs(this,d,Fs,Gs,bs,{})}}export{Vs as component};
