import{s as Ht,o as Ft,n as Mt}from"../chunks/scheduler.18a86fab.js";import{S as Qt,i as Et,g as r,s as n,r as u,A as qt,h as l,f as o,c as a,j as Z,u as h,x as d,k,y as p,a as s,v as g,d as f,t as y,w as M}from"../chunks/index.98837b22.js";import{T as Yt}from"../chunks/Tip.77304350.js";import{D as he}from"../chunks/Docstring.6758ea23.js";import{C as Ge}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Xt}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as je}from"../chunks/Heading.7e7e0c5b.js";import{E as Lt}from"../chunks/index.92f616ba.js";function Pt(S){let c,U="Examples:",T,m,b;return m=new Ge({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN1cGVyR2x1ZUNvbmZpZyUyQyUyMFN1cGVyR2x1ZU1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFN1cGVyR2x1ZSUyMHN1cGVyZ2x1ZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBTdXBlckdsdWVDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBzdXBlcmdsdWUlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFN1cGVyR2x1ZU1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SuperGlueConfig, SuperGlueModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SuperGlue superglue style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SuperGlueConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the superglue style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SuperGlueModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){c=r("p"),c.textContent=U,T=n(),u(m.$$.fragment)},l(i){c=l(i,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=U),T=a(i),h(m.$$.fragment,i)},m(i,w){s(i,c,w),s(i,T,w),g(m,i,w),b=!0},p:Mt,i(i){b||(f(m.$$.fragment,i),b=!0)},o(i){y(m.$$.fragment,i),b=!1},d(i){i&&(o(c),o(T)),M(m,i)}}}function Dt(S){let c,U=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=r("p"),c.innerHTML=U},l(T){c=l(T,"P",{"data-svelte-h":!0}),d(c)!=="svelte-fincs2"&&(c.innerHTML=U)},m(T,m){s(T,c,m)},p:Mt,d(T){T&&o(c)}}}function At(S){let c,U="Examples:",T,m,b;return m=new Ge({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZtYWdpY2xlYXAlMkZTdXBlckdsdWVQcmV0cmFpbmVkTmV0d29yayUyRmJsb2IlMkZtYXN0ZXIlMkZhc3NldHMlMkZwaG90b3RvdXJpc21fc2FtcGxlX2ltYWdlcyUyRmxvbmRvbl9icmlkZ2VfNzg5MTY2NzVfNDU2ODE0MTI4OC5qcGclM0ZyYXclM0R0cnVlJTIyJTBBaW1hZ2UxJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRm1hZ2ljbGVhcCUyRlN1cGVyR2x1ZVByZXRyYWluZWROZXR3b3JrJTJGYmxvYiUyRm1hc3RlciUyRmFzc2V0cyUyRnBob3RvdG91cmlzbV9zYW1wbGVfaW1hZ2VzJTJGbG9uZG9uX2JyaWRnZV8xOTQ4MTc5N18yMjk1ODkyNDIxLmpwZyUzRnJhdyUzRHRydWUlMjIlMEFpbWFnZTIlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBaW1hZ2VzJTIwJTNEJTIwJTVCaW1hZ2UxJTJDJTIwaW1hZ2UyJTVEJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtYWdpYy1sZWFwLWNvbW11bml0eSUyRnN1cGVyZ2x1ZV9vdXRkb29yJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJtYWdpYy1sZWFwLWNvbW11bml0eSUyRnN1cGVyZ2x1ZV9vdXRkb29yJTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://github.com/magicleap/SuperGluePretrainedNetwork/blob/master/assets/phototourism_sample_images/london_bridge_78916675_4568141288.jpg?raw=true&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image1 = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://github.com/magicleap/SuperGluePretrainedNetwork/blob/master/assets/phototourism_sample_images/london_bridge_19481797_2295892421.jpg?raw=true&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image2 = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>images = [image1, image2]

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superglue_outdoor&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superglue_outdoor&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">&gt;&gt;&gt; </span>    inputs = processor(images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>    outputs = model(**inputs)`,wrap:!1}}),{c(){c=r("p"),c.textContent=U,T=n(),u(m.$$.fragment)},l(i){c=l(i,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=U),T=a(i),h(m.$$.fragment,i)},m(i,w){s(i,c,w),s(i,T,w),g(m,i,w),b=!0},p:Mt,i(i){b||(f(m.$$.fragment,i),b=!0)},o(i){y(m.$$.fragment,i),b=!1},d(i){i&&(o(c),o(T)),M(m,i)}}}function Kt(S){let c,U,T,m,b,i,w,Tt='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',ve,V,Ce,X,bt='The SuperGlue model was proposed in <a href="https://arxiv.org/abs/1911.11763" rel="nofollow">SuperGlue: Learning Feature Matching with Graph Neural Networks</a> by Paul-Edouard Sarlin, Daniel DeTone, Tomasz Malisiewicz and Andrew Rabinovich.',ke,H,wt=`This model consists of matching two sets of interest points detected in an image. Paired with the
<a href="https://huggingface.co/magic-leap-community/superpoint" rel="nofollow">SuperPoint model</a>, it can be used to match two images and
estimate the pose between them. This model is useful for tasks such as image matching, homography estimation, etc.`,Ze,F,_t="The abstract from the paper is the following:",Se,Q,Jt=`<em>This paper introduces SuperGlue, a neural network that matches two sets of local features by jointly finding correspondences
and rejecting non-matchable points. Assignments are estimated by solving a differentiable optimal transport problem, whose costs
are predicted by a graph neural network. We introduce a flexible context aggregation mechanism based on attention, enabling
SuperGlue to reason about the underlying 3D scene and feature assignments jointly. Compared to traditional, hand-designed heuristics,
our technique learns priors over geometric transformations and regularities of the 3D world through end-to-end training from image
pairs. SuperGlue outperforms other learned approaches and achieves state-of-the-art results on the task of pose estimation in
challenging real-world indoor and outdoor environments. The proposed method performs matching in real-time on a modern GPU and
can be readily integrated into modern SfM or SLAM systems. The code and trained weights are publicly available at this <a href="https://github.com/magicleap/SuperGluePretrainedNetwork" rel="nofollow">URL</a>.</em>`,ze,E,$e,q,Ut=`Here is a quick example of using the model. Since this model is an image matching model, it requires pairs of images to be matched.
The raw outputs contain the list of keypoints detected by the keypoint detector as well as the list of matches with their corresponding
matching scores.`,xe,Y,Be,L,jt="You can use the <code>post_process_keypoint_matching</code> method from the <code>SuperGlueImageProcessor</code> to get the keypoints and matches in a more readable format:",We,P,Ne,D,It="From the outputs, you can visualize the matches between the two images using the following code:",Re,A,Ve,K,Gt='<img src="https://cdn-uploads.huggingface.co/production/uploads/632885ba1558dac67c440aa8/01ZYaLB1NL5XdA8u7yCo4.png" alt="image/png"/>',Xe,O,vt=`This model was contributed by <a href="https://huggingface.co/stevenbucaille" rel="nofollow">stevenbucaille</a>.
The original code can be found <a href="https://github.com/magicleap/SuperGluePretrainedNetwork" rel="nofollow">here</a>.`,He,ee,Fe,j,te,tt,ge,Ct=`This is the configuration class to store the configuration of a <code>SuperGlueModel</code>. It is used to instantiate a
SuperGlue model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the SuperGlue
<a href="https://huggingface.co/magic-leap-community/superglue_indoor" rel="nofollow">magic-leap-community/superglue_indoor</a> architecture.`,ot,fe,kt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,st,z,Qe,oe,Ee,_,se,nt,ye,Zt="Constructs a SuperGlue image processor.",at,$,ne,rt,Me,St=`Converts the raw output of <code>KeypointMatchingOutput</code> into lists of keypoints, scores and descriptors
with coordinates absolute to the original image sizes.`,lt,x,ae,it,Te,zt="Preprocess an image or batch of images.",ct,B,re,pt,be,$t="Resize an image.",qe,le,xt="<li>preprocess</li>",Ye,ie,Le,J,ce,dt,we,Bt="SuperGlue model taking images as inputs and outputting the matching of them.",mt,_e,Wt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ut,Je,Nt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ht,G,pe,gt,Ue,Rt='The <a href="/docs/transformers/main/en/model_doc/superglue#transformers.SuperGlueForKeypointMatching">SuperGlueForKeypointMatching</a> forward method, overrides the <code>__call__</code> special method.',ft,W,yt,N,Pe,de,Vt="<li>forward</li> <li>post_process_keypoint_matching</li>",De,me,Ae,Ie,Ke;return b=new je({props:{title:"SuperGlue",local:"superglue",headingTag:"h1"}}),V=new je({props:{title:"Overview",local:"overview",headingTag:"h2"}}),E=new je({props:{title:"How to use",local:"how-to-use",headingTag:"h2"}}),Y=new Ge({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmxfaW1hZ2UxJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGbWFnaWNsZWFwJTJGU3VwZXJHbHVlUHJldHJhaW5lZE5ldHdvcmslMkZyZWZzJTJGaGVhZHMlMkZtYXN0ZXIlMkZhc3NldHMlMkZwaG90b3RvdXJpc21fc2FtcGxlX2ltYWdlcyUyRnVuaXRlZF9zdGF0ZXNfY2FwaXRvbF85ODE2OTg4OF8zMzQ3NzEwODUyLmpwZyUyMiUwQWltYWdlMSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybF9pbWFnZTElMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBdXJsX2ltYWdlMiUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRm1hZ2ljbGVhcCUyRlN1cGVyR2x1ZVByZXRyYWluZWROZXR3b3JrJTJGcmVmcyUyRmhlYWRzJTJGbWFzdGVyJTJGYXNzZXRzJTJGcGhvdG90b3VyaXNtX3NhbXBsZV9pbWFnZXMlMkZ1bml0ZWRfc3RhdGVzX2NhcGl0b2xfMjY3NTcwMjdfNjcxNzA4NDA2MS5qcGclMjIlMEFpbWFnZV8yJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsX2ltYWdlMiUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZXMlMjAlM0QlMjAlNUJpbWFnZTElMkMlMjBpbWFnZTIlNUQlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1hZ2ljLWxlYXAtY29tbXVuaXR5JTJGc3VwZXJnbHVlX291dGRvb3IlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm1hZ2ljLWxlYXAtY29tbXVuaXR5JTJGc3VwZXJnbHVlX291dGRvb3IlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModel
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url_image1 = <span class="hljs-string">&quot;https://raw.githubusercontent.com/magicleap/SuperGluePretrainedNetwork/refs/heads/master/assets/phototourism_sample_images/united_states_capitol_98169888_3347710852.jpg&quot;</span>
image1 = Image.<span class="hljs-built_in">open</span>(requests.get(url_image1, stream=<span class="hljs-literal">True</span>).raw)
url_image2 = <span class="hljs-string">&quot;https://raw.githubusercontent.com/magicleap/SuperGluePretrainedNetwork/refs/heads/master/assets/phototourism_sample_images/united_states_capitol_26757027_6717084061.jpg&quot;</span>
image_2 = Image.<span class="hljs-built_in">open</span>(requests.get(url_image2, stream=<span class="hljs-literal">True</span>).raw)

images = [image1, image2]

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superglue_outdoor&quot;</span>)
model = AutoModel.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superglue_outdoor&quot;</span>)

inputs = processor(images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**inputs)`,wrap:!1}}),P=new Ge({props:{code:"aW1hZ2Vfc2l6ZXMlMjAlM0QlMjAlNUIlNUIoaW1hZ2UuaGVpZ2h0JTJDJTIwaW1hZ2Uud2lkdGgpJTIwZm9yJTIwaW1hZ2UlMjBpbiUyMGltYWdlcyU1RCU1RCUwQW91dHB1dHMlMjAlM0QlMjBwcm9jZXNzb3IucG9zdF9wcm9jZXNzX2tleXBvaW50X21hdGNoaW5nKG91dHB1dHMlMkMlMjBpbWFnZV9zaXplcyUyQyUyMHRocmVzaG9sZCUzRDAuMiklMEFmb3IlMjBpJTJDJTIwb3V0cHV0JTIwaW4lMjBlbnVtZXJhdGUob3V0cHV0cyklM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJGb3IlMjB0aGUlMjBpbWFnZSUyMHBhaXIlMjIlMkMlMjBpKSUwQSUyMCUyMCUyMCUyMGZvciUyMGtleXBvaW50MCUyQyUyMGtleXBvaW50MSUyQyUyMG1hdGNoaW5nX3Njb3JlJTIwaW4lMjB6aXAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTVCJTIya2V5cG9pbnRzMCUyMiU1RCUyQyUyMG91dHB1dCU1QiUyMmtleXBvaW50czElMjIlNUQlMkMlMjBvdXRwdXQlNUIlMjJtYXRjaGluZ19zY29yZXMlMjIlNUQlMEElMjAlMjAlMjAlMjApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMktleXBvaW50JTIwYXQlMjBjb29yZGluYXRlJTIwJTdCa2V5cG9pbnQwLm51bXB5KCklN0QlMjBpbiUyMHRoZSUyMGZpcnN0JTIwaW1hZ2UlMjBtYXRjaGVzJTIwd2l0aCUyMGtleXBvaW50JTIwYXQlMjBjb29yZGluYXRlJTIwJTdCa2V5cG9pbnQxLm51bXB5KCklN0QlMjBpbiUyMHRoZSUyMHNlY29uZCUyMGltYWdlJTIwd2l0aCUyMGElMjBzY29yZSUyMG9mJTIwJTdCbWF0Y2hpbmdfc2NvcmUlN0QuJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQQ==",highlighted:`image_sizes = [[(image.height, image.width) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> images]]
outputs = processor.post_process_keypoint_matching(outputs, image_sizes, threshold=<span class="hljs-number">0.2</span>)
<span class="hljs-keyword">for</span> i, output <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(outputs):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;For the image pair&quot;</span>, i)
    <span class="hljs-keyword">for</span> keypoint0, keypoint1, matching_score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(
            output[<span class="hljs-string">&quot;keypoints0&quot;</span>], output[<span class="hljs-string">&quot;keypoints1&quot;</span>], output[<span class="hljs-string">&quot;matching_scores&quot;</span>]
    ):
        <span class="hljs-built_in">print</span>(
            <span class="hljs-string">f&quot;Keypoint at coordinate <span class="hljs-subst">{keypoint0.numpy()}</span> in the first image matches with keypoint at coordinate <span class="hljs-subst">{keypoint1.numpy()}</span> in the second image with a score of <span class="hljs-subst">{matching_score}</span>.&quot;</span>
        )
`,wrap:!1}}),A=new Ge({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-comment"># Create side by side image</span>
merged_image = np.zeros((<span class="hljs-built_in">max</span>(image1.height, image2.height), image1.width + image2.width, <span class="hljs-number">3</span>))
merged_image[: image1.height, : image1.width] = np.array(image1) / <span class="hljs-number">255.0</span>
merged_image[: image2.height, image1.width :] = np.array(image2) / <span class="hljs-number">255.0</span>
plt.imshow(merged_image)
plt.axis(<span class="hljs-string">&quot;off&quot;</span>)

<span class="hljs-comment"># Retrieve the keypoints and matches</span>
output = outputs[<span class="hljs-number">0</span>]
keypoints0 = output[<span class="hljs-string">&quot;keypoints0&quot;</span>]
keypoints1 = output[<span class="hljs-string">&quot;keypoints1&quot;</span>]
matching_scores = output[<span class="hljs-string">&quot;matching_scores&quot;</span>]
keypoints0_x, keypoints0_y = keypoints0[:, <span class="hljs-number">0</span>].numpy(), keypoints0[:, <span class="hljs-number">1</span>].numpy()
keypoints1_x, keypoints1_y = keypoints1[:, <span class="hljs-number">0</span>].numpy(), keypoints1[:, <span class="hljs-number">1</span>].numpy()

<span class="hljs-comment"># Plot the matches</span>
<span class="hljs-keyword">for</span> keypoint0_x, keypoint0_y, keypoint1_x, keypoint1_y, matching_score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(
        keypoints0_x, keypoints0_y, keypoints1_x, keypoints1_y, matching_scores
):
    plt.plot(
        [keypoint0_x, keypoint1_x + image1.width],
        [keypoint0_y, keypoint1_y],
        color=plt.get_cmap(<span class="hljs-string">&quot;RdYlGn&quot;</span>)(matching_score.item()),
        alpha=<span class="hljs-number">0.9</span>,
        linewidth=<span class="hljs-number">0.5</span>,
    )
    plt.scatter(keypoint0_x, keypoint0_y, c=<span class="hljs-string">&quot;black&quot;</span>, s=<span class="hljs-number">2</span>)
    plt.scatter(keypoint1_x + image1.width, keypoint1_y, c=<span class="hljs-string">&quot;black&quot;</span>, s=<span class="hljs-number">2</span>)

<span class="hljs-comment"># Save the plot</span>
plt.savefig(<span class="hljs-string">&quot;matched_image.png&quot;</span>, dpi=<span class="hljs-number">300</span>, bbox_inches=<span class="hljs-string">&#x27;tight&#x27;</span>)
plt.close()`,wrap:!1}}),ee=new je({props:{title:"SuperGlueConfig",local:"transformers.SuperGlueConfig",headingTag:"h2"}}),te=new he({props:{name:"class transformers.SuperGlueConfig",anchor:"transformers.SuperGlueConfig",parameters:[{name:"keypoint_detector_config",val:": SuperPointConfig = None"},{name:"hidden_size",val:": int = 256"},{name:"keypoint_encoder_sizes",val:": typing.Optional[typing.List[int]] = None"},{name:"gnn_layers_types",val:": typing.Optional[typing.List[str]] = None"},{name:"num_attention_heads",val:": int = 4"},{name:"sinkhorn_iterations",val:": int = 100"},{name:"matching_threshold",val:": float = 0.0"},{name:"initializer_range",val:": float = 0.02"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperGlueConfig.keypoint_detector_config",description:`<strong>keypoint_detector_config</strong> (<code>Union[AutoConfig, dict]</code>,  <em>optional</em>, defaults to <code>SuperPointConfig</code>) &#x2014;
The config object or dictionary of the keypoint detector.`,name:"keypoint_detector_config"},{anchor:"transformers.SuperGlueConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The dimension of the descriptors.`,name:"hidden_size"},{anchor:"transformers.SuperGlueConfig.keypoint_encoder_sizes",description:`<strong>keypoint_encoder_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[32, 64, 128, 256]</code>) &#x2014;
The sizes of the keypoint encoder layers.`,name:"keypoint_encoder_sizes"},{anchor:"transformers.SuperGlueConfig.gnn_layers_types",description:`<strong>gnn_layers_types</strong> (<code>List[str]</code>, <em>optional</em>, defaults to <code>[&apos;self&apos;, &apos;cross&apos;, &apos;self&apos;, &apos;cross&apos;, &apos;self&apos;, &apos;cross&apos;, &apos;self&apos;, &apos;cross&apos;, &apos;self&apos;, &apos;cross&apos;, &apos;self&apos;, &apos;cross&apos;, &apos;self&apos;, &apos;cross&apos;, &apos;self&apos;, &apos;cross&apos;, &apos;self&apos;, &apos;cross&apos;]</code>) &#x2014;
The types of the GNN layers. Must be either &#x2018;self&#x2019; or &#x2018;cross&#x2019;.`,name:"gnn_layers_types"},{anchor:"transformers.SuperGlueConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of heads in the GNN layers.`,name:"num_attention_heads"},{anchor:"transformers.SuperGlueConfig.sinkhorn_iterations",description:`<strong>sinkhorn_iterations</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of Sinkhorn iterations.`,name:"sinkhorn_iterations"},{anchor:"transformers.SuperGlueConfig.matching_threshold",description:`<strong>matching_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The matching threshold.`,name:"matching_threshold"},{anchor:"transformers.SuperGlueConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superglue/configuration_superglue.py#L27"}}),z=new Xt({props:{anchor:"transformers.SuperGlueConfig.example",$$slots:{default:[Pt]},$$scope:{ctx:S}}}),oe=new je({props:{title:"SuperGlueImageProcessor",local:"transformers.SuperGlueImageProcessor",headingTag:"h2"}}),se=new he({props:{name:"class transformers.SuperGlueImageProcessor",anchor:"transformers.SuperGlueImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"do_grayscale",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperGlueImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden
by <code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.SuperGlueImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 480, &quot;width&quot;: 640}</code>):
Resolution of the output image after <code>resize</code> is applied. Only has an effect if <code>do_resize</code> is set to
<code>True</code>. Can be overridden by <code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.SuperGlueImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.SuperGlueImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.SuperGlueImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.SuperGlueImageProcessor.do_grayscale",description:`<strong>do_grayscale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to grayscale. Can be overridden by <code>do_grayscale</code> in the <code>preprocess</code> method.`,name:"do_grayscale"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superglue/image_processing_superglue.py#L135"}}),ne=new he({props:{name:"post_process_keypoint_matching",anchor:"transformers.SuperGlueImageProcessor.post_process_keypoint_matching",parameters:[{name:"outputs",val:": KeypointMatchingOutput"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple]]"},{name:"threshold",val:": float = 0.0"}],parametersDescription:[{anchor:"transformers.SuperGlueImageProcessor.post_process_keypoint_matching.outputs",description:`<strong>outputs</strong> (<code>KeypointMatchingOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.SuperGlueImageProcessor.post_process_keypoint_matching.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[Tuple[int, int]]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2, 2)</code> or list of tuples of tuples (<code>Tuple[int, int]</code>) containing the
target size <code>(height, width)</code> of each image in the batch. This must be the original image size (before
any processing).`,name:"target_sizes"},{anchor:"transformers.SuperGlueImageProcessor.post_process_keypoint_matching.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Threshold to filter out the matches with low scores.`,name:"threshold"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superglue/image_processing_superglue.py#L340",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the keypoints in the first and second image
of the pair, the matching scores and the matching indices.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),ae=new he({props:{name:"preprocess",anchor:"transformers.SuperGlueImageProcessor.preprocess",parameters:[{name:"images",val:""},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_grayscale",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[transformers.utils.generic.TensorType, str, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperGlueImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image pairs to preprocess. Expects either a list of 2 images or a list of list of 2 images list with
pixel values ranging from 0 to 255. If passing in images with pixel values between 0 and 1, set
<code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.SuperGlueImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.SuperGlueImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the output image after <code>resize</code> has been applied. If <code>size[&quot;shortest_edge&quot;]</code> &gt;= 384, the image
is resized to <code>(size[&quot;shortest_edge&quot;], size[&quot;shortest_edge&quot;])</code>. Otherwise, the smaller edge of the
image will be matched to <code>int(size[&quot;shortest_edge&quot;]/ crop_pct)</code>, after which the image is cropped to
<code>(size[&quot;shortest_edge&quot;], size[&quot;shortest_edge&quot;])</code>. Only has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"size"},{anchor:"transformers.SuperGlueImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of <code>PILImageResampling</code>, filters. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.SuperGlueImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.SuperGlueImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.SuperGlueImageProcessor.preprocess.do_grayscale",description:`<strong>do_grayscale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_grayscale</code>) &#x2014;
Whether to convert the image to grayscale.`,name:"do_grayscale"},{anchor:"transformers.SuperGlueImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.SuperGlueImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.SuperGlueImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superglue/image_processing_superglue.py#L222"}}),re=new he({props:{name:"resize",anchor:"transformers.SuperGlueImageProcessor.resize",parameters:[{name:"image",val:": ndarray"},{name:"size",val:": typing.Dict[str, int]"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperGlueImageProcessor.resize.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to resize.`,name:"image"},{anchor:"transformers.SuperGlueImageProcessor.resize.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>) &#x2014;
Dictionary of the form <code>{&quot;height&quot;: int, &quot;width&quot;: int}</code>, specifying the size of the output image.`,name:"size"},{anchor:"transformers.SuperGlueImageProcessor.resize.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the output image. If not provided, it will be inferred from the input
image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.SuperGlueImageProcessor.resize.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superglue/image_processing_superglue.py#L183"}}),ie=new je({props:{title:"SuperGlueForKeypointMatching",local:"transformers.SuperGlueForKeypointMatching",headingTag:"h2"}}),ce=new he({props:{name:"class transformers.SuperGlueForKeypointMatching",anchor:"transformers.SuperGlueForKeypointMatching",parameters:[{name:"config",val:": SuperGlueConfig"}],parametersDescription:[{anchor:"transformers.SuperGlueForKeypointMatching.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/superglue#transformers.SuperGlueConfig">SuperGlueConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superglue/modeling_superglue.py#L565"}}),pe=new he({props:{name:"forward",anchor:"transformers.SuperGlueForKeypointMatching.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SuperGlueForKeypointMatching.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.SuperGlueForKeypointMatching.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.SuperGlueForKeypointMatching.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SuperGlueForKeypointMatching.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SuperGlueForKeypointMatching.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superglue/modeling_superglue.py#L747",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.superglue.modeling_superglue.KeypointMatchingOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/superglue#transformers.SuperGlueConfig"
>SuperGlueConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>) — Loss computed during training.</li>
<li><strong>mask</strong> (<code>torch.IntTensor</code> of shape <code>(batch_size, num_keypoints)</code>) — Mask indicating which values in matches and matching_scores are keypoint matching information.</li>
<li><strong>matches</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2, num_matches)</code>) — Index of keypoint matched in the other image.</li>
<li><strong>matching_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2, num_matches)</code>) — Scores of predicted matches.</li>
<li><strong>keypoints</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_keypoints, 2)</code>) — Absolute (x, y) coordinates of predicted keypoints in a given image.</li>
<li><strong>hidden_states</strong> (<code>Tuple[torch.FloatTensor, ...]</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for the output of each stage) of shape <code>(batch_size, 2, num_channels, num_keypoints)</code>, returned when <code>output_hidden_states=True</code> is passed or when
<code>config.output_hidden_states=True</code>)</li>
<li><strong>attentions</strong> (<code>Tuple[torch.FloatTensor, ...]</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, 2, num_heads, num_keypoints, num_keypoints)</code>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>)</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.superglue.modeling_superglue.KeypointMatchingOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),W=new Yt({props:{$$slots:{default:[Dt]},$$scope:{ctx:S}}}),N=new Xt({props:{anchor:"transformers.SuperGlueForKeypointMatching.forward.example",$$slots:{default:[At]},$$scope:{ctx:S}}}),me=new Lt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/superglue.md"}}),{c(){c=r("meta"),U=n(),T=r("p"),m=n(),u(b.$$.fragment),i=n(),w=r("div"),w.innerHTML=Tt,ve=n(),u(V.$$.fragment),Ce=n(),X=r("p"),X.innerHTML=bt,ke=n(),H=r("p"),H.innerHTML=wt,Ze=n(),F=r("p"),F.textContent=_t,Se=n(),Q=r("p"),Q.innerHTML=Jt,ze=n(),u(E.$$.fragment),$e=n(),q=r("p"),q.textContent=Ut,xe=n(),u(Y.$$.fragment),Be=n(),L=r("p"),L.innerHTML=jt,We=n(),u(P.$$.fragment),Ne=n(),D=r("p"),D.textContent=It,Re=n(),u(A.$$.fragment),Ve=n(),K=r("p"),K.innerHTML=Gt,Xe=n(),O=r("p"),O.innerHTML=vt,He=n(),u(ee.$$.fragment),Fe=n(),j=r("div"),u(te.$$.fragment),tt=n(),ge=r("p"),ge.innerHTML=Ct,ot=n(),fe=r("p"),fe.innerHTML=kt,st=n(),u(z.$$.fragment),Qe=n(),u(oe.$$.fragment),Ee=n(),_=r("div"),u(se.$$.fragment),nt=n(),ye=r("p"),ye.textContent=Zt,at=n(),$=r("div"),u(ne.$$.fragment),rt=n(),Me=r("p"),Me.innerHTML=St,lt=n(),x=r("div"),u(ae.$$.fragment),it=n(),Te=r("p"),Te.textContent=zt,ct=n(),B=r("div"),u(re.$$.fragment),pt=n(),be=r("p"),be.textContent=$t,qe=n(),le=r("ul"),le.innerHTML=xt,Ye=n(),u(ie.$$.fragment),Le=n(),J=r("div"),u(ce.$$.fragment),dt=n(),we=r("p"),we.textContent=Bt,mt=n(),_e=r("p"),_e.innerHTML=Wt,ut=n(),Je=r("p"),Je.innerHTML=Nt,ht=n(),G=r("div"),u(pe.$$.fragment),gt=n(),Ue=r("p"),Ue.innerHTML=Rt,ft=n(),u(W.$$.fragment),yt=n(),u(N.$$.fragment),Pe=n(),de=r("ul"),de.innerHTML=Vt,De=n(),u(me.$$.fragment),Ae=n(),Ie=r("p"),this.h()},l(e){const t=qt("svelte-u9bgzb",document.head);c=l(t,"META",{name:!0,content:!0}),t.forEach(o),U=a(e),T=l(e,"P",{}),Z(T).forEach(o),m=a(e),h(b.$$.fragment,e),i=a(e),w=l(e,"DIV",{class:!0,"data-svelte-h":!0}),d(w)!=="svelte-13t8s2t"&&(w.innerHTML=Tt),ve=a(e),h(V.$$.fragment,e),Ce=a(e),X=l(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-jnhrty"&&(X.innerHTML=bt),ke=a(e),H=l(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-11zlwci"&&(H.innerHTML=wt),Ze=a(e),F=l(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-vfdo9a"&&(F.textContent=_t),Se=a(e),Q=l(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1hznpl7"&&(Q.innerHTML=Jt),ze=a(e),h(E.$$.fragment,e),$e=a(e),q=l(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-88y6pj"&&(q.textContent=Ut),xe=a(e),h(Y.$$.fragment,e),Be=a(e),L=l(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-o9bw9u"&&(L.innerHTML=jt),We=a(e),h(P.$$.fragment,e),Ne=a(e),D=l(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-v9owge"&&(D.textContent=It),Re=a(e),h(A.$$.fragment,e),Ve=a(e),K=l(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1pvnv97"&&(K.innerHTML=Gt),Xe=a(e),O=l(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-1plbgli"&&(O.innerHTML=vt),He=a(e),h(ee.$$.fragment,e),Fe=a(e),j=l(e,"DIV",{class:!0});var v=Z(j);h(te.$$.fragment,v),tt=a(v),ge=l(v,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-mrmg6g"&&(ge.innerHTML=Ct),ot=a(v),fe=l(v,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-o55m63"&&(fe.innerHTML=kt),st=a(v),h(z.$$.fragment,v),v.forEach(o),Qe=a(e),h(oe.$$.fragment,e),Ee=a(e),_=l(e,"DIV",{class:!0});var I=Z(_);h(se.$$.fragment,I),nt=a(I),ye=l(I,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-2i9uog"&&(ye.textContent=Zt),at=a(I),$=l(I,"DIV",{class:!0});var ue=Z($);h(ne.$$.fragment,ue),rt=a(ue),Me=l(ue,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-y19agd"&&(Me.innerHTML=St),ue.forEach(o),lt=a(I),x=l(I,"DIV",{class:!0});var Oe=Z(x);h(ae.$$.fragment,Oe),it=a(Oe),Te=l(Oe,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-1x3yxsa"&&(Te.textContent=zt),Oe.forEach(o),ct=a(I),B=l(I,"DIV",{class:!0});var et=Z(B);h(re.$$.fragment,et),pt=a(et),be=l(et,"P",{"data-svelte-h":!0}),d(be)!=="svelte-1eb2h1k"&&(be.textContent=$t),et.forEach(o),I.forEach(o),qe=a(e),le=l(e,"UL",{"data-svelte-h":!0}),d(le)!=="svelte-j0c82d"&&(le.innerHTML=xt),Ye=a(e),h(ie.$$.fragment,e),Le=a(e),J=l(e,"DIV",{class:!0});var C=Z(J);h(ce.$$.fragment,C),dt=a(C),we=l(C,"P",{"data-svelte-h":!0}),d(we)!=="svelte-td3ten"&&(we.textContent=Bt),mt=a(C),_e=l(C,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-6pahdo"&&(_e.innerHTML=Wt),ut=a(C),Je=l(C,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-hswkmf"&&(Je.innerHTML=Nt),ht=a(C),G=l(C,"DIV",{class:!0});var R=Z(G);h(pe.$$.fragment,R),gt=a(R),Ue=l(R,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-18va01n"&&(Ue.innerHTML=Rt),ft=a(R),h(W.$$.fragment,R),yt=a(R),h(N.$$.fragment,R),R.forEach(o),C.forEach(o),Pe=a(e),de=l(e,"UL",{"data-svelte-h":!0}),d(de)!=="svelte-mdsibh"&&(de.innerHTML=Vt),De=a(e),h(me.$$.fragment,e),Ae=a(e),Ie=l(e,"P",{}),Z(Ie).forEach(o),this.h()},h(){k(c,"name","hf:doc:metadata"),k(c,"content",Ot),k(w,"class","flex flex-wrap space-x-1"),k(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){p(document.head,c),s(e,U,t),s(e,T,t),s(e,m,t),g(b,e,t),s(e,i,t),s(e,w,t),s(e,ve,t),g(V,e,t),s(e,Ce,t),s(e,X,t),s(e,ke,t),s(e,H,t),s(e,Ze,t),s(e,F,t),s(e,Se,t),s(e,Q,t),s(e,ze,t),g(E,e,t),s(e,$e,t),s(e,q,t),s(e,xe,t),g(Y,e,t),s(e,Be,t),s(e,L,t),s(e,We,t),g(P,e,t),s(e,Ne,t),s(e,D,t),s(e,Re,t),g(A,e,t),s(e,Ve,t),s(e,K,t),s(e,Xe,t),s(e,O,t),s(e,He,t),g(ee,e,t),s(e,Fe,t),s(e,j,t),g(te,j,null),p(j,tt),p(j,ge),p(j,ot),p(j,fe),p(j,st),g(z,j,null),s(e,Qe,t),g(oe,e,t),s(e,Ee,t),s(e,_,t),g(se,_,null),p(_,nt),p(_,ye),p(_,at),p(_,$),g(ne,$,null),p($,rt),p($,Me),p(_,lt),p(_,x),g(ae,x,null),p(x,it),p(x,Te),p(_,ct),p(_,B),g(re,B,null),p(B,pt),p(B,be),s(e,qe,t),s(e,le,t),s(e,Ye,t),g(ie,e,t),s(e,Le,t),s(e,J,t),g(ce,J,null),p(J,dt),p(J,we),p(J,mt),p(J,_e),p(J,ut),p(J,Je),p(J,ht),p(J,G),g(pe,G,null),p(G,gt),p(G,Ue),p(G,ft),g(W,G,null),p(G,yt),g(N,G,null),s(e,Pe,t),s(e,de,t),s(e,De,t),g(me,e,t),s(e,Ae,t),s(e,Ie,t),Ke=!0},p(e,[t]){const v={};t&2&&(v.$$scope={dirty:t,ctx:e}),z.$set(v);const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),W.$set(I);const ue={};t&2&&(ue.$$scope={dirty:t,ctx:e}),N.$set(ue)},i(e){Ke||(f(b.$$.fragment,e),f(V.$$.fragment,e),f(E.$$.fragment,e),f(Y.$$.fragment,e),f(P.$$.fragment,e),f(A.$$.fragment,e),f(ee.$$.fragment,e),f(te.$$.fragment,e),f(z.$$.fragment,e),f(oe.$$.fragment,e),f(se.$$.fragment,e),f(ne.$$.fragment,e),f(ae.$$.fragment,e),f(re.$$.fragment,e),f(ie.$$.fragment,e),f(ce.$$.fragment,e),f(pe.$$.fragment,e),f(W.$$.fragment,e),f(N.$$.fragment,e),f(me.$$.fragment,e),Ke=!0)},o(e){y(b.$$.fragment,e),y(V.$$.fragment,e),y(E.$$.fragment,e),y(Y.$$.fragment,e),y(P.$$.fragment,e),y(A.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(z.$$.fragment,e),y(oe.$$.fragment,e),y(se.$$.fragment,e),y(ne.$$.fragment,e),y(ae.$$.fragment,e),y(re.$$.fragment,e),y(ie.$$.fragment,e),y(ce.$$.fragment,e),y(pe.$$.fragment,e),y(W.$$.fragment,e),y(N.$$.fragment,e),y(me.$$.fragment,e),Ke=!1},d(e){e&&(o(U),o(T),o(m),o(i),o(w),o(ve),o(Ce),o(X),o(ke),o(H),o(Ze),o(F),o(Se),o(Q),o(ze),o($e),o(q),o(xe),o(Be),o(L),o(We),o(Ne),o(D),o(Re),o(Ve),o(K),o(Xe),o(O),o(He),o(Fe),o(j),o(Qe),o(Ee),o(_),o(qe),o(le),o(Ye),o(Le),o(J),o(Pe),o(de),o(De),o(Ae),o(Ie)),o(c),M(b,e),M(V,e),M(E,e),M(Y,e),M(P,e),M(A,e),M(ee,e),M(te),M(z),M(oe,e),M(se),M(ne),M(ae),M(re),M(ie,e),M(ce),M(pe),M(W),M(N),M(me,e)}}}const Ot='{"title":"SuperGlue","local":"superglue","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"How to use","local":"how-to-use","sections":[],"depth":2},{"title":"SuperGlueConfig","local":"transformers.SuperGlueConfig","sections":[],"depth":2},{"title":"SuperGlueImageProcessor","local":"transformers.SuperGlueImageProcessor","sections":[],"depth":2},{"title":"SuperGlueForKeypointMatching","local":"transformers.SuperGlueForKeypointMatching","sections":[],"depth":2}],"depth":1}';function eo(S){return Ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class co extends Qt{constructor(c){super(),Et(this,c,eo,Kt,Ht,{})}}export{co as component};
