import{s as Ul,n as hl,o as Il}from"../chunks/scheduler.18a86fab.js";import{S as fl,i as jl,g as a,s as n,r as c,A as gl,h as i,f as l,c as o,j as ge,u as d,x as r,k as Jl,y as T,a as s,v as M,d as y,t as p,w as u}from"../chunks/index.98837b22.js";import{C as I}from"../chunks/CodeBlock.8d0c2e8a.js";import{H as w}from"../chunks/Heading.7e7e0c5b.js";import{E as Cl}from"../chunks/index.92f616ba.js";function bl(qt){let h,Ge,Ce,_e,j,Be,g,Ft="The <code>@auto_docstring</code> decorator in the Hugging Face Transformers library helps generate docstrings for model classes and their methods, which will be used to build the documentation for the library. It aims to improve consistency and reduce boilerplate by automatically including standard argument descriptions and allowing for targeted overrides and additions.",ve,Ze,Ae,C,$e,b,St="The <code>@auto_docstring</code> decorator constructs docstrings by:",ke,G,xt="<li><strong>Signature Inspection:</strong> It inspects the signature (arguments, types, defaults) of the decorated class’s <code>__init__</code> method or the decorated function.</li> <li><strong>Centralized Docstring Fetching:</strong> It retrieves predefined docstrings for common arguments (e.g., <code>input_ids</code>, <code>attention_mask</code>) from internal library sources (like <code>ModelArgs</code> or <code>ImageProcessorArgs</code> in <code>utils/args_doc.py</code>).</li> <li><strong>Overriding or Adding Arguments Descriptions:</strong><ul><li><strong>Direct Docstring Block:</strong> It incorporates custom docstring content from an <code>r&quot;&quot;&quot; &quot;&quot;&quot;</code> (or <code>&quot;&quot;&quot; &quot;&quot;&quot;</code>) block below the method signature or within the <code>__init__</code> docstring. This is for documenting new arguments or overriding standard descriptions.</li> <li><strong>Decorator Arguments (<code>custom_args</code>):</strong> A <code>custom_args</code> docstring block can be passed to the decorator to provide docstrings for specific arguments directly in the decorator call. This can be used to define the docstring block for new arguments once if they are repeated in multiple places in the modeling file.</li></ul></li> <li><strong>Adding Classes and Functions Introduction:</strong><ul><li><strong><code>custom_intro</code> argument:</strong> Allows prepending a custom introductory paragraph to a class or function docstring.</li> <li><strong>Automatic Introduction Generation:</strong> For model classes with standard naming patterns (like <code>ModelForCausalLM</code>) or belonging to a pipeline, the decorator automatically generates an appropriate introductory paragraph using <code>ClassDocstring</code> in <code>utils/args_doc.py</code> as the source.</li></ul></li> <li><strong>Templating:</strong> The decorator uses a templating system, allowing predefined docstrings to include dynamic information deduced from the <code>auto_modules</code> of the library, such as <code>{{processor_class}}</code> or <code>{{config_class}}</code>.</li> <li><strong>Deducing Relevant Examples:</strong> The decorator attempts to find appropriate usage examples based on the model’s task or pipeline compatibility. It extracts checkpoint information from the model’s configuration class to provide concrete examples with real model identifiers.</li> <li><strong>Adding Return Value Documentation:</strong> For methods like <code>forward</code>, the decorator can automatically generate the “Returns” section based on the method’s return type annotation. For example, for a method returning a <code>ModelOutput</code> subclass, it will extracts field descriptions from that class’s docstring to create a comprehensive return value description. A custom <code>Returns</code> section can also be manually specified in the function docstring block.</li> <li><strong>Unrolling Kwargs Typed With Unpack Operator:</strong> For specific methods (defined in <code>UNROLL_KWARGS_METHODS</code>) or classes (defined in <code>UNROLL_KWARGS_CLASSES</code>), the decorator processes <code>**kwargs</code> parameters that are typed with <code>Unpack[KwargsTypedDict]</code>. It extracts the documentation from the TypedDict and adds each parameter to the function’s docstring. Currently, this functionality is only supported for <code>FastImageProcessorKwargs</code>.</li>",We,Re,Ne,_,Ve,B,Xe,v,zt="Import the decorator into your modeling file:",He,Z,Ye,A,Ee,$,Lt="Place <code>@auto_docstring</code> directly above the class definition. It uses the <code>__init__</code> method’s signature and its docstring for parameter descriptions.",qe,k,Fe,W,Se,R,Qt="Arguments can be passed directly to <code>@auto_docstring</code> for more control:",xe,N,ze,V,Dt="Or:",Le,X,Qe,H,De,Y,Ot="Apply the decorator above method definitions, such as the <code>forward</code> method.",Oe,E,Pe,q,Ke,F,Pt="Arguments can be passed directly to <code>@auto_docstring</code> for more control. <code>Returns</code> and <code>Examples</code> sections can also be manually specified:",et,S,tt,lt,st,x,nt,J,Te,Kt="<p><strong>Standard Arguments (e.g., <code>input_ids</code>, <code>attention_mask</code>, <code>pixel_values</code>, <code>encoder_hidden_states</code> etc.):</strong></p> <ul><li><code>@auto_docstring</code> retrieves descriptions from a central source. Do not redefine these locally if their description and shape are the same as in <code>args_doc.py</code>.</li></ul>",kt,z,we,el="<strong>New or Custom Arguments:</strong>",Wt,m,me,tl="<strong>Primary Method:</strong> Document these within an <code>r&quot;&quot;&quot; &quot;&quot;&quot;</code> docstring block following the signature (for functions) or in the <code>__init__</code> method’s docstring (for class parameters).",Rt,L,Je,ll="Format:",Nt,Q,Vt,Ue,sl="Include <code>type</code> in backticks.",Xt,he,nl="Add ”<em>optional</em>” if the argument is not required (has a default value).",Ht,Ie,ol="Add “defaults to <code>X</code>” if it has a default value (no need to specify “defaults to <code>None</code>” if the default value is <code>None</code>).",Yt,fe,al="<p><strong>Overriding Standard Arguments:</strong></p> <ul><li>If a standard argument behaves differently (e.g., different expected shape, model-specific behavior), provide its complete description in the local <code>r&quot;&quot;&quot; &quot;&quot;&quot;</code> docstring. This local definition takes precedence.</li> <li>The <code>labels</code> argument is often customized per model and typically requires a specific docstring.</li></ul>",Et,je,il="<p><strong>Using Decorator Arguments for Overrides or New Arguments (<code>custom_args</code>):</strong></p> <ul><li>New or custom arguments docstrings can also be passed to <code>@auto_docstring</code> as a <code>custom_args</code> argument. This can be used to define the docstring block for new arguments once if they are repeated in multiple places in the modeling file.</li></ul>",ot,at,it,D,rt,O,rl="When working with modular files, follow these guidelines for applying the <code>@auto_docstring</code> decorator:",ct,P,cl=`<li><p><strong>For standalone models in modular files:</strong>
Apply the <code>@auto_docstring</code> decorator just as you would in regular modeling files.</p></li> <li><p><strong>For models inheriting from other library models:</strong></p> <ul><li>When inheriting from a parent model, decorators (including <code>@auto_docstring</code>) are automatically carried over to the generated modeling file without needing to add them in your modular file.</li> <li>If you need to modify the <code>@auto_docstring</code> behavior, apply the customized decorator in your modular file, making sure to <em>include all other decorators</em> that were present on the original function/class.</li></ul> <blockquote><p><strong>Warning</strong>: When overriding any decorator in a modular file, you must include ALL decorators that were applied to that function/class in the parent model. If you only override some decorators, the others won’t be included in the generated modeling file.</p></blockquote></li>`,dt,K,dl="<strong>Note</strong>: The <code>check_auto_docstrings</code> tool doesn’t check modular files directly, but it will check (and modify when using <code>--fix_and_overwrite</code>) the generated modeling files. If issues are found in the generated files, you’ll need to update your modular files accordingly.",Mt,yt,pt,ee,ut,te,Ml="The library includes a utility script to validate docstrings. This check is typically run during Continuous Integration (CI).",Tt,le,wt,se,yl="<li><strong>Decorator Presence:</strong> Ensures <code>@auto_docstring</code> is applied to relevant model classes and public methods. (TODO)</li> <li><strong>Argument Completeness &amp; Consistency:</strong><ul><li>Flags arguments in the signature that are not known standard arguments and lack a local description.</li> <li>Ensures documented arguments exist in the signature. (TODO)</li> <li>Verifies that types and default values in the docstring match the signature. (TODO)</li></ul></li> <li><strong>Placeholder Detection:</strong> Reminds you to complete placeholders like <code>&lt;fill_type&gt;</code> or <code>&lt;fill_docstring&gt;</code>.</li> <li><strong>Formatting:</strong> Adherence to the expected docstring style.</li>",mt,ne,Jt,oe,pl="Run this check locally before committing. The common command is:",Ut,ae,ht,ie,ul="Alternatively, to only perform docstrings and auto-docstring checks, you can use:",It,re,ft,ce,jt,de,Tl="<li>Add <code>@auto_docstring(...)</code> to the class or method.</li> <li>For new, custom, or overridden arguments, add descriptions in an <code>r&quot;&quot;&quot; &quot;&quot;&quot;</code> block.</li> <li>Run <code>make fix-copies</code> (or the <code>check_docstrings.py</code> utility).<ul><li>For unrecognized arguments lacking documentation, the utility will create placeholder entries.</li></ul></li> <li>Manually edit these placeholders with accurate types and descriptions.</li> <li>Re-run the check to ensure all issues are resolved.</li>",gt,Ct,bt,Me,Gt,ye,wl="<li>Use <code>@auto_docstring</code> for new PyTorch model classes (<code>PreTrainedModel</code> subclasses) and their primary for methods (e.g., <code>forward</code>, <code>get_text_features</code> etc.).</li> <li>For classes, the <code>__init__</code> method’s docstring is the main source for parameter descriptions when using <code>@auto_docstring</code> on the class.</li> <li>Rely on standard docstrings; do not redefine common arguments unless their behavior is different in your specific model.</li> <li>Document new or custom arguments clearly.</li> <li>Run <code>check_docstrings</code> locally and iteratively.</li>",_t,pe,ml="By following these guidelines, you help maintain consistent and informative documentation for the Hugging Face Transformers library 🤗.",Bt,ue,vt,be,Zt;return j=new w({props:{title:"Utilizing the @auto_docstring Decorator",local:"utilizing-the-autodocstring-decorator",headingTag:"h1"}}),C=new w({props:{title:"📜 How it Works",local:"-how-it-works",headingTag:"h2"}}),_=new w({props:{title:"🚀 How to Use @auto_docstring",local:"-how-to-use-autodocstring",headingTag:"h2"}}),B=new w({props:{title:"1. Importing the Decorator",local:"1-importing-the-decorator",headingTag:"h3"}}),Z=new I({props:{code:"ZnJvbSUyMC4uLnV0aWxzJTIwaW1wb3J0JTIwYXV0b19kb2NzdHJpbmc=",highlighted:'<span class="hljs-keyword">from</span> ...utils <span class="hljs-keyword">import</span> auto_docstring',wrap:!1}}),A=new w({props:{title:"2. Applying to Classes",local:"2-applying-to-classes",headingTag:"h3"}}),k=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbGluZ191dGlscyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjAuLi51dGlscyUyMGltcG9ydCUyMGF1dG9fZG9jc3RyaW5nJTBBJTBBJTQwYXV0b19kb2NzdHJpbmclMEFjbGFzcyUyME15QXdlc29tZU1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnJTJDJTIwY3VzdG9tX3BhcmFtZXRlciUzQSUyMGludCUyMCUzRCUyMDEwJTJDJTIwYW5vdGhlcl9jdXN0b21fYXJnJTNBJTIwc3RyJTIwJTNEJTIwJTIyZGVmYXVsdCUyMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY3VzdG9tX3BhcmFtZXRlciUyMCglNjBpbnQlNjAlMkMlMjAqb3B0aW9uYWwqJTJDJTIwZGVmYXVsdHMlMjB0byUyMDEwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMERlc2NyaXB0aW9uJTIwb2YlMjB0aGUlMjBjdXN0b21fcGFyYW1ldGVyJTIwZm9yJTIwTXlBd2Vzb21lTW9kZWwuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYW5vdGhlcl9jdXN0b21fYXJnJTIwKCU2MHN0ciU2MCUyQyUyMCpvcHRpb25hbColMkMlMjBkZWZhdWx0cyUyMHRvJTIwJTIyZGVmYXVsdCUyMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBEb2N1bWVudGF0aW9uJTIwZm9yJTIwYW5vdGhlciUyMHVuaXF1ZSUyMGFyZ3VtZW50LiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY3VzdG9tX3BhcmFtZXRlciUyMCUzRCUyMGN1c3RvbV9wYXJhbWV0ZXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmFub3RoZXJfY3VzdG9tX2FyZyUyMCUzRCUyMGFub3RoZXJfY3VzdG9tX2FyZyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMC4uLiUyMHJlc3QlMjBvZiUyMHlvdXIlMjBpbml0JTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwLi4uJTIwb3RoZXIlMjBtZXRob2Rz",highlighted:`<span class="hljs-keyword">from</span> transformers.modeling_utils <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> ...utils <span class="hljs-keyword">import</span> auto_docstring

<span class="hljs-meta">@auto_docstring</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyAwesomeModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config, custom_parameter: <span class="hljs-built_in">int</span> = <span class="hljs-number">10</span>, another_custom_arg: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;default&quot;</span></span>):
        <span class="hljs-string">r&quot;&quot;&quot;
        custom_parameter (\`int\`, *optional*, defaults to 10):
            Description of the custom_parameter for MyAwesomeModel.
        another_custom_arg (\`str\`, *optional*, defaults to &quot;default&quot;):
            Documentation for another unique argument.
        &quot;&quot;&quot;</span>
        <span class="hljs-built_in">super</span>().__init__(config)
        self.custom_parameter = custom_parameter
        self.another_custom_arg = another_custom_arg
        <span class="hljs-comment"># ... rest of your init</span>

    <span class="hljs-comment"># ... other methods</span>`,wrap:!1}}),W=new w({props:{title:"Advanced Class Decoration:",local:"advanced-class-decoration",headingTag:"h4"}}),N=new I({props:{code:"JTQwYXV0b19kb2NzdHJpbmcoJTBBJTIwJTIwJTIwJTIwY3VzdG9tX2ludHJvJTNEJTIyJTIyJTIyVGhpcyUyMG1vZGVsJTIwcGVyZm9ybXMlMjBzcGVjaWZpYyUyMHN5bmVyZ2lzdGljJTIwb3BlcmF0aW9ucy4lMEElMjAlMjAlMjAlMjBJdCUyMGJ1aWxkcyUyMHVwb24lMjB0aGUlMjBzdGFuZGFyZCUyMFRyYW5zZm9ybWVyJTIwYXJjaGl0ZWN0dXJlJTIwd2l0aCUyMHVuaXF1ZSUyMG1vZGlmaWNhdGlvbnMuJTIyJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX2FyZ3MlM0QlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBjdXN0b21fcGFyYW1ldGVyJTIwKCU2MHR5cGUlNjAlMkMlMjAqb3B0aW9uYWwqJTJDJTIwZGVmYXVsdHMlMjB0byUyMCU2MGRlZmF1bHRfdmFsdWUlNjApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQSUyMGNvbmNpc2UlMjBkZXNjcmlwdGlvbiUyMGZvciUyMGN1c3RvbV9wYXJhbWV0ZXIlMjBpZiUyMG5vdCUyMGRlZmluZWQlMjBvciUyMG92ZXJyaWRpbmclMjB0aGUlMjBkZXNjcmlwdGlvbiUyMGluJTIwJTYwYXJnc19kb2MucHklNjAuJTBBJTIwJTIwJTIwJTIwaW50ZXJuYWxfaGVscGVyX2FyZyUyMCglNjB0eXBlJTYwJTJDJTIwKm9wdGlvbmFsKiUyQyUyMGRlZmF1bHRzJTIwdG8lMjAlNjBkZWZhdWx0X3ZhbHVlJTYwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEElMjBjb25jaXNlJTIwZGVzY3JpcHRpb24lMjBmb3IlMjBpbnRlcm5hbF9oZWxwZXJfYXJnJTIwaWYlMjBub3QlMjBkZWZpbmVkJTIwb3IlMjBvdmVycmlkaW5nJTIwdGhlJTIwZGVzY3JpcHRpb24lMjBpbiUyMCU2MGFyZ3NfZG9jLnB5JTYwLiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSklMEFjbGFzcyUyME15U3BlY2lhbE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnJTNBJTIwQ29uZmlnVHlwZSUyQyUyMGN1c3RvbV9wYXJhbWV0ZXIlM0ElMjAlMjJ0eXBlJTIyJTIwJTNEJTIwJTIyZGVmYXVsdF92YWx1ZSUyMiUyQyUyMGludGVybmFsX2hlbHBlcl9hcmclM0ROb25lKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMC4uLg==",highlighted:'<span class="hljs-meta">@auto_docstring(<span class="hljs-params">\n    custom_intro=<span class="hljs-string">&quot;&quot;&quot;This model performs specific synergistic operations.\n    It builds upon the standard Transformer architecture with unique modifications.&quot;&quot;&quot;</span>,\n    custom_args=<span class="hljs-string">&quot;&quot;&quot;\n    custom_parameter (`type`, *optional*, defaults to `default_value`):\n        A concise description for custom_parameter if not defined or overriding the description in `args_doc.py`.\n    internal_helper_arg (`type`, *optional*, defaults to `default_value`):\n        A concise description for internal_helper_arg if not defined or overriding the description in `args_doc.py`.\n    &quot;&quot;&quot;</span>\n</span>)</span>\n<span class="hljs-keyword">class</span> <span class="hljs-title class_">MySpecialModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):\n    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: ConfigType, custom_parameter: <span class="hljs-string">&quot;type&quot;</span> = <span class="hljs-string">&quot;default_value&quot;</span>, internal_helper_arg=<span class="hljs-literal">None</span></span>):\n        <span class="hljs-comment"># ...</span>',wrap:!1}}),X=new I({props:{code:"JTQwYXV0b19kb2NzdHJpbmcoJTBBJTIwJTIwJTIwJTIwY3VzdG9tX2ludHJvJTNEJTIyJTIyJTIyVGhpcyUyMG1vZGVsJTIwcGVyZm9ybXMlMjBzcGVjaWZpYyUyMHN5bmVyZ2lzdGljJTIwb3BlcmF0aW9ucy4lMEElMjAlMjAlMjAlMjBJdCUyMGJ1aWxkcyUyMHVwb24lMjB0aGUlMjBzdGFuZGFyZCUyMFRyYW5zZm9ybWVyJTIwYXJjaGl0ZWN0dXJlJTIwd2l0aCUyMHVuaXF1ZSUyMG1vZGlmaWNhdGlvbnMuJTIyJTIyJTIyJTJDJTBBKSUwQWNsYXNzJTIwTXlTcGVjaWFsTW9kZWwoUHJlVHJhaW5lZE1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBjb25maWclM0ElMjBDb25maWdUeXBlJTJDJTIwY3VzdG9tX3BhcmFtZXRlciUzQSUyMCUyMnR5cGUlMjIlMjAlM0QlMjAlMjJkZWZhdWx0X3ZhbHVlJTIyJTJDJTIwaW50ZXJuYWxfaGVscGVyX2FyZyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwciUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGN1c3RvbV9wYXJhbWV0ZXIlMjAoJTYwdHlwZSU2MCUyQyUyMCpvcHRpb25hbColMkMlMjBkZWZhdWx0cyUyMHRvJTIwJTYwZGVmYXVsdF92YWx1ZSU2MCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBBJTIwY29uY2lzZSUyMGRlc2NyaXB0aW9uJTIwZm9yJTIwY3VzdG9tX3BhcmFtZXRlciUyMGlmJTIwbm90JTIwZGVmaW5lZCUyMG9yJTIwb3ZlcnJpZGluZyUyMHRoZSUyMGRlc2NyaXB0aW9uJTIwaW4lMjAlNjBhcmdzX2RvYy5weSU2MC4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnRlcm5hbF9oZWxwZXJfYXJnJTIwKCU2MHR5cGUlNjAlMkMlMjAqb3B0aW9uYWwqJTJDJTIwZGVmYXVsdHMlMjB0byUyMCU2MGRlZmF1bHRfdmFsdWUlNjApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQSUyMGNvbmNpc2UlMjBkZXNjcmlwdGlvbiUyMGZvciUyMGludGVybmFsX2hlbHBlcl9hcmclMjBpZiUyMG5vdCUyMGRlZmluZWQlMjBvciUyMG92ZXJyaWRpbmclMjB0aGUlMjBkZXNjcmlwdGlvbiUyMGluJTIwJTYwYXJnc19kb2MucHklNjAuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwLi4u",highlighted:'<span class="hljs-meta">@auto_docstring(<span class="hljs-params">\n    custom_intro=<span class="hljs-string">&quot;&quot;&quot;This model performs specific synergistic operations.\n    It builds upon the standard Transformer architecture with unique modifications.&quot;&quot;&quot;</span>,\n</span>)</span>\n<span class="hljs-keyword">class</span> <span class="hljs-title class_">MySpecialModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):\n    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: ConfigType, custom_parameter: <span class="hljs-string">&quot;type&quot;</span> = <span class="hljs-string">&quot;default_value&quot;</span>, internal_helper_arg=<span class="hljs-literal">None</span></span>):\n        <span class="hljs-string">r&quot;&quot;&quot;\n        custom_parameter (`type`, *optional*, defaults to `default_value`):\n            A concise description for custom_parameter if not defined or overriding the description in `args_doc.py`.\n        internal_helper_arg (`type`, *optional*, defaults to `default_value`):\n            A concise description for internal_helper_arg if not defined or overriding the description in `args_doc.py`.\n        &quot;&quot;&quot;</span>\n        <span class="hljs-comment"># ...</span>',wrap:!1}}),H=new w({props:{title:"3. Applying to Functions (e.g., forward method)",local:"3-applying-to-functions-eg-forward-method",headingTag:"h3"}}),E=new I({props:{code:"JTIwJTIwJTIwJTIwJTQwYXV0b19kb2NzdHJpbmclMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dF9pZHMlM0ElMjBPcHRpb25hbCU1QnRvcmNoLlRlbnNvciU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdHRlbnRpb25fbWFzayUzQSUyME9wdGlvbmFsJTVCdG9yY2guVGVuc29yJTVEJTIwJTNEJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5ld19jdXN0b21fYXJndW1lbnQlM0ElMjBPcHRpb25hbCU1QnRvcmNoLlRlbnNvciU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmdfZG9jdW1lbnRlZF9pbl9hcmdzX2RvYyUzQSUyME9wdGlvbmFsJTVCdG9yY2guVGVuc29yJTVEJTIwJTNEJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMC4uLiUyMG90aGVyJTIwYXJndW1lbnRzJTBBJTIwJTIwJTIwJTIwKSUyMC0lM0UlMjBVbmlvbiU1QlR1cGxlJTJDJTIwTW9kZWxPdXRwdXQlNUQlM0ElMjAlMjMlMjBUaGUlMjBkZXNjcmlwdGlvbiUyMG9mJTIwdGhlJTIwcmV0dXJuJTIwdmFsdWUlMjB3aWxsJTIwYXV0b21hdGljYWxseSUyMGJlJTIwZ2VuZXJhdGVkJTIwZnJvbSUyMHRoZSUyME1vZGVsT3V0cHV0JTIwY2xhc3MlMjBkb2NzdHJpbmcuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwciUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5ld19jdXN0b21fYXJndW1lbnQlMjAoJTYwdG9yY2guVGVuc29yJTYwJTJDJTIwKm9wdGlvbmFsKiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBEZXNjcmlwdGlvbiUyMG9mJTIwdGhpcyUyMG5ldyUyMGN1c3RvbSUyMGFyZ3VtZW50JTIwYW5kJTIwaXRzJTIwZXhwZWN0ZWQlMjBzaGFwZSUyMG9yJTIwdHlwZS4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAuLi4=",highlighted:`<span class="hljs-meta">    @auto_docstring</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">
        self,
        input_ids: <span class="hljs-type">Optional</span>[torch.Tensor] = <span class="hljs-literal">None</span>,
        attention_mask: <span class="hljs-type">Optional</span>[torch.Tensor] = <span class="hljs-literal">None</span>,
        new_custom_argument: <span class="hljs-type">Optional</span>[torch.Tensor] = <span class="hljs-literal">None</span>,
        arg_documented_in_args_doc: <span class="hljs-type">Optional</span>[torch.Tensor] = <span class="hljs-literal">None</span>,
        <span class="hljs-comment"># ... other arguments</span>
    </span>) -&gt; <span class="hljs-type">Union</span>[<span class="hljs-type">Tuple</span>, ModelOutput]: <span class="hljs-comment"># The description of the return value will automatically be generated from the ModelOutput class docstring.</span>
        <span class="hljs-string">r&quot;&quot;&quot;
        new_custom_argument (\`torch.Tensor\`, *optional*):
            Description of this new custom argument and its expected shape or type.
        &quot;&quot;&quot;</span>
        <span class="hljs-comment"># ...</span>`,wrap:!1}}),q=new w({props:{title:"Advanced Function Decoration:",local:"advanced-function-decoration",headingTag:"h4"}}),S=new I({props:{code:"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",highlighted:`MODEL_COMMON_CUSTOM_ARGS = <span class="hljs-string">r&quot;&quot;&quot;
    common_arg_1 (\`torch.Tensor\`, *optional*, defaults to \`default_value\`):
        Description of common_arg_1
    common_arg_2 (\`torch.Tensor\`, *optional*, defaults to \`default_value\`):
        Description of common_arg_2
    ...
&quot;&quot;&quot;</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    <span class="hljs-comment"># ...</span>
<span class="hljs-meta">    @auto_docstring(<span class="hljs-params">
        custom_intro=<span class="hljs-string">&quot;&quot;&quot;
        This is a custom introduction for the function.
        &quot;&quot;&quot;</span>
        custom_args=MODEL_COMMON_CUSTOM_ARGS
    </span>)</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">
        self,
        input_ids: <span class="hljs-type">Optional</span>[torch.Tensor] = <span class="hljs-literal">None</span>,
        attention_mask: <span class="hljs-type">Optional</span>[torch.Tensor] = <span class="hljs-literal">None</span>,
        common_arg_1: <span class="hljs-type">Optional</span>[torch.Tensor] = <span class="hljs-literal">None</span>,
        common_arg_2: <span class="hljs-type">Optional</span>[torch.Tensor] = <span class="hljs-literal">None</span>,
        <span class="hljs-comment">#...</span>
        function_specific_argument: <span class="hljs-type">Optional</span>[torch.Tensor] = <span class="hljs-literal">None</span>,
        <span class="hljs-comment"># ... other arguments</span>
    </span>) -&gt; torch.Tensor:
        <span class="hljs-string">r&quot;&quot;&quot;
        function_specific_argument (\`torch.Tensor\`, *optional*):
            Description of an argument specific to this function

        Returns:
            \`torch.Tensor\`: For a function returning a generic type, a custom &quot;Returns&quot; section can be specified.

        Example:

        (To override the default example with a custom one or to add an example for a model class that does not have a pipeline)

        \`\`\`python
        ...
        \`\`\`
        &quot;&quot;&quot;</span>
        <span class="hljs-comment"># ...</span>`,wrap:!1}}),x=new w({props:{title:"✍️ Documenting Arguments: Approach & Priority",local:"-documenting-arguments-approach--priority",headingTag:"h3"}}),Q=new I({props:{code:"YXJndW1lbnRfbmFtZSUyMCglNjB0eXBlJTYwJTJDJTIwKm9wdGlvbmFsKiUyQyUyMGRlZmF1bHRzJTIwdG8lMjAlNjBYJTYwKSUzQSUwQSUyMCUyMCUyMCUyMERlc2NyaXB0aW9uJTIwb2YlMjB0aGUlMjBhcmd1bWVudC4lMEElMjAlMjAlMjAlMjBFeHBsYWluJTIwaXRzJTIwcHVycG9zZSUyQyUyMGV4cGVjdGVkJTIwc2hhcGUlMkZ0eXBlJTIwaWYlMjBjb21wbGV4JTJDJTIwYW5kJTIwZGVmYXVsdCUyMGJlaGF2aW9yLiUwQSUyMCUyMCUyMCUyMFRoaXMlMjBjYW4lMjBzcGFuJTIwbXVsdGlwbGUlMjBsaW5lcy4=",highlighted:'argument_name (`<span class="hljs-keyword">type</span>`, *<span class="hljs-keyword">optional</span>*, defaults to `X`):\n    Description of the argument.\n    Explain its purpose, expected <span class="hljs-built_in">shape</span>/<span class="hljs-keyword">type</span> <span class="hljs-keyword">if</span> <span class="hljs-keyword">complex</span>, and <span class="hljs-keyword">default</span> behavior.\n    This can span multiple lines.',wrap:!1}}),D=new w({props:{title:"Usage with modular files",local:"usage-with-modular-files",headingTag:"h3"}}),ee=new w({props:{title:"✅ Checking Your Docstrings with check_auto_docstrings",local:"-checking-your-docstrings-with-checkautodocstrings",headingTag:"h2"}}),le=new w({props:{title:"What it Checks:",local:"what-it-checks",headingTag:"h4"}}),ne=new w({props:{title:"Running the Check Locally:",local:"running-the-check-locally",headingTag:"h4"}}),ae=new I({props:{code:"bWFrZSUyMGZpeC1jb3BpZXM=",highlighted:"make fix-copies",wrap:!1}}),re=new I({props:{code:"cHl0aG9uJTIwdXRpbHMlMkZjaGVja19kb2NzdHJpbmdzLnB5JTIwJTIzJTIwdG8lMjBvbmx5JTIwY2hlY2slMjBmaWxlcyUyMGluY2x1ZGVkJTIwaW4lMjB0aGUlMjBkaWZmJTIwd2l0aG91dCUyMGZpeGluZyUyMHRoZW0lMEElMjMlMjBPciUzQSUyMHB5dGhvbiUyMHV0aWxzJTJGY2hlY2tfZG9jc3RyaW5ncy5weSUyMC0tZml4X2FuZF9vdmVyd3JpdGUlMjAlMjMlMjB0byUyMGZpeCUyMGFuZCUyMG92ZXJ3cml0ZSUyMHRoZSUyMGZpbGVzJTIwaW4lMjB0aGUlMjBkaWZmJTBBJTIzJTIwT3IlM0ElMjBweXRob24lMjB1dGlscyUyRmNoZWNrX2RvY3N0cmluZ3MucHklMjAtLWZpeF9hbmRfb3ZlcndyaXRlJTIwLS1jaGVja19hbGwlMjAlMjMlMjB0byUyMGZpeCUyMGFuZCUyMG92ZXJ3cml0ZSUyMGFsbCUyMGZpbGVz",highlighted:`python utils/check_docstrings.py <span class="hljs-comment"># to only check files included in the diff without fixing them</span>
<span class="hljs-comment"># Or: python utils/check_docstrings.py --fix_and_overwrite # to fix and overwrite the files in the diff</span>
<span class="hljs-comment"># Or: python utils/check_docstrings.py --fix_and_overwrite --check_all # to fix and overwrite all files</span>`,wrap:!1}}),ce=new w({props:{title:"Workflow with the Checker:",local:"workflow-with-the-checker",headingTag:"h4"}}),Me=new w({props:{title:"🔑 Key Takeaways & Best Practices",local:"-key-takeaways--best-practices",headingTag:"h2"}}),ue=new Cl({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/auto_docstring.md"}}),{c(){h=a("meta"),Ge=n(),Ce=a("p"),_e=n(),c(j.$$.fragment),Be=n(),g=a("p"),g.innerHTML=Ft,ve=n(),Ze=a("hr"),Ae=n(),c(C.$$.fragment),$e=n(),b=a("p"),b.innerHTML=St,ke=n(),G=a("ol"),G.innerHTML=xt,We=n(),Re=a("hr"),Ne=n(),c(_.$$.fragment),Ve=n(),c(B.$$.fragment),Xe=n(),v=a("p"),v.textContent=zt,He=n(),c(Z.$$.fragment),Ye=n(),c(A.$$.fragment),Ee=n(),$=a("p"),$.innerHTML=Lt,qe=n(),c(k.$$.fragment),Fe=n(),c(W.$$.fragment),Se=n(),R=a("p"),R.innerHTML=Qt,xe=n(),c(N.$$.fragment),ze=n(),V=a("p"),V.textContent=Dt,Le=n(),c(X.$$.fragment),Qe=n(),c(H.$$.fragment),De=n(),Y=a("p"),Y.innerHTML=Ot,Oe=n(),c(E.$$.fragment),Pe=n(),c(q.$$.fragment),Ke=n(),F=a("p"),F.innerHTML=Pt,et=n(),c(S.$$.fragment),tt=n(),lt=a("hr"),st=n(),c(x.$$.fragment),nt=n(),J=a("ol"),Te=a("li"),Te.innerHTML=Kt,kt=n(),z=a("li"),we=a("p"),we.innerHTML=el,Wt=n(),m=a("ul"),me=a("li"),me.innerHTML=tl,Rt=n(),L=a("li"),Je=a("strong"),Je.textContent=ll,Nt=n(),c(Q.$$.fragment),Vt=n(),Ue=a("li"),Ue.innerHTML=sl,Xt=n(),he=a("li"),he.innerHTML=nl,Ht=n(),Ie=a("li"),Ie.innerHTML=ol,Yt=n(),fe=a("li"),fe.innerHTML=al,Et=n(),je=a("li"),je.innerHTML=il,ot=n(),at=a("hr"),it=n(),c(D.$$.fragment),rt=n(),O=a("p"),O.innerHTML=rl,ct=n(),P=a("ul"),P.innerHTML=cl,dt=n(),K=a("p"),K.innerHTML=dl,Mt=n(),yt=a("hr"),pt=n(),c(ee.$$.fragment),ut=n(),te=a("p"),te.textContent=Ml,Tt=n(),c(le.$$.fragment),wt=n(),se=a("ul"),se.innerHTML=yl,mt=n(),c(ne.$$.fragment),Jt=n(),oe=a("p"),oe.textContent=pl,Ut=n(),c(ae.$$.fragment),ht=n(),ie=a("p"),ie.textContent=ul,It=n(),c(re.$$.fragment),ft=n(),c(ce.$$.fragment),jt=n(),de=a("ol"),de.innerHTML=Tl,gt=n(),Ct=a("hr"),bt=n(),c(Me.$$.fragment),Gt=n(),ye=a("ul"),ye.innerHTML=wl,_t=n(),pe=a("p"),pe.textContent=ml,Bt=n(),c(ue.$$.fragment),vt=n(),be=a("p"),this.h()},l(e){const t=gl("svelte-u9bgzb",document.head);h=i(t,"META",{name:!0,content:!0}),t.forEach(l),Ge=o(e),Ce=i(e,"P",{}),ge(Ce).forEach(l),_e=o(e),d(j.$$.fragment,e),Be=o(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-mixa6j"&&(g.innerHTML=Ft),ve=o(e),Ze=i(e,"HR",{}),Ae=o(e),d(C.$$.fragment,e),$e=o(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-vcfy5j"&&(b.innerHTML=St),ke=o(e),G=i(e,"OL",{"data-svelte-h":!0}),r(G)!=="svelte-175ptf6"&&(G.innerHTML=xt),We=o(e),Re=i(e,"HR",{}),Ne=o(e),d(_.$$.fragment,e),Ve=o(e),d(B.$$.fragment,e),Xe=o(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1jrbh9"&&(v.textContent=zt),He=o(e),d(Z.$$.fragment,e),Ye=o(e),d(A.$$.fragment,e),Ee=o(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-20l4qb"&&($.innerHTML=Lt),qe=o(e),d(k.$$.fragment,e),Fe=o(e),d(W.$$.fragment,e),Se=o(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-r4fq0z"&&(R.innerHTML=Qt),xe=o(e),d(N.$$.fragment,e),ze=o(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-ylaoa1"&&(V.textContent=Dt),Le=o(e),d(X.$$.fragment,e),Qe=o(e),d(H.$$.fragment,e),De=o(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-c49u9v"&&(Y.innerHTML=Ot),Oe=o(e),d(E.$$.fragment,e),Pe=o(e),d(q.$$.fragment,e),Ke=o(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-hvsrt3"&&(F.innerHTML=Pt),et=o(e),d(S.$$.fragment,e),tt=o(e),lt=i(e,"HR",{}),st=o(e),d(x.$$.fragment,e),nt=o(e),J=i(e,"OL",{});var f=ge(J);Te=i(f,"LI",{"data-svelte-h":!0}),r(Te)!=="svelte-1jgy54"&&(Te.innerHTML=Kt),kt=o(f),z=i(f,"LI",{});var At=ge(z);we=i(At,"P",{"data-svelte-h":!0}),r(we)!=="svelte-8l3gg5"&&(we.innerHTML=el),Wt=o(At),m=i(At,"UL",{});var U=ge(m);me=i(U,"LI",{"data-svelte-h":!0}),r(me)!=="svelte-1ycw8n4"&&(me.innerHTML=tl),Rt=o(U),L=i(U,"LI",{});var $t=ge(L);Je=i($t,"STRONG",{"data-svelte-h":!0}),r(Je)!=="svelte-vq6kzj"&&(Je.textContent=ll),Nt=o($t),d(Q.$$.fragment,$t),$t.forEach(l),Vt=o(U),Ue=i(U,"LI",{"data-svelte-h":!0}),r(Ue)!=="svelte-1t85uof"&&(Ue.innerHTML=sl),Xt=o(U),he=i(U,"LI",{"data-svelte-h":!0}),r(he)!=="svelte-18gzer1"&&(he.innerHTML=nl),Ht=o(U),Ie=i(U,"LI",{"data-svelte-h":!0}),r(Ie)!=="svelte-1wldxbh"&&(Ie.innerHTML=ol),U.forEach(l),At.forEach(l),Yt=o(f),fe=i(f,"LI",{"data-svelte-h":!0}),r(fe)!=="svelte-1orfzte"&&(fe.innerHTML=al),Et=o(f),je=i(f,"LI",{"data-svelte-h":!0}),r(je)!=="svelte-zt0tyc"&&(je.innerHTML=il),f.forEach(l),ot=o(e),at=i(e,"HR",{}),it=o(e),d(D.$$.fragment,e),rt=o(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1d7d3u2"&&(O.innerHTML=rl),ct=o(e),P=i(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-c8sfx3"&&(P.innerHTML=cl),dt=o(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-x6bk1f"&&(K.innerHTML=dl),Mt=o(e),yt=i(e,"HR",{}),pt=o(e),d(ee.$$.fragment,e),ut=o(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1v8yllt"&&(te.textContent=Ml),Tt=o(e),d(le.$$.fragment,e),wt=o(e),se=i(e,"UL",{"data-svelte-h":!0}),r(se)!=="svelte-9qw9xo"&&(se.innerHTML=yl),mt=o(e),d(ne.$$.fragment,e),Jt=o(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1id251m"&&(oe.textContent=pl),Ut=o(e),d(ae.$$.fragment,e),ht=o(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-yb812z"&&(ie.textContent=ul),It=o(e),d(re.$$.fragment,e),ft=o(e),d(ce.$$.fragment,e),jt=o(e),de=i(e,"OL",{"data-svelte-h":!0}),r(de)!=="svelte-1utagb5"&&(de.innerHTML=Tl),gt=o(e),Ct=i(e,"HR",{}),bt=o(e),d(Me.$$.fragment,e),Gt=o(e),ye=i(e,"UL",{"data-svelte-h":!0}),r(ye)!=="svelte-z3kb16"&&(ye.innerHTML=wl),_t=o(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-d0a6b0"&&(pe.textContent=ml),Bt=o(e),d(ue.$$.fragment,e),vt=o(e),be=i(e,"P",{}),ge(be).forEach(l),this.h()},h(){Jl(h,"name","hf:doc:metadata"),Jl(h,"content",Gl)},m(e,t){T(document.head,h),s(e,Ge,t),s(e,Ce,t),s(e,_e,t),M(j,e,t),s(e,Be,t),s(e,g,t),s(e,ve,t),s(e,Ze,t),s(e,Ae,t),M(C,e,t),s(e,$e,t),s(e,b,t),s(e,ke,t),s(e,G,t),s(e,We,t),s(e,Re,t),s(e,Ne,t),M(_,e,t),s(e,Ve,t),M(B,e,t),s(e,Xe,t),s(e,v,t),s(e,He,t),M(Z,e,t),s(e,Ye,t),M(A,e,t),s(e,Ee,t),s(e,$,t),s(e,qe,t),M(k,e,t),s(e,Fe,t),M(W,e,t),s(e,Se,t),s(e,R,t),s(e,xe,t),M(N,e,t),s(e,ze,t),s(e,V,t),s(e,Le,t),M(X,e,t),s(e,Qe,t),M(H,e,t),s(e,De,t),s(e,Y,t),s(e,Oe,t),M(E,e,t),s(e,Pe,t),M(q,e,t),s(e,Ke,t),s(e,F,t),s(e,et,t),M(S,e,t),s(e,tt,t),s(e,lt,t),s(e,st,t),M(x,e,t),s(e,nt,t),s(e,J,t),T(J,Te),T(J,kt),T(J,z),T(z,we),T(z,Wt),T(z,m),T(m,me),T(m,Rt),T(m,L),T(L,Je),T(L,Nt),M(Q,L,null),T(m,Vt),T(m,Ue),T(m,Xt),T(m,he),T(m,Ht),T(m,Ie),T(J,Yt),T(J,fe),T(J,Et),T(J,je),s(e,ot,t),s(e,at,t),s(e,it,t),M(D,e,t),s(e,rt,t),s(e,O,t),s(e,ct,t),s(e,P,t),s(e,dt,t),s(e,K,t),s(e,Mt,t),s(e,yt,t),s(e,pt,t),M(ee,e,t),s(e,ut,t),s(e,te,t),s(e,Tt,t),M(le,e,t),s(e,wt,t),s(e,se,t),s(e,mt,t),M(ne,e,t),s(e,Jt,t),s(e,oe,t),s(e,Ut,t),M(ae,e,t),s(e,ht,t),s(e,ie,t),s(e,It,t),M(re,e,t),s(e,ft,t),M(ce,e,t),s(e,jt,t),s(e,de,t),s(e,gt,t),s(e,Ct,t),s(e,bt,t),M(Me,e,t),s(e,Gt,t),s(e,ye,t),s(e,_t,t),s(e,pe,t),s(e,Bt,t),M(ue,e,t),s(e,vt,t),s(e,be,t),Zt=!0},p:hl,i(e){Zt||(y(j.$$.fragment,e),y(C.$$.fragment,e),y(_.$$.fragment,e),y(B.$$.fragment,e),y(Z.$$.fragment,e),y(A.$$.fragment,e),y(k.$$.fragment,e),y(W.$$.fragment,e),y(N.$$.fragment,e),y(X.$$.fragment,e),y(H.$$.fragment,e),y(E.$$.fragment,e),y(q.$$.fragment,e),y(S.$$.fragment,e),y(x.$$.fragment,e),y(Q.$$.fragment,e),y(D.$$.fragment,e),y(ee.$$.fragment,e),y(le.$$.fragment,e),y(ne.$$.fragment,e),y(ae.$$.fragment,e),y(re.$$.fragment,e),y(ce.$$.fragment,e),y(Me.$$.fragment,e),y(ue.$$.fragment,e),Zt=!0)},o(e){p(j.$$.fragment,e),p(C.$$.fragment,e),p(_.$$.fragment,e),p(B.$$.fragment,e),p(Z.$$.fragment,e),p(A.$$.fragment,e),p(k.$$.fragment,e),p(W.$$.fragment,e),p(N.$$.fragment,e),p(X.$$.fragment,e),p(H.$$.fragment,e),p(E.$$.fragment,e),p(q.$$.fragment,e),p(S.$$.fragment,e),p(x.$$.fragment,e),p(Q.$$.fragment,e),p(D.$$.fragment,e),p(ee.$$.fragment,e),p(le.$$.fragment,e),p(ne.$$.fragment,e),p(ae.$$.fragment,e),p(re.$$.fragment,e),p(ce.$$.fragment,e),p(Me.$$.fragment,e),p(ue.$$.fragment,e),Zt=!1},d(e){e&&(l(Ge),l(Ce),l(_e),l(Be),l(g),l(ve),l(Ze),l(Ae),l($e),l(b),l(ke),l(G),l(We),l(Re),l(Ne),l(Ve),l(Xe),l(v),l(He),l(Ye),l(Ee),l($),l(qe),l(Fe),l(Se),l(R),l(xe),l(ze),l(V),l(Le),l(Qe),l(De),l(Y),l(Oe),l(Pe),l(Ke),l(F),l(et),l(tt),l(lt),l(st),l(nt),l(J),l(ot),l(at),l(it),l(rt),l(O),l(ct),l(P),l(dt),l(K),l(Mt),l(yt),l(pt),l(ut),l(te),l(Tt),l(wt),l(se),l(mt),l(Jt),l(oe),l(Ut),l(ht),l(ie),l(It),l(ft),l(jt),l(de),l(gt),l(Ct),l(bt),l(Gt),l(ye),l(_t),l(pe),l(Bt),l(vt),l(be)),l(h),u(j,e),u(C,e),u(_,e),u(B,e),u(Z,e),u(A,e),u(k,e),u(W,e),u(N,e),u(X,e),u(H,e),u(E,e),u(q,e),u(S,e),u(x,e),u(Q),u(D,e),u(ee,e),u(le,e),u(ne,e),u(ae,e),u(re,e),u(ce,e),u(Me,e),u(ue,e)}}}const Gl='{"title":"Utilizing the @auto_docstring Decorator","local":"utilizing-the-autodocstring-decorator","sections":[{"title":"📜 How it Works","local":"-how-it-works","sections":[],"depth":2},{"title":"🚀 How to Use @auto_docstring","local":"-how-to-use-autodocstring","sections":[{"title":"1. Importing the Decorator","local":"1-importing-the-decorator","sections":[],"depth":3},{"title":"2. Applying to Classes","local":"2-applying-to-classes","sections":[{"title":"Advanced Class Decoration:","local":"advanced-class-decoration","sections":[],"depth":4}],"depth":3},{"title":"3. Applying to Functions (e.g., forward method)","local":"3-applying-to-functions-eg-forward-method","sections":[{"title":"Advanced Function Decoration:","local":"advanced-function-decoration","sections":[],"depth":4}],"depth":3},{"title":"✍️ Documenting Arguments: Approach & Priority","local":"-documenting-arguments-approach--priority","sections":[],"depth":3},{"title":"Usage with modular files","local":"usage-with-modular-files","sections":[],"depth":3}],"depth":2},{"title":"✅ Checking Your Docstrings with check_auto_docstrings","local":"-checking-your-docstrings-with-checkautodocstrings","sections":[{"title":"What it Checks:","local":"what-it-checks","sections":[],"depth":4},{"title":"Running the Check Locally:","local":"running-the-check-locally","sections":[],"depth":4},{"title":"Workflow with the Checker:","local":"workflow-with-the-checker","sections":[],"depth":4}],"depth":2},{"title":"🔑 Key Takeaways & Best Practices","local":"-key-takeaways--best-practices","sections":[],"depth":2}],"depth":1}';function _l(qt){return Il(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kl extends fl{constructor(h){super(),jl(this,h,_l,bl,Ul,{})}}export{kl as component};
