import{s as T_,o as y_,n as $}from"../chunks/scheduler.9991993c.js";import{S as b_,i as x_,g as r,s,r as g,A as w_,h as i,f as l,c as a,j as U,u as f,x as d,k,y as n,a as m,v as u,d as T,t as y,w as b,m as __,n as M_}from"../chunks/index.ed60ef0f.js";import{T as Sc}from"../chunks/Tip.8eaeb7b5.js";import{D as j}from"../chunks/Docstring.222cf92b.js";import{C as v}from"../chunks/CodeBlock.d4c22193.js";import{E as P}from"../chunks/ExampleCodeBlock.78277022.js";import{H as J,E as U_}from"../chunks/index.5b62b65b.js";function k_(M){let o;return{c(){o=__("While there are such optional arguments as `tokenizer`, `feature_extractor`, `image_processor`, and `processor`,\nthey shouldn't be specified all at once. If these components are not provided, `pipeline` will try to load\nrequired ones automatically. In case you want to provide these components explicitly, please refer to a\nspecific pipeline in order to get more details regarding what components are required.")},l(_){o=M_(_,"While there are such optional arguments as `tokenizer`, `feature_extractor`, `image_processor`, and `processor`,\nthey shouldn't be specified all at once. If these components are not provided, `pipeline` will try to load\nrequired ones automatically. In case you want to provide these components explicitly, please refer to a\nspecific pipeline in order to get more details regarding what components are required.")},m(_,h){m(_,o,h)},d(_){_&&l(o)}}}function j_(M){let o,_="Examples:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTJDJTIwQXV0b01vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUyQyUyMEF1dG9Ub2tlbml6ZXIlMEElMEElMjMlMjBTZW50aW1lbnQlMjBhbmFseXNpcyUyMHBpcGVsaW5lJTBBYW5hbHl6ZXIlMjAlM0QlMjBwaXBlbGluZSglMjJzZW50aW1lbnQtYW5hbHlzaXMlMjIpJTBBJTBBJTIzJTIwUXVlc3Rpb24lMjBhbnN3ZXJpbmclMjBwaXBlbGluZSUyQyUyMHNwZWNpZnlpbmclMjB0aGUlMjBjaGVja3BvaW50JTIwaWRlbnRpZmllciUwQW9yYWNsZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMnF1ZXN0aW9uLWFuc3dlcmluZyUyMiUyQyUyMG1vZGVsJTNEJTIyZGlzdGlsYmVydCUyRmRpc3RpbGJlcnQtYmFzZS1jYXNlZC1kaXN0aWxsZWQtc3F1YWQlMjIlMkMlMjB0b2tlbml6ZXIlM0QlMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUwQSklMEElMEElMjMlMjBOYW1lZCUyMGVudGl0eSUyMHJlY29nbml0aW9uJTIwcGlwZWxpbmUlMkMlMjBwYXNzaW5nJTIwaW4lMjBhJTIwc3BlY2lmaWMlMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZGJtZHolMkZiZXJ0LWxhcmdlLWNhc2VkLWZpbmV0dW5lZC1jb25sbDAzLWVuZ2xpc2glMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBcmVjb2duaXplciUyMCUzRCUyMHBpcGVsaW5lKCUyMm5lciUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline, AutoModelForTokenClassification, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Sentiment analysis pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>analyzer = pipeline(<span class="hljs-string">&quot;sentiment-analysis&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Question answering pipeline, specifying the checkpoint identifier</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>oracle = pipeline(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;question-answering&quot;</span>, model=<span class="hljs-string">&quot;distilbert/distilbert-base-cased-distilled-squad&quot;</span>, tokenizer=<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Named entity recognition pipeline, passing in a specific model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;dbmdz/bert-large-cased-finetuned-conll03-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>recognizer = pipeline(<span class="hljs-string">&quot;ner&quot;</span>, model=model, tokenizer=tokenizer)`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-kvfsh7"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function v_(M){let o,_="然而，这并不自动意味着性能提升。它可能是一个10倍的加速或5倍的减速，具体取决于硬件、数据和实际使用的模型。",h,p,x="主要是加速的示例：";return{c(){o=r("p"),o.textContent=_,h=s(),p=r("p"),p.textContent=x},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-jbqn8u"&&(o.textContent=_),h=a(t),p=i(t,"P",{"data-svelte-h":!0}),d(p)!=="svelte-yo44t3"&&(p.textContent=x)},m(t,w){m(t,o,w),m(t,h,w),m(t,p,w)},p:$,d(t){t&&(l(o),l(h),l(p))}}}function $_(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyc3VwZXJiJTJGd2F2MnZlYzItYmFzZS1zdXBlcmIta3MlMjIpJTBBY2xhc3NpZmllciglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRjEuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(model=<span class="hljs-string">&quot;superb/wav2vec2-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/1.flac&quot;</span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.997</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;_unknown_&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.002</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;left&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;yes&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;down&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;stop&#x27;</span>}]`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function J_(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItYmFzZSUyMiklMEF0cmFuc2NyaWJlciglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRjEuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/1.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; He hoped there would be stew for dinner, turnips and carrots and bruised potatoes and fat mutton pieces to be ladled out in thick, peppered flour-fatten sauce.&#x27;</span>}`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function P_(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyc3VubyUyRmJhcmstc21hbGwlMjIpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZSglMjJIZXklMjBpdCdzJTIwSHVnZ2luZ0ZhY2UlMjBvbiUyMHRoZSUyMHBob25lISUyMiklMEElMEFhdWRpbyUyMCUzRCUyMG91dHB1dCU1QiUyMmF1ZGlvJTIyJTVEJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMG91dHB1dCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(model=<span class="hljs-string">&quot;suno/bark-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(<span class="hljs-string">&quot;Hey it&#x27;s HuggingFace on the phone!&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>audio = output[<span class="hljs-string">&quot;audio&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = output[<span class="hljs-string">&quot;sampling_rate&quot;</span>]`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function C_(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBbXVzaWNfZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRleHQtdG8tYXVkaW8lMjIlMkMlMjBtb2RlbCUzRCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIlMkMlMjBmcmFtZXdvcmslM0QlMjJwdCUyMiklMEElMEElMjMlMjBkaXZlcnNpZnklMjB0aGUlMjBtdXNpYyUyMGdlbmVyYXRpb24lMjBieSUyMGFkZGluZyUyMHJhbmRvbW5lc3MlMjB3aXRoJTIwYSUyMGhpZ2glMjB0ZW1wZXJhdHVyZSUyMGFuZCUyMHNldCUyMGElMjBtYXhpbXVtJTIwbXVzaWMlMjBsZW5ndGglMEFnZW5lcmF0ZV9rd2FyZ3MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJkb19zYW1wbGUlMjIlM0ElMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIydGVtcGVyYXR1cmUlMjIlM0ElMjAwLjclMkMlMEElMjAlMjAlMjAlMjAlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDM1JTJDJTBBJTdEJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG11c2ljX2dlbmVyYXRvciglMjJUZWNobm8lMjBtdXNpYyUyMHdpdGglMjBoaWdoJTIwbWVsb2RpYyUyMHJpZmZzJTIyJTJDJTIwZ2VuZXJhdGVfa3dhcmdzJTNEZ2VuZXJhdGVfa3dhcmdzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>music_generator = pipeline(task=<span class="hljs-string">&quot;text-to-audio&quot;</span>, model=<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>, framework=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># diversify the music generation by adding randomness with a high temperature and set a maximum music length</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">35</span>,
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = music_generator(<span class="hljs-string">&quot;Techno music with high melodic riffs&quot;</span>, generate_kwargs=generate_kwargs)`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function I_(M){let o,_=`You can specify parameters passed to the model by using <code>TextToAudioPipeline.__call__.forward_params</code> or
<code>TextToAudioPipeline.__call__.generate_kwargs</code>.`,h,p,x;return p=new P({props:{anchor:"transformers.TextToAudioPipeline.example-2",$$slots:{default:[C_]},$$scope:{ctx:M}}}),{c(){o=r("p"),o.innerHTML=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1g6q8re"&&(o.innerHTML=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p(t,w){const Hc={};w&2&&(Hc.$$scope={dirty:w,ctx:t}),p.$set(Hc)},i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function q_(M){let o,_="The default <code>hypothesis_template</code> is : <code>&quot;This is a sound of {}.&quot;</code>. Make sure you update it for your usage.";return{c(){o=r("p"),o.innerHTML=_},l(h){o=i(h,"P",{"data-svelte-h":!0}),d(o)!=="svelte-2d3hnv"&&(o.innerHTML=_)},m(h,p){m(h,o,p)},p:$,d(h){h&&l(o)}}}function z_(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJhc2hyYXElMkZlc2M1MCUyMiklMEFhdWRpbyUyMCUzRCUyMG5leHQoaXRlcihkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlNUIlMjJhdWRpbyUyMiU1RCkpJTVCJTIyYXJyYXklMjIlNUQlMEFjbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnplcm8tc2hvdC1hdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIybGFpb24lMkZjbGFwLWh0c2F0LXVuZnVzZWQlMjIpJTBBY2xhc3NpZmllcihhdWRpbyUyQyUyMGNhbmRpZGF0ZV9sYWJlbHMlM0QlNUIlMjJTb3VuZCUyMG9mJTIwYSUyMGRvZyUyMiUyQyUyMCUyMlNvdW5kJTIwb2YlMjB2YWNjdW0lMjBjbGVhbmVyJTIyJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;ashraq/esc50&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-string">&quot;audio&quot;</span>]))[<span class="hljs-string">&quot;array&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;zero-shot-audio-classification&quot;</span>, model=<span class="hljs-string">&quot;laion/clap-htsat-unfused&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier(audio, candidate_labels=[<span class="hljs-string">&quot;Sound of a dog&quot;</span>, <span class="hljs-string">&quot;Sound of vaccum cleaner&quot;</span>])
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9996</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Sound of a dog&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0004</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Sound of vaccum cleaner&#x27;</span>}]`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function G_(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZGVwdGhfZXN0aW1hdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmRlcHRoLWVzdGltYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMkxpaGVZb3VuZyUyRmRlcHRoLWFueXRoaW5nLWJhc2UtaGYlMjIpJTBBb3V0cHV0JTIwJTNEJTIwZGVwdGhfZXN0aW1hdG9yKCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIpJTBBJTIzJTIwVGhpcyUyMGlzJTIwYSUyMHRlbnNvciUyMHdpdGglMjB0aGUlMjB2YWx1ZXMlMjBiZWluZyUyMHRoZSUyMGRlcHRoJTIwZXhwcmVzc2VkJTIwaW4lMjBtZXRlcnMlMjBmb3IlMjBlYWNoJTIwcGl4ZWwlMEFvdXRwdXQlNUIlMjJwcmVkaWN0ZWRfZGVwdGglMjIlNUQuc2hhcGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>depth_estimator = pipeline(task=<span class="hljs-string">&quot;depth-estimation&quot;</span>, model=<span class="hljs-string">&quot;LiheYoung/depth-anything-base-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = depth_estimator(<span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This is a tensor with the values being the depth expressed in meters for each pixel</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output[<span class="hljs-string">&quot;predicted_depth&quot;</span>].shape
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">384</span>, <span class="hljs-number">384</span>])`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function Z_(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLXBhdGNoMTYtMjI0LXB0MjJrLWZ0MjJrJTIyKSUwQWNsYXNzaWZpZXIoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGaW1hZ2VfZHVtbXklMkZyYXclMkZtYWluJTJGcGFycm90cy5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(model=<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k-ft22k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/image_dummy/raw/main/parrots.png&quot;</span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.442</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;macaw&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.088</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;popinjay&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.075</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;parrot&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.073</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;parodist, lampooner&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.046</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;poll, poll_parrot&#x27;</span>}]`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function F_(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBc2VnbWVudGVyJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJmYWNlYm9vayUyRmRldHItcmVzbmV0LTUwLXBhbm9wdGljJTIyKSUwQXNlZ21lbnRzJTIwJTNEJTIwc2VnbWVudGVyKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmltYWdlX2R1bW15JTJGcmF3JTJGbWFpbiUyRnBhcnJvdHMucG5nJTIyKSUwQWxlbihzZWdtZW50cyklMEElMEFzZWdtZW50cyU1QjAlNUQlNUIlMjJsYWJlbCUyMiU1RCUwQSUwQXNlZ21lbnRzJTVCMSU1RCU1QiUyMmxhYmVsJTIyJTVEJTBBJTBBdHlwZShzZWdtZW50cyU1QjAlNUQlNUIlMjJtYXNrJTIyJTVEKSUyMCUyMCUyMyUyMFRoaXMlMjBpcyUyMGElMjBibGFjayUyMGFuZCUyMHdoaXRlJTIwbWFzayUyMHNob3dpbmclMjB3aGVyZSUyMGlzJTIwdGhlJTIwYmlyZCUyMG9uJTIwdGhlJTIwb3JpZ2luYWwlMjBpbWFnZS4lMEElMEFzZWdtZW50cyU1QjAlNUQlNUIlMjJtYXNrJTIyJTVELnNpemU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>segmenter = pipeline(model=<span class="hljs-string">&quot;facebook/detr-resnet-50-panoptic&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>segments = segmenter(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/image_dummy/raw/main/parrots.png&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(segments)
<span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>segments[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;label&quot;</span>]
<span class="hljs-string">&#x27;bird&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>segments[<span class="hljs-number">1</span>][<span class="hljs-string">&quot;label&quot;</span>]
<span class="hljs-string">&#x27;bird&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">type</span>(segments[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;mask&quot;</span>])  <span class="hljs-comment"># This is a black and white mask showing where is the bird on the original image.</span>
&lt;<span class="hljs-keyword">class</span> <span class="hljs-string">&#x27;PIL.Image.Image&#x27;</span>&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span>segments[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;mask&quot;</span>].size
(<span class="hljs-number">768</span>, <span class="hljs-number">512</span>)`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function B_(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEF1cHNjYWxlciUyMCUzRCUyMHBpcGVsaW5lKCUyMmltYWdlLXRvLWltYWdlJTIyJTJDJTIwbW9kZWwlM0QlMjJjYWlkYXMlMkZzd2luMlNSLWNsYXNzaWNhbC1zci14Mi02NCUyMiklMEFpbWclMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCglMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWltZyUyMCUzRCUyMGltZy5yZXNpemUoKDY0JTJDJTIwNjQpKSUwQXVwc2NhbGVkX2ltZyUyMCUzRCUyMHVwc2NhbGVyKGltZyklMEFpbWcuc2l6ZSUwQSUwQXVwc2NhbGVkX2ltZy5zaXpl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>upscaler = pipeline(<span class="hljs-string">&quot;image-to-image&quot;</span>, model=<span class="hljs-string">&quot;caidas/swin2SR-classical-sr-x2-64&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(requests.get(<span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = img.resize((<span class="hljs-number">64</span>, <span class="hljs-number">64</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>upscaled_img = upscaler(img)
<span class="hljs-meta">&gt;&gt;&gt; </span>img.size
(<span class="hljs-number">64</span>, <span class="hljs-number">64</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>upscaled_img.size
(<span class="hljs-number">144</span>, <span class="hljs-number">144</span>)`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function R_(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZGV0ZWN0b3IlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmZhY2Vib29rJTJGZGV0ci1yZXNuZXQtNTAlMjIpJTBBZGV0ZWN0b3IoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGaW1hZ2VfZHVtbXklMkZyYXclMkZtYWluJTJGcGFycm90cy5wbmclMjIpJTBBJTBBJTIzJTIweCUyQyUyMHklMjAlMjBhcmUlMjBleHByZXNzZWQlMjByZWxhdGl2ZSUyMHRvJTIwdGhlJTIwdG9wJTIwbGVmdCUyMGhhbmQlMjBjb3JuZXIu",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>detector = pipeline(model=<span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>detector(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/image_dummy/raw/main/parrots.png&quot;</span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.997</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;bird&#x27;</span>, <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">69</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">171</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">396</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">507</span>}}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.999</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;bird&#x27;</span>, <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">398</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">105</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">767</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">507</span>}}]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># x, y  are expressed relative to the top left hand corner.</span>`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function D_(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyZ29vZ2xlJTJGc2lnbGlwLXNvNDAwbS1wYXRjaDE0LTM4NCUyMiklMEFjbGFzc2lmaWVyKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmltYWdlX2R1bW15JTJGcmF3JTJGbWFpbiUyRnBhcnJvdHMucG5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwY2FuZGlkYXRlX2xhYmVscyUzRCU1QiUyMmFuaW1hbHMlMjIlMkMlMjAlMjJodW1hbnMlMjIlMkMlMjAlMjJsYW5kc2NhcGUlMjIlNUQlMkMlMEEpJTBBJTBBY2xhc3NpZmllciglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZpbWFnZV9kdW1teSUyRnJhdyUyRm1haW4lMkZwYXJyb3RzLnBuZyUyMiUyQyUwQSUyMCUyMCUyMCUyMGNhbmRpZGF0ZV9sYWJlbHMlM0QlNUIlMjJibGFjayUyMGFuZCUyMHdoaXRlJTIyJTJDJTIwJTIycGhvdG9yZWFsaXN0JTIyJTJDJTIwJTIycGFpbnRpbmclMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(model=<span class="hljs-string">&quot;google/siglip-so400m-patch14-384&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/image_dummy/raw/main/parrots.png&quot;</span>,
<span class="hljs-meta">... </span>    candidate_labels=[<span class="hljs-string">&quot;animals&quot;</span>, <span class="hljs-string">&quot;humans&quot;</span>, <span class="hljs-string">&quot;landscape&quot;</span>],
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.965</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;animals&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.03</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;humans&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.005</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;landscape&#x27;</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/image_dummy/raw/main/parrots.png&quot;</span>,
<span class="hljs-meta">... </span>    candidate_labels=[<span class="hljs-string">&quot;black and white&quot;</span>, <span class="hljs-string">&quot;photorealist&quot;</span>, <span class="hljs-string">&quot;painting&quot;</span>],
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.996</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;black and white&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.003</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;photorealist&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;painting&#x27;</span>}]`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function N_(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZGV0ZWN0b3IlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmdvb2dsZSUyRm93bHZpdC1iYXNlLXBhdGNoMzIlMjIlMkMlMjB0YXNrJTNEJTIyemVyby1zaG90LW9iamVjdC1kZXRlY3Rpb24lMjIpJTBBZGV0ZWN0b3IoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUyQyUwQSUyMCUyMCUyMCUyMGNhbmRpZGF0ZV9sYWJlbHMlM0QlNUIlMjJjYXQlMjIlMkMlMjAlMjJjb3VjaCUyMiU1RCUyQyUwQSklMEElMEFkZXRlY3RvciglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZpbWFnZV9kdW1teSUyRnJhdyUyRm1haW4lMkZwYXJyb3RzLnBuZyUyMiUyQyUwQSUyMCUyMCUyMCUyMGNhbmRpZGF0ZV9sYWJlbHMlM0QlNUIlMjJoZWFkJTIyJTJDJTIwJTIyYmlyZCUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>detector = pipeline(model=<span class="hljs-string">&quot;google/owlvit-base-patch32&quot;</span>, task=<span class="hljs-string">&quot;zero-shot-object-detection&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>detector(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>,
<span class="hljs-meta">... </span>    candidate_labels=[<span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;couch&quot;</span>],
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.287</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cat&#x27;</span>, <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">324</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">20</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">640</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">373</span>}}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.254</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cat&#x27;</span>, <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">55</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">315</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">472</span>}}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.121</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;couch&#x27;</span>, <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">642</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">476</span>}}]

<span class="hljs-meta">&gt;&gt;&gt; </span>detector(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/image_dummy/raw/main/parrots.png&quot;</span>,
<span class="hljs-meta">... </span>    candidate_labels=[<span class="hljs-string">&quot;head&quot;</span>, <span class="hljs-string">&quot;bird&quot;</span>],
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.119</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;bird&#x27;</span>, <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">71</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">170</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">410</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">508</span>}}]`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function L_(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZmlsbF9tYXNrZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBZmlsbF9tYXNrZXIoJTIyVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMCU1Qk1BU0slNUQuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>fill_masker = pipeline(model=<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>fill_masker(<span class="hljs-string">&quot;This is a simple [MASK].&quot;</span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.042</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">3291</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;problem&#x27;</span>, <span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;this is a simple problem.&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.031</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">3160</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;question&#x27;</span>, <span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;this is a simple question.&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.03</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">8522</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;equation&#x27;</span>, <span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;this is a simple equation.&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.027</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2028</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;one&#x27;</span>, <span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;this is a simple one.&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.024</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">3627</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;rule&#x27;</span>, <span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;this is a simple rule.&#x27;</span>}]`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function A_(M){let o,_=`This pipeline only works for inputs with exactly one token masked. Experimental: We added support for multiple
masks. The returned values are raw model output, and correspond to disjoint probabilities where one might expect
joint probabilities (See <a href="https://github.com/huggingface/transformers/pull/10222" rel="nofollow">discussion</a>).`;return{c(){o=r("p"),o.innerHTML=_},l(h){o=i(h,"P",{"data-svelte-h":!0}),d(o)!=="svelte-126iymh"&&(o.innerHTML=_)},m(h,p){m(h,o,p)},p:$,d(h){h&&l(o)}}}function V_(M){let o,_="This pipeline now supports tokenizer_kwargs. For example try:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZmlsbF9tYXNrZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBdG9rZW5pemVyX2t3YXJncyUyMCUzRCUyMCU3QiUyMnRydW5jYXRpb24lMjIlM0ElMjBUcnVlJTdEJTBBZmlsbF9tYXNrZXIoJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMCU1Qk1BU0slNUQuJTIwJTIyJTIwJTJCJTIwJTIyLi4ud2l0aCUyMGElMjBsYXJnZSUyMGFtb3VudCUyMG9mJTIwcmVwZWF0ZWQlMjB0ZXh0JTIwYXBwZW5kZWQuJTIwJTIyJTIwKiUyMDEwMCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplcl9rd2FyZ3MlM0R0b2tlbml6ZXJfa3dhcmdzJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>fill_masker = pipeline(model=<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_kwargs = {<span class="hljs-string">&quot;truncation&quot;</span>: <span class="hljs-literal">True</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>fill_masker(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;This is a simple [MASK]. &quot;</span> + <span class="hljs-string">&quot;...with a large amount of repeated text appended. &quot;</span> * <span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    tokenizer_kwargs=tokenizer_kwargs,
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1pudxyz"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function W_(M){let o,_;return o=new P({props:{anchor:"transformers.FillMaskPipeline.example-2",$$slots:{default:[V_]},$$scope:{ctx:M}}}),{c(){g(o.$$.fragment)},l(h){f(o.$$.fragment,h)},m(h,p){u(o,h,p),_=!0},p(h,p){const x={};p&2&&(x.$$scope={dirty:p,ctx:h}),o.$set(x)},i(h){_||(T(o.$$.fragment,h),_=!0)},o(h){y(o.$$.fragment,h),_=!1},d(h){b(o,h)}}}function S_(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdG9rZW5fY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIySmVhbi1CYXB0aXN0ZSUyRmNhbWVtYmVydC1uZXIlMjIlMkMlMjBhZ2dyZWdhdGlvbl9zdHJhdGVneSUzRCUyMnNpbXBsZSUyMiklMEFzZW50ZW5jZSUyMCUzRCUyMCUyMkplJTIwbSdhcHBlbGxlJTIwamVhbi1iYXB0aXN0ZSUyMGV0JTIwamUlMjB2aXMlMjAlQzMlQTAlMjBtb250ciVDMyVBOWFsJTIyJTBBdG9rZW5zJTIwJTNEJTIwdG9rZW5fY2xhc3NpZmllcihzZW50ZW5jZSklMEF0b2tlbnMlMEElMEF0b2tlbiUyMCUzRCUyMHRva2VucyU1QjAlNUQlMEElMjMlMjBTdGFydCUyMGFuZCUyMGVuZCUyMHByb3ZpZGUlMjBhbiUyMGVhc3klMjB3YXklMjB0byUyMGhpZ2hsaWdodCUyMHdvcmRzJTIwaW4lMjB0aGUlMjBvcmlnaW5hbCUyMHRleHQuJTBBc2VudGVuY2UlNUJ0b2tlbiU1QiUyMnN0YXJ0JTIyJTVEJTIwJTNBJTIwdG9rZW4lNUIlMjJlbmQlMjIlNUQlNUQlMEElMEElMjMlMjBTb21lJTIwbW9kZWxzJTIwdXNlJTIwdGhlJTIwc2FtZSUyMGlkZWElMjB0byUyMGRvJTIwcGFydCUyMG9mJTIwc3BlZWNoLiUwQXN5bnRheGVyJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJ2YmxhZ29qZSUyRmJlcnQtZW5nbGlzaC11bmNhc2VkLWZpbmV0dW5lZC1wb3MlMjIlMkMlMjBhZ2dyZWdhdGlvbl9zdHJhdGVneSUzRCUyMnNpbXBsZSUyMiklMEFzeW50YXhlciglMjJNeSUyMG5hbWUlMjBpcyUyMFNhcmFoJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMExvbmRvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>token_classifier = pipeline(model=<span class="hljs-string">&quot;Jean-Baptiste/camembert-ner&quot;</span>, aggregation_strategy=<span class="hljs-string">&quot;simple&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sentence = <span class="hljs-string">&quot;Je m&#x27;appelle jean-baptiste et je vis à montréal&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokens = token_classifier(sentence)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokens
[{<span class="hljs-string">&#x27;entity_group&#x27;</span>: <span class="hljs-string">&#x27;PER&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9931</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;jean-baptiste&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">12</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">26</span>}, {<span class="hljs-string">&#x27;entity_group&#x27;</span>: <span class="hljs-string">&#x27;LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.998</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;montréal&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">38</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">47</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span>token = tokens[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Start and end provide an easy way to highlight words in the original text.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sentence[token[<span class="hljs-string">&quot;start&quot;</span>] : token[<span class="hljs-string">&quot;end&quot;</span>]]
<span class="hljs-string">&#x27; jean-baptiste&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Some models use the same idea to do part of speech.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>syntaxer = pipeline(model=<span class="hljs-string">&quot;vblagoje/bert-english-uncased-finetuned-pos&quot;</span>, aggregation_strategy=<span class="hljs-string">&quot;simple&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>syntaxer(<span class="hljs-string">&quot;My name is Sarah and I live in London&quot;</span>)
[{<span class="hljs-string">&#x27;entity_group&#x27;</span>: <span class="hljs-string">&#x27;PRON&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.999</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;my&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">2</span>}, {<span class="hljs-string">&#x27;entity_group&#x27;</span>: <span class="hljs-string">&#x27;NOUN&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.997</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;name&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">7</span>}, {<span class="hljs-string">&#x27;entity_group&#x27;</span>: <span class="hljs-string">&#x27;AUX&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.994</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">8</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">10</span>}, {<span class="hljs-string">&#x27;entity_group&#x27;</span>: <span class="hljs-string">&#x27;PROPN&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.999</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;sarah&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">11</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">16</span>}, {<span class="hljs-string">&#x27;entity_group&#x27;</span>: <span class="hljs-string">&#x27;CCONJ&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.999</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;and&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">17</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">20</span>}, {<span class="hljs-string">&#x27;entity_group&#x27;</span>: <span class="hljs-string">&#x27;PRON&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.999</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">21</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">22</span>}, {<span class="hljs-string">&#x27;entity_group&#x27;</span>: <span class="hljs-string">&#x27;VERB&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.998</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;live&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">23</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">27</span>}, {<span class="hljs-string">&#x27;entity_group&#x27;</span>: <span class="hljs-string">&#x27;ADP&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.999</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;in&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">28</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">30</span>}, {<span class="hljs-string">&#x27;entity_group&#x27;</span>: <span class="hljs-string">&#x27;PROPN&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.999</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;london&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">31</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">37</span>}]`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function H_(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBb3JhY2xlJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJkZWVwc2V0JTJGcm9iZXJ0YS1iYXNlLXNxdWFkMiUyMiklMEFvcmFjbGUocXVlc3Rpb24lM0QlMjJXaGVyZSUyMGRvJTIwSSUyMGxpdmUlM0YlMjIlMkMlMjBjb250ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBXb2xmZ2FuZyUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBCZXJsaW4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>oracle = pipeline(model=<span class="hljs-string">&quot;deepset/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>oracle(question=<span class="hljs-string">&quot;Where do I live?&quot;</span>, context=<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9191</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">34</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">40</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;Berlin&#x27;</span>}`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function O_(M){let o,_="Usage:",h,p,x;return p=new v({props:{code:"JTIzJTIwdXNlJTIwYmFydCUyMGluJTIwcHl0b3JjaCUwQXN1bW1hcml6ZXIlMjAlM0QlMjBwaXBlbGluZSglMjJzdW1tYXJpemF0aW9uJTIyKSUwQXN1bW1hcml6ZXIoJTIyQW4lMjBhcHBsZSUyMGElMjBkYXklMkMlMjBrZWVwcyUyMHRoZSUyMGRvY3RvciUyMGF3YXklMjIlMkMlMjBtaW5fbGVuZ3RoJTNENSUyQyUyMG1heF9sZW5ndGglM0QyMCklMEElMEElMjMlMjB1c2UlMjB0NSUyMGluJTIwdGYlMEFzdW1tYXJpemVyJTIwJTNEJTIwcGlwZWxpbmUoJTIyc3VtbWFyaXphdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZ29vZ2xlLXQ1JTJGdDUtYmFzZSUyMiUyQyUyMHRva2VuaXplciUzRCUyMmdvb2dsZS10NSUyRnQ1LWJhc2UlMjIlMkMlMjBmcmFtZXdvcmslM0QlMjJ0ZiUyMiklMEFzdW1tYXJpemVyKCUyMkFuJTIwYXBwbGUlMjBhJTIwZGF5JTJDJTIwa2VlcHMlMjB0aGUlMjBkb2N0b3IlMjBhd2F5JTIyJTJDJTIwbWluX2xlbmd0aCUzRDUlMkMlMjBtYXhfbGVuZ3RoJTNEMjAp",highlighted:`<span class="hljs-comment"># use bart in pytorch</span>
summarizer = pipeline(<span class="hljs-string">&quot;summarization&quot;</span>)
summarizer(<span class="hljs-string">&quot;An apple a day, keeps the doctor away&quot;</span>, min_length=<span class="hljs-number">5</span>, max_length=<span class="hljs-number">20</span>)

<span class="hljs-comment"># use t5 in tf</span>
summarizer = pipeline(<span class="hljs-string">&quot;summarization&quot;</span>, model=<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>, tokenizer=<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>, framework=<span class="hljs-string">&quot;tf&quot;</span>)
summarizer(<span class="hljs-string">&quot;An apple a day, keeps the doctor away&quot;</span>, min_length=<span class="hljs-number">5</span>, max_length=<span class="hljs-number">20</span>)`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-5wyjqd"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function Y_(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBb3JhY2xlJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJnb29nbGUlMkZ0YXBhcy1iYXNlLWZpbmV0dW5lZC13dHElMjIpJTBBdGFibGUlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJSZXBvc2l0b3J5JTIyJTNBJTIwJTVCJTIyVHJhbnNmb3JtZXJzJTIyJTJDJTIwJTIyRGF0YXNldHMlMjIlMkMlMjAlMjJUb2tlbml6ZXJzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyU3RhcnMlMjIlM0ElMjAlNUIlMjIzNjU0MiUyMiUyQyUyMCUyMjQ1MTIlMjIlMkMlMjAlMjIzOTM0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyQ29udHJpYnV0b3JzJTIyJTNBJTIwJTVCJTIyNjUxJTIyJTJDJTIwJTIyNzclMjIlMkMlMjAlMjIzNCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMlByb2dyYW1taW5nJTIwbGFuZ3VhZ2UlMjIlM0ElMjAlNUIlMjJQeXRob24lMjIlMkMlMjAlMjJQeXRob24lMjIlMkMlMjAlMjJSdXN0JTJDJTIwUHl0aG9uJTIwYW5kJTIwTm9kZUpTJTIyJTVEJTJDJTBBJTdEJTBBb3JhY2xlKHF1ZXJ5JTNEJTIySG93JTIwbWFueSUyMHN0YXJzJTIwZG9lcyUyMHRoZSUyMHRyYW5zZm9ybWVycyUyMHJlcG9zaXRvcnklMjBoYXZlJTNGJTIyJTJDJTIwdGFibGUlM0R0YWJsZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>oracle = pipeline(model=<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Repository&quot;</span>: [<span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;Datasets&quot;</span>, <span class="hljs-string">&quot;Tokenizers&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Stars&quot;</span>: [<span class="hljs-string">&quot;36542&quot;</span>, <span class="hljs-string">&quot;4512&quot;</span>, <span class="hljs-string">&quot;3934&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Contributors&quot;</span>: [<span class="hljs-string">&quot;651&quot;</span>, <span class="hljs-string">&quot;77&quot;</span>, <span class="hljs-string">&quot;34&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Programming language&quot;</span>: [<span class="hljs-string">&quot;Python&quot;</span>, <span class="hljs-string">&quot;Python&quot;</span>, <span class="hljs-string">&quot;Rust, Python and NodeJS&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>oracle(query=<span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span>, table=table)
{<span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;AVERAGE &gt; 36542&#x27;</span>, <span class="hljs-string">&#x27;coordinates&#x27;</span>: [(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>)], <span class="hljs-string">&#x27;cells&#x27;</span>: [<span class="hljs-string">&#x27;36542&#x27;</span>], <span class="hljs-string">&#x27;aggregator&#x27;</span>: <span class="hljs-string">&#x27;AVERAGE&#x27;</span>}`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function E_(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZGF0YSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmFjdG9ycyUyMiUzQSUyMCU1QiUyMmJyYWQlMjBwaXR0JTIyJTJDJTIwJTIybGVvbmFyZG8lMjBkaSUyMGNhcHJpbyUyMiUyQyUyMCUyMmdlb3JnZSUyMGNsb29uZXklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJhZ2UlMjIlM0ElMjAlNUIlMjI1NiUyMiUyQyUyMCUyMjQ1JTIyJTJDJTIwJTIyNTklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJudW1iZXIlMjBvZiUyMG1vdmllcyUyMiUzQSUyMCU1QiUyMjg3JTIyJTJDJTIwJTIyNTMlMjIlMkMlMjAlMjI2OSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmRhdGUlMjBvZiUyMGJpcnRoJTIyJTNBJTIwJTVCJTIyNyUyMGZlYnJ1YXJ5JTIwMTk2NyUyMiUyQyUyMCUyMjEwJTIwanVuZSUyMDE5OTYlMjIlMkMlMjAlMjIyOCUyMG5vdmVtYmVyJTIwMTk2NyUyMiU1RCUyQyUwQSU3RA==",highlighted:`data = {
    <span class="hljs-string">&quot;actors&quot;</span>: [<span class="hljs-string">&quot;brad pitt&quot;</span>, <span class="hljs-string">&quot;leonardo di caprio&quot;</span>, <span class="hljs-string">&quot;george clooney&quot;</span>],
    <span class="hljs-string">&quot;age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
    <span class="hljs-string">&quot;number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
    <span class="hljs-string">&quot;date of birth&quot;</span>: [<span class="hljs-string">&quot;7 february 1967&quot;</span>, <span class="hljs-string">&quot;10 june 1996&quot;</span>, <span class="hljs-string">&quot;28 november 1967&quot;</span>],
}`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function Q_(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXRhYmxlJTIwJTNEJTIwcGQuRGF0YUZyYW1lLmZyb21fZGljdChkYXRhKQ==",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

table = pd.DataFrame.from_dict(data)`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function X_(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyZGlzdGlsYmVydCUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQWNsYXNzaWZpZXIoJTIyVGhpcyUyMG1vdmllJTIwaXMlMjBkaXNndXN0aW5nbHklMjBnb29kJTIwISUyMiklMEElMEFjbGFzc2lmaWVyKCUyMkRpcmVjdG9yJTIwdHJpZWQlMjB0b28lMjBtdWNoLiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(model=<span class="hljs-string">&quot;distilbert/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier(<span class="hljs-string">&quot;This movie is disgustingly good !&quot;</span>)
[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;POSITIVE&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">1.0</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier(<span class="hljs-string">&quot;Director tried too much.&quot;</span>)
[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;NEGATIVE&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.996</span>}]`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function K_(M){let o,_="Examples:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiklMEFnZW5lcmF0b3IoJTIySSUyMGNhbid0JTIwYmVsaWV2ZSUyMHlvdSUyMGRpZCUyMHN1Y2glMjBhJTIwJTIyJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UpJTBBJTBBJTIzJTIwVGhlc2UlMjBwYXJhbWV0ZXJzJTIwd2lsbCUyMHJldHVybiUyMHN1Z2dlc3Rpb25zJTJDJTIwYW5kJTIwb25seSUyMHRoZSUyMG5ld2x5JTIwY3JlYXRlZCUyMHRleHQlMjBtYWtpbmclMjBpdCUyMGVhc2llciUyMGZvciUyMHByb21wdGluZyUyMHN1Z2dlc3Rpb25zLiUwQW91dHB1dHMlMjAlM0QlMjBnZW5lcmF0b3IoJTIyTXklMjB0YXJ0JTIwbmVlZHMlMjBzb21lJTIyJTJDJTIwbnVtX3JldHVybl9zZXF1ZW5jZXMlM0Q0JTJDJTIwcmV0dXJuX2Z1bGxfdGV4dCUzREZhbHNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(model=<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generator(<span class="hljs-string">&quot;I can&#x27;t believe you did such a &quot;</span>, do_sample=<span class="hljs-literal">False</span>)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&quot;I can&#x27;t believe you did such a icky thing to me. I&#x27;m so sorry. I&#x27;m so sorry. I&#x27;m so sorry. I&#x27;m so sorry. I&#x27;m so sorry. I&#x27;m so sorry. I&#x27;m so sorry. I&quot;</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># These parameters will return suggestions, and only the newly created text making it easier for prompting suggestions.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = generator(<span class="hljs-string">&quot;My tart needs some&quot;</span>, num_return_sequences=<span class="hljs-number">4</span>, return_full_text=<span class="hljs-literal">False</span>)`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-kvfsh7"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function eM(M){let o,_;return o=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIpJTBBJTIzJTIwWmVwaHlyLWJldGElMjBpcyUyMGElMjBjb252ZXJzYXRpb25hbCUyMG1vZGVsJTJDJTIwc28lMjBsZXQncyUyMHBhc3MlMjBpdCUyMGElMjBjaGF0JTIwaW5zdGVhZCUyMG9mJTIwYSUyMHNpbmdsZSUyMHN0cmluZyUwQWdlbmVyYXRvciglNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjBBbnN3ZXIlMjBpbiUyMG9uZSUyMHdvcmQuJTIyJTdEJTVEJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(model=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Zephyr-beta is a conversational model, so let&#x27;s pass it a chat instead of a single string</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator([{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France? Answer in one word.&quot;</span>}], do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">2</span>)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What is the capital of France? Answer in one word.&#x27;</span>}, {<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;Paris&#x27;</span>}]}]`,wrap:!1}}),{c(){g(o.$$.fragment)},l(h){f(o.$$.fragment,h)},m(h,p){u(o,h,p),_=!0},p:$,i(h){_||(T(o.$$.fragment,h),_=!0)},o(h){y(o.$$.fragment,h),_=!1},d(h){b(o,h)}}}function tM(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJtcm04NDg4JTJGdDUtYmFzZS1maW5ldHVuZWQtcXVlc3Rpb24tZ2VuZXJhdGlvbi1hcCUyMiklMEFnZW5lcmF0b3IoJTBBJTIwJTIwJTIwJTIwJTIyYW5zd2VyJTNBJTIwTWFudWVsJTIwY29udGV4dCUzQSUyME1hbnVlbCUyMGhhcyUyMGNyZWF0ZWQlMjBSdVBFUlRhLWJhc2UlMjB3aXRoJTIwdGhlJTIwc3VwcG9ydCUyMG9mJTIwSEYtVHJhbnNmb3JtZXJzJTIwYW5kJTIwR29vZ2xlJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(model=<span class="hljs-string">&quot;mrm8488/t5-base-finetuned-question-generation-ap&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;answer: Manuel context: Manuel has created RuPERTa-base with the support of HF-Transformers and Google&quot;</span>
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;question: Who created the RuPERTa-base?&#x27;</span>}]`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function nM(M){let o,_="Usage:",h,p,x;return p=new v({props:{code:"dGV4dDJ0ZXh0X2dlbmVyYXRvciUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQydGV4dC1nZW5lcmF0aW9uJTIyKSUwQXRleHQydGV4dF9nZW5lcmF0b3IoJTIycXVlc3Rpb24lM0ElMjBXaGF0JTIwaXMlMjA0MiUyMCUzRiUyMGNvbnRleHQlM0ElMjA0MiUyMGlzJTIwdGhlJTIwYW5zd2VyJTIwdG8lMjBsaWZlJTJDJTIwdGhlJTIwdW5pdmVyc2UlMjBhbmQlMjBldmVyeXRoaW5nJTIyKQ==",highlighted:`text2text_generator = pipeline(<span class="hljs-string">&quot;text2text-generation&quot;</span>)
text2text_generator(<span class="hljs-string">&quot;question: What is 42 ? context: 42 is the answer to life, the universe and everything&quot;</span>)`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-5wyjqd"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function sM(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdG9rZW5fY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIySmVhbi1CYXB0aXN0ZSUyRmNhbWVtYmVydC1uZXIlMjIlMkMlMjBhZ2dyZWdhdGlvbl9zdHJhdGVneSUzRCUyMnNpbXBsZSUyMiklMEFzZW50ZW5jZSUyMCUzRCUyMCUyMkplJTIwbSdhcHBlbGxlJTIwamVhbi1iYXB0aXN0ZSUyMGV0JTIwamUlMjB2aXMlMjAlQzMlQTAlMjBtb250ciVDMyVBOWFsJTIyJTBBdG9rZW5zJTIwJTNEJTIwdG9rZW5fY2xhc3NpZmllcihzZW50ZW5jZSklMEF0b2tlbnMlMEElMEF0b2tlbiUyMCUzRCUyMHRva2VucyU1QjAlNUQlMEElMjMlMjBTdGFydCUyMGFuZCUyMGVuZCUyMHByb3ZpZGUlMjBhbiUyMGVhc3klMjB3YXklMjB0byUyMGhpZ2hsaWdodCUyMHdvcmRzJTIwaW4lMjB0aGUlMjBvcmlnaW5hbCUyMHRleHQuJTBBc2VudGVuY2UlNUJ0b2tlbiU1QiUyMnN0YXJ0JTIyJTVEJTIwJTNBJTIwdG9rZW4lNUIlMjJlbmQlMjIlNUQlNUQlMEElMEElMjMlMjBTb21lJTIwbW9kZWxzJTIwdXNlJTIwdGhlJTIwc2FtZSUyMGlkZWElMjB0byUyMGRvJTIwcGFydCUyMG9mJTIwc3BlZWNoLiUwQXN5bnRheGVyJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJ2YmxhZ29qZSUyRmJlcnQtZW5nbGlzaC11bmNhc2VkLWZpbmV0dW5lZC1wb3MlMjIlMkMlMjBhZ2dyZWdhdGlvbl9zdHJhdGVneSUzRCUyMnNpbXBsZSUyMiklMEFzeW50YXhlciglMjJNeSUyMG5hbWUlMjBpcyUyMFNhcmFoJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMExvbmRvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>token_classifier = pipeline(model=<span class="hljs-string">&quot;Jean-Baptiste/camembert-ner&quot;</span>, aggregation_strategy=<span class="hljs-string">&quot;simple&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sentence = <span class="hljs-string">&quot;Je m&#x27;appelle jean-baptiste et je vis à montréal&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokens = token_classifier(sentence)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokens
[{<span class="hljs-string">&#x27;entity_group&#x27;</span>: <span class="hljs-string">&#x27;PER&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9931</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;jean-baptiste&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">12</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">26</span>}, {<span class="hljs-string">&#x27;entity_group&#x27;</span>: <span class="hljs-string">&#x27;LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.998</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;montréal&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">38</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">47</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span>token = tokens[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Start and end provide an easy way to highlight words in the original text.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sentence[token[<span class="hljs-string">&quot;start&quot;</span>] : token[<span class="hljs-string">&quot;end&quot;</span>]]
<span class="hljs-string">&#x27; jean-baptiste&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Some models use the same idea to do part of speech.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>syntaxer = pipeline(model=<span class="hljs-string">&quot;vblagoje/bert-english-uncased-finetuned-pos&quot;</span>, aggregation_strategy=<span class="hljs-string">&quot;simple&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>syntaxer(<span class="hljs-string">&quot;My name is Sarah and I live in London&quot;</span>)
[{<span class="hljs-string">&#x27;entity_group&#x27;</span>: <span class="hljs-string">&#x27;PRON&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.999</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;my&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">2</span>}, {<span class="hljs-string">&#x27;entity_group&#x27;</span>: <span class="hljs-string">&#x27;NOUN&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.997</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;name&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">7</span>}, {<span class="hljs-string">&#x27;entity_group&#x27;</span>: <span class="hljs-string">&#x27;AUX&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.994</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">8</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">10</span>}, {<span class="hljs-string">&#x27;entity_group&#x27;</span>: <span class="hljs-string">&#x27;PROPN&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.999</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;sarah&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">11</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">16</span>}, {<span class="hljs-string">&#x27;entity_group&#x27;</span>: <span class="hljs-string">&#x27;CCONJ&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.999</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;and&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">17</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">20</span>}, {<span class="hljs-string">&#x27;entity_group&#x27;</span>: <span class="hljs-string">&#x27;PRON&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.999</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">21</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">22</span>}, {<span class="hljs-string">&#x27;entity_group&#x27;</span>: <span class="hljs-string">&#x27;VERB&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.998</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;live&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">23</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">27</span>}, {<span class="hljs-string">&#x27;entity_group&#x27;</span>: <span class="hljs-string">&#x27;ADP&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.999</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;in&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">28</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">30</span>}, {<span class="hljs-string">&#x27;entity_group&#x27;</span>: <span class="hljs-string">&#x27;PROPN&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.999</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;london&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">31</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">37</span>}]`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function aM(M){let o,_="Usage:",h,p,x;return p=new v({props:{code:"ZW5fZnJfdHJhbnNsYXRvciUyMCUzRCUyMHBpcGVsaW5lKCUyMnRyYW5zbGF0aW9uX2VuX3RvX2ZyJTIyKSUwQWVuX2ZyX3RyYW5zbGF0b3IoJTIySG93JTIwb2xkJTIwYXJlJTIweW91JTNGJTIyKQ==",highlighted:`en_fr_translator = pipeline(<span class="hljs-string">&quot;translation_en_to_fr&quot;</span>)
en_fr_translator(<span class="hljs-string">&quot;How old are you?&quot;</span>)`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-5wyjqd"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function oM(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBb3JhY2xlJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJmYWNlYm9vayUyRmJhcnQtbGFyZ2UtbW5saSUyMiklMEFvcmFjbGUoJTBBJTIwJTIwJTIwJTIwJTIySSUyMGhhdmUlMjBhJTIwcHJvYmxlbSUyMHdpdGglMjBteSUyMGlwaG9uZSUyMHRoYXQlMjBuZWVkcyUyMHRvJTIwYmUlMjByZXNvbHZlZCUyMGFzYXAhISUyMiUyQyUwQSUyMCUyMCUyMCUyMGNhbmRpZGF0ZV9sYWJlbHMlM0QlNUIlMjJ1cmdlbnQlMjIlMkMlMjAlMjJub3QlMjB1cmdlbnQlMjIlMkMlMjAlMjJwaG9uZSUyMiUyQyUyMCUyMnRhYmxldCUyMiUyQyUyMCUyMmNvbXB1dGVyJTIyJTVEJTJDJTBBKSUwQSUwQW9yYWNsZSglMEElMjAlMjAlMjAlMjAlMjJJJTIwaGF2ZSUyMGElMjBwcm9ibGVtJTIwd2l0aCUyMG15JTIwaXBob25lJTIwdGhhdCUyMG5lZWRzJTIwdG8lMjBiZSUyMHJlc29sdmVkJTIwYXNhcCEhJTIyJTJDJTBBJTIwJTIwJTIwJTIwY2FuZGlkYXRlX2xhYmVscyUzRCU1QiUyMmVuZ2xpc2glMjIlMkMlMjAlMjJnZXJtYW4lMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>oracle = pipeline(model=<span class="hljs-string">&quot;facebook/bart-large-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>oracle(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;I have a problem with my iphone that needs to be resolved asap!!&quot;</span>,
<span class="hljs-meta">... </span>    candidate_labels=[<span class="hljs-string">&quot;urgent&quot;</span>, <span class="hljs-string">&quot;not urgent&quot;</span>, <span class="hljs-string">&quot;phone&quot;</span>, <span class="hljs-string">&quot;tablet&quot;</span>, <span class="hljs-string">&quot;computer&quot;</span>],
<span class="hljs-meta">... </span>)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;I have a problem with my iphone that needs to be resolved asap!!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;urgent&#x27;</span>, <span class="hljs-string">&#x27;phone&#x27;</span>, <span class="hljs-string">&#x27;computer&#x27;</span>, <span class="hljs-string">&#x27;not urgent&#x27;</span>, <span class="hljs-string">&#x27;tablet&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.504</span>, <span class="hljs-number">0.479</span>, <span class="hljs-number">0.013</span>, <span class="hljs-number">0.003</span>, <span class="hljs-number">0.002</span>]}

<span class="hljs-meta">&gt;&gt;&gt; </span>oracle(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;I have a problem with my iphone that needs to be resolved asap!!&quot;</span>,
<span class="hljs-meta">... </span>    candidate_labels=[<span class="hljs-string">&quot;english&quot;</span>, <span class="hljs-string">&quot;german&quot;</span>],
<span class="hljs-meta">... </span>)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;I have a problem with my iphone that needs to be resolved asap!!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;english&#x27;</span>, <span class="hljs-string">&#x27;german&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.814</span>, <span class="hljs-number">0.186</span>]}`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function rM(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZG9jdW1lbnRfcWElMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmltcGlyYSUyRmxheW91dGxtLWRvY3VtZW50LXFhJTIyKSUwQWRvY3VtZW50X3FhKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnNwYWNlcyUyRmltcGlyYSUyRmRvY3F1ZXJ5JTJGcmVzb2x2ZSUyRjIzNTkyMjNjMTgzN2E3NTg3NDAyYmRhMGYyNjQzMzgyYTZlZWZlYWIlMkZpbnZvaWNlLnBuZyUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1ZXN0aW9uJTNEJTIyV2hhdCUyMGlzJTIwdGhlJTIwaW52b2ljZSUyMG51bWJlciUzRiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>document_qa = pipeline(model=<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>document_qa(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>,
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.425</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;us-001&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">16</span>}]`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function iM(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZXh0cmFjdG9yJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS11bmNhc2VkJTIyJTJDJTIwdGFzayUzRCUyMmZlYXR1cmUtZXh0cmFjdGlvbiUyMiklMEFyZXN1bHQlMjAlM0QlMjBleHRyYWN0b3IoJTIyVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMHRlc3QuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0RUcnVlKSUwQXJlc3VsdC5zaGFwZSUyMCUyMCUyMyUyMFRoaXMlMjBpcyUyMGElMjB0ZW5zb3IlMjBvZiUyMHNoYXBlJTIwJTVCMSUyQyUyMHNlcXVlbmNlX2xlbmd0aCUyQyUyMGhpZGRlbl9kaW1lbnNpb24lNUQlMjByZXByZXNlbnRpbmclMjB0aGUlMjBpbnB1dCUyMHN0cmluZy4=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>extractor = pipeline(model=<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>result = extractor(<span class="hljs-string">&quot;This is a simple test.&quot;</span>, return_tensors=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>result.shape  <span class="hljs-comment"># This is a tensor of shape [1, sequence_length, hidden_dimension] representing the input string.</span>
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">8</span>, <span class="hljs-number">768</span>])`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function lM(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZXh0cmFjdG9yJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJnb29nbGUlMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCUyMiUyQyUyMHRhc2slM0QlMjJpbWFnZS1mZWF0dXJlLWV4dHJhY3Rpb24lMjIpJTBBcmVzdWx0JTIwJTNEJTIwZXh0cmFjdG9yKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmltYWdlX2R1bW15JTJGcmF3JTJGbWFpbiUyRnBhcnJvdHMucG5nJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0RUcnVlKSUwQXJlc3VsdC5zaGFwZSUyMCUyMCUyMyUyMFRoaXMlMjBpcyUyMGElMjB0ZW5zb3IlMjBvZiUyMHNoYXBlJTIwJTVCMSUyQyUyMHNlcXVlbmNlX2xlbnRoJTJDJTIwaGlkZGVuX2RpbWVuc2lvbiU1RCUyMHJlcHJlc2VudGluZyUyMHRoZSUyMGlucHV0JTIwaW1hZ2Uu",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>extractor = pipeline(model=<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>, task=<span class="hljs-string">&quot;image-feature-extraction&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>result = extractor(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/image_dummy/raw/main/parrots.png&quot;</span>, return_tensors=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>result.shape  <span class="hljs-comment"># This is a tensor of shape [1, sequence_lenth, hidden_dimension] representing the input image.</span>
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">197</span>, <span class="hljs-number">768</span>])`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function cM(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2FwdGlvbmVyJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJ5ZHNoaWVoJTJGdml0LWdwdDItY29jby1lbiUyMiklMEFjYXB0aW9uZXIoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGaW1hZ2VfZHVtbXklMkZyYXclMkZtYWluJTJGcGFycm90cy5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>captioner = pipeline(model=<span class="hljs-string">&quot;ydshieh/vit-gpt2-coco-en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>captioner(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/image_dummy/raw/main/parrots.png&quot;</span>)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;two birds are standing next to each other &#x27;</span>}]`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function pM(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJpbWFnZS10ZXh0LXRvLXRleHQlMjIlMkMlMjBtb2RlbCUzRCUyMlNhbGVzZm9yY2UlMkZibGlwLWltYWdlLWNhcHRpb25pbmctYmFzZSUyMiklMEFwaXBlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmltYWdlX2R1bW15JTJGcmF3JTJGbWFpbiUyRnBhcnJvdHMucG5nJTIyJTJDJTIwdGV4dCUzRCUyMkElMjBwaG90byUyMG9mJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(task=<span class="hljs-string">&quot;image-text-to-text&quot;</span>, model=<span class="hljs-string">&quot;Salesforce/blip-image-captioning-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/image_dummy/raw/main/parrots.png&quot;</span>, text=<span class="hljs-string">&quot;A photo of&quot;</span>)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;a photo of two birds&#x27;</span>}]`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function dM(M){let o,_;return o=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmltYWdlLXRleHQtdG8tdGV4dCUyMiUyQyUyMG1vZGVsJTNEJTIybGxhdmEtaGYlMkZsbGF2YS1pbnRlcmxlYXZlLXF3ZW4tMC41Yi1oZiUyMiklMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJpbWFnZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVybCUyMiUzQSUyMCUyMmh0dHBzJTNBJTJGJTJGcWlhbndlbi1yZXMub3NzLWNuLWJlaWppbmcuYWxpeXVuY3MuY29tJTJGUXdlbi1WTCUyRmFzc2V0cyUyRmRlbW8uanBlZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMkRlc2NyaWJlJTIwdGhpcyUyMGltYWdlLiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyVGhlcmUlMjBpcyUyMGElMjBkb2clMjBhbmQlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElNUQlMEFwaXBlKHRleHQlM0RtZXNzYWdlcyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjAlMkMlMjByZXR1cm5fZnVsbF90ZXh0JTNERmFsc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;image-text-to-text&quot;</span>, model=<span class="hljs-string">&quot;llava-hf/llava-interleave-qwen-0.5b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">&gt;&gt;&gt; </span>    {
<span class="hljs-meta">&gt;&gt;&gt; </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">&gt;&gt;&gt; </span>        <span class="hljs-string">&quot;content&quot;</span>: [
<span class="hljs-meta">&gt;&gt;&gt; </span>            {
<span class="hljs-meta">&gt;&gt;&gt; </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>,
<span class="hljs-meta">&gt;&gt;&gt; </span>                <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://qianwen-res.oss-cn-beijing.aliyuncs.com/Qwen-VL/assets/demo.jpeg&quot;</span>,
<span class="hljs-meta">&gt;&gt;&gt; </span>            },
<span class="hljs-meta">&gt;&gt;&gt; </span>            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe this image.&quot;</span>},
<span class="hljs-meta">&gt;&gt;&gt; </span>        ],
<span class="hljs-meta">&gt;&gt;&gt; </span>    },
<span class="hljs-meta">&gt;&gt;&gt; </span>    {
<span class="hljs-meta">&gt;&gt;&gt; </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
<span class="hljs-meta">&gt;&gt;&gt; </span>        <span class="hljs-string">&quot;content&quot;</span>: [
<span class="hljs-meta">&gt;&gt;&gt; </span>            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;There is a dog and&quot;</span>},
<span class="hljs-meta">&gt;&gt;&gt; </span>        ],
<span class="hljs-meta">&gt;&gt;&gt; </span>    },
<span class="hljs-meta">&gt;&gt;&gt; </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(text=messages, max_new_tokens=<span class="hljs-number">20</span>, return_full_text=<span class="hljs-literal">False</span>)
[{<span class="hljs-string">&#x27;input_text&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>,
    <span class="hljs-string">&#x27;content&#x27;</span>: [{<span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;image&#x27;</span>,
    <span class="hljs-string">&#x27;url&#x27;</span>: <span class="hljs-string">&#x27;https://qianwen-res.oss-cn-beijing.aliyuncs.com/Qwen-VL/assets/demo.jpeg&#x27;</span>},
    {<span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Describe this image.&#x27;</span>}]},
{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>,
    <span class="hljs-string">&#x27;content&#x27;</span>: [{<span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;There is a dog and&#x27;</span>}]}],
<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27; a person in the image. The dog is sitting on the sand, and the person is sitting on&#x27;</span>}]`,wrap:!1}}),{c(){g(o.$$.fragment)},l(h){f(o.$$.fragment,h)},m(h,p){u(o,h,p),_=!0},p:$,i(h){_||(T(o.$$.fragment,h),_=!0)},o(h){y(o.$$.fragment,h),_=!1},d(h){b(o,h)}}}function mM(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJmYWNlYm9vayUyRnNhbS12aXQtYmFzZSUyMiUyQyUyMHRhc2slM0QlMjJtYXNrLWdlbmVyYXRpb24lMjIpJTBBb3V0cHV0cyUyMCUzRCUyMGdlbmVyYXRvciglMEElMjAlMjAlMjAlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTJDJTBBKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBnZW5lcmF0b3IoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGaW1hZ2VfZHVtbXklMkZyYXclMkZtYWluJTJGcGFycm90cy5wbmclMjIlMkMlMjBwb2ludHNfcGVyX2JhdGNoJTNEMTI4JTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(model=<span class="hljs-string">&quot;facebook/sam-vit-base&quot;</span>, task=<span class="hljs-string">&quot;mask-generation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = generator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = generator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/image_dummy/raw/main/parrots.png&quot;</span>, points_per_batch=<span class="hljs-number">128</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function hM(M){let o,_="Example:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBb3JhY2xlJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJkYW5kZWxpbiUyRnZpbHQtYjMyLWZpbmV0dW5lZC12cWElMjIpJTBBaW1hZ2VfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGaW1hZ2VfZHVtbXklMkZyYXclMkZtYWluJTJGbGVuYS5wbmclMjIlMEFvcmFjbGUocXVlc3Rpb24lM0QlMjJXaGF0JTIwaXMlMjBzaGUlMjB3ZWFyaW5nJTIwJTNGJTIyJTJDJTIwaW1hZ2UlM0RpbWFnZV91cmwpJTBBJTBBb3JhY2xlKHF1ZXN0aW9uJTNEJTIyV2hhdCUyMGlzJTIwc2hlJTIwd2VhcmluZyUyMCUzRiUyMiUyQyUyMGltYWdlJTNEaW1hZ2VfdXJsJTJDJTIwdG9wX2slM0QxKSUwQSUwQW9yYWNsZShxdWVzdGlvbiUzRCUyMklzJTIwdGhpcyUyMGElMjBwZXJzb24lMjAlM0YlMjIlMkMlMjBpbWFnZSUzRGltYWdlX3VybCUyQyUyMHRvcF9rJTNEMSklMEElMEFvcmFjbGUocXVlc3Rpb24lM0QlMjJJcyUyMHRoaXMlMjBhJTIwbWFuJTIwJTNGJTIyJTJDJTIwaW1hZ2UlM0RpbWFnZV91cmwlMkMlMjB0b3BfayUzRDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>oracle = pipeline(model=<span class="hljs-string">&quot;dandelin/vilt-b32-finetuned-vqa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/image_dummy/raw/main/lena.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>oracle(question=<span class="hljs-string">&quot;What is she wearing ?&quot;</span>, image=image_url)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.948</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;hat&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.009</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;fedora&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.003</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;clothes&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.003</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;sun hat&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.002</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;nothing&#x27;</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span>oracle(question=<span class="hljs-string">&quot;What is she wearing ?&quot;</span>, image=image_url, top_k=<span class="hljs-number">1</span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.948</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;hat&#x27;</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span>oracle(question=<span class="hljs-string">&quot;Is this a person ?&quot;</span>, image=image_url, top_k=<span class="hljs-number">1</span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.993</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;yes&#x27;</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span>oracle(question=<span class="hljs-string">&quot;Is this a man ?&quot;</span>, image=image_url, top_k=<span class="hljs-number">1</span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.996</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;no&#x27;</span>}]`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function gM(M){let o,_="Examples:",h,p,x;return p=new v({props:{code:"JTIzJTIwRXhwbGljaXRseSUyMGFzayUyMGZvciUyMHRlbnNvciUyMGFsbG9jYXRpb24lMjBvbiUyMENVREElMjBkZXZpY2UlMjAlM0EwJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKC4uLiUyQyUyMGRldmljZSUzRDApJTBBd2l0aCUyMHBpcGUuZGV2aWNlX3BsYWNlbWVudCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRXZlcnklMjBmcmFtZXdvcmslMjBzcGVjaWZpYyUyMHRlbnNvciUyMGFsbG9jYXRpb24lMjB3aWxsJTIwYmUlMjBkb25lJTIwb24lMjB0aGUlMjByZXF1ZXN0JTIwZGV2aWNlJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwcGlwZSguLi4p",highlighted:`<span class="hljs-comment"># Explicitly ask for tensor allocation on CUDA device :0</span>
pipe = pipeline(..., device=<span class="hljs-number">0</span>)
<span class="hljs-keyword">with</span> pipe.device_placement():
    <span class="hljs-comment"># Every framework specific tensor allocation will be done on the request device</span>
    output = pipe(...)`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-kvfsh7"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function fM(M){let o,_="Examples:",h,p,x;return p=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFB1c2glMjB0aGUlMjBwaXBlJTIwdG8lMjB5b3VyJTIwbmFtZXNwYWNlJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtYmVydCUyMi4lMEFwaXBlLnB1c2hfdG9faHViKCUyMm15LWZpbmV0dW5lZC1iZXJ0JTIyKSUwQSUwQSUyMyUyMFB1c2glMjB0aGUlMjBwaXBlJTIwdG8lMjBhbiUyMG9yZ2FuaXphdGlvbiUyMHdpdGglMjB0aGUlMjBuYW1lJTIwJTIybXktZmluZXR1bmVkLWJlcnQlMjIuJTBBcGlwZS5wdXNoX3RvX2h1YiglMjJodWdnaW5nZmFjZSUyRm15LWZpbmV0dW5lZC1iZXJ0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-comment"># Push the pipe to your namespace with the name &quot;my-finetuned-bert&quot;.</span>
pipe.push_to_hub(<span class="hljs-string">&quot;my-finetuned-bert&quot;</span>)

<span class="hljs-comment"># Push the pipe to an organization with the name &quot;my-finetuned-bert&quot;.</span>
pipe.push_to_hub(<span class="hljs-string">&quot;huggingface/my-finetuned-bert&quot;</span>)`,wrap:!1}}),{c(){o=r("p"),o.textContent=_,h=s(),g(p.$$.fragment)},l(t){o=i(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-kvfsh7"&&(o.textContent=_),h=a(t),f(p.$$.fragment,t)},m(t,w){m(t,o,w),m(t,h,w),u(p,t,w),x=!0},p:$,i(t){x||(T(p.$$.fragment,t),x=!0)},o(t){y(p.$$.fragment,t),x=!1},d(t){t&&(l(o),l(h)),b(p,t)}}}function uM(M){let o,_,h,p,x,t,w,Hc='pipelines是使用模型进行推理的一种简单方法。这些pipelines是抽象了库中大部分复杂代码的对象，提供了一个专用于多个任务的简单API，包括专名识别、掩码语言建模、情感分析、特征提取和问答等。请参阅<a href="../task_summary">任务摘要</a>以获取使用示例。',Yc,Pn,KT="有两种pipelines抽象类需要注意：",Ec,Cn,ey='<li><a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a>，它是封装所有其他pipelines的最强大的对象。</li> <li>针对特定任务pipelines，适用于<a href="#audio">音频</a>、<a href="#computer-vision">计算机视觉</a>、<a href="#natural-language-processing">自然语言处理</a>和<a href="#multimodal">多模态</a>任务。</li>',Qc,In,Xc,qn,ty="<em>pipeline</em>抽象类是对所有其他可用pipeline的封装。它可以像任何其他pipeline一样实例化，但进一步提供额外的便利性。",Kc,zn,ny="简单调用一个项目：",ep,Gn,tp,Zn,sy='如果您想使用 <a href="https://huggingface.co" rel="nofollow">hub</a> 上的特定模型，可以忽略任务，如果hub上的模型已经定义了该任务：',np,Fn,sp,Bn,ay="要在多个项目上调用pipeline，可以使用<em>列表</em>调用它。",ap,Rn,op,Dn,oy="为了遍历整个数据集，建议直接使用 <code>dataset</code>。这意味着您不需要一次性分配整个数据集，也不需要自己进行批处理。这应该与GPU上的自定义循环一样快。如果不是，请随时提出issue。",rp,Nn,ip,Ln,ry="为了方便使用，也可以使用生成器：",lp,An,cp,_e,Vn,vm,er,iy='Utility factory method to build a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.Pipeline">Pipeline</a>.',$m,tr,ly="A pipeline consists of:",Jm,nr,cy=`<li>One or more components for pre-processing model inputs, such as a <a href="tokenizer">tokenizer</a>,
<a href="image_processor">image_processor</a>, <a href="feature_extractor">feature_extractor</a>, or <a href="processors">processor</a>.</li> <li>A <a href="model">model</a> that generates predictions from the inputs.</li> <li>Optional post-processing steps to refine the model’s output, which can also be handled by processors.</li>`,Pm,Xe,Cm,Ke,pp,Wn,dp,Sn,py="所有pipeline都可以使用批处理。这将在pipeline使用其流处理功能时起作用（即传递列表或 <code>Dataset</code> 或 <code>generator</code> 时）。",mp,Hn,hp,et,gp,On,fp,Yn,up,En,dy="主要是减速的示例：",Tp,Qn,yp,Xn,my="与其他句子相比，这是一个非常长的句子。在这种情况下，<strong>整个</strong>批次将需要400个tokens的长度，因此整个批次将是 [64, 400] 而不是 [64, 4]，从而导致较大的减速。更糟糕的是，在更大的批次上，程序会崩溃。",bp,Kn,xp,es,hy="对于这个问题，没有好的（通用）解决方案，效果可能因您的用例而异。经验法则如下：",wp,ts,gy="对于用户，一个经验法则是：",_p,ns,fy="<li><strong>使用硬件测量负载性能。测量、测量、再测量。真实的数字是唯一的方法。</strong></li> <li>如果受到延迟的限制（进行推理的实时产品），不要进行批处理。</li> <li>如果使用CPU，不要进行批处理。</li> <li>如果您在GPU上处理的是吞吐量（您希望在大量静态数据上运行模型），则：<ul><li>如果对序列长度的大小没有概念（“自然”数据），默认情况下不要进行批处理，进行测试并尝试逐渐添加，添加OOM检查以在失败时恢复（如果您不能控制序列长度，它将在某些时候失败）。</li> <li>如果您的序列长度非常规律，那么批处理更有可能非常有趣，进行测试并推动它，直到出现OOM。</li> <li>GPU越大，批处理越有可能变得更有趣</li></ul></li> <li>一旦启用批处理，确保能够很好地处理OOM。</li>",Mp,ss,Up,as,uy="<code>zero-shot-classification</code> 和 <code>question-answering</code> 在某种意义上稍微特殊，因为单个输入可能会导致模型的多次前向传递。在正常情况下，这将导致 <code>batch_size</code> 参数的问题。",kp,os,Ty="为了规避这个问题，这两个pipeline都有点特殊，它们是 <code>ChunkPipeline</code> 而不是常规的 <code>Pipeline</code>。简而言之：",jp,rs,vp,is,yy="现在变成：",$p,ls,Jp,cs,by="这对您的代码应该是非常直观的，因为pipeline的使用方式是相同的。",Pp,ps,xy="这是一个简化的视图，因为Pipeline可以自动处理批次！这意味着您不必担心您的输入实际上会触发多少次前向传递，您可以独立于输入优化 <code>batch_size</code>。前面部分的注意事项仍然适用。",Cp,ds,Ip,ms,wy="如果您想要重载特定的pipeline。",qp,hs,_y="请随时为您手头的任务创建一个issue，Pipeline的目标是易于使用并支持大多数情况，因此 <code>transformers</code> 可能支持您的用例。",zp,gs,My="如果您想简单地尝试一下，可以：",Gp,fs,Uy="<li>继承您选择的pipeline</li>",Zp,us,Fp,Ts,ky="这样就可以让您编写所有想要的自定义代码。",Bp,ys,Rp,bs,jy='<a href="../add_new_pipeline">实现一个新的pipeline</a>',Dp,xs,Np,ws,vy="可用于音频任务的pipeline包括以下几种。",Lp,_s,Ap,re,Ms,Im,sr,$y=`Audio classification pipeline using any <code>AutoModelForAudioClassification</code>. This pipeline predicts the class of a
raw waveform or an audio file. In case of an audio file, ffmpeg should be installed to support multiple audio
formats.`,qm,tt,zm,ar,Jy='Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>',Gm,or,Py=`This pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task identifier:
<code>&quot;audio-classification&quot;</code>.`,Zm,rr,Cy=`See the list of available models on
<a href="https://huggingface.co/models?filter=audio-classification" rel="nofollow">huggingface.co/models</a>.`,Fm,nt,Us,Bm,ir,Iy=`Classify the sequence(s) given as inputs. See the <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.AutomaticSpeechRecognitionPipeline">AutomaticSpeechRecognitionPipeline</a> documentation for more
information.`,Vp,ks,Wp,Q,js,Rm,lr,qy="Pipeline that aims at extracting spoken text contained within some audio.",Dm,cr,zy=`The input can be either a raw waveform or a audio file. In case of the audio file, ffmpeg should be installed for
to support multiple audio formats`,Nm,pr,Gy=`Unless the model you’re using explicitly sets these generation parameters in its configuration files
(<code>generation_config.json</code>), the following default values will be used:`,Lm,dr,Zy="<li>max_new_tokens: 256</li> <li>num_beams: 5</li>",Am,st,Vm,mr,Fy='Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>',Wm,at,vs,Sm,hr,By=`Transcribe the audio sequence(s) given as inputs to text. See the <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.AutomaticSpeechRecognitionPipeline">AutomaticSpeechRecognitionPipeline</a>
documentation for more information.`,Sp,$s,Hp,G,Js,Hm,gr,Ry=`Text-to-audio generation pipeline using any <code>AutoModelForTextToWaveform</code> or <code>AutoModelForTextToSpectrogram</code>. This
pipeline generates an audio file from an input text and optional other conditional inputs.`,Om,fr,Dy=`Unless the model you’re using explicitly sets these generation parameters in its configuration files
(<code>generation_config.json</code>), the following default values will be used:`,Ym,ur,Ny="<li>max_new_tokens: 256</li>",Em,ot,Qm,Tr,Ly='Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>',Xm,rt,Km,yr,Ay=`This pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task identifiers: <code>&quot;text-to-speech&quot;</code> or
<code>&quot;text-to-audio&quot;</code>.`,eh,br,Vy='See the list of available models on <a href="https://huggingface.co/models?filter=text-to-speech" rel="nofollow">huggingface.co/models</a>.',th,it,Ps,nh,xr,Wy='Generates speech/audio from the inputs. See the <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.TextToAudioPipeline">TextToAudioPipeline</a> documentation for more information.',Op,Cs,Yp,Me,Is,sh,wr,Sy=`Zero shot audio classification pipeline using <code>ClapModel</code>. This pipeline predicts the class of an audio when you
provide an audio and a set of <code>candidate_labels</code>.`,ah,lt,oh,ct,rh,_r,Hy=`Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a> This audio
classification pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task identifier:
<code>&quot;zero-shot-audio-classification&quot;</code>. See the list of available models on
<a href="https://huggingface.co/models?filter=zero-shot-audio-classification" rel="nofollow">huggingface.co/models</a>.`,ih,pt,qs,lh,Mr,Oy="Assign labels to the audio(s) passed as inputs.",Ep,zs,Qp,Gs,Yy="可用于计算机视觉任务的pipeline包括以下几种。",Xp,Zs,Kp,ie,Fs,ch,Ur,Ey="Depth estimation pipeline using any <code>AutoModelForDepthEstimation</code>. This pipeline predicts the depth of an image.",ph,dt,dh,kr,Qy='Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>',mh,jr,Xy=`This depth estimation pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task identifier:
<code>&quot;depth-estimation&quot;</code>.`,hh,vr,Ky='See the list of available models on <a href="https://huggingface.co/models?filter=depth-estimation" rel="nofollow">huggingface.co/models</a>.',gh,mt,Bs,fh,$r,eb="Predict the depth(s) of the image(s) passed as inputs.",ed,Rs,td,le,Ds,uh,Jr,tb=`Image classification pipeline using any <code>AutoModelForImageClassification</code>. This pipeline predicts the class of an
image.`,Th,ht,yh,Pr,nb='Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>',bh,Cr,sb=`This image classification pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task identifier:
<code>&quot;image-classification&quot;</code>.`,xh,Ir,ab=`See the list of available models on
<a href="https://huggingface.co/models?filter=image-classification" rel="nofollow">huggingface.co/models</a>.`,wh,gt,Ns,_h,qr,ob="Assign labels to the image(s) passed as inputs.",nd,Ls,sd,Ue,As,Mh,zr,rb=`Image segmentation pipeline using any <code>AutoModelForXXXSegmentation</code>. This pipeline predicts masks of objects and
their classes.`,Uh,ft,kh,Gr,ib=`This image segmentation pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task identifier:
<code>&quot;image-segmentation&quot;</code>.`,jh,Zr,lb=`See the list of available models on
<a href="https://huggingface.co/models?filter=image-segmentation" rel="nofollow">huggingface.co/models</a>.`,vh,ut,Vs,$h,Fr,cb="Perform segmentation (detect masks & classes) in the image(s) passed as inputs.",ad,Ws,od,ke,Ss,Jh,Br,pb=`Image to Image pipeline using any <code>AutoModelForImageToImage</code>. This pipeline generates an image based on a previous
image input.`,Ph,Tt,Ch,Rr,db=`This image to image pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task identifier:
<code>&quot;image-to-image&quot;</code>.`,Ih,Dr,mb='See the list of available models on <a href="https://huggingface.co/models?filter=image-to-image" rel="nofollow">huggingface.co/models</a>.',qh,yt,Hs,zh,Nr,hb="Transform the image(s) passed as inputs.",rd,Os,id,ce,Ys,Gh,Lr,gb=`Object detection pipeline using any <code>AutoModelForObjectDetection</code>. This pipeline predicts bounding boxes of objects
and their classes.`,Zh,bt,Fh,Ar,fb='Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>',Bh,Vr,ub=`This object detection pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task identifier:
<code>&quot;object-detection&quot;</code>.`,Rh,Wr,Tb='See the list of available models on <a href="https://huggingface.co/models?filter=object-detection" rel="nofollow">huggingface.co/models</a>.',Dh,xt,Es,Nh,Sr,yb="Detect objects (bounding boxes & classes) in the image(s) passed as inputs.",ld,Qs,cd,Ge,Xs,Lh,Hr,bb=`Video classification pipeline using any <code>AutoModelForVideoClassification</code>. This pipeline predicts the class of a
video.`,Ah,Or,xb=`This video classification pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task identifier:
<code>&quot;video-classification&quot;</code>.`,Vh,Yr,wb=`See the list of available models on
<a href="https://huggingface.co/models?filter=video-classification" rel="nofollow">huggingface.co/models</a>.`,Wh,wt,Ks,Sh,Er,_b="Assign labels to the video(s) passed as inputs.",pd,ea,dd,pe,ta,Hh,Qr,Mb=`Zero shot image classification pipeline using <code>CLIPModel</code>. This pipeline predicts the class of an image when you
provide an image and a set of <code>candidate_labels</code>.`,Oh,_t,Yh,Xr,Ub='Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>',Eh,Kr,kb=`This image classification pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task identifier:
<code>&quot;zero-shot-image-classification&quot;</code>.`,Qh,ei,jb=`See the list of available models on
<a href="https://huggingface.co/models?filter=zero-shot-image-classification" rel="nofollow">huggingface.co/models</a>.`,Xh,Mt,na,Kh,ti,vb="Assign labels to the image(s) passed as inputs.",md,sa,hd,de,aa,eg,ni,$b=`Zero shot object detection pipeline using <code>OwlViTForObjectDetection</code>. This pipeline predicts bounding boxes of
objects when you provide an image and a set of <code>candidate_labels</code>.`,tg,Ut,ng,si,Jb='Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>',sg,ai,Pb=`This object detection pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task identifier:
<code>&quot;zero-shot-object-detection&quot;</code>.`,ag,oi,Cb=`See the list of available models on
<a href="https://huggingface.co/models?filter=zero-shot-object-detection" rel="nofollow">huggingface.co/models</a>.`,og,kt,oa,rg,ri,Ib="Detect objects (bounding boxes & classes) in the image(s) passed as inputs.",gd,ra,fd,ia,qb="可用于自然语言处理任务的pipeline包括以下几种。",ud,la,Td,R,ca,ig,ii,zb=`Masked language modeling prediction pipeline using any <code>ModelWithLMHead</code>. See the <a href="../task_summary#masked-language-modeling">masked language modeling
examples</a> for more information.`,lg,jt,cg,li,Gb='Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>',pg,ci,Zb=`This mask filling pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task identifier:
<code>&quot;fill-mask&quot;</code>.`,dg,pi,Fb=`The models that this pipeline can use are models that have been trained with a masked language modeling objective,
which includes the bi-directional models in the library. See the up-to-date list of available models on
<a href="https://huggingface.co/models?filter=fill-mask" rel="nofollow">huggingface.co/models</a>.`,mg,vt,hg,$t,gg,Jt,pa,fg,di,Bb="Fill the masked token in the text(s) given as inputs.",yd,da,bd,Z,ma,ug,mi,Rb=`Named Entity Recognition pipeline using any <code>ModelForTokenClassification</code>. See the <a href="../task_summary#named-entity-recognition">named entity recognition
examples</a> for more information.`,Tg,Pt,yg,hi,Db='Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>',bg,gi,Nb=`This token recognition pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task identifier:
<code>&quot;ner&quot;</code> (for predicting the classes of tokens in a sequence: person, organisation, location or miscellaneous).`,xg,fi,Lb=`The models that this pipeline can use are models that have been fine-tuned on a token classification task. See the
up-to-date list of available models on
<a href="https://huggingface.co/models?filter=token-classification" rel="nofollow">huggingface.co/models</a>.`,wg,Ve,ha,_g,ui,Ab="Override tokens from a given word that disagree to force agreement on word boundaries.",Mg,Ti,Vb=`Example: micro|soft| com|pany| B-ENT I-NAME I-ENT I-ENT will be rewritten with first strategy as microsoft|
company| B-ENT I-ENT`,Ug,Ct,ga,kg,yi,Wb="Fuse various numpy arrays into dicts with all the information needed for aggregation",jg,It,fa,vg,bi,Sb="Find and group together the adjacent tokens with the same entity predicted.",$g,qt,ua,Jg,xi,Hb="Group together the adjacent tokens with the same entity predicted.",xd,Ta,Ob='See <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.TokenClassificationPipeline">TokenClassificationPipeline</a> for all details.',wd,ya,_d,D,ba,Pg,wi,Yb=`Question Answering pipeline using any <code>ModelForQuestionAnswering</code>. See the <a href="../task_summary#question-answering">question answering
examples</a> for more information.`,Cg,zt,Ig,_i,Eb='Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>',qg,Mi,Qb=`This question answering pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task identifier:
<code>&quot;question-answering&quot;</code>.`,zg,Ui,Xb=`The models that this pipeline can use are models that have been fine-tuned on a question answering task. See the
up-to-date list of available models on
<a href="https://huggingface.co/models?filter=question-answering" rel="nofollow">huggingface.co/models</a>.`,Gg,Gt,xa,Zg,ki,Kb="Answer the question(s) given as inputs by using the context(s).",Fg,We,wa,Bg,ji,ex=`QuestionAnsweringPipeline leverages the <code>SquadExample</code> internally. This helper method encapsulate all the
logic for converting question(s) and context(s) to <code>SquadExample</code>.`,Rg,vi,tx="We currently support extractive question answering.",Dg,Zt,_a,Ng,$i,nx="When decoding from token probabilities, this method maps token indexes to actual word in the initial context.",Md,Ma,Ud,X,Ua,Lg,Ji,sx="Summarize news articles and other documents.",Ag,Pi,ax=`This summarizing pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task identifier:
<code>&quot;summarization&quot;</code>.`,Vg,Ci,ox=`The models that this pipeline can use are models that have been fine-tuned on a summarization task, which is
currently, ’<em>bart-large-cnn</em>’, ’<em>google-t5/t5-small</em>’, ’<em>google-t5/t5-base</em>’, ’<em>google-t5/t5-large</em>’, ’<em>google-t5/t5-3b</em>’, ’<em>google-t5/t5-11b</em>’. See the up-to-date
list of available models on <a href="https://huggingface.co/models?filter=summarization" rel="nofollow">huggingface.co/models</a>. For a list
of available parameters, see the <a href="https://huggingface.co/docs/transformers/en/main_classes/text_generation#transformers.generation.GenerationMixin.generate" rel="nofollow">following
documentation</a>`,Wg,Ii,rx=`Unless the model you’re using explicitly sets these generation parameters in its configuration files
(<code>generation_config.json</code>), the following default values will be used:`,Sg,qi,ix="<li>max_new_tokens: 256</li> <li>num_beams: 4</li>",Hg,Ft,Og,Bt,ka,Yg,zi,lx="Summarize the text(s) given as inputs.",kd,ja,jd,N,va,Eg,Gi,cx=`Table Question Answering pipeline using a <code>ModelForTableQuestionAnswering</code>. This pipeline is only available in
PyTorch.`,Qg,Zi,px=`Unless the model you’re using explicitly sets these generation parameters in its configuration files
(<code>generation_config.json</code>), the following default values will be used:`,Xg,Fi,dx="<li>max_new_tokens: 256</li>",Kg,Rt,ef,Bi,mx='Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>',tf,Ri,hx=`This tabular question answering pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task
identifier: <code>&quot;table-question-answering&quot;</code>.`,nf,Di,gx=`The models that this pipeline can use are models that have been fine-tuned on a tabular question answering task.
See the up-to-date list of available models on
<a href="https://huggingface.co/models?filter=table-question-answering" rel="nofollow">huggingface.co/models</a>.`,sf,Te,$a,af,Ni,fx="Answers queries according to a table. The pipeline accepts several types of inputs which are detailed below:",of,Li,ux="<li><code>pipeline(table, query)</code></li> <li><code>pipeline(table, [query])</code></li> <li><code>pipeline(table=table, query=query)</code></li> <li><code>pipeline(table=table, query=[query])</code></li> <li><code>pipeline({&quot;table&quot;: table, &quot;query&quot;: query})</code></li> <li><code>pipeline({&quot;table&quot;: table, &quot;query&quot;: [query]})</code></li> <li><code>pipeline([{&quot;table&quot;: table, &quot;query&quot;: query}, {&quot;table&quot;: table, &quot;query&quot;: query}])</code></li>",rf,Ai,Tx="The <code>table</code> argument should be a dict or a DataFrame built from that dict, containing the whole table:",lf,Dt,cf,Vi,yx="This dictionary can be passed in as such, or can be converted to a pandas DataFrame:",pf,Nt,vd,Ja,$d,K,Pa,df,Wi,bx=`Text classification pipeline using any <code>ModelForSequenceClassification</code>. See the <a href="../task_summary#sequence-classification">sequence classification
examples</a> for more information.`,mf,Lt,hf,Si,xx='Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>',gf,Hi,wx=`This text classification pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task identifier:
<code>&quot;sentiment-analysis&quot;</code> (for classifying sequences according to positive or negative sentiments).`,ff,Oi,_x=`If multiple classification labels are available (<code>model.config.num_labels &gt;= 2</code>), the pipeline will run a softmax
over the results. If there is a single label, the pipeline will run a sigmoid over the result. In case of regression
tasks (<code>model.config.problem_type == &quot;regression&quot;</code>), will not apply any function on the output.`,uf,Yi,Mx=`The models that this pipeline can use are models that have been fine-tuned on a sequence classification task. See
the up-to-date list of available models on
<a href="https://huggingface.co/models?filter=text-classification" rel="nofollow">huggingface.co/models</a>.`,Tf,At,Ca,yf,Ei,Ux="Classify the text(s) given as inputs.",Jd,Ia,Pd,F,qa,bf,Qi,kx=`Language generation pipeline using any <code>ModelWithLMHead</code> or <code>ModelForCausalLM</code>. This pipeline predicts the words
that will follow a specified text prompt. When the underlying model is a conversational model, it can also accept
one or more chats, in which case the pipeline will operate in chat mode and will continue the chat(s) by adding
its response(s). Each chat takes the form of a list of dicts, where each dict contains “role” and “content” keys.`,xf,Xi,jx=`Unless the model you’re using explicitly sets these generation parameters in its configuration files
(<code>generation_config.json</code>), the following default values will be used:`,wf,Ki,vx="<li>max_new_tokens: 256</li> <li>do_sample: True</li> <li>temperature: 0.7</li>",_f,Vt,Mf,Wt,Uf,el,$x=`Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>. You can pass text
generation parameters to this pipeline to control stopping criteria, decoding strategy, and more. Learn more about
text generation parameters in <a href="../generation_strategies">Text generation strategies</a> and <a href="text_generation">Text
generation</a>.`,kf,tl,Jx=`This language generation pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task identifier:
<code>&quot;text-generation&quot;</code>.`,jf,nl,Px=`The models that this pipeline can use are models that have been trained with an autoregressive language modeling
objective. See the list of available <a href="https://huggingface.co/models?filter=text-generation" rel="nofollow">text completion models</a>
and the list of <a href="https://huggingface.co/models?other=conversational" rel="nofollow">conversational models</a>
on [huggingface.co/models].`,vf,St,za,$f,sl,Cx="Complete the prompt(s) given as inputs.",Cd,Ga,Id,q,Za,Jf,al,Ix="Pipeline for text to text generation using seq2seq models.",Pf,ol,qx=`Unless the model you’re using explicitly sets these generation parameters in its configuration files
(<code>generation_config.json</code>), the following default values will be used:`,Cf,rl,zx="<li>max_new_tokens: 256</li> <li>num_beams: 4</li>",If,Ht,qf,il,Gx=`Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>. You can pass text
generation parameters to this pipeline to control stopping criteria, decoding strategy, and more. Learn more about
text generation parameters in <a href="../generation_strategies">Text generation strategies</a> and <a href="text_generation">Text
generation</a>.`,zf,ll,Zx=`This Text2TextGenerationPipeline pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task
identifier: <code>&quot;text2text-generation&quot;</code>.`,Gf,cl,Fx=`The models that this pipeline can use are models that have been fine-tuned on a translation task. See the
up-to-date list of available models on
<a href="https://huggingface.co/models?filter=text2text-generation" rel="nofollow">huggingface.co/models</a>. For a list of available
parameters, see the <a href="https://huggingface.co/docs/transformers/en/main_classes/text_generation#transformers.generation.GenerationMixin.generate" rel="nofollow">following
documentation</a>`,Zf,Ot,Ff,Yt,Fa,Bf,pl,Bx="Generate the output text(s) using text(s) given as inputs.",Rf,Et,Ba,Df,dl,Rx="Checks whether there might be something wrong with given input with regard to the model.",qd,Ra,zd,z,Da,Nf,ml,Dx=`Named Entity Recognition pipeline using any <code>ModelForTokenClassification</code>. See the <a href="../task_summary#named-entity-recognition">named entity recognition
examples</a> for more information.`,Lf,Qt,Af,hl,Nx='Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>',Vf,gl,Lx=`This token recognition pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task identifier:
<code>&quot;ner&quot;</code> (for predicting the classes of tokens in a sequence: person, organisation, location or miscellaneous).`,Wf,fl,Ax=`The models that this pipeline can use are models that have been fine-tuned on a token classification task. See the
up-to-date list of available models on
<a href="https://huggingface.co/models?filter=token-classification" rel="nofollow">huggingface.co/models</a>.`,Sf,Xt,Na,Hf,ul,Vx="Classify each token of the text(s) given as inputs.",Of,Se,La,Yf,Tl,Wx="Override tokens from a given word that disagree to force agreement on word boundaries.",Ef,yl,Sx=`Example: micro|soft| com|pany| B-ENT I-NAME I-ENT I-ENT will be rewritten with first strategy as microsoft|
company| B-ENT I-ENT`,Qf,Kt,Aa,Xf,bl,Hx="Fuse various numpy arrays into dicts with all the information needed for aggregation",Kf,en,Va,eu,xl,Ox="Find and group together the adjacent tokens with the same entity predicted.",tu,tn,Wa,nu,wl,Yx="Group together the adjacent tokens with the same entity predicted.",Gd,Sa,Zd,ee,Ha,su,_l,Ex="Translates from one language to another.",au,Ml,Qx=`This translation pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task identifier:
<code>&quot;translation_xx_to_yy&quot;</code>.`,ou,Ul,Xx=`The models that this pipeline can use are models that have been fine-tuned on a translation task. See the
up-to-date list of available models on <a href="https://huggingface.co/models?filter=translation" rel="nofollow">huggingface.co/models</a>.
For a list of available parameters, see the <a href="https://huggingface.co/docs/transformers/en/main_classes/text_generation#transformers.generation.GenerationMixin.generate" rel="nofollow">following
documentation</a>`,ru,kl,Kx=`Unless the model you’re using explicitly sets these generation parameters in its configuration files
(<code>generation_config.json</code>), the following default values will be used:`,iu,jl,ew="<li>max_new_tokens: 256</li> <li>num_beams: 4</li>",lu,nn,cu,sn,Oa,pu,vl,tw="Translate the text(s) given as inputs.",Fd,Ya,Bd,te,Ea,du,$l,nw=`NLI-based zero-shot classification pipeline using a <code>ModelForSequenceClassification</code> trained on NLI (natural
language inference) tasks. Equivalent of <code>text-classification</code> pipelines, but these models don’t require a
hardcoded number of potential classes, they can be chosen at runtime. It usually means it’s slower but it is
<strong>much</strong> more flexible.`,mu,Jl,sw=`Any combination of sequences and labels can be passed and each combination will be posed as a premise/hypothesis
pair and passed to the pretrained model. Then, the logit for <em>entailment</em> is taken as the logit for the candidate
label being valid. Any NLI model can be used, but the id of the <em>entailment</em> label must be included in the model
config’s :attr:<em>~transformers.PretrainedConfig.label2id</em>.`,hu,an,gu,Pl,aw='Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>',fu,Cl,ow=`This NLI pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task identifier:
<code>&quot;zero-shot-classification&quot;</code>.`,uu,Il,rw=`The models that this pipeline can use are models that have been fine-tuned on an NLI task. See the up-to-date list
of available models on <a href="https://huggingface.co/models?search=nli" rel="nofollow">huggingface.co/models</a>.`,Tu,on,Qa,yu,ql,iw=`Classify the sequence(s) given as inputs. See the <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.ZeroShotClassificationPipeline">ZeroShotClassificationPipeline</a> documentation for more
information.`,Rd,Xa,Dd,Ka,lw="可用于多模态任务的pipeline包括以下几种。",Nd,eo,Ld,L,to,bu,zl,cw=`Document Question Answering pipeline using any <code>AutoModelForDocumentQuestionAnswering</code>. The inputs/outputs are
similar to the (extractive) question answering pipeline; however, the pipeline takes an image (and optional OCR’d
words/boxes) as input instead of text context.`,xu,Gl,pw=`Unless the model you’re using explicitly sets these generation parameters in its configuration files
(<code>generation_config.json</code>), the following default values will be used:`,wu,Zl,dw="<li>max_new_tokens: 256</li>",_u,rn,Mu,Fl,mw='Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>',Uu,Bl,hw=`This document question answering pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task
identifier: <code>&quot;document-question-answering&quot;</code>.`,ku,Rl,gw=`The models that this pipeline can use are models that have been fine-tuned on a document question answering task.
See the up-to-date list of available models on
<a href="https://huggingface.co/models?filter=document-question-answering" rel="nofollow">huggingface.co/models</a>.`,ju,Ae,no,vu,Dl,fw=`Answer the question(s) given as inputs by using the document(s). A document is defined as an image and an
optional list of (word, box) tuples which represent the text in the document. If the <code>word_boxes</code> are not
provided, it will use the Tesseract OCR engine (if available) to extract the words and boxes automatically for
LayoutLM-like models which require them as input. For Donut, no OCR is run.`,$u,Nl,uw="You can invoke the pipeline several ways:",Ju,Ll,Tw="<li><code>pipeline(image=image, question=question)</code></li> <li><code>pipeline(image=image, question=question, word_boxes=word_boxes)</code></li> <li><code>pipeline([{&quot;image&quot;: image, &quot;question&quot;: question}])</code></li> <li><code>pipeline([{&quot;image&quot;: image, &quot;question&quot;: question, &quot;word_boxes&quot;: word_boxes}])</code></li>",Ad,so,Vd,me,ao,Pu,Al,yw=`Feature extraction pipeline uses no model head. This pipeline extracts the hidden states from the base
transformer, which can be used as features in downstream tasks.`,Cu,ln,Iu,Vl,bw='Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>',qu,Wl,xw=`This feature extraction pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the task identifier:
<code>&quot;feature-extraction&quot;</code>.`,zu,Sl,ww=`All models may be used for this pipeline. See a list of all models, including community-contributed models on
<a href="https://huggingface.co/models" rel="nofollow">huggingface.co/models</a>.`,Gu,cn,oo,Zu,Hl,_w="Extract the features of the input(s).",Wd,ro,Sd,he,io,Fu,Ol,Mw=`Image feature extraction pipeline uses no model head. This pipeline extracts the hidden states from the base
transformer, which can be used as features in downstream tasks.`,Bu,pn,Ru,Yl,Uw='Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>',Du,El,kw=`This image feature extraction pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the task identifier:
<code>&quot;image-feature-extraction&quot;</code>.`,Nu,Ql,jw=`All vision models may be used for this pipeline. See a list of all models, including community-contributed models on
<a href="https://huggingface.co/models" rel="nofollow">huggingface.co/models</a>.`,Lu,dn,lo,Au,Xl,vw="Extract the features of the input(s).",Hd,co,Od,A,po,Vu,Kl,$w="Image To Text pipeline using a <code>AutoModelForVision2Seq</code>. This pipeline predicts a caption for a given image.",Wu,ec,Jw=`Unless the model you’re using explicitly sets these generation parameters in its configuration files
(<code>generation_config.json</code>), the following default values will be used:`,Su,tc,Pw="<li>max_new_tokens: 256</li>",Hu,mn,Ou,nc,Cw='Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>',Yu,sc,Iw=`This image to text pipeline can currently be loaded from pipeline() using the following task identifier:
“image-to-text”.`,Eu,ac,qw=`See the list of available models on
<a href="https://huggingface.co/models?pipeline_tag=image-to-text" rel="nofollow">huggingface.co/models</a>.`,Qu,hn,mo,Xu,oc,zw="Assign labels to the image(s) passed as inputs.",Yd,ho,Ed,B,go,Ku,rc,Gw=`Image-text-to-text pipeline using an <code>AutoModelForImageTextToText</code>. This pipeline generates text given an image and text.
When the underlying model is a conversational model, it can also accept one or more chats,
in which case the pipeline will operate in chat mode and will continue the chat(s) by adding its response(s).
Each chat takes the form of a list of dicts, where each dict contains “role” and “content” keys.`,eT,ic,Zw=`Unless the model you’re using explicitly sets these generation parameters in its configuration files
(<code>generation_config.json</code>), the following default values will be used:`,tT,lc,Fw="<li>max_new_tokens: 256</li>",nT,gn,sT,fn,aT,cc,Bw='Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>',oT,pc,Rw=`This image-text to text pipeline can currently be loaded from pipeline() using the following task identifier:
“image-text-to-text”.`,rT,dc,Dw=`See the list of available models on
<a href="https://huggingface.co/models?pipeline_tag=image-text-to-text" rel="nofollow">huggingface.co/models</a>.`,iT,un,fo,lT,mc,Nw="Generate a text given text and the image(s) passed as inputs.",Qd,uo,Xd,V,To,cT,hc,Lw=`Automatic mask generation for images using <code>SamForMaskGeneration</code>. This pipeline predicts binary masks for an
image, given an image. It is a <code>ChunkPipeline</code> because you can separate the points in a mini-batch in order to
avoid OOM issues. Use the <code>points_per_batch</code> argument to control the number of points that will be processed at the
same time. Default is <code>64</code>.`,pT,gc,Aw="The pipeline works in 3 steps:",dT,fc,Vw=`<li><p><code>preprocess</code>: A grid of 1024 points evenly separated is generated along with bounding boxes and point
labels.
For more details on how the points and bounding boxes are created, check the <code>_generate_crop_boxes</code>
function. The image is also preprocessed using the <code>image_processor</code>. This function <code>yields</code> a minibatch of
<code>points_per_batch</code>.</p></li> <li><p><code>forward</code>: feeds the outputs of <code>preprocess</code> to the model. The image embedding is computed only once.
Calls both <code>self.model.get_image_embeddings</code> and makes sure that the gradients are not computed, and the
tensors and models are on the same device.</p></li> <li><p><code>postprocess</code>: The most important part of the automatic mask generation happens here. Three steps
are induced:</p> <ul><li>image_processor.postprocess_masks (run on each minibatch loop): takes in the raw output masks,
resizes them according
to the image size, and transforms there to binary masks.</li> <li>image_processor.filter_masks (on each minibatch loop): uses both <code>pred_iou_thresh</code> and
<code>stability_scores</code>. Also
applies a variety of filters based on non maximum suppression to remove bad masks.</li> <li>image_processor.postprocess_masks_for_amg applies the NSM on the mask to only keep relevant ones.</li></ul></li>`,mT,Tn,hT,uc,Ww='Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>',gT,Tc,Sw=`This segmentation pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task identifier:
<code>&quot;mask-generation&quot;</code>.`,fT,yc,Hw='See the list of available models on <a href="https://huggingface.co/models?filter=mask-generation" rel="nofollow">huggingface.co/models</a>.',uT,yn,yo,TT,bc,Ow="Generates binary segmentation masks",Kd,bo,em,W,xo,yT,xc,Yw=`Visual Question Answering pipeline using a <code>AutoModelForVisualQuestionAnswering</code>. This pipeline is currently only
available in PyTorch.`,bT,wc,Ew=`Unless the model you’re using explicitly sets these generation parameters in its configuration files
(<code>generation_config.json</code>), the following default values will be used:`,xT,_c,Qw="<li>max_new_tokens: 256</li>",wT,bn,_T,Mc,Xw='Learn more about the basics of using a pipeline in the <a href="../pipeline_tutorial">pipeline tutorial</a>',MT,Uc,Kw=`This visual question answering pipeline can currently be loaded from <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.pipeline">pipeline()</a> using the following task
identifiers: <code>&quot;visual-question-answering&quot;, &quot;vqa&quot;</code>.`,UT,kc,e_=`The models that this pipeline can use are models that have been fine-tuned on a visual question answering task. See
the up-to-date list of available models on
<a href="https://huggingface.co/models?filter=visual-question-answering" rel="nofollow">huggingface.co/models</a>.`,kT,He,wo,jT,jc,t_=`Answers open-ended questions about images. The pipeline accepts several types of inputs which are detailed
below:`,vT,vc,n_="<li><code>pipeline(image=image, question=question)</code></li> <li><code>pipeline({&quot;image&quot;: image, &quot;question&quot;: question})</code></li> <li><code>pipeline([{&quot;image&quot;: image, &quot;question&quot;: question}])</code></li> <li><code>pipeline([{&quot;image&quot;: image, &quot;question&quot;: question}, {&quot;image&quot;: image, &quot;question&quot;: question}])</code></li>",tm,_o,nm,C,Mo,$T,$c,s_=`The Pipeline class is the class from which all pipelines inherit. Refer to this class for methods shared across
different pipelines.`,JT,Jc,a_=`Base class implementing pipelined operations. Pipeline workflow is defined as a sequence of the following
operations:`,PT,Pc,o_="Input -> Tokenization -> Model Inference -> Post-Processing (task dependent) -> Output",CT,Cc,r_="Pipeline supports running on CPU or GPU through the device argument (see below).",IT,Ic,i_=`Some pipeline, like for instance <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.FeatureExtractionPipeline">FeatureExtractionPipeline</a> (<code>&#39;feature-extraction&#39;</code>) output large tensor object
as nested-lists. In order to avoid dumping such large structure as textual data we provide the <code>binary_output</code>
constructor argument. If set to <code>True</code>, the output will be stored in the pickle format.`,qT,xn,Uo,zT,qc,l_="Check if the model class is in supported by the pipeline.",GT,Oe,ko,ZT,zc,c_="Context Manager allowing tensor allocation on the user-specified device in framework agnostic way.",FT,wn,BT,_n,jo,RT,Gc,p_="Ensure PyTorch tensors are on the specified device.",DT,Mn,vo,NT,Zc,d_=`Postprocess will receive the raw outputs of the <code>_forward</code> method, generally tensors, and reformat them into
something more friendly. Generally it will output a list or a dict or results (containing just strings and
numbers).`,LT,Un,$o,AT,Fc,m_="Scikit / Keras interface to transformers’ pipelines. This method will forward to <strong>call</strong>().",VT,kn,Jo,WT,Bc,h_=`Preprocess will take the <code>input_</code> of a specific pipeline and return a dictionary of everything necessary for
<code>_forward</code> to run properly. It should contain at least one tensor, but might have arbitrary other items.`,ST,Ye,Po,HT,Rc,g_="Upload the pipeline file to the 🤗 Model Hub.",OT,jn,YT,vn,Co,ET,Dc,f_="Save the pipeline’s model and tokenizer.",QT,$n,Io,XT,Nc,u_="Scikit / Keras interface to transformers’ pipelines. This method will forward to <strong>call</strong>().",sm,qo,am,Oc,om;return x=new J({props:{title:"Pipelines",local:"pipelines",headingTag:"h1"}}),In=new J({props:{title:"pipeline抽象类",local:"transformers.pipeline",headingTag:"h2"}}),Gn=new v({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIpJTBBcGlwZSglMjJUaGlzJTIwcmVzdGF1cmFudCUyMGlzJTIwYXdlc29tZSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This restaurant is awesome&quot;</span>)
[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;POSITIVE&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9998743534088135</span>}]`,wrap:!1}}),Fn=new v({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyRmFjZWJvb2tBSSUyRnJvYmVydGEtbGFyZ2UtbW5saSUyMiklMEFwaXBlKCUyMlRoaXMlMjByZXN0YXVyYW50JTIwaXMlMjBhd2Vzb21lJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(model=<span class="hljs-string">&quot;FacebookAI/roberta-large-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This restaurant is awesome&quot;</span>)
[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;NEUTRAL&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.7313136458396912</span>}]`,wrap:!1}}),Rn=new v({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIpJTBBcGlwZSglNUIlMjJUaGlzJTIwcmVzdGF1cmFudCUyMGlzJTIwYXdlc29tZSUyMiUyQyUyMCUyMlRoaXMlMjByZXN0YXVyYW50JTIwaXMlMjBhd2Z1bCUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe([<span class="hljs-string">&quot;This restaurant is awesome&quot;</span>, <span class="hljs-string">&quot;This restaurant is awful&quot;</span>])
[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;POSITIVE&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9998743534088135</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;NEGATIVE&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9996669292449951</span>}]`,wrap:!1}}),Nn=new v({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEFmcm9tJTIwdHJhbnNmb3JtZXJzLnBpcGVsaW5lcy5wdF91dGlscyUyMGltcG9ydCUyMEtleURhdGFzZXQlMEFmcm9tJTIwdHFkbS5hdXRvJTIwaW1wb3J0JTIwdHFkbSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJmYWNlYm9vayUyRndhdjJ2ZWMyLWJhc2UtOTYwaCUyMiUyQyUyMGRldmljZSUzRDApJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJzdXBlcmIlMjIlMkMlMjBuYW1lJTNEJTIyYXNyJTIyJTJDJTIwc3BsaXQlM0QlMjJ0ZXN0JTIyKSUwQSUwQSUyMyUyMEtleURhdGFzZXQlMjAob25seSUyMCpwdCopJTIwd2lsbCUyMHNpbXBseSUyMHJldHVybiUyMHRoZSUyMGl0ZW0lMjBpbiUyMHRoZSUyMGRpY3QlMjByZXR1cm5lZCUyMGJ5JTIwdGhlJTIwZGF0YXNldCUyMGl0ZW0lMEElMjMlMjBhcyUyMHdlJ3JlJTIwbm90JTIwaW50ZXJlc3RlZCUyMGluJTIwdGhlJTIwKnRhcmdldColMjBwYXJ0JTIwb2YlMjB0aGUlMjBkYXRhc2V0LiUyMEZvciUyMHNlbnRlbmNlJTIwcGFpciUyMHVzZSUyMEtleVBhaXJEYXRhc2V0JTBBZm9yJTIwb3V0JTIwaW4lMjB0cWRtKHBpcGUoS2V5RGF0YXNldChkYXRhc2V0JTJDJTIwJTIyZmlsZSUyMikpKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KG91dCklMEElMjAlMjAlMjAlMjAlMjMlMjAlN0IlMjJ0ZXh0JTIyJTNBJTIwJTIyTlVNQkVSJTIwVEVOJTIwRlJFU0glMjBORUxMWSUyMElTJTIwV0FJVElORyUyME9OJTIwWU9VJTIwR09PRCUyME5JR0hUJTIwSFVTQkFORCUyMiU3RCUwQSUyMCUyMCUyMCUyMCUyMyUyMCU3QiUyMnRleHQlMjIlM0ElMjAuLi4uJTdEJTBBJTIwJTIwJTIwJTIwJTIzJTIwLi4uLg==",highlighted:`<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> transformers.pipelines.pt_utils <span class="hljs-keyword">import</span> KeyDataset
<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>, device=<span class="hljs-number">0</span>)
dataset = datasets.load_dataset(<span class="hljs-string">&quot;superb&quot;</span>, name=<span class="hljs-string">&quot;asr&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>)

<span class="hljs-comment"># KeyDataset (only *pt*) will simply return the item in the dict returned by the dataset item</span>
<span class="hljs-comment"># as we&#x27;re not interested in the *target* part of the dataset. For sentence pair use KeyPairDataset</span>
<span class="hljs-keyword">for</span> out <span class="hljs-keyword">in</span> tqdm(pipe(KeyDataset(dataset, <span class="hljs-string">&quot;file&quot;</span>))):
    <span class="hljs-built_in">print</span>(out)
    <span class="hljs-comment"># {&quot;text&quot;: &quot;NUMBER TEN FRESH NELLY IS WAITING ON YOU GOOD NIGHT HUSBAND&quot;}</span>
    <span class="hljs-comment"># {&quot;text&quot;: ....}</span>
    <span class="hljs-comment"># ....</span>`,wrap:!1}}),An=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIpJTBBJTBBJTBBZGVmJTIwZGF0YSgpJTNBJTBBJTIwJTIwJTIwJTIwd2hpbGUlMjBUcnVlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwVGhpcyUyMGNvdWxkJTIwY29tZSUyMGZyb20lMjBhJTIwZGF0YXNldCUyQyUyMGElMjBkYXRhYmFzZSUyQyUyMGElMjBxdWV1ZSUyMG9yJTIwSFRUUCUyMHJlcXVlc3QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBpbiUyMGElMjBzZXJ2ZXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBDYXZlYXQlM0ElMjBiZWNhdXNlJTIwdGhpcyUyMGlzJTIwaXRlcmF0aXZlJTJDJTIweW91JTIwY2Fubm90JTIwdXNlJTIwJTYwbnVtX3dvcmtlcnMlMjAlM0UlMjAxJTYwJTIwdmFyaWFibGUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjB0byUyMHVzZSUyMG11bHRpcGxlJTIwdGhyZWFkcyUyMHRvJTIwcHJlcHJvY2VzcyUyMGRhdGEuJTIwWW91JTIwY2FuJTIwc3RpbGwlMjBoYXZlJTIwMSUyMHRocmVhZCUyMHRoYXQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBkb2VzJTIwdGhlJTIwcHJlcHJvY2Vzc2luZyUyMHdoaWxlJTIwdGhlJTIwbWFpbiUyMHJ1bnMlMjB0aGUlMjBiaWclMjBpbmZlcmVuY2UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5aWVsZCUyMCUyMlRoaXMlMjBpcyUyMGElMjB0ZXN0JTIyJTBBJTBBJTBBZm9yJTIwb3V0JTIwaW4lMjBwaXBlKGRhdGEoKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChvdXQpJTBBJTIwJTIwJTIwJTIwJTIzJTIwJTdCJTIydGV4dCUyMiUzQSUyMCUyMk5VTUJFUiUyMFRFTiUyMEZSRVNIJTIwTkVMTFklMjBJUyUyMFdBSVRJTkclMjBPTiUyMFlPVSUyMEdPT0QlMjBOSUdIVCUyMEhVU0JBTkQlMjIlN0QlMEElMjAlMjAlMjAlMjAlMjMlMjAlN0IlMjJ0ZXh0JTIyJTNBJTIwLi4uLiU3RCUwQSUyMCUyMCUyMCUyMCUyMyUyMC4uLi4=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">data</span>():
    <span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
        <span class="hljs-comment"># This could come from a dataset, a database, a queue or HTTP request</span>
        <span class="hljs-comment"># in a server</span>
        <span class="hljs-comment"># Caveat: because this is iterative, you cannot use \`num_workers &gt; 1\` variable</span>
        <span class="hljs-comment"># to use multiple threads to preprocess data. You can still have 1 thread that</span>
        <span class="hljs-comment"># does the preprocessing while the main runs the big inference</span>
        <span class="hljs-keyword">yield</span> <span class="hljs-string">&quot;This is a test&quot;</span>


<span class="hljs-keyword">for</span> out <span class="hljs-keyword">in</span> pipe(data()):
    <span class="hljs-built_in">print</span>(out)
    <span class="hljs-comment"># {&quot;text&quot;: &quot;NUMBER TEN FRESH NELLY IS WAITING ON YOU GOOD NIGHT HUSBAND&quot;}</span>
    <span class="hljs-comment"># {&quot;text&quot;: ....}</span>
    <span class="hljs-comment"># ....</span>`,wrap:!1}}),Vn=new j({props:{name:"transformers.pipeline",anchor:"transformers.pipeline",parameters:[{name:"task",val:": typing.Optional[str] = None"},{name:"model",val:": typing.Union[str, ForwardRef('PreTrainedModel'), ForwardRef('TFPreTrainedModel'), NoneType] = None"},{name:"config",val:": typing.Union[str, transformers.configuration_utils.PretrainedConfig, NoneType] = None"},{name:"tokenizer",val:": typing.Union[str, transformers.tokenization_utils.PreTrainedTokenizer, ForwardRef('PreTrainedTokenizerFast'), NoneType] = None"},{name:"feature_extractor",val:": typing.Union[str, ForwardRef('SequenceFeatureExtractor'), NoneType] = None"},{name:"image_processor",val:": typing.Union[str, transformers.image_processing_utils.BaseImageProcessor, NoneType] = None"},{name:"processor",val:": typing.Union[str, transformers.processing_utils.ProcessorMixin, NoneType] = None"},{name:"framework",val:": typing.Optional[str] = None"},{name:"revision",val:": typing.Optional[str] = None"},{name:"use_fast",val:": bool = True"},{name:"token",val:": typing.Union[str, bool, NoneType] = None"},{name:"device",val:": typing.Union[int, str, ForwardRef('torch.device'), NoneType] = None"},{name:"device_map",val:" = None"},{name:"torch_dtype",val:" = None"},{name:"trust_remote_code",val:": typing.Optional[bool] = None"},{name:"model_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"pipeline_class",val:": typing.Optional[typing.Any] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.pipeline.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The task defining which pipeline will be returned. Currently accepted tasks are:</p>
<ul>
<li><code>&quot;audio-classification&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.AudioClassificationPipeline">AudioClassificationPipeline</a>.</li>
<li><code>&quot;automatic-speech-recognition&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.AutomaticSpeechRecognitionPipeline">AutomaticSpeechRecognitionPipeline</a>.</li>
<li><code>&quot;depth-estimation&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.DepthEstimationPipeline">DepthEstimationPipeline</a>.</li>
<li><code>&quot;document-question-answering&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.DocumentQuestionAnsweringPipeline">DocumentQuestionAnsweringPipeline</a>.</li>
<li><code>&quot;feature-extraction&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.FeatureExtractionPipeline">FeatureExtractionPipeline</a>.</li>
<li><code>&quot;fill-mask&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.FillMaskPipeline">FillMaskPipeline</a>:.</li>
<li><code>&quot;image-classification&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.ImageClassificationPipeline">ImageClassificationPipeline</a>.</li>
<li><code>&quot;image-feature-extraction&quot;</code>: will return an <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.ImageFeatureExtractionPipeline">ImageFeatureExtractionPipeline</a>.</li>
<li><code>&quot;image-segmentation&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.ImageSegmentationPipeline">ImageSegmentationPipeline</a>.</li>
<li><code>&quot;image-text-to-text&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.ImageTextToTextPipeline">ImageTextToTextPipeline</a>.</li>
<li><code>&quot;image-to-image&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.ImageToImagePipeline">ImageToImagePipeline</a>.</li>
<li><code>&quot;image-to-text&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.ImageToTextPipeline">ImageToTextPipeline</a>.</li>
<li><code>&quot;mask-generation&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.MaskGenerationPipeline">MaskGenerationPipeline</a>.</li>
<li><code>&quot;object-detection&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.ObjectDetectionPipeline">ObjectDetectionPipeline</a>.</li>
<li><code>&quot;question-answering&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.QuestionAnsweringPipeline">QuestionAnsweringPipeline</a>.</li>
<li><code>&quot;summarization&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.SummarizationPipeline">SummarizationPipeline</a>.</li>
<li><code>&quot;table-question-answering&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.TableQuestionAnsweringPipeline">TableQuestionAnsweringPipeline</a>.</li>
<li><code>&quot;text2text-generation&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.Text2TextGenerationPipeline">Text2TextGenerationPipeline</a>.</li>
<li><code>&quot;text-classification&quot;</code> (alias <code>&quot;sentiment-analysis&quot;</code> available): will return a
<a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.TextClassificationPipeline">TextClassificationPipeline</a>.</li>
<li><code>&quot;text-generation&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>:.</li>
<li><code>&quot;text-to-audio&quot;</code> (alias <code>&quot;text-to-speech&quot;</code> available): will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.TextToAudioPipeline">TextToAudioPipeline</a>:.</li>
<li><code>&quot;token-classification&quot;</code> (alias <code>&quot;ner&quot;</code> available): will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.TokenClassificationPipeline">TokenClassificationPipeline</a>.</li>
<li><code>&quot;translation&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.TranslationPipeline">TranslationPipeline</a>.</li>
<li><code>&quot;translation_xx_to_yy&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.TranslationPipeline">TranslationPipeline</a>.</li>
<li><code>&quot;video-classification&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.VideoClassificationPipeline">VideoClassificationPipeline</a>.</li>
<li><code>&quot;visual-question-answering&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.VisualQuestionAnsweringPipeline">VisualQuestionAnsweringPipeline</a>.</li>
<li><code>&quot;zero-shot-classification&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.ZeroShotClassificationPipeline">ZeroShotClassificationPipeline</a>.</li>
<li><code>&quot;zero-shot-image-classification&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.ZeroShotImageClassificationPipeline">ZeroShotImageClassificationPipeline</a>.</li>
<li><code>&quot;zero-shot-audio-classification&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.ZeroShotAudioClassificationPipeline">ZeroShotAudioClassificationPipeline</a>.</li>
<li><code>&quot;zero-shot-object-detection&quot;</code>: will return a <a href="/docs/transformers/main/zh/main_classes/pipelines#transformers.ZeroShotObjectDetectionPipeline">ZeroShotObjectDetectionPipeline</a>.</li>
</ul>`,name:"task"},{anchor:"transformers.pipeline.model",description:`<strong>model</strong> (<code>str</code> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>, <em>optional</em>) &#x2014;
The model that will be used by the pipeline to make predictions. This can be a model identifier or an
actual instance of a pretrained model inheriting from <a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> (for PyTorch) or
<a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> (for TensorFlow).</p>
<p>If not provided, the default for the <code>task</code> will be loaded.`,name:"model"},{anchor:"transformers.pipeline.config",description:`<strong>config</strong> (<code>str</code> or <a href="/docs/transformers/main/zh/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
The configuration that will be used by the pipeline to instantiate the model. This can be a model
identifier or an actual pretrained model configuration inheriting from <a href="/docs/transformers/main/zh/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>.</p>
<p>If not provided, the default configuration file for the requested model will be used. That means that if
<code>model</code> is given, its default configuration will be used. However, if <code>model</code> is not supplied, this
<code>task</code>&#x2019;s default model&#x2019;s config is used instead.`,name:"config"},{anchor:"transformers.pipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>str</code> or <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>, <em>optional</em>) &#x2014;
The tokenizer that will be used by the pipeline to encode data for the model. This can be a model
identifier or an actual pretrained tokenizer inheriting from <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>.</p>
<p>If not provided, the default tokenizer for the given <code>model</code> will be loaded (if it is a string). If <code>model</code>
is not specified or not a string, then the default tokenizer for <code>config</code> is loaded (if it is a string).
However, if <code>config</code> is also not given or not a string, then the default tokenizer for the given <code>task</code>
will be loaded.`,name:"tokenizer"},{anchor:"transformers.pipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<code>str</code> or <code>PreTrainedFeatureExtractor</code>, <em>optional</em>) &#x2014;
The feature extractor that will be used by the pipeline to encode data for the model. This can be a model
identifier or an actual pretrained feature extractor inheriting from <code>PreTrainedFeatureExtractor</code>.</p>
<p>Feature extractors are used for non-NLP models, such as Speech or Vision models as well as multi-modal
models. Multi-modal models will also require a tokenizer to be passed.</p>
<p>If not provided, the default feature extractor for the given <code>model</code> will be loaded (if it is a string). If
<code>model</code> is not specified or not a string, then the default feature extractor for <code>config</code> is loaded (if it
is a string). However, if <code>config</code> is also not given or not a string, then the default feature extractor
for the given <code>task</code> will be loaded.`,name:"feature_extractor"},{anchor:"transformers.pipeline.image_processor",description:`<strong>image_processor</strong> (<code>str</code> or <a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor that will be used by the pipeline to preprocess images for the model. This can be a
model identifier or an actual image processor inheriting from <a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>.</p>
<p>Image processors are used for Vision models and multi-modal models that require image inputs. Multi-modal
models will also require a tokenizer to be passed.</p>
<p>If not provided, the default image processor for the given <code>model</code> will be loaded (if it is a string). If
<code>model</code> is not specified or not a string, then the default image processor for <code>config</code> is loaded (if it is
a string).`,name:"image_processor"},{anchor:"transformers.pipeline.processor",description:`<strong>processor</strong> (<code>str</code> or <a href="/docs/transformers/main/zh/main_classes/processors#transformers.ProcessorMixin">ProcessorMixin</a>, <em>optional</em>) &#x2014;
The processor that will be used by the pipeline to preprocess data for the model. This can be a model
identifier or an actual processor inheriting from <a href="/docs/transformers/main/zh/main_classes/processors#transformers.ProcessorMixin">ProcessorMixin</a>.</p>
<p>Processors are used for multi-modal models that require multi-modal inputs, for example, a model that
requires both text and image inputs.</p>
<p>If not provided, the default processor for the given <code>model</code> will be loaded (if it is a string). If <code>model</code>
is not specified or not a string, then the default processor for <code>config</code> is loaded (if it is a string).`,name:"processor"},{anchor:"transformers.pipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.pipeline.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
When passing a task name or a string model identifier: The specific model version to use. It can be a
branch name, a tag name, or a commit id, since we use a git-based system for storing models and other
artifacts on huggingface.co, so <code>revision</code> can be any identifier allowed by git.`,name:"revision"},{anchor:"transformers.pipeline.use_fast",description:`<strong>use_fast</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use a Fast tokenizer if possible (a <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a>).`,name:"use_fast"},{anchor:"transformers.pipeline.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"use_auth_token"},{anchor:"transformers.pipeline.device",description:`<strong>device</strong> (<code>int</code> or <code>str</code> or <code>torch.device</code>) &#x2014;
Defines the device (<em>e.g.</em>, <code>&quot;cpu&quot;</code>, <code>&quot;cuda:1&quot;</code>, <code>&quot;mps&quot;</code>, or a GPU ordinal rank like <code>1</code>) on which this
pipeline will be allocated.`,name:"device"},{anchor:"transformers.pipeline.device_map",description:`<strong>device_map</strong> (<code>str</code> or <code>Dict[str, Union[int, str, torch.device]</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut). When <code>accelerate</code> library is present, set
<code>device_map=&quot;auto&quot;</code> to compute the most optimized <code>device_map</code> automatically (see
<a href="https://huggingface.co/docs/accelerate/main/en/package_reference/big_modeling#accelerate.cpu_offload" rel="nofollow">here</a>
for more information).</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>Do not use <code>device_map</code> AND <code>device</code> at the same time as they will conflict</p>

					</div>`,name:"device_map"},{anchor:"transformers.pipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>).`,name:"torch_dtype"},{anchor:"transformers.pipeline.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom code defined on the Hub in their own modeling, configuration,
tokenization or even pipeline files. This option should only be set to <code>True</code> for repositories you trust
and in which you have read the code, as it will execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.pipeline.model_kwargs",description:`<strong>model_kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional dictionary of keyword arguments passed along to the model&#x2019;s <code>from_pretrained(..., **model_kwargs)</code> function.`,name:"model_kwargs"},{anchor:"transformers.pipeline.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the specific pipeline init (see the documentation for the
corresponding pipeline class for possible values).`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/__init__.py#L567",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A suitable pipeline for the task.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/zh/main_classes/pipelines#transformers.Pipeline"
>Pipeline</a></p>
`}}),Xe=new Sc({props:{$$slots:{default:[k_]},$$scope:{ctx:M}}}),Ke=new P({props:{anchor:"transformers.pipeline.example",$$slots:{default:[j_]},$$scope:{ctx:M}}}),Wn=new J({props:{title:"Pipeline batching",local:"pipeline-batching",headingTag:"h2"}}),Hn=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMucHRfdXRpbHMlMjBpbXBvcnQlMjBLZXlEYXRhc2V0JTBBaW1wb3J0JTIwZGF0YXNldHMlMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBuYW1lJTNEJTIycGxhaW5fdGV4dCUyMiUyQyUyMHNwbGl0JTNEJTIydW5zdXBlcnZpc2VkJTIyKSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwZGV2aWNlJTNEMCklMEFmb3IlMjBvdXQlMjBpbiUyMHBpcGUoS2V5RGF0YXNldChkYXRhc2V0JTJDJTIwJTIydGV4dCUyMiklMkMlMjBiYXRjaF9zaXplJTNEOCUyQyUyMHRydW5jYXRpb24lM0QlMjJvbmx5X2ZpcnN0JTIyKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KG91dCklMEElMjAlMjAlMjAlMjAlMjMlMjAlNUIlN0InbGFiZWwnJTNBJTIwJ1BPU0lUSVZFJyUyQyUyMCdzY29yZSclM0ElMjAwLjk5OTg3NDM1MzQwODgxMzUlN0QlNUQlMEElMjAlMjAlMjAlMjAlMjMlMjBFeGFjdGx5JTIwdGhlJTIwc2FtZSUyMG91dHB1dCUyMGFzJTIwYmVmb3JlJTJDJTIwYnV0JTIwdGhlJTIwY29udGVudCUyMGFyZSUyMHBhc3NlZCUwQSUyMCUyMCUyMCUyMCUyMyUyMGFzJTIwYmF0Y2hlcyUyMHRvJTIwdGhlJTIwbW9kZWw=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> transformers.pipelines.pt_utils <span class="hljs-keyword">import</span> KeyDataset
<span class="hljs-keyword">import</span> datasets

dataset = datasets.load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, name=<span class="hljs-string">&quot;plain_text&quot;</span>, split=<span class="hljs-string">&quot;unsupervised&quot;</span>)
pipe = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, device=<span class="hljs-number">0</span>)
<span class="hljs-keyword">for</span> out <span class="hljs-keyword">in</span> pipe(KeyDataset(dataset, <span class="hljs-string">&quot;text&quot;</span>), batch_size=<span class="hljs-number">8</span>, truncation=<span class="hljs-string">&quot;only_first&quot;</span>):
    <span class="hljs-built_in">print</span>(out)
    <span class="hljs-comment"># [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.9998743534088135}]</span>
    <span class="hljs-comment"># Exactly the same output as before, but the content are passed</span>
    <span class="hljs-comment"># as batches to the model</span>`,wrap:!1}}),et=new Sc({props:{warning:!0,$$slots:{default:[v_]},$$scope:{ctx:M}}}),On=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhc2V0JTBBZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMGRldmljZSUzRDApJTBBJTBBJTBBY2xhc3MlMjBNeURhdGFzZXQoRGF0YXNldCklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2xlbl9fKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwNTAwMCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9fZ2V0aXRlbV9fKHNlbGYlMkMlMjBpKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMlRoaXMlMjBpcyUyMGElMjB0ZXN0JTIyJTBBJTBBJTBBZGF0YXNldCUyMCUzRCUyME15RGF0YXNldCgpJTBBJTBBZm9yJTIwYmF0Y2hfc2l6ZSUyMGluJTIwJTVCMSUyQyUyMDglMkMlMjA2NCUyQyUyMDI1NiU1RCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0lMjIlMjAqJTIwMzApJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlN0cmVhbWluZyUyMGJhdGNoX3NpemUlM0QlN0JiYXRjaF9zaXplJTdEJTIyKSUwQSUyMCUyMCUyMCUyMGZvciUyMG91dCUyMGluJTIwdHFkbShwaXBlKGRhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSklMkMlMjB0b3RhbCUzRGxlbihkYXRhc2V0KSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

pipe = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, device=<span class="hljs-number">0</span>)


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyDataset</span>(<span class="hljs-title class_ inherited__">Dataset</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__len__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> <span class="hljs-number">5000</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__getitem__</span>(<span class="hljs-params">self, i</span>):
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;This is a test&quot;</span>


dataset = MyDataset()

<span class="hljs-keyword">for</span> batch_size <span class="hljs-keyword">in</span> [<span class="hljs-number">1</span>, <span class="hljs-number">8</span>, <span class="hljs-number">64</span>, <span class="hljs-number">256</span>]:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;-&quot;</span> * <span class="hljs-number">30</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Streaming batch_size=<span class="hljs-subst">{batch_size}</span>&quot;</span>)
    <span class="hljs-keyword">for</span> out <span class="hljs-keyword">in</span> tqdm(pipe(dataset, batch_size=batch_size), total=<span class="hljs-built_in">len</span>(dataset)):
        <span class="hljs-keyword">pass</span>`,wrap:!1}}),Yn=new v({props:{code:"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",highlighted:`<span class="hljs-section"># On GTX 970
------------------------------</span>
Streaming no batching
100%|██████████████████████████████████████████████████████████████████████| 5000/5000 [00:26&lt;00:00, 187.52it/s]
<span class="hljs-code">------------------------------
Streaming batch_size=8
100%|█████████████████████████████████████████████████████████████████████| 5000/5000 [00:04&lt;00:00, 1205.95it/s]
------------------------------</span>
Streaming batch<span class="hljs-emphasis">_size=64
100%|█████████████████████████████████████████████████████████████████████| 5000/5000 [00:02&lt;00:00, 2478.24it/s]
------------------------------
Streaming batch_</span>size=256
100%|█████████████████████████████████████████████████████████████████████| 5000/5000 [00:01&lt;00:00, 2554.43it/s]
(diminishing returns, saturated the GPU)`,wrap:!1}}),Qn=new v({props:{code:"Y2xhc3MlMjBNeURhdGFzZXQoRGF0YXNldCklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2xlbl9fKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwNTAwMCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9fZ2V0aXRlbV9fKHNlbGYlMkMlMjBpKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwaSUyMCUyNSUyMDY0JTIwJTNEJTNEJTIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG4lMjAlM0QlMjAxMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbiUyMCUzRCUyMDElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlMjJUaGlzJTIwaXMlMjBhJTIwdGVzdCUyMiUyMColMjBu",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyDataset</span>(<span class="hljs-title class_ inherited__">Dataset</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__len__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> <span class="hljs-number">5000</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__getitem__</span>(<span class="hljs-params">self, i</span>):
        <span class="hljs-keyword">if</span> i % <span class="hljs-number">64</span> == <span class="hljs-number">0</span>:
            n = <span class="hljs-number">100</span>
        <span class="hljs-keyword">else</span>:
            n = <span class="hljs-number">1</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;This is a test&quot;</span> * n`,wrap:!1}}),Kn=new v({props:{code:"LS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tJTBBU3RyZWFtaW5nJTIwbm8lMjBiYXRjaGluZyUwQTEwMCUyNSU3QyVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCU3QyUyMDEwMDAlMkYxMDAwJTIwJTVCMDAlM0EwNSUzQzAwJTNBMDAlMkMlMjAxODMuNjlpdCUyRnMlNUQlMEEtLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0lMEFTdHJlYW1pbmclMjBiYXRjaF9zaXplJTNEOCUwQTEwMCUyNSU3QyVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCU3QyUyMDEwMDAlMkYxMDAwJTIwJTVCMDAlM0EwMyUzQzAwJTNBMDAlMkMlMjAyNjUuNzRpdCUyRnMlNUQlMEEtLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0lMEFTdHJlYW1pbmclMjBiYXRjaF9zaXplJTNENjQlMEExMDAlMjUlN0MlRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglN0MlMjAxMDAwJTJGMTAwMCUyMCU1QjAwJTNBMjYlM0MwMCUzQTAwJTJDJTIwMzcuODBpdCUyRnMlNUQlMEEtLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0lMEFTdHJlYW1pbmclMjBiYXRjaF9zaXplJTNEMjU2JTBBJTIwJTIwMCUyNSU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDAlMkYxMDAwJTIwJTVCMDAlM0EwMCUzQyUzRiUyQyUyMCUzRml0JTJGcyU1RCUwQVRyYWNlYmFjayUyMChtb3N0JTIwcmVjZW50JTIwY2FsbCUyMGxhc3QpJTNBJTBBJTIwJTIwRmlsZSUyMCUyMiUyRmhvbWUlMkZuaWNvbGFzJTJGc3JjJTJGdHJhbnNmb3JtZXJzJTJGdGVzdC5weSUyMiUyQyUyMGxpbmUlMjA0MiUyQyUyMGluJTIwJTNDbW9kdWxlJTNFJTBBJTIwJTIwJTIwJTIwZm9yJTIwb3V0JTIwaW4lMjB0cWRtKHBpcGUoZGF0YXNldCUyQyUyMGJhdGNoX3NpemUlM0QyNTYpJTJDJTIwdG90YWwlM0RsZW4oZGF0YXNldCkpJTNBJTBBLi4uLiUwQSUyMCUyMCUyMCUyMHElMjAlM0QlMjBxJTIwJTJGJTIwbWF0aC5zcXJ0KGRpbV9wZXJfaGVhZCklMjAlMjAlMjMlMjAoYnMlMkMlMjBuX2hlYWRzJTJDJTIwcV9sZW5ndGglMkMlMjBkaW1fcGVyX2hlYWQpJTBBUnVudGltZUVycm9yJTNBJTIwQ1VEQSUyMG91dCUyMG9mJTIwbWVtb3J5LiUyMFRyaWVkJTIwdG8lMjBhbGxvY2F0ZSUyMDM3Ni4wMCUyME1pQiUyMChHUFUlMjAwJTNCJTIwMy45NSUyMEdpQiUyMHRvdGFsJTIwY2FwYWNpdHklM0IlMjAxLjcyJTIwR2lCJTIwYWxyZWFkeSUyMGFsbG9jYXRlZCUzQiUyMDM1NC44OCUyME1pQiUyMGZyZWUlM0IlMjAyLjQ2JTIwR2lCJTIwcmVzZXJ2ZWQlMjBpbiUyMHRvdGFsJTIwYnklMjBQeVRvcmNoKQ==",highlighted:`<span class="hljs-comment">------------------------------</span>
Streaming no batching
<span class="hljs-number">100</span>%|█████████████████████████████████████████████████████████████████████| <span class="hljs-number">1000</span>/<span class="hljs-number">1000</span> [<span class="hljs-number">00</span>:<span class="hljs-number">05</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">183.69</span><span class="hljs-keyword">it</span>/s]
<span class="hljs-comment">------------------------------</span>
Streaming batch_size=<span class="hljs-number">8</span>
<span class="hljs-number">100</span>%|█████████████████████████████████████████████████████████████████████| <span class="hljs-number">1000</span>/<span class="hljs-number">1000</span> [<span class="hljs-number">00</span>:<span class="hljs-number">03</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">265.74</span><span class="hljs-keyword">it</span>/s]
<span class="hljs-comment">------------------------------</span>
Streaming batch_size=<span class="hljs-number">64</span>
<span class="hljs-number">100</span>%|██████████████████████████████████████████████████████████████████████| <span class="hljs-number">1000</span>/<span class="hljs-number">1000</span> [<span class="hljs-number">00</span>:<span class="hljs-number">26</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">37.80</span><span class="hljs-keyword">it</span>/s]
<span class="hljs-comment">------------------------------</span>
Streaming batch_size=<span class="hljs-number">256</span>
  <span class="hljs-number">0</span>%|                                                                                 | <span class="hljs-number">0</span>/<span class="hljs-number">1000</span> [<span class="hljs-number">00</span>:<span class="hljs-number">00</span><span class="hljs-meta">&lt;?</span>, ?<span class="hljs-keyword">it</span>/s]
Traceback (most recent call <span class="hljs-keyword">last</span>):
  File <span class="hljs-string">&quot;/home/nicolas/src/transformers/test.py&quot;</span>, <span class="hljs-built_in">line</span> <span class="hljs-number">42</span>, <span class="hljs-keyword">in</span> &lt;module&gt;
    <span class="hljs-keyword">for</span> out <span class="hljs-keyword">in</span> tqdm(pipe(dataset, batch_size=<span class="hljs-number">256</span>), total=<span class="hljs-built_in">len</span>(dataset)):
....
    q = q / math.<span class="hljs-built_in">sqrt</span>(dim_per_head)  <span class="hljs-comment"># (bs, n_heads, q_length, dim_per_head)</span>
RuntimeError: CUDA out <span class="hljs-keyword">of</span> memory. Tried <span class="hljs-built_in">to</span> allocate <span class="hljs-number">376.00</span> MiB (GPU <span class="hljs-number">0</span>; <span class="hljs-number">3.95</span> GiB total capacity; <span class="hljs-number">1.72</span> GiB already allocated; <span class="hljs-number">354.88</span> MiB free; <span class="hljs-number">2.46</span> GiB reserved <span class="hljs-keyword">in</span> total <span class="hljs-keyword">by</span> PyTorch)`,wrap:!1}}),ss=new J({props:{title:"Pipeline chunk batching",local:"pipeline-chunk-batching",headingTag:"h2"}}),rs=new v({props:{code:"cHJlcHJvY2Vzc2VkJTIwJTNEJTIwcGlwZS5wcmVwcm9jZXNzKGlucHV0cyklMEFtb2RlbF9vdXRwdXRzJTIwJTNEJTIwcGlwZS5mb3J3YXJkKHByZXByb2Nlc3NlZCklMEFvdXRwdXRzJTIwJTNEJTIwcGlwZS5wb3N0cHJvY2Vzcyhtb2RlbF9vdXRwdXRzKQ==",highlighted:`preprocessed = pipe.preprocess(inputs)
model_outputs = pipe.forward(preprocessed)
outputs = pipe.postprocess(model_outputs)`,wrap:!1}}),ls=new v({props:{code:"YWxsX21vZGVsX291dHB1dHMlMjAlM0QlMjAlNUIlNUQlMEFmb3IlMjBwcmVwcm9jZXNzZWQlMjBpbiUyMHBpcGUucHJlcHJvY2VzcyhpbnB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWxfb3V0cHV0cyUyMCUzRCUyMHBpcGUuZm9yd2FyZChwcmVwcm9jZXNzZWQpJTBBJTIwJTIwJTIwJTIwYWxsX21vZGVsX291dHB1dHMuYXBwZW5kKG1vZGVsX291dHB1dHMpJTBBb3V0cHV0cyUyMCUzRCUyMHBpcGUucG9zdHByb2Nlc3MoYWxsX21vZGVsX291dHB1dHMp",highlighted:`all_model_outputs = []
<span class="hljs-keyword">for</span> preprocessed <span class="hljs-keyword">in</span> pipe.preprocess(inputs):
    model_outputs = pipe.forward(preprocessed)
    all_model_outputs.append(model_outputs)
outputs = pipe.postprocess(all_model_outputs)`,wrap:!1}}),ds=new J({props:{title:"Pipeline自定义",local:"pipeline自定义",headingTag:"h2"}}),us=new v({props:{code:"Y2xhc3MlMjBNeVBpcGVsaW5lKFRleHRDbGFzc2lmaWNhdGlvblBpcGVsaW5lKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHBvc3Rwcm9jZXNzKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBZb3VyJTIwY29kZSUyMGdvZXMlMjBoZXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NvcmVzJTIwJTNEJTIwc2NvcmVzJTIwKiUyMDEwMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEFuZCUyMGhlcmUlMEElMEElMEFteV9waXBlbGluZSUyMCUzRCUyME15UGlwZWxpbmUobW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUyMC4uLiklMEElMjMlMjBvciUyMGlmJTIweW91JTIwdXNlJTIwKnBpcGVsaW5lKiUyMGZ1bmN0aW9uJTJDJTIwdGhlbiUzQSUwQW15X3BpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJ4eHh4JTIyJTJDJTIwcGlwZWxpbmVfY2xhc3MlM0RNeVBpcGVsaW5lKQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyPipeline</span>(<span class="hljs-title class_ inherited__">TextClassificationPipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>():
        <span class="hljs-comment"># Your code goes here</span>
        scores = scores * <span class="hljs-number">100</span>
        <span class="hljs-comment"># And here</span>


my_pipeline = MyPipeline(model=model, tokenizer=tokenizer, ...)
<span class="hljs-comment"># or if you use *pipeline* function, then:</span>
my_pipeline = pipeline(model=<span class="hljs-string">&quot;xxxx&quot;</span>, pipeline_class=MyPipeline)`,wrap:!1}}),ys=new J({props:{title:"实现一个pipeline",local:"实现一个pipeline",headingTag:"h2"}}),xs=new J({props:{title:"音频",local:"音频",headingTag:"h2"}}),_s=new J({props:{title:"AudioClassificationPipeline",local:"transformers.AudioClassificationPipeline",headingTag:"h3"}}),Ms=new j({props:{name:"class transformers.AudioClassificationPipeline",anchor:"transformers.AudioClassificationPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AudioClassificationPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.AudioClassificationPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="/docs/transformers/main/zh/main_classes/feature_extractor#transformers.SequenceFeatureExtractor">SequenceFeatureExtractor</a>) &#x2014;
The feature extractor that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/feature_extractor#transformers.SequenceFeatureExtractor">SequenceFeatureExtractor</a>.`,name:"feature_extractor"},{anchor:"transformers.AudioClassificationPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.AudioClassificationPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.AudioClassificationPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.AudioClassificationPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.AudioClassificationPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.AudioClassificationPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.AudioClassificationPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.AudioClassificationPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.AudioClassificationPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/audio_classification.py#L66"}}),tt=new P({props:{anchor:"transformers.AudioClassificationPipeline.example",$$slots:{default:[$_]},$$scope:{ctx:M}}}),Us=new j({props:{name:"__call__",anchor:"transformers.AudioClassificationPipeline.__call__",parameters:[{name:"inputs",val:": typing.Union[numpy.ndarray, bytes, str]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AudioClassificationPipeline.__call__.inputs",description:`<strong>inputs</strong> (<code>np.ndarray</code> or <code>bytes</code> or <code>str</code> or <code>dict</code>) &#x2014;
The inputs is either :<ul>
<li><code>str</code> that is the filename of the audio file, the file will be read at the correct sampling rate
to get the waveform using <em>ffmpeg</em>. This requires <em>ffmpeg</em> to be installed on the system.</li>
<li><code>bytes</code> it is supposed to be the content of an audio file and is interpreted by <em>ffmpeg</em> in the
same way.</li>
<li>(<code>np.ndarray</code> of shape (n, ) of type <code>np.float32</code> or <code>np.float64</code>)
Raw audio at the correct sampling rate (no further check will be done)</li>
<li><code>dict</code> form can be used to pass raw audio sampled at arbitrary <code>sampling_rate</code> and let this
pipeline do the resampling. The dict must be either be in the format <code>{&quot;sampling_rate&quot;: int, &quot;raw&quot;: np.array}</code>, or <code>{&quot;sampling_rate&quot;: int, &quot;array&quot;: np.array}</code>, where the key <code>&quot;raw&quot;</code> or
<code>&quot;array&quot;</code> is used to denote the raw audio waveform.</li>
</ul>`,name:"inputs"},{anchor:"transformers.AudioClassificationPipeline.__call__.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to None) &#x2014;
The number of top labels that will be returned by the pipeline. If the provided number is <code>None</code> or
higher than the number of labels available in the model configuration, it will default to the number of
labels.`,name:"top_k"},{anchor:"transformers.AudioClassificationPipeline.__call__.function_to_apply(str,",description:`<strong>function_to_apply(<code>str</code>,</strong> <em>optional</em>, defaults to &#x201C;softmax&#x201D;) &#x2014;
The function to apply to the model output. By default, the pipeline will apply the softmax function to
the output of the model. Valid options: [&#x201C;softmax&#x201D;, &#x201C;sigmoid&#x201D;, &#x201C;none&#x201D;]. Note that passing Python&#x2019;s
built-in <code>None</code> will default to &#x201C;softmax&#x201D;, so you need to pass the string &#x201C;none&#x201D; to disable any
post-processing.`,name:"function_to_apply(str,"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/audio_classification.py#L106",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><strong>label</strong> (<code>str</code>) — The label predicted.</li>
<li><strong>score</strong> (<code>float</code>) — The corresponding probability.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <code>dict</code> with the following keys</p>
`}}),ks=new J({props:{title:"AutomaticSpeechRecognitionPipeline",local:"transformers.AutomaticSpeechRecognitionPipeline",headingTag:"h3"}}),js=new j({props:{name:"class transformers.AutomaticSpeechRecognitionPipeline",anchor:"transformers.AutomaticSpeechRecognitionPipeline",parameters:[{name:"model",val:": PreTrainedModel"},{name:"feature_extractor",val:": typing.Union[ForwardRef('SequenceFeatureExtractor'), str] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils.PreTrainedTokenizer] = None"},{name:"decoder",val:": typing.Union[ForwardRef('BeamSearchDecoderCTC'), str, NoneType] = None"},{name:"device",val:": typing.Union[int, ForwardRef('torch.device')] = None"},{name:"torch_dtype",val:": typing.Union[str, ForwardRef('torch.dtype'), NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutomaticSpeechRecognitionPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.AutomaticSpeechRecognitionPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="/docs/transformers/main/zh/main_classes/feature_extractor#transformers.SequenceFeatureExtractor">SequenceFeatureExtractor</a>) &#x2014;
The feature extractor that will be used by the pipeline to encode waveform for the model.`,name:"feature_extractor"},{anchor:"transformers.AutomaticSpeechRecognitionPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
The tokenizer that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>.`,name:"tokenizer"},{anchor:"transformers.AutomaticSpeechRecognitionPipeline.decoder",description:`<strong>decoder</strong> (<code>pyctcdecode.BeamSearchDecoderCTC</code>, <em>optional</em>) &#x2014;
<a href="https://github.com/kensho-technologies/pyctcdecode/blob/2fd33dc37c4111417e08d89ccd23d28e9b308d19/pyctcdecode/decoder.py#L180" rel="nofollow">PyCTCDecode&#x2019;s
BeamSearchDecoderCTC</a>
can be passed for language model boosted decoding. See <code>Wav2Vec2ProcessorWithLM</code> for more information.`,name:"decoder"},{anchor:"transformers.AutomaticSpeechRecognitionPipeline.chunk_length_s",description:`<strong>chunk_length_s</strong> (<code>float</code>, <em>optional</em>, defaults to 0) &#x2014;
The input length for in each chunk. If <code>chunk_length_s = 0</code> then chunking is disabled (default).</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>For more information on how to effectively use <code>chunk_length_s</code>, please have a look at the <a href="https://huggingface.co/blog/asr-chunking" rel="nofollow">ASR chunking
blog post</a>.</p>

					</div>`,name:"chunk_length_s"},{anchor:"transformers.AutomaticSpeechRecognitionPipeline.stride_length_s",description:`<strong>stride_length_s</strong> (<code>float</code>, <em>optional</em>, defaults to <code>chunk_length_s / 6</code>) &#x2014;
The length of stride on the left and right of each chunk. Used only with <code>chunk_length_s &gt; 0</code>. This enables
the model to <em>see</em> more context and infer letters better than without this context but the pipeline
discards the stride bits at the end to make the final reconstitution as perfect as possible.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>For more information on how to effectively use <code>stride_length_s</code>, please have a look at the <a href="https://huggingface.co/blog/asr-chunking" rel="nofollow">ASR chunking
blog post</a>.</p>

					</div>`,name:"stride_length_s"},{anchor:"transformers.AutomaticSpeechRecognitionPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed. If no framework is specified, will default to the one currently installed. If no framework is
specified and both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if
no model is provided.`,name:"framework"},{anchor:"transformers.AutomaticSpeechRecognitionPipeline.device",description:`<strong>device</strong> (Union[<code>int</code>, <code>torch.device</code>], <em>optional</em>) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to <code>None</code> will leverage CPU, a positive will run the
model on the associated CUDA device id.`,name:"device"},{anchor:"transformers.AutomaticSpeechRecognitionPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (Union[<code>int</code>, <code>torch.dtype</code>], <em>optional</em>) &#x2014;
The data-type (dtype) of the computation. Setting this to <code>None</code> will use float32 precision. Set to
<code>torch.float16</code> or <code>torch.bfloat16</code> to use half-precision in the respective dtypes.`,name:"torch_dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/automatic_speech_recognition.py#L127"}}),st=new P({props:{anchor:"transformers.AutomaticSpeechRecognitionPipeline.example",$$slots:{default:[J_]},$$scope:{ctx:M}}}),vs=new j({props:{name:"__call__",anchor:"transformers.AutomaticSpeechRecognitionPipeline.__call__",parameters:[{name:"inputs",val:": typing.Union[numpy.ndarray, bytes, str]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutomaticSpeechRecognitionPipeline.__call__.inputs",description:`<strong>inputs</strong> (<code>np.ndarray</code> or <code>bytes</code> or <code>str</code> or <code>dict</code>) &#x2014;
The inputs is either :</p>
<ul>
<li><code>str</code> that is either the filename of a local audio file, or a public URL address to download the
audio file. The file will be read at the correct sampling rate to get the waveform using
<em>ffmpeg</em>. This requires <em>ffmpeg</em> to be installed on the system.</li>
<li><code>bytes</code> it is supposed to be the content of an audio file and is interpreted by <em>ffmpeg</em> in the
same way.</li>
<li>(<code>np.ndarray</code> of shape (n, ) of type <code>np.float32</code> or <code>np.float64</code>)
Raw audio at the correct sampling rate (no further check will be done)</li>
<li><code>dict</code> form can be used to pass raw audio sampled at arbitrary <code>sampling_rate</code> and let this
pipeline do the resampling. The dict must be in the format <code>{&quot;sampling_rate&quot;: int, &quot;raw&quot;: np.array}</code> with optionally a <code>&quot;stride&quot;: (left: int, right: int)</code> than can ask the pipeline to
treat the first <code>left</code> samples and last <code>right</code> samples to be ignored in decoding (but used at
inference to provide more context to the model). Only use <code>stride</code> with CTC models.</li>
</ul>`,name:"inputs"},{anchor:"transformers.AutomaticSpeechRecognitionPipeline.__call__.return_timestamps",description:`<strong>return_timestamps</strong> (<em>optional</em>, <code>str</code> or <code>bool</code>) &#x2014;
Only available for pure CTC models (Wav2Vec2, HuBERT, etc) and the Whisper model. Not available for
other sequence-to-sequence models.</p>
<p>For CTC models, timestamps can take one of two formats:</p>
<ul>
<li><code>&quot;char&quot;</code>: the pipeline will return timestamps along the text for every character in the text. For
instance, if you get <code>[{&quot;text&quot;: &quot;h&quot;, &quot;timestamp&quot;: (0.5, 0.6)}, {&quot;text&quot;: &quot;i&quot;, &quot;timestamp&quot;: (0.7, 0.9)}]</code>, then it means the model predicts that the letter &#x201C;h&#x201D; was spoken after <code>0.5</code> and before
<code>0.6</code> seconds.</li>
<li><code>&quot;word&quot;</code>: the pipeline will return timestamps along the text for every word in the text. For
instance, if you get <code>[{&quot;text&quot;: &quot;hi &quot;, &quot;timestamp&quot;: (0.5, 0.9)}, {&quot;text&quot;: &quot;there&quot;, &quot;timestamp&quot;: (1.0, 1.5)}]</code>, then it means the model predicts that the word &#x201C;hi&#x201D; was spoken after <code>0.5</code> and
before <code>0.9</code> seconds.</li>
</ul>
<p>For the Whisper model, timestamps can take one of two formats:</p>
<ul>
<li><code>&quot;word&quot;</code>: same as above for word-level CTC timestamps. Word-level timestamps are predicted
through the <em>dynamic-time warping (DTW)</em> algorithm, an approximation to word-level timestamps
by inspecting the cross-attention weights.</li>
<li><code>True</code>: the pipeline will return timestamps along the text for <em>segments</em> of words in the text.
For instance, if you get <code>[{&quot;text&quot;: &quot; Hi there!&quot;, &quot;timestamp&quot;: (0.5, 1.5)}]</code>, then it means the
model predicts that the segment &#x201C;Hi there!&#x201D; was spoken after <code>0.5</code> and before <code>1.5</code> seconds.
Note that a segment of text refers to a sequence of one or more words, rather than individual
words as with word-level timestamps.</li>
</ul>`,name:"return_timestamps"},{anchor:"transformers.AutomaticSpeechRecognitionPipeline.__call__.generate_kwargs",description:`<strong>generate_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
The dictionary of ad-hoc parametrization of <code>generate_config</code> to be used for the generation call. For a
complete overview of generate, check the <a href="https://huggingface.co/docs/transformers/en/main_classes/text_generation" rel="nofollow">following
guide</a>.`,name:"generate_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/automatic_speech_recognition.py#L234",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary with the following keys:</p>
<ul>
<li><strong>text</strong> (<code>str</code>): The recognized text.</li>
<li><strong>chunks</strong> (<em>optional(, <code>List[Dict]</code>)
When using <code>return_timestamps</code>, the <code>chunks</code> will become a list containing all the various text
chunks identified by the model, </em>e.g.* <code>[&#123;"text": "hi ", "timestamp": (0.5, 0.9)&#125;, &#123;"text": "there", "timestamp": (1.0, 1.5)&#125;]</code>. The original full text can roughly be recovered by doing
<code>"".join(chunk["text"] for chunk in output["chunks"])</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict</code></p>
`}}),$s=new J({props:{title:"TextToAudioPipeline",local:"transformers.TextToAudioPipeline",headingTag:"h3"}}),Js=new j({props:{name:"class transformers.TextToAudioPipeline",anchor:"transformers.TextToAudioPipeline",parameters:[{name:"*args",val:""},{name:"vocoder",val:" = None"},{name:"sampling_rate",val:" = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/text_to_audio.py#L30"}}),ot=new P({props:{anchor:"transformers.TextToAudioPipeline.example",$$slots:{default:[P_]},$$scope:{ctx:M}}}),rt=new Sc({props:{$$slots:{default:[I_]},$$scope:{ctx:M}}}),Ps=new j({props:{name:"__call__",anchor:"transformers.TextToAudioPipeline.__call__",parameters:[{name:"text_inputs",val:": typing.Union[str, typing.List[str]]"},{name:"**forward_params",val:""}],parametersDescription:[{anchor:"transformers.TextToAudioPipeline.__call__.text_inputs",description:`<strong>text_inputs</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The text(s) to generate.`,name:"text_inputs"},{anchor:"transformers.TextToAudioPipeline.__call__.forward_params",description:`<strong>forward_params</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Parameters passed to the model generation/forward method. <code>forward_params</code> are always passed to the
underlying model.`,name:"forward_params"},{anchor:"transformers.TextToAudioPipeline.__call__.generate_kwargs",description:`<strong>generate_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
The dictionary of ad-hoc parametrization of <code>generate_config</code> to be used for the generation call. For a
complete overview of generate, check the <a href="https://huggingface.co/docs/transformers/en/main_classes/text_generation" rel="nofollow">following
guide</a>. <code>generate_kwargs</code> are
only passed to the underlying model if the latter is a generative model.`,name:"generate_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/text_to_audio.py#L176",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dictionaries have two keys:</p>
<ul>
<li><strong>audio</strong> (<code>np.ndarray</code> of shape <code>(nb_channels, audio_length)</code>) — The generated audio waveform.</li>
<li><strong>sampling_rate</strong> (<code>int</code>) — The sampling rate of the generated audio waveform.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>dict</code> or a list of <code>dict</code></p>
`}}),Cs=new J({props:{title:"ZeroShotAudioClassificationPipeline",local:"transformers.ZeroShotAudioClassificationPipeline",headingTag:"h3"}}),Is=new j({props:{name:"class transformers.ZeroShotAudioClassificationPipeline",anchor:"transformers.ZeroShotAudioClassificationPipeline",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ZeroShotAudioClassificationPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.ZeroShotAudioClassificationPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
The tokenizer that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>.`,name:"tokenizer"},{anchor:"transformers.ZeroShotAudioClassificationPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="/docs/transformers/main/zh/main_classes/feature_extractor#transformers.SequenceFeatureExtractor">SequenceFeatureExtractor</a>) &#x2014;
The feature extractor that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/feature_extractor#transformers.SequenceFeatureExtractor">SequenceFeatureExtractor</a>.`,name:"feature_extractor"},{anchor:"transformers.ZeroShotAudioClassificationPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.ZeroShotAudioClassificationPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.ZeroShotAudioClassificationPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.ZeroShotAudioClassificationPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.ZeroShotAudioClassificationPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.ZeroShotAudioClassificationPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.ZeroShotAudioClassificationPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.ZeroShotAudioClassificationPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.ZeroShotAudioClassificationPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/zero_shot_audio_classification.py#L32"}}),lt=new Sc({props:{warning:!0,$$slots:{default:[q_]},$$scope:{ctx:M}}}),ct=new P({props:{anchor:"transformers.ZeroShotAudioClassificationPipeline.example",$$slots:{default:[z_]},$$scope:{ctx:M}}}),qs=new j({props:{name:"__call__",anchor:"transformers.ZeroShotAudioClassificationPipeline.__call__",parameters:[{name:"audios",val:": typing.Union[numpy.ndarray, bytes, str]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ZeroShotAudioClassificationPipeline.__call__.audios",description:`<strong>audios</strong> (<code>str</code>, <code>List[str]</code>, <code>np.array</code> or <code>List[np.array]</code>) &#x2014;
The pipeline handles three types of inputs:<ul>
<li>A string containing a http link pointing to an audio</li>
<li>A string containing a local path to an audio</li>
<li>An audio loaded in numpy</li>
</ul>`,name:"audios"},{anchor:"transformers.ZeroShotAudioClassificationPipeline.__call__.candidate_labels",description:`<strong>candidate_labels</strong> (<code>List[str]</code>) &#x2014;
The candidate labels for this audio. They will be formatted using <em>hypothesis_template</em>.`,name:"candidate_labels"},{anchor:"transformers.ZeroShotAudioClassificationPipeline.__call__.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;This is a sound of {}&quot;</code>) &#x2014;
The format used in conjunction with <em>candidate_labels</em> to attempt the audio classification by
replacing the placeholder with the candidate_labels. Pass &#x201D;{}&#x201D; if <em>candidate_labels</em> are
already formatted.`,name:"hypothesis_template"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/zero_shot_audio_classification.py#L70",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries containing one entry per proposed label. Each dictionary contains the
following keys:</p>
<ul>
<li><strong>label</strong> (<code>str</code>) — One of the suggested <em>candidate_labels</em>.</li>
<li><strong>score</strong> (<code>float</code>) — The score attributed by the model to that label. It is a value between
0 and 1, computed as the <code>softmax</code> of <code>logits_per_audio</code>.</li>
</ul>
`}}),zs=new J({props:{title:"计算机视觉",local:"计算机视觉",headingTag:"h2"}}),Zs=new J({props:{title:"DepthEstimationPipeline",local:"transformers.DepthEstimationPipeline",headingTag:"h3"}}),Fs=new j({props:{name:"class transformers.DepthEstimationPipeline",anchor:"transformers.DepthEstimationPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DepthEstimationPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.DepthEstimationPipeline.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>) &#x2014;
The image processor that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>.`,name:"image_processor"},{anchor:"transformers.DepthEstimationPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.DepthEstimationPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.DepthEstimationPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.DepthEstimationPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.DepthEstimationPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.DepthEstimationPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.DepthEstimationPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.DepthEstimationPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.DepthEstimationPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/depth_estimation.py#L24"}}),dt=new P({props:{anchor:"transformers.DepthEstimationPipeline.example",$$slots:{default:[G_]},$$scope:{ctx:M}}}),Bs=new j({props:{name:"__call__",anchor:"transformers.DepthEstimationPipeline.__call__",parameters:[{name:"inputs",val:": typing.Union[str, typing.List[str], ForwardRef('Image.Image'), typing.List[ForwardRef('Image.Image')]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DepthEstimationPipeline.__call__.inputs",description:`<strong>inputs</strong> (<code>str</code>, <code>List[str]</code>, <code>PIL.Image</code> or <code>List[PIL.Image]</code>) &#x2014;
The pipeline handles three types of images:</p>
<ul>
<li>A string containing a http link pointing to an image</li>
<li>A string containing a local path to an image</li>
<li>An image loaded in PIL directly</li>
</ul>
<p>The pipeline accepts either a single image or a batch of images, which must then be passed as a string.
Images in a batch must all be in the same format: all as http links, all as local paths, or all as PIL
images.`,name:"inputs"},{anchor:"transformers.DepthEstimationPipeline.__call__.parameters",description:`<strong>parameters</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary of argument names to parameter values, to control pipeline behaviour.
The only parameter available right now is <code>timeout</code>, which is the length of time, in seconds,
that the pipeline should wait before giving up on trying to download an image.`,name:"parameters"},{anchor:"transformers.DepthEstimationPipeline.__call__.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
The maximum time in seconds to wait for fetching images from the web. If None, no timeout is set and
the call may block forever.`,name:"timeout"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/depth_estimation.py#L55",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary or a list of dictionaries containing result. If the input is a single image, will return a
dictionary, if the input is a list of several images, will return a list of dictionaries corresponding to
the images.</p>
<p>The dictionaries contain the following keys:</p>
<ul>
<li><strong>predicted_depth</strong> (<code>torch.Tensor</code>) — The predicted depth by the model as a <code>torch.Tensor</code>.</li>
<li><strong>depth</strong> (<code>PIL.Image</code>) — The predicted depth by the model as a <code>PIL.Image</code>.</li>
</ul>
`}}),Rs=new J({props:{title:"ImageClassificationPipeline",local:"transformers.ImageClassificationPipeline",headingTag:"h3"}}),Ds=new j({props:{name:"class transformers.ImageClassificationPipeline",anchor:"transformers.ImageClassificationPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ImageClassificationPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.ImageClassificationPipeline.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>) &#x2014;
The image processor that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>.`,name:"image_processor"},{anchor:"transformers.ImageClassificationPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.ImageClassificationPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.ImageClassificationPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.ImageClassificationPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.ImageClassificationPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.ImageClassificationPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.ImageClassificationPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.ImageClassificationPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.ImageClassificationPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"},{anchor:"transformers.ImageClassificationPipeline.function_to_apply",description:`<strong>function_to_apply</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores. Accepts four different values:</p>
<ul>
<li><code>&quot;default&quot;</code>: if the model has a single label, will apply the sigmoid function on the output. If the model
has several labels, will apply the softmax function on the output.</li>
<li><code>&quot;sigmoid&quot;</code>: Applies the sigmoid function on the output.</li>
<li><code>&quot;softmax&quot;</code>: Applies the softmax function on the output.</li>
<li><code>&quot;none&quot;</code>: Does not apply any function on the output.</li>
</ul>`,name:"function_to_apply"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/image_classification.py#L65"}}),ht=new P({props:{anchor:"transformers.ImageClassificationPipeline.example",$$slots:{default:[Z_]},$$scope:{ctx:M}}}),Ns=new j({props:{name:"__call__",anchor:"transformers.ImageClassificationPipeline.__call__",parameters:[{name:"inputs",val:": typing.Union[str, typing.List[str], ForwardRef('Image.Image'), typing.List[ForwardRef('Image.Image')]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ImageClassificationPipeline.__call__.inputs",description:`<strong>inputs</strong> (<code>str</code>, <code>List[str]</code>, <code>PIL.Image</code> or <code>List[PIL.Image]</code>) &#x2014;
The pipeline handles three types of images:</p>
<ul>
<li>A string containing a http link pointing to an image</li>
<li>A string containing a local path to an image</li>
<li>An image loaded in PIL directly</li>
</ul>
<p>The pipeline accepts either a single image or a batch of images, which must then be passed as a string.
Images in a batch must all be in the same format: all as http links, all as local paths, or all as PIL
images.`,name:"inputs"},{anchor:"transformers.ImageClassificationPipeline.__call__.function_to_apply",description:`<strong>function_to_apply</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores. Accepts four different
values:</p>
<p>If this argument is not specified, then it will apply the following functions according to the number
of labels:</p>
<ul>
<li>If the model has a single label, will apply the sigmoid function on the output.</li>
<li>If the model has several labels, will apply the softmax function on the output.</li>
</ul>
<p>Possible values are:</p>
<ul>
<li><code>&quot;sigmoid&quot;</code>: Applies the sigmoid function on the output.</li>
<li><code>&quot;softmax&quot;</code>: Applies the softmax function on the output.</li>
<li><code>&quot;none&quot;</code>: Does not apply any function on the output.</li>
</ul>`,name:"function_to_apply"},{anchor:"transformers.ImageClassificationPipeline.__call__.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 5) &#x2014;
The number of top labels that will be returned by the pipeline. If the provided number is higher than
the number of labels available in the model configuration, it will default to the number of labels.`,name:"top_k"},{anchor:"transformers.ImageClassificationPipeline.__call__.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
The maximum time in seconds to wait for fetching images from the web. If None, no timeout is set and
the call may block forever.`,name:"timeout"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/image_classification.py#L125",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary or a list of dictionaries containing result. If the input is a single image, will return a
dictionary, if the input is a list of several images, will return a list of dictionaries corresponding to
the images.</p>
<p>The dictionaries contain the following keys:</p>
<ul>
<li><strong>label</strong> (<code>str</code>) — The label identified by the model.</li>
<li><strong>score</strong> (<code>int</code>) — The score attributed by the model for that label.</li>
</ul>
`}}),Ls=new J({props:{title:"ImageSegmentationPipeline",local:"transformers.ImageSegmentationPipeline",headingTag:"h3"}}),As=new j({props:{name:"class transformers.ImageSegmentationPipeline",anchor:"transformers.ImageSegmentationPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ImageSegmentationPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.ImageSegmentationPipeline.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>) &#x2014;
The image processor that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>.`,name:"image_processor"},{anchor:"transformers.ImageSegmentationPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.ImageSegmentationPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.ImageSegmentationPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.ImageSegmentationPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.ImageSegmentationPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.ImageSegmentationPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.ImageSegmentationPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.ImageSegmentationPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.ImageSegmentationPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/image_segmentation.py#L30"}}),ft=new P({props:{anchor:"transformers.ImageSegmentationPipeline.example",$$slots:{default:[F_]},$$scope:{ctx:M}}}),Vs=new j({props:{name:"__call__",anchor:"transformers.ImageSegmentationPipeline.__call__",parameters:[{name:"inputs",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ImageSegmentationPipeline.__call__.inputs",description:`<strong>inputs</strong> (<code>str</code>, <code>List[str]</code>, <code>PIL.Image</code> or <code>List[PIL.Image]</code>) &#x2014;
The pipeline handles three types of images:</p>
<ul>
<li>A string containing an HTTP(S) link pointing to an image</li>
<li>A string containing a local path to an image</li>
<li>An image loaded in PIL directly</li>
</ul>
<p>The pipeline accepts either a single image or a batch of images. Images in a batch must all be in the
same format: all as HTTP(S) links, all as local paths, or all as PIL images.`,name:"inputs"},{anchor:"transformers.ImageSegmentationPipeline.__call__.subtask",description:`<strong>subtask</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Segmentation task to be performed, choose [<code>semantic</code>, <code>instance</code> and <code>panoptic</code>] depending on model
capabilities. If not set, the pipeline will attempt tp resolve in the following order:
<code>panoptic</code>, <code>instance</code>, <code>semantic</code>.`,name:"subtask"},{anchor:"transformers.ImageSegmentationPipeline.__call__.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.9) &#x2014;
Probability threshold to filter out predicted masks.`,name:"threshold"},{anchor:"transformers.ImageSegmentationPipeline.__call__.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.ImageSegmentationPipeline.__call__.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Mask overlap threshold to eliminate small, disconnected segments.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.ImageSegmentationPipeline.__call__.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
The maximum time in seconds to wait for fetching images from the web. If None, no timeout is set and
the call may block forever.`,name:"timeout"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/image_segmentation.py#L97",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary or a list of dictionaries containing the result. If the input is a single image, will return a
list of dictionaries, if the input is a list of several images, will return a list of list of dictionaries
corresponding to each image.</p>
<p>The dictionaries contain the mask, label and score (where applicable) of each detected object and contains
the following keys:</p>
<ul>
<li><strong>label</strong> (<code>str</code>) — The class label identified by the model.</li>
<li><strong>mask</strong> (<code>PIL.Image</code>) — A binary mask of the detected object as a Pil Image of shape (width, height) of
the original image. Returns a mask filled with zeros if no object is found.</li>
<li><strong>score</strong> (<em>optional</em> <code>float</code>) — Optionally, when the model is capable of estimating a confidence of the
“object” described by the label and the mask.</li>
</ul>
`}}),Ws=new J({props:{title:"ImageToImagePipeline",local:"transformers.ImageToImagePipeline",headingTag:"h3"}}),Ss=new j({props:{name:"class transformers.ImageToImagePipeline",anchor:"transformers.ImageToImagePipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ImageToImagePipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.ImageToImagePipeline.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>) &#x2014;
The image processor that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>.`,name:"image_processor"},{anchor:"transformers.ImageToImagePipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.ImageToImagePipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.ImageToImagePipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.ImageToImagePipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.ImageToImagePipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.ImageToImagePipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.ImageToImagePipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.ImageToImagePipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.ImageToImagePipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/image_to_image.py#L39"}}),Tt=new P({props:{anchor:"transformers.ImageToImagePipeline.example",$$slots:{default:[B_]},$$scope:{ctx:M}}}),Hs=new j({props:{name:"__call__",anchor:"transformers.ImageToImagePipeline.__call__",parameters:[{name:"images",val:": typing.Union[str, typing.List[str], ForwardRef('Image.Image'), typing.List[ForwardRef('Image.Image')]]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ImageToImagePipeline.__call__.images",description:`<strong>images</strong> (<code>str</code>, <code>List[str]</code>, <code>PIL.Image</code> or <code>List[PIL.Image]</code>) &#x2014;
The pipeline handles three types of images:</p>
<ul>
<li>A string containing a http link pointing to an image</li>
<li>A string containing a local path to an image</li>
<li>An image loaded in PIL directly</li>
</ul>
<p>The pipeline accepts either a single image or a batch of images, which must then be passed as a string.
Images in a batch must all be in the same format: all as http links, all as local paths, or all as PIL
images.`,name:"images"},{anchor:"transformers.ImageToImagePipeline.__call__.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
The maximum time in seconds to wait for fetching images from the web. If None, no timeout is used and
the call may block forever.`,name:"timeout"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/image_to_image.py#L87",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An image (Image.Image) or a list of images (List[“Image.Image”]) containing result(s). If the input is a
single image, the return will be also a single image, if the input is a list of several images, it will
return a list of transformed images.</p>
`}}),Os=new J({props:{title:"ObjectDetectionPipeline",local:"transformers.ObjectDetectionPipeline",headingTag:"h3"}}),Ys=new j({props:{name:"class transformers.ObjectDetectionPipeline",anchor:"transformers.ObjectDetectionPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ObjectDetectionPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.ObjectDetectionPipeline.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>) &#x2014;
The image processor that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>.`,name:"image_processor"},{anchor:"transformers.ObjectDetectionPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.ObjectDetectionPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.ObjectDetectionPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.ObjectDetectionPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.ObjectDetectionPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.ObjectDetectionPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.ObjectDetectionPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.ObjectDetectionPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.ObjectDetectionPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/object_detection.py#L26"}}),bt=new P({props:{anchor:"transformers.ObjectDetectionPipeline.example",$$slots:{default:[R_]},$$scope:{ctx:M}}}),Es=new j({props:{name:"__call__",anchor:"transformers.ObjectDetectionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ObjectDetectionPipeline.__call__.inputs",description:`<strong>inputs</strong> (<code>str</code>, <code>List[str]</code>, <code>PIL.Image</code> or <code>List[PIL.Image]</code>) &#x2014;
The pipeline handles three types of images:</p>
<ul>
<li>A string containing an HTTP(S) link pointing to an image</li>
<li>A string containing a local path to an image</li>
<li>An image loaded in PIL directly</li>
</ul>
<p>The pipeline accepts either a single image or a batch of images. Images in a batch must all be in the
same format: all as HTTP(S) links, all as local paths, or all as PIL images.`,name:"inputs"},{anchor:"transformers.ObjectDetectionPipeline.__call__.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability necessary to make a prediction.`,name:"threshold"},{anchor:"transformers.ObjectDetectionPipeline.__call__.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
The maximum time in seconds to wait for fetching images from the web. If None, no timeout is set and
the call may block forever.`,name:"timeout"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/object_detection.py#L72",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries or a list of list of dictionaries containing the result. If the input is a single
image, will return a list of dictionaries, if the input is a list of several images, will return a list of
list of dictionaries corresponding to each image.</p>
<p>The dictionaries contain the following keys:</p>
<ul>
<li><strong>label</strong> (<code>str</code>) — The class label identified by the model.</li>
<li><strong>score</strong> (<code>float</code>) — The score attributed by the model for that label.</li>
<li><strong>box</strong> (<code>List[Dict[str, int]]</code>) — The bounding box of detected object in image’s original size.</li>
</ul>
`}}),Qs=new J({props:{title:"VideoClassificationPipeline",local:"transformers.VideoClassificationPipeline",headingTag:"h3"}}),Xs=new j({props:{name:"class transformers.VideoClassificationPipeline",anchor:"transformers.VideoClassificationPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoClassificationPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.VideoClassificationPipeline.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>) &#x2014;
The image processor that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>.`,name:"image_processor"},{anchor:"transformers.VideoClassificationPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.VideoClassificationPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.VideoClassificationPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.VideoClassificationPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.VideoClassificationPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.VideoClassificationPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.VideoClassificationPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.VideoClassificationPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.VideoClassificationPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/video_classification.py#L41"}}),Ks=new j({props:{name:"__call__",anchor:"transformers.VideoClassificationPipeline.__call__",parameters:[{name:"inputs",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoClassificationPipeline.__call__.inputs",description:`<strong>inputs</strong> (<code>str</code>, <code>List[str]</code>) &#x2014;
The pipeline handles three types of videos:</p>
<ul>
<li>A string containing a http link pointing to a video</li>
<li>A string containing a local path to a video</li>
</ul>
<p>The pipeline accepts either a single video or a batch of videos, which must then be passed as a string.
Videos in a batch must all be in the same format: all as http links or all as local paths.`,name:"inputs"},{anchor:"transformers.VideoClassificationPipeline.__call__.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 5) &#x2014;
The number of top labels that will be returned by the pipeline. If the provided number is higher than
the number of labels available in the model configuration, it will default to the number of labels.`,name:"top_k"},{anchor:"transformers.VideoClassificationPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.model.config.num_frames</code>) &#x2014;
The number of frames sampled from the video to run the classification on. If not provided, will default
to the number of frames specified in the model configuration.`,name:"num_frames"},{anchor:"transformers.VideoClassificationPipeline.__call__.frame_sampling_rate",description:`<strong>frame_sampling_rate</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The sampling rate used to select frames from the video. If not provided, will default to 1, i.e. every
frame will be used.`,name:"frame_sampling_rate"},{anchor:"transformers.VideoClassificationPipeline.__call__.function_to_apply(str,",description:`<strong>function_to_apply(<code>str</code>,</strong> <em>optional</em>, defaults to &#x201C;softmax&#x201D;) &#x2014;
The function to apply to the model output. By default, the pipeline will apply the softmax function to
the output of the model. Valid options: [&#x201C;softmax&#x201D;, &#x201C;sigmoid&#x201D;, &#x201C;none&#x201D;]. Note that passing Python&#x2019;s
built-in <code>None</code> will default to &#x201C;softmax&#x201D;, so you need to pass the string &#x201C;none&#x201D; to disable any
post-processing.`,name:"function_to_apply(str,"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/video_classification.py#L80",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries or a list of list of dictionaries containing result. If the input is a single video,
will return a list of <code>top_k</code> dictionaries, if the input is a list of several videos, will return a list of list of
<code>top_k</code> dictionaries corresponding to the videos.</p>
<p>The dictionaries contain the following keys:</p>
<ul>
<li><strong>label</strong> (<code>str</code>) — The label identified by the model.</li>
<li><strong>score</strong> (<code>int</code>) — The score attributed by the model for that label.</li>
</ul>
`}}),ea=new J({props:{title:"ZeroShotImageClassificationPipeline",local:"transformers.ZeroShotImageClassificationPipeline",headingTag:"h3"}}),ta=new j({props:{name:"class transformers.ZeroShotImageClassificationPipeline",anchor:"transformers.ZeroShotImageClassificationPipeline",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ZeroShotImageClassificationPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.ZeroShotImageClassificationPipeline.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>) &#x2014;
The image processor that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>.`,name:"image_processor"},{anchor:"transformers.ZeroShotImageClassificationPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.ZeroShotImageClassificationPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.ZeroShotImageClassificationPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.ZeroShotImageClassificationPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.ZeroShotImageClassificationPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.ZeroShotImageClassificationPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.ZeroShotImageClassificationPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.ZeroShotImageClassificationPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.ZeroShotImageClassificationPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/zero_shot_image_classification.py#L33"}}),_t=new P({props:{anchor:"transformers.ZeroShotImageClassificationPipeline.example",$$slots:{default:[D_]},$$scope:{ctx:M}}}),na=new j({props:{name:"__call__",anchor:"transformers.ZeroShotImageClassificationPipeline.__call__",parameters:[{name:"image",val:": typing.Union[str, typing.List[str], ForwardRef('Image'), typing.List[ForwardRef('Image')]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ZeroShotImageClassificationPipeline.__call__.image",description:`<strong>image</strong> (<code>str</code>, <code>List[str]</code>, <code>PIL.Image</code> or <code>List[PIL.Image]</code>) &#x2014;
The pipeline handles three types of images:</p>
<ul>
<li>A string containing a http link pointing to an image</li>
<li>A string containing a local path to an image</li>
<li>An image loaded in PIL directly</li>
</ul>`,name:"image"},{anchor:"transformers.ZeroShotImageClassificationPipeline.__call__.candidate_labels",description:`<strong>candidate_labels</strong> (<code>List[str]</code>) &#x2014;
The candidate labels for this image. They will be formatted using <em>hypothesis_template</em>.`,name:"candidate_labels"},{anchor:"transformers.ZeroShotImageClassificationPipeline.__call__.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;This is a photo of {}&quot;</code>) &#x2014;
The format used in conjunction with <em>candidate_labels</em> to attempt the image classification by
replacing the placeholder with the candidate_labels. Pass &#x201D;{}&#x201D; if <em>candidate_labels</em> are
already formatted.`,name:"hypothesis_template"},{anchor:"transformers.ZeroShotImageClassificationPipeline.__call__.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
The maximum time in seconds to wait for fetching images from the web. If None, no timeout is set and
the call may block forever.`,name:"timeout"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/zero_shot_image_classification.py#L77",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries containing one entry per proposed label. Each dictionary contains the
following keys:</p>
<ul>
<li><strong>label</strong> (<code>str</code>) — One of the suggested <em>candidate_labels</em>.</li>
<li><strong>score</strong> (<code>float</code>) — The score attributed by the model to that label. It is a value between
0 and 1, computed as the <code>softmax</code> of <code>logits_per_image</code>.</li>
</ul>
`}}),sa=new J({props:{title:"ZeroShotObjectDetectionPipeline",local:"transformers.ZeroShotObjectDetectionPipeline",headingTag:"h3"}}),aa=new j({props:{name:"class transformers.ZeroShotObjectDetectionPipeline",anchor:"transformers.ZeroShotObjectDetectionPipeline",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ZeroShotObjectDetectionPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.ZeroShotObjectDetectionPipeline.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>) &#x2014;
The image processor that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>.`,name:"image_processor"},{anchor:"transformers.ZeroShotObjectDetectionPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.ZeroShotObjectDetectionPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.ZeroShotObjectDetectionPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.ZeroShotObjectDetectionPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.ZeroShotObjectDetectionPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.ZeroShotObjectDetectionPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.ZeroShotObjectDetectionPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.ZeroShotObjectDetectionPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.ZeroShotObjectDetectionPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/zero_shot_object_detection.py#L22"}}),Ut=new P({props:{anchor:"transformers.ZeroShotObjectDetectionPipeline.example",$$slots:{default:[N_]},$$scope:{ctx:M}}}),oa=new j({props:{name:"__call__",anchor:"transformers.ZeroShotObjectDetectionPipeline.__call__",parameters:[{name:"image",val:": typing.Union[str, ForwardRef('Image.Image'), typing.List[typing.Dict[str, typing.Any]]]"},{name:"candidate_labels",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ZeroShotObjectDetectionPipeline.__call__.image",description:`<strong>image</strong> (<code>str</code>, <code>PIL.Image</code> or <code>List[Dict[str, Any]]</code>) &#x2014;
The pipeline handles three types of images:</p>
<ul>
<li>A string containing an http url pointing to an image</li>
<li>A string containing a local path to an image</li>
<li>An image loaded in PIL directly</li>
</ul>
<p>You can use this parameter to send directly a list of images, or a dataset or a generator like so:`,name:"image"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/zero_shot_object_detection.py#L65",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of lists containing prediction results, one list per input image. Each list contains dictionaries
with the following keys:</p>
<ul>
<li><strong>label</strong> (<code>str</code>) — Text query corresponding to the found object.</li>
<li><strong>score</strong> (<code>float</code>) — Score corresponding to the object (between 0 and 1).</li>
<li><strong>box</strong> (<code>Dict[str,int]</code>) — Bounding box of the detected object in image’s original size. It is a
dictionary with <code>x_min</code>, <code>x_max</code>, <code>y_min</code>, <code>y_max</code> keys.</li>
</ul>
`}}),ra=new J({props:{title:"自然语言处理",local:"自然语言处理",headingTag:"h2"}}),la=new J({props:{title:"FillMaskPipeline",local:"transformers.FillMaskPipeline",headingTag:"h3"}}),ca=new j({props:{name:"class transformers.FillMaskPipeline",anchor:"transformers.FillMaskPipeline",parameters:[{name:"model",val:": typing.Union[ForwardRef('PreTrainedModel'), ForwardRef('TFPreTrainedModel')]"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils.PreTrainedTokenizer] = None"},{name:"feature_extractor",val:": typing.Optional[ForwardRef('SequenceFeatureExtractor')] = None"},{name:"image_processor",val:": typing.Optional[transformers.image_processing_utils.BaseImageProcessor] = None"},{name:"processor",val:": typing.Optional[transformers.processing_utils.ProcessorMixin] = None"},{name:"modelcard",val:": typing.Optional[transformers.modelcard.ModelCard] = None"},{name:"framework",val:": typing.Optional[str] = None"},{name:"task",val:": str = ''"},{name:"args_parser",val:": ArgumentHandler = None"},{name:"device",val:": typing.Union[int, ForwardRef('torch.device')] = None"},{name:"torch_dtype",val:": typing.Union[str, ForwardRef('torch.dtype'), NoneType] = None"},{name:"binary_output",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FillMaskPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.FillMaskPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
The tokenizer that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>.`,name:"tokenizer"},{anchor:"transformers.FillMaskPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.FillMaskPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.FillMaskPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.FillMaskPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.FillMaskPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.FillMaskPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.FillMaskPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.FillMaskPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.FillMaskPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"},{anchor:"transformers.FillMaskPipeline.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 5) &#x2014;
The number of predictions to return.`,name:"top_k"},{anchor:"transformers.FillMaskPipeline.targets",description:`<strong>targets</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
When passed, the model will limit the scores to the passed targets instead of looking up in the whole
vocab. If the provided targets are not in the model vocab, they will be tokenized and the first resulting
token will be used (with a warning, and that might be slower).`,name:"targets"},{anchor:"transformers.FillMaskPipeline.tokenizer_kwargs",description:`<strong>tokenizer_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional dictionary of keyword arguments passed along to the tokenizer.`,name:"tokenizer_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/fill_mask.py#L22"}}),jt=new P({props:{anchor:"transformers.FillMaskPipeline.example",$$slots:{default:[L_]},$$scope:{ctx:M}}}),vt=new Sc({props:{$$slots:{default:[A_]},$$scope:{ctx:M}}}),$t=new Sc({props:{$$slots:{default:[W_]},$$scope:{ctx:M}}}),pa=new j({props:{name:"__call__",anchor:"transformers.FillMaskPipeline.__call__",parameters:[{name:"inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FillMaskPipeline.__call__.inputs",description:`<strong>inputs</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
One or several texts (or one list of prompts) with masked tokens.`,name:"inputs"},{anchor:"transformers.FillMaskPipeline.__call__.targets",description:`<strong>targets</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
When passed, the model will limit the scores to the passed targets instead of looking up in the whole
vocab. If the provided targets are not in the model vocab, they will be tokenized and the first
resulting token will be used (with a warning, and that might be slower).`,name:"targets"},{anchor:"transformers.FillMaskPipeline.__call__.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When passed, overrides the number of predictions to return.`,name:"top_k"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/fill_mask.py#L248",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Each result comes as list of dictionaries with the following keys:</p>
<ul>
<li><strong>sequence</strong> (<code>str</code>) — The corresponding input with the mask token prediction.</li>
<li><strong>score</strong> (<code>float</code>) — The corresponding probability.</li>
<li><strong>token</strong> (<code>int</code>) — The predicted token id (to replace the masked one).</li>
<li><strong>token_str</strong> (<code>str</code>) — The predicted token (to replace the masked one).</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list or a list of list of <code>dict</code></p>
`}}),da=new J({props:{title:"NerPipeline",local:"transformers.TokenClassificationPipeline",headingTag:"h3"}}),ma=new j({props:{name:"class transformers.TokenClassificationPipeline",anchor:"transformers.TokenClassificationPipeline",parameters:[{name:"args_parser",val:" = <transformers.pipelines.token_classification.TokenClassificationArgumentHandler object at 0x7f17de8f4610>"},{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TokenClassificationPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.TokenClassificationPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
The tokenizer that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>.`,name:"tokenizer"},{anchor:"transformers.TokenClassificationPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.TokenClassificationPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.TokenClassificationPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.TokenClassificationPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.TokenClassificationPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.TokenClassificationPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.TokenClassificationPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.TokenClassificationPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.TokenClassificationPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"},{anchor:"transformers.TokenClassificationPipeline.ignore_labels",description:`<strong>ignore_labels</strong> (<code>List[str]</code>, defaults to <code>[&quot;O&quot;]</code>) &#x2014;
A list of labels to ignore.`,name:"ignore_labels"},{anchor:"transformers.TokenClassificationPipeline.grouped_entities",description:`<strong>grouped_entities</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
DEPRECATED, use <code>aggregation_strategy</code> instead. Whether or not to group the tokens corresponding to the
same entity together in the predictions or not.`,name:"grouped_entities"},{anchor:"transformers.TokenClassificationPipeline.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If stride is provided, the pipeline is applied on all the text. The text is split into chunks of size
model_max_length. Works only with fast tokenizers and <code>aggregation_strategy</code> different from <code>NONE</code>. The
value of this argument defines the number of overlapping tokens between chunks. In other words, the model
will shift forward by <code>tokenizer.model_max_length - stride</code> tokens each step.`,name:"stride"},{anchor:"transformers.TokenClassificationPipeline.aggregation_strategy",description:`<strong>aggregation_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;none&quot;</code>) &#x2014;
The strategy to fuse (or not) tokens based on the model prediction.</p>
<ul>
<li>&#x201C;none&#x201D; : Will simply not do any aggregation and simply return raw results from the model</li>
<li>&#x201C;simple&#x201D; : Will attempt to group entities following the default schema. (A, B-TAG), (B, I-TAG), (C,
I-TAG), (D, B-TAG2) (E, B-TAG2) will end up being [{&#x201C;word&#x201D;: ABC, &#x201C;entity&#x201D;: &#x201C;TAG&#x201D;}, {&#x201C;word&#x201D;: &#x201C;D&#x201D;,
&#x201C;entity&#x201D;: &#x201C;TAG2&#x201D;}, {&#x201C;word&#x201D;: &#x201C;E&#x201D;, &#x201C;entity&#x201D;: &#x201C;TAG2&#x201D;}] Notice that two consecutive B tags will end up as
different entities. On word based languages, we might end up splitting words undesirably : Imagine
Microsoft being tagged as [{&#x201C;word&#x201D;: &#x201C;Micro&#x201D;, &#x201C;entity&#x201D;: &#x201C;ENTERPRISE&#x201D;}, {&#x201C;word&#x201D;: &#x201C;soft&#x201D;, &#x201C;entity&#x201D;:
&#x201C;NAME&#x201D;}]. Look for FIRST, MAX, AVERAGE for ways to mitigate that and disambiguate words (on languages
that support that meaning, which is basically tokens separated by a space). These mitigations will
only work on real words, &#x201C;New york&#x201D; might still be tagged with two different entities.</li>
<li>&#x201C;first&#x201D; : (works only on word based models) Will use the <code>SIMPLE</code> strategy except that words, cannot
end up with different tags. Words will simply use the tag of the first token of the word when there
is ambiguity.</li>
<li>&#x201C;average&#x201D; : (works only on word based models) Will use the <code>SIMPLE</code> strategy except that words,
cannot end up with different tags. scores will be averaged first across tokens, and then the maximum
label is applied.</li>
<li>&#x201C;max&#x201D; : (works only on word based models) Will use the <code>SIMPLE</code> strategy except that words, cannot
end up with different tags. Word entity will simply be the token with the maximum score.</li>
</ul>`,name:"aggregation_strategy"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/token_classification.py#L63"}}),Pt=new P({props:{anchor:"transformers.TokenClassificationPipeline.example",$$slots:{default:[S_]},$$scope:{ctx:M}}}),ha=new j({props:{name:"aggregate_words",anchor:"transformers.TokenClassificationPipeline.aggregate_words",parameters:[{name:"entities",val:": typing.List[dict]"},{name:"aggregation_strategy",val:": AggregationStrategy"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/token_classification.py#L475"}}),ga=new j({props:{name:"gather_pre_entities",anchor:"transformers.TokenClassificationPipeline.gather_pre_entities",parameters:[{name:"sentence",val:": str"},{name:"input_ids",val:": ndarray"},{name:"scores",val:": ndarray"},{name:"offset_mapping",val:": typing.Optional[typing.List[typing.Tuple[int, int]]]"},{name:"special_tokens_mask",val:": ndarray"},{name:"aggregation_strategy",val:": AggregationStrategy"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/token_classification.py#L361"}}),fa=new j({props:{name:"group_entities",anchor:"transformers.TokenClassificationPipeline.group_entities",parameters:[{name:"entities",val:": typing.List[dict]"}],parametersDescription:[{anchor:"transformers.TokenClassificationPipeline.group_entities.entities",description:"<strong>entities</strong> (<code>dict</code>) &#x2014; The entities predicted by the pipeline.",name:"entities"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/token_classification.py#L538"}}),ua=new j({props:{name:"group_sub_entities",anchor:"transformers.TokenClassificationPipeline.group_sub_entities",parameters:[{name:"entities",val:": typing.List[dict]"}],parametersDescription:[{anchor:"transformers.TokenClassificationPipeline.group_sub_entities.entities",description:"<strong>entities</strong> (<code>dict</code>) &#x2014; The entities predicted by the pipeline.",name:"entities"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/token_classification.py#L503"}}),ya=new J({props:{title:"QuestionAnsweringPipeline",local:"transformers.QuestionAnsweringPipeline",headingTag:"h3"}}),ba=new j({props:{name:"class transformers.QuestionAnsweringPipeline",anchor:"transformers.QuestionAnsweringPipeline",parameters:[{name:"model",val:": typing.Union[ForwardRef('PreTrainedModel'), ForwardRef('TFPreTrainedModel')]"},{name:"tokenizer",val:": PreTrainedTokenizer"},{name:"modelcard",val:": typing.Optional[transformers.modelcard.ModelCard] = None"},{name:"framework",val:": typing.Optional[str] = None"},{name:"task",val:": str = ''"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.QuestionAnsweringPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.QuestionAnsweringPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
The tokenizer that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>.`,name:"tokenizer"},{anchor:"transformers.QuestionAnsweringPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.QuestionAnsweringPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.QuestionAnsweringPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.QuestionAnsweringPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.QuestionAnsweringPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.QuestionAnsweringPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.QuestionAnsweringPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.QuestionAnsweringPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.QuestionAnsweringPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/question_answering.py#L232"}}),zt=new P({props:{anchor:"transformers.QuestionAnsweringPipeline.example",$$slots:{default:[H_]},$$scope:{ctx:M}}}),xa=new j({props:{name:"__call__",anchor:"transformers.QuestionAnsweringPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.QuestionAnsweringPipeline.__call__.question",description:`<strong>question</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
One or several question(s) (must be used in conjunction with the <code>context</code> argument).`,name:"question"},{anchor:"transformers.QuestionAnsweringPipeline.__call__.context",description:`<strong>context</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
One or several context(s) associated with the question(s) (must be used in conjunction with the
<code>question</code> argument).`,name:"context"},{anchor:"transformers.QuestionAnsweringPipeline.__call__.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Note that we return less than
top_k answers if there are not enough options available within the context.`,name:"top_k"},{anchor:"transformers.QuestionAnsweringPipeline.__call__.doc_stride",description:`<strong>doc_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
If the context is too long to fit with the question for the model, it will be split in several chunks
with some overlap. This argument controls the size of that overlap.`,name:"doc_stride"},{anchor:"transformers.QuestionAnsweringPipeline.__call__.max_answer_len",description:`<strong>max_answer_len</strong> (<code>int</code>, <em>optional</em>, defaults to 15) &#x2014;
The maximum length of predicted answers (e.g., only answers with a shorter length are considered).`,name:"max_answer_len"},{anchor:"transformers.QuestionAnsweringPipeline.__call__.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
The maximum length of the total sentence (context + question) in tokens of each chunk passed to the
model. The context will be split in several chunks (using <code>doc_stride</code> as overlap) if needed.`,name:"max_seq_len"},{anchor:"transformers.QuestionAnsweringPipeline.__call__.max_question_len",description:`<strong>max_question_len</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
The maximum length of the question after tokenization. It will be truncated if needed.`,name:"max_question_len"},{anchor:"transformers.QuestionAnsweringPipeline.__call__.handle_impossible_answer",description:`<strong>handle_impossible_answer</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not we accept impossible as an answer.`,name:"handle_impossible_answer"},{anchor:"transformers.QuestionAnsweringPipeline.__call__.align_to_words",description:`<strong>align_to_words</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Attempts to align the answer to real words. Improves quality on space separated languages. Might hurt on
non-space-separated languages (like Japanese or Chinese)`,name:"align_to_words"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/question_answering.py#L350",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Each result comes as a dictionary with the following keys:</p>
<ul>
<li><strong>score</strong> (<code>float</code>) — The probability associated to the answer.</li>
<li><strong>start</strong> (<code>int</code>) — The character start index of the answer (in the tokenized version of the input).</li>
<li><strong>end</strong> (<code>int</code>) — The character end index of the answer (in the tokenized version of the input).</li>
<li><strong>answer</strong> (<code>str</code>) — The answer to the question.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>dict</code> or a list of <code>dict</code></p>
`}}),wa=new j({props:{name:"create_sample",anchor:"transformers.QuestionAnsweringPipeline.create_sample",parameters:[{name:"question",val:": typing.Union[str, typing.List[str]]"},{name:"context",val:": typing.Union[str, typing.List[str]]"}],parametersDescription:[{anchor:"transformers.QuestionAnsweringPipeline.create_sample.question",description:"<strong>question</strong> (<code>str</code> or <code>List[str]</code>) &#x2014; The question(s) asked.",name:"question"},{anchor:"transformers.QuestionAnsweringPipeline.create_sample.context",description:"<strong>context</strong> (<code>str</code> or <code>List[str]</code>) &#x2014; The context(s) in which we will look for the answer.",name:"context"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/question_answering.py#L286",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The corresponding <code>SquadExample</code> grouping question and context.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>One or a list of <code>SquadExample</code></p>
`}}),_a=new j({props:{name:"span_to_answer",anchor:"transformers.QuestionAnsweringPipeline.span_to_answer",parameters:[{name:"text",val:": str"},{name:"start",val:": int"},{name:"end",val:": int"}],parametersDescription:[{anchor:"transformers.QuestionAnsweringPipeline.span_to_answer.text",description:"<strong>text</strong> (<code>str</code>) &#x2014; The actual context to extract the answer from.",name:"text"},{anchor:"transformers.QuestionAnsweringPipeline.span_to_answer.start",description:"<strong>start</strong> (<code>int</code>) &#x2014; The answer starting token index.",name:"start"},{anchor:"transformers.QuestionAnsweringPipeline.span_to_answer.end",description:"<strong>end</strong> (<code>int</code>) &#x2014; The answer end token index.",name:"end"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/question_answering.py#L638",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>str, ‘start’: int, ‘end’: int}\`</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary like \`{‘answer’</p>
`}}),Ma=new J({props:{title:"SummarizationPipeline",local:"transformers.SummarizationPipeline",headingTag:"h3"}}),Ua=new j({props:{name:"class transformers.SummarizationPipeline",anchor:"transformers.SummarizationPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SummarizationPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.SummarizationPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
The tokenizer that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>.`,name:"tokenizer"},{anchor:"transformers.SummarizationPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.SummarizationPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.SummarizationPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.SummarizationPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.SummarizationPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.SummarizationPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.SummarizationPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.SummarizationPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.SummarizationPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/text2text_generation.py#L240"}}),Ft=new P({props:{anchor:"transformers.SummarizationPipeline.example",$$slots:{default:[O_]},$$scope:{ctx:M}}}),ka=new j({props:{name:"__call__",anchor:"transformers.SummarizationPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SummarizationPipeline.__call__.documents",description:`<strong>documents</strong> (<em>str</em> or <code>List[str]</code>) &#x2014;
One or several articles (or one list of articles) to summarize.`,name:"documents"},{anchor:"transformers.SummarizationPipeline.__call__.return_text",description:`<strong>return_text</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to include the decoded texts in the outputs`,name:"return_text"},{anchor:"transformers.SummarizationPipeline.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to include the tensors of predictions (as token indices) in the outputs.`,name:"return_tensors"},{anchor:"transformers.SummarizationPipeline.__call__.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.SummarizationPipeline.__call__.generate_kwargs",description:`<strong>generate_kwargs</strong> &#x2014;
Additional keyword arguments to pass along to the generate method of the model (see the generate method
corresponding to your framework <a href="./text_generation">here</a>).`,name:"generate_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/text2text_generation.py#L274",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Each result comes as a dictionary with the following keys:</p>
<ul>
<li><strong>summary_text</strong> (<code>str</code>, present when <code>return_text=True</code>) — The summary of the corresponding input.</li>
<li><strong>summary_token_ids</strong> (<code>torch.Tensor</code> or <code>tf.Tensor</code>, present when <code>return_tensors=True</code>) — The token
ids of the summary.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list or a list of list of <code>dict</code></p>
`}}),ja=new J({props:{title:"TableQuestionAnsweringPipeline",local:"transformers.TableQuestionAnsweringPipeline",headingTag:"h3"}}),va=new j({props:{name:"class transformers.TableQuestionAnsweringPipeline",anchor:"transformers.TableQuestionAnsweringPipeline",parameters:[{name:"args_parser",val:" = <transformers.pipelines.table_question_answering.TableQuestionAnsweringArgumentHandler object at 0x7f17dea3f760>"},{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TableQuestionAnsweringPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.TableQuestionAnsweringPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
The tokenizer that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>.`,name:"tokenizer"},{anchor:"transformers.TableQuestionAnsweringPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.TableQuestionAnsweringPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.TableQuestionAnsweringPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.TableQuestionAnsweringPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.TableQuestionAnsweringPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.TableQuestionAnsweringPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.TableQuestionAnsweringPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.TableQuestionAnsweringPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.TableQuestionAnsweringPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/table_question_answering.py#L86"}}),Rt=new P({props:{anchor:"transformers.TableQuestionAnsweringPipeline.example",$$slots:{default:[Y_]},$$scope:{ctx:M}}}),$a=new j({props:{name:"__call__",anchor:"transformers.TableQuestionAnsweringPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TableQuestionAnsweringPipeline.__call__.table",description:`<strong>table</strong> (<code>pd.DataFrame</code> or <code>Dict</code>) &#x2014;
Pandas DataFrame or dictionary that will be converted to a DataFrame containing all the table values.
See above for an example of dictionary.`,name:"table"},{anchor:"transformers.TableQuestionAnsweringPipeline.__call__.query",description:`<strong>query</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
Query or list of queries that will be sent to the model alongside the table.`,name:"query"},{anchor:"transformers.TableQuestionAnsweringPipeline.__call__.sequential",description:`<strong>sequential</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to do inference sequentially or as a batch. Batching is faster, but models like SQA require the
inference to be done sequentially to extract relations within sequences, given their conversational
nature.`,name:"sequential"},{anchor:"transformers.TableQuestionAnsweringPipeline.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/zh/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls padding. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.TableQuestionAnsweringPipeline.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <code>str</code> or <code>TapasTruncationStrategy</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls truncation. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;drop_rows_to_fit&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code>
or to the maximum acceptable input length for the model if that argument is not provided. This will
truncate row by row, removing rows from the table.</li>
<li><code>False</code> or <code>&apos;do_not_truncate&apos;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).</li>
</ul>`,name:"truncation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/table_question_answering.py#L280",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Each result is a dictionary with the following
keys:</p>
<ul>
<li><strong>answer</strong> (<code>str</code>) — The answer of the query given the table. If there is an aggregator, the answer will
be preceded by <code>AGGREGATOR &gt;</code>.</li>
<li><strong>coordinates</strong> (<code>List[Tuple[int, int]]</code>) — Coordinates of the cells of the answers.</li>
<li><strong>cells</strong> (<code>List[str]</code>) — List of strings made up of the answer cell values.</li>
<li><strong>aggregator</strong> (<code>str</code>) — If the model has an aggregator, this returns the aggregator.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary or a list of dictionaries containing results</p>
`}}),Dt=new P({props:{anchor:"transformers.TableQuestionAnsweringPipeline.__call__.example",$$slots:{default:[E_]},$$scope:{ctx:M}}}),Nt=new P({props:{anchor:"transformers.TableQuestionAnsweringPipeline.__call__.example-2",$$slots:{default:[Q_]},$$scope:{ctx:M}}}),Ja=new J({props:{title:"TextClassificationPipeline",local:"transformers.TextClassificationPipeline",headingTag:"h3"}}),Pa=new j({props:{name:"class transformers.TextClassificationPipeline",anchor:"transformers.TextClassificationPipeline",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextClassificationPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.TextClassificationPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
The tokenizer that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>.`,name:"tokenizer"},{anchor:"transformers.TextClassificationPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.TextClassificationPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.TextClassificationPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.TextClassificationPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.TextClassificationPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.TextClassificationPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.TextClassificationPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.TextClassificationPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.TextClassificationPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"},{anchor:"transformers.TextClassificationPipeline.return_all_scores",description:`<strong>return_all_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return all prediction scores or just the one of the predicted class.`,name:"return_all_scores"},{anchor:"transformers.TextClassificationPipeline.function_to_apply",description:`<strong>function_to_apply</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores. Accepts four different values:</p>
<ul>
<li><code>&quot;default&quot;</code>: if the model has a single label, will apply the sigmoid function on the output. If the model
has several labels, will apply the softmax function on the output. In case of regression tasks, will not
apply any function on the output.</li>
<li><code>&quot;sigmoid&quot;</code>: Applies the sigmoid function on the output.</li>
<li><code>&quot;softmax&quot;</code>: Applies the softmax function on the output.</li>
<li><code>&quot;none&quot;</code>: Does not apply any function on the output.</li>
</ul>`,name:"function_to_apply"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/text_classification.py#L34"}}),Lt=new P({props:{anchor:"transformers.TextClassificationPipeline.example",$$slots:{default:[X_]},$$scope:{ctx:M}}}),Ca=new j({props:{name:"__call__",anchor:"transformers.TextClassificationPipeline.__call__",parameters:[{name:"inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextClassificationPipeline.__call__.inputs",description:`<strong>inputs</strong> (<code>str</code> or <code>List[str]</code> or <code>Dict[str]</code>, or <code>List[Dict[str]]</code>) &#x2014;
One or several texts to classify. In order to use text pairs for your classification, you can send a
dictionary containing <code>{&quot;text&quot;, &quot;text_pair&quot;}</code> keys, or a list of those.`,name:"inputs"},{anchor:"transformers.TextClassificationPipeline.__call__.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
How many results to return.`,name:"top_k"},{anchor:"transformers.TextClassificationPipeline.__call__.function_to_apply",description:`<strong>function_to_apply</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores. Accepts four different
values:</p>
<p>If this argument is not specified, then it will apply the following functions according to the number
of labels:</p>
<ul>
<li>If problem type is regression, will not apply any function on the output.</li>
<li>If the model has a single label, will apply the sigmoid function on the output.</li>
<li>If the model has several labels, will apply the softmax function on the output.</li>
</ul>
<p>Possible values are:</p>
<ul>
<li><code>&quot;sigmoid&quot;</code>: Applies the sigmoid function on the output.</li>
<li><code>&quot;softmax&quot;</code>: Applies the softmax function on the output.</li>
<li><code>&quot;none&quot;</code>: Does not apply any function on the output.</li>
</ul>`,name:"function_to_apply"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/text_classification.py#L123",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Each result comes as list of dictionaries with the following keys:</p>
<ul>
<li><strong>label</strong> (<code>str</code>) — The label predicted.</li>
<li><strong>score</strong> (<code>float</code>) — The corresponding probability.</li>
</ul>
<p>If <code>top_k</code> is used, one such dictionary is returned per label.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list or a list of list of <code>dict</code></p>
`}}),Ia=new J({props:{title:"TextGenerationPipeline",local:"transformers.TextGenerationPipeline",headingTag:"h3"}}),qa=new j({props:{name:"class transformers.TextGenerationPipeline",anchor:"transformers.TextGenerationPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextGenerationPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.TextGenerationPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
The tokenizer that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>.`,name:"tokenizer"},{anchor:"transformers.TextGenerationPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.TextGenerationPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.TextGenerationPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.TextGenerationPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.TextGenerationPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.TextGenerationPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.TextGenerationPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.TextGenerationPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.TextGenerationPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/text_generation.py#L41"}}),Vt=new P({props:{anchor:"transformers.TextGenerationPipeline.example",$$slots:{default:[K_]},$$scope:{ctx:M}}}),Wt=new P({props:{anchor:"transformers.TextGenerationPipeline.example-2",$$slots:{default:[eM]},$$scope:{ctx:M}}}),za=new j({props:{name:"__call__",anchor:"transformers.TextGenerationPipeline.__call__",parameters:[{name:"text_inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextGenerationPipeline.__call__.text_inputs",description:`<strong>text_inputs</strong> (<code>str</code>, <code>List[str]</code>, List[Dict[str, str]], or <code>List[List[Dict[str, str]]]</code>) &#x2014;
One or several prompts (or one list of prompts) to complete. If strings or a list of string are
passed, this pipeline will continue each prompt. Alternatively, a &#x201C;chat&#x201D;, in the form of a list
of dicts with &#x201C;role&#x201D; and &#x201C;content&#x201D; keys, can be passed, or a list of such chats. When chats are passed,
the model&#x2019;s chat template will be used to format them before passing them to the model.`,name:"text_inputs"},{anchor:"transformers.TextGenerationPipeline.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Returns the tensors of predictions (as token indices) in the outputs. If set to
<code>True</code>, the decoded text is not returned.`,name:"return_tensors"},{anchor:"transformers.TextGenerationPipeline.__call__.return_text",description:`<strong>return_text</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Returns the decoded texts in the outputs.`,name:"return_text"},{anchor:"transformers.TextGenerationPipeline.__call__.return_full_text",description:`<strong>return_full_text</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If set to <code>False</code> only added text is returned, otherwise the full text is returned. Cannot be
specified at the same time as <code>return_text</code>.`,name:"return_full_text"},{anchor:"transformers.TextGenerationPipeline.__call__.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.TextGenerationPipeline.__call__.continue_final_message(",description:`<strong>continue_final_message(</strong> <code>bool</code>, <em>optional</em>) &#x2014; This indicates that you want the model to continue the
last message in the input chat rather than starting a new one, allowing you to &#x201C;prefill&#x201D; its response.
By default this is <code>True</code> when the final message in the input chat has the <code>assistant</code> role and
<code>False</code> otherwise, but you can manually override that behaviour by setting this flag.`,name:"continue_final_message("},{anchor:"transformers.TextGenerationPipeline.__call__.prefix",description:`<strong>prefix</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Prefix added to prompt.`,name:"prefix"},{anchor:"transformers.TextGenerationPipeline.__call__.handle_long_generation",description:`<strong>handle_long_generation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
By default, this pipelines does not handle long generation (ones that exceed in one form or the other
the model maximum length). There is no perfect way to address this (more info
:<a href="https://github.com/huggingface/transformers/issues/14033#issuecomment-948385227" rel="nofollow">https://github.com/huggingface/transformers/issues/14033#issuecomment-948385227</a>). This provides common
strategies to work around that problem depending on your use case.</p>
<ul>
<li><code>None</code> : default strategy where nothing in particular happens</li>
<li><code>&quot;hole&quot;</code>: Truncates left of input, and leaves a gap wide enough to let generation happen (might
truncate a lot of the prompt and not suitable when generation exceed the model capacity)</li>
</ul>`,name:"handle_long_generation"},{anchor:"transformers.TextGenerationPipeline.__call__.generate_kwargs",description:`<strong>generate_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass along to the generate method of the model (see the generate method
corresponding to your framework <a href="./text_generation">here</a>).`,name:"generate_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/text_generation.py#L234",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Returns one of the following dictionaries (cannot return a combination
of both <code>generated_text</code> and <code>generated_token_ids</code>):</p>
<ul>
<li><strong>generated_text</strong> (<code>str</code>, present when <code>return_text=True</code>) — The generated text.</li>
<li><strong>generated_token_ids</strong> (<code>torch.Tensor</code> or <code>tf.Tensor</code>, present when <code>return_tensors=True</code>) — The token
ids of the generated text.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list or a list of lists of <code>dict</code></p>
`}}),Ga=new J({props:{title:"Text2TextGenerationPipeline",local:"transformers.Text2TextGenerationPipeline",headingTag:"h3"}}),Za=new j({props:{name:"class transformers.Text2TextGenerationPipeline",anchor:"transformers.Text2TextGenerationPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Text2TextGenerationPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.Text2TextGenerationPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
The tokenizer that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>.`,name:"tokenizer"},{anchor:"transformers.Text2TextGenerationPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.Text2TextGenerationPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.Text2TextGenerationPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.Text2TextGenerationPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.Text2TextGenerationPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.Text2TextGenerationPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.Text2TextGenerationPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.Text2TextGenerationPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.Text2TextGenerationPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/text2text_generation.py#L26"}}),Ht=new P({props:{anchor:"transformers.Text2TextGenerationPipeline.example",$$slots:{default:[tM]},$$scope:{ctx:M}}}),Ot=new P({props:{anchor:"transformers.Text2TextGenerationPipeline.example-2",$$slots:{default:[nM]},$$scope:{ctx:M}}}),Fa=new j({props:{name:"__call__",anchor:"transformers.Text2TextGenerationPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Text2TextGenerationPipeline.__call__.args",description:`<strong>args</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
Input text for the encoder.`,name:"args"},{anchor:"transformers.Text2TextGenerationPipeline.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to include the tensors of predictions (as token indices) in the outputs.`,name:"return_tensors"},{anchor:"transformers.Text2TextGenerationPipeline.__call__.return_text",description:`<strong>return_text</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to include the decoded texts in the outputs.`,name:"return_text"},{anchor:"transformers.Text2TextGenerationPipeline.__call__.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.Text2TextGenerationPipeline.__call__.truncation",description:`<strong>truncation</strong> (<code>TruncationStrategy</code>, <em>optional</em>, defaults to <code>TruncationStrategy.DO_NOT_TRUNCATE</code>) &#x2014;
The truncation strategy for the tokenization within the pipeline. <code>TruncationStrategy.DO_NOT_TRUNCATE</code>
(default) will never truncate, but it is sometimes desirable to truncate the input to fit the model&#x2019;s
max_length instead of throwing an error down the line.`,name:"truncation"},{anchor:"transformers.Text2TextGenerationPipeline.__call__.generate_kwargs",description:`<strong>generate_kwargs</strong> &#x2014;
Additional keyword arguments to pass along to the generate method of the model (see the generate method
corresponding to your framework <a href="./text_generation">here</a>).`,name:"generate_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/text2text_generation.py#L157",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Each result comes as a dictionary with the following keys:</p>
<ul>
<li><strong>generated_text</strong> (<code>str</code>, present when <code>return_text=True</code>) — The generated text.</li>
<li><strong>generated_token_ids</strong> (<code>torch.Tensor</code> or <code>tf.Tensor</code>, present when <code>return_tensors=True</code>) — The token
ids of the generated text.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list or a list of list of <code>dict</code></p>
`}}),Ba=new j({props:{name:"check_inputs",anchor:"transformers.Text2TextGenerationPipeline.check_inputs",parameters:[{name:"input_length",val:": int"},{name:"min_length",val:": int"},{name:"max_length",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/text2text_generation.py#L130"}}),Ra=new J({props:{title:"TokenClassificationPipeline",local:"transformers.TokenClassificationPipeline",headingTag:"h3"}}),Da=new j({props:{name:"class transformers.TokenClassificationPipeline",anchor:"transformers.TokenClassificationPipeline",parameters:[{name:"args_parser",val:" = <transformers.pipelines.token_classification.TokenClassificationArgumentHandler object at 0x7f17de8f4610>"},{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TokenClassificationPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.TokenClassificationPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
The tokenizer that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>.`,name:"tokenizer"},{anchor:"transformers.TokenClassificationPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.TokenClassificationPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.TokenClassificationPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.TokenClassificationPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.TokenClassificationPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.TokenClassificationPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.TokenClassificationPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.TokenClassificationPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.TokenClassificationPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"},{anchor:"transformers.TokenClassificationPipeline.ignore_labels",description:`<strong>ignore_labels</strong> (<code>List[str]</code>, defaults to <code>[&quot;O&quot;]</code>) &#x2014;
A list of labels to ignore.`,name:"ignore_labels"},{anchor:"transformers.TokenClassificationPipeline.grouped_entities",description:`<strong>grouped_entities</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
DEPRECATED, use <code>aggregation_strategy</code> instead. Whether or not to group the tokens corresponding to the
same entity together in the predictions or not.`,name:"grouped_entities"},{anchor:"transformers.TokenClassificationPipeline.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If stride is provided, the pipeline is applied on all the text. The text is split into chunks of size
model_max_length. Works only with fast tokenizers and <code>aggregation_strategy</code> different from <code>NONE</code>. The
value of this argument defines the number of overlapping tokens between chunks. In other words, the model
will shift forward by <code>tokenizer.model_max_length - stride</code> tokens each step.`,name:"stride"},{anchor:"transformers.TokenClassificationPipeline.aggregation_strategy",description:`<strong>aggregation_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;none&quot;</code>) &#x2014;
The strategy to fuse (or not) tokens based on the model prediction.</p>
<ul>
<li>&#x201C;none&#x201D; : Will simply not do any aggregation and simply return raw results from the model</li>
<li>&#x201C;simple&#x201D; : Will attempt to group entities following the default schema. (A, B-TAG), (B, I-TAG), (C,
I-TAG), (D, B-TAG2) (E, B-TAG2) will end up being [{&#x201C;word&#x201D;: ABC, &#x201C;entity&#x201D;: &#x201C;TAG&#x201D;}, {&#x201C;word&#x201D;: &#x201C;D&#x201D;,
&#x201C;entity&#x201D;: &#x201C;TAG2&#x201D;}, {&#x201C;word&#x201D;: &#x201C;E&#x201D;, &#x201C;entity&#x201D;: &#x201C;TAG2&#x201D;}] Notice that two consecutive B tags will end up as
different entities. On word based languages, we might end up splitting words undesirably : Imagine
Microsoft being tagged as [{&#x201C;word&#x201D;: &#x201C;Micro&#x201D;, &#x201C;entity&#x201D;: &#x201C;ENTERPRISE&#x201D;}, {&#x201C;word&#x201D;: &#x201C;soft&#x201D;, &#x201C;entity&#x201D;:
&#x201C;NAME&#x201D;}]. Look for FIRST, MAX, AVERAGE for ways to mitigate that and disambiguate words (on languages
that support that meaning, which is basically tokens separated by a space). These mitigations will
only work on real words, &#x201C;New york&#x201D; might still be tagged with two different entities.</li>
<li>&#x201C;first&#x201D; : (works only on word based models) Will use the <code>SIMPLE</code> strategy except that words, cannot
end up with different tags. Words will simply use the tag of the first token of the word when there
is ambiguity.</li>
<li>&#x201C;average&#x201D; : (works only on word based models) Will use the <code>SIMPLE</code> strategy except that words,
cannot end up with different tags. scores will be averaged first across tokens, and then the maximum
label is applied.</li>
<li>&#x201C;max&#x201D; : (works only on word based models) Will use the <code>SIMPLE</code> strategy except that words, cannot
end up with different tags. Word entity will simply be the token with the maximum score.</li>
</ul>`,name:"aggregation_strategy"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/token_classification.py#L63"}}),Qt=new P({props:{anchor:"transformers.TokenClassificationPipeline.example",$$slots:{default:[sM]},$$scope:{ctx:M}}}),Na=new j({props:{name:"__call__",anchor:"transformers.TokenClassificationPipeline.__call__",parameters:[{name:"inputs",val:": typing.Union[str, typing.List[str]]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TokenClassificationPipeline.__call__.inputs",description:`<strong>inputs</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
One or several texts (or one list of texts) for token classification.`,name:"inputs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/token_classification.py#L220",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Each result comes as a list of dictionaries (one for each token in the
corresponding input, or each entity if this pipeline was instantiated with an aggregation_strategy) with
the following keys:</p>
<ul>
<li><strong>word</strong> (<code>str</code>) — The token/word classified. This is obtained by decoding the selected tokens. If you
want to have the exact string in the original sentence, use <code>start</code> and <code>end</code>.</li>
<li><strong>score</strong> (<code>float</code>) — The corresponding probability for <code>entity</code>.</li>
<li><strong>entity</strong> (<code>str</code>) — The entity predicted for that token/word (it is named <em>entity_group</em> when
<em>aggregation_strategy</em> is not <code>"none"</code>.</li>
<li><strong>index</strong> (<code>int</code>, only present when <code>aggregation_strategy="none"</code>) — The index of the corresponding
token in the sentence.</li>
<li><strong>start</strong> (<code>int</code>, <em>optional</em>) — The index of the start of the corresponding entity in the sentence. Only
exists if the offsets are available within the tokenizer</li>
<li><strong>end</strong> (<code>int</code>, <em>optional</em>) — The index of the end of the corresponding entity in the sentence. Only
exists if the offsets are available within the tokenizer</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list or a list of list of <code>dict</code></p>
`}}),La=new j({props:{name:"aggregate_words",anchor:"transformers.TokenClassificationPipeline.aggregate_words",parameters:[{name:"entities",val:": typing.List[dict]"},{name:"aggregation_strategy",val:": AggregationStrategy"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/token_classification.py#L475"}}),Aa=new j({props:{name:"gather_pre_entities",anchor:"transformers.TokenClassificationPipeline.gather_pre_entities",parameters:[{name:"sentence",val:": str"},{name:"input_ids",val:": ndarray"},{name:"scores",val:": ndarray"},{name:"offset_mapping",val:": typing.Optional[typing.List[typing.Tuple[int, int]]]"},{name:"special_tokens_mask",val:": ndarray"},{name:"aggregation_strategy",val:": AggregationStrategy"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/token_classification.py#L361"}}),Va=new j({props:{name:"group_entities",anchor:"transformers.TokenClassificationPipeline.group_entities",parameters:[{name:"entities",val:": typing.List[dict]"}],parametersDescription:[{anchor:"transformers.TokenClassificationPipeline.group_entities.entities",description:"<strong>entities</strong> (<code>dict</code>) &#x2014; The entities predicted by the pipeline.",name:"entities"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/token_classification.py#L538"}}),Wa=new j({props:{name:"group_sub_entities",anchor:"transformers.TokenClassificationPipeline.group_sub_entities",parameters:[{name:"entities",val:": typing.List[dict]"}],parametersDescription:[{anchor:"transformers.TokenClassificationPipeline.group_sub_entities.entities",description:"<strong>entities</strong> (<code>dict</code>) &#x2014; The entities predicted by the pipeline.",name:"entities"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/token_classification.py#L503"}}),Sa=new J({props:{title:"TranslationPipeline",local:"transformers.TranslationPipeline",headingTag:"h3"}}),Ha=new j({props:{name:"class transformers.TranslationPipeline",anchor:"transformers.TranslationPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TranslationPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.TranslationPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
The tokenizer that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>.`,name:"tokenizer"},{anchor:"transformers.TranslationPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.TranslationPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.TranslationPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.TranslationPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.TranslationPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.TranslationPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.TranslationPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.TranslationPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.TranslationPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/text2text_generation.py#L315"}}),nn=new P({props:{anchor:"transformers.TranslationPipeline.example",$$slots:{default:[aM]},$$scope:{ctx:M}}}),Oa=new j({props:{name:"__call__",anchor:"transformers.TranslationPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TranslationPipeline.__call__.args",description:`<strong>args</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
Texts to be translated.`,name:"args"},{anchor:"transformers.TranslationPipeline.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to include the tensors of predictions (as token indices) in the outputs.`,name:"return_tensors"},{anchor:"transformers.TranslationPipeline.__call__.return_text",description:`<strong>return_text</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to include the decoded texts in the outputs.`,name:"return_text"},{anchor:"transformers.TranslationPipeline.__call__.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.TranslationPipeline.__call__.src_lang",description:`<strong>src_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The language of the input. Might be required for multilingual models. Will not have any effect for
single pair translation models`,name:"src_lang"},{anchor:"transformers.TranslationPipeline.__call__.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The language of the desired output. Might be required for multilingual models. Will not have any effect
for single pair translation models`,name:"tgt_lang"},{anchor:"transformers.TranslationPipeline.__call__.generate_kwargs",description:`<strong>generate_kwargs</strong> &#x2014;
Additional keyword arguments to pass along to the generate method of the model (see the generate method
corresponding to your framework <a href="./text_generation">here</a>).`,name:"generate_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/text2text_generation.py#L375",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Each result comes as a dictionary with the following keys:</p>
<ul>
<li><strong>translation_text</strong> (<code>str</code>, present when <code>return_text=True</code>) — The translation.</li>
<li><strong>translation_token_ids</strong> (<code>torch.Tensor</code> or <code>tf.Tensor</code>, present when <code>return_tensors=True</code>) — The
token ids of the translation.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list or a list of list of <code>dict</code></p>
`}}),Ya=new J({props:{title:"ZeroShotClassificationPipeline",local:"transformers.ZeroShotClassificationPipeline",headingTag:"h3"}}),Ea=new j({props:{name:"class transformers.ZeroShotClassificationPipeline",anchor:"transformers.ZeroShotClassificationPipeline",parameters:[{name:"args_parser",val:" = <transformers.pipelines.zero_shot_classification.ZeroShotClassificationArgumentHandler object at 0x7f17de8f5d80>"},{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ZeroShotClassificationPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.ZeroShotClassificationPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
The tokenizer that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>.`,name:"tokenizer"},{anchor:"transformers.ZeroShotClassificationPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.ZeroShotClassificationPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.ZeroShotClassificationPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.ZeroShotClassificationPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.ZeroShotClassificationPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.ZeroShotClassificationPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.ZeroShotClassificationPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.ZeroShotClassificationPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.ZeroShotClassificationPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/zero_shot_classification.py#L46"}}),an=new P({props:{anchor:"transformers.ZeroShotClassificationPipeline.example",$$slots:{default:[oM]},$$scope:{ctx:M}}}),Qa=new j({props:{name:"__call__",anchor:"transformers.ZeroShotClassificationPipeline.__call__",parameters:[{name:"sequences",val:": typing.Union[str, typing.List[str]]"},{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ZeroShotClassificationPipeline.__call__.sequences",description:`<strong>sequences</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The sequence(s) to classify, will be truncated if the model input is too large.`,name:"sequences"},{anchor:"transformers.ZeroShotClassificationPipeline.__call__.candidate_labels",description:`<strong>candidate_labels</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The set of possible class labels to classify each sequence into. Can be a single label, a string of
comma-separated labels, or a list of labels.`,name:"candidate_labels"},{anchor:"transformers.ZeroShotClassificationPipeline.__call__.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;This example is {}.&quot;</code>) &#x2014;
The template used to turn each label into an NLI-style hypothesis. This template must include a {} or
similar syntax for the candidate label to be inserted into the template. For example, the default
template is <code>&quot;This example is {}.&quot;</code> With the candidate label <code>&quot;sports&quot;</code>, this would be fed into the
model like <code>&quot;&lt;cls&gt; sequence to classify &lt;sep&gt; This example is sports . &lt;sep&gt;&quot;</code>. The default template
works well in many cases, but it may be worthwhile to experiment with different templates depending on
the task setting.`,name:"hypothesis_template"},{anchor:"transformers.ZeroShotClassificationPipeline.__call__.multi_label",description:`<strong>multi_label</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not multiple candidate labels can be true. If <code>False</code>, the scores are normalized such that
the sum of the label likelihoods for each sequence is 1. If <code>True</code>, the labels are considered
independent and probabilities are normalized for each candidate by doing a softmax of the entailment
score vs. the contradiction score.`,name:"multi_label"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/zero_shot_classification.py#L163",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Each result comes as a dictionary with the following keys:</p>
<ul>
<li><strong>sequence</strong> (<code>str</code>) — The sequence for which this is the output.</li>
<li><strong>labels</strong> (<code>List[str]</code>) — The labels sorted by order of likelihood.</li>
<li><strong>scores</strong> (<code>List[float]</code>) — The probabilities for each of the labels.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>dict</code> or a list of <code>dict</code></p>
`}}),Xa=new J({props:{title:"多模态",local:"多模态",headingTag:"h2"}}),eo=new J({props:{title:"DocumentQuestionAnsweringPipeline",local:"transformers.DocumentQuestionAnsweringPipeline",headingTag:"h3"}}),to=new j({props:{name:"class transformers.DocumentQuestionAnsweringPipeline",anchor:"transformers.DocumentQuestionAnsweringPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DocumentQuestionAnsweringPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.DocumentQuestionAnsweringPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
The tokenizer that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>.`,name:"tokenizer"},{anchor:"transformers.DocumentQuestionAnsweringPipeline.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>) &#x2014;
The image processor that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>.`,name:"image_processor"},{anchor:"transformers.DocumentQuestionAnsweringPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.DocumentQuestionAnsweringPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.DocumentQuestionAnsweringPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.DocumentQuestionAnsweringPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.DocumentQuestionAnsweringPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.DocumentQuestionAnsweringPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.DocumentQuestionAnsweringPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.DocumentQuestionAnsweringPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.DocumentQuestionAnsweringPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/document_question_answering.py#L102"}}),rn=new P({props:{anchor:"transformers.DocumentQuestionAnsweringPipeline.example",$$slots:{default:[rM]},$$scope:{ctx:M}}}),no=new j({props:{name:"__call__",anchor:"transformers.DocumentQuestionAnsweringPipeline.__call__",parameters:[{name:"image",val:": typing.Union[ForwardRef('Image.Image'), str]"},{name:"question",val:": typing.Optional[str] = None"},{name:"word_boxes",val:": typing.Optional[typing.Tuple[str, typing.List[float]]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DocumentQuestionAnsweringPipeline.__call__.image",description:`<strong>image</strong> (<code>str</code> or <code>PIL.Image</code>) &#x2014;
The pipeline handles three types of images:</p>
<ul>
<li>A string containing a http link pointing to an image</li>
<li>A string containing a local path to an image</li>
<li>An image loaded in PIL directly</li>
</ul>
<p>The pipeline accepts either a single image or a batch of images. If given a single image, it can be
broadcasted to multiple questions.`,name:"image"},{anchor:"transformers.DocumentQuestionAnsweringPipeline.__call__.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
A question to ask of the document.`,name:"question"},{anchor:"transformers.DocumentQuestionAnsweringPipeline.__call__.word_boxes",description:`<strong>word_boxes</strong> (<code>List[str, Tuple[float, float, float, float]]</code>, <em>optional</em>) &#x2014;
A list of words and bounding boxes (normalized 0-&gt;1000). If you provide this optional input, then the
pipeline will use these words and boxes instead of running OCR on the image to derive them for models
that need them (e.g. LayoutLM). This allows you to reuse OCR&#x2019;d results across many invocations of the
pipeline without having to re-run it each time.`,name:"word_boxes"},{anchor:"transformers.DocumentQuestionAnsweringPipeline.__call__.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Note that we return less than
top_k answers if there are not enough options available within the context.`,name:"top_k"},{anchor:"transformers.DocumentQuestionAnsweringPipeline.__call__.doc_stride",description:`<strong>doc_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
If the words in the document are too long to fit with the question for the model, it will be split in
several chunks with some overlap. This argument controls the size of that overlap.`,name:"doc_stride"},{anchor:"transformers.DocumentQuestionAnsweringPipeline.__call__.max_answer_len",description:`<strong>max_answer_len</strong> (<code>int</code>, <em>optional</em>, defaults to 15) &#x2014;
The maximum length of predicted answers (e.g., only answers with a shorter length are considered).`,name:"max_answer_len"},{anchor:"transformers.DocumentQuestionAnsweringPipeline.__call__.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
The maximum length of the total sentence (context + question) in tokens of each chunk passed to the
model. The context will be split in several chunks (using <code>doc_stride</code> as overlap) if needed.`,name:"max_seq_len"},{anchor:"transformers.DocumentQuestionAnsweringPipeline.__call__.max_question_len",description:`<strong>max_question_len</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
The maximum length of the question after tokenization. It will be truncated if needed.`,name:"max_question_len"},{anchor:"transformers.DocumentQuestionAnsweringPipeline.__call__.handle_impossible_answer",description:`<strong>handle_impossible_answer</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not we accept impossible as an answer.`,name:"handle_impossible_answer"},{anchor:"transformers.DocumentQuestionAnsweringPipeline.__call__.lang",description:`<strong>lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Language to use while running OCR. Defaults to english.`,name:"lang"},{anchor:"transformers.DocumentQuestionAnsweringPipeline.__call__.tesseract_config",description:`<strong>tesseract_config</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Additional flags to pass to tesseract while running OCR.`,name:"tesseract_config"},{anchor:"transformers.DocumentQuestionAnsweringPipeline.__call__.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
The maximum time in seconds to wait for fetching images from the web. If None, no timeout is set and
the call may block forever.`,name:"timeout"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/document_question_answering.py#L212",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Each result comes as a dictionary with the following keys:</p>
<ul>
<li><strong>score</strong> (<code>float</code>) — The probability associated to the answer.</li>
<li><strong>start</strong> (<code>int</code>) — The start word index of the answer (in the OCR’d version of the input or provided
<code>word_boxes</code>).</li>
<li><strong>end</strong> (<code>int</code>) — The end word index of the answer (in the OCR’d version of the input or provided
<code>word_boxes</code>).</li>
<li><strong>answer</strong> (<code>str</code>) — The answer to the question.</li>
<li><strong>words</strong> (<code>list[int]</code>) — The index of each word/box pair that is in the answer</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>dict</code> or a list of <code>dict</code></p>
`}}),so=new J({props:{title:"FeatureExtractionPipeline",local:"transformers.FeatureExtractionPipeline",headingTag:"h3"}}),ao=new j({props:{name:"class transformers.FeatureExtractionPipeline",anchor:"transformers.FeatureExtractionPipeline",parameters:[{name:"model",val:": typing.Union[ForwardRef('PreTrainedModel'), ForwardRef('TFPreTrainedModel')]"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils.PreTrainedTokenizer] = None"},{name:"feature_extractor",val:": typing.Optional[ForwardRef('SequenceFeatureExtractor')] = None"},{name:"image_processor",val:": typing.Optional[transformers.image_processing_utils.BaseImageProcessor] = None"},{name:"processor",val:": typing.Optional[transformers.processing_utils.ProcessorMixin] = None"},{name:"modelcard",val:": typing.Optional[transformers.modelcard.ModelCard] = None"},{name:"framework",val:": typing.Optional[str] = None"},{name:"task",val:": str = ''"},{name:"args_parser",val:": ArgumentHandler = None"},{name:"device",val:": typing.Union[int, ForwardRef('torch.device')] = None"},{name:"torch_dtype",val:": typing.Union[str, ForwardRef('torch.dtype'), NoneType] = None"},{name:"binary_output",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FeatureExtractionPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.FeatureExtractionPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
The tokenizer that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>.`,name:"tokenizer"},{anchor:"transformers.FeatureExtractionPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.FeatureExtractionPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.FeatureExtractionPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.FeatureExtractionPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.FeatureExtractionPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.FeatureExtractionPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.FeatureExtractionPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.FeatureExtractionPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.FeatureExtractionPipeline.tokenize_kwargs",description:`<strong>tokenize_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional dictionary of keyword arguments passed along to the tokenizer.`,name:"tokenize_kwargs"},{anchor:"transformers.FeatureExtractionPipeline.return_tensors",description:`<strong>return_tensors</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, returns a tensor according to the specified framework, otherwise returns a list.`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/feature_extraction.py#L7"}}),ln=new P({props:{anchor:"transformers.FeatureExtractionPipeline.example",$$slots:{default:[iM]},$$scope:{ctx:M}}}),oo=new j({props:{name:"__call__",anchor:"transformers.FeatureExtractionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FeatureExtractionPipeline.__call__.args",description:"<strong>args</strong> (<code>str</code> or <code>List[str]</code>) &#x2014; One or several texts (or one list of texts) to get the features of.",name:"args"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/feature_extraction.py#L76",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The features computed by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A nested list of <code>float</code></p>
`}}),ro=new J({props:{title:"ImageFeatureExtractionPipeline",local:"transformers.ImageFeatureExtractionPipeline",headingTag:"h3"}}),io=new j({props:{name:"class transformers.ImageFeatureExtractionPipeline",anchor:"transformers.ImageFeatureExtractionPipeline",parameters:[{name:"model",val:": typing.Union[ForwardRef('PreTrainedModel'), ForwardRef('TFPreTrainedModel')]"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils.PreTrainedTokenizer] = None"},{name:"feature_extractor",val:": typing.Optional[ForwardRef('SequenceFeatureExtractor')] = None"},{name:"image_processor",val:": typing.Optional[transformers.image_processing_utils.BaseImageProcessor] = None"},{name:"processor",val:": typing.Optional[transformers.processing_utils.ProcessorMixin] = None"},{name:"modelcard",val:": typing.Optional[transformers.modelcard.ModelCard] = None"},{name:"framework",val:": typing.Optional[str] = None"},{name:"task",val:": str = ''"},{name:"args_parser",val:": ArgumentHandler = None"},{name:"device",val:": typing.Union[int, ForwardRef('torch.device')] = None"},{name:"torch_dtype",val:": typing.Union[str, ForwardRef('torch.dtype'), NoneType] = None"},{name:"binary_output",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ImageFeatureExtractionPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.ImageFeatureExtractionPipeline.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>) &#x2014;
The image processor that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>.`,name:"image_processor"},{anchor:"transformers.ImageFeatureExtractionPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.ImageFeatureExtractionPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.ImageFeatureExtractionPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.ImageFeatureExtractionPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.ImageFeatureExtractionPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.ImageFeatureExtractionPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.ImageFeatureExtractionPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.ImageFeatureExtractionPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.ImageFeatureExtractionPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"},{anchor:"transformers.ImageFeatureExtractionPipeline.image_processor_kwargs",description:`<strong>image_processor_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional dictionary of keyword arguments passed along to the image processor e.g.
{&#x201C;size&#x201D;: {&#x201C;height&#x201D;: 100, &#x201C;width&#x201D;: 100}&#x200C;}`,name:"image_processor_kwargs"},{anchor:"transformers.ImageFeatureExtractionPipeline.pool",description:`<strong>pool</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the pooled output. If <code>False</code>, the model will return the raw hidden states.`,name:"pool"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/image_feature_extraction.py#L11"}}),pn=new P({props:{anchor:"transformers.ImageFeatureExtractionPipeline.example",$$slots:{default:[lM]},$$scope:{ctx:M}}}),lo=new j({props:{name:"__call__",anchor:"transformers.ImageFeatureExtractionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ImageFeatureExtractionPipeline.__call__.images",description:`<strong>images</strong> (<code>str</code>, <code>List[str]</code>, <code>PIL.Image</code> or <code>List[PIL.Image]</code>) &#x2014;
The pipeline handles three types of images:</p>
<ul>
<li>A string containing a http link pointing to an image</li>
<li>A string containing a local path to an image</li>
<li>An image loaded in PIL directly</li>
</ul>
<p>The pipeline accepts either a single image or a batch of images, which must then be passed as a string.
Images in a batch must all be in the same format: all as http links, all as local paths, or all as PIL
images.`,name:"images"},{anchor:"transformers.ImageFeatureExtractionPipeline.__call__.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
The maximum time in seconds to wait for fetching images from the web. If None, no timeout is used and
the call may block forever.`,name:"timeout"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/image_feature_extraction.py#L91",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The features computed by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A nested list of <code>float</code></p>
`}}),co=new J({props:{title:"ImageToTextPipeline",local:"transformers.ImageToTextPipeline",headingTag:"h3"}}),po=new j({props:{name:"class transformers.ImageToTextPipeline",anchor:"transformers.ImageToTextPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ImageToTextPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.ImageToTextPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
The tokenizer that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>.`,name:"tokenizer"},{anchor:"transformers.ImageToTextPipeline.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>) &#x2014;
The image processor that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>.`,name:"image_processor"},{anchor:"transformers.ImageToTextPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.ImageToTextPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.ImageToTextPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.ImageToTextPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.ImageToTextPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.ImageToTextPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.ImageToTextPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.ImageToTextPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.ImageToTextPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/image_to_text.py#L46"}}),mn=new P({props:{anchor:"transformers.ImageToTextPipeline.example",$$slots:{default:[cM]},$$scope:{ctx:M}}}),mo=new j({props:{name:"__call__",anchor:"transformers.ImageToTextPipeline.__call__",parameters:[{name:"inputs",val:": typing.Union[str, typing.List[str], ForwardRef('Image.Image'), typing.List[ForwardRef('Image.Image')]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ImageToTextPipeline.__call__.inputs",description:`<strong>inputs</strong> (<code>str</code>, <code>List[str]</code>, <code>PIL.Image</code> or <code>List[PIL.Image]</code>) &#x2014;
The pipeline handles three types of images:</p>
<ul>
<li>A string containing a HTTP(s) link pointing to an image</li>
<li>A string containing a local path to an image</li>
<li>An image loaded in PIL directly</li>
</ul>
<p>The pipeline accepts either a single image or a batch of images.`,name:"inputs"},{anchor:"transformers.ImageToTextPipeline.__call__.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The amount of maximum tokens to generate. By default it will use <code>generate</code> default.`,name:"max_new_tokens"},{anchor:"transformers.ImageToTextPipeline.__call__.generate_kwargs",description:`<strong>generate_kwargs</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Pass it to send all of these arguments directly to <code>generate</code> allowing full control of this function.`,name:"generate_kwargs"},{anchor:"transformers.ImageToTextPipeline.__call__.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
The maximum time in seconds to wait for fetching images from the web. If None, no timeout is set and
the call may block forever.`,name:"timeout"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/image_to_text.py#L114",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Each result comes as a dictionary with the following key:</p>
<ul>
<li><strong>generated_text</strong> (<code>str</code>) — The generated text.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list or a list of list of <code>dict</code></p>
`}}),ho=new J({props:{title:"ImageTextToTextPipeline",local:"transformers.ImageTextToTextPipeline",headingTag:"h3"}}),go=new j({props:{name:"class transformers.ImageTextToTextPipeline",anchor:"transformers.ImageTextToTextPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ImageTextToTextPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.ImageTextToTextPipeline.processor",description:`<strong>processor</strong> (<a href="/docs/transformers/main/zh/main_classes/processors#transformers.ProcessorMixin">ProcessorMixin</a>) &#x2014;
The processor that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/processors#transformers.ProcessorMixin">ProcessorMixin</a>. Processor is a composite object that might contain <code>tokenizer</code>, <code>feature_extractor</code>, and
<code>image_processor</code>.`,name:"processor"},{anchor:"transformers.ImageTextToTextPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.ImageTextToTextPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.ImageTextToTextPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.ImageTextToTextPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.ImageTextToTextPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.ImageTextToTextPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.ImageTextToTextPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.ImageTextToTextPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.ImageTextToTextPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/image_text_to_text.py#L116"}}),gn=new P({props:{anchor:"transformers.ImageTextToTextPipeline.example",$$slots:{default:[pM]},$$scope:{ctx:M}}}),fn=new P({props:{anchor:"transformers.ImageTextToTextPipeline.example-2",$$slots:{default:[dM]},$$scope:{ctx:M}}}),fo=new j({props:{name:"__call__",anchor:"transformers.ImageTextToTextPipeline.__call__",parameters:[{name:"images",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]], ForwardRef('Image.Image'), typing.List[ForwardRef('Image.Image')], typing.List[typing.List[ForwardRef('Image.Image')]], typing.List[dict], NoneType] = None"},{name:"text",val:": typing.Union[str, typing.List[str], typing.List[dict], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ImageTextToTextPipeline.__call__.images",description:`<strong>images</strong> (<code>str</code>, <code>List[str]</code>, <code>PIL.Image, </code>List[PIL.Image]<code>, </code>List[Dict[str, Union[str, PIL.Image]]]\`) &#x2014;
The pipeline handles three types of images:</p>
<ul>
<li>A string containing a HTTP(s) link pointing to an image</li>
<li>A string containing a local path to an image</li>
<li>An image loaded in PIL directly</li>
</ul>
<p>The pipeline accepts either a single image or a batch of images. Finally, this pipeline also supports
the chat format (see <code>text</code>) containing images and text in this argument.`,name:"images"},{anchor:"transformers.ImageTextToTextPipeline.__call__.text",description:`<strong>text</strong> (str, List[str], <code>List[Dict[str, Union[str, PIL.Image]]]</code>) &#x2014;
The text to be used for generation. If a list of strings is passed, the length of the list should be
the same as the number of images. Text can also follow the chat format: a list of dictionaries where
each dictionary represents a message in a conversation. Each dictionary should have two keys: &#x2018;role&#x2019;
and &#x2018;content&#x2019;. &#x2018;role&#x2019; should be one of &#x2018;user&#x2019;, &#x2018;system&#x2019; or &#x2018;assistant&#x2019;. &#x2018;content&#x2019; should be a list of
dictionary containing the text of the message and the type of the message. The type of the message
can be either &#x2018;text&#x2019; or &#x2018;image&#x2019;. If the type is &#x2018;image&#x2019;, no text is needed.`,name:"text"},{anchor:"transformers.ImageTextToTextPipeline.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Returns the tensors of predictions (as token indices) in the outputs. If set to
<code>True</code>, the decoded text is not returned.`,name:"return_tensors"},{anchor:"transformers.ImageTextToTextPipeline.__call__.return_text",description:`<strong>return_text</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Returns the decoded texts in the outputs.`,name:"return_text"},{anchor:"transformers.ImageTextToTextPipeline.__call__.return_full_text",description:`<strong>return_full_text</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If set to <code>False</code> only added text is returned, otherwise the full text is returned. Cannot be
specified at the same time as <code>return_text</code>.`,name:"return_full_text"},{anchor:"transformers.ImageTextToTextPipeline.__call__.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.ImageTextToTextPipeline.__call__.continue_final_message(",description:`<strong>continue_final_message(</strong> <code>bool</code>, <em>optional</em>) &#x2014; This indicates that you want the model to continue the
last message in the input chat rather than starting a new one, allowing you to &#x201C;prefill&#x201D; its response.
By default this is <code>True</code> when the final message in the input chat has the <code>assistant</code> role and
<code>False</code> otherwise, but you can manually override that behaviour by setting this flag.`,name:"continue_final_message("}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/image_text_to_text.py#L254",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Each result comes as a dictionary with the following key (cannot
return a combination of both <code>generated_text</code> and <code>generated_token_ids</code>):</p>
<ul>
<li><strong>generated_text</strong> (<code>str</code>, present when <code>return_text=True</code>) — The generated text.</li>
<li><strong>generated_token_ids</strong> (<code>torch.Tensor</code>, present when <code>return_tensors=True</code>) — The token
ids of the generated text.</li>
<li><strong>input_text</strong> (<code>str</code>) — The input text.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list or a list of list of <code>dict</code></p>
`}}),uo=new J({props:{title:"MaskGenerationPipeline",local:"transformers.MaskGenerationPipeline",headingTag:"h3"}}),To=new j({props:{name:"class transformers.MaskGenerationPipeline",anchor:"transformers.MaskGenerationPipeline",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaskGenerationPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.MaskGenerationPipeline.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>) &#x2014;
The image processor that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>.`,name:"image_processor"},{anchor:"transformers.MaskGenerationPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.MaskGenerationPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.MaskGenerationPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.MaskGenerationPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.MaskGenerationPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.MaskGenerationPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.MaskGenerationPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.MaskGenerationPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.MaskGenerationPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"},{anchor:"transformers.MaskGenerationPipeline.points_per_batch",description:`<strong>points_per_batch</strong> (<em>optional</em>, int, default to 64) &#x2014;
Sets the number of points run simultaneously by the model. Higher numbers may be faster but use more GPU
memory.`,name:"points_per_batch"},{anchor:"transformers.MaskGenerationPipeline.output_bboxes_mask",description:`<strong>output_bboxes_mask</strong> (<code>bool</code>, <em>optional</em>, default to <code>False</code>) &#x2014;
Whether or not to output the bounding box predictions.`,name:"output_bboxes_mask"},{anchor:"transformers.MaskGenerationPipeline.output_rle_masks",description:`<strong>output_rle_masks</strong> (<code>bool</code>, <em>optional</em>, default to <code>False</code>) &#x2014;
Whether or not to output the masks in <code>RLE</code> format`,name:"output_rle_masks"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/mask_generation.py#L22"}}),Tn=new P({props:{anchor:"transformers.MaskGenerationPipeline.example",$$slots:{default:[mM]},$$scope:{ctx:M}}}),yo=new j({props:{name:"__call__",anchor:"transformers.MaskGenerationPipeline.__call__",parameters:[{name:"image",val:""},{name:"*args",val:""},{name:"num_workers",val:" = None"},{name:"batch_size",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaskGenerationPipeline.__call__.inputs",description:`<strong>inputs</strong> (<code>np.ndarray</code> or <code>bytes</code> or <code>str</code> or <code>dict</code>) &#x2014;
Image or list of images.`,name:"inputs"},{anchor:"transformers.MaskGenerationPipeline.__call__.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.MaskGenerationPipeline.__call__.pred_iou_thresh",description:`<strong>pred_iou_thresh</strong> (<code>float</code>, <em>optional</em>, defaults to 0.88) &#x2014;
A filtering threshold in <code>[0,1]</code> applied on the model&#x2019;s predicted mask quality.`,name:"pred_iou_thresh"},{anchor:"transformers.MaskGenerationPipeline.__call__.stability_score_thresh",description:`<strong>stability_score_thresh</strong> (<code>float</code>, <em>optional</em>, defaults to 0.95) &#x2014;
A filtering threshold in <code>[0,1]</code>, using the stability of the mask under changes to the cutoff used to
binarize the model&#x2019;s mask predictions.`,name:"stability_score_thresh"},{anchor:"transformers.MaskGenerationPipeline.__call__.stability_score_offset",description:`<strong>stability_score_offset</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The amount to shift the cutoff when calculated the stability score.`,name:"stability_score_offset"},{anchor:"transformers.MaskGenerationPipeline.__call__.crops_nms_thresh",description:`<strong>crops_nms_thresh</strong> (<code>float</code>, <em>optional</em>, defaults to 0.7) &#x2014;
The box IoU cutoff used by non-maximal suppression to filter duplicate masks.`,name:"crops_nms_thresh"},{anchor:"transformers.MaskGenerationPipeline.__call__.crops_n_layers",description:`<strong>crops_n_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If <code>crops_n_layers&gt;0</code>, mask prediction will be run again on crops of the image. Sets the number of
layers to run, where each layer has 2**i_layer number of image crops.`,name:"crops_n_layers"},{anchor:"transformers.MaskGenerationPipeline.__call__.crop_overlap_ratio",description:`<strong>crop_overlap_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to <code>512 / 1500</code>) &#x2014;
Sets the degree to which crops overlap. In the first crop layer, crops will overlap by this fraction of
the image length. Later layers with more crops scale down this overlap.`,name:"crop_overlap_ratio"},{anchor:"transformers.MaskGenerationPipeline.__call__.crop_n_points_downscale_factor",description:`<strong>crop_n_points_downscale_factor</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
The number of points-per-side sampled in layer n is scaled down by crop_n_points_downscale_factor**n.`,name:"crop_n_points_downscale_factor"},{anchor:"transformers.MaskGenerationPipeline.__call__.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
The maximum time in seconds to wait for fetching images from the web. If None, no timeout is set and
the call may block forever.`,name:"timeout"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/mask_generation.py#L128",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary with the following keys:</p>
<ul>
<li><strong>mask</strong> (<code>PIL.Image</code>) — A binary mask of the detected object as a PIL Image of shape <code>(width, height)</code> of the original image. Returns a mask filled with zeros if no object is found.</li>
<li><strong>score</strong> (<em>optional</em> <code>float</code>) — Optionally, when the model is capable of estimating a confidence of
the “object” described by the label and the mask.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict</code></p>
`}}),bo=new J({props:{title:"VisualQuestionAnsweringPipeline",local:"transformers.VisualQuestionAnsweringPipeline",headingTag:"h3"}}),xo=new j({props:{name:"class transformers.VisualQuestionAnsweringPipeline",anchor:"transformers.VisualQuestionAnsweringPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VisualQuestionAnsweringPipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.VisualQuestionAnsweringPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
The tokenizer that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>.`,name:"tokenizer"},{anchor:"transformers.VisualQuestionAnsweringPipeline.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>) &#x2014;
The image processor that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>.`,name:"image_processor"},{anchor:"transformers.VisualQuestionAnsweringPipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.VisualQuestionAnsweringPipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.VisualQuestionAnsweringPipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.VisualQuestionAnsweringPipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.VisualQuestionAnsweringPipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.VisualQuestionAnsweringPipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.VisualQuestionAnsweringPipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.VisualQuestionAnsweringPipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.VisualQuestionAnsweringPipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/visual_question_answering.py#L20"}}),bn=new P({props:{anchor:"transformers.VisualQuestionAnsweringPipeline.example",$$slots:{default:[hM]},$$scope:{ctx:M}}}),wo=new j({props:{name:"__call__",anchor:"transformers.VisualQuestionAnsweringPipeline.__call__",parameters:[{name:"image",val:": typing.Union[ForwardRef('Image.Image'), str, typing.List[ForwardRef('Image.Image')], typing.List[str], ForwardRef('KeyDataset')]"},{name:"question",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VisualQuestionAnsweringPipeline.__call__.image",description:`<strong>image</strong> (<code>str</code>, <code>List[str]</code>, <code>PIL.Image</code>, <code>List[PIL.Image]</code> or <code>KeyDataset</code>) &#x2014;
The pipeline handles three types of images:</p>
<ul>
<li>A string containing a http link pointing to an image</li>
<li>A string containing a local path to an image</li>
<li>An image loaded in PIL directly</li>
</ul>
<p>The pipeline accepts either a single image or a batch of images. If given a single image, it can be
broadcasted to multiple questions.
For dataset: the passed in dataset must be of type <code>transformers.pipelines.pt_utils.KeyDataset</code>
Example:`,name:"image"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/visual_question_answering.py#L90",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><strong>label</strong> (<code>str</code>) — The label identified by the model.</li>
<li><strong>score</strong> (<code>int</code>) — The score attributed by the model for that label.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary or a list of dictionaries containing the result. The dictionaries contain the following keys</p>
`}}),_o=new J({props:{title:"Parent class: Pipeline",local:"transformers.Pipeline",headingTag:"h2"}}),Mo=new j({props:{name:"class transformers.Pipeline",anchor:"transformers.Pipeline",parameters:[{name:"model",val:": typing.Union[ForwardRef('PreTrainedModel'), ForwardRef('TFPreTrainedModel')]"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils.PreTrainedTokenizer] = None"},{name:"feature_extractor",val:": typing.Optional[ForwardRef('SequenceFeatureExtractor')] = None"},{name:"image_processor",val:": typing.Optional[transformers.image_processing_utils.BaseImageProcessor] = None"},{name:"processor",val:": typing.Optional[transformers.processing_utils.ProcessorMixin] = None"},{name:"modelcard",val:": typing.Optional[transformers.modelcard.ModelCard] = None"},{name:"framework",val:": typing.Optional[str] = None"},{name:"task",val:": str = ''"},{name:"args_parser",val:": ArgumentHandler = None"},{name:"device",val:": typing.Union[int, ForwardRef('torch.device')] = None"},{name:"torch_dtype",val:": typing.Union[str, ForwardRef('torch.dtype'), NoneType] = None"},{name:"binary_output",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Pipeline.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>) &#x2014;
The model that will be used by the pipeline to make predictions. This needs to be a model inheriting from
<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> for PyTorch and <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a> for TensorFlow.`,name:"model"},{anchor:"transformers.Pipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
The tokenizer that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>.`,name:"tokenizer"},{anchor:"transformers.Pipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="/docs/transformers/main/zh/main_classes/feature_extractor#transformers.SequenceFeatureExtractor">SequenceFeatureExtractor</a>) &#x2014;
The feature extractor that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/feature_extractor#transformers.SequenceFeatureExtractor">SequenceFeatureExtractor</a>.`,name:"feature_extractor"},{anchor:"transformers.Pipeline.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>) &#x2014;
The image processor that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a>.`,name:"image_processor"},{anchor:"transformers.Pipeline.processor",description:`<strong>processor</strong> (<a href="/docs/transformers/main/zh/main_classes/processors#transformers.ProcessorMixin">ProcessorMixin</a>) &#x2014;
The processor that will be used by the pipeline to encode data for the model. This object inherits from
<a href="/docs/transformers/main/zh/main_classes/processors#transformers.ProcessorMixin">ProcessorMixin</a>. Processor is a composite object that might contain <code>tokenizer</code>, <code>feature_extractor</code>, and
<code>image_processor</code>.`,name:"processor"},{anchor:"transformers.Pipeline.modelcard",description:`<strong>modelcard</strong> (<code>str</code> or <code>ModelCard</code>, <em>optional</em>) &#x2014;
Model card attributed to the model for this pipeline.`,name:"modelcard"},{anchor:"transformers.Pipeline.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The framework to use, either <code>&quot;pt&quot;</code> for PyTorch or <code>&quot;tf&quot;</code> for TensorFlow. The specified framework must be
installed.</p>
<p>If no framework is specified, will default to the one currently installed. If no framework is specified and
both frameworks are installed, will default to the framework of the <code>model</code>, or to PyTorch if no model is
provided.`,name:"framework"},{anchor:"transformers.Pipeline.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
A task-identifier for the pipeline.`,name:"task"},{anchor:"transformers.Pipeline.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the number of
workers to be used.`,name:"num_workers"},{anchor:"transformers.Pipeline.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
When the pipeline will use <em>DataLoader</em> (when passing a dataset, on GPU for a Pytorch model), the size of
the batch to use, for inference this is not always beneficial, please read <a href="https://huggingface.co/transformers/main_classes/pipelines.html#pipeline-batching" rel="nofollow">Batching with
pipelines</a> .`,name:"batch_size"},{anchor:"transformers.Pipeline.args_parser",description:`<strong>args_parser</strong> (<a href="/docs/transformers/main/zh/internal/pipelines_utils#transformers.pipelines.ArgumentHandler">ArgumentHandler</a>, <em>optional</em>) &#x2014;
Reference to the object in charge of parsing supplied pipeline parameters.`,name:"args_parser"},{anchor:"transformers.Pipeline.device",description:`<strong>device</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run the model on
the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too`,name:"device"},{anchor:"transformers.Pipeline.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Sent directly as <code>model_kwargs</code> (just a simpler shortcut) to use the available precision for this model
(<code>torch.float16</code>, <code>torch.bfloat16</code>, &#x2026; or <code>&quot;auto&quot;</code>)`,name:"torch_dtype"},{anchor:"transformers.Pipeline.binary_output",description:`<strong>binary_output</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag indicating if the output the pipeline should happen in a serialized format (i.e., pickle) or as
the raw output data e.g. text.`,name:"binary_output"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/base.py#L879"}}),Uo=new j({props:{name:"check_model_type",anchor:"transformers.Pipeline.check_model_type",parameters:[{name:"supported_models",val:": typing.Union[typing.List[str], dict]"}],parametersDescription:[{anchor:"transformers.Pipeline.check_model_type.supported_models",description:`<strong>supported_models</strong> (<code>List[str]</code> or <code>dict</code>) &#x2014;
The list of models supported by the pipeline, or a dictionary with model class values.`,name:"supported_models"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/base.py#L1251"}}),ko=new j({props:{name:"device_placement",anchor:"transformers.Pipeline.device_placement",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/base.py#L1183",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Context manager</p>
`}}),wn=new P({props:{anchor:"transformers.Pipeline.device_placement.example",$$slots:{default:[gM]},$$scope:{ctx:M}}}),jo=new j({props:{name:"ensure_tensor_on_device",anchor:"transformers.Pipeline.ensure_tensor_on_device",parameters:[{name:"**inputs",val:""}],parametersDescription:[{anchor:"transformers.Pipeline.ensure_tensor_on_device.inputs",description:`<strong>inputs</strong> (keyword arguments that should be <code>torch.Tensor</code>, the rest is ignored) &#x2014;
The tensors to place on <code>self.device</code>.`,name:"inputs"},{anchor:"transformers.Pipeline.ensure_tensor_on_device.Recursive",description:"<strong>Recursive</strong> on lists <strong>only</strong>. &#x2014;",name:"Recursive"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/base.py#L1219",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The same as <code>inputs</code> but on the proper device.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, torch.Tensor]</code></p>
`}}),vo=new j({props:{name:"postprocess",anchor:"transformers.Pipeline.postprocess",parameters:[{name:"model_outputs",val:": ModelOutput"},{name:"**postprocess_parameters",val:": typing.Dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/base.py#L1317"}}),$o=new j({props:{name:"predict",anchor:"transformers.Pipeline.predict",parameters:[{name:"X",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/base.py#L1170"}}),Jo=new j({props:{name:"preprocess",anchor:"transformers.Pipeline.preprocess",parameters:[{name:"input_",val:": typing.Any"},{name:"**preprocess_parameters",val:": typing.Dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/base.py#L1296"}}),Po=new j({props:{name:"push_to_hub",anchor:"transformers.Pipeline.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"use_temp_dir",val:": typing.Optional[bool] = None"},{name:"commit_message",val:": typing.Optional[str] = None"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"max_shard_size",val:": typing.Union[str, int, NoneType] = '5GB'"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"revision",val:": typing.Optional[str] = None"},{name:"commit_description",val:": typing.Optional[str] = None"},{name:"tags",val:": typing.Optional[list[str]] = None"},{name:"**deprecated_kwargs",val:""}],parametersDescription:[{anchor:"transformers.Pipeline.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your pipe to. It should contain your organization name
when pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.Pipeline.push_to_hub.use_temp_dir",description:`<strong>use_temp_dir</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to use a temporary directory to store the files saved before they are pushed to the Hub.
Will default to <code>True</code> if there is no directory named like <code>repo_id</code>, <code>False</code> otherwise.`,name:"use_temp_dir"},{anchor:"transformers.Pipeline.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Will default to <code>&quot;Upload pipe&quot;</code>.`,name:"commit_message"},{anchor:"transformers.Pipeline.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to make the repo private. If <code>None</code> (default), the repo will be public unless the organization&#x2019;s default is private. This value is ignored if the repo already exists.`,name:"private"},{anchor:"transformers.Pipeline.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>). Will default to <code>True</code> if <code>repo_url</code>
is not specified.`,name:"token"},{anchor:"transformers.Pipeline.push_to_hub.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>, defaults to <code>&quot;5GB&quot;</code>) &#x2014;
Only applicable for models. The maximum size for a checkpoint before being sharded. Checkpoints shard
will then be each of size lower than this size. If expressed as a string, needs to be digits followed
by a unit (like <code>&quot;5MB&quot;</code>). We default it to <code>&quot;5GB&quot;</code> so that users can easily load models on free-tier
Google Colab instances without any CPU OOM issues.`,name:"max_shard_size"},{anchor:"transformers.Pipeline.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"transformers.Pipeline.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights in safetensors format for safer serialization.`,name:"safe_serialization"},{anchor:"transformers.Pipeline.push_to_hub.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Branch to push the uploaded files to.`,name:"revision"},{anchor:"transformers.Pipeline.push_to_hub.commit_description",description:`<strong>commit_description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the commit that will be created`,name:"commit_description"},{anchor:"transformers.Pipeline.push_to_hub.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of tags to push on the Hub.`,name:"tags"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/hub.py#L838"}}),jn=new P({props:{anchor:"transformers.Pipeline.push_to_hub.example",$$slots:{default:[fM]},$$scope:{ctx:M}}}),Co=new j({props:{name:"save_pretrained",anchor:"transformers.Pipeline.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"safe_serialization",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Pipeline.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
A path to the directory where to saved. It will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"transformers.Pipeline.save_pretrained.safe_serialization",description:`<strong>safe_serialization</strong> (<code>str</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional way for PyTorch or Tensorflow.`,name:"safe_serialization"},{anchor:"transformers.Pipeline.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/main/zh/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/base.py#L1093"}}),Io=new j({props:{name:"transform",anchor:"transformers.Pipeline.transform",parameters:[{name:"X",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/pipelines/base.py#L1164"}}),qo=new U_({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/zh/main_classes/pipelines.md"}}),{c(){o=r("meta"),_=s(),h=r("p"),p=s(),g(x.$$.fragment),t=s(),w=r("p"),w.innerHTML=Hc,Yc=s(),Pn=r("p"),Pn.textContent=KT,Ec=s(),Cn=r("ul"),Cn.innerHTML=ey,Qc=s(),g(In.$$.fragment),Xc=s(),qn=r("p"),qn.innerHTML=ty,Kc=s(),zn=r("p"),zn.textContent=ny,ep=s(),g(Gn.$$.fragment),tp=s(),Zn=r("p"),Zn.innerHTML=sy,np=s(),g(Fn.$$.fragment),sp=s(),Bn=r("p"),Bn.innerHTML=ay,ap=s(),g(Rn.$$.fragment),op=s(),Dn=r("p"),Dn.innerHTML=oy,rp=s(),g(Nn.$$.fragment),ip=s(),Ln=r("p"),Ln.textContent=ry,lp=s(),g(An.$$.fragment),cp=s(),_e=r("div"),g(Vn.$$.fragment),vm=s(),er=r("p"),er.innerHTML=iy,$m=s(),tr=r("p"),tr.textContent=ly,Jm=s(),nr=r("ul"),nr.innerHTML=cy,Pm=s(),g(Xe.$$.fragment),Cm=s(),g(Ke.$$.fragment),pp=s(),g(Wn.$$.fragment),dp=s(),Sn=r("p"),Sn.innerHTML=py,mp=s(),g(Hn.$$.fragment),hp=s(),g(et.$$.fragment),gp=s(),g(On.$$.fragment),fp=s(),g(Yn.$$.fragment),up=s(),En=r("p"),En.textContent=dy,Tp=s(),g(Qn.$$.fragment),yp=s(),Xn=r("p"),Xn.innerHTML=my,bp=s(),g(Kn.$$.fragment),xp=s(),es=r("p"),es.textContent=hy,wp=s(),ts=r("p"),ts.textContent=gy,_p=s(),ns=r("ul"),ns.innerHTML=fy,Mp=s(),g(ss.$$.fragment),Up=s(),as=r("p"),as.innerHTML=uy,kp=s(),os=r("p"),os.innerHTML=Ty,jp=s(),g(rs.$$.fragment),vp=s(),is=r("p"),is.textContent=yy,$p=s(),g(ls.$$.fragment),Jp=s(),cs=r("p"),cs.textContent=by,Pp=s(),ps=r("p"),ps.innerHTML=xy,Cp=s(),g(ds.$$.fragment),Ip=s(),ms=r("p"),ms.textContent=wy,qp=s(),hs=r("p"),hs.innerHTML=_y,zp=s(),gs=r("p"),gs.textContent=My,Gp=s(),fs=r("ul"),fs.innerHTML=Uy,Zp=s(),g(us.$$.fragment),Fp=s(),Ts=r("p"),Ts.textContent=ky,Bp=s(),g(ys.$$.fragment),Rp=s(),bs=r("p"),bs.innerHTML=jy,Dp=s(),g(xs.$$.fragment),Np=s(),ws=r("p"),ws.textContent=vy,Lp=s(),g(_s.$$.fragment),Ap=s(),re=r("div"),g(Ms.$$.fragment),Im=s(),sr=r("p"),sr.innerHTML=$y,qm=s(),g(tt.$$.fragment),zm=s(),ar=r("p"),ar.innerHTML=Jy,Gm=s(),or=r("p"),or.innerHTML=Py,Zm=s(),rr=r("p"),rr.innerHTML=Cy,Fm=s(),nt=r("div"),g(Us.$$.fragment),Bm=s(),ir=r("p"),ir.innerHTML=Iy,Vp=s(),g(ks.$$.fragment),Wp=s(),Q=r("div"),g(js.$$.fragment),Rm=s(),lr=r("p"),lr.textContent=qy,Dm=s(),cr=r("p"),cr.textContent=zy,Nm=s(),pr=r("p"),pr.innerHTML=Gy,Lm=s(),dr=r("ul"),dr.innerHTML=Zy,Am=s(),g(st.$$.fragment),Vm=s(),mr=r("p"),mr.innerHTML=Fy,Wm=s(),at=r("div"),g(vs.$$.fragment),Sm=s(),hr=r("p"),hr.innerHTML=By,Sp=s(),g($s.$$.fragment),Hp=s(),G=r("div"),g(Js.$$.fragment),Hm=s(),gr=r("p"),gr.innerHTML=Ry,Om=s(),fr=r("p"),fr.innerHTML=Dy,Ym=s(),ur=r("ul"),ur.innerHTML=Ny,Em=s(),g(ot.$$.fragment),Qm=s(),Tr=r("p"),Tr.innerHTML=Ly,Xm=s(),g(rt.$$.fragment),Km=s(),yr=r("p"),yr.innerHTML=Ay,eh=s(),br=r("p"),br.innerHTML=Vy,th=s(),it=r("div"),g(Ps.$$.fragment),nh=s(),xr=r("p"),xr.innerHTML=Wy,Op=s(),g(Cs.$$.fragment),Yp=s(),Me=r("div"),g(Is.$$.fragment),sh=s(),wr=r("p"),wr.innerHTML=Sy,ah=s(),g(lt.$$.fragment),oh=s(),g(ct.$$.fragment),rh=s(),_r=r("p"),_r.innerHTML=Hy,ih=s(),pt=r("div"),g(qs.$$.fragment),lh=s(),Mr=r("p"),Mr.textContent=Oy,Ep=s(),g(zs.$$.fragment),Qp=s(),Gs=r("p"),Gs.textContent=Yy,Xp=s(),g(Zs.$$.fragment),Kp=s(),ie=r("div"),g(Fs.$$.fragment),ch=s(),Ur=r("p"),Ur.innerHTML=Ey,ph=s(),g(dt.$$.fragment),dh=s(),kr=r("p"),kr.innerHTML=Qy,mh=s(),jr=r("p"),jr.innerHTML=Xy,hh=s(),vr=r("p"),vr.innerHTML=Ky,gh=s(),mt=r("div"),g(Bs.$$.fragment),fh=s(),$r=r("p"),$r.textContent=eb,ed=s(),g(Rs.$$.fragment),td=s(),le=r("div"),g(Ds.$$.fragment),uh=s(),Jr=r("p"),Jr.innerHTML=tb,Th=s(),g(ht.$$.fragment),yh=s(),Pr=r("p"),Pr.innerHTML=nb,bh=s(),Cr=r("p"),Cr.innerHTML=sb,xh=s(),Ir=r("p"),Ir.innerHTML=ab,wh=s(),gt=r("div"),g(Ns.$$.fragment),_h=s(),qr=r("p"),qr.textContent=ob,nd=s(),g(Ls.$$.fragment),sd=s(),Ue=r("div"),g(As.$$.fragment),Mh=s(),zr=r("p"),zr.innerHTML=rb,Uh=s(),g(ft.$$.fragment),kh=s(),Gr=r("p"),Gr.innerHTML=ib,jh=s(),Zr=r("p"),Zr.innerHTML=lb,vh=s(),ut=r("div"),g(Vs.$$.fragment),$h=s(),Fr=r("p"),Fr.textContent=cb,ad=s(),g(Ws.$$.fragment),od=s(),ke=r("div"),g(Ss.$$.fragment),Jh=s(),Br=r("p"),Br.innerHTML=pb,Ph=s(),g(Tt.$$.fragment),Ch=s(),Rr=r("p"),Rr.innerHTML=db,Ih=s(),Dr=r("p"),Dr.innerHTML=mb,qh=s(),yt=r("div"),g(Hs.$$.fragment),zh=s(),Nr=r("p"),Nr.textContent=hb,rd=s(),g(Os.$$.fragment),id=s(),ce=r("div"),g(Ys.$$.fragment),Gh=s(),Lr=r("p"),Lr.innerHTML=gb,Zh=s(),g(bt.$$.fragment),Fh=s(),Ar=r("p"),Ar.innerHTML=fb,Bh=s(),Vr=r("p"),Vr.innerHTML=ub,Rh=s(),Wr=r("p"),Wr.innerHTML=Tb,Dh=s(),xt=r("div"),g(Es.$$.fragment),Nh=s(),Sr=r("p"),Sr.textContent=yb,ld=s(),g(Qs.$$.fragment),cd=s(),Ge=r("div"),g(Xs.$$.fragment),Lh=s(),Hr=r("p"),Hr.innerHTML=bb,Ah=s(),Or=r("p"),Or.innerHTML=xb,Vh=s(),Yr=r("p"),Yr.innerHTML=wb,Wh=s(),wt=r("div"),g(Ks.$$.fragment),Sh=s(),Er=r("p"),Er.textContent=_b,pd=s(),g(ea.$$.fragment),dd=s(),pe=r("div"),g(ta.$$.fragment),Hh=s(),Qr=r("p"),Qr.innerHTML=Mb,Oh=s(),g(_t.$$.fragment),Yh=s(),Xr=r("p"),Xr.innerHTML=Ub,Eh=s(),Kr=r("p"),Kr.innerHTML=kb,Qh=s(),ei=r("p"),ei.innerHTML=jb,Xh=s(),Mt=r("div"),g(na.$$.fragment),Kh=s(),ti=r("p"),ti.textContent=vb,md=s(),g(sa.$$.fragment),hd=s(),de=r("div"),g(aa.$$.fragment),eg=s(),ni=r("p"),ni.innerHTML=$b,tg=s(),g(Ut.$$.fragment),ng=s(),si=r("p"),si.innerHTML=Jb,sg=s(),ai=r("p"),ai.innerHTML=Pb,ag=s(),oi=r("p"),oi.innerHTML=Cb,og=s(),kt=r("div"),g(oa.$$.fragment),rg=s(),ri=r("p"),ri.textContent=Ib,gd=s(),g(ra.$$.fragment),fd=s(),ia=r("p"),ia.textContent=qb,ud=s(),g(la.$$.fragment),Td=s(),R=r("div"),g(ca.$$.fragment),ig=s(),ii=r("p"),ii.innerHTML=zb,lg=s(),g(jt.$$.fragment),cg=s(),li=r("p"),li.innerHTML=Gb,pg=s(),ci=r("p"),ci.innerHTML=Zb,dg=s(),pi=r("p"),pi.innerHTML=Fb,mg=s(),g(vt.$$.fragment),hg=s(),g($t.$$.fragment),gg=s(),Jt=r("div"),g(pa.$$.fragment),fg=s(),di=r("p"),di.textContent=Bb,yd=s(),g(da.$$.fragment),bd=s(),Z=r("div"),g(ma.$$.fragment),ug=s(),mi=r("p"),mi.innerHTML=Rb,Tg=s(),g(Pt.$$.fragment),yg=s(),hi=r("p"),hi.innerHTML=Db,bg=s(),gi=r("p"),gi.innerHTML=Nb,xg=s(),fi=r("p"),fi.innerHTML=Lb,wg=s(),Ve=r("div"),g(ha.$$.fragment),_g=s(),ui=r("p"),ui.textContent=Ab,Mg=s(),Ti=r("p"),Ti.textContent=Vb,Ug=s(),Ct=r("div"),g(ga.$$.fragment),kg=s(),yi=r("p"),yi.textContent=Wb,jg=s(),It=r("div"),g(fa.$$.fragment),vg=s(),bi=r("p"),bi.textContent=Sb,$g=s(),qt=r("div"),g(ua.$$.fragment),Jg=s(),xi=r("p"),xi.textContent=Hb,xd=s(),Ta=r("p"),Ta.innerHTML=Ob,wd=s(),g(ya.$$.fragment),_d=s(),D=r("div"),g(ba.$$.fragment),Pg=s(),wi=r("p"),wi.innerHTML=Yb,Cg=s(),g(zt.$$.fragment),Ig=s(),_i=r("p"),_i.innerHTML=Eb,qg=s(),Mi=r("p"),Mi.innerHTML=Qb,zg=s(),Ui=r("p"),Ui.innerHTML=Xb,Gg=s(),Gt=r("div"),g(xa.$$.fragment),Zg=s(),ki=r("p"),ki.textContent=Kb,Fg=s(),We=r("div"),g(wa.$$.fragment),Bg=s(),ji=r("p"),ji.innerHTML=ex,Rg=s(),vi=r("p"),vi.textContent=tx,Dg=s(),Zt=r("div"),g(_a.$$.fragment),Ng=s(),$i=r("p"),$i.textContent=nx,Md=s(),g(Ma.$$.fragment),Ud=s(),X=r("div"),g(Ua.$$.fragment),Lg=s(),Ji=r("p"),Ji.textContent=sx,Ag=s(),Pi=r("p"),Pi.innerHTML=ax,Vg=s(),Ci=r("p"),Ci.innerHTML=ox,Wg=s(),Ii=r("p"),Ii.innerHTML=rx,Sg=s(),qi=r("ul"),qi.innerHTML=ix,Hg=s(),g(Ft.$$.fragment),Og=s(),Bt=r("div"),g(ka.$$.fragment),Yg=s(),zi=r("p"),zi.textContent=lx,kd=s(),g(ja.$$.fragment),jd=s(),N=r("div"),g(va.$$.fragment),Eg=s(),Gi=r("p"),Gi.innerHTML=cx,Qg=s(),Zi=r("p"),Zi.innerHTML=px,Xg=s(),Fi=r("ul"),Fi.innerHTML=dx,Kg=s(),g(Rt.$$.fragment),ef=s(),Bi=r("p"),Bi.innerHTML=mx,tf=s(),Ri=r("p"),Ri.innerHTML=hx,nf=s(),Di=r("p"),Di.innerHTML=gx,sf=s(),Te=r("div"),g($a.$$.fragment),af=s(),Ni=r("p"),Ni.textContent=fx,of=s(),Li=r("ul"),Li.innerHTML=ux,rf=s(),Ai=r("p"),Ai.innerHTML=Tx,lf=s(),g(Dt.$$.fragment),cf=s(),Vi=r("p"),Vi.textContent=yx,pf=s(),g(Nt.$$.fragment),vd=s(),g(Ja.$$.fragment),$d=s(),K=r("div"),g(Pa.$$.fragment),df=s(),Wi=r("p"),Wi.innerHTML=bx,mf=s(),g(Lt.$$.fragment),hf=s(),Si=r("p"),Si.innerHTML=xx,gf=s(),Hi=r("p"),Hi.innerHTML=wx,ff=s(),Oi=r("p"),Oi.innerHTML=_x,uf=s(),Yi=r("p"),Yi.innerHTML=Mx,Tf=s(),At=r("div"),g(Ca.$$.fragment),yf=s(),Ei=r("p"),Ei.textContent=Ux,Jd=s(),g(Ia.$$.fragment),Pd=s(),F=r("div"),g(qa.$$.fragment),bf=s(),Qi=r("p"),Qi.innerHTML=kx,xf=s(),Xi=r("p"),Xi.innerHTML=jx,wf=s(),Ki=r("ul"),Ki.innerHTML=vx,_f=s(),g(Vt.$$.fragment),Mf=s(),g(Wt.$$.fragment),Uf=s(),el=r("p"),el.innerHTML=$x,kf=s(),tl=r("p"),tl.innerHTML=Jx,jf=s(),nl=r("p"),nl.innerHTML=Px,vf=s(),St=r("div"),g(za.$$.fragment),$f=s(),sl=r("p"),sl.textContent=Cx,Cd=s(),g(Ga.$$.fragment),Id=s(),q=r("div"),g(Za.$$.fragment),Jf=s(),al=r("p"),al.textContent=Ix,Pf=s(),ol=r("p"),ol.innerHTML=qx,Cf=s(),rl=r("ul"),rl.innerHTML=zx,If=s(),g(Ht.$$.fragment),qf=s(),il=r("p"),il.innerHTML=Gx,zf=s(),ll=r("p"),ll.innerHTML=Zx,Gf=s(),cl=r("p"),cl.innerHTML=Fx,Zf=s(),g(Ot.$$.fragment),Ff=s(),Yt=r("div"),g(Fa.$$.fragment),Bf=s(),pl=r("p"),pl.textContent=Bx,Rf=s(),Et=r("div"),g(Ba.$$.fragment),Df=s(),dl=r("p"),dl.textContent=Rx,qd=s(),g(Ra.$$.fragment),zd=s(),z=r("div"),g(Da.$$.fragment),Nf=s(),ml=r("p"),ml.innerHTML=Dx,Lf=s(),g(Qt.$$.fragment),Af=s(),hl=r("p"),hl.innerHTML=Nx,Vf=s(),gl=r("p"),gl.innerHTML=Lx,Wf=s(),fl=r("p"),fl.innerHTML=Ax,Sf=s(),Xt=r("div"),g(Na.$$.fragment),Hf=s(),ul=r("p"),ul.textContent=Vx,Of=s(),Se=r("div"),g(La.$$.fragment),Yf=s(),Tl=r("p"),Tl.textContent=Wx,Ef=s(),yl=r("p"),yl.textContent=Sx,Qf=s(),Kt=r("div"),g(Aa.$$.fragment),Xf=s(),bl=r("p"),bl.textContent=Hx,Kf=s(),en=r("div"),g(Va.$$.fragment),eu=s(),xl=r("p"),xl.textContent=Ox,tu=s(),tn=r("div"),g(Wa.$$.fragment),nu=s(),wl=r("p"),wl.textContent=Yx,Gd=s(),g(Sa.$$.fragment),Zd=s(),ee=r("div"),g(Ha.$$.fragment),su=s(),_l=r("p"),_l.textContent=Ex,au=s(),Ml=r("p"),Ml.innerHTML=Qx,ou=s(),Ul=r("p"),Ul.innerHTML=Xx,ru=s(),kl=r("p"),kl.innerHTML=Kx,iu=s(),jl=r("ul"),jl.innerHTML=ew,lu=s(),g(nn.$$.fragment),cu=s(),sn=r("div"),g(Oa.$$.fragment),pu=s(),vl=r("p"),vl.textContent=tw,Fd=s(),g(Ya.$$.fragment),Bd=s(),te=r("div"),g(Ea.$$.fragment),du=s(),$l=r("p"),$l.innerHTML=nw,mu=s(),Jl=r("p"),Jl.innerHTML=sw,hu=s(),g(an.$$.fragment),gu=s(),Pl=r("p"),Pl.innerHTML=aw,fu=s(),Cl=r("p"),Cl.innerHTML=ow,uu=s(),Il=r("p"),Il.innerHTML=rw,Tu=s(),on=r("div"),g(Qa.$$.fragment),yu=s(),ql=r("p"),ql.innerHTML=iw,Rd=s(),g(Xa.$$.fragment),Dd=s(),Ka=r("p"),Ka.textContent=lw,Nd=s(),g(eo.$$.fragment),Ld=s(),L=r("div"),g(to.$$.fragment),bu=s(),zl=r("p"),zl.innerHTML=cw,xu=s(),Gl=r("p"),Gl.innerHTML=pw,wu=s(),Zl=r("ul"),Zl.innerHTML=dw,_u=s(),g(rn.$$.fragment),Mu=s(),Fl=r("p"),Fl.innerHTML=mw,Uu=s(),Bl=r("p"),Bl.innerHTML=hw,ku=s(),Rl=r("p"),Rl.innerHTML=gw,ju=s(),Ae=r("div"),g(no.$$.fragment),vu=s(),Dl=r("p"),Dl.innerHTML=fw,$u=s(),Nl=r("p"),Nl.textContent=uw,Ju=s(),Ll=r("ul"),Ll.innerHTML=Tw,Ad=s(),g(so.$$.fragment),Vd=s(),me=r("div"),g(ao.$$.fragment),Pu=s(),Al=r("p"),Al.textContent=yw,Cu=s(),g(ln.$$.fragment),Iu=s(),Vl=r("p"),Vl.innerHTML=bw,qu=s(),Wl=r("p"),Wl.innerHTML=xw,zu=s(),Sl=r("p"),Sl.innerHTML=ww,Gu=s(),cn=r("div"),g(oo.$$.fragment),Zu=s(),Hl=r("p"),Hl.textContent=_w,Wd=s(),g(ro.$$.fragment),Sd=s(),he=r("div"),g(io.$$.fragment),Fu=s(),Ol=r("p"),Ol.textContent=Mw,Bu=s(),g(pn.$$.fragment),Ru=s(),Yl=r("p"),Yl.innerHTML=Uw,Du=s(),El=r("p"),El.innerHTML=kw,Nu=s(),Ql=r("p"),Ql.innerHTML=jw,Lu=s(),dn=r("div"),g(lo.$$.fragment),Au=s(),Xl=r("p"),Xl.textContent=vw,Hd=s(),g(co.$$.fragment),Od=s(),A=r("div"),g(po.$$.fragment),Vu=s(),Kl=r("p"),Kl.innerHTML=$w,Wu=s(),ec=r("p"),ec.innerHTML=Jw,Su=s(),tc=r("ul"),tc.innerHTML=Pw,Hu=s(),g(mn.$$.fragment),Ou=s(),nc=r("p"),nc.innerHTML=Cw,Yu=s(),sc=r("p"),sc.textContent=Iw,Eu=s(),ac=r("p"),ac.innerHTML=qw,Qu=s(),hn=r("div"),g(mo.$$.fragment),Xu=s(),oc=r("p"),oc.textContent=zw,Yd=s(),g(ho.$$.fragment),Ed=s(),B=r("div"),g(go.$$.fragment),Ku=s(),rc=r("p"),rc.innerHTML=Gw,eT=s(),ic=r("p"),ic.innerHTML=Zw,tT=s(),lc=r("ul"),lc.innerHTML=Fw,nT=s(),g(gn.$$.fragment),sT=s(),g(fn.$$.fragment),aT=s(),cc=r("p"),cc.innerHTML=Bw,oT=s(),pc=r("p"),pc.textContent=Rw,rT=s(),dc=r("p"),dc.innerHTML=Dw,iT=s(),un=r("div"),g(fo.$$.fragment),lT=s(),mc=r("p"),mc.textContent=Nw,Qd=s(),g(uo.$$.fragment),Xd=s(),V=r("div"),g(To.$$.fragment),cT=s(),hc=r("p"),hc.innerHTML=Lw,pT=s(),gc=r("p"),gc.textContent=Aw,dT=s(),fc=r("ol"),fc.innerHTML=Vw,mT=s(),g(Tn.$$.fragment),hT=s(),uc=r("p"),uc.innerHTML=Ww,gT=s(),Tc=r("p"),Tc.innerHTML=Sw,fT=s(),yc=r("p"),yc.innerHTML=Hw,uT=s(),yn=r("div"),g(yo.$$.fragment),TT=s(),bc=r("p"),bc.textContent=Ow,Kd=s(),g(bo.$$.fragment),em=s(),W=r("div"),g(xo.$$.fragment),yT=s(),xc=r("p"),xc.innerHTML=Yw,bT=s(),wc=r("p"),wc.innerHTML=Ew,xT=s(),_c=r("ul"),_c.innerHTML=Qw,wT=s(),g(bn.$$.fragment),_T=s(),Mc=r("p"),Mc.innerHTML=Xw,MT=s(),Uc=r("p"),Uc.innerHTML=Kw,UT=s(),kc=r("p"),kc.innerHTML=e_,kT=s(),He=r("div"),g(wo.$$.fragment),jT=s(),jc=r("p"),jc.textContent=t_,vT=s(),vc=r("ul"),vc.innerHTML=n_,tm=s(),g(_o.$$.fragment),nm=s(),C=r("div"),g(Mo.$$.fragment),$T=s(),$c=r("p"),$c.textContent=s_,JT=s(),Jc=r("p"),Jc.textContent=a_,PT=s(),Pc=r("p"),Pc.textContent=o_,CT=s(),Cc=r("p"),Cc.textContent=r_,IT=s(),Ic=r("p"),Ic.innerHTML=i_,qT=s(),xn=r("div"),g(Uo.$$.fragment),zT=s(),qc=r("p"),qc.textContent=l_,GT=s(),Oe=r("div"),g(ko.$$.fragment),ZT=s(),zc=r("p"),zc.textContent=c_,FT=s(),g(wn.$$.fragment),BT=s(),_n=r("div"),g(jo.$$.fragment),RT=s(),Gc=r("p"),Gc.textContent=p_,DT=s(),Mn=r("div"),g(vo.$$.fragment),NT=s(),Zc=r("p"),Zc.innerHTML=d_,LT=s(),Un=r("div"),g($o.$$.fragment),AT=s(),Fc=r("p"),Fc.innerHTML=m_,VT=s(),kn=r("div"),g(Jo.$$.fragment),WT=s(),Bc=r("p"),Bc.innerHTML=h_,ST=s(),Ye=r("div"),g(Po.$$.fragment),HT=s(),Rc=r("p"),Rc.textContent=g_,OT=s(),g(jn.$$.fragment),YT=s(),vn=r("div"),g(Co.$$.fragment),ET=s(),Dc=r("p"),Dc.textContent=f_,QT=s(),$n=r("div"),g(Io.$$.fragment),XT=s(),Nc=r("p"),Nc.innerHTML=u_,sm=s(),g(qo.$$.fragment),am=s(),Oc=r("p"),this.h()},l(e){const c=w_("svelte-u9bgzb",document.head);o=i(c,"META",{name:!0,content:!0}),c.forEach(l),_=a(e),h=i(e,"P",{}),U(h).forEach(l),p=a(e),f(x.$$.fragment,e),t=a(e),w=i(e,"P",{"data-svelte-h":!0}),d(w)!=="svelte-gqgo8q"&&(w.innerHTML=Hc),Yc=a(e),Pn=i(e,"P",{"data-svelte-h":!0}),d(Pn)!=="svelte-17orrwm"&&(Pn.textContent=KT),Ec=a(e),Cn=i(e,"UL",{"data-svelte-h":!0}),d(Cn)!=="svelte-1dn5ygq"&&(Cn.innerHTML=ey),Qc=a(e),f(In.$$.fragment,e),Xc=a(e),qn=i(e,"P",{"data-svelte-h":!0}),d(qn)!=="svelte-746ti5"&&(qn.innerHTML=ty),Kc=a(e),zn=i(e,"P",{"data-svelte-h":!0}),d(zn)!=="svelte-zrudxx"&&(zn.textContent=ny),ep=a(e),f(Gn.$$.fragment,e),tp=a(e),Zn=i(e,"P",{"data-svelte-h":!0}),d(Zn)!=="svelte-1n5prhc"&&(Zn.innerHTML=sy),np=a(e),f(Fn.$$.fragment,e),sp=a(e),Bn=i(e,"P",{"data-svelte-h":!0}),d(Bn)!=="svelte-qi7qyk"&&(Bn.innerHTML=ay),ap=a(e),f(Rn.$$.fragment,e),op=a(e),Dn=i(e,"P",{"data-svelte-h":!0}),d(Dn)!=="svelte-n7de29"&&(Dn.innerHTML=oy),rp=a(e),f(Nn.$$.fragment,e),ip=a(e),Ln=i(e,"P",{"data-svelte-h":!0}),d(Ln)!=="svelte-11chlj4"&&(Ln.textContent=ry),lp=a(e),f(An.$$.fragment,e),cp=a(e),_e=i(e,"DIV",{class:!0});var Ze=U(_e);f(Vn.$$.fragment,Ze),vm=a(Ze),er=i(Ze,"P",{"data-svelte-h":!0}),d(er)!=="svelte-17pwaf6"&&(er.innerHTML=iy),$m=a(Ze),tr=i(Ze,"P",{"data-svelte-h":!0}),d(tr)!=="svelte-jpprfs"&&(tr.textContent=ly),Jm=a(Ze),nr=i(Ze,"UL",{"data-svelte-h":!0}),d(nr)!=="svelte-1htam2n"&&(nr.innerHTML=cy),Pm=a(Ze),f(Xe.$$.fragment,Ze),Cm=a(Ze),f(Ke.$$.fragment,Ze),Ze.forEach(l),pp=a(e),f(Wn.$$.fragment,e),dp=a(e),Sn=i(e,"P",{"data-svelte-h":!0}),d(Sn)!=="svelte-v5xc82"&&(Sn.innerHTML=py),mp=a(e),f(Hn.$$.fragment,e),hp=a(e),f(et.$$.fragment,e),gp=a(e),f(On.$$.fragment,e),fp=a(e),f(Yn.$$.fragment,e),up=a(e),En=i(e,"P",{"data-svelte-h":!0}),d(En)!=="svelte-pccs60"&&(En.textContent=dy),Tp=a(e),f(Qn.$$.fragment,e),yp=a(e),Xn=i(e,"P",{"data-svelte-h":!0}),d(Xn)!=="svelte-1nxx4l6"&&(Xn.innerHTML=my),bp=a(e),f(Kn.$$.fragment,e),xp=a(e),es=i(e,"P",{"data-svelte-h":!0}),d(es)!=="svelte-wxes32"&&(es.textContent=hy),wp=a(e),ts=i(e,"P",{"data-svelte-h":!0}),d(ts)!=="svelte-i0f5f4"&&(ts.textContent=gy),_p=a(e),ns=i(e,"UL",{"data-svelte-h":!0}),d(ns)!=="svelte-h590re"&&(ns.innerHTML=fy),Mp=a(e),f(ss.$$.fragment,e),Up=a(e),as=i(e,"P",{"data-svelte-h":!0}),d(as)!=="svelte-qmvd7m"&&(as.innerHTML=uy),kp=a(e),os=i(e,"P",{"data-svelte-h":!0}),d(os)!=="svelte-1rszvwl"&&(os.innerHTML=Ty),jp=a(e),f(rs.$$.fragment,e),vp=a(e),is=i(e,"P",{"data-svelte-h":!0}),d(is)!=="svelte-1seu35y"&&(is.textContent=yy),$p=a(e),f(ls.$$.fragment,e),Jp=a(e),cs=i(e,"P",{"data-svelte-h":!0}),d(cs)!=="svelte-6rhsm0"&&(cs.textContent=by),Pp=a(e),ps=i(e,"P",{"data-svelte-h":!0}),d(ps)!=="svelte-1586eur"&&(ps.innerHTML=xy),Cp=a(e),f(ds.$$.fragment,e),Ip=a(e),ms=i(e,"P",{"data-svelte-h":!0}),d(ms)!=="svelte-1c2jxl3"&&(ms.textContent=wy),qp=a(e),hs=i(e,"P",{"data-svelte-h":!0}),d(hs)!=="svelte-xhq1b2"&&(hs.innerHTML=_y),zp=a(e),gs=i(e,"P",{"data-svelte-h":!0}),d(gs)!=="svelte-14y1xl"&&(gs.textContent=My),Gp=a(e),fs=i(e,"UL",{"data-svelte-h":!0}),d(fs)!=="svelte-1ducd9d"&&(fs.innerHTML=Uy),Zp=a(e),f(us.$$.fragment,e),Fp=a(e),Ts=i(e,"P",{"data-svelte-h":!0}),d(Ts)!=="svelte-as5dux"&&(Ts.textContent=ky),Bp=a(e),f(ys.$$.fragment,e),Rp=a(e),bs=i(e,"P",{"data-svelte-h":!0}),d(bs)!=="svelte-12n9b6f"&&(bs.innerHTML=jy),Dp=a(e),f(xs.$$.fragment,e),Np=a(e),ws=i(e,"P",{"data-svelte-h":!0}),d(ws)!=="svelte-vn3gp9"&&(ws.textContent=vy),Lp=a(e),f(_s.$$.fragment,e),Ap=a(e),re=i(e,"DIV",{class:!0});var je=U(re);f(Ms.$$.fragment,je),Im=a(je),sr=i(je,"P",{"data-svelte-h":!0}),d(sr)!=="svelte-1wmh7ni"&&(sr.innerHTML=$y),qm=a(je),f(tt.$$.fragment,je),zm=a(je),ar=i(je,"P",{"data-svelte-h":!0}),d(ar)!=="svelte-13rexfx"&&(ar.innerHTML=Jy),Gm=a(je),or=i(je,"P",{"data-svelte-h":!0}),d(or)!=="svelte-nt2sqy"&&(or.innerHTML=Py),Zm=a(je),rr=i(je,"P",{"data-svelte-h":!0}),d(rr)!=="svelte-1pv1mxa"&&(rr.innerHTML=Cy),Fm=a(je),nt=i(je,"DIV",{class:!0});var zo=U(nt);f(Us.$$.fragment,zo),Bm=a(zo),ir=i(zo,"P",{"data-svelte-h":!0}),d(ir)!=="svelte-th77pz"&&(ir.innerHTML=Iy),zo.forEach(l),je.forEach(l),Vp=a(e),f(ks.$$.fragment,e),Wp=a(e),Q=i(e,"DIV",{class:!0});var ge=U(Q);f(js.$$.fragment,ge),Rm=a(ge),lr=i(ge,"P",{"data-svelte-h":!0}),d(lr)!=="svelte-vm8asa"&&(lr.textContent=qy),Dm=a(ge),cr=i(ge,"P",{"data-svelte-h":!0}),d(cr)!=="svelte-1l0gjoy"&&(cr.textContent=zy),Nm=a(ge),pr=i(ge,"P",{"data-svelte-h":!0}),d(pr)!=="svelte-42qofm"&&(pr.innerHTML=Gy),Lm=a(ge),dr=i(ge,"UL",{"data-svelte-h":!0}),d(dr)!=="svelte-1br0xz1"&&(dr.innerHTML=Zy),Am=a(ge),f(st.$$.fragment,ge),Vm=a(ge),mr=i(ge,"P",{"data-svelte-h":!0}),d(mr)!=="svelte-13rexfx"&&(mr.innerHTML=Fy),Wm=a(ge),at=i(ge,"DIV",{class:!0});var Go=U(at);f(vs.$$.fragment,Go),Sm=a(Go),hr=i(Go,"P",{"data-svelte-h":!0}),d(hr)!=="svelte-1tmib06"&&(hr.innerHTML=By),Go.forEach(l),ge.forEach(l),Sp=a(e),f($s.$$.fragment,e),Hp=a(e),G=i(e,"DIV",{class:!0});var S=U(G);f(Js.$$.fragment,S),Hm=a(S),gr=i(S,"P",{"data-svelte-h":!0}),d(gr)!=="svelte-y1s454"&&(gr.innerHTML=Ry),Om=a(S),fr=i(S,"P",{"data-svelte-h":!0}),d(fr)!=="svelte-42qofm"&&(fr.innerHTML=Dy),Ym=a(S),ur=i(S,"UL",{"data-svelte-h":!0}),d(ur)!=="svelte-pmfbv0"&&(ur.innerHTML=Ny),Em=a(S),f(ot.$$.fragment,S),Qm=a(S),Tr=i(S,"P",{"data-svelte-h":!0}),d(Tr)!=="svelte-13rexfx"&&(Tr.innerHTML=Ly),Xm=a(S),f(rt.$$.fragment,S),Km=a(S),yr=i(S,"P",{"data-svelte-h":!0}),d(yr)!=="svelte-61c6fc"&&(yr.innerHTML=Ay),eh=a(S),br=i(S,"P",{"data-svelte-h":!0}),d(br)!=="svelte-1g4o6wf"&&(br.innerHTML=Vy),th=a(S),it=i(S,"DIV",{class:!0});var Zo=U(it);f(Ps.$$.fragment,Zo),nh=a(Zo),xr=i(Zo,"P",{"data-svelte-h":!0}),d(xr)!=="svelte-1kfk3sq"&&(xr.innerHTML=Wy),Zo.forEach(l),S.forEach(l),Op=a(e),f(Cs.$$.fragment,e),Yp=a(e),Me=i(e,"DIV",{class:!0});var Fe=U(Me);f(Is.$$.fragment,Fe),sh=a(Fe),wr=i(Fe,"P",{"data-svelte-h":!0}),d(wr)!=="svelte-tmg4zt"&&(wr.innerHTML=Sy),ah=a(Fe),f(lt.$$.fragment,Fe),oh=a(Fe),f(ct.$$.fragment,Fe),rh=a(Fe),_r=i(Fe,"P",{"data-svelte-h":!0}),d(_r)!=="svelte-fda8c5"&&(_r.innerHTML=Hy),ih=a(Fe),pt=i(Fe,"DIV",{class:!0});var Fo=U(pt);f(qs.$$.fragment,Fo),lh=a(Fo),Mr=i(Fo,"P",{"data-svelte-h":!0}),d(Mr)!=="svelte-kd58rd"&&(Mr.textContent=Oy),Fo.forEach(l),Fe.forEach(l),Ep=a(e),f(zs.$$.fragment,e),Qp=a(e),Gs=i(e,"P",{"data-svelte-h":!0}),d(Gs)!=="svelte-666kgg"&&(Gs.textContent=Yy),Xp=a(e),f(Zs.$$.fragment,e),Kp=a(e),ie=i(e,"DIV",{class:!0});var ve=U(ie);f(Fs.$$.fragment,ve),ch=a(ve),Ur=i(ve,"P",{"data-svelte-h":!0}),d(Ur)!=="svelte-cmozej"&&(Ur.innerHTML=Ey),ph=a(ve),f(dt.$$.fragment,ve),dh=a(ve),kr=i(ve,"P",{"data-svelte-h":!0}),d(kr)!=="svelte-13rexfx"&&(kr.innerHTML=Qy),mh=a(ve),jr=i(ve,"P",{"data-svelte-h":!0}),d(jr)!=="svelte-wy5irg"&&(jr.innerHTML=Xy),hh=a(ve),vr=i(ve,"P",{"data-svelte-h":!0}),d(vr)!=="svelte-6trb8y"&&(vr.innerHTML=Ky),gh=a(ve),mt=i(ve,"DIV",{class:!0});var Bo=U(mt);f(Bs.$$.fragment,Bo),fh=a(Bo),$r=i(Bo,"P",{"data-svelte-h":!0}),d($r)!=="svelte-10lhg27"&&($r.textContent=eb),Bo.forEach(l),ve.forEach(l),ed=a(e),f(Rs.$$.fragment,e),td=a(e),le=i(e,"DIV",{class:!0});var $e=U(le);f(Ds.$$.fragment,$e),uh=a($e),Jr=i($e,"P",{"data-svelte-h":!0}),d(Jr)!=="svelte-rlbi70"&&(Jr.innerHTML=tb),Th=a($e),f(ht.$$.fragment,$e),yh=a($e),Pr=i($e,"P",{"data-svelte-h":!0}),d(Pr)!=="svelte-13rexfx"&&(Pr.innerHTML=nb),bh=a($e),Cr=i($e,"P",{"data-svelte-h":!0}),d(Cr)!=="svelte-e2q3fa"&&(Cr.innerHTML=sb),xh=a($e),Ir=i($e,"P",{"data-svelte-h":!0}),d(Ir)!=="svelte-cqpf5t"&&(Ir.innerHTML=ab),wh=a($e),gt=i($e,"DIV",{class:!0});var Ro=U(gt);f(Ns.$$.fragment,Ro),_h=a(Ro),qr=i(Ro,"P",{"data-svelte-h":!0}),d(qr)!=="svelte-ypfmt8"&&(qr.textContent=ob),Ro.forEach(l),$e.forEach(l),nd=a(e),f(Ls.$$.fragment,e),sd=a(e),Ue=i(e,"DIV",{class:!0});var Be=U(Ue);f(As.$$.fragment,Be),Mh=a(Be),zr=i(Be,"P",{"data-svelte-h":!0}),d(zr)!=="svelte-1y2a978"&&(zr.innerHTML=rb),Uh=a(Be),f(ft.$$.fragment,Be),kh=a(Be),Gr=i(Be,"P",{"data-svelte-h":!0}),d(Gr)!=="svelte-1plrfve"&&(Gr.innerHTML=ib),jh=a(Be),Zr=i(Be,"P",{"data-svelte-h":!0}),d(Zr)!=="svelte-151zbn3"&&(Zr.innerHTML=lb),vh=a(Be),ut=i(Be,"DIV",{class:!0});var Do=U(ut);f(Vs.$$.fragment,Do),$h=a(Do),Fr=i(Do,"P",{"data-svelte-h":!0}),d(Fr)!=="svelte-1qn9qfa"&&(Fr.textContent=cb),Do.forEach(l),Be.forEach(l),ad=a(e),f(Ws.$$.fragment,e),od=a(e),ke=i(e,"DIV",{class:!0});var Re=U(ke);f(Ss.$$.fragment,Re),Jh=a(Re),Br=i(Re,"P",{"data-svelte-h":!0}),d(Br)!=="svelte-5hn3v1"&&(Br.innerHTML=pb),Ph=a(Re),f(Tt.$$.fragment,Re),Ch=a(Re),Rr=i(Re,"P",{"data-svelte-h":!0}),d(Rr)!=="svelte-i3ugm9"&&(Rr.innerHTML=db),Ih=a(Re),Dr=i(Re,"P",{"data-svelte-h":!0}),d(Dr)!=="svelte-1pm9980"&&(Dr.innerHTML=mb),qh=a(Re),yt=i(Re,"DIV",{class:!0});var No=U(yt);f(Hs.$$.fragment,No),zh=a(No),Nr=i(No,"P",{"data-svelte-h":!0}),d(Nr)!=="svelte-1ega32d"&&(Nr.textContent=hb),No.forEach(l),Re.forEach(l),rd=a(e),f(Os.$$.fragment,e),id=a(e),ce=i(e,"DIV",{class:!0});var Je=U(ce);f(Ys.$$.fragment,Je),Gh=a(Je),Lr=i(Je,"P",{"data-svelte-h":!0}),d(Lr)!=="svelte-1c7y9od"&&(Lr.innerHTML=gb),Zh=a(Je),f(bt.$$.fragment,Je),Fh=a(Je),Ar=i(Je,"P",{"data-svelte-h":!0}),d(Ar)!=="svelte-13rexfx"&&(Ar.innerHTML=fb),Bh=a(Je),Vr=i(Je,"P",{"data-svelte-h":!0}),d(Vr)!=="svelte-1lt01m6"&&(Vr.innerHTML=ub),Rh=a(Je),Wr=i(Je,"P",{"data-svelte-h":!0}),d(Wr)!=="svelte-1ea8edc"&&(Wr.innerHTML=Tb),Dh=a(Je),xt=i(Je,"DIV",{class:!0});var Lo=U(xt);f(Es.$$.fragment,Lo),Nh=a(Lo),Sr=i(Lo,"P",{"data-svelte-h":!0}),d(Sr)!=="svelte-1ws18e1"&&(Sr.textContent=yb),Lo.forEach(l),Je.forEach(l),ld=a(e),f(Qs.$$.fragment,e),cd=a(e),Ge=i(e,"DIV",{class:!0});var Le=U(Ge);f(Xs.$$.fragment,Le),Lh=a(Le),Hr=i(Le,"P",{"data-svelte-h":!0}),d(Hr)!=="svelte-115eloe"&&(Hr.innerHTML=bb),Ah=a(Le),Or=i(Le,"P",{"data-svelte-h":!0}),d(Or)!=="svelte-aleq82"&&(Or.innerHTML=xb),Vh=a(Le),Yr=i(Le,"P",{"data-svelte-h":!0}),d(Yr)!=="svelte-38n9pn"&&(Yr.innerHTML=wb),Wh=a(Le),wt=i(Le,"DIV",{class:!0});var Ao=U(wt);f(Ks.$$.fragment,Ao),Sh=a(Ao),Er=i(Ao,"P",{"data-svelte-h":!0}),d(Er)!=="svelte-1wpkis2"&&(Er.textContent=_b),Ao.forEach(l),Le.forEach(l),pd=a(e),f(ea.$$.fragment,e),dd=a(e),pe=i(e,"DIV",{class:!0});var Pe=U(pe);f(ta.$$.fragment,Pe),Hh=a(Pe),Qr=i(Pe,"P",{"data-svelte-h":!0}),d(Qr)!=="svelte-1lqk35m"&&(Qr.innerHTML=Mb),Oh=a(Pe),f(_t.$$.fragment,Pe),Yh=a(Pe),Xr=i(Pe,"P",{"data-svelte-h":!0}),d(Xr)!=="svelte-13rexfx"&&(Xr.innerHTML=Ub),Eh=a(Pe),Kr=i(Pe,"P",{"data-svelte-h":!0}),d(Kr)!=="svelte-1y4j5o2"&&(Kr.innerHTML=kb),Qh=a(Pe),ei=i(Pe,"P",{"data-svelte-h":!0}),d(ei)!=="svelte-ab0ict"&&(ei.innerHTML=jb),Xh=a(Pe),Mt=i(Pe,"DIV",{class:!0});var Vo=U(Mt);f(na.$$.fragment,Vo),Kh=a(Vo),ti=i(Vo,"P",{"data-svelte-h":!0}),d(ti)!=="svelte-ypfmt8"&&(ti.textContent=vb),Vo.forEach(l),Pe.forEach(l),md=a(e),f(sa.$$.fragment,e),hd=a(e),de=i(e,"DIV",{class:!0});var Ce=U(de);f(aa.$$.fragment,Ce),eg=a(Ce),ni=i(Ce,"P",{"data-svelte-h":!0}),d(ni)!=="svelte-zegbdg"&&(ni.innerHTML=$b),tg=a(Ce),f(Ut.$$.fragment,Ce),ng=a(Ce),si=i(Ce,"P",{"data-svelte-h":!0}),d(si)!=="svelte-13rexfx"&&(si.innerHTML=Jb),sg=a(Ce),ai=i(Ce,"P",{"data-svelte-h":!0}),d(ai)!=="svelte-ui4b6a"&&(ai.innerHTML=Pb),ag=a(Ce),oi=i(Ce,"P",{"data-svelte-h":!0}),d(oi)!=="svelte-1lmpzxi"&&(oi.innerHTML=Cb),og=a(Ce),kt=i(Ce,"DIV",{class:!0});var Wo=U(kt);f(oa.$$.fragment,Wo),rg=a(Wo),ri=i(Wo,"P",{"data-svelte-h":!0}),d(ri)!=="svelte-1ws18e1"&&(ri.textContent=Ib),Wo.forEach(l),Ce.forEach(l),gd=a(e),f(ra.$$.fragment,e),fd=a(e),ia=i(e,"P",{"data-svelte-h":!0}),d(ia)!=="svelte-7gccxi"&&(ia.textContent=qb),ud=a(e),f(la.$$.fragment,e),Td=a(e),R=i(e,"DIV",{class:!0});var ne=U(R);f(ca.$$.fragment,ne),ig=a(ne),ii=i(ne,"P",{"data-svelte-h":!0}),d(ii)!=="svelte-1y2vlya"&&(ii.innerHTML=zb),lg=a(ne),f(jt.$$.fragment,ne),cg=a(ne),li=i(ne,"P",{"data-svelte-h":!0}),d(li)!=="svelte-13rexfx"&&(li.innerHTML=Gb),pg=a(ne),ci=i(ne,"P",{"data-svelte-h":!0}),d(ci)!=="svelte-43vkhe"&&(ci.innerHTML=Zb),dg=a(ne),pi=i(ne,"P",{"data-svelte-h":!0}),d(pi)!=="svelte-6ieg"&&(pi.innerHTML=Fb),mg=a(ne),f(vt.$$.fragment,ne),hg=a(ne),f($t.$$.fragment,ne),gg=a(ne),Jt=i(ne,"DIV",{class:!0});var So=U(Jt);f(pa.$$.fragment,So),fg=a(So),di=i(So,"P",{"data-svelte-h":!0}),d(di)!=="svelte-1dgb1r"&&(di.textContent=Bb),So.forEach(l),ne.forEach(l),yd=a(e),f(da.$$.fragment,e),bd=a(e),Z=i(e,"DIV",{class:!0});var H=U(Z);f(ma.$$.fragment,H),ug=a(H),mi=i(H,"P",{"data-svelte-h":!0}),d(mi)!=="svelte-15adoar"&&(mi.innerHTML=Rb),Tg=a(H),f(Pt.$$.fragment,H),yg=a(H),hi=i(H,"P",{"data-svelte-h":!0}),d(hi)!=="svelte-13rexfx"&&(hi.innerHTML=Db),bg=a(H),gi=i(H,"P",{"data-svelte-h":!0}),d(gi)!=="svelte-23yv8f"&&(gi.innerHTML=Nb),xg=a(H),fi=i(H,"P",{"data-svelte-h":!0}),d(fi)!=="svelte-jwg5m8"&&(fi.innerHTML=Lb),wg=a(H),Ve=i(H,"DIV",{class:!0});var Ee=U(Ve);f(ha.$$.fragment,Ee),_g=a(Ee),ui=i(Ee,"P",{"data-svelte-h":!0}),d(ui)!=="svelte-1qebl0w"&&(ui.textContent=Ab),Mg=a(Ee),Ti=i(Ee,"P",{"data-svelte-h":!0}),d(Ti)!=="svelte-m7pmui"&&(Ti.textContent=Vb),Ee.forEach(l),Ug=a(H),Ct=i(H,"DIV",{class:!0});var Ho=U(Ct);f(ga.$$.fragment,Ho),kg=a(Ho),yi=i(Ho,"P",{"data-svelte-h":!0}),d(yi)!=="svelte-lj4b08"&&(yi.textContent=Wb),Ho.forEach(l),jg=a(H),It=i(H,"DIV",{class:!0});var Oo=U(It);f(fa.$$.fragment,Oo),vg=a(Oo),bi=i(Oo,"P",{"data-svelte-h":!0}),d(bi)!=="svelte-226no6"&&(bi.textContent=Sb),Oo.forEach(l),$g=a(H),qt=i(H,"DIV",{class:!0});var Yo=U(qt);f(ua.$$.fragment,Yo),Jg=a(Yo),xi=i(Yo,"P",{"data-svelte-h":!0}),d(xi)!=="svelte-vx34uc"&&(xi.textContent=Hb),Yo.forEach(l),H.forEach(l),xd=a(e),Ta=i(e,"P",{"data-svelte-h":!0}),d(Ta)!=="svelte-wyz41o"&&(Ta.innerHTML=Ob),wd=a(e),f(ya.$$.fragment,e),_d=a(e),D=i(e,"DIV",{class:!0});var se=U(D);f(ba.$$.fragment,se),Pg=a(se),wi=i(se,"P",{"data-svelte-h":!0}),d(wi)!=="svelte-81lrkw"&&(wi.innerHTML=Yb),Cg=a(se),f(zt.$$.fragment,se),Ig=a(se),_i=i(se,"P",{"data-svelte-h":!0}),d(_i)!=="svelte-13rexfx"&&(_i.innerHTML=Eb),qg=a(se),Mi=i(se,"P",{"data-svelte-h":!0}),d(Mi)!=="svelte-l55jbq"&&(Mi.innerHTML=Qb),zg=a(se),Ui=i(se,"P",{"data-svelte-h":!0}),d(Ui)!=="svelte-13vdwbu"&&(Ui.innerHTML=Xb),Gg=a(se),Gt=i(se,"DIV",{class:!0});var Eo=U(Gt);f(xa.$$.fragment,Eo),Zg=a(Eo),ki=i(Eo,"P",{"data-svelte-h":!0}),d(ki)!=="svelte-2lj46g"&&(ki.textContent=Kb),Eo.forEach(l),Fg=a(se),We=i(se,"DIV",{class:!0});var Qe=U(We);f(wa.$$.fragment,Qe),Bg=a(Qe),ji=i(Qe,"P",{"data-svelte-h":!0}),d(ji)!=="svelte-1iglp3e"&&(ji.innerHTML=ex),Rg=a(Qe),vi=i(Qe,"P",{"data-svelte-h":!0}),d(vi)!=="svelte-tiqx9u"&&(vi.textContent=tx),Qe.forEach(l),Dg=a(se),Zt=i(se,"DIV",{class:!0});var Qo=U(Zt);f(_a.$$.fragment,Qo),Ng=a(Qo),$i=i(Qo,"P",{"data-svelte-h":!0}),d($i)!=="svelte-d6foro"&&($i.textContent=nx),Qo.forEach(l),se.forEach(l),Md=a(e),f(Ma.$$.fragment,e),Ud=a(e),X=i(e,"DIV",{class:!0});var fe=U(X);f(Ua.$$.fragment,fe),Lg=a(fe),Ji=i(fe,"P",{"data-svelte-h":!0}),d(Ji)!=="svelte-4fy8a0"&&(Ji.textContent=sx),Ag=a(fe),Pi=i(fe,"P",{"data-svelte-h":!0}),d(Pi)!=="svelte-1kohns0"&&(Pi.innerHTML=ax),Vg=a(fe),Ci=i(fe,"P",{"data-svelte-h":!0}),d(Ci)!=="svelte-1rau5o"&&(Ci.innerHTML=ox),Wg=a(fe),Ii=i(fe,"P",{"data-svelte-h":!0}),d(Ii)!=="svelte-42qofm"&&(Ii.innerHTML=rx),Sg=a(fe),qi=i(fe,"UL",{"data-svelte-h":!0}),d(qi)!=="svelte-gry39y"&&(qi.innerHTML=ix),Hg=a(fe),f(Ft.$$.fragment,fe),Og=a(fe),Bt=i(fe,"DIV",{class:!0});var Xo=U(Bt);f(ka.$$.fragment,Xo),Yg=a(Xo),zi=i(Xo,"P",{"data-svelte-h":!0}),d(zi)!=="svelte-myfdp"&&(zi.textContent=lx),Xo.forEach(l),fe.forEach(l),kd=a(e),f(ja.$$.fragment,e),jd=a(e),N=i(e,"DIV",{class:!0});var ae=U(N);f(va.$$.fragment,ae),Eg=a(ae),Gi=i(ae,"P",{"data-svelte-h":!0}),d(Gi)!=="svelte-1j45sfj"&&(Gi.innerHTML=cx),Qg=a(ae),Zi=i(ae,"P",{"data-svelte-h":!0}),d(Zi)!=="svelte-42qofm"&&(Zi.innerHTML=px),Xg=a(ae),Fi=i(ae,"UL",{"data-svelte-h":!0}),d(Fi)!=="svelte-pmfbv0"&&(Fi.innerHTML=dx),Kg=a(ae),f(Rt.$$.fragment,ae),ef=a(ae),Bi=i(ae,"P",{"data-svelte-h":!0}),d(Bi)!=="svelte-13rexfx"&&(Bi.innerHTML=mx),tf=a(ae),Ri=i(ae,"P",{"data-svelte-h":!0}),d(Ri)!=="svelte-jh85pk"&&(Ri.innerHTML=hx),nf=a(ae),Di=i(ae,"P",{"data-svelte-h":!0}),d(Di)!=="svelte-1jig9aq"&&(Di.innerHTML=gx),sf=a(ae),Te=i(ae,"DIV",{class:!0});var Ie=U(Te);f($a.$$.fragment,Ie),af=a(Ie),Ni=i(Ie,"P",{"data-svelte-h":!0}),d(Ni)!=="svelte-1pyysfu"&&(Ni.textContent=fx),of=a(Ie),Li=i(Ie,"UL",{"data-svelte-h":!0}),d(Li)!=="svelte-1ny9a5f"&&(Li.innerHTML=ux),rf=a(Ie),Ai=i(Ie,"P",{"data-svelte-h":!0}),d(Ai)!=="svelte-11u3uey"&&(Ai.innerHTML=Tx),lf=a(Ie),f(Dt.$$.fragment,Ie),cf=a(Ie),Vi=i(Ie,"P",{"data-svelte-h":!0}),d(Vi)!=="svelte-madj2v"&&(Vi.textContent=yx),pf=a(Ie),f(Nt.$$.fragment,Ie),Ie.forEach(l),ae.forEach(l),vd=a(e),f(Ja.$$.fragment,e),$d=a(e),K=i(e,"DIV",{class:!0});var ue=U(K);f(Pa.$$.fragment,ue),df=a(ue),Wi=i(ue,"P",{"data-svelte-h":!0}),d(Wi)!=="svelte-n7evf0"&&(Wi.innerHTML=bx),mf=a(ue),f(Lt.$$.fragment,ue),hf=a(ue),Si=i(ue,"P",{"data-svelte-h":!0}),d(Si)!=="svelte-13rexfx"&&(Si.innerHTML=xx),gf=a(ue),Hi=i(ue,"P",{"data-svelte-h":!0}),d(Hi)!=="svelte-12gmkto"&&(Hi.innerHTML=wx),ff=a(ue),Oi=i(ue,"P",{"data-svelte-h":!0}),d(Oi)!=="svelte-mvgqwz"&&(Oi.innerHTML=_x),uf=a(ue),Yi=i(ue,"P",{"data-svelte-h":!0}),d(Yi)!=="svelte-1qrdw9i"&&(Yi.innerHTML=Mx),Tf=a(ue),At=i(ue,"DIV",{class:!0});var Ko=U(At);f(Ca.$$.fragment,Ko),yf=a(Ko),Ei=i(Ko,"P",{"data-svelte-h":!0}),d(Ei)!=="svelte-14zfmze"&&(Ei.textContent=Ux),Ko.forEach(l),ue.forEach(l),Jd=a(e),f(Ia.$$.fragment,e),Pd=a(e),F=i(e,"DIV",{class:!0});var O=U(F);f(qa.$$.fragment,O),bf=a(O),Qi=i(O,"P",{"data-svelte-h":!0}),d(Qi)!=="svelte-1y4vmr9"&&(Qi.innerHTML=kx),xf=a(O),Xi=i(O,"P",{"data-svelte-h":!0}),d(Xi)!=="svelte-42qofm"&&(Xi.innerHTML=jx),wf=a(O),Ki=i(O,"UL",{"data-svelte-h":!0}),d(Ki)!=="svelte-lffs7r"&&(Ki.innerHTML=vx),_f=a(O),f(Vt.$$.fragment,O),Mf=a(O),f(Wt.$$.fragment,O),Uf=a(O),el=i(O,"P",{"data-svelte-h":!0}),d(el)!=="svelte-26qptp"&&(el.innerHTML=$x),kf=a(O),tl=i(O,"P",{"data-svelte-h":!0}),d(tl)!=="svelte-19r9gm7"&&(tl.innerHTML=Jx),jf=a(O),nl=i(O,"P",{"data-svelte-h":!0}),d(nl)!=="svelte-1j73hay"&&(nl.innerHTML=Px),vf=a(O),St=i(O,"DIV",{class:!0});var rm=U(St);f(za.$$.fragment,rm),$f=a(rm),sl=i(rm,"P",{"data-svelte-h":!0}),d(sl)!=="svelte-1ql86ls"&&(sl.textContent=Cx),rm.forEach(l),O.forEach(l),Cd=a(e),f(Ga.$$.fragment,e),Id=a(e),q=i(e,"DIV",{class:!0});var Y=U(q);f(Za.$$.fragment,Y),Jf=a(Y),al=i(Y,"P",{"data-svelte-h":!0}),d(al)!=="svelte-xbi6mw"&&(al.textContent=Ix),Pf=a(Y),ol=i(Y,"P",{"data-svelte-h":!0}),d(ol)!=="svelte-42qofm"&&(ol.innerHTML=qx),Cf=a(Y),rl=i(Y,"UL",{"data-svelte-h":!0}),d(rl)!=="svelte-gry39y"&&(rl.innerHTML=zx),If=a(Y),f(Ht.$$.fragment,Y),qf=a(Y),il=i(Y,"P",{"data-svelte-h":!0}),d(il)!=="svelte-26qptp"&&(il.innerHTML=Gx),zf=a(Y),ll=i(Y,"P",{"data-svelte-h":!0}),d(ll)!=="svelte-ay50l6"&&(ll.innerHTML=Zx),Gf=a(Y),cl=i(Y,"P",{"data-svelte-h":!0}),d(cl)!=="svelte-1iyxmj8"&&(cl.innerHTML=Fx),Zf=a(Y),f(Ot.$$.fragment,Y),Ff=a(Y),Yt=i(Y,"DIV",{class:!0});var im=U(Yt);f(Fa.$$.fragment,im),Bf=a(im),pl=i(im,"P",{"data-svelte-h":!0}),d(pl)!=="svelte-48qsnz"&&(pl.textContent=Bx),im.forEach(l),Rf=a(Y),Et=i(Y,"DIV",{class:!0});var lm=U(Et);f(Ba.$$.fragment,lm),Df=a(lm),dl=i(lm,"P",{"data-svelte-h":!0}),d(dl)!=="svelte-uzfqtg"&&(dl.textContent=Rx),lm.forEach(l),Y.forEach(l),qd=a(e),f(Ra.$$.fragment,e),zd=a(e),z=i(e,"DIV",{class:!0});var E=U(z);f(Da.$$.fragment,E),Nf=a(E),ml=i(E,"P",{"data-svelte-h":!0}),d(ml)!=="svelte-15adoar"&&(ml.innerHTML=Dx),Lf=a(E),f(Qt.$$.fragment,E),Af=a(E),hl=i(E,"P",{"data-svelte-h":!0}),d(hl)!=="svelte-13rexfx"&&(hl.innerHTML=Nx),Vf=a(E),gl=i(E,"P",{"data-svelte-h":!0}),d(gl)!=="svelte-23yv8f"&&(gl.innerHTML=Lx),Wf=a(E),fl=i(E,"P",{"data-svelte-h":!0}),d(fl)!=="svelte-jwg5m8"&&(fl.innerHTML=Ax),Sf=a(E),Xt=i(E,"DIV",{class:!0});var cm=U(Xt);f(Na.$$.fragment,cm),Hf=a(cm),ul=i(cm,"P",{"data-svelte-h":!0}),d(ul)!=="svelte-1fmsbp5"&&(ul.textContent=Vx),cm.forEach(l),Of=a(E),Se=i(E,"DIV",{class:!0});var Lc=U(Se);f(La.$$.fragment,Lc),Yf=a(Lc),Tl=i(Lc,"P",{"data-svelte-h":!0}),d(Tl)!=="svelte-1qebl0w"&&(Tl.textContent=Wx),Ef=a(Lc),yl=i(Lc,"P",{"data-svelte-h":!0}),d(yl)!=="svelte-m7pmui"&&(yl.textContent=Sx),Lc.forEach(l),Qf=a(E),Kt=i(E,"DIV",{class:!0});var pm=U(Kt);f(Aa.$$.fragment,pm),Xf=a(pm),bl=i(pm,"P",{"data-svelte-h":!0}),d(bl)!=="svelte-lj4b08"&&(bl.textContent=Hx),pm.forEach(l),Kf=a(E),en=i(E,"DIV",{class:!0});var dm=U(en);f(Va.$$.fragment,dm),eu=a(dm),xl=i(dm,"P",{"data-svelte-h":!0}),d(xl)!=="svelte-226no6"&&(xl.textContent=Ox),dm.forEach(l),tu=a(E),tn=i(E,"DIV",{class:!0});var mm=U(tn);f(Wa.$$.fragment,mm),nu=a(mm),wl=i(mm,"P",{"data-svelte-h":!0}),d(wl)!=="svelte-vx34uc"&&(wl.textContent=Yx),mm.forEach(l),E.forEach(l),Gd=a(e),f(Sa.$$.fragment,e),Zd=a(e),ee=i(e,"DIV",{class:!0});var qe=U(ee);f(Ha.$$.fragment,qe),su=a(qe),_l=i(qe,"P",{"data-svelte-h":!0}),d(_l)!=="svelte-1ufl6u7"&&(_l.textContent=Ex),au=a(qe),Ml=i(qe,"P",{"data-svelte-h":!0}),d(Ml)!=="svelte-1yahkzd"&&(Ml.innerHTML=Qx),ou=a(qe),Ul=i(qe,"P",{"data-svelte-h":!0}),d(Ul)!=="svelte-175zgvy"&&(Ul.innerHTML=Xx),ru=a(qe),kl=i(qe,"P",{"data-svelte-h":!0}),d(kl)!=="svelte-42qofm"&&(kl.innerHTML=Kx),iu=a(qe),jl=i(qe,"UL",{"data-svelte-h":!0}),d(jl)!=="svelte-gry39y"&&(jl.innerHTML=ew),lu=a(qe),f(nn.$$.fragment,qe),cu=a(qe),sn=i(qe,"DIV",{class:!0});var hm=U(sn);f(Oa.$$.fragment,hm),pu=a(hm),vl=i(hm,"P",{"data-svelte-h":!0}),d(vl)!=="svelte-1q7dj96"&&(vl.textContent=tw),hm.forEach(l),qe.forEach(l),Fd=a(e),f(Ya.$$.fragment,e),Bd=a(e),te=i(e,"DIV",{class:!0});var ze=U(te);f(Ea.$$.fragment,ze),du=a(ze),$l=i(ze,"P",{"data-svelte-h":!0}),d($l)!=="svelte-gusdnf"&&($l.innerHTML=nw),mu=a(ze),Jl=i(ze,"P",{"data-svelte-h":!0}),d(Jl)!=="svelte-1hjzyz9"&&(Jl.innerHTML=sw),hu=a(ze),f(an.$$.fragment,ze),gu=a(ze),Pl=i(ze,"P",{"data-svelte-h":!0}),d(Pl)!=="svelte-13rexfx"&&(Pl.innerHTML=aw),fu=a(ze),Cl=i(ze,"P",{"data-svelte-h":!0}),d(Cl)!=="svelte-pcfr04"&&(Cl.innerHTML=ow),uu=a(ze),Il=i(ze,"P",{"data-svelte-h":!0}),d(Il)!=="svelte-17eq97f"&&(Il.innerHTML=rw),Tu=a(ze),on=i(ze,"DIV",{class:!0});var gm=U(on);f(Qa.$$.fragment,gm),yu=a(gm),ql=i(gm,"P",{"data-svelte-h":!0}),d(ql)!=="svelte-aysmv3"&&(ql.innerHTML=iw),gm.forEach(l),ze.forEach(l),Rd=a(e),f(Xa.$$.fragment,e),Dd=a(e),Ka=i(e,"P",{"data-svelte-h":!0}),d(Ka)!=="svelte-11o5ko1"&&(Ka.textContent=lw),Nd=a(e),f(eo.$$.fragment,e),Ld=a(e),L=i(e,"DIV",{class:!0});var ye=U(L);f(to.$$.fragment,ye),bu=a(ye),zl=i(ye,"P",{"data-svelte-h":!0}),d(zl)!=="svelte-40flx9"&&(zl.innerHTML=cw),xu=a(ye),Gl=i(ye,"P",{"data-svelte-h":!0}),d(Gl)!=="svelte-42qofm"&&(Gl.innerHTML=pw),wu=a(ye),Zl=i(ye,"UL",{"data-svelte-h":!0}),d(Zl)!=="svelte-pmfbv0"&&(Zl.innerHTML=dw),_u=a(ye),f(rn.$$.fragment,ye),Mu=a(ye),Fl=i(ye,"P",{"data-svelte-h":!0}),d(Fl)!=="svelte-13rexfx"&&(Fl.innerHTML=mw),Uu=a(ye),Bl=i(ye,"P",{"data-svelte-h":!0}),d(Bl)!=="svelte-1pdfyj9"&&(Bl.innerHTML=hw),ku=a(ye),Rl=i(ye,"P",{"data-svelte-h":!0}),d(Rl)!=="svelte-1akhzjj"&&(Rl.innerHTML=gw),ju=a(ye),Ae=i(ye,"DIV",{class:!0});var Jn=U(Ae);f(no.$$.fragment,Jn),vu=a(Jn),Dl=i(Jn,"P",{"data-svelte-h":!0}),d(Dl)!=="svelte-1211nrg"&&(Dl.innerHTML=fw),$u=a(Jn),Nl=i(Jn,"P",{"data-svelte-h":!0}),d(Nl)!=="svelte-1njhmhw"&&(Nl.textContent=uw),Ju=a(Jn),Ll=i(Jn,"UL",{"data-svelte-h":!0}),d(Ll)!=="svelte-gfpbs1"&&(Ll.innerHTML=Tw),Jn.forEach(l),ye.forEach(l),Ad=a(e),f(so.$$.fragment,e),Vd=a(e),me=i(e,"DIV",{class:!0});var De=U(me);f(ao.$$.fragment,De),Pu=a(De),Al=i(De,"P",{"data-svelte-h":!0}),d(Al)!=="svelte-2bxem6"&&(Al.textContent=yw),Cu=a(De),f(ln.$$.fragment,De),Iu=a(De),Vl=i(De,"P",{"data-svelte-h":!0}),d(Vl)!=="svelte-13rexfx"&&(Vl.innerHTML=bw),qu=a(De),Wl=i(De,"P",{"data-svelte-h":!0}),d(Wl)!=="svelte-1xa8um5"&&(Wl.innerHTML=xw),zu=a(De),Sl=i(De,"P",{"data-svelte-h":!0}),d(Sl)!=="svelte-85c9z6"&&(Sl.innerHTML=ww),Gu=a(De),cn=i(De,"DIV",{class:!0});var fm=U(cn);f(oo.$$.fragment,fm),Zu=a(fm),Hl=i(fm,"P",{"data-svelte-h":!0}),d(Hl)!=="svelte-11eoigb"&&(Hl.textContent=_w),fm.forEach(l),De.forEach(l),Wd=a(e),f(ro.$$.fragment,e),Sd=a(e),he=i(e,"DIV",{class:!0});var Ne=U(he);f(io.$$.fragment,Ne),Fu=a(Ne),Ol=i(Ne,"P",{"data-svelte-h":!0}),d(Ol)!=="svelte-1cp7rf7"&&(Ol.textContent=Mw),Bu=a(Ne),f(pn.$$.fragment,Ne),Ru=a(Ne),Yl=i(Ne,"P",{"data-svelte-h":!0}),d(Yl)!=="svelte-13rexfx"&&(Yl.innerHTML=Uw),Du=a(Ne),El=i(Ne,"P",{"data-svelte-h":!0}),d(El)!=="svelte-1j5q1la"&&(El.innerHTML=kw),Nu=a(Ne),Ql=i(Ne,"P",{"data-svelte-h":!0}),d(Ql)!=="svelte-19r0ftw"&&(Ql.innerHTML=jw),Lu=a(Ne),dn=i(Ne,"DIV",{class:!0});var um=U(dn);f(lo.$$.fragment,um),Au=a(um),Xl=i(um,"P",{"data-svelte-h":!0}),d(Xl)!=="svelte-11eoigb"&&(Xl.textContent=vw),um.forEach(l),Ne.forEach(l),Hd=a(e),f(co.$$.fragment,e),Od=a(e),A=i(e,"DIV",{class:!0});var be=U(A);f(po.$$.fragment,be),Vu=a(be),Kl=i(be,"P",{"data-svelte-h":!0}),d(Kl)!=="svelte-yuzbfo"&&(Kl.innerHTML=$w),Wu=a(be),ec=i(be,"P",{"data-svelte-h":!0}),d(ec)!=="svelte-42qofm"&&(ec.innerHTML=Jw),Su=a(be),tc=i(be,"UL",{"data-svelte-h":!0}),d(tc)!=="svelte-pmfbv0"&&(tc.innerHTML=Pw),Hu=a(be),f(mn.$$.fragment,be),Ou=a(be),nc=i(be,"P",{"data-svelte-h":!0}),d(nc)!=="svelte-13rexfx"&&(nc.innerHTML=Cw),Yu=a(be),sc=i(be,"P",{"data-svelte-h":!0}),d(sc)!=="svelte-172bsdq"&&(sc.textContent=Iw),Eu=a(be),ac=i(be,"P",{"data-svelte-h":!0}),d(ac)!=="svelte-6aba0z"&&(ac.innerHTML=qw),Qu=a(be),hn=i(be,"DIV",{class:!0});var Tm=U(hn);f(mo.$$.fragment,Tm),Xu=a(Tm),oc=i(Tm,"P",{"data-svelte-h":!0}),d(oc)!=="svelte-ypfmt8"&&(oc.textContent=zw),Tm.forEach(l),be.forEach(l),Yd=a(e),f(ho.$$.fragment,e),Ed=a(e),B=i(e,"DIV",{class:!0});var oe=U(B);f(go.$$.fragment,oe),Ku=a(oe),rc=i(oe,"P",{"data-svelte-h":!0}),d(rc)!=="svelte-138vhyq"&&(rc.innerHTML=Gw),eT=a(oe),ic=i(oe,"P",{"data-svelte-h":!0}),d(ic)!=="svelte-42qofm"&&(ic.innerHTML=Zw),tT=a(oe),lc=i(oe,"UL",{"data-svelte-h":!0}),d(lc)!=="svelte-pmfbv0"&&(lc.innerHTML=Fw),nT=a(oe),f(gn.$$.fragment,oe),sT=a(oe),f(fn.$$.fragment,oe),aT=a(oe),cc=i(oe,"P",{"data-svelte-h":!0}),d(cc)!=="svelte-13rexfx"&&(cc.innerHTML=Bw),oT=a(oe),pc=i(oe,"P",{"data-svelte-h":!0}),d(pc)!=="svelte-96qbn6"&&(pc.textContent=Rw),rT=a(oe),dc=i(oe,"P",{"data-svelte-h":!0}),d(dc)!=="svelte-185vjex"&&(dc.innerHTML=Dw),iT=a(oe),un=i(oe,"DIV",{class:!0});var ym=U(un);f(fo.$$.fragment,ym),lT=a(ym),mc=i(ym,"P",{"data-svelte-h":!0}),d(mc)!=="svelte-1nkqfj7"&&(mc.textContent=Nw),ym.forEach(l),oe.forEach(l),Qd=a(e),f(uo.$$.fragment,e),Xd=a(e),V=i(e,"DIV",{class:!0});var xe=U(V);f(To.$$.fragment,xe),cT=a(xe),hc=i(xe,"P",{"data-svelte-h":!0}),d(hc)!=="svelte-17owywk"&&(hc.innerHTML=Lw),pT=a(xe),gc=i(xe,"P",{"data-svelte-h":!0}),d(gc)!=="svelte-1fqmqrc"&&(gc.textContent=Aw),dT=a(xe),fc=i(xe,"OL",{"data-svelte-h":!0}),d(fc)!=="svelte-jptyar"&&(fc.innerHTML=Vw),mT=a(xe),f(Tn.$$.fragment,xe),hT=a(xe),uc=i(xe,"P",{"data-svelte-h":!0}),d(uc)!=="svelte-13rexfx"&&(uc.innerHTML=Ww),gT=a(xe),Tc=i(xe,"P",{"data-svelte-h":!0}),d(Tc)!=="svelte-10cv952"&&(Tc.innerHTML=Sw),fT=a(xe),yc=i(xe,"P",{"data-svelte-h":!0}),d(yc)!=="svelte-1oqqq9o"&&(yc.innerHTML=Hw),uT=a(xe),yn=i(xe,"DIV",{class:!0});var bm=U(yn);f(yo.$$.fragment,bm),TT=a(bm),bc=i(bm,"P",{"data-svelte-h":!0}),d(bc)!=="svelte-qnrg8s"&&(bc.textContent=Ow),bm.forEach(l),xe.forEach(l),Kd=a(e),f(bo.$$.fragment,e),em=a(e),W=i(e,"DIV",{class:!0});var we=U(W);f(xo.$$.fragment,we),yT=a(we),xc=i(we,"P",{"data-svelte-h":!0}),d(xc)!=="svelte-1lg1j1m"&&(xc.innerHTML=Yw),bT=a(we),wc=i(we,"P",{"data-svelte-h":!0}),d(wc)!=="svelte-42qofm"&&(wc.innerHTML=Ew),xT=a(we),_c=i(we,"UL",{"data-svelte-h":!0}),d(_c)!=="svelte-pmfbv0"&&(_c.innerHTML=Qw),wT=a(we),f(bn.$$.fragment,we),_T=a(we),Mc=i(we,"P",{"data-svelte-h":!0}),d(Mc)!=="svelte-13rexfx"&&(Mc.innerHTML=Xw),MT=a(we),Uc=i(we,"P",{"data-svelte-h":!0}),d(Uc)!=="svelte-atse4y"&&(Uc.innerHTML=Kw),UT=a(we),kc=i(we,"P",{"data-svelte-h":!0}),d(kc)!=="svelte-lcegcp"&&(kc.innerHTML=e_),kT=a(we),He=i(we,"DIV",{class:!0});var Ac=U(He);f(wo.$$.fragment,Ac),jT=a(Ac),jc=i(Ac,"P",{"data-svelte-h":!0}),d(jc)!=="svelte-10yp62t"&&(jc.textContent=t_),vT=a(Ac),vc=i(Ac,"UL",{"data-svelte-h":!0}),d(vc)!=="svelte-15cnno4"&&(vc.innerHTML=n_),Ac.forEach(l),we.forEach(l),tm=a(e),f(_o.$$.fragment,e),nm=a(e),C=i(e,"DIV",{class:!0});var I=U(C);f(Mo.$$.fragment,I),$T=a(I),$c=i(I,"P",{"data-svelte-h":!0}),d($c)!=="svelte-k7p6k2"&&($c.textContent=s_),JT=a(I),Jc=i(I,"P",{"data-svelte-h":!0}),d(Jc)!=="svelte-3qu5a5"&&(Jc.textContent=a_),PT=a(I),Pc=i(I,"P",{"data-svelte-h":!0}),d(Pc)!=="svelte-1mj6jcv"&&(Pc.textContent=o_),CT=a(I),Cc=i(I,"P",{"data-svelte-h":!0}),d(Cc)!=="svelte-pcl79b"&&(Cc.textContent=r_),IT=a(I),Ic=i(I,"P",{"data-svelte-h":!0}),d(Ic)!=="svelte-ofyuvf"&&(Ic.innerHTML=i_),qT=a(I),xn=i(I,"DIV",{class:!0});var xm=U(xn);f(Uo.$$.fragment,xm),zT=a(xm),qc=i(xm,"P",{"data-svelte-h":!0}),d(qc)!=="svelte-exnhmi"&&(qc.textContent=l_),xm.forEach(l),GT=a(I),Oe=i(I,"DIV",{class:!0});var Vc=U(Oe);f(ko.$$.fragment,Vc),ZT=a(Vc),zc=i(Vc,"P",{"data-svelte-h":!0}),d(zc)!=="svelte-1piccye"&&(zc.textContent=c_),FT=a(Vc),f(wn.$$.fragment,Vc),Vc.forEach(l),BT=a(I),_n=i(I,"DIV",{class:!0});var wm=U(_n);f(jo.$$.fragment,wm),RT=a(wm),Gc=i(wm,"P",{"data-svelte-h":!0}),d(Gc)!=="svelte-p1t4ev"&&(Gc.textContent=p_),wm.forEach(l),DT=a(I),Mn=i(I,"DIV",{class:!0});var _m=U(Mn);f(vo.$$.fragment,_m),NT=a(_m),Zc=i(_m,"P",{"data-svelte-h":!0}),d(Zc)!=="svelte-2wm42a"&&(Zc.innerHTML=d_),_m.forEach(l),LT=a(I),Un=i(I,"DIV",{class:!0});var Mm=U(Un);f($o.$$.fragment,Mm),AT=a(Mm),Fc=i(Mm,"P",{"data-svelte-h":!0}),d(Fc)!=="svelte-10cd17f"&&(Fc.innerHTML=m_),Mm.forEach(l),VT=a(I),kn=i(I,"DIV",{class:!0});var Um=U(kn);f(Jo.$$.fragment,Um),WT=a(Um),Bc=i(Um,"P",{"data-svelte-h":!0}),d(Bc)!=="svelte-12sv4vl"&&(Bc.innerHTML=h_),Um.forEach(l),ST=a(I),Ye=i(I,"DIV",{class:!0});var Wc=U(Ye);f(Po.$$.fragment,Wc),HT=a(Wc),Rc=i(Wc,"P",{"data-svelte-h":!0}),d(Rc)!=="svelte-15f1ri9"&&(Rc.textContent=g_),OT=a(Wc),f(jn.$$.fragment,Wc),Wc.forEach(l),YT=a(I),vn=i(I,"DIV",{class:!0});var km=U(vn);f(Co.$$.fragment,km),ET=a(km),Dc=i(km,"P",{"data-svelte-h":!0}),d(Dc)!=="svelte-kp2v8j"&&(Dc.textContent=f_),km.forEach(l),QT=a(I),$n=i(I,"DIV",{class:!0});var jm=U($n);f(Io.$$.fragment,jm),XT=a(jm),Nc=i(jm,"P",{"data-svelte-h":!0}),d(Nc)!=="svelte-10cd17f"&&(Nc.innerHTML=u_),jm.forEach(l),I.forEach(l),sm=a(e),f(qo.$$.fragment,e),am=a(e),Oc=i(e,"P",{}),U(Oc).forEach(l),this.h()},h(){k(o,"name","hf:doc:metadata"),k(o,"content",TM),k(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(It,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(qt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(At,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(St,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(en,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(on,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(yn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(xn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(_n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(kn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(vn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k($n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){n(document.head,o),m(e,_,c),m(e,h,c),m(e,p,c),u(x,e,c),m(e,t,c),m(e,w,c),m(e,Yc,c),m(e,Pn,c),m(e,Ec,c),m(e,Cn,c),m(e,Qc,c),u(In,e,c),m(e,Xc,c),m(e,qn,c),m(e,Kc,c),m(e,zn,c),m(e,ep,c),u(Gn,e,c),m(e,tp,c),m(e,Zn,c),m(e,np,c),u(Fn,e,c),m(e,sp,c),m(e,Bn,c),m(e,ap,c),u(Rn,e,c),m(e,op,c),m(e,Dn,c),m(e,rp,c),u(Nn,e,c),m(e,ip,c),m(e,Ln,c),m(e,lp,c),u(An,e,c),m(e,cp,c),m(e,_e,c),u(Vn,_e,null),n(_e,vm),n(_e,er),n(_e,$m),n(_e,tr),n(_e,Jm),n(_e,nr),n(_e,Pm),u(Xe,_e,null),n(_e,Cm),u(Ke,_e,null),m(e,pp,c),u(Wn,e,c),m(e,dp,c),m(e,Sn,c),m(e,mp,c),u(Hn,e,c),m(e,hp,c),u(et,e,c),m(e,gp,c),u(On,e,c),m(e,fp,c),u(Yn,e,c),m(e,up,c),m(e,En,c),m(e,Tp,c),u(Qn,e,c),m(e,yp,c),m(e,Xn,c),m(e,bp,c),u(Kn,e,c),m(e,xp,c),m(e,es,c),m(e,wp,c),m(e,ts,c),m(e,_p,c),m(e,ns,c),m(e,Mp,c),u(ss,e,c),m(e,Up,c),m(e,as,c),m(e,kp,c),m(e,os,c),m(e,jp,c),u(rs,e,c),m(e,vp,c),m(e,is,c),m(e,$p,c),u(ls,e,c),m(e,Jp,c),m(e,cs,c),m(e,Pp,c),m(e,ps,c),m(e,Cp,c),u(ds,e,c),m(e,Ip,c),m(e,ms,c),m(e,qp,c),m(e,hs,c),m(e,zp,c),m(e,gs,c),m(e,Gp,c),m(e,fs,c),m(e,Zp,c),u(us,e,c),m(e,Fp,c),m(e,Ts,c),m(e,Bp,c),u(ys,e,c),m(e,Rp,c),m(e,bs,c),m(e,Dp,c),u(xs,e,c),m(e,Np,c),m(e,ws,c),m(e,Lp,c),u(_s,e,c),m(e,Ap,c),m(e,re,c),u(Ms,re,null),n(re,Im),n(re,sr),n(re,qm),u(tt,re,null),n(re,zm),n(re,ar),n(re,Gm),n(re,or),n(re,Zm),n(re,rr),n(re,Fm),n(re,nt),u(Us,nt,null),n(nt,Bm),n(nt,ir),m(e,Vp,c),u(ks,e,c),m(e,Wp,c),m(e,Q,c),u(js,Q,null),n(Q,Rm),n(Q,lr),n(Q,Dm),n(Q,cr),n(Q,Nm),n(Q,pr),n(Q,Lm),n(Q,dr),n(Q,Am),u(st,Q,null),n(Q,Vm),n(Q,mr),n(Q,Wm),n(Q,at),u(vs,at,null),n(at,Sm),n(at,hr),m(e,Sp,c),u($s,e,c),m(e,Hp,c),m(e,G,c),u(Js,G,null),n(G,Hm),n(G,gr),n(G,Om),n(G,fr),n(G,Ym),n(G,ur),n(G,Em),u(ot,G,null),n(G,Qm),n(G,Tr),n(G,Xm),u(rt,G,null),n(G,Km),n(G,yr),n(G,eh),n(G,br),n(G,th),n(G,it),u(Ps,it,null),n(it,nh),n(it,xr),m(e,Op,c),u(Cs,e,c),m(e,Yp,c),m(e,Me,c),u(Is,Me,null),n(Me,sh),n(Me,wr),n(Me,ah),u(lt,Me,null),n(Me,oh),u(ct,Me,null),n(Me,rh),n(Me,_r),n(Me,ih),n(Me,pt),u(qs,pt,null),n(pt,lh),n(pt,Mr),m(e,Ep,c),u(zs,e,c),m(e,Qp,c),m(e,Gs,c),m(e,Xp,c),u(Zs,e,c),m(e,Kp,c),m(e,ie,c),u(Fs,ie,null),n(ie,ch),n(ie,Ur),n(ie,ph),u(dt,ie,null),n(ie,dh),n(ie,kr),n(ie,mh),n(ie,jr),n(ie,hh),n(ie,vr),n(ie,gh),n(ie,mt),u(Bs,mt,null),n(mt,fh),n(mt,$r),m(e,ed,c),u(Rs,e,c),m(e,td,c),m(e,le,c),u(Ds,le,null),n(le,uh),n(le,Jr),n(le,Th),u(ht,le,null),n(le,yh),n(le,Pr),n(le,bh),n(le,Cr),n(le,xh),n(le,Ir),n(le,wh),n(le,gt),u(Ns,gt,null),n(gt,_h),n(gt,qr),m(e,nd,c),u(Ls,e,c),m(e,sd,c),m(e,Ue,c),u(As,Ue,null),n(Ue,Mh),n(Ue,zr),n(Ue,Uh),u(ft,Ue,null),n(Ue,kh),n(Ue,Gr),n(Ue,jh),n(Ue,Zr),n(Ue,vh),n(Ue,ut),u(Vs,ut,null),n(ut,$h),n(ut,Fr),m(e,ad,c),u(Ws,e,c),m(e,od,c),m(e,ke,c),u(Ss,ke,null),n(ke,Jh),n(ke,Br),n(ke,Ph),u(Tt,ke,null),n(ke,Ch),n(ke,Rr),n(ke,Ih),n(ke,Dr),n(ke,qh),n(ke,yt),u(Hs,yt,null),n(yt,zh),n(yt,Nr),m(e,rd,c),u(Os,e,c),m(e,id,c),m(e,ce,c),u(Ys,ce,null),n(ce,Gh),n(ce,Lr),n(ce,Zh),u(bt,ce,null),n(ce,Fh),n(ce,Ar),n(ce,Bh),n(ce,Vr),n(ce,Rh),n(ce,Wr),n(ce,Dh),n(ce,xt),u(Es,xt,null),n(xt,Nh),n(xt,Sr),m(e,ld,c),u(Qs,e,c),m(e,cd,c),m(e,Ge,c),u(Xs,Ge,null),n(Ge,Lh),n(Ge,Hr),n(Ge,Ah),n(Ge,Or),n(Ge,Vh),n(Ge,Yr),n(Ge,Wh),n(Ge,wt),u(Ks,wt,null),n(wt,Sh),n(wt,Er),m(e,pd,c),u(ea,e,c),m(e,dd,c),m(e,pe,c),u(ta,pe,null),n(pe,Hh),n(pe,Qr),n(pe,Oh),u(_t,pe,null),n(pe,Yh),n(pe,Xr),n(pe,Eh),n(pe,Kr),n(pe,Qh),n(pe,ei),n(pe,Xh),n(pe,Mt),u(na,Mt,null),n(Mt,Kh),n(Mt,ti),m(e,md,c),u(sa,e,c),m(e,hd,c),m(e,de,c),u(aa,de,null),n(de,eg),n(de,ni),n(de,tg),u(Ut,de,null),n(de,ng),n(de,si),n(de,sg),n(de,ai),n(de,ag),n(de,oi),n(de,og),n(de,kt),u(oa,kt,null),n(kt,rg),n(kt,ri),m(e,gd,c),u(ra,e,c),m(e,fd,c),m(e,ia,c),m(e,ud,c),u(la,e,c),m(e,Td,c),m(e,R,c),u(ca,R,null),n(R,ig),n(R,ii),n(R,lg),u(jt,R,null),n(R,cg),n(R,li),n(R,pg),n(R,ci),n(R,dg),n(R,pi),n(R,mg),u(vt,R,null),n(R,hg),u($t,R,null),n(R,gg),n(R,Jt),u(pa,Jt,null),n(Jt,fg),n(Jt,di),m(e,yd,c),u(da,e,c),m(e,bd,c),m(e,Z,c),u(ma,Z,null),n(Z,ug),n(Z,mi),n(Z,Tg),u(Pt,Z,null),n(Z,yg),n(Z,hi),n(Z,bg),n(Z,gi),n(Z,xg),n(Z,fi),n(Z,wg),n(Z,Ve),u(ha,Ve,null),n(Ve,_g),n(Ve,ui),n(Ve,Mg),n(Ve,Ti),n(Z,Ug),n(Z,Ct),u(ga,Ct,null),n(Ct,kg),n(Ct,yi),n(Z,jg),n(Z,It),u(fa,It,null),n(It,vg),n(It,bi),n(Z,$g),n(Z,qt),u(ua,qt,null),n(qt,Jg),n(qt,xi),m(e,xd,c),m(e,Ta,c),m(e,wd,c),u(ya,e,c),m(e,_d,c),m(e,D,c),u(ba,D,null),n(D,Pg),n(D,wi),n(D,Cg),u(zt,D,null),n(D,Ig),n(D,_i),n(D,qg),n(D,Mi),n(D,zg),n(D,Ui),n(D,Gg),n(D,Gt),u(xa,Gt,null),n(Gt,Zg),n(Gt,ki),n(D,Fg),n(D,We),u(wa,We,null),n(We,Bg),n(We,ji),n(We,Rg),n(We,vi),n(D,Dg),n(D,Zt),u(_a,Zt,null),n(Zt,Ng),n(Zt,$i),m(e,Md,c),u(Ma,e,c),m(e,Ud,c),m(e,X,c),u(Ua,X,null),n(X,Lg),n(X,Ji),n(X,Ag),n(X,Pi),n(X,Vg),n(X,Ci),n(X,Wg),n(X,Ii),n(X,Sg),n(X,qi),n(X,Hg),u(Ft,X,null),n(X,Og),n(X,Bt),u(ka,Bt,null),n(Bt,Yg),n(Bt,zi),m(e,kd,c),u(ja,e,c),m(e,jd,c),m(e,N,c),u(va,N,null),n(N,Eg),n(N,Gi),n(N,Qg),n(N,Zi),n(N,Xg),n(N,Fi),n(N,Kg),u(Rt,N,null),n(N,ef),n(N,Bi),n(N,tf),n(N,Ri),n(N,nf),n(N,Di),n(N,sf),n(N,Te),u($a,Te,null),n(Te,af),n(Te,Ni),n(Te,of),n(Te,Li),n(Te,rf),n(Te,Ai),n(Te,lf),u(Dt,Te,null),n(Te,cf),n(Te,Vi),n(Te,pf),u(Nt,Te,null),m(e,vd,c),u(Ja,e,c),m(e,$d,c),m(e,K,c),u(Pa,K,null),n(K,df),n(K,Wi),n(K,mf),u(Lt,K,null),n(K,hf),n(K,Si),n(K,gf),n(K,Hi),n(K,ff),n(K,Oi),n(K,uf),n(K,Yi),n(K,Tf),n(K,At),u(Ca,At,null),n(At,yf),n(At,Ei),m(e,Jd,c),u(Ia,e,c),m(e,Pd,c),m(e,F,c),u(qa,F,null),n(F,bf),n(F,Qi),n(F,xf),n(F,Xi),n(F,wf),n(F,Ki),n(F,_f),u(Vt,F,null),n(F,Mf),u(Wt,F,null),n(F,Uf),n(F,el),n(F,kf),n(F,tl),n(F,jf),n(F,nl),n(F,vf),n(F,St),u(za,St,null),n(St,$f),n(St,sl),m(e,Cd,c),u(Ga,e,c),m(e,Id,c),m(e,q,c),u(Za,q,null),n(q,Jf),n(q,al),n(q,Pf),n(q,ol),n(q,Cf),n(q,rl),n(q,If),u(Ht,q,null),n(q,qf),n(q,il),n(q,zf),n(q,ll),n(q,Gf),n(q,cl),n(q,Zf),u(Ot,q,null),n(q,Ff),n(q,Yt),u(Fa,Yt,null),n(Yt,Bf),n(Yt,pl),n(q,Rf),n(q,Et),u(Ba,Et,null),n(Et,Df),n(Et,dl),m(e,qd,c),u(Ra,e,c),m(e,zd,c),m(e,z,c),u(Da,z,null),n(z,Nf),n(z,ml),n(z,Lf),u(Qt,z,null),n(z,Af),n(z,hl),n(z,Vf),n(z,gl),n(z,Wf),n(z,fl),n(z,Sf),n(z,Xt),u(Na,Xt,null),n(Xt,Hf),n(Xt,ul),n(z,Of),n(z,Se),u(La,Se,null),n(Se,Yf),n(Se,Tl),n(Se,Ef),n(Se,yl),n(z,Qf),n(z,Kt),u(Aa,Kt,null),n(Kt,Xf),n(Kt,bl),n(z,Kf),n(z,en),u(Va,en,null),n(en,eu),n(en,xl),n(z,tu),n(z,tn),u(Wa,tn,null),n(tn,nu),n(tn,wl),m(e,Gd,c),u(Sa,e,c),m(e,Zd,c),m(e,ee,c),u(Ha,ee,null),n(ee,su),n(ee,_l),n(ee,au),n(ee,Ml),n(ee,ou),n(ee,Ul),n(ee,ru),n(ee,kl),n(ee,iu),n(ee,jl),n(ee,lu),u(nn,ee,null),n(ee,cu),n(ee,sn),u(Oa,sn,null),n(sn,pu),n(sn,vl),m(e,Fd,c),u(Ya,e,c),m(e,Bd,c),m(e,te,c),u(Ea,te,null),n(te,du),n(te,$l),n(te,mu),n(te,Jl),n(te,hu),u(an,te,null),n(te,gu),n(te,Pl),n(te,fu),n(te,Cl),n(te,uu),n(te,Il),n(te,Tu),n(te,on),u(Qa,on,null),n(on,yu),n(on,ql),m(e,Rd,c),u(Xa,e,c),m(e,Dd,c),m(e,Ka,c),m(e,Nd,c),u(eo,e,c),m(e,Ld,c),m(e,L,c),u(to,L,null),n(L,bu),n(L,zl),n(L,xu),n(L,Gl),n(L,wu),n(L,Zl),n(L,_u),u(rn,L,null),n(L,Mu),n(L,Fl),n(L,Uu),n(L,Bl),n(L,ku),n(L,Rl),n(L,ju),n(L,Ae),u(no,Ae,null),n(Ae,vu),n(Ae,Dl),n(Ae,$u),n(Ae,Nl),n(Ae,Ju),n(Ae,Ll),m(e,Ad,c),u(so,e,c),m(e,Vd,c),m(e,me,c),u(ao,me,null),n(me,Pu),n(me,Al),n(me,Cu),u(ln,me,null),n(me,Iu),n(me,Vl),n(me,qu),n(me,Wl),n(me,zu),n(me,Sl),n(me,Gu),n(me,cn),u(oo,cn,null),n(cn,Zu),n(cn,Hl),m(e,Wd,c),u(ro,e,c),m(e,Sd,c),m(e,he,c),u(io,he,null),n(he,Fu),n(he,Ol),n(he,Bu),u(pn,he,null),n(he,Ru),n(he,Yl),n(he,Du),n(he,El),n(he,Nu),n(he,Ql),n(he,Lu),n(he,dn),u(lo,dn,null),n(dn,Au),n(dn,Xl),m(e,Hd,c),u(co,e,c),m(e,Od,c),m(e,A,c),u(po,A,null),n(A,Vu),n(A,Kl),n(A,Wu),n(A,ec),n(A,Su),n(A,tc),n(A,Hu),u(mn,A,null),n(A,Ou),n(A,nc),n(A,Yu),n(A,sc),n(A,Eu),n(A,ac),n(A,Qu),n(A,hn),u(mo,hn,null),n(hn,Xu),n(hn,oc),m(e,Yd,c),u(ho,e,c),m(e,Ed,c),m(e,B,c),u(go,B,null),n(B,Ku),n(B,rc),n(B,eT),n(B,ic),n(B,tT),n(B,lc),n(B,nT),u(gn,B,null),n(B,sT),u(fn,B,null),n(B,aT),n(B,cc),n(B,oT),n(B,pc),n(B,rT),n(B,dc),n(B,iT),n(B,un),u(fo,un,null),n(un,lT),n(un,mc),m(e,Qd,c),u(uo,e,c),m(e,Xd,c),m(e,V,c),u(To,V,null),n(V,cT),n(V,hc),n(V,pT),n(V,gc),n(V,dT),n(V,fc),n(V,mT),u(Tn,V,null),n(V,hT),n(V,uc),n(V,gT),n(V,Tc),n(V,fT),n(V,yc),n(V,uT),n(V,yn),u(yo,yn,null),n(yn,TT),n(yn,bc),m(e,Kd,c),u(bo,e,c),m(e,em,c),m(e,W,c),u(xo,W,null),n(W,yT),n(W,xc),n(W,bT),n(W,wc),n(W,xT),n(W,_c),n(W,wT),u(bn,W,null),n(W,_T),n(W,Mc),n(W,MT),n(W,Uc),n(W,UT),n(W,kc),n(W,kT),n(W,He),u(wo,He,null),n(He,jT),n(He,jc),n(He,vT),n(He,vc),m(e,tm,c),u(_o,e,c),m(e,nm,c),m(e,C,c),u(Mo,C,null),n(C,$T),n(C,$c),n(C,JT),n(C,Jc),n(C,PT),n(C,Pc),n(C,CT),n(C,Cc),n(C,IT),n(C,Ic),n(C,qT),n(C,xn),u(Uo,xn,null),n(xn,zT),n(xn,qc),n(C,GT),n(C,Oe),u(ko,Oe,null),n(Oe,ZT),n(Oe,zc),n(Oe,FT),u(wn,Oe,null),n(C,BT),n(C,_n),u(jo,_n,null),n(_n,RT),n(_n,Gc),n(C,DT),n(C,Mn),u(vo,Mn,null),n(Mn,NT),n(Mn,Zc),n(C,LT),n(C,Un),u($o,Un,null),n(Un,AT),n(Un,Fc),n(C,VT),n(C,kn),u(Jo,kn,null),n(kn,WT),n(kn,Bc),n(C,ST),n(C,Ye),u(Po,Ye,null),n(Ye,HT),n(Ye,Rc),n(Ye,OT),u(jn,Ye,null),n(C,YT),n(C,vn),u(Co,vn,null),n(vn,ET),n(vn,Dc),n(C,QT),n(C,$n),u(Io,$n,null),n($n,XT),n($n,Nc),m(e,sm,c),u(qo,e,c),m(e,am,c),m(e,Oc,c),om=!0},p(e,[c]){const Ze={};c&2&&(Ze.$$scope={dirty:c,ctx:e}),Xe.$set(Ze);const je={};c&2&&(je.$$scope={dirty:c,ctx:e}),Ke.$set(je);const zo={};c&2&&(zo.$$scope={dirty:c,ctx:e}),et.$set(zo);const ge={};c&2&&(ge.$$scope={dirty:c,ctx:e}),tt.$set(ge);const Go={};c&2&&(Go.$$scope={dirty:c,ctx:e}),st.$set(Go);const S={};c&2&&(S.$$scope={dirty:c,ctx:e}),ot.$set(S);const Zo={};c&2&&(Zo.$$scope={dirty:c,ctx:e}),rt.$set(Zo);const Fe={};c&2&&(Fe.$$scope={dirty:c,ctx:e}),lt.$set(Fe);const Fo={};c&2&&(Fo.$$scope={dirty:c,ctx:e}),ct.$set(Fo);const ve={};c&2&&(ve.$$scope={dirty:c,ctx:e}),dt.$set(ve);const Bo={};c&2&&(Bo.$$scope={dirty:c,ctx:e}),ht.$set(Bo);const $e={};c&2&&($e.$$scope={dirty:c,ctx:e}),ft.$set($e);const Ro={};c&2&&(Ro.$$scope={dirty:c,ctx:e}),Tt.$set(Ro);const Be={};c&2&&(Be.$$scope={dirty:c,ctx:e}),bt.$set(Be);const Do={};c&2&&(Do.$$scope={dirty:c,ctx:e}),_t.$set(Do);const Re={};c&2&&(Re.$$scope={dirty:c,ctx:e}),Ut.$set(Re);const No={};c&2&&(No.$$scope={dirty:c,ctx:e}),jt.$set(No);const Je={};c&2&&(Je.$$scope={dirty:c,ctx:e}),vt.$set(Je);const Lo={};c&2&&(Lo.$$scope={dirty:c,ctx:e}),$t.$set(Lo);const Le={};c&2&&(Le.$$scope={dirty:c,ctx:e}),Pt.$set(Le);const Ao={};c&2&&(Ao.$$scope={dirty:c,ctx:e}),zt.$set(Ao);const Pe={};c&2&&(Pe.$$scope={dirty:c,ctx:e}),Ft.$set(Pe);const Vo={};c&2&&(Vo.$$scope={dirty:c,ctx:e}),Rt.$set(Vo);const Ce={};c&2&&(Ce.$$scope={dirty:c,ctx:e}),Dt.$set(Ce);const Wo={};c&2&&(Wo.$$scope={dirty:c,ctx:e}),Nt.$set(Wo);const ne={};c&2&&(ne.$$scope={dirty:c,ctx:e}),Lt.$set(ne);const So={};c&2&&(So.$$scope={dirty:c,ctx:e}),Vt.$set(So);const H={};c&2&&(H.$$scope={dirty:c,ctx:e}),Wt.$set(H);const Ee={};c&2&&(Ee.$$scope={dirty:c,ctx:e}),Ht.$set(Ee);const Ho={};c&2&&(Ho.$$scope={dirty:c,ctx:e}),Ot.$set(Ho);const Oo={};c&2&&(Oo.$$scope={dirty:c,ctx:e}),Qt.$set(Oo);const Yo={};c&2&&(Yo.$$scope={dirty:c,ctx:e}),nn.$set(Yo);const se={};c&2&&(se.$$scope={dirty:c,ctx:e}),an.$set(se);const Eo={};c&2&&(Eo.$$scope={dirty:c,ctx:e}),rn.$set(Eo);const Qe={};c&2&&(Qe.$$scope={dirty:c,ctx:e}),ln.$set(Qe);const Qo={};c&2&&(Qo.$$scope={dirty:c,ctx:e}),pn.$set(Qo);const fe={};c&2&&(fe.$$scope={dirty:c,ctx:e}),mn.$set(fe);const Xo={};c&2&&(Xo.$$scope={dirty:c,ctx:e}),gn.$set(Xo);const ae={};c&2&&(ae.$$scope={dirty:c,ctx:e}),fn.$set(ae);const Ie={};c&2&&(Ie.$$scope={dirty:c,ctx:e}),Tn.$set(Ie);const ue={};c&2&&(ue.$$scope={dirty:c,ctx:e}),bn.$set(ue);const Ko={};c&2&&(Ko.$$scope={dirty:c,ctx:e}),wn.$set(Ko);const O={};c&2&&(O.$$scope={dirty:c,ctx:e}),jn.$set(O)},i(e){om||(T(x.$$.fragment,e),T(In.$$.fragment,e),T(Gn.$$.fragment,e),T(Fn.$$.fragment,e),T(Rn.$$.fragment,e),T(Nn.$$.fragment,e),T(An.$$.fragment,e),T(Vn.$$.fragment,e),T(Xe.$$.fragment,e),T(Ke.$$.fragment,e),T(Wn.$$.fragment,e),T(Hn.$$.fragment,e),T(et.$$.fragment,e),T(On.$$.fragment,e),T(Yn.$$.fragment,e),T(Qn.$$.fragment,e),T(Kn.$$.fragment,e),T(ss.$$.fragment,e),T(rs.$$.fragment,e),T(ls.$$.fragment,e),T(ds.$$.fragment,e),T(us.$$.fragment,e),T(ys.$$.fragment,e),T(xs.$$.fragment,e),T(_s.$$.fragment,e),T(Ms.$$.fragment,e),T(tt.$$.fragment,e),T(Us.$$.fragment,e),T(ks.$$.fragment,e),T(js.$$.fragment,e),T(st.$$.fragment,e),T(vs.$$.fragment,e),T($s.$$.fragment,e),T(Js.$$.fragment,e),T(ot.$$.fragment,e),T(rt.$$.fragment,e),T(Ps.$$.fragment,e),T(Cs.$$.fragment,e),T(Is.$$.fragment,e),T(lt.$$.fragment,e),T(ct.$$.fragment,e),T(qs.$$.fragment,e),T(zs.$$.fragment,e),T(Zs.$$.fragment,e),T(Fs.$$.fragment,e),T(dt.$$.fragment,e),T(Bs.$$.fragment,e),T(Rs.$$.fragment,e),T(Ds.$$.fragment,e),T(ht.$$.fragment,e),T(Ns.$$.fragment,e),T(Ls.$$.fragment,e),T(As.$$.fragment,e),T(ft.$$.fragment,e),T(Vs.$$.fragment,e),T(Ws.$$.fragment,e),T(Ss.$$.fragment,e),T(Tt.$$.fragment,e),T(Hs.$$.fragment,e),T(Os.$$.fragment,e),T(Ys.$$.fragment,e),T(bt.$$.fragment,e),T(Es.$$.fragment,e),T(Qs.$$.fragment,e),T(Xs.$$.fragment,e),T(Ks.$$.fragment,e),T(ea.$$.fragment,e),T(ta.$$.fragment,e),T(_t.$$.fragment,e),T(na.$$.fragment,e),T(sa.$$.fragment,e),T(aa.$$.fragment,e),T(Ut.$$.fragment,e),T(oa.$$.fragment,e),T(ra.$$.fragment,e),T(la.$$.fragment,e),T(ca.$$.fragment,e),T(jt.$$.fragment,e),T(vt.$$.fragment,e),T($t.$$.fragment,e),T(pa.$$.fragment,e),T(da.$$.fragment,e),T(ma.$$.fragment,e),T(Pt.$$.fragment,e),T(ha.$$.fragment,e),T(ga.$$.fragment,e),T(fa.$$.fragment,e),T(ua.$$.fragment,e),T(ya.$$.fragment,e),T(ba.$$.fragment,e),T(zt.$$.fragment,e),T(xa.$$.fragment,e),T(wa.$$.fragment,e),T(_a.$$.fragment,e),T(Ma.$$.fragment,e),T(Ua.$$.fragment,e),T(Ft.$$.fragment,e),T(ka.$$.fragment,e),T(ja.$$.fragment,e),T(va.$$.fragment,e),T(Rt.$$.fragment,e),T($a.$$.fragment,e),T(Dt.$$.fragment,e),T(Nt.$$.fragment,e),T(Ja.$$.fragment,e),T(Pa.$$.fragment,e),T(Lt.$$.fragment,e),T(Ca.$$.fragment,e),T(Ia.$$.fragment,e),T(qa.$$.fragment,e),T(Vt.$$.fragment,e),T(Wt.$$.fragment,e),T(za.$$.fragment,e),T(Ga.$$.fragment,e),T(Za.$$.fragment,e),T(Ht.$$.fragment,e),T(Ot.$$.fragment,e),T(Fa.$$.fragment,e),T(Ba.$$.fragment,e),T(Ra.$$.fragment,e),T(Da.$$.fragment,e),T(Qt.$$.fragment,e),T(Na.$$.fragment,e),T(La.$$.fragment,e),T(Aa.$$.fragment,e),T(Va.$$.fragment,e),T(Wa.$$.fragment,e),T(Sa.$$.fragment,e),T(Ha.$$.fragment,e),T(nn.$$.fragment,e),T(Oa.$$.fragment,e),T(Ya.$$.fragment,e),T(Ea.$$.fragment,e),T(an.$$.fragment,e),T(Qa.$$.fragment,e),T(Xa.$$.fragment,e),T(eo.$$.fragment,e),T(to.$$.fragment,e),T(rn.$$.fragment,e),T(no.$$.fragment,e),T(so.$$.fragment,e),T(ao.$$.fragment,e),T(ln.$$.fragment,e),T(oo.$$.fragment,e),T(ro.$$.fragment,e),T(io.$$.fragment,e),T(pn.$$.fragment,e),T(lo.$$.fragment,e),T(co.$$.fragment,e),T(po.$$.fragment,e),T(mn.$$.fragment,e),T(mo.$$.fragment,e),T(ho.$$.fragment,e),T(go.$$.fragment,e),T(gn.$$.fragment,e),T(fn.$$.fragment,e),T(fo.$$.fragment,e),T(uo.$$.fragment,e),T(To.$$.fragment,e),T(Tn.$$.fragment,e),T(yo.$$.fragment,e),T(bo.$$.fragment,e),T(xo.$$.fragment,e),T(bn.$$.fragment,e),T(wo.$$.fragment,e),T(_o.$$.fragment,e),T(Mo.$$.fragment,e),T(Uo.$$.fragment,e),T(ko.$$.fragment,e),T(wn.$$.fragment,e),T(jo.$$.fragment,e),T(vo.$$.fragment,e),T($o.$$.fragment,e),T(Jo.$$.fragment,e),T(Po.$$.fragment,e),T(jn.$$.fragment,e),T(Co.$$.fragment,e),T(Io.$$.fragment,e),T(qo.$$.fragment,e),om=!0)},o(e){y(x.$$.fragment,e),y(In.$$.fragment,e),y(Gn.$$.fragment,e),y(Fn.$$.fragment,e),y(Rn.$$.fragment,e),y(Nn.$$.fragment,e),y(An.$$.fragment,e),y(Vn.$$.fragment,e),y(Xe.$$.fragment,e),y(Ke.$$.fragment,e),y(Wn.$$.fragment,e),y(Hn.$$.fragment,e),y(et.$$.fragment,e),y(On.$$.fragment,e),y(Yn.$$.fragment,e),y(Qn.$$.fragment,e),y(Kn.$$.fragment,e),y(ss.$$.fragment,e),y(rs.$$.fragment,e),y(ls.$$.fragment,e),y(ds.$$.fragment,e),y(us.$$.fragment,e),y(ys.$$.fragment,e),y(xs.$$.fragment,e),y(_s.$$.fragment,e),y(Ms.$$.fragment,e),y(tt.$$.fragment,e),y(Us.$$.fragment,e),y(ks.$$.fragment,e),y(js.$$.fragment,e),y(st.$$.fragment,e),y(vs.$$.fragment,e),y($s.$$.fragment,e),y(Js.$$.fragment,e),y(ot.$$.fragment,e),y(rt.$$.fragment,e),y(Ps.$$.fragment,e),y(Cs.$$.fragment,e),y(Is.$$.fragment,e),y(lt.$$.fragment,e),y(ct.$$.fragment,e),y(qs.$$.fragment,e),y(zs.$$.fragment,e),y(Zs.$$.fragment,e),y(Fs.$$.fragment,e),y(dt.$$.fragment,e),y(Bs.$$.fragment,e),y(Rs.$$.fragment,e),y(Ds.$$.fragment,e),y(ht.$$.fragment,e),y(Ns.$$.fragment,e),y(Ls.$$.fragment,e),y(As.$$.fragment,e),y(ft.$$.fragment,e),y(Vs.$$.fragment,e),y(Ws.$$.fragment,e),y(Ss.$$.fragment,e),y(Tt.$$.fragment,e),y(Hs.$$.fragment,e),y(Os.$$.fragment,e),y(Ys.$$.fragment,e),y(bt.$$.fragment,e),y(Es.$$.fragment,e),y(Qs.$$.fragment,e),y(Xs.$$.fragment,e),y(Ks.$$.fragment,e),y(ea.$$.fragment,e),y(ta.$$.fragment,e),y(_t.$$.fragment,e),y(na.$$.fragment,e),y(sa.$$.fragment,e),y(aa.$$.fragment,e),y(Ut.$$.fragment,e),y(oa.$$.fragment,e),y(ra.$$.fragment,e),y(la.$$.fragment,e),y(ca.$$.fragment,e),y(jt.$$.fragment,e),y(vt.$$.fragment,e),y($t.$$.fragment,e),y(pa.$$.fragment,e),y(da.$$.fragment,e),y(ma.$$.fragment,e),y(Pt.$$.fragment,e),y(ha.$$.fragment,e),y(ga.$$.fragment,e),y(fa.$$.fragment,e),y(ua.$$.fragment,e),y(ya.$$.fragment,e),y(ba.$$.fragment,e),y(zt.$$.fragment,e),y(xa.$$.fragment,e),y(wa.$$.fragment,e),y(_a.$$.fragment,e),y(Ma.$$.fragment,e),y(Ua.$$.fragment,e),y(Ft.$$.fragment,e),y(ka.$$.fragment,e),y(ja.$$.fragment,e),y(va.$$.fragment,e),y(Rt.$$.fragment,e),y($a.$$.fragment,e),y(Dt.$$.fragment,e),y(Nt.$$.fragment,e),y(Ja.$$.fragment,e),y(Pa.$$.fragment,e),y(Lt.$$.fragment,e),y(Ca.$$.fragment,e),y(Ia.$$.fragment,e),y(qa.$$.fragment,e),y(Vt.$$.fragment,e),y(Wt.$$.fragment,e),y(za.$$.fragment,e),y(Ga.$$.fragment,e),y(Za.$$.fragment,e),y(Ht.$$.fragment,e),y(Ot.$$.fragment,e),y(Fa.$$.fragment,e),y(Ba.$$.fragment,e),y(Ra.$$.fragment,e),y(Da.$$.fragment,e),y(Qt.$$.fragment,e),y(Na.$$.fragment,e),y(La.$$.fragment,e),y(Aa.$$.fragment,e),y(Va.$$.fragment,e),y(Wa.$$.fragment,e),y(Sa.$$.fragment,e),y(Ha.$$.fragment,e),y(nn.$$.fragment,e),y(Oa.$$.fragment,e),y(Ya.$$.fragment,e),y(Ea.$$.fragment,e),y(an.$$.fragment,e),y(Qa.$$.fragment,e),y(Xa.$$.fragment,e),y(eo.$$.fragment,e),y(to.$$.fragment,e),y(rn.$$.fragment,e),y(no.$$.fragment,e),y(so.$$.fragment,e),y(ao.$$.fragment,e),y(ln.$$.fragment,e),y(oo.$$.fragment,e),y(ro.$$.fragment,e),y(io.$$.fragment,e),y(pn.$$.fragment,e),y(lo.$$.fragment,e),y(co.$$.fragment,e),y(po.$$.fragment,e),y(mn.$$.fragment,e),y(mo.$$.fragment,e),y(ho.$$.fragment,e),y(go.$$.fragment,e),y(gn.$$.fragment,e),y(fn.$$.fragment,e),y(fo.$$.fragment,e),y(uo.$$.fragment,e),y(To.$$.fragment,e),y(Tn.$$.fragment,e),y(yo.$$.fragment,e),y(bo.$$.fragment,e),y(xo.$$.fragment,e),y(bn.$$.fragment,e),y(wo.$$.fragment,e),y(_o.$$.fragment,e),y(Mo.$$.fragment,e),y(Uo.$$.fragment,e),y(ko.$$.fragment,e),y(wn.$$.fragment,e),y(jo.$$.fragment,e),y(vo.$$.fragment,e),y($o.$$.fragment,e),y(Jo.$$.fragment,e),y(Po.$$.fragment,e),y(jn.$$.fragment,e),y(Co.$$.fragment,e),y(Io.$$.fragment,e),y(qo.$$.fragment,e),om=!1},d(e){e&&(l(_),l(h),l(p),l(t),l(w),l(Yc),l(Pn),l(Ec),l(Cn),l(Qc),l(Xc),l(qn),l(Kc),l(zn),l(ep),l(tp),l(Zn),l(np),l(sp),l(Bn),l(ap),l(op),l(Dn),l(rp),l(ip),l(Ln),l(lp),l(cp),l(_e),l(pp),l(dp),l(Sn),l(mp),l(hp),l(gp),l(fp),l(up),l(En),l(Tp),l(yp),l(Xn),l(bp),l(xp),l(es),l(wp),l(ts),l(_p),l(ns),l(Mp),l(Up),l(as),l(kp),l(os),l(jp),l(vp),l(is),l($p),l(Jp),l(cs),l(Pp),l(ps),l(Cp),l(Ip),l(ms),l(qp),l(hs),l(zp),l(gs),l(Gp),l(fs),l(Zp),l(Fp),l(Ts),l(Bp),l(Rp),l(bs),l(Dp),l(Np),l(ws),l(Lp),l(Ap),l(re),l(Vp),l(Wp),l(Q),l(Sp),l(Hp),l(G),l(Op),l(Yp),l(Me),l(Ep),l(Qp),l(Gs),l(Xp),l(Kp),l(ie),l(ed),l(td),l(le),l(nd),l(sd),l(Ue),l(ad),l(od),l(ke),l(rd),l(id),l(ce),l(ld),l(cd),l(Ge),l(pd),l(dd),l(pe),l(md),l(hd),l(de),l(gd),l(fd),l(ia),l(ud),l(Td),l(R),l(yd),l(bd),l(Z),l(xd),l(Ta),l(wd),l(_d),l(D),l(Md),l(Ud),l(X),l(kd),l(jd),l(N),l(vd),l($d),l(K),l(Jd),l(Pd),l(F),l(Cd),l(Id),l(q),l(qd),l(zd),l(z),l(Gd),l(Zd),l(ee),l(Fd),l(Bd),l(te),l(Rd),l(Dd),l(Ka),l(Nd),l(Ld),l(L),l(Ad),l(Vd),l(me),l(Wd),l(Sd),l(he),l(Hd),l(Od),l(A),l(Yd),l(Ed),l(B),l(Qd),l(Xd),l(V),l(Kd),l(em),l(W),l(tm),l(nm),l(C),l(sm),l(am),l(Oc)),l(o),b(x,e),b(In,e),b(Gn,e),b(Fn,e),b(Rn,e),b(Nn,e),b(An,e),b(Vn),b(Xe),b(Ke),b(Wn,e),b(Hn,e),b(et,e),b(On,e),b(Yn,e),b(Qn,e),b(Kn,e),b(ss,e),b(rs,e),b(ls,e),b(ds,e),b(us,e),b(ys,e),b(xs,e),b(_s,e),b(Ms),b(tt),b(Us),b(ks,e),b(js),b(st),b(vs),b($s,e),b(Js),b(ot),b(rt),b(Ps),b(Cs,e),b(Is),b(lt),b(ct),b(qs),b(zs,e),b(Zs,e),b(Fs),b(dt),b(Bs),b(Rs,e),b(Ds),b(ht),b(Ns),b(Ls,e),b(As),b(ft),b(Vs),b(Ws,e),b(Ss),b(Tt),b(Hs),b(Os,e),b(Ys),b(bt),b(Es),b(Qs,e),b(Xs),b(Ks),b(ea,e),b(ta),b(_t),b(na),b(sa,e),b(aa),b(Ut),b(oa),b(ra,e),b(la,e),b(ca),b(jt),b(vt),b($t),b(pa),b(da,e),b(ma),b(Pt),b(ha),b(ga),b(fa),b(ua),b(ya,e),b(ba),b(zt),b(xa),b(wa),b(_a),b(Ma,e),b(Ua),b(Ft),b(ka),b(ja,e),b(va),b(Rt),b($a),b(Dt),b(Nt),b(Ja,e),b(Pa),b(Lt),b(Ca),b(Ia,e),b(qa),b(Vt),b(Wt),b(za),b(Ga,e),b(Za),b(Ht),b(Ot),b(Fa),b(Ba),b(Ra,e),b(Da),b(Qt),b(Na),b(La),b(Aa),b(Va),b(Wa),b(Sa,e),b(Ha),b(nn),b(Oa),b(Ya,e),b(Ea),b(an),b(Qa),b(Xa,e),b(eo,e),b(to),b(rn),b(no),b(so,e),b(ao),b(ln),b(oo),b(ro,e),b(io),b(pn),b(lo),b(co,e),b(po),b(mn),b(mo),b(ho,e),b(go),b(gn),b(fn),b(fo),b(uo,e),b(To),b(Tn),b(yo),b(bo,e),b(xo),b(bn),b(wo),b(_o,e),b(Mo),b(Uo),b(ko),b(wn),b(jo),b(vo),b($o),b(Jo),b(Po),b(jn),b(Co),b(Io),b(qo,e)}}}const TM='{"title":"Pipelines","local":"pipelines","sections":[{"title":"pipeline抽象类","local":"transformers.pipeline","sections":[],"depth":2},{"title":"Pipeline batching","local":"pipeline-batching","sections":[],"depth":2},{"title":"Pipeline chunk batching","local":"pipeline-chunk-batching","sections":[],"depth":2},{"title":"Pipeline自定义","local":"pipeline自定义","sections":[],"depth":2},{"title":"实现一个pipeline","local":"实现一个pipeline","sections":[],"depth":2},{"title":"音频","local":"音频","sections":[{"title":"AudioClassificationPipeline","local":"transformers.AudioClassificationPipeline","sections":[],"depth":3},{"title":"AutomaticSpeechRecognitionPipeline","local":"transformers.AutomaticSpeechRecognitionPipeline","sections":[],"depth":3},{"title":"TextToAudioPipeline","local":"transformers.TextToAudioPipeline","sections":[],"depth":3},{"title":"ZeroShotAudioClassificationPipeline","local":"transformers.ZeroShotAudioClassificationPipeline","sections":[],"depth":3}],"depth":2},{"title":"计算机视觉","local":"计算机视觉","sections":[{"title":"DepthEstimationPipeline","local":"transformers.DepthEstimationPipeline","sections":[],"depth":3},{"title":"ImageClassificationPipeline","local":"transformers.ImageClassificationPipeline","sections":[],"depth":3},{"title":"ImageSegmentationPipeline","local":"transformers.ImageSegmentationPipeline","sections":[],"depth":3},{"title":"ImageToImagePipeline","local":"transformers.ImageToImagePipeline","sections":[],"depth":3},{"title":"ObjectDetectionPipeline","local":"transformers.ObjectDetectionPipeline","sections":[],"depth":3},{"title":"VideoClassificationPipeline","local":"transformers.VideoClassificationPipeline","sections":[],"depth":3},{"title":"ZeroShotImageClassificationPipeline","local":"transformers.ZeroShotImageClassificationPipeline","sections":[],"depth":3},{"title":"ZeroShotObjectDetectionPipeline","local":"transformers.ZeroShotObjectDetectionPipeline","sections":[],"depth":3}],"depth":2},{"title":"自然语言处理","local":"自然语言处理","sections":[{"title":"FillMaskPipeline","local":"transformers.FillMaskPipeline","sections":[],"depth":3},{"title":"NerPipeline","local":"transformers.TokenClassificationPipeline","sections":[],"depth":3},{"title":"QuestionAnsweringPipeline","local":"transformers.QuestionAnsweringPipeline","sections":[],"depth":3},{"title":"SummarizationPipeline","local":"transformers.SummarizationPipeline","sections":[],"depth":3},{"title":"TableQuestionAnsweringPipeline","local":"transformers.TableQuestionAnsweringPipeline","sections":[],"depth":3},{"title":"TextClassificationPipeline","local":"transformers.TextClassificationPipeline","sections":[],"depth":3},{"title":"TextGenerationPipeline","local":"transformers.TextGenerationPipeline","sections":[],"depth":3},{"title":"Text2TextGenerationPipeline","local":"transformers.Text2TextGenerationPipeline","sections":[],"depth":3},{"title":"TokenClassificationPipeline","local":"transformers.TokenClassificationPipeline","sections":[],"depth":3},{"title":"TranslationPipeline","local":"transformers.TranslationPipeline","sections":[],"depth":3},{"title":"ZeroShotClassificationPipeline","local":"transformers.ZeroShotClassificationPipeline","sections":[],"depth":3}],"depth":2},{"title":"多模态","local":"多模态","sections":[{"title":"DocumentQuestionAnsweringPipeline","local":"transformers.DocumentQuestionAnsweringPipeline","sections":[],"depth":3},{"title":"FeatureExtractionPipeline","local":"transformers.FeatureExtractionPipeline","sections":[],"depth":3},{"title":"ImageFeatureExtractionPipeline","local":"transformers.ImageFeatureExtractionPipeline","sections":[],"depth":3},{"title":"ImageToTextPipeline","local":"transformers.ImageToTextPipeline","sections":[],"depth":3},{"title":"ImageTextToTextPipeline","local":"transformers.ImageTextToTextPipeline","sections":[],"depth":3},{"title":"MaskGenerationPipeline","local":"transformers.MaskGenerationPipeline","sections":[],"depth":3},{"title":"VisualQuestionAnsweringPipeline","local":"transformers.VisualQuestionAnsweringPipeline","sections":[],"depth":3}],"depth":2},{"title":"Parent class: Pipeline","local":"transformers.Pipeline","sections":[],"depth":2}],"depth":1}';function yM(M){return y_(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jM extends b_{constructor(o){super(),x_(this,o,yM,uM,T_,{})}}export{jM as component};
