import{s as Ul,n as Il,o as Al}from"../chunks/scheduler.85c25b89.js";import{S as Cl,i as Zl,g as p,s as e,r as i,A as Bl,h as m,f as t,c as n,j as bl,u as M,x as j,k as fl,y as Nl,a,v as o,d as c,t as r,w as J}from"../chunks/index.c9bcf812.js";import{C as R}from"../chunks/CodeBlock.94efc595.js";import{H as X}from"../chunks/Heading.3c6e5b17.js";function xl(cl){let h,Y,v,V,T,H,g,rl='A <strong>ResNeXt</strong> repeats a <a href="https://paperswithcode.com/method/resnext-block" rel="nofollow">building block</a> that aggregates a set of transformations with the same topology. Compared to a <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNet</a>, it exposes a new dimension,  <em>cardinality</em> (the size of the set of transformations) $C$, as an essential factor in addition to the dimensions of depth and width.',_,w,S,d,Jl="To load a pretrained model:",z,y,F,u,jl="To load and preprocess the image:",D,b,L,f,hl="To get the model predictions:",q,U,P,I,Tl="To get the top-5 predictions class names:",K,A,O,C,gl="Replace the model name with the variant you want to use, e.g. <code>resnext101_32x8d</code>. You can find the IDs in the model summaries at the top of this page.",ll,Z,wl='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',sl,B,tl,N,dl="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",al,x,el,$,yl=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,nl,W,pl,G,ul='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',ml,E,il,k,Ml,Q,ol;return T=new X({props:{title:"ResNeXt",local:"resnext",headingTag:"h1"}}),w=new X({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),y=new R({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3Jlc25leHQxMDFfMzJ4OGQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnext101_32x8d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new R({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),A=new R({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),B=new X({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),x=new R({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVzbmV4dDEwMV8zMng4ZCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnext101_32x8d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),W=new X({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new X({props:{title:"Citation",local:"citation",headingTag:"h2"}}),k=new R({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZYaWVHRFRIMTYlMkMlMEElMjAlMjBhdXRob3IlMjAlMjAlMjAlMjAlM0QlMjAlN0JTYWluaW5nJTIwWGllJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUm9zcyUyMEIuJTIwR2lyc2hpY2slMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBQaW90ciUyMERvbGwlN0IlNUMnJTdCYSU3RCU3RHIlMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBaaHVvd2VuJTIwVHUlMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBLYWltaW5nJTIwSGUlN0QlMkMlMEElMjAlMjB0aXRsZSUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QkFnZ3JlZ2F0ZWQlMjBSZXNpZHVhbCUyMFRyYW5zZm9ybWF0aW9ucyUyMGZvciUyMERlZXAlMjBOZXVyYWwlMjBOZXR3b3JrcyU3RCUyQyUwQSUyMCUyMGpvdXJuYWwlMjAlMjAlMjAlM0QlMjAlN0JDb1JSJTdEJTJDJTBBJTIwJTIwdm9sdW1lJTIwJTIwJTIwJTIwJTNEJTIwJTdCYWJzJTJGMTYxMS4wNTQzMSU3RCUyQyUwQSUyMCUyMHllYXIlMjAlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0IyMDE2JTdEJTJDJTBBJTIwJTIwdXJsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCaHR0cCUzQSUyRiUyRmFyeGl2Lm9yZyUyRmFicyUyRjE2MTEuMDU0MzElN0QlMkMlMEElMjAlMjBhcmNoaXZlUHJlZml4JTIwJTNEJTIwJTdCYXJYaXYlN0QlMkMlMEElMjAlMjBlcHJpbnQlMjAlMjAlMjAlMjAlM0QlMjAlN0IxNjExLjA1NDMxJTdEJTJDJTBBJTIwJTIwdGltZXN0YW1wJTIwJTNEJTIwJTdCTW9uJTJDJTIwMTMlMjBBdWclMjAyMDE4JTIwMTYlM0E0NSUzQTU4JTIwJTJCMDIwMCU3RCUyQyUwQSUyMCUyMGJpYnVybCUyMCUyMCUyMCUyMCUzRCUyMCU3Qmh0dHBzJTNBJTJGJTJGZGJscC5vcmclMkZyZWMlMkZqb3VybmFscyUyRmNvcnIlMkZYaWVHRFRIMTYuYmliJTdEJTJDJTBBJTIwJTIwYmlic291cmNlJTIwJTNEJTIwJTdCZGJscCUyMGNvbXB1dGVyJTIwc2NpZW5jZSUyMGJpYmxpb2dyYXBoeSUyQyUyMGh0dHBzJTNBJTJGJTJGZGJscC5vcmclN0QlMEElN0Q=",highlighted:`<span class="language-xml">@article</span><span class="hljs-template-variable">{DBLP:journals/corr/XieGDTH16,
  author    = {Saining Xie and
               Ross B. Girshick and
               Piotr Doll{\\&#x27;{a}</span><span class="language-xml">}r and
               Zhuowen Tu and
               Kaiming He},
  title     = </span><span class="hljs-template-variable">{Aggregated Residual Transformations for Deep Neural Networks}</span><span class="language-xml">,
  journal   = </span><span class="hljs-template-variable">{CoRR}</span><span class="language-xml">,
  volume    = </span><span class="hljs-template-variable">{abs/1611.05431}</span><span class="language-xml">,
  year      = </span><span class="hljs-template-variable">{2016}</span><span class="language-xml">,
  url       = </span><span class="hljs-template-variable">{http://arxiv.org/abs/1611.05431}</span><span class="language-xml">,
  archivePrefix = </span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
  eprint    = </span><span class="hljs-template-variable">{1611.05431}</span><span class="language-xml">,
  timestamp = </span><span class="hljs-template-variable">{Mon, 13 Aug 2018 16:45:58 +0200}</span><span class="language-xml">,
  biburl    = </span><span class="hljs-template-variable">{https://dblp.org/rec/journals/corr/XieGDTH16.bib}</span><span class="language-xml">,
  bibsource = </span><span class="hljs-template-variable">{dblp computer science bibliography, https://dblp.org}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){h=p("meta"),Y=e(),v=p("p"),V=e(),i(T.$$.fragment),H=e(),g=p("p"),g.innerHTML=rl,_=e(),i(w.$$.fragment),S=e(),d=p("p"),d.textContent=Jl,z=e(),i(y.$$.fragment),F=e(),u=p("p"),u.textContent=jl,D=e(),i(b.$$.fragment),L=e(),f=p("p"),f.textContent=hl,q=e(),i(U.$$.fragment),P=e(),I=p("p"),I.textContent=Tl,K=e(),i(A.$$.fragment),O=e(),C=p("p"),C.innerHTML=gl,ll=e(),Z=p("p"),Z.innerHTML=wl,sl=e(),i(B.$$.fragment),tl=e(),N=p("p"),N.textContent=dl,al=e(),i(x.$$.fragment),el=e(),$=p("p"),$.innerHTML=yl,nl=e(),i(W.$$.fragment),pl=e(),G=p("p"),G.innerHTML=ul,ml=e(),i(E.$$.fragment),il=e(),i(k.$$.fragment),Ml=e(),Q=p("p"),this.h()},l(l){const s=Bl("svelte-u9bgzb",document.head);h=m(s,"META",{name:!0,content:!0}),s.forEach(t),Y=n(l),v=m(l,"P",{}),bl(v).forEach(t),V=n(l),M(T.$$.fragment,l),H=n(l),g=m(l,"P",{"data-svelte-h":!0}),j(g)!=="svelte-lhf39w"&&(g.innerHTML=rl),_=n(l),M(w.$$.fragment,l),S=n(l),d=m(l,"P",{"data-svelte-h":!0}),j(d)!=="svelte-18ywhxh"&&(d.textContent=Jl),z=n(l),M(y.$$.fragment,l),F=n(l),u=m(l,"P",{"data-svelte-h":!0}),j(u)!=="svelte-1c2ipa8"&&(u.textContent=jl),D=n(l),M(b.$$.fragment,l),L=n(l),f=m(l,"P",{"data-svelte-h":!0}),j(f)!=="svelte-1n9qsq1"&&(f.textContent=hl),q=n(l),M(U.$$.fragment,l),P=n(l),I=m(l,"P",{"data-svelte-h":!0}),j(I)!=="svelte-19cnvx1"&&(I.textContent=Tl),K=n(l),M(A.$$.fragment,l),O=n(l),C=m(l,"P",{"data-svelte-h":!0}),j(C)!=="svelte-j0haf3"&&(C.innerHTML=gl),ll=n(l),Z=m(l,"P",{"data-svelte-h":!0}),j(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=wl),sl=n(l),M(B.$$.fragment,l),tl=n(l),N=m(l,"P",{"data-svelte-h":!0}),j(N)!=="svelte-9sr7nh"&&(N.textContent=dl),al=n(l),M(x.$$.fragment,l),el=n(l),$=m(l,"P",{"data-svelte-h":!0}),j($)!=="svelte-1kguc51"&&($.innerHTML=yl),nl=n(l),M(W.$$.fragment,l),pl=n(l),G=m(l,"P",{"data-svelte-h":!0}),j(G)!=="svelte-1n0coha"&&(G.innerHTML=ul),ml=n(l),M(E.$$.fragment,l),il=n(l),M(k.$$.fragment,l),Ml=n(l),Q=m(l,"P",{}),bl(Q).forEach(t),this.h()},h(){fl(h,"name","hf:doc:metadata"),fl(h,"content",$l)},m(l,s){Nl(document.head,h),a(l,Y,s),a(l,v,s),a(l,V,s),o(T,l,s),a(l,H,s),a(l,g,s),a(l,_,s),o(w,l,s),a(l,S,s),a(l,d,s),a(l,z,s),o(y,l,s),a(l,F,s),a(l,u,s),a(l,D,s),o(b,l,s),a(l,L,s),a(l,f,s),a(l,q,s),o(U,l,s),a(l,P,s),a(l,I,s),a(l,K,s),o(A,l,s),a(l,O,s),a(l,C,s),a(l,ll,s),a(l,Z,s),a(l,sl,s),o(B,l,s),a(l,tl,s),a(l,N,s),a(l,al,s),o(x,l,s),a(l,el,s),a(l,$,s),a(l,nl,s),o(W,l,s),a(l,pl,s),a(l,G,s),a(l,ml,s),o(E,l,s),a(l,il,s),o(k,l,s),a(l,Ml,s),a(l,Q,s),ol=!0},p:Il,i(l){ol||(c(T.$$.fragment,l),c(w.$$.fragment,l),c(y.$$.fragment,l),c(b.$$.fragment,l),c(U.$$.fragment,l),c(A.$$.fragment,l),c(B.$$.fragment,l),c(x.$$.fragment,l),c(W.$$.fragment,l),c(E.$$.fragment,l),c(k.$$.fragment,l),ol=!0)},o(l){r(T.$$.fragment,l),r(w.$$.fragment,l),r(y.$$.fragment,l),r(b.$$.fragment,l),r(U.$$.fragment,l),r(A.$$.fragment,l),r(B.$$.fragment,l),r(x.$$.fragment,l),r(W.$$.fragment,l),r(E.$$.fragment,l),r(k.$$.fragment,l),ol=!1},d(l){l&&(t(Y),t(v),t(V),t(H),t(g),t(_),t(S),t(d),t(z),t(F),t(u),t(D),t(L),t(f),t(q),t(P),t(I),t(K),t(O),t(C),t(ll),t(Z),t(sl),t(tl),t(N),t(al),t(el),t($),t(nl),t(pl),t(G),t(ml),t(il),t(Ml),t(Q)),t(h),J(T,l),J(w,l),J(y,l),J(b,l),J(U,l),J(A,l),J(B,l),J(x,l),J(W,l),J(E,l),J(k,l)}}}const $l='{"title":"ResNeXt","local":"resnext","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Wl(cl){return Al(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vl extends Cl{constructor(h){super(),Zl(this,h,Wl,xl,Ul,{})}}export{vl as component};
