import{s as Ft,o as Lt,n as Gl}from"../chunks/scheduler.5eb9d175.js";import{S as qt,i as St,g as p,s as n,r as c,A as Pt,h as i,f as t,c as M,j as Ht,u as J,x as y,k as zt,y as Dt,a as s,v as m,d as T,t as d,w}from"../chunks/index.fcdcb606.js";import{T as Vl}from"../chunks/Tip.9272e506.js";import{C as f}from"../chunks/CodeBlock.a7036e06.js";import{H as Rl,E as Kt}from"../chunks/EditOnGithub.98bf070f.js";function Ot(u){let a,r="تتبع النماذج في مكتبة <code>transformers</code> اتفاقية قبول كائن <code>config</code> في دالة  <code>__init__</code> الخاصة بها، ثم تمرر كائن <code>config</code> بالكامل إلى الطبقات الفرعية في النموذج، بدلاً من تقسيمه إلى معامﻻت متعددة. يؤدي كتابة نموذجك بهذا الأسلوب إلى كود أبسط مع “مصدر حقيقة” واضح لأي فرط معلمات، كما يسهل إعادة استخدام الكود من نماذج أخرى في <code>transformers</code>.";return{c(){a=p("p"),a.innerHTML=r},l(o){a=i(o,"P",{"data-svelte-h":!0}),y(a)!=="svelte-1ae7j6c"&&(a.innerHTML=r)},m(o,j){s(o,a,j)},p:Gl,d(o){o&&t(a)}}}function ls(u){let a,r="إذا كان نموذجك مشابهًا جدًا لنموذج داخل المكتبة، فيمكنك إعادة استخدام نفس التكوين مثل هذا النموذج.";return{c(){a=p("p"),a.textContent=r},l(o){a=i(o,"P",{"data-svelte-h":!0}),y(a)!=="svelte-cvvuyl"&&(a.textContent=r)},m(o,j){s(o,a,j)},p:Gl,d(o){o&&t(a)}}}function es(u){let a,r="هذا API تجريبي وقد يكون له بعض التغييرات الطفيفة في الإصدارات القادمة.";return{c(){a=p("p"),a.textContent=r},l(o){a=i(o,"P",{"data-svelte-h":!0}),y(a)!=="svelte-7rycl8"&&(a.textContent=r)},m(o,j){s(o,a,j)},p:Gl,d(o){o&&t(a)}}}function ts(u){let a,r=`إذا كنت تقوم بنسخ ملفات النمذجة من المكتبة، فسوف تحتاج إلى استبدال جميع الواردات النسبية في أعلى الملف
لاستيرادها من حزمة <code>transformers</code>.`;return{c(){a=p("p"),a.innerHTML=r},l(o){a=i(o,"P",{"data-svelte-h":!0}),y(a)!=="svelte-wcgyfo"&&(a.innerHTML=r)},m(o,j){s(o,a,j)},p:Gl,d(o){o&&t(a)}}}function ss(u){let a,r=`استخدم <code>register_for_auto_class()</code> إذا كنت تريد نسخ ملفات الكود. إذا كنت تفضل استخدام الكود على Hub من مستودع آخر،
فلا تحتاج إلى استدعائه. في الحالات التي يوجد فيها أكثر من فئة تلقائية واحدة، يمكنك تعديل ملف <code>config.json</code> مباشرة باستخدام
الهيكل التالي:`,o,j,C;return j=new f({props:{code:"JTIyYXV0b19tYXAlMjIlM0ElMjAlN0IlMjAlMjAlMjAlMjAlMjAlMEElMDklMjJBdXRvQ29uZmlnJTIyJTNBJTIwJTIyJTNDeW91ci1yZXBvLW5hbWUlM0UtLSUzQ2NvbmZpZy1uYW1lJTNFJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTBBJTA5JTIyQXV0b01vZGVsJTIyJTNBJTIwJTIyJTNDeW91ci1yZXBvLW5hbWUlM0UtLSUzQ2NvbmZpZy1uYW1lJTNFJTIyJTJDJTBBJTA5JTIyQXV0b01vZGVsRm9yJTNDVGFzayUzRSUyMiUzQSUyMCUyMiUzQ3lvdXItcmVwby1uYW1lJTNFLS0lM0Njb25maWctbmFtZSUzRSUyMiUyQyUyMCUyMCUyMCUyMCUwQSU3RCUyQw==",highlighted:`<span class="hljs-attr">&quot;auto_map&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>     
	<span class="hljs-attr">&quot;AutoConfig&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;your-repo-name&gt;--&lt;config-name&gt;&quot;</span><span class="hljs-punctuation">,</span>     
	<span class="hljs-attr">&quot;AutoModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;your-repo-name&gt;--&lt;config-name&gt;&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;AutoModelFor&lt;Task&gt;&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;your-repo-name&gt;--&lt;config-name&gt;&quot;</span><span class="hljs-punctuation">,</span>    
<span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>`,wrap:!1}}),{c(){a=p("p"),a.innerHTML=r,o=n(),c(j.$$.fragment)},l(U){a=i(U,"P",{"data-svelte-h":!0}),y(a)!=="svelte-1w0jexy"&&(a.innerHTML=r),o=M(U),J(j.$$.fragment,U)},m(U,b){s(U,a,b),s(U,o,b),m(j,U,b),C=!0},p:Gl,i(U){C||(T(j.$$.fragment,U),C=!0)},o(U){d(j.$$.fragment,U),C=!1},d(U){U&&(t(a),t(o)),w(j,U)}}}function ns(u){let a,r,o,j,C,U,b,lt="تم تصميم مكتبة 🤗 Transformers لتكون قابلة للتوسيع بسهولة. كل نموذج مُشفّر بالكامل في مجلد فرعي معين بالمستودع، دون أي تجريد، لذلك يمكنك بسهولة نسخ ملف النمذجة وتعديله وفقًا لاحتياجاتك.",Ql,A,et="إذا كنت تُنشئ نموذجًا جديدًا تمامًا، فقد يكون من الأسهل البدء من الصفر. في هذا البرنامج التعليمي، سنُرِيك كيفية كتابة نموذج مخصص وتكوينه ليُستخدم داخل Transformers، وكيفية مشاركته مع المجتمع (مع الكود الذي يعتمد عليه) بحيث يمكن لأي شخص استخدامه، حتى إذا لم يكن موجودًا في مكتبة 🤗 Transformers. سنرى كيفية البناء على المحولات ونوسّع الإطار  باستخدام الأدوات التي يمكن استخدامها لتعديل سلوك الإطار (hooks) والتعليمات البرمجية المخصصة.",Yl,g,tt=`سنوضح كل هذا من خلال نموذج ResNet، بتغليف فئة ResNet من
<a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">مكتبة timm</a> داخل <code>PreTrainedModel</code>.`,xl,N,El,k,st="لنبدأ بكتابة إعدادات النموذج. إعدادات النموذج هو كائنٌ يحتوي على جميع المعلومات اللازمة لبنائه. كما سنرى لاحقًا، يتطلب النموذج كائن <code>config</code> لتهيئته، لذا يجب أن يكون هذا الكائن كاملاً.",Hl,I,zl,B,nt="في مثالنا، سنعدّل بعض الوسائط في فئة ResNet التي قد نرغب في ضبطها. ستعطينا التكوينات المختلفة أنواع ResNets المختلفة الممكنة. سنقوم بتخزين هذه الوسائط بعد التحقق من صحته.",Fl,W,Ll,v,Mt="الأشياء الثلاثة المهمة التي يجب تذكرها عند كتابة تكوينك الخاص هي:",ql,R,at="<li>يجب أن ترث من <code>PretrainedConfig</code>،</li> <li>يجب أن تقبل دالة  <code>__init__</code> الخاصة بـ <code>PretrainedConfig</code> أي معامﻻت إضافية kwargs،</li> <li>يجب تمرير هذه المعامﻻت الإضافية إلى دالة <code>__init__</code> فى الفئة الأساسية الاعلى.</li>",Sl,X,pt="يضمن الإرث حصولك على جميع الوظائف من مكتبة 🤗 Transformers، في حين أن القيدين التانى والثالث يأتيان من حقيقة أن <code>PretrainedConfig</code> لديه المزيد من الحقول أكثر من تلك التي تقوم بتعيينها. عند إعادة تحميل تكوين باستخدام طريقة <code>from_pretrained</code>، يجب أن يقبل تكوينك هذه الحقول ثم إرسالها إلى الفئة الأساسية الأعلى.",Pl,V,it=`تحديد <code>model_type</code> لتكوينك (هنا <code>model_type=&quot;resnet&quot;</code>) ليس إلزاميًا، ما لم ترغب في
تسجيل نموذجك باستخدام الفئات التلقائية (راجع القسم الأخير).`,Dl,G,yt=`مع القيام بذلك، يمكنك بسهولة إنشاء تكوينك وحفظه مثلما تفعل مع أي تكوين نموذج آخر في
المكتبة. إليك كيفية إنشاء تكوين resnet50d وحفظه:`,Kl,Q,Ol,Y,ot=`سيؤدي هذا إلى حفظ ملف باسم <code>config.json</code> داخل مجلد <code>custom-resnet</code>. يمكنك بعد ذلك إعادة تحميل تكوينك باستخدام
طريقة <code>from_pretrained</code>:`,le,x,ee,E,ct="يمكنك أيضًا استخدام أي طريقة أخرى من فئة <code>PretrainedConfig</code>، مثل <code>push_to_hub()</code> لتحميل تكوينك مباشرة إلى Hub.",te,H,se,z,Jt="الآن بعد أن أصبح لدينا تكوين ResNet، يمكننا المتابعة لإنشاء نموذجين: الأول يستخرج الميزات المخفية  من دفعة من الصور (مثل <code>BertModel</code>) والآخر مناسب لتصنيف الصور (مثل <code>BertForSequenceClassification</code>).",ne,F,mt="كما ذكرنا سابقًا، سنقوم ببناء نموذج مبسط لتسهيل الفهم في هذا المثال. الخطوة الوحيدة المطلوبة قبل كتابة هذه الفئة هي لربط أنواع وحدات البناء بفئات ذات وحدات بناء فعلية. بعد ذلك، يُعرّف النموذج من خلال التكوين عبر تمرير كل شيء إلى فئة <code>ResNet</code>:",Me,L,ae,q,Tt="بالنسبة للنموذج الذي سيصنف الصور، فإننا نغير فقط طريقة التقديم:",pe,S,ie,P,dt="في كلتا الحالتين، لاحظ كيف نرث من <code>PreTrainedModel</code> ونستدعي مُهيئ الفئة الرئيسية باستخدام <code>config</code> (كما تفعل عند إنشاء وحدة <code>torch.nn.Module</code> عادية). ليس من الضروري تعريف <code>config_class</code> إلا إذا كنت ترغب في تسجيل نموذجك مع الفئات التلقائية (راجع القسم الأخير).",ye,_,oe,D,wt=`يمكن لنموذجك أن يعيد أي شيء تريده، ولكن إعادة قاموس مثلما فعلنا لـ
<code>ResnetModelForImageClassification</code>، مع تضمين الخسارة عند تمرير العلامات، سيجعل نموذجك قابلًا للاستخدام مباشرة داخل فئة <code>Trainer</code>. يعد استخدام تنسيق إخراج آخر أمرًا جيدًا طالما أنك تخطط لاستخدام حلقة تدريب خاصة بك أو مكتبة أخرى للتدريب.`,ce,K,jt="الآن بعد أن أصبح لدينا فئة النموذج، دعنا ننشئ واحدة:",Je,O,me,ll,rt=`يمكنك استخدام أي من طرق فئة <code>PreTrainedModel</code>، مثل <code>save_pretrained()</code> أو
<code>push_to_hub()</code>. سنستخدم الثاني في القسم التالي، وسنرى كيفية دفع أوزان النموذج مع كود نموذجنا. ولكن أولاً، دعنا نحمل بعض الأوزان المُعلمة مسبقًا داخل نموذجنا.`,Te,el,Ut=`في حالة الاستخدام الخاصة بك، فمن المحتمل أن تقوم بتدريب نموذجك المخصص على بياناتك الخاصة. للانتقال بسرعة خلال هذا البرنامج التعليمي،
سنستخدم الإصدار المُعلم مسبقًا من resnet50d. نظرًا لأن نموذجنا هو مجرد غلاف حوله، فمن السهل نقل هذه الأوزان:`,de,tl,we,sl,ft="الآن دعونا نرى كيفية التأكد من أنه عند قيامنا بـ <code>save_pretrained()</code> أو <code>push_to_hub()</code>، يتم حفظ كود النموذج.",je,nl,re,Ml,ut="إذا كنت تكتب مكتبة توسع 🤗 Transformers، فقد ترغب في توسيع الفئات التلقائية لتشمل نموذجك الخاص. يختلف هذا عن نشر الكود إلى Hub بمعنى أن المستخدمين سيحتاجون إلى استيراد مكتبتك للحصول على النماذج المخصصة (على عكس تنزيل كود النموذج تلقائيًا من Hub).",Ue,al,Ct="ما دام تكوينك يحتوي على معامل  <code>model_type</code> مختلفة عن أنواع النماذج الحالية، وأن فئات نماذجك لديك لديها الخصائص الصحيحة <code>config_class</code>، فيمكنك ببساطة إضافتها إلى الفئات التلقائية مثل هذا:",fe,pl,ue,il,bt=`لاحظ أن الحجة الأولى المستخدمة عند تسجيل تكوينك المخصص لـ <code>AutoConfig</code> يجب أن تتطابق مع <code>model_type</code>
من تكوينك المخصص، والحجة الأولى المستخدمة عند تسجيل نماذجك المخصصة لأي فئة نموذج تلقائي يجب
أن تتطابق مع <code>config_class</code> من تلك النماذج.`,Ce,yl,be,Z,Ie,ol,It="أولاً، تأكد من تعريف نموذجك بالكامل في ملف <code>.py</code>. يمكن أن يعتمد على الاستيراد النسبي لملفات أخرى طالما أن جميع الملفات موجودة في نفس الدليل (لا ندعم الوحدات الفرعية لهذه الميزة حتى الآن). في مثالنا، سنحدد ملف <code>modeling_resnet.py</code> وملف <code>configuration_resnet.py</code> في مجلد باسم “resnet_model” في دليل العمل الحالي. يحتوي ملف التكوين على كود لـ <code>ResnetConfig</code> ويحتوي ملف النمذجة على كود لـ <code>ResnetModel</code> و<code>ResnetModelForImageClassification</code>.",_e,cl,Ze,Jl,_t="يمكن أن يكون ملف <code>__init__.py</code> فارغًا، فهو موجود فقط حتى يتمكن Python من اكتشاف أن <code>resnet_model</code> يمكن استخدامه كموديل.",$e,$,he,ml,Zt="لاحظ أنه يمكنك إعادة استخدام (أو توسيع) تكوين/نموذج موجود.",Ae,Tl,$t="لمشاركة نموذجك مع المجتمع، اتبع الخطوات التالية: أولاً، قم باستيراد نموذج ResNet والتكوين من الملفات التي تم إنشاؤها حديثًا:",ge,dl,Ne,wl,ht=`بعد ذلك، يجب عليك إخبار المكتبة بأنك تريد نسخ ملفات الكود الخاصة بهذه الكائنات عند استخدام طريقة <code>save_pretrained</code>
وتسجيلها بشكل صحيح باستخدام فئة تلقائية (خاصة للنماذج)، ما عليك سوى تشغيل:`,ke,jl,Be,rl,At=`لاحظ أنه لا توجد حاجة لتحديد فئة تلقائية للتكوين (هناك فئة تلقائية واحدة فقط لها،
<code>AutoConfig</code>) ولكن الأمر يختلف بالنسبة للنماذج. قد يكون نموذجك المخصص مناسبًا للعديد من المهام المختلفة، لذلك يجب
تحديد أي من الفئات التلقائية هو الصحيح لنموذجك.`,We,h,ve,Ul,gt="بعد ذلك، دعنا نقوم بإنشاء التكوين والنماذج كما فعلنا من قبل:",Re,fl,Xe,ul,Nt="الآن لإرسال النموذج إلى Hub، تأكد من تسجيل الدخول. إما تشغيل في المحطة الأوامر الطرفية الخاصة بك:",Ve,Cl,Ge,bl,kt="أو من دفتر ملاحظات:",Qe,Il,Ye,_l,Bt="يمكنك بعد ذلك الضغط على مساحة الاسم الخاصة بك (أو منظمة أنت عضو فيها) مثل هذا:",xe,Zl,Ee,$l,Wt='بالإضافة إلى أوزان النمذجة والتكوين بتنسيق json، فقد قام هذا أيضًا بنسخ ملفات النمذجة والتكوين <code>.py</code> في مجلد <code>custom-resnet50d</code> وتحميل النتيجة إلى Hub. يمكنك التحقق من النتيجة في هذا <a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">مستودع النموذج</a>.',He,hl,vt='راجع <a href="model_sharing">البرنامج التعليمي للمشاركة</a> لمزيد من المعلومات حول طريقة الدفع إلى المحور.',ze,Al,Fe,gl,Rt='يمكنك استخدام أي تكوين أو نموذج أو مقسم لغوي مع ملفات برمجة مخصصة في مستودعه باستخدام الفئات التلقائية و دالة <code>from_pretrained</code>.تُفحص جميع الملفات والرموز المرفوع إلى Hub بحثًا عن البرامج الضارة (راجع وثائق <a href="https://huggingface.co/docs/hub/security#malware-scanning" rel="nofollow">أمان Hub</a> لمزيد من المعلومات)، ولكن يجب عليك مراجعة كود النموذج والمؤلف لتجنب تنفيذ التعليمات البرمجية الضارة على جهازك. لتفعيل نموذج يحتوي على شفرة برمجية مخصصة،  عيّن <code>trust_remote_code=True</code>:',Le,Nl,qe,kl,Xt="يُنصح بشدة بتحديد رقم إصدار (commit hash) كـ <code>revision</code>  للتأكد من عدم تعديل مؤلف النموذج للشفرة لاحقًابإضافة أسطر ضارة  (إلا إذا كنت تثق تمامًا بمؤلفي النموذج):",Se,Bl,Pe,Wl,Vt="لاحظ وجود زرّ لنسخ رقم إصدار بسهولة عند تصفح سجل التزامات مستودع النموذج على منصة Hugging Face.",De,vl,Ke,Xl,Oe;return C=new Rl({props:{title:"بناء نماذج مخصصة",local:"بناء-نماذج-مخصصة",headingTag:"h1"}}),N=new Rl({props:{title:"كتابة إعدادات مخصصة",local:"كتابة-إعدادات-مخصصة",headingTag:"h2"}}),I=new Vl({props:{$$slots:{default:[Ot]},$$scope:{ctx:u}}}),W=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`,wrap:!1}}),Q=new f({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`,wrap:!1}}),x=new f({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)',wrap:!1}}),H=new Rl({props:{title:"كتابة نموذج مخصص",local:"كتابة-نموذج-مخصص",headingTag:"h2"}}),L=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`,wrap:!1}}),S=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),_=new Vl({props:{$$slots:{default:[ls]},$$scope:{ctx:u}}}),O=new f({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)",wrap:!1}}),tl=new f({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),nl=new Rl({props:{title:"تسجيل نموذج مع كود مخصص للفئات التلقائية",local:"تسجيل-نموذج-مع-كود-مخصص-للفئات-التلقائية",headingTag:"h2"}}),pl=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`,wrap:!1}}),yl=new Rl({props:{title:"إرسال الكود إلى Hub",local:"إرسال-الكود-إلى-hub",headingTag:"h2"}}),Z=new Vl({props:{warning:!0,$$slots:{default:[es]},$$scope:{ctx:u}}}),cl=new f({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── configuration_resnet.<span class="hljs-keyword">py</span>
    └── modeling_resnet.<span class="hljs-keyword">py</span>`,wrap:!1}}),$=new Vl({props:{warning:!0,$$slots:{default:[ts]},$$scope:{ctx:u}}}),dl=new f({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`,wrap:!1}}),jl=new f({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`,wrap:!1}}),h=new Vl({props:{$$slots:{default:[ss]},$$scope:{ctx:u}}}),fl=new f({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),Cl=new f({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),Il=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),Zl=new f({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)',wrap:!1}}),Al=new Rl({props:{title:"استخدام نموذج مع كود مخصص",local:"استخدام-نموذج-مع-كود-مخصص",headingTag:"h3"}}),Nl=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),Bl=new f({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiVEOCU4QyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSVEOCU4QyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>، trust_remote_code=<span class="hljs-literal">True</span>، revision=commit_hash
)`,wrap:!1}}),vl=new Kt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ar/custom_models.md"}}),{c(){a=p("meta"),r=n(),o=p("p"),j=n(),c(C.$$.fragment),U=n(),b=p("p"),b.textContent=lt,Ql=n(),A=p("p"),A.textContent=et,Yl=n(),g=p("p"),g.innerHTML=tt,xl=n(),c(N.$$.fragment),El=n(),k=p("p"),k.innerHTML=st,Hl=n(),c(I.$$.fragment),zl=n(),B=p("p"),B.textContent=nt,Fl=n(),c(W.$$.fragment),Ll=n(),v=p("p"),v.textContent=Mt,ql=n(),R=p("ul"),R.innerHTML=at,Sl=n(),X=p("p"),X.innerHTML=pt,Pl=n(),V=p("p"),V.innerHTML=it,Dl=n(),G=p("p"),G.textContent=yt,Kl=n(),c(Q.$$.fragment),Ol=n(),Y=p("p"),Y.innerHTML=ot,le=n(),c(x.$$.fragment),ee=n(),E=p("p"),E.innerHTML=ct,te=n(),c(H.$$.fragment),se=n(),z=p("p"),z.innerHTML=Jt,ne=n(),F=p("p"),F.innerHTML=mt,Me=n(),c(L.$$.fragment),ae=n(),q=p("p"),q.textContent=Tt,pe=n(),c(S.$$.fragment),ie=n(),P=p("p"),P.innerHTML=dt,ye=n(),c(_.$$.fragment),oe=n(),D=p("p"),D.innerHTML=wt,ce=n(),K=p("p"),K.textContent=jt,Je=n(),c(O.$$.fragment),me=n(),ll=p("p"),ll.innerHTML=rt,Te=n(),el=p("p"),el.textContent=Ut,de=n(),c(tl.$$.fragment),we=n(),sl=p("p"),sl.innerHTML=ft,je=n(),c(nl.$$.fragment),re=n(),Ml=p("p"),Ml.textContent=ut,Ue=n(),al=p("p"),al.innerHTML=Ct,fe=n(),c(pl.$$.fragment),ue=n(),il=p("p"),il.innerHTML=bt,Ce=n(),c(yl.$$.fragment),be=n(),c(Z.$$.fragment),Ie=n(),ol=p("p"),ol.innerHTML=It,_e=n(),c(cl.$$.fragment),Ze=n(),Jl=p("p"),Jl.innerHTML=_t,$e=n(),c($.$$.fragment),he=n(),ml=p("p"),ml.textContent=Zt,Ae=n(),Tl=p("p"),Tl.textContent=$t,ge=n(),c(dl.$$.fragment),Ne=n(),wl=p("p"),wl.innerHTML=ht,ke=n(),c(jl.$$.fragment),Be=n(),rl=p("p"),rl.innerHTML=At,We=n(),c(h.$$.fragment),ve=n(),Ul=p("p"),Ul.textContent=gt,Re=n(),c(fl.$$.fragment),Xe=n(),ul=p("p"),ul.textContent=Nt,Ve=n(),c(Cl.$$.fragment),Ge=n(),bl=p("p"),bl.textContent=kt,Qe=n(),c(Il.$$.fragment),Ye=n(),_l=p("p"),_l.textContent=Bt,xe=n(),c(Zl.$$.fragment),Ee=n(),$l=p("p"),$l.innerHTML=Wt,He=n(),hl=p("p"),hl.innerHTML=vt,ze=n(),c(Al.$$.fragment),Fe=n(),gl=p("p"),gl.innerHTML=Rt,Le=n(),c(Nl.$$.fragment),qe=n(),kl=p("p"),kl.innerHTML=Xt,Se=n(),c(Bl.$$.fragment),Pe=n(),Wl=p("p"),Wl.textContent=Vt,De=n(),c(vl.$$.fragment),Ke=n(),Xl=p("p"),this.h()},l(l){const e=Pt("svelte-u9bgzb",document.head);a=i(e,"META",{name:!0,content:!0}),e.forEach(t),r=M(l),o=i(l,"P",{}),Ht(o).forEach(t),j=M(l),J(C.$$.fragment,l),U=M(l),b=i(l,"P",{"data-svelte-h":!0}),y(b)!=="svelte-hd5nwu"&&(b.textContent=lt),Ql=M(l),A=i(l,"P",{"data-svelte-h":!0}),y(A)!=="svelte-usx0fo"&&(A.textContent=et),Yl=M(l),g=i(l,"P",{"data-svelte-h":!0}),y(g)!=="svelte-ebeamv"&&(g.innerHTML=tt),xl=M(l),J(N.$$.fragment,l),El=M(l),k=i(l,"P",{"data-svelte-h":!0}),y(k)!=="svelte-1y3kqgf"&&(k.innerHTML=st),Hl=M(l),J(I.$$.fragment,l),zl=M(l),B=i(l,"P",{"data-svelte-h":!0}),y(B)!=="svelte-ssuif8"&&(B.textContent=nt),Fl=M(l),J(W.$$.fragment,l),Ll=M(l),v=i(l,"P",{"data-svelte-h":!0}),y(v)!=="svelte-1cq80su"&&(v.textContent=Mt),ql=M(l),R=i(l,"UL",{"data-svelte-h":!0}),y(R)!=="svelte-1w9g9g0"&&(R.innerHTML=at),Sl=M(l),X=i(l,"P",{"data-svelte-h":!0}),y(X)!=="svelte-17kl9ie"&&(X.innerHTML=pt),Pl=M(l),V=i(l,"P",{"data-svelte-h":!0}),y(V)!=="svelte-wp58rx"&&(V.innerHTML=it),Dl=M(l),G=i(l,"P",{"data-svelte-h":!0}),y(G)!=="svelte-18w81nd"&&(G.textContent=yt),Kl=M(l),J(Q.$$.fragment,l),Ol=M(l),Y=i(l,"P",{"data-svelte-h":!0}),y(Y)!=="svelte-nrhv2d"&&(Y.innerHTML=ot),le=M(l),J(x.$$.fragment,l),ee=M(l),E=i(l,"P",{"data-svelte-h":!0}),y(E)!=="svelte-1pyqvjd"&&(E.innerHTML=ct),te=M(l),J(H.$$.fragment,l),se=M(l),z=i(l,"P",{"data-svelte-h":!0}),y(z)!=="svelte-bmwsim"&&(z.innerHTML=Jt),ne=M(l),F=i(l,"P",{"data-svelte-h":!0}),y(F)!=="svelte-rx85by"&&(F.innerHTML=mt),Me=M(l),J(L.$$.fragment,l),ae=M(l),q=i(l,"P",{"data-svelte-h":!0}),y(q)!=="svelte-11ewkcr"&&(q.textContent=Tt),pe=M(l),J(S.$$.fragment,l),ie=M(l),P=i(l,"P",{"data-svelte-h":!0}),y(P)!=="svelte-25oqdj"&&(P.innerHTML=dt),ye=M(l),J(_.$$.fragment,l),oe=M(l),D=i(l,"P",{"data-svelte-h":!0}),y(D)!=="svelte-gi4gi9"&&(D.innerHTML=wt),ce=M(l),K=i(l,"P",{"data-svelte-h":!0}),y(K)!=="svelte-e4ndfe"&&(K.textContent=jt),Je=M(l),J(O.$$.fragment,l),me=M(l),ll=i(l,"P",{"data-svelte-h":!0}),y(ll)!=="svelte-qbig14"&&(ll.innerHTML=rt),Te=M(l),el=i(l,"P",{"data-svelte-h":!0}),y(el)!=="svelte-hk6ree"&&(el.textContent=Ut),de=M(l),J(tl.$$.fragment,l),we=M(l),sl=i(l,"P",{"data-svelte-h":!0}),y(sl)!=="svelte-923bt"&&(sl.innerHTML=ft),je=M(l),J(nl.$$.fragment,l),re=M(l),Ml=i(l,"P",{"data-svelte-h":!0}),y(Ml)!=="svelte-96thec"&&(Ml.textContent=ut),Ue=M(l),al=i(l,"P",{"data-svelte-h":!0}),y(al)!=="svelte-16azhm4"&&(al.innerHTML=Ct),fe=M(l),J(pl.$$.fragment,l),ue=M(l),il=i(l,"P",{"data-svelte-h":!0}),y(il)!=="svelte-t00tcn"&&(il.innerHTML=bt),Ce=M(l),J(yl.$$.fragment,l),be=M(l),J(Z.$$.fragment,l),Ie=M(l),ol=i(l,"P",{"data-svelte-h":!0}),y(ol)!=="svelte-1p733tx"&&(ol.innerHTML=It),_e=M(l),J(cl.$$.fragment,l),Ze=M(l),Jl=i(l,"P",{"data-svelte-h":!0}),y(Jl)!=="svelte-3df7i6"&&(Jl.innerHTML=_t),$e=M(l),J($.$$.fragment,l),he=M(l),ml=i(l,"P",{"data-svelte-h":!0}),y(ml)!=="svelte-1huo93w"&&(ml.textContent=Zt),Ae=M(l),Tl=i(l,"P",{"data-svelte-h":!0}),y(Tl)!=="svelte-9nv0fy"&&(Tl.textContent=$t),ge=M(l),J(dl.$$.fragment,l),Ne=M(l),wl=i(l,"P",{"data-svelte-h":!0}),y(wl)!=="svelte-1tw2k0c"&&(wl.innerHTML=ht),ke=M(l),J(jl.$$.fragment,l),Be=M(l),rl=i(l,"P",{"data-svelte-h":!0}),y(rl)!=="svelte-1c7lco5"&&(rl.innerHTML=At),We=M(l),J(h.$$.fragment,l),ve=M(l),Ul=i(l,"P",{"data-svelte-h":!0}),y(Ul)!=="svelte-g0gfwo"&&(Ul.textContent=gt),Re=M(l),J(fl.$$.fragment,l),Xe=M(l),ul=i(l,"P",{"data-svelte-h":!0}),y(ul)!=="svelte-g4kard"&&(ul.textContent=Nt),Ve=M(l),J(Cl.$$.fragment,l),Ge=M(l),bl=i(l,"P",{"data-svelte-h":!0}),y(bl)!=="svelte-1cm7m6l"&&(bl.textContent=kt),Qe=M(l),J(Il.$$.fragment,l),Ye=M(l),_l=i(l,"P",{"data-svelte-h":!0}),y(_l)!=="svelte-wpz2x2"&&(_l.textContent=Bt),xe=M(l),J(Zl.$$.fragment,l),Ee=M(l),$l=i(l,"P",{"data-svelte-h":!0}),y($l)!=="svelte-5cmpld"&&($l.innerHTML=Wt),He=M(l),hl=i(l,"P",{"data-svelte-h":!0}),y(hl)!=="svelte-1dadkpy"&&(hl.innerHTML=vt),ze=M(l),J(Al.$$.fragment,l),Fe=M(l),gl=i(l,"P",{"data-svelte-h":!0}),y(gl)!=="svelte-bskqd7"&&(gl.innerHTML=Rt),Le=M(l),J(Nl.$$.fragment,l),qe=M(l),kl=i(l,"P",{"data-svelte-h":!0}),y(kl)!=="svelte-12jcqhz"&&(kl.innerHTML=Xt),Se=M(l),J(Bl.$$.fragment,l),Pe=M(l),Wl=i(l,"P",{"data-svelte-h":!0}),y(Wl)!=="svelte-118hrnx"&&(Wl.textContent=Vt),De=M(l),J(vl.$$.fragment,l),Ke=M(l),Xl=i(l,"P",{}),Ht(Xl).forEach(t),this.h()},h(){zt(a,"name","hf:doc:metadata"),zt(a,"content",Ms)},m(l,e){Dt(document.head,a),s(l,r,e),s(l,o,e),s(l,j,e),m(C,l,e),s(l,U,e),s(l,b,e),s(l,Ql,e),s(l,A,e),s(l,Yl,e),s(l,g,e),s(l,xl,e),m(N,l,e),s(l,El,e),s(l,k,e),s(l,Hl,e),m(I,l,e),s(l,zl,e),s(l,B,e),s(l,Fl,e),m(W,l,e),s(l,Ll,e),s(l,v,e),s(l,ql,e),s(l,R,e),s(l,Sl,e),s(l,X,e),s(l,Pl,e),s(l,V,e),s(l,Dl,e),s(l,G,e),s(l,Kl,e),m(Q,l,e),s(l,Ol,e),s(l,Y,e),s(l,le,e),m(x,l,e),s(l,ee,e),s(l,E,e),s(l,te,e),m(H,l,e),s(l,se,e),s(l,z,e),s(l,ne,e),s(l,F,e),s(l,Me,e),m(L,l,e),s(l,ae,e),s(l,q,e),s(l,pe,e),m(S,l,e),s(l,ie,e),s(l,P,e),s(l,ye,e),m(_,l,e),s(l,oe,e),s(l,D,e),s(l,ce,e),s(l,K,e),s(l,Je,e),m(O,l,e),s(l,me,e),s(l,ll,e),s(l,Te,e),s(l,el,e),s(l,de,e),m(tl,l,e),s(l,we,e),s(l,sl,e),s(l,je,e),m(nl,l,e),s(l,re,e),s(l,Ml,e),s(l,Ue,e),s(l,al,e),s(l,fe,e),m(pl,l,e),s(l,ue,e),s(l,il,e),s(l,Ce,e),m(yl,l,e),s(l,be,e),m(Z,l,e),s(l,Ie,e),s(l,ol,e),s(l,_e,e),m(cl,l,e),s(l,Ze,e),s(l,Jl,e),s(l,$e,e),m($,l,e),s(l,he,e),s(l,ml,e),s(l,Ae,e),s(l,Tl,e),s(l,ge,e),m(dl,l,e),s(l,Ne,e),s(l,wl,e),s(l,ke,e),m(jl,l,e),s(l,Be,e),s(l,rl,e),s(l,We,e),m(h,l,e),s(l,ve,e),s(l,Ul,e),s(l,Re,e),m(fl,l,e),s(l,Xe,e),s(l,ul,e),s(l,Ve,e),m(Cl,l,e),s(l,Ge,e),s(l,bl,e),s(l,Qe,e),m(Il,l,e),s(l,Ye,e),s(l,_l,e),s(l,xe,e),m(Zl,l,e),s(l,Ee,e),s(l,$l,e),s(l,He,e),s(l,hl,e),s(l,ze,e),m(Al,l,e),s(l,Fe,e),s(l,gl,e),s(l,Le,e),m(Nl,l,e),s(l,qe,e),s(l,kl,e),s(l,Se,e),m(Bl,l,e),s(l,Pe,e),s(l,Wl,e),s(l,De,e),m(vl,l,e),s(l,Ke,e),s(l,Xl,e),Oe=!0},p(l,[e]){const Gt={};e&2&&(Gt.$$scope={dirty:e,ctx:l}),I.$set(Gt);const Qt={};e&2&&(Qt.$$scope={dirty:e,ctx:l}),_.$set(Qt);const Yt={};e&2&&(Yt.$$scope={dirty:e,ctx:l}),Z.$set(Yt);const xt={};e&2&&(xt.$$scope={dirty:e,ctx:l}),$.$set(xt);const Et={};e&2&&(Et.$$scope={dirty:e,ctx:l}),h.$set(Et)},i(l){Oe||(T(C.$$.fragment,l),T(N.$$.fragment,l),T(I.$$.fragment,l),T(W.$$.fragment,l),T(Q.$$.fragment,l),T(x.$$.fragment,l),T(H.$$.fragment,l),T(L.$$.fragment,l),T(S.$$.fragment,l),T(_.$$.fragment,l),T(O.$$.fragment,l),T(tl.$$.fragment,l),T(nl.$$.fragment,l),T(pl.$$.fragment,l),T(yl.$$.fragment,l),T(Z.$$.fragment,l),T(cl.$$.fragment,l),T($.$$.fragment,l),T(dl.$$.fragment,l),T(jl.$$.fragment,l),T(h.$$.fragment,l),T(fl.$$.fragment,l),T(Cl.$$.fragment,l),T(Il.$$.fragment,l),T(Zl.$$.fragment,l),T(Al.$$.fragment,l),T(Nl.$$.fragment,l),T(Bl.$$.fragment,l),T(vl.$$.fragment,l),Oe=!0)},o(l){d(C.$$.fragment,l),d(N.$$.fragment,l),d(I.$$.fragment,l),d(W.$$.fragment,l),d(Q.$$.fragment,l),d(x.$$.fragment,l),d(H.$$.fragment,l),d(L.$$.fragment,l),d(S.$$.fragment,l),d(_.$$.fragment,l),d(O.$$.fragment,l),d(tl.$$.fragment,l),d(nl.$$.fragment,l),d(pl.$$.fragment,l),d(yl.$$.fragment,l),d(Z.$$.fragment,l),d(cl.$$.fragment,l),d($.$$.fragment,l),d(dl.$$.fragment,l),d(jl.$$.fragment,l),d(h.$$.fragment,l),d(fl.$$.fragment,l),d(Cl.$$.fragment,l),d(Il.$$.fragment,l),d(Zl.$$.fragment,l),d(Al.$$.fragment,l),d(Nl.$$.fragment,l),d(Bl.$$.fragment,l),d(vl.$$.fragment,l),Oe=!1},d(l){l&&(t(r),t(o),t(j),t(U),t(b),t(Ql),t(A),t(Yl),t(g),t(xl),t(El),t(k),t(Hl),t(zl),t(B),t(Fl),t(Ll),t(v),t(ql),t(R),t(Sl),t(X),t(Pl),t(V),t(Dl),t(G),t(Kl),t(Ol),t(Y),t(le),t(ee),t(E),t(te),t(se),t(z),t(ne),t(F),t(Me),t(ae),t(q),t(pe),t(ie),t(P),t(ye),t(oe),t(D),t(ce),t(K),t(Je),t(me),t(ll),t(Te),t(el),t(de),t(we),t(sl),t(je),t(re),t(Ml),t(Ue),t(al),t(fe),t(ue),t(il),t(Ce),t(be),t(Ie),t(ol),t(_e),t(Ze),t(Jl),t($e),t(he),t(ml),t(Ae),t(Tl),t(ge),t(Ne),t(wl),t(ke),t(Be),t(rl),t(We),t(ve),t(Ul),t(Re),t(Xe),t(ul),t(Ve),t(Ge),t(bl),t(Qe),t(Ye),t(_l),t(xe),t(Ee),t($l),t(He),t(hl),t(ze),t(Fe),t(gl),t(Le),t(qe),t(kl),t(Se),t(Pe),t(Wl),t(De),t(Ke),t(Xl)),t(a),w(C,l),w(N,l),w(I,l),w(W,l),w(Q,l),w(x,l),w(H,l),w(L,l),w(S,l),w(_,l),w(O,l),w(tl,l),w(nl,l),w(pl,l),w(yl,l),w(Z,l),w(cl,l),w($,l),w(dl,l),w(jl,l),w(h,l),w(fl,l),w(Cl,l),w(Il,l),w(Zl,l),w(Al,l),w(Nl,l),w(Bl,l),w(vl,l)}}}const Ms='{"title":"بناء نماذج مخصصة","local":"بناء-نماذج-مخصصة","sections":[{"title":"كتابة إعدادات مخصصة","local":"كتابة-إعدادات-مخصصة","sections":[],"depth":2},{"title":"كتابة نموذج مخصص","local":"كتابة-نموذج-مخصص","sections":[],"depth":2},{"title":"تسجيل نموذج مع كود مخصص للفئات التلقائية","local":"تسجيل-نموذج-مع-كود-مخصص-للفئات-التلقائية","sections":[],"depth":2},{"title":"إرسال الكود إلى Hub","local":"إرسال-الكود-إلى-hub","sections":[{"title":"استخدام نموذج مع كود مخصص","local":"استخدام-نموذج-مع-كود-مخصص","sections":[],"depth":3}],"depth":2}],"depth":1}';function as(u){return Lt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Js extends qt{constructor(a){super(),St(this,a,as,ns,Ft,{})}}export{Js as component};
