import{s as no,o as ao,n as Q}from"../chunks/scheduler.25b97de1.js";import{S as so,i as ro,g as l,s,r as f,A as io,h as c,f as n,c as r,j,u as g,x as u,k as J,y as i,a as d,v as _,d as b,t as y,w as T}from"../chunks/index.d9030fc9.js";import{T as Ze}from"../chunks/Tip.baa67368.js";import{D as N}from"../chunks/Docstring.ffac8efa.js";import{C as jt}from"../chunks/CodeBlock.e6cd0d95.js";import{E as qt}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as ke,E as lo}from"../chunks/EditOnGithub.91d95064.js";function co(v){let t,h='<li>Gemma2 uses sliding window attention every second layer, which makes it unsuitable for typical kv caching with <a href="/docs/transformers/main/en/internal/generation_utils#transformers.DynamicCache">~DynamicCache</a> or tuples of tensors. To enable caching in Gemma2 forward call, you must initialize a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.HybridCache">~HybridCache</a> instance and pass it as <code>past_key_values</code> to the forward call. Note, that you also have to prepare <code>cache_position</code> if the <code>past_key_values</code> already contains previous keys and values.</li>';return{c(){t=l("ul"),t.innerHTML=h},l(a){t=c(a,"UL",{"data-svelte-h":!0}),u(t)!=="svelte-hu8gpo"&&(t.innerHTML=h)},m(a,p){d(a,t,p)},p:Q,d(a){a&&n(t)}}}function mo(v){let t,h;return t=new jt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdlbW1hMk1vZGVsJTJDJTIwR2VtbWEyQ29uZmlnJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMEdlbW1hMiUyMGdlbW1hMi03YiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBHZW1tYTJDb25maWcoKSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBnZW1tYTItN2IlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMEdlbW1hMk1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Gemma2Model, Gemma2Config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Gemma2 gemma2-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Gemma2Config()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the gemma2-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Gemma2Model(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){f(t.$$.fragment)},l(a){g(t.$$.fragment,a)},m(a,p){_(t,a,p),h=!0},p:Q,i(a){h||(b(t.$$.fragment,a),h=!0)},o(a){y(t.$$.fragment,a),h=!1},d(a){T(t,a)}}}function po(v){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=l("p"),t.innerHTML=h},l(a){t=c(a,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(a,p){d(a,t,p)},p:Q,d(a){a&&n(t)}}}function ho(v){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=l("p"),t.innerHTML=h},l(a){t=c(a,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(a,p){d(a,t,p)},p:Q,d(a){a&&n(t)}}}function uo(v){let t,h="Example:",a,p,w;return p=new jt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBHZW1tYUZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBHZW1tYUZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZnZW1tYS0yLTliJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTItOWIlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMGZhdm9yaXRlJTIwY29uZGltZW50JTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMEFnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMuaW5wdXRfaWRzJTJDJTIwbWF4X2xlbmd0aCUzRDMwKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, GemmaForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = GemmaForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2-9b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2-9b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;What is your favorite condiment?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;What is your favorite condiment?&quot;</span>`,wrap:!1}}),{c(){t=l("p"),t.textContent=h,a=s(),f(p.$$.fragment)},l(m){t=c(m,"P",{"data-svelte-h":!0}),u(t)!=="svelte-11lpom8"&&(t.textContent=h),a=r(m),g(p.$$.fragment,m)},m(m,$){d(m,t,$),d(m,a,$),_(p,m,$),w=!0},p:Q,i(m){w||(b(p.$$.fragment,m),w=!0)},o(m){y(p.$$.fragment,m),w=!1},d(m){m&&(n(t),n(a)),T(p,m)}}}function fo(v){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=l("p"),t.innerHTML=h},l(a){t=c(a,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(a,p){d(a,t,p)},p:Q,d(a){a&&n(t)}}}function go(v){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=l("p"),t.innerHTML=h},l(a){t=c(a,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(a,p){d(a,t,p)},p:Q,d(a){a&&n(t)}}}function _o(v){let t,h="Example:",a,p,w;return p=new jt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBHZW1tYTJGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZnZW1tYTItN2IlMjIpJTBBbW9kZWwlMjAlM0QlMjBHZW1tYTJGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZnZW1tYTItN2IlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCUyMkh1Z2dpbmdGYWNlJTIwaXMlMjBhJTIwY29tcGFueSUyMGJhc2VkJTIwaW4lMjBQYXJpcyUyMGFuZCUyME5ldyUyMFlvcmslMjIlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTIwJTNEJTIwbG9naXRzLmFyZ21heCgtMSklMEElMEElMjMlMjBOb3RlJTIwdGhhdCUyMHRva2VucyUyMGFyZSUyMGNsYXNzaWZpZWQlMjByYXRoZXIlMjB0aGVuJTIwaW5wdXQlMjB3b3JkcyUyMHdoaWNoJTIwbWVhbnMlMjB0aGF0JTBBJTIzJTIwdGhlcmUlMjBtaWdodCUyMGJlJTIwbW9yZSUyMHByZWRpY3RlZCUyMHRva2VuJTIwY2xhc3NlcyUyMHRoYW4lMjB3b3Jkcy4lMEElMjMlMjBNdWx0aXBsZSUyMHRva2VuJTIwY2xhc3NlcyUyMG1pZ2h0JTIwYWNjb3VudCUyMGZvciUyMHRoZSUyMHNhbWUlMjB3b3JkJTBBcHJlZGljdGVkX3Rva2Vuc19jbGFzc2VzJTIwJTNEJTIwJTVCbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCdC5pdGVtKCklNUQlMjBmb3IlMjB0JTIwaW4lMjBwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTVCMCU1RCU1RCUwQSUwQWxhYmVscyUyMCUzRCUyMHByZWRpY3RlZF90b2tlbl9jbGFzc19pZHMlMEFsb3NzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpLmxvc3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Gemma2ForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma2-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Gemma2ForTokenClassification.from_pretrained(<span class="hljs-string">&quot;google/gemma2-7b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFace is a company based in Paris and New York&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_class_ids = logits.argmax(-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that tokens are classified rather then input words which means that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># there might be more predicted token classes than words.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Multiple token classes might account for the same word</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes = [model.config.id2label[t.item()] <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> predicted_token_class_ids[<span class="hljs-number">0</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = predicted_token_class_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=l("p"),t.textContent=h,a=s(),f(p.$$.fragment)},l(m){t=c(m,"P",{"data-svelte-h":!0}),u(t)!=="svelte-11lpom8"&&(t.textContent=h),a=r(m),g(p.$$.fragment,m)},m(m,$){d(m,t,$),d(m,a,$),_(p,m,$),w=!0},p:Q,i(m){w||(b(p.$$.fragment,m),w=!0)},o(m){y(p.$$.fragment,m),w=!1},d(m){m&&(n(t),n(a)),T(p,m)}}}function bo(v){let t,h,a,p,w,m,$,Be,K,Jt=`The Gemma2 model was proposed in <a href="https://blog.google/technology/developers/google-gemma-2/" rel="nofollow">Gemma2: Open Models Based on Gemini Technology and Research</a> by Gemma2 Team, Google.
Two Gemma2 models are released, with parameters sizes of 9 billion (9B) and 27 billion (27B).`,He,ee,Lt="The abstract from the blog post is the following:",Ne,te,Pt="<em>Now we’re officially releasing Gemma 2 to researchers and developers globally. Available in both 9 billion (9B) and 27 billion (27B) parameter sizes, Gemma 2 is higher-performing and more efficient at inference than the first generation, with significant safety advancements built in. In fact, at 27B, it offers competitive alternatives to models more than twice its size, delivering the kind of performance that was only possible with proprietary models as recently as December.</em>",Se,oe,Ut="Tips:",Oe,ne,Zt="<li>The original checkpoints can be converted using the conversion script <code>src/transformers/models/Gemma2/convert_Gemma2_weights_to_hf.py</code></li>",Re,S,Ee,ae,Bt='This model was contributed by <a href="https://huggingface.co/ArthurZ" rel="nofollow">Arthur Zucker</a>, <a href="https://huggingface.co/pcuenq" rel="nofollow">Pedro Cuenca</a> and <a href="">Tom Arsen</a>.',Ve,se,Ye,W,re,rt,ve,Ht=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/gemma2#transformers.Gemma2Model">Gemma2Model</a>. It is used to instantiate an Gemma2
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the Gemma2-7B.
e.g. <a href="https://huggingface.co/google/gemma2-7b" rel="nofollow">google/gemma2-7b</a>
Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,it,O,Ae,ie,Xe,C,de,dt,we,Nt=`The bare Gemma2 Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,lt,Me,St=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ct,$e,Ot="Transformer decoder consisting of <em>config.num_hidden_layers</em> layers. Each layer is a <code>Gemma2DecoderLayer</code>",mt,L,le,pt,Ce,Rt='The <a href="/docs/transformers/main/en/model_doc/gemma2#transformers.Gemma2Model">Gemma2Model</a> forward method, overrides the <code>__call__</code> special method.',ht,R,De,ce,Qe,U,me,ut,I,pe,ft,Ge,Et='The <a href="/docs/transformers/main/en/model_doc/gemma2#transformers.Gemma2ForCausalLM">Gemma2ForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',gt,E,_t,V,Ke,he,et,k,ue,bt,ze,Vt="The Gemma2 Model transformer with a sequence classification head on top (linear layer).",yt,xe,Yt=`<a href="/docs/transformers/main/en/model_doc/gemma2#transformers.Gemma2ForSequenceClassification">Gemma2ForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-2) do.`,Tt,Ie,At=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,kt,Fe,Xt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,vt,We,Dt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,wt,P,fe,Mt,qe,Qt='The <a href="/docs/transformers/main/en/model_doc/gemma2#transformers.Gemma2ForSequenceClassification">Gemma2ForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',$t,Y,tt,ge,ot,G,_e,Ct,je,Kt=`The Gemma2 Model transformer with a token classification head on top (a linear layer on top of the hidden-states
output) e.g. for Named-Entity-Recognition (NER) tasks.`,Gt,Je,eo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,zt,Le,to=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,xt,F,be,It,Pe,oo='The <a href="/docs/transformers/main/en/model_doc/gemma2#transformers.Gemma2ForTokenClassification">Gemma2ForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',Ft,A,Wt,X,nt,ye,at,Ue,st;return w=new ke({props:{title:"Gemma2",local:"gemma2",headingTag:"h1"}}),$=new ke({props:{title:"Overview",local:"overview",headingTag:"h2"}}),S=new Ze({props:{warning:!0,$$slots:{default:[co]},$$scope:{ctx:v}}}),se=new ke({props:{title:"Gemma2Config",local:"transformers.Gemma2Config",headingTag:"h2"}}),re=new N({props:{name:"class transformers.Gemma2Config",anchor:"transformers.Gemma2Config",parameters:[{name:"vocab_size",val:" = 256000"},{name:"hidden_size",val:" = 2304"},{name:"intermediate_size",val:" = 9216"},{name:"num_hidden_layers",val:" = 26"},{name:"num_attention_heads",val:" = 8"},{name:"num_key_value_heads",val:" = 4"},{name:"head_dim",val:" = 256"},{name:"hidden_activation",val:" = 'gelu_pytorch_tanh'"},{name:"max_position_embeddings",val:" = 8192"},{name:"initializer_range",val:" = 0.02"},{name:"rms_norm_eps",val:" = 1e-06"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = 0"},{name:"eos_token_id",val:" = 1"},{name:"bos_token_id",val:" = 2"},{name:"tie_word_embeddings",val:" = True"},{name:"rope_theta",val:" = 10000.0"},{name:"attention_bias",val:" = False"},{name:"attention_dropout",val:" = 0.0"},{name:"query_pre_attn_scalar",val:" = 256"},{name:"sliding_window",val:" = 4096"},{name:"final_logit_softcapping",val:" = 30.0"},{name:"attn_logit_softcapping",val:" = 50.0"},{name:"cache_implementation",val:" = 'hybrid'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Gemma2Config.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256000) &#x2014;
Vocabulary size of the Gemma2 model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/gemma2#transformers.Gemma2Model">Gemma2Model</a>`,name:"vocab_size"},{anchor:"transformers.Gemma2Config.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2304) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.Gemma2Config.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 9216) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.Gemma2Config.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 26) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"num_hidden_layers"},{anchor:"transformers.Gemma2Config.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"num_attention_heads"},{anchor:"transformers.Gemma2Config.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to
<code>num_attention_heads</code>.`,name:"num_key_value_heads"},{anchor:"transformers.Gemma2Config.head_dim",description:`<strong>head_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The attention head dimension.`,name:"head_dim"},{anchor:"transformers.Gemma2Config.hidden_activation",description:`<strong>hidden_activation</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu_pytorch_tanh&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder. Will default to <code>&quot;gelu_pytorch_tanh&quot;</code>
if not specified. <code>&quot;gelu_pytorch_tanh&quot;</code> uses an approximation of the <code>&quot;gelu&quot;</code> activation function.`,name:"hidden_activation"},{anchor:"transformers.Gemma2Config.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
The maximum sequence length that this model might ever be used with.`,name:"max_position_embeddings"},{anchor:"transformers.Gemma2Config.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Gemma2Config.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.Gemma2Config.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.Gemma2Config.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.Gemma2Config.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
End of stream token id.`,name:"eos_token_id"},{anchor:"transformers.Gemma2Config.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.Gemma2Config.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.Gemma2Config.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.Gemma2Config.attention_bias",description:`<strong>attention_bias</strong> (<code>bool</code>, defaults to <code>False</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in the query, key, value and output projection layers during self-attention.`,name:"attention_bias"},{anchor:"transformers.Gemma2Config.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.Gemma2Config.query_pre_attn_scalar",description:"<strong>query_pre_attn_scalar</strong> (<code>float</code>, <em>optional</em>, defaults to 256) &#x2014; scaling factor used on the attention scores",name:"query_pre_attn_scalar"},{anchor:"transformers.Gemma2Config.sliding_window",description:`<strong>sliding_window</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014; in Gemma2, every other layer uses sliding window attention. This is the
size of the sliding window.`,name:"sliding_window"},{anchor:"transformers.Gemma2Config.final_logit_softcapping",description:"<strong>final_logit_softcapping</strong> (<code>float</code>, <em>optional</em>, defaults to 30.0) &#x2014; scaling factor when applying tanh softcapping on the logits.",name:"final_logit_softcapping"},{anchor:"transformers.Gemma2Config.attn_logit_softcapping",description:"<strong>attn_logit_softcapping</strong> (<code>float</code>, <em>optional</em>, defaults to 50.0) &#x2014; scaling factor when applying tanh softcapping on the attention scores.",name:"attn_logit_softcapping"},{anchor:"transformers.Gemma2Config.cache_implementation",description:"<strong>cache_implementation</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;hybrid&quot;</code>) &#x2014; the cache type to be used with <code>generate</code>.",name:"cache_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gemma2/configuration_gemma2.py#L25"}}),O=new qt({props:{anchor:"transformers.Gemma2Config.example",$$slots:{default:[mo]},$$scope:{ctx:v}}}),ie=new ke({props:{title:"Gemma2Model",local:"transformers.Gemma2Model",headingTag:"h2"}}),de=new N({props:{name:"class transformers.Gemma2Model",anchor:"transformers.Gemma2Model",parameters:[{name:"config",val:": Gemma2Config"}],parametersDescription:[{anchor:"transformers.Gemma2Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/gemma2#transformers.Gemma2Config">Gemma2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.
config &#x2014; Gemma2Config`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gemma2/modeling_gemma2.py#L721"}}),le=new N({props:{name:"forward",anchor:"transformers.Gemma2Model.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"cache_position",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Gemma2Model.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Gemma2Model.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Gemma2Model.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Gemma2Model.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Gemma2Model.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Gemma2Model.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Gemma2Model.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Gemma2Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Gemma2Model.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Gemma2Model.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gemma2/modeling_gemma2.py#L754"}}),R=new Ze({props:{$$slots:{default:[po]},$$scope:{ctx:v}}}),ce=new ke({props:{title:"Gemma2ForCausalLM",local:"transformers.Gemma2ForCausalLM",headingTag:"h2"}}),me=new N({props:{name:"class transformers.Gemma2ForCausalLM",anchor:"transformers.Gemma2ForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gemma2/modeling_gemma2.py#L962"}}),pe=new N({props:{name:"forward",anchor:"transformers.Gemma2ForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"cache_position",val:": Optional = None"},{name:"num_logits_to_keep",val:": int = 0"},{name:"**loss_kwargs",val:""}],parametersDescription:[{anchor:"transformers.Gemma2ForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Gemma2ForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Gemma2ForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Gemma2ForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Gemma2ForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Gemma2ForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Gemma2ForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Gemma2ForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Gemma2ForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Gemma2ForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.</p>
<p>num_logits_to_keep (<code>int</code>, <em>optional</em>):
Calculate logits for the last <code>num_logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gemma2/modeling_gemma2.py#L992",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/gemma2#transformers.Gemma2Config"
>Gemma2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),E=new Ze({props:{$$slots:{default:[ho]},$$scope:{ctx:v}}}),V=new qt({props:{anchor:"transformers.Gemma2ForCausalLM.forward.example",$$slots:{default:[uo]},$$scope:{ctx:v}}}),he=new ke({props:{title:"Gemma2ForSequenceClassification",local:"transformers.Gemma2ForSequenceClassification",headingTag:"h2"}}),ue=new N({props:{name:"class transformers.Gemma2ForSequenceClassification",anchor:"transformers.Gemma2ForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Gemma2ForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/gemma2#transformers.Gemma2Config">Gemma2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gemma2/modeling_gemma2.py#L1168"}}),fe=new N({props:{name:"forward",anchor:"transformers.Gemma2ForSequenceClassification.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Union = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Gemma2ForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Gemma2ForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Gemma2ForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Gemma2ForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Gemma2ForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Gemma2ForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Gemma2ForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Gemma2ForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Gemma2ForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Gemma2ForSequenceClassification.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.Gemma2ForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gemma2/modeling_gemma2.py#L1199"}}),Y=new Ze({props:{$$slots:{default:[fo]},$$scope:{ctx:v}}}),ge=new ke({props:{title:"Gemma2ForTokenClassification",local:"transformers.Gemma2ForTokenClassification",headingTag:"h2"}}),_e=new N({props:{name:"class transformers.Gemma2ForTokenClassification",anchor:"transformers.Gemma2ForTokenClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Gemma2ForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/gemma2#transformers.Gemma2Config">Gemma2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gemma2/modeling_gemma2.py#L1272"}}),be=new N({props:{name:"forward",anchor:"transformers.Gemma2ForTokenClassification.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Gemma2ForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Gemma2ForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Gemma2ForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Gemma2ForTokenClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Gemma2ForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Gemma2ForTokenClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Gemma2ForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Gemma2ForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Gemma2ForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Gemma2ForTokenClassification.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.Gemma2ForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gemma2/modeling_gemma2.py#L1302",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/gemma2#transformers.Gemma2Config"
>Gemma2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),A=new Ze({props:{$$slots:{default:[go]},$$scope:{ctx:v}}}),X=new qt({props:{anchor:"transformers.Gemma2ForTokenClassification.forward.example",$$slots:{default:[_o]},$$scope:{ctx:v}}}),ye=new lo({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/gemma2.md"}}),{c(){t=l("meta"),h=s(),a=l("p"),p=s(),f(w.$$.fragment),m=s(),f($.$$.fragment),Be=s(),K=l("p"),K.innerHTML=Jt,He=s(),ee=l("p"),ee.textContent=Lt,Ne=s(),te=l("p"),te.innerHTML=Pt,Se=s(),oe=l("p"),oe.textContent=Ut,Oe=s(),ne=l("ul"),ne.innerHTML=Zt,Re=s(),f(S.$$.fragment),Ee=s(),ae=l("p"),ae.innerHTML=Bt,Ve=s(),f(se.$$.fragment),Ye=s(),W=l("div"),f(re.$$.fragment),rt=s(),ve=l("p"),ve.innerHTML=Ht,it=s(),f(O.$$.fragment),Ae=s(),f(ie.$$.fragment),Xe=s(),C=l("div"),f(de.$$.fragment),dt=s(),we=l("p"),we.innerHTML=Nt,lt=s(),Me=l("p"),Me.innerHTML=St,ct=s(),$e=l("p"),$e.innerHTML=Ot,mt=s(),L=l("div"),f(le.$$.fragment),pt=s(),Ce=l("p"),Ce.innerHTML=Rt,ht=s(),f(R.$$.fragment),De=s(),f(ce.$$.fragment),Qe=s(),U=l("div"),f(me.$$.fragment),ut=s(),I=l("div"),f(pe.$$.fragment),ft=s(),Ge=l("p"),Ge.innerHTML=Et,gt=s(),f(E.$$.fragment),_t=s(),f(V.$$.fragment),Ke=s(),f(he.$$.fragment),et=s(),k=l("div"),f(ue.$$.fragment),bt=s(),ze=l("p"),ze.textContent=Vt,yt=s(),xe=l("p"),xe.innerHTML=Yt,Tt=s(),Ie=l("p"),Ie.innerHTML=At,kt=s(),Fe=l("p"),Fe.innerHTML=Xt,vt=s(),We=l("p"),We.innerHTML=Dt,wt=s(),P=l("div"),f(fe.$$.fragment),Mt=s(),qe=l("p"),qe.innerHTML=Qt,$t=s(),f(Y.$$.fragment),tt=s(),f(ge.$$.fragment),ot=s(),G=l("div"),f(_e.$$.fragment),Ct=s(),je=l("p"),je.textContent=Kt,Gt=s(),Je=l("p"),Je.innerHTML=eo,zt=s(),Le=l("p"),Le.innerHTML=to,xt=s(),F=l("div"),f(be.$$.fragment),It=s(),Pe=l("p"),Pe.innerHTML=oo,Ft=s(),f(A.$$.fragment),Wt=s(),f(X.$$.fragment),nt=s(),f(ye.$$.fragment),at=s(),Ue=l("p"),this.h()},l(e){const o=io("svelte-u9bgzb",document.head);t=c(o,"META",{name:!0,content:!0}),o.forEach(n),h=r(e),a=c(e,"P",{}),j(a).forEach(n),p=r(e),g(w.$$.fragment,e),m=r(e),g($.$$.fragment,e),Be=r(e),K=c(e,"P",{"data-svelte-h":!0}),u(K)!=="svelte-qvin01"&&(K.innerHTML=Jt),He=r(e),ee=c(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-1b31asq"&&(ee.textContent=Lt),Ne=r(e),te=c(e,"P",{"data-svelte-h":!0}),u(te)!=="svelte-rpvfx1"&&(te.innerHTML=Pt),Se=r(e),oe=c(e,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-axv494"&&(oe.textContent=Ut),Oe=r(e),ne=c(e,"UL",{"data-svelte-h":!0}),u(ne)!=="svelte-1khublo"&&(ne.innerHTML=Zt),Re=r(e),g(S.$$.fragment,e),Ee=r(e),ae=c(e,"P",{"data-svelte-h":!0}),u(ae)!=="svelte-1ogb02t"&&(ae.innerHTML=Bt),Ve=r(e),g(se.$$.fragment,e),Ye=r(e),W=c(e,"DIV",{class:!0});var Z=j(W);g(re.$$.fragment,Z),rt=r(Z),ve=c(Z,"P",{"data-svelte-h":!0}),u(ve)!=="svelte-1g5c0n8"&&(ve.innerHTML=Ht),it=r(Z),g(O.$$.fragment,Z),Z.forEach(n),Ae=r(e),g(ie.$$.fragment,e),Xe=r(e),C=c(e,"DIV",{class:!0});var z=j(C);g(de.$$.fragment,z),dt=r(z),we=c(z,"P",{"data-svelte-h":!0}),u(we)!=="svelte-6muruj"&&(we.innerHTML=Nt),lt=r(z),Me=c(z,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-hswkmf"&&(Me.innerHTML=St),ct=r(z),$e=c(z,"P",{"data-svelte-h":!0}),u($e)!=="svelte-vk10ns"&&($e.innerHTML=Ot),mt=r(z),L=c(z,"DIV",{class:!0});var B=j(L);g(le.$$.fragment,B),pt=r(B),Ce=c(B,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-82fg80"&&(Ce.innerHTML=Rt),ht=r(B),g(R.$$.fragment,B),B.forEach(n),z.forEach(n),De=r(e),g(ce.$$.fragment,e),Qe=r(e),U=c(e,"DIV",{class:!0});var Te=j(U);g(me.$$.fragment,Te),ut=r(Te),I=c(Te,"DIV",{class:!0});var q=j(I);g(pe.$$.fragment,q),ft=r(q),Ge=c(q,"P",{"data-svelte-h":!0}),u(Ge)!=="svelte-lsmtzk"&&(Ge.innerHTML=Et),gt=r(q),g(E.$$.fragment,q),_t=r(q),g(V.$$.fragment,q),q.forEach(n),Te.forEach(n),Ke=r(e),g(he.$$.fragment,e),et=r(e),k=c(e,"DIV",{class:!0});var M=j(k);g(ue.$$.fragment,M),bt=r(M),ze=c(M,"P",{"data-svelte-h":!0}),u(ze)!=="svelte-m8ld61"&&(ze.textContent=Vt),yt=r(M),xe=c(M,"P",{"data-svelte-h":!0}),u(xe)!=="svelte-z6nrdp"&&(xe.innerHTML=Yt),Tt=r(M),Ie=c(M,"P",{"data-svelte-h":!0}),u(Ie)!=="svelte-10ugs3m"&&(Ie.innerHTML=At),kt=r(M),Fe=c(M,"P",{"data-svelte-h":!0}),u(Fe)!=="svelte-6pahdo"&&(Fe.innerHTML=Xt),vt=r(M),We=c(M,"P",{"data-svelte-h":!0}),u(We)!=="svelte-hswkmf"&&(We.innerHTML=Dt),wt=r(M),P=c(M,"DIV",{class:!0});var H=j(P);g(fe.$$.fragment,H),Mt=r(H),qe=c(H,"P",{"data-svelte-h":!0}),u(qe)!=="svelte-3jkk98"&&(qe.innerHTML=Qt),$t=r(H),g(Y.$$.fragment,H),H.forEach(n),M.forEach(n),tt=r(e),g(ge.$$.fragment,e),ot=r(e),G=c(e,"DIV",{class:!0});var x=j(G);g(_e.$$.fragment,x),Ct=r(x),je=c(x,"P",{"data-svelte-h":!0}),u(je)!=="svelte-1f58hu4"&&(je.textContent=Kt),Gt=r(x),Je=c(x,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-6pahdo"&&(Je.innerHTML=eo),zt=r(x),Le=c(x,"P",{"data-svelte-h":!0}),u(Le)!=="svelte-hswkmf"&&(Le.innerHTML=to),xt=r(x),F=c(x,"DIV",{class:!0});var D=j(F);g(be.$$.fragment,D),It=r(D),Pe=c(D,"P",{"data-svelte-h":!0}),u(Pe)!=="svelte-ychany"&&(Pe.innerHTML=oo),Ft=r(D),g(A.$$.fragment,D),Wt=r(D),g(X.$$.fragment,D),D.forEach(n),x.forEach(n),nt=r(e),g(ye.$$.fragment,e),at=r(e),Ue=c(e,"P",{}),j(Ue).forEach(n),this.h()},h(){J(t,"name","hf:doc:metadata"),J(t,"content",yo),J(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){i(document.head,t),d(e,h,o),d(e,a,o),d(e,p,o),_(w,e,o),d(e,m,o),_($,e,o),d(e,Be,o),d(e,K,o),d(e,He,o),d(e,ee,o),d(e,Ne,o),d(e,te,o),d(e,Se,o),d(e,oe,o),d(e,Oe,o),d(e,ne,o),d(e,Re,o),_(S,e,o),d(e,Ee,o),d(e,ae,o),d(e,Ve,o),_(se,e,o),d(e,Ye,o),d(e,W,o),_(re,W,null),i(W,rt),i(W,ve),i(W,it),_(O,W,null),d(e,Ae,o),_(ie,e,o),d(e,Xe,o),d(e,C,o),_(de,C,null),i(C,dt),i(C,we),i(C,lt),i(C,Me),i(C,ct),i(C,$e),i(C,mt),i(C,L),_(le,L,null),i(L,pt),i(L,Ce),i(L,ht),_(R,L,null),d(e,De,o),_(ce,e,o),d(e,Qe,o),d(e,U,o),_(me,U,null),i(U,ut),i(U,I),_(pe,I,null),i(I,ft),i(I,Ge),i(I,gt),_(E,I,null),i(I,_t),_(V,I,null),d(e,Ke,o),_(he,e,o),d(e,et,o),d(e,k,o),_(ue,k,null),i(k,bt),i(k,ze),i(k,yt),i(k,xe),i(k,Tt),i(k,Ie),i(k,kt),i(k,Fe),i(k,vt),i(k,We),i(k,wt),i(k,P),_(fe,P,null),i(P,Mt),i(P,qe),i(P,$t),_(Y,P,null),d(e,tt,o),_(ge,e,o),d(e,ot,o),d(e,G,o),_(_e,G,null),i(G,Ct),i(G,je),i(G,Gt),i(G,Je),i(G,zt),i(G,Le),i(G,xt),i(G,F),_(be,F,null),i(F,It),i(F,Pe),i(F,Ft),_(A,F,null),i(F,Wt),_(X,F,null),d(e,nt,o),_(ye,e,o),d(e,at,o),d(e,Ue,o),st=!0},p(e,[o]){const Z={};o&2&&(Z.$$scope={dirty:o,ctx:e}),S.$set(Z);const z={};o&2&&(z.$$scope={dirty:o,ctx:e}),O.$set(z);const B={};o&2&&(B.$$scope={dirty:o,ctx:e}),R.$set(B);const Te={};o&2&&(Te.$$scope={dirty:o,ctx:e}),E.$set(Te);const q={};o&2&&(q.$$scope={dirty:o,ctx:e}),V.$set(q);const M={};o&2&&(M.$$scope={dirty:o,ctx:e}),Y.$set(M);const H={};o&2&&(H.$$scope={dirty:o,ctx:e}),A.$set(H);const x={};o&2&&(x.$$scope={dirty:o,ctx:e}),X.$set(x)},i(e){st||(b(w.$$.fragment,e),b($.$$.fragment,e),b(S.$$.fragment,e),b(se.$$.fragment,e),b(re.$$.fragment,e),b(O.$$.fragment,e),b(ie.$$.fragment,e),b(de.$$.fragment,e),b(le.$$.fragment,e),b(R.$$.fragment,e),b(ce.$$.fragment,e),b(me.$$.fragment,e),b(pe.$$.fragment,e),b(E.$$.fragment,e),b(V.$$.fragment,e),b(he.$$.fragment,e),b(ue.$$.fragment,e),b(fe.$$.fragment,e),b(Y.$$.fragment,e),b(ge.$$.fragment,e),b(_e.$$.fragment,e),b(be.$$.fragment,e),b(A.$$.fragment,e),b(X.$$.fragment,e),b(ye.$$.fragment,e),st=!0)},o(e){y(w.$$.fragment,e),y($.$$.fragment,e),y(S.$$.fragment,e),y(se.$$.fragment,e),y(re.$$.fragment,e),y(O.$$.fragment,e),y(ie.$$.fragment,e),y(de.$$.fragment,e),y(le.$$.fragment,e),y(R.$$.fragment,e),y(ce.$$.fragment,e),y(me.$$.fragment,e),y(pe.$$.fragment,e),y(E.$$.fragment,e),y(V.$$.fragment,e),y(he.$$.fragment,e),y(ue.$$.fragment,e),y(fe.$$.fragment,e),y(Y.$$.fragment,e),y(ge.$$.fragment,e),y(_e.$$.fragment,e),y(be.$$.fragment,e),y(A.$$.fragment,e),y(X.$$.fragment,e),y(ye.$$.fragment,e),st=!1},d(e){e&&(n(h),n(a),n(p),n(m),n(Be),n(K),n(He),n(ee),n(Ne),n(te),n(Se),n(oe),n(Oe),n(ne),n(Re),n(Ee),n(ae),n(Ve),n(Ye),n(W),n(Ae),n(Xe),n(C),n(De),n(Qe),n(U),n(Ke),n(et),n(k),n(tt),n(ot),n(G),n(nt),n(at),n(Ue)),n(t),T(w,e),T($,e),T(S,e),T(se,e),T(re),T(O),T(ie,e),T(de),T(le),T(R),T(ce,e),T(me),T(pe),T(E),T(V),T(he,e),T(ue),T(fe),T(Y),T(ge,e),T(_e),T(be),T(A),T(X),T(ye,e)}}}const yo='{"title":"Gemma2","local":"gemma2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Gemma2Config","local":"transformers.Gemma2Config","sections":[],"depth":2},{"title":"Gemma2Model","local":"transformers.Gemma2Model","sections":[],"depth":2},{"title":"Gemma2ForCausalLM","local":"transformers.Gemma2ForCausalLM","sections":[],"depth":2},{"title":"Gemma2ForSequenceClassification","local":"transformers.Gemma2ForSequenceClassification","sections":[],"depth":2},{"title":"Gemma2ForTokenClassification","local":"transformers.Gemma2ForTokenClassification","sections":[],"depth":2}],"depth":1}';function To(v){return ao(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zo extends so{constructor(t){super(),ro(this,t,To,bo,no,{})}}export{zo as component};
