import{s as vt,o as kt,n as ye}from"../chunks/scheduler.25b97de1.js";import{S as $t,i as Ct,g as c,s,r as h,A as It,h as p,f as a,c as r,j as se,u,x as T,k as re,y as m,a as i,v as f,d as g,t as b,w as _}from"../chunks/index.d9030fc9.js";import{T as Jt}from"../chunks/Tip.baa67368.js";import{D as Me}from"../chunks/Docstring.ffac8efa.js";import{C as Te}from"../chunks/CodeBlock.e6cd0d95.js";import{E as st}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as ie,E as xt}from"../chunks/EditOnGithub.91d95064.js";function jt(I){let o,y="Example:",l,d,M;return d=new Te({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hbWJhMkNvbmZpZyUyQyUyME1hbWJhMk1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME1hbWJhMiUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwTWFtYmEyQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyME1hbWJhMk1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Mamba2Config, Mamba2Model

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Mamba2 configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Mamba2Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mamba2Model(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=c("p"),o.textContent=y,l=s(),h(d.$$.fragment)},l(n){o=p(n,"P",{"data-svelte-h":!0}),T(o)!=="svelte-11lpom8"&&(o.textContent=y),l=r(n),u(d.$$.fragment,n)},m(n,w){i(n,o,w),i(n,l,w),f(d,n,w),M=!0},p:ye,i(n){M||(g(d.$$.fragment,n),M=!0)},o(n){b(d.$$.fragment,n),M=!1},d(n){n&&(a(o),a(l)),_(d,n)}}}function zt(I){let o,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=c("p"),o.innerHTML=y},l(l){o=p(l,"P",{"data-svelte-h":!0}),T(o)!=="svelte-fincs2"&&(o.innerHTML=y)},m(l,d){i(l,o,d)},p:ye,d(l){l&&a(o)}}}function Ut(I){let o,y="Example:",l,d,M;return d=new Te({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNYW1iYTJNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGbWFtYmEtY29kZXN0cmFsLTdCLXYwLjElMjIpJTBBbW9kZWwlMjAlM0QlMjBNYW1iYTJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGbWFtYmEtY29kZXN0cmFsLTdCLXYwLjElMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Mamba2Model
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/mamba-codestral-7B-v0.1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mamba2Model.from_pretrained(<span class="hljs-string">&quot;mistralai/mamba-codestral-7B-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){o=c("p"),o.textContent=y,l=s(),h(d.$$.fragment)},l(n){o=p(n,"P",{"data-svelte-h":!0}),T(o)!=="svelte-11lpom8"&&(o.textContent=y),l=r(n),u(d.$$.fragment,n)},m(n,w){i(n,o,w),i(n,l,w),f(d,n,w),M=!0},p:ye,i(n){M||(g(d.$$.fragment,n),M=!0)},o(n){b(d.$$.fragment,n),M=!1},d(n){n&&(a(o),a(l)),_(d,n)}}}function Wt(I){let o,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=c("p"),o.innerHTML=y},l(l){o=p(l,"P",{"data-svelte-h":!0}),T(o)!=="svelte-fincs2"&&(o.innerHTML=y)},m(l,d){i(l,o,d)},p:ye,d(l){l&&a(o)}}}function Zt(I){let o,y="Example:",l,d,M;return d=new Te({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyME1hbWJhMkZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGbWFtYmEtY29kZXN0cmFsLTdCLXYwLjElMjIpJTBBbW9kZWwlMjAlM0QlMjBNYW1iYTJGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGbWFtYmEtY29kZXN0cmFsLTdCLXYwLjElMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCklMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Mamba2ForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/mamba-codestral-7B-v0.1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mamba2ForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/mamba-codestral-7B-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){o=c("p"),o.textContent=y,l=s(),h(d.$$.fragment)},l(n){o=p(n,"P",{"data-svelte-h":!0}),T(o)!=="svelte-11lpom8"&&(o.textContent=y),l=r(n),u(d.$$.fragment,n)},m(n,w){i(n,o,w),i(n,l,w),f(d,n,w),M=!0},p:ye,i(n){M||(g(d.$$.fragment,n),M=!0)},o(n){b(d.$$.fragment,n),M=!1},d(n){n&&(a(o),a(l)),_(d,n)}}}function Bt(I){let o,y,l,d,M,n,w,we,N,rt='The Mamba2 model was proposed in <a href="https://arxiv.org/abs/2405.21060" rel="nofollow">Transformers are SSMs: Generalized Models and Efficient Algorithms Through Structured State Space Duality</a> by Tri Dao and Albert Gu. It is a State Space Model similar to Mamba 1, with better performances in a simplified architecture.',Je,G,it="The abstract from the paper is the following:",ve,E,lt="<em>While Transformers have been the main architecture behind deep learning’s success in language modeling, state-space models (SSMs) such as Mamba have recently been shown to match or outperform Transformers at small to medium scale. We show that these families of models are actually quite closely related, and develop a rich framework of theoretical connections between SSMs and variants of attention, connected through various decompositions of a well-studied class of structured semiseparable matrices. Our state space duality (SSD) framework allows us to design a new architecture (Mamba-2) whose core layer is an a refinement of Mamba’s selective SSM that is 2-8X faster, while continuing to be competitive with Transformers on language modeling.</em>",ke,H,dt="Tips:",$e,V,mt=`This version should support all implementations of Mamba 2, and in particular <a href="https://huggingface.co/mistralai/Mamba-Codestral-7B-v0.1" rel="nofollow">Mamba-2 codestral</a> from Mistral AI. In particular, mamba 2 codestral was released with a number of <code>groups</code> equal to 8, which can be thought intuitively as similar to the number of kv heads in an attention-based model.
This model has two different forward passes, <code>torch_forward</code> or <code>cuda_kernels_forward</code>. The latter uses the original cuda kernels if they are found in your environment, and is slower on the prefill i.e. requires a “warmup run” due to high cpu overhead, see <a href="https://github.com/state-spaces/mamba/issues/389#issuecomment-2171755306" rel="nofollow">here</a> and <a href="https://github.com/state-spaces/mamba/issues/355#issuecomment-2147597457" rel="nofollow">also here</a>. Without compilation, the <code>torch_forward</code> implementation is faster by a factor 3 to 4. Further, there are no positional embeddings in this model, but there is an <code>attention_mask</code> and a specific logic to mask out hidden states in two places in the case of batched generation, see <a href="https://github.com/state-spaces/mamba/issues/66#issuecomment-1863563829" rel="nofollow">here</a> as well. Due to this, in addition to the reimplementation of mamba2 kernels, batched generation and cached generation are expected to have slight discrepancies. Further, the results given by the cuda kernels or the torch forward are expected to be slightly different. The SSM algorithm heavily relies on tensor contractions, which have matmul equivalents but the order of operations is slightly different, making the difference greater at smaller precisions.
Another note, shutdown of hidden states corresponding to padding tokens is done in 2 places and mostly has been tested with left-padding. Right-padding will propagate noise down the line and is not guaranteed to yield satisfactory results. <code>tokenizer.padding_side = &quot;left&quot;</code> ensures you are using the correct padding side.`,Ce,L,ct=`This model was contributed by <a href="https://huggingface.co/Molbap" rel="nofollow">Molbap</a>, with tremendous help from <a href="https://github.com/vasqu" rel="nofollow">Anton Vlasjuk</a>.
The original code can be found <a href="https://github.com/state-spaces/mamba" rel="nofollow">here</a>.`,Ie,q,xe,Y,je,Q,ze,A,pt="Here’s a draft script for finetuning:",Ue,S,We,P,Ze,k,D,He,le,ht=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/mamba2#transformers.Mamba2Model">Mamba2Model</a>. It is used to instantiate a MAMBA2
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the MAMBA2
<a href="https://huggingface.co/state-spaces/mamba2-2.8b" rel="nofollow">state-spaces/mamba2-2.8b</a> architecture.`,Ve,de,ut=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Le,Z,Be,O,Fe,J,K,qe,me,ft="The bare MAMBA2 Model transformer outputting raw hidden-states without any specific head on top.",Ye,ce,gt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Qe,pe,bt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ae,x,ee,Se,he,_t='The <a href="/docs/transformers/main/en/model_doc/mamba2#transformers.Mamba2Model">Mamba2Model</a> forward method, overrides the <code>__call__</code> special method.',Pe,B,De,F,Xe,te,Re,v,ae,Oe,ue,Mt=`The MAMBA2 Model transformer with a language modeling head on top (linear layer with weights not tied to the input
embeddings).`,Ke,fe,Tt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,et,ge,yt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,tt,j,oe,at,be,wt='The <a href="/docs/transformers/main/en/model_doc/mamba2#transformers.Mamba2ForCausalLM">Mamba2ForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',ot,X,nt,R,Ne,ne,Ge,_e,Ee;return M=new ie({props:{title:"Mamba 2",local:"mamba-2",headingTag:"h1"}}),w=new ie({props:{title:"Overview",local:"overview",headingTag:"h2"}}),q=new ie({props:{title:"Usage",local:"usage",headingTag:"h1"}}),Y=new ie({props:{title:"A simple generation example:",local:"a-simple-generation-example",headingTag:"h3"}}),Q=new Te({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hbWJhMkNvbmZpZyUyQyUyME1hbWJhMkZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBbW9kZWxfaWQlMjAlM0QlMjAnbWlzdHJhbGFpJTJGTWFtYmEtQ29kZXN0cmFsLTdCLXYwLjEnJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjByZXZpc2lvbiUzRCdyZWZzJTJGcHIlMkY5JyUyQyUyMGZyb21fc2xvdyUzRFRydWUlMkMlMjBsZWdhY3klM0RGYWxzZSklMEFtb2RlbCUyMCUzRCUyME1hbWJhMkZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHJldmlzaW9uJTNEJ3JlZnMlMkZwciUyRjknKSUwQWlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplciglMjJIZXklMjBob3clMjBhcmUlMjB5b3UlMjBkb2luZyUzRiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIwJTIycHQlMjIpJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTBBJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfaWRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Mamba2Config, Mamba2ForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch
model_id = <span class="hljs-string">&#x27;mistralai/Mamba-Codestral-7B-v0.1&#x27;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id, revision=<span class="hljs-string">&#x27;refs/pr/9&#x27;</span>, from_slow=<span class="hljs-literal">True</span>, legacy=<span class="hljs-literal">False</span>)
model = Mamba2ForCausalLM.from_pretrained(model_id, revision=<span class="hljs-string">&#x27;refs/pr/9&#x27;</span>)
input_ids = tokenizer(<span class="hljs-string">&quot;Hey how are you doing?&quot;</span>, return_tensors= <span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]

out = model.generate(input_ids, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(out))`,wrap:!1}}),S=new Te({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Mamba2ForCausalLM, TrainingArguments
model_id = <span class="hljs-string">&#x27;mistralai/Mamba-Codestral-7B-v0.1&#x27;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id, revision=<span class="hljs-string">&#x27;refs/pr/9&#x27;</span>, from_slow=<span class="hljs-literal">True</span>, legacy=<span class="hljs-literal">False</span>)
tokenizer.pad_token = tokenizer.eos_token
tokenizer.padding_side = <span class="hljs-string">&quot;left&quot;</span> <span class="hljs-comment">#enforce padding side left</span>

model = Mamba2ForCausalLM.from_pretrained(model_id, revision=<span class="hljs-string">&#x27;refs/pr/9&#x27;</span>)
dataset = load_dataset(<span class="hljs-string">&quot;Abirate/english_quotes&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-comment"># Without CUDA kernels, batch size of 2 occupies one 80GB device</span>
<span class="hljs-comment"># but precision can be reduced.</span>
<span class="hljs-comment"># Experiments and trials welcome!</span>
training_args = TrainingArguments(
    output_dir=<span class="hljs-string">&quot;./results&quot;</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    per_device_train_batch_size=<span class="hljs-number">2</span>,
    logging_dir=<span class="hljs-string">&#x27;./logs&#x27;</span>,
    logging_steps=<span class="hljs-number">10</span>,
    learning_rate=<span class="hljs-number">2e-3</span>
)
lora_config =  LoraConfig(
        r=<span class="hljs-number">8</span>,
        target_modules=[<span class="hljs-string">&quot;embeddings&quot;</span>, <span class="hljs-string">&quot;in_proj&quot;</span>, <span class="hljs-string">&quot;out_proj&quot;</span>],
        task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
        bias=<span class="hljs-string">&quot;none&quot;</span>
)
trainer = SFTTrainer(
    model=model,
    tokenizer=tokenizer,
    args=training_args,
    peft_config=lora_config,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;quote&quot;</span>,
)
trainer.train()`,wrap:!1}}),P=new ie({props:{title:"Mamba2Config",local:"transformers.Mamba2Config",headingTag:"h2"}}),D=new Me({props:{name:"class transformers.Mamba2Config",anchor:"transformers.Mamba2Config",parameters:[{name:"num_heads",val:" = 128"},{name:"head_dim",val:" = 64"},{name:"vocab_size",val:" = 32768"},{name:"hidden_size",val:" = 4096"},{name:"state_size",val:" = 128"},{name:"num_hidden_layers",val:" = 64"},{name:"layer_norm_epsilon",val:" = 1e-05"},{name:"pad_token_id",val:" = 1"},{name:"bos_token_id",val:" = 0"},{name:"eos_token_id",val:" = 2"},{name:"expand",val:" = 2"},{name:"conv_kernel",val:" = 4"},{name:"n_groups",val:" = 8"},{name:"use_bias",val:" = False"},{name:"use_conv_bias",val:" = True"},{name:"hidden_act",val:" = 'silu'"},{name:"initializer_range",val:" = 0.1"},{name:"residual_in_fp32",val:" = True"},{name:"time_step_rank",val:" = 'auto'"},{name:"time_step_min",val:" = 0.001"},{name:"time_step_max",val:" = 0.1"},{name:"time_step_floor",val:" = 0.0001"},{name:"time_step_limit",val:" = (0.0, inf)"},{name:"rescale_prenorm_residual",val:" = False"},{name:"use_cache",val:" = True"},{name:"rms_norm",val:" = True"},{name:"chunk_size",val:" = 256"},{name:"tie_word_embeddings",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Mamba2Config.num_heads",description:`<strong>num_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Number of heads for the evolution matrices of mamba 2.`,name:"num_heads"},{anchor:"transformers.Mamba2Config.head_dim",description:`<strong>head_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Dimension of each head.`,name:"head_dim"},{anchor:"transformers.Mamba2Config.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32768) &#x2014;
Vocabulary size of the MAMBA2 model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/mamba2#transformers.Mamba2Model">Mamba2Model</a>.`,name:"vocab_size"},{anchor:"transformers.Mamba2Config.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the embeddings and hidden states.`,name:"hidden_size"},{anchor:"transformers.Mamba2Config.state_size",description:"<strong>state_size</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014; shape of the state space latents.",name:"state_size"},{anchor:"transformers.Mamba2Config.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of hidden layers in the model.`,name:"num_hidden_layers"},{anchor:"transformers.Mamba2Config.layer_norm_epsilon",description:`<strong>layer_norm_epsilon</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon to use in the layer normalization layers.`,name:"layer_norm_epsilon"},{anchor:"transformers.Mamba2Config.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.Mamba2Config.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The id of the beginning of sentence token in the vocabulary.`,name:"bos_token_id"},{anchor:"transformers.Mamba2Config.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The id of the end of sentence token in the vocabulary.`,name:"eos_token_id"},{anchor:"transformers.Mamba2Config.expand",description:"<strong>expand</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014; Expanding factor used to determine the intermediate size.",name:"expand"},{anchor:"transformers.Mamba2Config.conv_kernel",description:"<strong>conv_kernel</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014; Size of the convolution kernel.",name:"conv_kernel"},{anchor:"transformers.Mamba2Config.n_groups",description:`<strong>n_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of groups for the evolution matrices of mamba 2.`,name:"n_groups"},{anchor:"transformers.Mamba2Config.use_bias",description:`<strong>use_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use bias in [&#x201C;in_proj&#x201D;, &#x201C;out_proj&#x201D;] of the mixer block`,name:"use_bias"},{anchor:"transformers.Mamba2Config.use_conv_bias",description:`<strong>use_conv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use bias in the convolution layer of the mixer block.`,name:"use_conv_bias"},{anchor:"transformers.Mamba2Config.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.Mamba2Config.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Mamba2Config.residual_in_fp32",description:`<strong>residual_in_fp32</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not residuals should be in <code>float32</code>. If set to <code>False</code> residuals will keep the same <code>dtype</code> as the rest of the model`,name:"residual_in_fp32"},{anchor:"transformers.Mamba2Config.time_step_rank",description:`<strong>time_step_rank</strong> (<code>Union[int,str]</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
Rank of the discretization projection matrix. <code>&quot;auto&quot;</code> means that it will default to <code>math.ceil(self.hidden_size / 16)</code>`,name:"time_step_rank"},{anchor:"transformers.Mamba2Config.time_step_min",description:`<strong>time_step_min</strong> (<code>float</code>, <em>optional</em>, defaults to 0.001) &#x2014;
Minimum <code>time_step</code> used to bound <code>dt_proj.bias</code>.`,name:"time_step_min"},{anchor:"transformers.Mamba2Config.time_step_max",description:`<strong>time_step_max</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Maximum <code>time_step</code> used to bound <code>dt_proj.bias</code>.`,name:"time_step_max"},{anchor:"transformers.Mamba2Config.time_step_floor",description:`<strong>time_step_floor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0001) &#x2014;
Minimum clamping value of the <code>dt_proj.bias</code> layer initialization.`,name:"time_step_floor"},{anchor:"transformers.Mamba2Config.time_step_limit",description:`<strong>time_step_limit</strong> (<code>tuple</code>, <em>optional</em>, defaults to <code>(0.0, inf)</code>) &#x2014;
Accepted range of time step values.`,name:"time_step_limit"},{anchor:"transformers.Mamba2Config.rescale_prenorm_residual",description:`<strong>rescale_prenorm_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to rescale <code>out_proj</code> weights when initializing.`,name:"rescale_prenorm_residual"},{anchor:"transformers.Mamba2Config.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the cache should be used.`,name:"use_cache"},{anchor:"transformers.Mamba2Config.rms_norm",description:`<strong>rms_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use RMS norm or not.`,name:"rms_norm"},{anchor:"transformers.Mamba2Config.chunk_size",description:`<strong>chunk_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Size of the chunks that will comprise the sequence.`,name:"chunk_size"},{anchor:"transformers.Mamba2Config.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie word embeddings or not.`,name:"tie_word_embeddings"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mamba2/configuration_mamba2.py#L26"}}),Z=new st({props:{anchor:"transformers.Mamba2Config.example",$$slots:{default:[jt]},$$scope:{ctx:I}}}),O=new ie({props:{title:"Mamba2Model",local:"transformers.Mamba2Model",headingTag:"h2"}}),K=new Me({props:{name:"class transformers.Mamba2Model",anchor:"transformers.Mamba2Model",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Mamba2Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mamba2#transformers.Mamba2Config">Mamba2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mamba2/modeling_mamba2.py#L821"}}),ee=new Me({props:{name:"forward",anchor:"transformers.Mamba2Model.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"cache_params",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"cache_position",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Mamba2Model.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>cache_params.seqlen_offset&gt;0</code>, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Mamba2Model.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Mamba2Model.forward.cache_params",description:`<strong>cache_params</strong> (<code>Mamba2Cache</code>, <em>optional</em>) &#x2014;
If passed along, the model uses the previous state in all the blocks (which will give the output for the
<code>input_ids</code> provided as if the model add <code>state_input_ids + input_ids</code> as context).`,name:"cache_params"},{anchor:"transformers.Mamba2Model.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the <code>cache_params</code> is returned and can be used to quickly generate the next logits.`,name:"use_cache"},{anchor:"transformers.Mamba2Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Mamba2Model.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Mamba2Model.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
The position of the current input in the cache. This is used to ensure that the cache is correctly updated.
If <code>cache_params</code> is passed, <code>cache_position</code> should also be passed.`,name:"cache_position"},{anchor:"transformers.Mamba2Model.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mamba2/modeling_mamba2.py#L850",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.mamba2.modeling_mamba2.Mamba2Output</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mamba2#transformers.Mamba2Config"
>Mamba2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>cache_params</strong> (<code>Mamba2Cache</code>) — The state of the model at the last time step. Can be used in a forward method with the next <code>input_ids</code> to
avoid providing the old <code>input_ids</code>.</p>
<p>Includes both the State space model state matrices after the selective scan, and the Convolutional states</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.mamba2.modeling_mamba2.Mamba2Output</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),B=new Jt({props:{$$slots:{default:[zt]},$$scope:{ctx:I}}}),F=new st({props:{anchor:"transformers.Mamba2Model.forward.example",$$slots:{default:[Ut]},$$scope:{ctx:I}}}),te=new ie({props:{title:"Mamba2LMHeadModel",local:"transformers.Mamba2ForCausalLM",headingTag:"h2"}}),ae=new Me({props:{name:"class transformers.Mamba2ForCausalLM",anchor:"transformers.Mamba2ForCausalLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Mamba2ForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mamba2#transformers.Mamba2Config">Mamba2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mamba2/modeling_mamba2.py#L937"}}),oe=new Me({props:{name:"forward",anchor:"transformers.Mamba2ForCausalLM.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"cache_params",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"cache_position",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Mamba2ForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>cache_params.seqlen_offset&gt;0</code>, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Mamba2ForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Mamba2ForCausalLM.forward.cache_params",description:`<strong>cache_params</strong> (<code>Mamba2Cache</code>, <em>optional</em>) &#x2014;
If passed along, the model uses the previous state in all the blocks (which will give the output for the
<code>input_ids</code> provided as if the model add <code>state_input_ids + input_ids</code> as context).`,name:"cache_params"},{anchor:"transformers.Mamba2ForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the <code>cache_params</code> is returned and can be used to quickly generate the next logits.`,name:"use_cache"},{anchor:"transformers.Mamba2ForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Mamba2ForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Mamba2ForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
The position of the current input in the cache. This is used to ensure that the cache is correctly updated.
If <code>cache_params</code> is passed, <code>cache_position</code> should also be passed.`,name:"cache_position"},{anchor:"transformers.Mamba2ForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Mamba2ForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mamba2/modeling_mamba2.py#L1032",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.mamba2.modeling_mamba2.Mamba2CausalLMOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mamba2#transformers.Mamba2Config"
>Mamba2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>cache_params</strong> (<code>Mamba2Cache</code>) — The state of the model at the last time step. Can be used in a forward method with the next <code>input_ids</code> to
avoid providing the old <code>input_ids</code>.</p>
<p>Includes both the State space model state matrices after the selective scan, and the Convolutional states</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.mamba2.modeling_mamba2.Mamba2CausalLMOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),X=new Jt({props:{$$slots:{default:[Wt]},$$scope:{ctx:I}}}),R=new st({props:{anchor:"transformers.Mamba2ForCausalLM.forward.example",$$slots:{default:[Zt]},$$scope:{ctx:I}}}),ne=new xt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/mamba2.md"}}),{c(){o=c("meta"),y=s(),l=c("p"),d=s(),h(M.$$.fragment),n=s(),h(w.$$.fragment),we=s(),N=c("p"),N.innerHTML=rt,Je=s(),G=c("p"),G.textContent=it,ve=s(),E=c("p"),E.innerHTML=lt,ke=s(),H=c("p"),H.textContent=dt,$e=s(),V=c("p"),V.innerHTML=mt,Ce=s(),L=c("p"),L.innerHTML=ct,Ie=s(),h(q.$$.fragment),xe=s(),h(Y.$$.fragment),je=s(),h(Q.$$.fragment),ze=s(),A=c("p"),A.textContent=pt,Ue=s(),h(S.$$.fragment),We=s(),h(P.$$.fragment),Ze=s(),k=c("div"),h(D.$$.fragment),He=s(),le=c("p"),le.innerHTML=ht,Ve=s(),de=c("p"),de.innerHTML=ut,Le=s(),h(Z.$$.fragment),Be=s(),h(O.$$.fragment),Fe=s(),J=c("div"),h(K.$$.fragment),qe=s(),me=c("p"),me.textContent=ft,Ye=s(),ce=c("p"),ce.innerHTML=gt,Qe=s(),pe=c("p"),pe.innerHTML=bt,Ae=s(),x=c("div"),h(ee.$$.fragment),Se=s(),he=c("p"),he.innerHTML=_t,Pe=s(),h(B.$$.fragment),De=s(),h(F.$$.fragment),Xe=s(),h(te.$$.fragment),Re=s(),v=c("div"),h(ae.$$.fragment),Oe=s(),ue=c("p"),ue.textContent=Mt,Ke=s(),fe=c("p"),fe.innerHTML=Tt,et=s(),ge=c("p"),ge.innerHTML=yt,tt=s(),j=c("div"),h(oe.$$.fragment),at=s(),be=c("p"),be.innerHTML=wt,ot=s(),h(X.$$.fragment),nt=s(),h(R.$$.fragment),Ne=s(),h(ne.$$.fragment),Ge=s(),_e=c("p"),this.h()},l(e){const t=It("svelte-u9bgzb",document.head);o=p(t,"META",{name:!0,content:!0}),t.forEach(a),y=r(e),l=p(e,"P",{}),se(l).forEach(a),d=r(e),u(M.$$.fragment,e),n=r(e),u(w.$$.fragment,e),we=r(e),N=p(e,"P",{"data-svelte-h":!0}),T(N)!=="svelte-1d6fl0b"&&(N.innerHTML=rt),Je=r(e),G=p(e,"P",{"data-svelte-h":!0}),T(G)!=="svelte-vfdo9a"&&(G.textContent=it),ve=r(e),E=p(e,"P",{"data-svelte-h":!0}),T(E)!=="svelte-7hg709"&&(E.innerHTML=lt),ke=r(e),H=p(e,"P",{"data-svelte-h":!0}),T(H)!=="svelte-axv494"&&(H.textContent=dt),$e=r(e),V=p(e,"P",{"data-svelte-h":!0}),T(V)!=="svelte-130dh8m"&&(V.innerHTML=mt),Ce=r(e),L=p(e,"P",{"data-svelte-h":!0}),T(L)!=="svelte-sx29qw"&&(L.innerHTML=ct),Ie=r(e),u(q.$$.fragment,e),xe=r(e),u(Y.$$.fragment,e),je=r(e),u(Q.$$.fragment,e),ze=r(e),A=p(e,"P",{"data-svelte-h":!0}),T(A)!=="svelte-n2y54r"&&(A.textContent=pt),Ue=r(e),u(S.$$.fragment,e),We=r(e),u(P.$$.fragment,e),Ze=r(e),k=p(e,"DIV",{class:!0});var z=se(k);u(D.$$.fragment,z),He=r(z),le=p(z,"P",{"data-svelte-h":!0}),T(le)!=="svelte-k7tbfb"&&(le.innerHTML=ht),Ve=r(z),de=p(z,"P",{"data-svelte-h":!0}),T(de)!=="svelte-o55m63"&&(de.innerHTML=ut),Le=r(z),u(Z.$$.fragment,z),z.forEach(a),Be=r(e),u(O.$$.fragment,e),Fe=r(e),J=p(e,"DIV",{class:!0});var $=se(J);u(K.$$.fragment,$),qe=r($),me=p($,"P",{"data-svelte-h":!0}),T(me)!=="svelte-1rstypp"&&(me.textContent=ft),Ye=r($),ce=p($,"P",{"data-svelte-h":!0}),T(ce)!=="svelte-6pahdo"&&(ce.innerHTML=gt),Qe=r($),pe=p($,"P",{"data-svelte-h":!0}),T(pe)!=="svelte-hswkmf"&&(pe.innerHTML=bt),Ae=r($),x=p($,"DIV",{class:!0});var U=se(x);u(ee.$$.fragment,U),Se=r(U),he=p(U,"P",{"data-svelte-h":!0}),T(he)!=="svelte-y382d"&&(he.innerHTML=_t),Pe=r(U),u(B.$$.fragment,U),De=r(U),u(F.$$.fragment,U),U.forEach(a),$.forEach(a),Xe=r(e),u(te.$$.fragment,e),Re=r(e),v=p(e,"DIV",{class:!0});var C=se(v);u(ae.$$.fragment,C),Oe=r(C),ue=p(C,"P",{"data-svelte-h":!0}),T(ue)!=="svelte-14gyjie"&&(ue.textContent=Mt),Ke=r(C),fe=p(C,"P",{"data-svelte-h":!0}),T(fe)!=="svelte-6pahdo"&&(fe.innerHTML=Tt),et=r(C),ge=p(C,"P",{"data-svelte-h":!0}),T(ge)!=="svelte-hswkmf"&&(ge.innerHTML=yt),tt=r(C),j=p(C,"DIV",{class:!0});var W=se(j);u(oe.$$.fragment,W),at=r(W),be=p(W,"P",{"data-svelte-h":!0}),T(be)!=="svelte-mv4mtl"&&(be.innerHTML=wt),ot=r(W),u(X.$$.fragment,W),nt=r(W),u(R.$$.fragment,W),W.forEach(a),C.forEach(a),Ne=r(e),u(ne.$$.fragment,e),Ge=r(e),_e=p(e,"P",{}),se(_e).forEach(a),this.h()},h(){re(o,"name","hf:doc:metadata"),re(o,"content",Ft),re(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),re(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),re(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),re(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),re(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){m(document.head,o),i(e,y,t),i(e,l,t),i(e,d,t),f(M,e,t),i(e,n,t),f(w,e,t),i(e,we,t),i(e,N,t),i(e,Je,t),i(e,G,t),i(e,ve,t),i(e,E,t),i(e,ke,t),i(e,H,t),i(e,$e,t),i(e,V,t),i(e,Ce,t),i(e,L,t),i(e,Ie,t),f(q,e,t),i(e,xe,t),f(Y,e,t),i(e,je,t),f(Q,e,t),i(e,ze,t),i(e,A,t),i(e,Ue,t),f(S,e,t),i(e,We,t),f(P,e,t),i(e,Ze,t),i(e,k,t),f(D,k,null),m(k,He),m(k,le),m(k,Ve),m(k,de),m(k,Le),f(Z,k,null),i(e,Be,t),f(O,e,t),i(e,Fe,t),i(e,J,t),f(K,J,null),m(J,qe),m(J,me),m(J,Ye),m(J,ce),m(J,Qe),m(J,pe),m(J,Ae),m(J,x),f(ee,x,null),m(x,Se),m(x,he),m(x,Pe),f(B,x,null),m(x,De),f(F,x,null),i(e,Xe,t),f(te,e,t),i(e,Re,t),i(e,v,t),f(ae,v,null),m(v,Oe),m(v,ue),m(v,Ke),m(v,fe),m(v,et),m(v,ge),m(v,tt),m(v,j),f(oe,j,null),m(j,at),m(j,be),m(j,ot),f(X,j,null),m(j,nt),f(R,j,null),i(e,Ne,t),f(ne,e,t),i(e,Ge,t),i(e,_e,t),Ee=!0},p(e,[t]){const z={};t&2&&(z.$$scope={dirty:t,ctx:e}),Z.$set(z);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),B.$set($);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),F.$set(U);const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),X.$set(C);const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),R.$set(W)},i(e){Ee||(g(M.$$.fragment,e),g(w.$$.fragment,e),g(q.$$.fragment,e),g(Y.$$.fragment,e),g(Q.$$.fragment,e),g(S.$$.fragment,e),g(P.$$.fragment,e),g(D.$$.fragment,e),g(Z.$$.fragment,e),g(O.$$.fragment,e),g(K.$$.fragment,e),g(ee.$$.fragment,e),g(B.$$.fragment,e),g(F.$$.fragment,e),g(te.$$.fragment,e),g(ae.$$.fragment,e),g(oe.$$.fragment,e),g(X.$$.fragment,e),g(R.$$.fragment,e),g(ne.$$.fragment,e),Ee=!0)},o(e){b(M.$$.fragment,e),b(w.$$.fragment,e),b(q.$$.fragment,e),b(Y.$$.fragment,e),b(Q.$$.fragment,e),b(S.$$.fragment,e),b(P.$$.fragment,e),b(D.$$.fragment,e),b(Z.$$.fragment,e),b(O.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(B.$$.fragment,e),b(F.$$.fragment,e),b(te.$$.fragment,e),b(ae.$$.fragment,e),b(oe.$$.fragment,e),b(X.$$.fragment,e),b(R.$$.fragment,e),b(ne.$$.fragment,e),Ee=!1},d(e){e&&(a(y),a(l),a(d),a(n),a(we),a(N),a(Je),a(G),a(ve),a(E),a(ke),a(H),a($e),a(V),a(Ce),a(L),a(Ie),a(xe),a(je),a(ze),a(A),a(Ue),a(We),a(Ze),a(k),a(Be),a(Fe),a(J),a(Xe),a(Re),a(v),a(Ne),a(Ge),a(_e)),a(o),_(M,e),_(w,e),_(q,e),_(Y,e),_(Q,e),_(S,e),_(P,e),_(D),_(Z),_(O,e),_(K),_(ee),_(B),_(F),_(te,e),_(ae),_(oe),_(X),_(R),_(ne,e)}}}const Ft='{"title":"Mamba 2","local":"mamba-2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2}],"depth":1}';function Xt(I){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qt extends $t{constructor(o){super(),Ct(this,o,Xt,Bt,vt,{})}}export{qt as component};
