import{s as pZ,o as mZ,n as x}from"../chunks/scheduler.25b97de1.js";import{S as hZ,i as gZ,g as o,s as a,r as m,A as uZ,h as l,f as n,c as r,j as T,u as h,x as _,k as M,y as t,a as p,v as g,d as u,t as f,w as b}from"../chunks/index.d9030fc9.js";import{T as Va}from"../chunks/Tip.baa67368.js";import{D as v}from"../chunks/Docstring.ffac8efa.js";import{C as U}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Z}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as ye,E as fZ}from"../chunks/EditOnGithub.91d95064.js";function bZ(j){let c,$=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/en/model_doc/bark" rel="nofollow">Bark</a>’s fine submodel. See the model documentation
for examples.`;return{c(){c=o("p"),c.innerHTML=$},l(y){c=l(y,"P",{"data-svelte-h":!0}),_(c)!=="svelte-nbt45a"&&(c.innerHTML=$)},m(y,d){p(y,c,d)},p:x,d(y){y&&n(c)}}}function _Z(j){let c,$=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/main/en/model_doc/musicgen" rel="nofollow">MusicGen</a>`;return{c(){c=o("p"),c.innerHTML=$},l(y){c=l(y,"P",{"data-svelte-h":!0}),_(c)!=="svelte-1uojnuk"&&(c.innerHTML=$)},m(y,d){p(y,c,d)},p:x,d(y){y&&n(c)}}}function yZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMjgwcyUyMHBvcCUyMHRyYWNrJTIwd2l0aCUyMGJhc3N5JTIwZHJ1bXMlMjBhbmQlMjBzeW50aCUyMiUyQyUyMCUyMjkwcyUyMHJvY2slMjBzb25nJTIwd2l0aCUyMGxvdWQlMjBndWl0YXJzJTIwYW5kJTIwaGVhdnklMjBkcnVtcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSklMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function TZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkFsaWNlJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMFdoYXQlMjBkbyUyMHlvdSUyMGxvdmUlM0YlNUNuQm9iJTNBJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwZ3JlZWR5JTIwZGVjb2RpbmclMkMlMjB3ZSUyMHNlZSUyMEJvYiUyMHJlcGVhdGluZyUyMEFsaWNlJ3MlMjBvcGluaW9uLiUyMElmJTIwQm9iJTIwd2FzJTIwYSUyMGNoYXRib3QlMkMlMjBpdCUyMHdvdWxkJTIwYmUlMjBhJTIwcG9vciUyMG9uZS4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhpcyUyMGxvZ2l0cyUyMHByb2Nlc3NvciUyQyUyMHdlJTIwY2FuJTIwcHJldmVudCUyMEJvYiUyMGZyb20lMjByZXBlYXRpbmclMjBBbGljZSdzJTIwb3Bpbmlvbi4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX25vX3JlcGVhdF9uZ3JhbV9zaXplJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice: I love cats. What do you love?\\nBob:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With greedy decoding, we see Bob repeating Alice&#x27;s opinion. If Bob was a chatbot, it would be a poor one.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: I love cats. What do you

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With this logits processor, we can prevent Bob from repeating Alice&#x27;s opinion.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, encoder_no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: My cats are very cute.`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function MZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkFsaWNlJTIwYW5kJTIwQm9iLiUyMFRoZSUyMHRoaXJkJTIwbWVtYmVyJ3MlMjBuYW1lJTIwd2FzJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhlJTIwJTYwZW5jb2Rlcl9yZXBldGl0aW9uX3BlbmFsdHklNjAlMjBhcmd1bWVudCUyMHdlJTIwY2FuJTIwdHJpZ2dlciUyMHRoaXMlMjBsb2dpdHMlMjBwcm9jZXNzb3IlMjBpbiUyMCU2MGdlbmVyYXRlJTYwJTJDJTIwd2hpY2glMjBjYW4lMEElMjMlMjBwcm9tb3RlJTIwdGhlJTIwdXNlJTIwb2YlMjBwcm9tcHQlMjB0b2tlbnMlMjAoJTIyQm9iJTIyJTIwaW4lMjB0aGlzJTIwZXhhbXBsZSklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX3JlcGV0aXRpb25fcGVuYWx0eSUzRDEuMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Alice and Bob. The third member&#x27;s name was&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob. The third membe<span class="hljs-string">r&#x27;s name was not mentioned.

&gt;&gt;&gt; # With the \`encoder_repetition_penalty\` argument we can trigger this logits processor in \`generate\`, which can
&gt;&gt;&gt; # promote the use of prompt tokens (&quot;Bob&quot; in this example)
&gt;&gt;&gt; gen_out = model.generate(**inputs, encoder_repetition_penalty=1.2)
&gt;&gt;&gt; print(tokenizer.batch_decode(gen_out, skip_special_tokens=True)[0])
Alice and Bob. The third member&#x27;</span>s name was Bob. The third membe<span class="hljs-string">r&#x27;s name was Bob.</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function vZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMGVwc2lsb24lMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdG8lMjBoaWdoLXByb2JhYmlsaXR5JTIwdG9rZW5zLiUyME5vdGUlMjB0aGF0JTIwdGhpcyUyMGlzJTIwc2ltaWxhciUyMHRvJTBBJTIzJTIwVG9wJTIwUCUyMHNhbXBsaW5nJTJDJTIwd2hpY2glMjByZXN0cmljdHMlMjB0b2tlbnMlMjBiYXNlZCUyMG9uJTIwdGhlaXIlMjBjdW11bGF0aXZlJTIwcHJvYmFiaWxpdHkuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwVGhlJTIwcGFwZXIlMjByZWNvbWVuZHMlMjB1c2luZyUyMCU2MGVwc2lsb25fY3V0b2ZmJTYwJTIwdmFsdWVzJTIwYmV0d2VlbiUyMDNlLTQlMjBhbmQlMjA5ZS00JTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMGVwc2lsb25fY3V0b2ZmJTNEMC4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With epsilon sampling, the output gets restricted to high-probability tokens. Note that this is similar to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Top P sampling, which restricts tokens based on their cumulative probability.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`epsilon_cutoff\` values between 3e-4 and 9e-4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, epsilon_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function wZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMGV0YSUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwZ2V0cyUyMHJlc3RyaWN0ZWQlMjB0byUyMGhpZ2gtcHJvYmFiaWxpdHklMjB0b2tlbnMuJTIwWW91JTIwY2FuJTIwc2VlJTIwaXQlMjBhcyUyMGElMjBkeW5hbWljJTIwZm9ybSUyMG9mJTBBJTIzJTIwZXBzaWxvbiUyMHNhbXBsaW5nJTIwdGhhdCUyMGFkYXB0cyUyMGl0cyUyMGN1dG9mZiUyMHByb2JhYmlsaXR5JTIwYmFzZWQlMjBvbiUyMHRoZSUyMGVudHJvcHklMjAoaGlnaCUyMGVudHJvcHklMjAlM0QlMjBsb3dlciUyMGN1dG9mZikuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwVGhlJTIwcGFwZXIlMjByZWNvbWVuZHMlMjB1c2luZyUyMCU2MGV0YV9jdXRvZmYlNjAlMjB2YWx1ZXMlMjBiZXR3ZWVuJTIwM2UtNCUyMHRvJTIwNGUtMyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBldGFfY3V0b2ZmJTNEMC4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With eta sampling, the output gets restricted to high-probability tokens. You can see it as a dynamic form of</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># epsilon sampling that adapts its cutoff probability based on the entropy (high entropy = lower cutoff).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`eta_cutoff\` values between 3e-4 to 4e-3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, eta_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function kZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Just wanted to let you know, I&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Let&#x27;s consider that we want short sentences, so we limit \`max_length=30\`. However, we observe that the answer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># tends to end abruptly.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.9</span>, max_length=<span class="hljs-number">30</span>, pad_token_id=<span class="hljs-number">50256</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span> Although

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To promote the appearance of the EOS token at the right time, we add the \`exponential_decay_length_penalty =</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (start_index, decay_factor)\`. Instead of cutting at max_tokens, the output comes to an end before and usually</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with more meaning. What happens is that starting from \`start_index\` the EOS token score will be increased</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># by \`decay_factor\` exponentially. However, if you set a high decay factor, you may also end up with abruptly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># ending sequences.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.6</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network
which&lt;|endoftext|&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With a small decay factor, you will have a higher chance of getting a meaningful sequence.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.01</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span>&lt;|endoftext|&gt;`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function $Z(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZmxhbi10NS1zbWFsbCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUcmFuc2xhdGUlMjBmcm9tJTIwRW5nbGlzaCUyMHRvJTIwR2VybWFuJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwQnklMjBkZWZhdWx0JTJDJTIwaXQlMjBjb250aW51ZXMlMjBnZW5lcmF0aW5nJTIwYWNjb3JkaW5nJTIwdG8lMjB0aGUlMjBtb2RlbCdzJTIwbG9naXRzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCklMEElMEElMjMlMjBXZSUyMGNhbiUyMHVzZSUyMCU2MGZvcmNlZF9ib3NfdG9rZW5faWQlNjAlMjB0byUyMGZvcmNlJTIwdGhlJTIwc3RhcnQlMjBvZiUyMGdlbmVyYXRpb24lMjB3aXRoJTIwYW4lMjBlbmNvZGVyLWRlY29kZXIlMjBtb2RlbCUwQSUyMyUyMChpbmNsdWRpbmclMjBmb3JjaW5nJTIwaXQlMjB0byUyMGVuZCUyMHN0cmFpZ2h0JTIwYXdheSUyMHdpdGglMjBhbiUyMEVPUyUyMHRva2VuKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAlMkMlMjBmb3JjZWRfYm9zX3Rva2VuX2lkJTNEdG9rZW5pemVyLmVvc190b2tlbl9pZCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Translate from English to German: I love cats.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt; Ich liebe Kitty.&lt;/s&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can use \`forced_bos_token_id\` to force the start of generation with an encoder-decoder model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (including forcing it to end straight away with an EOS token)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_bos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt;&lt;/s&gt;`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function jZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJBJTIwc2VxdWVuY2UlM0ElMjAxJTJDJTIwMiUyQyUyMDMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEJ5JTIwZGVmYXVsdCUyQyUyMGl0JTIwY29udGludWVzJTIwZ2VuZXJhdGluZyUyMGFjY29yZGluZyUyMHRvJTIwdGhlJTIwbW9kZWwncyUyMGxvZ2l0cyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTApJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzKSU1QjAlNUQpJTBBJTBBJTIzJTIwJTYwZm9yY2VkX2Vvc190b2tlbl9pZCU2MCUyMGVuc3VyZXMlMjB0aGUlMjBnZW5lcmF0aW9uJTIwZW5kcyUyMHdpdGglMjBhJTIwRU9TJTIwdG9rZW4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwJTJDJTIwZm9yY2VkX2Vvc190b2tlbl9pZCUzRHRva2VuaXplci5lb3NfdG9rZW5faWQpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># \`forced_eos_token_id\` ensures the generation ends with a EOS token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_eos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>,&lt;|endoftext|&gt;`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function xZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># A long text about the solar system</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The Solar System is a gravitationally bound system comprising the Sun and the objects that orbit it, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;either directly or indirectly. Of the objects that orbit the Sun directly, the largest are the eight &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;planets, with the remainder being smaller objects, such as the five dwarf planets and small Solar System &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;bodies. The Solar System formed 4.6 billion years ago from the gravitational collapse of a giant &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;interstellar molecular cloud.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;summarize: &quot;</span> + text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    num_beam_groups=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    diversity_penalty=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summaries_diverse = tokenizer.batch_decode(outputs_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate non-diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_non_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_non_diverse = tokenizer.batch_decode(outputs_non_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`diversity_penalty\`, the resulting beams are much more diverse</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summary_non_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the Solar System formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summaries_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets. the rest of the objects are smaller objects, such as the five dwarf planets and small solar system bodies.&#x27;</span>]`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function JZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTJDJTIwMyUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwQnklMjBkZWZhdWx0JTJDJTIwdGhlJTIwc2NvcmVzJTIwYXJlJTIwbm90JTIwbm9ybWFsaXplZCUyMC0tJTIwdGhlJTIwc3VtJTIwb2YlMjB0aGVpciUyMGV4cG9uZW50aWFscyUyMGlzJTIwTk9UJTIwYSUyMG5vcm1hbGl6ZWQlMjBwcm9iYWJpbGl0eSUwQSUyMyUyMGRpc3RyaWJ1dGlvbiUyQyUyMHN1bW1pbmclMjB0byUyMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUlMkMlMjBvdXRwdXRfc2NvcmVzJTNEVHJ1ZSklMEFwcmludCh0b3JjaC5hbGxjbG9zZSh0b3JjaC5zdW0odG9yY2guZXhwKG91dHB1dHMuc2NvcmVzJTVCLTElNUQpKSUyQyUyMHRvcmNoLlRlbnNvcigoMS4wMDAlMkMpKSUyQyUyMHJ0b2wlM0QxZS00KSklMEElMEElMjMlMjBOb3JtYWxpemluZyUyMHRoZW0lMjBtYXklMjBoYXZlJTIwYSUyMHBvc2l0aXZlJTIwaW1wYWN0JTIwb24lMjBiZWFtJTIwbWV0aG9kcyUyQyUyMG9yJTIwd2hlbiUyMHVzaW5nJTIwdGhlJTIwc2NvcmVzJTIwb24lMjB5b3VyJTIwYXBwbGljYXRpb24lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZW5vcm1hbGl6ZV9sb2dpdHMlM0RUcnVlJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQodG9yY2guYWxsY2xvc2UodG9yY2guc3VtKHRvcmNoLmV4cChvdXRwdXRzLnNjb3JlcyU1Qi0xJTVEKSklMkMlMjB0b3JjaC5UZW5zb3IoKDEuMDAwJTJDKSklMkMlMjBydG9sJTNEMWUtNCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the scores are not normalized -- the sum of their exponentials is NOT a normalized probability</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># distribution, summing to 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.allclose(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])), torch.Tensor((<span class="hljs-number">1.000</span>,)), rtol=<span class="hljs-number">1e-4</span>))
<span class="hljs-literal">False</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Normalizing them may have a positive impact on beam methods, or when using the scores on your application</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, renormalize_logits=<span class="hljs-literal">True</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.allclose(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])), torch.Tensor((<span class="hljs-number">1.000</span>,)), rtol=<span class="hljs-number">1e-4</span>))
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function UZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBudW1iZXIlM0ElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbGVuZ3RoJTYwJTIwdG8lMjBhJTIwdmFsdWUlMjBzbWFsbGVyJTIwdGhhbiUyMHRoZSUyMHVuY29udHJvbGxlZCUyMG91dHB1dCUyMGxlbmd0aCUyMGhhcyUyMG5vJTIwaW1wYWN0JTBBZ2VuX291dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWluX2xlbmd0aCUzRDMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBzZXR0aW5nJTIwYSUyMGxhcmdlciUyMCU2MG1pbl9sZW5ndGglNjAlMjB3aWxsJTIwZm9yY2UlMjB0aGUlMjBtb2RlbCUyMHRvJTIwZ2VuZXJhdGUlMjBiZXlvbmQlMjBpdHMlMjBuYXR1cmFsJTIwZW5kaW5nJTIwcG9pbnQlMkMlMjB3aGljaCUyMGlzJTIwbm90JTBBJTIzJTIwbmVjZXNzYXJpbHklMjBpbmNvcnJlY3QlMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtaW5fbGVuZ3RoJTNEMTApJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A number:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_length\` to a value smaller than the uncontrolled output length has no impact</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting a larger \`min_length\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand, nine hundred <span class="hljs-keyword">and</span> ninety-four`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function ZZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjBudW1iZXIlM0ElMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbmV3X3Rva2VucyU2MCUyMHdpbGwlMjBmb3JjZSUyMHRoZSUyMG1vZGVsJTIwdG8lMjBnZW5lcmF0ZSUyMGJleW9uZCUyMGl0cyUyMG5hdHVyYWwlMjBlbmRpbmclMjBwb2ludCUyQyUyMHdoaWNoJTIwaXMlMjBub3QlMEElMjMlMjBuZWNlc3NhcmlseSUyMGluY29ycmVjdCUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1pbl9uZXdfdG9rZW5zJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;A number:&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_new_tokens\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_new_tokens=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function CZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMCU2MG1pbl9wJTYwJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRvJTIwaGlnaC1wcm9iYWJpbGl0eSUyMHRva2Vucy4lMEElMjMlMjBQcm8lMjB0aXAlM0ElMjBJbiUyMHByYWN0aWNlJTJDJTIwTExNcyUyMHVzZSUyMCU2MG1pbl9wJTYwJTIwaW4lMjB0aGUlMjAwLjAxLTAuMiUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBtaW5fcCUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`min_p\` sampling, the output gets restricted to high-probability tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`min_p\` in the 0.01-0.2 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, min_p=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function WZ(j){let c,$=`In order to get the token ids of the words that should not appear in the generated text, make sure to set
<code>add_prefix_space=True</code> when initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code> argument is only supported for some slow tokenizers,
as fast tokenizers’ prefixing behaviours come from <code>pre tokenizers</code>. Read more
<a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){c=o("p"),c.innerHTML=$},l(y){c=l(y,"P",{"data-svelte-h":!0}),_(c)!=="svelte-15bvr1j"&&(c.innerHTML=$)},m(y,d){p(y,c,d)},p:x,d(y){y&&n(c)}}}function BZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;In a word, the cake is a&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, pad_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a mess.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s take the bad words out. Please note that the tokenizer is initialized differently</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_list</span>(<span class="hljs-params">word_list</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Converts a sequence of words into a list of tokens&quot;</span>
<span class="hljs-meta">... </span>    tokens_list = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_list:
<span class="hljs-meta">... </span>        tokenized_word = tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        tokens_list.append(tokenized_word)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokens_list


<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = get_tokens_as_list(word_list=[<span class="hljs-string">&quot;mess&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, bad_words_ids=bad_words_ids, pad_token_id=tokenizer.eos_token_id
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a surprise.`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function IZ(j){let c,$=`Use n-gram penalties with care. For instance, penalizing 2-grams (bigrams) in an article about the city of New York
might lead to undesirable outcomes where the city’s name appears only once in the entire text.
<a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">Reference</a>`;return{c(){c=o("p"),c.innerHTML=$},l(y){c=l(y,"P",{"data-svelte-h":!0}),_(c)!=="svelte-5zfsi9"&&(c.innerHTML=$)},m(y,d){p(y,c,d)},p:x,d(y){y&&n(c)}}}function zZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJUb2RheSUyMEklMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0JTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMEElMjMlMjBOb3clMjBsZXQncyUyMGFkZCUyMG5ncmFtJTIwc2l6ZSUyMHVzaW5nJTIwJTYwbm9fcmVwZWF0X25ncmFtX3NpemUlNjAuJTIwVGhpcyUyMHN0b3BzJTIwdGhlJTIwcmVwZXRpdGlvbnMlMjAoJTIySSVFMiU4MCU5OW0lMjIpJTIwaW4lMjB0aGUlMjBvdXRwdXQuJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBub19yZXBlYXRfbmdyYW1fc2l6ZSUzRDIpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXQlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today I&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I’m going to be able to do it.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s add ngram size using \`no_repeat_ngram_size\`. This stops the repetitions (&quot;I’m&quot;) in the output.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs, no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I can get a better understanding of the nature of this issue`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function VZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice and Bob&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob are friends

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can contrain it with \`prefix_allowed_tokens_fn\` to force a certain behavior based on a prefix.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For instance, we can force an entire entity to be generated when its beginning is detected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>entity = tokenizer(<span class="hljs-string">&quot; Bob Marley&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids[<span class="hljs-number">0</span>]  <span class="hljs-comment"># 3 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">prefix_allowed_tokens_fn</span>(<span class="hljs-params">batch_id, input_ids</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Attempts to generate &#x27;Bob Marley&#x27; when &#x27;Bob&#x27; is detected.
<span class="hljs-meta">... </span>    In this case, \`batch_id\` is not used, but you can set rules for each batch member.
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">0</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> [entity[<span class="hljs-number">1</span>].item()]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">elif</span> input_ids[-<span class="hljs-number">2</span>] == entity[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">1</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> [entity[<span class="hljs-number">2</span>].item()]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-built_in">list</span>(<span class="hljs-built_in">range</span>(tokenizer.vocab_size))  <span class="hljs-comment"># If no match, allow all tokens</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, prefix_allowed_tokens_fn=prefix_allowed_tokens_fn)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob Marley`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function GZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwdG9rZW5pemVyJTIwZm9yJTIwaXQlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIySSdtJTIwbm90JTIwZ29pbmclMjB0byUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwVGhpcyUyMHNob3dzJTIwYSUyMG5vcm1hbCUyMGdlbmVyYXRlJTIwd2l0aG91dCUyMGFueSUyMHNwZWNpZmljJTIwcGFyYW1ldGVycyUwQXN1bW1hcnlfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShzdW1tYXJ5X2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwVGhpcyUyMGdlbmVyYXRlcyUyMGElMjBwZW5hbHR5JTIwZm9yJTIwcmVwZWF0ZWQlMjB0b2tlbnMlMEFwZW5hbGl6ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjEpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShwZW5hbGl6ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing the model and tokenizer for it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;I&#x27;m not going to&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This shows a normal generate without any specific parameters</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>m going to be able to do that

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This generates a penalty for repeated tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>penalized_ids = model.generate(**inputs, repetition_penalty=<span class="hljs-number">1.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(penalized_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>ll just have to go out <span class="hljs-keyword">and</span> play`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function FZ(j){let c,$=`In order to get the token ids of the sequences that you want to bias, make sure to set <code>add_prefix_space=True</code> when
initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The
<code>add_prefix_space</code> argument is only supported for some slow tokenizers, as fast tokenizers’ prefixing behaviours
come from <code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){c=o("p"),c.innerHTML=$},l(y){c=l(y,"P",{"data-svelte-h":!0}),_(c)!=="svelte-16cusgy"&&(c.innerHTML=$)},m(y,d){p(y,c,d)},p:x,d(y){y&&n(c)}}}function XZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;The full name of Donald is Donald&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Trump Jr

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s control generation through a bias. Please note that the tokenizer is initialized differently!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens</span>(<span class="hljs-params">word</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>]


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we add a negative bias without beam search, it may become &quot;stuck&quot; in a prefix without good continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = [get_tokens(<span class="hljs-string">&quot;Trump&quot;</span>), -<span class="hljs-number">10.0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Donald,

<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Rumsfeld,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also add a positive bias to nudge the model towards specific tokens or continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = [get_tokens(<span class="hljs-string">&quot;Donald Duck&quot;</span>), <span class="hljs-number">10.0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Duck.`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function RZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2hpc3BlciUyMGhhcyUyMCU2MGJlZ2luX3N1cHByZXNzX3Rva2VucyU2MCUyMHNldCUyMGJ5JTIwZGVmYXVsdCUyMCglM0QlMjAlNjAlNUIyMjAlMkMlMjA1MDI1NiU1RCU2MCkuJTIwNTAyNTYlMjBpcyUyMHRoZSUyMEVPUyUyMHRva2VuJTJDJTIwc28lMjB0aGlzJTIwbWVhbnMlMEElMjMlMjBpdCUyMGNhbid0JTIwZ2VuZXJhdGUlMjBhbmQlMjBFT1MlMjB0b2tlbiUyMGluJTIwdGhlJTIwZmlyc3QlMjBpdGVyYXRpb24lMkMlMjBidXQlMjBpdCUyMGNhbiUyMGluJTIwdGhlJTIwb3RoZXJzLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlKSUwQXByaW50KG91dHB1dHMuc2NvcmVzJTVCMCU1RCU1QjAlMkMlMjA1MDI1NiU1RCklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1Qi0xJTVEJTVCMCUyQyUyMDUwMjU2JTVEKSUyMCUyMCUyMyUyMGluJTIwb3RoZXIlMjBwbGFjZXMlMjB3ZSUyMGNhbiUyMHNlZSUyMHNvbWUlMjBwcm9iYWJpbGl0eSUyMG1hc3MlMjBmb3IlMjBFT1MlMEElMEElMjMlMjBJZiUyMHdlJTIwZGlzYWJsZSUyMCU2MGJlZ2luX3N1cHByZXNzX3Rva2VucyU2MCUyQyUyMHdlJTIwY2FuJTIwZ2VuZXJhdGUlMjBFT1MlMjBpbiUyMHRoZSUyMGZpcnN0JTIwaXRlcmF0aW9uLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlJTJDJTIwYmVnaW5fc3VwcHJlc3NfdG9rZW5zJTNETm9uZSUwQSklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1QjAlNUQlNUIwJTJDJTIwNTAyNTYlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has \`begin_suppress_tokens\` set by default (= \`[220, 50256]\`). 50256 is the EOS token, so this means</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># it can&#x27;t generate and EOS token in the first iteration, but it can in the others.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])
tensor(-inf)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[-<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])  <span class="hljs-comment"># in other places we can see some probability mass for EOS</span>
tensor(<span class="hljs-number">29.9010</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`begin_suppress_tokens\`, we can generate EOS in the first iteration.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, begin_suppress_tokens=<span class="hljs-literal">None</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])
tensor(<span class="hljs-number">11.2027</span>)`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function LZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2hpc3BlciUyMGhhcyUyMGElMjBsb25nJTIwbGlzdCUyMG9mJTIwc3VwcHJlc3NlZCUyMHRva2Vucy4lMjBGb3IlMjBpbnN0YW5jZSUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMkMlMjB0aGUlMjB0b2tlbiUyMDElMjBpcyUyMHN1cHByZXNzZWQlMjBieSUyMGRlZmF1bHQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQob3V0cHV0cy5zY29yZXMlNUIxJTVEJTVCMCUyQyUyMDElNUQpJTIwJTIwJTIzJTIwMSUyMChhbmQlMjBub3QlMjAwKSUyMGlzJTIwdGhlJTIwZmlyc3QlMjBmcmVlbHklMjBnZW5lcmF0ZWQlMjB0b2tlbiUwQSUwQSUyMyUyMElmJTIwd2UlMjBkaXNhYmxlJTIwJTYwc3VwcHJlc3NfdG9rZW5zJTYwJTJDJTIwd2UlMjBjYW4lMjBnZW5lcmF0ZSUyMGl0LiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlJTJDJTIwc3VwcHJlc3NfdG9rZW5zJTNETm9uZSklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1QjElNUQlNUIwJTJDJTIwMSU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has a long list of suppressed tokens. For instance, in this case, the token 1 is suppressed by default.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])  <span class="hljs-comment"># 1 (and not 0) is the first freely generated token</span>
tensor(-inf)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`suppress_tokens\`, we can generate it.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, suppress_tokens=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
tensor(<span class="hljs-number">6.0678</span>)`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function SZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFN5bnRoSURUZXh0V2F0ZXJtYXJraW5nQ29uZmlnJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJ2dvb2dsZSUyRmdlbW1hLTItMmInJTJDJTIwcGFkZGluZ19zaWRlJTNEJTIybGVmdCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCgnZ29vZ2xlJTJGZ2VtbWEtMi0yYicpJTBBJTBBJTIzJTIwU3ludGhJRCUyMFRleHQlMjBjb25maWd1cmF0aW9uJTBBd2F0ZXJtYXJraW5nX2NvbmZpZyUyMCUzRCUyMFN5bnRoSURUZXh0V2F0ZXJtYXJraW5nQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGtleXMlM0QlNUI2NTQlMkMlMjA0MDAlMkMlMjA4MzYlMkMlMjAxMjMlMkMlMjAzNDAlMkMlMjA0NDMlMkMlMjA1OTclMkMlMjAxNjAlMkMlMjA1NyU1RCUyQyUwQSUyMCUyMCUyMCUyMG5ncmFtX2xlbiUzRDUlMkMlMEEpJTBBJTBBJTIzJTIwR2VuZXJhdGlvbiUyMHdpdGglMjB3YXRlcm1hcmtpbmclMEF0b2tlbml6ZWRfcHJvbXB0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQW91dHB1dF9zZXF1ZW5jZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKnRva2VuaXplZF9wcm9tcHRzJTJDJTIwd2F0ZXJtYXJraW5nX2NvbmZpZyUzRHdhdGVybWFya2luZ19jb25maWclMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUwQSklMEF3YXRlcm1hcmtlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRfc2VxdWVuY2VzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, SynthIDTextWatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># SynthID Text configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = SynthIDTextWatermarkingConfig(
<span class="hljs-meta">... </span>    keys=[<span class="hljs-number">654</span>, <span class="hljs-number">400</span>, <span class="hljs-number">836</span>, <span class="hljs-number">123</span>, <span class="hljs-number">340</span>, <span class="hljs-number">443</span>, <span class="hljs-number">597</span>, <span class="hljs-number">160</span>, <span class="hljs-number">57</span>],
<span class="hljs-meta">... </span>    ngram_len=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generation with watermarking</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_prompts = tokenizer([<span class="hljs-string">&quot;Once upon a time, &quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output_sequences = model.generate(
<span class="hljs-meta">... </span>    **tokenized_prompts, watermarking_config=watermarking_config, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">10</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarked_text = tokenizer.batch_decode(output_sequences, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function NZ(j){let c,$=`Make sure that <code>do_sample=True</code> is included in the <code>generate</code> arguments otherwise the temperature value won’t have
any effect.`;return{c(){c=o("p"),c.innerHTML=$},l(y){c=l(y,"P",{"data-svelte-h":!0}),_(c)!=="svelte-1byeoum"&&(c.innerHTML=$)},m(y,d){p(y,c,d)},p:x,d(y){y&&n(c)}}}function HZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwc2V0X3NlZWQlMEElMEFzZXRfc2VlZCgwKSUyMCUyMCUyMyUyMGZvciUyMHJlcHJvZHVjaWJpbGl0eSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsLmNvbmZpZy5wYWRfdG9rZW5faWQlMjAlM0QlMjBtb2RlbC5jb25maWcuZW9zX3Rva2VuX2lkJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkh1Z2dpbmclMjBGYWNlJTIwQ29tcGFueSUyMGlzJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwdGVtcGVyYXR1cmUlM0QxLjAlMkMlMjB0aGUlMjBkZWZhdWx0JTJDJTIwd2UlMjBjb25zaXN0ZW50bHklMjBnZXQlMjByYW5kb20lMjBvdXRwdXRzJTIwZHVlJTIwdG8lMjByYW5kb20lMjBzYW1wbGluZy4lMEFnZW5lcmF0ZV9rd2FyZ3MlMjAlM0QlMjAlN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDEwJTJDJTIwJTIyZG9fc2FtcGxlJTIyJTNBJTIwVHJ1ZSUyQyUyMCUyMnRlbXBlcmF0dXJlJTIyJTNBJTIwMS4wJTJDJTIwJTIybnVtX3JldHVybl9zZXF1ZW5jZXMlMjIlM0ElMjAyJTdEJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwKipnZW5lcmF0ZV9rd2FyZ3MpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSUwQSUyMyUyMEhvd2V2ZXIlMkMlMjB3aXRoJTIwdGVtcGVyYXR1cmUlMjBjbG9zZSUyMHRvJTIwMCUyQyUyMGl0JTIwYXBwcm94aW1hdGVzJTIwZ3JlZWR5JTIwZGVjb2RpbmclMjBzdHJhdGVnaWVzJTIwKGludmFyaWFudCklMEFnZW5lcmF0ZV9rd2FyZ3MlNUIlMjJ0ZW1wZXJhdHVyZSUyMiU1RCUyMCUzRCUyMDAuMDAwMSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMCoqZ2VuZXJhdGVfa3dhcmdzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># for reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Hugging Face Company is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With temperature=1.0, the default, we consistently get random outputs due to random sampling.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs = {<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&quot;num_return_sequences&quot;</span>: <span class="hljs-number">2</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is one of these companies that is going to take a&#x27;</span>,
<span class="hljs-string">&quot;Hugging Face Company is a brand created by Brian A. O&#x27;Neil&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># However, with temperature close to 0, it approximates greedy decoding strategies (invariant)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs[<span class="hljs-string">&quot;temperature&quot;</span>] = <span class="hljs-number">0.0001</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>]`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function EZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwQSUyQyUyMEIlMkMlMjBDJTJDJTIwRCUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2l0aCUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwaXMlMjB1bmV4cGVjdGVkJTIwLS0lMjBzb21ldGltZXMlMjB0b28lMjB1bmV4cGVjdGVkLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwJTYwdG9wX2slNjAlMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdGhlJTIwayUyMG1vc3QlMjBsaWtlbHklMjB0b2tlbnMuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwSW4lMjBwcmFjdGljZSUyQyUyMExMTXMlMjB1c2UlMjAlNjB0b3BfayU2MCUyMGluJTIwdGhlJTIwNS01MCUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfayUzRDIpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: A, B, C, D&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, E — S — O, P — R

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_k\` sampling, the output gets restricted the k most likely tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_k\` in the 5-50 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_k=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, E, F, G, H, I`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function qZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMCU2MHRvcF9wJTYwJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRvJTIwaGlnaC1wcm9iYWJpbGl0eSUyMHRva2Vucy4lMEElMjMlMjBQcm8lMjB0aXAlM0ElMjBJbiUyMHByYWN0aWNlJTJDJTIwTExNcyUyMHVzZSUyMCU2MHRvcF9wJTYwJTIwaW4lMjB0aGUlMjAwLjktMC45NSUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfcCUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_p\` sampling, the output gets restricted to high-probability tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_p\` in the 0.9-0.95 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function QZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that greedy decoding produces a sequence of numbers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>, <span class="hljs-number">10</span>,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For this particular seed, we can see that sampling produces nearly the same low-information (= low entropy)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sequence</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span> <span class="hljs-keyword">and</span> <span class="hljs-number">10</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`typical_p\` set, the most obvious sequence is no longer produced, which may be good for your problem</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, do_sample=<span class="hljs-literal">True</span>, typical_p=<span class="hljs-number">0.1</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.sequences, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> <span class="hljs-keyword">and</span> <span class="hljs-number">5</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that the token corresponding to &quot;4&quot; (token 934) in the second position, the most likely token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># as seen with greedy decoding, was entirely blocked out</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">934</span>])
tensor(-inf)`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function DZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJUb2RheSUyQyUyMGElMjBkcmFnb24lMjBmbGV3JTIwb3ZlciUyMFBhcmlzJTJDJTIwRnJhbmNlJTJDJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDEuNSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQlMEElMEElMjMlMjB3aXRoJTIwYSUyMG5lZ2F0aXZlJTIwcHJvbXB0JTBBbmVnX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBJTIwdmVyeSUyMGhhcHB5JTIwZXZlbnQlMjBoYXBwZW5lZCUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QyJTJDJTIwbmVnYXRpdmVfcHJvbXB0X2lkcyUzRG5lZ19pbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwd2l0aCUyMGElMjBwb3NpdGl2ZSUyMHByb21wdCUwQW5lZ19pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyQSUyMHZlcnklMjBoYXBweSUyMGV2ZW50JTIwaGFwcGVuZWQlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMCUyQyUyMG5lZ2F0aXZlX3Byb21wdF9pZHMlM0RuZWdfaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today, a dragon flew over Paris, France,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">1.5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 50 people and injuring more than 100&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a negative prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">2</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 130 people. French media reported that&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a positive prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">0</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Today, a dragon flew over Paris, France, and I&#x27;m very happy to be here. I&quot;</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function YZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBHZW5lcmF0aW9uQ29uZmlnJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIzJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfZmVhdHVyZXMlMjAlM0QlMjBpbnB1dHMuaW5wdXRfZmVhdHVyZXMlMEElMEElMjNEaXNwbGF5aW5nJTIwdGltZXN0YW1wcyUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlM0RpbnB1dF9mZWF0dXJlcyUyQyUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwZGVjb2RlX3dpdGhfdGltZXN0YW1wcyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKSUwQSUwQSUwQSUyM05vJTIwdGltZXN0YW1wcyUyMCUyNiUyMGNoYW5nZSUyMEVPUyUzQSUwQSUyM1RoaXMlMjBhbGxvd3MlMjB0aGUlMjB1c2VyJTIwdG8lMjBzZWxlY3QlMjBhJTIwc3BlY2lmaWMlMjB0b2tlbiUyMHRvJTIwdGVybWluYXRlJTIwdGhlJTIwc2VxdWVuY2UlMjBvbiUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMjBpdCdzJTIwdGhlJTIwd29yZCUyMCUyMmNhbiUyMig0NjApJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuZW9zX3Rva2VuX2lkJTIwJTNEJTIwNDYwJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyUzRGlucHV0X2ZlYXR1cmVzJTJDcmV0dXJuX3RpbWVzdGFtcHMlM0RGYWxzZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration, GenerationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">3</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_features = inputs.input_features

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment">#Displaying timestamps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features, return_timestamps=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, decode_with_timestamps=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription: &lt;|startoftranscript|&gt;&lt;|<span class="hljs-number">0.00</span>|&gt; He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all, and can&lt;|6.44|&gt;&lt;|6.44|&gt; discover in it but little of rocky Ithaca.&lt;|9.44|&gt;&lt;|endoftext|&gt;


&gt;&gt;&gt; #No timestamps &amp; change EOS:
&gt;&gt;&gt; #This allows the user to select a specific token to terminate the sequence on, in this case it&#x27;</span>s the word <span class="hljs-string">&quot;can&quot;</span>(<span class="hljs-number">460</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.eos_token_id = <span class="hljs-number">460</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features,return_timestamps=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription:  He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all and can</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function PZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFdhdGVybWFya2luZ0NvbmZpZyUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBbGljZSUyMGFuZCUyMEJvYiUyMGFyZSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwbm9ybWFsJTIwZ2VuZXJhdGlvbiUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMG1heF9sZW5ndGglM0QyMCUyQyUyMGRvX3NhbXBsZSUzREZhbHNlKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMHdhdGVybWFya2VkJTIwZ2VuZXJhdGlvbiUwQXdhdGVybWFya2luZ19jb25maWclMjAlM0QlMjBXYXRlcm1hcmtpbmdDb25maWcoYmlhcyUzRDIuNSUyQyUyMGNvbnRleHRfd2lkdGglM0QyJTJDJTIwc2VlZGluZ19zY2hlbWUlM0QlMjJzZWxmaGFzaCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjB3YXRlcm1hcmtpbmdfY29uZmlnJTNEd2F0ZXJtYXJraW5nX2NvbmZpZyUyQyUyMG1heF9sZW5ndGglM0QyMCUyQyUyMGRvX3NhbXBsZSUzREZhbHNlKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMHRvJTIwZGV0ZWN0JTIwd2F0ZXJtYXJrZWQlMjB0ZXh0JTIwdXNlJTIwdGhlJTIwV2F0ZXJtYXJrRGV0ZWN0b3IlMjBjbGFzcyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBXYXRlcm1hcmtEZXRlY3RvciUwQWRldGVjdG9yJTIwJTNEJTIwV2F0ZXJtYXJrRGV0ZWN0b3IobW9kZWxfY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwZGV2aWNlJTNEJTIyY3B1JTIyJTJDJTIwd2F0ZXJtYXJraW5nX2NvbmZpZyUzRCUyMHdhdGVybWFya2luZ19jb25maWcpJTBBZGV0ZWN0aW9uX3ByZWRzJTIwJTNEJTIwZGV0ZWN0b3Iob3V0KSUwQWRldGVjdGlvbl9wcmVkcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, WatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Alice and Bob are&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># normal generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_length=<span class="hljs-number">20</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Alice and Bob are both in the same room.\\n\\n&quot;I\\&#x27;m not sure if you\\&#x27;re&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># watermarked generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = WatermarkingConfig(bias=<span class="hljs-number">2.5</span>, context_width=<span class="hljs-number">2</span>, seeding_scheme=<span class="hljs-string">&quot;selfhash&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], watermarking_config=watermarking_config, max_length=<span class="hljs-number">20</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Alice and Bob are both still alive and well and the story is pretty much a one-hour adventure&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to detect watermarked text use the WatermarkDetector class</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WatermarkDetector
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = WatermarkDetector(model_config=model.config, device=<span class="hljs-string">&quot;cpu&quot;</span>, watermarking_config= watermarking_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_preds = detector(out)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_preds
array([ <span class="hljs-literal">True</span>])`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function AZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnBoaS0yJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnBoaS0yJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUaGUlMjBiaWdnZXN0JTIwc3RhdGVzJTIwaW4lMjB0aGUlMjBVU0ElMjBieSUyMGxhbmQlMjBhcmVhJTNBJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBQYXNzaW5nJTIwb25lJTIwb3IlMjBtb3JlJTIwc3RvcCUyMHN0cmluZ3MlMjB3aWxsJTIwaGFsdCUyMGdlbmVyYXRpb24lMjBhZnRlciUyMHRob3NlJTIwc3RyaW5ncyUyMGFyZSUyMGVtaXR0ZWQlMEElMjMlMjBOb3RlJTIwdGhhdCUyMGdlbmVyYXRpbmclMjB3aXRoJTIwc3RvcCUyMHN0cmluZ3MlMjByZXF1aXJlcyUyMHlvdSUyMHRvJTIwcGFzcyUyMHRoZSUyMHRva2VuaXplciUyMHRvbyUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHN0b3Bfc3RyaW5ncyUzRCU1QiUyMlRleGFzJTIyJTVEJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuX291dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The biggest states in the USA by land area:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The biggest states <span class="hljs-keyword">in</span> the USA by land area:
- Alaska
- Texas
- California

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Passing one or more stop strings will halt generation after those strings are emitted</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that generating with stop strings requires you to pass the tokenizer too</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, stop_strings=[<span class="hljs-string">&quot;Texas&quot;</span>], tokenizer=tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The biggest states <span class="hljs-keyword">in</span> the USA by land area:
- Alaska
- Texas`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function OZ(j){let c,$;return c=new U({props:{code:"Y29tcGxldGVkJTIwJTNEJTIwRmFsc2UlMEF3aGlsZSUyMG5vdCUyMGNvbXBsZXRlZCUzQSUwQSUyMCUyMCUyMCUyMF8lMkMlMjBjb21wbGV0ZWQlMjAlM0QlMjBjb25zdHJhaW50LnVwZGF0ZShjb25zdHJhaW50LmFkdmFuY2UoKSk=",highlighted:`completed = <span class="hljs-literal">False</span>
<span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> completed:
    _, completed = constraint.update(constraint.advance())`,wrap:!1}}),{c(){m(c.$$.fragment)},l(y){h(c.$$.fragment,y)},m(y,d){g(c,y,d),$=!0},p:x,i(y){$||(u(c.$$.fragment,y),$=!0)},o(y){f(c.$$.fragment,y),$=!1},d(y){b(c,y)}}}function KZ(j){let c,$="The API for the streamer classes is still under development and may change in the future.";return{c(){c=o("p"),c.textContent=$},l(y){c=l(y,"P",{"data-svelte-h":!0}),_(c)!=="svelte-gv2g1g"&&(c.textContent=$)},m(y,d){p(y,c,d)},p:x,d(y){y&&n(c)}}}function eC(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRTdHJlYW1lciUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0U3RyZWFtZXIodG9rKSUwQSUwQSUyMyUyMERlc3BpdGUlMjByZXR1cm5pbmclMjB0aGUlMjB1c3VhbCUyMG91dHB1dCUyQyUyMHRoZSUyMHN0cmVhbWVyJTIwd2lsbCUyMGFsc28lMjBwcmludCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjB0byUyMHN0ZG91dC4lMEFfJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBzdHJlYW1lciUzRHN0cmVhbWVyJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Despite returning the usual output, the streamer will also print the generated text to stdout.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model.generate(**inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function tC(j){let c,$="The API for the streamer classes is still under development and may change in the future.";return{c(){c=o("p"),c.textContent=$},l(y){c=l(y,"P",{"data-svelte-h":!0}),_(c)!=="svelte-gv2g1g"&&(c.textContent=$)},m(y,d){p(y,c,d)},p:x,d(y){y&&n(c)}}}function sC(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRJdGVyYXRvclN0cmVhbWVyJTBBZnJvbSUyMHRocmVhZGluZyUyMGltcG9ydCUyMFRocmVhZCUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0SXRlcmF0b3JTdHJlYW1lcih0b2spJTBBJTBBJTIzJTIwUnVuJTIwdGhlJTIwZ2VuZXJhdGlvbiUyMGluJTIwYSUyMHNlcGFyYXRlJTIwdGhyZWFkJTJDJTIwc28lMjB0aGF0JTIwd2UlMjBjYW4lMjBmZXRjaCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjBpbiUyMGElMjBub24tYmxvY2tpbmclMjB3YXkuJTBBZ2VuZXJhdGlvbl9rd2FyZ3MlMjAlM0QlMjBkaWN0KGlucHV0cyUyQyUyMHN0cmVhbWVyJTNEc3RyZWFtZXIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKSUwQXRocmVhZCUyMCUzRCUyMFRocmVhZCh0YXJnZXQlM0Rtb2RlbC5nZW5lcmF0ZSUyQyUyMGt3YXJncyUzRGdlbmVyYXRpb25fa3dhcmdzKSUwQXRocmVhZC5zdGFydCgpJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjAlMjIlMjIlMEFmb3IlMjBuZXdfdGV4dCUyMGluJTIwc3RyZWFtZXIlM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfdGV4dCUyMCUyQiUzRCUyMG5ld190ZXh0JTBBZ2VuZXJhdGVkX3RleHQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextIteratorStreamer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> threading <span class="hljs-keyword">import</span> Thread

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextIteratorStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run the generation in a separate thread, so that we can fetch the generated text in a non-blocking way.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_kwargs = <span class="hljs-built_in">dict</span>(inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread = Thread(target=model.generate, kwargs=generation_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread.start()
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> new_text <span class="hljs-keyword">in</span> streamer:
<span class="hljs-meta">... </span>    generated_text += new_text
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text
<span class="hljs-string">&#x27;An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,&#x27;</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function nC(j){let c,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMER5bmFtaWNDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBRd2VuMiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMER5bmFtaWNDYWNoZSgpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSklMEFvdXRwdXRzLnBhc3Rfa2V5X3ZhbHVlcyUyMCUyMyUyMGFjY2VzcyUyMGNhY2hlJTIwZmlsbGVkJTIwd2l0aCUyMGtleSUyRnZhbHVlcyUyMGZyb20lMjBnZW5lcmF0aW9u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, DynamicCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
DynamicCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-11lpom8"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function aC(j){let c,$="Example:",y,d,w;return d=new U({props:{code:"JTIzJTIwUnVuJTIwcGlwJTIwaW5zdGFsbCUyMHF1YW50byUyMGZpcnN0JTIwaWYlMjB5b3UlMjBkb24ndCUyMGhhdmUlMjBpdCUyMHlldCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBRdWFudG9RdWFudGl6ZWRDYWNoZSUyQyUyMFF1YW50aXplZENhY2hlQ29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMFF3ZW4yJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBQcmVwYXJlJTIwYSUyMGNhY2hlJTIwY2xhc3MlMjBhbmQlMjBwYXNzJTIwaXQlMjB0byUyMG1vZGVsJ3MlMjBmb3J3YXJkJTBBY2FjaGVfY29uZmlnJTIwJTNEJTIwUXVhbnRpemVkQ2FjaGVDb25maWcobmJpdHMlM0Q0KSUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMFF1YW50b1F1YW50aXplZENhY2hlKGNhY2hlX2NvbmZpZyUzRGNhY2hlX2NvbmZpZyklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBwYXN0X2tleV92YWx1ZXMlM0RwYXN0X2tleV92YWx1ZXMlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKSUwQW91dHB1dHMucGFzdF9rZXlfdmFsdWVzJTIwJTIzJTIwYWNjZXNzJTIwY2FjaGUlMjBmaWxsZWQlMjB3aXRoJTIwa2V5JTJGdmFsdWVzJTIwZnJvbSUyMGdlbmVyYXRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run pip install quanto first if you don&#x27;t have it yet</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, QuantoQuantizedCache, QuantizedCacheConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cache_config = QuantizedCacheConfig(nbits=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = QuantoQuantizedCache(cache_config=cache_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
QuantoQuantizedCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-11lpom8"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function rC(j){let c,$="Example:",y,d,w;return d=new U({props:{code:"JTIzJTIwUnVuJTIwcGlwJTIwaW5zdGFsbCUyMGhxcSUyMGZpcnN0JTIwaWYlMjB5b3UlMjBkb24ndCUyMGhhdmUlMjBpdCUyMHlldCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBIUVFRdWFudGl6ZWRDYWNoZSUyQyUyMFF1YW50aXplZENhY2hlQ29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMFF3ZW4yJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBQcmVwYXJlJTIwYSUyMGNhY2hlJTIwY2xhc3MlMjBhbmQlMjBwYXNzJTIwaXQlMjB0byUyMG1vZGVsJ3MlMjBmb3J3YXJkJTBBY2FjaGVfY29uZmlnJTIwJTNEJTIwUXVhbnRpemVkQ2FjaGVDb25maWcobmJpdHMlM0Q0JTJDJTIwYXhpc19rZXklM0QxJTJDJTIwYXhpc192YWx1ZSUzRDEpJTBBcGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwSFFRUXVhbnRpemVkQ2FjaGUoY2FjaGVfY29uZmlnJTNEY2FjaGVfY29uZmlnKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUyMHVzZV9jYWNoZSUzRFRydWUpJTBBb3V0cHV0cy5wYXN0X2tleV92YWx1ZXMlMjAlMjMlMjBhY2Nlc3MlMjBjYWNoZSUyMGZpbGxlZCUyMHdpdGglMjBrZXklMkZ2YWx1ZXMlMjBmcm9tJTIwZ2VuZXJhdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run pip install hqq first if you don&#x27;t have it yet</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, HQQQuantizedCache, QuantizedCacheConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cache_config = QuantizedCacheConfig(nbits=<span class="hljs-number">4</span>, axis_key=<span class="hljs-number">1</span>, axis_value=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = HQQQuantizedCache(cache_config=cache_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
HQQQuantizedCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-11lpom8"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function oC(j){let c,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFNpbmtDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBRd2VuMiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMFNpbmtDYWNoZSh3aW5kb3dfbGVuZ3RoJTNEMjU2JTJDJTIwbnVtX3NpbmtfdG9rZW5zJTNENCklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBwYXN0X2tleV92YWx1ZXMlM0RwYXN0X2tleV92YWx1ZXMlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKSUwQW91dHB1dHMucGFzdF9rZXlfdmFsdWVzJTIwJTIzJTIwYWNjZXNzJTIwY2FjaGUlMjBmaWxsZWQlMjB3aXRoJTIwa2V5JTJGdmFsdWVzJTIwZnJvbSUyMGdlbmVyYXRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, SinkCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = SinkCache(window_length=<span class="hljs-number">256</span>, num_sink_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
SinkCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-11lpom8"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function lC(j){let c,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFN0YXRpY0NhY2hlJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItY2hhdC1oZiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBMbGFtYSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQSUyMyUyMExlYXZlJTIwZW1wdHklMjBzcGFjZSUyMGZvciUyMDEwJTIwbmV3JTIwdG9rZW5zJTJDJTIwd2hpY2glMjBjYW4lMjBiZSUyMHVzZWQlMjB3aGVuJTIwY2FsbGluZyUyMGZvcndhcmQlMjBpdGVyYXRpdmVseSUyMDEwJTIwdGltZXMlMjB0byUyMGdlbmVyYXRlJTBBbWF4X2dlbmVyYXRlZF9sZW5ndGglMjAlM0QlMjBpbnB1dHMuaW5wdXRfaWRzLnNoYXBlJTVCMSU1RCUyMCUyQiUyMDEwJTBBcGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwU3RhdGljQ2FjaGUoY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwYmF0Y2hfc2l6ZSUzRDElMkMlMjBtYXhfY2FjaGVfbGVuJTNEbWF4X2dlbmVyYXRlZF9sZW5ndGglMkMlMjBkZXZpY2UlM0Rtb2RlbC5kZXZpY2UlMkMlMjBkdHlwZSUzRG1vZGVsLmR0eXBlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUyMHVzZV9jYWNoZSUzRFRydWUpJTBBb3V0cHV0cy5wYXN0X2tleV92YWx1ZXMlMjAlMjMlMjBhY2Nlc3MlMjBjYWNoZSUyMGZpbGxlZCUyMHdpdGglMjBrZXklMkZ2YWx1ZXMlMjBmcm9tJTIwZ2VuZXJhdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, StaticCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Llama&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = StaticCache(config=model.config, batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
StaticCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-11lpom8"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function cC(j){let c,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyME9mZmxvYWRlZFN0YXRpY0NhY2hlJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMEdQVDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFByZXBhcmUlMjBhJTIwY2FjaGUlMjBjbGFzcyUyMGFuZCUyMHBhc3MlMjBpdCUyMHRvJTIwbW9kZWwncyUyMGZvcndhcmQlMEElMjMlMjBMZWF2ZSUyMGVtcHR5JTIwc3BhY2UlMjBmb3IlMjAxMCUyMG5ldyUyMHRva2VucyUyQyUyMHdoaWNoJTIwY2FuJTIwYmUlMjB1c2VkJTIwd2hlbiUyMGNhbGxpbmclMjBmb3J3YXJkJTIwaXRlcmF0aXZlbHklMjAxMCUyMHRpbWVzJTIwdG8lMjBnZW5lcmF0ZSUwQW1heF9nZW5lcmF0ZWRfbGVuZ3RoJTIwJTNEJTIwaW5wdXRzLmlucHV0X2lkcy5zaGFwZSU1QjElNUQlMjAlMkIlMjAxMCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyME9mZmxvYWRlZFN0YXRpY0NhY2hlKGNvbmZpZyUzRG1vZGVsLmNvbmZpZyUyQyUyMG1heF9iYXRjaF9zaXplJTNEMSUyQyUyMG1heF9jYWNoZV9sZW4lM0RtYXhfZ2VuZXJhdGVkX2xlbmd0aCUyQyUyMGRldmljZSUzRG1vZGVsLmRldmljZSUyQyUyMGR0eXBlJTNEbW9kZWwuZHR5cGUpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSklMEFwYXN0X2t2X2xlbmd0aCUyMCUzRCUyMG91dHB1dHMucGFzdF9rZXlfdmFsdWVzJTIwJTIzJTIwYWNjZXNzJTIwY2FjaGUlMjBmaWxsZWQlMjB3aXRoJTIwa2V5JTJGdmFsdWVzJTIwZnJvbSUyMGdlbmVyYXRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, OffloadedStaticCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is GPT2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = OffloadedStaticCache(config=model.config, max_batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>past_kv_length = outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-11lpom8"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function iC(j){let c,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMEh5YnJpZENhY2hlJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZ2VtbWEtMi0yYiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZnZW1tYS0yLTJiJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBHZW1tYSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQSUyMyUyMExlYXZlJTIwZW1wdHklMjBzcGFjZSUyMGZvciUyMDEwJTIwbmV3JTIwdG9rZW5zJTJDJTIwd2hpY2glMjBjYW4lMjBiZSUyMHVzZWQlMjB3aGVuJTIwY2FsbGluZyUyMGZvcndhcmQlMjBpdGVyYXRpdmVseSUyMDEwJTIwdGltZXMlMjB0byUyMGdlbmVyYXRlJTBBbWF4X2dlbmVyYXRlZF9sZW5ndGglMjAlM0QlMjBpbnB1dHMuaW5wdXRfaWRzLnNoYXBlJTVCMSU1RCUyMCUyQiUyMDEwJTBBcGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwSHlicmlkQ2FjaGUoY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwYmF0Y2hfc2l6ZSUzRDElMkMlMjBtYXhfY2FjaGVfbGVuJTNEbWF4X2dlbmVyYXRlZF9sZW5ndGglMkMlMjBkZXZpY2UlM0Rtb2RlbC5kZXZpY2UlMkMlMjBkdHlwZSUzRG1vZGVsLmR0eXBlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUyMHVzZV9jYWNoZSUzRFRydWUpJTBBb3V0cHV0cy5wYXN0X2tleV92YWx1ZXMlMjAlMjMlMjBhY2Nlc3MlMjBjYWNoZSUyMGZpbGxlZCUyMHdpdGglMjBrZXklMkZ2YWx1ZXMlMjBmcm9tJTIwZ2VuZXJhdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, HybridCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2-2b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2-2b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Gemma&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = HybridCache(config=model.config, batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
HybridCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-11lpom8"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function dC(j){let c,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFNsaWRpbmdXaW5kb3dDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItSW5zdHJ1Y3QtdjAuMyUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLUluc3RydWN0LXYwLjMlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyME1pc3RyYWwlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFByZXBhcmUlMjBhJTIwY2FjaGUlMjBjbGFzcyUyMGFuZCUyMHBhc3MlMjBpdCUyMHRvJTIwbW9kZWwncyUyMGZvcndhcmQlMEElMjMlMjBMZWF2ZSUyMGVtcHR5JTIwc3BhY2UlMjBmb3IlMjAxMCUyMG5ldyUyMHRva2VucyUyQyUyMHdoaWNoJTIwY2FuJTIwYmUlMjB1c2VkJTIwd2hlbiUyMGNhbGxpbmclMjBmb3J3YXJkJTIwaXRlcmF0aXZlbHklMjAxMCUyMHRpbWVzJTIwdG8lMjBnZW5lcmF0ZSUwQW1heF9nZW5lcmF0ZWRfbGVuZ3RoJTIwJTNEJTIwaW5wdXRzLmlucHV0X2lkcy5zaGFwZSU1QjElNUQlMjAlMkIlMjAxMCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMFNsaWRpbmdXaW5kb3dDYWNoZShjb25maWclM0Rtb2RlbC5jb25maWclMkMlMjBiYXRjaF9zaXplJTNEMSUyQyUyMG1heF9jYWNoZV9sZW4lM0RtYXhfZ2VuZXJhdGVkX2xlbmd0aCUyQyUyMGRldmljZSUzRG1vZGVsLmRldmljZSUyQyUyMGR0eXBlJTNEbW9kZWwuZHR5cGUpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSklMEFvdXRwdXRzLnBhc3Rfa2V5X3ZhbHVlcyUyMCUyMyUyMGFjY2VzcyUyMGNhY2hlJTIwZmlsbGVkJTIwd2l0aCUyMGtleSUyRnZhbHVlcyUyMGZyb20lMjBnZW5lcmF0aW9u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, SlidingWindowCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.3&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.3&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Mistral&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = SlidingWindowCache(config=model.config, batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
SlidingWindowCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-11lpom8"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function pC(j){let c,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMER5bmFtaWNDYWNoZSUyQyUyMEVuY29kZXJEZWNvZGVyQ2FjaGUlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRndoaXNwZXItc21hbGwlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGF1ZGlvJTNEWU9VUi1BVURJTyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGNhY2hlJTIwY2xhc3NlcyUyMGZvciUyMGVuY29kZXIlMjBhbmQlMjBkZWNvZGVyJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXNlbGZfYXR0ZW50aW9uX2NhY2hlJTIwJTNEJTIwRHluYW1pY0NhY2hlKCklMEFjcm9zc19hdHRlbnRpb25fY2FjaGUlMjAlM0QlMjBEeW5hbWljQ2FjaGUoKSUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMEVuY29kZXJEZWNvZGVyQ2FjaGUoc2VsZl9hdHRlbnRpb25fY2FjaGUlMkMlMjBjcm9zc19hdHRlbnRpb25fY2FjaGUpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSklMEFvdXRwdXRzLnBhc3Rfa2V5X3ZhbHVlcyUyMCUyMyUyMGFjY2VzcyUyMGNhY2hlJTIwZmlsbGVkJTIwd2l0aCUyMGtleSUyRnZhbHVlcyUyMGZyb20lMjBnZW5lcmF0aW9u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForCausalLM, DynamicCache, EncoderDecoderCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(audio=YOUR-AUDIO, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare cache classes for encoder and decoder and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>self_attention_cache = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>cross_attention_cache = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = EncoderDecoderCache(self_attention_cache, cross_attention_cache)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
EncoderDecoderCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-11lpom8"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function mC(j){let c,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNYW1iYUZvckNhdXNhbExNJTJDJTIwTWFtYmFDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwTWFtYmFGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhdGUtc3BhY2VzJTJGbWFtYmEtMTMwbS1oZiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzdGF0ZS1zcGFjZXMlMkZtYW1iYS0xMzBtLWhmJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBNYW1iYSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyME1hbWJhQ2FjaGUoY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwYmF0Y2hfc2l6ZSUzRDElMkMlMjBkZXZpY2UlM0Rtb2RlbC5kZXZpY2UlMkMlMjBkdHlwZSUzRG1vZGVsLmR0eXBlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUyMHVzZV9jYWNoZSUzRFRydWUpJTBBb3V0cHV0cy5wYXN0X2tleV92YWx1ZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MambaForCausalLM, MambaCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MambaForCausalLM.from_pretrained(<span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Mamba&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = MambaCache(config=model.config, batch_size=<span class="hljs-number">1</span>, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values
MambaCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-11lpom8"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function hC(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFdhdGVybWFya0RldGVjdG9yJTJDJTIwV2F0ZXJtYXJraW5nQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXRvay5wYWRfdG9rZW5faWQlMjAlM0QlMjB0b2suZW9zX3Rva2VuX2lkJTBBdG9rLnBhZGRpbmdfc2lkZSUyMCUzRCUyMCUyMmxlZnQlMjIlMEElMEFpbnB1dHMlMjAlM0QlMjB0b2soJTVCJTIyVGhpcyUyMGlzJTIwdGhlJTIwYmVnaW5uaW5nJTIwb2YlMjBhJTIwbG9uZyUyMHN0b3J5JTIyJTJDJTIwJTIyQWxpY2UlMjBhbmQlMjBCb2IlMjBhcmUlMjIlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfbGVuJTIwJTNEJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnNoYXBlJTVCLTElNUQlMEElMEElMjMlMjBmaXJzdCUyMGdlbmVyYXRlJTIwdGV4dCUyMHdpdGglMjB3YXRlcm1hcmslMjBhbmQlMjB3aXRob3V0JTBBd2F0ZXJtYXJraW5nX2NvbmZpZyUyMCUzRCUyMFdhdGVybWFya2luZ0NvbmZpZyhiaWFzJTNEMi41JTJDJTIwc2VlZGluZ19zY2hlbWUlM0QlMjJzZWxmaGFzaCUyMiklMEFvdXRfd2F0ZXJtYXJrZWQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHdhdGVybWFya2luZ19jb25maWclM0R3YXRlcm1hcmtpbmdfY29uZmlnJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMjBtYXhfbGVuZ3RoJTNEMjApJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9sZW5ndGglM0QyMCklMEElMEElMjMlMjBub3clMjB3ZSUyMGNhbiUyMGluc3RhbnRpYXRlJTIwdGhlJTIwZGV0ZWN0b3IlMjBhbmQlMjBjaGVjayUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMEFkZXRlY3RvciUyMCUzRCUyMFdhdGVybWFya0RldGVjdG9yKG1vZGVsX2NvbmZpZyUzRG1vZGVsLmNvbmZpZyUyQyUyMGRldmljZSUzRCUyMmNwdSUyMiUyQyUyMHdhdGVybWFya2luZ19jb25maWclM0R3YXRlcm1hcmtpbmdfY29uZmlnKSUwQWRldGVjdGlvbl9vdXRfd2F0ZXJtYXJrZWQlMjAlM0QlMjBkZXRlY3RvcihvdXRfd2F0ZXJtYXJrZWQlMkMlMjByZXR1cm5fZGljdCUzRFRydWUpJTBBZGV0ZWN0aW9uX291dCUyMCUzRCUyMGRldGVjdG9yKG91dCUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSklMEFkZXRlY3Rpb25fb3V0X3dhdGVybWFya2VkLnByZWRpY3Rpb24lMEElMEFkZXRlY3Rpb25fb3V0LnByZWRpY3Rpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, WatermarkDetector, WatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;openai-community/gpt2&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>tok.pad_token_id = tok.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>tok.padding_side = <span class="hljs-string">&quot;left&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;This is the beginning of a long story&quot;</span>, <span class="hljs-string">&quot;Alice and Bob are&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_len = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># first generate text with watermark and without</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = WatermarkingConfig(bias=<span class="hljs-number">2.5</span>, seeding_scheme=<span class="hljs-string">&quot;selfhash&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out_watermarked = model.generate(**inputs, watermarking_config=watermarking_config, do_sample=<span class="hljs-literal">False</span>, max_length=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_length=<span class="hljs-number">20</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># now we can instantiate the detector and check the generated text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = WatermarkDetector(model_config=model.config, device=<span class="hljs-string">&quot;cpu&quot;</span>, watermarking_config=watermarking_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out_watermarked = detector(out_watermarked, return_dict=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out = detector(out, return_dict=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out_watermarked.prediction
array([ <span class="hljs-literal">True</span>,  <span class="hljs-literal">True</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out.prediction
array([<span class="hljs-literal">False</span>,  <span class="hljs-literal">False</span>])`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function gC(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFN5bnRoSURUZXh0V2F0ZXJtYXJraW5nQ29uZmlnJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJ2dvb2dsZSUyRmdlbW1hLTItMmInJTJDJTIwcGFkZGluZ19zaWRlJTNEJTIybGVmdCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCgnZ29vZ2xlJTJGZ2VtbWEtMi0yYicpJTBBJTBBJTIzJTIwU3ludGhJRCUyMFRleHQlMjBjb25maWd1cmF0aW9uJTBBd2F0ZXJtYXJraW5nX2NvbmZpZyUyMCUzRCUyMFN5bnRoSURUZXh0V2F0ZXJtYXJraW5nQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGtleXMlM0QlNUI2NTQlMkMlMjA0MDAlMkMlMjA4MzYlMkMlMjAxMjMlMkMlMjAzNDAlMkMlMjA0NDMlMkMlMjA1OTclMkMlMjAxNjAlMkMlMjA1NyU1RCUyQyUwQSUyMCUyMCUyMCUyMG5ncmFtX2xlbiUzRDUlMkMlMEEpJTBBJTBBJTIzJTIwR2VuZXJhdGlvbiUyMHdpdGglMjB3YXRlcm1hcmtpbmclMEF0b2tlbml6ZWRfcHJvbXB0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQW91dHB1dF9zZXF1ZW5jZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKnRva2VuaXplZF9wcm9tcHRzJTJDJTIwd2F0ZXJtYXJraW5nX2NvbmZpZyUzRHdhdGVybWFya2luZ19jb25maWclMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUwQSklMEF3YXRlcm1hcmtlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRfc2VxdWVuY2VzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, SynthIDTextWatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># SynthID Text configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = SynthIDTextWatermarkingConfig(
<span class="hljs-meta">... </span>    keys=[<span class="hljs-number">654</span>, <span class="hljs-number">400</span>, <span class="hljs-number">836</span>, <span class="hljs-number">123</span>, <span class="hljs-number">340</span>, <span class="hljs-number">443</span>, <span class="hljs-number">597</span>, <span class="hljs-number">160</span>, <span class="hljs-number">57</span>],
<span class="hljs-meta">... </span>    ngram_len=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generation with watermarking</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_prompts = tokenizer([<span class="hljs-string">&quot;Once upon a time, &quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output_sequences = model.generate(
<span class="hljs-meta">... </span>    **tokenized_prompts, watermarking_config=watermarking_config, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">10</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarked_text = tokenizer.batch_decode(output_sequences, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function uC(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBBdXRvVG9rZW5pemVyJTJDJTIwQmF5ZXNpYW5EZXRlY3Rvck1vZGVsJTJDJTIwU3ludGhJRFRleHRXYXRlcm1hcmtMb2dpdHNQcm9jZXNzb3IlMkMlMjBTeW50aElEVGV4dFdhdGVybWFya0RldGVjdG9yJTBBKSUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBkZXRlY3Rvci4lMjBTZWUlMjBleGFtcGxlcyUyRnJlc2VhcmNoX3Byb2plY3RzJTJGc3ludGhpZF90ZXh0JTIwZm9yJTIwdHJhaW5pbmclMjBhJTIwZGV0ZWN0b3IuJTBBZGV0ZWN0b3JfbW9kZWwlMjAlM0QlMjBCYXllc2lhbkRldGVjdG9yTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmpvYW9nYW50ZSUyRmR1bW15X3N5bnRoaWRfZGV0ZWN0b3IlMjIpJTBBbG9naXRzX3Byb2Nlc3NvciUyMCUzRCUyMFN5bnRoSURUZXh0V2F0ZXJtYXJrTG9naXRzUHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCoqZGV0ZWN0b3JfbW9kZWwuY29uZmlnLndhdGVybWFya2luZ19jb25maWclMkMlMjBkZXZpY2UlM0QlMjJjcHUlMjIlMEEpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoZGV0ZWN0b3JfbW9kZWwuY29uZmlnLm1vZGVsX25hbWUpJTBBZGV0ZWN0b3IlMjAlM0QlMjBTeW50aElEVGV4dFdhdGVybWFya0RldGVjdG9yKGRldGVjdG9yX21vZGVsJTJDJTIwbG9naXRzX3Byb2Nlc3NvciUyQyUyMHRva2VuaXplciklMEElMEElMjMlMjBUZXN0JTIwd2hldGhlciUyMGElMjBjZXJ0YWluJTIwc3RyaW5nJTIwaXMlMjB3YXRlcm1hcmtlZCUwQXRlc3RfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyVGhpcyUyMGlzJTIwYSUyMHRlc3QlMjBpbnB1dCUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaXNfd2F0ZXJtYXJrZWQlMjAlM0QlMjBkZXRlY3Rvcih0ZXN0X2lucHV0LmlucHV0X2lkcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer, BayesianDetectorModel, SynthIDTextWatermarkLogitsProcessor, SynthIDTextWatermarkDetector
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the detector. See examples/research_projects/synthid_text for training a detector.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector_model = BayesianDetectorModel.from_pretrained(<span class="hljs-string">&quot;joaogante/dummy_synthid_detector&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = SynthIDTextWatermarkLogitsProcessor(
<span class="hljs-meta">... </span>    **detector_model.config.watermarking_config, device=<span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(detector_model.config.model_name)
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = SynthIDTextWatermarkDetector(detector_model, logits_processor, tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Test whether a certain string is watermarked</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>test_input = tokenizer([<span class="hljs-string">&quot;This is a test input&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>is_watermarked = detector(test_input.input_ids)`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=a(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=r(s),h(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),g(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),b(d,s)}}}function fC(j){let c,$,y,d,w,s,k,V$='This page lists all the utility functions used by <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>.',zf,Ga,Vf,Fa,G$=`The output of <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> is an instance of a subclass of
<a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a>. This output is a data structure containing all the information returned
by <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, but that can also be used as tuple or dictionary.`,Gf,Xa,F$="Here’s an example:",Ff,Ra,Xf,La,X$=`The <code>generation_output</code> object is a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateDecoderOnlyOutput">GenerateDecoderOnlyOutput</a>, as we can
see in the documentation of that class below, it means it has the following attributes:`,Rf,Sa,R$="<li><code>sequences</code>: the generated sequences of tokens</li> <li><code>scores</code> (optional): the prediction scores of the language modelling head, for each generation step</li> <li><code>hidden_states</code> (optional): the hidden states of the model, for each generation step</li> <li><code>attentions</code> (optional): the attention weights of the model, for each generation step</li>",Lf,Na,L$=`Here we have the <code>scores</code> since we passed along <code>output_scores=True</code>, but we don’t have <code>hidden_states</code> and
<code>attentions</code> because we didn’t pass <code>output_hidden_states=True</code> or <code>output_attentions=True</code>.`,Sf,Ha,S$=`You can access each attribute as you would usually do, and if that attribute has not been returned by the model, you
will get <code>None</code>. Here for instance <code>generation_output.scores</code> are all the generated prediction scores of the
language modeling head, and <code>generation_output.attentions</code> is <code>None</code>.`,Nf,Ea,N$=`When using our <code>generation_output</code> object as a tuple, it only keeps the attributes that don’t have <code>None</code> values.
Here, for instance, it has two elements, <code>loss</code> then <code>logits</code>, so`,Hf,qa,Ef,Qa,H$="will return the tuple <code>(generation_output.sequences, generation_output.scores)</code> for instance.",qf,Da,E$=`When using our <code>generation_output</code> object as a dictionary, it only keeps the attributes that don’t have <code>None</code>
values. Here, for instance, it has two keys that are <code>sequences</code> and <code>scores</code>.`,Qf,Ya,q$="We document here all output types.",Df,Pa,Yf,ms,Aa,pT,td,Q$="Outputs of decoder-only generation models, when using non-beam methods.",Pf,hs,Oa,mT,sd,D$="Outputs of encoder-decoder generation models, when using non-beam methods.",Af,gs,Ka,hT,nd,Y$="Outputs of decoder-only generation models, when using beam methods.",Of,us,er,gT,ad,P$="Outputs of encoder-decoder generation models, when using beam methods.",Kf,tr,eb,fs,sr,uT,rd,A$=`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,tb,bs,nr,fT,od,O$="Base class for outputs of decoder-only generation models using greedy search.",sb,_s,ar,bT,ld,K$=`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,nb,ys,rr,_T,cd,ej="Base class for outputs of decoder-only generation models using sampling.",ab,Ts,or,yT,id,tj=`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,rb,Ms,lr,TT,dd,sj="Base class for outputs of decoder-only generation models using beam search.",ob,vs,cr,MT,pd,nj=`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,lb,ws,ir,vT,md,aj="Base class for outputs of decoder-only generation models using beam sample.",cb,ks,dr,wT,hd,rj=`Base class for outputs of encoder-decoder generation models using contrastive search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,ib,$s,pr,kT,gd,oj="Base class for outputs of decoder-only generation models using contrastive search.",db,mr,pb,et,hr,$T,ud,lj="Flax Base class for outputs of decoder-only generation models using sampling.",jT,Is,gr,xT,fd,cj="“Returns a new object replacing the specified fields with new values.",mb,tt,ur,JT,bd,ij="Flax Base class for outputs of decoder-only generation models using greedy search.",UT,zs,fr,ZT,_d,dj="“Returns a new object replacing the specified fields with new values.",hb,st,br,CT,yd,pj="Flax Base class for outputs of decoder-only generation models using greedy search.",WT,Vs,_r,BT,Td,mj="“Returns a new object replacing the specified fields with new values.",gb,yr,ub,Tr,hj=`A <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> can be used to modify the prediction scores of a language model head for
generation.`,fb,Mr,bb,ke,vr,IT,Md,gj='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing alternated generation between the two codebooks of Bark.',zT,Gs,VT,vd,wr,_b,S,kr,GT,wd,uj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for classifier free guidance (CFG). The scores are split over the batch dimension,
where the first half correspond to the conditional logits (predicted from the input prompt) and the second half
correspond to the unconditional logits (predicted from an empty or ‘null’ prompt). The processor computes a
weighted average across the conditional and unconditional logits, parameterised by the <code>guidance_scale</code>.`,FT,kd,fj='See <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">the paper</a> for more information.',XT,Fs,RT,Xs,LT,$d,$r,yb,se,jr,ST,jd,bj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/main/en/internal/generation_utils#transformers.NoRepeatNGramLogitsProcessor">NoRepeatNGramLogitsProcessor</a>, but applied exclusively to prevent
the repetition of n-grams present in the prompt.`,NT,xd,_j=`It was designed to promote chattiness in a language model, by preventing the generation of n-grams present in
previous conversation rounds.`,HT,Rs,ET,Jd,xr,Tb,ne,Jr,qT,Ud,yj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/main/en/internal/generation_utils#transformers.RepetitionPenaltyLogitsProcessor">RepetitionPenaltyLogitsProcessor</a>, but with an <em>inverse</em> penalty
that is applied to the tokens present in the prompt. In other words, a penalty above 1.0 increases the odds of
selecting tokens that were present in the prompt.`,QT,Zd,Tj=`It was designed to avoid hallucination in input-grounded tasks, like summarization. Although originally intended
for encoder-decoder models, it can also be used with decoder-only models like LLMs.`,DT,Ls,YT,Cd,Ur,Mb,$e,Zr,PT,Wd,Mj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs epsilon-sampling, i.e. restricting to tokens with <code>prob &gt;= epsilon</code>. Takes the
largest min_tokens_to_keep tokens if no tokens satisfy this constraint. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more information.`,AT,Ss,OT,Bd,Cr,vb,je,Wr,KT,Id,vj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs eta-sampling, a technique to filter out tokens with probabilities below a dynamic
cutoff value, <code>eta</code>, which is calculated based on a combination of the hyperparameter <code>epsilon</code> and the entropy of
the token probabilities, i.e. <code>eta := min(epsilon, sqrt(epsilon * e^-entropy(probabilities)))</code>. Takes the largest
min_tokens_to_keep tokens if no tokens satisfy this constraint. It addresses the issue of poor quality in long
samples of text generated by neural language models leading to more coherent and fluent text. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation
Sampling as Language Model Desmoothing</a> for more information. Note: <code>do_sample</code>
must be set to <code>True</code> for this <code>LogitsProcessor</code> to work.`,eM,Ns,tM,zd,Br,wb,xe,Ir,sM,Vd,wj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that exponentially increases the score of the <code>eos_token_id</code> after <code>start_index</code> has been
reached. This allows generating shorter sequences without having a hard cutoff, allowing the <code>eos_token</code> to be
predicted in a meaningful position.`,nM,Hs,aM,Gd,zr,kb,Je,Vr,rM,Fd,kj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the first generated token. Used with encoder-decoder
models.`,oM,Es,lM,Xd,Gr,$b,Ue,Fr,cM,Rd,$j='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',iM,qs,dM,Ld,Xr,jb,N,Rr,pM,Sd,jj='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces diverse beam search.',mM,Nd,xj=`Note that this logits processor is only effective for <code>PreTrainedModel.group_beam_search</code>. See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">Diverse Beam
Search: Decoding Diverse Solutions from Neural Sequence Models</a> for more
details.`,hM,Hd,Jj=`Traditional beam search often generates very similar sequences across different beams.
<code>HammingDiversityLogitsProcessor</code> addresses this by penalizing beams that generate tokens already chosen by other
beams in the same time step.`,gM,Qs,uM,Ed,Lr,xb,Ze,Sr,fM,qd,Uj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that removes all <code>nan</code> and <code>inf</code> values to avoid the generation method to fail. Note that using
the logits processor should only be used if necessary since it can slow down the generation method.`,bM,Qd,Zj=`This logits processor has no <code>generate</code> example, as there shouldn’t be a correct combination of flags that warrants
its use.`,_M,Dd,Nr,Jb,Ce,Hr,yM,Yd,Cj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for normalizing the scores using log-softmax. It’s important to normalize
the scores during beam search, after applying the logits processors or warpers, since the search algorithm used in
this library doesn’t do it (it only does it before, but they may need re-normalization) but it still supposes that
the scores are normalized when comparing the hypotheses.`,TM,Ds,MM,Pd,Er,Ub,nt,qr,vM,Ad,Wj="Abstract base class for all logit processors that can be applied during generation.",wM,Od,Qr,Zb,at,Dr,kM,Kd,Bj=`This class can be used to create a list of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> to subsequently process a <code>scores</code> input tensor.
This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> to the
inputs.`,$M,ep,Yr,Cb,We,Pr,jM,tp,Ij=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length by setting EOS probability to 0. Note that, for decoder-only models
like most LLMs, the length includes the prompt.`,xM,Ys,JM,sp,Ar,Wb,Be,Or,UM,np,zj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length of new tokens by setting EOS (End-Of-Sequence) token probability to 0.
Contrarily to <a href="/docs/transformers/main/en/internal/generation_utils#transformers.MinLengthLogitsProcessor">MinLengthLogitsProcessor</a>, this processor ignores the prompt.`,ZM,Ps,CM,ap,Kr,Bb,H,eo,WM,rp,Vj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs min-p, i.e. keeps all tokens that are above a minimum probability, scaled by the
probability of the most likely token. As a result, the filter becomes more agressive in the presence of
high-probability tokens, which is a sign of a confident output that we shouldn’t deviate from.`,BM,op,Gj=`Often used together with <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a>. Used as an alternative to <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a> and
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,IM,lp,Fj='Created by @menhguin and @kalomaze (github handles). Code adapted from <a href="https://github.com/oobabooga/text-generation-webui/pull/4449/files" rel="nofollow">this external PR</a>',zM,As,VM,cp,to,Ib,ae,so,GM,ip,Xj='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces that specified sequences will never be selected.',FM,Os,XM,Ks,RM,dp,no,zb,re,ao,LM,pp,Rj=`N-grams are groups of “n” consecutive words, characters, or tokens taken from a sequence of text. Given the
sentence: “She runs fast”, the bi-grams (n=2) would be (“she”, “runs”) and (“runs”, “fast”). In text generation,
avoiding repetitions of word sequences provides a more diverse output. This <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforces no
repetition of n-grams by setting the scores of banned tokens to negative infinity which eliminates those tokens
from consideration when further processing the scores. Note that, for decoder-only models like most LLMs, the
prompt is also considered to obtain the n-grams.
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,SM,en,NM,tn,HM,mp,ro,Vb,Ie,oo,EM,hp,Lj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces constrained generation and is useful for prefix-conditioned constrained
generation. See <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity Retrieval</a> for more information.`,qM,sn,QM,gp,lo,Gb,oe,co,DM,up,Sj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that prevents the repetition of previous tokens through a penalty. This penalty is applied at
most once per token. Note that, for decoder-only models like most LLMs, the considered tokens include the prompt.`,YM,fp,Nj=`In the original <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">paper</a>, the authors suggest the use of a penalty of around
1.2 to achieve a good balance between truthful generation and lack of repetition. To penalize and reduce
repetition, use <code>penalty</code> values above 1.0, where a higher value penalizes more strongly. To reward and encourage
repetition, use <code>penalty</code> values between 0.0 and 1.0, where a lower value rewards more strongly.`,PM,nn,AM,bp,io,Fb,le,po,OM,_p,Hj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that applies an additive bias on sequences. The bias is applied to the last token of a sequence
when the next generated token can complete it. Consequently, to take the most of biasing sequences with more than
one token, consider using beam methods (to gracefully work around partially completed sequences that have a
negative bias) and applying the bias to their prefixes (to ensure the bias is applied earlier).`,KM,an,ev,rn,tv,yp,mo,Xb,ze,ho,sv,Tp,Ej=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.SuppressTokensAtBeginLogitsProcessor">SuppressTokensAtBeginLogitsProcessor</a> supresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are
not generated at the begining. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,nv,on,av,Mp,go,Rb,Ve,uo,rv,vp,qj=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so
that they are not generated. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,ov,ln,lv,wp,fo,Lb,G,bo,cv,kp,Qj=`Logits processor that implements watermarking techniques for text generation models.
This class facilitates the application of SynthID text watermarking, a method for embedding imperceptible signals
into generated text to aid in detecting synthetic content. It operates by subtly manipulating the probabilities of
token selection during text generation in a manner that can be reliably recovered later for verification.`,iv,$p,Dj="Key Features:",dv,jp,Yj=`<li><p><strong>State Management:</strong> Maintains internal state to track token sequences and generate watermarking keys
dynamically.</p></li> <li><p><strong>Key Generation:</strong> Computes hashes based on token sequences and watermarking parameters to create unique keys
for each position.</p></li> <li><p><strong>G-Value Sampling:</strong> Employs a pre-computed sampling table to sample watermarking values (g-values) based on
the generated keys.</p></li> <li><p><strong>Score Adjustment:</strong> Applies calculated g-values to modify token probabilities during generation, embedding the
watermark.</p></li> <li><p><strong>Context Repetition Handling:</strong> Incorporates logic to avoid watermarking tokens in repeated contexts,
preserving naturalness.</p></li> <li><p><strong>EOS Token Masking:</strong> Supports masking end-of-sentence tokens to prevent their inclusion in watermarking
calculations.</p></li> <li><p><strong>Utility Functions:</strong> Provides functions to compute g-values directly, check for context repetition, create
EOS token masks, and estimate expected mean g-values.</p></li>`,pv,xp,Pj='Refer to paper url: <a href="https://www.nature.com/articles/s41586-024-08025-4" rel="nofollow">https://www.nature.com/articles/s41586-024-08025-4</a> for more details around this.',mv,cn,hv,Jp,_o,Sb,ce,yo,gv,Up,Aj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for temperature (exponential scaling output probability distribution), which effectively means
that it can control the randomness of the predicted tokens. Often used together with <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a> and
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,uv,dn,fv,pn,bv,Zp,To,Nb,Ge,Mo,_v,Cp,Oj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs top-k, i.e. restricting to the k highest probability elements. Often used
together with <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a>.`,yv,mn,Tv,Wp,vo,Hb,Fe,wo,Mv,Bp,Kj=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.
Often used together with <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,vv,hn,wv,Ip,ko,Eb,ie,$o,kv,zp,e0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs typical decoding. Inspired on how humans use language, it prioritizes tokens
whose log probability is close to the entropy of the token probability distribution. This means that the most
likely tokens may be discarded in the process.`,$v,Vp,t0='See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information.',jv,gn,xv,Gp,jo,qb,de,xo,Jv,Fp,s0=`Logits processor for Classifier-Free Guidance (CFG). The processors computes a weighted average across scores
from prompt conditional and prompt unconditional (or negative) logits, parameterized by the <code>guidance_scale</code>.
The unconditional scores are computed internally by prompting <code>model</code> with the <code>unconditional_ids</code> branch.`,Uv,Xp,n0='See <a href="https://arxiv.org/abs/2306.17806" rel="nofollow">the paper</a> for more information.',Zv,un,Cv,Rp,Jo,Qb,pe,Uo,Wv,Lp,a0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that modifies the logits for the generation of timestamps in the transcription. When the input
tokens are at a specific threshold, the processor sets the scores to negative infinity. The processor makes sure
that timestamp tokens appear in pairs, by masking out the logits that would break this pairing pattern. This is
done to maintain the consistency and structure of generated timestamps. It also ensures that when the predicted
probability of sampling any of the timestamp token is greater than any individual non-timestamp token, those
non-timestamp logits are set to negative infinity. This is done to ensure the generation of timestamps over other
potential tokens.`,Bv,Sp,r0='See <a href="https://arxiv.org/abs/2212.04356" rel="nofollow">the paper</a> for more information.',Iv,fn,zv,Np,Zo,Db,E,Co,Vv,Hp,o0=`Logits processor for watermarking generated text. The processor modifies model output scores by adding a small bias to
randomized set of “green” tokens before generating the next token. “Green” tokens selection process depends on the
<code>seeding_scheme</code> used. The code was based on the <a href="https://github.com/jwkirchenbauer/lm-watermarking/tree/main" rel="nofollow">original repo</a>.`,Gv,Ep,l0='The text generated by this <code>LogitsProcessor</code> can be detected using <code>WatermarkDetector</code>. See <a href="/docs/transformers/main/en/internal/generation_utils#transformers.WatermarkDetector.__call__"><strong>call</strong>()</a> for details,',Fv,qp,c0='See <a href="https://arxiv.org/abs/2306.04634" rel="nofollow">the paper</a> for more information.',Xv,bn,Rv,Qp,Wo,Yb,Bo,Pb,rt,Io,Lv,Dp,i0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the first generated token.',Sv,Yp,zo,Ab,ot,Vo,Nv,Pp,d0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',Hv,Ap,Go,Ob,lt,Fo,Ev,Op,p0=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to <code>0</code> and all other tokens to
<code>-inf</code> so that they are sampled at their corresponding index.`,qv,Kp,Xo,Kb,ct,Ro,Qv,em,m0="Abstract base class for all logit processors that can be applied during generation.",Dv,_n,Lo,Yv,tm,h0="TF method for processing logits.",e_,it,So,Pv,sm,g0=`This class can be used to create a list of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to subsequently process a <code>scores</code> input tensor.
This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to the
inputs.`,Av,nm,No,t_,dt,Ho,Ov,am,u0="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",Kv,yn,Eo,ew,rm,f0="TF method for warping logits.",s_,pt,qo,tw,om,b0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',sw,lm,Qo,n_,mt,Do,nw,cm,_0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces that specified sequences will never be sampled.',aw,im,Yo,a_,ht,Po,rw,dm,y0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces no repetition of n-grams. See
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,ow,pm,Ao,r_,gt,Oo,lw,mm,T0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing an exponential penalty on repeated sequences.',cw,hm,Ko,o_,ut,el,iw,gm,M0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFSuppressTokensAtBeginLogitsProcessor">TFSuppressTokensAtBeginLogitsProcessor</a> suppresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> at not
sampled at the begining of the generation.`,dw,um,tl,l_,ft,sl,pw,fm,v0=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so that they
are not sampled.`,mw,bm,nl,c_,bt,al,hw,_m,w0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> for temperature (exponential scaling output probability distribution).',gw,ym,rl,i_,_t,ol,uw,Tm,k0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',fw,Mm,ll,d_,yt,cl,bw,vm,$0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to &lt;= prob_cut_off.',_w,wm,il,p_,dl,m_,Tt,pl,yw,km,j0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the first generated token.',Tw,$m,ml,h_,Mt,hl,Mw,jm,x0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',vw,xm,gl,g_,vt,ul,ww,Jm,J0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that takes a list of pairs of integers which indicates a mapping from generation indices to
token indices that will be forced before sampling. The processor will set their log probs to 0 and all other tokens
to <code>-inf</code> so that they are sampled at their corresponding index.`,kw,Um,fl,u_,wt,bl,$w,Zm,U0="Abstract base class for all logit processors that can be applied during generation.",jw,Tn,_l,xw,Cm,Z0="Flax method for processing logits.",f_,kt,yl,Jw,Wm,C0=`This class can be used to create a list of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to subsequently process
a <code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to the inputs.`,Uw,Bm,Tl,b_,$t,Ml,Zw,Im,W0="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",Cw,Mn,vl,Ww,zm,B0="Flax method for warping logits.",__,jt,wl,Bw,Vm,I0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',Iw,Gm,kl,y_,xt,$l,zw,Fm,z0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> supressing a list of tokens as soon as the <code>generate</code> function starts generating using
<code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are not sampled at the
begining of the generation.`,Vw,Xm,jl,T_,Jt,xl,Gw,Rm,V0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> suppressing a list of tokens at each decoding step. The processor will set their log probs
to be <code>-inf</code> so they are not sampled.`,Fw,Lm,Jl,M_,Ut,Ul,Xw,Sm,G0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> for temperature (exponential scaling output probability distribution).',Rw,Nm,Zl,v_,Zt,Cl,Lw,Hm,F0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',Sw,Em,Wl,w_,Ct,Bl,Nw,qm,X0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.',Hw,Qm,Il,k_,Wt,zl,Ew,Dm,R0=`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to <code>inf</code> so that they are sampled at their corresponding index.`,qw,Ym,Vl,$_,Gl,j_,Fl,L0='A <a href="/docs/transformers/main/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a> can be used to change when to stop generation (other than EOS token). Please note that this is exclusively available to our PyTorch implementations.',x_,Xe,Xl,Qw,Pm,S0="Abstract base class for all stopping criteria that can be applied during generation.",Dw,Am,N0="If your stopping criteria depends on the <code>scores</code> input, make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.",Yw,Om,Rl,J_,js,Ll,Pw,Km,Sl,U_,Bt,Nl,Aw,eh,H0=`This class can be used to stop generation whenever the full generated number of tokens exceeds <code>max_length</code>. Keep
in mind for decoder-only type of transformers, this will include the initial prompted tokens.`,Ow,th,Hl,Z_,It,El,Kw,sh,E0=`This class can be used to stop generation whenever the full generation exceeds some amount of time. By default, the
time will start being counted when you initialize this function. You can override this by passing an
<code>initial_time</code>.`,e2,nh,ql,C_,J,Ql,t2,ah,q0=`This class can be used to stop generation whenever specific string sequences are generated. It preprocesses
the strings together with the tokenizer vocab to find positions where tokens can validly complete the stop strings.`,s2,rh,Q0=`Generation is stopped as soon as a token is generated that completes any of the stop strings.
We want to catch any instance in which the stop string would be present in the decoded output, which means
we must also catch cases with “overhangs” off one or both ends. To make this more concrete, for the stop string
“stop”, any of the following token sequences would trigger the match:`,n2,oh,D0="<li>[“st”, “op”]</li> <li>[“stop”]</li> <li>[“st”, “opera”]</li> <li>[“sto”, “pper”]</li> <li>[“las”, “topper”]</li> <li>[“s”, “to”, “pped”]</li>",a2,lh,Y0=`Note that a match will only be triggered if the stop string is at the end of the generated sequence. In other
words, these sequences will not trigger a match:`,r2,ch,P0="<li>[“stop”, “at”]</li> <li>[“st”, “op”, “at”]</li> <li>[“st”, “opera”, “tion”]</li>",o2,ih,A0=`The reason these are not a match is that the stop string does not overlap with the final token. If you can remove
one or more tokens from the end of the sequence without destroying the stop string, then this criterion will not
match that stop string. This is by design; because this check is run after each token is generated, we can’t miss a
valid stop string if one is generated, but we don’t want to halt generation just because the stop string exists
somewhere in the past input_ids.`,l2,dh,O0=`How is the match actually performed, though? We do it in quite a confusing way, because we want the entire match
process to be compilable with Torch or XLA, which means we cannot use standard string methods. However, it is possible,
with some work, to do string matching with pure tensor operations. We’ll begin by describing the algorithm we use
with standard string operations, and then at the end we’ll explain how this is converted to pure tensor operations.`,c2,ph,K0=`The key to the algorithm is an observation: Because the stop string must overlap with the end of the token sequence, we can start at
the end of the sequence and work backwards. Specifically, we check that there is an overlap between the start of
the final token and the end of the stop_string, or to put it another way, stop_string[-i:] == token[:i] for
some i > 0. If you look at the positive examples above, you’ll see the last token in all of them fulfills this
property:`,i2,mh,ex="<li>[“st”, “op”] (overlap is “op”, overlap length == 2)</li> <li>[“stop”]  (overlap is “stop”, overlap length == 4)</li> <li>[“st”, “opera”]  (overlap is “op”, overlap length == 2)</li> <li>[“sto”, “pper”]  (overlap is “p”, overlap length == 1)</li> <li>[“las”, “topper”]  (overlap is “top”, overlap length == 3)</li> <li>[“s”, “to”, “pped”]  (overlap is “p”, overlap length == 1)</li>",d2,hh,tx=`It’s impossible to construct a matching sequence that does not have this property (feel free to verify this
yourself). However, although this overlap between the start of the final token and the end of the stop string is
necessary for a match, it is not sufficient. We also need to check that the rest of the token sequence is
consistent with the stop string.`,p2,gh,sx=`How do we do that? Let’s use [“s”, “to”, “pped”] as an example. We know that the final token, “pped”, has an
overlap of 1 with the stop string, “stop”. We then go back to the previous token, “to”. Since we have already
matched 1 character from the stop string, the remainder to check is “sto”. We check that the next token “to”
matches the end of the remainder, which it does. We have now matched 3 characters from the stop string, and the
remainder to match is “s”. We go back to the previous token again, which is also “s”. This is a match, and so
we have matched the entire stop string.`,m2,uh,nx=`How does it work when the tokens run off the start of the stop string, though? Let’s consider the example of
[“las”, “topper”]. The final token, “topper”, has an overlap of 3 with the stop string, “stop”. Therefore,
the remaining stop string to match is “s”. We go back to the previous token, “las”. Because the remainder to
match is just “s”, with length 1, we consider only the final 1 character from the token, which is “s”. This
matches the stop string, and so the entire string is matched.`,h2,fh,ax=`How do we compute these matches with tensor operations, though? Simply: we efficiently precompute the necessary
information for all tokens! For every token, we compute:`,g2,bh,rx="<li>Its overlap with the end of the stop string, if any</li> <li>The positions inside the stop string where the token matches, including matches that run off the start.</li> <li>The total length of the token</li>",u2,_h,ox=`For example, for the token “pped”, we would compute an end overlap of 1, no internal matching positions,
and a length of 4. For the token “to”, we would compute no end overlap, a single internal matching position
of 1 (counting from the end), and a length of 2. For the token “s”, we would compute no end overlap,
a single internal matching position of 3 (again counting from the end) and a length of 1.`,f2,yh,lx=`As long as we have this information, we can execute the algorithm above without any string comparison
operations. We simply perform the following steps:`,b2,Th,cx="<li>Check if the final token has an end-overlap with the start string</li> <li>Continue backwards, keeping track of how much of the stop string we’ve matched so far</li> <li>At each point, check if the next token has the current position as one of its valid positions</li> <li>Continue until either a match fails, or we completely match the whole stop string</li>",_2,Mh,ix=`Again, consider [“s”, “to”, “pped”] as an example. “pped” has an end overlap of 1, so we can begin a match.
We have matched 1 character so far, so we check that the next token “to”, has 1 as a valid position (again,
counting from the end). It does, so we add the length of “to” to our position tracker. We have now matched
3 characters, so we check that the next token “s” has 3 as a valid position. It does, so we add its length
to the position tracker. The position tracker is now 4, which is the length of the stop string. We have matched the
entire stop string.`,y2,vh,dx=`In the second case, [“las”, “topper”], “topper” has an end overlap of 3, so we can begin a match. We have
matched 3 characters so far, so we check that the next token “las” has 3 as a valid position. It does, because we
allow tokens to match positions that run off the start of the stop string. We add its length to the position
tracker. The position tracker is now 6, which is greater than the length of the stop string! Don’t panic, though -
this also counts as a match of the stop string. We have matched the entire stop string.`,T2,vn,M2,wh,Dl,W_,zt,Yl,v2,kh,px=`This class can be used to stop generation whenever the “end-of-sequence” token is generated.
By default, it uses the <code>model.generation_config.eos_token_id</code>.`,w2,$h,Pl,B_,Al,I_,Ol,mx='A <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> can be used to force the generation to include specific tokens or sequences in the output. Please note that this is exclusively available to our PyTorch implementations.',z_,W,Kl,k2,jh,hx=`Abstract base class for all constraints that can be applied during generation.
It must define how the constraint can be satisfied.`,$2,xh,gx="All classes that inherit Constraint must follow the requirement that",j2,wn,x2,Jh,ux="will always terminate (halt).",J2,kn,ec,U2,Uh,fx="When called, returns the token(s) that would take this constraint one step closer to being fulfilled.",Z2,$n,tc,C2,Zh,bx="Creates a new instance of this constraint.",W2,jn,sc,B2,Ch,_x="Reads in a token and returns whether it creates progress.",I2,xn,nc,z2,Wh,yx="Returns the number of remaining steps of <code>advance()</code> in order to complete this constraint.",V2,Jn,ac,G2,Bh,Tx=`Resets the state of this constraint to its initialization. We would call this in cases where the fulfillment of
a constraint is abrupted by an unwanted token.`,F2,Un,rc,X2,Ih,Mx="Tests whether this constraint has been properly defined.",R2,Kt,oc,L2,zh,vx=`Reads in a token and returns booleans that indicate the progress made by it. This function will update the
state of this object unlikes <code>does_advance(self, token_id: int)</code>.`,S2,Vh,wx=`This isn’t to test whether a certain token will advance the progress; it’s to update its state as if it has
been generated. This becomes important if token_id != desired token (refer to else statement in
PhrasalConstraint)`,V_,xs,lc,N2,Gh,kx='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> enforcing that an ordered sequence of tokens is included in the output.',G_,Js,cc,H2,Fh,$x='A special <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> that is fulfilled by fulfilling just one of several constraints.',F_,Re,ic,E2,Xh,jx="A class for beam scorers to track its progress through a list of constraints.",q2,K,dc,Q2,Rh,xx=`The list of tokens to generate such that we can make progress.
By “list” we don’t mean the list of token that will fully fulfill a constraint.`,D2,Lh,Jx=`Given constraints <code>c_i = {t_ij | j == # of tokens}</code>, If we’re not in the middle of progressing through a
specific constraint <code>c_i</code>, we return:`,Y2,Sh,Ux="<code>[t_k1 for k in indices of unfulfilled constraints]</code>",P2,Nh,Zx=`If we are in the middle of a constraint, then we return:
<code>[t_ij]</code>, where <code>i</code> is the index of the inprogress constraint, <code>j</code> is the next step for the constraint.`,A2,Hh,Cx=`Though we don’t care which constraint is fulfilled first, if we are in the progress of fulfilling a constraint,
that’s the only one we’ll return.`,O2,Zn,pc,K2,Eh,Wx="token_ids: the tokens generated thus far to reset the state of the progress through constraints.",X_,mc,R_,Le,hc,e1,qh,Bx=`Abstract base class for all beam scorers that are used for <code>~PreTrainedModel.beam_search</code> and
<code>~PreTrainedModel.beam_sample</code>.`,t1,Qh,gc,s1,Dh,uc,L_,q,fc,n1,Yh,Ix='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing standard beam search decoding.',a1,Ph,zx=`Adapted in part from <a href="https://github.com/facebookresearch/XLM/blob/9e6f6814d17be4fe5b15f2e6c43eb2b2d76daeb4/src/model/transformer.py#L529" rel="nofollow">Facebook’s XLM beam search
code</a>.`,r1,Ah,Vx=`Reference for the diverse beam search algorithm and implementation <a href="https://github.com/ashwinkalyan/dbs/blob/master/dbs/beam_utils.lua" rel="nofollow">Ashwin Kalyan’s DBS
implementation</a>`,o1,Oh,bc,l1,Kh,_c,S_,Se,yc,c1,eg,Gx='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing constrained beam search decoding.',i1,tg,Tc,d1,sg,Mc,N_,vc,H_,F,wc,p1,ng,Fx="Simple text streamer that prints the token(s) to stdout as soon as entire words are formed.",m1,Cn,h1,Wn,g1,Bn,kc,u1,ag,Xx="Flushes any remaining cache and prints a newline to stdout.",f1,In,$c,b1,rg,Rx="Prints the new text to stdout. If the stream is ending, also prints a newline.",_1,zn,jc,y1,og,Lx="Receives tokens, decodes them, and prints them to stdout as soon as they form entire words.",E_,me,xc,T1,lg,Sx=`Streamer that stores print-ready text in a queue, to be used by a downstream application as an iterator. This is
useful for applications that benefit from acessing the generated text in a non-blocking way (e.g. in an interactive
Gradio demo).`,M1,Vn,v1,Gn,w1,Fn,Jc,k1,cg,Nx="Put the new text in the queue. If the stream is ending, also put a stop signal in the queue.",q_,Uc,Q_,Vt,Zc,$1,ig,Hx="Base, abstract class for all caches. The actual data structure is specific to each subclass.",j1,Xn,Cc,x1,dg,Ex="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",D_,Gt,Wc,J1,pg,qx="Base class for cache configs",U1,Rn,Bc,Z1,mg,Qx=`Updates attributes of this class instance with attributes from <code>kwargs</code> if they match existing attributes,
returning all the unused kwargs.`,Y_,Ft,Ic,C1,hg,Dx="Configuration class for quantized cache settings.",W1,Ln,zc,B1,gg,Yx="Validates if the arguments passed are correct",P_,I,Vc,I1,ug,Px="A cache that grows dynamically as more tokens are generated. This is the default for generative models.",z1,fg,Ax=`It stores the Key and Value states as a list of tensors, one for each layer. The expected shape for each tensor is
<code>[batch_size, num_heads, seq_len, head_dim]</code>.`,V1,Sn,G1,Nn,Gc,F1,bg,Ox="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",X1,Hn,Fc,R1,_g,Kx="Returns the sequence length of the cached states. A layer index can be optionally passed.",L1,En,Xc,S1,yg,eJ="Reorders the cache for beam search, given the selected beam indices.",N1,qn,Rc,H1,Tg,tJ=`Converts the <code>DynamicCache</code> instance into the its equivalent in the legacy cache format. Used for
backward compatibility.`,E1,Qn,Lc,q1,Mg,sJ=`Converts a cache in the legacy cache format into an equivalent <code>DynamicCache</code>. Used for
backward compatibility.`,A_,Q,Sc,Q1,vg,nJ=`A quantizer cache similar to what is described in the <a href="https://arxiv.org/abs/2402.02750" rel="nofollow">KIVI: A Tuning-Free Asymmetric 2bit Quantization for KV Cache paper</a>.
It allows the model to generate longer sequence length without allocating too much memory for Key and Value cache by applying quantization.`,D1,wg,aJ=`The cache has two types of storage, one for original precision and one for the quantized cache. A <code>residual length</code> is set as a maximum capacity for the
original precision cache. When the length goes beyond maximum capacity, the original precision cache is discarded and moved into the quantized cache. The
quantization is done per-channel with a set <code>q_group_size</code> for both Keys and Values, in contrast to what was described in the paper.`,Y1,kg,rJ=`It stores Keys and Values a list of quantized tensors (tuples in case we need to store metadata), one for each layer. Additionally, it stores the Key and
Value in original precision states as a list of tensors, one for each layer. The size of each tensor
is <code>[batch_size, num_heads, seq_len - residual_length, head_dim]</code>`,P1,$g,Nc,A1,Dn,Hc,O1,jg,oJ="Returns the sequence length of the cached states. A layer index can be optionally passed.",O_,Xt,Ec,K1,xg,lJ="Quantized Cache class that uses <code>quanto</code> as a backend to perform quantization. Current implementation supports <code>int2</code> and <code>int4</code> dtypes only.",ek,Yn,K_,Rt,qc,tk,Jg,cJ="Quantized Cache class that uses <code>HQQ</code> as a backend to perform quantization. Current implementation supports <code>int2</code>, <code>int4</code>, <code>int8</code> dtypes.",sk,Pn,ey,X,Qc,nk,Ug,iJ=`A cache that as described in the <a href="https://arxiv.org/abs/2309.17453" rel="nofollow">Attention Sinks paper</a>. It allows the model to
generate beyond the length of its context window, without losing fluency in the conversation. As it discards past
tokens, the model will lose the ability to generate tokens that depend on the context that was discarded.`,ak,Zg,dJ=`It stores the Key and Value states as a list of tensors, one for each layer. The expected shape for each tensor is
<code>[batch_size, num_heads, seq_len, head_dim]</code>.`,rk,An,ok,On,Dc,lk,Cg,pJ="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",ck,Kn,Yc,ik,Wg,mJ="Returns the sequence length of the cached states. A layer index can be optionally passed.",dk,ea,Pc,pk,Bg,hJ="Reorders the cache for beam search, given the selected beam indices.",ty,D,Ac,mk,Ig,gJ=`A drop-in replacement for DynamicCache that conserves GPU memory at the expense of more CPU memory.
Useful for generating from models with very long context.`,hk,zg,uJ=`In addition to the default CUDA stream, where all forward() computations happen,
this class uses another stream, the prefetch stream, which it creates itself.
Since scheduling of operations on separate streams happens independently, this class uses
the prefetch stream to asynchronously prefetch the KV cache of layer k+1 when layer k is executing.
The movement of the layer k-1 cache to the CPU is handled by the default stream as a simple way to
ensure the eviction is scheduled after all computations on that cache are finished.`,gk,ta,Oc,uk,Vg,fJ="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",fk,sa,Kc,bk,Gg,bJ="Starts prefetching the next layer cache",_k,na,ei,yk,Fg,_J="Moves the previous layer cache to the CPU",sy,Y,ti,Tk,Xg,yJ="Static Cache class to be used with <code>torch.compile(model)</code> and <code>torch.export()</code>.",Mk,aa,vk,ra,si,wk,Rg,TJ=`Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.
It is VERY important to index using a tensor, otherwise you introduce a copy to the device.`,kk,oa,ni,$k,Lg,MJ="Returns the sequence length of the cached states that were seen by the model.",jk,la,ai,xk,Sg,vJ="Resets the cache values while preserving the objects",ny,P,ri,Jk,Ng,wJ=`Static cache class to be used with <code>torch.compile(model)</code> that offloads to the CPU or
another device.`,Uk,ca,Zk,ia,oi,Ck,Hg,kJ=`Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.
It is VERY important to index using a tensor, otherwise you introduce a copy to the device.`,Wk,da,li,Bk,Eg,$J="Returns the sequence length of the cached states that were seen by the model.",Ik,pa,ci,zk,qg,jJ="Resets the cache values while preserving the objects.",ay,A,ii,Vk,Qg,xJ=`Hybrid Cache class to be used with <code>torch.compile</code> for Gemma2 models that alternate between a local sliding window attention
and global attention in every other layer. Under the hood, Hybrid Cache leverages [“SlidingWindowCache”] for sliding window attention
and [“StaticCache”] for global attention. For more information, see the documentation of each subcomponeent cache class.`,Gk,ma,Fk,Dg,di,Xk,Yg,pi,Rk,ha,mi,Lk,Pg,JJ="Resets the cache values while preserving the objects",ry,z,hi,Sk,Ag,UJ=`Sliding Window Cache class to be used with <code>torch.compile</code> for models like Mistral that support sliding window attention.
Every time when we try to update the cache, we compute the <code>indices</code> based on <code>cache_position &gt;= self.config.sliding_window - 1</code>,
if true(which means the cache can not hold all the old key value states and new states together because of the sliding window constraint),
we need to do a cycle shift based on <code>indices</code> to replace the oldest states by the new key value states passed in.`,Nk,Og,ZJ="The <code>to_shift</code> is only true once we are above sliding_window. Thus with <code>sliding_window==64</code>:",Hk,Kg,CJ=`indices = (slicing + to_shift[-1].int()-1) % self.config.sliding_window
tensor([ 1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54,
55, 56, 57, 58, 59, 60, 61, 62, 63,  0])`,Ek,eu,WJ="We overwrite the cache using these, then we always write at cache_position (clamped to <code>sliding_window</code>)",qk,ga,Qk,tu,gi,Dk,su,ui,oy,V,fi,Yk,nu,BJ=`Base, abstract class for all encoder-decoder caches. Can be used to hold combinations of self-attention and
cross-attention caches.`,Pk,ua,Ak,fa,bi,Ok,au,IJ="Returns the sequence length of the cached states. A layer index can be optionally passed.",Kk,ba,_i,e$,ru,zJ="Converts the <code>EncoderDecoderCache</code> instance into  its equivalent in the legacy cache format.",t$,_a,yi,s$,ou,VJ="Converts a cache in the legacy cache format into an equivalent <code>EncoderDecoderCache</code>.",n$,lu,Ti,a$,ya,Mi,r$,cu,GJ="Reorders the cache for beam search, given the selected beam indices.",ly,O,vi,o$,iu,FJ="Cache for mamba model which does not have attention mechanism and key value states.",l$,Ta,c$,du,wi,i$,pu,ki,d$,mu,$i,cy,ji,iy,he,xi,p$,hu,XJ=`Class that holds arguments for watermark generation and should be passed into <code>GenerationConfig</code> during <code>generate</code>.
See <a href="https://arxiv.org/abs/2306.04634" rel="nofollow">this paper</a> for more details on the arguments.`,m$,gu,RJ="Accepts the following keys:",h$,uu,LJ=`<li>greenlist_ratio (<code>float</code>):
Used for watermarking. The ratio of “green” tokens used to the vocabulary size. Defaults to 0.25.</li> <li>bias (<code>float</code>):
Used with watermarking. The bias added to the selected “green” tokens’ logits. Defaults to 2.0.</li> <li>hashing_key (<code>int</code>):
Hashing key used for watermarking. Defaults to 15485863 (the millionth prime).</li> <li>seeding_scheme (<code>str</code>):
Algorithm to use for watermarking. Accepts values:<ul><li>“lefthash” (default): “green” tokens selection depend on the last token (Algorithm 2 from the paper)</li> <li>“selfhash”: “green” tokens selection depends on the current token itself (Algorithm 3 from the paper)
The downside of this scheme is that it considers all possible next tokens and can be slower than “lefthash”.</li></ul></li> <li>context_width(<code>int</code>):
The context length of previous tokens to use in seeding. Higher context length makes watermarking more robust.</li>`,g$,Ma,Ji,u$,fu,SJ="Call self as a function.",dy,ge,Ui,f$,bu,NJ=`Detector for detection of watermark generated text. The detector needs to be given the exact same settings that were
given during text generation to replicate the watermark greenlist generation and so detect the watermark. This includes
the correct device that was used during text generation, the correct watermarking arguments and the correct tokenizer vocab size.
The code was based on the <a href="https://github.com/jwkirchenbauer/lm-watermarking/tree/main" rel="nofollow">original repo</a>.`,b$,_u,HJ='See <a href="https://arxiv.org/abs/2306.04634" rel="nofollow">the paper</a> for more information.',_$,va,y$,wa,Zi,T$,yu,EJ="ma",py,Lt,Ci,M$,Tu,qJ=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.BayesianDetectorModel">BayesianDetectorModel</a>. It is used to
instantiate a Bayesian Detector model according to the specified arguments.`,v$,Mu,QJ=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,my,R,Wi,w$,vu,DJ="Bayesian classifier for watermark detection.",k$,wu,YJ=`This detector uses Bayes’ rule to compute a watermarking score, which is the sigmoid of the log of ratio of the
posterior probabilities P(watermarked|g_values) and P(unwatermarked|g_values). Please see the section on
BayesianScore in the paper for further details.
Paper URL: <a href="https://www.nature.com/articles/s41586-024-08025-4" rel="nofollow">https://www.nature.com/articles/s41586-024-08025-4</a>`,$$,ku,PJ=`Note that this detector only works with non-distortionary Tournament-based watermarking using the Bernoulli(0.5)
g-value distribution.`,j$,$u,AJ=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,x$,ju,OJ=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,J$,ka,Bi,U$,xu,KJ="Computes the watermarked posterior P(watermarked|g_values).",hy,St,Ii,Z$,Ju,eU=`Class that holds arguments for watermark generation and should be passed into <code>GenerationConfig</code> during <code>generate</code>.
See <a href="https://www.nature.com/articles/s41586-024-08025-4" rel="nofollow">this paper</a> for more details on the arguments.`,C$,$a,gy,ue,zi,W$,Uu,tU="SynthID text watermark detector class.",B$,Zu,sU=`This class has to be initialized with the trained bayesian detector module check script
in examples/synthid_text/detector_training.py for example in training/saving/loading this
detector module. The folder also showcases example use case of this detector.`,I$,ja,z$,Cu,Vi,uy,Gi,fy,_f,by;return w=new ye({props:{title:"Utilities for Generation",local:"utilities-for-generation",headingTag:"h1"}}),Ga=new ye({props:{title:"Generate Outputs",local:"generate-outputs",headingTag:"h2"}}),Ra=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXIlMkMlMjBHUFQyTE1IZWFkTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiklMEFtb2RlbCUyMCUzRCUyMEdQVDJMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjBhbmQlMjAlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbmVyYXRpb25fb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUlMkMlMjBvdXRwdXRfc2NvcmVzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, GPT2LMHeadModel

tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
model = GPT2LMHeadModel.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute and &quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
generation_output = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)`,wrap:!1}}),qa=new U({props:{code:"Z2VuZXJhdGlvbl9vdXRwdXQlNUIlM0EyJTVE",highlighted:'generation_output[:<span class="hljs-number">2</span>]',wrap:!1}}),Pa=new ye({props:{title:"PyTorch",local:"transformers.generation.GenerateDecoderOnlyOutput",headingTag:"h3"}}),Aa=new v({props:{name:"class transformers.generation.GenerateDecoderOnlyOutput",anchor:"transformers.generation.GenerateDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L118"}}),Oa=new v({props:{name:"class transformers.generation.GenerateEncoderDecoderOutput",anchor:"transformers.generation.GenerateEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L154"}}),Ka=new v({props:{name:"class transformers.generation.GenerateBeamDecoderOnlyOutput",anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L202"}}),er=new v({props:{name:"class transformers.generation.GenerateBeamEncoderDecoderOutput",anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L246"}}),tr=new ye({props:{title:"TensorFlow",local:"transformers.generation.TFGreedySearchEncoderDecoderOutput",headingTag:"h3"}}),sr=new v({props:{name:"class transformers.generation.TFGreedySearchEncoderDecoderOutput",anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L85"}}),nr=new v({props:{name:"class transformers.generation.TFGreedySearchDecoderOnlyOutput",anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L57"}}),ar=new v({props:{name:"class transformers.generation.TFSampleEncoderDecoderOutput",anchor:"transformers.generation.TFSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size*num_return_sequences, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L155"}}),rr=new v({props:{name:"class transformers.generation.TFSampleDecoderOnlyOutput",anchor:"transformers.generation.TFSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L127"}}),or=new v({props:{name:"class transformers.generation.TFBeamSearchEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. <code>Tuple of </code>tf.Tensor<code>with up to</code>max_new_tokens<code>elements (one element for each generated token), with each tensor of shape</code>(batch_size*num_beams, config.vocab_size)\`.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L232"}}),lr=new v({props:{name:"class transformers.generation.TFBeamSearchDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L197"}}),cr=new v({props:{name:"class transformers.generation.TFBeamSampleEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L317"}}),ir=new v({props:{name:"class transformers.generation.TFBeamSampleDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L282"}}),dr=new v({props:{name:"class transformers.generation.TFContrastiveSearchEncoderDecoderOutput",anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L393"}}),pr=new v({props:{name:"class transformers.generation.TFContrastiveSearchDecoderOnlyOutput",anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L366"}}),mr=new ye({props:{title:"FLAX",local:"transformers.generation.FlaxSampleOutput",headingTag:"h3"}}),hr=new v({props:{name:"class transformers.generation.FlaxSampleOutput",anchor:"transformers.generation.FlaxSampleOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxSampleOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L69"}}),gr=new v({props:{name:"replace",anchor:"transformers.generation.FlaxSampleOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),ur=new v({props:{name:"class transformers.generation.FlaxGreedySearchOutput",anchor:"transformers.generation.FlaxGreedySearchOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxGreedySearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L55"}}),fr=new v({props:{name:"replace",anchor:"transformers.generation.FlaxGreedySearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),br=new v({props:{name:"class transformers.generation.FlaxBeamSearchOutput",anchor:"transformers.generation.FlaxBeamSearchOutput",parameters:[{name:"sequences",val:": Array = None"},{name:"scores",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxBeamSearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"},{anchor:"transformers.generation.FlaxBeamSearchOutput.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size,)</code>) &#x2014;
The scores (log probabilities) of the generated sequences.`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L83"}}),_r=new v({props:{name:"replace",anchor:"transformers.generation.FlaxBeamSearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),yr=new ye({props:{title:"LogitsProcessor",local:"logitsprocessor",headingTag:"h2"}}),Mr=new ye({props:{title:"PyTorch",local:"transformers.AlternatingCodebooksLogitsProcessor",headingTag:"h3"}}),vr=new v({props:{name:"class transformers.AlternatingCodebooksLogitsProcessor",anchor:"transformers.AlternatingCodebooksLogitsProcessor",parameters:[{name:"input_start_len",val:": int"},{name:"semantic_vocab_size",val:": int"},{name:"codebook_size",val:": int"}],parametersDescription:[{anchor:"transformers.AlternatingCodebooksLogitsProcessor.input_start_len",description:`<strong>input_start_len</strong> (<code>int</code>) &#x2014;
The length of the initial input sequence.`,name:"input_start_len"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.semantic_vocab_size",description:`<strong>semantic_vocab_size</strong> (<code>int</code>) &#x2014;
Vocabulary size of the semantic part, i.e number of tokens associated to the semantic vocabulary.`,name:"semantic_vocab_size"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.codebook_size",description:`<strong>codebook_size</strong> (<code>int</code>) &#x2014;
Number of tokens associated to the codebook.`,name:"codebook_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2131"}}),Gs=new Va({props:{warning:!0,$$slots:{default:[bZ]},$$scope:{ctx:j}}}),wr=new v({props:{name:"__call__",anchor:"transformers.AlternatingCodebooksLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2160"}}),kr=new v({props:{name:"class transformers.ClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:""}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (float) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale &gt; 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2067"}}),Fs=new Va({props:{warning:!0,$$slots:{default:[_Z]},$$scope:{ctx:j}}}),Xs=new Z({props:{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[yZ]},$$scope:{ctx:j}}}),$r=new v({props:{name:"__call__",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2115",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),jr=new v({props:{name:"class transformers.EncoderNoRepeatNGramLogitsProcessor",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor",parameters:[{name:"encoder_ngram_size",val:": int"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_ngram_size",description:`<strong>encoder_ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur within the encoder input ids.`,name:"encoder_ngram_size"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>int</code>) &#x2014;
The encoder_input_ids that should not be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L981"}}),Rs=new Z({props:{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.example",$$slots:{default:[TZ]},$$scope:{ctx:j}}}),xr=new v({props:{name:"__call__",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1030",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Jr=new v({props:{name:"class transformers.EncoderRepetitionPenaltyLogitsProcessor",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 rewards prompt tokens. Between 0.0
and 1.0 penalizes prompt tokens.`,name:"penalty"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The encoder_input_ids that should be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L362"}}),Ls=new Z({props:{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.example",$$slots:{default:[MZ]},$$scope:{ctx:j}}}),Ur=new v({props:{name:"__call__",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L406",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Zr=new v({props:{name:"class transformers.EpsilonLogitsWarper",anchor:"transformers.EpsilonLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
If set to &gt; 0, only the most tokens with probabilities <code>epsilon</code> or higher are kept for generation.`,name:"epsilon"},{anchor:"transformers.EpsilonLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.EpsilonLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L702"}}),Ss=new Z({props:{anchor:"transformers.EpsilonLogitsWarper.example",$$slots:{default:[vZ]},$$scope:{ctx:j}}}),Cr=new v({props:{name:"__call__",anchor:"transformers.EpsilonLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EpsilonLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L757",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Wr=new v({props:{name:"class transformers.EtaLogitsWarper",anchor:"transformers.EtaLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
A float value in the range (0, 1). Hyperparameter used to calculate the dynamic cutoff value, <code>eta</code>. The
suggested values from the paper ranges from 3e-4 to 4e-3 depending on the size of the model.`,name:"epsilon"},{anchor:"transformers.EtaLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All values that are found to be below the dynamic cutoff value, <code>eta</code>, are set to this float value. This
parameter is useful when logits need to be modified for very low probability tokens that should be excluded
from generation entirely.`,name:"filter_value"},{anchor:"transformers.EtaLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Specifies the minimum number of tokens that must be kept for generation, regardless of their probabilities.
For example, if <code>min_tokens_to_keep</code> is set to 1, at least one token will always be kept for generation,
even if all tokens have probabilities below the cutoff <code>eta</code>.`,name:"min_tokens_to_keep"},{anchor:"transformers.EtaLogitsWarper.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L771"}}),Ns=new Z({props:{anchor:"transformers.EtaLogitsWarper.example",$$slots:{default:[wZ]},$$scope:{ctx:j}}}),Br=new v({props:{name:"__call__",anchor:"transformers.EtaLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EtaLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L840",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ir=new v({props:{name:"class transformers.ExponentialDecayLengthPenalty",anchor:"transformers.ExponentialDecayLengthPenalty",parameters:[{name:"exponential_decay_length_penalty",val:": Tuple"},{name:"eos_token_id",val:": Union"},{name:"input_ids_seq_length",val:": int"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>) &#x2014;
This tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where penalty
starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.ExponentialDecayLengthPenalty.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.ExponentialDecayLengthPenalty.input_ids_seq_length",description:`<strong>input_ids_seq_length</strong> (<code>int</code>) &#x2014;
The length of the input sequence.`,name:"input_ids_seq_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1643"}}),Hs=new Z({props:{anchor:"transformers.ExponentialDecayLengthPenalty.example",$$slots:{default:[kZ]},$$scope:{ctx:j}}}),zr=new v({props:{name:"__call__",anchor:"transformers.ExponentialDecayLengthPenalty.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1729",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Vr=new v({props:{name:"class transformers.ForcedBOSTokenLogitsProcessor",anchor:"transformers.ForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1521"}}),Es=new Z({props:{anchor:"transformers.ForcedBOSTokenLogitsProcessor.example",$$slots:{default:[$Z]},$$scope:{ctx:j}}}),Gr=new v({props:{name:"__call__",anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1556",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Fr=new v({props:{name:"class transformers.ForcedEOSTokenLogitsProcessor",anchor:"transformers.ForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": Union"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1566"}}),qs=new Z({props:{anchor:"transformers.ForcedEOSTokenLogitsProcessor.example",$$slots:{default:[jZ]},$$scope:{ctx:j}}}),Xr=new v({props:{name:"__call__",anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1612",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Rr=new v({props:{name:"class transformers.HammingDiversityLogitsProcessor",anchor:"transformers.HammingDiversityLogitsProcessor",parameters:[{name:"diversity_penalty",val:": float"},{name:"num_beams",val:": int"},{name:"num_beam_groups",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. A higher <code>diversity_penalty</code> will enforce greater diversity among the beams. Adjusting
this value can help strike a balance between diversity and natural likelihood.`,name:"diversity_penalty"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
<a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1385"}}),Qs=new Z({props:{anchor:"transformers.HammingDiversityLogitsProcessor.example",$$slots:{default:[xZ]},$$scope:{ctx:j}}}),Lr=new v({props:{name:"__call__",anchor:"transformers.HammingDiversityLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"current_tokens",val:": LongTensor"},{name:"beam_group_idx",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.current_tokens",description:`<strong>current_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the tokens selected by the other
beam groups in the current generation step.`,name:"current_tokens"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.beam_group_idx",description:`<strong>beam_group_idx</strong> (<code>int</code>) &#x2014;
The index of the beam group currently being processed.`,name:"beam_group_idx"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1472",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Sr=new v({props:{name:"class transformers.InfNanRemoveLogitsProcessor",anchor:"transformers.InfNanRemoveLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1622"}}),Nr=new v({props:{name:"__call__",anchor:"transformers.InfNanRemoveLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1631",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Hr=new v({props:{name:"class transformers.LogitNormalization",anchor:"transformers.LogitNormalization",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1744"}}),Ds=new Z({props:{anchor:"transformers.LogitNormalization.example",$$slots:{default:[JZ]},$$scope:{ctx:j}}}),Er=new v({props:{name:"__call__",anchor:"transformers.LogitNormalization.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitNormalization.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitNormalization.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1775",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),qr=new v({props:{name:"class transformers.LogitsProcessor",anchor:"transformers.LogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L45"}}),Qr=new v({props:{name:"__call__",anchor:"transformers.LogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L48",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Dr=new v({props:{name:"class transformers.LogitsProcessorList",anchor:"transformers.LogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L71"}}),Yr=new v({props:{name:"__call__",anchor:"transformers.LogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.LogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional kwargs that are specific to a logits processor.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L78",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Pr=new v({props:{name:"class transformers.MinLengthLogitsProcessor",anchor:"transformers.MinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": Union"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.MinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.MinLengthLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L109"}}),Ys=new Z({props:{anchor:"transformers.MinLengthLogitsProcessor.example",$$slots:{default:[UZ]},$$scope:{ctx:j}}}),Ar=new v({props:{name:"__call__",anchor:"transformers.MinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L160",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Or=new v({props:{name:"class transformers.MinNewTokensLengthLogitsProcessor",anchor:"transformers.MinNewTokensLengthLogitsProcessor",parameters:[{name:"prompt_length_to_skip",val:": int"},{name:"min_new_tokens",val:": int"},{name:"eos_token_id",val:": Union"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.prompt_length_to_skip",description:`<strong>prompt_length_to_skip</strong> (<code>int</code>) &#x2014;
The input tokens length. Not a valid argument when used with <code>generate</code> as it will automatically assign the
input length.`,name:"prompt_length_to_skip"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>) &#x2014;
The minimum <em>new</em> tokens length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_new_tokens"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L170"}}),Ps=new Z({props:{anchor:"transformers.MinNewTokensLengthLogitsProcessor.example",$$slots:{default:[ZZ]},$$scope:{ctx:j}}}),Kr=new v({props:{name:"__call__",anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L230",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),eo=new v({props:{name:"class transformers.MinPLogitsWarper",anchor:"transformers.MinPLogitsWarper",parameters:[{name:"min_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.MinPLogitsWarper.min_p",description:`<strong>min_p</strong> (<code>float</code>) &#x2014;
Minimum token probability, which will be scaled by the probability of the most likely token. It must be a
value between 0 and 1. Typical values are in the 0.01-0.2 range, comparably selective as setting <code>top_p</code> in
the 0.99-0.8 range (use the opposite of normal <code>top_p</code> values).`,name:"min_p"},{anchor:"transformers.MinPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.MinPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L537"}}),As=new Z({props:{anchor:"transformers.MinPLogitsWarper.example",$$slots:{default:[CZ]},$$scope:{ctx:j}}}),to=new v({props:{name:"__call__",anchor:"transformers.MinPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L594"}}),so=new v({props:{name:"class transformers.NoBadWordsLogitsProcessor",anchor:"transformers.NoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": List"},{name:"eos_token_id",val:": Union = None"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated.`,name:"bad_words_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>, <em>optional</em>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1225"}}),Os=new Va({props:{$$slots:{default:[WZ]},$$scope:{ctx:j}}}),Ks=new Z({props:{anchor:"transformers.NoBadWordsLogitsProcessor.example",$$slots:{default:[BZ]},$$scope:{ctx:j}}}),no=new v({props:{name:"__call__",anchor:"transformers.NoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1123",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ao=new v({props:{name:"class transformers.NoRepeatNGramLogitsProcessor",anchor:"transformers.NoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L922"}}),en=new Va({props:{$$slots:{default:[IZ]},$$scope:{ctx:j}}}),tn=new Z({props:{anchor:"transformers.NoRepeatNGramLogitsProcessor.example",$$slots:{default:[zZ]},$$scope:{ctx:j}}}),ro=new v({props:{name:"__call__",anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L969",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),oo=new v({props:{name:"class transformers.PrefixConstrainedLogitsProcessor",anchor:"transformers.PrefixConstrainedLogitsProcessor",parameters:[{name:"prefix_allowed_tokens_fn",val:": Callable"},{name:"num_beams",val:": int"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>) &#x2014;
This function constraints the beam search to allowed tokens only at each step. This function takes 2
arguments <code>inputs_ids</code> and the batch ID <code>batch_id</code>. It has to return a list with the allowed tokens for the
next generation step conditioned on the previously generated tokens <code>inputs_ids</code> and the batch ID
<code>batch_id</code>.`,name:"prefix_allowed_tokens_fn"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1316"}}),sn=new Z({props:{anchor:"transformers.PrefixConstrainedLogitsProcessor.example",$$slots:{default:[VZ]},$$scope:{ctx:j}}}),lo=new v({props:{name:"__call__",anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1367",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),co=new v({props:{name:"class transformers.RepetitionPenaltyLogitsProcessor",anchor:"transformers.RepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 penalizes previously generated
tokens. Between 0.0 and 1.0 rewards previously generated tokens.`,name:"penalty"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L308"}}),nn=new Z({props:{anchor:"transformers.RepetitionPenaltyLogitsProcessor.example",$$slots:{default:[GZ]},$$scope:{ctx:j}}}),io=new v({props:{name:"__call__",anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L351",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),po=new v({props:{name:"class transformers.SequenceBiasLogitsProcessor",anchor:"transformers.SequenceBiasLogitsProcessor",parameters:[{name:"sequence_bias",val:": List"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.sequence_bias",description:`<strong>sequence_bias</strong> (<code>List[List[Union[List[int], float]]]</code>) &#x2014;
List of lists that maps a sequence of tokens to its bias term (e.g. <code>[[[10, 45], -2.0], [[64], -7.5]]</code>). Positive biases increase the odds of the
sequence being selected, while negative biases do the opposite. If a sequence has a length of 1, its bias
will always be applied. Otherwise, the bias will only be applied if the sequence in question is about to be
completed (in the token selection step after this processor is applied).`,name:"sequence_bias"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1050"}}),an=new Va({props:{$$slots:{default:[FZ]},$$scope:{ctx:j}}}),rn=new Z({props:{anchor:"transformers.SequenceBiasLogitsProcessor.example",$$slots:{default:[XZ]},$$scope:{ctx:j}}}),mo=new v({props:{name:"__call__",anchor:"transformers.SequenceBiasLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1123",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ho=new v({props:{name:"class transformers.SuppressTokensAtBeginLogitsProcessor",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""},{name:"device",val:": str = 'cpu'"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1781"}}),on=new Z({props:{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.example",$$slots:{default:[RZ]},$$scope:{ctx:j}}}),go=new v({props:{name:"__call__",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1823",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),uo=new v({props:{name:"class transformers.SuppressTokensLogitsProcessor",anchor:"transformers.SuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""},{name:"device",val:": str = 'cpu'"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1834"}}),ln=new Z({props:{anchor:"transformers.SuppressTokensLogitsProcessor.example",$$slots:{default:[LZ]},$$scope:{ctx:j}}}),fo=new v({props:{name:"__call__",anchor:"transformers.SuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1866",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),bo=new v({props:{name:"class transformers.SynthIDTextWatermarkLogitsProcessor",anchor:"transformers.SynthIDTextWatermarkLogitsProcessor",parameters:[{name:"ngram_len",val:": int"},{name:"keys",val:": List"},{name:"sampling_table_size",val:": int"},{name:"sampling_table_seed",val:": int"},{name:"context_history_size",val:": int"},{name:"device",val:": device"},{name:"skip_first_ngram_calls",val:": bool = False"},{name:"debug_mode",val:": bool = False"}],parametersDescription:[{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.ngram_len",description:`<strong>ngram_len</strong> (<code>int</code>) &#x2014;
Ngram length.`,name:"ngram_len"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.keys",description:`<strong>keys</strong> (<code>List[int]</code>) &#x2014;
A sequence of watermarking keys, one for each depth.`,name:"keys"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.sampling_table_size",description:`<strong>sampling_table_size</strong> (<code>int</code>) &#x2014;
Size of the sampling table.`,name:"sampling_table_size"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.sampling_table_seed",description:`<strong>sampling_table_seed</strong> (<code>int</code>) &#x2014;
Random seed to generate the sampling table.`,name:"sampling_table_seed"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.context_history_size",description:`<strong>context_history_size</strong> (<code>int</code>) &#x2014;
Size of the tensor to keep track of seen contexts.`,name:"context_history_size"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Device to use.`,name:"device"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.skip_first_ngram_calls",description:`<strong>skip_first_ngram_calls</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip first ngram calls.`,name:"skip_first_ngram_calls"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.debug_mode",description:`<strong>debug_mode</strong> (<code>bool</code>, optional, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Logits are modified to uniform one got before watermarking modification is applied. This is to test the
implementation.`,name:"debug_mode"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2514"}}),cn=new Z({props:{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.example",$$slots:{default:[SZ]},$$scope:{ctx:j}}}),_o=new v({props:{name:"__call__",anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2652",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),yo=new v({props:{name:"class transformers.TemperatureLogitsWarper",anchor:"transformers.TemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
Strictly positive float value used to modulate the logits distribution. A value smaller than <code>1</code> decreases
randomness (and vice versa), with <code>0</code> being equivalent to shifting all probability mass to the most likely
token.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L242"}}),dn=new Va({props:{$$slots:{default:[NZ]},$$scope:{ctx:j}}}),pn=new Z({props:{anchor:"transformers.TemperatureLogitsWarper.example",$$slots:{default:[HZ]},$$scope:{ctx:j}}}),To=new v({props:{name:"__call__",anchor:"transformers.TemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TemperatureLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L302",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Mo=new v({props:{name:"class transformers.TopKLogitsWarper",anchor:"transformers.TopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L484"}}),mn=new Z({props:{anchor:"transformers.TopKLogitsWarper.example",$$slots:{default:[EZ]},$$scope:{ctx:j}}}),vo=new v({props:{name:"__call__",anchor:"transformers.TopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopKLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L528",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),wo=new v({props:{name:"class transformers.TopPLogitsWarper",anchor:"transformers.TopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L417"}}),hn=new Z({props:{anchor:"transformers.TopPLogitsWarper.example",$$slots:{default:[qZ]},$$scope:{ctx:j}}}),ko=new v({props:{name:"__call__",anchor:"transformers.TopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopPLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L468",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),$o=new v({props:{name:"class transformers.TypicalLogitsWarper",anchor:"transformers.TypicalLogitsWarper",parameters:[{name:"mass",val:": float = 0.9"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.mass",description:`<strong>mass</strong> (<code>float</code>, <em>optional</em>, defaults to 0.9) &#x2014;
Value of typical_p between 0 and 1 inclusive, defaults to 0.9.`,name:"mass"},{anchor:"transformers.TypicalLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TypicalLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L614"}}),gn=new Z({props:{anchor:"transformers.TypicalLogitsWarper.example",$$slots:{default:[QZ]},$$scope:{ctx:j}}}),jo=new v({props:{name:"__call__",anchor:"transformers.TypicalLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TypicalLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L678",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),xo=new v({props:{name:"class transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:": float"},{name:"model",val:""},{name:"unconditional_ids",val:": Optional = None"},{name:"unconditional_attention_mask",val:": Optional = None"},{name:"use_cache",val:": Optional = True"}],parametersDescription:[{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale != 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality. A value smaller than 1 has the opposite effect, while
making the negative prompt provided with negative_prompt_ids (if any) act as a positive prompt.`,name:"guidance_scale"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model computing the unconditional scores. Supposedly the same as the one computing the conditional
scores. Both models must use the same tokenizer.`,name:"model"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_ids",description:`<strong>unconditional_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary for the unconditional branch. If unset, will default to
the last token of the prompt.`,name:"unconditional_ids"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_attention_mask",description:`<strong>unconditional_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention mask for unconditional_ids.`,name:"unconditional_attention_mask"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to cache key/values during the negative prompt forward pass.`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2176"}}),un=new Z({props:{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[DZ]},$$scope:{ctx:j}}}),Jo=new v({props:{name:"__call__",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2282"}}),Uo=new v({props:{name:"class transformers.WhisperTimeStampLogitsProcessor",anchor:"transformers.WhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"begin_index",val:": Optional = None"},{name:"_detect_timestamp_from_logprob",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.begin_index",description:"<strong>begin_index</strong> (<code>Optional</code>, <em>optional</em>) &#x2014; Token index of the first token that is generated by the model.",name:"begin_index"},{anchor:"transformers.WhisperTimeStampLogitsProcessor._detect_timestamp_from_logprob",description:"<strong>_detect_timestamp_from_logprob</strong> (<code>bool</code>, <em>optional</em>) &#x2014; Whether timestamps can be predicted from logprobs over all timestamps.",name:"_detect_timestamp_from_logprob"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1874"}}),fn=new Z({props:{anchor:"transformers.WhisperTimeStampLogitsProcessor.example",$$slots:{default:[YZ]},$$scope:{ctx:j}}}),Zo=new v({props:{name:"__call__",anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1959",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Co=new v({props:{name:"class transformers.WatermarkLogitsProcessor",anchor:"transformers.WatermarkLogitsProcessor",parameters:[{name:"vocab_size",val:""},{name:"device",val:""},{name:"greenlist_ratio",val:": float = 0.25"},{name:"bias",val:": float = 2.0"},{name:"hashing_key",val:": int = 15485863"},{name:"seeding_scheme",val:": str = 'lefthash'"},{name:"context_width",val:": int = 1"}],parametersDescription:[{anchor:"transformers.WatermarkLogitsProcessor.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>) &#x2014;
The model tokenizer&#x2019;s vocab_size. Used to calculate &#x201C;green&#x201D; tokens ratio.`,name:"vocab_size"},{anchor:"transformers.WatermarkLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>) &#x2014;
The device where model is allocated.`,name:"device"},{anchor:"transformers.WatermarkLogitsProcessor.greenlist_ratio",description:`<strong>greenlist_ratio</strong> (<code>float</code>, optional, <em>optional</em>, defaults to 0.25) &#x2014;
The ratio of &#x201C;green&#x201D; tokens used to the vocabulary size. Defaults to 0.25.`,name:"greenlist_ratio"},{anchor:"transformers.WatermarkLogitsProcessor.bias",description:`<strong>bias</strong> (<code>float</code>, optional, <em>optional</em>, defaults to 2.0) &#x2014;
The bias added to the selected &#x201C;green&#x201D; tokens&#x2019; logits. Consider lowering the
<code>bias</code> if the text generation quality degrades. Recommended values are in the
range of [0.5, 2.0]. Defaults to 2.0.`,name:"bias"},{anchor:"transformers.WatermarkLogitsProcessor.hashing_key",description:`<strong>hashing_key</strong> (<code>int</code>, optional, <em>optional</em>, defaults to 15485863) &#x2014;
Key used for hashing. If you deploy this watermark, we advise using another private key.
Defaults to 15485863 (the millionth prime).`,name:"hashing_key"},{anchor:"transformers.WatermarkLogitsProcessor.seeding_scheme",description:`<strong>seeding_scheme</strong> (<code>str</code>, optional, <em>optional</em>, defaults to <code>&quot;lefthash&quot;</code>) &#x2014;
The seeding scheme used for selecting &#x201C;green&#x201D; tokens. Accepts values:<ul>
<li>&#x201C;lefthash&#x201D; (default): &#x201C;green&#x201D; tokens selection depend on the last token (Algorithm 2 from paper)</li>
<li>&#x201C;selfhash&#x201D;: &#x201C;green&#x201D; tokens selection depends on the current token itself (Algorithm 3 from paper)
The downside of this scheme is that it considers all possible next tokens and can be slower than &#x201C;lefthash&#x201D;.
The context length of previous tokens to use in seeding. Higher context length makes watermarking more robust.</li>
</ul>`,name:"seeding_scheme"},{anchor:"transformers.WatermarkLogitsProcessor.context_width",description:`<strong>context_width</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of previous tokens to use when setting the seed.`,name:"context_width"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2341"}}),bn=new Z({props:{anchor:"transformers.WatermarkLogitsProcessor.example",$$slots:{default:[PZ]},$$scope:{ctx:j}}}),Wo=new v({props:{name:"__call__",anchor:"transformers.WatermarkLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.WatermarkLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.WatermarkLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2463",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Bo=new ye({props:{title:"TensorFlow",local:"transformers.TFForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),Io=new v({props:{name:"class transformers.TFForcedBOSTokenLogitsProcessor",anchor:"transformers.TFForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L448"}}),zo=new v({props:{name:"__call__",anchor:"transformers.TFForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L462"}}),Vo=new v({props:{name:"class transformers.TFForcedEOSTokenLogitsProcessor",anchor:"transformers.TFForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L478"}}),Go=new v({props:{name:"__call__",anchor:"transformers.TFForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L495"}}),Fo=new v({props:{name:"class transformers.TFForceTokensLogitsProcessor",anchor:"transformers.TFForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": List"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L563"}}),Xo=new v({props:{name:"__call__",anchor:"transformers.TFForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L579"}}),Ro=new v({props:{name:"class transformers.TFLogitsProcessor",anchor:"transformers.TFLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L53"}}),Lo=new v({props:{name:"__call__",anchor:"transformers.TFLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessor.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L56",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),So=new v({props:{name:"class transformers.TFLogitsProcessorList",anchor:"transformers.TFLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L75"}}),No=new v({props:{name:"__call__",anchor:"transformers.TFLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessorList.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L82",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ho=new v({props:{name:"class transformers.TFLogitsWarper",anchor:"transformers.TFLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L64"}}),Eo=new v({props:{name:"__call__",anchor:"transformers.TFLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsWarper.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L67",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),qo=new v({props:{name:"class transformers.TFMinLengthLogitsProcessor",anchor:"transformers.TFMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.TFMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L202"}}),Qo=new v({props:{name:"__call__",anchor:"transformers.TFMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L228"}}),Do=new v({props:{name:"class transformers.TFNoBadWordsLogitsProcessor",anchor:"transformers.TFNoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": List"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated. In order to get the tokens of the words
that should not appear in the generated text, make sure to set <code>add_prefix_space=True</code> when initializing
the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code>
argument is only supported for some slow tokenizers, as fast tokenizers&#x2019; prefixing behaviours come from
<code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`,name:"bad_words_ids"},{anchor:"transformers.TFNoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L288"}}),Yo=new v({props:{name:"__call__",anchor:"transformers.TFNoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L367"}}),Po=new v({props:{name:"class transformers.TFNoRepeatNGramLogitsProcessor",anchor:"transformers.TFNoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L388"}}),Ao=new v({props:{name:"__call__",anchor:"transformers.TFNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L427"}}),Oo=new v({props:{name:"class transformers.TFRepetitionPenaltyLogitsProcessor",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L238"}}),Ko=new v({props:{name:"__call__",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L280"}}),el=new v({props:{name:"class transformers.TFSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L511"}}),tl=new v({props:{name:"__call__",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L522"}}),sl=new v({props:{name:"class transformers.TFSuppressTokensLogitsProcessor",anchor:"transformers.TFSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L541"}}),nl=new v({props:{name:"__call__",anchor:"transformers.TFSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L548"}}),al=new v({props:{name:"class transformers.TFTemperatureLogitsWarper",anchor:"transformers.TFTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TFTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L98"}}),rl=new v({props:{name:"__call__",anchor:"transformers.TFTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L113"}}),ol=new v({props:{name:"class transformers.TFTopKLogitsWarper",anchor:"transformers.TFTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TFTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L118"}}),ll=new v({props:{name:"__call__",anchor:"transformers.TFTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L138"}}),cl=new v({props:{name:"class transformers.TFTopPLogitsWarper",anchor:"transformers.TFTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TFTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L146"}}),il=new v({props:{name:"__call__",anchor:"transformers.TFTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L170"}}),dl=new ye({props:{title:"FLAX",local:"transformers.FlaxForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),pl=new v({props:{name:"class transformers.FlaxForcedBOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L195"}}),ml=new v({props:{name:"__call__",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L207"}}),hl=new v({props:{name:"class transformers.FlaxForcedEOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L217"}}),gl=new v({props:{name:"__call__",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L232"}}),ul=new v({props:{name:"class transformers.FlaxForceTokensLogitsProcessor",anchor:"transformers.FlaxForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:""}],parametersDescription:[{anchor:"transformers.FlaxForceTokensLogitsProcessor.force_token_map",description:`<strong>force_token_map</strong> (<code>list</code>) &#x2014;
Map giving token ids and indices where they will be forced to be sampled.`,name:"force_token_map"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L316"}}),fl=new v({props:{name:"__call__",anchor:"transformers.FlaxForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L338"}}),bl=new v({props:{name:"class transformers.FlaxLogitsProcessor",anchor:"transformers.FlaxLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L51"}}),_l=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L54",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),yl=new v({props:{name:"class transformers.FlaxLogitsProcessorList",anchor:"transformers.FlaxLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L73"}}),Tl=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L80",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ml=new v({props:{name:"class transformers.FlaxLogitsWarper",anchor:"transformers.FlaxLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L62"}}),vl=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L65",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),wl=new v({props:{name:"class transformers.FlaxMinLengthLogitsProcessor",anchor:"transformers.FlaxMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.FlaxMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L242"}}),kl=new v({props:{name:"__call__",anchor:"transformers.FlaxMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L263"}}),$l=new v({props:{name:"class transformers.FlaxSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong> (<code>List[int]</code>) &#x2014;
Tokens to not sample.`,name:"begin_suppress_tokens"},{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_index",description:`<strong>begin_index</strong> (<code>int</code>) &#x2014;
Index where the tokens are suppressed.`,name:"begin_index"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L272"}}),jl=new v({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L289"}}),xl=new v({props:{name:"class transformers.FlaxSuppressTokensLogitsProcessor",anchor:"transformers.FlaxSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:": list"}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensLogitsProcessor.suppress_tokens",description:`<strong>suppress_tokens</strong> (<code>list</code>) &#x2014;
Tokens to not sample.`,name:"suppress_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L297"}}),Jl=new v({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L310"}}),Ul=new v({props:{name:"class transformers.FlaxTemperatureLogitsWarper",anchor:"transformers.FlaxTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.FlaxTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L96"}}),Zl=new v({props:{name:"__call__",anchor:"transformers.FlaxTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L111"}}),Cl=new v({props:{name:"class transformers.FlaxTopKLogitsWarper",anchor:"transformers.FlaxTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.FlaxTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L160"}}),Wl=new v({props:{name:"__call__",anchor:"transformers.FlaxTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L180"}}),Bl=new v({props:{name:"class transformers.FlaxTopPLogitsWarper",anchor:"transformers.FlaxTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.FlaxTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L116"}}),Il=new v({props:{name:"__call__",anchor:"transformers.FlaxTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L140"}}),zl=new v({props:{name:"class transformers.FlaxWhisperTimeStampLogitsProcessor",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"model_config",val:""},{name:"decoder_input_length",val:""}],parametersDescription:[{anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L364"}}),Vl=new v({props:{name:"__call__",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L398"}}),Gl=new ye({props:{title:"StoppingCriteria",local:"transformers.StoppingCriteria",headingTag:"h2"}}),Xl=new v({props:{name:"class transformers.StoppingCriteria",anchor:"transformers.StoppingCriteria",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L46"}}),Rl=new v({props:{name:"__call__",anchor:"transformers.StoppingCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L53",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Ll=new v({props:{name:"class transformers.StoppingCriteriaList",anchor:"transformers.StoppingCriteriaList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L491"}}),Sl=new v({props:{name:"__call__",anchor:"transformers.StoppingCriteriaList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteriaList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteriaList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteriaList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L492",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Nl=new v({props:{name:"class transformers.MaxLengthCriteria",anchor:"transformers.MaxLengthCriteria",parameters:[{name:"max_length",val:": int"},{name:"max_position_embeddings",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length that the output sequence can have in number of tokens.`,name:"max_length"},{anchor:"transformers.MaxLengthCriteria.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum model length, as defined by the model&#x2019;s <code>config.max_position_embeddings</code> attribute.`,name:"max_position_embeddings"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L58"}}),Hl=new v({props:{name:"__call__",anchor:"transformers.MaxLengthCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxLengthCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxLengthCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L74",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),El=new v({props:{name:"class transformers.MaxTimeCriteria",anchor:"transformers.MaxTimeCriteria",parameters:[{name:"max_time",val:": float"},{name:"initial_timestamp",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.max_time",description:`<strong>max_time</strong> (<code>float</code>) &#x2014;
The maximum allowed time in seconds for the generation.`,name:"max_time"},{anchor:"transformers.MaxTimeCriteria.initial_time",description:`<strong>initial_time</strong> (<code>float</code>, <em>optional</em>, defaults to <code>time.time()</code>) &#x2014;
The start of the generation allowed time.`,name:"initial_time"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L87"}}),ql=new v({props:{name:"__call__",anchor:"transformers.MaxTimeCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxTimeCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxTimeCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L104",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Ql=new v({props:{name:"class transformers.StopStringCriteria",anchor:"transformers.StopStringCriteria",parameters:[{name:"tokenizer",val:": PreTrainedTokenizerBase"},{name:"stop_strings",val:": Union"}],parametersDescription:[{anchor:"transformers.StopStringCriteria.tokenizer",description:`<strong>tokenizer</strong> (<code>PreTrainedTokenizer</code>) &#x2014;
The model&#x2019;s associated tokenizer (necessary to extract vocab and tokenize the termination sequences)`,name:"tokenizer"},{anchor:"transformers.StopStringCriteria.stop_strings",description:`<strong>stop_strings</strong> (<code>Union[str, List[str]]</code>) &#x2014;
A list of strings that should end generation. If a string is passed, it will be treated like a
list with a single element.`,name:"stop_strings"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L110"}}),vn=new Z({props:{anchor:"transformers.StopStringCriteria.example",$$slots:{default:[AZ]},$$scope:{ctx:j}}}),Dl=new v({props:{name:"__call__",anchor:"transformers.StopStringCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StopStringCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StopStringCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StopStringCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L387",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Yl=new v({props:{name:"class transformers.EosTokenCriteria",anchor:"transformers.EosTokenCriteria",parameters:[{name:"eos_token_id",val:": Union"}],parametersDescription:[{anchor:"transformers.EosTokenCriteria.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L446"}}),Pl=new v({props:{name:"__call__",anchor:"transformers.EosTokenCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.EosTokenCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EosTokenCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.EosTokenCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L463",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Al=new ye({props:{title:"Constraints",local:"transformers.Constraint",headingTag:"h2"}}),Kl=new v({props:{name:"class transformers.Constraint",anchor:"transformers.Constraint",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L5"}}),wn=new Z({props:{anchor:"transformers.Constraint.example",$$slots:{default:[OZ]},$$scope:{ctx:j}}}),ec=new v({props:{name:"advance",anchor:"transformers.Constraint.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L48",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>A single token ID (int) that advances the constraint, or</li>
<li>A list of token IDs that could advance the constraint</li>
<li>None if the constraint is completed or cannot be advanced</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>token_ids (Union[int, List[int], None])</p>
`}}),tc=new v({props:{name:"copy",anchor:"transformers.Constraint.copy",parameters:[{name:"stateful",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L116",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The same constraint as the one being called from.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>constraint(<code>Constraint</code>)</p>
`}}),sc=new v({props:{name:"does_advance",anchor:"transformers.Constraint.does_advance",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L63"}}),nc=new v({props:{name:"remaining",anchor:"transformers.Constraint.remaining",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L107"}}),ac=new v({props:{name:"reset",anchor:"transformers.Constraint.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L97"}}),rc=new v({props:{name:"test",anchor:"transformers.Constraint.test",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L24"}}),oc=new v({props:{name:"update",anchor:"transformers.Constraint.update",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L72",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Whether this constraint has become one step closer to being fulfuilled.
completed(<code>bool</code>):
Whether this constraint has been completely fulfilled by this token being generated.
reset (<code>bool</code>):
Whether this constraint has reset its progress by this token being generated.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stepped(<code>bool</code>)</p>
`}}),lc=new v({props:{name:"class transformers.PhrasalConstraint",anchor:"transformers.PhrasalConstraint",parameters:[{name:"token_ids",val:": List"}],parametersDescription:[{anchor:"transformers.PhrasalConstraint.token_ids",description:`<strong>token_ids</strong> (<code>List[int]</code>) &#x2014;
The id of the token that must be generated by the output.`,name:"token_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L132"}}),cc=new v({props:{name:"class transformers.DisjunctiveConstraint",anchor:"transformers.DisjunctiveConstraint",parameters:[{name:"nested_token_ids",val:": List"}],parametersDescription:[{anchor:"transformers.DisjunctiveConstraint.nested_token_ids",description:`<strong>nested_token_ids</strong> (<code>List[List[int]]</code>) &#x2014;
A list of words, where each word is a list of ids. This constraint is fulfilled by generating just one from
the list of words.`,name:"nested_token_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L264"}}),ic=new v({props:{name:"class transformers.ConstraintListState",anchor:"transformers.ConstraintListState",parameters:[{name:"constraints",val:": List"}],parametersDescription:[{anchor:"transformers.ConstraintListState.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> objects that must be fulfilled by the beam scorer.`,name:"constraints"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L354"}}),dc=new v({props:{name:"advance",anchor:"transformers.ConstraintListState.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L386"}}),pc=new v({props:{name:"reset",anchor:"transformers.ConstraintListState.reset",parameters:[{name:"token_ids",val:": Optional"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L421"}}),mc=new ye({props:{title:"BeamSearch",local:"transformers.BeamScorer",headingTag:"h2"}}),hc=new v({props:{name:"class transformers.BeamScorer",anchor:"transformers.BeamScorer",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L91"}}),gc=new v({props:{name:"process",anchor:"transformers.BeamScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.BeamScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.BeamScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.BeamScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.BeamScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.BeamScorer.process.group_index",description:`<strong>group_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The index of the group of beams. Used with <code>~PreTrainedModel.group_beam_search</code>.`,name:"group_index"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L97",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of all
non-finished beams.</li>
<li><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be added
to the non-finished beam_hypotheses.</li>
<li><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),uc=new v({props:{name:"finalize",anchor:"transformers.BeamScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.finalize.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.finalize.final_beam_scores",description:`<strong>final_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The final scores of all non-finished beams.`,name:"final_beam_scores"},{anchor:"transformers.BeamScorer.finalize.final_beam_tokens",description:`<strong>final_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The last tokens to be added to the non-finished beam_hypotheses.`,name:"final_beam_tokens"},{anchor:"transformers.BeamScorer.finalize.final_beam_indices",description:`<strong>final_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The beam indices indicating to which beam the <code>final_beam_tokens</code> shall be added.`,name:"final_beam_indices"},{anchor:"transformers.BeamScorer.finalize.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.finalize.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L109",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated sequences.
The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter if all batches finished early
due to the <code>eos_token_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code> of shape <code>(batch_size * num_return_sequences, sequence_length)</code></p>
`}}),fc=new v({props:{name:"class transformers.BeamSearchScorer",anchor:"transformers.BeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"device",val:": device"},{name:"length_penalty",val:": Optional = 1.0"},{name:"do_early_stopping",val:": Union = False"},{name:"num_beam_hyps_to_keep",val:": Optional = 1"},{name:"num_beam_groups",val:": Optional = 1"},{name:"max_length",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.BeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.BeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.BeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.BeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.BeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.BeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.BeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.BeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L123"}}),bc=new v({props:{name:"process",anchor:"transformers.BeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"pad_token_id",val:": Union = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"group_index",val:": Optional = 0"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L215"}}),_c=new v({props:{name:"finalize",anchor:"transformers.BeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": Union = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L320"}}),yc=new v({props:{name:"class transformers.ConstrainedBeamSearchScorer",anchor:"transformers.ConstrainedBeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"constraints",val:": List"},{name:"device",val:": device"},{name:"length_penalty",val:": Optional = 1.0"},{name:"do_early_stopping",val:": Union = False"},{name:"num_beam_hyps_to_keep",val:": Optional = 1"},{name:"num_beam_groups",val:": Optional = 1"},{name:"max_length",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.ConstrainedBeamSearchScorer.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of positive constraints represented as <code>Constraint</code> objects that must be fulfilled in the generation
output. For more information, the documentation of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> should be read.`,name:"constraints"},{anchor:"transformers.ConstrainedBeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.ConstrainedBeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.ConstrainedBeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.ConstrainedBeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L419"}}),Tc=new v({props:{name:"process",anchor:"transformers.ConstrainedBeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"scores_for_all_vocab",val:": FloatTensor"},{name:"pad_token_id",val:": Union = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.scores_for_all_vocab",description:`<strong>scores_for_all_vocab</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
The scores of all tokens in the vocabulary for each of the beam hypotheses.`,name:"scores_for_all_vocab"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.decoder_prompt_len",description:`<strong>decoder_prompt_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The length of prompt that is included in the input to decoder.`,name:"decoder_prompt_len"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L513",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li>
<p><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of
all
non-finished beams.</p>
</li>
<li>
<p><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be
added
to the non-finished beam_hypotheses.</p>
</li>
<li>
<p><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),Mc=new v({props:{name:"finalize",anchor:"transformers.ConstrainedBeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": Union = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L813"}}),vc=new ye({props:{title:"Streamers",local:"transformers.TextStreamer",headingTag:"h2"}}),wc=new v({props:{name:"class transformers.TextStreamer",anchor:"transformers.TextStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L38"}}),Cn=new Va({props:{warning:!0,$$slots:{default:[KZ]},$$scope:{ctx:j}}}),Wn=new Z({props:{anchor:"transformers.TextStreamer.example",$$slots:{default:[eC]},$$scope:{ctx:j}}}),kc=new v({props:{name:"end",anchor:"transformers.TextStreamer.end",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L116"}}),$c=new v({props:{name:"on_finalized_text",anchor:"transformers.TextStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L130"}}),jc=new v({props:{name:"put",anchor:"transformers.TextStreamer.put",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L82"}}),xc=new v({props:{name:"class transformers.TextIteratorStreamer",anchor:"transformers.TextIteratorStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"timeout",val:": Optional = None"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextIteratorStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextIteratorStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextIteratorStreamer.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The timeout for the text queue. If <code>None</code>, the queue will block indefinitely. Useful to handle exceptions
in <code>.generate()</code>, when it is called in a separate thread.`,name:"timeout"},{anchor:"transformers.TextIteratorStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L159"}}),Vn=new Va({props:{warning:!0,$$slots:{default:[tC]},$$scope:{ctx:j}}}),Gn=new Z({props:{anchor:"transformers.TextIteratorStreamer.example",$$slots:{default:[sC]},$$scope:{ctx:j}}}),Jc=new v({props:{name:"on_finalized_text",anchor:"transformers.TextIteratorStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L213"}}),Uc=new ye({props:{title:"Caches",local:"transformers.Cache",headingTag:"h2"}}),Zc=new v({props:{name:"class transformers.Cache",anchor:"transformers.Cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L28"}}),Cc=new v({props:{name:"update",anchor:"transformers.Cache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Cache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.Cache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.Cache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.Cache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. These are specific to each subclass and allow new types of
cache to be created.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L36",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),Wc=new v({props:{name:"class transformers.CacheConfig",anchor:"transformers.CacheConfig",parameters:[{name:"cache_implementation",val:": None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L115"}}),Bc=new v({props:{name:"update",anchor:"transformers.CacheConfig.update",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CacheConfig.update.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary of attributes to tentatively update this class.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L189",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary containing all the key-value pairs that were not used to update the instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Ic=new v({props:{name:"class transformers.QuantizedCacheConfig",anchor:"transformers.QuantizedCacheConfig",parameters:[{name:"backend",val:": str = 'quanto'"},{name:"nbits",val:": Optional = 4"},{name:"axis_key",val:": Optional = 0"},{name:"axis_value",val:": Optional = 0"},{name:"q_group_size",val:": Optional = 64"},{name:"residual_length",val:": Optional = 128"},{name:"compute_dtype",val:": Optional = torch.float16"},{name:"device",val:": Optional = 'cpu'"}],parametersDescription:[{anchor:"transformers.QuantizedCacheConfig.backend",description:`<strong>backend</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;quanto&quot;</code>) &#x2014;
Backend to use when performing quantization, Can be one of [<code>quanto</code>, <code>HQQ</code>]`,name:"backend"},{anchor:"transformers.QuantizedCacheConfig.nbits",description:`<strong>nbits</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to 4) &#x2014;
Number of bits, can be 2 or 4 for the <code>quanto</code> backend and one of [1, 2, 3, 4, 8] for the <code>HQQ</code> backend. Defaults to 2.`,name:"nbits"},{anchor:"transformers.QuantizedCacheConfig.axis_key",description:`<strong>axis_key</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Axis over which to perform grouping for the key tensors. Can be [0, -1] for <code>quanto</code> backend and [0, 1] for <code>HQQ</code> backend.`,name:"axis_key"},{anchor:"transformers.QuantizedCacheConfig.axis_value",description:`<strong>axis_value</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Axis over which to perform grouping for the value tensors. Can be [0, -1] for <code>quanto</code> backend and [0, 1] for <code>HQQ</code> backend.`,name:"axis_value"},{anchor:"transformers.QuantizedCacheConfig.q_group_size",description:`<strong>q_group_size</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to 64) &#x2014;
Size of the quantization group, should be a divisor of the model&#x2019;s hidden dimension.
Defaults to 64.`,name:"q_group_size"},{anchor:"transformers.QuantizedCacheConfig.residual_length",description:`<strong>residual_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to 128) &#x2014;
Length of the residual cache which will always be stored in original presicion.
Defaults to 128.`,name:"residual_length"},{anchor:"transformers.QuantizedCacheConfig.compute_dtype",description:`<strong>compute_dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float16</code>) &#x2014;
The defualt dtype used for computations in the model. Keys and Values will be cast to this dtype after dequantization.`,name:"compute_dtype"},{anchor:"transformers.QuantizedCacheConfig.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
Device on which to perform computations, should be same as the model&#x2019;s device.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L212"}}),zc=new v({props:{name:"validate",anchor:"transformers.QuantizedCacheConfig.validate",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L258"}}),Vc=new v({props:{name:"class transformers.DynamicCache",anchor:"transformers.DynamicCache",parameters:[{name:"num_hidden_layers",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L351"}}),Sn=new Z({props:{anchor:"transformers.DynamicCache.example",$$slots:{default:[nC]},$$scope:{ctx:j}}}),Gc=new v({props:{name:"update",anchor:"transformers.DynamicCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.DynamicCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.DynamicCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.DynamicCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.DynamicCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. No additional arguments are used in <code>DynamicCache</code>.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L408",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),Fc=new v({props:{name:"get_seq_length",anchor:"transformers.DynamicCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L452"}}),Xc=new v({props:{name:"reorder_cache",anchor:"transformers.DynamicCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L93"}}),Rc=new v({props:{name:"to_legacy_cache",anchor:"transformers.DynamicCache.to_legacy_cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L467"}}),Lc=new v({props:{name:"from_legacy_cache",anchor:"transformers.DynamicCache.from_legacy_cache",parameters:[{name:"past_key_values",val:": Optional = None"},{name:"num_hidden_layers",val:": int = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L475"}}),Sc=new v({props:{name:"class transformers.QuantizedCache",anchor:"transformers.QuantizedCache",parameters:[{name:"cache_config",val:": QuantizedCacheConfig"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L662"}}),Nc=new v({props:{name:"update",anchor:"transformers.QuantizedCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L691"}}),Hc=new v({props:{name:"get_seq_length",anchor:"transformers.QuantizedCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L734"}}),Ec=new v({props:{name:"class transformers.QuantoQuantizedCache",anchor:"transformers.QuantoQuantizedCache",parameters:[{name:"cache_config",val:": CacheConfig"}],parametersDescription:[{anchor:"transformers.QuantoQuantizedCache.cache_config",description:`<strong>cache_config</strong> (<code>QuantizedCacheConfig</code>) &#x2014;
A configuration containing all the arguments to be used by the quantizer, including axis, qtype and group size.`,name:"cache_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L752"}}),Yn=new Z({props:{anchor:"transformers.QuantoQuantizedCache.example",$$slots:{default:[aC]},$$scope:{ctx:j}}}),qc=new v({props:{name:"class transformers.HQQQuantizedCache",anchor:"transformers.HQQQuantizedCache",parameters:[{name:"cache_config",val:": CacheConfig"}],parametersDescription:[{anchor:"transformers.HQQQuantizedCache.cache_config",description:`<strong>cache_config</strong> (<code>QuantizedCacheConfig</code>) &#x2014;
A configuration containing all the arguments to be used by the quantizer, including axis, qtype and group size.`,name:"cache_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L833"}}),Pn=new Z({props:{anchor:"transformers.HQQQuantizedCache.example",$$slots:{default:[rC]},$$scope:{ctx:j}}}),Qc=new v({props:{name:"class transformers.SinkCache",anchor:"transformers.SinkCache",parameters:[{name:"window_length",val:": int"},{name:"num_sink_tokens",val:": int"}],parametersDescription:[{anchor:"transformers.SinkCache.window_length",description:`<strong>window_length</strong> (<code>int</code>) &#x2014;
The length of the context window.`,name:"window_length"},{anchor:"transformers.SinkCache.num_sink_tokens",description:`<strong>num_sink_tokens</strong> (<code>int</code>) &#x2014;
The number of sink tokens. See the original paper for more information.`,name:"num_sink_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L895"}}),An=new Z({props:{anchor:"transformers.SinkCache.example",$$slots:{default:[oC]},$$scope:{ctx:j}}}),Dc=new v({props:{name:"update",anchor:"transformers.SinkCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.SinkCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.SinkCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.SinkCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.SinkCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. The following arguments can be used in <code>SinkCache</code>: <code>sin</code>,
<code>cos</code> and <code>partial_rotation_size</code>. These arguments are used with models using RoPE, to recompute the
rotation as the tokens are shifted.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L987",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),Yc=new v({props:{name:"get_seq_length",anchor:"transformers.SinkCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L975"}}),Pc=new v({props:{name:"reorder_cache",anchor:"transformers.SinkCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L93"}}),Ac=new v({props:{name:"class transformers.OffloadedCache",anchor:"transformers.OffloadedCache",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L548"}}),Oc=new v({props:{name:"update",anchor:"transformers.OffloadedCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.OffloadedCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.OffloadedCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.OffloadedCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.OffloadedCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. No additional arguments are used in <code>OffloadedCache</code>.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L615",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),Kc=new v({props:{name:"prefetch_layer",anchor:"transformers.OffloadedCache.prefetch_layer",parameters:[{name:"layer_idx",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L569"}}),ei=new v({props:{name:"evict_previous_layer",anchor:"transformers.OffloadedCache.evict_previous_layer",parameters:[{name:"layer_idx",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L578"}}),ti=new v({props:{name:"class transformers.StaticCache",anchor:"transformers.StaticCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"batch_size",val:": int = None"},{name:"max_cache_len",val:": int = None"},{name:"device",val:": device = None"},{name:"dtype",val:": dtype = torch.float32"},{name:"max_batch_size",val:": Optional = None"},{name:"layer_device_map",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.StaticCache.config",description:`<strong>config</strong> (<code>PretrainedConfig</code>) &#x2014;
The configuration file defining the shape-related attributes required to initialize the static cache.`,name:"config"},{anchor:"transformers.StaticCache.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
The batch size with which the model will be used. Note that a new instance must be instantiated if a
smaller batch size is used. If you are manually setting the batch size, make sure to take into account the number of beams if you are running beam search`,name:"batch_size"},{anchor:"transformers.StaticCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.StaticCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.`,name:"device"},{anchor:"transformers.StaticCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.StaticCache.layer_device_map(`Dict[int,",description:"<strong>layer_device_map(`Dict[int,</strong> Union[str, torch.device, int]]]<code>, </code>optional<code>) -- Mapping between the layers and its device. This is required when you are manually initializing the cache and the model is splitted between differents gpus. You can know which layers mapped to which device by checking the associated device_map: </code>model.hf_device_map`.",name:"layer_device_map(`Dict[int,"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1082"}}),aa=new Z({props:{anchor:"transformers.StaticCache.example",$$slots:{default:[lC]},$$scope:{ctx:j}}}),si=new v({props:{name:"update",anchor:"transformers.StaticCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.StaticCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.StaticCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.StaticCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.StaticCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. The <code>StaticCache</code> needs the <code>cache_position</code> input
to know how where to write in the cache.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1181",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),ni=new v({props:{name:"get_seq_length",anchor:"transformers.StaticCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1229"}}),ai=new v({props:{name:"reset",anchor:"transformers.StaticCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1239"}}),ri=new v({props:{name:"class transformers.OffloadedStaticCache",anchor:"transformers.OffloadedStaticCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"max_batch_size",val:": int"},{name:"max_cache_len",val:": Optional"},{name:"device",val:": Union"},{name:"dtype",val:": Optional = None"},{name:"offload_device",val:": Union = device(type='cpu')"}],parametersDescription:[{anchor:"transformers.OffloadedStaticCache.config",description:`<strong>config</strong> (\`PretrainedConfig) &#x2014;
The configuration file defining the shape-related attributes required to initialize
the static cache.`,name:"config"},{anchor:"transformers.OffloadedStaticCache.max_batch_size",description:`<strong>max_batch_size</strong> (<code>int</code>) &#x2014;
The maximum batch size with which the model will be used.`,name:"max_batch_size"},{anchor:"transformers.OffloadedStaticCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.OffloadedStaticCache.device",description:`<strong>device</strong> (<code>Union[str, torch.device]</code>) &#x2014;
The device on which the cache should be initialized. Should be the same as the
layer device.`,name:"device"},{anchor:"transformers.OffloadedStaticCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>) &#x2014;
The default <code>dtype</code> to use when initializing the cache.`,name:"dtype"},{anchor:"transformers.OffloadedStaticCache.offload_device",description:`<strong>offload_device</strong> (<code>Union[str, torch.device]</code>, <em>optional</em>, defaults to <code>cpu</code>) &#x2014;
The device to offload to. Defaults to CPU.`,name:"offload_device"},{anchor:"transformers.OffloadedStaticCache.key_cache",description:`<strong>key_cache</strong> (<code>List[torch.Tensor]</code>) &#x2014;
Off-loaded key cache tensors. First one will be on device, where-as the others are
off-loaded.`,name:"key_cache"},{anchor:"transformers.OffloadedStaticCache.value_cache",description:`<strong>value_cache</strong> (<code>List[torch.Tensor]</code>) &#x2014;
Off-loaded value cache tensors. First one will be on device, where-as the others are
off-loaded.`,name:"value_cache"},{anchor:"transformers.OffloadedStaticCache.max_batch_size",description:`<strong>max_batch_size</strong> (<code>int</code>) &#x2014;
The maximum batch size with which this cache can be used.`,name:"max_batch_size"},{anchor:"transformers.OffloadedStaticCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which this cache can be used.`,name:"max_cache_len"},{anchor:"transformers.OffloadedStaticCache.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
The device on which the cache is used.`,name:"device"},{anchor:"transformers.OffloadedStaticCache.offload_device",description:`<strong>offload_device</strong> (<code>torch.device</code>) &#x2014;
The device used to offload to.`,name:"offload_device"},{anchor:"transformers.OffloadedStaticCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>) &#x2014;
The <code>dtype</code> used to initializing the cache.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1853"}}),ca=new Z({props:{anchor:"transformers.OffloadedStaticCache.example",$$slots:{default:[cC]},$$scope:{ctx:j}}}),oi=new v({props:{name:"update",anchor:"transformers.OffloadedStaticCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.OffloadedStaticCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.OffloadedStaticCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.OffloadedStaticCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.OffloadedStaticCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional arguments for the cache subclass. The <code>OffloadedStaticCache</code> needs the
<code>cache_position</code> input to know how where to write in the cache.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1965",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),li=new v({props:{name:"get_seq_length",anchor:"transformers.OffloadedStaticCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L2048"}}),ci=new v({props:{name:"reset",anchor:"transformers.OffloadedStaticCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L2059"}}),ii=new v({props:{name:"class transformers.HybridCache",anchor:"transformers.HybridCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"batch_size",val:": int = None"},{name:"max_cache_len",val:": int = None"},{name:"device",val:": Union = 'cpu'"},{name:"dtype",val:": dtype = torch.float32"},{name:"max_batch_size",val:": Optional = None"},{name:"layer_device_map",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.HybridCache.config",description:"<strong>config</strong> (`PretrainedConfig) &#x2014;\nThe configuration file defining the shape-related attributes required to initialize the static cache.",name:"config"},{anchor:"transformers.HybridCache.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
The batch size with which the model will be used. Note that a new instance must be instantiated if a
smaller batch size is used.`,name:"batch_size"},{anchor:"transformers.HybridCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.HybridCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.`,name:"device"},{anchor:"transformers.HybridCache.dtype",description:`<strong>dtype</strong> (torch.dtype, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.HybridCache.layer_device_map(`Dict[int,",description:"<strong>layer_device_map(`Dict[int,</strong> Union[str, torch.device, int]]]<code>, </code>optional<code>) -- Mapping between the layers and its device. This is required when you are manually initializing the cache and the model is splitted between differents gpus. You can know which layers mapped to which device by checking the associated device_map: </code>model.hf_device_map`.",name:"layer_device_map(`Dict[int,"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1558"}}),ma=new Z({props:{anchor:"transformers.HybridCache.example",$$slots:{default:[iC]},$$scope:{ctx:j}}}),di=new v({props:{name:"update",anchor:"transformers.HybridCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1697"}}),pi=new v({props:{name:"get_seq_length",anchor:"transformers.HybridCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1726"}}),mi=new v({props:{name:"reset",anchor:"transformers.HybridCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1737"}}),hi=new v({props:{name:"class transformers.SlidingWindowCache",anchor:"transformers.SlidingWindowCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"batch_size",val:": int = None"},{name:"max_cache_len",val:": int = None"},{name:"device",val:": device = None"},{name:"dtype",val:": dtype = torch.float32"},{name:"max_batch_size",val:": Optional = None"},{name:"layer_device_map",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.SlidingWindowCache.config",description:`<strong>config</strong> (<code>PretrainedConfig</code>) &#x2014;
The configuration file defining the shape-related attributes required to initialize the static cache.`,name:"config"},{anchor:"transformers.SlidingWindowCache.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
The batch size with which the model will be used. Note that a new instance must be instantiated if a
smaller batch size is used.`,name:"batch_size"},{anchor:"transformers.SlidingWindowCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.SlidingWindowCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.`,name:"device"},{anchor:"transformers.SlidingWindowCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.SlidingWindowCache.layer_device_map(`Dict[int,",description:"<strong>layer_device_map(`Dict[int,</strong> Union[str, torch.device, int]]]<code>, </code>optional<code>) -- Mapping between the layers and its device. This is required when you are manually initializing the cache and the model is splitted between differents gpus. You can know which layers mapped to which device by checking the associated device_map: </code>model.hf_device_map`.",name:"layer_device_map(`Dict[int,"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1247"}}),ga=new Z({props:{anchor:"transformers.SlidingWindowCache.example",$$slots:{default:[dC]},$$scope:{ctx:j}}}),gi=new v({props:{name:"update",anchor:"transformers.SlidingWindowCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1330"}}),ui=new v({props:{name:"reset",anchor:"transformers.SlidingWindowCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1380"}}),fi=new v({props:{name:"class transformers.EncoderDecoderCache",anchor:"transformers.EncoderDecoderCache",parameters:[{name:"self_attention_cache",val:": Cache"},{name:"cross_attention_cache",val:": Cache"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1387"}}),ua=new Z({props:{anchor:"transformers.EncoderDecoderCache.example",$$slots:{default:[pC]},$$scope:{ctx:j}}}),bi=new v({props:{name:"get_seq_length",anchor:"transformers.EncoderDecoderCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1475"}}),_i=new v({props:{name:"to_legacy_cache",anchor:"transformers.EncoderDecoderCache.to_legacy_cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1444"}}),yi=new v({props:{name:"from_legacy_cache",anchor:"transformers.EncoderDecoderCache.from_legacy_cache",parameters:[{name:"past_key_values",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1456"}}),Ti=new v({props:{name:"reset",anchor:"transformers.EncoderDecoderCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1480"}}),Mi=new v({props:{name:"reorder_cache",anchor:"transformers.EncoderDecoderCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1495"}}),vi=new v({props:{name:"class transformers.MambaCache",anchor:"transformers.MambaCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"batch_size",val:": int = None"},{name:"dtype",val:": dtype = torch.float16"},{name:"device",val:": Union = None"},{name:"max_batch_size",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MambaCache.config",description:"<strong>config</strong> (`PretrainedConfig) &#x2014;\nThe configuration file defining the shape-related attributes required to initialize the static cache.",name:"config"},{anchor:"transformers.MambaCache.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
The batch size with which the model will be used. Note that a new instance must be instantiated if a
smaller batch size is used.`,name:"batch_size"},{anchor:"transformers.MambaCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float16</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.MambaCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>, <em>optional</em>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.
dtype &#x2014; (<code>torch.dtype</code>):
The default <code>dtype</code> used to initializing the cache.
intermediate_size &#x2014; (<code>int</code>):
Model&#x2019;s intermediate_size taken from config.
ssm_state_size &#x2014; (<code>int</code>):
Model&#x2019;s state_size taken from config.
conv_kernel_size &#x2014; (<code>int</code>):
Model&#x2019;s convolution kernel size taken from config
conv_states &#x2014; (<code>torch.Tensor</code>):
A tensor of shape <code>[layer_idx, batch_size, intermediate_size, conv_kernel_size]</code> that holds convolutional states.
ssm_states &#x2014; (<code>torch.Tensor</code>):
A tensor of shape <code>[layer_idx, batch_size, intermediate_size, ssm_state_size]</code> that holds ssm states`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1745"}}),Ta=new Z({props:{anchor:"transformers.MambaCache.example",$$slots:{default:[mC]},$$scope:{ctx:j}}}),wi=new v({props:{name:"update_conv_state",anchor:"transformers.MambaCache.update_conv_state",parameters:[{name:"layer_idx",val:": int"},{name:"new_conv_state",val:": Tensor"},{name:"cache_position",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1832"}}),ki=new v({props:{name:"update_ssm_state",anchor:"transformers.MambaCache.update_ssm_state",parameters:[{name:"layer_idx",val:": int"},{name:"new_ssm_state",val:": Tensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1844"}}),$i=new v({props:{name:"reset",anchor:"transformers.MambaCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1848"}}),ji=new ye({props:{title:"Watermark Utils",local:"transformers.WatermarkingConfig",headingTag:"h2"}}),xi=new v({props:{name:"class transformers.WatermarkingConfig",anchor:"transformers.WatermarkingConfig",parameters:[{name:"greenlist_ratio",val:": Optional = 0.25"},{name:"bias",val:": Optional = 2.0"},{name:"hashing_key",val:": Optional = 15485863"},{name:"seeding_scheme",val:": Optional = 'lefthash'"},{name:"context_width",val:": Optional = 1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L1377"}}),Ji=new v({props:{name:"__call__",anchor:"transformers.WatermarkingConfig.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Ui=new v({props:{name:"class transformers.WatermarkDetector",anchor:"transformers.WatermarkDetector",parameters:[{name:"model_config",val:": PretrainedConfig"},{name:"device",val:": str"},{name:"watermarking_config",val:": Union"},{name:"ignore_repeated_ngrams",val:": bool = False"},{name:"max_cache_size",val:": int = 128"}],parametersDescription:[{anchor:"transformers.WatermarkDetector.model_config",description:`<strong>model_config</strong> (<code>PretrainedConfig</code>) &#x2014;
The model config that will be used to get model specific arguments used when generating.`,name:"model_config"},{anchor:"transformers.WatermarkDetector.device",description:`<strong>device</strong> (<code>str</code>) &#x2014;
The device which was used during watermarked text generation.`,name:"device"},{anchor:"transformers.WatermarkDetector.watermarking_config",description:`<strong>watermarking_config</strong> (Union[<code>WatermarkingConfig</code>, <code>Dict</code>]) &#x2014;
The exact same watermarking config and arguments used when generating text.`,name:"watermarking_config"},{anchor:"transformers.WatermarkDetector.ignore_repeated_ngrams",description:`<strong>ignore_repeated_ngrams</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to count every unique ngram only once or not.`,name:"ignore_repeated_ngrams"},{anchor:"transformers.WatermarkDetector.max_cache_size",description:`<strong>max_cache_size</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The max size to be used for LRU caching of seeding/sampling algorithms called for every token.`,name:"max_cache_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/watermarking.py#L73"}}),va=new Z({props:{anchor:"transformers.WatermarkDetector.example",$$slots:{default:[hC]},$$scope:{ctx:j}}}),Zi=new v({props:{name:"__call__",anchor:"transformers.WatermarkDetector.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"z_threshold",val:": float = 3.0"},{name:"return_dict",val:": bool = False"}],parametersDescription:[{anchor:"transformers.WatermarkDetector.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The watermark generated text. It is advised to remove the prompt, which can affect the detection.`,name:"input_ids"},{anchor:"transformers.WatermarkDetector.__call__.z_threshold",description:`<strong>z_threshold</strong> (<code>Dict</code>, <em>optional</em>, defaults to <code>3.0</code>) &#x2014;
Changing this threshold will change the sensitivity of the detector. Higher z threshold gives less
sensitivity and vice versa for lower z threshold.`,name:"z_threshold"},{anchor:"transformers.WatermarkDetector.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>,  <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return <code>~generation.WatermarkDetectorOutput</code> or not. If not it will return boolean predictions,`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/watermarking.py#L193",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>WatermarkDetectorOutput</code>
if <code>return_dict=True</code> otherwise a <code>np.array</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>WatermarkDetectorOutput</code> or <code>np.array</code></p>
`}}),Ci=new v({props:{name:"class transformers.BayesianDetectorConfig",anchor:"transformers.BayesianDetectorConfig",parameters:[{name:"watermarking_depth",val:": int = None"},{name:"base_rate",val:": float = 0.5"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BayesianDetectorConfig.watermarking_depth",description:`<strong>watermarking_depth</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of tournament layers.`,name:"watermarking_depth"},{anchor:"transformers.BayesianDetectorConfig.base_rate",description:`<strong>base_rate</strong> (<code>float1</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Prior probability P(w) that a text is watermarked.`,name:"base_rate"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/watermarking.py#L245"}}),Wi=new v({props:{name:"class transformers.BayesianDetectorModel",anchor:"transformers.BayesianDetectorModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.BayesianDetectorModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BayesianDetectorConfig">BayesianDetectorConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/watermarking.py#L352"}}),Bi=new v({props:{name:"forward",anchor:"transformers.BayesianDetectorModel.forward",parameters:[{name:"g_values",val:": Tensor"},{name:"mask",val:": Tensor"},{name:"labels",val:": Optional = None"},{name:"loss_batch_weight",val:" = 1"},{name:"return_dict",val:" = False"}],parametersDescription:[{anchor:"transformers.BayesianDetectorModel.forward.g_values",description:`<strong>g_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, seq_len, watermarking_depth, ...)</code>) &#x2014;
g-values (with values 0 or 1)
mask &#x2014;
A binary array shape [batch_size, seq_len] indicating which g-values should be used. g-values with mask
value 0 are discarded.`,name:"g_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/watermarking.py#L438",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>p(watermarked | g_values), of shape [batch_size].</p>
`}}),Ii=new v({props:{name:"class transformers.SynthIDTextWatermarkingConfig",anchor:"transformers.SynthIDTextWatermarkingConfig",parameters:[{name:"ngram_len",val:": int"},{name:"keys",val:": List"},{name:"context_history_size",val:": int = 1024"},{name:"sampling_table_seed",val:": int = 0"},{name:"sampling_table_size",val:": int = 65536"},{name:"skip_first_ngram_calls",val:": bool = False"},{name:"debug_mode",val:": bool = False"}],parametersDescription:[{anchor:"transformers.SynthIDTextWatermarkingConfig.ngram_len",description:`<strong>ngram_len</strong> (<code>int</code>) &#x2014;
Ngram length.`,name:"ngram_len"},{anchor:"transformers.SynthIDTextWatermarkingConfig.keys",description:`<strong>keys</strong> (<code>List[int]</code>) &#x2014;
A sequence of watermarking keys, one for each depth.`,name:"keys"},{anchor:"transformers.SynthIDTextWatermarkingConfig.context_history_size",description:`<strong>context_history_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Size of the tensor to keep track of seen contexts.`,name:"context_history_size"},{anchor:"transformers.SynthIDTextWatermarkingConfig.sampling_table_seed",description:`<strong>sampling_table_seed</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Random seed to generate the sampling table.`,name:"sampling_table_seed"},{anchor:"transformers.SynthIDTextWatermarkingConfig.sampling_table_size",description:`<strong>sampling_table_size</strong> (<code>int</code>, <em>optional</em>, defaults to 65536) &#x2014;
Size of the sampling table.`,name:"sampling_table_size"},{anchor:"transformers.SynthIDTextWatermarkingConfig.skip_first_ngram_calls",description:`<strong>skip_first_ngram_calls</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip first ngram calls.`,name:"skip_first_ngram_calls"},{anchor:"transformers.SynthIDTextWatermarkingConfig.debug_mode",description:`<strong>debug_mode</strong> (<code>bool</code>, optional, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Logits are modified to uniform one got before watermarking modification is applied. This is to test the
implementation.`,name:"debug_mode"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L1455"}}),$a=new Z({props:{anchor:"transformers.SynthIDTextWatermarkingConfig.example",$$slots:{default:[gC]},$$scope:{ctx:j}}}),zi=new v({props:{name:"class transformers.SynthIDTextWatermarkDetector",anchor:"transformers.SynthIDTextWatermarkDetector",parameters:[{name:"detector_module",val:": BayesianDetectorModel"},{name:"logits_processor",val:": SynthIDTextWatermarkLogitsProcessor"},{name:"tokenizer",val:": Any"}],parametersDescription:[{anchor:"transformers.SynthIDTextWatermarkDetector.detector_module",description:`<strong>detector_module</strong> (<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BayesianDetectorModel">BayesianDetectorModel</a>) &#x2014;
Bayesian detector module object initialized with parameters.
Check examples/research_projects/synthid_text/detector_training.py for usage.`,name:"detector_module"},{anchor:"transformers.SynthIDTextWatermarkDetector.logits_processor",description:`<strong>logits_processor</strong> (<code>SynthIDTextWatermarkLogitsProcessor</code>) &#x2014;
The logits processor used for watermarking.`,name:"logits_processor"},{anchor:"transformers.SynthIDTextWatermarkDetector.tokenizer",description:`<strong>tokenizer</strong> (<code>Any</code>) &#x2014;
The tokenizer used for the model.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/watermarking.py#L482"}}),ja=new Z({props:{anchor:"transformers.SynthIDTextWatermarkDetector.example",$$slots:{default:[uC]},$$scope:{ctx:j}}}),Vi=new v({props:{name:"__call__",anchor:"transformers.SynthIDTextWatermarkDetector.__call__",parameters:[{name:"tokenized_outputs",val:": Tensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/watermarking.py#L529"}}),Gi=new fZ({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/internal/generation_utils.md"}}),{c(){c=o("meta"),$=a(),y=o("p"),d=a(),m(w.$$.fragment),s=a(),k=o("p"),k.innerHTML=V$,zf=a(),m(Ga.$$.fragment),Vf=a(),Fa=o("p"),Fa.innerHTML=G$,Gf=a(),Xa=o("p"),Xa.textContent=F$,Ff=a(),m(Ra.$$.fragment),Xf=a(),La=o("p"),La.innerHTML=X$,Rf=a(),Sa=o("ul"),Sa.innerHTML=R$,Lf=a(),Na=o("p"),Na.innerHTML=L$,Sf=a(),Ha=o("p"),Ha.innerHTML=S$,Nf=a(),Ea=o("p"),Ea.innerHTML=N$,Hf=a(),m(qa.$$.fragment),Ef=a(),Qa=o("p"),Qa.innerHTML=H$,qf=a(),Da=o("p"),Da.innerHTML=E$,Qf=a(),Ya=o("p"),Ya.textContent=q$,Df=a(),m(Pa.$$.fragment),Yf=a(),ms=o("div"),m(Aa.$$.fragment),pT=a(),td=o("p"),td.textContent=Q$,Pf=a(),hs=o("div"),m(Oa.$$.fragment),mT=a(),sd=o("p"),sd.textContent=D$,Af=a(),gs=o("div"),m(Ka.$$.fragment),hT=a(),nd=o("p"),nd.textContent=Y$,Of=a(),us=o("div"),m(er.$$.fragment),gT=a(),ad=o("p"),ad.textContent=P$,Kf=a(),m(tr.$$.fragment),eb=a(),fs=o("div"),m(sr.$$.fragment),uT=a(),rd=o("p"),rd.textContent=A$,tb=a(),bs=o("div"),m(nr.$$.fragment),fT=a(),od=o("p"),od.textContent=O$,sb=a(),_s=o("div"),m(ar.$$.fragment),bT=a(),ld=o("p"),ld.textContent=K$,nb=a(),ys=o("div"),m(rr.$$.fragment),_T=a(),cd=o("p"),cd.textContent=ej,ab=a(),Ts=o("div"),m(or.$$.fragment),yT=a(),id=o("p"),id.textContent=tj,rb=a(),Ms=o("div"),m(lr.$$.fragment),TT=a(),dd=o("p"),dd.textContent=sj,ob=a(),vs=o("div"),m(cr.$$.fragment),MT=a(),pd=o("p"),pd.textContent=nj,lb=a(),ws=o("div"),m(ir.$$.fragment),vT=a(),md=o("p"),md.textContent=aj,cb=a(),ks=o("div"),m(dr.$$.fragment),wT=a(),hd=o("p"),hd.textContent=rj,ib=a(),$s=o("div"),m(pr.$$.fragment),kT=a(),gd=o("p"),gd.textContent=oj,db=a(),m(mr.$$.fragment),pb=a(),et=o("div"),m(hr.$$.fragment),$T=a(),ud=o("p"),ud.textContent=lj,jT=a(),Is=o("div"),m(gr.$$.fragment),xT=a(),fd=o("p"),fd.textContent=cj,mb=a(),tt=o("div"),m(ur.$$.fragment),JT=a(),bd=o("p"),bd.textContent=ij,UT=a(),zs=o("div"),m(fr.$$.fragment),ZT=a(),_d=o("p"),_d.textContent=dj,hb=a(),st=o("div"),m(br.$$.fragment),CT=a(),yd=o("p"),yd.textContent=pj,WT=a(),Vs=o("div"),m(_r.$$.fragment),BT=a(),Td=o("p"),Td.textContent=mj,gb=a(),m(yr.$$.fragment),ub=a(),Tr=o("p"),Tr.innerHTML=hj,fb=a(),m(Mr.$$.fragment),bb=a(),ke=o("div"),m(vr.$$.fragment),IT=a(),Md=o("p"),Md.innerHTML=gj,zT=a(),m(Gs.$$.fragment),VT=a(),vd=o("div"),m(wr.$$.fragment),_b=a(),S=o("div"),m(kr.$$.fragment),GT=a(),wd=o("p"),wd.innerHTML=uj,FT=a(),kd=o("p"),kd.innerHTML=fj,XT=a(),m(Fs.$$.fragment),RT=a(),m(Xs.$$.fragment),LT=a(),$d=o("div"),m($r.$$.fragment),yb=a(),se=o("div"),m(jr.$$.fragment),ST=a(),jd=o("p"),jd.innerHTML=bj,NT=a(),xd=o("p"),xd.textContent=_j,HT=a(),m(Rs.$$.fragment),ET=a(),Jd=o("div"),m(xr.$$.fragment),Tb=a(),ne=o("div"),m(Jr.$$.fragment),qT=a(),Ud=o("p"),Ud.innerHTML=yj,QT=a(),Zd=o("p"),Zd.textContent=Tj,DT=a(),m(Ls.$$.fragment),YT=a(),Cd=o("div"),m(Ur.$$.fragment),Mb=a(),$e=o("div"),m(Zr.$$.fragment),PT=a(),Wd=o("p"),Wd.innerHTML=Mj,AT=a(),m(Ss.$$.fragment),OT=a(),Bd=o("div"),m(Cr.$$.fragment),vb=a(),je=o("div"),m(Wr.$$.fragment),KT=a(),Id=o("p"),Id.innerHTML=vj,eM=a(),m(Ns.$$.fragment),tM=a(),zd=o("div"),m(Br.$$.fragment),wb=a(),xe=o("div"),m(Ir.$$.fragment),sM=a(),Vd=o("p"),Vd.innerHTML=wj,nM=a(),m(Hs.$$.fragment),aM=a(),Gd=o("div"),m(zr.$$.fragment),kb=a(),Je=o("div"),m(Vr.$$.fragment),rM=a(),Fd=o("p"),Fd.innerHTML=kj,oM=a(),m(Es.$$.fragment),lM=a(),Xd=o("div"),m(Gr.$$.fragment),$b=a(),Ue=o("div"),m(Fr.$$.fragment),cM=a(),Rd=o("p"),Rd.innerHTML=$j,iM=a(),m(qs.$$.fragment),dM=a(),Ld=o("div"),m(Xr.$$.fragment),jb=a(),N=o("div"),m(Rr.$$.fragment),pM=a(),Sd=o("p"),Sd.innerHTML=jj,mM=a(),Nd=o("p"),Nd.innerHTML=xj,hM=a(),Hd=o("p"),Hd.innerHTML=Jj,gM=a(),m(Qs.$$.fragment),uM=a(),Ed=o("div"),m(Lr.$$.fragment),xb=a(),Ze=o("div"),m(Sr.$$.fragment),fM=a(),qd=o("p"),qd.innerHTML=Uj,bM=a(),Qd=o("p"),Qd.innerHTML=Zj,_M=a(),Dd=o("div"),m(Nr.$$.fragment),Jb=a(),Ce=o("div"),m(Hr.$$.fragment),yM=a(),Yd=o("p"),Yd.innerHTML=Cj,TM=a(),m(Ds.$$.fragment),MM=a(),Pd=o("div"),m(Er.$$.fragment),Ub=a(),nt=o("div"),m(qr.$$.fragment),vM=a(),Ad=o("p"),Ad.textContent=Wj,wM=a(),Od=o("div"),m(Qr.$$.fragment),Zb=a(),at=o("div"),m(Dr.$$.fragment),kM=a(),Kd=o("p"),Kd.innerHTML=Bj,$M=a(),ep=o("div"),m(Yr.$$.fragment),Cb=a(),We=o("div"),m(Pr.$$.fragment),jM=a(),tp=o("p"),tp.innerHTML=Ij,xM=a(),m(Ys.$$.fragment),JM=a(),sp=o("div"),m(Ar.$$.fragment),Wb=a(),Be=o("div"),m(Or.$$.fragment),UM=a(),np=o("p"),np.innerHTML=zj,ZM=a(),m(Ps.$$.fragment),CM=a(),ap=o("div"),m(Kr.$$.fragment),Bb=a(),H=o("div"),m(eo.$$.fragment),WM=a(),rp=o("p"),rp.innerHTML=Vj,BM=a(),op=o("p"),op.innerHTML=Gj,IM=a(),lp=o("p"),lp.innerHTML=Fj,zM=a(),m(As.$$.fragment),VM=a(),cp=o("div"),m(to.$$.fragment),Ib=a(),ae=o("div"),m(so.$$.fragment),GM=a(),ip=o("p"),ip.innerHTML=Xj,FM=a(),m(Os.$$.fragment),XM=a(),m(Ks.$$.fragment),RM=a(),dp=o("div"),m(no.$$.fragment),zb=a(),re=o("div"),m(ao.$$.fragment),LM=a(),pp=o("p"),pp.innerHTML=Rj,SM=a(),m(en.$$.fragment),NM=a(),m(tn.$$.fragment),HM=a(),mp=o("div"),m(ro.$$.fragment),Vb=a(),Ie=o("div"),m(oo.$$.fragment),EM=a(),hp=o("p"),hp.innerHTML=Lj,qM=a(),m(sn.$$.fragment),QM=a(),gp=o("div"),m(lo.$$.fragment),Gb=a(),oe=o("div"),m(co.$$.fragment),DM=a(),up=o("p"),up.innerHTML=Sj,YM=a(),fp=o("p"),fp.innerHTML=Nj,PM=a(),m(nn.$$.fragment),AM=a(),bp=o("div"),m(io.$$.fragment),Fb=a(),le=o("div"),m(po.$$.fragment),OM=a(),_p=o("p"),_p.innerHTML=Hj,KM=a(),m(an.$$.fragment),ev=a(),m(rn.$$.fragment),tv=a(),yp=o("div"),m(mo.$$.fragment),Xb=a(),ze=o("div"),m(ho.$$.fragment),sv=a(),Tp=o("p"),Tp.innerHTML=Ej,nv=a(),m(on.$$.fragment),av=a(),Mp=o("div"),m(go.$$.fragment),Rb=a(),Ve=o("div"),m(uo.$$.fragment),rv=a(),vp=o("p"),vp.innerHTML=qj,ov=a(),m(ln.$$.fragment),lv=a(),wp=o("div"),m(fo.$$.fragment),Lb=a(),G=o("div"),m(bo.$$.fragment),cv=a(),kp=o("p"),kp.textContent=Qj,iv=a(),$p=o("p"),$p.textContent=Dj,dv=a(),jp=o("ul"),jp.innerHTML=Yj,pv=a(),xp=o("p"),xp.innerHTML=Pj,mv=a(),m(cn.$$.fragment),hv=a(),Jp=o("div"),m(_o.$$.fragment),Sb=a(),ce=o("div"),m(yo.$$.fragment),gv=a(),Up=o("p"),Up.innerHTML=Aj,uv=a(),m(dn.$$.fragment),fv=a(),m(pn.$$.fragment),bv=a(),Zp=o("div"),m(To.$$.fragment),Nb=a(),Ge=o("div"),m(Mo.$$.fragment),_v=a(),Cp=o("p"),Cp.innerHTML=Oj,yv=a(),m(mn.$$.fragment),Tv=a(),Wp=o("div"),m(vo.$$.fragment),Hb=a(),Fe=o("div"),m(wo.$$.fragment),Mv=a(),Bp=o("p"),Bp.innerHTML=Kj,vv=a(),m(hn.$$.fragment),wv=a(),Ip=o("div"),m(ko.$$.fragment),Eb=a(),ie=o("div"),m($o.$$.fragment),kv=a(),zp=o("p"),zp.innerHTML=e0,$v=a(),Vp=o("p"),Vp.innerHTML=t0,jv=a(),m(gn.$$.fragment),xv=a(),Gp=o("div"),m(jo.$$.fragment),qb=a(),de=o("div"),m(xo.$$.fragment),Jv=a(),Fp=o("p"),Fp.innerHTML=s0,Uv=a(),Xp=o("p"),Xp.innerHTML=n0,Zv=a(),m(un.$$.fragment),Cv=a(),Rp=o("div"),m(Jo.$$.fragment),Qb=a(),pe=o("div"),m(Uo.$$.fragment),Wv=a(),Lp=o("p"),Lp.innerHTML=a0,Bv=a(),Sp=o("p"),Sp.innerHTML=r0,Iv=a(),m(fn.$$.fragment),zv=a(),Np=o("div"),m(Zo.$$.fragment),Db=a(),E=o("div"),m(Co.$$.fragment),Vv=a(),Hp=o("p"),Hp.innerHTML=o0,Gv=a(),Ep=o("p"),Ep.innerHTML=l0,Fv=a(),qp=o("p"),qp.innerHTML=c0,Xv=a(),m(bn.$$.fragment),Rv=a(),Qp=o("div"),m(Wo.$$.fragment),Yb=a(),m(Bo.$$.fragment),Pb=a(),rt=o("div"),m(Io.$$.fragment),Lv=a(),Dp=o("p"),Dp.innerHTML=i0,Sv=a(),Yp=o("div"),m(zo.$$.fragment),Ab=a(),ot=o("div"),m(Vo.$$.fragment),Nv=a(),Pp=o("p"),Pp.innerHTML=d0,Hv=a(),Ap=o("div"),m(Go.$$.fragment),Ob=a(),lt=o("div"),m(Fo.$$.fragment),Ev=a(),Op=o("p"),Op.innerHTML=p0,qv=a(),Kp=o("div"),m(Xo.$$.fragment),Kb=a(),ct=o("div"),m(Ro.$$.fragment),Qv=a(),em=o("p"),em.textContent=m0,Dv=a(),_n=o("div"),m(Lo.$$.fragment),Yv=a(),tm=o("p"),tm.textContent=h0,e_=a(),it=o("div"),m(So.$$.fragment),Pv=a(),sm=o("p"),sm.innerHTML=g0,Av=a(),nm=o("div"),m(No.$$.fragment),t_=a(),dt=o("div"),m(Ho.$$.fragment),Ov=a(),am=o("p"),am.textContent=u0,Kv=a(),yn=o("div"),m(Eo.$$.fragment),ew=a(),rm=o("p"),rm.textContent=f0,s_=a(),pt=o("div"),m(qo.$$.fragment),tw=a(),om=o("p"),om.innerHTML=b0,sw=a(),lm=o("div"),m(Qo.$$.fragment),n_=a(),mt=o("div"),m(Do.$$.fragment),nw=a(),cm=o("p"),cm.innerHTML=_0,aw=a(),im=o("div"),m(Yo.$$.fragment),a_=a(),ht=o("div"),m(Po.$$.fragment),rw=a(),dm=o("p"),dm.innerHTML=y0,ow=a(),pm=o("div"),m(Ao.$$.fragment),r_=a(),gt=o("div"),m(Oo.$$.fragment),lw=a(),mm=o("p"),mm.innerHTML=T0,cw=a(),hm=o("div"),m(Ko.$$.fragment),o_=a(),ut=o("div"),m(el.$$.fragment),iw=a(),gm=o("p"),gm.innerHTML=M0,dw=a(),um=o("div"),m(tl.$$.fragment),l_=a(),ft=o("div"),m(sl.$$.fragment),pw=a(),fm=o("p"),fm.innerHTML=v0,mw=a(),bm=o("div"),m(nl.$$.fragment),c_=a(),bt=o("div"),m(al.$$.fragment),hw=a(),_m=o("p"),_m.innerHTML=w0,gw=a(),ym=o("div"),m(rl.$$.fragment),i_=a(),_t=o("div"),m(ol.$$.fragment),uw=a(),Tm=o("p"),Tm.innerHTML=k0,fw=a(),Mm=o("div"),m(ll.$$.fragment),d_=a(),yt=o("div"),m(cl.$$.fragment),bw=a(),vm=o("p"),vm.innerHTML=$0,_w=a(),wm=o("div"),m(il.$$.fragment),p_=a(),m(dl.$$.fragment),m_=a(),Tt=o("div"),m(pl.$$.fragment),yw=a(),km=o("p"),km.innerHTML=j0,Tw=a(),$m=o("div"),m(ml.$$.fragment),h_=a(),Mt=o("div"),m(hl.$$.fragment),Mw=a(),jm=o("p"),jm.innerHTML=x0,vw=a(),xm=o("div"),m(gl.$$.fragment),g_=a(),vt=o("div"),m(ul.$$.fragment),ww=a(),Jm=o("p"),Jm.innerHTML=J0,kw=a(),Um=o("div"),m(fl.$$.fragment),u_=a(),wt=o("div"),m(bl.$$.fragment),$w=a(),Zm=o("p"),Zm.textContent=U0,jw=a(),Tn=o("div"),m(_l.$$.fragment),xw=a(),Cm=o("p"),Cm.textContent=Z0,f_=a(),kt=o("div"),m(yl.$$.fragment),Jw=a(),Wm=o("p"),Wm.innerHTML=C0,Uw=a(),Bm=o("div"),m(Tl.$$.fragment),b_=a(),$t=o("div"),m(Ml.$$.fragment),Zw=a(),Im=o("p"),Im.textContent=W0,Cw=a(),Mn=o("div"),m(vl.$$.fragment),Ww=a(),zm=o("p"),zm.textContent=B0,__=a(),jt=o("div"),m(wl.$$.fragment),Bw=a(),Vm=o("p"),Vm.innerHTML=I0,Iw=a(),Gm=o("div"),m(kl.$$.fragment),y_=a(),xt=o("div"),m($l.$$.fragment),zw=a(),Fm=o("p"),Fm.innerHTML=z0,Vw=a(),Xm=o("div"),m(jl.$$.fragment),T_=a(),Jt=o("div"),m(xl.$$.fragment),Gw=a(),Rm=o("p"),Rm.innerHTML=V0,Fw=a(),Lm=o("div"),m(Jl.$$.fragment),M_=a(),Ut=o("div"),m(Ul.$$.fragment),Xw=a(),Sm=o("p"),Sm.innerHTML=G0,Rw=a(),Nm=o("div"),m(Zl.$$.fragment),v_=a(),Zt=o("div"),m(Cl.$$.fragment),Lw=a(),Hm=o("p"),Hm.innerHTML=F0,Sw=a(),Em=o("div"),m(Wl.$$.fragment),w_=a(),Ct=o("div"),m(Bl.$$.fragment),Nw=a(),qm=o("p"),qm.innerHTML=X0,Hw=a(),Qm=o("div"),m(Il.$$.fragment),k_=a(),Wt=o("div"),m(zl.$$.fragment),Ew=a(),Dm=o("p"),Dm.innerHTML=R0,qw=a(),Ym=o("div"),m(Vl.$$.fragment),$_=a(),m(Gl.$$.fragment),j_=a(),Fl=o("p"),Fl.innerHTML=L0,x_=a(),Xe=o("div"),m(Xl.$$.fragment),Qw=a(),Pm=o("p"),Pm.textContent=S0,Dw=a(),Am=o("p"),Am.innerHTML=N0,Yw=a(),Om=o("div"),m(Rl.$$.fragment),J_=a(),js=o("div"),m(Ll.$$.fragment),Pw=a(),Km=o("div"),m(Sl.$$.fragment),U_=a(),Bt=o("div"),m(Nl.$$.fragment),Aw=a(),eh=o("p"),eh.innerHTML=H0,Ow=a(),th=o("div"),m(Hl.$$.fragment),Z_=a(),It=o("div"),m(El.$$.fragment),Kw=a(),sh=o("p"),sh.innerHTML=E0,e2=a(),nh=o("div"),m(ql.$$.fragment),C_=a(),J=o("div"),m(Ql.$$.fragment),t2=a(),ah=o("p"),ah.textContent=q0,s2=a(),rh=o("p"),rh.textContent=Q0,n2=a(),oh=o("ul"),oh.innerHTML=D0,a2=a(),lh=o("p"),lh.textContent=Y0,r2=a(),ch=o("ul"),ch.innerHTML=P0,o2=a(),ih=o("p"),ih.textContent=A0,l2=a(),dh=o("p"),dh.textContent=O0,c2=a(),ph=o("p"),ph.textContent=K0,i2=a(),mh=o("ul"),mh.innerHTML=ex,d2=a(),hh=o("p"),hh.textContent=tx,p2=a(),gh=o("p"),gh.textContent=sx,m2=a(),uh=o("p"),uh.textContent=nx,h2=a(),fh=o("p"),fh.textContent=ax,g2=a(),bh=o("ul"),bh.innerHTML=rx,u2=a(),_h=o("p"),_h.textContent=ox,f2=a(),yh=o("p"),yh.textContent=lx,b2=a(),Th=o("ul"),Th.innerHTML=cx,_2=a(),Mh=o("p"),Mh.textContent=ix,y2=a(),vh=o("p"),vh.textContent=dx,T2=a(),m(vn.$$.fragment),M2=a(),wh=o("div"),m(Dl.$$.fragment),W_=a(),zt=o("div"),m(Yl.$$.fragment),v2=a(),kh=o("p"),kh.innerHTML=px,w2=a(),$h=o("div"),m(Pl.$$.fragment),B_=a(),m(Al.$$.fragment),I_=a(),Ol=o("p"),Ol.innerHTML=mx,z_=a(),W=o("div"),m(Kl.$$.fragment),k2=a(),jh=o("p"),jh.textContent=hx,$2=a(),xh=o("p"),xh.textContent=gx,j2=a(),m(wn.$$.fragment),x2=a(),Jh=o("p"),Jh.textContent=ux,J2=a(),kn=o("div"),m(ec.$$.fragment),U2=a(),Uh=o("p"),Uh.textContent=fx,Z2=a(),$n=o("div"),m(tc.$$.fragment),C2=a(),Zh=o("p"),Zh.textContent=bx,W2=a(),jn=o("div"),m(sc.$$.fragment),B2=a(),Ch=o("p"),Ch.textContent=_x,I2=a(),xn=o("div"),m(nc.$$.fragment),z2=a(),Wh=o("p"),Wh.innerHTML=yx,V2=a(),Jn=o("div"),m(ac.$$.fragment),G2=a(),Bh=o("p"),Bh.textContent=Tx,F2=a(),Un=o("div"),m(rc.$$.fragment),X2=a(),Ih=o("p"),Ih.textContent=Mx,R2=a(),Kt=o("div"),m(oc.$$.fragment),L2=a(),zh=o("p"),zh.innerHTML=vx,S2=a(),Vh=o("p"),Vh.textContent=wx,V_=a(),xs=o("div"),m(lc.$$.fragment),N2=a(),Gh=o("p"),Gh.innerHTML=kx,G_=a(),Js=o("div"),m(cc.$$.fragment),H2=a(),Fh=o("p"),Fh.innerHTML=$x,F_=a(),Re=o("div"),m(ic.$$.fragment),E2=a(),Xh=o("p"),Xh.textContent=jx,q2=a(),K=o("div"),m(dc.$$.fragment),Q2=a(),Rh=o("p"),Rh.textContent=xx,D2=a(),Lh=o("p"),Lh.innerHTML=Jx,Y2=a(),Sh=o("p"),Sh.innerHTML=Ux,P2=a(),Nh=o("p"),Nh.innerHTML=Zx,A2=a(),Hh=o("p"),Hh.textContent=Cx,O2=a(),Zn=o("div"),m(pc.$$.fragment),K2=a(),Eh=o("p"),Eh.textContent=Wx,X_=a(),m(mc.$$.fragment),R_=a(),Le=o("div"),m(hc.$$.fragment),e1=a(),qh=o("p"),qh.innerHTML=Bx,t1=a(),Qh=o("div"),m(gc.$$.fragment),s1=a(),Dh=o("div"),m(uc.$$.fragment),L_=a(),q=o("div"),m(fc.$$.fragment),n1=a(),Yh=o("p"),Yh.innerHTML=Ix,a1=a(),Ph=o("p"),Ph.innerHTML=zx,r1=a(),Ah=o("p"),Ah.innerHTML=Vx,o1=a(),Oh=o("div"),m(bc.$$.fragment),l1=a(),Kh=o("div"),m(_c.$$.fragment),S_=a(),Se=o("div"),m(yc.$$.fragment),c1=a(),eg=o("p"),eg.innerHTML=Gx,i1=a(),tg=o("div"),m(Tc.$$.fragment),d1=a(),sg=o("div"),m(Mc.$$.fragment),N_=a(),m(vc.$$.fragment),H_=a(),F=o("div"),m(wc.$$.fragment),p1=a(),ng=o("p"),ng.textContent=Fx,m1=a(),m(Cn.$$.fragment),h1=a(),m(Wn.$$.fragment),g1=a(),Bn=o("div"),m(kc.$$.fragment),u1=a(),ag=o("p"),ag.textContent=Xx,f1=a(),In=o("div"),m($c.$$.fragment),b1=a(),rg=o("p"),rg.textContent=Rx,_1=a(),zn=o("div"),m(jc.$$.fragment),y1=a(),og=o("p"),og.textContent=Lx,E_=a(),me=o("div"),m(xc.$$.fragment),T1=a(),lg=o("p"),lg.textContent=Sx,M1=a(),m(Vn.$$.fragment),v1=a(),m(Gn.$$.fragment),w1=a(),Fn=o("div"),m(Jc.$$.fragment),k1=a(),cg=o("p"),cg.textContent=Nx,q_=a(),m(Uc.$$.fragment),Q_=a(),Vt=o("div"),m(Zc.$$.fragment),$1=a(),ig=o("p"),ig.textContent=Hx,j1=a(),Xn=o("div"),m(Cc.$$.fragment),x1=a(),dg=o("p"),dg.innerHTML=Ex,D_=a(),Gt=o("div"),m(Wc.$$.fragment),J1=a(),pg=o("p"),pg.textContent=qx,U1=a(),Rn=o("div"),m(Bc.$$.fragment),Z1=a(),mg=o("p"),mg.innerHTML=Qx,Y_=a(),Ft=o("div"),m(Ic.$$.fragment),C1=a(),hg=o("p"),hg.textContent=Dx,W1=a(),Ln=o("div"),m(zc.$$.fragment),B1=a(),gg=o("p"),gg.textContent=Yx,P_=a(),I=o("div"),m(Vc.$$.fragment),I1=a(),ug=o("p"),ug.textContent=Px,z1=a(),fg=o("p"),fg.innerHTML=Ax,V1=a(),m(Sn.$$.fragment),G1=a(),Nn=o("div"),m(Gc.$$.fragment),F1=a(),bg=o("p"),bg.innerHTML=Ox,X1=a(),Hn=o("div"),m(Fc.$$.fragment),R1=a(),_g=o("p"),_g.textContent=Kx,L1=a(),En=o("div"),m(Xc.$$.fragment),S1=a(),yg=o("p"),yg.textContent=eJ,N1=a(),qn=o("div"),m(Rc.$$.fragment),H1=a(),Tg=o("p"),Tg.innerHTML=tJ,E1=a(),Qn=o("div"),m(Lc.$$.fragment),q1=a(),Mg=o("p"),Mg.innerHTML=sJ,A_=a(),Q=o("div"),m(Sc.$$.fragment),Q1=a(),vg=o("p"),vg.innerHTML=nJ,D1=a(),wg=o("p"),wg.innerHTML=aJ,Y1=a(),kg=o("p"),kg.innerHTML=rJ,P1=a(),$g=o("div"),m(Nc.$$.fragment),A1=a(),Dn=o("div"),m(Hc.$$.fragment),O1=a(),jg=o("p"),jg.textContent=oJ,O_=a(),Xt=o("div"),m(Ec.$$.fragment),K1=a(),xg=o("p"),xg.innerHTML=lJ,ek=a(),m(Yn.$$.fragment),K_=a(),Rt=o("div"),m(qc.$$.fragment),tk=a(),Jg=o("p"),Jg.innerHTML=cJ,sk=a(),m(Pn.$$.fragment),ey=a(),X=o("div"),m(Qc.$$.fragment),nk=a(),Ug=o("p"),Ug.innerHTML=iJ,ak=a(),Zg=o("p"),Zg.innerHTML=dJ,rk=a(),m(An.$$.fragment),ok=a(),On=o("div"),m(Dc.$$.fragment),lk=a(),Cg=o("p"),Cg.innerHTML=pJ,ck=a(),Kn=o("div"),m(Yc.$$.fragment),ik=a(),Wg=o("p"),Wg.textContent=mJ,dk=a(),ea=o("div"),m(Pc.$$.fragment),pk=a(),Bg=o("p"),Bg.textContent=hJ,ty=a(),D=o("div"),m(Ac.$$.fragment),mk=a(),Ig=o("p"),Ig.textContent=gJ,hk=a(),zg=o("p"),zg.textContent=uJ,gk=a(),ta=o("div"),m(Oc.$$.fragment),uk=a(),Vg=o("p"),Vg.innerHTML=fJ,fk=a(),sa=o("div"),m(Kc.$$.fragment),bk=a(),Gg=o("p"),Gg.textContent=bJ,_k=a(),na=o("div"),m(ei.$$.fragment),yk=a(),Fg=o("p"),Fg.textContent=_J,sy=a(),Y=o("div"),m(ti.$$.fragment),Tk=a(),Xg=o("p"),Xg.innerHTML=yJ,Mk=a(),m(aa.$$.fragment),vk=a(),ra=o("div"),m(si.$$.fragment),wk=a(),Rg=o("p"),Rg.innerHTML=TJ,kk=a(),oa=o("div"),m(ni.$$.fragment),$k=a(),Lg=o("p"),Lg.textContent=MJ,jk=a(),la=o("div"),m(ai.$$.fragment),xk=a(),Sg=o("p"),Sg.textContent=vJ,ny=a(),P=o("div"),m(ri.$$.fragment),Jk=a(),Ng=o("p"),Ng.innerHTML=wJ,Uk=a(),m(ca.$$.fragment),Zk=a(),ia=o("div"),m(oi.$$.fragment),Ck=a(),Hg=o("p"),Hg.innerHTML=kJ,Wk=a(),da=o("div"),m(li.$$.fragment),Bk=a(),Eg=o("p"),Eg.textContent=$J,Ik=a(),pa=o("div"),m(ci.$$.fragment),zk=a(),qg=o("p"),qg.textContent=jJ,ay=a(),A=o("div"),m(ii.$$.fragment),Vk=a(),Qg=o("p"),Qg.innerHTML=xJ,Gk=a(),m(ma.$$.fragment),Fk=a(),Dg=o("div"),m(di.$$.fragment),Xk=a(),Yg=o("div"),m(pi.$$.fragment),Rk=a(),ha=o("div"),m(mi.$$.fragment),Lk=a(),Pg=o("p"),Pg.textContent=JJ,ry=a(),z=o("div"),m(hi.$$.fragment),Sk=a(),Ag=o("p"),Ag.innerHTML=UJ,Nk=a(),Og=o("p"),Og.innerHTML=ZJ,Hk=a(),Kg=o("p"),Kg.textContent=CJ,Ek=a(),eu=o("p"),eu.innerHTML=WJ,qk=a(),m(ga.$$.fragment),Qk=a(),tu=o("div"),m(gi.$$.fragment),Dk=a(),su=o("div"),m(ui.$$.fragment),oy=a(),V=o("div"),m(fi.$$.fragment),Yk=a(),nu=o("p"),nu.textContent=BJ,Pk=a(),m(ua.$$.fragment),Ak=a(),fa=o("div"),m(bi.$$.fragment),Ok=a(),au=o("p"),au.textContent=IJ,Kk=a(),ba=o("div"),m(_i.$$.fragment),e$=a(),ru=o("p"),ru.innerHTML=zJ,t$=a(),_a=o("div"),m(yi.$$.fragment),s$=a(),ou=o("p"),ou.innerHTML=VJ,n$=a(),lu=o("div"),m(Ti.$$.fragment),a$=a(),ya=o("div"),m(Mi.$$.fragment),r$=a(),cu=o("p"),cu.textContent=GJ,ly=a(),O=o("div"),m(vi.$$.fragment),o$=a(),iu=o("p"),iu.textContent=FJ,l$=a(),m(Ta.$$.fragment),c$=a(),du=o("div"),m(wi.$$.fragment),i$=a(),pu=o("div"),m(ki.$$.fragment),d$=a(),mu=o("div"),m($i.$$.fragment),cy=a(),m(ji.$$.fragment),iy=a(),he=o("div"),m(xi.$$.fragment),p$=a(),hu=o("p"),hu.innerHTML=XJ,m$=a(),gu=o("p"),gu.textContent=RJ,h$=a(),uu=o("ul"),uu.innerHTML=LJ,g$=a(),Ma=o("div"),m(Ji.$$.fragment),u$=a(),fu=o("p"),fu.textContent=SJ,dy=a(),ge=o("div"),m(Ui.$$.fragment),f$=a(),bu=o("p"),bu.innerHTML=NJ,b$=a(),_u=o("p"),_u.innerHTML=HJ,_$=a(),m(va.$$.fragment),y$=a(),wa=o("div"),m(Zi.$$.fragment),T$=a(),yu=o("p"),yu.textContent=EJ,py=a(),Lt=o("div"),m(Ci.$$.fragment),M$=a(),Tu=o("p"),Tu.innerHTML=qJ,v$=a(),Mu=o("p"),Mu.innerHTML=QJ,my=a(),R=o("div"),m(Wi.$$.fragment),w$=a(),vu=o("p"),vu.textContent=DJ,k$=a(),wu=o("p"),wu.innerHTML=YJ,$$=a(),ku=o("p"),ku.textContent=PJ,j$=a(),$u=o("p"),$u.innerHTML=AJ,x$=a(),ju=o("p"),ju.innerHTML=OJ,J$=a(),ka=o("div"),m(Bi.$$.fragment),U$=a(),xu=o("p"),xu.textContent=KJ,hy=a(),St=o("div"),m(Ii.$$.fragment),Z$=a(),Ju=o("p"),Ju.innerHTML=eU,C$=a(),m($a.$$.fragment),gy=a(),ue=o("div"),m(zi.$$.fragment),W$=a(),Uu=o("p"),Uu.textContent=tU,B$=a(),Zu=o("p"),Zu.textContent=sU,I$=a(),m(ja.$$.fragment),z$=a(),Cu=o("div"),m(Vi.$$.fragment),uy=a(),m(Gi.$$.fragment),fy=a(),_f=o("p"),this.h()},l(e){const i=uZ("svelte-u9bgzb",document.head);c=l(i,"META",{name:!0,content:!0}),i.forEach(n),$=r(e),y=l(e,"P",{}),T(y).forEach(n),d=r(e),h(w.$$.fragment,e),s=r(e),k=l(e,"P",{"data-svelte-h":!0}),_(k)!=="svelte-1bcp7t6"&&(k.innerHTML=V$),zf=r(e),h(Ga.$$.fragment,e),Vf=r(e),Fa=l(e,"P",{"data-svelte-h":!0}),_(Fa)!=="svelte-18ep3y6"&&(Fa.innerHTML=G$),Gf=r(e),Xa=l(e,"P",{"data-svelte-h":!0}),_(Xa)!=="svelte-wwwyth"&&(Xa.textContent=F$),Ff=r(e),h(Ra.$$.fragment,e),Xf=r(e),La=l(e,"P",{"data-svelte-h":!0}),_(La)!=="svelte-1xs4157"&&(La.innerHTML=X$),Rf=r(e),Sa=l(e,"UL",{"data-svelte-h":!0}),_(Sa)!=="svelte-1arpy9m"&&(Sa.innerHTML=R$),Lf=r(e),Na=l(e,"P",{"data-svelte-h":!0}),_(Na)!=="svelte-xh59rv"&&(Na.innerHTML=L$),Sf=r(e),Ha=l(e,"P",{"data-svelte-h":!0}),_(Ha)!=="svelte-rqavqw"&&(Ha.innerHTML=S$),Nf=r(e),Ea=l(e,"P",{"data-svelte-h":!0}),_(Ea)!=="svelte-qr02he"&&(Ea.innerHTML=N$),Hf=r(e),h(qa.$$.fragment,e),Ef=r(e),Qa=l(e,"P",{"data-svelte-h":!0}),_(Qa)!=="svelte-114v74y"&&(Qa.innerHTML=H$),qf=r(e),Da=l(e,"P",{"data-svelte-h":!0}),_(Da)!=="svelte-13knclg"&&(Da.innerHTML=E$),Qf=r(e),Ya=l(e,"P",{"data-svelte-h":!0}),_(Ya)!=="svelte-gz8gow"&&(Ya.textContent=q$),Df=r(e),h(Pa.$$.fragment,e),Yf=r(e),ms=l(e,"DIV",{class:!0});var Fi=T(ms);h(Aa.$$.fragment,Fi),pT=r(Fi),td=l(Fi,"P",{"data-svelte-h":!0}),_(td)!=="svelte-k7oes3"&&(td.textContent=Q$),Fi.forEach(n),Pf=r(e),hs=l(e,"DIV",{class:!0});var Xi=T(hs);h(Oa.$$.fragment,Xi),mT=r(Xi),sd=l(Xi,"P",{"data-svelte-h":!0}),_(sd)!=="svelte-111f3sj"&&(sd.textContent=D$),Xi.forEach(n),Af=r(e),gs=l(e,"DIV",{class:!0});var Ri=T(gs);h(Ka.$$.fragment,Ri),hT=r(Ri),nd=l(Ri,"P",{"data-svelte-h":!0}),_(nd)!=="svelte-1j3b9cp"&&(nd.textContent=Y$),Ri.forEach(n),Of=r(e),us=l(e,"DIV",{class:!0});var Li=T(us);h(er.$$.fragment,Li),gT=r(Li),ad=l(Li,"P",{"data-svelte-h":!0}),_(ad)!=="svelte-16r5px1"&&(ad.textContent=P$),Li.forEach(n),Kf=r(e),h(tr.$$.fragment,e),eb=r(e),fs=l(e,"DIV",{class:!0});var Si=T(fs);h(sr.$$.fragment,Si),uT=r(Si),rd=l(Si,"P",{"data-svelte-h":!0}),_(rd)!=="svelte-1bnrp61"&&(rd.textContent=A$),Si.forEach(n),tb=r(e),bs=l(e,"DIV",{class:!0});var Ni=T(bs);h(nr.$$.fragment,Ni),fT=r(Ni),od=l(Ni,"P",{"data-svelte-h":!0}),_(od)!=="svelte-fenhkk"&&(od.textContent=O$),Ni.forEach(n),sb=r(e),_s=l(e,"DIV",{class:!0});var Hi=T(_s);h(ar.$$.fragment,Hi),bT=r(Hi),ld=l(Hi,"P",{"data-svelte-h":!0}),_(ld)!=="svelte-1dqtgq4"&&(ld.textContent=K$),Hi.forEach(n),nb=r(e),ys=l(e,"DIV",{class:!0});var Ei=T(ys);h(rr.$$.fragment,Ei),_T=r(Ei),cd=l(Ei,"P",{"data-svelte-h":!0}),_(cd)!=="svelte-10orfv5"&&(cd.textContent=ej),Ei.forEach(n),ab=r(e),Ts=l(e,"DIV",{class:!0});var qi=T(Ts);h(or.$$.fragment,qi),yT=r(qi),id=l(qi,"P",{"data-svelte-h":!0}),_(id)!=="svelte-jg8udg"&&(id.textContent=tj),qi.forEach(n),rb=r(e),Ms=l(e,"DIV",{class:!0});var Qi=T(Ms);h(lr.$$.fragment,Qi),TT=r(Qi),dd=l(Qi,"P",{"data-svelte-h":!0}),_(dd)!=="svelte-1i40667"&&(dd.textContent=sj),Qi.forEach(n),ob=r(e),vs=l(e,"DIV",{class:!0});var Di=T(vs);h(cr.$$.fragment,Di),MT=r(Di),pd=l(Di,"P",{"data-svelte-h":!0}),_(pd)!=="svelte-n5fi8x"&&(pd.textContent=nj),Di.forEach(n),lb=r(e),ws=l(e,"DIV",{class:!0});var Yi=T(ws);h(ir.$$.fragment,Yi),vT=r(Yi),md=l(Yi,"P",{"data-svelte-h":!0}),_(md)!=="svelte-h5pj3l"&&(md.textContent=aj),Yi.forEach(n),cb=r(e),ks=l(e,"DIV",{class:!0});var Pi=T(ks);h(dr.$$.fragment,Pi),wT=r(Pi),hd=l(Pi,"P",{"data-svelte-h":!0}),_(hd)!=="svelte-b9zq6n"&&(hd.textContent=rj),Pi.forEach(n),ib=r(e),$s=l(e,"DIV",{class:!0});var Ai=T($s);h(pr.$$.fragment,Ai),kT=r(Ai),gd=l(Ai,"P",{"data-svelte-h":!0}),_(gd)!=="svelte-pru3ks"&&(gd.textContent=oj),Ai.forEach(n),db=r(e),h(mr.$$.fragment,e),pb=r(e),et=l(e,"DIV",{class:!0});var Us=T(et);h(hr.$$.fragment,Us),$T=r(Us),ud=l(Us,"P",{"data-svelte-h":!0}),_(ud)!=="svelte-qoov36"&&(ud.textContent=lj),jT=r(Us),Is=l(Us,"DIV",{class:!0});var Oi=T(Is);h(gr.$$.fragment,Oi),xT=r(Oi),fd=l(Oi,"P",{"data-svelte-h":!0}),_(fd)!=="svelte-5ihtpa"&&(fd.textContent=cj),Oi.forEach(n),Us.forEach(n),mb=r(e),tt=l(e,"DIV",{class:!0});var Zs=T(tt);h(ur.$$.fragment,Zs),JT=r(Zs),bd=l(Zs,"P",{"data-svelte-h":!0}),_(bd)!=="svelte-1tz7qrd"&&(bd.textContent=ij),UT=r(Zs),zs=l(Zs,"DIV",{class:!0});var Ki=T(zs);h(fr.$$.fragment,Ki),ZT=r(Ki),_d=l(Ki,"P",{"data-svelte-h":!0}),_(_d)!=="svelte-5ihtpa"&&(_d.textContent=dj),Ki.forEach(n),Zs.forEach(n),hb=r(e),st=l(e,"DIV",{class:!0});var Cs=T(st);h(br.$$.fragment,Cs),CT=r(Cs),yd=l(Cs,"P",{"data-svelte-h":!0}),_(yd)!=="svelte-1tz7qrd"&&(yd.textContent=pj),WT=r(Cs),Vs=l(Cs,"DIV",{class:!0});var ed=T(Vs);h(_r.$$.fragment,ed),BT=r(ed),Td=l(ed,"P",{"data-svelte-h":!0}),_(Td)!=="svelte-5ihtpa"&&(Td.textContent=mj),ed.forEach(n),Cs.forEach(n),gb=r(e),h(yr.$$.fragment,e),ub=r(e),Tr=l(e,"P",{"data-svelte-h":!0}),_(Tr)!=="svelte-1mhr04t"&&(Tr.innerHTML=hj),fb=r(e),h(Mr.$$.fragment,e),bb=r(e),ke=l(e,"DIV",{class:!0});var Nt=T(ke);h(vr.$$.fragment,Nt),IT=r(Nt),Md=l(Nt,"P",{"data-svelte-h":!0}),_(Md)!=="svelte-r0ppk6"&&(Md.innerHTML=gj),zT=r(Nt),h(Gs.$$.fragment,Nt),VT=r(Nt),vd=l(Nt,"DIV",{class:!0});var yf=T(vd);h(wr.$$.fragment,yf),yf.forEach(n),Nt.forEach(n),_b=r(e),S=l(e,"DIV",{class:!0});var fe=T(S);h(kr.$$.fragment,fe),GT=r(fe),wd=l(fe,"P",{"data-svelte-h":!0}),_(wd)!=="svelte-3t2r7l"&&(wd.innerHTML=uj),FT=r(fe),kd=l(fe,"P",{"data-svelte-h":!0}),_(kd)!=="svelte-lu7kru"&&(kd.innerHTML=fj),XT=r(fe),h(Fs.$$.fragment,fe),RT=r(fe),h(Xs.$$.fragment,fe),LT=r(fe),$d=l(fe,"DIV",{class:!0});var Tf=T($d);h($r.$$.fragment,Tf),Tf.forEach(n),fe.forEach(n),yb=r(e),se=l(e,"DIV",{class:!0});var Ne=T(se);h(jr.$$.fragment,Ne),ST=r(Ne),jd=l(Ne,"P",{"data-svelte-h":!0}),_(jd)!=="svelte-jnv1x5"&&(jd.innerHTML=bj),NT=r(Ne),xd=l(Ne,"P",{"data-svelte-h":!0}),_(xd)!=="svelte-mpy00q"&&(xd.textContent=_j),HT=r(Ne),h(Rs.$$.fragment,Ne),ET=r(Ne),Jd=l(Ne,"DIV",{class:!0});var Mf=T(Jd);h(xr.$$.fragment,Mf),Mf.forEach(n),Ne.forEach(n),Tb=r(e),ne=l(e,"DIV",{class:!0});var He=T(ne);h(Jr.$$.fragment,He),qT=r(He),Ud=l(He,"P",{"data-svelte-h":!0}),_(Ud)!=="svelte-hixi53"&&(Ud.innerHTML=yj),QT=r(He),Zd=l(He,"P",{"data-svelte-h":!0}),_(Zd)!=="svelte-3qpgm7"&&(Zd.textContent=Tj),DT=r(He),h(Ls.$$.fragment,He),YT=r(He),Cd=l(He,"DIV",{class:!0});var vf=T(Cd);h(Ur.$$.fragment,vf),vf.forEach(n),He.forEach(n),Mb=r(e),$e=l(e,"DIV",{class:!0});var Ht=T($e);h(Zr.$$.fragment,Ht),PT=r(Ht),Wd=l(Ht,"P",{"data-svelte-h":!0}),_(Wd)!=="svelte-y33f0y"&&(Wd.innerHTML=Mj),AT=r(Ht),h(Ss.$$.fragment,Ht),OT=r(Ht),Bd=l(Ht,"DIV",{class:!0});var wf=T(Bd);h(Cr.$$.fragment,wf),wf.forEach(n),Ht.forEach(n),vb=r(e),je=l(e,"DIV",{class:!0});var Et=T(je);h(Wr.$$.fragment,Et),KT=r(Et),Id=l(Et,"P",{"data-svelte-h":!0}),_(Id)!=="svelte-erurzh"&&(Id.innerHTML=vj),eM=r(Et),h(Ns.$$.fragment,Et),tM=r(Et),zd=l(Et,"DIV",{class:!0});var kf=T(zd);h(Br.$$.fragment,kf),kf.forEach(n),Et.forEach(n),wb=r(e),xe=l(e,"DIV",{class:!0});var qt=T(xe);h(Ir.$$.fragment,qt),sM=r(qt),Vd=l(qt,"P",{"data-svelte-h":!0}),_(Vd)!=="svelte-zac23"&&(Vd.innerHTML=wj),nM=r(qt),h(Hs.$$.fragment,qt),aM=r(qt),Gd=l(qt,"DIV",{class:!0});var $f=T(Gd);h(zr.$$.fragment,$f),$f.forEach(n),qt.forEach(n),kb=r(e),Je=l(e,"DIV",{class:!0});var Qt=T(Je);h(Vr.$$.fragment,Qt),rM=r(Qt),Fd=l(Qt,"P",{"data-svelte-h":!0}),_(Fd)!=="svelte-1xemmef"&&(Fd.innerHTML=kj),oM=r(Qt),h(Es.$$.fragment,Qt),lM=r(Qt),Xd=l(Qt,"DIV",{class:!0});var jf=T(Xd);h(Gr.$$.fragment,jf),jf.forEach(n),Qt.forEach(n),$b=r(e),Ue=l(e,"DIV",{class:!0});var Dt=T(Ue);h(Fr.$$.fragment,Dt),cM=r(Dt),Rd=l(Dt,"P",{"data-svelte-h":!0}),_(Rd)!=="svelte-1ideb0b"&&(Rd.innerHTML=$j),iM=r(Dt),h(qs.$$.fragment,Dt),dM=r(Dt),Ld=l(Dt,"DIV",{class:!0});var xf=T(Ld);h(Xr.$$.fragment,xf),xf.forEach(n),Dt.forEach(n),jb=r(e),N=l(e,"DIV",{class:!0});var be=T(N);h(Rr.$$.fragment,be),pM=r(be),Sd=l(be,"P",{"data-svelte-h":!0}),_(Sd)!=="svelte-gr8gnh"&&(Sd.innerHTML=jj),mM=r(be),Nd=l(be,"P",{"data-svelte-h":!0}),_(Nd)!=="svelte-1b0c3nk"&&(Nd.innerHTML=xj),hM=r(be),Hd=l(be,"P",{"data-svelte-h":!0}),_(Hd)!=="svelte-2fpu88"&&(Hd.innerHTML=Jj),gM=r(be),h(Qs.$$.fragment,be),uM=r(be),Ed=l(be,"DIV",{class:!0});var Jf=T(Ed);h(Lr.$$.fragment,Jf),Jf.forEach(n),be.forEach(n),xb=r(e),Ze=l(e,"DIV",{class:!0});var Yt=T(Ze);h(Sr.$$.fragment,Yt),fM=r(Yt),qd=l(Yt,"P",{"data-svelte-h":!0}),_(qd)!=="svelte-19509do"&&(qd.innerHTML=Uj),bM=r(Yt),Qd=l(Yt,"P",{"data-svelte-h":!0}),_(Qd)!=="svelte-1v3r596"&&(Qd.innerHTML=Zj),_M=r(Yt),Dd=l(Yt,"DIV",{class:!0});var Uf=T(Dd);h(Nr.$$.fragment,Uf),Uf.forEach(n),Yt.forEach(n),Jb=r(e),Ce=l(e,"DIV",{class:!0});var Pt=T(Ce);h(Hr.$$.fragment,Pt),yM=r(Pt),Yd=l(Pt,"P",{"data-svelte-h":!0}),_(Yd)!=="svelte-1e7zhts"&&(Yd.innerHTML=Cj),TM=r(Pt),h(Ds.$$.fragment,Pt),MM=r(Pt),Pd=l(Pt,"DIV",{class:!0});var Zf=T(Pd);h(Er.$$.fragment,Zf),Zf.forEach(n),Pt.forEach(n),Ub=r(e),nt=l(e,"DIV",{class:!0});var Ws=T(nt);h(qr.$$.fragment,Ws),vM=r(Ws),Ad=l(Ws,"P",{"data-svelte-h":!0}),_(Ad)!=="svelte-y1kta5"&&(Ad.textContent=Wj),wM=r(Ws),Od=l(Ws,"DIV",{class:!0});var Cf=T(Od);h(Qr.$$.fragment,Cf),Cf.forEach(n),Ws.forEach(n),Zb=r(e),at=l(e,"DIV",{class:!0});var Bs=T(at);h(Dr.$$.fragment,Bs),kM=r(Bs),Kd=l(Bs,"P",{"data-svelte-h":!0}),_(Kd)!=="svelte-1atbpnp"&&(Kd.innerHTML=Bj),$M=r(Bs),ep=l(Bs,"DIV",{class:!0});var Wf=T(ep);h(Yr.$$.fragment,Wf),Wf.forEach(n),Bs.forEach(n),Cb=r(e),We=l(e,"DIV",{class:!0});var At=T(We);h(Pr.$$.fragment,At),jM=r(At),tp=l(At,"P",{"data-svelte-h":!0}),_(tp)!=="svelte-1qtsa3r"&&(tp.innerHTML=Ij),xM=r(At),h(Ys.$$.fragment,At),JM=r(At),sp=l(At,"DIV",{class:!0});var Bf=T(sp);h(Ar.$$.fragment,Bf),Bf.forEach(n),At.forEach(n),Wb=r(e),Be=l(e,"DIV",{class:!0});var Ot=T(Be);h(Or.$$.fragment,Ot),UM=r(Ot),np=l(Ot,"P",{"data-svelte-h":!0}),_(np)!=="svelte-1xxt5g1"&&(np.innerHTML=zj),ZM=r(Ot),h(Ps.$$.fragment,Ot),CM=r(Ot),ap=l(Ot,"DIV",{class:!0});var If=T(ap);h(Kr.$$.fragment,If),If.forEach(n),Ot.forEach(n),Bb=r(e),H=l(e,"DIV",{class:!0});var _e=T(H);h(eo.$$.fragment,_e),WM=r(_e),rp=l(_e,"P",{"data-svelte-h":!0}),_(rp)!=="svelte-1m9qk3k"&&(rp.innerHTML=Vj),BM=r(_e),op=l(_e,"P",{"data-svelte-h":!0}),_(op)!=="svelte-19dc1me"&&(op.innerHTML=Gj),IM=r(_e),lp=l(_e,"P",{"data-svelte-h":!0}),_(lp)!=="svelte-1fvwhfn"&&(lp.innerHTML=Fj),zM=r(_e),h(As.$$.fragment,_e),VM=r(_e),cp=l(_e,"DIV",{class:!0});var nU=T(cp);h(to.$$.fragment,nU),nU.forEach(n),_e.forEach(n),Ib=r(e),ae=l(e,"DIV",{class:!0});var es=T(ae);h(so.$$.fragment,es),GM=r(es),ip=l(es,"P",{"data-svelte-h":!0}),_(ip)!=="svelte-1j8exuv"&&(ip.innerHTML=Xj),FM=r(es),h(Os.$$.fragment,es),XM=r(es),h(Ks.$$.fragment,es),RM=r(es),dp=l(es,"DIV",{class:!0});var aU=T(dp);h(no.$$.fragment,aU),aU.forEach(n),es.forEach(n),zb=r(e),re=l(e,"DIV",{class:!0});var ts=T(re);h(ao.$$.fragment,ts),LM=r(ts),pp=l(ts,"P",{"data-svelte-h":!0}),_(pp)!=="svelte-1oiukny"&&(pp.innerHTML=Rj),SM=r(ts),h(en.$$.fragment,ts),NM=r(ts),h(tn.$$.fragment,ts),HM=r(ts),mp=l(ts,"DIV",{class:!0});var rU=T(mp);h(ro.$$.fragment,rU),rU.forEach(n),ts.forEach(n),Vb=r(e),Ie=l(e,"DIV",{class:!0});var xa=T(Ie);h(oo.$$.fragment,xa),EM=r(xa),hp=l(xa,"P",{"data-svelte-h":!0}),_(hp)!=="svelte-8lc5bj"&&(hp.innerHTML=Lj),qM=r(xa),h(sn.$$.fragment,xa),QM=r(xa),gp=l(xa,"DIV",{class:!0});var oU=T(gp);h(lo.$$.fragment,oU),oU.forEach(n),xa.forEach(n),Gb=r(e),oe=l(e,"DIV",{class:!0});var ss=T(oe);h(co.$$.fragment,ss),DM=r(ss),up=l(ss,"P",{"data-svelte-h":!0}),_(up)!=="svelte-1dx7orz"&&(up.innerHTML=Sj),YM=r(ss),fp=l(ss,"P",{"data-svelte-h":!0}),_(fp)!=="svelte-qhda5i"&&(fp.innerHTML=Nj),PM=r(ss),h(nn.$$.fragment,ss),AM=r(ss),bp=l(ss,"DIV",{class:!0});var lU=T(bp);h(io.$$.fragment,lU),lU.forEach(n),ss.forEach(n),Fb=r(e),le=l(e,"DIV",{class:!0});var ns=T(le);h(po.$$.fragment,ns),OM=r(ns),_p=l(ns,"P",{"data-svelte-h":!0}),_(_p)!=="svelte-wdblk4"&&(_p.innerHTML=Hj),KM=r(ns),h(an.$$.fragment,ns),ev=r(ns),h(rn.$$.fragment,ns),tv=r(ns),yp=l(ns,"DIV",{class:!0});var cU=T(yp);h(mo.$$.fragment,cU),cU.forEach(n),ns.forEach(n),Xb=r(e),ze=l(e,"DIV",{class:!0});var Ja=T(ze);h(ho.$$.fragment,Ja),sv=r(Ja),Tp=l(Ja,"P",{"data-svelte-h":!0}),_(Tp)!=="svelte-sekyuo"&&(Tp.innerHTML=Ej),nv=r(Ja),h(on.$$.fragment,Ja),av=r(Ja),Mp=l(Ja,"DIV",{class:!0});var iU=T(Mp);h(go.$$.fragment,iU),iU.forEach(n),Ja.forEach(n),Rb=r(e),Ve=l(e,"DIV",{class:!0});var Ua=T(Ve);h(uo.$$.fragment,Ua),rv=r(Ua),vp=l(Ua,"P",{"data-svelte-h":!0}),_(vp)!=="svelte-kp6ubc"&&(vp.innerHTML=qj),ov=r(Ua),h(ln.$$.fragment,Ua),lv=r(Ua),wp=l(Ua,"DIV",{class:!0});var dU=T(wp);h(fo.$$.fragment,dU),dU.forEach(n),Ua.forEach(n),Lb=r(e),G=l(e,"DIV",{class:!0});var Te=T(G);h(bo.$$.fragment,Te),cv=r(Te),kp=l(Te,"P",{"data-svelte-h":!0}),_(kp)!=="svelte-1rvhp9l"&&(kp.textContent=Qj),iv=r(Te),$p=l(Te,"P",{"data-svelte-h":!0}),_($p)!=="svelte-1adc5s0"&&($p.textContent=Dj),dv=r(Te),jp=l(Te,"UL",{"data-svelte-h":!0}),_(jp)!=="svelte-eq22a7"&&(jp.innerHTML=Yj),pv=r(Te),xp=l(Te,"P",{"data-svelte-h":!0}),_(xp)!=="svelte-1mgc9mo"&&(xp.innerHTML=Pj),mv=r(Te),h(cn.$$.fragment,Te),hv=r(Te),Jp=l(Te,"DIV",{class:!0});var pU=T(Jp);h(_o.$$.fragment,pU),pU.forEach(n),Te.forEach(n),Sb=r(e),ce=l(e,"DIV",{class:!0});var as=T(ce);h(yo.$$.fragment,as),gv=r(as),Up=l(as,"P",{"data-svelte-h":!0}),_(Up)!=="svelte-1l8rgx"&&(Up.innerHTML=Aj),uv=r(as),h(dn.$$.fragment,as),fv=r(as),h(pn.$$.fragment,as),bv=r(as),Zp=l(as,"DIV",{class:!0});var mU=T(Zp);h(To.$$.fragment,mU),mU.forEach(n),as.forEach(n),Nb=r(e),Ge=l(e,"DIV",{class:!0});var Za=T(Ge);h(Mo.$$.fragment,Za),_v=r(Za),Cp=l(Za,"P",{"data-svelte-h":!0}),_(Cp)!=="svelte-1g5adob"&&(Cp.innerHTML=Oj),yv=r(Za),h(mn.$$.fragment,Za),Tv=r(Za),Wp=l(Za,"DIV",{class:!0});var hU=T(Wp);h(vo.$$.fragment,hU),hU.forEach(n),Za.forEach(n),Hb=r(e),Fe=l(e,"DIV",{class:!0});var Ca=T(Fe);h(wo.$$.fragment,Ca),Mv=r(Ca),Bp=l(Ca,"P",{"data-svelte-h":!0}),_(Bp)!=="svelte-1patzqj"&&(Bp.innerHTML=Kj),vv=r(Ca),h(hn.$$.fragment,Ca),wv=r(Ca),Ip=l(Ca,"DIV",{class:!0});var gU=T(Ip);h(ko.$$.fragment,gU),gU.forEach(n),Ca.forEach(n),Eb=r(e),ie=l(e,"DIV",{class:!0});var rs=T(ie);h($o.$$.fragment,rs),kv=r(rs),zp=l(rs,"P",{"data-svelte-h":!0}),_(zp)!=="svelte-wob73k"&&(zp.innerHTML=e0),$v=r(rs),Vp=l(rs,"P",{"data-svelte-h":!0}),_(Vp)!=="svelte-1qmimno"&&(Vp.innerHTML=t0),jv=r(rs),h(gn.$$.fragment,rs),xv=r(rs),Gp=l(rs,"DIV",{class:!0});var uU=T(Gp);h(jo.$$.fragment,uU),uU.forEach(n),rs.forEach(n),qb=r(e),de=l(e,"DIV",{class:!0});var os=T(de);h(xo.$$.fragment,os),Jv=r(os),Fp=l(os,"P",{"data-svelte-h":!0}),_(Fp)!=="svelte-1dewsn6"&&(Fp.innerHTML=s0),Uv=r(os),Xp=l(os,"P",{"data-svelte-h":!0}),_(Xp)!=="svelte-5qs7tv"&&(Xp.innerHTML=n0),Zv=r(os),h(un.$$.fragment,os),Cv=r(os),Rp=l(os,"DIV",{class:!0});var fU=T(Rp);h(Jo.$$.fragment,fU),fU.forEach(n),os.forEach(n),Qb=r(e),pe=l(e,"DIV",{class:!0});var ls=T(pe);h(Uo.$$.fragment,ls),Wv=r(ls),Lp=l(ls,"P",{"data-svelte-h":!0}),_(Lp)!=="svelte-laa6zp"&&(Lp.innerHTML=a0),Bv=r(ls),Sp=l(ls,"P",{"data-svelte-h":!0}),_(Sp)!=="svelte-qmmn5t"&&(Sp.innerHTML=r0),Iv=r(ls),h(fn.$$.fragment,ls),zv=r(ls),Np=l(ls,"DIV",{class:!0});var bU=T(Np);h(Zo.$$.fragment,bU),bU.forEach(n),ls.forEach(n),Db=r(e),E=l(e,"DIV",{class:!0});var Ee=T(E);h(Co.$$.fragment,Ee),Vv=r(Ee),Hp=l(Ee,"P",{"data-svelte-h":!0}),_(Hp)!=="svelte-1722u08"&&(Hp.innerHTML=o0),Gv=r(Ee),Ep=l(Ee,"P",{"data-svelte-h":!0}),_(Ep)!=="svelte-1yjxylt"&&(Ep.innerHTML=l0),Fv=r(Ee),qp=l(Ee,"P",{"data-svelte-h":!0}),_(qp)!=="svelte-y9hsik"&&(qp.innerHTML=c0),Xv=r(Ee),h(bn.$$.fragment,Ee),Rv=r(Ee),Qp=l(Ee,"DIV",{class:!0});var _U=T(Qp);h(Wo.$$.fragment,_U),_U.forEach(n),Ee.forEach(n),Yb=r(e),h(Bo.$$.fragment,e),Pb=r(e),rt=l(e,"DIV",{class:!0});var Wu=T(rt);h(Io.$$.fragment,Wu),Lv=r(Wu),Dp=l(Wu,"P",{"data-svelte-h":!0}),_(Dp)!=="svelte-1r9g8lr"&&(Dp.innerHTML=i0),Sv=r(Wu),Yp=l(Wu,"DIV",{class:!0});var yU=T(Yp);h(zo.$$.fragment,yU),yU.forEach(n),Wu.forEach(n),Ab=r(e),ot=l(e,"DIV",{class:!0});var Bu=T(ot);h(Vo.$$.fragment,Bu),Nv=r(Bu),Pp=l(Bu,"P",{"data-svelte-h":!0}),_(Pp)!=="svelte-1o8otjv"&&(Pp.innerHTML=d0),Hv=r(Bu),Ap=l(Bu,"DIV",{class:!0});var TU=T(Ap);h(Go.$$.fragment,TU),TU.forEach(n),Bu.forEach(n),Ob=r(e),lt=l(e,"DIV",{class:!0});var Iu=T(lt);h(Fo.$$.fragment,Iu),Ev=r(Iu),Op=l(Iu,"P",{"data-svelte-h":!0}),_(Op)!=="svelte-1557waw"&&(Op.innerHTML=p0),qv=r(Iu),Kp=l(Iu,"DIV",{class:!0});var MU=T(Kp);h(Xo.$$.fragment,MU),MU.forEach(n),Iu.forEach(n),Kb=r(e),ct=l(e,"DIV",{class:!0});var zu=T(ct);h(Ro.$$.fragment,zu),Qv=r(zu),em=l(zu,"P",{"data-svelte-h":!0}),_(em)!=="svelte-y1kta5"&&(em.textContent=m0),Dv=r(zu),_n=l(zu,"DIV",{class:!0});var _y=T(_n);h(Lo.$$.fragment,_y),Yv=r(_y),tm=l(_y,"P",{"data-svelte-h":!0}),_(tm)!=="svelte-5aspnb"&&(tm.textContent=h0),_y.forEach(n),zu.forEach(n),e_=r(e),it=l(e,"DIV",{class:!0});var Vu=T(it);h(So.$$.fragment,Vu),Pv=r(Vu),sm=l(Vu,"P",{"data-svelte-h":!0}),_(sm)!=="svelte-wv649x"&&(sm.innerHTML=g0),Av=r(Vu),nm=l(Vu,"DIV",{class:!0});var vU=T(nm);h(No.$$.fragment,vU),vU.forEach(n),Vu.forEach(n),t_=r(e),dt=l(e,"DIV",{class:!0});var Gu=T(dt);h(Ho.$$.fragment,Gu),Ov=r(Gu),am=l(Gu,"P",{"data-svelte-h":!0}),_(am)!=="svelte-th82mu"&&(am.textContent=u0),Kv=r(Gu),yn=l(Gu,"DIV",{class:!0});var yy=T(yn);h(Eo.$$.fragment,yy),ew=r(yy),rm=l(yy,"P",{"data-svelte-h":!0}),_(rm)!=="svelte-hcoglc"&&(rm.textContent=f0),yy.forEach(n),Gu.forEach(n),s_=r(e),pt=l(e,"DIV",{class:!0});var Fu=T(pt);h(qo.$$.fragment,Fu),tw=r(Fu),om=l(Fu,"P",{"data-svelte-h":!0}),_(om)!=="svelte-d6heh3"&&(om.innerHTML=b0),sw=r(Fu),lm=l(Fu,"DIV",{class:!0});var wU=T(lm);h(Qo.$$.fragment,wU),wU.forEach(n),Fu.forEach(n),n_=r(e),mt=l(e,"DIV",{class:!0});var Xu=T(mt);h(Do.$$.fragment,Xu),nw=r(Xu),cm=l(Xu,"P",{"data-svelte-h":!0}),_(cm)!=="svelte-gt0dvy"&&(cm.innerHTML=_0),aw=r(Xu),im=l(Xu,"DIV",{class:!0});var kU=T(im);h(Yo.$$.fragment,kU),kU.forEach(n),Xu.forEach(n),a_=r(e),ht=l(e,"DIV",{class:!0});var Ru=T(ht);h(Po.$$.fragment,Ru),rw=r(Ru),dm=l(Ru,"P",{"data-svelte-h":!0}),_(dm)!=="svelte-e8ez2m"&&(dm.innerHTML=y0),ow=r(Ru),pm=l(Ru,"DIV",{class:!0});var $U=T(pm);h(Ao.$$.fragment,$U),$U.forEach(n),Ru.forEach(n),r_=r(e),gt=l(e,"DIV",{class:!0});var Lu=T(gt);h(Oo.$$.fragment,Lu),lw=r(Lu),mm=l(Lu,"P",{"data-svelte-h":!0}),_(mm)!=="svelte-1sr1lwj"&&(mm.innerHTML=T0),cw=r(Lu),hm=l(Lu,"DIV",{class:!0});var jU=T(hm);h(Ko.$$.fragment,jU),jU.forEach(n),Lu.forEach(n),o_=r(e),ut=l(e,"DIV",{class:!0});var Su=T(ut);h(el.$$.fragment,Su),iw=r(Su),gm=l(Su,"P",{"data-svelte-h":!0}),_(gm)!=="svelte-16ddbx0"&&(gm.innerHTML=M0),dw=r(Su),um=l(Su,"DIV",{class:!0});var xU=T(um);h(tl.$$.fragment,xU),xU.forEach(n),Su.forEach(n),l_=r(e),ft=l(e,"DIV",{class:!0});var Nu=T(ft);h(sl.$$.fragment,Nu),pw=r(Nu),fm=l(Nu,"P",{"data-svelte-h":!0}),_(fm)!=="svelte-a554sd"&&(fm.innerHTML=v0),mw=r(Nu),bm=l(Nu,"DIV",{class:!0});var JU=T(bm);h(nl.$$.fragment,JU),JU.forEach(n),Nu.forEach(n),c_=r(e),bt=l(e,"DIV",{class:!0});var Hu=T(bt);h(al.$$.fragment,Hu),hw=r(Hu),_m=l(Hu,"P",{"data-svelte-h":!0}),_(_m)!=="svelte-m0ovbw"&&(_m.innerHTML=w0),gw=r(Hu),ym=l(Hu,"DIV",{class:!0});var UU=T(ym);h(rl.$$.fragment,UU),UU.forEach(n),Hu.forEach(n),i_=r(e),_t=l(e,"DIV",{class:!0});var Eu=T(_t);h(ol.$$.fragment,Eu),uw=r(Eu),Tm=l(Eu,"P",{"data-svelte-h":!0}),_(Tm)!=="svelte-v0j3k9"&&(Tm.innerHTML=k0),fw=r(Eu),Mm=l(Eu,"DIV",{class:!0});var ZU=T(Mm);h(ll.$$.fragment,ZU),ZU.forEach(n),Eu.forEach(n),d_=r(e),yt=l(e,"DIV",{class:!0});var qu=T(yt);h(cl.$$.fragment,qu),bw=r(qu),vm=l(qu,"P",{"data-svelte-h":!0}),_(vm)!=="svelte-1kdstb"&&(vm.innerHTML=$0),_w=r(qu),wm=l(qu,"DIV",{class:!0});var CU=T(wm);h(il.$$.fragment,CU),CU.forEach(n),qu.forEach(n),p_=r(e),h(dl.$$.fragment,e),m_=r(e),Tt=l(e,"DIV",{class:!0});var Qu=T(Tt);h(pl.$$.fragment,Qu),yw=r(Qu),km=l(Qu,"P",{"data-svelte-h":!0}),_(km)!=="svelte-115xumf"&&(km.innerHTML=j0),Tw=r(Qu),$m=l(Qu,"DIV",{class:!0});var WU=T($m);h(ml.$$.fragment,WU),WU.forEach(n),Qu.forEach(n),h_=r(e),Mt=l(e,"DIV",{class:!0});var Du=T(Mt);h(hl.$$.fragment,Du),Mw=r(Du),jm=l(Du,"P",{"data-svelte-h":!0}),_(jm)!=="svelte-nirf9f"&&(jm.innerHTML=x0),vw=r(Du),xm=l(Du,"DIV",{class:!0});var BU=T(xm);h(gl.$$.fragment,BU),BU.forEach(n),Du.forEach(n),g_=r(e),vt=l(e,"DIV",{class:!0});var Yu=T(vt);h(ul.$$.fragment,Yu),ww=r(Yu),Jm=l(Yu,"P",{"data-svelte-h":!0}),_(Jm)!=="svelte-klyckq"&&(Jm.innerHTML=J0),kw=r(Yu),Um=l(Yu,"DIV",{class:!0});var IU=T(Um);h(fl.$$.fragment,IU),IU.forEach(n),Yu.forEach(n),u_=r(e),wt=l(e,"DIV",{class:!0});var Pu=T(wt);h(bl.$$.fragment,Pu),$w=r(Pu),Zm=l(Pu,"P",{"data-svelte-h":!0}),_(Zm)!=="svelte-y1kta5"&&(Zm.textContent=U0),jw=r(Pu),Tn=l(Pu,"DIV",{class:!0});var Ty=T(Tn);h(_l.$$.fragment,Ty),xw=r(Ty),Cm=l(Ty,"P",{"data-svelte-h":!0}),_(Cm)!=="svelte-1l17mwc"&&(Cm.textContent=Z0),Ty.forEach(n),Pu.forEach(n),f_=r(e),kt=l(e,"DIV",{class:!0});var Au=T(kt);h(yl.$$.fragment,Au),Jw=r(Au),Wm=l(Au,"P",{"data-svelte-h":!0}),_(Wm)!=="svelte-8dgktv"&&(Wm.innerHTML=C0),Uw=r(Au),Bm=l(Au,"DIV",{class:!0});var zU=T(Bm);h(Tl.$$.fragment,zU),zU.forEach(n),Au.forEach(n),b_=r(e),$t=l(e,"DIV",{class:!0});var Ou=T($t);h(Ml.$$.fragment,Ou),Zw=r(Ou),Im=l(Ou,"P",{"data-svelte-h":!0}),_(Im)!=="svelte-th82mu"&&(Im.textContent=W0),Cw=r(Ou),Mn=l(Ou,"DIV",{class:!0});var My=T(Mn);h(vl.$$.fragment,My),Ww=r(My),zm=l(My,"P",{"data-svelte-h":!0}),_(zm)!=="svelte-1tcb5cf"&&(zm.textContent=B0),My.forEach(n),Ou.forEach(n),__=r(e),jt=l(e,"DIV",{class:!0});var Ku=T(jt);h(wl.$$.fragment,Ku),Bw=r(Ku),Vm=l(Ku,"P",{"data-svelte-h":!0}),_(Vm)!=="svelte-18yq2lb"&&(Vm.innerHTML=I0),Iw=r(Ku),Gm=l(Ku,"DIV",{class:!0});var VU=T(Gm);h(kl.$$.fragment,VU),VU.forEach(n),Ku.forEach(n),y_=r(e),xt=l(e,"DIV",{class:!0});var ef=T(xt);h($l.$$.fragment,ef),zw=r(ef),Fm=l(ef,"P",{"data-svelte-h":!0}),_(Fm)!=="svelte-rwiser"&&(Fm.innerHTML=z0),Vw=r(ef),Xm=l(ef,"DIV",{class:!0});var GU=T(Xm);h(jl.$$.fragment,GU),GU.forEach(n),ef.forEach(n),T_=r(e),Jt=l(e,"DIV",{class:!0});var tf=T(Jt);h(xl.$$.fragment,tf),Gw=r(tf),Rm=l(tf,"P",{"data-svelte-h":!0}),_(Rm)!=="svelte-vt3rxp"&&(Rm.innerHTML=V0),Fw=r(tf),Lm=l(tf,"DIV",{class:!0});var FU=T(Lm);h(Jl.$$.fragment,FU),FU.forEach(n),tf.forEach(n),M_=r(e),Ut=l(e,"DIV",{class:!0});var sf=T(Ut);h(Ul.$$.fragment,sf),Xw=r(sf),Sm=l(sf,"P",{"data-svelte-h":!0}),_(Sm)!=="svelte-15abw8y"&&(Sm.innerHTML=G0),Rw=r(sf),Nm=l(sf,"DIV",{class:!0});var XU=T(Nm);h(Zl.$$.fragment,XU),XU.forEach(n),sf.forEach(n),v_=r(e),Zt=l(e,"DIV",{class:!0});var nf=T(Zt);h(Cl.$$.fragment,nf),Lw=r(nf),Hm=l(nf,"P",{"data-svelte-h":!0}),_(Hm)!=="svelte-1oo0biz"&&(Hm.innerHTML=F0),Sw=r(nf),Em=l(nf,"DIV",{class:!0});var RU=T(Em);h(Wl.$$.fragment,RU),RU.forEach(n),nf.forEach(n),w_=r(e),Ct=l(e,"DIV",{class:!0});var af=T(Ct);h(Bl.$$.fragment,af),Nw=r(af),qm=l(af,"P",{"data-svelte-h":!0}),_(qm)!=="svelte-1j5ogr1"&&(qm.innerHTML=X0),Hw=r(af),Qm=l(af,"DIV",{class:!0});var LU=T(Qm);h(Il.$$.fragment,LU),LU.forEach(n),af.forEach(n),k_=r(e),Wt=l(e,"DIV",{class:!0});var rf=T(Wt);h(zl.$$.fragment,rf),Ew=r(rf),Dm=l(rf,"P",{"data-svelte-h":!0}),_(Dm)!=="svelte-1sygpwz"&&(Dm.innerHTML=R0),qw=r(rf),Ym=l(rf,"DIV",{class:!0});var SU=T(Ym);h(Vl.$$.fragment,SU),SU.forEach(n),rf.forEach(n),$_=r(e),h(Gl.$$.fragment,e),j_=r(e),Fl=l(e,"P",{"data-svelte-h":!0}),_(Fl)!=="svelte-vfaqvb"&&(Fl.innerHTML=L0),x_=r(e),Xe=l(e,"DIV",{class:!0});var Wa=T(Xe);h(Xl.$$.fragment,Wa),Qw=r(Wa),Pm=l(Wa,"P",{"data-svelte-h":!0}),_(Pm)!=="svelte-rfvu1k"&&(Pm.textContent=S0),Dw=r(Wa),Am=l(Wa,"P",{"data-svelte-h":!0}),_(Am)!=="svelte-e1lytz"&&(Am.innerHTML=N0),Yw=r(Wa),Om=l(Wa,"DIV",{class:!0});var NU=T(Om);h(Rl.$$.fragment,NU),NU.forEach(n),Wa.forEach(n),J_=r(e),js=l(e,"DIV",{class:!0});var vy=T(js);h(Ll.$$.fragment,vy),Pw=r(vy),Km=l(vy,"DIV",{class:!0});var HU=T(Km);h(Sl.$$.fragment,HU),HU.forEach(n),vy.forEach(n),U_=r(e),Bt=l(e,"DIV",{class:!0});var of=T(Bt);h(Nl.$$.fragment,of),Aw=r(of),eh=l(of,"P",{"data-svelte-h":!0}),_(eh)!=="svelte-4hfu96"&&(eh.innerHTML=H0),Ow=r(of),th=l(of,"DIV",{class:!0});var EU=T(th);h(Hl.$$.fragment,EU),EU.forEach(n),of.forEach(n),Z_=r(e),It=l(e,"DIV",{class:!0});var lf=T(It);h(El.$$.fragment,lf),Kw=r(lf),sh=l(lf,"P",{"data-svelte-h":!0}),_(sh)!=="svelte-q5v59n"&&(sh.innerHTML=E0),e2=r(lf),nh=l(lf,"DIV",{class:!0});var qU=T(nh);h(ql.$$.fragment,qU),qU.forEach(n),lf.forEach(n),C_=r(e),J=l(e,"DIV",{class:!0});var C=T(J);h(Ql.$$.fragment,C),t2=r(C),ah=l(C,"P",{"data-svelte-h":!0}),_(ah)!=="svelte-1rue44"&&(ah.textContent=q0),s2=r(C),rh=l(C,"P",{"data-svelte-h":!0}),_(rh)!=="svelte-we1k7h"&&(rh.textContent=Q0),n2=r(C),oh=l(C,"UL",{"data-svelte-h":!0}),_(oh)!=="svelte-1f6ppg"&&(oh.innerHTML=D0),a2=r(C),lh=l(C,"P",{"data-svelte-h":!0}),_(lh)!=="svelte-1uu68ip"&&(lh.textContent=Y0),r2=r(C),ch=l(C,"UL",{"data-svelte-h":!0}),_(ch)!=="svelte-izl8df"&&(ch.innerHTML=P0),o2=r(C),ih=l(C,"P",{"data-svelte-h":!0}),_(ih)!=="svelte-hoqys0"&&(ih.textContent=A0),l2=r(C),dh=l(C,"P",{"data-svelte-h":!0}),_(dh)!=="svelte-1a9fclk"&&(dh.textContent=O0),c2=r(C),ph=l(C,"P",{"data-svelte-h":!0}),_(ph)!=="svelte-15ntb9y"&&(ph.textContent=K0),i2=r(C),mh=l(C,"UL",{"data-svelte-h":!0}),_(mh)!=="svelte-vv46ly"&&(mh.innerHTML=ex),d2=r(C),hh=l(C,"P",{"data-svelte-h":!0}),_(hh)!=="svelte-1owyk1q"&&(hh.textContent=tx),p2=r(C),gh=l(C,"P",{"data-svelte-h":!0}),_(gh)!=="svelte-wt8oc0"&&(gh.textContent=sx),m2=r(C),uh=l(C,"P",{"data-svelte-h":!0}),_(uh)!=="svelte-ws21yj"&&(uh.textContent=nx),h2=r(C),fh=l(C,"P",{"data-svelte-h":!0}),_(fh)!=="svelte-l6qxzs"&&(fh.textContent=ax),g2=r(C),bh=l(C,"UL",{"data-svelte-h":!0}),_(bh)!=="svelte-p67cyh"&&(bh.innerHTML=rx),u2=r(C),_h=l(C,"P",{"data-svelte-h":!0}),_(_h)!=="svelte-1fg1xi2"&&(_h.textContent=ox),f2=r(C),yh=l(C,"P",{"data-svelte-h":!0}),_(yh)!=="svelte-1e0ripw"&&(yh.textContent=lx),b2=r(C),Th=l(C,"UL",{"data-svelte-h":!0}),_(Th)!=="svelte-1v088e0"&&(Th.innerHTML=cx),_2=r(C),Mh=l(C,"P",{"data-svelte-h":!0}),_(Mh)!=="svelte-be7vix"&&(Mh.textContent=ix),y2=r(C),vh=l(C,"P",{"data-svelte-h":!0}),_(vh)!=="svelte-1xhdoom"&&(vh.textContent=dx),T2=r(C),h(vn.$$.fragment,C),M2=r(C),wh=l(C,"DIV",{class:!0});var QU=T(wh);h(Dl.$$.fragment,QU),QU.forEach(n),C.forEach(n),W_=r(e),zt=l(e,"DIV",{class:!0});var cf=T(zt);h(Yl.$$.fragment,cf),v2=r(cf),kh=l(cf,"P",{"data-svelte-h":!0}),_(kh)!=="svelte-1t19wr8"&&(kh.innerHTML=px),w2=r(cf),$h=l(cf,"DIV",{class:!0});var DU=T($h);h(Pl.$$.fragment,DU),DU.forEach(n),cf.forEach(n),B_=r(e),h(Al.$$.fragment,e),I_=r(e),Ol=l(e,"P",{"data-svelte-h":!0}),_(Ol)!=="svelte-1fq8mcp"&&(Ol.innerHTML=mx),z_=r(e),W=l(e,"DIV",{class:!0});var B=T(W);h(Kl.$$.fragment,B),k2=r(B),jh=l(B,"P",{"data-svelte-h":!0}),_(jh)!=="svelte-1kh5y5v"&&(jh.textContent=hx),$2=r(B),xh=l(B,"P",{"data-svelte-h":!0}),_(xh)!=="svelte-1ygkifj"&&(xh.textContent=gx),j2=r(B),h(wn.$$.fragment,B),x2=r(B),Jh=l(B,"P",{"data-svelte-h":!0}),_(Jh)!=="svelte-7kbd1a"&&(Jh.textContent=ux),J2=r(B),kn=l(B,"DIV",{class:!0});var wy=T(kn);h(ec.$$.fragment,wy),U2=r(wy),Uh=l(wy,"P",{"data-svelte-h":!0}),_(Uh)!=="svelte-163x237"&&(Uh.textContent=fx),wy.forEach(n),Z2=r(B),$n=l(B,"DIV",{class:!0});var ky=T($n);h(tc.$$.fragment,ky),C2=r(ky),Zh=l(ky,"P",{"data-svelte-h":!0}),_(Zh)!=="svelte-dtkk01"&&(Zh.textContent=bx),ky.forEach(n),W2=r(B),jn=l(B,"DIV",{class:!0});var $y=T(jn);h(sc.$$.fragment,$y),B2=r($y),Ch=l($y,"P",{"data-svelte-h":!0}),_(Ch)!=="svelte-11pa7k0"&&(Ch.textContent=_x),$y.forEach(n),I2=r(B),xn=l(B,"DIV",{class:!0});var jy=T(xn);h(nc.$$.fragment,jy),z2=r(jy),Wh=l(jy,"P",{"data-svelte-h":!0}),_(Wh)!=="svelte-57vcuk"&&(Wh.innerHTML=yx),jy.forEach(n),V2=r(B),Jn=l(B,"DIV",{class:!0});var xy=T(Jn);h(ac.$$.fragment,xy),G2=r(xy),Bh=l(xy,"P",{"data-svelte-h":!0}),_(Bh)!=="svelte-e342dt"&&(Bh.textContent=Tx),xy.forEach(n),F2=r(B),Un=l(B,"DIV",{class:!0});var Jy=T(Un);h(rc.$$.fragment,Jy),X2=r(Jy),Ih=l(Jy,"P",{"data-svelte-h":!0}),_(Ih)!=="svelte-vbd5xj"&&(Ih.textContent=Mx),Jy.forEach(n),R2=r(B),Kt=l(B,"DIV",{class:!0});var df=T(Kt);h(oc.$$.fragment,df),L2=r(df),zh=l(df,"P",{"data-svelte-h":!0}),_(zh)!=="svelte-1c2dshy"&&(zh.innerHTML=vx),S2=r(df),Vh=l(df,"P",{"data-svelte-h":!0}),_(Vh)!=="svelte-1qvu1un"&&(Vh.textContent=wx),df.forEach(n),B.forEach(n),V_=r(e),xs=l(e,"DIV",{class:!0});var Uy=T(xs);h(lc.$$.fragment,Uy),N2=r(Uy),Gh=l(Uy,"P",{"data-svelte-h":!0}),_(Gh)!=="svelte-1rymat9"&&(Gh.innerHTML=kx),Uy.forEach(n),G_=r(e),Js=l(e,"DIV",{class:!0});var Zy=T(Js);h(cc.$$.fragment,Zy),H2=r(Zy),Fh=l(Zy,"P",{"data-svelte-h":!0}),_(Fh)!=="svelte-1obuarm"&&(Fh.innerHTML=$x),Zy.forEach(n),F_=r(e),Re=l(e,"DIV",{class:!0});var Ba=T(Re);h(ic.$$.fragment,Ba),E2=r(Ba),Xh=l(Ba,"P",{"data-svelte-h":!0}),_(Xh)!=="svelte-rxlesw"&&(Xh.textContent=jx),q2=r(Ba),K=l(Ba,"DIV",{class:!0});var qe=T(K);h(dc.$$.fragment,qe),Q2=r(qe),Rh=l(qe,"P",{"data-svelte-h":!0}),_(Rh)!=="svelte-15hhlou"&&(Rh.textContent=xx),D2=r(qe),Lh=l(qe,"P",{"data-svelte-h":!0}),_(Lh)!=="svelte-e6h4hs"&&(Lh.innerHTML=Jx),Y2=r(qe),Sh=l(qe,"P",{"data-svelte-h":!0}),_(Sh)!=="svelte-1w36vm3"&&(Sh.innerHTML=Ux),P2=r(qe),Nh=l(qe,"P",{"data-svelte-h":!0}),_(Nh)!=="svelte-1niq0qw"&&(Nh.innerHTML=Zx),A2=r(qe),Hh=l(qe,"P",{"data-svelte-h":!0}),_(Hh)!=="svelte-af4g6f"&&(Hh.textContent=Cx),qe.forEach(n),O2=r(Ba),Zn=l(Ba,"DIV",{class:!0});var Cy=T(Zn);h(pc.$$.fragment,Cy),K2=r(Cy),Eh=l(Cy,"P",{"data-svelte-h":!0}),_(Eh)!=="svelte-eab6jp"&&(Eh.textContent=Wx),Cy.forEach(n),Ba.forEach(n),X_=r(e),h(mc.$$.fragment,e),R_=r(e),Le=l(e,"DIV",{class:!0});var Ia=T(Le);h(hc.$$.fragment,Ia),e1=r(Ia),qh=l(Ia,"P",{"data-svelte-h":!0}),_(qh)!=="svelte-1fikjzl"&&(qh.innerHTML=Bx),t1=r(Ia),Qh=l(Ia,"DIV",{class:!0});var YU=T(Qh);h(gc.$$.fragment,YU),YU.forEach(n),s1=r(Ia),Dh=l(Ia,"DIV",{class:!0});var PU=T(Dh);h(uc.$$.fragment,PU),PU.forEach(n),Ia.forEach(n),L_=r(e),q=l(e,"DIV",{class:!0});var Qe=T(q);h(fc.$$.fragment,Qe),n1=r(Qe),Yh=l(Qe,"P",{"data-svelte-h":!0}),_(Yh)!=="svelte-1lvowm"&&(Yh.innerHTML=Ix),a1=r(Qe),Ph=l(Qe,"P",{"data-svelte-h":!0}),_(Ph)!=="svelte-19qrwo1"&&(Ph.innerHTML=zx),r1=r(Qe),Ah=l(Qe,"P",{"data-svelte-h":!0}),_(Ah)!=="svelte-l79sbt"&&(Ah.innerHTML=Vx),o1=r(Qe),Oh=l(Qe,"DIV",{class:!0});var AU=T(Oh);h(bc.$$.fragment,AU),AU.forEach(n),l1=r(Qe),Kh=l(Qe,"DIV",{class:!0});var OU=T(Kh);h(_c.$$.fragment,OU),OU.forEach(n),Qe.forEach(n),S_=r(e),Se=l(e,"DIV",{class:!0});var za=T(Se);h(yc.$$.fragment,za),c1=r(za),eg=l(za,"P",{"data-svelte-h":!0}),_(eg)!=="svelte-cvew4t"&&(eg.innerHTML=Gx),i1=r(za),tg=l(za,"DIV",{class:!0});var KU=T(tg);h(Tc.$$.fragment,KU),KU.forEach(n),d1=r(za),sg=l(za,"DIV",{class:!0});var eZ=T(sg);h(Mc.$$.fragment,eZ),eZ.forEach(n),za.forEach(n),N_=r(e),h(vc.$$.fragment,e),H_=r(e),F=l(e,"DIV",{class:!0});var Me=T(F);h(wc.$$.fragment,Me),p1=r(Me),ng=l(Me,"P",{"data-svelte-h":!0}),_(ng)!=="svelte-5jvlz5"&&(ng.textContent=Fx),m1=r(Me),h(Cn.$$.fragment,Me),h1=r(Me),h(Wn.$$.fragment,Me),g1=r(Me),Bn=l(Me,"DIV",{class:!0});var Wy=T(Bn);h(kc.$$.fragment,Wy),u1=r(Wy),ag=l(Wy,"P",{"data-svelte-h":!0}),_(ag)!=="svelte-10d94rs"&&(ag.textContent=Xx),Wy.forEach(n),f1=r(Me),In=l(Me,"DIV",{class:!0});var By=T(In);h($c.$$.fragment,By),b1=r(By),rg=l(By,"P",{"data-svelte-h":!0}),_(rg)!=="svelte-tm945r"&&(rg.textContent=Rx),By.forEach(n),_1=r(Me),zn=l(Me,"DIV",{class:!0});var Iy=T(zn);h(jc.$$.fragment,Iy),y1=r(Iy),og=l(Iy,"P",{"data-svelte-h":!0}),_(og)!=="svelte-1i1356p"&&(og.textContent=Lx),Iy.forEach(n),Me.forEach(n),E_=r(e),me=l(e,"DIV",{class:!0});var cs=T(me);h(xc.$$.fragment,cs),T1=r(cs),lg=l(cs,"P",{"data-svelte-h":!0}),_(lg)!=="svelte-190fodr"&&(lg.textContent=Sx),M1=r(cs),h(Vn.$$.fragment,cs),v1=r(cs),h(Gn.$$.fragment,cs),w1=r(cs),Fn=l(cs,"DIV",{class:!0});var zy=T(Fn);h(Jc.$$.fragment,zy),k1=r(zy),cg=l(zy,"P",{"data-svelte-h":!0}),_(cg)!=="svelte-16i5iz"&&(cg.textContent=Nx),zy.forEach(n),cs.forEach(n),q_=r(e),h(Uc.$$.fragment,e),Q_=r(e),Vt=l(e,"DIV",{class:!0});var pf=T(Vt);h(Zc.$$.fragment,pf),$1=r(pf),ig=l(pf,"P",{"data-svelte-h":!0}),_(ig)!=="svelte-15qehu2"&&(ig.textContent=Hx),j1=r(pf),Xn=l(pf,"DIV",{class:!0});var Vy=T(Xn);h(Cc.$$.fragment,Vy),x1=r(Vy),dg=l(Vy,"P",{"data-svelte-h":!0}),_(dg)!=="svelte-dfcv5s"&&(dg.innerHTML=Ex),Vy.forEach(n),pf.forEach(n),D_=r(e),Gt=l(e,"DIV",{class:!0});var mf=T(Gt);h(Wc.$$.fragment,mf),J1=r(mf),pg=l(mf,"P",{"data-svelte-h":!0}),_(pg)!=="svelte-1sqibp"&&(pg.textContent=qx),U1=r(mf),Rn=l(mf,"DIV",{class:!0});var Gy=T(Rn);h(Bc.$$.fragment,Gy),Z1=r(Gy),mg=l(Gy,"P",{"data-svelte-h":!0}),_(mg)!=="svelte-n0rwld"&&(mg.innerHTML=Qx),Gy.forEach(n),mf.forEach(n),Y_=r(e),Ft=l(e,"DIV",{class:!0});var hf=T(Ft);h(Ic.$$.fragment,hf),C1=r(hf),hg=l(hf,"P",{"data-svelte-h":!0}),_(hg)!=="svelte-157zylv"&&(hg.textContent=Dx),W1=r(hf),Ln=l(hf,"DIV",{class:!0});var Fy=T(Ln);h(zc.$$.fragment,Fy),B1=r(Fy),gg=l(Fy,"P",{"data-svelte-h":!0}),_(gg)!=="svelte-15juztn"&&(gg.textContent=Yx),Fy.forEach(n),hf.forEach(n),P_=r(e),I=l(e,"DIV",{class:!0});var L=T(I);h(Vc.$$.fragment,L),I1=r(L),ug=l(L,"P",{"data-svelte-h":!0}),_(ug)!=="svelte-11w7j52"&&(ug.textContent=Px),z1=r(L),fg=l(L,"P",{"data-svelte-h":!0}),_(fg)!=="svelte-1f9j82e"&&(fg.innerHTML=Ax),V1=r(L),h(Sn.$$.fragment,L),G1=r(L),Nn=l(L,"DIV",{class:!0});var Xy=T(Nn);h(Gc.$$.fragment,Xy),F1=r(Xy),bg=l(Xy,"P",{"data-svelte-h":!0}),_(bg)!=="svelte-dfcv5s"&&(bg.innerHTML=Ox),Xy.forEach(n),X1=r(L),Hn=l(L,"DIV",{class:!0});var Ry=T(Hn);h(Fc.$$.fragment,Ry),R1=r(Ry),_g=l(Ry,"P",{"data-svelte-h":!0}),_(_g)!=="svelte-1nftdf9"&&(_g.textContent=Kx),Ry.forEach(n),L1=r(L),En=l(L,"DIV",{class:!0});var Ly=T(En);h(Xc.$$.fragment,Ly),S1=r(Ly),yg=l(Ly,"P",{"data-svelte-h":!0}),_(yg)!=="svelte-114iuj0"&&(yg.textContent=eJ),Ly.forEach(n),N1=r(L),qn=l(L,"DIV",{class:!0});var Sy=T(qn);h(Rc.$$.fragment,Sy),H1=r(Sy),Tg=l(Sy,"P",{"data-svelte-h":!0}),_(Tg)!=="svelte-dst59w"&&(Tg.innerHTML=tJ),Sy.forEach(n),E1=r(L),Qn=l(L,"DIV",{class:!0});var Ny=T(Qn);h(Lc.$$.fragment,Ny),q1=r(Ny),Mg=l(Ny,"P",{"data-svelte-h":!0}),_(Mg)!=="svelte-15y4kd1"&&(Mg.innerHTML=sJ),Ny.forEach(n),L.forEach(n),A_=r(e),Q=l(e,"DIV",{class:!0});var De=T(Q);h(Sc.$$.fragment,De),Q1=r(De),vg=l(De,"P",{"data-svelte-h":!0}),_(vg)!=="svelte-1x0oesy"&&(vg.innerHTML=nJ),D1=r(De),wg=l(De,"P",{"data-svelte-h":!0}),_(wg)!=="svelte-2ai6qp"&&(wg.innerHTML=aJ),Y1=r(De),kg=l(De,"P",{"data-svelte-h":!0}),_(kg)!=="svelte-18fduhd"&&(kg.innerHTML=rJ),P1=r(De),$g=l(De,"DIV",{class:!0});var tZ=T($g);h(Nc.$$.fragment,tZ),tZ.forEach(n),A1=r(De),Dn=l(De,"DIV",{class:!0});var Hy=T(Dn);h(Hc.$$.fragment,Hy),O1=r(Hy),jg=l(Hy,"P",{"data-svelte-h":!0}),_(jg)!=="svelte-1nftdf9"&&(jg.textContent=oJ),Hy.forEach(n),De.forEach(n),O_=r(e),Xt=l(e,"DIV",{class:!0});var gf=T(Xt);h(Ec.$$.fragment,gf),K1=r(gf),xg=l(gf,"P",{"data-svelte-h":!0}),_(xg)!=="svelte-pjm1pe"&&(xg.innerHTML=lJ),ek=r(gf),h(Yn.$$.fragment,gf),gf.forEach(n),K_=r(e),Rt=l(e,"DIV",{class:!0});var uf=T(Rt);h(qc.$$.fragment,uf),tk=r(uf),Jg=l(uf,"P",{"data-svelte-h":!0}),_(Jg)!=="svelte-api7s7"&&(Jg.innerHTML=cJ),sk=r(uf),h(Pn.$$.fragment,uf),uf.forEach(n),ey=r(e),X=l(e,"DIV",{class:!0});var ve=T(X);h(Qc.$$.fragment,ve),nk=r(ve),Ug=l(ve,"P",{"data-svelte-h":!0}),_(Ug)!=="svelte-ldcea6"&&(Ug.innerHTML=iJ),ak=r(ve),Zg=l(ve,"P",{"data-svelte-h":!0}),_(Zg)!=="svelte-1f9j82e"&&(Zg.innerHTML=dJ),rk=r(ve),h(An.$$.fragment,ve),ok=r(ve),On=l(ve,"DIV",{class:!0});var Ey=T(On);h(Dc.$$.fragment,Ey),lk=r(Ey),Cg=l(Ey,"P",{"data-svelte-h":!0}),_(Cg)!=="svelte-dfcv5s"&&(Cg.innerHTML=pJ),Ey.forEach(n),ck=r(ve),Kn=l(ve,"DIV",{class:!0});var qy=T(Kn);h(Yc.$$.fragment,qy),ik=r(qy),Wg=l(qy,"P",{"data-svelte-h":!0}),_(Wg)!=="svelte-1nftdf9"&&(Wg.textContent=mJ),qy.forEach(n),dk=r(ve),ea=l(ve,"DIV",{class:!0});var Qy=T(ea);h(Pc.$$.fragment,Qy),pk=r(Qy),Bg=l(Qy,"P",{"data-svelte-h":!0}),_(Bg)!=="svelte-114iuj0"&&(Bg.textContent=hJ),Qy.forEach(n),ve.forEach(n),ty=r(e),D=l(e,"DIV",{class:!0});var Ye=T(D);h(Ac.$$.fragment,Ye),mk=r(Ye),Ig=l(Ye,"P",{"data-svelte-h":!0}),_(Ig)!=="svelte-8o3e5p"&&(Ig.textContent=gJ),hk=r(Ye),zg=l(Ye,"P",{"data-svelte-h":!0}),_(zg)!=="svelte-1cyjk9y"&&(zg.textContent=uJ),gk=r(Ye),ta=l(Ye,"DIV",{class:!0});var Dy=T(ta);h(Oc.$$.fragment,Dy),uk=r(Dy),Vg=l(Dy,"P",{"data-svelte-h":!0}),_(Vg)!=="svelte-dfcv5s"&&(Vg.innerHTML=fJ),Dy.forEach(n),fk=r(Ye),sa=l(Ye,"DIV",{class:!0});var Yy=T(sa);h(Kc.$$.fragment,Yy),bk=r(Yy),Gg=l(Yy,"P",{"data-svelte-h":!0}),_(Gg)!=="svelte-t93z5n"&&(Gg.textContent=bJ),Yy.forEach(n),_k=r(Ye),na=l(Ye,"DIV",{class:!0});var Py=T(na);h(ei.$$.fragment,Py),yk=r(Py),Fg=l(Py,"P",{"data-svelte-h":!0}),_(Fg)!=="svelte-1rjgo2n"&&(Fg.textContent=_J),Py.forEach(n),Ye.forEach(n),sy=r(e),Y=l(e,"DIV",{class:!0});var Pe=T(Y);h(ti.$$.fragment,Pe),Tk=r(Pe),Xg=l(Pe,"P",{"data-svelte-h":!0}),_(Xg)!=="svelte-1atvuc"&&(Xg.innerHTML=yJ),Mk=r(Pe),h(aa.$$.fragment,Pe),vk=r(Pe),ra=l(Pe,"DIV",{class:!0});var Ay=T(ra);h(si.$$.fragment,Ay),wk=r(Ay),Rg=l(Ay,"P",{"data-svelte-h":!0}),_(Rg)!=="svelte-vi6d54"&&(Rg.innerHTML=TJ),Ay.forEach(n),kk=r(Pe),oa=l(Pe,"DIV",{class:!0});var Oy=T(oa);h(ni.$$.fragment,Oy),$k=r(Oy),Lg=l(Oy,"P",{"data-svelte-h":!0}),_(Lg)!=="svelte-14hqs6n"&&(Lg.textContent=MJ),Oy.forEach(n),jk=r(Pe),la=l(Pe,"DIV",{class:!0});var Ky=T(la);h(ai.$$.fragment,Ky),xk=r(Ky),Sg=l(Ky,"P",{"data-svelte-h":!0}),_(Sg)!=="svelte-135okg0"&&(Sg.textContent=vJ),Ky.forEach(n),Pe.forEach(n),ny=r(e),P=l(e,"DIV",{class:!0});var Ae=T(P);h(ri.$$.fragment,Ae),Jk=r(Ae),Ng=l(Ae,"P",{"data-svelte-h":!0}),_(Ng)!=="svelte-t1noj8"&&(Ng.innerHTML=wJ),Uk=r(Ae),h(ca.$$.fragment,Ae),Zk=r(Ae),ia=l(Ae,"DIV",{class:!0});var eT=T(ia);h(oi.$$.fragment,eT),Ck=r(eT),Hg=l(eT,"P",{"data-svelte-h":!0}),_(Hg)!=="svelte-vi6d54"&&(Hg.innerHTML=kJ),eT.forEach(n),Wk=r(Ae),da=l(Ae,"DIV",{class:!0});var tT=T(da);h(li.$$.fragment,tT),Bk=r(tT),Eg=l(tT,"P",{"data-svelte-h":!0}),_(Eg)!=="svelte-14hqs6n"&&(Eg.textContent=$J),tT.forEach(n),Ik=r(Ae),pa=l(Ae,"DIV",{class:!0});var sT=T(pa);h(ci.$$.fragment,sT),zk=r(sT),qg=l(sT,"P",{"data-svelte-h":!0}),_(qg)!=="svelte-oxae9u"&&(qg.textContent=jJ),sT.forEach(n),Ae.forEach(n),ay=r(e),A=l(e,"DIV",{class:!0});var Oe=T(A);h(ii.$$.fragment,Oe),Vk=r(Oe),Qg=l(Oe,"P",{"data-svelte-h":!0}),_(Qg)!=="svelte-oxdq12"&&(Qg.innerHTML=xJ),Gk=r(Oe),h(ma.$$.fragment,Oe),Fk=r(Oe),Dg=l(Oe,"DIV",{class:!0});var sZ=T(Dg);h(di.$$.fragment,sZ),sZ.forEach(n),Xk=r(Oe),Yg=l(Oe,"DIV",{class:!0});var nZ=T(Yg);h(pi.$$.fragment,nZ),nZ.forEach(n),Rk=r(Oe),ha=l(Oe,"DIV",{class:!0});var nT=T(ha);h(mi.$$.fragment,nT),Lk=r(nT),Pg=l(nT,"P",{"data-svelte-h":!0}),_(Pg)!=="svelte-135okg0"&&(Pg.textContent=JJ),nT.forEach(n),Oe.forEach(n),ry=r(e),z=l(e,"DIV",{class:!0});var ee=T(z);h(hi.$$.fragment,ee),Sk=r(ee),Ag=l(ee,"P",{"data-svelte-h":!0}),_(Ag)!=="svelte-16jubgm"&&(Ag.innerHTML=UJ),Nk=r(ee),Og=l(ee,"P",{"data-svelte-h":!0}),_(Og)!=="svelte-437xch"&&(Og.innerHTML=ZJ),Hk=r(ee),Kg=l(ee,"P",{"data-svelte-h":!0}),_(Kg)!=="svelte-1qvpx79"&&(Kg.textContent=CJ),Ek=r(ee),eu=l(ee,"P",{"data-svelte-h":!0}),_(eu)!=="svelte-dhmy5x"&&(eu.innerHTML=WJ),qk=r(ee),h(ga.$$.fragment,ee),Qk=r(ee),tu=l(ee,"DIV",{class:!0});var aZ=T(tu);h(gi.$$.fragment,aZ),aZ.forEach(n),Dk=r(ee),su=l(ee,"DIV",{class:!0});var rZ=T(su);h(ui.$$.fragment,rZ),rZ.forEach(n),ee.forEach(n),oy=r(e),V=l(e,"DIV",{class:!0});var te=T(V);h(fi.$$.fragment,te),Yk=r(te),nu=l(te,"P",{"data-svelte-h":!0}),_(nu)!=="svelte-biazxg"&&(nu.textContent=BJ),Pk=r(te),h(ua.$$.fragment,te),Ak=r(te),fa=l(te,"DIV",{class:!0});var aT=T(fa);h(bi.$$.fragment,aT),Ok=r(aT),au=l(aT,"P",{"data-svelte-h":!0}),_(au)!=="svelte-1nftdf9"&&(au.textContent=IJ),aT.forEach(n),Kk=r(te),ba=l(te,"DIV",{class:!0});var rT=T(ba);h(_i.$$.fragment,rT),e$=r(rT),ru=l(rT,"P",{"data-svelte-h":!0}),_(ru)!=="svelte-qvnpmr"&&(ru.innerHTML=zJ),rT.forEach(n),t$=r(te),_a=l(te,"DIV",{class:!0});var oT=T(_a);h(yi.$$.fragment,oT),s$=r(oT),ou=l(oT,"P",{"data-svelte-h":!0}),_(ou)!=="svelte-1tx1mox"&&(ou.innerHTML=VJ),oT.forEach(n),n$=r(te),lu=l(te,"DIV",{class:!0});var oZ=T(lu);h(Ti.$$.fragment,oZ),oZ.forEach(n),a$=r(te),ya=l(te,"DIV",{class:!0});var lT=T(ya);h(Mi.$$.fragment,lT),r$=r(lT),cu=l(lT,"P",{"data-svelte-h":!0}),_(cu)!=="svelte-114iuj0"&&(cu.textContent=GJ),lT.forEach(n),te.forEach(n),ly=r(e),O=l(e,"DIV",{class:!0});var Ke=T(O);h(vi.$$.fragment,Ke),o$=r(Ke),iu=l(Ke,"P",{"data-svelte-h":!0}),_(iu)!=="svelte-plgsbf"&&(iu.textContent=FJ),l$=r(Ke),h(Ta.$$.fragment,Ke),c$=r(Ke),du=l(Ke,"DIV",{class:!0});var lZ=T(du);h(wi.$$.fragment,lZ),lZ.forEach(n),i$=r(Ke),pu=l(Ke,"DIV",{class:!0});var cZ=T(pu);h(ki.$$.fragment,cZ),cZ.forEach(n),d$=r(Ke),mu=l(Ke,"DIV",{class:!0});var iZ=T(mu);h($i.$$.fragment,iZ),iZ.forEach(n),Ke.forEach(n),cy=r(e),h(ji.$$.fragment,e),iy=r(e),he=l(e,"DIV",{class:!0});var is=T(he);h(xi.$$.fragment,is),p$=r(is),hu=l(is,"P",{"data-svelte-h":!0}),_(hu)!=="svelte-8pa9bo"&&(hu.innerHTML=XJ),m$=r(is),gu=l(is,"P",{"data-svelte-h":!0}),_(gu)!=="svelte-1wzt57b"&&(gu.textContent=RJ),h$=r(is),uu=l(is,"UL",{"data-svelte-h":!0}),_(uu)!=="svelte-vgskhd"&&(uu.innerHTML=LJ),g$=r(is),Ma=l(is,"DIV",{class:!0});var cT=T(Ma);h(Ji.$$.fragment,cT),u$=r(cT),fu=l(cT,"P",{"data-svelte-h":!0}),_(fu)!=="svelte-1eed40t"&&(fu.textContent=SJ),cT.forEach(n),is.forEach(n),dy=r(e),ge=l(e,"DIV",{class:!0});var ds=T(ge);h(Ui.$$.fragment,ds),f$=r(ds),bu=l(ds,"P",{"data-svelte-h":!0}),_(bu)!=="svelte-17osgxw"&&(bu.innerHTML=NJ),b$=r(ds),_u=l(ds,"P",{"data-svelte-h":!0}),_(_u)!=="svelte-y9hsik"&&(_u.innerHTML=HJ),_$=r(ds),h(va.$$.fragment,ds),y$=r(ds),wa=l(ds,"DIV",{class:!0});var iT=T(wa);h(Zi.$$.fragment,iT),T$=r(iT),yu=l(iT,"P",{"data-svelte-h":!0}),_(yu)!=="svelte-8xv78e"&&(yu.textContent=EJ),iT.forEach(n),ds.forEach(n),py=r(e),Lt=l(e,"DIV",{class:!0});var ff=T(Lt);h(Ci.$$.fragment,ff),M$=r(ff),Tu=l(ff,"P",{"data-svelte-h":!0}),_(Tu)!=="svelte-1fls76z"&&(Tu.innerHTML=qJ),v$=r(ff),Mu=l(ff,"P",{"data-svelte-h":!0}),_(Mu)!=="svelte-o55m63"&&(Mu.innerHTML=QJ),ff.forEach(n),my=r(e),R=l(e,"DIV",{class:!0});var we=T(R);h(Wi.$$.fragment,we),w$=r(we),vu=l(we,"P",{"data-svelte-h":!0}),_(vu)!=="svelte-ti06z9"&&(vu.textContent=DJ),k$=r(we),wu=l(we,"P",{"data-svelte-h":!0}),_(wu)!=="svelte-vwtjd"&&(wu.innerHTML=YJ),$$=r(we),ku=l(we,"P",{"data-svelte-h":!0}),_(ku)!=="svelte-m9ljkx"&&(ku.textContent=PJ),j$=r(we),$u=l(we,"P",{"data-svelte-h":!0}),_($u)!=="svelte-6pahdo"&&($u.innerHTML=AJ),x$=r(we),ju=l(we,"P",{"data-svelte-h":!0}),_(ju)!=="svelte-hswkmf"&&(ju.innerHTML=OJ),J$=r(we),ka=l(we,"DIV",{class:!0});var dT=T(ka);h(Bi.$$.fragment,dT),U$=r(dT),xu=l(dT,"P",{"data-svelte-h":!0}),_(xu)!=="svelte-1pf58kz"&&(xu.textContent=KJ),dT.forEach(n),we.forEach(n),hy=r(e),St=l(e,"DIV",{class:!0});var bf=T(St);h(Ii.$$.fragment,bf),Z$=r(bf),Ju=l(bf,"P",{"data-svelte-h":!0}),_(Ju)!=="svelte-1hdm2wz"&&(Ju.innerHTML=eU),C$=r(bf),h($a.$$.fragment,bf),bf.forEach(n),gy=r(e),ue=l(e,"DIV",{class:!0});var ps=T(ue);h(zi.$$.fragment,ps),W$=r(ps),Uu=l(ps,"P",{"data-svelte-h":!0}),_(Uu)!=="svelte-8dvois"&&(Uu.textContent=tU),B$=r(ps),Zu=l(ps,"P",{"data-svelte-h":!0}),_(Zu)!=="svelte-1xpqz8m"&&(Zu.textContent=sU),I$=r(ps),h(ja.$$.fragment,ps),z$=r(ps),Cu=l(ps,"DIV",{class:!0});var dZ=T(Cu);h(Vi.$$.fragment,dZ),dZ.forEach(n),ps.forEach(n),uy=r(e),h(Gi.$$.fragment,e),fy=r(e),_f=l(e,"P",{}),T(_f).forEach(n),this.h()},h(){M(c,"name","hf:doc:metadata"),M(c,"content",bC),M(ms,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(hs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(us,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ys,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ts,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ms,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ws,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ks,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Is,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Cd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ld,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ed,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Dd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Pd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Od,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ep,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(sp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ap,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(cp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ip,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Rp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Np,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Yp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ap,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Kp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(nm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(im,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(hm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(um,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ym,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Um,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Lm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Nm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Em,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ym,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Om,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Km,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(js,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(th,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(nh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(It,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($h,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Js,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Dh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Oh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Kh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(sg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(In,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(En,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(qn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(On,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Kn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ea,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ta,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(sa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(na,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ra,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(oa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(la,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ia,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(da,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Dg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Yg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ha,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(su,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ba,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_a,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ya,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(du,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ma,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ka,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(St,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Cu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,c),p(e,$,i),p(e,y,i),p(e,d,i),g(w,e,i),p(e,s,i),p(e,k,i),p(e,zf,i),g(Ga,e,i),p(e,Vf,i),p(e,Fa,i),p(e,Gf,i),p(e,Xa,i),p(e,Ff,i),g(Ra,e,i),p(e,Xf,i),p(e,La,i),p(e,Rf,i),p(e,Sa,i),p(e,Lf,i),p(e,Na,i),p(e,Sf,i),p(e,Ha,i),p(e,Nf,i),p(e,Ea,i),p(e,Hf,i),g(qa,e,i),p(e,Ef,i),p(e,Qa,i),p(e,qf,i),p(e,Da,i),p(e,Qf,i),p(e,Ya,i),p(e,Df,i),g(Pa,e,i),p(e,Yf,i),p(e,ms,i),g(Aa,ms,null),t(ms,pT),t(ms,td),p(e,Pf,i),p(e,hs,i),g(Oa,hs,null),t(hs,mT),t(hs,sd),p(e,Af,i),p(e,gs,i),g(Ka,gs,null),t(gs,hT),t(gs,nd),p(e,Of,i),p(e,us,i),g(er,us,null),t(us,gT),t(us,ad),p(e,Kf,i),g(tr,e,i),p(e,eb,i),p(e,fs,i),g(sr,fs,null),t(fs,uT),t(fs,rd),p(e,tb,i),p(e,bs,i),g(nr,bs,null),t(bs,fT),t(bs,od),p(e,sb,i),p(e,_s,i),g(ar,_s,null),t(_s,bT),t(_s,ld),p(e,nb,i),p(e,ys,i),g(rr,ys,null),t(ys,_T),t(ys,cd),p(e,ab,i),p(e,Ts,i),g(or,Ts,null),t(Ts,yT),t(Ts,id),p(e,rb,i),p(e,Ms,i),g(lr,Ms,null),t(Ms,TT),t(Ms,dd),p(e,ob,i),p(e,vs,i),g(cr,vs,null),t(vs,MT),t(vs,pd),p(e,lb,i),p(e,ws,i),g(ir,ws,null),t(ws,vT),t(ws,md),p(e,cb,i),p(e,ks,i),g(dr,ks,null),t(ks,wT),t(ks,hd),p(e,ib,i),p(e,$s,i),g(pr,$s,null),t($s,kT),t($s,gd),p(e,db,i),g(mr,e,i),p(e,pb,i),p(e,et,i),g(hr,et,null),t(et,$T),t(et,ud),t(et,jT),t(et,Is),g(gr,Is,null),t(Is,xT),t(Is,fd),p(e,mb,i),p(e,tt,i),g(ur,tt,null),t(tt,JT),t(tt,bd),t(tt,UT),t(tt,zs),g(fr,zs,null),t(zs,ZT),t(zs,_d),p(e,hb,i),p(e,st,i),g(br,st,null),t(st,CT),t(st,yd),t(st,WT),t(st,Vs),g(_r,Vs,null),t(Vs,BT),t(Vs,Td),p(e,gb,i),g(yr,e,i),p(e,ub,i),p(e,Tr,i),p(e,fb,i),g(Mr,e,i),p(e,bb,i),p(e,ke,i),g(vr,ke,null),t(ke,IT),t(ke,Md),t(ke,zT),g(Gs,ke,null),t(ke,VT),t(ke,vd),g(wr,vd,null),p(e,_b,i),p(e,S,i),g(kr,S,null),t(S,GT),t(S,wd),t(S,FT),t(S,kd),t(S,XT),g(Fs,S,null),t(S,RT),g(Xs,S,null),t(S,LT),t(S,$d),g($r,$d,null),p(e,yb,i),p(e,se,i),g(jr,se,null),t(se,ST),t(se,jd),t(se,NT),t(se,xd),t(se,HT),g(Rs,se,null),t(se,ET),t(se,Jd),g(xr,Jd,null),p(e,Tb,i),p(e,ne,i),g(Jr,ne,null),t(ne,qT),t(ne,Ud),t(ne,QT),t(ne,Zd),t(ne,DT),g(Ls,ne,null),t(ne,YT),t(ne,Cd),g(Ur,Cd,null),p(e,Mb,i),p(e,$e,i),g(Zr,$e,null),t($e,PT),t($e,Wd),t($e,AT),g(Ss,$e,null),t($e,OT),t($e,Bd),g(Cr,Bd,null),p(e,vb,i),p(e,je,i),g(Wr,je,null),t(je,KT),t(je,Id),t(je,eM),g(Ns,je,null),t(je,tM),t(je,zd),g(Br,zd,null),p(e,wb,i),p(e,xe,i),g(Ir,xe,null),t(xe,sM),t(xe,Vd),t(xe,nM),g(Hs,xe,null),t(xe,aM),t(xe,Gd),g(zr,Gd,null),p(e,kb,i),p(e,Je,i),g(Vr,Je,null),t(Je,rM),t(Je,Fd),t(Je,oM),g(Es,Je,null),t(Je,lM),t(Je,Xd),g(Gr,Xd,null),p(e,$b,i),p(e,Ue,i),g(Fr,Ue,null),t(Ue,cM),t(Ue,Rd),t(Ue,iM),g(qs,Ue,null),t(Ue,dM),t(Ue,Ld),g(Xr,Ld,null),p(e,jb,i),p(e,N,i),g(Rr,N,null),t(N,pM),t(N,Sd),t(N,mM),t(N,Nd),t(N,hM),t(N,Hd),t(N,gM),g(Qs,N,null),t(N,uM),t(N,Ed),g(Lr,Ed,null),p(e,xb,i),p(e,Ze,i),g(Sr,Ze,null),t(Ze,fM),t(Ze,qd),t(Ze,bM),t(Ze,Qd),t(Ze,_M),t(Ze,Dd),g(Nr,Dd,null),p(e,Jb,i),p(e,Ce,i),g(Hr,Ce,null),t(Ce,yM),t(Ce,Yd),t(Ce,TM),g(Ds,Ce,null),t(Ce,MM),t(Ce,Pd),g(Er,Pd,null),p(e,Ub,i),p(e,nt,i),g(qr,nt,null),t(nt,vM),t(nt,Ad),t(nt,wM),t(nt,Od),g(Qr,Od,null),p(e,Zb,i),p(e,at,i),g(Dr,at,null),t(at,kM),t(at,Kd),t(at,$M),t(at,ep),g(Yr,ep,null),p(e,Cb,i),p(e,We,i),g(Pr,We,null),t(We,jM),t(We,tp),t(We,xM),g(Ys,We,null),t(We,JM),t(We,sp),g(Ar,sp,null),p(e,Wb,i),p(e,Be,i),g(Or,Be,null),t(Be,UM),t(Be,np),t(Be,ZM),g(Ps,Be,null),t(Be,CM),t(Be,ap),g(Kr,ap,null),p(e,Bb,i),p(e,H,i),g(eo,H,null),t(H,WM),t(H,rp),t(H,BM),t(H,op),t(H,IM),t(H,lp),t(H,zM),g(As,H,null),t(H,VM),t(H,cp),g(to,cp,null),p(e,Ib,i),p(e,ae,i),g(so,ae,null),t(ae,GM),t(ae,ip),t(ae,FM),g(Os,ae,null),t(ae,XM),g(Ks,ae,null),t(ae,RM),t(ae,dp),g(no,dp,null),p(e,zb,i),p(e,re,i),g(ao,re,null),t(re,LM),t(re,pp),t(re,SM),g(en,re,null),t(re,NM),g(tn,re,null),t(re,HM),t(re,mp),g(ro,mp,null),p(e,Vb,i),p(e,Ie,i),g(oo,Ie,null),t(Ie,EM),t(Ie,hp),t(Ie,qM),g(sn,Ie,null),t(Ie,QM),t(Ie,gp),g(lo,gp,null),p(e,Gb,i),p(e,oe,i),g(co,oe,null),t(oe,DM),t(oe,up),t(oe,YM),t(oe,fp),t(oe,PM),g(nn,oe,null),t(oe,AM),t(oe,bp),g(io,bp,null),p(e,Fb,i),p(e,le,i),g(po,le,null),t(le,OM),t(le,_p),t(le,KM),g(an,le,null),t(le,ev),g(rn,le,null),t(le,tv),t(le,yp),g(mo,yp,null),p(e,Xb,i),p(e,ze,i),g(ho,ze,null),t(ze,sv),t(ze,Tp),t(ze,nv),g(on,ze,null),t(ze,av),t(ze,Mp),g(go,Mp,null),p(e,Rb,i),p(e,Ve,i),g(uo,Ve,null),t(Ve,rv),t(Ve,vp),t(Ve,ov),g(ln,Ve,null),t(Ve,lv),t(Ve,wp),g(fo,wp,null),p(e,Lb,i),p(e,G,i),g(bo,G,null),t(G,cv),t(G,kp),t(G,iv),t(G,$p),t(G,dv),t(G,jp),t(G,pv),t(G,xp),t(G,mv),g(cn,G,null),t(G,hv),t(G,Jp),g(_o,Jp,null),p(e,Sb,i),p(e,ce,i),g(yo,ce,null),t(ce,gv),t(ce,Up),t(ce,uv),g(dn,ce,null),t(ce,fv),g(pn,ce,null),t(ce,bv),t(ce,Zp),g(To,Zp,null),p(e,Nb,i),p(e,Ge,i),g(Mo,Ge,null),t(Ge,_v),t(Ge,Cp),t(Ge,yv),g(mn,Ge,null),t(Ge,Tv),t(Ge,Wp),g(vo,Wp,null),p(e,Hb,i),p(e,Fe,i),g(wo,Fe,null),t(Fe,Mv),t(Fe,Bp),t(Fe,vv),g(hn,Fe,null),t(Fe,wv),t(Fe,Ip),g(ko,Ip,null),p(e,Eb,i),p(e,ie,i),g($o,ie,null),t(ie,kv),t(ie,zp),t(ie,$v),t(ie,Vp),t(ie,jv),g(gn,ie,null),t(ie,xv),t(ie,Gp),g(jo,Gp,null),p(e,qb,i),p(e,de,i),g(xo,de,null),t(de,Jv),t(de,Fp),t(de,Uv),t(de,Xp),t(de,Zv),g(un,de,null),t(de,Cv),t(de,Rp),g(Jo,Rp,null),p(e,Qb,i),p(e,pe,i),g(Uo,pe,null),t(pe,Wv),t(pe,Lp),t(pe,Bv),t(pe,Sp),t(pe,Iv),g(fn,pe,null),t(pe,zv),t(pe,Np),g(Zo,Np,null),p(e,Db,i),p(e,E,i),g(Co,E,null),t(E,Vv),t(E,Hp),t(E,Gv),t(E,Ep),t(E,Fv),t(E,qp),t(E,Xv),g(bn,E,null),t(E,Rv),t(E,Qp),g(Wo,Qp,null),p(e,Yb,i),g(Bo,e,i),p(e,Pb,i),p(e,rt,i),g(Io,rt,null),t(rt,Lv),t(rt,Dp),t(rt,Sv),t(rt,Yp),g(zo,Yp,null),p(e,Ab,i),p(e,ot,i),g(Vo,ot,null),t(ot,Nv),t(ot,Pp),t(ot,Hv),t(ot,Ap),g(Go,Ap,null),p(e,Ob,i),p(e,lt,i),g(Fo,lt,null),t(lt,Ev),t(lt,Op),t(lt,qv),t(lt,Kp),g(Xo,Kp,null),p(e,Kb,i),p(e,ct,i),g(Ro,ct,null),t(ct,Qv),t(ct,em),t(ct,Dv),t(ct,_n),g(Lo,_n,null),t(_n,Yv),t(_n,tm),p(e,e_,i),p(e,it,i),g(So,it,null),t(it,Pv),t(it,sm),t(it,Av),t(it,nm),g(No,nm,null),p(e,t_,i),p(e,dt,i),g(Ho,dt,null),t(dt,Ov),t(dt,am),t(dt,Kv),t(dt,yn),g(Eo,yn,null),t(yn,ew),t(yn,rm),p(e,s_,i),p(e,pt,i),g(qo,pt,null),t(pt,tw),t(pt,om),t(pt,sw),t(pt,lm),g(Qo,lm,null),p(e,n_,i),p(e,mt,i),g(Do,mt,null),t(mt,nw),t(mt,cm),t(mt,aw),t(mt,im),g(Yo,im,null),p(e,a_,i),p(e,ht,i),g(Po,ht,null),t(ht,rw),t(ht,dm),t(ht,ow),t(ht,pm),g(Ao,pm,null),p(e,r_,i),p(e,gt,i),g(Oo,gt,null),t(gt,lw),t(gt,mm),t(gt,cw),t(gt,hm),g(Ko,hm,null),p(e,o_,i),p(e,ut,i),g(el,ut,null),t(ut,iw),t(ut,gm),t(ut,dw),t(ut,um),g(tl,um,null),p(e,l_,i),p(e,ft,i),g(sl,ft,null),t(ft,pw),t(ft,fm),t(ft,mw),t(ft,bm),g(nl,bm,null),p(e,c_,i),p(e,bt,i),g(al,bt,null),t(bt,hw),t(bt,_m),t(bt,gw),t(bt,ym),g(rl,ym,null),p(e,i_,i),p(e,_t,i),g(ol,_t,null),t(_t,uw),t(_t,Tm),t(_t,fw),t(_t,Mm),g(ll,Mm,null),p(e,d_,i),p(e,yt,i),g(cl,yt,null),t(yt,bw),t(yt,vm),t(yt,_w),t(yt,wm),g(il,wm,null),p(e,p_,i),g(dl,e,i),p(e,m_,i),p(e,Tt,i),g(pl,Tt,null),t(Tt,yw),t(Tt,km),t(Tt,Tw),t(Tt,$m),g(ml,$m,null),p(e,h_,i),p(e,Mt,i),g(hl,Mt,null),t(Mt,Mw),t(Mt,jm),t(Mt,vw),t(Mt,xm),g(gl,xm,null),p(e,g_,i),p(e,vt,i),g(ul,vt,null),t(vt,ww),t(vt,Jm),t(vt,kw),t(vt,Um),g(fl,Um,null),p(e,u_,i),p(e,wt,i),g(bl,wt,null),t(wt,$w),t(wt,Zm),t(wt,jw),t(wt,Tn),g(_l,Tn,null),t(Tn,xw),t(Tn,Cm),p(e,f_,i),p(e,kt,i),g(yl,kt,null),t(kt,Jw),t(kt,Wm),t(kt,Uw),t(kt,Bm),g(Tl,Bm,null),p(e,b_,i),p(e,$t,i),g(Ml,$t,null),t($t,Zw),t($t,Im),t($t,Cw),t($t,Mn),g(vl,Mn,null),t(Mn,Ww),t(Mn,zm),p(e,__,i),p(e,jt,i),g(wl,jt,null),t(jt,Bw),t(jt,Vm),t(jt,Iw),t(jt,Gm),g(kl,Gm,null),p(e,y_,i),p(e,xt,i),g($l,xt,null),t(xt,zw),t(xt,Fm),t(xt,Vw),t(xt,Xm),g(jl,Xm,null),p(e,T_,i),p(e,Jt,i),g(xl,Jt,null),t(Jt,Gw),t(Jt,Rm),t(Jt,Fw),t(Jt,Lm),g(Jl,Lm,null),p(e,M_,i),p(e,Ut,i),g(Ul,Ut,null),t(Ut,Xw),t(Ut,Sm),t(Ut,Rw),t(Ut,Nm),g(Zl,Nm,null),p(e,v_,i),p(e,Zt,i),g(Cl,Zt,null),t(Zt,Lw),t(Zt,Hm),t(Zt,Sw),t(Zt,Em),g(Wl,Em,null),p(e,w_,i),p(e,Ct,i),g(Bl,Ct,null),t(Ct,Nw),t(Ct,qm),t(Ct,Hw),t(Ct,Qm),g(Il,Qm,null),p(e,k_,i),p(e,Wt,i),g(zl,Wt,null),t(Wt,Ew),t(Wt,Dm),t(Wt,qw),t(Wt,Ym),g(Vl,Ym,null),p(e,$_,i),g(Gl,e,i),p(e,j_,i),p(e,Fl,i),p(e,x_,i),p(e,Xe,i),g(Xl,Xe,null),t(Xe,Qw),t(Xe,Pm),t(Xe,Dw),t(Xe,Am),t(Xe,Yw),t(Xe,Om),g(Rl,Om,null),p(e,J_,i),p(e,js,i),g(Ll,js,null),t(js,Pw),t(js,Km),g(Sl,Km,null),p(e,U_,i),p(e,Bt,i),g(Nl,Bt,null),t(Bt,Aw),t(Bt,eh),t(Bt,Ow),t(Bt,th),g(Hl,th,null),p(e,Z_,i),p(e,It,i),g(El,It,null),t(It,Kw),t(It,sh),t(It,e2),t(It,nh),g(ql,nh,null),p(e,C_,i),p(e,J,i),g(Ql,J,null),t(J,t2),t(J,ah),t(J,s2),t(J,rh),t(J,n2),t(J,oh),t(J,a2),t(J,lh),t(J,r2),t(J,ch),t(J,o2),t(J,ih),t(J,l2),t(J,dh),t(J,c2),t(J,ph),t(J,i2),t(J,mh),t(J,d2),t(J,hh),t(J,p2),t(J,gh),t(J,m2),t(J,uh),t(J,h2),t(J,fh),t(J,g2),t(J,bh),t(J,u2),t(J,_h),t(J,f2),t(J,yh),t(J,b2),t(J,Th),t(J,_2),t(J,Mh),t(J,y2),t(J,vh),t(J,T2),g(vn,J,null),t(J,M2),t(J,wh),g(Dl,wh,null),p(e,W_,i),p(e,zt,i),g(Yl,zt,null),t(zt,v2),t(zt,kh),t(zt,w2),t(zt,$h),g(Pl,$h,null),p(e,B_,i),g(Al,e,i),p(e,I_,i),p(e,Ol,i),p(e,z_,i),p(e,W,i),g(Kl,W,null),t(W,k2),t(W,jh),t(W,$2),t(W,xh),t(W,j2),g(wn,W,null),t(W,x2),t(W,Jh),t(W,J2),t(W,kn),g(ec,kn,null),t(kn,U2),t(kn,Uh),t(W,Z2),t(W,$n),g(tc,$n,null),t($n,C2),t($n,Zh),t(W,W2),t(W,jn),g(sc,jn,null),t(jn,B2),t(jn,Ch),t(W,I2),t(W,xn),g(nc,xn,null),t(xn,z2),t(xn,Wh),t(W,V2),t(W,Jn),g(ac,Jn,null),t(Jn,G2),t(Jn,Bh),t(W,F2),t(W,Un),g(rc,Un,null),t(Un,X2),t(Un,Ih),t(W,R2),t(W,Kt),g(oc,Kt,null),t(Kt,L2),t(Kt,zh),t(Kt,S2),t(Kt,Vh),p(e,V_,i),p(e,xs,i),g(lc,xs,null),t(xs,N2),t(xs,Gh),p(e,G_,i),p(e,Js,i),g(cc,Js,null),t(Js,H2),t(Js,Fh),p(e,F_,i),p(e,Re,i),g(ic,Re,null),t(Re,E2),t(Re,Xh),t(Re,q2),t(Re,K),g(dc,K,null),t(K,Q2),t(K,Rh),t(K,D2),t(K,Lh),t(K,Y2),t(K,Sh),t(K,P2),t(K,Nh),t(K,A2),t(K,Hh),t(Re,O2),t(Re,Zn),g(pc,Zn,null),t(Zn,K2),t(Zn,Eh),p(e,X_,i),g(mc,e,i),p(e,R_,i),p(e,Le,i),g(hc,Le,null),t(Le,e1),t(Le,qh),t(Le,t1),t(Le,Qh),g(gc,Qh,null),t(Le,s1),t(Le,Dh),g(uc,Dh,null),p(e,L_,i),p(e,q,i),g(fc,q,null),t(q,n1),t(q,Yh),t(q,a1),t(q,Ph),t(q,r1),t(q,Ah),t(q,o1),t(q,Oh),g(bc,Oh,null),t(q,l1),t(q,Kh),g(_c,Kh,null),p(e,S_,i),p(e,Se,i),g(yc,Se,null),t(Se,c1),t(Se,eg),t(Se,i1),t(Se,tg),g(Tc,tg,null),t(Se,d1),t(Se,sg),g(Mc,sg,null),p(e,N_,i),g(vc,e,i),p(e,H_,i),p(e,F,i),g(wc,F,null),t(F,p1),t(F,ng),t(F,m1),g(Cn,F,null),t(F,h1),g(Wn,F,null),t(F,g1),t(F,Bn),g(kc,Bn,null),t(Bn,u1),t(Bn,ag),t(F,f1),t(F,In),g($c,In,null),t(In,b1),t(In,rg),t(F,_1),t(F,zn),g(jc,zn,null),t(zn,y1),t(zn,og),p(e,E_,i),p(e,me,i),g(xc,me,null),t(me,T1),t(me,lg),t(me,M1),g(Vn,me,null),t(me,v1),g(Gn,me,null),t(me,w1),t(me,Fn),g(Jc,Fn,null),t(Fn,k1),t(Fn,cg),p(e,q_,i),g(Uc,e,i),p(e,Q_,i),p(e,Vt,i),g(Zc,Vt,null),t(Vt,$1),t(Vt,ig),t(Vt,j1),t(Vt,Xn),g(Cc,Xn,null),t(Xn,x1),t(Xn,dg),p(e,D_,i),p(e,Gt,i),g(Wc,Gt,null),t(Gt,J1),t(Gt,pg),t(Gt,U1),t(Gt,Rn),g(Bc,Rn,null),t(Rn,Z1),t(Rn,mg),p(e,Y_,i),p(e,Ft,i),g(Ic,Ft,null),t(Ft,C1),t(Ft,hg),t(Ft,W1),t(Ft,Ln),g(zc,Ln,null),t(Ln,B1),t(Ln,gg),p(e,P_,i),p(e,I,i),g(Vc,I,null),t(I,I1),t(I,ug),t(I,z1),t(I,fg),t(I,V1),g(Sn,I,null),t(I,G1),t(I,Nn),g(Gc,Nn,null),t(Nn,F1),t(Nn,bg),t(I,X1),t(I,Hn),g(Fc,Hn,null),t(Hn,R1),t(Hn,_g),t(I,L1),t(I,En),g(Xc,En,null),t(En,S1),t(En,yg),t(I,N1),t(I,qn),g(Rc,qn,null),t(qn,H1),t(qn,Tg),t(I,E1),t(I,Qn),g(Lc,Qn,null),t(Qn,q1),t(Qn,Mg),p(e,A_,i),p(e,Q,i),g(Sc,Q,null),t(Q,Q1),t(Q,vg),t(Q,D1),t(Q,wg),t(Q,Y1),t(Q,kg),t(Q,P1),t(Q,$g),g(Nc,$g,null),t(Q,A1),t(Q,Dn),g(Hc,Dn,null),t(Dn,O1),t(Dn,jg),p(e,O_,i),p(e,Xt,i),g(Ec,Xt,null),t(Xt,K1),t(Xt,xg),t(Xt,ek),g(Yn,Xt,null),p(e,K_,i),p(e,Rt,i),g(qc,Rt,null),t(Rt,tk),t(Rt,Jg),t(Rt,sk),g(Pn,Rt,null),p(e,ey,i),p(e,X,i),g(Qc,X,null),t(X,nk),t(X,Ug),t(X,ak),t(X,Zg),t(X,rk),g(An,X,null),t(X,ok),t(X,On),g(Dc,On,null),t(On,lk),t(On,Cg),t(X,ck),t(X,Kn),g(Yc,Kn,null),t(Kn,ik),t(Kn,Wg),t(X,dk),t(X,ea),g(Pc,ea,null),t(ea,pk),t(ea,Bg),p(e,ty,i),p(e,D,i),g(Ac,D,null),t(D,mk),t(D,Ig),t(D,hk),t(D,zg),t(D,gk),t(D,ta),g(Oc,ta,null),t(ta,uk),t(ta,Vg),t(D,fk),t(D,sa),g(Kc,sa,null),t(sa,bk),t(sa,Gg),t(D,_k),t(D,na),g(ei,na,null),t(na,yk),t(na,Fg),p(e,sy,i),p(e,Y,i),g(ti,Y,null),t(Y,Tk),t(Y,Xg),t(Y,Mk),g(aa,Y,null),t(Y,vk),t(Y,ra),g(si,ra,null),t(ra,wk),t(ra,Rg),t(Y,kk),t(Y,oa),g(ni,oa,null),t(oa,$k),t(oa,Lg),t(Y,jk),t(Y,la),g(ai,la,null),t(la,xk),t(la,Sg),p(e,ny,i),p(e,P,i),g(ri,P,null),t(P,Jk),t(P,Ng),t(P,Uk),g(ca,P,null),t(P,Zk),t(P,ia),g(oi,ia,null),t(ia,Ck),t(ia,Hg),t(P,Wk),t(P,da),g(li,da,null),t(da,Bk),t(da,Eg),t(P,Ik),t(P,pa),g(ci,pa,null),t(pa,zk),t(pa,qg),p(e,ay,i),p(e,A,i),g(ii,A,null),t(A,Vk),t(A,Qg),t(A,Gk),g(ma,A,null),t(A,Fk),t(A,Dg),g(di,Dg,null),t(A,Xk),t(A,Yg),g(pi,Yg,null),t(A,Rk),t(A,ha),g(mi,ha,null),t(ha,Lk),t(ha,Pg),p(e,ry,i),p(e,z,i),g(hi,z,null),t(z,Sk),t(z,Ag),t(z,Nk),t(z,Og),t(z,Hk),t(z,Kg),t(z,Ek),t(z,eu),t(z,qk),g(ga,z,null),t(z,Qk),t(z,tu),g(gi,tu,null),t(z,Dk),t(z,su),g(ui,su,null),p(e,oy,i),p(e,V,i),g(fi,V,null),t(V,Yk),t(V,nu),t(V,Pk),g(ua,V,null),t(V,Ak),t(V,fa),g(bi,fa,null),t(fa,Ok),t(fa,au),t(V,Kk),t(V,ba),g(_i,ba,null),t(ba,e$),t(ba,ru),t(V,t$),t(V,_a),g(yi,_a,null),t(_a,s$),t(_a,ou),t(V,n$),t(V,lu),g(Ti,lu,null),t(V,a$),t(V,ya),g(Mi,ya,null),t(ya,r$),t(ya,cu),p(e,ly,i),p(e,O,i),g(vi,O,null),t(O,o$),t(O,iu),t(O,l$),g(Ta,O,null),t(O,c$),t(O,du),g(wi,du,null),t(O,i$),t(O,pu),g(ki,pu,null),t(O,d$),t(O,mu),g($i,mu,null),p(e,cy,i),g(ji,e,i),p(e,iy,i),p(e,he,i),g(xi,he,null),t(he,p$),t(he,hu),t(he,m$),t(he,gu),t(he,h$),t(he,uu),t(he,g$),t(he,Ma),g(Ji,Ma,null),t(Ma,u$),t(Ma,fu),p(e,dy,i),p(e,ge,i),g(Ui,ge,null),t(ge,f$),t(ge,bu),t(ge,b$),t(ge,_u),t(ge,_$),g(va,ge,null),t(ge,y$),t(ge,wa),g(Zi,wa,null),t(wa,T$),t(wa,yu),p(e,py,i),p(e,Lt,i),g(Ci,Lt,null),t(Lt,M$),t(Lt,Tu),t(Lt,v$),t(Lt,Mu),p(e,my,i),p(e,R,i),g(Wi,R,null),t(R,w$),t(R,vu),t(R,k$),t(R,wu),t(R,$$),t(R,ku),t(R,j$),t(R,$u),t(R,x$),t(R,ju),t(R,J$),t(R,ka),g(Bi,ka,null),t(ka,U$),t(ka,xu),p(e,hy,i),p(e,St,i),g(Ii,St,null),t(St,Z$),t(St,Ju),t(St,C$),g($a,St,null),p(e,gy,i),p(e,ue,i),g(zi,ue,null),t(ue,W$),t(ue,Uu),t(ue,B$),t(ue,Zu),t(ue,I$),g(ja,ue,null),t(ue,z$),t(ue,Cu),g(Vi,Cu,null),p(e,uy,i),g(Gi,e,i),p(e,fy,i),p(e,_f,i),by=!0},p(e,[i]){const Fi={};i&2&&(Fi.$$scope={dirty:i,ctx:e}),Gs.$set(Fi);const Xi={};i&2&&(Xi.$$scope={dirty:i,ctx:e}),Fs.$set(Xi);const Ri={};i&2&&(Ri.$$scope={dirty:i,ctx:e}),Xs.$set(Ri);const Li={};i&2&&(Li.$$scope={dirty:i,ctx:e}),Rs.$set(Li);const Si={};i&2&&(Si.$$scope={dirty:i,ctx:e}),Ls.$set(Si);const Ni={};i&2&&(Ni.$$scope={dirty:i,ctx:e}),Ss.$set(Ni);const Hi={};i&2&&(Hi.$$scope={dirty:i,ctx:e}),Ns.$set(Hi);const Ei={};i&2&&(Ei.$$scope={dirty:i,ctx:e}),Hs.$set(Ei);const qi={};i&2&&(qi.$$scope={dirty:i,ctx:e}),Es.$set(qi);const Qi={};i&2&&(Qi.$$scope={dirty:i,ctx:e}),qs.$set(Qi);const Di={};i&2&&(Di.$$scope={dirty:i,ctx:e}),Qs.$set(Di);const Yi={};i&2&&(Yi.$$scope={dirty:i,ctx:e}),Ds.$set(Yi);const Pi={};i&2&&(Pi.$$scope={dirty:i,ctx:e}),Ys.$set(Pi);const Ai={};i&2&&(Ai.$$scope={dirty:i,ctx:e}),Ps.$set(Ai);const Us={};i&2&&(Us.$$scope={dirty:i,ctx:e}),As.$set(Us);const Oi={};i&2&&(Oi.$$scope={dirty:i,ctx:e}),Os.$set(Oi);const Zs={};i&2&&(Zs.$$scope={dirty:i,ctx:e}),Ks.$set(Zs);const Ki={};i&2&&(Ki.$$scope={dirty:i,ctx:e}),en.$set(Ki);const Cs={};i&2&&(Cs.$$scope={dirty:i,ctx:e}),tn.$set(Cs);const ed={};i&2&&(ed.$$scope={dirty:i,ctx:e}),sn.$set(ed);const Nt={};i&2&&(Nt.$$scope={dirty:i,ctx:e}),nn.$set(Nt);const yf={};i&2&&(yf.$$scope={dirty:i,ctx:e}),an.$set(yf);const fe={};i&2&&(fe.$$scope={dirty:i,ctx:e}),rn.$set(fe);const Tf={};i&2&&(Tf.$$scope={dirty:i,ctx:e}),on.$set(Tf);const Ne={};i&2&&(Ne.$$scope={dirty:i,ctx:e}),ln.$set(Ne);const Mf={};i&2&&(Mf.$$scope={dirty:i,ctx:e}),cn.$set(Mf);const He={};i&2&&(He.$$scope={dirty:i,ctx:e}),dn.$set(He);const vf={};i&2&&(vf.$$scope={dirty:i,ctx:e}),pn.$set(vf);const Ht={};i&2&&(Ht.$$scope={dirty:i,ctx:e}),mn.$set(Ht);const wf={};i&2&&(wf.$$scope={dirty:i,ctx:e}),hn.$set(wf);const Et={};i&2&&(Et.$$scope={dirty:i,ctx:e}),gn.$set(Et);const kf={};i&2&&(kf.$$scope={dirty:i,ctx:e}),un.$set(kf);const qt={};i&2&&(qt.$$scope={dirty:i,ctx:e}),fn.$set(qt);const $f={};i&2&&($f.$$scope={dirty:i,ctx:e}),bn.$set($f);const Qt={};i&2&&(Qt.$$scope={dirty:i,ctx:e}),vn.$set(Qt);const jf={};i&2&&(jf.$$scope={dirty:i,ctx:e}),wn.$set(jf);const Dt={};i&2&&(Dt.$$scope={dirty:i,ctx:e}),Cn.$set(Dt);const xf={};i&2&&(xf.$$scope={dirty:i,ctx:e}),Wn.$set(xf);const be={};i&2&&(be.$$scope={dirty:i,ctx:e}),Vn.$set(be);const Jf={};i&2&&(Jf.$$scope={dirty:i,ctx:e}),Gn.$set(Jf);const Yt={};i&2&&(Yt.$$scope={dirty:i,ctx:e}),Sn.$set(Yt);const Uf={};i&2&&(Uf.$$scope={dirty:i,ctx:e}),Yn.$set(Uf);const Pt={};i&2&&(Pt.$$scope={dirty:i,ctx:e}),Pn.$set(Pt);const Zf={};i&2&&(Zf.$$scope={dirty:i,ctx:e}),An.$set(Zf);const Ws={};i&2&&(Ws.$$scope={dirty:i,ctx:e}),aa.$set(Ws);const Cf={};i&2&&(Cf.$$scope={dirty:i,ctx:e}),ca.$set(Cf);const Bs={};i&2&&(Bs.$$scope={dirty:i,ctx:e}),ma.$set(Bs);const Wf={};i&2&&(Wf.$$scope={dirty:i,ctx:e}),ga.$set(Wf);const At={};i&2&&(At.$$scope={dirty:i,ctx:e}),ua.$set(At);const Bf={};i&2&&(Bf.$$scope={dirty:i,ctx:e}),Ta.$set(Bf);const Ot={};i&2&&(Ot.$$scope={dirty:i,ctx:e}),va.$set(Ot);const If={};i&2&&(If.$$scope={dirty:i,ctx:e}),$a.$set(If);const _e={};i&2&&(_e.$$scope={dirty:i,ctx:e}),ja.$set(_e)},i(e){by||(u(w.$$.fragment,e),u(Ga.$$.fragment,e),u(Ra.$$.fragment,e),u(qa.$$.fragment,e),u(Pa.$$.fragment,e),u(Aa.$$.fragment,e),u(Oa.$$.fragment,e),u(Ka.$$.fragment,e),u(er.$$.fragment,e),u(tr.$$.fragment,e),u(sr.$$.fragment,e),u(nr.$$.fragment,e),u(ar.$$.fragment,e),u(rr.$$.fragment,e),u(or.$$.fragment,e),u(lr.$$.fragment,e),u(cr.$$.fragment,e),u(ir.$$.fragment,e),u(dr.$$.fragment,e),u(pr.$$.fragment,e),u(mr.$$.fragment,e),u(hr.$$.fragment,e),u(gr.$$.fragment,e),u(ur.$$.fragment,e),u(fr.$$.fragment,e),u(br.$$.fragment,e),u(_r.$$.fragment,e),u(yr.$$.fragment,e),u(Mr.$$.fragment,e),u(vr.$$.fragment,e),u(Gs.$$.fragment,e),u(wr.$$.fragment,e),u(kr.$$.fragment,e),u(Fs.$$.fragment,e),u(Xs.$$.fragment,e),u($r.$$.fragment,e),u(jr.$$.fragment,e),u(Rs.$$.fragment,e),u(xr.$$.fragment,e),u(Jr.$$.fragment,e),u(Ls.$$.fragment,e),u(Ur.$$.fragment,e),u(Zr.$$.fragment,e),u(Ss.$$.fragment,e),u(Cr.$$.fragment,e),u(Wr.$$.fragment,e),u(Ns.$$.fragment,e),u(Br.$$.fragment,e),u(Ir.$$.fragment,e),u(Hs.$$.fragment,e),u(zr.$$.fragment,e),u(Vr.$$.fragment,e),u(Es.$$.fragment,e),u(Gr.$$.fragment,e),u(Fr.$$.fragment,e),u(qs.$$.fragment,e),u(Xr.$$.fragment,e),u(Rr.$$.fragment,e),u(Qs.$$.fragment,e),u(Lr.$$.fragment,e),u(Sr.$$.fragment,e),u(Nr.$$.fragment,e),u(Hr.$$.fragment,e),u(Ds.$$.fragment,e),u(Er.$$.fragment,e),u(qr.$$.fragment,e),u(Qr.$$.fragment,e),u(Dr.$$.fragment,e),u(Yr.$$.fragment,e),u(Pr.$$.fragment,e),u(Ys.$$.fragment,e),u(Ar.$$.fragment,e),u(Or.$$.fragment,e),u(Ps.$$.fragment,e),u(Kr.$$.fragment,e),u(eo.$$.fragment,e),u(As.$$.fragment,e),u(to.$$.fragment,e),u(so.$$.fragment,e),u(Os.$$.fragment,e),u(Ks.$$.fragment,e),u(no.$$.fragment,e),u(ao.$$.fragment,e),u(en.$$.fragment,e),u(tn.$$.fragment,e),u(ro.$$.fragment,e),u(oo.$$.fragment,e),u(sn.$$.fragment,e),u(lo.$$.fragment,e),u(co.$$.fragment,e),u(nn.$$.fragment,e),u(io.$$.fragment,e),u(po.$$.fragment,e),u(an.$$.fragment,e),u(rn.$$.fragment,e),u(mo.$$.fragment,e),u(ho.$$.fragment,e),u(on.$$.fragment,e),u(go.$$.fragment,e),u(uo.$$.fragment,e),u(ln.$$.fragment,e),u(fo.$$.fragment,e),u(bo.$$.fragment,e),u(cn.$$.fragment,e),u(_o.$$.fragment,e),u(yo.$$.fragment,e),u(dn.$$.fragment,e),u(pn.$$.fragment,e),u(To.$$.fragment,e),u(Mo.$$.fragment,e),u(mn.$$.fragment,e),u(vo.$$.fragment,e),u(wo.$$.fragment,e),u(hn.$$.fragment,e),u(ko.$$.fragment,e),u($o.$$.fragment,e),u(gn.$$.fragment,e),u(jo.$$.fragment,e),u(xo.$$.fragment,e),u(un.$$.fragment,e),u(Jo.$$.fragment,e),u(Uo.$$.fragment,e),u(fn.$$.fragment,e),u(Zo.$$.fragment,e),u(Co.$$.fragment,e),u(bn.$$.fragment,e),u(Wo.$$.fragment,e),u(Bo.$$.fragment,e),u(Io.$$.fragment,e),u(zo.$$.fragment,e),u(Vo.$$.fragment,e),u(Go.$$.fragment,e),u(Fo.$$.fragment,e),u(Xo.$$.fragment,e),u(Ro.$$.fragment,e),u(Lo.$$.fragment,e),u(So.$$.fragment,e),u(No.$$.fragment,e),u(Ho.$$.fragment,e),u(Eo.$$.fragment,e),u(qo.$$.fragment,e),u(Qo.$$.fragment,e),u(Do.$$.fragment,e),u(Yo.$$.fragment,e),u(Po.$$.fragment,e),u(Ao.$$.fragment,e),u(Oo.$$.fragment,e),u(Ko.$$.fragment,e),u(el.$$.fragment,e),u(tl.$$.fragment,e),u(sl.$$.fragment,e),u(nl.$$.fragment,e),u(al.$$.fragment,e),u(rl.$$.fragment,e),u(ol.$$.fragment,e),u(ll.$$.fragment,e),u(cl.$$.fragment,e),u(il.$$.fragment,e),u(dl.$$.fragment,e),u(pl.$$.fragment,e),u(ml.$$.fragment,e),u(hl.$$.fragment,e),u(gl.$$.fragment,e),u(ul.$$.fragment,e),u(fl.$$.fragment,e),u(bl.$$.fragment,e),u(_l.$$.fragment,e),u(yl.$$.fragment,e),u(Tl.$$.fragment,e),u(Ml.$$.fragment,e),u(vl.$$.fragment,e),u(wl.$$.fragment,e),u(kl.$$.fragment,e),u($l.$$.fragment,e),u(jl.$$.fragment,e),u(xl.$$.fragment,e),u(Jl.$$.fragment,e),u(Ul.$$.fragment,e),u(Zl.$$.fragment,e),u(Cl.$$.fragment,e),u(Wl.$$.fragment,e),u(Bl.$$.fragment,e),u(Il.$$.fragment,e),u(zl.$$.fragment,e),u(Vl.$$.fragment,e),u(Gl.$$.fragment,e),u(Xl.$$.fragment,e),u(Rl.$$.fragment,e),u(Ll.$$.fragment,e),u(Sl.$$.fragment,e),u(Nl.$$.fragment,e),u(Hl.$$.fragment,e),u(El.$$.fragment,e),u(ql.$$.fragment,e),u(Ql.$$.fragment,e),u(vn.$$.fragment,e),u(Dl.$$.fragment,e),u(Yl.$$.fragment,e),u(Pl.$$.fragment,e),u(Al.$$.fragment,e),u(Kl.$$.fragment,e),u(wn.$$.fragment,e),u(ec.$$.fragment,e),u(tc.$$.fragment,e),u(sc.$$.fragment,e),u(nc.$$.fragment,e),u(ac.$$.fragment,e),u(rc.$$.fragment,e),u(oc.$$.fragment,e),u(lc.$$.fragment,e),u(cc.$$.fragment,e),u(ic.$$.fragment,e),u(dc.$$.fragment,e),u(pc.$$.fragment,e),u(mc.$$.fragment,e),u(hc.$$.fragment,e),u(gc.$$.fragment,e),u(uc.$$.fragment,e),u(fc.$$.fragment,e),u(bc.$$.fragment,e),u(_c.$$.fragment,e),u(yc.$$.fragment,e),u(Tc.$$.fragment,e),u(Mc.$$.fragment,e),u(vc.$$.fragment,e),u(wc.$$.fragment,e),u(Cn.$$.fragment,e),u(Wn.$$.fragment,e),u(kc.$$.fragment,e),u($c.$$.fragment,e),u(jc.$$.fragment,e),u(xc.$$.fragment,e),u(Vn.$$.fragment,e),u(Gn.$$.fragment,e),u(Jc.$$.fragment,e),u(Uc.$$.fragment,e),u(Zc.$$.fragment,e),u(Cc.$$.fragment,e),u(Wc.$$.fragment,e),u(Bc.$$.fragment,e),u(Ic.$$.fragment,e),u(zc.$$.fragment,e),u(Vc.$$.fragment,e),u(Sn.$$.fragment,e),u(Gc.$$.fragment,e),u(Fc.$$.fragment,e),u(Xc.$$.fragment,e),u(Rc.$$.fragment,e),u(Lc.$$.fragment,e),u(Sc.$$.fragment,e),u(Nc.$$.fragment,e),u(Hc.$$.fragment,e),u(Ec.$$.fragment,e),u(Yn.$$.fragment,e),u(qc.$$.fragment,e),u(Pn.$$.fragment,e),u(Qc.$$.fragment,e),u(An.$$.fragment,e),u(Dc.$$.fragment,e),u(Yc.$$.fragment,e),u(Pc.$$.fragment,e),u(Ac.$$.fragment,e),u(Oc.$$.fragment,e),u(Kc.$$.fragment,e),u(ei.$$.fragment,e),u(ti.$$.fragment,e),u(aa.$$.fragment,e),u(si.$$.fragment,e),u(ni.$$.fragment,e),u(ai.$$.fragment,e),u(ri.$$.fragment,e),u(ca.$$.fragment,e),u(oi.$$.fragment,e),u(li.$$.fragment,e),u(ci.$$.fragment,e),u(ii.$$.fragment,e),u(ma.$$.fragment,e),u(di.$$.fragment,e),u(pi.$$.fragment,e),u(mi.$$.fragment,e),u(hi.$$.fragment,e),u(ga.$$.fragment,e),u(gi.$$.fragment,e),u(ui.$$.fragment,e),u(fi.$$.fragment,e),u(ua.$$.fragment,e),u(bi.$$.fragment,e),u(_i.$$.fragment,e),u(yi.$$.fragment,e),u(Ti.$$.fragment,e),u(Mi.$$.fragment,e),u(vi.$$.fragment,e),u(Ta.$$.fragment,e),u(wi.$$.fragment,e),u(ki.$$.fragment,e),u($i.$$.fragment,e),u(ji.$$.fragment,e),u(xi.$$.fragment,e),u(Ji.$$.fragment,e),u(Ui.$$.fragment,e),u(va.$$.fragment,e),u(Zi.$$.fragment,e),u(Ci.$$.fragment,e),u(Wi.$$.fragment,e),u(Bi.$$.fragment,e),u(Ii.$$.fragment,e),u($a.$$.fragment,e),u(zi.$$.fragment,e),u(ja.$$.fragment,e),u(Vi.$$.fragment,e),u(Gi.$$.fragment,e),by=!0)},o(e){f(w.$$.fragment,e),f(Ga.$$.fragment,e),f(Ra.$$.fragment,e),f(qa.$$.fragment,e),f(Pa.$$.fragment,e),f(Aa.$$.fragment,e),f(Oa.$$.fragment,e),f(Ka.$$.fragment,e),f(er.$$.fragment,e),f(tr.$$.fragment,e),f(sr.$$.fragment,e),f(nr.$$.fragment,e),f(ar.$$.fragment,e),f(rr.$$.fragment,e),f(or.$$.fragment,e),f(lr.$$.fragment,e),f(cr.$$.fragment,e),f(ir.$$.fragment,e),f(dr.$$.fragment,e),f(pr.$$.fragment,e),f(mr.$$.fragment,e),f(hr.$$.fragment,e),f(gr.$$.fragment,e),f(ur.$$.fragment,e),f(fr.$$.fragment,e),f(br.$$.fragment,e),f(_r.$$.fragment,e),f(yr.$$.fragment,e),f(Mr.$$.fragment,e),f(vr.$$.fragment,e),f(Gs.$$.fragment,e),f(wr.$$.fragment,e),f(kr.$$.fragment,e),f(Fs.$$.fragment,e),f(Xs.$$.fragment,e),f($r.$$.fragment,e),f(jr.$$.fragment,e),f(Rs.$$.fragment,e),f(xr.$$.fragment,e),f(Jr.$$.fragment,e),f(Ls.$$.fragment,e),f(Ur.$$.fragment,e),f(Zr.$$.fragment,e),f(Ss.$$.fragment,e),f(Cr.$$.fragment,e),f(Wr.$$.fragment,e),f(Ns.$$.fragment,e),f(Br.$$.fragment,e),f(Ir.$$.fragment,e),f(Hs.$$.fragment,e),f(zr.$$.fragment,e),f(Vr.$$.fragment,e),f(Es.$$.fragment,e),f(Gr.$$.fragment,e),f(Fr.$$.fragment,e),f(qs.$$.fragment,e),f(Xr.$$.fragment,e),f(Rr.$$.fragment,e),f(Qs.$$.fragment,e),f(Lr.$$.fragment,e),f(Sr.$$.fragment,e),f(Nr.$$.fragment,e),f(Hr.$$.fragment,e),f(Ds.$$.fragment,e),f(Er.$$.fragment,e),f(qr.$$.fragment,e),f(Qr.$$.fragment,e),f(Dr.$$.fragment,e),f(Yr.$$.fragment,e),f(Pr.$$.fragment,e),f(Ys.$$.fragment,e),f(Ar.$$.fragment,e),f(Or.$$.fragment,e),f(Ps.$$.fragment,e),f(Kr.$$.fragment,e),f(eo.$$.fragment,e),f(As.$$.fragment,e),f(to.$$.fragment,e),f(so.$$.fragment,e),f(Os.$$.fragment,e),f(Ks.$$.fragment,e),f(no.$$.fragment,e),f(ao.$$.fragment,e),f(en.$$.fragment,e),f(tn.$$.fragment,e),f(ro.$$.fragment,e),f(oo.$$.fragment,e),f(sn.$$.fragment,e),f(lo.$$.fragment,e),f(co.$$.fragment,e),f(nn.$$.fragment,e),f(io.$$.fragment,e),f(po.$$.fragment,e),f(an.$$.fragment,e),f(rn.$$.fragment,e),f(mo.$$.fragment,e),f(ho.$$.fragment,e),f(on.$$.fragment,e),f(go.$$.fragment,e),f(uo.$$.fragment,e),f(ln.$$.fragment,e),f(fo.$$.fragment,e),f(bo.$$.fragment,e),f(cn.$$.fragment,e),f(_o.$$.fragment,e),f(yo.$$.fragment,e),f(dn.$$.fragment,e),f(pn.$$.fragment,e),f(To.$$.fragment,e),f(Mo.$$.fragment,e),f(mn.$$.fragment,e),f(vo.$$.fragment,e),f(wo.$$.fragment,e),f(hn.$$.fragment,e),f(ko.$$.fragment,e),f($o.$$.fragment,e),f(gn.$$.fragment,e),f(jo.$$.fragment,e),f(xo.$$.fragment,e),f(un.$$.fragment,e),f(Jo.$$.fragment,e),f(Uo.$$.fragment,e),f(fn.$$.fragment,e),f(Zo.$$.fragment,e),f(Co.$$.fragment,e),f(bn.$$.fragment,e),f(Wo.$$.fragment,e),f(Bo.$$.fragment,e),f(Io.$$.fragment,e),f(zo.$$.fragment,e),f(Vo.$$.fragment,e),f(Go.$$.fragment,e),f(Fo.$$.fragment,e),f(Xo.$$.fragment,e),f(Ro.$$.fragment,e),f(Lo.$$.fragment,e),f(So.$$.fragment,e),f(No.$$.fragment,e),f(Ho.$$.fragment,e),f(Eo.$$.fragment,e),f(qo.$$.fragment,e),f(Qo.$$.fragment,e),f(Do.$$.fragment,e),f(Yo.$$.fragment,e),f(Po.$$.fragment,e),f(Ao.$$.fragment,e),f(Oo.$$.fragment,e),f(Ko.$$.fragment,e),f(el.$$.fragment,e),f(tl.$$.fragment,e),f(sl.$$.fragment,e),f(nl.$$.fragment,e),f(al.$$.fragment,e),f(rl.$$.fragment,e),f(ol.$$.fragment,e),f(ll.$$.fragment,e),f(cl.$$.fragment,e),f(il.$$.fragment,e),f(dl.$$.fragment,e),f(pl.$$.fragment,e),f(ml.$$.fragment,e),f(hl.$$.fragment,e),f(gl.$$.fragment,e),f(ul.$$.fragment,e),f(fl.$$.fragment,e),f(bl.$$.fragment,e),f(_l.$$.fragment,e),f(yl.$$.fragment,e),f(Tl.$$.fragment,e),f(Ml.$$.fragment,e),f(vl.$$.fragment,e),f(wl.$$.fragment,e),f(kl.$$.fragment,e),f($l.$$.fragment,e),f(jl.$$.fragment,e),f(xl.$$.fragment,e),f(Jl.$$.fragment,e),f(Ul.$$.fragment,e),f(Zl.$$.fragment,e),f(Cl.$$.fragment,e),f(Wl.$$.fragment,e),f(Bl.$$.fragment,e),f(Il.$$.fragment,e),f(zl.$$.fragment,e),f(Vl.$$.fragment,e),f(Gl.$$.fragment,e),f(Xl.$$.fragment,e),f(Rl.$$.fragment,e),f(Ll.$$.fragment,e),f(Sl.$$.fragment,e),f(Nl.$$.fragment,e),f(Hl.$$.fragment,e),f(El.$$.fragment,e),f(ql.$$.fragment,e),f(Ql.$$.fragment,e),f(vn.$$.fragment,e),f(Dl.$$.fragment,e),f(Yl.$$.fragment,e),f(Pl.$$.fragment,e),f(Al.$$.fragment,e),f(Kl.$$.fragment,e),f(wn.$$.fragment,e),f(ec.$$.fragment,e),f(tc.$$.fragment,e),f(sc.$$.fragment,e),f(nc.$$.fragment,e),f(ac.$$.fragment,e),f(rc.$$.fragment,e),f(oc.$$.fragment,e),f(lc.$$.fragment,e),f(cc.$$.fragment,e),f(ic.$$.fragment,e),f(dc.$$.fragment,e),f(pc.$$.fragment,e),f(mc.$$.fragment,e),f(hc.$$.fragment,e),f(gc.$$.fragment,e),f(uc.$$.fragment,e),f(fc.$$.fragment,e),f(bc.$$.fragment,e),f(_c.$$.fragment,e),f(yc.$$.fragment,e),f(Tc.$$.fragment,e),f(Mc.$$.fragment,e),f(vc.$$.fragment,e),f(wc.$$.fragment,e),f(Cn.$$.fragment,e),f(Wn.$$.fragment,e),f(kc.$$.fragment,e),f($c.$$.fragment,e),f(jc.$$.fragment,e),f(xc.$$.fragment,e),f(Vn.$$.fragment,e),f(Gn.$$.fragment,e),f(Jc.$$.fragment,e),f(Uc.$$.fragment,e),f(Zc.$$.fragment,e),f(Cc.$$.fragment,e),f(Wc.$$.fragment,e),f(Bc.$$.fragment,e),f(Ic.$$.fragment,e),f(zc.$$.fragment,e),f(Vc.$$.fragment,e),f(Sn.$$.fragment,e),f(Gc.$$.fragment,e),f(Fc.$$.fragment,e),f(Xc.$$.fragment,e),f(Rc.$$.fragment,e),f(Lc.$$.fragment,e),f(Sc.$$.fragment,e),f(Nc.$$.fragment,e),f(Hc.$$.fragment,e),f(Ec.$$.fragment,e),f(Yn.$$.fragment,e),f(qc.$$.fragment,e),f(Pn.$$.fragment,e),f(Qc.$$.fragment,e),f(An.$$.fragment,e),f(Dc.$$.fragment,e),f(Yc.$$.fragment,e),f(Pc.$$.fragment,e),f(Ac.$$.fragment,e),f(Oc.$$.fragment,e),f(Kc.$$.fragment,e),f(ei.$$.fragment,e),f(ti.$$.fragment,e),f(aa.$$.fragment,e),f(si.$$.fragment,e),f(ni.$$.fragment,e),f(ai.$$.fragment,e),f(ri.$$.fragment,e),f(ca.$$.fragment,e),f(oi.$$.fragment,e),f(li.$$.fragment,e),f(ci.$$.fragment,e),f(ii.$$.fragment,e),f(ma.$$.fragment,e),f(di.$$.fragment,e),f(pi.$$.fragment,e),f(mi.$$.fragment,e),f(hi.$$.fragment,e),f(ga.$$.fragment,e),f(gi.$$.fragment,e),f(ui.$$.fragment,e),f(fi.$$.fragment,e),f(ua.$$.fragment,e),f(bi.$$.fragment,e),f(_i.$$.fragment,e),f(yi.$$.fragment,e),f(Ti.$$.fragment,e),f(Mi.$$.fragment,e),f(vi.$$.fragment,e),f(Ta.$$.fragment,e),f(wi.$$.fragment,e),f(ki.$$.fragment,e),f($i.$$.fragment,e),f(ji.$$.fragment,e),f(xi.$$.fragment,e),f(Ji.$$.fragment,e),f(Ui.$$.fragment,e),f(va.$$.fragment,e),f(Zi.$$.fragment,e),f(Ci.$$.fragment,e),f(Wi.$$.fragment,e),f(Bi.$$.fragment,e),f(Ii.$$.fragment,e),f($a.$$.fragment,e),f(zi.$$.fragment,e),f(ja.$$.fragment,e),f(Vi.$$.fragment,e),f(Gi.$$.fragment,e),by=!1},d(e){e&&(n($),n(y),n(d),n(s),n(k),n(zf),n(Vf),n(Fa),n(Gf),n(Xa),n(Ff),n(Xf),n(La),n(Rf),n(Sa),n(Lf),n(Na),n(Sf),n(Ha),n(Nf),n(Ea),n(Hf),n(Ef),n(Qa),n(qf),n(Da),n(Qf),n(Ya),n(Df),n(Yf),n(ms),n(Pf),n(hs),n(Af),n(gs),n(Of),n(us),n(Kf),n(eb),n(fs),n(tb),n(bs),n(sb),n(_s),n(nb),n(ys),n(ab),n(Ts),n(rb),n(Ms),n(ob),n(vs),n(lb),n(ws),n(cb),n(ks),n(ib),n($s),n(db),n(pb),n(et),n(mb),n(tt),n(hb),n(st),n(gb),n(ub),n(Tr),n(fb),n(bb),n(ke),n(_b),n(S),n(yb),n(se),n(Tb),n(ne),n(Mb),n($e),n(vb),n(je),n(wb),n(xe),n(kb),n(Je),n($b),n(Ue),n(jb),n(N),n(xb),n(Ze),n(Jb),n(Ce),n(Ub),n(nt),n(Zb),n(at),n(Cb),n(We),n(Wb),n(Be),n(Bb),n(H),n(Ib),n(ae),n(zb),n(re),n(Vb),n(Ie),n(Gb),n(oe),n(Fb),n(le),n(Xb),n(ze),n(Rb),n(Ve),n(Lb),n(G),n(Sb),n(ce),n(Nb),n(Ge),n(Hb),n(Fe),n(Eb),n(ie),n(qb),n(de),n(Qb),n(pe),n(Db),n(E),n(Yb),n(Pb),n(rt),n(Ab),n(ot),n(Ob),n(lt),n(Kb),n(ct),n(e_),n(it),n(t_),n(dt),n(s_),n(pt),n(n_),n(mt),n(a_),n(ht),n(r_),n(gt),n(o_),n(ut),n(l_),n(ft),n(c_),n(bt),n(i_),n(_t),n(d_),n(yt),n(p_),n(m_),n(Tt),n(h_),n(Mt),n(g_),n(vt),n(u_),n(wt),n(f_),n(kt),n(b_),n($t),n(__),n(jt),n(y_),n(xt),n(T_),n(Jt),n(M_),n(Ut),n(v_),n(Zt),n(w_),n(Ct),n(k_),n(Wt),n($_),n(j_),n(Fl),n(x_),n(Xe),n(J_),n(js),n(U_),n(Bt),n(Z_),n(It),n(C_),n(J),n(W_),n(zt),n(B_),n(I_),n(Ol),n(z_),n(W),n(V_),n(xs),n(G_),n(Js),n(F_),n(Re),n(X_),n(R_),n(Le),n(L_),n(q),n(S_),n(Se),n(N_),n(H_),n(F),n(E_),n(me),n(q_),n(Q_),n(Vt),n(D_),n(Gt),n(Y_),n(Ft),n(P_),n(I),n(A_),n(Q),n(O_),n(Xt),n(K_),n(Rt),n(ey),n(X),n(ty),n(D),n(sy),n(Y),n(ny),n(P),n(ay),n(A),n(ry),n(z),n(oy),n(V),n(ly),n(O),n(cy),n(iy),n(he),n(dy),n(ge),n(py),n(Lt),n(my),n(R),n(hy),n(St),n(gy),n(ue),n(uy),n(fy),n(_f)),n(c),b(w,e),b(Ga,e),b(Ra,e),b(qa,e),b(Pa,e),b(Aa),b(Oa),b(Ka),b(er),b(tr,e),b(sr),b(nr),b(ar),b(rr),b(or),b(lr),b(cr),b(ir),b(dr),b(pr),b(mr,e),b(hr),b(gr),b(ur),b(fr),b(br),b(_r),b(yr,e),b(Mr,e),b(vr),b(Gs),b(wr),b(kr),b(Fs),b(Xs),b($r),b(jr),b(Rs),b(xr),b(Jr),b(Ls),b(Ur),b(Zr),b(Ss),b(Cr),b(Wr),b(Ns),b(Br),b(Ir),b(Hs),b(zr),b(Vr),b(Es),b(Gr),b(Fr),b(qs),b(Xr),b(Rr),b(Qs),b(Lr),b(Sr),b(Nr),b(Hr),b(Ds),b(Er),b(qr),b(Qr),b(Dr),b(Yr),b(Pr),b(Ys),b(Ar),b(Or),b(Ps),b(Kr),b(eo),b(As),b(to),b(so),b(Os),b(Ks),b(no),b(ao),b(en),b(tn),b(ro),b(oo),b(sn),b(lo),b(co),b(nn),b(io),b(po),b(an),b(rn),b(mo),b(ho),b(on),b(go),b(uo),b(ln),b(fo),b(bo),b(cn),b(_o),b(yo),b(dn),b(pn),b(To),b(Mo),b(mn),b(vo),b(wo),b(hn),b(ko),b($o),b(gn),b(jo),b(xo),b(un),b(Jo),b(Uo),b(fn),b(Zo),b(Co),b(bn),b(Wo),b(Bo,e),b(Io),b(zo),b(Vo),b(Go),b(Fo),b(Xo),b(Ro),b(Lo),b(So),b(No),b(Ho),b(Eo),b(qo),b(Qo),b(Do),b(Yo),b(Po),b(Ao),b(Oo),b(Ko),b(el),b(tl),b(sl),b(nl),b(al),b(rl),b(ol),b(ll),b(cl),b(il),b(dl,e),b(pl),b(ml),b(hl),b(gl),b(ul),b(fl),b(bl),b(_l),b(yl),b(Tl),b(Ml),b(vl),b(wl),b(kl),b($l),b(jl),b(xl),b(Jl),b(Ul),b(Zl),b(Cl),b(Wl),b(Bl),b(Il),b(zl),b(Vl),b(Gl,e),b(Xl),b(Rl),b(Ll),b(Sl),b(Nl),b(Hl),b(El),b(ql),b(Ql),b(vn),b(Dl),b(Yl),b(Pl),b(Al,e),b(Kl),b(wn),b(ec),b(tc),b(sc),b(nc),b(ac),b(rc),b(oc),b(lc),b(cc),b(ic),b(dc),b(pc),b(mc,e),b(hc),b(gc),b(uc),b(fc),b(bc),b(_c),b(yc),b(Tc),b(Mc),b(vc,e),b(wc),b(Cn),b(Wn),b(kc),b($c),b(jc),b(xc),b(Vn),b(Gn),b(Jc),b(Uc,e),b(Zc),b(Cc),b(Wc),b(Bc),b(Ic),b(zc),b(Vc),b(Sn),b(Gc),b(Fc),b(Xc),b(Rc),b(Lc),b(Sc),b(Nc),b(Hc),b(Ec),b(Yn),b(qc),b(Pn),b(Qc),b(An),b(Dc),b(Yc),b(Pc),b(Ac),b(Oc),b(Kc),b(ei),b(ti),b(aa),b(si),b(ni),b(ai),b(ri),b(ca),b(oi),b(li),b(ci),b(ii),b(ma),b(di),b(pi),b(mi),b(hi),b(ga),b(gi),b(ui),b(fi),b(ua),b(bi),b(_i),b(yi),b(Ti),b(Mi),b(vi),b(Ta),b(wi),b(ki),b($i),b(ji,e),b(xi),b(Ji),b(Ui),b(va),b(Zi),b(Ci),b(Wi),b(Bi),b(Ii),b($a),b(zi),b(ja),b(Vi),b(Gi,e)}}}const bC='{"title":"Utilities for Generation","local":"utilities-for-generation","sections":[{"title":"Generate Outputs","local":"generate-outputs","sections":[{"title":"PyTorch","local":"transformers.generation.GenerateDecoderOnlyOutput","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.generation.TFGreedySearchEncoderDecoderOutput","sections":[],"depth":3},{"title":"FLAX","local":"transformers.generation.FlaxSampleOutput","sections":[],"depth":3}],"depth":2},{"title":"LogitsProcessor","local":"logitsprocessor","sections":[{"title":"PyTorch","local":"transformers.AlternatingCodebooksLogitsProcessor","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.TFForcedBOSTokenLogitsProcessor","sections":[],"depth":3},{"title":"FLAX","local":"transformers.FlaxForcedBOSTokenLogitsProcessor","sections":[],"depth":3}],"depth":2},{"title":"StoppingCriteria","local":"transformers.StoppingCriteria","sections":[],"depth":2},{"title":"Constraints","local":"transformers.Constraint","sections":[],"depth":2},{"title":"BeamSearch","local":"transformers.BeamScorer","sections":[],"depth":2},{"title":"Streamers","local":"transformers.TextStreamer","sections":[],"depth":2},{"title":"Caches","local":"transformers.Cache","sections":[],"depth":2},{"title":"Watermark Utils","local":"transformers.WatermarkingConfig","sections":[],"depth":2}],"depth":1}';function _C(j){return mZ(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jC extends hZ{constructor(c){super(),gZ(this,c,_C,fC,pZ,{})}}export{jC as component};
