import{s as Pe,n as qe,o as Ke}from"../chunks/scheduler.25b97de1.js";import{S as Ae,i as Oe,g as p,s as l,r as m,A as es,h as i,f as t,c as n,j as Fe,u as J,x as o,k as Ze,y as ss,a,v as r,d as w,t as c,w as T}from"../chunks/index.d9030fc9.js";import{C as u}from"../chunks/CodeBlock.e6cd0d95.js";import{D as ts}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{H as as,E as ls}from"../chunks/EditOnGithub.91d95064.js";function ns(We){let h,q,F,K,d,A,b,O,f,Ve="Image-to-Image task is the task where an application receives an image and outputs another image. This has various subtasks, including image enhancement (super resolution, low light enhancement, deraining and so on), image inpainting, and more.",ee,I,xe="This guide will show you how to:",se,y,Ne="<li>Use an image-to-image pipeline for super resolution task,</li> <li>Run image-to-image models for same task without a pipeline.</li>",te,j,De="Note that as of the time this guide is released, <code>image-to-image</code> pipeline only supports super resolution task.",ae,$,_e="Let’s begin by installing the necessary libraries.",le,C,ne,U,ze='We can now initialize the pipeline with a <a href="https://huggingface.co/caidas/swin2SR-lightweight-x2-64" rel="nofollow">Swin2SR model</a>. We can then infer with the pipeline by calling it with an image. As of now, only <a href="https://huggingface.co/models?sort=trending&amp;search=swin2sr" rel="nofollow">Swin2SR models</a> are supported in this pipeline.',pe,v,ie,k,Re="Now, let’s load an image.",oe,Z,me,W,Je,g,Se='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/cat.jpg" alt="Photo of a cat"/>',re,V,Be="We can now do inference with the pipeline. We will get an upscaled version of the cat image.",we,x,ce,N,Te,D,He="If you wish to do inference yourself with no pipeline, you can use the <code>Swin2SRForImageSuperResolution</code> and <code>Swin2SRImageProcessor</code> classes of transformers. We will use the same model checkpoint for this. Let’s initialize the model and the processor.",ue,_,he,z,Ge="<code>pipeline</code> abstracts away the preprocessing and postprocessing steps that we have to do ourselves, so let’s preprocess the image. We will pass the image to the processor and then move the pixel values to GPU.",ge,R,Me,S,Ye="We can now infer the image by passing pixel values to the model.",de,B,be,H,Ee="Output is an object of type <code>ImageSuperResolutionOutput</code> that looks like below 👇",fe,G,Ie,Y,Xe="We need to get the <code>reconstruction</code> and post-process it for visualization. Let’s see how it looks like.",ye,E,je,X,Le="We need to squeeze the output and get rid of axis 0, clip the values, then convert it to be numpy float. Then we will arrange axes to have the shape [1072, 880], and finally, bring the output back to range [0, 255].",$e,L,Ce,M,Qe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/cat_upscaled.png" alt="Upscaled photo of a cat"/>',Ue,Q,ve,P,ke;return d=new as({props:{title:"Image-to-Image Task Guide",local:"image-to-image-task-guide",headingTag:"h1"}}),b=new ts({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/image_to_image.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_to_image.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_to_image.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/image_to_image.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_to_image.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_to_image.ipynb"}]}}),C=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycw==",highlighted:"pip install transformers",wrap:!1}}),v=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJ2N1ZGEnJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCdjcHUnKSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyaW1hZ2UtdG8taW1hZ2UlMjIlMkMlMjBtb2RlbCUzRCUyMmNhaWRhcyUyRnN3aW4yU1ItbGlnaHR3ZWlnaHQteDItNjQlMjIlMkMlMjBkZXZpY2UlM0RkZXZpY2Up",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&#x27;cuda&#x27;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;cpu&#x27;</span>)
pipe = pipeline(task=<span class="hljs-string">&quot;image-to-image&quot;</span>, model=<span class="hljs-string">&quot;caidas/swin2SR-lightweight-x2-64&quot;</span>, device=device)`,wrap:!1}}),Z=new u({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0cmFuc2Zvcm1lcnMlMkZ0YXNrcyUyRmNhdC5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFwcmludChpbWFnZS5zaXplKQ==",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/cat.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-built_in">print</span>(image.size)`,wrap:!1}}),W=new u({props:{code:"JTIzJTIwKDUzMiUyQyUyMDQzMik=",highlighted:'<span class="hljs-comment"># (532, 432)</span>',wrap:!1}}),x=new u({props:{code:"dXBzY2FsZWQlMjAlM0QlMjBwaXBlKGltYWdlKSUwQXByaW50KHVwc2NhbGVkLnNpemUp",highlighted:`upscaled = pipe(image)
<span class="hljs-built_in">print</span>(upscaled.size)`,wrap:!1}}),N=new u({props:{code:"JTIzJTIwKDEwNzIlMkMlMjA4ODAp",highlighted:'<span class="hljs-comment"># (1072, 880)</span>',wrap:!1}}),_=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN3aW4yU1JGb3JJbWFnZVN1cGVyUmVzb2x1dGlvbiUyQyUyMFN3aW4yU1JJbWFnZVByb2Nlc3NvciUyMCUwQSUwQW1vZGVsJTIwJTNEJTIwU3dpbjJTUkZvckltYWdlU3VwZXJSZXNvbHV0aW9uLmZyb21fcHJldHJhaW5lZCglMjJjYWlkYXMlMkZzd2luMlNSLWxpZ2h0d2VpZ2h0LXgyLTY0JTIyKS50byhkZXZpY2UpJTBBcHJvY2Vzc29yJTIwJTNEJTIwU3dpbjJTUkltYWdlUHJvY2Vzc29yKCUyMmNhaWRhcyUyRnN3aW4yU1ItbGlnaHR3ZWlnaHQteDItNjQlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Swin2SRForImageSuperResolution, Swin2SRImageProcessor 

model = Swin2SRForImageSuperResolution.from_pretrained(<span class="hljs-string">&quot;caidas/swin2SR-lightweight-x2-64&quot;</span>).to(device)
processor = Swin2SRImageProcessor(<span class="hljs-string">&quot;caidas/swin2SR-lightweight-x2-64&quot;</span>)`,wrap:!1}}),R=new u({props:{code:"cGl4ZWxfdmFsdWVzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikucGl4ZWxfdmFsdWVzJTBBcHJpbnQocGl4ZWxfdmFsdWVzLnNoYXBlKSUwQSUwQXBpeGVsX3ZhbHVlcyUyMCUzRCUyMHBpeGVsX3ZhbHVlcy50byhkZXZpY2Up",highlighted:`pixel_values = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-built_in">print</span>(pixel_values.shape)

pixel_values = pixel_values.to(device)`,wrap:!1}}),B=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBpeGVsX3ZhbHVlcyk=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">with</span> torch.no_grad():
  outputs = model(pixel_values)`,wrap:!1}}),G=new u({props:{code:"KGxvc3MlM0ROb25lJTJDJTIwcmVjb25zdHJ1Y3Rpb24lM0R0ZW5zb3IoJTVCJTVCJTVCJTVCMC44MjcwJTJDJTIwMC44MjY5JTJDJTIwMC44Mjc1JTJDJTIwJTIwLi4uJTJDJTIwMC43NDYzJTJDJTIwMC43NDQ2JTJDJTIwMC43NDUzJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC44Mjg3JTJDJTIwMC44Mjc4JTJDJTIwMC44MjgzJTJDJTIwJTIwLi4uJTJDJTIwMC43NDUxJTJDJTIwMC43NDQ4JTJDJTIwMC43NDU3JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC44MjgwJTJDJTIwMC44MjczJTJDJTIwMC44MjY5JTJDJTIwJTIwLi4uJTJDJTIwMC43NDQ3JTJDJTIwMC43NDQ2JTJDJTIwMC43NDUyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC41OTIzJTJDJTIwMC41OTMzJTJDJTIwMC41OTI0JTJDJTIwJTIwLi4uJTJDJTIwMC4wNjk3JTJDJTIwMC4wNjk1JTJDJTIwMC4wNzA2JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC41OTI2JTJDJTIwMC41OTMyJTJDJTIwMC41OTI2JTJDJTIwJTIwLi4uJTJDJTIwMC4wNjczJTJDJTIwMC4wNjg3JTJDJTIwMC4wNzA1JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC41OTI3JTJDJTIwMC41OTE0JTJDJTIwMC41OTIyJTJDJTIwJTIwLi4uJTJDJTIwMC4wNjY0JTJDJTIwMC4wNjk0JTJDJTIwMC4wNzE4JTVEJTVEJTVEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGV2aWNlJTNEJ2N1ZGElM0EwJyklMkMlMjBoaWRkZW5fc3RhdGVzJTNETm9uZSUyQyUyMGF0dGVudGlvbnMlM0ROb25lKQ==",highlighted:`(<span class="hljs-name">loss=None</span>, reconstruction=tensor([[[[<span class="hljs-name">0.8270</span>, <span class="hljs-number">0.8269</span>, <span class="hljs-number">0.8275</span>,  ..., <span class="hljs-number">0.7463</span>, <span class="hljs-number">0.7446</span>, <span class="hljs-number">0.7453</span>],
          [<span class="hljs-name">0.8287</span>, <span class="hljs-number">0.8278</span>, <span class="hljs-number">0.8283</span>,  ..., <span class="hljs-number">0.7451</span>, <span class="hljs-number">0.7448</span>, <span class="hljs-number">0.7457</span>],
          [<span class="hljs-name">0.8280</span>, <span class="hljs-number">0.8273</span>, <span class="hljs-number">0.8269</span>,  ..., <span class="hljs-number">0.7447</span>, <span class="hljs-number">0.7446</span>, <span class="hljs-number">0.7452</span>],
          ...,
          [<span class="hljs-name">0.5923</span>, <span class="hljs-number">0.5933</span>, <span class="hljs-number">0.5924</span>,  ..., <span class="hljs-number">0.0697</span>, <span class="hljs-number">0.0695</span>, <span class="hljs-number">0.0706</span>],
          [<span class="hljs-name">0.5926</span>, <span class="hljs-number">0.5932</span>, <span class="hljs-number">0.5926</span>,  ..., <span class="hljs-number">0.0673</span>, <span class="hljs-number">0.0687</span>, <span class="hljs-number">0.0705</span>],
          [<span class="hljs-name">0.5927</span>, <span class="hljs-number">0.5914</span>, <span class="hljs-number">0.5922</span>,  ..., <span class="hljs-number">0.0664</span>, <span class="hljs-number">0.0694</span>, <span class="hljs-number">0.0718</span>]]]],
       device=<span class="hljs-symbol">&#x27;cuda:0</span>&#x27;), hidden_states=None, attentions=None)`,wrap:!1}}),E=new u({props:{code:"b3V0cHV0cy5yZWNvbnN0cnVjdGlvbi5kYXRhLnNoYXBlJTBBJTIzJTIwdG9yY2guU2l6ZSglNUIxJTJDJTIwMyUyQyUyMDg4MCUyQyUyMDEwNzIlNUQp",highlighted:`outputs.reconstruction.data.shape
<span class="hljs-comment"># torch.Size([1, 3, 880, 1072])</span>`,wrap:!1}}),L=new u({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTIzJTIwc3F1ZWV6ZSUyQyUyMHRha2UlMjB0byUyMENQVSUyMGFuZCUyMGNsaXAlMjB0aGUlMjB2YWx1ZXMlMEFvdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnJlY29uc3RydWN0aW9uLmRhdGEuc3F1ZWV6ZSgpLmNwdSgpLmNsYW1wXygwJTJDJTIwMSkubnVtcHkoKSUwQSUyMyUyMHJlYXJyYW5nZSUyMHRoZSUyMGF4ZXMlMEFvdXRwdXQlMjAlM0QlMjBucC5tb3ZlYXhpcyhvdXRwdXQlMkMlMjBzb3VyY2UlM0QwJTJDJTIwZGVzdGluYXRpb24lM0QtMSklMEElMjMlMjBicmluZyUyMHZhbHVlcyUyMGJhY2slMjB0byUyMHBpeGVsJTIwdmFsdWVzJTIwcmFuZ2UlMEFvdXRwdXQlMjAlM0QlMjAob3V0cHV0JTIwKiUyMDI1NS4wKS5yb3VuZCgpLmFzdHlwZShucC51aW50OCklMEFJbWFnZS5mcm9tYXJyYXkob3V0cHV0KQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-comment"># squeeze, take to CPU and clip the values</span>
output = outputs.reconstruction.data.squeeze().cpu().clamp_(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>).numpy()
<span class="hljs-comment"># rearrange the axes</span>
output = np.moveaxis(output, source=<span class="hljs-number">0</span>, destination=-<span class="hljs-number">1</span>)
<span class="hljs-comment"># bring values back to pixel values range</span>
output = (output * <span class="hljs-number">255.0</span>).<span class="hljs-built_in">round</span>().astype(np.uint8)
Image.fromarray(output)`,wrap:!1}}),Q=new ls({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/image_to_image.md"}}),{c(){h=p("meta"),q=l(),F=p("p"),K=l(),m(d.$$.fragment),A=l(),m(b.$$.fragment),O=l(),f=p("p"),f.textContent=Ve,ee=l(),I=p("p"),I.textContent=xe,se=l(),y=p("ul"),y.innerHTML=Ne,te=l(),j=p("p"),j.innerHTML=De,ae=l(),$=p("p"),$.textContent=_e,le=l(),m(C.$$.fragment),ne=l(),U=p("p"),U.innerHTML=ze,pe=l(),m(v.$$.fragment),ie=l(),k=p("p"),k.textContent=Re,oe=l(),m(Z.$$.fragment),me=l(),m(W.$$.fragment),Je=l(),g=p("div"),g.innerHTML=Se,re=l(),V=p("p"),V.textContent=Be,we=l(),m(x.$$.fragment),ce=l(),m(N.$$.fragment),Te=l(),D=p("p"),D.innerHTML=He,ue=l(),m(_.$$.fragment),he=l(),z=p("p"),z.innerHTML=Ge,ge=l(),m(R.$$.fragment),Me=l(),S=p("p"),S.textContent=Ye,de=l(),m(B.$$.fragment),be=l(),H=p("p"),H.innerHTML=Ee,fe=l(),m(G.$$.fragment),Ie=l(),Y=p("p"),Y.innerHTML=Xe,ye=l(),m(E.$$.fragment),je=l(),X=p("p"),X.textContent=Le,$e=l(),m(L.$$.fragment),Ce=l(),M=p("div"),M.innerHTML=Qe,Ue=l(),m(Q.$$.fragment),ve=l(),P=p("p"),this.h()},l(e){const s=es("svelte-u9bgzb",document.head);h=i(s,"META",{name:!0,content:!0}),s.forEach(t),q=n(e),F=i(e,"P",{}),Fe(F).forEach(t),K=n(e),J(d.$$.fragment,e),A=n(e),J(b.$$.fragment,e),O=n(e),f=i(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1m5ab0h"&&(f.textContent=Ve),ee=n(e),I=i(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1aff4p7"&&(I.textContent=xe),se=n(e),y=i(e,"UL",{"data-svelte-h":!0}),o(y)!=="svelte-1dytd0b"&&(y.innerHTML=Ne),te=n(e),j=i(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-j21dpj"&&(j.innerHTML=De),ae=n(e),$=i(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-2ffb0z"&&($.textContent=_e),le=n(e),J(C.$$.fragment,e),ne=n(e),U=i(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-6x8yac"&&(U.innerHTML=ze),pe=n(e),J(v.$$.fragment,e),ie=n(e),k=i(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-dx2hkj"&&(k.textContent=Re),oe=n(e),J(Z.$$.fragment,e),me=n(e),J(W.$$.fragment,e),Je=n(e),g=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(g)!=="svelte-muvbux"&&(g.innerHTML=Se),re=n(e),V=i(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-jehike"&&(V.textContent=Be),we=n(e),J(x.$$.fragment,e),ce=n(e),J(N.$$.fragment,e),Te=n(e),D=i(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-7mqp02"&&(D.innerHTML=He),ue=n(e),J(_.$$.fragment,e),he=n(e),z=i(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-cwlggi"&&(z.innerHTML=Ge),ge=n(e),J(R.$$.fragment,e),Me=n(e),S=i(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-z8yxu1"&&(S.textContent=Ye),de=n(e),J(B.$$.fragment,e),be=n(e),H=i(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-yf1rhn"&&(H.innerHTML=Ee),fe=n(e),J(G.$$.fragment,e),Ie=n(e),Y=i(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-nzl4n2"&&(Y.innerHTML=Xe),ye=n(e),J(E.$$.fragment,e),je=n(e),X=i(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-z07gu"&&(X.textContent=Le),$e=n(e),J(L.$$.fragment,e),Ce=n(e),M=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(M)!=="svelte-1u1oaeg"&&(M.innerHTML=Qe),Ue=n(e),J(Q.$$.fragment,e),ve=n(e),P=i(e,"P",{}),Fe(P).forEach(t),this.h()},h(){Ze(h,"name","hf:doc:metadata"),Ze(h,"content",ps),Ze(g,"class","flex justify-center"),Ze(M,"class","flex justify-center")},m(e,s){ss(document.head,h),a(e,q,s),a(e,F,s),a(e,K,s),r(d,e,s),a(e,A,s),r(b,e,s),a(e,O,s),a(e,f,s),a(e,ee,s),a(e,I,s),a(e,se,s),a(e,y,s),a(e,te,s),a(e,j,s),a(e,ae,s),a(e,$,s),a(e,le,s),r(C,e,s),a(e,ne,s),a(e,U,s),a(e,pe,s),r(v,e,s),a(e,ie,s),a(e,k,s),a(e,oe,s),r(Z,e,s),a(e,me,s),r(W,e,s),a(e,Je,s),a(e,g,s),a(e,re,s),a(e,V,s),a(e,we,s),r(x,e,s),a(e,ce,s),r(N,e,s),a(e,Te,s),a(e,D,s),a(e,ue,s),r(_,e,s),a(e,he,s),a(e,z,s),a(e,ge,s),r(R,e,s),a(e,Me,s),a(e,S,s),a(e,de,s),r(B,e,s),a(e,be,s),a(e,H,s),a(e,fe,s),r(G,e,s),a(e,Ie,s),a(e,Y,s),a(e,ye,s),r(E,e,s),a(e,je,s),a(e,X,s),a(e,$e,s),r(L,e,s),a(e,Ce,s),a(e,M,s),a(e,Ue,s),r(Q,e,s),a(e,ve,s),a(e,P,s),ke=!0},p:qe,i(e){ke||(w(d.$$.fragment,e),w(b.$$.fragment,e),w(C.$$.fragment,e),w(v.$$.fragment,e),w(Z.$$.fragment,e),w(W.$$.fragment,e),w(x.$$.fragment,e),w(N.$$.fragment,e),w(_.$$.fragment,e),w(R.$$.fragment,e),w(B.$$.fragment,e),w(G.$$.fragment,e),w(E.$$.fragment,e),w(L.$$.fragment,e),w(Q.$$.fragment,e),ke=!0)},o(e){c(d.$$.fragment,e),c(b.$$.fragment,e),c(C.$$.fragment,e),c(v.$$.fragment,e),c(Z.$$.fragment,e),c(W.$$.fragment,e),c(x.$$.fragment,e),c(N.$$.fragment,e),c(_.$$.fragment,e),c(R.$$.fragment,e),c(B.$$.fragment,e),c(G.$$.fragment,e),c(E.$$.fragment,e),c(L.$$.fragment,e),c(Q.$$.fragment,e),ke=!1},d(e){e&&(t(q),t(F),t(K),t(A),t(O),t(f),t(ee),t(I),t(se),t(y),t(te),t(j),t(ae),t($),t(le),t(ne),t(U),t(pe),t(ie),t(k),t(oe),t(me),t(Je),t(g),t(re),t(V),t(we),t(ce),t(Te),t(D),t(ue),t(he),t(z),t(ge),t(Me),t(S),t(de),t(be),t(H),t(fe),t(Ie),t(Y),t(ye),t(je),t(X),t($e),t(Ce),t(M),t(Ue),t(ve),t(P)),t(h),T(d,e),T(b,e),T(C,e),T(v,e),T(Z,e),T(W,e),T(x,e),T(N,e),T(_,e),T(R,e),T(B,e),T(G,e),T(E,e),T(L,e),T(Q,e)}}}const ps='{"title":"Image-to-Image Task Guide","local":"image-to-image-task-guide","sections":[],"depth":1}';function is(We){return Ke(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cs extends Ae{constructor(h){super(),Oe(this,h,is,ns,Pe,{})}}export{cs as component};
