import{s as Xt,f as Qt,o as Vt,n as Mt}from"../chunks/scheduler.25b97de1.js";import{S as Ft,i as At,g as i,s as a,r as m,A as Yt,h as r,f as l,c as n,j as Ht,u as d,x as p,k as rt,y as Nt,a as s,v as c,d as u,t as y,w}from"../chunks/index.d9030fc9.js";import{T as pt}from"../chunks/Tip.baa67368.js";import{C as J}from"../chunks/CodeBlock.e6cd0d95.js";import{D as xt}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{H as j,E as St}from"../chunks/EditOnGithub.91d95064.js";function zt(b){let o,h='If you’re new to <code>transformers.agents</code>, make sure to first read the main <a href="./agents">agents documentation</a>.';return{c(){o=i("p"),o.innerHTML=h},l(M){o=r(M,"P",{"data-svelte-h":!0}),p(o)!=="svelte-pp2axe"&&(o.innerHTML=h)},m(M,T){s(M,o,T)},p:Mt,d(M){M&&l(o)}}}function qt(b){let o,h='For an in-depth example of an efficient multi-agent implementation, see <a href="https://huggingface.co/blog/beating-gaia" rel="nofollow">how we pushed our multi-agent system to the top of the GAIA leaderboard</a>.';return{c(){o=i("p"),o.innerHTML=h},l(M){o=r(M,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1d151kq"&&(o.innerHTML=h)},m(M,T){s(M,o,T)},p:Mt,d(M){M&&l(o)}}}function Lt(b){let o,h="gradio-tools require <em>textual</em> inputs and outputs even when working with different modalities like image and audio objects. Image and audio inputs and outputs are currently incompatible.";return{c(){o=i("p"),o.innerHTML=h},l(M){o=r(M,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1vfyu6i"&&(o.innerHTML=h)},m(M,T){s(M,o,T)},p:Mt,d(M){M&&l(o)}}}function Dt(b){let o,h,M,T,I,ye,C,we,Z,he,g,Te,v,mt="In this page we’re going to highlight several advanced uses of <code>transformers.agents</code>.",Je,$,be,B,dt=`Multi-agent has been introduced in Microsoft’s framework <a href="https://huggingface.co/papers/2308.08155" rel="nofollow">Autogen</a>.
It simply means having several agents working together to solve your task instead of only one.
It empirically yields better performance on most benchmarks. The reason for this better performance is conceptually simple: for many tasks, rather than using a do-it-all system, you would prefer to specialize units on sub-tasks. Here, having agents with separate tool sets and memories allows to achieve efficient specialization.`,ge,W,ct="You can easily build hierarchical multi-agent systems with <code>transformers.agents</code>.",fe,G,ut='To do so, encapsulate the agent in a <a href="/docs/transformers/main/en/main_classes/agent#transformers.ManagedAgent">ManagedAgent</a> object. This object needs arguments <code>agent</code>, <code>name</code>, and a <code>description</code>, which will then be embedded in the manager agent’s system prompt to let it know how to call this managed agent, as we also do for tools.',Ue,_,yt="Here’s an example of making an agent that managed a specific web search agent using our <code>DuckDuckGoSearchTool</code>:",je,k,Ie,f,Ce,R,Ze,E,ve,H,wt="Let’s take again the tool example from main documentation, for which we had implemented a <code>tool</code> decorator.",$e,X,ht='If you need to add variation, like custom attributes for your tool, you can build your tool following the fine-grained method: building a class that inherits from the <a href="/docs/transformers/main/en/main_classes/agent#transformers.Tool">Tool</a> superclass.',Be,Q,Tt="The custom tool needs:",We,V,Jt="<li>An attribute <code>name</code>, which corresponds to the name of the tool itself. The name usually describes what the tool does. Since the code returns the model with the most downloads for a task, let’s name it <code>model_download_counter</code>.</li> <li>An attribute <code>description</code> is used to populate the agent’s system prompt.</li> <li>An <code>inputs</code> attribute, which is a dictionary with keys <code>&quot;type&quot;</code> and <code>&quot;description&quot;</code>. It contains information that helps the Python interpreter make educated choices about the input.</li> <li>An <code>output_type</code> attribute, which specifies the output type.</li> <li>A <code>forward</code> method which contains the inference code to be executed.</li>",Ge,F,bt='The types for both <code>inputs</code> and <code>output_type</code> should be amongst <a href="https://docs.pydantic.dev/latest/concepts/json_schema/#generating-json-schema" rel="nofollow">Pydantic formats</a>.',_e,A,ke,Y,gt="Now that the custom <code>HfModelDownloadsTool</code> class is ready, you can save it to a file named <code>model_downloads.py</code> and import it for use.",Re,N,Ee,x,ft='You can also share your custom tool to the Hub by calling <a href="/docs/transformers/main/en/main_classes/agent#transformers.Tool.push_to_hub">push_to_hub()</a> on the tool. Make sure you’ve created a repository for it on the Hub and are using a token with read access.',He,S,Xe,z,Ut="Load the tool with the <code>~Tool.load_tool</code> function and pass it to the <code>tools</code> parameter in your agent.",Qe,q,Ve,L,Fe,D,jt=`<a href="https://github.com/freddyaboulton/gradio-tools" rel="nofollow">gradio-tools</a> is a powerful library that allows using Hugging
Face Spaces as tools. It supports many existing Spaces as well as custom Spaces.`,Ae,P,It='Transformers supports <code>gradio_tools</code> with the <a href="/docs/transformers/main/en/main_classes/agent#transformers.Tool.from_gradio">Tool.from_gradio()</a> method. For example, let’s use the <a href="https://github.com/freddyaboulton/gradio-tools/blob/main/gradio_tools/tools/prompt_generator.py" rel="nofollow"><code>StableDiffusionPromptGeneratorTool</code></a> from <code>gradio-tools</code> toolkit for improving prompts to generate better images.',Ye,K,Ct="Import and instantiate the tool, then pass it to the <code>Tool.from_gradio</code> method:",Ne,O,xe,ee,Zt="Now you can use it just like any other tool. For example, let’s improve the prompt  <code>a rabbit wearing a space suit</code>.",Se,te,ze,le,vt="The model adequately leverages the tool:",qe,se,Le,ae,$t="Before finally generating the image:",De,ce,Bt,Pe,U,Ke,ne,Oe,oe,Wt=`We love Langchain and think it has a very compelling suite of tools.
To import a tool from LangChain, use the <code>from_langchain()</code> method.`,et,ie,Gt="Here is how you can use it to recreate the intro’s search result using a LangChain web search tool.",tt,re,lt,pe,st,Me,_t="You can leverage <code>gradio.Chatbot</code>to display your agent’s thoughts using <code>stream_to_gradio</code>, here is an example:",at,me,nt,de,ot,ue,it;return I=new j({props:{title:"Agents, supercharged - Multi-agents, External tools, and more",local:"agents-supercharged---multi-agents-external-tools-and-more",headingTag:"h1"}}),C=new xt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/agents_advanced.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/agents_advanced.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/agents_advanced.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/agents_advanced.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/agents_advanced.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/agents_advanced.ipynb"}]}}),Z=new j({props:{title:"What is an agent?",local:"what-is-an-agent",headingTag:"h3"}}),g=new pt({props:{warning:!1,$$slots:{default:[zt]},$$scope:{ctx:b}}}),$=new j({props:{title:"Multi-agents",local:"multi-agents",headingTag:"h2"}}),k=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBSZWFjdENvZGVBZ2VudCUyQyUyMEhmQXBpRW5naW5lJTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBNYW5hZ2VkQWdlbnQlMEElMEFsbG1fZW5naW5lJTIwJTNEJTIwSGZBcGlFbmdpbmUoKSUwQSUwQXdlYl9hZ2VudCUyMCUzRCUyMFJlYWN0Q29kZUFnZW50KHRvb2xzJTNEJTVCRHVja0R1Y2tHb1NlYXJjaFRvb2woKSU1RCUyQyUyMGxsbV9lbmdpbmUlM0RsbG1fZW5naW5lKSUwQSUwQW1hbmFnZWRfd2ViX2FnZW50JTIwJTNEJTIwTWFuYWdlZEFnZW50KCUwQSUyMCUyMCUyMCUyMGFnZW50JTNEd2ViX2FnZW50JTJDJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMndlYl9zZWFyY2glMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlJ1bnMlMjB3ZWIlMjBzZWFyY2hlcyUyMGZvciUyMHlvdS4lMjBHaXZlJTIwaXQlMjB5b3VyJTIwcXVlcnklMjBhcyUyMGFuJTIwYXJndW1lbnQuJTIyJTBBKSUwQSUwQW1hbmFnZXJfYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QiU1RCUyQyUyMGxsbV9lbmdpbmUlM0RsbG1fZW5naW5lJTJDJTIwbWFuYWdlZF9hZ2VudHMlM0QlNUJtYW5hZ2VkX3dlYl9hZ2VudCU1RCUwQSklMEElMEFtYW5hZ2VyX2FnZW50LnJ1biglMjJXaG8lMjBpcyUyMHRoZSUyMENFTyUyMG9mJTIwSHVnZ2luZyUyMEZhY2UlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> ReactCodeAgent, HfApiEngine, DuckDuckGoSearchTool, ManagedAgent

llm_engine = HfApiEngine()

web_agent = ReactCodeAgent(tools=[DuckDuckGoSearchTool()], llm_engine=llm_engine)

managed_web_agent = ManagedAgent(
    agent=web_agent,
    name=<span class="hljs-string">&quot;web_search&quot;</span>,
    description=<span class="hljs-string">&quot;Runs web searches for you. Give it your query as an argument.&quot;</span>
)

manager_agent = ReactCodeAgent(
    tools=[], llm_engine=llm_engine, managed_agents=[managed_web_agent]
)

manager_agent.run(<span class="hljs-string">&quot;Who is the CEO of Hugging Face?&quot;</span>)`,wrap:!1}}),f=new pt({props:{warning:!1,$$slots:{default:[qt]},$$scope:{ctx:b}}}),R=new j({props:{title:"Advanced tool usage",local:"advanced-tool-usage",headingTag:"h2"}}),E=new j({props:{title:"Directly define a tool by subclassing Tool, and share it to the Hub",local:"directly-define-a-tool-by-subclassing-tool-and-share-it-to-the-hub",headingTag:"h3"}}),A=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRvb2wlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEFjbGFzcyUyMEhGTW9kZWxEb3dubG9hZHNUb29sKFRvb2wpJTNBJTBBJTIwJTIwJTIwJTIwbmFtZSUyMCUzRCUyMCUyMm1vZGVsX2Rvd25sb2FkX2NvdW50ZXIlMjIlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUyMCUzRCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMFRoaXMlMjBpcyUyMGElMjB0b29sJTIwdGhhdCUyMHJldHVybnMlMjB0aGUlMjBtb3N0JTIwZG93bmxvYWRlZCUyMG1vZGVsJTIwb2YlMjBhJTIwZ2l2ZW4lMjB0YXNrJTIwb24lMjB0aGUlMjBIdWdnaW5nJTIwRmFjZSUyMEh1Yi4lMEElMjAlMjAlMjAlMjBJdCUyMHJldHVybnMlMjB0aGUlMjBuYW1lJTIwb2YlMjB0aGUlMjBjaGVja3BvaW50LiUyMiUyMiUyMiUwQSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRhc2slMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyc3RyaW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJ0aGUlMjB0YXNrJTIwY2F0ZWdvcnklMjAoc3VjaCUyMGFzJTIwdGV4dC1jbGFzc2lmaWNhdGlvbiUyQyUyMGRlcHRoLWVzdGltYXRpb24lMkMlMjBldGMpJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlMjAlM0QlMjAlMjJzdHJpbmclMjIlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjB0YXNrJTNBJTIwc3RyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwbmV4dChpdGVyKGxpc3RfbW9kZWxzKGZpbHRlciUzRHRhc2slMkMlMjBzb3J0JTNEJTIyZG93bmxvYWRzJTIyJTJDJTIwZGlyZWN0aW9uJTNELTEpKSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBtb2RlbC5pZA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub.
    It returns the name of the checkpoint.&quot;&quot;&quot;</span>

    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>`,wrap:!1}}),N=new J({props:{code:"ZnJvbSUyMG1vZGVsX2Rvd25sb2FkcyUyMGltcG9ydCUyMEhGTW9kZWxEb3dubG9hZHNUb29sJTBBJTBBdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> model_downloads <span class="hljs-keyword">import</span> HFModelDownloadsTool

tool = HFModelDownloadsTool()`,wrap:!1}}),S=new J({props:{code:"dG9vbC5wdXNoX3RvX2h1YiglMjIlN0J5b3VyX3VzZXJuYW1lJTdEJTJGaGYtbW9kZWwtZG93bmxvYWRzJTIyKQ==",highlighted:'tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>)',wrap:!1}}),q=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGxvYWRfdG9vbCUyQyUyMENvZGVBZ2VudCUwQSUwQW1vZGVsX2Rvd25sb2FkX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybS1yaWMlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(<span class="hljs-string">&quot;m-ric/hf-model-downloads&quot;</span>)`,wrap:!1}}),L=new j({props:{title:"Use gradio-tools",local:"use-gradio-tools",headingTag:"h3"}}),O=new J({props:{code:"ZnJvbSUyMGdyYWRpb190b29scyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblByb21wdEdlbmVyYXRvclRvb2wlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVG9vbCUyQyUyMGxvYWRfdG9vbCUyQyUyMENvZGVBZ2VudCUwQSUwQWdyYWRpb19wcm9tcHRfZ2VuZXJhdG9yX3Rvb2wlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25Qcm9tcHRHZW5lcmF0b3JUb29sKCklMEFwcm9tcHRfZ2VuZXJhdG9yX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fZ3JhZGlvKGdyYWRpb19wcm9tcHRfZ2VuZXJhdG9yX3Rvb2wp",highlighted:`<span class="hljs-keyword">from</span> gradio_tools <span class="hljs-keyword">import</span> StableDiffusionPromptGeneratorTool
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Tool, load_tool, CodeAgent

gradio_prompt_generator_tool = StableDiffusionPromptGeneratorTool()
prompt_generator_tool = Tool.from_gradio(gradio_prompt_generator_tool)`,wrap:!1}}),te=new J({props:{code:"aW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwbG9hZF90b29sKCdodWdnaW5nZmFjZS10b29scyUyRnRleHQtdG8taW1hZ2UnKSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCcHJvbXB0X2dlbmVyYXRvcl90b29sJTJDJTIwaW1hZ2VfZ2VuZXJhdGlvbl90b29sJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUpJTBBJTBBYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkltcHJvdmUlMjB0aGlzJTIwcHJvbXB0JTJDJTIwdGhlbiUyMGdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMG9mJTIwaXQuJTIyJTJDJTIwcHJvbXB0JTNEJ0ElMjByYWJiaXQlMjB3ZWFyaW5nJTIwYSUyMHNwYWNlJTIwc3VpdCclMEEp",highlighted:`image_generation_tool = load_tool(<span class="hljs-string">&#x27;huggingface-tools/text-to-image&#x27;</span>)
agent = CodeAgent(tools=[prompt_generator_tool, image_generation_tool], llm_engine=llm_engine)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, prompt=<span class="hljs-string">&#x27;A rabbit wearing a space suit&#x27;</span>
)`,wrap:!1}}),se=new J({props:{code:"JTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTIwTmV3JTIwdGFzayUyMCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUwQUltcHJvdmUlMjB0aGlzJTIwcHJvbXB0JTJDJTIwdGhlbiUyMGdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMG9mJTIwaXQuJTBBWW91JTIwaGF2ZSUyMGJlZW4lMjBwcm92aWRlZCUyMHdpdGglMjB0aGVzZSUyMGluaXRpYWwlMjBhcmd1bWVudHMlM0ElMjAlN0IncHJvbXB0JyUzQSUyMCdBJTIwcmFiYml0JTIwd2VhcmluZyUyMGElMjBzcGFjZSUyMHN1aXQnJTdELiUwQSUzRCUzRCUzRCUzRCUyMEFnZW50JTIwaXMlMjBleGVjdXRpbmclMjB0aGUlMjBjb2RlJTIwYmVsb3clM0ElMEFpbXByb3ZlZF9wcm9tcHQlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25Qcm9tcHRHZW5lcmF0b3IocXVlcnklM0Rwcm9tcHQpJTBBd2hpbGUlMjBpbXByb3ZlZF9wcm9tcHQlMjAlM0QlM0QlMjAlMjJRVUVVRV9GVUxMJTIyJTNBJTBBJTIwJTIwJTIwJTIwaW1wcm92ZWRfcHJvbXB0JTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUHJvbXB0R2VuZXJhdG9yKHF1ZXJ5JTNEcHJvbXB0KSUwQXByaW50KGYlMjJUaGUlMjBpbXByb3ZlZCUyMHByb21wdCUyMGlzJTIwJTdCaW1wcm92ZWRfcHJvbXB0JTdELiUyMiklMEFpbWFnZSUyMCUzRCUyMGltYWdlX2dlbmVyYXRvcihwcm9tcHQlM0RpbXByb3ZlZF9wcm9tcHQpJTBBJTNEJTNEJTNEJTNE",highlighted:`======== New task ========
Improve this prompt, then generate an image of it.
You have been provided with these initial arguments: {&#x27;prompt&#x27;: &#x27;A rabbit wearing a space suit&#x27;}.
==== Agent is executing the code below:
improved_prompt = StableDiffusionPromptGenerator(query=prompt)
while improved_prompt == &quot;QUEUE_FULL&quot;:
    improved_prompt = StableDiffusionPromptGenerator(query=prompt)
print(f&quot;The improved prompt is {improved_prompt}.&quot;)
image = image_generator(prompt=improved_prompt)
====`,wrap:!1}}),U=new pt({props:{warning:!0,$$slots:{default:[Lt]},$$scope:{ctx:b}}}),ne=new j({props:{title:"Use LangChain tools",local:"use-langchain-tools",headingTag:"h3"}}),re=new J({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRvb2wlMkMlMjBSZWFjdENvZGVBZ2VudCUwQSUwQXNlYXJjaF90b29sJTIwJTNEJTIwVG9vbC5mcm9tX2xhbmdjaGFpbihsb2FkX3Rvb2xzKCU1QiUyMnNlcnBhcGklMjIlNUQpJTVCMCU1RCklMEElMEFhZ2VudCUyMCUzRCUyMFJlYWN0Q29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQpJTBBJTBBYWdlbnQucnVuKCUyMkhvdyUyMG1hbnklMjBtb3JlJTIwYmxvY2tzJTIwKGFsc28lMjBkZW5vdGVkJTIwYXMlMjBsYXllcnMpJTIwaW4lMjBCRVJUJTIwYmFzZSUyMGVuY29kZXIlMjB0aGFuJTIwdGhlJTIwZW5jb2RlciUyMGZyb20lMjB0aGUlMjBhcmNoaXRlY3R1cmUlMjBwcm9wb3NlZCUyMGluJTIwQXR0ZW50aW9uJTIwaXMlMjBBbGwlMjBZb3UlMjBOZWVkJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Tool, ReactCodeAgent

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = ReactCodeAgent(tools=[search_tool])

agent.run(<span class="hljs-string">&quot;How many more blocks (also denoted as layers) in BERT base encoder than the encoder from the architecture proposed in Attention is All You Need?&quot;</span>)`,wrap:!1}}),pe=new j({props:{title:"Display your agent run in a cool Gradio interface",local:"display-your-agent-run-in-a-cool-gradio-interface",headingTag:"h2"}}),me=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    load_tool,
    ReactCodeAgent,
    HfApiEngine,
    stream_to_gradio,
)

<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>)

llm_engine = HfApiEngine(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)

<span class="hljs-comment"># Initialize the agent with the image generation tool</span>
agent = ReactCodeAgent(tools=[image_generation_tool], llm_engine=llm_engine)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">interact_with_agent</span>(<span class="hljs-params">task</span>):
    messages = []
    messages.append(gr.ChatMessage(role=<span class="hljs-string">&quot;user&quot;</span>, content=task))
    <span class="hljs-keyword">yield</span> messages
    <span class="hljs-keyword">for</span> msg <span class="hljs-keyword">in</span> stream_to_gradio(agent, task):
        messages.append(msg)
        <span class="hljs-keyword">yield</span> messages + [
            gr.ChatMessage(role=<span class="hljs-string">&quot;assistant&quot;</span>, content=<span class="hljs-string">&quot;⏳ Task not finished yet!&quot;</span>)
        ]
    <span class="hljs-keyword">yield</span> messages


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    text_input = gr.Textbox(lines=<span class="hljs-number">1</span>, label=<span class="hljs-string">&quot;Chat Message&quot;</span>, value=<span class="hljs-string">&quot;Make me a picture of the Statue of Liberty.&quot;</span>)
    submit = gr.Button(<span class="hljs-string">&quot;Run illustrator agent!&quot;</span>)
    chatbot = gr.Chatbot(
        label=<span class="hljs-string">&quot;Agent&quot;</span>,
        <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>,
        avatar_images=(
            <span class="hljs-literal">None</span>,
            <span class="hljs-string">&quot;https://em-content.zobj.net/source/twitter/53/robot-face_1f916.png&quot;</span>,
        ),
    )
    submit.click(interact_with_agent, [text_input], [chatbot])

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    demo.launch()`,wrap:!1}}),de=new St({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/agents_advanced.md"}}),{c(){o=i("meta"),h=a(),M=i("p"),T=a(),m(I.$$.fragment),ye=a(),m(C.$$.fragment),we=a(),m(Z.$$.fragment),he=a(),m(g.$$.fragment),Te=a(),v=i("p"),v.innerHTML=mt,Je=a(),m($.$$.fragment),be=a(),B=i("p"),B.innerHTML=dt,ge=a(),W=i("p"),W.innerHTML=ct,fe=a(),G=i("p"),G.innerHTML=ut,Ue=a(),_=i("p"),_.innerHTML=yt,je=a(),m(k.$$.fragment),Ie=a(),m(f.$$.fragment),Ce=a(),m(R.$$.fragment),Ze=a(),m(E.$$.fragment),ve=a(),H=i("p"),H.innerHTML=wt,$e=a(),X=i("p"),X.innerHTML=ht,Be=a(),Q=i("p"),Q.textContent=Tt,We=a(),V=i("ul"),V.innerHTML=Jt,Ge=a(),F=i("p"),F.innerHTML=bt,_e=a(),m(A.$$.fragment),ke=a(),Y=i("p"),Y.innerHTML=gt,Re=a(),m(N.$$.fragment),Ee=a(),x=i("p"),x.innerHTML=ft,He=a(),m(S.$$.fragment),Xe=a(),z=i("p"),z.innerHTML=Ut,Qe=a(),m(q.$$.fragment),Ve=a(),m(L.$$.fragment),Fe=a(),D=i("p"),D.innerHTML=jt,Ae=a(),P=i("p"),P.innerHTML=It,Ye=a(),K=i("p"),K.innerHTML=Ct,Ne=a(),m(O.$$.fragment),xe=a(),ee=i("p"),ee.innerHTML=Zt,Se=a(),m(te.$$.fragment),ze=a(),le=i("p"),le.textContent=vt,qe=a(),m(se.$$.fragment),Le=a(),ae=i("p"),ae.textContent=$t,De=a(),ce=i("img"),Pe=a(),m(U.$$.fragment),Ke=a(),m(ne.$$.fragment),Oe=a(),oe=i("p"),oe.innerHTML=Wt,et=a(),ie=i("p"),ie.textContent=Gt,tt=a(),m(re.$$.fragment),lt=a(),m(pe.$$.fragment),st=a(),Me=i("p"),Me.innerHTML=_t,at=a(),m(me.$$.fragment),nt=a(),m(de.$$.fragment),ot=a(),ue=i("p"),this.h()},l(e){const t=Yt("svelte-u9bgzb",document.head);o=r(t,"META",{name:!0,content:!0}),t.forEach(l),h=n(e),M=r(e,"P",{}),Ht(M).forEach(l),T=n(e),d(I.$$.fragment,e),ye=n(e),d(C.$$.fragment,e),we=n(e),d(Z.$$.fragment,e),he=n(e),d(g.$$.fragment,e),Te=n(e),v=r(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-dweok5"&&(v.innerHTML=mt),Je=n(e),d($.$$.fragment,e),be=n(e),B=r(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-oi9t2a"&&(B.innerHTML=dt),ge=n(e),W=r(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-pkiik5"&&(W.innerHTML=ct),fe=n(e),G=r(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-tfgyd4"&&(G.innerHTML=ut),Ue=n(e),_=r(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-bx601e"&&(_.innerHTML=yt),je=n(e),d(k.$$.fragment,e),Ie=n(e),d(f.$$.fragment,e),Ce=n(e),d(R.$$.fragment,e),Ze=n(e),d(E.$$.fragment,e),ve=n(e),H=r(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-e6ym1a"&&(H.innerHTML=wt),$e=n(e),X=r(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-14h7n8i"&&(X.innerHTML=ht),Be=n(e),Q=r(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-hid0wz"&&(Q.textContent=Tt),We=n(e),V=r(e,"UL",{"data-svelte-h":!0}),p(V)!=="svelte-he81o0"&&(V.innerHTML=Jt),Ge=n(e),F=r(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1tuw1rn"&&(F.innerHTML=bt),_e=n(e),d(A.$$.fragment,e),ke=n(e),Y=r(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-58l3g5"&&(Y.innerHTML=gt),Re=n(e),d(N.$$.fragment,e),Ee=n(e),x=r(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-9o4zlb"&&(x.innerHTML=ft),He=n(e),d(S.$$.fragment,e),Xe=n(e),z=r(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-n0ukpl"&&(z.innerHTML=Ut),Qe=n(e),d(q.$$.fragment,e),Ve=n(e),d(L.$$.fragment,e),Fe=n(e),D=r(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-c328x"&&(D.innerHTML=jt),Ae=n(e),P=r(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1883nj9"&&(P.innerHTML=It),Ye=n(e),K=r(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-6fvul5"&&(K.innerHTML=Ct),Ne=n(e),d(O.$$.fragment,e),xe=n(e),ee=r(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-14hvnbw"&&(ee.innerHTML=Zt),Se=n(e),d(te.$$.fragment,e),ze=n(e),le=r(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1ss743w"&&(le.textContent=vt),qe=n(e),d(se.$$.fragment,e),Le=n(e),ae=r(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-euaib0"&&(ae.textContent=$t),De=n(e),ce=r(e,"IMG",{src:!0}),Pe=n(e),d(U.$$.fragment,e),Ke=n(e),d(ne.$$.fragment,e),Oe=n(e),oe=r(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1rq40pf"&&(oe.innerHTML=Wt),et=n(e),ie=r(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-aqowof"&&(ie.textContent=Gt),tt=n(e),d(re.$$.fragment,e),lt=n(e),d(pe.$$.fragment,e),st=n(e),Me=r(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-vvfxr6"&&(Me.innerHTML=_t),at=n(e),d(me.$$.fragment,e),nt=n(e),d(de.$$.fragment,e),ot=n(e),ue=r(e,"P",{}),Ht(ue).forEach(l),this.h()},h(){rt(o,"name","hf:doc:metadata"),rt(o,"content",Pt),Qt(ce.src,Bt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png")||rt(ce,"src",Bt)},m(e,t){Nt(document.head,o),s(e,h,t),s(e,M,t),s(e,T,t),c(I,e,t),s(e,ye,t),c(C,e,t),s(e,we,t),c(Z,e,t),s(e,he,t),c(g,e,t),s(e,Te,t),s(e,v,t),s(e,Je,t),c($,e,t),s(e,be,t),s(e,B,t),s(e,ge,t),s(e,W,t),s(e,fe,t),s(e,G,t),s(e,Ue,t),s(e,_,t),s(e,je,t),c(k,e,t),s(e,Ie,t),c(f,e,t),s(e,Ce,t),c(R,e,t),s(e,Ze,t),c(E,e,t),s(e,ve,t),s(e,H,t),s(e,$e,t),s(e,X,t),s(e,Be,t),s(e,Q,t),s(e,We,t),s(e,V,t),s(e,Ge,t),s(e,F,t),s(e,_e,t),c(A,e,t),s(e,ke,t),s(e,Y,t),s(e,Re,t),c(N,e,t),s(e,Ee,t),s(e,x,t),s(e,He,t),c(S,e,t),s(e,Xe,t),s(e,z,t),s(e,Qe,t),c(q,e,t),s(e,Ve,t),c(L,e,t),s(e,Fe,t),s(e,D,t),s(e,Ae,t),s(e,P,t),s(e,Ye,t),s(e,K,t),s(e,Ne,t),c(O,e,t),s(e,xe,t),s(e,ee,t),s(e,Se,t),c(te,e,t),s(e,ze,t),s(e,le,t),s(e,qe,t),c(se,e,t),s(e,Le,t),s(e,ae,t),s(e,De,t),s(e,ce,t),s(e,Pe,t),c(U,e,t),s(e,Ke,t),c(ne,e,t),s(e,Oe,t),s(e,oe,t),s(e,et,t),s(e,ie,t),s(e,tt,t),c(re,e,t),s(e,lt,t),c(pe,e,t),s(e,st,t),s(e,Me,t),s(e,at,t),c(me,e,t),s(e,nt,t),c(de,e,t),s(e,ot,t),s(e,ue,t),it=!0},p(e,[t]){const kt={};t&2&&(kt.$$scope={dirty:t,ctx:e}),g.$set(kt);const Rt={};t&2&&(Rt.$$scope={dirty:t,ctx:e}),f.$set(Rt);const Et={};t&2&&(Et.$$scope={dirty:t,ctx:e}),U.$set(Et)},i(e){it||(u(I.$$.fragment,e),u(C.$$.fragment,e),u(Z.$$.fragment,e),u(g.$$.fragment,e),u($.$$.fragment,e),u(k.$$.fragment,e),u(f.$$.fragment,e),u(R.$$.fragment,e),u(E.$$.fragment,e),u(A.$$.fragment,e),u(N.$$.fragment,e),u(S.$$.fragment,e),u(q.$$.fragment,e),u(L.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(se.$$.fragment,e),u(U.$$.fragment,e),u(ne.$$.fragment,e),u(re.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(de.$$.fragment,e),it=!0)},o(e){y(I.$$.fragment,e),y(C.$$.fragment,e),y(Z.$$.fragment,e),y(g.$$.fragment,e),y($.$$.fragment,e),y(k.$$.fragment,e),y(f.$$.fragment,e),y(R.$$.fragment,e),y(E.$$.fragment,e),y(A.$$.fragment,e),y(N.$$.fragment,e),y(S.$$.fragment,e),y(q.$$.fragment,e),y(L.$$.fragment,e),y(O.$$.fragment,e),y(te.$$.fragment,e),y(se.$$.fragment,e),y(U.$$.fragment,e),y(ne.$$.fragment,e),y(re.$$.fragment,e),y(pe.$$.fragment,e),y(me.$$.fragment,e),y(de.$$.fragment,e),it=!1},d(e){e&&(l(h),l(M),l(T),l(ye),l(we),l(he),l(Te),l(v),l(Je),l(be),l(B),l(ge),l(W),l(fe),l(G),l(Ue),l(_),l(je),l(Ie),l(Ce),l(Ze),l(ve),l(H),l($e),l(X),l(Be),l(Q),l(We),l(V),l(Ge),l(F),l(_e),l(ke),l(Y),l(Re),l(Ee),l(x),l(He),l(Xe),l(z),l(Qe),l(Ve),l(Fe),l(D),l(Ae),l(P),l(Ye),l(K),l(Ne),l(xe),l(ee),l(Se),l(ze),l(le),l(qe),l(Le),l(ae),l(De),l(ce),l(Pe),l(Ke),l(Oe),l(oe),l(et),l(ie),l(tt),l(lt),l(st),l(Me),l(at),l(nt),l(ot),l(ue)),l(o),w(I,e),w(C,e),w(Z,e),w(g,e),w($,e),w(k,e),w(f,e),w(R,e),w(E,e),w(A,e),w(N,e),w(S,e),w(q,e),w(L,e),w(O,e),w(te,e),w(se,e),w(U,e),w(ne,e),w(re,e),w(pe,e),w(me,e),w(de,e)}}}const Pt='{"title":"Agents, supercharged - Multi-agents, External tools, and more","local":"agents-supercharged---multi-agents-external-tools-and-more","sections":[{"title":"What is an agent?","local":"what-is-an-agent","sections":[],"depth":3},{"title":"Multi-agents","local":"multi-agents","sections":[],"depth":2},{"title":"Advanced tool usage","local":"advanced-tool-usage","sections":[{"title":"Directly define a tool by subclassing Tool, and share it to the Hub","local":"directly-define-a-tool-by-subclassing-tool-and-share-it-to-the-hub","sections":[],"depth":3},{"title":"Use gradio-tools","local":"use-gradio-tools","sections":[],"depth":3},{"title":"Use LangChain tools","local":"use-langchain-tools","sections":[],"depth":3}],"depth":2},{"title":"Display your agent run in a cool Gradio interface","local":"display-your-agent-run-in-a-cool-gradio-interface","sections":[],"depth":2}],"depth":1}';function Kt(b){return Vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nl extends Ft{constructor(o){super(),At(this,o,Kt,Dt,Xt,{})}}export{nl as component};
