import{s as ro,o as io,n as dn}from"../chunks/scheduler.bdbef820.js";import{S as lo,i as co,g as a,s as o,r as u,A as mo,h as r,f as i,c as s,j as G,u as h,x as m,k as J,y as n,a as p,v as f,d as _,t as b,w as y}from"../chunks/index.33f81d56.js";import{T as xt}from"../chunks/Tip.34194030.js";import{D as U}from"../chunks/Docstring.64554317.js";import{C as vt}from"../chunks/CodeBlock.362b34a4.js";import{E as kt}from"../chunks/ExampleCodeBlock.4f2252c6.js";import{H as pn,E as po}from"../chunks/EditOnGithub.a9246e21.js";function go(B){let l,k=`A large number of these flags control the logits or the stopping criteria of the generation. Make sure you check
the <a href="https://huggingface.co/docs/transformers/internal/generation_utils" rel="nofollow">generate-related classes</a> for a full
description of the possible manipulations, as well as examples of their usage.`;return{c(){l=a("p"),l.innerHTML=k},l(g){l=r(g,"P",{"data-svelte-h":!0}),m(l)!=="svelte-1lhagsi"&&(l.innerHTML=k)},m(g,d){p(g,l,d)},p:dn,d(g){g&&i(l)}}}function uo(B){let l,k="Examples:",g,d,M;return d=new vt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdlbmVyYXRpb25Db25maWclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQSUwQSUyMyUyMEUuZy4lMjBjb25maWclMjB3YXMlMjBzYXZlZCUyMHVzaW5nJTIwKnNhdmVfcHJldHJhaW5lZCgnLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRicpKiUwQWdlbmVyYXRpb25fY29uZmlnLnNhdmVfcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJTIyKSUwQWdlbmVyYXRpb25fY29uZmlnJTIwJTNEJTIwR2VuZXJhdGlvbkNvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRiUyMiklMEElMEElMjMlMjBZb3UlMjBjYW4lMjBhbHNvJTIwc3BlY2lmeSUyMGNvbmZpZ3VyYXRpb24lMjBuYW1lcyUyMHRvJTIweW91ciUyMGdlbmVyYXRpb24lMjBjb25maWd1cmF0aW9uJTIwZmlsZSUwQWdlbmVyYXRpb25fY29uZmlnLnNhdmVfcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJTIyJTJDJTIwY29uZmlnX2ZpbGVfbmFtZSUzRCUyMm15X2NvbmZpZ3VyYXRpb24uanNvbiUyMiklMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYlMjIlMkMlMjAlMjJteV9jb25maWd1cmF0aW9uLmpzb24lMjIpJTBBJTBBJTIzJTIwSWYlMjB5b3UnZCUyMGxpa2UlMjB0byUyMHRyeSUyMGElMjBtaW5vciUyMHZhcmlhdGlvbiUyMHRvJTIwYW4lMjBleGlzdGluZyUyMGNvbmZpZ3VyYXRpb24lMkMlMjB5b3UlMjBjYW4lMjBhbHNvJTIwcGFzcyUyMGdlbmVyYXRpb24lMEElMjMlMjBhcmd1bWVudHMlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoKSU2MC4lMjBCZSUyMG1pbmRmdWwlMjB0aGF0JTIwdHlwb3MlMjBhbmQlMjB1bnVzZWQlMjBhcmd1bWVudHMlMjB3aWxsJTIwYmUlMjBpZ25vcmVkJTBBZ2VuZXJhdGlvbl9jb25maWclMkMlMjB1bnVzZWRfa3dhcmdzJTIwJTNEJTIwR2VuZXJhdGlvbkNvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIlMkMlMjB0b3BfayUzRDElMkMlMjBmb28lM0RGYWxzZSUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjByZXR1cm5fdW51c2VkX2t3YXJncyUzRFRydWUlMEEpJTBBZ2VuZXJhdGlvbl9jb25maWcudG9wX2slMEElMEF1bnVzZWRfa3dhcmdz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GenerationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># E.g. config was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You can also specify configuration names to your generation configuration file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>, config_file_name=<span class="hljs-string">&quot;my_configuration.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>, <span class="hljs-string">&quot;my_configuration.json&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you&#x27;d like to try a minor variation to an existing configuration, you can also pass generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># arguments to \`.from_pretrained()\`. Be mindful that typos and unused arguments will be ignored</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config, unused_kwargs = GenerationConfig.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, top_k=<span class="hljs-number">1</span>, foo=<span class="hljs-literal">False</span>, do_sample=<span class="hljs-literal">True</span>, return_unused_kwargs=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.top_k
<span class="hljs-number">1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>unused_kwargs
{<span class="hljs-string">&#x27;foo&#x27;</span>: <span class="hljs-literal">False</span>}`,wrap:!1}}),{c(){l=a("p"),l.textContent=k,g=o(),u(d.$$.fragment)},l(t){l=r(t,"P",{"data-svelte-h":!0}),m(l)!=="svelte-kvfsh7"&&(l.textContent=k),g=s(t),h(d.$$.fragment,t)},m(t,w){p(t,l,w),p(t,g,w),f(d,t,w),M=!0},p:dn,i(t){M||(_(d.$$.fragment,t),M=!0)},o(t){b(d.$$.fragment,t),M=!1},d(t){t&&(i(l),i(g)),y(d,t)}}}function ho(B){let l,k=`Most generation-controlling parameters are set in <code>generation_config</code> which, if not passed, will be set to the
model’s default generation configuration. You can override any <code>generation_config</code> by passing the corresponding
parameters to generate(), e.g. <code>.generate(inputs, num_beams=4, do_sample=True)</code>.`,g,d,M=`For an overview of generation strategies and code examples, check out the <a href="../generation_strategies">following
guide</a>.`;return{c(){l=a("p"),l.innerHTML=k,g=o(),d=a("p"),d.innerHTML=M},l(t){l=r(t,"P",{"data-svelte-h":!0}),m(l)!=="svelte-1c5u34l"&&(l.innerHTML=k),g=s(t),d=r(t,"P",{"data-svelte-h":!0}),m(d)!=="svelte-fvlq1g"&&(d.innerHTML=M)},m(t,w){p(t,l,w),p(t,g,w),p(t,d,w)},p:dn,d(t){t&&(i(l),i(g),i(d))}}}function fo(B){let l,k="Examples:",g,d,M;return d=new vt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token_id = tokenizer.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 1: Print the scores for each token generated with Greedy Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, normalize_logits=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_length is the length of the input prompt for decoder-only models, like the GPT family, and 1 for</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># encoder-decoder models, like BART or T5.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = <span class="hljs-number">1</span> <span class="hljs-keyword">if</span> model.config.is_encoder_decoder <span class="hljs-keyword">else</span> inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = outputs.sequences[:, input_length:]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> tok, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(generated_tokens[<span class="hljs-number">0</span>], transition_scores[<span class="hljs-number">0</span>]):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># | token | token string | log probability | probability</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;| <span class="hljs-subst">{tok:5d}</span> | <span class="hljs-subst">{tokenizer.decode(tok):8s}</span> | <span class="hljs-subst">{score.numpy():<span class="hljs-number">.3</span>f}</span> | <span class="hljs-subst">{np.exp(score.numpy()):<span class="hljs-number">.2</span>%}</span>&quot;</span>)
|   <span class="hljs-number">262</span> |  the     | -<span class="hljs-number">1.414</span> | <span class="hljs-number">24.33</span>%
|  <span class="hljs-number">1110</span> |  day     | -<span class="hljs-number">2.609</span> | <span class="hljs-number">7.36</span>%
|   <span class="hljs-number">618</span> |  when    | -<span class="hljs-number">2.010</span> | <span class="hljs-number">13.40</span>%
|   <span class="hljs-number">356</span> |  we      | -<span class="hljs-number">1.859</span> | <span class="hljs-number">15.58</span>%
|   <span class="hljs-number">460</span> |  can     | -<span class="hljs-number">2.508</span> | <span class="hljs-number">8.14</span>%

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 2: Reconstruct the sequence scores from Beam Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    return_dict_in_generate=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    output_scores=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=<span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you sum the generated tokens&#x27; scores and apply the length penalty, you&#x27;ll get the sequence scores.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip 1: recomputing the scores is only guaranteed to match with \`normalize_logits=False\`. Depending on the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use case, you might want to recompute it with \`normalize_logits=True\`.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip 2: the output length does NOT include the input length</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_length = np.<span class="hljs-built_in">sum</span>(transition_scores.numpy() &lt; <span class="hljs-number">0</span>, axis=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>length_penalty = model.generation_config.length_penalty
<span class="hljs-meta">&gt;&gt;&gt; </span>reconstructed_scores = transition_scores.<span class="hljs-built_in">sum</span>(axis=<span class="hljs-number">1</span>) / (output_length**length_penalty)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(np.allclose(outputs.sequences_scores, reconstructed_scores))
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){l=a("p"),l.textContent=k,g=o(),u(d.$$.fragment)},l(t){l=r(t,"P",{"data-svelte-h":!0}),m(l)!=="svelte-kvfsh7"&&(l.textContent=k),g=s(t),h(d.$$.fragment,t)},m(t,w){p(t,l,w),p(t,g,w),f(d,t,w),M=!0},p:dn,i(t){M||(_(d.$$.fragment,t),M=!0)},o(t){b(d.$$.fragment,t),M=!1},d(t){t&&(i(l),i(g)),y(d,t)}}}function _o(B){let l,k=`Most generation-controlling parameters are set in <code>generation_config</code> which, if not passed, will be set to the
model’s default generation configuration. You can override any <code>generation_config</code> by passing the corresponding
parameters to generate, e.g. <code>.generate(inputs, num_beams=4, do_sample=True)</code>.`,g,d,M=`For an overview of generation strategies and code examples, check out the <a href="../generation_strategies">following
guide</a>.`;return{c(){l=a("p"),l.innerHTML=k,g=o(),d=a("p"),d.innerHTML=M},l(t){l=r(t,"P",{"data-svelte-h":!0}),m(l)!=="svelte-1pahvb2"&&(l.innerHTML=k),g=s(t),d=r(t,"P",{"data-svelte-h":!0}),m(d)!=="svelte-fvlq1g"&&(d.innerHTML=M)},m(t,w){p(t,l,w),p(t,g,w),p(t,d,w)},p:dn,d(t){t&&(i(l),i(g),i(d))}}}function bo(B){let l,k="Examples:",g,d,M;return d=new vt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, TFAutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token_id = tokenizer.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today is&quot;</span>], return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 1: Print the scores for each token generated with Greedy Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, normalize_logits=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_length is the length of the input prompt for decoder-only models, like the GPT family, and 1 for</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># encoder-decoder models, like BART or T5.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = <span class="hljs-number">1</span> <span class="hljs-keyword">if</span> model.config.is_encoder_decoder <span class="hljs-keyword">else</span> inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = outputs.sequences[:, input_length:]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> tok, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(generated_tokens[<span class="hljs-number">0</span>], transition_scores[<span class="hljs-number">0</span>]):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># | token | token string | logits | probability</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;| <span class="hljs-subst">{tok:5d}</span> | <span class="hljs-subst">{tokenizer.decode(tok):8s}</span> | <span class="hljs-subst">{score.numpy():<span class="hljs-number">.3</span>f}</span> | <span class="hljs-subst">{np.exp(score.numpy()):<span class="hljs-number">.2</span>%}</span>&quot;</span>)
|   <span class="hljs-number">262</span> |  the     | -<span class="hljs-number">1.414</span> | <span class="hljs-number">24.33</span>%
|  <span class="hljs-number">1110</span> |  day     | -<span class="hljs-number">2.609</span> | <span class="hljs-number">7.36</span>%
|   <span class="hljs-number">618</span> |  when    | -<span class="hljs-number">2.010</span> | <span class="hljs-number">13.40</span>%
|   <span class="hljs-number">356</span> |  we      | -<span class="hljs-number">1.859</span> | <span class="hljs-number">15.58</span>%
|   <span class="hljs-number">460</span> |  can     | -<span class="hljs-number">2.508</span> | <span class="hljs-number">8.14</span>%

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 2: Reconstruct the sequence scores from Beam Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    return_dict_in_generate=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    output_scores=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=<span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you sum the generated tokens&#x27; scores and apply the length penalty, you&#x27;ll get the sequence scores.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip: recomputing the scores is only guaranteed to match with \`normalize_logits=False\`. Depending on the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use case, you might want to recompute it with \`normalize_logits=True\`.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_length = np.<span class="hljs-built_in">sum</span>(transition_scores.numpy() &lt; <span class="hljs-number">0</span>, axis=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>length_penalty = model.generation_config.length_penalty
<span class="hljs-meta">&gt;&gt;&gt; </span>reconstructed_scores = np.<span class="hljs-built_in">sum</span>(transition_scores, axis=<span class="hljs-number">1</span>) / (output_length**length_penalty)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(np.allclose(outputs.sequences_scores, reconstructed_scores))
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){l=a("p"),l.textContent=k,g=o(),u(d.$$.fragment)},l(t){l=r(t,"P",{"data-svelte-h":!0}),m(l)!=="svelte-kvfsh7"&&(l.textContent=k),g=s(t),h(d.$$.fragment,t)},m(t,w){p(t,l,w),p(t,g,w),f(d,t,w),M=!0},p:dn,i(t){M||(_(d.$$.fragment,t),M=!0)},o(t){b(d.$$.fragment,t),M=!1},d(t){t&&(i(l),i(g)),y(d,t)}}}function yo(B){let l,k,g,d,M,t,w,jt="각 프레임워크에는 해당하는 <code>GenerationMixin</code> 클래스에서 구현된 텍스트 생성을 위한 generate 메소드가 있습니다:",gn,te,Gt='<li>PyTorch에서는 <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>가 <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationMixin">GenerationMixin</a>에 구현되어 있습니다.</li> <li>TensorFlow에서는 <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.TFGenerationMixin.generate">generate()</a>가 <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.TFGenerationMixin">TFGenerationMixin</a>에 구현되어 있습니다.</li> <li>Flax/JAX에서는 <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.FlaxGenerationMixin.generate">generate()</a>가 <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.FlaxGenerationMixin">FlaxGenerationMixin</a>에 구현되어 있습니다.</li>',un,oe,Jt='사용하는 프레임워크에 상관없이, generate 메소드는 <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> 클래스 인스턴스로 매개변수화 할 수 있습니다. generate 메소드의 동작을 제어하는 모든 생성 매개변수 목록을 확인하려면 이 클래스를 참조하세요.',hn,se,Ct='모델의 생성 설정을 어떻게 확인하고, 기본값이 무엇인지, 매개변수를 어떻게 임시로 변경하는지, 그리고 사용자 지정 생성 설정을 만들고 저장하는 방법을 배우려면 <a href="../generation_strategies">텍스트 생성 전략 가이드</a>를 참조하세요. 이 가이드는 토큰 스트리밍과 같은 관련 기능을 사용하는 방법도 설명합니다.',fn,ae,_n,T,re,Un,Ce,Ut=`Class that holds a configuration for a generation task. A <code>generate</code> call supports the following generation methods
for text-decoder, text-to-text, speech-to-text, and vision-to-text models:`,Bn,Ue,Bt="<li><em>greedy decoding</em> if <code>num_beams=1</code> and <code>do_sample=False</code></li> <li><em>contrastive search</em> if <code>penalty_alpha&gt;0.</code> and <code>top_k&gt;1</code></li> <li><em>multinomial sampling</em> if <code>num_beams=1</code> and <code>do_sample=True</code></li> <li><em>beam-search decoding</em> if <code>num_beams&gt;1</code> and <code>do_sample=False</code></li> <li><em>beam-search multinomial sampling</em> if <code>num_beams&gt;1</code> and <code>do_sample=True</code></li> <li><em>diverse beam-search decoding</em> if <code>num_beams&gt;1</code> and <code>num_beam_groups&gt;1</code></li> <li><em>constrained beam-search decoding</em> if <code>constraints!=None</code> or <code>force_words_ids!=None</code></li> <li><em>assisted decoding</em> if <code>assistant_model</code> or <code>prompt_lookup_num_tokens</code> is passed to <code>.generate()</code></li> <li><em>dola decoding</em> if <code>dola_layers</code> is passed to <code>.generate()</code></li>",Zn,Be,Zt='To learn more about decoding strategies refer to the <a href="../generation_strategies">text generation strategies guide</a>.',$n,S,In,z,ie,Wn,Ze,$t='Instantiate a <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> from a generation configuration file.',zn,E,Vn,q,le,Hn,$e,It=`Instantiates a <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> from a <a href="/docs/transformers/main/ko/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>. This function is useful to convert legacy
<a href="/docs/transformers/main/ko/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> objects, which may contain generation parameters, into a stand-alone <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>.`,Xn,D,ce,Fn,Ie,Wt=`Save a generation configuration object to the directory <code>save_directory</code>, so that it can be re-loaded using the
<a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationConfig.from_pretrained">from_pretrained()</a> class method.`,Rn,Y,de,Nn,We,zt=`Updates attributes of this class instance with attributes from <code>kwargs</code> if they match existing attributes,
returning all the unused kwargs.`,Ln,V,me,Sn,ze,Vt=`Validates the values of the attributes of the <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> instance. Raises exceptions in the presence
of parameterization that can be detected as incorrect from the configuration instance alone.`,En,Ve,Ht=`Note that some parameters not validated here are best validated at generate runtime, as they may depend on
other inputs and/or the model, such as parameters related to the generation length.`,qn,Q,pe,Dn,He,Xt='Returns the generation mode triggered by the <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> instance.',bn,I,ge,Yn,Xe,Ft=`Class that holds arguments for watermark generation and should be passed into <code>GenerationConfig</code> during <code>generate</code>.
See <a href="https://arxiv.org/abs/2306.04634" rel="nofollow">this paper</a> for more details on the arguments.`,Qn,Fe,Rt="Accepts the following keys:",An,Re,Nt=`<li>greenlist_ratio (<code>float</code>):
Used for watermarking. The ratio of “green” tokens used to the vocabulary size. Defaults to 0.25.</li> <li>bias (<code>float</code>):
Used with watermarking. The bias added to the selected “green” tokens’ logits. Defaults to 2.0.</li> <li>hashing_key (<code>int</code>):
Hashing key used for watermarking. Defaults to 15485863 (the millionth prime).</li> <li>seeding_scheme (<code>str</code>):
Algorithm to use for watermarking. Accepts values:<ul><li>“lefthash” (default): “green” tokens selection depend on the last token (Algorithm 2 from the paper)</li> <li>“selfhash”: “green” tokens selection depends on the current token itself (Algorithm 3 from the paper)
The downside of this scheme is that it considers all possible next tokens and can be slower than “lefthash”.</li></ul></li> <li>context_width(<code>int</code>):
The context length of previous tokens to use in seeding. Higher context length makes watermarking more robust.</li>`,yn,ue,Mn,v,he,On,Ne,Lt='A class containing all functions for auto-regressive text generation, to be used as a mixin in <a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>.',Pn,Le,St='The class exposes <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, which can be used for:',Kn,Se,Et="<li><em>greedy decoding</em> if <code>num_beams=1</code> and <code>do_sample=False</code></li> <li><em>contrastive search</em> if <code>penalty_alpha&gt;0</code> and <code>top_k&gt;1</code></li> <li><em>multinomial sampling</em> if <code>num_beams=1</code> and <code>do_sample=True</code></li> <li><em>beam-search decoding</em> if <code>num_beams&gt;1</code> and <code>do_sample=False</code></li> <li><em>beam-search multinomial sampling</em> if <code>num_beams&gt;1</code> and <code>do_sample=True</code></li> <li><em>diverse beam-search decoding</em> if <code>num_beams&gt;1</code> and <code>num_beam_groups&gt;1</code></li> <li><em>constrained beam-search decoding</em> if <code>constraints!=None</code> or <code>force_words_ids!=None</code></li> <li><em>assisted decoding</em> if <code>assistant_model</code> or <code>prompt_lookup_num_tokens</code> is passed to <code>.generate()</code></li>",et,Ee,qt='To learn more about decoding strategies refer to the <a href="../generation_strategies">text generation strategies guide</a>.',nt,H,fe,tt,qe,Dt="Generates sequences of token ids for models with a language modeling head.",ot,A,st,X,_e,at,De,Yt=`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`,rt,O,wn,be,Tn,j,ye,it,Ye,Qt='A class containing all of the functions supporting generation, to be used as a mixin in <a href="/docs/transformers/main/ko/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>.',lt,Qe,At='The class exposes <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.TFGenerationMixin.generate">generate()</a>, which can be used for:',ct,Ae,Ot=`<li><em>greedy decoding</em> by calling <code>greedy_search()</code> if <code>num_beams=1</code> and
<code>do_sample=False</code></li> <li><em>contrastive search</em> by calling <code>contrastive_search()</code> if <code>penalty_alpha&gt;0</code> and
<code>top_k&gt;1</code></li> <li><em>multinomial sampling</em> by calling <code>sample()</code> if <code>num_beams=1</code> and
<code>do_sample=True</code></li> <li><em>beam-search decoding</em> by calling <code>beam_search()</code> if <code>num_beams&gt;1</code></li>`,dt,Oe,Pt=`You do not need to call any of the above methods directly. Pass custom parameter values to ‘generate’ instead. To
learn more about decoding strategies refer to the <a href="../generation_strategies">text generation strategies guide</a>.`,mt,F,Me,pt,Pe,Kt="Generates sequences of token ids for models with a language modeling head.",gt,P,ut,R,we,ht,Ke,eo=`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`,ft,K,xn,Te,kn,C,xe,_t,en,no=`A class containing all functions for auto-regressive text generation, to be used as a mixin in
<a href="/docs/transformers/main/ko/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>.`,bt,nn,to='The class exposes <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.FlaxGenerationMixin.generate">generate()</a>, which can be used for:',yt,tn,oo=`<li><em>greedy decoding</em> by calling <code>_greedy_search()</code> if <code>num_beams=1</code> and
<code>do_sample=False</code></li> <li><em>multinomial sampling</em> by calling <code>_sample()</code> if <code>num_beams=1</code> and
<code>do_sample=True</code></li> <li><em>beam-search decoding</em> by calling <code>_beam_search()</code> if <code>num_beams&gt;1</code> and
<code>do_sample=False</code></li>`,Mt,on,so=`You do not need to call any of the above methods directly. Pass custom parameter values to ‘generate’ instead. To
learn more about decoding strategies refer to the <a href="../generation_strategies">text generation strategies guide</a>.`,wt,ee,ke,Tt,sn,ao="Generates sequences of token ids for models with a language modeling head.",vn,ve,jn,mn,Gn;return M=new pn({props:{title:"생성",local:"generation",headingTag:"h1"}}),ae=new pn({props:{title:"GenerationConfig",local:"transformers.GenerationConfig ][ transformers.GenerationConfig",headingTag:"h2"}}),re=new U({props:{name:"class transformers.GenerationConfig",anchor:"transformers.GenerationConfig",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L96",parameterGroups:[{title:"Parameters that control the length of the output",parametersDescription:[{anchor:"transformers.GenerationConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The maximum length the generated tokens can have. Corresponds to the length of the input prompt +
<code>max_new_tokens</code>. Its effect is overridden by <code>max_new_tokens</code>, if also set.`,name:"max_length"},{anchor:"transformers.GenerationConfig.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum numbers of tokens to generate, ignoring the number of tokens in the prompt.`,name:"max_new_tokens"},{anchor:"transformers.GenerationConfig.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The minimum length of the sequence to be generated. Corresponds to the length of the input prompt +
<code>min_new_tokens</code>. Its effect is overridden by <code>min_new_tokens</code>, if also set.`,name:"min_length"},{anchor:"transformers.GenerationConfig.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum numbers of tokens to generate, ignoring the number of tokens in the prompt.`,name:"min_new_tokens"},{anchor:"transformers.GenerationConfig.early_stopping",description:`<strong>early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"early_stopping"},{anchor:"transformers.GenerationConfig.max_time",description:`<strong>max_time</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The maximum amount of time you allow the computation to run for in seconds. generation will still finish
the current pass after allocated time has been passed.`,name:"max_time"},{anchor:"transformers.GenerationConfig.stop_strings",description:`<strong>stop_strings</strong> (<code>str or List[str]</code>, <em>optional</em>) &#x2014;
A string or a list of strings that should terminate generation if the model outputs them.`,name:"stop_strings"}]},{title:"Parameters that control the generation strategy used",parametersDescription:[{anchor:"transformers.GenerationConfig.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use sampling ; use greedy decoding otherwise.`,name:"do_sample"},{anchor:"transformers.GenerationConfig.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.GenerationConfig.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
<a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.GenerationConfig.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The values balance the model confidence and the degeneration penalty in contrastive search decoding.`,name:"penalty_alpha"},{anchor:"transformers.GenerationConfig.dola_layers",description:`<strong>dola_layers</strong> (<code>str</code> or <code>List[int]</code>, <em>optional</em>) &#x2014;
The layers to use for DoLa decoding. If <code>None</code>, DoLa decoding is not used. If a string, it must
be one of &#x201C;low&#x201D; or &#x201C;high&#x201D;, which means using the lower part or higher part of the model layers, respectively.
&#x201C;low&#x201D; means the first half of the layers up to the first 20 layers, and &#x201C;high&#x201D; means the last half of the
layers up to the last 20 layers.
If a list of integers, it must contain the indices of the layers to use for candidate premature layers in DoLa.
The 0-th layer is the word embedding layer of the model. Set to <code>&apos;low&apos;</code> to improve long-answer reasoning tasks,
<code>&apos;high&apos;</code> to improve short-answer tasks. Check the <a href="https://github.com/huggingface/transformers/blob/main/docs/source/en/generation_strategies.md" rel="nofollow">documentation</a>
or <a href="https://arxiv.org/abs/2309.03883" rel="nofollow">the paper</a> for more details.`,name:"dola_layers"}]},{title:"Parameters that control the cache",parametersDescription:[{anchor:"transformers.GenerationConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should use the past last key/values attentions (if applicable to the model) to
speed up decoding.`,name:"use_cache"},{anchor:"transformers.GenerationConfig.cache_implementation",description:`<strong>cache_implementation</strong> (<code>str</code>, <em>optional</em>, default to <code>None</code>) &#x2014;
Name of the cache class that will be instantiated in <code>generate</code>, for faster decoding. Possible values are:</p>
<ul>
<li><code>&quot;static&quot;</code>: <a href="/docs/transformers/main/ko/internal/generation_utils#transformers.StaticCache">StaticCache</a></li>
<li><code>&quot;offloaded_static&quot;</code>: <a href="/docs/transformers/main/ko/internal/generation_utils#transformers.OffloadedStaticCache">OffloadedStaticCache</a></li>
<li><code>&quot;sliding_window&quot;</code>: <a href="/docs/transformers/main/ko/internal/generation_utils#transformers.SlidingWindowCache">SlidingWindowCache</a></li>
<li><code>&quot;hybrid&quot;</code>: <a href="/docs/transformers/main/ko/internal/generation_utils#transformers.HybridCache">HybridCache</a></li>
<li><code>&quot;mamba&quot;</code>: <a href="/docs/transformers/main/ko/internal/generation_utils#transformers.MambaCache">MambaCache</a></li>
<li><code>&quot;quantized&quot;</code>: <a href="/docs/transformers/main/ko/internal/generation_utils#transformers.QuantizedCache">QuantizedCache</a></li>
</ul>
<p>We support other cache types, but they must be manually instantiated and
passed to <code>generate</code> through the <code>past_key_values</code> argument. See our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">cache documentation</a> for further information.`,name:"cache_implementation"},{anchor:"transformers.GenerationConfig.cache_config",description:`<strong>cache_config</strong> (<code>CacheConfig</code> or <code>dict</code>, <em>optional</em>, default to <code>None</code>) &#x2014;
Arguments used in the key-value cache class can be passed in <code>cache_config</code>. Can be passed as a <code>Dict</code> and
it will be converted to its repsective <code>CacheConfig</code> internally.
Otherwise can be passed as a <code>CacheConfig</code> class matching the indicated <code>cache_implementation</code>.`,name:"cache_config"},{anchor:"transformers.GenerationConfig.return_legacy_cache",description:`<strong>return_legacy_cache</strong> (<code>bool</code>, <em>optional</em>, default to <code>True</code>) &#x2014;
Whether to return the legacy or new format of the cache when <code>DynamicCache</code> is used by default.`,name:"return_legacy_cache"}]},{title:"Parameters for manipulation of the model output logits",parametersDescription:[{anchor:"transformers.GenerationConfig.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The value used to modulate the next token probabilities.`,name:"temperature"},{anchor:"transformers.GenerationConfig.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.GenerationConfig.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If set to float &lt; 1, only the smallest set of most probable tokens with probabilities that add up to
<code>top_p</code> or higher are kept for generation.`,name:"top_p"},{anchor:"transformers.GenerationConfig.min_p",description:`<strong>min_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Minimum token probability, which will be scaled by the probability of the most likely token. It must be a
value between 0 and 1. Typical values are in the 0.01-0.2 range, comparably selective as setting <code>top_p</code> in
the 0.99-0.8 range (use the opposite of normal <code>top_p</code> values).`,name:"min_p"},{anchor:"transformers.GenerationConfig.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Local typicality measures how similar the conditional probability of predicting a target token next is to
the expected conditional probability of predicting a random token next, given the partial text already
generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with probabilities that
add up to <code>typical_p</code> or higher are kept for generation. See <a href="https://arxiv.org/pdf/2202.00666.pdf" rel="nofollow">this
paper</a> for more details.`,name:"typical_p"},{anchor:"transformers.GenerationConfig.epsilon_cutoff",description:`<strong>epsilon_cutoff</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
If set to float strictly between 0 and 1, only tokens with a conditional probability greater than
<code>epsilon_cutoff</code> will be sampled. In the paper, suggested values range from 3e-4 to 9e-4, depending on the
size of the model. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"epsilon_cutoff"},{anchor:"transformers.GenerationConfig.eta_cutoff",description:`<strong>eta_cutoff</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Eta sampling is a hybrid of locally typical sampling and epsilon sampling. If set to float strictly between
0 and 1, a token is only considered if it is greater than either <code>eta_cutoff</code> or <code>sqrt(eta_cutoff) * exp(-entropy(softmax(next_token_logits)))</code>. The latter term is intuitively the expected next token
probability, scaled by <code>sqrt(eta_cutoff)</code>. In the paper, suggested values range from 3e-4 to 2e-3,
depending on the size of the model. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"eta_cutoff"},{anchor:"transformers.GenerationConfig.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. Note that <code>diversity_penalty</code> is only effective if <code>group beam search</code> is enabled.`,name:"diversity_penalty"},{anchor:"transformers.GenerationConfig.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"transformers.GenerationConfig.encoder_repetition_penalty",description:`<strong>encoder_repetition_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The paramater for encoder_repetition_penalty. An exponential penalty on sequences that are not in the
original input. 1.0 means no penalty.`,name:"encoder_repetition_penalty"},{anchor:"transformers.GenerationConfig.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.GenerationConfig.no_repeat_ngram_size",description:`<strong>no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to int &gt; 0, all ngrams of that size can only occur once.`,name:"no_repeat_ngram_size"},{anchor:"transformers.GenerationConfig.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>, <em>optional</em>) &#x2014;
List of list of token ids that are not allowed to be generated. Check
<a href="/docs/transformers/main/ko/internal/generation_utils#transformers.NoBadWordsLogitsProcessor">NoBadWordsLogitsProcessor</a> for further documentation and examples.`,name:"bad_words_ids"},{anchor:"transformers.GenerationConfig.force_words_ids",description:`<strong>force_words_ids</strong> (<code>List[List[int]]</code> or <code>List[List[List[int]]]</code>, <em>optional</em>) &#x2014;
List of token ids that must be generated. If given a <code>List[List[int]]</code>, this is treated as a simple list of
words that must be included, the opposite to <code>bad_words_ids</code>. If given <code>List[List[List[int]]]</code>, this
triggers a <a href="https://github.com/huggingface/transformers/issues/14081" rel="nofollow">disjunctive constraint</a>, where one
can allow different forms of each word.`,name:"force_words_ids"},{anchor:"transformers.GenerationConfig.renormalize_logits",description:`<strong>renormalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to renormalize the logits after applying all the logits processors (including the custom
ones). It&#x2019;s highly recommended to set this flag to <code>True</code> as the search algorithms suppose the score logits
are normalized but some logit processors break the normalization.`,name:"renormalize_logits"},{anchor:"transformers.GenerationConfig.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>, <em>optional</em>) &#x2014;
Custom constraints that can be added to the generation to ensure that the output will contain the use of
certain tokens as defined by <code>Constraint</code> objects, in the most sensible way possible.`,name:"constraints"},{anchor:"transformers.GenerationConfig.forced_bos_token_id",description:`<strong>forced_bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.forced_bos_token_id</code>) &#x2014;
The id of the token to force as the first generated token after the <code>decoder_start_token_id</code>. Useful for
multilingual models like <a href="../model_doc/mbart">mBART</a> where the first generated token needs to be the target
language token.`,name:"forced_bos_token_id"},{anchor:"transformers.GenerationConfig.forced_eos_token_id",description:"<strong>forced_eos_token_id</strong> (<code>int</code> or List[int]<code>, *optional*, defaults to </code>model.config.forced_eos_token_id<code>) -- The id of the token to force as the last generated token when </code>max_length` is reached. Optionally, use a\nlist to set multiple <em>end-of-sequence</em> tokens.",name:"forced_eos_token_id"},{anchor:"transformers.GenerationConfig.remove_invalid_values",description:`<strong>remove_invalid_values</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>model.config.remove_invalid_values</code>) &#x2014;
Whether to remove possible <em>nan</em> and <em>inf</em> outputs of the model to prevent the generation method to crash.
Note that using <code>remove_invalid_values</code> can slow down generation.`,name:"remove_invalid_values"},{anchor:"transformers.GenerationConfig.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>, <em>optional</em>) &#x2014;
This Tuple adds an exponentially increasing length penalty, after a certain amount of tokens have been
generated. The tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where
penalty starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.GenerationConfig.suppress_tokens",description:`<strong>suppress_tokens</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
A list of tokens that will be suppressed at generation. The <code>SupressTokens</code> logit processor will set their
log probs to <code>-inf</code> so that they are not sampled.`,name:"suppress_tokens"},{anchor:"transformers.GenerationConfig.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong>  (<code>List[int]</code>, <em>optional</em>) &#x2014;
A list of tokens that will be suppressed at the beginning of the generation. The <code>SupressBeginTokens</code> logit
processor will set their log probs to <code>-inf</code> so that they are not sampled.`,name:"begin_suppress_tokens"},{anchor:"transformers.GenerationConfig.forced_decoder_ids",description:`<strong>forced_decoder_ids</strong> (<code>List[List[int]]</code>, <em>optional</em>) &#x2014;
A list of pairs of integers which indicates a mapping from generation indices to token indices that will be
forced before sampling. For example, <code>[[1, 123]]</code> means the second generated token will always be a token
of index 123.`,name:"forced_decoder_ids"},{anchor:"transformers.GenerationConfig.sequence_bias",description:`<strong>sequence_bias</strong> (<code>Dict[Tuple[int], float]</code>, <em>optional</em>)) &#x2014;
Dictionary that maps a sequence of tokens to its bias term. Positive biases increase the odds of the
sequence being selected, while negative biases do the opposite. Check
<a href="/docs/transformers/main/ko/internal/generation_utils#transformers.SequenceBiasLogitsProcessor">SequenceBiasLogitsProcessor</a> for further documentation and examples.`,name:"sequence_bias"},{anchor:"transformers.GenerationConfig.token_healing",description:`<strong>token_healing</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Heal tail tokens of prompts by replacing them with their appropriate extensions.
This enhances the quality of completions for prompts affected by greedy tokenization bias.`,name:"token_healing"},{anchor:"transformers.GenerationConfig.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale &gt; 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality.`,name:"guidance_scale"},{anchor:"transformers.GenerationConfig.low_memory",description:`<strong>low_memory</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Switch to sequential beam search and sequential topk for contrastive search to reduce peak memory.
Used with beam search and contrastive search.`,name:"low_memory"},{anchor:"transformers.GenerationConfig.watermarking_config",description:`<strong>watermarking_config</strong> (<code>BaseWatermarkingConfig</code> or <code>dict</code>, <em>optional</em>) &#x2014;
Arguments used to watermark the model outputs by adding a small bias to randomly selected set of &#x201C;green&#x201D;
tokens. See the docs of <code>SynthIDTextWatermarkingConfig</code> and <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.WatermarkingConfig">WatermarkingConfig</a> for more
details. If passed as <code>Dict</code>, it will be converted to a <code>WatermarkingConfig</code> internally.`,name:"watermarking_config"}]},{title:"Parameters that define the output variables of generate",parametersDescription:[{anchor:"transformers.GenerationConfig.num_return_sequences",description:`<strong>num_return_sequences</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of independently computed returned sequences for each element in the batch.`,name:"num_return_sequences"},{anchor:"transformers.GenerationConfig.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationConfig.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationConfig.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationConfig.output_logits",description:`<strong>output_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the unprocessed prediction logit scores. See <code>logits</code> under returned tensors for
more details.`,name:"output_logits"},{anchor:"transformers.GenerationConfig.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/ko/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a>, as opposed to returning exclusively the generated
sequence. This flag must be set to <code>True</code> to return the generation cache (when <code>use_cache</code> is <code>True</code>)
or optional outputs (see flags starting with <code>output_</code>)`,name:"return_dict_in_generate"}]},{title:"Special tokens that can be used at generation time",parametersDescription:[{anchor:"transformers.GenerationConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>beginning-of-sequence</em> token.`,name:"bos_token_id"},{anchor:"transformers.GenerationConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}]},{title:"Generation parameters exclusive to encoder-decoder models",parametersDescription:[{anchor:"transformers.GenerationConfig.encoder_no_repeat_ngram_size",description:`<strong>encoder_no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to int &gt; 0, all ngrams of that size that occur in the <code>encoder_input_ids</code> cannot occur in the
<code>decoder_input_ids</code>.`,name:"encoder_no_repeat_ngram_size"},{anchor:"transformers.GenerationConfig.decoder_start_token_id",description:`<strong>decoder_start_token_id</strong> (<code>int</code> or <code>List[int]</code>, <em>optional</em>) &#x2014;
If an encoder-decoder model starts decoding with a different token than <em>bos</em>, the id of that token or a list of length
<code>batch_size</code>. Indicating a list enables different start ids for each element in the batch
(e.g. multilingual models with different target languages in one batch)`,name:"decoder_start_token_id"}]},{title:"Generation parameters exclusive to assistant generation",parametersDescription:[{anchor:"transformers.GenerationConfig.is_assistant",description:`<strong>is_assistant</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model is an assistant (draft) model.`,name:"is_assistant"},{anchor:"transformers.GenerationConfig.num_assistant_tokens",description:`<strong>num_assistant_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
Defines the number of <em>speculative tokens</em> that shall be generated by the assistant model before being
checked by the target model at each iteration. Higher values for <code>num_assistant_tokens</code> make the generation
more <em>speculative</em> : If the assistant model is performant larger speed-ups can be reached, if the assistant
model requires lots of corrections, lower speed-ups are reached.`,name:"num_assistant_tokens"},{anchor:"transformers.GenerationConfig.num_assistant_tokens_schedule",description:`<strong>num_assistant_tokens_schedule</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;constant&quot;</code>) &#x2014;
Defines the schedule at which max assistant tokens shall be changed during inference.<ul>
<li><code>&quot;heuristic&quot;</code>: When all speculative tokens are correct, increase <code>num_assistant_tokens</code> by 2 else
reduce by 1. <code>num_assistant_tokens</code> value is persistent over multiple generation calls with the same assistant model.</li>
<li><code>&quot;heuristic_transient&quot;</code>: Same as <code>&quot;heuristic&quot;</code> but <code>num_assistant_tokens</code> is reset to its initial value after each generation call.</li>
<li><code>&quot;constant&quot;</code>: <code>num_assistant_tokens</code> stays unchanged during generation</li>
</ul>`,name:"num_assistant_tokens_schedule"},{anchor:"transformers.GenerationConfig.assistant_confidence_threshold",description:`<strong>assistant_confidence_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.4) &#x2014;
The confidence threshold for the assistant model. If the assistant model&#x2019;s confidence in its prediction for the current token is lower
than this threshold, the assistant model stops the current token generation iteration, even if the number of <em>speculative tokens</em>
(defined by <code>num_assistant_tokens</code>) is not yet reached. It is an unsupervised version of the dynamic speculation lookahead
from Dynamic Speculation Lookahead Accelerates Speculative Decoding of Large Language Models <a href="https://arxiv.org/abs/2405.04304" rel="nofollow">https://arxiv.org/abs/2405.04304</a>.`,name:"assistant_confidence_threshold"},{anchor:"transformers.GenerationConfig.prompt_lookup_num_tokens",description:`<strong>prompt_lookup_num_tokens</strong> (<code>int</code>, <em>optional</em>, default to <code>None</code>) &#x2014;
The number of tokens to be output as candidate tokens.`,name:"prompt_lookup_num_tokens"},{anchor:"transformers.GenerationConfig.max_matching_ngram_size",description:`<strong>max_matching_ngram_size</strong> (<code>int</code>, <em>optional</em>, default to <code>None</code>) &#x2014;
The maximum ngram size to be considered for matching in the prompt. Default to 2 if not provided.`,name:"max_matching_ngram_size"}]},{title:"Wild card",parametersDescription:[]}]}}),S=new xt({props:{$$slots:{default:[go]},$$scope:{ctx:B}}}),ie=new U({props:{name:"from_pretrained",anchor:"transformers.GenerationConfig.from_pretrained",parameters:[{name:"pretrained_model_name",val:": Union"},{name:"config_file_name",val:": Union = None"},{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": Union = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.from_pretrained.pretrained_model_name",description:`<strong>pretrained_model_name</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained model configuration hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a configuration file saved using the
<a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationConfig.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"pretrained_model_name"},{anchor:"transformers.GenerationConfig.from_pretrained.config_file_name",description:`<strong>config_file_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>, defaults to <code>&quot;generation_config.json&quot;</code>) &#x2014;
Name of the generation configuration JSON file to be loaded from <code>pretrained_model_name</code>.`,name:"config_file_name"},{anchor:"transformers.GenerationConfig.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.GenerationConfig.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the configuration files and override the cached versions if
they exist.
resume_download &#x2014;
Deprecated and ignored. All downloads are now resumed by default when possible.
Will be removed in v5 of Transformers.`,name:"force_download"},{anchor:"transformers.GenerationConfig.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.GenerationConfig.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, or not specified, will use
the token generated when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.GenerationConfig.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>To test a pull request you made on the Hub, you can pass <code>revision=&quot;refs/pr/&lt;pr_number&gt;&quot;</code>.</p>

					</div>`,name:"revision"},{anchor:"transformers.GenerationConfig.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final configuration object.</p>
<p>If <code>True</code>, then this functions returns a <code>Tuple(config, unused_kwargs)</code> where <em>unused_kwargs</em> is a
dictionary consisting of the key/value pairs whose keys are not configuration attributes: i.e., the
part of <code>kwargs</code> which has not been used to update <code>config</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.GenerationConfig.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"transformers.GenerationConfig.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are configuration attributes will be used to override the loaded
values. Behavior concerning key/value pairs whose keys are <em>not</em> configuration attributes is controlled
by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L884",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The configuration object instantiated from this pretrained model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationConfig"
>GenerationConfig</a></p>
`}}),E=new kt({props:{anchor:"transformers.GenerationConfig.from_pretrained.example",$$slots:{default:[uo]},$$scope:{ctx:B}}}),le=new U({props:{name:"from_model_config",anchor:"transformers.GenerationConfig.from_model_config",parameters:[{name:"model_config",val:": PretrainedConfig"}],parametersDescription:[{anchor:"transformers.GenerationConfig.from_model_config.model_config",description:`<strong>model_config</strong> (<code>PretrainedConfig</code>) &#x2014;
The model config that will be used to instantiate the generation config.`,name:"model_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L1224",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The configuration object instantiated from those parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationConfig"
>GenerationConfig</a></p>
`}}),ce=new U({props:{name:"save_pretrained",anchor:"transformers.GenerationConfig.save_pretrained",parameters:[{name:"save_directory",val:": Union"},{name:"config_file_name",val:": Union = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the configuration JSON file will be saved (will be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.GenerationConfig.save_pretrained.config_file_name",description:`<strong>config_file_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>, defaults to <code>&quot;generation_config.json&quot;</code>) &#x2014;
Name of the generation configuration JSON file to be saved in <code>save_directory</code>.`,name:"config_file_name"},{anchor:"transformers.GenerationConfig.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.GenerationConfig.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/main/ko/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L806"}}),de=new U({props:{name:"update",anchor:"transformers.GenerationConfig.update",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.update.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary of attributes to tentatively update this class.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L1268",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary containing all the key-value pairs that were not used to update the instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),me=new U({props:{name:"validate",anchor:"transformers.GenerationConfig.validate",parameters:[{name:"is_init",val:" = False"}],parametersDescription:[{anchor:"transformers.GenerationConfig.validate.is_init",description:`<strong>is_init</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the validation is performed during the initialization of the instance.`,name:"is_init"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L557"}}),pe=new U({props:{name:"get_generation_mode",anchor:"transformers.GenerationConfig.get_generation_mode",parameters:[{name:"assistant_model",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.GenerationConfig.get_generation_mode.assistant_model",description:`<strong>assistant_model</strong> (<code>PreTrainedModel</code>, <em>optional</em>) &#x2014;
The assistant model to be used for assisted generation. If set, the generation mode will be
assisted generation.`,name:"assistant_model"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L499",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generation mode triggered by the instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>GenerationMode</code></p>
`}}),ge=new U({props:{name:"class transformers.WatermarkingConfig",anchor:"transformers.WatermarkingConfig",parameters:[{name:"greenlist_ratio",val:": Optional = 0.25"},{name:"bias",val:": Optional = 2.0"},{name:"hashing_key",val:": Optional = 15485863"},{name:"seeding_scheme",val:": Optional = 'lefthash'"},{name:"context_width",val:": Optional = 1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L1377"}}),ue=new pn({props:{title:"GenerationMixin",local:"transformers.GenerationMixin ][ transformers.GenerationMixin",headingTag:"h2"}}),he=new U({props:{name:"class transformers.GenerationMixin",anchor:"transformers.GenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L331"}}),fe=new U({props:{name:"generate",anchor:"transformers.GenerationMixin.generate",parameters:[{name:"inputs",val:": Optional = None"},{name:"generation_config",val:": Optional = None"},{name:"logits_processor",val:": Optional = None"},{name:"stopping_criteria",val:": Optional = None"},{name:"prefix_allowed_tokens_fn",val:": Optional = None"},{name:"synced_gpus",val:": Optional = None"},{name:"assistant_model",val:": Optional = None"},{name:"streamer",val:": Optional = None"},{name:"negative_prompt_ids",val:": Optional = None"},{name:"negative_prompt_attention_mask",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.generate.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should be in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.GenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which has the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.GenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.generate.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
Custom stopping criteria that complements the default stopping criteria built from arguments and a
generation config. If a stopping criteria is passed that is already created with the arguments or a
generation config an error is thrown. If your stopping criteria depends on the <code>scores</code> input, make
sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>. This feature is
intended for advanced users.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.generate.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>, <em>optional</em>) &#x2014;
If provided, this function constraints the beam search to allowed tokens only at each step. If not
provided no constraint is applied. This function takes 2 arguments: the batch ID <code>batch_id</code> and
<code>input_ids</code>. It has to return a list with the allowed tokens for the next generation step conditioned
on the batch ID <code>batch_id</code> and the previously generated tokens <code>inputs_ids</code>. This argument is useful
for constrained generation conditioned on the prefix, as described in <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity
Retrieval</a>.`,name:"prefix_allowed_tokens_fn"},{anchor:"transformers.GenerationMixin.generate.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to continue running the while loop until max_length. Unless overridden, this flag will be set
to <code>True</code> if using <code>FullyShardedDataParallel</code> or DeepSpeed ZeRO Stage 3 with multiple GPUs to avoid
deadlocking if one GPU finishes generating before other GPUs. Otherwise, defaults to <code>False</code>.`,name:"synced_gpus"},{anchor:"transformers.GenerationMixin.generate.assistant_model",description:`<strong>assistant_model</strong> (<code>PreTrainedModel</code>, <em>optional</em>) &#x2014;
An assistant model that can be used to accelerate generation. The assistant model must have the exact
same tokenizer. The acceleration is achieved when forecasting candidate tokens with the assistant model
is much faster than running generation with the model you&#x2019;re calling generate from. As such, the
assistant model should be much smaller.`,name:"assistant_model"},{anchor:"transformers.GenerationMixin.generate.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.`,name:"streamer"},{anchor:"transformers.GenerationMixin.generate.negative_prompt_ids",description:`<strong>negative_prompt_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
The negative prompt needed for some processors such as CFG. The batch size must match the input batch
size. This is an experimental feature, subject to breaking API changes in future versions.`,name:"negative_prompt_ids"},{anchor:"transformers.GenerationMixin.generate.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention_mask for <code>negative_prompt_ids</code>.`,name:"negative_prompt_attention_mask"},{anchor:"transformers.GenerationMixin.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generation_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L1884",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/ko/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code>
or when <code>config.return_dict_in_generate=True</code>) or a <code>torch.LongTensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/main/ko/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/main/ko/internal/generation_utils#transformers.generation.GenerateDecoderOnlyOutput"
>GenerateDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/main/ko/internal/generation_utils#transformers.generation.GenerateBeamDecoderOnlyOutput"
>GenerateBeamDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/main/ko/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/main/ko/internal/generation_utils#transformers.generation.GenerateEncoderDecoderOutput"
>GenerateEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/main/ko/internal/generation_utils#transformers.generation.GenerateBeamEncoderDecoderOutput"
>GenerateBeamEncoderDecoderOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/ko/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>torch.LongTensor</code></p>
`}}),A=new xt({props:{warning:!0,$$slots:{default:[ho]},$$scope:{ctx:B}}}),_e=new U({props:{name:"compute_transition_scores",anchor:"transformers.GenerationMixin.compute_transition_scores",parameters:[{name:"sequences",val:": Tensor"},{name:"scores",val:": Tuple"},{name:"beam_indices",val:": Optional = None"},{name:"normalize_logits",val:": bool = False"}],parametersDescription:[{anchor:"transformers.GenerationMixin.compute_transition_scores.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or
shorter if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.GenerationMixin.compute_transition_scores.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code>) &#x2014;
Transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.GenerationMixin.compute_transition_scores.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>. Only required if a <code>num_beams&gt;1</code> at
generate-time.`,name:"beam_indices"},{anchor:"transformers.GenerationMixin.compute_transition_scores.normalize_logits",description:`<strong>normalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the logits (which, for legacy reasons, may be unnormalized).`,name:"normalize_logits"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L1143",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>torch.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code> containing
the transition scores (logits)</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),O=new kt({props:{anchor:"transformers.GenerationMixin.compute_transition_scores.example",$$slots:{default:[fo]},$$scope:{ctx:B}}}),be=new pn({props:{title:"TFGenerationMixin",local:"transformers.TFGenerationMixin ][ transformers.TFGenerationMixin",headingTag:"h2"}}),ye=new U({props:{name:"class transformers.TFGenerationMixin",anchor:"transformers.TFGenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L444"}}),Me=new U({props:{name:"generate",anchor:"transformers.TFGenerationMixin.generate",parameters:[{name:"inputs",val:": Optional = None"},{name:"generation_config",val:": Optional = None"},{name:"logits_processor",val:": Optional = None"},{name:"seed",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFGenerationMixin.generate.inputs",description:`<strong>inputs</strong> (<code>tf.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should of in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.TFGenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.TFGenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.TFGenerationMixin.generate.seed",description:`<strong>seed</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Random seed to control sampling, containing two integers, used when <code>do_sample</code> is <code>True</code>. See the
<code>seed</code> argument from stateless functions in <code>tf.random</code>.`,name:"seed"},{anchor:"transformers.TFGenerationMixin.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L645",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/ko/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code> or when
<code>config.return_dict_in_generate=True</code>) or a <code>tf.Tensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/main/ko/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/main/ko/internal/generation_utils#transformers.generation.TFGreedySearchDecoderOnlyOutput"
>TFGreedySearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/main/ko/internal/generation_utils#transformers.generation.TFSampleDecoderOnlyOutput"
>TFSampleDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/main/ko/internal/generation_utils#transformers.generation.TFBeamSearchDecoderOnlyOutput"
>TFBeamSearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/main/ko/internal/generation_utils#transformers.generation.TFBeamSampleDecoderOnlyOutput"
>TFBeamSampleDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/main/ko/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/main/ko/internal/generation_utils#transformers.generation.TFGreedySearchEncoderDecoderOutput"
>TFGreedySearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/main/ko/internal/generation_utils#transformers.generation.TFSampleEncoderDecoderOutput"
>TFSampleEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/main/ko/internal/generation_utils#transformers.generation.TFBeamSearchEncoderDecoderOutput"
>TFBeamSearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/main/ko/internal/generation_utils#transformers.generation.TFBeamSampleEncoderDecoderOutput"
>TFBeamSampleEncoderDecoderOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/ko/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>tf.Tensor</code></p>
`}}),P=new xt({props:{warning:!0,$$slots:{default:[_o]},$$scope:{ctx:B}}}),we=new U({props:{name:"compute_transition_scores",anchor:"transformers.TFGenerationMixin.compute_transition_scores",parameters:[{name:"sequences",val:": Tensor"},{name:"scores",val:": Tuple"},{name:"beam_indices",val:": Optional = None"},{name:"normalize_logits",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFGenerationMixin.compute_transition_scores.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or
shorter if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code>) &#x2014;
Transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens Tuple of
<code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token), with each
tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>. Only required if a <code>num_beams&gt;1</code> at
generate-time.`,name:"beam_indices"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.normalize_logits",description:`<strong>normalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the logits (which, for legacy reasons, may be unnormalized).`,name:"normalize_logits"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L477",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code> containing
the transition scores (logits)</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code></p>
`}}),K=new kt({props:{anchor:"transformers.TFGenerationMixin.compute_transition_scores.example",$$slots:{default:[bo]},$$scope:{ctx:B}}}),Te=new pn({props:{title:"FlaxGenerationMixin",local:"transformers.FlaxGenerationMixin ][ transformers.FlaxGenerationMixin",headingTag:"h2"}}),xe=new U({props:{name:"class transformers.FlaxGenerationMixin",anchor:"transformers.FlaxGenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L130"}}),ke=new U({props:{name:"generate",anchor:"transformers.FlaxGenerationMixin.generate",parameters:[{name:"input_ids",val:": Array"},{name:"generation_config",val:": Optional = None"},{name:"prng_key",val:": Optional = None"},{name:"trace",val:": bool = True"},{name:"params",val:": Optional = None"},{name:"logits_processor",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxGenerationMixin.generate.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.FlaxGenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.FlaxGenerationMixin.generate.trace",description:`<strong>trace</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to trace generation. Setting <code>trace=False</code> should only be used for debugging and will lead to a
considerably slower runtime.`,name:"trace"},{anchor:"transformers.FlaxGenerationMixin.generate.params",description:`<strong>params</strong> (<code>Dict[str, jnp.ndarray]</code>, <em>optional</em>) &#x2014;
Optionally the model parameters can be passed. Can be useful for parallelized generation.`,name:"params"},{anchor:"transformers.FlaxGenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>FlaxLogitsProcessorList </code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.FlaxGenerationMixin.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L268",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/ko/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a>.</p>
`}}),ve=new po({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ko/main_classes/text_generation.md"}}),{c(){l=a("meta"),k=o(),g=a("p"),d=o(),u(M.$$.fragment),t=o(),w=a("p"),w.innerHTML=jt,gn=o(),te=a("ul"),te.innerHTML=Gt,un=o(),oe=a("p"),oe.innerHTML=Jt,hn=o(),se=a("p"),se.innerHTML=Ct,fn=o(),u(ae.$$.fragment),_n=o(),T=a("div"),u(re.$$.fragment),Un=o(),Ce=a("p"),Ce.innerHTML=Ut,Bn=o(),Ue=a("ul"),Ue.innerHTML=Bt,Zn=o(),Be=a("p"),Be.innerHTML=Zt,$n=o(),u(S.$$.fragment),In=o(),z=a("div"),u(ie.$$.fragment),Wn=o(),Ze=a("p"),Ze.innerHTML=$t,zn=o(),u(E.$$.fragment),Vn=o(),q=a("div"),u(le.$$.fragment),Hn=o(),$e=a("p"),$e.innerHTML=It,Xn=o(),D=a("div"),u(ce.$$.fragment),Fn=o(),Ie=a("p"),Ie.innerHTML=Wt,Rn=o(),Y=a("div"),u(de.$$.fragment),Nn=o(),We=a("p"),We.innerHTML=zt,Ln=o(),V=a("div"),u(me.$$.fragment),Sn=o(),ze=a("p"),ze.innerHTML=Vt,En=o(),Ve=a("p"),Ve.textContent=Ht,qn=o(),Q=a("div"),u(pe.$$.fragment),Dn=o(),He=a("p"),He.innerHTML=Xt,bn=o(),I=a("div"),u(ge.$$.fragment),Yn=o(),Xe=a("p"),Xe.innerHTML=Ft,Qn=o(),Fe=a("p"),Fe.textContent=Rt,An=o(),Re=a("ul"),Re.innerHTML=Nt,yn=o(),u(ue.$$.fragment),Mn=o(),v=a("div"),u(he.$$.fragment),On=o(),Ne=a("p"),Ne.innerHTML=Lt,Pn=o(),Le=a("p"),Le.innerHTML=St,Kn=o(),Se=a("ul"),Se.innerHTML=Et,et=o(),Ee=a("p"),Ee.innerHTML=qt,nt=o(),H=a("div"),u(fe.$$.fragment),tt=o(),qe=a("p"),qe.textContent=Dt,ot=o(),u(A.$$.fragment),st=o(),X=a("div"),u(_e.$$.fragment),at=o(),De=a("p"),De.textContent=Yt,rt=o(),u(O.$$.fragment),wn=o(),u(be.$$.fragment),Tn=o(),j=a("div"),u(ye.$$.fragment),it=o(),Ye=a("p"),Ye.innerHTML=Qt,lt=o(),Qe=a("p"),Qe.innerHTML=At,ct=o(),Ae=a("ul"),Ae.innerHTML=Ot,dt=o(),Oe=a("p"),Oe.innerHTML=Pt,mt=o(),F=a("div"),u(Me.$$.fragment),pt=o(),Pe=a("p"),Pe.textContent=Kt,gt=o(),u(P.$$.fragment),ut=o(),R=a("div"),u(we.$$.fragment),ht=o(),Ke=a("p"),Ke.textContent=eo,ft=o(),u(K.$$.fragment),xn=o(),u(Te.$$.fragment),kn=o(),C=a("div"),u(xe.$$.fragment),_t=o(),en=a("p"),en.innerHTML=no,bt=o(),nn=a("p"),nn.innerHTML=to,yt=o(),tn=a("ul"),tn.innerHTML=oo,Mt=o(),on=a("p"),on.innerHTML=so,wt=o(),ee=a("div"),u(ke.$$.fragment),Tt=o(),sn=a("p"),sn.textContent=ao,vn=o(),u(ve.$$.fragment),jn=o(),mn=a("p"),this.h()},l(e){const c=mo("svelte-u9bgzb",document.head);l=r(c,"META",{name:!0,content:!0}),c.forEach(i),k=s(e),g=r(e,"P",{}),G(g).forEach(i),d=s(e),h(M.$$.fragment,e),t=s(e),w=r(e,"P",{"data-svelte-h":!0}),m(w)!=="svelte-15l0uin"&&(w.innerHTML=jt),gn=s(e),te=r(e,"UL",{"data-svelte-h":!0}),m(te)!=="svelte-1rt4uuq"&&(te.innerHTML=Gt),un=s(e),oe=r(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-1v0d7l4"&&(oe.innerHTML=Jt),hn=s(e),se=r(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-76uueu"&&(se.innerHTML=Ct),fn=s(e),h(ae.$$.fragment,e),_n=s(e),T=r(e,"DIV",{class:!0});var x=G(T);h(re.$$.fragment,x),Un=s(x),Ce=r(x,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-14531m7"&&(Ce.innerHTML=Ut),Bn=s(x),Ue=r(x,"UL",{"data-svelte-h":!0}),m(Ue)!=="svelte-1p8wjok"&&(Ue.innerHTML=Bt),Zn=s(x),Be=r(x,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-1gtazd5"&&(Be.innerHTML=Zt),$n=s(x),h(S.$$.fragment,x),In=s(x),z=r(x,"DIV",{class:!0});var N=G(z);h(ie.$$.fragment,N),Wn=s(N),Ze=r(N,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-st3cta"&&(Ze.innerHTML=$t),zn=s(N),h(E.$$.fragment,N),N.forEach(i),Vn=s(x),q=r(x,"DIV",{class:!0});var je=G(q);h(le.$$.fragment,je),Hn=s(je),$e=r(je,"P",{"data-svelte-h":!0}),m($e)!=="svelte-1ek383b"&&($e.innerHTML=It),je.forEach(i),Xn=s(x),D=r(x,"DIV",{class:!0});var Ge=G(D);h(ce.$$.fragment,Ge),Fn=s(Ge),Ie=r(Ge,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-1oazotl"&&(Ie.innerHTML=Wt),Ge.forEach(i),Rn=s(x),Y=r(x,"DIV",{class:!0});var Je=G(Y);h(de.$$.fragment,Je),Nn=s(Je),We=r(Je,"P",{"data-svelte-h":!0}),m(We)!=="svelte-n0rwld"&&(We.innerHTML=zt),Je.forEach(i),Ln=s(x),V=r(x,"DIV",{class:!0});var L=G(V);h(me.$$.fragment,L),Sn=s(L),ze=r(L,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-hpbaje"&&(ze.innerHTML=Vt),En=s(L),Ve=r(L,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-1rsok5m"&&(Ve.textContent=Ht),L.forEach(i),qn=s(x),Q=r(x,"DIV",{class:!0});var Jn=G(Q);h(pe.$$.fragment,Jn),Dn=s(Jn),He=r(Jn,"P",{"data-svelte-h":!0}),m(He)!=="svelte-111z5df"&&(He.innerHTML=Xt),Jn.forEach(i),x.forEach(i),bn=s(e),I=r(e,"DIV",{class:!0});var ne=G(I);h(ge.$$.fragment,ne),Yn=s(ne),Xe=r(ne,"P",{"data-svelte-h":!0}),m(Xe)!=="svelte-8pa9bo"&&(Xe.innerHTML=Ft),Qn=s(ne),Fe=r(ne,"P",{"data-svelte-h":!0}),m(Fe)!=="svelte-1wzt57b"&&(Fe.textContent=Rt),An=s(ne),Re=r(ne,"UL",{"data-svelte-h":!0}),m(Re)!=="svelte-vgskhd"&&(Re.innerHTML=Nt),ne.forEach(i),yn=s(e),h(ue.$$.fragment,e),Mn=s(e),v=r(e,"DIV",{class:!0});var Z=G(v);h(he.$$.fragment,Z),On=s(Z),Ne=r(Z,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-1c6833z"&&(Ne.innerHTML=Lt),Pn=s(Z),Le=r(Z,"P",{"data-svelte-h":!0}),m(Le)!=="svelte-13q9jk6"&&(Le.innerHTML=St),Kn=s(Z),Se=r(Z,"UL",{"data-svelte-h":!0}),m(Se)!=="svelte-1655ho"&&(Se.innerHTML=Et),et=s(Z),Ee=r(Z,"P",{"data-svelte-h":!0}),m(Ee)!=="svelte-1gtazd5"&&(Ee.innerHTML=qt),nt=s(Z),H=r(Z,"DIV",{class:!0});var an=G(H);h(fe.$$.fragment,an),tt=s(an),qe=r(an,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-s5ko3x"&&(qe.textContent=Dt),ot=s(an),h(A.$$.fragment,an),an.forEach(i),st=s(Z),X=r(Z,"DIV",{class:!0});var rn=G(X);h(_e.$$.fragment,rn),at=s(rn),De=r(rn,"P",{"data-svelte-h":!0}),m(De)!=="svelte-1om47tb"&&(De.textContent=Yt),rt=s(rn),h(O.$$.fragment,rn),rn.forEach(i),Z.forEach(i),wn=s(e),h(be.$$.fragment,e),Tn=s(e),j=r(e,"DIV",{class:!0});var $=G(j);h(ye.$$.fragment,$),it=s($),Ye=r($,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-p630vp"&&(Ye.innerHTML=Qt),lt=s($),Qe=r($,"P",{"data-svelte-h":!0}),m(Qe)!=="svelte-qnvo3c"&&(Qe.innerHTML=At),ct=s($),Ae=r($,"UL",{"data-svelte-h":!0}),m(Ae)!=="svelte-fx738d"&&(Ae.innerHTML=Ot),dt=s($),Oe=r($,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-13kczdy"&&(Oe.innerHTML=Pt),mt=s($),F=r($,"DIV",{class:!0});var ln=G(F);h(Me.$$.fragment,ln),pt=s(ln),Pe=r(ln,"P",{"data-svelte-h":!0}),m(Pe)!=="svelte-s5ko3x"&&(Pe.textContent=Kt),gt=s(ln),h(P.$$.fragment,ln),ln.forEach(i),ut=s($),R=r($,"DIV",{class:!0});var cn=G(R);h(we.$$.fragment,cn),ht=s(cn),Ke=r(cn,"P",{"data-svelte-h":!0}),m(Ke)!=="svelte-1om47tb"&&(Ke.textContent=eo),ft=s(cn),h(K.$$.fragment,cn),cn.forEach(i),$.forEach(i),xn=s(e),h(Te.$$.fragment,e),kn=s(e),C=r(e,"DIV",{class:!0});var W=G(C);h(xe.$$.fragment,W),_t=s(W),en=r(W,"P",{"data-svelte-h":!0}),m(en)!=="svelte-rtac0l"&&(en.innerHTML=no),bt=s(W),nn=r(W,"P",{"data-svelte-h":!0}),m(nn)!=="svelte-24ndcz"&&(nn.innerHTML=to),yt=s(W),tn=r(W,"UL",{"data-svelte-h":!0}),m(tn)!=="svelte-ffjx8e"&&(tn.innerHTML=oo),Mt=s(W),on=r(W,"P",{"data-svelte-h":!0}),m(on)!=="svelte-13kczdy"&&(on.innerHTML=so),wt=s(W),ee=r(W,"DIV",{class:!0});var Cn=G(ee);h(ke.$$.fragment,Cn),Tt=s(Cn),sn=r(Cn,"P",{"data-svelte-h":!0}),m(sn)!=="svelte-s5ko3x"&&(sn.textContent=ao),Cn.forEach(i),W.forEach(i),vn=s(e),h(ve.$$.fragment,e),jn=s(e),mn=r(e,"P",{}),G(mn).forEach(i),this.h()},h(){J(l,"name","hf:doc:metadata"),J(l,"content",Mo),J(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){n(document.head,l),p(e,k,c),p(e,g,c),p(e,d,c),f(M,e,c),p(e,t,c),p(e,w,c),p(e,gn,c),p(e,te,c),p(e,un,c),p(e,oe,c),p(e,hn,c),p(e,se,c),p(e,fn,c),f(ae,e,c),p(e,_n,c),p(e,T,c),f(re,T,null),n(T,Un),n(T,Ce),n(T,Bn),n(T,Ue),n(T,Zn),n(T,Be),n(T,$n),f(S,T,null),n(T,In),n(T,z),f(ie,z,null),n(z,Wn),n(z,Ze),n(z,zn),f(E,z,null),n(T,Vn),n(T,q),f(le,q,null),n(q,Hn),n(q,$e),n(T,Xn),n(T,D),f(ce,D,null),n(D,Fn),n(D,Ie),n(T,Rn),n(T,Y),f(de,Y,null),n(Y,Nn),n(Y,We),n(T,Ln),n(T,V),f(me,V,null),n(V,Sn),n(V,ze),n(V,En),n(V,Ve),n(T,qn),n(T,Q),f(pe,Q,null),n(Q,Dn),n(Q,He),p(e,bn,c),p(e,I,c),f(ge,I,null),n(I,Yn),n(I,Xe),n(I,Qn),n(I,Fe),n(I,An),n(I,Re),p(e,yn,c),f(ue,e,c),p(e,Mn,c),p(e,v,c),f(he,v,null),n(v,On),n(v,Ne),n(v,Pn),n(v,Le),n(v,Kn),n(v,Se),n(v,et),n(v,Ee),n(v,nt),n(v,H),f(fe,H,null),n(H,tt),n(H,qe),n(H,ot),f(A,H,null),n(v,st),n(v,X),f(_e,X,null),n(X,at),n(X,De),n(X,rt),f(O,X,null),p(e,wn,c),f(be,e,c),p(e,Tn,c),p(e,j,c),f(ye,j,null),n(j,it),n(j,Ye),n(j,lt),n(j,Qe),n(j,ct),n(j,Ae),n(j,dt),n(j,Oe),n(j,mt),n(j,F),f(Me,F,null),n(F,pt),n(F,Pe),n(F,gt),f(P,F,null),n(j,ut),n(j,R),f(we,R,null),n(R,ht),n(R,Ke),n(R,ft),f(K,R,null),p(e,xn,c),f(Te,e,c),p(e,kn,c),p(e,C,c),f(xe,C,null),n(C,_t),n(C,en),n(C,bt),n(C,nn),n(C,yt),n(C,tn),n(C,Mt),n(C,on),n(C,wt),n(C,ee),f(ke,ee,null),n(ee,Tt),n(ee,sn),p(e,vn,c),f(ve,e,c),p(e,jn,c),p(e,mn,c),Gn=!0},p(e,[c]){const x={};c&2&&(x.$$scope={dirty:c,ctx:e}),S.$set(x);const N={};c&2&&(N.$$scope={dirty:c,ctx:e}),E.$set(N);const je={};c&2&&(je.$$scope={dirty:c,ctx:e}),A.$set(je);const Ge={};c&2&&(Ge.$$scope={dirty:c,ctx:e}),O.$set(Ge);const Je={};c&2&&(Je.$$scope={dirty:c,ctx:e}),P.$set(Je);const L={};c&2&&(L.$$scope={dirty:c,ctx:e}),K.$set(L)},i(e){Gn||(_(M.$$.fragment,e),_(ae.$$.fragment,e),_(re.$$.fragment,e),_(S.$$.fragment,e),_(ie.$$.fragment,e),_(E.$$.fragment,e),_(le.$$.fragment,e),_(ce.$$.fragment,e),_(de.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(ge.$$.fragment,e),_(ue.$$.fragment,e),_(he.$$.fragment,e),_(fe.$$.fragment,e),_(A.$$.fragment,e),_(_e.$$.fragment,e),_(O.$$.fragment,e),_(be.$$.fragment,e),_(ye.$$.fragment,e),_(Me.$$.fragment,e),_(P.$$.fragment,e),_(we.$$.fragment,e),_(K.$$.fragment,e),_(Te.$$.fragment,e),_(xe.$$.fragment,e),_(ke.$$.fragment,e),_(ve.$$.fragment,e),Gn=!0)},o(e){b(M.$$.fragment,e),b(ae.$$.fragment,e),b(re.$$.fragment,e),b(S.$$.fragment,e),b(ie.$$.fragment,e),b(E.$$.fragment,e),b(le.$$.fragment,e),b(ce.$$.fragment,e),b(de.$$.fragment,e),b(me.$$.fragment,e),b(pe.$$.fragment,e),b(ge.$$.fragment,e),b(ue.$$.fragment,e),b(he.$$.fragment,e),b(fe.$$.fragment,e),b(A.$$.fragment,e),b(_e.$$.fragment,e),b(O.$$.fragment,e),b(be.$$.fragment,e),b(ye.$$.fragment,e),b(Me.$$.fragment,e),b(P.$$.fragment,e),b(we.$$.fragment,e),b(K.$$.fragment,e),b(Te.$$.fragment,e),b(xe.$$.fragment,e),b(ke.$$.fragment,e),b(ve.$$.fragment,e),Gn=!1},d(e){e&&(i(k),i(g),i(d),i(t),i(w),i(gn),i(te),i(un),i(oe),i(hn),i(se),i(fn),i(_n),i(T),i(bn),i(I),i(yn),i(Mn),i(v),i(wn),i(Tn),i(j),i(xn),i(kn),i(C),i(vn),i(jn),i(mn)),i(l),y(M,e),y(ae,e),y(re),y(S),y(ie),y(E),y(le),y(ce),y(de),y(me),y(pe),y(ge),y(ue,e),y(he),y(fe),y(A),y(_e),y(O),y(be,e),y(ye),y(Me),y(P),y(we),y(K),y(Te,e),y(xe),y(ke),y(ve,e)}}}const Mo='{"title":"생성","local":"generation","sections":[{"title":"GenerationConfig","local":"transformers.GenerationConfig ][ transformers.GenerationConfig","sections":[],"depth":2},{"title":"GenerationMixin","local":"transformers.GenerationMixin ][ transformers.GenerationMixin","sections":[],"depth":2},{"title":"TFGenerationMixin","local":"transformers.TFGenerationMixin ][ transformers.TFGenerationMixin","sections":[],"depth":2},{"title":"FlaxGenerationMixin","local":"transformers.FlaxGenerationMixin ][ transformers.FlaxGenerationMixin","sections":[],"depth":2}],"depth":1}';function wo(B){return io(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Co extends lo{constructor(l){super(),co(this,l,wo,yo,ro,{})}}export{Co as component};
