import{s as pt,n as mt,o as ft}from"../chunks/scheduler.c57aa7ef.js";import{S as ut,i as dt,g as s,s as n,r as p,A as ht,h as o,f as l,c as i,j as ot,u as m,x as r,k as rt,y as ct,a,v as f,d as u,t as d,w as h}from"../chunks/index.c50cb18e.js";import{C as D}from"../chunks/CodeBlock.34f0a53d.js";import{H as K}from"../chunks/Heading.c7d7e0e7.js";function wt(Re){let c,te,O,le,w,ae,g,We="Quantization represents data with fewer bits, making it a useful technique for reducing memory-usage and accelerating inference especially when it comes to large language models (LLMs). There are several ways to quantize a model including:",ne,b,Xe='<li>optimizing which model weights are quantized with the <a href="https://hf.co/papers/2306.00978" rel="nofollow">AWQ</a> algorithm</li> <li>independently quantizing each row of a weight matrix with the <a href="https://hf.co/papers/2210.17323" rel="nofollow">GPTQ</a> algorithm</li> <li>quantizing to 8-bit and 4-bit precision with the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> library</li> <li>quantizing to as low as 2-bit precision with the <a href="https://arxiv.org/abs/2401.06118" rel="nofollow">AQLM</a> algorithm</li>',ie,M,He='However, after a model is quantized it isn’t typically further trained for downstream tasks because training can be unstable due to the lower precision of the weights and activations. But since PEFT methods only add <em>extra</em> trainable parameters, this allows you to train a quantized model with a PEFT adapter on top! Combining quantization with PEFT can be a good strategy for training even the largest models on a single GPU. For example, <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> is a method that quantizes a model to 4-bits and then trains it with LoRA. This method allows you to finetune a 65B parameter model on a single 48GB GPU!',se,T,Fe="In this guide, you’ll see how to quantize a model to 4-bits and train it with LoRA.",oe,y,re,J,Ge='<a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> is a quantization library with a Transformers integration. With this integration, you can quantize a model to 8 or 4-bits and enable many other options by configuring the <a href="https://huggingface.co/docs/transformers/v4.39.0/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a> class. For example, you can:',pe,_,Ee="<li>set <code>load_in_4bit=True</code> to quantize the model to 4-bits when you load it</li> <li>set <code>bnb_4bit_quant_type=&quot;nf4&quot;</code> to use a special 4-bit data type for weights initialized from a normal distribution</li> <li>set <code>bnb_4bit_use_double_quant=True</code> to use a nested quantization scheme to quantize the already quantized weights</li> <li>set <code>bnb_4bit_compute_dtype=torch.bfloat16</code> to use bfloat16 for faster computation</li>",me,$,fe,v,Ne='Pass the <code>config</code> to the <a href="https://huggingface.co/docs/transformers/v4.39.0/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method.',ue,q,de,L,Ve='Next, you should call the <a href="/docs/peft/v0.10.0/en/package_reference/peft_model#peft.prepare_model_for_kbit_training">prepare_model_for_kbit_training()</a> function to preprocess the quantized model for training.',he,C,ce,z,Ye="Now that the quantized model is ready, let’s set up a configuration.",we,B,ge,j,Pe='Create a <a href="/docs/peft/v0.10.0/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> with the following parameters (or choose your own):',be,x,Me,k,Se='Then use the <a href="/docs/peft/v0.10.0/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function to create a <a href="/docs/peft/v0.10.0/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> from the quantized model and configuration.',Te,Q,ye,Z,De="You’re all set for training with whichever training method you prefer!",Je,I,_e,A,Ke='<a href="https://hf.co/papers/2310.08659" rel="nofollow">LoftQ</a> initializes LoRA weights such that the quantization error is minimized, and it can improve performance when training quantized models. To get started, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',$e,U,Oe="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",ve,R,qe,W,et="QLoRA adds trainable weights to all the linear layers in the transformer architecture. Since the attribute names for these linear layers can vary across architectures, set <code>target_modules</code> to <code>&quot;all-linear&quot;</code> to add LoRA to all the linear layers:",Le,X,Ce,H,ze,F,tt='Additive Quantization of Language Models (<a href="https://arxiv.org/abs/2401.06118" rel="nofollow">AQLM</a>) is a Large Language Models compression method. It quantizes multiple weights together and takes advantage of interdependencies between them. AQLM represents groups of 8-16 weights as a sum of multiple vector codes. This allows it to compress models down to as low as 2-bit with considerably low accuracy losses.',Be,G,lt='Since the AQLM quantization process is computationally expensive, a use of prequantized models is recommended. A partial list of available models can be found in the official aqlm <a href="https://github.com/Vahe1994/AQLM" rel="nofollow">repository</a>.',je,E,at="The models support LoRA adapter tuning. To tune the quantized model you’ll need to install the <code>aqlm</code> inference library: <code>pip install aqlm&gt;=1.0.2</code>. Finetuned LoRA adapters shall be saved separately, as merging them with AQLM quantized weights is not possible.",xe,N,ke,V,nt='You can refer to the <a href="https://colab.research.google.com/drive/12GTp1FCj5_0SnnNQH18h_2XFh9vS_guX?usp=sharing" rel="nofollow">Google Colab</a> example for an overview of AQLM+LoRA finetuning.',Qe,Y,Ze,P,it="If you’re interested in learning more about quantization, the following may be helpful:",Ie,S,st='<li>Learn more about details about QLoRA and check out some benchmarks on its impact in the <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">Making LLMs even more accessible with bitsandbytes, 4-bit quantization and QLoRA</a> blog post.</li> <li>Read more about different quantization schemes in the Transformers <a href="https://hf.co/docs/transformers/main/quantization" rel="nofollow">Quantization</a> guide.</li>',Ae,ee,Ue;return w=new K({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),y=new K({props:{title:"Quantize a model",local:"quantize-a-model",headingTag:"h2"}}),$=new D({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
)`,wrap:!1}}),q=new D({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=config)`,wrap:!1}}),C=new D({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nJTBBJTBBbW9kZWwlMjAlM0QlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nKG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> prepare_model_for_kbit_training

model = prepare_model_for_kbit_training(model)`,wrap:!1}}),B=new K({props:{title:"LoraConfig",local:"loraconfig",headingTag:"h2"}}),x=new D({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJTIyb19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4wNSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)`,wrap:!1}}),Q=new D({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = get_peft_model(model, config)`,wrap:!1}}),I=new K({props:{title:"LoftQ initialization",local:"loftq-initialization",headingTag:"h3"}}),R=new K({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),X=new D({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),H=new K({props:{title:"AQLM quantization",local:"aqlm-quantization",headingTag:"h2"}}),N=new D({props:{code:"cXVhbnRpemVkX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkJsYWNrU2Ftb3JleiUyRk1peHRyYWwtOHg3Yi1BUUxNLTJCaXQtMXgxNi1oZi10ZXN0LWRpc3BhdGNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUlMkMlMEEpJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEElMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`quantized_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;BlackSamorez/Mixtral-8x7b-AQLM-2Bit-1x16-hf-test-dispatch&quot;</span>,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, low_cpu_mem_usage=<span class="hljs-literal">True</span>,
)

peft_config = LoraConfig(...)

quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),Y=new K({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){c=s("meta"),te=n(),O=s("p"),le=n(),p(w.$$.fragment),ae=n(),g=s("p"),g.textContent=We,ne=n(),b=s("ul"),b.innerHTML=Xe,ie=n(),M=s("p"),M.innerHTML=He,se=n(),T=s("p"),T.textContent=Fe,oe=n(),p(y.$$.fragment),re=n(),J=s("p"),J.innerHTML=Ge,pe=n(),_=s("ul"),_.innerHTML=Ee,me=n(),p($.$$.fragment),fe=n(),v=s("p"),v.innerHTML=Ne,ue=n(),p(q.$$.fragment),de=n(),L=s("p"),L.innerHTML=Ve,he=n(),p(C.$$.fragment),ce=n(),z=s("p"),z.textContent=Ye,we=n(),p(B.$$.fragment),ge=n(),j=s("p"),j.innerHTML=Pe,be=n(),p(x.$$.fragment),Me=n(),k=s("p"),k.innerHTML=Se,Te=n(),p(Q.$$.fragment),ye=n(),Z=s("p"),Z.textContent=De,Je=n(),p(I.$$.fragment),_e=n(),A=s("p"),A.innerHTML=Ke,$e=n(),U=s("p"),U.innerHTML=Oe,ve=n(),p(R.$$.fragment),qe=n(),W=s("p"),W.innerHTML=et,Le=n(),p(X.$$.fragment),Ce=n(),p(H.$$.fragment),ze=n(),F=s("p"),F.innerHTML=tt,Be=n(),G=s("p"),G.innerHTML=lt,je=n(),E=s("p"),E.innerHTML=at,xe=n(),p(N.$$.fragment),ke=n(),V=s("p"),V.innerHTML=nt,Qe=n(),p(Y.$$.fragment),Ze=n(),P=s("p"),P.textContent=it,Ie=n(),S=s("ul"),S.innerHTML=st,Ae=n(),ee=s("p"),this.h()},l(e){const t=ht("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(l),te=i(e),O=o(e,"P",{}),ot(O).forEach(l),le=i(e),m(w.$$.fragment,e),ae=i(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-famg4s"&&(g.textContent=We),ne=i(e),b=o(e,"UL",{"data-svelte-h":!0}),r(b)!=="svelte-27c91"&&(b.innerHTML=Xe),ie=i(e),M=o(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-142xot4"&&(M.innerHTML=He),se=i(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1demhiu"&&(T.textContent=Fe),oe=i(e),m(y.$$.fragment,e),re=i(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-15h8qn9"&&(J.innerHTML=Ge),pe=i(e),_=o(e,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-hfynw8"&&(_.innerHTML=Ee),me=i(e),m($.$$.fragment,e),fe=i(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-cj6wh7"&&(v.innerHTML=Ne),ue=i(e),m(q.$$.fragment,e),de=i(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-dxiygk"&&(L.innerHTML=Ve),he=i(e),m(C.$$.fragment,e),ce=i(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-11mx7fc"&&(z.textContent=Ye),we=i(e),m(B.$$.fragment,e),ge=i(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1ommq4o"&&(j.innerHTML=Pe),be=i(e),m(x.$$.fragment,e),Me=i(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-n0z4vw"&&(k.innerHTML=Se),Te=i(e),m(Q.$$.fragment,e),ye=i(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-xd402n"&&(Z.textContent=De),Je=i(e),m(I.$$.fragment,e),_e=i(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-f32n60"&&(A.innerHTML=Ke),$e=i(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-7f0aai"&&(U.innerHTML=Oe),ve=i(e),m(R.$$.fragment,e),qe=i(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1c7jiea"&&(W.innerHTML=et),Le=i(e),m(X.$$.fragment,e),Ce=i(e),m(H.$$.fragment,e),ze=i(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-h7ytse"&&(F.innerHTML=tt),Be=i(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-120mr43"&&(G.innerHTML=lt),je=i(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-wlm3ol"&&(E.innerHTML=at),xe=i(e),m(N.$$.fragment,e),ke=i(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1f1bzer"&&(V.innerHTML=nt),Qe=i(e),m(Y.$$.fragment,e),Ze=i(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-agdyn7"&&(P.textContent=it),Ie=i(e),S=o(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-83nivc"&&(S.innerHTML=st),Ae=i(e),ee=o(e,"P",{}),ot(ee).forEach(l),this.h()},h(){rt(c,"name","hf:doc:metadata"),rt(c,"content",gt)},m(e,t){ct(document.head,c),a(e,te,t),a(e,O,t),a(e,le,t),f(w,e,t),a(e,ae,t),a(e,g,t),a(e,ne,t),a(e,b,t),a(e,ie,t),a(e,M,t),a(e,se,t),a(e,T,t),a(e,oe,t),f(y,e,t),a(e,re,t),a(e,J,t),a(e,pe,t),a(e,_,t),a(e,me,t),f($,e,t),a(e,fe,t),a(e,v,t),a(e,ue,t),f(q,e,t),a(e,de,t),a(e,L,t),a(e,he,t),f(C,e,t),a(e,ce,t),a(e,z,t),a(e,we,t),f(B,e,t),a(e,ge,t),a(e,j,t),a(e,be,t),f(x,e,t),a(e,Me,t),a(e,k,t),a(e,Te,t),f(Q,e,t),a(e,ye,t),a(e,Z,t),a(e,Je,t),f(I,e,t),a(e,_e,t),a(e,A,t),a(e,$e,t),a(e,U,t),a(e,ve,t),f(R,e,t),a(e,qe,t),a(e,W,t),a(e,Le,t),f(X,e,t),a(e,Ce,t),f(H,e,t),a(e,ze,t),a(e,F,t),a(e,Be,t),a(e,G,t),a(e,je,t),a(e,E,t),a(e,xe,t),f(N,e,t),a(e,ke,t),a(e,V,t),a(e,Qe,t),f(Y,e,t),a(e,Ze,t),a(e,P,t),a(e,Ie,t),a(e,S,t),a(e,Ae,t),a(e,ee,t),Ue=!0},p:mt,i(e){Ue||(u(w.$$.fragment,e),u(y.$$.fragment,e),u($.$$.fragment,e),u(q.$$.fragment,e),u(C.$$.fragment,e),u(B.$$.fragment,e),u(x.$$.fragment,e),u(Q.$$.fragment,e),u(I.$$.fragment,e),u(R.$$.fragment,e),u(X.$$.fragment,e),u(H.$$.fragment,e),u(N.$$.fragment,e),u(Y.$$.fragment,e),Ue=!0)},o(e){d(w.$$.fragment,e),d(y.$$.fragment,e),d($.$$.fragment,e),d(q.$$.fragment,e),d(C.$$.fragment,e),d(B.$$.fragment,e),d(x.$$.fragment,e),d(Q.$$.fragment,e),d(I.$$.fragment,e),d(R.$$.fragment,e),d(X.$$.fragment,e),d(H.$$.fragment,e),d(N.$$.fragment,e),d(Y.$$.fragment,e),Ue=!1},d(e){e&&(l(te),l(O),l(le),l(ae),l(g),l(ne),l(b),l(ie),l(M),l(se),l(T),l(oe),l(re),l(J),l(pe),l(_),l(me),l(fe),l(v),l(ue),l(de),l(L),l(he),l(ce),l(z),l(we),l(ge),l(j),l(be),l(Me),l(k),l(Te),l(ye),l(Z),l(Je),l(_e),l(A),l($e),l(U),l(ve),l(qe),l(W),l(Le),l(Ce),l(ze),l(F),l(Be),l(G),l(je),l(E),l(xe),l(ke),l(V),l(Qe),l(Ze),l(P),l(Ie),l(S),l(Ae),l(ee)),l(c),h(w,e),h(y,e),h($,e),h(q,e),h(C,e),h(B,e),h(x,e),h(Q,e),h(I,e),h(R,e),h(X,e),h(H,e),h(N,e),h(Y,e)}}}const gt='{"title":"Quantization","local":"quantization","sections":[{"title":"Quantize a model","local":"quantize-a-model","sections":[],"depth":2},{"title":"LoraConfig","local":"loraconfig","sections":[{"title":"LoftQ initialization","local":"loftq-initialization","sections":[],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3}],"depth":2},{"title":"AQLM quantization","local":"aqlm-quantization","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function bt(Re){return ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _t extends ut{constructor(c){super(),dt(this,c,bt,wt,pt,{})}}export{_t as component};
