import{s as Dt,o as $t,n as xt}from"../chunks/scheduler.182ea377.js";import{S as Tt,i as St,g as r,s as i,r as g,A as Mt,h as l,f as t,c as s,j as T,u as h,x as c,k as S,y as a,a as o,v as _,d as b,t as v,w as P}from"../chunks/index.abf12888.js";import{T as Ct}from"../chunks/Tip.230e2334.js";import{D as j}from"../chunks/Docstring.93f6f462.js";import{C as kt}from"../chunks/CodeBlock.57fe6e13.js";import{E as It}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as Ae}from"../chunks/Heading.16916d63.js";function Lt(ie){let p,D='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){p=r("p"),p.innerHTML=D},l(u){p=l(u,"P",{"data-svelte-h":!0}),c(p)!=="svelte-1wmc0l4"&&(p.innerHTML=D)},m(u,y){o(u,p,y)},p:xt,d(u){u&&t(p)}}}function Ut(ie){let p,D="Examples:",u,y,w;return y=new kt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERQTVBhcmFsbGVsU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBhcmFkaWdtc1BpcGVsaW5lJTBBJTBBc2NoZWR1bGVyJTIwJTNEJTIwRERQTVBhcmFsbGVsU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiklMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGFyYWRpZ21zUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBbmdwdSUyQyUyMGJhdGNoX3Blcl9kZXZpY2UlMjAlM0QlMjB0b3JjaC5jdWRhLmRldmljZV9jb3VudCgpJTJDJTIwNSUwQXBpcGUud3JhcHBlZF91bmV0JTIwJTNEJTIwdG9yY2gubm4uRGF0YVBhcmFsbGVsKHBpcGUudW5ldCUyQyUyMGRldmljZV9pZHMlM0QlNUJkJTIwZm9yJTIwZCUyMGluJTIwcmFuZ2UobmdwdSklNUQpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBwYXJhbGxlbCUzRG5ncHUlMjAqJTIwYmF0Y2hfcGVyX2RldmljZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxMDAwKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMParallelScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionParadigmsPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = DDPMParallelScheduler.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionParadigmsPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, scheduler=scheduler, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>ngpu, batch_per_device = torch.cuda.device_count(), <span class="hljs-number">5</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.wrapped_unet = torch.nn.DataParallel(pipe.unet, device_ids=[d <span class="hljs-keyword">for</span> d <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(ngpu)])

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, parallel=ngpu * batch_per_device, num_inference_steps=<span class="hljs-number">1000</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){p=r("p"),p.textContent=D,u=i(),g(y.$$.fragment)},l(m){p=l(m,"P",{"data-svelte-h":!0}),c(p)!=="svelte-kvfsh7"&&(p.textContent=D),u=s(m),h(y.$$.fragment,m)},m(m,x){o(m,p,x),o(m,u,x),_(y,m,x),w=!0},p:xt,i(m){w||(b(y.$$.fragment,m),w=!0)},o(m){v(y.$$.fragment,m),w=!1},d(m){m&&(t(p),t(u)),P(y,m)}}}function Jt(ie){let p,D,u,y,w,m,x,it='<a href="https://huggingface.co/papers/2305.16317" rel="nofollow">Parallel Sampling of Diffusion Models</a> is by Andy Shih, Suneel Belkhale, Stefano Ermon, Dorsa Sadigh, Nima Anari.',he,A,st="The abstract from the paper is:",_e,E,at="<em>Diffusion models are powerful generative models but suffer from slow sampling, often taking 1000 sequential denoising steps for one sample. As a result, considerable efforts have been directed toward reducing the number of denoising steps, but these methods hurt sample quality. Instead of reducing the number of denoising steps (trading quality for speed), in this paper we explore an orthogonal approach: can we run the denoising steps in parallel (trading compute for speed)? In spite of the sequential nature of the denoising steps, we show that surprisingly it is possible to parallelize sampling via Picard iterations, by guessing the solution of future denoising steps and iteratively refining until convergence. With this insight, we present ParaDiGMS, a novel method to accelerate the sampling of pretrained diffusion models by denoising multiple steps in parallel. ParaDiGMS is the first diffusion sampling method that enables trading compute for speed and is even compatible with existing fast sampling techniques such as DDIM and DPMSolver. Using ParaDiGMS, we improve sampling speed by 2-4x across a range of robotics and image generation models, giving state-of-the-art sampling speeds of 0.2s on 100-step DiffusionPolicy and 16s on 1000-step StableDiffusion-v2 with no measurable degradation of task reward, FID score, or CLIP score.</em>",be,V,ot='The original codebase can be found at <a href="https://github.com/AndyShih12/paradigms" rel="nofollow">AndyShih12/paradigms</a>, and the pipeline was contributed by <a href="https://github.com/AndyShih12" rel="nofollow">AndyShih12</a>. ❤️',ve,Z,Pe,H,rt=`This pipeline improves sampling speed by running denoising steps in parallel, at the cost of increased total FLOPs.
Therefore, it is better to call this pipeline when running on multiple GPUs. Otherwise, without enough GPU bandwidth
sampling may be even slower than sequential sampling.`,ye,B,lt="The two parameters to play with are <code>parallel</code> (batch size) and <code>tolerance</code>.",we,F,dt=`<li>If it fits in memory, for a 1000-step DDPM you can aim for a batch size of around 100
(for example, 8 GPUs and <code>batch_per_device=12</code> to get <code>parallel=96</code>). A higher batch size
may not fit in memory, and lower batch size gives less parallelism.</li> <li>For tolerance, using a higher tolerance may get better speedups but can risk sample quality degradation.
If there is quality degradation with the default tolerance, then use a lower tolerance like <code>0.001</code>.</li>`,xe,R,pt=`For a 1000-step DDPM on 8 A100 GPUs, you can expect around a 3x speedup from <a href="/docs/diffusers/v0.22.2/en/api/pipelines/paradigms#diffusers.StableDiffusionParadigmsPipeline">StableDiffusionParadigmsPipeline</a> compared to the <a href="/docs/diffusers/v0.22.2/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>
by setting <code>parallel=80</code> and <code>tolerance=0.1</code>.`,De,q,ft=`🤗 Diffusers offers <a href="../training/distributed_inference">distributed inference support</a> for generating multiple prompts
in parallel on multiple GPUs. But <a href="/docs/diffusers/v0.22.2/en/api/pipelines/paradigms#diffusers.StableDiffusionParadigmsPipeline">StableDiffusionParadigmsPipeline</a> is designed for speeding up sampling of a single prompt by using multiple GPUs.`,$e,k,Te,z,Se,d,O,Ee,se,ct="Pipeline for text-to-image generation using a parallelized version of Stable Diffusion.",Ve,ae,mt=`This model inherits from <a href="/docs/diffusers/v0.22.2/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Ze,oe,ut="The pipeline also inherits the following loading methods:",He,re,gt='<li><a href="/docs/diffusers/v0.22.2/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/v0.22.2/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/v0.22.2/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/v0.22.2/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li>',Be,$,W,Fe,le,ht="The call function to the pipeline for generation.",Re,I,qe,L,Y,ze,de,_t=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Oe,U,Q,We,pe,bt=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ye,J,X,Qe,fe,vt=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Xe,G,K,Ke,ce,Pt=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,et,N,ee,tt,me,yt="Encodes the prompt into text encoder hidden states.",Me,te,Ce,M,ne,nt,ue,wt="Output class for Stable Diffusion pipelines.",ke,ge,Ie;return w=new Ae({props:{title:"Parallel Sampling of Diffusion Models",local:"parallel-sampling-of-diffusion-models",headingTag:"h1"}}),Z=new Ae({props:{title:"Tips",local:"tips",headingTag:"h2"}}),k=new Ct({props:{$$slots:{default:[Lt]},$$scope:{ctx:ie}}}),z=new Ae({props:{title:"StableDiffusionParadigmsPipeline",local:"diffusers.StableDiffusionParadigmsPipeline",headingTag:"h2"}}),O=new j({props:{name:"class diffusers.StableDiffusionParadigmsPipeline",anchor:"diffusers.StableDiffusionParadigmsPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionParadigmsPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.22.2/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.22.2/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.22.2/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.22.2/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.22.2/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.22.2/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.2/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_paradigms.py#L65"}}),W=new j({props:{name:"__call__",anchor:"diffusers.StableDiffusionParadigmsPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"parallel",val:": int = 10"},{name:"tolerance",val:": float = 0.1"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"debug",val:": bool = False"},{name:"clip_skip",val:": int = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionParadigmsPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.__call__.parallel",description:`<strong>parallel</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
The batch size to use when doing parallel sampling. More parallelism may lead to faster inference but
requires higher memory usage and can also require more total FLOPs.`,name:"parallel"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.__call__.tolerance",description:`<strong>tolerance</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The error tolerance for determining when to slide the batch window forward for parallel sampling. Lower
tolerance usually leads to less or no degradation. Higher tolerance is faster but can risk degradation
of sample quality. The tolerance is specified as a ratio of the scheduler&#x2019;s noise magnitude.`,name:"tolerance"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.22.2/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.22.2/en/api/pipelines/stable_diffusion/image_variation#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.__call__.debug",description:`<strong>debug</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to run in debug mode. In debug mode, <code>torch.cumsum</code> is evaluated using the CPU.`,name:"debug"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.2/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_paradigms.py#L508",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.22.2/en/api/pipelines/stable_diffusion/image_variation#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.22.2/en/api/pipelines/stable_diffusion/image_variation#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),I=new It({props:{anchor:"diffusers.StableDiffusionParadigmsPipeline.__call__.example",$$slots:{default:[Ut]},$$scope:{ctx:ie}}}),Y=new j({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionParadigmsPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.2/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_paradigms.py#L157"}}),Q=new j({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionParadigmsPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.2/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_paradigms.py#L174"}}),X=new j({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionParadigmsPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.2/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_paradigms.py#L149"}}),K=new j({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionParadigmsPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.2/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_paradigms.py#L165"}}),ee=new j({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionParadigmsPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionParadigmsPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionParadigmsPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.2/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_paradigms.py#L215"}}),te=new Ae({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),ne=new j({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"nsfw_content_detected",val:": typing.Optional[typing.List[bool]]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.2/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L11"}}),{c(){p=r("meta"),D=i(),u=r("p"),y=i(),g(w.$$.fragment),m=i(),x=r("p"),x.innerHTML=it,he=i(),A=r("p"),A.textContent=st,_e=i(),E=r("p"),E.innerHTML=at,be=i(),V=r("p"),V.innerHTML=ot,ve=i(),g(Z.$$.fragment),Pe=i(),H=r("p"),H.textContent=rt,ye=i(),B=r("p"),B.innerHTML=lt,we=i(),F=r("ul"),F.innerHTML=dt,xe=i(),R=r("p"),R.innerHTML=pt,De=i(),q=r("p"),q.innerHTML=ft,$e=i(),g(k.$$.fragment),Te=i(),g(z.$$.fragment),Se=i(),d=r("div"),g(O.$$.fragment),Ee=i(),se=r("p"),se.textContent=ct,Ve=i(),ae=r("p"),ae.innerHTML=mt,Ze=i(),oe=r("p"),oe.textContent=ut,He=i(),re=r("ul"),re.innerHTML=gt,Be=i(),$=r("div"),g(W.$$.fragment),Fe=i(),le=r("p"),le.textContent=ht,Re=i(),g(I.$$.fragment),qe=i(),L=r("div"),g(Y.$$.fragment),ze=i(),de=r("p"),de.innerHTML=_t,Oe=i(),U=r("div"),g(Q.$$.fragment),We=i(),pe=r("p"),pe.innerHTML=bt,Ye=i(),J=r("div"),g(X.$$.fragment),Qe=i(),fe=r("p"),fe.textContent=vt,Xe=i(),G=r("div"),g(K.$$.fragment),Ke=i(),ce=r("p"),ce.textContent=Pt,et=i(),N=r("div"),g(ee.$$.fragment),tt=i(),me=r("p"),me.textContent=yt,Me=i(),g(te.$$.fragment),Ce=i(),M=r("div"),g(ne.$$.fragment),nt=i(),ue=r("p"),ue.textContent=wt,ke=i(),ge=r("p"),this.h()},l(e){const n=Mt("svelte-u9bgzb",document.head);p=l(n,"META",{name:!0,content:!0}),n.forEach(t),D=s(e),u=l(e,"P",{}),T(u).forEach(t),y=s(e),h(w.$$.fragment,e),m=s(e),x=l(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-1naubok"&&(x.innerHTML=it),he=s(e),A=l(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-1cwsb16"&&(A.textContent=st),_e=s(e),E=l(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-atex3c"&&(E.innerHTML=at),be=s(e),V=l(e,"P",{"data-svelte-h":!0}),c(V)!=="svelte-r2abl6"&&(V.innerHTML=ot),ve=s(e),h(Z.$$.fragment,e),Pe=s(e),H=l(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-1u85qjg"&&(H.textContent=rt),ye=s(e),B=l(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-y1c0t7"&&(B.innerHTML=lt),we=s(e),F=l(e,"UL",{"data-svelte-h":!0}),c(F)!=="svelte-12b7bdp"&&(F.innerHTML=dt),xe=s(e),R=l(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-ugw21i"&&(R.innerHTML=pt),De=s(e),q=l(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-1als606"&&(q.innerHTML=ft),$e=s(e),h(k.$$.fragment,e),Te=s(e),h(z.$$.fragment,e),Se=s(e),d=l(e,"DIV",{class:!0});var f=T(d);h(O.$$.fragment,f),Ee=s(f),se=l(f,"P",{"data-svelte-h":!0}),c(se)!=="svelte-2s0fwr"&&(se.textContent=ct),Ve=s(f),ae=l(f,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-ksralz"&&(ae.innerHTML=mt),Ze=s(f),oe=l(f,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-14s6m4u"&&(oe.textContent=ut),He=s(f),re=l(f,"UL",{"data-svelte-h":!0}),c(re)!=="svelte-1khnixs"&&(re.innerHTML=gt),Be=s(f),$=l(f,"DIV",{class:!0});var C=T($);h(W.$$.fragment,C),Fe=s(C),le=l(C,"P",{"data-svelte-h":!0}),c(le)!=="svelte-50j04k"&&(le.textContent=ht),Re=s(C),h(I.$$.fragment,C),C.forEach(t),qe=s(f),L=l(f,"DIV",{class:!0});var Le=T(L);h(Y.$$.fragment,Le),ze=s(Le),de=l(Le,"P",{"data-svelte-h":!0}),c(de)!=="svelte-1s3c06i"&&(de.innerHTML=_t),Le.forEach(t),Oe=s(f),U=l(f,"DIV",{class:!0});var Ue=T(U);h(Q.$$.fragment,Ue),We=s(Ue),pe=l(Ue,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-pkn4ui"&&(pe.innerHTML=bt),Ue.forEach(t),Ye=s(f),J=l(f,"DIV",{class:!0});var Je=T(J);h(X.$$.fragment,Je),Qe=s(Je),fe=l(Je,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-14bnrb6"&&(fe.textContent=vt),Je.forEach(t),Xe=s(f),G=l(f,"DIV",{class:!0});var Ge=T(G);h(K.$$.fragment,Ge),Ke=s(Ge),ce=l(Ge,"P",{"data-svelte-h":!0}),c(ce)!=="svelte-1xwrf7t"&&(ce.textContent=Pt),Ge.forEach(t),et=s(f),N=l(f,"DIV",{class:!0});var Ne=T(N);h(ee.$$.fragment,Ne),tt=s(Ne),me=l(Ne,"P",{"data-svelte-h":!0}),c(me)!=="svelte-16q0ax1"&&(me.textContent=yt),Ne.forEach(t),f.forEach(t),Me=s(e),h(te.$$.fragment,e),Ce=s(e),M=l(e,"DIV",{class:!0});var je=T(M);h(ne.$$.fragment,je),nt=s(je),ue=l(je,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-1qpjiuf"&&(ue.textContent=wt),je.forEach(t),ke=s(e),ge=l(e,"P",{}),T(ge).forEach(t),this.h()},h(){S(p,"name","hf:doc:metadata"),S(p,"content",Gt),S($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){a(document.head,p),o(e,D,n),o(e,u,n),o(e,y,n),_(w,e,n),o(e,m,n),o(e,x,n),o(e,he,n),o(e,A,n),o(e,_e,n),o(e,E,n),o(e,be,n),o(e,V,n),o(e,ve,n),_(Z,e,n),o(e,Pe,n),o(e,H,n),o(e,ye,n),o(e,B,n),o(e,we,n),o(e,F,n),o(e,xe,n),o(e,R,n),o(e,De,n),o(e,q,n),o(e,$e,n),_(k,e,n),o(e,Te,n),_(z,e,n),o(e,Se,n),o(e,d,n),_(O,d,null),a(d,Ee),a(d,se),a(d,Ve),a(d,ae),a(d,Ze),a(d,oe),a(d,He),a(d,re),a(d,Be),a(d,$),_(W,$,null),a($,Fe),a($,le),a($,Re),_(I,$,null),a(d,qe),a(d,L),_(Y,L,null),a(L,ze),a(L,de),a(d,Oe),a(d,U),_(Q,U,null),a(U,We),a(U,pe),a(d,Ye),a(d,J),_(X,J,null),a(J,Qe),a(J,fe),a(d,Xe),a(d,G),_(K,G,null),a(G,Ke),a(G,ce),a(d,et),a(d,N),_(ee,N,null),a(N,tt),a(N,me),o(e,Me,n),_(te,e,n),o(e,Ce,n),o(e,M,n),_(ne,M,null),a(M,nt),a(M,ue),o(e,ke,n),o(e,ge,n),Ie=!0},p(e,[n]){const f={};n&2&&(f.$$scope={dirty:n,ctx:e}),k.$set(f);const C={};n&2&&(C.$$scope={dirty:n,ctx:e}),I.$set(C)},i(e){Ie||(b(w.$$.fragment,e),b(Z.$$.fragment,e),b(k.$$.fragment,e),b(z.$$.fragment,e),b(O.$$.fragment,e),b(W.$$.fragment,e),b(I.$$.fragment,e),b(Y.$$.fragment,e),b(Q.$$.fragment,e),b(X.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(ne.$$.fragment,e),Ie=!0)},o(e){v(w.$$.fragment,e),v(Z.$$.fragment,e),v(k.$$.fragment,e),v(z.$$.fragment,e),v(O.$$.fragment,e),v(W.$$.fragment,e),v(I.$$.fragment,e),v(Y.$$.fragment,e),v(Q.$$.fragment,e),v(X.$$.fragment,e),v(K.$$.fragment,e),v(ee.$$.fragment,e),v(te.$$.fragment,e),v(ne.$$.fragment,e),Ie=!1},d(e){e&&(t(D),t(u),t(y),t(m),t(x),t(he),t(A),t(_e),t(E),t(be),t(V),t(ve),t(Pe),t(H),t(ye),t(B),t(we),t(F),t(xe),t(R),t(De),t(q),t($e),t(Te),t(Se),t(d),t(Me),t(Ce),t(M),t(ke),t(ge)),t(p),P(w,e),P(Z,e),P(k,e),P(z,e),P(O),P(W),P(I),P(Y),P(Q),P(X),P(K),P(ee),P(te,e),P(ne)}}}const Gt='{"title":"Parallel Sampling of Diffusion Models","local":"parallel-sampling-of-diffusion-models","sections":[{"title":"Tips","local":"tips","sections":[],"depth":2},{"title":"StableDiffusionParadigmsPipeline","local":"diffusers.StableDiffusionParadigmsPipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function Nt(ie){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ft extends Tt{constructor(p){super(),St(this,p,Nt,Jt,Dt,{})}}export{Ft as component};
