import{s as kl,o as Vl,n as Rl}from"../chunks/scheduler.25b97de1.js";import{S as Xl,i as El,g as i,s as a,r as M,A as Sl,h as p,f as t,c as n,j as Al,u as J,x as o,k as _l,y as Wl,a as e,v as m,d as y,t as r,w as T}from"../chunks/index.d9030fc9.js";import{T as zl}from"../chunks/Tip.baa67368.js";import{C as w}from"../chunks/CodeBlock.e6cd0d95.js";import{H as d,E as Yl}from"../chunks/EditOnGithub.91d95064.js";function Hl(cs){let c,h="Note that if you are trying to load a video from URL, you can decode the video only with <code>pyav</code> or <code>decord</code> as backend.";return{c(){c=i("p"),c.innerHTML=h},l(U){c=p(U,"P",{"data-svelte-h":!0}),o(c)!=="svelte-15dpt1t"&&(c.innerHTML=h)},m(U,rs){e(U,c,rs)},p:Rl,d(U){U&&t(c)}}}function Fl(cs){let c,h,U,rs,j,Us,I,Jl="In this section, we’ll explore how to use chat templates with multimodal models, enabling your templates to handle a variety of inputs such as text, images, and audio. Multimodal models provide richer, more interactive experiences, and understanding how to effectively combine these inputs within your templates is key. We’ll walk through how to work with different modalities, configure your templates for optimal performance, and tackle common challenges along the way.",ws,f,ml='Just like with text-only LLMs, multimodal models expect a chat with <strong>messages</strong>, each of which includes a <strong>role</strong> and <strong>content</strong>. However, for multimodal models, chat templates are a part of the <a href="./main_cllasses/processors">Processor</a> class. Let’s see how we can format our prompts when there are images or videos in the input along with text.',ds,C,us,g,yl='For models such as <a href="https://huggingface.co/llava-hf" rel="nofollow">LLaVA</a> the prompts can be formatted as below. Notice that the only difference from text-only models is that we need to also pass a placeholder for input images. To accommodate for extra modalities, each <strong>content</strong> is a list containing either a text or an image <strong>type</strong>.',hs,b,rl="Let’s make this concrete with a quick example using the <code>llava-hf/llava-onevision-qwen2-0.5b-ov-hf</code> model:",js,Z,Is,v,Tl="This yields a string in LLaVA’s expected input format with many <code>&lt;image&gt;</code> tokens prepended before the text.",fs,B,Cs,q,gs,N,cl="To incorporate images into your chat templates, you can pass them as file paths or URLs. This method automatically loads the image, processes it, and prepares the necessary pixel values to create ready-to-use inputs for the model. This approach simplifies the integration of images, enabling seamless multimodal functionality.",bs,Q,Ul="Let’s see how it works with an example using the same model as above. This time we’ll indicate an image URL with <code>&quot;url&quot;</code> key in the message’s <strong>content</strong> and ask the chat template to <code>tokenize</code> and <code>return_dict</code>. Currently, “base64”, “url”, and “path” are supported image sources.",Zs,G,vs,$,wl='This yields a dictionary with inputs processed and ready to be further passed into <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> to generate text.',Bs,x,qs,A,Ns,_,dl="Some vision models support videos as inputs as well as images. The message format is very similar to the image-only models with tiny differences to handle loading videos from a URL. We can continue using the same model as before since it supports videos.",Qs,k,Gs,V,ul="Here’s an example of how to set up a conversation with video inputs. Notice the extra <code>kwargs</code> passed to <code>processor.apply_chat_template()</code>. The key parameter here is <code>num_frames</code>, which controls how many frames to sample uniformly from the video. Each model checkpoint has a maximum frame count it was trained with, and exceeding this limit can significantly impact generation quality. So, it’s important to choose a frame count that fits both the model’s capacity and your computational resources. If you don’t specify <code>num_frames</code>, the entire video will be loaded without any frame sampling.",$s,R,hl="You also have the option to choose a specific framework to load the video, depending on your preferences or needs. Currently, we support <code>decord</code>, <code>pyav</code> (the default), <code>opencv</code>, and <code>torchvision</code>. For this example, we’ll use <code>decord</code>, as it’s a bit faster than <code>pyav</code>.",xs,u,As,X,_s,E,ks,S,jl="When working with long videos, you might want to sample more frames for better representation. Instead of a fixed number of frames, you can specify <code>video_fps</code>, which determines how many frames per second to extract. For example, if a video is <strong>10 seconds long</strong> and you set <code>video_fps=2</code>, the model will sample <strong>20 frames</strong> (2 per second, uniformly spaced).",Vs,W,Il="Using the above model, we need to apply chat template as follows to sample 2 frames per second.",Rs,z,Xs,Y,Es,H,fl="Not all models sample frames <strong>uniformly</strong> — some require more complex logic to determine which frames to use. If your model follows a different sampling strategy, you can <strong>customize</strong> frame selection by providing a function:",Ss,F,Cl=`🔹 Use the <code>sample_indices_fn</code> argument to pass a <strong>callable function</strong> for sampling.<br/>
🔹 If provided, this function <strong>overrides</strong> standard <code>num_frames</code> and <code>fps</code> methods.<br/>
🔹 It receives all the arguments passed to <code>load_video</code> and must return <strong>valid frame indices</strong> to sample.`,Ws,L,gl="You should use <code>sample_indices_fn</code> when:",zs,D,bl="<li>If you need a custom sampling strategy (e.g., <strong>adaptive frame selection</strong> instead of uniform sampling).</li> <li>If your model prioritizes <strong>key moments</strong> in a video rather than evenly spaced frames.</li>",Ys,P,Zl="Here’s an example of how to implement it:",Hs,K,Fs,O,vl="By using <code>sample_indices_fn</code>, you gain <strong>full control</strong> over frame selection, making your model <strong>more adaptable</strong> to different video scenarios. 🚀",Ls,ss,Ds,ls,Bl="Sometimes, instead of having a full video file, you might only have a set of sampled frames stored as images.",Ps,ts,ql="You can pass a list of image file paths, and the processor will automatically concatenate them into a video. Just make sure that all images have the same size, as they are assumed to be from the same video.",Ks,es,Os,as,sl,ns,Nl='<a href="/docs/transformers/main/en/main_classes/pipelines#transformers.ImageTextToTextPipeline">ImageTextToTextPipeline</a> currently accepts images as inputs but we are planning to add support for video inputs in the future. The pipeline supports chat inputs in the same format as we have seen above. Apart from that, the pipeline will accept chats in OpenAI format. This format is supported exclusively within the pipeline to make inference easier and more accessible.',ll,is,Ql="Here is how the OpenAI conversation format looks:",tl,ps,el,os,al,Ms,Gl='To add a custom chat template for your multimodal LLM, simply create your template using <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/" rel="nofollow">Jinja</a> and set it with <code>processor.chat_template</code>. If you’re new to writing chat templates or need some tips, check out our <a href="./chat_template_advanced">tutorial here</a> for helpful guidance.',nl,Js,$l='In some cases, you may want your template to handle a <strong>list of content</strong> from multiple modalities, while still supporting a plain string for text-only inference. Here’s an example of how you can achieve that, using the <a href="https://huggingface.co/collections/meta-llama/metas-llama-32-multimodal-models-675bfd70e574a62dd0e4059b" rel="nofollow">Llama-Vision</a> chat template.',il,ms,pl,ys,ol,Ts,Ml;return j=new d({props:{title:"Multimodal Chat Templates for Vision and Audio LLMs",local:"multimodal-chat-templates-for-vision-and-audio-llms",headingTag:"h1"}}),C=new d({props:{title:"Image inputs",local:"image-inputs",headingTag:"h2"}}),Z=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBMbGF2YU9uZXZpc2lvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybGxhdmEtaGYlMkZsbGF2YS1vbmV2aXNpb24tcXdlbjItMC41Yi1vdi1oZiUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwZnJpZW5kbHklMjBjaGF0Ym90JTIwd2hvJTIwYWx3YXlzJTIwcmVzcG9uZHMlMjBpbiUyMHRoZSUyMHN0eWxlJTIwb2YlMjBhJTIwcGlyYXRlJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMmltYWdlJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyV2hhdCUyMGFyZSUyMHRoZXNlJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTVEJTBBJTBBZm9ybWF0dGVkX3Byb21wdCUyMCUzRCUyMHByb2Nlc3Nvci5hcHBseV9jaGF0X3RlbXBsYXRlKG1lc3NhZ2VzJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUyMHRva2VuaXplJTNERmFsc2UpJTBBcHJpbnQoZm9ybWF0dGVkX3Byb21wdCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaOnevisionForConditionalGeneration

model_id = <span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-0.5b-ov-hf&quot;</span>
processor = AutoProcessor.from_pretrained(model_id)

messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>}],
    },
    {
      <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
      <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What are these?&quot;</span>},
        ],
    },
]

formatted_prompt = processor.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-built_in">print</span>(formatted_prompt)`,wrap:!1}}),B=new w({props:{code:"JyUzQyU3Q2ltX3N0YXJ0JTdDJTNFc3lzdGVtJTIwJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMjAlMEFZb3UlMjBhcmUlMjBhJTIwZnJpZW5kbHklMjBjaGF0Ym90JTIwd2hvJTIwYWx3YXlzJTIwcmVzcG9uZHMlMjBpbiUyMHRoZSUyMHN0eWxlJTIwb2YlMjBhJTIwcGlyYXRlJTNDJTdDaW1fZW5kJTdDJTNFJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTIwJTNDaW1hZ2UlM0UlMEFXaGF0JTIwYXJlJTIwdGhlc2UlM0YlM0MlN0NpbV9lbmQlN0MlM0U=",highlighted:`&#x27;&lt;|im_start|&gt;system 
&lt;|im_start|&gt;system 
You are a friendly chatbot who always responds in the style of a pirate&lt;|im_end|&gt;&lt;|im_start|&gt;user &lt;image&gt;
What are these?&lt;|im_end|&gt;`,wrap:!1}}),q=new d({props:{title:"Image paths or URLs",local:"image-paths-or-urls",headingTag:"h3"}}),G=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBMbGF2YU9uZXZpc2lvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybGxhdmEtaGYlMkZsbGF2YS1vbmV2aXNpb24tcXdlbjItMC41Yi1vdi1oZiUyMiUwQW1vZGVsJTIwJTNEJTIwTGxhdmFPbmV2aXNpb25Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwZnJpZW5kbHklMjBjaGF0Ym90JTIwd2hvJTIwYWx3YXlzJTIwcmVzcG9uZHMlMjBpbiUyMHRoZSUyMHN0eWxlJTIwb2YlMjBhJTIwcGlyYXRlJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMmltYWdlJTIyJTJDJTIwJTIydXJsJTIyJTNBJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMldoYXQlMjBhcmUlMjB0aGVzZSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSU1RCUwQSUwQXByb2Nlc3NlZF9jaGF0JTIwJTNEJTIwcHJvY2Vzc29yLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwdG9rZW5pemUlM0RUcnVlJTJDJTIwcmV0dXJuX2RpY3QlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludChwcm9jZXNzZWRfY2hhdC5rZXlzKCkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaOnevisionForConditionalGeneration

model_id = <span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-0.5b-ov-hf&quot;</span>
model = LlavaOnevisionForConditionalGeneration.from_pretrained(model_id)
processor = AutoProcessor.from_pretrained(model_id)

messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>}],
    },
    {
      <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
      <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What are these?&quot;</span>},
        ],
    },
]

processed_chat = processor.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, tokenize=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(processed_chat.keys())`,wrap:!1}}),x=new w({props:{code:"ZGljdF9rZXlzKCU1QiUyMmlucHV0X2lkcyUyMiUyQyUyMCUyMmF0dGVudGlvbl9tYXNrJTIyJTJDJTIwJTIycGl4ZWxfdmFsdWVzJTIyJTJDJTIwJTIyaW1hZ2Vfc2l6ZXMlMjIlNUQp",highlighted:"dict_keys([&quot;input_ids&quot;, &quot;attention_mask&quot;, &quot;pixel_values&quot;, &quot;image_sizes&quot;])",wrap:!1}}),A=new d({props:{title:"Video inputs",local:"video-inputs",headingTag:"h2"}}),k=new d({props:{title:"Sampling with fixed number of frames",local:"sampling-with-fixed-number-of-frames",headingTag:"h3"}}),u=new zl({props:{$$slots:{default:[Hl]},$$scope:{ctx:cs}}}),X=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBMbGF2YU9uZXZpc2lvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybGxhdmEtaGYlMkZsbGF2YS1vbmV2aXNpb24tcXdlbjItMC41Yi1vdi1oZiUyMiUwQW1vZGVsJTIwJTNEJTIwTGxhdmFPbmV2aXNpb25Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwZnJpZW5kbHklMjBjaGF0Ym90JTIwd2hvJTIwYWx3YXlzJTIwcmVzcG9uZHMlMjBpbiUyMHRoZSUyMHN0eWxlJTIwb2YlMjBhJTIwcGlyYXRlJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMnZpZGVvJTIyJTJDJTIwJTIydXJsJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZ0ZXN0LXZpZGVvcy5jby51ayUyRnZpZHMlMkZiaWdidWNrYnVubnklMkZtcDQlMkZoMjY0JTJGNzIwJTJGQmlnX0J1Y2tfQnVubnlfNzIwXzEwc18xME1CLm1wNCUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMldoYXQlMjBkbyUyMHlvdSUyMHNlZSUyMGluJTIwdGhpcyUyMHZpZGVvJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTVEJTBBJTBBcHJvY2Vzc2VkX2NoYXQlMjAlM0QlMjBwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUyQyUwQSUyMCUyMCUyMCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZGljdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ZyYW1lcyUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwdmlkZW9fbG9hZF9iYWNrZW5kJTNEJTIyZGVjb3JkJTIyJTJDJTBBKSUwQXByaW50KHByb2Nlc3NlZF9jaGF0LmtleXMoKSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaOnevisionForConditionalGeneration

model_id = <span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-0.5b-ov-hf&quot;</span>
model = LlavaOnevisionForConditionalGeneration.from_pretrained(model_id)
processor = AutoProcessor.from_pretrained(model_id)

messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>}],
    },
    {
      <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
      <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;video&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://test-videos.co.uk/vids/bigbuckbunny/mp4/h264/720/Big_Buck_Bunny_720_10s_10MB.mp4&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What do you see in this video?&quot;</span>},
        ],
    },
]

processed_chat = processor.apply_chat_template(
    messages,
    add_generation_prompt=<span class="hljs-literal">True</span>,
    tokenize=<span class="hljs-literal">True</span>,
    return_dict=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    num_frames=<span class="hljs-number">32</span>,
    video_load_backend=<span class="hljs-string">&quot;decord&quot;</span>,
)
<span class="hljs-built_in">print</span>(processed_chat.keys())`,wrap:!1}}),E=new d({props:{title:"Sampling with FPS",local:"sampling-with-fps",headingTag:"h3"}}),z=new w({props:{code:"cHJvY2Vzc2VkX2NoYXQlMjAlM0QlMjBwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUyQyUwQSUyMCUyMCUyMCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZGljdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB2aWRlb19mcHMlM0QzMiUyQyUwQSUyMCUyMCUyMCUyMHZpZGVvX2xvYWRfYmFja2VuZCUzRCUyMmRlY29yZCUyMiUyQyUwQSklMEFwcmludChwcm9jZXNzZWRfY2hhdC5rZXlzKCkp",highlighted:`processed_chat = processor.apply_chat_template(
    messages,
    add_generation_prompt=<span class="hljs-literal">True</span>,
    tokenize=<span class="hljs-literal">True</span>,
    return_dict=<span class="hljs-literal">True</span>,
    video_fps=<span class="hljs-number">32</span>,
    video_load_backend=<span class="hljs-string">&quot;decord&quot;</span>,
)
<span class="hljs-built_in">print</span>(processed_chat.keys())`,wrap:!1}}),Y=new d({props:{title:"Custom Frame Sampling with a Function",local:"custom-frame-sampling-with-a-function",headingTag:"h3"}}),K=new w({props:{code:"JTBBZGVmJTIwc2FtcGxlX2luZGljZXNfZm4obWV0YWRhdGElMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBzYW1wbGVzJTIwb25seSUyMHRoZSUyMGZpcnN0JTIwYW5kJTIwdGhlJTIwc2Vjb25kJTIwZnJhbWUlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlNUIwJTJDJTIwMSU1RCUwQSUwQXByb2Nlc3NlZF9jaGF0JTIwJTNEJTIwcHJvY2Vzc29yLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX2RpY3QlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwc2FtcGxlX2luZGljZXNfZm4lM0RzYW1wbGVfaW5kaWNlc19mbiUyQyUwQSUyMCUyMCUyMCUyMHZpZGVvX2xvYWRfYmFja2VuZCUzRCUyMmRlY29yZCUyMiUyQyUwQSklMEFwcmludChwcm9jZXNzZWRfY2hhdC5rZXlzKCkp",highlighted:`
<span class="hljs-keyword">def</span> <span class="hljs-title function_">sample_indices_fn</span>(<span class="hljs-params">metadata, **kwargs</span>):
    <span class="hljs-comment"># samples only the first and the second frame</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>]

processed_chat = processor.apply_chat_template(
    messages,
    add_generation_prompt=<span class="hljs-literal">True</span>,
    tokenize=<span class="hljs-literal">True</span>,
    return_dict=<span class="hljs-literal">True</span>,
    sample_indices_fn=sample_indices_fn,
    video_load_backend=<span class="hljs-string">&quot;decord&quot;</span>,
)
<span class="hljs-built_in">print</span>(processed_chat.keys())`,wrap:!1}}),ss=new d({props:{title:"List of image frames as video",local:"list-of-image-frames-as-video",headingTag:"h3"}}),es=new w({props:{code:"ZnJhbWVzX3BhdGhzJTIwJTNEJTIwJTVCJTIyJTJGcGF0aCUyRnRvJTJGZnJhbWUwLnBuZyUyMiUyQyUyMCUyMiUyRnBhdGglMkZ0byUyRmZyYW1lNS5wbmclMjIlMkMlMjAlMjIlMkZwYXRoJTJGdG8lMkZmcmFtZTEwLnBuZyUyMiU1RCUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwZnJpZW5kbHklMjBjaGF0Ym90JTIwd2hvJTIwYWx3YXlzJTIwcmVzcG9uZHMlMjBpbiUyMHRoZSUyMHN0eWxlJTIwb2YlMjBhJTIwcGlyYXRlJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMnZpZGVvJTIyJTJDJTIwJTIycGF0aCUyMiUzQSUyMGZyYW1lc19wYXRocyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMldoYXQlMjBkbyUyMHlvdSUyMHNlZSUyMGluJTIwdGhpcyUyMHZpZGVvJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTVEJTBBJTBBcHJvY2Vzc2VkX2NoYXQlMjAlM0QlMjBwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUyQyUwQSUyMCUyMCUyMCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZGljdCUzRFRydWUlMkMlMEEpJTBBcHJpbnQocHJvY2Vzc2VkX2NoYXQua2V5cygpKQ==",highlighted:`frames_paths = [<span class="hljs-string">&quot;/path/to/frame0.png&quot;</span>, <span class="hljs-string">&quot;/path/to/frame5.png&quot;</span>, <span class="hljs-string">&quot;/path/to/frame10.png&quot;</span>]
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>}],
    },
    {
      <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
      <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;video&quot;</span>, <span class="hljs-string">&quot;path&quot;</span>: frames_paths},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What do you see in this video?&quot;</span>},
        ],
    },
]

processed_chat = processor.apply_chat_template(
    messages,
    add_generation_prompt=<span class="hljs-literal">True</span>,
    tokenize=<span class="hljs-literal">True</span>,
    return_dict=<span class="hljs-literal">True</span>,
)
<span class="hljs-built_in">print</span>(processed_chat.keys())`,wrap:!1}}),as=new d({props:{title:"Multimodal conversational pipeline",local:"multimodal-conversational-pipeline",headingTag:"h2"}}),ps=new w({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRleHQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjBpbiUyMHRoaXMlMjBpbWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJpbWFnZV91cmwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbWFnZV91cmwlMjIlM0ElMjAlN0IlMjJ1cmwlMjIlM0ElMjBmJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUwQSU1RA==",highlighted:`messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is in this image?&quot;</span>,
            },
            {
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                <span class="hljs-string">&quot;image_url&quot;</span>: {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">f&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>},
            },
        ],
    }
]`,wrap:!1}}),os=new d({props:{title:"Best Practices for Multimodal Template Configuration",local:"best-practices-for-multimodal-template-configuration",headingTag:"h2"}}),ms=new w({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElN0IlMjUlMjBpZiUyMGxvb3AuaW5kZXgwJTIwJTNEJTNEJTIwMCUyMCUyNSU3RCU3QiU3QiUyMGJvc190b2tlbiUyMCU3RCU3RCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTdCJTIwJyUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyUzQyU3Q2VuZF9oZWFkZXJfaWQlN0MlM0UlNUNuJTVDbiclMjAlN0QlN0QlMEElN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjBpcyUyMHN0cmluZyUyMCUyNSU3RCUwQSU3QiU3QiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlN0QlN0QlMEElN0IlMjUlMjBlbHNlJTIwJTI1JTdEJTBBJTdCJTI1JTIwZm9yJTIwY29udGVudCUyMGluJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyNSU3RCUwQSU3QiUyNSUyMGlmJTIwY29udGVudCU1Qid0eXBlJyU1RCUyMCUzRCUzRCUyMCdpbWFnZSclMjAlMjUlN0QlMEElN0IlN0IlMjAnJTNDJTdDaW1hZ2UlN0MlM0UnJTIwJTdEJTdEJTBBJTdCJTI1JTIwZWxpZiUyMGNvbnRlbnQlNUIndHlwZSclNUQlMjAlM0QlM0QlMjAndGV4dCclMjAlMjUlN0QlMEElN0IlN0IlMjBjb250ZW50JTVCJ3RleHQnJTVEJTIwJTdEJTdEJTBBJTdCJTI1JTIwZW5kaWYlMjAlMjUlN0QlMEElN0IlMjUlMjBlbmRmb3IlMjAlMjUlN0QlMEElN0IlMjUlMjBlbmRpZiUyMCUyNSU3RCUwQSU3QiU3QiUyMCclM0MlN0Nlb3RfaWQlN0MlM0UnJTIwJTdEJTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdEJTBBJTdCJTI1JTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlN0IlN0IlMjAnJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFYXNzaXN0YW50JTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSU1Q24lNUNuJyUyMCU3RCU3RCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">for</span></span> message <span class="hljs-keyword">in</span> messages %}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">if</span></span> loop.index0 == 0 %}</span><span class="hljs-template-variable">{{ bos_token }}</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">endif</span></span> %}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ &#x27;&lt;|start_header_id|&gt;&#x27; + message[&#x27;role&#x27;] + &#x27;&lt;|end_header_id|&gt;\\n\\n&#x27; }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">if</span></span> message[&#x27;content&#x27;] is string %}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ message[&#x27;content&#x27;] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">else</span></span> %}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">for</span></span> content <span class="hljs-keyword">in</span> message[&#x27;content&#x27;] %}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">if</span></span> content[&#x27;type&#x27;] == &#x27;image&#x27; %}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ &#x27;&lt;|image|&gt;&#x27; }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">elif</span></span> content[&#x27;type&#x27;] == &#x27;text&#x27; %}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ content[&#x27;text&#x27;] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">endif</span></span> %}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">endif</span></span> %}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ &#x27;&lt;|eot_id|&gt;&#x27; }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">if</span></span> add_generation_prompt %}</span><span class="hljs-template-variable">{{ &#x27;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\n&#x27; }}</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">endif</span></span> %}</span>`,wrap:!1}}),ys=new Yl({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/chat_template_multimodal.md"}}),{c(){c=i("meta"),h=a(),U=i("p"),rs=a(),M(j.$$.fragment),Us=a(),I=i("p"),I.textContent=Jl,ws=a(),f=i("p"),f.innerHTML=ml,ds=a(),M(C.$$.fragment),us=a(),g=i("p"),g.innerHTML=yl,hs=a(),b=i("p"),b.innerHTML=rl,js=a(),M(Z.$$.fragment),Is=a(),v=i("p"),v.innerHTML=Tl,fs=a(),M(B.$$.fragment),Cs=a(),M(q.$$.fragment),gs=a(),N=i("p"),N.textContent=cl,bs=a(),Q=i("p"),Q.innerHTML=Ul,Zs=a(),M(G.$$.fragment),vs=a(),$=i("p"),$.innerHTML=wl,Bs=a(),M(x.$$.fragment),qs=a(),M(A.$$.fragment),Ns=a(),_=i("p"),_.textContent=dl,Qs=a(),M(k.$$.fragment),Gs=a(),V=i("p"),V.innerHTML=ul,$s=a(),R=i("p"),R.innerHTML=hl,xs=a(),M(u.$$.fragment),As=a(),M(X.$$.fragment),_s=a(),M(E.$$.fragment),ks=a(),S=i("p"),S.innerHTML=jl,Vs=a(),W=i("p"),W.textContent=Il,Rs=a(),M(z.$$.fragment),Xs=a(),M(Y.$$.fragment),Es=a(),H=i("p"),H.innerHTML=fl,Ss=a(),F=i("p"),F.innerHTML=Cl,Ws=a(),L=i("p"),L.innerHTML=gl,zs=a(),D=i("ul"),D.innerHTML=bl,Ys=a(),P=i("p"),P.textContent=Zl,Hs=a(),M(K.$$.fragment),Fs=a(),O=i("p"),O.innerHTML=vl,Ls=a(),M(ss.$$.fragment),Ds=a(),ls=i("p"),ls.textContent=Bl,Ps=a(),ts=i("p"),ts.textContent=ql,Ks=a(),M(es.$$.fragment),Os=a(),M(as.$$.fragment),sl=a(),ns=i("p"),ns.innerHTML=Nl,ll=a(),is=i("p"),is.textContent=Ql,tl=a(),M(ps.$$.fragment),el=a(),M(os.$$.fragment),al=a(),Ms=i("p"),Ms.innerHTML=Gl,nl=a(),Js=i("p"),Js.innerHTML=$l,il=a(),M(ms.$$.fragment),pl=a(),M(ys.$$.fragment),ol=a(),Ts=i("p"),this.h()},l(s){const l=Sl("svelte-u9bgzb",document.head);c=p(l,"META",{name:!0,content:!0}),l.forEach(t),h=n(s),U=p(s,"P",{}),Al(U).forEach(t),rs=n(s),J(j.$$.fragment,s),Us=n(s),I=p(s,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1vh73bc"&&(I.textContent=Jl),ws=n(s),f=p(s,"P",{"data-svelte-h":!0}),o(f)!=="svelte-w0zoss"&&(f.innerHTML=ml),ds=n(s),J(C.$$.fragment,s),us=n(s),g=p(s,"P",{"data-svelte-h":!0}),o(g)!=="svelte-97p3uh"&&(g.innerHTML=yl),hs=n(s),b=p(s,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1ljzup"&&(b.innerHTML=rl),js=n(s),J(Z.$$.fragment,s),Is=n(s),v=p(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1rg1ihm"&&(v.innerHTML=Tl),fs=n(s),J(B.$$.fragment,s),Cs=n(s),J(q.$$.fragment,s),gs=n(s),N=p(s,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1mjcd7j"&&(N.textContent=cl),bs=n(s),Q=p(s,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1fc6o5w"&&(Q.innerHTML=Ul),Zs=n(s),J(G.$$.fragment,s),vs=n(s),$=p(s,"P",{"data-svelte-h":!0}),o($)!=="svelte-dbnusc"&&($.innerHTML=wl),Bs=n(s),J(x.$$.fragment,s),qs=n(s),J(A.$$.fragment,s),Ns=n(s),_=p(s,"P",{"data-svelte-h":!0}),o(_)!=="svelte-8qhe2y"&&(_.textContent=dl),Qs=n(s),J(k.$$.fragment,s),Gs=n(s),V=p(s,"P",{"data-svelte-h":!0}),o(V)!=="svelte-h7pp8l"&&(V.innerHTML=ul),$s=n(s),R=p(s,"P",{"data-svelte-h":!0}),o(R)!=="svelte-qmm6k4"&&(R.innerHTML=hl),xs=n(s),J(u.$$.fragment,s),As=n(s),J(X.$$.fragment,s),_s=n(s),J(E.$$.fragment,s),ks=n(s),S=p(s,"P",{"data-svelte-h":!0}),o(S)!=="svelte-17386uu"&&(S.innerHTML=jl),Vs=n(s),W=p(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1uvxkpu"&&(W.textContent=Il),Rs=n(s),J(z.$$.fragment,s),Xs=n(s),J(Y.$$.fragment,s),Es=n(s),H=p(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-10f7ad4"&&(H.innerHTML=fl),Ss=n(s),F=p(s,"P",{"data-svelte-h":!0}),o(F)!=="svelte-15ee1kk"&&(F.innerHTML=Cl),Ws=n(s),L=p(s,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1id9cat"&&(L.innerHTML=gl),zs=n(s),D=p(s,"UL",{"data-svelte-h":!0}),o(D)!=="svelte-1i1tmw4"&&(D.innerHTML=bl),Ys=n(s),P=p(s,"P",{"data-svelte-h":!0}),o(P)!=="svelte-ntx8uj"&&(P.textContent=Zl),Hs=n(s),J(K.$$.fragment,s),Fs=n(s),O=p(s,"P",{"data-svelte-h":!0}),o(O)!=="svelte-cbn9yp"&&(O.innerHTML=vl),Ls=n(s),J(ss.$$.fragment,s),Ds=n(s),ls=p(s,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-trfw6a"&&(ls.textContent=Bl),Ps=n(s),ts=p(s,"P",{"data-svelte-h":!0}),o(ts)!=="svelte-1i91am4"&&(ts.textContent=ql),Ks=n(s),J(es.$$.fragment,s),Os=n(s),J(as.$$.fragment,s),sl=n(s),ns=p(s,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-1pzpfjq"&&(ns.innerHTML=Nl),ll=n(s),is=p(s,"P",{"data-svelte-h":!0}),o(is)!=="svelte-tgl7fl"&&(is.textContent=Ql),tl=n(s),J(ps.$$.fragment,s),el=n(s),J(os.$$.fragment,s),al=n(s),Ms=p(s,"P",{"data-svelte-h":!0}),o(Ms)!=="svelte-kr110e"&&(Ms.innerHTML=Gl),nl=n(s),Js=p(s,"P",{"data-svelte-h":!0}),o(Js)!=="svelte-11llr7p"&&(Js.innerHTML=$l),il=n(s),J(ms.$$.fragment,s),pl=n(s),J(ys.$$.fragment,s),ol=n(s),Ts=p(s,"P",{}),Al(Ts).forEach(t),this.h()},h(){_l(c,"name","hf:doc:metadata"),_l(c,"content",Ll)},m(s,l){Wl(document.head,c),e(s,h,l),e(s,U,l),e(s,rs,l),m(j,s,l),e(s,Us,l),e(s,I,l),e(s,ws,l),e(s,f,l),e(s,ds,l),m(C,s,l),e(s,us,l),e(s,g,l),e(s,hs,l),e(s,b,l),e(s,js,l),m(Z,s,l),e(s,Is,l),e(s,v,l),e(s,fs,l),m(B,s,l),e(s,Cs,l),m(q,s,l),e(s,gs,l),e(s,N,l),e(s,bs,l),e(s,Q,l),e(s,Zs,l),m(G,s,l),e(s,vs,l),e(s,$,l),e(s,Bs,l),m(x,s,l),e(s,qs,l),m(A,s,l),e(s,Ns,l),e(s,_,l),e(s,Qs,l),m(k,s,l),e(s,Gs,l),e(s,V,l),e(s,$s,l),e(s,R,l),e(s,xs,l),m(u,s,l),e(s,As,l),m(X,s,l),e(s,_s,l),m(E,s,l),e(s,ks,l),e(s,S,l),e(s,Vs,l),e(s,W,l),e(s,Rs,l),m(z,s,l),e(s,Xs,l),m(Y,s,l),e(s,Es,l),e(s,H,l),e(s,Ss,l),e(s,F,l),e(s,Ws,l),e(s,L,l),e(s,zs,l),e(s,D,l),e(s,Ys,l),e(s,P,l),e(s,Hs,l),m(K,s,l),e(s,Fs,l),e(s,O,l),e(s,Ls,l),m(ss,s,l),e(s,Ds,l),e(s,ls,l),e(s,Ps,l),e(s,ts,l),e(s,Ks,l),m(es,s,l),e(s,Os,l),m(as,s,l),e(s,sl,l),e(s,ns,l),e(s,ll,l),e(s,is,l),e(s,tl,l),m(ps,s,l),e(s,el,l),m(os,s,l),e(s,al,l),e(s,Ms,l),e(s,nl,l),e(s,Js,l),e(s,il,l),m(ms,s,l),e(s,pl,l),m(ys,s,l),e(s,ol,l),e(s,Ts,l),Ml=!0},p(s,[l]){const xl={};l&2&&(xl.$$scope={dirty:l,ctx:s}),u.$set(xl)},i(s){Ml||(y(j.$$.fragment,s),y(C.$$.fragment,s),y(Z.$$.fragment,s),y(B.$$.fragment,s),y(q.$$.fragment,s),y(G.$$.fragment,s),y(x.$$.fragment,s),y(A.$$.fragment,s),y(k.$$.fragment,s),y(u.$$.fragment,s),y(X.$$.fragment,s),y(E.$$.fragment,s),y(z.$$.fragment,s),y(Y.$$.fragment,s),y(K.$$.fragment,s),y(ss.$$.fragment,s),y(es.$$.fragment,s),y(as.$$.fragment,s),y(ps.$$.fragment,s),y(os.$$.fragment,s),y(ms.$$.fragment,s),y(ys.$$.fragment,s),Ml=!0)},o(s){r(j.$$.fragment,s),r(C.$$.fragment,s),r(Z.$$.fragment,s),r(B.$$.fragment,s),r(q.$$.fragment,s),r(G.$$.fragment,s),r(x.$$.fragment,s),r(A.$$.fragment,s),r(k.$$.fragment,s),r(u.$$.fragment,s),r(X.$$.fragment,s),r(E.$$.fragment,s),r(z.$$.fragment,s),r(Y.$$.fragment,s),r(K.$$.fragment,s),r(ss.$$.fragment,s),r(es.$$.fragment,s),r(as.$$.fragment,s),r(ps.$$.fragment,s),r(os.$$.fragment,s),r(ms.$$.fragment,s),r(ys.$$.fragment,s),Ml=!1},d(s){s&&(t(h),t(U),t(rs),t(Us),t(I),t(ws),t(f),t(ds),t(us),t(g),t(hs),t(b),t(js),t(Is),t(v),t(fs),t(Cs),t(gs),t(N),t(bs),t(Q),t(Zs),t(vs),t($),t(Bs),t(qs),t(Ns),t(_),t(Qs),t(Gs),t(V),t($s),t(R),t(xs),t(As),t(_s),t(ks),t(S),t(Vs),t(W),t(Rs),t(Xs),t(Es),t(H),t(Ss),t(F),t(Ws),t(L),t(zs),t(D),t(Ys),t(P),t(Hs),t(Fs),t(O),t(Ls),t(Ds),t(ls),t(Ps),t(ts),t(Ks),t(Os),t(sl),t(ns),t(ll),t(is),t(tl),t(el),t(al),t(Ms),t(nl),t(Js),t(il),t(pl),t(ol),t(Ts)),t(c),T(j,s),T(C,s),T(Z,s),T(B,s),T(q,s),T(G,s),T(x,s),T(A,s),T(k,s),T(u,s),T(X,s),T(E,s),T(z,s),T(Y,s),T(K,s),T(ss,s),T(es,s),T(as,s),T(ps,s),T(os,s),T(ms,s),T(ys,s)}}}const Ll='{"title":"Multimodal Chat Templates for Vision and Audio LLMs","local":"multimodal-chat-templates-for-vision-and-audio-llms","sections":[{"title":"Image inputs","local":"image-inputs","sections":[{"title":"Image paths or URLs","local":"image-paths-or-urls","sections":[],"depth":3}],"depth":2},{"title":"Video inputs","local":"video-inputs","sections":[{"title":"Sampling with fixed number of frames","local":"sampling-with-fixed-number-of-frames","sections":[],"depth":3},{"title":"Sampling with FPS","local":"sampling-with-fps","sections":[],"depth":3},{"title":"Custom Frame Sampling with a Function","local":"custom-frame-sampling-with-a-function","sections":[],"depth":3},{"title":"List of image frames as video","local":"list-of-image-frames-as-video","sections":[],"depth":3}],"depth":2},{"title":"Multimodal conversational pipeline","local":"multimodal-conversational-pipeline","sections":[],"depth":2},{"title":"Best Practices for Multimodal Template Configuration","local":"best-practices-for-multimodal-template-configuration","sections":[],"depth":2}],"depth":1}';function Dl(cs){return Vl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tt extends Xl{constructor(c){super(),El(this,c,Dl,Fl,kl,{})}}export{tt as component};
