import{s as sl,n as nl,o as al}from"../chunks/scheduler.39a43cde.js";import{S as ol,i as il,g as o,s as n,r as M,A as rl,h as i,f as l,c as a,j as el,u as p,x as r,k as ll,y as Ml,a as s,v as c,d as y,t as u,w as m}from"../chunks/index.23ec2204.js";import{D as pl,C as j}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as wt,E as cl}from"../chunks/EditOnGithub.f2d09226.js";function yl(Ue){let w,Jt,ht,bt,h,Ut,d,Tt,J,Te='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',gt,b,ge='This notebook demonstrates how you can use <a href="https://huggingface.co/docs/transformers/en/transformers_agents" rel="nofollow"><strong>Transformers Agents</strong></a> to build awesome <strong>agents</strong>!',ft,U,fe="What are <strong>agents</strong>? Agents are systems that are powered by an LLM and enable the LLM (with careful prompting and output parsing) to use specific <em>tools</em> to solve problems.",It,T,Ie='These <em>tools</em> are basically functions that the LLM couldn’t perform well by itself: for instance for a text-generation LLM like <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B-Instruct" rel="nofollow">Llama-3-70B</a>, this could be an image generation tool, a web search tool, a calculator…',Ct,g,Ce='What is <strong>Transformers Agents</strong>? it’s an extension of our <code>transformers</code> library that provides building blocks to build your own agents! Learn more about it in the <a href="https://huggingface.co/docs/transformers/en/transformers_agents" rel="nofollow">documentation</a>.',vt,f,ve="Let’s see how to use it, and which use cases it can solve.",Zt,I,Ze="We install transformers agents from source since it has not been released as of writing, but later this week when it gets release you can simply install it with <code>pip install transformers[agents]</code>.",Bt,C,Gt,v,kt,Z,Wt,B,Be="For this use case, we want to show an agent that browses the web and is able to generate image.",Rt,G,Ge="To build it, we simply need to have two tools ready: image generation and web search.",At,k,ke="<li>For image generation, we load a tool from the Hub that uses the HF Inference API (Serverless) to generate images using Stable Diffusion.</li> <li>For the web search, we load a LangChain tool.</li>",_t,W,Nt,R,We='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/agents_db5.png" alt="Image of an Aston Martin DB5"/>',$t,A,Vt,_,Re="Quick definition: Retrieval-Augmented-Generation (RAG) is “using an LLM to answer a user query, but basing the answer on information retrieved from a knowledge base”. It has many advantages over using a vanilla or fine-tuned LLM: to name a few, it allows to ground the answer on true facts and reduce confabulations, it allows to provide the LLM with domain-specific knowledge, and it allows fine-grained control of access to information from the knowledge base.",Qt,N,Ae="Now let’s say we want to perform RAG, but with the additional constraint that some parameters must be dynamically generated. For example, depending on the user query we could want to restrict the search to specific subsets of the knowledge base, or we could want to adjust the number of documents retrieved. The difficulty is: <strong>how to dynamically adjust these parameters based on the user query?</strong>",St,$,_e="🔧 Well, we can solve this by in a simple way: we will <strong>give our agent control over these parameters!</strong>",Xt,V,Ne="➡️ Let’s show how to do this. We first load a knowledge base on which we want to perform RAG: this dataset is a compilation of the documentation pages for many <code>huggingface</code> packages, stored as markdown.",xt,Q,Ht,S,$e="Now we prepare the knowledge base by processing the dataset and storing it into a vector database to be used by the retriever. We are going to use LangChain, since it features excellent utilities for vector databases:",qt,X,Yt,x,Ve="Now that we have the database ready, let’s build a RAG system that answers user queries based on it!",Et,H,Qe="We want our system to select only from the most relevant sources of information, depending on the query.",zt,q,Se="Our documentation pages come from the following sources:",Ft,Y,Lt,E,Xe=`['evaluate', 'course', 'deep-rl-class', 'peft', 'hf-endpoints-documentation', 'blog', 'gradio', 'datasets', 'datasets-server', 'transformers', 'optimum', 'hub-docs', 'pytorch-image-models', 'diffusers']
`,Pt,z,Kt,F,Dt,L,xe="To share your tool to the Hub, first copy-paste the code in the RetrieverTool definition cell to a new file named for instance <code>retriever.py</code>.",Ot,P,He="When the tool is loaded from a separate file, you can then push it to the Hub using the code below (make sure to login with a <code>write</code> access token)",te,K,ee,D,le,O,se,tt,qe=`Final output:
https://github.com/huggingface/diffusers/blob/main/examples/text_to_image/train_text_to_image_lora.py
`,ne,et,Ye="What happened here? First, the agent launched the retriever with specific sources in mind (<code>[&#39;transformers&#39;, &#39;blog&#39;]</code>).",ae,lt,Ee=`But this retrieval did not yield enough results ⇒ no problem! The agent could iterate on previous results, so it just re-ran its retrieval with less restrictive search parameters.
Thus the research was successful!`,oe,st,ze="Note that <strong>using an LLM agent</strong> that calls a retriever as a tool and can dynamically modify the query and other retrieval parameters <strong>is a more general formulation of RAG</strong>, which also covers many RAG improvement techniques like iterative query refinement.",ie,nt,re,at,Fe="Since the ReactCodeAgent has an built int Python code interpreter, we can use it to debug our faulty Python script!",Me,ot,pe,it,Le="As you can see, the agent tried the given code, gets an error, analyses the error, corrects the code and returns it after veryfing that it works!",ce,rt,Pe="And the final code is the corrected code:",ye,Mt,ue,pt,Ke=`list=[0, 1, 2]

for i in range(4):
    print(list(i))
`,me,ct,je,yt,De="These three use cases should give you a glimpse into the possibilities of our Agents framework!",we,ut,Oe='For more advanced usage, read the <a href="https://huggingface.co/docs/transformers/en/transformers_agents" rel="nofollow">documentation</a>, and <a href="https://github.com/aymeric-roucher/agent_reasoning_benchmark/blob/main/benchmark_gaia.ipynb" rel="nofollow">this experiment</a> that allowed us to build our own agent based on Llama-3-70B that beats many GPT-4 agents on the very difficult <a href="https://huggingface.co/spaces/gaia-benchmark/leaderboard" rel="nofollow">GAIA Leaderboard</a>!',he,mt,tl="All feedback is welcome, it will help us improve the framework! 🚀",de,jt,Je,dt,be;return h=new pl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/agents.ipynb"}]}}),d=new wt({props:{title:"Build an agent with tool-calling superpowers 🦸 using Transformers Agents",local:"build-an-agent-with-tool-calling-superpowers--using-transformers-agents",headingTag:"h1"}}),C=new j({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycy5naXQlMjNlZ2clM0R0cmFuc2Zvcm1lcnMlNUJhZ2VudHMlNUQlMjI=",highlighted:'!pip install <span class="hljs-string">&quot;git+https://github.com/huggingface/transformers.git#egg=transformers[agents]&quot;</span>',wrap:!1}}),v=new j({props:{code:"IXBpcCUyMGluc3RhbGwlMjBkYXRhc2V0cyUyMGh1Z2dpbmdmYWNlX2h1YiUyMGxhbmdjaGFpbiUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWNwdSUyMHNlcnBhcGklMjBnb29nbGUtc2VhcmNoLXJlc3VsdHMlMjAtcQ==",highlighted:"!pip install datasets huggingface_hub langchain sentence-transformers faiss-cpu serpapi google-search-results -q",wrap:!1}}),Z=new wt({props:{title:"1. 🏞️ Multimodal + 🌐 Web-browsing assistant",local:"1--multimodal---web-browsing-assistant",headingTag:"h2"}}),W=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRvb2wlMkMlMjBsb2FkX3Rvb2wlMkMlMjBSZWFjdENvZGVBZ2VudCUyQyUyMEhmRW5naW5lJTBBJTBBJTIzJTIwSW1wb3J0JTIwdG9vbCUyMGZyb20lMjBIdWIlMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybS1yaWMlMkZ0ZXh0LXRvLWltYWdlJTIyKSUwQSUwQSUyMyUyMEltcG9ydCUyMHRvb2wlMjBmcm9tJTIwTGFuZ0NoYWluJTBBZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQSUwQWxsbV9lbmdpbmUlMjAlM0QlMjBIZkVuZ2luZSglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLTcwQi1JbnN0cnVjdCUyMiklMEElMjMlMjBJbml0aWFsaXplJTIwdGhlJTIwYWdlbnQlMjB3aXRoJTIwYm90aCUyMHRvb2xzJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCUyQyUyMHNlYXJjaF90b29sJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUpJTBBJTBBJTIzJTIwUnVuJTIwaXQhJTBBYWdlbnQucnVuKCUyMkdlbmVyYXRlJTIwbWUlMjBhJTIwcGhvdG8lMjBvZiUyMHRoZSUyMGNhciUyMHRoYXQlMjBKYW1lcyUyMGJvbmQlMjBkcm92ZSUyMGluJTIwdGhlJTIwbGF0ZXN0JTIwbW92aWUuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Tool, load_tool, ReactCodeAgent, HfEngine

<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>)

<span class="hljs-comment"># Import tool from LangChain</span>
<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])


llm_engine = HfEngine(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-comment"># Initialize the agent with both tools</span>
agent = ReactCodeAgent(tools=[image_generation_tool, search_tool], llm_engine=llm_engine)

<span class="hljs-comment"># Run it!</span>
agent.run(<span class="hljs-string">&quot;Generate me a photo of the car that James bond drove in the latest movie.&quot;</span>)`,wrap:!1}}),A=new wt({props:{title:"2. 📚💬 Retrieval-Augmented Generation with source selection",local:"2--retrieval-augmented-generation-with-source-selection",headingTag:"h2"}}),Q=new j({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEElMEFrbm93bGVkZ2VfYmFzZSUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJtLXJpYyUyRmh1Z2dpbmdmYWNlX2RvYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> datasets

knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),X=new j({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2NzdG9yZS5kb2N1bWVudCUyMGltcG9ydCUyMERvY3VtZW50JTBBZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW5fY29tbXVuaXR5LmVtYmVkZGluZ3MlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MlMEElMEFzb3VyY2VfZG9jcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMERvY3VtZW50KHBhZ2VfY29udGVudCUzRGRvYyU1QiUyMnRleHQlMjIlNUQlMkMlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZSUyMiUzQSUyMGRvYyU1QiUyMnNvdXJjZSUyMiU1RC5zcGxpdCglMjIlMkYlMjIpJTVCMSU1RCU3RCklMjBmb3IlMjBkb2MlMjBpbiUyMGtub3dsZWRnZV9iYXNlJTBBJTVEJTBBJTBBZG9jc19wcm9jZXNzZWQlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDUwMCkuc3BsaXRfZG9jdW1lbnRzKHNvdXJjZV9kb2NzKSU1QiUzQTEwMDAlNUQlMEElMEFlbWJlZGRpbmdfbW9kZWwlMjAlM0QlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MobW9kZWxfbmFtZSUzRCUyMnRoZW5scGVyJTJGZ3RlLXNtYWxsJTIyKSUwQXZlY3RvcmRiJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoZG9jdW1lbnRzJTNEZG9jc19wcm9jZXNzZWQlMkMlMjBlbWJlZGRpbmclM0RlbWJlZGRpbmdfbW9kZWwp",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]}) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
]

docs_processed = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">500</span>).split_documents(source_docs)[:<span class="hljs-number">1000</span>]

embedding_model = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>)
vectordb = FAISS.from_documents(documents=docs_processed, embedding=embedding_model)`,wrap:!1}}),Y=new j({props:{code:"YWxsX3NvdXJjZXMlMjAlM0QlMjBsaXN0KHNldCglNUJkb2MubWV0YWRhdGElNUIlMjJzb3VyY2UlMjIlNUQlMjBmb3IlMjBkb2MlMjBpbiUyMGRvY3NfcHJvY2Vzc2VkJTVEKSklMEFwcmludChhbGxfc291cmNlcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>all_sources = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>([doc.metadata[<span class="hljs-string">&quot;source&quot;</span>] <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs_processed]))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(all_sources)`,wrap:!1}}),z=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_core.vectorstores <span class="hljs-keyword">import</span> VectorStore


<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = (
        <span class="hljs-string">&quot;Retrieves some documents from the knowledge base that have the closest embeddings to the input query.&quot;</span>
    )
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        },
        <span class="hljs-string">&quot;source&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;&quot;</span>},
        <span class="hljs-string">&quot;number_of_documents&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the number of documents to retrieve. Stay under 10 to avoid drowning in docs&quot;</span>,
        },
    }
    output_type = <span class="hljs-string">&quot;text&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, vectordb: VectorStore, all_sources: <span class="hljs-built_in">str</span>, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.vectordb = vectordb
        self.inputs[<span class="hljs-string">&quot;source&quot;</span>][
            <span class="hljs-string">&quot;description&quot;</span>
        ] = <span class="hljs-string">f&quot;The source of the documents to search, as a str representation of a list. Possible values in the list are: <span class="hljs-subst">{all_sources}</span>. If this argument is not provided, all sources will be searched.&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span>, source: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span>, number_of_documents=<span class="hljs-number">7</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>
        number_of_documents = <span class="hljs-built_in">int</span>(number_of_documents)

        <span class="hljs-keyword">if</span> source:
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(source, <span class="hljs-built_in">str</span>) <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;[&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">str</span>(source):  <span class="hljs-comment"># if the source is not representing a list</span>
                source = [source]
            source = json.loads(<span class="hljs-built_in">str</span>(source).replace(<span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>))

        docs = self.vectordb.similarity_search(
            query,
            <span class="hljs-built_in">filter</span>=({<span class="hljs-string">&quot;source&quot;</span>: source} <span class="hljs-keyword">if</span> source <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>),
            k=number_of_documents,
        )

        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(docs) == <span class="hljs-number">0</span>:
            <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;No documents found with this filtering. Try removing the source filter.&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Retrieved documents:\\n\\n&quot;</span> + <span class="hljs-string">&quot;\\n===Document===\\n&quot;</span>.join([doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs])`,wrap:!1}}),F=new wt({props:{title:"Optional: Share your Retriever tool to Hub",local:"optional-share-your-retriever-tool-to-hub",headingTag:"h3"}}),K=new j({props:{code:"c2hhcmVfdG9faHViJTIwJTNEJTIwRmFsc2UlMEElMEFpZiUyMHNoYXJlX3RvX2h1YiUzQSUwQSUyMCUyMCUyMCUyMGZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBsb2dpbiUwQSUyMCUyMCUyMCUyMGZyb20lMjByZXRyaWV2ZXIlMjBpbXBvcnQlMjBSZXRyaWV2ZXJUb29sJTBBJTBBJTIwJTIwJTIwJTIwbG9naW4oJTIyeW91cl90b2tlbiUyMiklMEElMEElMjAlMjAlMjAlMjB0b29sJTIwJTNEJTIwUmV0cmlldmVyVG9vbCh2ZWN0b3JkYiUyQyUyMGFsbF9zb3VyY2VzKSUwQSUwQSUyMCUyMCUyMCUyMHRvb2wucHVzaF90b19odWIocmVwb19pZCUzRCUyMm0tcmljJTJGcmV0cmlldmVyLXRvb2wlMjIp",highlighted:`share_to_hub = <span class="hljs-literal">False</span>

<span class="hljs-keyword">if</span> share_to_hub:
    <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
    <span class="hljs-keyword">from</span> retriever <span class="hljs-keyword">import</span> RetrieverTool

    login(<span class="hljs-string">&quot;your_token&quot;</span>)

    tool = RetrieverTool(vectordb, all_sources)

    tool.push_to_hub(repo_id=<span class="hljs-string">&quot;m-ric/retriever-tool&quot;</span>)`,wrap:!1}}),D=new wt({props:{title:"Run the agent!",local:"run-the-agent",headingTag:"h3"}}),O=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBIZkVuZ2luZSUyQyUyMFJlYWN0SnNvbkFnZW50JTJDJTIwbG9hZF90b29sJTBBJTBBbGxtX2VuZ2luZSUyMCUzRCUyMEhmRW5naW5lKCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtNzBCLUluc3RydWN0JTIyKSUwQSUwQXJldHJpZXZlcl90b29sJTIwJTNEJTIwbG9hZF90b29sKCUyMm0tcmljJTJGcmV0cmlldmVyLXRvb2wlMjIlMkMlMjB2ZWN0b3JkYiUzRHZlY3RvcmRiJTJDJTIwYWxsX3NvdXJjZXMlM0RhbGxfc291cmNlcyklMEFhZ2VudCUyMCUzRCUyMFJlYWN0SnNvbkFnZW50KHRvb2xzJTNEJTVCcmV0cmlldmVyX3Rvb2wlNUQlMkMlMjBsbG1fZW5naW5lJTNEbGxtX2VuZ2luZSUyQyUyMHZlcmJvc2UlM0QwKSUwQSUwQWFnZW50X291dHB1dCUyMCUzRCUyMGFnZW50LnJ1biglMjJQbGVhc2UlMjBzaG93JTIwbWUlMjBhJTIwTE9SQSUyMGZpbmV0dW5pbmclMjBzY3JpcHQlMjIpJTBBJTBBcHJpbnQoJTIyRmluYWwlMjBvdXRwdXQlM0ElMjIpJTBBcHJpbnQoYWdlbnRfb3V0cHV0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> HfEngine, ReactJsonAgent, load_tool

<span class="hljs-meta">&gt;&gt;&gt; </span>llm_engine = HfEngine(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>retriever_tool = load_tool(<span class="hljs-string">&quot;m-ric/retriever-tool&quot;</span>, vectordb=vectordb, all_sources=all_sources)
<span class="hljs-meta">&gt;&gt;&gt; </span>agent = ReactJsonAgent(tools=[retriever_tool], llm_engine=llm_engine, verbose=<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>agent_output = agent.run(<span class="hljs-string">&quot;Please show me a LORA finetuning script&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),nt=new wt({props:{title:"3. 💻 Debugging Python code",local:"3--debugging-python-code",headingTag:"h2"}}),ot=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlYWN0Q29kZUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCklMEElMEFjb2RlJTIwJTNEJTIwJTIyJTIyJTIyJTBBbGlzdCUzRCU1QjAlMkMlMjAxJTJDJTIwMiU1RCUwQSUwQWZvciUyMGklMjBpbiUyMHJhbmdlKDQpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQobGlzdChpKSklMEElMjIlMjIlMjIlMEElMEFmaW5hbF9hbnN3ZXIlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySSUyMGhhdmUlMjBzb21lJTIwY29kZSUyMHRoYXQlMjBjcmVhdGVzJTIwYSUyMGJ1ZyUzQSUyMHBsZWFzZSUyMGRlYnVnJTIwaXQlMjBhbmQlMjByZXR1cm4lMjB0aGUlMjBmaW5hbCUyMGNvZGUlMjIlMkMlMEElMjAlMjAlMjAlMjBjb2RlJTNEY29kZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ReactCodeAgent

agent = ReactCodeAgent(tools=[])

code = <span class="hljs-string">&quot;&quot;&quot;
list=[0, 1, 2]

for i in range(4):
    print(list(i))
&quot;&quot;&quot;</span>

final_answer = agent.run(
    <span class="hljs-string">&quot;I have some code that creates a bug: please debug it and return the final code&quot;</span>,
    code=code,
)`,wrap:!1}}),Mt=new j({props:{code:"cHJpbnQoZmluYWxfYW5zd2VyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(final_answer)',wrap:!1}}),ct=new wt({props:{title:"➡️ Conclusion",local:"-conclusion",headingTag:"h2"}}),jt=new cl({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/agents.md"}}),{c(){w=o("meta"),Jt=n(),ht=o("p"),bt=n(),M(h.$$.fragment),Ut=n(),M(d.$$.fragment),Tt=n(),J=o("p"),J.innerHTML=Te,gt=n(),b=o("p"),b.innerHTML=ge,ft=n(),U=o("p"),U.innerHTML=fe,It=n(),T=o("p"),T.innerHTML=Ie,Ct=n(),g=o("p"),g.innerHTML=Ce,vt=n(),f=o("p"),f.textContent=ve,Zt=n(),I=o("p"),I.innerHTML=Ze,Bt=n(),M(C.$$.fragment),Gt=n(),M(v.$$.fragment),kt=n(),M(Z.$$.fragment),Wt=n(),B=o("p"),B.textContent=Be,Rt=n(),G=o("p"),G.textContent=Ge,At=n(),k=o("ul"),k.innerHTML=ke,_t=n(),M(W.$$.fragment),Nt=n(),R=o("p"),R.innerHTML=We,$t=n(),M(A.$$.fragment),Vt=n(),_=o("p"),_.textContent=Re,Qt=n(),N=o("p"),N.innerHTML=Ae,St=n(),$=o("p"),$.innerHTML=_e,Xt=n(),V=o("p"),V.innerHTML=Ne,xt=n(),M(Q.$$.fragment),Ht=n(),S=o("p"),S.textContent=$e,qt=n(),M(X.$$.fragment),Yt=n(),x=o("p"),x.textContent=Ve,Et=n(),H=o("p"),H.textContent=Qe,zt=n(),q=o("p"),q.textContent=Se,Ft=n(),M(Y.$$.fragment),Lt=n(),E=o("pre"),E.textContent=Xe,Pt=n(),M(z.$$.fragment),Kt=n(),M(F.$$.fragment),Dt=n(),L=o("p"),L.innerHTML=xe,Ot=n(),P=o("p"),P.innerHTML=He,te=n(),M(K.$$.fragment),ee=n(),M(D.$$.fragment),le=n(),M(O.$$.fragment),se=n(),tt=o("pre"),tt.textContent=qe,ne=n(),et=o("p"),et.innerHTML=Ye,ae=n(),lt=o("p"),lt.textContent=Ee,oe=n(),st=o("p"),st.innerHTML=ze,ie=n(),M(nt.$$.fragment),re=n(),at=o("p"),at.textContent=Fe,Me=n(),M(ot.$$.fragment),pe=n(),it=o("p"),it.textContent=Le,ce=n(),rt=o("p"),rt.textContent=Pe,ye=n(),M(Mt.$$.fragment),ue=n(),pt=o("pre"),pt.textContent=Ke,me=n(),M(ct.$$.fragment),je=n(),yt=o("p"),yt.textContent=De,we=n(),ut=o("p"),ut.innerHTML=Oe,he=n(),mt=o("p"),mt.textContent=tl,de=n(),M(jt.$$.fragment),Je=n(),dt=o("p"),this.h()},l(t){const e=rl("svelte-u9bgzb",document.head);w=i(e,"META",{name:!0,content:!0}),e.forEach(l),Jt=a(t),ht=i(t,"P",{}),el(ht).forEach(l),bt=a(t),p(h.$$.fragment,t),Ut=a(t),p(d.$$.fragment,t),Tt=a(t),J=i(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1xlqnsv"&&(J.innerHTML=Te),gt=a(t),b=i(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-o14ioo"&&(b.innerHTML=ge),ft=a(t),U=i(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1mh34dv"&&(U.innerHTML=fe),It=a(t),T=i(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-mmy9qo"&&(T.innerHTML=Ie),Ct=a(t),g=i(t,"P",{"data-svelte-h":!0}),r(g)!=="svelte-gwofaa"&&(g.innerHTML=Ce),vt=a(t),f=i(t,"P",{"data-svelte-h":!0}),r(f)!=="svelte-fc6q9b"&&(f.textContent=ve),Zt=a(t),I=i(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-psgh4s"&&(I.innerHTML=Ze),Bt=a(t),p(C.$$.fragment,t),Gt=a(t),p(v.$$.fragment,t),kt=a(t),p(Z.$$.fragment,t),Wt=a(t),B=i(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1354tpb"&&(B.textContent=Be),Rt=a(t),G=i(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1yb5yrl"&&(G.textContent=Ge),At=a(t),k=i(t,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-1dqrk95"&&(k.innerHTML=ke),_t=a(t),p(W.$$.fragment,t),Nt=a(t),R=i(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1hg95q8"&&(R.innerHTML=We),$t=a(t),p(A.$$.fragment,t),Vt=a(t),_=i(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-wr7xp9"&&(_.textContent=Re),Qt=a(t),N=i(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-108grnk"&&(N.innerHTML=Ae),St=a(t),$=i(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1283j65"&&($.innerHTML=_e),Xt=a(t),V=i(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1qw64fs"&&(V.innerHTML=Ne),xt=a(t),p(Q.$$.fragment,t),Ht=a(t),S=i(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-jy4i2f"&&(S.textContent=$e),qt=a(t),p(X.$$.fragment,t),Yt=a(t),x=i(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-5pp8py"&&(x.textContent=Ve),Et=a(t),H=i(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1cx88lu"&&(H.textContent=Qe),zt=a(t),q=i(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1vgfwws"&&(q.textContent=Se),Ft=a(t),p(Y.$$.fragment,t),Lt=a(t),E=i(t,"PRE",{"data-svelte-h":!0}),r(E)!=="svelte-87x3d8"&&(E.textContent=Xe),Pt=a(t),p(z.$$.fragment,t),Kt=a(t),p(F.$$.fragment,t),Dt=a(t),L=i(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-19hckuz"&&(L.innerHTML=xe),Ot=a(t),P=i(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1wpkyax"&&(P.innerHTML=He),te=a(t),p(K.$$.fragment,t),ee=a(t),p(D.$$.fragment,t),le=a(t),p(O.$$.fragment,t),se=a(t),tt=i(t,"PRE",{"data-svelte-h":!0}),r(tt)!=="svelte-l44zt6"&&(tt.textContent=qe),ne=a(t),et=i(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-6d9ubm"&&(et.innerHTML=Ye),ae=a(t),lt=i(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-ud3g55"&&(lt.textContent=Ee),oe=a(t),st=i(t,"P",{"data-svelte-h":!0}),r(st)!=="svelte-3qqlok"&&(st.innerHTML=ze),ie=a(t),p(nt.$$.fragment,t),re=a(t),at=i(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-3y19vc"&&(at.textContent=Fe),Me=a(t),p(ot.$$.fragment,t),pe=a(t),it=i(t,"P",{"data-svelte-h":!0}),r(it)!=="svelte-168ebuv"&&(it.textContent=Le),ce=a(t),rt=i(t,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-vscncs"&&(rt.textContent=Pe),ye=a(t),p(Mt.$$.fragment,t),ue=a(t),pt=i(t,"PRE",{"data-svelte-h":!0}),r(pt)!=="svelte-1t45l4d"&&(pt.textContent=Ke),me=a(t),p(ct.$$.fragment,t),je=a(t),yt=i(t,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-1nx9qzu"&&(yt.textContent=De),we=a(t),ut=i(t,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1nxb7v"&&(ut.innerHTML=Oe),he=a(t),mt=i(t,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-1ctcozl"&&(mt.textContent=tl),de=a(t),p(jt.$$.fragment,t),Je=a(t),dt=i(t,"P",{}),el(dt).forEach(l),this.h()},h(){ll(w,"name","hf:doc:metadata"),ll(w,"content",ul)},m(t,e){Ml(document.head,w),s(t,Jt,e),s(t,ht,e),s(t,bt,e),c(h,t,e),s(t,Ut,e),c(d,t,e),s(t,Tt,e),s(t,J,e),s(t,gt,e),s(t,b,e),s(t,ft,e),s(t,U,e),s(t,It,e),s(t,T,e),s(t,Ct,e),s(t,g,e),s(t,vt,e),s(t,f,e),s(t,Zt,e),s(t,I,e),s(t,Bt,e),c(C,t,e),s(t,Gt,e),c(v,t,e),s(t,kt,e),c(Z,t,e),s(t,Wt,e),s(t,B,e),s(t,Rt,e),s(t,G,e),s(t,At,e),s(t,k,e),s(t,_t,e),c(W,t,e),s(t,Nt,e),s(t,R,e),s(t,$t,e),c(A,t,e),s(t,Vt,e),s(t,_,e),s(t,Qt,e),s(t,N,e),s(t,St,e),s(t,$,e),s(t,Xt,e),s(t,V,e),s(t,xt,e),c(Q,t,e),s(t,Ht,e),s(t,S,e),s(t,qt,e),c(X,t,e),s(t,Yt,e),s(t,x,e),s(t,Et,e),s(t,H,e),s(t,zt,e),s(t,q,e),s(t,Ft,e),c(Y,t,e),s(t,Lt,e),s(t,E,e),s(t,Pt,e),c(z,t,e),s(t,Kt,e),c(F,t,e),s(t,Dt,e),s(t,L,e),s(t,Ot,e),s(t,P,e),s(t,te,e),c(K,t,e),s(t,ee,e),c(D,t,e),s(t,le,e),c(O,t,e),s(t,se,e),s(t,tt,e),s(t,ne,e),s(t,et,e),s(t,ae,e),s(t,lt,e),s(t,oe,e),s(t,st,e),s(t,ie,e),c(nt,t,e),s(t,re,e),s(t,at,e),s(t,Me,e),c(ot,t,e),s(t,pe,e),s(t,it,e),s(t,ce,e),s(t,rt,e),s(t,ye,e),c(Mt,t,e),s(t,ue,e),s(t,pt,e),s(t,me,e),c(ct,t,e),s(t,je,e),s(t,yt,e),s(t,we,e),s(t,ut,e),s(t,he,e),s(t,mt,e),s(t,de,e),c(jt,t,e),s(t,Je,e),s(t,dt,e),be=!0},p:nl,i(t){be||(y(h.$$.fragment,t),y(d.$$.fragment,t),y(C.$$.fragment,t),y(v.$$.fragment,t),y(Z.$$.fragment,t),y(W.$$.fragment,t),y(A.$$.fragment,t),y(Q.$$.fragment,t),y(X.$$.fragment,t),y(Y.$$.fragment,t),y(z.$$.fragment,t),y(F.$$.fragment,t),y(K.$$.fragment,t),y(D.$$.fragment,t),y(O.$$.fragment,t),y(nt.$$.fragment,t),y(ot.$$.fragment,t),y(Mt.$$.fragment,t),y(ct.$$.fragment,t),y(jt.$$.fragment,t),be=!0)},o(t){u(h.$$.fragment,t),u(d.$$.fragment,t),u(C.$$.fragment,t),u(v.$$.fragment,t),u(Z.$$.fragment,t),u(W.$$.fragment,t),u(A.$$.fragment,t),u(Q.$$.fragment,t),u(X.$$.fragment,t),u(Y.$$.fragment,t),u(z.$$.fragment,t),u(F.$$.fragment,t),u(K.$$.fragment,t),u(D.$$.fragment,t),u(O.$$.fragment,t),u(nt.$$.fragment,t),u(ot.$$.fragment,t),u(Mt.$$.fragment,t),u(ct.$$.fragment,t),u(jt.$$.fragment,t),be=!1},d(t){t&&(l(Jt),l(ht),l(bt),l(Ut),l(Tt),l(J),l(gt),l(b),l(ft),l(U),l(It),l(T),l(Ct),l(g),l(vt),l(f),l(Zt),l(I),l(Bt),l(Gt),l(kt),l(Wt),l(B),l(Rt),l(G),l(At),l(k),l(_t),l(Nt),l(R),l($t),l(Vt),l(_),l(Qt),l(N),l(St),l($),l(Xt),l(V),l(xt),l(Ht),l(S),l(qt),l(Yt),l(x),l(Et),l(H),l(zt),l(q),l(Ft),l(Lt),l(E),l(Pt),l(Kt),l(Dt),l(L),l(Ot),l(P),l(te),l(ee),l(le),l(se),l(tt),l(ne),l(et),l(ae),l(lt),l(oe),l(st),l(ie),l(re),l(at),l(Me),l(pe),l(it),l(ce),l(rt),l(ye),l(ue),l(pt),l(me),l(je),l(yt),l(we),l(ut),l(he),l(mt),l(de),l(Je),l(dt)),l(w),m(h,t),m(d,t),m(C,t),m(v,t),m(Z,t),m(W,t),m(A,t),m(Q,t),m(X,t),m(Y,t),m(z,t),m(F,t),m(K,t),m(D,t),m(O,t),m(nt,t),m(ot,t),m(Mt,t),m(ct,t),m(jt,t)}}}const ul='{"title":"Build an agent with tool-calling superpowers 🦸 using Transformers Agents","local":"build-an-agent-with-tool-calling-superpowers--using-transformers-agents","sections":[{"title":"1. 🏞️ Multimodal + 🌐 Web-browsing assistant","local":"1--multimodal---web-browsing-assistant","sections":[],"depth":2},{"title":"2. 📚💬 Retrieval-Augmented Generation with source selection","local":"2--retrieval-augmented-generation-with-source-selection","sections":[{"title":"Optional: Share your Retriever tool to Hub","local":"optional-share-your-retriever-tool-to-hub","sections":[],"depth":3},{"title":"Run the agent!","local":"run-the-agent","sections":[],"depth":3}],"depth":2},{"title":"3. 💻 Debugging Python code","local":"3--debugging-python-code","sections":[],"depth":2},{"title":"➡️ Conclusion","local":"-conclusion","sections":[],"depth":2}],"depth":1}';function ml(Ue){return al(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jl extends ol{constructor(w){super(),il(this,w,ml,yl,sl,{})}}export{Jl as component};
