import{s as At,y as Ft,n as Rt,o as Yt}from"../chunks/scheduler.d6170356.js";import{S as qt,i as Nt,g as n,s as a,r as M,A as Dt,h as o,f as l,c as i,j as St,u as v,x as r,k as d,y as Ot,a as s,v as _,d as J,t as H,w as j}from"../chunks/index.fcd4cc08.js";import{C as Qt}from"../chunks/CodeBlock.7b16bdef.js";import{H as ue,E as Kt}from"../chunks/EditOnGithub.da2b595c.js";function el(it){let u,ce,re,he,k,me,C,nt='To upload models to the Hub, you’ll need to create an account at <a href="https://huggingface.co/join" rel="nofollow">Hugging Face</a>. Models on the Hub are <a href="./repositories">Git-based repositories</a>, which give you versioning, branches, discoverability and sharing features, integration with dozens of libraries, and more! You have control over what you want to upload to your repository, which could include checkpoints, configs, and any other files.',pe,I,ot='You can link repositories with an individual user, such as <a href="https://huggingface.co/osanseviero/fashion_brands_patterns" rel="nofollow">osanseviero/fashion_brands_patterns</a>, or with an organization, such as <a href="https://huggingface.co/facebook/bart-large-xsum" rel="nofollow">facebook/bart-large-xsum</a>. Organizations can collect models related to a company, community, or library! If you choose an organization, the model will be featured on the organization’s page, and every member of the organization will have the ability to contribute to the repository. You can create a new organization <a href="https://huggingface.co/organizations/new" rel="nofollow">here</a>.',fe,x,rt="<p><strong><em>NOTE:</em></strong> Models do NOT need to be compatible with the Transformers/Diffusers libraries to get download metrics. Any custom model is supported. Read more below!</p>",ge,L,dt='There are several ways to upload models for them to be nicely integrated into the Hub and get <a href="models-download-stats">download metrics</a>, described below.',be,U,ut='<li>In case your model is designed for a library that has <a href="#upload-from-a-library-with-built-in-support">built-in support</a>, you can use the methods provided by the library. Custom models that use <code>trust_remote_code=True</code> can also leverage these methods.</li> <li>In case your model is a custom PyTorch model, one can leverage the <a href="#upload-a-pytorch-model-using-huggingface_hub"><code>PyTorchModelHubMixin</code> class</a> as it allows to add <code>from_pretrained</code>, <code>push_to_hub</code> to any <code>nn.Module</code> class, just like models in the Transformers, Diffusers and Timm libraries.</li> <li>In addition to programmatic uploads, you can always use the <a href="#using-the-web-interface">web interface</a>.</li>',ye,$,ct='Once your model is uploaded, we suggest adding a <a href="./model-cards">Model Card</a> to your repo to document your model and make it more discoverable.',we,c,ht,Te,Z,mt="Example [repository](https://huggingface.co/LiheYoung/depth_anything_vitl14) that leverages [PyTorchModelHubMixin](#upload-a-pytorch-model-using-huggingface_hub). Downloads are shown on the right.",Me,W,ve,B,pt='To create a brand new model repository, visit <a href="http://huggingface.co/new" rel="nofollow">huggingface.co/new</a>. Then follow these steps:',_e,z,ft="<li>In the “Files and versions” tab, select “Add File” and specify “Upload File”:</li>",Je,h,gt='<img class="block dark:hidden" width="300" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/add-file.png"/> <img class="hidden dark:block" width="300" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/add-file-dark.png"/>',He,m,bt="<li>From there, select a file from your computer to upload and leave a helpful commit message to know what you are uploading:</li>",je,p,yt='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/commit-file.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/commit-file-dark.png"/>',ke,f,wt="<li><p>Afterwards, click <strong>Commit changes</strong> to upload your model to the Hub!</p></li> <li><p>Inspect files and history</p></li>",Ce,G,Tt="You can check your repository with all the recently added files!",Ie,g,Mt='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/repo_with_files.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/repo_with_files-dark.png"/>',xe,V,vt="The UI allows you to explore the model files and commits and to see the diff introduced by each commit:",Le,b,_t='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/explore_history.gif"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/explore_history-dark.gif"/>',Ue,y,Jt="<li>Add metadata</li>",$e,E,Ht="You can add metadata to your model card. You can specify:",Ze,P,jt="<li>the type of task this model is for, enabling widgets and the Inference API.</li> <li>the used library (<code>transformers</code>, <code>spaCy</code>, etc.)</li> <li>the language</li> <li>the dataset</li> <li>metrics</li> <li>license</li> <li>a lot more!</li>",We,X,kt='Read more about model tags <a href="./model-cards#model-card-metadata">here</a>.',Be,w,Ct="<li>Add TensorBoard traces</li>",ze,S,It='Any repository that contains TensorBoard traces (filenames that contain <code>tfevents</code>) is categorized with the <a href="https://huggingface.co/models?filter=tensorboard" rel="nofollow"><code>TensorBoard</code> tag</a>. As a convention, we suggest that you save traces under the <code>runs/</code> subfolder. The “Training metrics” tab then makes it easy to review charts of the logged variables, like the loss or the accuracy.',Ge,T,xt='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/tensorboard.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/tensorboard-dark.png"/>',Ve,Q,Lt='Models trained with 🤗 Transformers will generate <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.integrations.TensorBoardCallback" rel="nofollow">TensorBoard traces</a> by default if <a href="https://pypi.org/project/tensorboard/" rel="nofollow"><code>tensorboard</code></a> is installed.',Ee,A,Pe,F,Ut='First check if your model is from a library that has built-in support to push to/load from the Hub, like Transformers, Diffusers, Timm, Asteroid, etc.: <a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">https://huggingface.co/docs/hub/models-libraries</a>. Below we’ll show how easy this is for a library like Transformers:',Xe,R,Se,Y,$t='Some libraries, like Transformers, support loading <a href="https://huggingface.co/docs/transformers/custom_models" rel="nofollow">code from the Hub</a>. This is a way to make your model work with Transformers using the <code>trust_remote_code=True</code> flag. You may want to consider this option instead of a full-fledged library integration.',Qe,q,Ae,N,Zt='In case your model is a (custom) PyTorch model, you can leverage the <code>PyTorchModelHubMixin</code> <a href="https://huggingface.co/docs/huggingface_hub/package_reference/mixins#huggingface_hub.PyTorchModelHubMixin" rel="nofollow">class</a> available in the <a href="https://github.com/huggingface/huggingface_hub" rel="nofollow">huggingface_hub</a> Python library. It is a minimal class which adds <code>from_pretrained</code> and <code>push_to_hub</code> capabilities to any <code>nn.Module</code>, along with download metrics.',Fe,D,Wt="Here is how to use it (assuming you have run <code>pip install huggingface_hub</code>):",Re,O,Ye,K,Bt="As you can see, the only requirement is that your model inherits from <code>PyTorchModelHubMixin</code>. All instance attributes will be automatically serialized to a <code>config.json</code> file.",qe,ee,zt="This comes with automated download metrics, meaning that you’ll be able to see how many times the model is downloaded, the same way they are available for models integrated natively in the Transformers, Diffusers or Timm libraries. With this mixin class, each separate checkpoint is stored on the Hub in a single repository consisting of 2 files:",Ne,te,Gt='<li>a <code>pytorch_model.bin</code> or <code>model.safetensors</code> file containing the weights</li> <li>a <code>config.json</code> file which is a serialized version of the model configuration. This class is used for counting download metrics: everytime a user calls <code>from_pretrained</code> to load a <code>config.json</code>, the count goes up by one. See <a href="https://huggingface.co/docs/hub/models-download-stats" rel="nofollow">this guide</a> regarding automated download metrics.</li>',De,le,Vt="It’s recommended to add a model card to each checkpoint so that people can read what the model is about, have a link to the paper, etc.",Oe,se,Et='Visit <a href="https://huggingface.co/docs/huggingface_hub/guides/integrations" rel="nofollow">the huggingface_hub’s documentation</a> to learn more.',Ke,ae,Pt='Alternatively, one can also simply programmatically upload files or folders to the hub: <a href="https://huggingface.co/docs/huggingface_hub/guides/upload" rel="nofollow">https://huggingface.co/docs/huggingface_hub/guides/upload</a>.',et,ie,tt,ne,Xt='Finally, since model repos are just Git repositories, you can also use Git to push your model files to the Hub. Follow the guide on <a href="repositories-getting-started#adding-files-to-a-repository-terminalterminal">Getting Started with Repositories</a> to learn about using the <code>git</code> CLI to commit and push your models.',lt,oe,st,de,at;return k=new ue({props:{title:"Uploading models",local:"uploading-models",headingTag:"h1"}}),W=new ue({props:{title:"Using the web interface",local:"using-the-web-interface",headingTag:"h2"}}),A=new ue({props:{title:"Upload from a library with built-in support",local:"upload-from-a-library-with-built-in-support",headingTag:"h2"}}),R=new Qt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRDb25maWclMkMlMjBCZXJ0TW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBCZXJ0Q29uZmlnKCklMEFtb2RlbCUyMCUzRCUyMEJlcnRNb2RlbChjb25maWcpJTBBJTBBbW9kZWwucHVzaF90b19odWIoJTIybmllbHNyJTJGbXktYXdlc29tZS1iZXJ0LW1vZGVsJTIyKSUwQSUwQSUyMyUyMHJlbG9hZCUwQW1vZGVsJTIwJTNEJTIwQmVydE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJuaWVsc3IlMkZteS1hd2Vzb21lLWJlcnQtbW9kZWwlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertConfig, BertModel

config = BertConfig()
model = BertModel(config)

model.push_to_hub(<span class="hljs-string">&quot;nielsr/my-awesome-bert-model&quot;</span>)

<span class="hljs-comment"># reload</span>
model = BertModel.from_pretrained(<span class="hljs-string">&quot;nielsr/my-awesome-bert-model&quot;</span>)`,wrap:!1}}),q=new ue({props:{title:"Upload a PyTorch model using huggingface_hub",local:"upload-a-pytorch-model-using-huggingfacehub",headingTag:"h2"}}),O=new Qt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwUHlUb3JjaE1vZGVsSHViTWl4aW4lMEElMEElMEFjbGFzcyUyME15TW9kZWwobm4uTW9kdWxlJTJDJTIwUHlUb3JjaE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMG51bV9jaGFubmVscyUzQSUyMGludCUyQyUyMGhpZGRlbl9zaXplJTNBJTIwaW50JTJDJTIwbnVtX2NsYXNzZXMlM0ElMjBpbnQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5wYXJhbSUyMCUzRCUyMG5uLlBhcmFtZXRlcih0b3JjaC5yYW5kKG51bV9jaGFubmVscyUyQyUyMGhpZGRlbl9zaXplKSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmxpbmVhciUyMCUzRCUyMG5uLkxpbmVhcihoaWRkZW5fc2l6ZSUyQyUyMG51bV9jbGFzc2VzKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2VsZi5saW5lYXIoeCUyMCUyQiUyMHNlbGYucGFyYW0pJTBBJTBBJTIzJTIwY3JlYXRlJTIwbW9kZWwlMEFjb25maWclMjAlM0QlMjAlN0IlMjJudW1fY2hhbm5lbHMlMjIlM0ElMjAzJTJDJTIwJTIyaGlkZGVuX3NpemUlMjIlM0ElMjAzMiUyQyUyMCUyMm51bV9jbGFzc2VzJTIyJTNBJTIwMTAlN0QlMEFtb2RlbCUyMCUzRCUyME15TW9kZWwoKipjb25maWcpJTBBJTBBJTIzJTIwc2F2ZSUyMGxvY2FsbHklMEFtb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIybXktYXdlc29tZS1tb2RlbCUyMiklMEElMEElMjMlMjBwdXNoJTIwdG8lMjB0aGUlMjBodWIlMEFtb2RlbC5wdXNoX3RvX2h1YiglMjJteS1hd2Vzb21lLW1vZGVsJTIyKSUwQSUwQSUyMyUyMHJlbG9hZCUwQW1vZGVsJTIwJTNEJTIwTXlNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIydXNlcm5hbWUlMkZteS1hd2Vzb21lLW1vZGVsJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> PyTorchModelHubMixin


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(nn.Module, PyTorchModelHubMixin):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, num_channels: <span class="hljs-built_in">int</span>, hidden_size: <span class="hljs-built_in">int</span>, num_classes: <span class="hljs-built_in">int</span></span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.param = nn.Parameter(torch.rand(num_channels, hidden_size))
        self.linear = nn.Linear(hidden_size, num_classes)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-keyword">return</span> self.linear(x + self.param)

<span class="hljs-comment"># create model</span>
config = {<span class="hljs-string">&quot;num_channels&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;hidden_size&quot;</span>: <span class="hljs-number">32</span>, <span class="hljs-string">&quot;num_classes&quot;</span>: <span class="hljs-number">10</span>}
model = MyModel(**config)

<span class="hljs-comment"># save locally</span>
model.save_pretrained(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># push to the hub</span>
model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># reload</span>
model = MyModel.from_pretrained(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)`,wrap:!1}}),ie=new ue({props:{title:"Using Git",local:"using-git",headingTag:"h2"}}),oe=new Kt({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/models-uploading.md"}}),{c(){u=n("meta"),ce=a(),re=n("p"),he=a(),M(k.$$.fragment),me=a(),C=n("p"),C.innerHTML=nt,pe=a(),I=n("p"),I.innerHTML=ot,fe=a(),x=n("blockquote"),x.innerHTML=rt,ge=a(),L=n("p"),L.innerHTML=dt,be=a(),U=n("ul"),U.innerHTML=ut,ye=a(),$=n("p"),$.innerHTML=ct,we=a(),c=n("img"),Te=a(),Z=n("small"),Z.textContent=mt,Me=a(),M(W.$$.fragment),ve=a(),B=n("p"),B.innerHTML=pt,_e=a(),z=n("ol"),z.innerHTML=ft,Je=a(),h=n("div"),h.innerHTML=gt,He=a(),m=n("ol"),m.innerHTML=bt,je=a(),p=n("div"),p.innerHTML=yt,ke=a(),f=n("ol"),f.innerHTML=wt,Ce=a(),G=n("p"),G.textContent=Tt,Ie=a(),g=n("div"),g.innerHTML=Mt,xe=a(),V=n("p"),V.textContent=vt,Le=a(),b=n("div"),b.innerHTML=_t,Ue=a(),y=n("ol"),y.innerHTML=Jt,$e=a(),E=n("p"),E.textContent=Ht,Ze=a(),P=n("ul"),P.innerHTML=jt,We=a(),X=n("p"),X.innerHTML=kt,Be=a(),w=n("ol"),w.innerHTML=Ct,ze=a(),S=n("p"),S.innerHTML=It,Ge=a(),T=n("div"),T.innerHTML=xt,Ve=a(),Q=n("p"),Q.innerHTML=Lt,Ee=a(),M(A.$$.fragment),Pe=a(),F=n("p"),F.innerHTML=Ut,Xe=a(),M(R.$$.fragment),Se=a(),Y=n("p"),Y.innerHTML=$t,Qe=a(),M(q.$$.fragment),Ae=a(),N=n("p"),N.innerHTML=Zt,Fe=a(),D=n("p"),D.innerHTML=Wt,Re=a(),M(O.$$.fragment),Ye=a(),K=n("p"),K.innerHTML=Bt,qe=a(),ee=n("p"),ee.textContent=zt,Ne=a(),te=n("ul"),te.innerHTML=Gt,De=a(),le=n("p"),le.textContent=Vt,Oe=a(),se=n("p"),se.innerHTML=Et,Ke=a(),ae=n("p"),ae.innerHTML=Pt,et=a(),M(ie.$$.fragment),tt=a(),ne=n("p"),ne.innerHTML=Xt,lt=a(),M(oe.$$.fragment),st=a(),de=n("p"),this.h()},l(e){const t=Dt("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(l),ce=i(e),re=o(e,"P",{}),St(re).forEach(l),he=i(e),v(k.$$.fragment,e),me=i(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1k1s32s"&&(C.innerHTML=nt),pe=i(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1yho9nm"&&(I.innerHTML=ot),fe=i(e),x=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(x)!=="svelte-5gr2ts"&&(x.innerHTML=rt),ge=i(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-u47biw"&&(L.innerHTML=dt),be=i(e),U=o(e,"UL",{"data-svelte-h":!0}),r(U)!=="svelte-1wbv7rg"&&(U.innerHTML=ut),ye=i(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-vwc1dj"&&($.innerHTML=ct),we=i(e),c=o(e,"IMG",{src:!0,alt:!0,width:!0}),Te=i(e),Z=o(e,"SMALL",{"data-svelte-h":!0}),r(Z)!=="svelte-1v0qx61"&&(Z.textContent=mt),Me=i(e),v(W.$$.fragment,e),ve=i(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-x37mbe"&&(B.innerHTML=pt),_e=i(e),z=o(e,"OL",{"data-svelte-h":!0}),r(z)!=="svelte-m7dyke"&&(z.innerHTML=ft),Je=i(e),h=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-1kwaicp"&&(h.innerHTML=gt),He=i(e),m=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(m)!=="svelte-bnx7wi"&&(m.innerHTML=bt),je=i(e),p=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(p)!=="svelte-1yhipjn"&&(p.innerHTML=yt),ke=i(e),f=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(f)!=="svelte-1g8w05a"&&(f.innerHTML=wt),Ce=i(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-197c7zs"&&(G.textContent=Tt),Ie=i(e),g=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-1vobd2z"&&(g.innerHTML=Mt),xe=i(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-9fow57"&&(V.textContent=vt),Le=i(e),b=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-cdui6d"&&(b.innerHTML=_t),Ue=i(e),y=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(y)!=="svelte-j2g6d3"&&(y.innerHTML=Jt),$e=i(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-gkc8cy"&&(E.textContent=Ht),Ze=i(e),P=o(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-tl31d8"&&(P.innerHTML=jt),We=i(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-6zfhus"&&(X.innerHTML=kt),Be=i(e),w=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(w)!=="svelte-1r5hl08"&&(w.innerHTML=Ct),ze=i(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-duz775"&&(S.innerHTML=It),Ge=i(e),T=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-rlnnzb"&&(T.innerHTML=xt),Ve=i(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-hpisbu"&&(Q.innerHTML=Lt),Ee=i(e),v(A.$$.fragment,e),Pe=i(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-mz82tu"&&(F.innerHTML=Ut),Xe=i(e),v(R.$$.fragment,e),Se=i(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1mkmuk9"&&(Y.innerHTML=$t),Qe=i(e),v(q.$$.fragment,e),Ae=i(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1pq7dxk"&&(N.innerHTML=Zt),Fe=i(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-uwt68k"&&(D.innerHTML=Wt),Re=i(e),v(O.$$.fragment,e),Ye=i(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-149w2g"&&(K.innerHTML=Bt),qe=i(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1f1zsla"&&(ee.textContent=zt),Ne=i(e),te=o(e,"UL",{"data-svelte-h":!0}),r(te)!=="svelte-m0rjhi"&&(te.innerHTML=Gt),De=i(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1j0lu4s"&&(le.textContent=Vt),Oe=i(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1e814df"&&(se.innerHTML=Et),Ke=i(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1x88idh"&&(ae.innerHTML=Pt),et=i(e),v(ie.$$.fragment,e),tt=i(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-9t8mwt"&&(ne.innerHTML=Xt),lt=i(e),v(oe.$$.fragment,e),st=i(e),de=o(e,"P",{}),St(de).forEach(l),this.h()},h(){d(u,"name","hf:doc:metadata"),d(u,"content",tl),Ft(c.src,ht="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/example_repository.png")||d(c,"src",ht),d(c,"alt","drawing"),d(c,"width","600"),d(h,"class","flex justify-center"),d(m,"start","2"),d(p,"class","flex justify-center"),d(f,"start","3"),d(g,"class","flex justify-center"),d(b,"class","flex justify-center"),d(y,"start","5"),d(w,"start","6"),d(T,"class","flex justify-center")},m(e,t){Ot(document.head,u),s(e,ce,t),s(e,re,t),s(e,he,t),_(k,e,t),s(e,me,t),s(e,C,t),s(e,pe,t),s(e,I,t),s(e,fe,t),s(e,x,t),s(e,ge,t),s(e,L,t),s(e,be,t),s(e,U,t),s(e,ye,t),s(e,$,t),s(e,we,t),s(e,c,t),s(e,Te,t),s(e,Z,t),s(e,Me,t),_(W,e,t),s(e,ve,t),s(e,B,t),s(e,_e,t),s(e,z,t),s(e,Je,t),s(e,h,t),s(e,He,t),s(e,m,t),s(e,je,t),s(e,p,t),s(e,ke,t),s(e,f,t),s(e,Ce,t),s(e,G,t),s(e,Ie,t),s(e,g,t),s(e,xe,t),s(e,V,t),s(e,Le,t),s(e,b,t),s(e,Ue,t),s(e,y,t),s(e,$e,t),s(e,E,t),s(e,Ze,t),s(e,P,t),s(e,We,t),s(e,X,t),s(e,Be,t),s(e,w,t),s(e,ze,t),s(e,S,t),s(e,Ge,t),s(e,T,t),s(e,Ve,t),s(e,Q,t),s(e,Ee,t),_(A,e,t),s(e,Pe,t),s(e,F,t),s(e,Xe,t),_(R,e,t),s(e,Se,t),s(e,Y,t),s(e,Qe,t),_(q,e,t),s(e,Ae,t),s(e,N,t),s(e,Fe,t),s(e,D,t),s(e,Re,t),_(O,e,t),s(e,Ye,t),s(e,K,t),s(e,qe,t),s(e,ee,t),s(e,Ne,t),s(e,te,t),s(e,De,t),s(e,le,t),s(e,Oe,t),s(e,se,t),s(e,Ke,t),s(e,ae,t),s(e,et,t),_(ie,e,t),s(e,tt,t),s(e,ne,t),s(e,lt,t),_(oe,e,t),s(e,st,t),s(e,de,t),at=!0},p:Rt,i(e){at||(J(k.$$.fragment,e),J(W.$$.fragment,e),J(A.$$.fragment,e),J(R.$$.fragment,e),J(q.$$.fragment,e),J(O.$$.fragment,e),J(ie.$$.fragment,e),J(oe.$$.fragment,e),at=!0)},o(e){H(k.$$.fragment,e),H(W.$$.fragment,e),H(A.$$.fragment,e),H(R.$$.fragment,e),H(q.$$.fragment,e),H(O.$$.fragment,e),H(ie.$$.fragment,e),H(oe.$$.fragment,e),at=!1},d(e){e&&(l(ce),l(re),l(he),l(me),l(C),l(pe),l(I),l(fe),l(x),l(ge),l(L),l(be),l(U),l(ye),l($),l(we),l(c),l(Te),l(Z),l(Me),l(ve),l(B),l(_e),l(z),l(Je),l(h),l(He),l(m),l(je),l(p),l(ke),l(f),l(Ce),l(G),l(Ie),l(g),l(xe),l(V),l(Le),l(b),l(Ue),l(y),l($e),l(E),l(Ze),l(P),l(We),l(X),l(Be),l(w),l(ze),l(S),l(Ge),l(T),l(Ve),l(Q),l(Ee),l(Pe),l(F),l(Xe),l(Se),l(Y),l(Qe),l(Ae),l(N),l(Fe),l(D),l(Re),l(Ye),l(K),l(qe),l(ee),l(Ne),l(te),l(De),l(le),l(Oe),l(se),l(Ke),l(ae),l(et),l(tt),l(ne),l(lt),l(st),l(de)),l(u),j(k,e),j(W,e),j(A,e),j(R,e),j(q,e),j(O,e),j(ie,e),j(oe,e)}}}const tl='{"title":"Uploading models","local":"uploading-models","sections":[{"title":"Using the web interface","local":"using-the-web-interface","sections":[],"depth":2},{"title":"Upload from a library with built-in support","local":"upload-from-a-library-with-built-in-support","sections":[],"depth":2},{"title":"Upload a PyTorch model using huggingface_hub","local":"upload-a-pytorch-model-using-huggingfacehub","sections":[],"depth":2},{"title":"Using Git","local":"using-git","sections":[],"depth":2}],"depth":1}';function ll(it){return Yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ol extends qt{constructor(u){super(),Nt(this,u,ll,el,At,{})}}export{ol as component};
