import{s as ps,n as fs,o as ms}from"../chunks/scheduler.0219f8bd.js";import{S as hs,i as Ts,g as d,s as r,r as c,A as ys,h as s,f as i,c as u,j as n,u as p,x as o,k as a,y as $s,a as l,v as f,d as m,t as h,w as T}from"../chunks/index.f61edf3b.js";import{H as y,E as _s}from"../chunks/index.ef6fbf3e.js";function vs(ju){let $,Ze,Xe,ti,_,ei,v,ii,L,Uu="Custom data structures.",li,x,Bu=`These are only used internally, meaning an end-user shouldn’t
need to access anything here.`,ri,k,Fu='<li><a href="#module_utils/data-structures">utils/data-structures</a><ul><li><em>static</em><ul><li><a href="#module_utils/data-structures.PriorityQueue">.PriorityQueue</a><ul><li><a href="#new_module_utils/data-structures.PriorityQueue_new"><code>new PriorityQueue(comparator)</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+size"><code>.size</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+isEmpty"><code>.isEmpty()</code></a> ⇒ <code>boolean</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+peek"><code>.peek()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+push"><code>.push(...values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+extend"><code>.extend(values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+pop"><code>.pop()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+replace"><code>.replace(value)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+_siftUpFrom"><code>._siftUpFrom(node)</code></a></li></ul></li> <li><a href="#module_utils/data-structures.CharTrie">.CharTrie</a><ul><li><a href="#module_utils/data-structures.CharTrie+extend"><code>.extend(texts)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+push"><code>.push(text)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+commonPrefixSearch"><code>.commonPrefixSearch(text)</code></a></li></ul></li> <li><a href="#module_utils/data-structures.TokenLattice">.TokenLattice</a><ul><li><a href="#new_module_utils/data-structures.TokenLattice_new"><code>new TokenLattice(sentence, bosTokenId, eosTokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+insert"><code>.insert(pos, length, score, tokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+viterbi"><code>.viterbi()</code></a> ⇒ <code>Array.&lt;TokenLatticeNode&gt;</code></li> <li><a href="#module_utils/data-structures.TokenLattice+piece"><code>.piece(node)</code></a> ⇒ <code>string</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokens"><code>.tokens()</code></a> ⇒ <code>Array.&lt;string&gt;</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokenIds"><code>.tokenIds()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li></ul></li> <li><a href="#module_utils/data-structures.DictionarySplitter">.DictionarySplitter</a><ul><li><a href="#new_module_utils/data-structures.DictionarySplitter_new"><code>new DictionarySplitter(dictionary)</code></a></li> <li><a href="#module_utils/data-structures.DictionarySplitter+split"><code>.split(text)</code></a> ⇒ <code>Array.&lt;string&gt;</code></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/data-structures..CharTrieNode">~CharTrieNode</a><ul><li><a href="#new_module_utils/data-structures..CharTrieNode_new"><code>new CharTrieNode(isLeaf, children)</code></a></li> <li><a href="#module_utils/data-structures..CharTrieNode.default"><code>.default()</code></a> ⇒ <code>CharTrieNode</code></li></ul></li> <li><a href="#module_utils/data-structures..TokenLatticeNode">~TokenLatticeNode</a><ul><li><a href="#new_module_utils/data-structures..TokenLatticeNode_new"><code>new TokenLatticeNode(tokenId, nodeId, pos, length, score)</code></a></li> <li><a href="#module_utils/data-structures..TokenLatticeNode+clone"><code>.clone()</code></a> ⇒ <code>TokenLatticeNode</code></li></ul></li></ul></li></ul></li>',ui,di,si,C,oi,b,ai,H,Ou=`Efficient Heap-based Implementation of a Priority Queue.
It uses an array-based binary heap, where the root is at index <code>0</code>, and the
children of node <code>i</code> are located at indices <code>2i + 1</code> and <code>2i + 2</code>, respectively.`,ni,P,Gu="Adapted from the following sources:",ci,w,Vu='<li><a href="https://stackoverflow.com/a/42919752/13989043" rel="nofollow">https://stackoverflow.com/a/42919752/13989043</a> (original)</li> <li><a href="https://github.com/belladoreai/llama-tokenizer-js" rel="nofollow">https://github.com/belladoreai/llama-tokenizer-js</a> (minor improvements)</li>',pi,M,Wu='<strong>Kind</strong>: static class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',fi,A,Ju='<li><a href="#module_utils/data-structures.PriorityQueue">.PriorityQueue</a><ul><li><a href="#new_module_utils/data-structures.PriorityQueue_new"><code>new PriorityQueue(comparator)</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+size"><code>.size</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+isEmpty"><code>.isEmpty()</code></a> ⇒ <code>boolean</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+peek"><code>.peek()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+push"><code>.push(...values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+extend"><code>.extend(values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+pop"><code>.pop()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+replace"><code>.replace(value)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+_siftUpFrom"><code>._siftUpFrom(node)</code></a></li></ul></li>',mi,hi,Ti,Q,yi,N,$i,g,Xu="Create a new PriorityQueue.",_i,E,Yu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>comparator</td><td><code>function</code></td><td><p>Comparator function to determine priority. Defaults to a MaxHeap.</p></td></tr></tbody>",vi,Li,xi,q,ki,R,Ci,I,Zu="The size of the queue",bi,D,td='<strong>Kind</strong>: instance property of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a>',Hi,Pi,wi,S,Mi,z,Ai,K,ed="Check if the queue is empty.",Qi,j,id='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>boolean</code> - <code>true</code> if the queue is empty, <code>false</code> otherwise.',Ni,gi,Ei,U,qi,B,Ri,F,ld="Return the element with the highest priority in the queue.",Ii,O,rd='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>any</code> - The highest priority element in the queue.',Di,Si,zi,G,Ki,V,ji,W,ud="Add one or more elements to the queue.",Ui,J,dd='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>number</code> - The new size of the queue.',Bi,X,sd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...values</td><td><code>any</code></td><td><p>The values to push into the queue.</p></td></tr></tbody>",Fi,Oi,Gi,Y,Vi,Z,Wi,tt,od="Add multiple elements to the queue.",Ji,et,ad='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>number</code> - The new size of the queue.',Xi,it,nd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>values</td><td><code>Array.&lt;any&gt;</code></td><td><p>The values to push into the queue.</p></td></tr></tbody>",Yi,Zi,tl,lt,el,rt,il,ut,cd="Remove and return the element with the highest priority in the queue.",ll,dt,pd='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>any</code> - The element with the highest priority in the queue.',rl,ul,dl,st,sl,ot,ol,at,fd="Replace the element with the highest priority in the queue with a new value.",al,nt,md='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>*</code> - The replaced value.',nl,ct,hd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>value</td><td><code>*</code></td><td><p>The new value.</p></td></tr></tbody>",cl,pl,fl,pt,ml,ft,hl,mt,Td="Helper function to sift up from a given node.",Tl,ht,yd='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a>',yl,Tt,$d="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>node</td><td><code>number</code></td><td><p>The index of the node to start sifting up from.</p></td></tr></tbody>",$l,_l,vl,yt,Ll,$t,xl,_t,_d="A trie structure to efficiently store and search for strings.",kl,vt,vd='<strong>Kind</strong>: static class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',Cl,Lt,Ld='<li><a href="#module_utils/data-structures.CharTrie">.CharTrie</a><ul><li><a href="#module_utils/data-structures.CharTrie+extend"><code>.extend(texts)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+push"><code>.push(text)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+commonPrefixSearch"><code>.commonPrefixSearch(text)</code></a></li></ul></li>',bl,Hl,Pl,xt,wl,kt,Ml,Ct,xd="Adds one or more <code>texts</code> to the trie.",Al,bt,kd='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.CharTrie"><code>CharTrie</code></a>',Ql,Ht,Cd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>Array.&lt;string&gt;</code></td><td><p>The strings to add to the trie.</p></td></tr></tbody>",Nl,gl,El,Pt,ql,wt,Rl,Mt,bd="Adds text to the trie.",Il,At,Hd='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.CharTrie"><code>CharTrie</code></a>',Dl,Qt,Pd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>text</td><td><code>string</code></td><td><p>The string to add to the trie.</p></td></tr></tbody>",Sl,zl,Kl,Nt,jl,gt,Ul,Et,wd="Searches the trie for all strings with a common prefix of <code>text</code>.",Bl,qt,Md='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.CharTrie"><code>CharTrie</code></a>',Fl,Rt,Ad="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>text</td><td><code>string</code></td><td><p>The common prefix to search for.</p></td></tr></tbody>",Ol,Gl,Vl,It,Wl,Dt,Jl,St,Qd="A lattice data structure to be used for tokenization.",Xl,zt,Nd='<strong>Kind</strong>: static class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',Yl,Kt,gd='<li><a href="#module_utils/data-structures.TokenLattice">.TokenLattice</a><ul><li><a href="#new_module_utils/data-structures.TokenLattice_new"><code>new TokenLattice(sentence, bosTokenId, eosTokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+insert"><code>.insert(pos, length, score, tokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+viterbi"><code>.viterbi()</code></a> ⇒ <code>Array.&lt;TokenLatticeNode&gt;</code></li> <li><a href="#module_utils/data-structures.TokenLattice+piece"><code>.piece(node)</code></a> ⇒ <code>string</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokens"><code>.tokens()</code></a> ⇒ <code>Array.&lt;string&gt;</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokenIds"><code>.tokenIds()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li></ul></li>',Zl,tr,er,jt,ir,Ut,lr,Bt,Ed="Creates a new TokenLattice instance.",rr,Ft,qd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>sentence</td><td><code>string</code></td><td><p>The input sentence to be tokenized.</p></td> </tr><tr><td>bosTokenId</td><td><code>number</code></td><td><p>The beginning-of-sequence token ID.</p></td> </tr><tr><td>eosTokenId</td><td><code>number</code></td><td><p>The end-of-sequence token ID.</p></td></tr></tbody>",ur,dr,sr,Ot,or,Gt,ar,Vt,Rd="Inserts a new token node into the token lattice.",nr,Wt,Id='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a>',cr,Jt,Dd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pos</td><td><code>number</code></td><td><p>The starting position of the token.</p></td> </tr><tr><td>length</td><td><code>number</code></td><td><p>The length of the token.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td><p>The score of the token.</p></td> </tr><tr><td>tokenId</td><td><code>number</code></td><td><p>The token ID of the token.</p></td></tr></tbody>",pr,fr,mr,Xt,hr,Yt,Tr,Zt,Sd="Implements the Viterbi algorithm to compute the most likely sequence of tokens.",yr,te,zd='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;TokenLatticeNode&gt;</code> - The most likely sequence of tokens.',$r,_r,vr,ee,Lr,ie,xr,le,Kd='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>string</code> - The array of nodes representing the most likely sequence of tokens.',kr,re,jd="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>node</td><td><code>TokenLatticeNode</code></td></tr></tbody>",Cr,br,Hr,ue,Pr,de,wr,se,Ud='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;string&gt;</code> - The most likely sequence of tokens.',Mr,Ar,Qr,oe,Nr,ae,gr,ne,Bd='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The most likely sequence of token ids.',Er,qr,Rr,ce,Ir,pe,Dr,fe,Fd=`A data structure which uses a trie to split a string into tokens based on a dictionary.
It can also use a regular expression to preprocess the input text before splitting.`,Sr,me,Od="NOTE: To ensure multi-byte characters are handled correctly, we operate at byte-level instead of character-level.",zr,he,Gd='<strong>Kind</strong>: static class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',Kr,Te,Vd='<li><a href="#module_utils/data-structures.DictionarySplitter">.DictionarySplitter</a><ul><li><a href="#new_module_utils/data-structures.DictionarySplitter_new"><code>new DictionarySplitter(dictionary)</code></a></li> <li><a href="#module_utils/data-structures.DictionarySplitter+split"><code>.split(text)</code></a> ⇒ <code>Array.&lt;string&gt;</code></li></ul></li>',jr,Ur,Br,ye,Fr,$e,Or,_e,Wd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>dictionary</td><td><code>Array.&lt;string&gt;</code></td><td><p>The dictionary of words to use for splitting.</p></td></tr></tbody>",Gr,Vr,Wr,ve,Jr,Le,Xr,xe,Jd="Splits the input text into tokens based on the dictionary.",Yr,ke,Xd='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.DictionarySplitter"><code>DictionarySplitter</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;string&gt;</code> - An array of tokens.',Zr,Ce,Yd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>text</td><td><code>string</code></td><td><p>The input text to split.</p></td></tr></tbody>",tu,eu,iu,be,lu,He,ru,Pe,Zd="Represents a node in a character trie.",uu,we,ts='<strong>Kind</strong>: inner class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',du,Me,es='<li><a href="#module_utils/data-structures..CharTrieNode">~CharTrieNode</a><ul><li><a href="#new_module_utils/data-structures..CharTrieNode_new"><code>new CharTrieNode(isLeaf, children)</code></a></li> <li><a href="#module_utils/data-structures..CharTrieNode.default"><code>.default()</code></a> ⇒ <code>CharTrieNode</code></li></ul></li>',su,ou,au,Ae,nu,Qe,cu,Ne,is="Create a new CharTrieNode.",pu,ge,ls="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>isLeaf</td><td><code>boolean</code></td><td><p>Whether the node is a leaf node or not.</p></td> </tr><tr><td>children</td><td><code>Map.&lt;string, CharTrieNode&gt;</code></td><td><p>A map containing the node&#39;s children, where the key is a character and the value is a <code>CharTrieNode</code>.</p></td></tr></tbody>",fu,mu,hu,Ee,Tu,qe,yu,Re,rs="Returns a new <code>CharTrieNode</code> instance with default values.",$u,Ie,us='<strong>Kind</strong>: static method of <a href="#module_utils/data-structures..CharTrieNode"><code>CharTrieNode</code></a><br/> <strong>Returns</strong>: <code>CharTrieNode</code> - A new <code>CharTrieNode</code> instance with <code>isLeaf</code> set to <code>false</code> and an empty <code>children</code> map.',_u,vu,Lu,De,xu,Se,ku,ze,ds='<strong>Kind</strong>: inner class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',Cu,Ke,ss='<li><a href="#module_utils/data-structures..TokenLatticeNode">~TokenLatticeNode</a><ul><li><a href="#new_module_utils/data-structures..TokenLatticeNode_new"><code>new TokenLatticeNode(tokenId, nodeId, pos, length, score)</code></a></li> <li><a href="#module_utils/data-structures..TokenLatticeNode+clone"><code>.clone()</code></a> ⇒ <code>TokenLatticeNode</code></li></ul></li>',bu,Hu,Pu,je,wu,Ue,Mu,Be,os="Represents a node in a token lattice for a given sentence.",Au,Fe,as="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tokenId</td><td><code>number</code></td><td><p>The ID of the token associated with this node.</p></td> </tr><tr><td>nodeId</td><td><code>number</code></td><td><p>The ID of this node.</p></td> </tr><tr><td>pos</td><td><code>number</code></td><td><p>The starting position of the token in the sentence.</p></td> </tr><tr><td>length</td><td><code>number</code></td><td><p>The length of the token.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td><p>The score associated with the token.</p></td></tr></tbody>",Qu,Nu,gu,Oe,Eu,Ge,qu,Ve,ns="Returns a clone of this node.",Ru,We,cs='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures..TokenLatticeNode"><code>TokenLatticeNode</code></a><br/> <strong>Returns</strong>: <code>TokenLatticeNode</code> - A clone of this node.',Iu,Du,Su,Je,zu,Ye,Ku;return v=new y({props:{title:"utils/data-structures",local:"utilsdata-structures",headingTag:"h1"}}),b=new y({props:{title:"utils/data-structures.PriorityQueue",local:"utilsdata-structurespriorityqueue",headingTag:"h2"}}),N=new y({props:{title:"new PriorityQueue(comparator)",local:"new-priorityqueuecomparator",headingTag:"h3"}}),R=new y({props:{title:"priorityQueue.size",local:"priorityqueuesize",headingTag:"h3"}}),z=new y({props:{title:"priorityQueue.isEmpty() ⇒ <code> boolean </code>",local:"priorityqueueisempty--code-boolean-code",headingTag:"h3"}}),B=new y({props:{title:"priorityQueue.peek() ⇒ <code> any </code>",local:"priorityqueuepeek--code-any-code",headingTag:"h3"}}),V=new y({props:{title:"priorityQueue.push(...values) ⇒ <code> number </code>",local:"priorityqueuepushvalues--code-number-code",headingTag:"h3"}}),Z=new y({props:{title:"priorityQueue.extend(values) ⇒ <code> number </code>",local:"priorityqueueextendvalues--code-number-code",headingTag:"h3"}}),rt=new y({props:{title:"priorityQueue.pop() ⇒ <code> any </code>",local:"priorityqueuepop--code-any-code",headingTag:"h3"}}),ot=new y({props:{title:"priorityQueue.replace(value) ⇒ <code> * </code>",local:"priorityqueuereplacevalue--code--code",headingTag:"h3"}}),ft=new y({props:{title:"priorityQueue._siftUpFrom(node)",local:"priorityqueuesiftupfromnode",headingTag:"h3"}}),$t=new y({props:{title:"utils/data-structures.CharTrie",local:"utilsdata-structureschartrie",headingTag:"h2"}}),kt=new y({props:{title:"charTrie.extend(texts)",local:"chartrieextendtexts",headingTag:"h3"}}),wt=new y({props:{title:"charTrie.push(text)",local:"chartriepushtext",headingTag:"h3"}}),gt=new y({props:{title:"charTrie.commonPrefixSearch(text)",local:"chartriecommonprefixsearchtext",headingTag:"h3"}}),Dt=new y({props:{title:"utils/data-structures.TokenLattice",local:"utilsdata-structurestokenlattice",headingTag:"h2"}}),Ut=new y({props:{title:"new TokenLattice(sentence, bosTokenId, eosTokenId)",local:"new-tokenlatticesentence-bostokenid-eostokenid",headingTag:"h3"}}),Gt=new y({props:{title:"tokenLattice.insert(pos, length, score, tokenId)",local:"tokenlatticeinsertpos-length-score-tokenid",headingTag:"h3"}}),Yt=new y({props:{title:"tokenLattice.viterbi() ⇒ <code> Array. < TokenLatticeNode > </code>",local:"tokenlatticeviterbi--code-array--tokenlatticenode--code",headingTag:"h3"}}),ie=new y({props:{title:"tokenLattice.piece(node) ⇒ <code> string </code>",local:"tokenlatticepiecenode--code-string-code",headingTag:"h3"}}),de=new y({props:{title:"tokenLattice.tokens() ⇒ <code> Array. < string > </code>",local:"tokenlatticetokens--code-array--string--code",headingTag:"h3"}}),ae=new y({props:{title:"tokenLattice.tokenIds() ⇒ <code> Array. < number > </code>",local:"tokenlatticetokenids--code-array--number--code",headingTag:"h3"}}),pe=new y({props:{title:"utils/data-structures.DictionarySplitter",local:"utilsdata-structuresdictionarysplitter",headingTag:"h2"}}),$e=new y({props:{title:"new DictionarySplitter(dictionary)",local:"new-dictionarysplitterdictionary",headingTag:"h3"}}),Le=new y({props:{title:"dictionarySplitter.split(text) ⇒ <code> Array. < string > </code>",local:"dictionarysplittersplittext--code-array--string--code",headingTag:"h3"}}),He=new y({props:{title:"utils/data-structures~CharTrieNode",local:"utilsdata-structureschartrienode",headingTag:"h2"}}),Qe=new y({props:{title:"new CharTrieNode(isLeaf, children)",local:"new-chartrienodeisleaf-children",headingTag:"h3"}}),qe=new y({props:{title:"CharTrieNode.default() ⇒ <code> CharTrieNode </code>",local:"chartrienodedefault--code-chartrienode-code",headingTag:"h3"}}),Se=new y({props:{title:"utils/data-structures~TokenLatticeNode",local:"utilsdata-structurestokenlatticenode",headingTag:"h2"}}),Ue=new y({props:{title:"new TokenLatticeNode(tokenId, nodeId, pos, length, score)",local:"new-tokenlatticenodetokenid-nodeid-pos-length-score",headingTag:"h3"}}),Ge=new y({props:{title:"tokenLatticeNode.clone() ⇒ <code> TokenLatticeNode </code>",local:"tokenlatticenodeclone--code-tokenlatticenode-code",headingTag:"h3"}}),Je=new _s({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/utils/data-structures.md"}}),{c(){$=d("meta"),Ze=r(),Xe=d("p"),ti=r(),_=d("a"),ei=r(),c(v.$$.fragment),ii=r(),L=d("p"),L.textContent=Uu,li=r(),x=d("p"),x.textContent=Bu,ri=r(),k=d("ul"),k.innerHTML=Fu,ui=r(),di=d("hr"),si=r(),C=d("a"),oi=r(),c(b.$$.fragment),ai=r(),H=d("p"),H.innerHTML=Ou,ni=r(),P=d("p"),P.textContent=Gu,ci=r(),w=d("ul"),w.innerHTML=Vu,pi=r(),M=d("p"),M.innerHTML=Wu,fi=r(),A=d("ul"),A.innerHTML=Ju,mi=r(),hi=d("hr"),Ti=r(),Q=d("a"),yi=r(),c(N.$$.fragment),$i=r(),g=d("p"),g.textContent=Xu,_i=r(),E=d("table"),E.innerHTML=Yu,vi=r(),Li=d("hr"),xi=r(),q=d("a"),ki=r(),c(R.$$.fragment),Ci=r(),I=d("p"),I.textContent=Zu,bi=r(),D=d("p"),D.innerHTML=td,Hi=r(),Pi=d("hr"),wi=r(),S=d("a"),Mi=r(),c(z.$$.fragment),Ai=r(),K=d("p"),K.textContent=ed,Qi=r(),j=d("p"),j.innerHTML=id,Ni=r(),gi=d("hr"),Ei=r(),U=d("a"),qi=r(),c(B.$$.fragment),Ri=r(),F=d("p"),F.textContent=ld,Ii=r(),O=d("p"),O.innerHTML=rd,Di=r(),Si=d("hr"),zi=r(),G=d("a"),Ki=r(),c(V.$$.fragment),ji=r(),W=d("p"),W.textContent=ud,Ui=r(),J=d("p"),J.innerHTML=dd,Bi=r(),X=d("table"),X.innerHTML=sd,Fi=r(),Oi=d("hr"),Gi=r(),Y=d("a"),Vi=r(),c(Z.$$.fragment),Wi=r(),tt=d("p"),tt.textContent=od,Ji=r(),et=d("p"),et.innerHTML=ad,Xi=r(),it=d("table"),it.innerHTML=nd,Yi=r(),Zi=d("hr"),tl=r(),lt=d("a"),el=r(),c(rt.$$.fragment),il=r(),ut=d("p"),ut.textContent=cd,ll=r(),dt=d("p"),dt.innerHTML=pd,rl=r(),ul=d("hr"),dl=r(),st=d("a"),sl=r(),c(ot.$$.fragment),ol=r(),at=d("p"),at.textContent=fd,al=r(),nt=d("p"),nt.innerHTML=md,nl=r(),ct=d("table"),ct.innerHTML=hd,cl=r(),pl=d("hr"),fl=r(),pt=d("a"),ml=r(),c(ft.$$.fragment),hl=r(),mt=d("p"),mt.textContent=Td,Tl=r(),ht=d("p"),ht.innerHTML=yd,yl=r(),Tt=d("table"),Tt.innerHTML=$d,$l=r(),_l=d("hr"),vl=r(),yt=d("a"),Ll=r(),c($t.$$.fragment),xl=r(),_t=d("p"),_t.textContent=_d,kl=r(),vt=d("p"),vt.innerHTML=vd,Cl=r(),Lt=d("ul"),Lt.innerHTML=Ld,bl=r(),Hl=d("hr"),Pl=r(),xt=d("a"),wl=r(),c(kt.$$.fragment),Ml=r(),Ct=d("p"),Ct.innerHTML=xd,Al=r(),bt=d("p"),bt.innerHTML=kd,Ql=r(),Ht=d("table"),Ht.innerHTML=Cd,Nl=r(),gl=d("hr"),El=r(),Pt=d("a"),ql=r(),c(wt.$$.fragment),Rl=r(),Mt=d("p"),Mt.textContent=bd,Il=r(),At=d("p"),At.innerHTML=Hd,Dl=r(),Qt=d("table"),Qt.innerHTML=Pd,Sl=r(),zl=d("hr"),Kl=r(),Nt=d("a"),jl=r(),c(gt.$$.fragment),Ul=r(),Et=d("p"),Et.innerHTML=wd,Bl=r(),qt=d("p"),qt.innerHTML=Md,Fl=r(),Rt=d("table"),Rt.innerHTML=Ad,Ol=r(),Gl=d("hr"),Vl=r(),It=d("a"),Wl=r(),c(Dt.$$.fragment),Jl=r(),St=d("p"),St.textContent=Qd,Xl=r(),zt=d("p"),zt.innerHTML=Nd,Yl=r(),Kt=d("ul"),Kt.innerHTML=gd,Zl=r(),tr=d("hr"),er=r(),jt=d("a"),ir=r(),c(Ut.$$.fragment),lr=r(),Bt=d("p"),Bt.textContent=Ed,rr=r(),Ft=d("table"),Ft.innerHTML=qd,ur=r(),dr=d("hr"),sr=r(),Ot=d("a"),or=r(),c(Gt.$$.fragment),ar=r(),Vt=d("p"),Vt.textContent=Rd,nr=r(),Wt=d("p"),Wt.innerHTML=Id,cr=r(),Jt=d("table"),Jt.innerHTML=Dd,pr=r(),fr=d("hr"),mr=r(),Xt=d("a"),hr=r(),c(Yt.$$.fragment),Tr=r(),Zt=d("p"),Zt.textContent=Sd,yr=r(),te=d("p"),te.innerHTML=zd,$r=r(),_r=d("hr"),vr=r(),ee=d("a"),Lr=r(),c(ie.$$.fragment),xr=r(),le=d("p"),le.innerHTML=Kd,kr=r(),re=d("table"),re.innerHTML=jd,Cr=r(),br=d("hr"),Hr=r(),ue=d("a"),Pr=r(),c(de.$$.fragment),wr=r(),se=d("p"),se.innerHTML=Ud,Mr=r(),Ar=d("hr"),Qr=r(),oe=d("a"),Nr=r(),c(ae.$$.fragment),gr=r(),ne=d("p"),ne.innerHTML=Bd,Er=r(),qr=d("hr"),Rr=r(),ce=d("a"),Ir=r(),c(pe.$$.fragment),Dr=r(),fe=d("p"),fe.textContent=Fd,Sr=r(),me=d("p"),me.textContent=Od,zr=r(),he=d("p"),he.innerHTML=Gd,Kr=r(),Te=d("ul"),Te.innerHTML=Vd,jr=r(),Ur=d("hr"),Br=r(),ye=d("a"),Fr=r(),c($e.$$.fragment),Or=r(),_e=d("table"),_e.innerHTML=Wd,Gr=r(),Vr=d("hr"),Wr=r(),ve=d("a"),Jr=r(),c(Le.$$.fragment),Xr=r(),xe=d("p"),xe.textContent=Jd,Yr=r(),ke=d("p"),ke.innerHTML=Xd,Zr=r(),Ce=d("table"),Ce.innerHTML=Yd,tu=r(),eu=d("hr"),iu=r(),be=d("a"),lu=r(),c(He.$$.fragment),ru=r(),Pe=d("p"),Pe.textContent=Zd,uu=r(),we=d("p"),we.innerHTML=ts,du=r(),Me=d("ul"),Me.innerHTML=es,su=r(),ou=d("hr"),au=r(),Ae=d("a"),nu=r(),c(Qe.$$.fragment),cu=r(),Ne=d("p"),Ne.textContent=is,pu=r(),ge=d("table"),ge.innerHTML=ls,fu=r(),mu=d("hr"),hu=r(),Ee=d("a"),Tu=r(),c(qe.$$.fragment),yu=r(),Re=d("p"),Re.innerHTML=rs,$u=r(),Ie=d("p"),Ie.innerHTML=us,_u=r(),vu=d("hr"),Lu=r(),De=d("a"),xu=r(),c(Se.$$.fragment),ku=r(),ze=d("p"),ze.innerHTML=ds,Cu=r(),Ke=d("ul"),Ke.innerHTML=ss,bu=r(),Hu=d("hr"),Pu=r(),je=d("a"),wu=r(),c(Ue.$$.fragment),Mu=r(),Be=d("p"),Be.textContent=os,Au=r(),Fe=d("table"),Fe.innerHTML=as,Qu=r(),Nu=d("hr"),gu=r(),Oe=d("a"),Eu=r(),c(Ge.$$.fragment),qu=r(),Ve=d("p"),Ve.textContent=ns,Ru=r(),We=d("p"),We.innerHTML=cs,Iu=r(),Du=d("hr"),Su=r(),c(Je.$$.fragment),zu=r(),Ye=d("p"),this.h()},l(t){const e=ys("svelte-u9bgzb",document.head);$=s(e,"META",{name:!0,content:!0}),e.forEach(i),Ze=u(t),Xe=s(t,"P",{}),n(Xe).forEach(i),ti=u(t),_=s(t,"A",{id:!0,class:!0}),n(_).forEach(i),ei=u(t),p(v.$$.fragment,t),ii=u(t),L=s(t,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1aeeeid"&&(L.textContent=Uu),li=u(t),x=s(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1r3ntfo"&&(x.textContent=Bu),ri=u(t),k=s(t,"UL",{"data-svelte-h":!0}),o(k)!=="svelte-1ak9f40"&&(k.innerHTML=Fu),ui=u(t),di=s(t,"HR",{}),si=u(t),C=s(t,"A",{id:!0,class:!0}),n(C).forEach(i),oi=u(t),p(b.$$.fragment,t),ai=u(t),H=s(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1ux83uj"&&(H.innerHTML=Ou),ni=u(t),P=s(t,"P",{"data-svelte-h":!0}),o(P)!=="svelte-vi2pz9"&&(P.textContent=Gu),ci=u(t),w=s(t,"UL",{"data-svelte-h":!0}),o(w)!=="svelte-qlvgg9"&&(w.innerHTML=Vu),pi=u(t),M=s(t,"P",{"data-svelte-h":!0}),o(M)!=="svelte-1saulos"&&(M.innerHTML=Wu),fi=u(t),A=s(t,"UL",{"data-svelte-h":!0}),o(A)!=="svelte-fzyqbp"&&(A.innerHTML=Ju),mi=u(t),hi=s(t,"HR",{}),Ti=u(t),Q=s(t,"A",{id:!0,class:!0}),n(Q).forEach(i),yi=u(t),p(N.$$.fragment,t),$i=u(t),g=s(t,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1dgukb8"&&(g.textContent=Xu),_i=u(t),E=s(t,"TABLE",{"data-svelte-h":!0}),o(E)!=="svelte-15lsmj7"&&(E.innerHTML=Yu),vi=u(t),Li=s(t,"HR",{}),xi=u(t),q=s(t,"A",{id:!0,class:!0}),n(q).forEach(i),ki=u(t),p(R.$$.fragment,t),Ci=u(t),I=s(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-19ll7y9"&&(I.textContent=Zu),bi=u(t),D=s(t,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1spompf"&&(D.innerHTML=td),Hi=u(t),Pi=s(t,"HR",{}),wi=u(t),S=s(t,"A",{id:!0,class:!0}),n(S).forEach(i),Mi=u(t),p(z.$$.fragment,t),Ai=u(t),K=s(t,"P",{"data-svelte-h":!0}),o(K)!=="svelte-iwo0ja"&&(K.textContent=ed),Qi=u(t),j=s(t,"P",{"data-svelte-h":!0}),o(j)!=="svelte-usw3zo"&&(j.innerHTML=id),Ni=u(t),gi=s(t,"HR",{}),Ei=u(t),U=s(t,"A",{id:!0,class:!0}),n(U).forEach(i),qi=u(t),p(B.$$.fragment,t),Ri=u(t),F=s(t,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1g38rzl"&&(F.textContent=ld),Ii=u(t),O=s(t,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1jn2os3"&&(O.innerHTML=rd),Di=u(t),Si=s(t,"HR",{}),zi=u(t),G=s(t,"A",{id:!0,class:!0}),n(G).forEach(i),Ki=u(t),p(V.$$.fragment,t),ji=u(t),W=s(t,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1o3p42d"&&(W.textContent=ud),Ui=u(t),J=s(t,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1hty3q7"&&(J.innerHTML=dd),Bi=u(t),X=s(t,"TABLE",{"data-svelte-h":!0}),o(X)!=="svelte-19plha1"&&(X.innerHTML=sd),Fi=u(t),Oi=s(t,"HR",{}),Gi=u(t),Y=s(t,"A",{id:!0,class:!0}),n(Y).forEach(i),Vi=u(t),p(Z.$$.fragment,t),Wi=u(t),tt=s(t,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-1rf8gmz"&&(tt.textContent=od),Ji=u(t),et=s(t,"P",{"data-svelte-h":!0}),o(et)!=="svelte-1hty3q7"&&(et.innerHTML=ad),Xi=u(t),it=s(t,"TABLE",{"data-svelte-h":!0}),o(it)!=="svelte-txh99d"&&(it.innerHTML=nd),Yi=u(t),Zi=s(t,"HR",{}),tl=u(t),lt=s(t,"A",{id:!0,class:!0}),n(lt).forEach(i),el=u(t),p(rt.$$.fragment,t),il=u(t),ut=s(t,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1l3oksc"&&(ut.textContent=cd),ll=u(t),dt=s(t,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-vpswb8"&&(dt.innerHTML=pd),rl=u(t),ul=s(t,"HR",{}),dl=u(t),st=s(t,"A",{id:!0,class:!0}),n(st).forEach(i),sl=u(t),p(ot.$$.fragment,t),ol=u(t),at=s(t,"P",{"data-svelte-h":!0}),o(at)!=="svelte-7s4t0d"&&(at.textContent=fd),al=u(t),nt=s(t,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-ckytvb"&&(nt.innerHTML=md),nl=u(t),ct=s(t,"TABLE",{"data-svelte-h":!0}),o(ct)!=="svelte-1xv2m9q"&&(ct.innerHTML=hd),cl=u(t),pl=s(t,"HR",{}),fl=u(t),pt=s(t,"A",{id:!0,class:!0}),n(pt).forEach(i),ml=u(t),p(ft.$$.fragment,t),hl=u(t),mt=s(t,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-hj5sse"&&(mt.textContent=Td),Tl=u(t),ht=s(t,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-6p6lmz"&&(ht.innerHTML=yd),yl=u(t),Tt=s(t,"TABLE",{"data-svelte-h":!0}),o(Tt)!=="svelte-fj2fu5"&&(Tt.innerHTML=$d),$l=u(t),_l=s(t,"HR",{}),vl=u(t),yt=s(t,"A",{id:!0,class:!0}),n(yt).forEach(i),Ll=u(t),p($t.$$.fragment,t),xl=u(t),_t=s(t,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-nklgrc"&&(_t.textContent=_d),kl=u(t),vt=s(t,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-1saulos"&&(vt.innerHTML=vd),Cl=u(t),Lt=s(t,"UL",{"data-svelte-h":!0}),o(Lt)!=="svelte-1yt2jf0"&&(Lt.innerHTML=Ld),bl=u(t),Hl=s(t,"HR",{}),Pl=u(t),xt=s(t,"A",{id:!0,class:!0}),n(xt).forEach(i),wl=u(t),p(kt.$$.fragment,t),Ml=u(t),Ct=s(t,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-moeq8l"&&(Ct.innerHTML=xd),Al=u(t),bt=s(t,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-33rax3"&&(bt.innerHTML=kd),Ql=u(t),Ht=s(t,"TABLE",{"data-svelte-h":!0}),o(Ht)!=="svelte-18dtsnv"&&(Ht.innerHTML=Cd),Nl=u(t),gl=s(t,"HR",{}),El=u(t),Pt=s(t,"A",{id:!0,class:!0}),n(Pt).forEach(i),ql=u(t),p(wt.$$.fragment,t),Rl=u(t),Mt=s(t,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-4q846v"&&(Mt.textContent=bd),Il=u(t),At=s(t,"P",{"data-svelte-h":!0}),o(At)!=="svelte-33rax3"&&(At.innerHTML=Hd),Dl=u(t),Qt=s(t,"TABLE",{"data-svelte-h":!0}),o(Qt)!=="svelte-hqwgb9"&&(Qt.innerHTML=Pd),Sl=u(t),zl=s(t,"HR",{}),Kl=u(t),Nt=s(t,"A",{id:!0,class:!0}),n(Nt).forEach(i),jl=u(t),p(gt.$$.fragment,t),Ul=u(t),Et=s(t,"P",{"data-svelte-h":!0}),o(Et)!=="svelte-bmaw98"&&(Et.innerHTML=wd),Bl=u(t),qt=s(t,"P",{"data-svelte-h":!0}),o(qt)!=="svelte-33rax3"&&(qt.innerHTML=Md),Fl=u(t),Rt=s(t,"TABLE",{"data-svelte-h":!0}),o(Rt)!=="svelte-18qxh0x"&&(Rt.innerHTML=Ad),Ol=u(t),Gl=s(t,"HR",{}),Vl=u(t),It=s(t,"A",{id:!0,class:!0}),n(It).forEach(i),Wl=u(t),p(Dt.$$.fragment,t),Jl=u(t),St=s(t,"P",{"data-svelte-h":!0}),o(St)!=="svelte-1xkinx1"&&(St.textContent=Qd),Xl=u(t),zt=s(t,"P",{"data-svelte-h":!0}),o(zt)!=="svelte-1saulos"&&(zt.innerHTML=Nd),Yl=u(t),Kt=s(t,"UL",{"data-svelte-h":!0}),o(Kt)!=="svelte-12y4jvx"&&(Kt.innerHTML=gd),Zl=u(t),tr=s(t,"HR",{}),er=u(t),jt=s(t,"A",{id:!0,class:!0}),n(jt).forEach(i),ir=u(t),p(Ut.$$.fragment,t),lr=u(t),Bt=s(t,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-ziiz62"&&(Bt.textContent=Ed),rr=u(t),Ft=s(t,"TABLE",{"data-svelte-h":!0}),o(Ft)!=="svelte-1h8dv5n"&&(Ft.innerHTML=qd),ur=u(t),dr=s(t,"HR",{}),sr=u(t),Ot=s(t,"A",{id:!0,class:!0}),n(Ot).forEach(i),or=u(t),p(Gt.$$.fragment,t),ar=u(t),Vt=s(t,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-1hzq3te"&&(Vt.textContent=Rd),nr=u(t),Wt=s(t,"P",{"data-svelte-h":!0}),o(Wt)!=="svelte-1bjyh7n"&&(Wt.innerHTML=Id),cr=u(t),Jt=s(t,"TABLE",{"data-svelte-h":!0}),o(Jt)!=="svelte-1a01i2a"&&(Jt.innerHTML=Dd),pr=u(t),fr=s(t,"HR",{}),mr=u(t),Xt=s(t,"A",{id:!0,class:!0}),n(Xt).forEach(i),hr=u(t),p(Yt.$$.fragment,t),Tr=u(t),Zt=s(t,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-jv0r"&&(Zt.textContent=Sd),yr=u(t),te=s(t,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1hp113b"&&(te.innerHTML=zd),$r=u(t),_r=s(t,"HR",{}),vr=u(t),ee=s(t,"A",{id:!0,class:!0}),n(ee).forEach(i),Lr=u(t),p(ie.$$.fragment,t),xr=u(t),le=s(t,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1n9zjoi"&&(le.innerHTML=Kd),kr=u(t),re=s(t,"TABLE",{"data-svelte-h":!0}),o(re)!=="svelte-6nufyb"&&(re.innerHTML=jd),Cr=u(t),br=s(t,"HR",{}),Hr=u(t),ue=s(t,"A",{id:!0,class:!0}),n(ue).forEach(i),Pr=u(t),p(de.$$.fragment,t),wr=u(t),se=s(t,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1ipxykz"&&(se.innerHTML=Ud),Mr=u(t),Ar=s(t,"HR",{}),Qr=u(t),oe=s(t,"A",{id:!0,class:!0}),n(oe).forEach(i),Nr=u(t),p(ae.$$.fragment,t),gr=u(t),ne=s(t,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1nolezc"&&(ne.innerHTML=Bd),Er=u(t),qr=s(t,"HR",{}),Rr=u(t),ce=s(t,"A",{id:!0,class:!0}),n(ce).forEach(i),Ir=u(t),p(pe.$$.fragment,t),Dr=u(t),fe=s(t,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-1d71m1c"&&(fe.textContent=Fd),Sr=u(t),me=s(t,"P",{"data-svelte-h":!0}),o(me)!=="svelte-13fkdt9"&&(me.textContent=Od),zr=u(t),he=s(t,"P",{"data-svelte-h":!0}),o(he)!=="svelte-1saulos"&&(he.innerHTML=Gd),Kr=u(t),Te=s(t,"UL",{"data-svelte-h":!0}),o(Te)!=="svelte-728se6"&&(Te.innerHTML=Vd),jr=u(t),Ur=s(t,"HR",{}),Br=u(t),ye=s(t,"A",{id:!0,class:!0}),n(ye).forEach(i),Fr=u(t),p($e.$$.fragment,t),Or=u(t),_e=s(t,"TABLE",{"data-svelte-h":!0}),o(_e)!=="svelte-d113ps"&&(_e.innerHTML=Wd),Gr=u(t),Vr=s(t,"HR",{}),Wr=u(t),ve=s(t,"A",{id:!0,class:!0}),n(ve).forEach(i),Jr=u(t),p(Le.$$.fragment,t),Xr=u(t),xe=s(t,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-ussbd6"&&(xe.textContent=Jd),Yr=u(t),ke=s(t,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-kdhwpe"&&(ke.innerHTML=Xd),Zr=u(t),Ce=s(t,"TABLE",{"data-svelte-h":!0}),o(Ce)!=="svelte-raiep6"&&(Ce.innerHTML=Yd),tu=u(t),eu=s(t,"HR",{}),iu=u(t),be=s(t,"A",{id:!0,class:!0}),n(be).forEach(i),lu=u(t),p(He.$$.fragment,t),ru=u(t),Pe=s(t,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-1auz3rh"&&(Pe.textContent=Zd),uu=u(t),we=s(t,"P",{"data-svelte-h":!0}),o(we)!=="svelte-1p9ver0"&&(we.innerHTML=ts),du=u(t),Me=s(t,"UL",{"data-svelte-h":!0}),o(Me)!=="svelte-4v7sww"&&(Me.innerHTML=es),su=u(t),ou=s(t,"HR",{}),au=u(t),Ae=s(t,"A",{id:!0,class:!0}),n(Ae).forEach(i),nu=u(t),p(Qe.$$.fragment,t),cu=u(t),Ne=s(t,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-mt1jex"&&(Ne.textContent=is),pu=u(t),ge=s(t,"TABLE",{"data-svelte-h":!0}),o(ge)!=="svelte-nk427c"&&(ge.innerHTML=ls),fu=u(t),mu=s(t,"HR",{}),hu=u(t),Ee=s(t,"A",{id:!0,class:!0}),n(Ee).forEach(i),Tu=u(t),p(qe.$$.fragment,t),yu=u(t),Re=s(t,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-9cjdkj"&&(Re.innerHTML=rs),$u=u(t),Ie=s(t,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-3pigfy"&&(Ie.innerHTML=us),_u=u(t),vu=s(t,"HR",{}),Lu=u(t),De=s(t,"A",{id:!0,class:!0}),n(De).forEach(i),xu=u(t),p(Se.$$.fragment,t),ku=u(t),ze=s(t,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-1p9ver0"&&(ze.innerHTML=ds),Cu=u(t),Ke=s(t,"UL",{"data-svelte-h":!0}),o(Ke)!=="svelte-r6qh2h"&&(Ke.innerHTML=ss),bu=u(t),Hu=s(t,"HR",{}),Pu=u(t),je=s(t,"A",{id:!0,class:!0}),n(je).forEach(i),wu=u(t),p(Ue.$$.fragment,t),Mu=u(t),Be=s(t,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-vrhdhn"&&(Be.textContent=os),Au=u(t),Fe=s(t,"TABLE",{"data-svelte-h":!0}),o(Fe)!=="svelte-5ahzuq"&&(Fe.innerHTML=as),Qu=u(t),Nu=s(t,"HR",{}),gu=u(t),Oe=s(t,"A",{id:!0,class:!0}),n(Oe).forEach(i),Eu=u(t),p(Ge.$$.fragment,t),qu=u(t),Ve=s(t,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-34g670"&&(Ve.textContent=ns),Ru=u(t),We=s(t,"P",{"data-svelte-h":!0}),o(We)!=="svelte-7303j9"&&(We.innerHTML=cs),Iu=u(t),Du=s(t,"HR",{}),Su=u(t),p(Je.$$.fragment,t),zu=u(t),Ye=s(t,"P",{}),n(Ye).forEach(i),this.h()},h(){a($,"name","hf:doc:metadata"),a($,"content",Ls),a(_,"id","module_utils/data-structures"),a(_,"class","group"),a(C,"id","module_utils/data-structures.PriorityQueue"),a(C,"class","group"),a(Q,"id","new_module_utils/data-structures.PriorityQueue_new"),a(Q,"class","group"),a(q,"id","module_utils/data-structures.PriorityQueue+size"),a(q,"class","group"),a(S,"id","module_utils/data-structures.PriorityQueue+isEmpty"),a(S,"class","group"),a(U,"id","module_utils/data-structures.PriorityQueue+peek"),a(U,"class","group"),a(G,"id","module_utils/data-structures.PriorityQueue+push"),a(G,"class","group"),a(Y,"id","module_utils/data-structures.PriorityQueue+extend"),a(Y,"class","group"),a(lt,"id","module_utils/data-structures.PriorityQueue+pop"),a(lt,"class","group"),a(st,"id","module_utils/data-structures.PriorityQueue+replace"),a(st,"class","group"),a(pt,"id","module_utils/data-structures.PriorityQueue+_siftUpFrom"),a(pt,"class","group"),a(yt,"id","module_utils/data-structures.CharTrie"),a(yt,"class","group"),a(xt,"id","module_utils/data-structures.CharTrie+extend"),a(xt,"class","group"),a(Pt,"id","module_utils/data-structures.CharTrie+push"),a(Pt,"class","group"),a(Nt,"id","module_utils/data-structures.CharTrie+commonPrefixSearch"),a(Nt,"class","group"),a(It,"id","module_utils/data-structures.TokenLattice"),a(It,"class","group"),a(jt,"id","new_module_utils/data-structures.TokenLattice_new"),a(jt,"class","group"),a(Ot,"id","module_utils/data-structures.TokenLattice+insert"),a(Ot,"class","group"),a(Xt,"id","module_utils/data-structures.TokenLattice+viterbi"),a(Xt,"class","group"),a(ee,"id","module_utils/data-structures.TokenLattice+piece"),a(ee,"class","group"),a(ue,"id","module_utils/data-structures.TokenLattice+tokens"),a(ue,"class","group"),a(oe,"id","module_utils/data-structures.TokenLattice+tokenIds"),a(oe,"class","group"),a(ce,"id","module_utils/data-structures.DictionarySplitter"),a(ce,"class","group"),a(ye,"id","new_module_utils/data-structures.DictionarySplitter_new"),a(ye,"class","group"),a(ve,"id","module_utils/data-structures.DictionarySplitter+split"),a(ve,"class","group"),a(be,"id","module_utils/data-structures..CharTrieNode"),a(be,"class","group"),a(Ae,"id","new_module_utils/data-structures..CharTrieNode_new"),a(Ae,"class","group"),a(Ee,"id","module_utils/data-structures..CharTrieNode.default"),a(Ee,"class","group"),a(De,"id","module_utils/data-structures..TokenLatticeNode"),a(De,"class","group"),a(je,"id","new_module_utils/data-structures..TokenLatticeNode_new"),a(je,"class","group"),a(Oe,"id","module_utils/data-structures..TokenLatticeNode+clone"),a(Oe,"class","group")},m(t,e){$s(document.head,$),l(t,Ze,e),l(t,Xe,e),l(t,ti,e),l(t,_,e),l(t,ei,e),f(v,t,e),l(t,ii,e),l(t,L,e),l(t,li,e),l(t,x,e),l(t,ri,e),l(t,k,e),l(t,ui,e),l(t,di,e),l(t,si,e),l(t,C,e),l(t,oi,e),f(b,t,e),l(t,ai,e),l(t,H,e),l(t,ni,e),l(t,P,e),l(t,ci,e),l(t,w,e),l(t,pi,e),l(t,M,e),l(t,fi,e),l(t,A,e),l(t,mi,e),l(t,hi,e),l(t,Ti,e),l(t,Q,e),l(t,yi,e),f(N,t,e),l(t,$i,e),l(t,g,e),l(t,_i,e),l(t,E,e),l(t,vi,e),l(t,Li,e),l(t,xi,e),l(t,q,e),l(t,ki,e),f(R,t,e),l(t,Ci,e),l(t,I,e),l(t,bi,e),l(t,D,e),l(t,Hi,e),l(t,Pi,e),l(t,wi,e),l(t,S,e),l(t,Mi,e),f(z,t,e),l(t,Ai,e),l(t,K,e),l(t,Qi,e),l(t,j,e),l(t,Ni,e),l(t,gi,e),l(t,Ei,e),l(t,U,e),l(t,qi,e),f(B,t,e),l(t,Ri,e),l(t,F,e),l(t,Ii,e),l(t,O,e),l(t,Di,e),l(t,Si,e),l(t,zi,e),l(t,G,e),l(t,Ki,e),f(V,t,e),l(t,ji,e),l(t,W,e),l(t,Ui,e),l(t,J,e),l(t,Bi,e),l(t,X,e),l(t,Fi,e),l(t,Oi,e),l(t,Gi,e),l(t,Y,e),l(t,Vi,e),f(Z,t,e),l(t,Wi,e),l(t,tt,e),l(t,Ji,e),l(t,et,e),l(t,Xi,e),l(t,it,e),l(t,Yi,e),l(t,Zi,e),l(t,tl,e),l(t,lt,e),l(t,el,e),f(rt,t,e),l(t,il,e),l(t,ut,e),l(t,ll,e),l(t,dt,e),l(t,rl,e),l(t,ul,e),l(t,dl,e),l(t,st,e),l(t,sl,e),f(ot,t,e),l(t,ol,e),l(t,at,e),l(t,al,e),l(t,nt,e),l(t,nl,e),l(t,ct,e),l(t,cl,e),l(t,pl,e),l(t,fl,e),l(t,pt,e),l(t,ml,e),f(ft,t,e),l(t,hl,e),l(t,mt,e),l(t,Tl,e),l(t,ht,e),l(t,yl,e),l(t,Tt,e),l(t,$l,e),l(t,_l,e),l(t,vl,e),l(t,yt,e),l(t,Ll,e),f($t,t,e),l(t,xl,e),l(t,_t,e),l(t,kl,e),l(t,vt,e),l(t,Cl,e),l(t,Lt,e),l(t,bl,e),l(t,Hl,e),l(t,Pl,e),l(t,xt,e),l(t,wl,e),f(kt,t,e),l(t,Ml,e),l(t,Ct,e),l(t,Al,e),l(t,bt,e),l(t,Ql,e),l(t,Ht,e),l(t,Nl,e),l(t,gl,e),l(t,El,e),l(t,Pt,e),l(t,ql,e),f(wt,t,e),l(t,Rl,e),l(t,Mt,e),l(t,Il,e),l(t,At,e),l(t,Dl,e),l(t,Qt,e),l(t,Sl,e),l(t,zl,e),l(t,Kl,e),l(t,Nt,e),l(t,jl,e),f(gt,t,e),l(t,Ul,e),l(t,Et,e),l(t,Bl,e),l(t,qt,e),l(t,Fl,e),l(t,Rt,e),l(t,Ol,e),l(t,Gl,e),l(t,Vl,e),l(t,It,e),l(t,Wl,e),f(Dt,t,e),l(t,Jl,e),l(t,St,e),l(t,Xl,e),l(t,zt,e),l(t,Yl,e),l(t,Kt,e),l(t,Zl,e),l(t,tr,e),l(t,er,e),l(t,jt,e),l(t,ir,e),f(Ut,t,e),l(t,lr,e),l(t,Bt,e),l(t,rr,e),l(t,Ft,e),l(t,ur,e),l(t,dr,e),l(t,sr,e),l(t,Ot,e),l(t,or,e),f(Gt,t,e),l(t,ar,e),l(t,Vt,e),l(t,nr,e),l(t,Wt,e),l(t,cr,e),l(t,Jt,e),l(t,pr,e),l(t,fr,e),l(t,mr,e),l(t,Xt,e),l(t,hr,e),f(Yt,t,e),l(t,Tr,e),l(t,Zt,e),l(t,yr,e),l(t,te,e),l(t,$r,e),l(t,_r,e),l(t,vr,e),l(t,ee,e),l(t,Lr,e),f(ie,t,e),l(t,xr,e),l(t,le,e),l(t,kr,e),l(t,re,e),l(t,Cr,e),l(t,br,e),l(t,Hr,e),l(t,ue,e),l(t,Pr,e),f(de,t,e),l(t,wr,e),l(t,se,e),l(t,Mr,e),l(t,Ar,e),l(t,Qr,e),l(t,oe,e),l(t,Nr,e),f(ae,t,e),l(t,gr,e),l(t,ne,e),l(t,Er,e),l(t,qr,e),l(t,Rr,e),l(t,ce,e),l(t,Ir,e),f(pe,t,e),l(t,Dr,e),l(t,fe,e),l(t,Sr,e),l(t,me,e),l(t,zr,e),l(t,he,e),l(t,Kr,e),l(t,Te,e),l(t,jr,e),l(t,Ur,e),l(t,Br,e),l(t,ye,e),l(t,Fr,e),f($e,t,e),l(t,Or,e),l(t,_e,e),l(t,Gr,e),l(t,Vr,e),l(t,Wr,e),l(t,ve,e),l(t,Jr,e),f(Le,t,e),l(t,Xr,e),l(t,xe,e),l(t,Yr,e),l(t,ke,e),l(t,Zr,e),l(t,Ce,e),l(t,tu,e),l(t,eu,e),l(t,iu,e),l(t,be,e),l(t,lu,e),f(He,t,e),l(t,ru,e),l(t,Pe,e),l(t,uu,e),l(t,we,e),l(t,du,e),l(t,Me,e),l(t,su,e),l(t,ou,e),l(t,au,e),l(t,Ae,e),l(t,nu,e),f(Qe,t,e),l(t,cu,e),l(t,Ne,e),l(t,pu,e),l(t,ge,e),l(t,fu,e),l(t,mu,e),l(t,hu,e),l(t,Ee,e),l(t,Tu,e),f(qe,t,e),l(t,yu,e),l(t,Re,e),l(t,$u,e),l(t,Ie,e),l(t,_u,e),l(t,vu,e),l(t,Lu,e),l(t,De,e),l(t,xu,e),f(Se,t,e),l(t,ku,e),l(t,ze,e),l(t,Cu,e),l(t,Ke,e),l(t,bu,e),l(t,Hu,e),l(t,Pu,e),l(t,je,e),l(t,wu,e),f(Ue,t,e),l(t,Mu,e),l(t,Be,e),l(t,Au,e),l(t,Fe,e),l(t,Qu,e),l(t,Nu,e),l(t,gu,e),l(t,Oe,e),l(t,Eu,e),f(Ge,t,e),l(t,qu,e),l(t,Ve,e),l(t,Ru,e),l(t,We,e),l(t,Iu,e),l(t,Du,e),l(t,Su,e),f(Je,t,e),l(t,zu,e),l(t,Ye,e),Ku=!0},p:fs,i(t){Ku||(m(v.$$.fragment,t),m(b.$$.fragment,t),m(N.$$.fragment,t),m(R.$$.fragment,t),m(z.$$.fragment,t),m(B.$$.fragment,t),m(V.$$.fragment,t),m(Z.$$.fragment,t),m(rt.$$.fragment,t),m(ot.$$.fragment,t),m(ft.$$.fragment,t),m($t.$$.fragment,t),m(kt.$$.fragment,t),m(wt.$$.fragment,t),m(gt.$$.fragment,t),m(Dt.$$.fragment,t),m(Ut.$$.fragment,t),m(Gt.$$.fragment,t),m(Yt.$$.fragment,t),m(ie.$$.fragment,t),m(de.$$.fragment,t),m(ae.$$.fragment,t),m(pe.$$.fragment,t),m($e.$$.fragment,t),m(Le.$$.fragment,t),m(He.$$.fragment,t),m(Qe.$$.fragment,t),m(qe.$$.fragment,t),m(Se.$$.fragment,t),m(Ue.$$.fragment,t),m(Ge.$$.fragment,t),m(Je.$$.fragment,t),Ku=!0)},o(t){h(v.$$.fragment,t),h(b.$$.fragment,t),h(N.$$.fragment,t),h(R.$$.fragment,t),h(z.$$.fragment,t),h(B.$$.fragment,t),h(V.$$.fragment,t),h(Z.$$.fragment,t),h(rt.$$.fragment,t),h(ot.$$.fragment,t),h(ft.$$.fragment,t),h($t.$$.fragment,t),h(kt.$$.fragment,t),h(wt.$$.fragment,t),h(gt.$$.fragment,t),h(Dt.$$.fragment,t),h(Ut.$$.fragment,t),h(Gt.$$.fragment,t),h(Yt.$$.fragment,t),h(ie.$$.fragment,t),h(de.$$.fragment,t),h(ae.$$.fragment,t),h(pe.$$.fragment,t),h($e.$$.fragment,t),h(Le.$$.fragment,t),h(He.$$.fragment,t),h(Qe.$$.fragment,t),h(qe.$$.fragment,t),h(Se.$$.fragment,t),h(Ue.$$.fragment,t),h(Ge.$$.fragment,t),h(Je.$$.fragment,t),Ku=!1},d(t){t&&(i(Ze),i(Xe),i(ti),i(_),i(ei),i(ii),i(L),i(li),i(x),i(ri),i(k),i(ui),i(di),i(si),i(C),i(oi),i(ai),i(H),i(ni),i(P),i(ci),i(w),i(pi),i(M),i(fi),i(A),i(mi),i(hi),i(Ti),i(Q),i(yi),i($i),i(g),i(_i),i(E),i(vi),i(Li),i(xi),i(q),i(ki),i(Ci),i(I),i(bi),i(D),i(Hi),i(Pi),i(wi),i(S),i(Mi),i(Ai),i(K),i(Qi),i(j),i(Ni),i(gi),i(Ei),i(U),i(qi),i(Ri),i(F),i(Ii),i(O),i(Di),i(Si),i(zi),i(G),i(Ki),i(ji),i(W),i(Ui),i(J),i(Bi),i(X),i(Fi),i(Oi),i(Gi),i(Y),i(Vi),i(Wi),i(tt),i(Ji),i(et),i(Xi),i(it),i(Yi),i(Zi),i(tl),i(lt),i(el),i(il),i(ut),i(ll),i(dt),i(rl),i(ul),i(dl),i(st),i(sl),i(ol),i(at),i(al),i(nt),i(nl),i(ct),i(cl),i(pl),i(fl),i(pt),i(ml),i(hl),i(mt),i(Tl),i(ht),i(yl),i(Tt),i($l),i(_l),i(vl),i(yt),i(Ll),i(xl),i(_t),i(kl),i(vt),i(Cl),i(Lt),i(bl),i(Hl),i(Pl),i(xt),i(wl),i(Ml),i(Ct),i(Al),i(bt),i(Ql),i(Ht),i(Nl),i(gl),i(El),i(Pt),i(ql),i(Rl),i(Mt),i(Il),i(At),i(Dl),i(Qt),i(Sl),i(zl),i(Kl),i(Nt),i(jl),i(Ul),i(Et),i(Bl),i(qt),i(Fl),i(Rt),i(Ol),i(Gl),i(Vl),i(It),i(Wl),i(Jl),i(St),i(Xl),i(zt),i(Yl),i(Kt),i(Zl),i(tr),i(er),i(jt),i(ir),i(lr),i(Bt),i(rr),i(Ft),i(ur),i(dr),i(sr),i(Ot),i(or),i(ar),i(Vt),i(nr),i(Wt),i(cr),i(Jt),i(pr),i(fr),i(mr),i(Xt),i(hr),i(Tr),i(Zt),i(yr),i(te),i($r),i(_r),i(vr),i(ee),i(Lr),i(xr),i(le),i(kr),i(re),i(Cr),i(br),i(Hr),i(ue),i(Pr),i(wr),i(se),i(Mr),i(Ar),i(Qr),i(oe),i(Nr),i(gr),i(ne),i(Er),i(qr),i(Rr),i(ce),i(Ir),i(Dr),i(fe),i(Sr),i(me),i(zr),i(he),i(Kr),i(Te),i(jr),i(Ur),i(Br),i(ye),i(Fr),i(Or),i(_e),i(Gr),i(Vr),i(Wr),i(ve),i(Jr),i(Xr),i(xe),i(Yr),i(ke),i(Zr),i(Ce),i(tu),i(eu),i(iu),i(be),i(lu),i(ru),i(Pe),i(uu),i(we),i(du),i(Me),i(su),i(ou),i(au),i(Ae),i(nu),i(cu),i(Ne),i(pu),i(ge),i(fu),i(mu),i(hu),i(Ee),i(Tu),i(yu),i(Re),i($u),i(Ie),i(_u),i(vu),i(Lu),i(De),i(xu),i(ku),i(ze),i(Cu),i(Ke),i(bu),i(Hu),i(Pu),i(je),i(wu),i(Mu),i(Be),i(Au),i(Fe),i(Qu),i(Nu),i(gu),i(Oe),i(Eu),i(qu),i(Ve),i(Ru),i(We),i(Iu),i(Du),i(Su),i(zu),i(Ye)),i($),T(v,t),T(b,t),T(N,t),T(R,t),T(z,t),T(B,t),T(V,t),T(Z,t),T(rt,t),T(ot,t),T(ft,t),T($t,t),T(kt,t),T(wt,t),T(gt,t),T(Dt,t),T(Ut,t),T(Gt,t),T(Yt,t),T(ie,t),T(de,t),T(ae,t),T(pe,t),T($e,t),T(Le,t),T(He,t),T(Qe,t),T(qe,t),T(Se,t),T(Ue,t),T(Ge,t),T(Je,t)}}}const Ls='{"title":"utils/data-structures","local":"utilsdata-structures","sections":[{"title":"utils/data-structures.PriorityQueue","local":"utilsdata-structurespriorityqueue","sections":[{"title":"new PriorityQueue(comparator)","local":"new-priorityqueuecomparator","sections":[],"depth":3},{"title":"priorityQueue.size","local":"priorityqueuesize","sections":[],"depth":3},{"title":"priorityQueue.isEmpty() ⇒ <code> boolean </code>","local":"priorityqueueisempty--code-boolean-code","sections":[],"depth":3},{"title":"priorityQueue.peek() ⇒ <code> any </code>","local":"priorityqueuepeek--code-any-code","sections":[],"depth":3},{"title":"priorityQueue.push(...values) ⇒ <code> number </code>","local":"priorityqueuepushvalues--code-number-code","sections":[],"depth":3},{"title":"priorityQueue.extend(values) ⇒ <code> number </code>","local":"priorityqueueextendvalues--code-number-code","sections":[],"depth":3},{"title":"priorityQueue.pop() ⇒ <code> any </code>","local":"priorityqueuepop--code-any-code","sections":[],"depth":3},{"title":"priorityQueue.replace(value) ⇒ <code> * </code>","local":"priorityqueuereplacevalue--code--code","sections":[],"depth":3},{"title":"priorityQueue._siftUpFrom(node)","local":"priorityqueuesiftupfromnode","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures.CharTrie","local":"utilsdata-structureschartrie","sections":[{"title":"charTrie.extend(texts)","local":"chartrieextendtexts","sections":[],"depth":3},{"title":"charTrie.push(text)","local":"chartriepushtext","sections":[],"depth":3},{"title":"charTrie.commonPrefixSearch(text)","local":"chartriecommonprefixsearchtext","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures.TokenLattice","local":"utilsdata-structurestokenlattice","sections":[{"title":"new TokenLattice(sentence, bosTokenId, eosTokenId)","local":"new-tokenlatticesentence-bostokenid-eostokenid","sections":[],"depth":3},{"title":"tokenLattice.insert(pos, length, score, tokenId)","local":"tokenlatticeinsertpos-length-score-tokenid","sections":[],"depth":3},{"title":"tokenLattice.viterbi() ⇒ <code> Array. < TokenLatticeNode > </code>","local":"tokenlatticeviterbi--code-array--tokenlatticenode--code","sections":[],"depth":3},{"title":"tokenLattice.piece(node) ⇒ <code> string </code>","local":"tokenlatticepiecenode--code-string-code","sections":[],"depth":3},{"title":"tokenLattice.tokens() ⇒ <code> Array. < string > </code>","local":"tokenlatticetokens--code-array--string--code","sections":[],"depth":3},{"title":"tokenLattice.tokenIds() ⇒ <code> Array. < number > </code>","local":"tokenlatticetokenids--code-array--number--code","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures.DictionarySplitter","local":"utilsdata-structuresdictionarysplitter","sections":[{"title":"new DictionarySplitter(dictionary)","local":"new-dictionarysplitterdictionary","sections":[],"depth":3},{"title":"dictionarySplitter.split(text) ⇒ <code> Array. < string > </code>","local":"dictionarysplittersplittext--code-array--string--code","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures~CharTrieNode","local":"utilsdata-structureschartrienode","sections":[{"title":"new CharTrieNode(isLeaf, children)","local":"new-chartrienodeisleaf-children","sections":[],"depth":3},{"title":"CharTrieNode.default() ⇒ <code> CharTrieNode </code>","local":"chartrienodedefault--code-chartrienode-code","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures~TokenLatticeNode","local":"utilsdata-structurestokenlatticenode","sections":[{"title":"new TokenLatticeNode(tokenId, nodeId, pos, length, score)","local":"new-tokenlatticenodetokenid-nodeid-pos-length-score","sections":[],"depth":3},{"title":"tokenLatticeNode.clone() ⇒ <code> TokenLatticeNode </code>","local":"tokenlatticenodeclone--code-tokenlatticenode-code","sections":[],"depth":3}],"depth":2}],"depth":1}';function xs(ju){return ms(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hs extends hs{constructor($){super(),Ts(this,$,xs,vs,ps,{})}}export{Hs as component};
