import{s as ut,n as dt,o as mt}from"../chunks/scheduler.9680c161.js";import{S as yt,i as ft,g as i,s as a,r as c,A as Tt,h as o,f as n,c as s,j as Mt,u as p,x as r,k as le,y as gt,a as l,v as h,d as M,t as u,w as d}from"../chunks/index.38d74ee1.js";import{C as m}from"../chunks/CodeBlock.1371964c.js";import{H as ee}from"../chunks/Heading.74c51a96.js";function wt(Se){let y,ae,te,se,w,ie,U,Ee="There are many ways you can consume Text Generation Inference server in your applications. After launching, you can use the <code>/generate</code> route and make a <code>POST</code> request to get results from the server. You can also use the <code>/generate_stream</code> route if you want TGI to return a stream of tokens. You can make the requests using the tool of your preference, such as curl, Python or TypeScrpt. For a final end-to-end experience, we also open-sourced ChatUI, a chat interface for open-source models.",oe,J,re,b,Le="After the launch, you can query the model using either the <code>/generate</code> or <code>/generate_stream</code> routes:",ce,I,pe,C,he,j,Fe=`<a href="https://huggingface.co/docs/huggingface_hub/main/en/index" rel="nofollow"><code>huggingface-hub</code></a> is a Python library to interact with the Hugging Face Hub, including its endpoints. It provides a nice high-level class, [<code>~huggingface_hub.InferenceClient</code>], which makes it easy to make calls to a TGI endpoint. <code>InferenceClient</code> also takes care of parameter validation and provides a simple to-use interface.
You can simply install <code>huggingface-hub</code> package with pip.`,Me,G,ue,$,qe="Once you start the TGI server, instantiate <code>InferenceClient()</code> with the URL to the endpoint serving the model. You can then call <code>text_generation()</code> to hit the endpoint through Python.",de,k,me,Z,Pe="You can do streaming with <code>InferenceClient</code> by passing <code>stream=True</code>. Streaming will return tokens as they are being generated in the server. To use streaming, you can do as follows:",ye,v,fe,x,Ae="Another parameter you can use with TGI backend is <code>details</code>. You can get more details on generation (tokens, probabilities, etc.) by setting <code>details</code> to <code>True</code>. When it’s specified, TGI will return a <code>TextGenerationResponse</code> or <code>TextGenerationStreamResponse</code> rather than a string or stream.",Te,R,ge,W,De="You can see how to stream below.",we,H,Ue,B,Ke='You can check out the details of the function <a href="https://huggingface.co/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation" rel="nofollow">here</a>. There is also an async version of the client, <code>AsyncInferenceClient</code>, based on <code>asyncio</code> and <code>aiohttp</code>. You can find docs for it <a href="https://huggingface.co/docs/huggingface_hub/package_reference/inference_client#huggingface_hub.AsyncInferenceClient" rel="nofollow">here</a>',Je,V,be,_,Oe='ChatUI is an open-source interface built for LLM serving. It offers many customization options, such as web search with SERP API and more. ChatUI can automatically consume the TGI server and even provides an option to switch between different TGI endpoints. You can try it out at <a href="https://huggingface.co/chat/" rel="nofollow">Hugging Chat</a>, or use the <a href="https://huggingface.co/new-space?template=huggingchat/chat-ui-template" rel="nofollow">ChatUI Docker Space</a> to deploy your own Hugging Chat to Spaces.',Ie,Q,et="To serve both ChatUI and TGI in same environment, simply add your own endpoints to the <code>MODELS</code> variable in <code>.env.local</code> file inside the <code>chat-ui</code> repository. Provide the endpoints pointing to where TGI is served.",Ce,Y,je,N,tt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/chatui_screen.png" alt="ChatUI"/>',Ge,z,$e,X,nt="Gradio is a Python library that helps you build web applications for your machine learning models with a few lines of code. It has a <code>ChatInterface</code> wrapper that helps create neat UIs for chatbots. Let’s take a look at how to create a chatbot with streaming mode using TGI and Gradio. Let’s install Gradio and Hub Python library first.",ke,S,Ze,E,lt='Assume you are serving your model on port 8080, we will query through <a href="consuming_tgi#inference-client">InferenceClient</a>.',ve,L,xe,F,at="The UI looks like this 👇",Re,f,st='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/tgi/gradio-tgi.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/tgi/gradio-tgi-dark.png"/>',We,q,it="You can try the demo directly here 👇",He,T,ot='<iframe src="https://merve-gradio-tgi-2.hf.space?__theme=light" width="850" height="750"></iframe>',Be,g,rt='<iframe src="https://merve-gradio-tgi-2.hf.space?__theme=dark" width="850" height="750"></iframe>',Ve,P,ct="You can disable streaming mode using <code>return</code> instead of <code>yield</code> in your inference function, like below.",_e,A,Qe,D,pt='You can read more about how to customize a <code>ChatInterface</code> <a href="https://www.gradio.app/guides/creating-a-chatbot-fast" rel="nofollow">here</a>.',Ye,K,Ne,O,ht='You can consult the OpenAPI documentation of the <code>text-generation-inference</code> REST API using the <code>/docs</code> route. The Swagger UI is also available <a href="https://huggingface.github.io/text-generation-inference" rel="nofollow">here</a>.',ze,ne,Xe;return w=new ee({props:{title:"Consuming Text Generation Inference",local:"consuming-text-generation-inference",headingTag:"h1"}}),J=new ee({props:{title:"curl",local:"curl",headingTag:"h2"}}),I=new m({props:{code:"Y3VybCUyMDEyNy4wLjAuMSUzQTgwODAlMkZnZW5lcmF0ZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC1YJTIwUE9TVCUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUyMmlucHV0cyUyMiUzQSUyMldoYXQlMjBpcyUyMERlZXAlMjBMZWFybmluZyUzRiUyMiUyQyUyMnBhcmFtZXRlcnMlMjIlM0ElN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQTIwJTdEJTdEJyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1IJTIwJ0NvbnRlbnQtVHlwZSUzQSUyMGFwcGxpY2F0aW9uJTJGanNvbic=",highlighted:`curl 127.0.0.1:8080/generate \\
    -X POST \\
    -d <span class="hljs-string">&#x27;{&quot;inputs&quot;:&quot;What is Deep Learning?&quot;,&quot;parameters&quot;:{&quot;max_new_tokens&quot;:20}}&#x27;</span> \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span>`,wrap:!1}}),C=new ee({props:{title:"Inference Client",local:"inference-client",headingTag:"h2"}}),G=new m({props:{code:"cGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlLWh1Yg==",highlighted:"pip install huggingface-hub",wrap:!1}}),k=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmh0dHAlM0ElMkYlMkYxMjcuMC4wLjElM0E4MDgwJTIyKSUwQWNsaWVudC50ZXh0X2dlbmVyYXRpb24ocHJvbXB0JTNEJTIyV3JpdGUlMjBhJTIwY29kZSUyMGZvciUyMHNuYWtlJTIwZ2FtZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(model=<span class="hljs-string">&quot;http://127.0.0.1:8080&quot;</span>)
client.text_generation(prompt=<span class="hljs-string">&quot;Write a code for snake game&quot;</span>)`,wrap:!1}}),v=new m({props:{code:"Zm9yJTIwdG9rZW4lMjBpbiUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24oJTIySG93JTIwZG8lMjB5b3UlMjBtYWtlJTIwY2hlZXNlJTNGJTIyJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMiUyQyUyMHN0cmVhbSUzRFRydWUpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQodG9rZW4p",highlighted:`<span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;How do you make cheese?&quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, stream=<span class="hljs-literal">True</span>):
    <span class="hljs-built_in">print</span>(token)`,wrap:!1}}),R=new m({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbihwcm9tcHQlM0QlMjJNZWFuaW5nJTIwb2YlMjBsaWZlJTIwaXMlMjIlMkMlMjBkZXRhaWxzJTNEVHJ1ZSklMEFwcmludChvdXRwdXQpJTBBJTBBJTIzJTIwVGV4dEdlbmVyYXRpb25SZXNwb25zZShnZW5lcmF0ZWRfdGV4dCUzRCclMjBhJTIwY29tcGxleCUyMGNvbmNlcHQlMjB0aGF0JTIwaXMlMjBub3QlMjBhbHdheXMlMjBjbGVhciUyMHRvJTIwdGhlJTIwaW5kaXZpZHVhbC4lMjBJdCUyMGlzJTIwYSUyMGNvbmNlcHQlMjB0aGF0JTIwaXMlMjBub3QlMjBhbHdheXMnJTJDJTIwZGV0YWlscyUzRERldGFpbHMoZmluaXNoX3JlYXNvbiUzRCUzQ0ZpbmlzaFJlYXNvbi5MZW5ndGglM0ElMjAnbGVuZ3RoJyUzRSUyQyUyMGdlbmVyYXRlZF90b2tlbnMlM0QyMCUyQyUyMHNlZWQlM0ROb25lJTJDJTIwcHJlZmlsbCUzRCU1QiU1RCUyQyUyMHRva2VucyUzRCU1QlRva2VuKGlkJTNEMjY3JTJDJTIwdGV4dCUzRCclMjBhJyUyQyUyMGxvZ3Byb2IlM0QtMi4wNzIzNDc0JTJDJTIwc3BlY2lhbCUzREZhbHNlKSUyQyUyMFRva2VuKGlkJTNEMTEyMzUlMkMlMjB0ZXh0JTNEJyUyMGNvbXBsZXgnJTJDJTIwbG9ncHJvYiUzRC0zLjEyNzI1NTIlMkMlMjBzcGVjaWFsJTNERmFsc2UpJTJDJTIwVG9rZW4oaWQlM0QxNzkwOCUyQyUyMHRleHQlM0QnJTIwY29uY2VwdCclMkMlMjBsb2dwcm9iJTNELTEuMzYzMjQ5NSUyQyUyMHNwZWNpYWwlM0RGYWxzZSklMkMuLikp",highlighted:`output = client.text_generation(prompt=<span class="hljs-string">&quot;Meaning of life is&quot;</span>, details=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(output)

<span class="hljs-comment"># TextGenerationResponse(generated_text=&#x27; a complex concept that is not always clear to the individual. It is a concept that is not always&#x27;, details=Details(finish_reason=&lt;FinishReason.Length: &#x27;length&#x27;&gt;, generated_tokens=20, seed=None, prefill=[], tokens=[Token(id=267, text=&#x27; a&#x27;, logprob=-2.0723474, special=False), Token(id=11235, text=&#x27; complex&#x27;, logprob=-3.1272552, special=False), Token(id=17908, text=&#x27; concept&#x27;, logprob=-1.3632495, special=False),..))</span>`,wrap:!1}}),H=new m({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbihwcm9tcHQlM0QlMjJNZWFuaW5nJTIwb2YlMjBsaWZlJTIwaXMlMjIlMkMlMjBzdHJlYW0lM0RUcnVlJTJDJTIwZGV0YWlscyUzRFRydWUpJTBBcHJpbnQobmV4dChpdGVyKG91dHB1dCkpKSUwQSUwQSUyMyUyMFRleHRHZW5lcmF0aW9uU3RyZWFtUmVzcG9uc2UodG9rZW4lM0RUb2tlbihpZCUzRDI2NyUyQyUyMHRleHQlM0QnJTIwYSclMkMlMjBsb2dwcm9iJTNELTIuMDcyMzQ3NCUyQyUyMHNwZWNpYWwlM0RGYWxzZSklMkMlMjBnZW5lcmF0ZWRfdGV4dCUzRE5vbmUlMkMlMjBkZXRhaWxzJTNETm9uZSk=",highlighted:`output = client.text_generation(prompt=<span class="hljs-string">&quot;Meaning of life is&quot;</span>, stream=<span class="hljs-literal">True</span>, details=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(output)))

<span class="hljs-comment"># TextGenerationStreamResponse(token=Token(id=267, text=&#x27; a&#x27;, logprob=-2.0723474, special=False), generated_text=None, details=None)</span>`,wrap:!1}}),V=new ee({props:{title:"ChatUI",local:"chatui",headingTag:"h2"}}),Y=new m({props:{code:"JTdCJTBBJTJGJTJGJTIwcmVzdCUyMG9mJTIwdGhlJTIwbW9kZWwlMjBjb25maWclMjBoZXJlJTBBJTIyZW5kcG9pbnRzJTIyJTNBJTIwJTVCJTdCJTIydXJsJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZIT1NUJTNBUE9SVCUyRmdlbmVyYXRlX3N0cmVhbSUyMiU3RCU1RCUwQSU3RA==",highlighted:`{
<span class="hljs-comment">// rest of the model config here</span>
<span class="hljs-string">&quot;endpoints&quot;</span>: <span class="hljs-selector-attr">[{<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://HOST:PORT/generate_stream&quot;</span>}]</span>
}`,wrap:!1}}),z=new ee({props:{title:"Gradio",local:"gradio",headingTag:"h2"}}),S=new m({props:{code:"cGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlLWh1YiUyMGdyYWRpbw==",highlighted:"pip install huggingface-hub gradio",wrap:!1}}),L=new m({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnQlMEElMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQobW9kZWwlM0QlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODA4MCUyMiklMEElMEFkZWYlMjBpbmZlcmVuY2UobWVzc2FnZSUyQyUyMGhpc3RvcnkpJTNBJTBBJTIwJTIwJTIwJTIwcGFydGlhbF9tZXNzYWdlJTIwJTNEJTIwJTIyJTIyJTBBJTIwJTIwJTIwJTIwZm9yJTIwdG9rZW4lMjBpbiUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24obWVzc2FnZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjAlMkMlMjBzdHJlYW0lM0RUcnVlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcnRpYWxfbWVzc2FnZSUyMCUyQiUzRCUyMHRva2VuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweWllbGQlMjBwYXJ0aWFsX21lc3NhZ2UlMEElMEFnci5DaGF0SW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGluZmVyZW5jZSUyQyUwQSUyMCUyMCUyMCUyMGNoYXRib3QlM0Rnci5DaGF0Ym90KGhlaWdodCUzRDMwMCklMkMlMEElMjAlMjAlMjAlMjB0ZXh0Ym94JTNEZ3IuVGV4dGJveChwbGFjZWhvbGRlciUzRCUyMkNoYXQlMjB3aXRoJTIwbWUhJTIyJTJDJTIwY29udGFpbmVyJTNERmFsc2UlMkMlMjBzY2FsZSUzRDcpJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJUaGlzJTIwaXMlMjB0aGUlMjBkZW1vJTIwZm9yJTIwR3JhZGlvJTIwVUklMjBjb25zdW1pbmclMjBUR0klMjBlbmRwb2ludCUyMHdpdGglMjBMTGFNQSUyMDdCLUNoYXQlMjBtb2RlbC4lMjIlMkMlMEElMjAlMjAlMjAlMjB0aXRsZSUzRCUyMkdyYWRpbyUyMCVGMCU5RiVBNCU5RCUyMFRHSSUyMiUyQyUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTNEJTVCJTIyQXJlJTIwdG9tYXRvZXMlMjB2ZWdldGFibGVzJTNGJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcmV0cnlfYnRuJTNEJTIyUmV0cnklMjIlMkMlMEElMjAlMjAlMjAlMjB1bmRvX2J0biUzRCUyMlVuZG8lMjIlMkMlMEElMjAlMjAlMjAlMjBjbGVhcl9idG4lM0QlMjJDbGVhciUyMiUyQyUwQSkucXVldWUoKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(model=<span class="hljs-string">&quot;http://127.0.0.1:8080&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">inference</span>(<span class="hljs-params">message, history</span>):
    partial_message = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.text_generation(message, max_new_tokens=<span class="hljs-number">20</span>, stream=<span class="hljs-literal">True</span>):
        partial_message += token
        <span class="hljs-keyword">yield</span> partial_message

gr.ChatInterface(
    inference,
    chatbot=gr.Chatbot(height=<span class="hljs-number">300</span>),
    textbox=gr.Textbox(placeholder=<span class="hljs-string">&quot;Chat with me!&quot;</span>, container=<span class="hljs-literal">False</span>, scale=<span class="hljs-number">7</span>),
    description=<span class="hljs-string">&quot;This is the demo for Gradio UI consuming TGI endpoint with LLaMA 7B-Chat model.&quot;</span>,
    title=<span class="hljs-string">&quot;Gradio 🤝 TGI&quot;</span>,
    examples=[<span class="hljs-string">&quot;Are tomatoes vegetables?&quot;</span>],
    retry_btn=<span class="hljs-string">&quot;Retry&quot;</span>,
    undo_btn=<span class="hljs-string">&quot;Undo&quot;</span>,
    clear_btn=<span class="hljs-string">&quot;Clear&quot;</span>,
).queue().launch()`,wrap:!1}}),A=new m({props:{code:"ZGVmJTIwaW5mZXJlbmNlKG1lc3NhZ2UlMkMlMjBoaXN0b3J5KSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24obWVzc2FnZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjAp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">inference</span>(<span class="hljs-params">message, history</span>):
    <span class="hljs-keyword">return</span> client.text_generation(message, max_new_tokens=<span class="hljs-number">20</span>)`,wrap:!1}}),K=new ee({props:{title:"API documentation",local:"api-documentation",headingTag:"h2"}}),{c(){y=i("meta"),ae=a(),te=i("p"),se=a(),c(w.$$.fragment),ie=a(),U=i("p"),U.innerHTML=Ee,oe=a(),c(J.$$.fragment),re=a(),b=i("p"),b.innerHTML=Le,ce=a(),c(I.$$.fragment),pe=a(),c(C.$$.fragment),he=a(),j=i("p"),j.innerHTML=Fe,Me=a(),c(G.$$.fragment),ue=a(),$=i("p"),$.innerHTML=qe,de=a(),c(k.$$.fragment),me=a(),Z=i("p"),Z.innerHTML=Pe,ye=a(),c(v.$$.fragment),fe=a(),x=i("p"),x.innerHTML=Ae,Te=a(),c(R.$$.fragment),ge=a(),W=i("p"),W.textContent=De,we=a(),c(H.$$.fragment),Ue=a(),B=i("p"),B.innerHTML=Ke,Je=a(),c(V.$$.fragment),be=a(),_=i("p"),_.innerHTML=Oe,Ie=a(),Q=i("p"),Q.innerHTML=et,Ce=a(),c(Y.$$.fragment),je=a(),N=i("p"),N.innerHTML=tt,Ge=a(),c(z.$$.fragment),$e=a(),X=i("p"),X.innerHTML=nt,ke=a(),c(S.$$.fragment),Ze=a(),E=i("p"),E.innerHTML=lt,ve=a(),c(L.$$.fragment),xe=a(),F=i("p"),F.textContent=at,Re=a(),f=i("div"),f.innerHTML=st,We=a(),q=i("p"),q.textContent=it,He=a(),T=i("div"),T.innerHTML=ot,Be=a(),g=i("div"),g.innerHTML=rt,Ve=a(),P=i("p"),P.innerHTML=ct,_e=a(),c(A.$$.fragment),Qe=a(),D=i("p"),D.innerHTML=pt,Ye=a(),c(K.$$.fragment),Ne=a(),O=i("p"),O.innerHTML=ht,ze=a(),ne=i("p"),this.h()},l(e){const t=Tt("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(n),ae=s(e),te=o(e,"P",{}),Mt(te).forEach(n),se=s(e),p(w.$$.fragment,e),ie=s(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-178rkma"&&(U.innerHTML=Ee),oe=s(e),p(J.$$.fragment,e),re=s(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1dlxhnz"&&(b.innerHTML=Le),ce=s(e),p(I.$$.fragment,e),pe=s(e),p(C.$$.fragment,e),he=s(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1w4ht1w"&&(j.innerHTML=Fe),Me=s(e),p(G.$$.fragment,e),ue=s(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-nvkyoi"&&($.innerHTML=qe),de=s(e),p(k.$$.fragment,e),me=s(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-38ka24"&&(Z.innerHTML=Pe),ye=s(e),p(v.$$.fragment,e),fe=s(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-nm4ig7"&&(x.innerHTML=Ae),Te=s(e),p(R.$$.fragment,e),ge=s(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1vj3swg"&&(W.textContent=De),we=s(e),p(H.$$.fragment,e),Ue=s(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-fupzbv"&&(B.innerHTML=Ke),Je=s(e),p(V.$$.fragment,e),be=s(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-9eaac9"&&(_.innerHTML=Oe),Ie=s(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-ll7db"&&(Q.innerHTML=et),Ce=s(e),p(Y.$$.fragment,e),je=s(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-16nfqnk"&&(N.innerHTML=tt),Ge=s(e),p(z.$$.fragment,e),$e=s(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-24oiaj"&&(X.innerHTML=nt),ke=s(e),p(S.$$.fragment,e),Ze=s(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-4m25xv"&&(E.innerHTML=lt),ve=s(e),p(L.$$.fragment,e),xe=s(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-ysfgve"&&(F.textContent=at),Re=s(e),f=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(f)!=="svelte-1navfwx"&&(f.innerHTML=st),We=s(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-9o7oqq"&&(q.textContent=it),He=s(e),T=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-eisylj"&&(T.innerHTML=ot),Be=s(e),g=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-diccf8"&&(g.innerHTML=rt),Ve=s(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-ha9nch"&&(P.innerHTML=ct),_e=s(e),p(A.$$.fragment,e),Qe=s(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-6b9edz"&&(D.innerHTML=pt),Ye=s(e),p(K.$$.fragment,e),Ne=s(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-3jzlxn"&&(O.innerHTML=ht),ze=s(e),ne=o(e,"P",{}),Mt(ne).forEach(n),this.h()},h(){le(y,"name","hf:doc:metadata"),le(y,"content",Ut),le(f,"class","flex justify-center"),le(T,"class","block dark:hidden"),le(g,"class","hidden dark:block")},m(e,t){gt(document.head,y),l(e,ae,t),l(e,te,t),l(e,se,t),h(w,e,t),l(e,ie,t),l(e,U,t),l(e,oe,t),h(J,e,t),l(e,re,t),l(e,b,t),l(e,ce,t),h(I,e,t),l(e,pe,t),h(C,e,t),l(e,he,t),l(e,j,t),l(e,Me,t),h(G,e,t),l(e,ue,t),l(e,$,t),l(e,de,t),h(k,e,t),l(e,me,t),l(e,Z,t),l(e,ye,t),h(v,e,t),l(e,fe,t),l(e,x,t),l(e,Te,t),h(R,e,t),l(e,ge,t),l(e,W,t),l(e,we,t),h(H,e,t),l(e,Ue,t),l(e,B,t),l(e,Je,t),h(V,e,t),l(e,be,t),l(e,_,t),l(e,Ie,t),l(e,Q,t),l(e,Ce,t),h(Y,e,t),l(e,je,t),l(e,N,t),l(e,Ge,t),h(z,e,t),l(e,$e,t),l(e,X,t),l(e,ke,t),h(S,e,t),l(e,Ze,t),l(e,E,t),l(e,ve,t),h(L,e,t),l(e,xe,t),l(e,F,t),l(e,Re,t),l(e,f,t),l(e,We,t),l(e,q,t),l(e,He,t),l(e,T,t),l(e,Be,t),l(e,g,t),l(e,Ve,t),l(e,P,t),l(e,_e,t),h(A,e,t),l(e,Qe,t),l(e,D,t),l(e,Ye,t),h(K,e,t),l(e,Ne,t),l(e,O,t),l(e,ze,t),l(e,ne,t),Xe=!0},p:dt,i(e){Xe||(M(w.$$.fragment,e),M(J.$$.fragment,e),M(I.$$.fragment,e),M(C.$$.fragment,e),M(G.$$.fragment,e),M(k.$$.fragment,e),M(v.$$.fragment,e),M(R.$$.fragment,e),M(H.$$.fragment,e),M(V.$$.fragment,e),M(Y.$$.fragment,e),M(z.$$.fragment,e),M(S.$$.fragment,e),M(L.$$.fragment,e),M(A.$$.fragment,e),M(K.$$.fragment,e),Xe=!0)},o(e){u(w.$$.fragment,e),u(J.$$.fragment,e),u(I.$$.fragment,e),u(C.$$.fragment,e),u(G.$$.fragment,e),u(k.$$.fragment,e),u(v.$$.fragment,e),u(R.$$.fragment,e),u(H.$$.fragment,e),u(V.$$.fragment,e),u(Y.$$.fragment,e),u(z.$$.fragment,e),u(S.$$.fragment,e),u(L.$$.fragment,e),u(A.$$.fragment,e),u(K.$$.fragment,e),Xe=!1},d(e){e&&(n(ae),n(te),n(se),n(ie),n(U),n(oe),n(re),n(b),n(ce),n(pe),n(he),n(j),n(Me),n(ue),n($),n(de),n(me),n(Z),n(ye),n(fe),n(x),n(Te),n(ge),n(W),n(we),n(Ue),n(B),n(Je),n(be),n(_),n(Ie),n(Q),n(Ce),n(je),n(N),n(Ge),n($e),n(X),n(ke),n(Ze),n(E),n(ve),n(xe),n(F),n(Re),n(f),n(We),n(q),n(He),n(T),n(Be),n(g),n(Ve),n(P),n(_e),n(Qe),n(D),n(Ye),n(Ne),n(O),n(ze),n(ne)),n(y),d(w,e),d(J,e),d(I,e),d(C,e),d(G,e),d(k,e),d(v,e),d(R,e),d(H,e),d(V,e),d(Y,e),d(z,e),d(S,e),d(L,e),d(A,e),d(K,e)}}}const Ut='{"title":"Consuming Text Generation Inference","local":"consuming-text-generation-inference","sections":[{"title":"curl","local":"curl","sections":[],"depth":2},{"title":"Inference Client","local":"inference-client","sections":[],"depth":2},{"title":"ChatUI","local":"chatui","sections":[],"depth":2},{"title":"Gradio","local":"gradio","sections":[],"depth":2},{"title":"API documentation","local":"api-documentation","sections":[],"depth":2}],"depth":1}';function Jt(Se){return mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gt extends yt{constructor(y){super(),ft(this,y,Jt,wt,ut,{})}}export{Gt as component};
