import{s as P,n as O,o as q}from"../chunks/scheduler.7bc62968.js";import{S as ll,i as sl,g as c,s as e,r as o,A as Ml,h as C,f as M,c as a,j as K,u,x as _,k as F,y as nl,a as n,v as h,d as A,t as b,w as d}from"../chunks/index.2f8492b0.js";import{C as el}from"../chunks/CodeBlock.4e96d6f7.js";import{H as f,E as al}from"../chunks/EditOnGithub.2a9ce03a.js";function yl(X){let y,G,k,g,J,Q,t,x,T,W="The VGG architecture was developed in 2014 by Karen Simonyan and Andrew Zisserman from the Visual Geometry Group -and hence named VGG- at Oxford University. The model demonstrated significant improvements over the past models at that time- to be specific 2014 Imagenet challange also known as ILSVRC.",Z,U,V,w,L="<li>Inputs are 224x224 images.</li> <li>Convolution kernel shape is (3,3) and max pooling window shape is (2,2).</li> <li>Number of channels for each convolutional layer 64 -&gt; 128 -&gt; 256 -&gt; 512 -&gt; 512.</li> <li>VGG16 has 16 hidden layers (13 convolutional layers and 3 fully connected layers).</li> <li>VGG19 has 19 hidden layers (16 convolutional layers and 3 fully connected layers).</li>",S,j,R,p,H="<li>VGG (16 or 19 layers) was relatively deeper than other SOTA networks at the time. AlexNet, the winning model for ILSVRC 2012 only has 8 layers.</li> <li>Multiple small (3X3) receptive field filters with ReLU activation instead of one large (7X7 or 11X11) filter lead to better learning of complex features. Smaller filters also mean fewer parameters per layer, with additional nonlinearity introduced in between.</li> <li>Multiscale training and inference. Each image was trained in multiple rounds with varying scales to ensure similar characteristics were captured at different sizes.</li> <li>Consistency and simplicity of the VGG network make it easier to scale or modify for future improvements.</li>",v,i,E,r,Y="Below you can find the PyTorch implementation of VGG19.",N,I,D,m,z,B,$;return J=new f({props:{title:"Very Deep Convolutional Networks for Large Scale Image Recognition (2014)",local:"very-deep-convolutional-networks-for-large-scale-image-recognition-2014",headingTag:"h1"}}),t=new f({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),U=new f({props:{title:"VGG Network Architechture",local:"vgg-network-architechture",headingTag:"h2"}}),j=new f({props:{title:"Key Comparisons",local:"key-comparisons",headingTag:"h2"}}),i=new f({props:{title:"PyTorch Example",local:"pytorch-example",headingTag:"h2"}}),I=new el({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn


<span class="hljs-keyword">class</span> <span class="hljs-title class_">VGG19</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, num_classes=<span class="hljs-number">1000</span></span>):
        <span class="hljs-built_in">super</span>(VGG19, self).__init__()

        <span class="hljs-comment"># Feature extraction layers: Convolutional and pooling layers</span>
        self.feature_extractor = nn.Sequential(
            nn.Conv2d(
                <span class="hljs-number">3</span>, <span class="hljs-number">64</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>
            ),  <span class="hljs-comment"># 3 input channels, 64 output channels, 3x3 kernel, 1 padding</span>
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">64</span>, <span class="hljs-number">64</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.MaxPool2d(
                kernel_size=<span class="hljs-number">2</span>, stride=<span class="hljs-number">2</span>
            ),  <span class="hljs-comment"># Max pooling with 2x2 kernel and stride 2</span>
            nn.Conv2d(<span class="hljs-number">64</span>, <span class="hljs-number">128</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">128</span>, <span class="hljs-number">128</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.MaxPool2d(kernel_size=<span class="hljs-number">2</span>, stride=<span class="hljs-number">2</span>),
            nn.Conv2d(<span class="hljs-number">128</span>, <span class="hljs-number">256</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">256</span>, <span class="hljs-number">256</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">256</span>, <span class="hljs-number">256</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">256</span>, <span class="hljs-number">256</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.MaxPool2d(kernel_size=<span class="hljs-number">2</span>, stride=<span class="hljs-number">2</span>),
            nn.Conv2d(<span class="hljs-number">256</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.MaxPool2d(kernel_size=<span class="hljs-number">2</span>, stride=<span class="hljs-number">2</span>),
        )

        <span class="hljs-comment"># Fully connected layers for classification</span>
        self.classifier = nn.Sequential(
            nn.Linear(
                <span class="hljs-number">512</span> * <span class="hljs-number">7</span> * <span class="hljs-number">7</span>, <span class="hljs-number">4096</span>
            ),  <span class="hljs-comment"># 512 channels, 7x7 spatial dimensions after max pooling</span>
            nn.ReLU(),
            nn.Dropout(<span class="hljs-number">0.5</span>),  <span class="hljs-comment"># Dropout layer with 0.5 dropout probability</span>
            nn.Linear(<span class="hljs-number">4096</span>, <span class="hljs-number">4096</span>),
            nn.ReLU(),
            nn.Dropout(<span class="hljs-number">0.5</span>),
            nn.Linear(<span class="hljs-number">4096</span>, num_classes),  <span class="hljs-comment"># Output layer with &#x27;num_classes&#x27; output units</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = self.feature_extractor(x)  <span class="hljs-comment"># Pass input through the feature extractor layers</span>
        x = x.view(x.size(<span class="hljs-number">0</span>), -<span class="hljs-number">1</span>)  <span class="hljs-comment"># Flatten the output for the fully connected layers</span>
        x = self.classifier(x)  <span class="hljs-comment"># Pass flattened output through the classifier layers</span>
        <span class="hljs-keyword">return</span> x`,wrap:!1}}),m=new al({props:{source:"https://github.com/johko/computer-vision-course/blob/main/chapters/en/unit2/cnns/vgg.mdx"}}),{c(){y=c("meta"),G=e(),k=c("p"),g=e(),o(J.$$.fragment),Q=e(),o(t.$$.fragment),x=e(),T=c("p"),T.textContent=W,Z=e(),o(U.$$.fragment),V=e(),w=c("ul"),w.innerHTML=L,S=e(),o(j.$$.fragment),R=e(),p=c("ul"),p.innerHTML=H,v=e(),o(i.$$.fragment),E=e(),r=c("p"),r.textContent=Y,N=e(),o(I.$$.fragment),D=e(),o(m.$$.fragment),z=e(),B=c("p"),this.h()},l(l){const s=Ml("svelte-u9bgzb",document.head);y=C(s,"META",{name:!0,content:!0}),s.forEach(M),G=a(l),k=C(l,"P",{}),K(k).forEach(M),g=a(l),u(J.$$.fragment,l),Q=a(l),u(t.$$.fragment,l),x=a(l),T=C(l,"P",{"data-svelte-h":!0}),_(T)!=="svelte-13pxk3z"&&(T.textContent=W),Z=a(l),u(U.$$.fragment,l),V=a(l),w=C(l,"UL",{"data-svelte-h":!0}),_(w)!=="svelte-1rax18l"&&(w.innerHTML=L),S=a(l),u(j.$$.fragment,l),R=a(l),p=C(l,"UL",{"data-svelte-h":!0}),_(p)!=="svelte-qri0w"&&(p.innerHTML=H),v=a(l),u(i.$$.fragment,l),E=a(l),r=C(l,"P",{"data-svelte-h":!0}),_(r)!=="svelte-1i2dftw"&&(r.textContent=Y),N=a(l),u(I.$$.fragment,l),D=a(l),u(m.$$.fragment,l),z=a(l),B=C(l,"P",{}),K(B).forEach(M),this.h()},h(){F(y,"name","hf:doc:metadata"),F(y,"content",Jl)},m(l,s){nl(document.head,y),n(l,G,s),n(l,k,s),n(l,g,s),h(J,l,s),n(l,Q,s),h(t,l,s),n(l,x,s),n(l,T,s),n(l,Z,s),h(U,l,s),n(l,V,s),n(l,w,s),n(l,S,s),h(j,l,s),n(l,R,s),n(l,p,s),n(l,v,s),h(i,l,s),n(l,E,s),n(l,r,s),n(l,N,s),h(I,l,s),n(l,D,s),h(m,l,s),n(l,z,s),n(l,B,s),$=!0},p:O,i(l){$||(A(J.$$.fragment,l),A(t.$$.fragment,l),A(U.$$.fragment,l),A(j.$$.fragment,l),A(i.$$.fragment,l),A(I.$$.fragment,l),A(m.$$.fragment,l),$=!0)},o(l){b(J.$$.fragment,l),b(t.$$.fragment,l),b(U.$$.fragment,l),b(j.$$.fragment,l),b(i.$$.fragment,l),b(I.$$.fragment,l),b(m.$$.fragment,l),$=!1},d(l){l&&(M(G),M(k),M(g),M(Q),M(x),M(T),M(Z),M(V),M(w),M(S),M(R),M(p),M(v),M(E),M(r),M(N),M(D),M(z),M(B)),M(y),d(J,l),d(t,l),d(U,l),d(j,l),d(i,l),d(I,l),d(m,l)}}}const Jl='{"title":"Very Deep Convolutional Networks for Large Scale Image Recognition (2014)","local":"very-deep-convolutional-networks-for-large-scale-image-recognition-2014","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"VGG Network Architechture","local":"vgg-network-architechture","sections":[],"depth":2},{"title":"Key Comparisons","local":"key-comparisons","sections":[],"depth":2},{"title":"PyTorch Example","local":"pytorch-example","sections":[],"depth":2}],"depth":1}';function tl(X){return q(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pl extends ll{constructor(y){super(),sl(this,y,tl,yl,P,{})}}export{pl as component};
