import{s as Fl,o as Ll,n as Dl}from"../chunks/scheduler.65852ee5.js";import{S as Pl,i as Ol,g as i,s as n,r as M,A as Kl,h as o,f as l,c as a,j as Yl,u as J,x as p,k as Sl,l as es,y as ts,a as s,v as c,d,t as r,w as T}from"../chunks/index.aa74147d.js";import{T as ls}from"../chunks/Tip.bb8ccac8.js";import{D as ss,C as u}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as j,E as ns}from"../chunks/EditOnGithub.4eda6a96.js";function as(Ve){let w,h="In-memory can only be used for quick-prototyping and tests. It is a Python implementation of the Qdrant server methods.";return{c(){w=i("p"),w.textContent=h},l(m){w=o(m,"P",{"data-svelte-h":!0}),p(w)!=="svelte-1xbb3g2"&&(w.textContent=h)},m(m,Ee){s(m,w,Ee)},p:Dl,d(m){m&&l(w)}}}function is(Ve){let w,h,m,Ee,b,Qe,f,qe,U,il='<em>Authored by: <a href="https://qdrant.tech/" rel="nofollow">Qdrant Team</a></em>',ze,g,ol="In this notebook, we demonstrate how you can use vector embeddings to navigate a codebase, and find relevant code snippets. We’ll search codebases using natural semantic queries, and search for code based on a similar logic.",Xe,C,pl='You can check out the <a href="https://code-search.qdrant.tech/" rel="nofollow">live deployment</a> of this approach which exposes the Qdrant codebase for search with a web interface.',He,x,Ye,B,Ml="We need two models to accomplish our goal.",Se,Z,Jl='<li><p>General usage neural encoder for Natural Language Processing (NLP), in our case <a href="https://huggingface.co/sentence-transformers/all-MiniLM-L6-v2" rel="nofollow">sentence-transformers/all-MiniLM-L6-v2</a>. We’ll call this NLP model.</p></li> <li><p>Specialized embeddings for code-to-code similarity search. We’ll use the <a href="https://huggingface.co/jinaai/jina-embeddings-v2-base-code" rel="nofollow">jinaai/jina-embeddings-v2-base-code</a> model for the task. It supports English and 30 widely used programming languages with a 8192 sequence length. Let’s call this code model.</p></li>',Fe,v,cl="To prepare our code for the NLP model, we need to preprocess the code to a format that closely resembles natural language. The code model supports a variety of standard programming languages, so there is no need to preprocess the snippets. We can use the code as is.",Le,A,De,k,dl="Let’s install the packages we’ll work with.",Pe,G,rl='<li><a href="https://pypi.org/project/inflection/" rel="nofollow">inflection</a> - A string transformation library. It singularizes and pluralizes English words, and transforms CamelCase to underscored string.</li> <li><a href="https://pypi.org/project/fastembed/" rel="nofollow">fastembed</a> - A CPU-first, lightweight library for generating vector embeddings. <a href="https://github.com/qdrant/fastembed#%EF%B8%8F-fastembed-on-a-gpu" rel="nofollow">GPU support is available</a>.</li> <li><a href="https://pypi.org/project/qdrant-client/" rel="nofollow">qdrant-client</a> - Official Python library to interface with the Qdrant server.</li>',Oe,W,Ke,_,et,N,Tl="Chunking the application sources into smaller parts is a non-trivial task. In general, functions, class methods, structs, enums, and all the other language-specific constructs are good candidates for chunks. They are big enough to contain some meaningful information, but small enough to be processed by embedding models with a limited context window. You can also use docstrings, comments, and other metadata can be used to enrich the chunks with additional information.",tt,y,ul='<img src="https://huggingface.co/datasets/Anush008/cookbook-images/resolve/main/data-chunking.png"/>',lt,$,wl="Text-based search is based on function signatures, but code search may return smaller pieces, such as loops. So, if we receive a particular function signature from the NLP model and part of its implementation from the code model, we merge the results.",st,E,nt,R,ml=`We’ll use the <a href="https://github.com/qdrant/qdrant" rel="nofollow">Qdrant codebase</a> for this demo.
While this codebase uses Rust, you can use this approach with any other language. You can use an <a href="https://microsoft.github.io/language-server-protocol/" rel="nofollow">Language Server Protocol (LSP)</a> tool to build a graph of the codebase, and then extract chunks. We did our work with the <a href="https://rust-analyzer.github.io/" rel="nofollow">rust-analyzer</a>. We exported the parsed codebase into the <a href="https://microsoft.github.io/language-server-protocol/specifications/lsif/0.4.0/specification/" rel="nofollow">LSIF</a> format, a standard for code intelligence data. Next, we used the LSIF data to navigate the codebase and extract the chunks.`,at,V,jl='You can use the same approach for other languages. There are <a href="https://microsoft.github.io/language-server-protocol/implementors/servers/" rel="nofollow">plenty of implementations</a> available.',it,Q,yl="We will then export the chunks into JSON documents with not only the code itself, but also context with the location of the code in the project.",ot,q,Il='You can examine the Qdrant structures, parsed in JSON, in the <a href="https://storage.googleapis.com/tutorial-attachments/code-search/structures.jsonl" rel="nofollow">structures.jsonl file</a> in our Google Cloud Storage bucket. Download it and use it as a source of data for our code search.',pt,z,Mt,X,hl="Next, load the file and parse the lines into a list of dictionaries:",Jt,H,ct,Y,bl="Let’s see how one entry looks like.",dt,S,rt,F,Tt,L,ut,D,fl="Each programming language has its own syntax which is not a part of the natural language. Thus, a general-purpose model probably does not understand the code as is. We can, however, normalize the data by removing code specifics and including additional context, such as module, class, function, and file name. We take the following steps:",wt,P,Ul="<li>Extract the signature of the function, method, or other code construct.</li> <li>Divide camel case and snake case names into separate words.</li> <li>Take the docstring, comments, and other important metadata.</li> <li>Build a sentence from the extracted data using a predefined template.</li> <li>Remove the special characters and replace them with spaces.</li>",mt,O,gl="We can now define the <code>textify</code> function that uses the <code>inflection</code> library to carry out our conversions:",jt,K,yt,ee,Cl="Now we can use <code>textify</code> to convert all chunks into text representations:",It,te,ht,le,xl="Let’s see how one of our representations looks like:",bt,se,ft,ne,Ut,ae,gt,ie,Ct,oe,xt,pe,Bt,Me,Zt,Je,Bl='Qdrant supports multiple modes of deployment. Including in-memory for prototyping, Docker and Qdrant Cloud. You can refer to the <a href="https://qdrant.tech/documentation/guides/installation/" rel="nofollow">installation instructions</a> for more information.',vt,ce,Zl="We’ll continue the tutorial using an in-memory instance.",At,I,kt,de,vl="Let’s create a collection to store our vectors.",Gt,re,Wt,Te,Al="Our newly created collection is ready to accept the data. Let’s upload the embeddings:",_t,ue,Nt,we,kl="The uploaded points are immediately available for search. Next, query the collection to find relevant code snippets.",$t,me,Et,je,Gl='We use one of the models to search the collection via Qdrant’s new <a href="https://qdrant.tech/blog/qdrant-1.10.x/" rel="nofollow">Query API</a>. Start with text embeddings. Run the following query “How do I count points in a collection?”. Review the results.',Rt,ye,Vt,Ie,Wl=`Now, review the results. The following table lists the module, the file name
and score. Each line includes a link to the signature.`,Qt,he,_l='<thead><tr><th>module</th> <th>file_name</th> <th>score</th> <th>signature</th></tr></thead> <tbody><tr><td>operations</td> <td>types.rs</td> <td>0.5493385</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/collection/src/operations/types.rs#L794" rel="nofollow"><code>pub struct CountRequestInternal</code></a></td></tr> <tr><td>map_index</td> <td>types.rs</td> <td>0.49973965</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/map_index/mod.rs#L89" rel="nofollow"><code>fn get_points_with_value_count</code></a></td></tr> <tr><td>map_index</td> <td>mutable_map_index.rs</td> <td>0.49941066</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/map_index/mutable_map_index.rs#L143" rel="nofollow"><code>pub fn get_points_with_value_count</code></a></td></tr></tbody>',qt,be,Nl="It seems we were able to find some relevant code structures. Let’s try the same with the code embeddings:",zt,fe,Xt,Ue,$l="Output:",Ht,ge,El='<thead><tr><th>module</th> <th>file_name</th> <th>score</th> <th>signature</th></tr></thead> <tbody><tr><td>field_index</td> <td>geo_index.rs</td> <td>0.7217579</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/geo_index/mod.rs#L319" rel="nofollow"><code>fn count_indexed_points</code></a></td></tr> <tr><td>numeric_index</td> <td>mod.rs</td> <td>0.7113214</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/numeric_index/mod.rs#L317" rel="nofollow"><code>fn count_indexed_points</code></a></td></tr> <tr><td>full_text_index</td> <td>text_index.rs</td> <td>0.6993165</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/full_text_index/text_index.rs#L179" rel="nofollow"><code>fn count_indexed_points</code></a></td></tr></tbody>',Yt,Ce,Rl=`While the scores retrieved by different models are not comparable, but we can
see that the results are different. Code and text embeddings can capture
different aspects of the codebase. We can use both models to query the collection
and then combine the results to get the most relevant code snippets.`,St,xe,Ft,Be,Lt,Ze,Vl='|  operations  |  lib/collection/src/operations/types.rs  |  0.5  | ` # [doc = " Count Request"] # [doc = " Counts the number of points which satisfy the given filter."] # [doc = " If filter is not provided, the count of all points in the collection will be returned."] # [derive (Debug , Deserialize , Serialize , JsonSchema , Validate)] # [serde (rename_all = "snake_case")] pub struct CountRequestInternal &#123; # [doc = " Look only for points which satisfies this conditions"] # [validate] pub filter : Option < Filter > , # [doc = " If true, count exact number of points. If false, count approximate number of points faster."] # [doc = " Approximate count might be unreliable during the indexing process. Default: true"] # [serde (default = "default_exact_count")] pub exact : bool , } ` |\n|  field_index  |  lib/segment/src/index/field_index/geo_index.rs  |  0.5  | ` fn count_indexed_points (& self) -> usize ` |\n|  map_index  |  lib/segment/src/index/field_index/map_index/mod.rs  |  0.33333334  | ` fn get_points_with_value_count < Q > (& self , value : & Q) -> Option < usize > where Q : ? Sized , N : std :: borrow :: Borrow < Q > , Q : Hash + Eq , ` |\n|  numeric_index  |  lib/segment/src/index/field_index/numeric_index/mod.rs  |  0.33333334  | ` fn count_indexed_points (& self) -> usize ` |\n|  fixtures  |  lib/segment/src/fixtures/payload_context_fixture.rs  |  0.25  | ` fn total_point_count (& self) -> usize ` |\n|  map_index  |  lib/segment/src/index/field_index/map_index/mutable_map_index.rs  |  0.25  | ` fn get_points_with_value_count < Q > (& self , value : & Q) -> Option < usize > where Q : ? Sized , N : std :: borrow :: Borrow < Q > , Q : Hash + Eq , ` |\n|  id_tracker  |  lib/segment/src/id_tracker/simple_id_tracker.rs  |  0.2  | ` fn total_point_count (& self) -> usize ` |\n|  map_index  |  lib/segment/src/index/field_index/map_index/mod.rs  |  0.2  | ` fn count_indexed_points (& self) -> usize ` |\n|  map_index  |  lib/segment/src/index/field_index/map_index/mod.rs  |  0.16666667  | ` fn count_indexed_points (& self) -> usize ` |\n|  field_index  |  lib/segment/src/index/field_index/stat_tools.rs  |  0.16666667  | ` fn number_of_selected_points (points : usize , values : usize) -> usize ` |\n',Dt,ve,Ql=`This is one example of how you can fuse the results from different models.
In a real-world scenario, you might run some reranking and deduplication, as well as additional processing of the results.`,Pt,Ae,Ot,ke,ql=`You can improve the search results, by grouping them by payload properties.
In our case, we can group the results by the module. If we use code embeddings,
we can see multiple results from the <code>map_index</code> module. Let’s group the
results and assume a single result per module:`,Kt,Ge,el,We,tl,_e,zl="|  field_index  |  geo_index.rs  |  0.7217579  | ` fn count_indexed_points (& self) -> usize ` |\n|  numeric_index  |  mod.rs  |  0.7113214  | ` fn count_indexed_points (& self) -> usize ` |\n|  fixtures  |  payload_context_fixture.rs  |  0.6993165  | ` fn total_point_count (& self) -> usize ` |\n|  map_index  |  mod.rs  |  0.68385994  | ` fn count_indexed_points (& self) -> usize ` |\n|  full_text_index  |  text_index.rs  |  0.6660142  | ` fn count_indexed_points (& self) -> usize ` |\n",ll,Ne,Xl='That concludes our tutorial. Thanks for taking the time to get here. We’ve just begun exploring what’s possible with vector embeddings and how to improve it. Feel free to experiment your way; you could build something very cool! Do share it with us 🙏 We are <a href="https://qdrant.tech/contact-us/" rel="nofollow">here</a>.',sl,$e,nl,Re,al;return b=new ss({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/code_search.ipynb"}]}}),f=new j({props:{title:"Code Search with Vector Embeddings and Qdrant",local:"code-search-with-vector-embeddings-and-qdrant",headingTag:"h2"}}),x=new j({props:{title:"The approach",local:"the-approach",headingTag:"h3"}}),A=new j({props:{title:"Installing Dependencies",local:"installing-dependencies",headingTag:"h2"}}),W=new u({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGluZmxlY3Rpb24lMjBxZHJhbnQtY2xpZW50JTIwZmFzdGVtYmVk",highlighted:"%pip install inflection qdrant-client fastembed",wrap:!1}}),_=new j({props:{title:"Data preparation",local:"data-preparation",headingTag:"h3"}}),E=new j({props:{title:"Parsing the Codebaase",local:"parsing-the-codebaase",headingTag:"h3"}}),z=new u({props:{code:"IXdnZXQlMjBodHRwcyUzQSUyRiUyRnN0b3JhZ2UuZ29vZ2xlYXBpcy5jb20lMkZ0dXRvcmlhbC1hdHRhY2htZW50cyUyRmNvZGUtc2VhcmNoJTJGc3RydWN0dXJlcy5qc29ubA==",highlighted:"!wget https://storage.googleapis.com/tutorial-attachments/code-search/structures.jsonl",wrap:!1}}),H=new u({props:{code:"aW1wb3J0JTIwanNvbiUwQSUwQXN0cnVjdHVyZXMlMjAlM0QlMjAlNUIlNUQlMEF3aXRoJTIwb3BlbiglMjJzdHJ1Y3R1cmVzLmpzb25sJTIyJTJDJTIwJTIyciUyMiklMjBhcyUyMGZwJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyQyUyMHJvdyUyMGluJTIwZW51bWVyYXRlKGZwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVudHJ5JTIwJTNEJTIwanNvbi5sb2Fkcyhyb3cpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RydWN0dXJlcy5hcHBlbmQoZW50cnkp",highlighted:`<span class="hljs-keyword">import</span> json

structures = []
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;structures.jsonl&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> fp:
    <span class="hljs-keyword">for</span> i, row <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(fp):
        entry = json.loads(row)
        structures.append(entry)`,wrap:!1}}),S=new u({props:{code:"c3RydWN0dXJlcyU1QjAlNUQ=",highlighted:'structures[<span class="hljs-number">0</span>]',wrap:!1}}),F=new u({props:{code:"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",highlighted:`{<span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;InvertedIndexRam&#x27;</span>,
 <span class="hljs-string">&#x27;signature&#x27;</span>: <span class="hljs-string">&#x27;# [doc = &quot; Inverted flatten index from dimension id to posting list&quot;] # [derive (Debug , Clone , PartialEq)] pub struct InvertedIndexRam { # [doc = &quot; Posting lists for each dimension flattened (dimension id -&gt; posting list)&quot;] # [doc = &quot; Gaps are filled with empty posting lists&quot;] pub postings : Vec &lt; PostingList &gt; , # [doc = &quot; Number of unique indexed vectors&quot;] # [doc = &quot; pre-computed on build and upsert to avoid having to traverse the posting lists.&quot;] pub vector_count : usize , }&#x27;</span>,
 <span class="hljs-string">&#x27;code_type&#x27;</span>: <span class="hljs-string">&#x27;Struct&#x27;</span>,
 <span class="hljs-string">&#x27;docstring&#x27;</span>: <span class="hljs-string">&#x27;= &quot; Inverted flatten index from dimension id to posting list&quot;&#x27;</span>,
 <span class="hljs-string">&#x27;line&#x27;</span>: <span class="hljs-number">15</span>,
 <span class="hljs-string">&#x27;line_from&#x27;</span>: <span class="hljs-number">13</span>,
 <span class="hljs-string">&#x27;line_to&#x27;</span>: <span class="hljs-number">22</span>,
 <span class="hljs-string">&#x27;context&#x27;</span>: {<span class="hljs-string">&#x27;module&#x27;</span>: <span class="hljs-string">&#x27;inverted_index&#x27;</span>,
  <span class="hljs-string">&#x27;file_path&#x27;</span>: <span class="hljs-string">&#x27;lib/sparse/src/index/inverted_index/inverted_index_ram.rs&#x27;</span>,
  <span class="hljs-string">&#x27;file_name&#x27;</span>: <span class="hljs-string">&#x27;inverted_index_ram.rs&#x27;</span>,
  <span class="hljs-string">&#x27;struct_name&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;snippet&#x27;</span>: <span class="hljs-string">&#x27;/// Inverted flatten index from dimension id to posting list\\n#[derive(Debug, Clone, PartialEq)]\\npub struct InvertedIndexRam {\\n    /// Posting lists for each dimension flattened (dimension id -&gt; posting list)\\n    /// Gaps are filled with empty posting lists\\n    pub postings: Vec&lt;PostingList&gt;,\\n    /// Number of unique indexed vectors\\n    /// pre-computed on build and upsert to avoid having to traverse the posting lists.\\n    pub vector_count: usize,\\n}\\n&#x27;</span>}}`,wrap:!1}}),L=new j({props:{title:"Code to natural language conversion",local:"code-to-natural-language-conversion",headingTag:"h3"}}),K=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> inflection
<span class="hljs-keyword">import</span> re

<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Dict</span>, <span class="hljs-type">Any</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">textify</span>(<span class="hljs-params">chunk: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-comment"># Get rid of all the camel case / snake case</span>
    <span class="hljs-comment"># - inflection.underscore changes the camel case to snake case</span>
    <span class="hljs-comment"># - inflection.humanize converts the snake case to human readable form</span>
    name = inflection.humanize(inflection.underscore(chunk[<span class="hljs-string">&quot;name&quot;</span>]))
    signature = inflection.humanize(inflection.underscore(chunk[<span class="hljs-string">&quot;signature&quot;</span>]))

    <span class="hljs-comment"># Check if docstring is provided</span>
    docstring = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">if</span> chunk[<span class="hljs-string">&quot;docstring&quot;</span>]:
        docstring = <span class="hljs-string">f&quot;that does <span class="hljs-subst">{chunk[<span class="hljs-string">&#x27;docstring&#x27;</span>]}</span> &quot;</span>

    <span class="hljs-comment"># Extract the location of that snippet of code</span>
    context = <span class="hljs-string">f&quot;module <span class="hljs-subst">{chunk[<span class="hljs-string">&#x27;context&#x27;</span>][<span class="hljs-string">&#x27;module&#x27;</span>]}</span> &quot;</span> <span class="hljs-string">f&quot;file <span class="hljs-subst">{chunk[<span class="hljs-string">&#x27;context&#x27;</span>][<span class="hljs-string">&#x27;file_name&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-keyword">if</span> chunk[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;struct_name&quot;</span>]:
        struct_name = inflection.humanize(inflection.underscore(chunk[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;struct_name&quot;</span>]))
        context = <span class="hljs-string">f&quot;defined in struct <span class="hljs-subst">{struct_name}</span> <span class="hljs-subst">{context}</span>&quot;</span>

    <span class="hljs-comment"># Combine all the bits and pieces together</span>
    text_representation = <span class="hljs-string">f&quot;<span class="hljs-subst">{chunk[<span class="hljs-string">&#x27;code_type&#x27;</span>]}</span> <span class="hljs-subst">{name}</span> &quot;</span> <span class="hljs-string">f&quot;<span class="hljs-subst">{docstring}</span>&quot;</span> <span class="hljs-string">f&quot;defined as <span class="hljs-subst">{signature}</span> &quot;</span> <span class="hljs-string">f&quot;<span class="hljs-subst">{context}</span>&quot;</span>

    <span class="hljs-comment"># Remove any special characters and concatenate the tokens</span>
    tokens = re.split(<span class="hljs-string">r&quot;\\W&quot;</span>, text_representation)
    tokens = <span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> x: x, tokens)
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot; &quot;</span>.join(tokens)`,wrap:!1}}),te=new u({props:{code:"dGV4dF9yZXByZXNlbnRhdGlvbnMlMjAlM0QlMjBsaXN0KG1hcCh0ZXh0aWZ5JTJDJTIwc3RydWN0dXJlcykp",highlighted:'text_representations = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">map</span>(textify, structures))',wrap:!1}}),se=new u({props:{code:"dGV4dF9yZXByZXNlbnRhdGlvbnMlNUIxMDAwJTVE",highlighted:'text_representations[<span class="hljs-number">1000</span>]',wrap:!1}}),ne=new u({props:{code:"J0Z1bmN0aW9uJTIwSG5zdyUyMGRpc2NvdmVyJTIwcHJlY2lzaW9uJTIwdGhhdCUyMGRvZXMlMjBDaGVja3MlMjBkaXNjb3ZlcnklMjBzZWFyY2glMjBwcmVjaXNpb24lMjB3aGVuJTIwdXNpbmclMjBobnN3JTIwaW5kZXglMjB0aGlzJTIwaXMlMjBkaWZmZXJlbnQlMjBmcm9tJTIwdGhlJTIwdGVzdHMlMjBpbiUyMGRlZmluZWQlMjBhcyUyMEZuJTIwaG5zdyUyMGRpc2NvdmVyJTIwcHJlY2lzaW9uJTIwbW9kdWxlJTIwaW50ZWdyYXRpb24lMjBmaWxlJTIwaG5zd19kaXNjb3Zlcl90ZXN0JTIwcnMn",highlighted:'<span class="hljs-string">&#x27;Function Hnsw discover precision that does Checks discovery search precision when using hnsw index this is different from the tests in defined as Fn hnsw discover precision module integration file hnsw_discover_test rs&#x27;</span>',wrap:!1}}),ae=new j({props:{title:"Natural language embeddings",local:"natural-language-embeddings",headingTag:"h3"}}),ie=new u({props:{code:"ZnJvbSUyMGZhc3RlbWJlZCUyMGltcG9ydCUyMFRleHRFbWJlZGRpbmclMEElMEFiYXRjaF9zaXplJTIwJTNEJTIwNSUwQSUwQW5scF9tb2RlbCUyMCUzRCUyMFRleHRFbWJlZGRpbmcoJTIyc2VudGVuY2UtdHJhbnNmb3JtZXJzJTJGYWxsLU1pbmlMTS1MNi12MiUyMiUyQyUyMHRocmVhZHMlM0QwKSUwQW5scF9lbWJlZGRpbmdzJTIwJTNEJTIwbmxwX21vZGVsLmVtYmVkKHRleHRfcmVwcmVzZW50YXRpb25zJTJDJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUp",highlighted:`<span class="hljs-keyword">from</span> fastembed <span class="hljs-keyword">import</span> TextEmbedding

batch_size = <span class="hljs-number">5</span>

nlp_model = TextEmbedding(<span class="hljs-string">&quot;sentence-transformers/all-MiniLM-L6-v2&quot;</span>, threads=<span class="hljs-number">0</span>)
nlp_embeddings = nlp_model.embed(text_representations, batch_size=batch_size)`,wrap:!1}}),oe=new j({props:{title:"Code Embeddings",local:"code-embeddings",headingTag:"h3"}}),pe=new u({props:{code:"Y29kZV9zbmlwcGV0cyUyMCUzRCUyMCU1QnN0cnVjdHVyZSU1QiUyMmNvbnRleHQlMjIlNUQlNUIlMjJzbmlwcGV0JTIyJTVEJTIwZm9yJTIwc3RydWN0dXJlJTIwaW4lMjBzdHJ1Y3R1cmVzJTVEJTBBJTBBY29kZV9tb2RlbCUyMCUzRCUyMFRleHRFbWJlZGRpbmcoJTIyamluYWFpJTJGamluYS1lbWJlZGRpbmdzLXYyLWJhc2UtY29kZSUyMiklMEElMEFjb2RlX2VtYmVkZGluZ3MlMjAlM0QlMjBjb2RlX21vZGVsLmVtYmVkKGNvZGVfc25pcHBldHMlMkMlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSk=",highlighted:`code_snippets = [structure[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;snippet&quot;</span>] <span class="hljs-keyword">for</span> structure <span class="hljs-keyword">in</span> structures]

code_model = TextEmbedding(<span class="hljs-string">&quot;jinaai/jina-embeddings-v2-base-code&quot;</span>)

code_embeddings = code_model.embed(code_snippets, batch_size=batch_size)`,wrap:!1}}),Me=new j({props:{title:"Building Qdrant collection",local:"building-qdrant-collection",headingTag:"h3"}}),I=new ls({props:{warning:!1,$$slots:{default:[as]},$$scope:{ctx:Ve}}}),re=new u({props:{code:"ZnJvbSUyMHFkcmFudF9jbGllbnQlMjBpbXBvcnQlMjBRZHJhbnRDbGllbnQlMkMlMjBtb2RlbHMlMEElMEFDT0xMRUNUSU9OX05BTUUlMjAlM0QlMjAlMjJxZHJhbnQtc291cmNlcyUyMiUwQSUwQWNsaWVudCUyMCUzRCUyMFFkcmFudENsaWVudCglMjIlM0FtZW1vcnklM0ElMjIpJTIwJTIwJTIzJTIwVXNlJTIwaW4tbWVtb3J5JTIwc3RvcmFnZSUwQSUyMyUyMGNsaWVudCUyMCUzRCUyMFFkcmFudENsaWVudCglMjJodHRwJTNBJTJGJTJGbG9jYWhvc3QlM0E2MzMzJTIyKSUyMCUyMCUyMyUyMEZvciUyMFFkcmFudCUyMHNlcnZlciUwQSUwQWNsaWVudC5jcmVhdGVfY29sbGVjdGlvbiglMEElMjAlMjAlMjAlMjBDT0xMRUNUSU9OX05BTUUlMkMlMEElMjAlMjAlMjAlMjB2ZWN0b3JzX2NvbmZpZyUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRleHQlMjIlM0ElMjBtb2RlbHMuVmVjdG9yUGFyYW1zKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNpemUlM0QzODQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkaXN0YW5jZSUzRG1vZGVscy5EaXN0YW5jZS5DT1NJTkUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29kZSUyMiUzQSUyMG1vZGVscy5WZWN0b3JQYXJhbXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2l6ZSUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRpc3RhbmNlJTNEbW9kZWxzLkRpc3RhbmNlLkNPU0lORSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> qdrant_client <span class="hljs-keyword">import</span> QdrantClient, models

COLLECTION_NAME = <span class="hljs-string">&quot;qdrant-sources&quot;</span>

client = QdrantClient(<span class="hljs-string">&quot;:memory:&quot;</span>)  <span class="hljs-comment"># Use in-memory storage</span>
<span class="hljs-comment"># client = QdrantClient(&quot;http://locahost:6333&quot;)  # For Qdrant server</span>

client.create_collection(
    COLLECTION_NAME,
    vectors_config={
        <span class="hljs-string">&quot;text&quot;</span>: models.VectorParams(
            size=<span class="hljs-number">384</span>,
            distance=models.Distance.COSINE,
        ),
        <span class="hljs-string">&quot;code&quot;</span>: models.VectorParams(
            size=<span class="hljs-number">768</span>,
            distance=models.Distance.COSINE,
        ),
    },
)`,wrap:!1}}),ue=new u({props:{code:"ZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBJTBBcG9pbnRzJTIwJTNEJTIwJTVCJTVEJTBBdG90YWwlMjAlM0QlMjBsZW4oc3RydWN0dXJlcyklMEFwcmludCglMjJOdW1iZXIlMjBvZiUyMHBvaW50cyUyMHRvJTIwdXBsb2FkJTNBJTIwJTIyJTJDJTIwdG90YWwpJTBBJTBBZm9yJTIwaWQlMkMlMjAodGV4dF9lbWJlZGRpbmclMkMlMjBjb2RlX2VtYmVkZGluZyUyQyUyMHN0cnVjdHVyZSklMjBpbiUyMHRxZG0oJTBBJTIwJTIwJTIwJTIwZW51bWVyYXRlKHppcChubHBfZW1iZWRkaW5ncyUyQyUyMGNvZGVfZW1iZWRkaW5ncyUyQyUyMHN0cnVjdHVyZXMpKSUyQyUyMHRvdGFsJTNEdG90YWwlMEEpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRmFzdEVtYmVkJTIwcmV0dXJucyUyMGdlbmVyYXRvcnMuJTIwRW1iZWRkaW5ncyUyMGFyZSUyMGNvbXB1dGVkJTIwYXMlMjBjb25zdW1lZC4lMEElMjAlMjAlMjAlMjBwb2ludHMuYXBwZW5kKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVscy5Qb2ludFN0cnVjdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZCUzRGlkJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmVjdG9yJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUzQSUyMHRleHRfZW1iZWRkaW5nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29kZSUyMiUzQSUyMGNvZGVfZW1iZWRkaW5nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGF5bG9hZCUzRHN0cnVjdHVyZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXBsb2FkJTIwcG9pbnRzJTIwaW4lMjBiYXRjaGVzJTBBJTIwJTIwJTIwJTIwaWYlMjBsZW4ocG9pbnRzKSUyMCUzRSUzRCUyMGJhdGNoX3NpemUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjbGllbnQudXBsb2FkX3BvaW50cyhDT0xMRUNUSU9OX05BTUUlMkMlMjBwb2ludHMlM0Rwb2ludHMlMkMlMjB3YWl0JTNEVHJ1ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwb2ludHMlMjAlM0QlMjAlNUIlNUQlMEElMEElMjMlMjBFbnN1cmUlMjBhbnklMjByZW1haW5pbmclMjBwb2ludHMlMjBhcmUlMjB1cGxvYWRlZCUwQWlmJTIwcG9pbnRzJTNBJTBBJTIwJTIwJTIwJTIwY2xpZW50LnVwbG9hZF9wb2ludHMoQ09MTEVDVElPTl9OQU1FJTJDJTIwcG9pbnRzJTNEcG9pbnRzKSUwQSUwQXByaW50KGYlMjJUb3RhbCUyMHBvaW50cyUyMGluJTIwY29sbGVjdGlvbiUzQSUyMCU3QmNsaWVudC5jb3VudChDT0xMRUNUSU9OX05BTUUpLmNvdW50JTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

points = []
total = <span class="hljs-built_in">len</span>(structures)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Number of points to upload: &quot;</span>, total)

<span class="hljs-keyword">for</span> <span class="hljs-built_in">id</span>, (text_embedding, code_embedding, structure) <span class="hljs-keyword">in</span> tqdm(
    <span class="hljs-built_in">enumerate</span>(<span class="hljs-built_in">zip</span>(nlp_embeddings, code_embeddings, structures)), total=total
):
    <span class="hljs-comment"># FastEmbed returns generators. Embeddings are computed as consumed.</span>
    points.append(
        models.PointStruct(
            <span class="hljs-built_in">id</span>=<span class="hljs-built_in">id</span>,
            vector={
                <span class="hljs-string">&quot;text&quot;</span>: text_embedding,
                <span class="hljs-string">&quot;code&quot;</span>: code_embedding,
            },
            payload=structure,
        )
    )

    <span class="hljs-comment"># Upload points in batches</span>
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(points) &gt;= batch_size:
        client.upload_points(COLLECTION_NAME, points=points, wait=<span class="hljs-literal">True</span>)
        points = []

<span class="hljs-comment"># Ensure any remaining points are uploaded</span>
<span class="hljs-keyword">if</span> points:
    client.upload_points(COLLECTION_NAME, points=points)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Total points in collection: <span class="hljs-subst">{client.count(COLLECTION_NAME).count}</span>&quot;</span>)`,wrap:!1}}),me=new j({props:{title:"Querying the codebase",local:"querying-the-codebase",headingTag:"h3"}}),ye=new u({props:{code:"cXVlcnklMjAlM0QlMjAlMjJIb3clMjBkbyUyMEklMjBjb3VudCUyMHBvaW50cyUyMGluJTIwYSUyMGNvbGxlY3Rpb24lM0YlMjIlMEElMEFoaXRzJTIwJTNEJTIwY2xpZW50LnF1ZXJ5X3BvaW50cyglMEElMjAlMjAlMjAlMjBDT0xMRUNUSU9OX05BTUUlMkMlMEElMjAlMjAlMjAlMjBxdWVyeSUzRG5leHQobmxwX21vZGVsLnF1ZXJ5X2VtYmVkKHF1ZXJ5KSkudG9saXN0KCklMkMlMEElMjAlMjAlMjAlMjB1c2luZyUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBsaW1pdCUzRDMlMkMlMEEpLnBvaW50cw==",highlighted:`query = <span class="hljs-string">&quot;How do I count points in a collection?&quot;</span>

hits = client.query_points(
    COLLECTION_NAME,
    query=<span class="hljs-built_in">next</span>(nlp_model.query_embed(query)).tolist(),
    using=<span class="hljs-string">&quot;text&quot;</span>,
    limit=<span class="hljs-number">3</span>,
).points`,wrap:!1}}),fe=new u({props:{code:"aGl0cyUyMCUzRCUyMGNsaWVudC5xdWVyeV9wb2ludHMoJTBBJTIwJTIwJTIwJTIwQ09MTEVDVElPTl9OQU1FJTJDJTBBJTIwJTIwJTIwJTIwcXVlcnklM0RuZXh0KGNvZGVfbW9kZWwucXVlcnlfZW1iZWQocXVlcnkpKS50b2xpc3QoKSUyQyUwQSUyMCUyMCUyMCUyMHVzaW5nJTNEJTIyY29kZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGxpbWl0JTNEMyUyQyUwQSkucG9pbnRz",highlighted:`hits = client.query_points(
    COLLECTION_NAME,
    query=<span class="hljs-built_in">next</span>(code_model.query_embed(query)).tolist(),
    using=<span class="hljs-string">&quot;code&quot;</span>,
    limit=<span class="hljs-number">3</span>,
).points`,wrap:!1}}),xe=new u({props:{code:"ZnJvbSUyMHFkcmFudF9jbGllbnQlMjBpbXBvcnQlMjBtb2RlbHMlMEElMEFoaXRzJTIwJTNEJTIwY2xpZW50LnF1ZXJ5X3BvaW50cyglMEElMjAlMjAlMjAlMjBjb2xsZWN0aW9uX25hbWUlM0RDT0xMRUNUSU9OX05BTUUlMkMlMEElMjAlMjAlMjAlMjBwcmVmZXRjaCUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVscy5QcmVmZXRjaCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBxdWVyeSUzRG5leHQobmxwX21vZGVsLnF1ZXJ5X2VtYmVkKHF1ZXJ5KSkudG9saXN0KCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1c2luZyUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsaW1pdCUzRDUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxzLlByZWZldGNoKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHF1ZXJ5JTNEbmV4dChjb2RlX21vZGVsLnF1ZXJ5X2VtYmVkKHF1ZXJ5KSkudG9saXN0KCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1c2luZyUzRCUyMmNvZGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsaW1pdCUzRDUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwcXVlcnklM0Rtb2RlbHMuRnVzaW9uUXVlcnkoZnVzaW9uJTNEbW9kZWxzLkZ1c2lvbi5SUkYpJTJDJTBBKS5wb2ludHM=",highlighted:`<span class="hljs-keyword">from</span> qdrant_client <span class="hljs-keyword">import</span> models

hits = client.query_points(
    collection_name=COLLECTION_NAME,
    prefetch=[
        models.Prefetch(
            query=<span class="hljs-built_in">next</span>(nlp_model.query_embed(query)).tolist(),
            using=<span class="hljs-string">&quot;text&quot;</span>,
            limit=<span class="hljs-number">5</span>,
        ),
        models.Prefetch(
            query=<span class="hljs-built_in">next</span>(code_model.query_embed(query)).tolist(),
            using=<span class="hljs-string">&quot;code&quot;</span>,
            limit=<span class="hljs-number">5</span>,
        ),
    ],
    query=models.FusionQuery(fusion=models.Fusion.RRF),
).points`,wrap:!1}}),Be=new u({props:{code:"Zm9yJTIwaGl0JTIwaW4lMjBoaXRzJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJjb250ZXh0JTIyJTVEJTVCJTIybW9kdWxlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJjb250ZXh0JTIyJTVEJTVCJTIyZmlsZV9wYXRoJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnNjb3JlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTYwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJzaWduYXR1cmUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlNjAlMjAlN0MlMjIlMkMlMEElMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> hit <span class="hljs-keyword">in</span> hits:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;| &quot;</span>,
<span class="hljs-meta">... </span>        hit.payload[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;module&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot; | &quot;</span>,
<span class="hljs-meta">... </span>        hit.payload[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;file_path&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot; | &quot;</span>,
<span class="hljs-meta">... </span>        hit.score,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot; | \`&quot;</span>,
<span class="hljs-meta">... </span>        hit.payload[<span class="hljs-string">&quot;signature&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;\` |&quot;</span>,
<span class="hljs-meta">... </span>    )`,wrap:!1}}),Ae=new j({props:{title:"Grouping the results",local:"grouping-the-results",headingTag:"h3"}}),Ge=new u({props:{code:"cmVzdWx0cyUyMCUzRCUyMGNsaWVudC5xdWVyeV9wb2ludHNfZ3JvdXBzKCUwQSUyMCUyMCUyMCUyMENPTExFQ1RJT05fTkFNRSUyQyUwQSUyMCUyMCUyMCUyMHF1ZXJ5JTNEbmV4dChjb2RlX21vZGVsLnF1ZXJ5X2VtYmVkKHF1ZXJ5KSkudG9saXN0KCklMkMlMEElMjAlMjAlMjAlMjB1c2luZyUzRCUyMmNvZGUlMjIlMkMlMEElMjAlMjAlMjAlMjBncm91cF9ieSUzRCUyMmNvbnRleHQubW9kdWxlJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGltaXQlM0Q1JTJDJTBBJTIwJTIwJTIwJTIwZ3JvdXBfc2l6ZSUzRDElMkMlMEEp",highlighted:`results = client.query_points_groups(
    COLLECTION_NAME,
    query=<span class="hljs-built_in">next</span>(code_model.query_embed(query)).tolist(),
    using=<span class="hljs-string">&quot;code&quot;</span>,
    group_by=<span class="hljs-string">&quot;context.module&quot;</span>,
    limit=<span class="hljs-number">5</span>,
    group_size=<span class="hljs-number">1</span>,
)`,wrap:!1}}),We=new u({props:{code:"Zm9yJTIwZ3JvdXAlMjBpbiUyMHJlc3VsdHMuZ3JvdXBzJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaGl0JTIwaW4lMjBncm91cC5oaXRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJjb250ZXh0JTIyJTVEJTVCJTIybW9kdWxlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJjb250ZXh0JTIyJTVEJTVCJTIyZmlsZV9uYW1lJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnNjb3JlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTYwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJzaWduYXR1cmUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlNjAlMjAlN0MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> group <span class="hljs-keyword">in</span> results.groups:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> hit <span class="hljs-keyword">in</span> group.hits:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;| &quot;</span>,
<span class="hljs-meta">... </span>            hit.payload[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;module&quot;</span>],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot; | &quot;</span>,
<span class="hljs-meta">... </span>            hit.payload[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;file_name&quot;</span>],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot; | &quot;</span>,
<span class="hljs-meta">... </span>            hit.score,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot; | \`&quot;</span>,
<span class="hljs-meta">... </span>            hit.payload[<span class="hljs-string">&quot;signature&quot;</span>],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;\` |&quot;</span>,
<span class="hljs-meta">... </span>        )`,wrap:!1}}),$e=new ns({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/code_search.md"}}),{c(){w=i("meta"),h=n(),m=i("p"),Ee=n(),M(b.$$.fragment),Qe=n(),M(f.$$.fragment),qe=n(),U=i("p"),U.innerHTML=il,ze=n(),g=i("p"),g.textContent=ol,Xe=n(),C=i("p"),C.innerHTML=pl,He=n(),M(x.$$.fragment),Ye=n(),B=i("p"),B.textContent=Ml,Se=n(),Z=i("ul"),Z.innerHTML=Jl,Fe=n(),v=i("p"),v.textContent=cl,Le=n(),M(A.$$.fragment),De=n(),k=i("p"),k.textContent=dl,Pe=n(),G=i("ul"),G.innerHTML=rl,Oe=n(),M(W.$$.fragment),Ke=n(),M(_.$$.fragment),et=n(),N=i("p"),N.textContent=Tl,tt=n(),y=i("div"),y.innerHTML=ul,lt=n(),$=i("p"),$.textContent=wl,st=n(),M(E.$$.fragment),nt=n(),R=i("p"),R.innerHTML=ml,at=n(),V=i("p"),V.innerHTML=jl,it=n(),Q=i("p"),Q.textContent=yl,ot=n(),q=i("p"),q.innerHTML=Il,pt=n(),M(z.$$.fragment),Mt=n(),X=i("p"),X.textContent=hl,Jt=n(),M(H.$$.fragment),ct=n(),Y=i("p"),Y.textContent=bl,dt=n(),M(S.$$.fragment),rt=n(),M(F.$$.fragment),Tt=n(),M(L.$$.fragment),ut=n(),D=i("p"),D.textContent=fl,wt=n(),P=i("ol"),P.innerHTML=Ul,mt=n(),O=i("p"),O.innerHTML=gl,jt=n(),M(K.$$.fragment),yt=n(),ee=i("p"),ee.innerHTML=Cl,It=n(),M(te.$$.fragment),ht=n(),le=i("p"),le.textContent=xl,bt=n(),M(se.$$.fragment),ft=n(),M(ne.$$.fragment),Ut=n(),M(ae.$$.fragment),gt=n(),M(ie.$$.fragment),Ct=n(),M(oe.$$.fragment),xt=n(),M(pe.$$.fragment),Bt=n(),M(Me.$$.fragment),Zt=n(),Je=i("p"),Je.innerHTML=Bl,vt=n(),ce=i("p"),ce.textContent=Zl,At=n(),M(I.$$.fragment),kt=n(),de=i("p"),de.textContent=vl,Gt=n(),M(re.$$.fragment),Wt=n(),Te=i("p"),Te.textContent=Al,_t=n(),M(ue.$$.fragment),Nt=n(),we=i("p"),we.textContent=kl,$t=n(),M(me.$$.fragment),Et=n(),je=i("p"),je.innerHTML=Gl,Rt=n(),M(ye.$$.fragment),Vt=n(),Ie=i("p"),Ie.textContent=Wl,Qt=n(),he=i("table"),he.innerHTML=_l,qt=n(),be=i("p"),be.textContent=Nl,zt=n(),M(fe.$$.fragment),Xt=n(),Ue=i("p"),Ue.textContent=$l,Ht=n(),ge=i("table"),ge.innerHTML=El,Yt=n(),Ce=i("p"),Ce.textContent=Rl,St=n(),M(xe.$$.fragment),Ft=n(),M(Be.$$.fragment),Lt=n(),Ze=i("pre"),Ze.textContent=Vl,Dt=n(),ve=i("p"),ve.textContent=Ql,Pt=n(),M(Ae.$$.fragment),Ot=n(),ke=i("p"),ke.innerHTML=ql,Kt=n(),M(Ge.$$.fragment),el=n(),M(We.$$.fragment),tl=n(),_e=i("pre"),_e.textContent=zl,ll=n(),Ne=i("p"),Ne.innerHTML=Xl,sl=n(),M($e.$$.fragment),nl=n(),Re=i("p"),this.h()},l(e){const t=Kl("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(l),h=a(e),m=o(e,"P",{}),Yl(m).forEach(l),Ee=a(e),J(b.$$.fragment,e),Qe=a(e),J(f.$$.fragment,e),qe=a(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-17bl742"&&(U.innerHTML=il),ze=a(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-ae7bkg"&&(g.textContent=ol),Xe=a(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-kszg01"&&(C.innerHTML=pl),He=a(e),J(x.$$.fragment,e),Ye=a(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1dvof7"&&(B.textContent=Ml),Se=a(e),Z=o(e,"UL",{"data-svelte-h":!0}),p(Z)!=="svelte-19x5x7t"&&(Z.innerHTML=Jl),Fe=a(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-d94nr5"&&(v.textContent=cl),Le=a(e),J(A.$$.fragment,e),De=a(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-ut59o"&&(k.textContent=dl),Pe=a(e),G=o(e,"UL",{"data-svelte-h":!0}),p(G)!=="svelte-n6syf2"&&(G.innerHTML=rl),Oe=a(e),J(W.$$.fragment,e),Ke=a(e),J(_.$$.fragment,e),et=a(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1g3hp9b"&&(N.textContent=Tl),tt=a(e),y=o(e,"DIV",{style:!0,"data-svelte-h":!0}),p(y)!=="svelte-aiydin"&&(y.innerHTML=ul),lt=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-k9nbvr"&&($.textContent=wl),st=a(e),J(E.$$.fragment,e),nt=a(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-i8w8vo"&&(R.innerHTML=ml),at=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1mfzfdl"&&(V.innerHTML=jl),it=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-15jgfrp"&&(Q.textContent=yl),ot=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-14cl4i2"&&(q.innerHTML=Il),pt=a(e),J(z.$$.fragment,e),Mt=a(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-6aidpg"&&(X.textContent=hl),Jt=a(e),J(H.$$.fragment,e),ct=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-y6ssjb"&&(Y.textContent=bl),dt=a(e),J(S.$$.fragment,e),rt=a(e),J(F.$$.fragment,e),Tt=a(e),J(L.$$.fragment,e),ut=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1oie9o1"&&(D.textContent=fl),wt=a(e),P=o(e,"OL",{"data-svelte-h":!0}),p(P)!=="svelte-xx6zbg"&&(P.innerHTML=Ul),mt=a(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1k8bmra"&&(O.innerHTML=gl),jt=a(e),J(K.$$.fragment,e),yt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1fo0w5p"&&(ee.innerHTML=Cl),It=a(e),J(te.$$.fragment,e),ht=a(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-3wwgsm"&&(le.textContent=xl),bt=a(e),J(se.$$.fragment,e),ft=a(e),J(ne.$$.fragment,e),Ut=a(e),J(ae.$$.fragment,e),gt=a(e),J(ie.$$.fragment,e),Ct=a(e),J(oe.$$.fragment,e),xt=a(e),J(pe.$$.fragment,e),Bt=a(e),J(Me.$$.fragment,e),Zt=a(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-8h1xvl"&&(Je.innerHTML=Bl),vt=a(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-5jc3sw"&&(ce.textContent=Zl),At=a(e),J(I.$$.fragment,e),kt=a(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1fvhhbg"&&(de.textContent=vl),Gt=a(e),J(re.$$.fragment,e),Wt=a(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-dpehrl"&&(Te.textContent=Al),_t=a(e),J(ue.$$.fragment,e),Nt=a(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-3ws99c"&&(we.textContent=kl),$t=a(e),J(me.$$.fragment,e),Et=a(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-h95ly4"&&(je.innerHTML=Gl),Rt=a(e),J(ye.$$.fragment,e),Vt=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-1yoto9z"&&(Ie.textContent=Wl),Qt=a(e),he=o(e,"TABLE",{"data-svelte-h":!0}),p(he)!=="svelte-129t8ym"&&(he.innerHTML=_l),qt=a(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-19cp8rk"&&(be.textContent=Nl),zt=a(e),J(fe.$$.fragment,e),Xt=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1wuxk0l"&&(Ue.textContent=$l),Ht=a(e),ge=o(e,"TABLE",{"data-svelte-h":!0}),p(ge)!=="svelte-1d7gdtl"&&(ge.innerHTML=El),Yt=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-6u9tc7"&&(Ce.textContent=Rl),St=a(e),J(xe.$$.fragment,e),Ft=a(e),J(Be.$$.fragment,e),Lt=a(e),Ze=o(e,"PRE",{"data-svelte-h":!0}),p(Ze)!=="svelte-k4pkfe"&&(Ze.textContent=Vl),Dt=a(e),ve=o(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-rfg7y4"&&(ve.textContent=Ql),Pt=a(e),J(Ae.$$.fragment,e),Ot=a(e),ke=o(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-t87f2d"&&(ke.innerHTML=ql),Kt=a(e),J(Ge.$$.fragment,e),el=a(e),J(We.$$.fragment,e),tl=a(e),_e=o(e,"PRE",{"data-svelte-h":!0}),p(_e)!=="svelte-jxqdo"&&(_e.textContent=zl),ll=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-1rvelqz"&&(Ne.innerHTML=Xl),sl=a(e),J($e.$$.fragment,e),nl=a(e),Re=o(e,"P",{}),Yl(Re).forEach(l),this.h()},h(){Sl(w,"name","hf:doc:metadata"),Sl(w,"content",os),es(y,"text-align","center")},m(e,t){ts(document.head,w),s(e,h,t),s(e,m,t),s(e,Ee,t),c(b,e,t),s(e,Qe,t),c(f,e,t),s(e,qe,t),s(e,U,t),s(e,ze,t),s(e,g,t),s(e,Xe,t),s(e,C,t),s(e,He,t),c(x,e,t),s(e,Ye,t),s(e,B,t),s(e,Se,t),s(e,Z,t),s(e,Fe,t),s(e,v,t),s(e,Le,t),c(A,e,t),s(e,De,t),s(e,k,t),s(e,Pe,t),s(e,G,t),s(e,Oe,t),c(W,e,t),s(e,Ke,t),c(_,e,t),s(e,et,t),s(e,N,t),s(e,tt,t),s(e,y,t),s(e,lt,t),s(e,$,t),s(e,st,t),c(E,e,t),s(e,nt,t),s(e,R,t),s(e,at,t),s(e,V,t),s(e,it,t),s(e,Q,t),s(e,ot,t),s(e,q,t),s(e,pt,t),c(z,e,t),s(e,Mt,t),s(e,X,t),s(e,Jt,t),c(H,e,t),s(e,ct,t),s(e,Y,t),s(e,dt,t),c(S,e,t),s(e,rt,t),c(F,e,t),s(e,Tt,t),c(L,e,t),s(e,ut,t),s(e,D,t),s(e,wt,t),s(e,P,t),s(e,mt,t),s(e,O,t),s(e,jt,t),c(K,e,t),s(e,yt,t),s(e,ee,t),s(e,It,t),c(te,e,t),s(e,ht,t),s(e,le,t),s(e,bt,t),c(se,e,t),s(e,ft,t),c(ne,e,t),s(e,Ut,t),c(ae,e,t),s(e,gt,t),c(ie,e,t),s(e,Ct,t),c(oe,e,t),s(e,xt,t),c(pe,e,t),s(e,Bt,t),c(Me,e,t),s(e,Zt,t),s(e,Je,t),s(e,vt,t),s(e,ce,t),s(e,At,t),c(I,e,t),s(e,kt,t),s(e,de,t),s(e,Gt,t),c(re,e,t),s(e,Wt,t),s(e,Te,t),s(e,_t,t),c(ue,e,t),s(e,Nt,t),s(e,we,t),s(e,$t,t),c(me,e,t),s(e,Et,t),s(e,je,t),s(e,Rt,t),c(ye,e,t),s(e,Vt,t),s(e,Ie,t),s(e,Qt,t),s(e,he,t),s(e,qt,t),s(e,be,t),s(e,zt,t),c(fe,e,t),s(e,Xt,t),s(e,Ue,t),s(e,Ht,t),s(e,ge,t),s(e,Yt,t),s(e,Ce,t),s(e,St,t),c(xe,e,t),s(e,Ft,t),c(Be,e,t),s(e,Lt,t),s(e,Ze,t),s(e,Dt,t),s(e,ve,t),s(e,Pt,t),c(Ae,e,t),s(e,Ot,t),s(e,ke,t),s(e,Kt,t),c(Ge,e,t),s(e,el,t),c(We,e,t),s(e,tl,t),s(e,_e,t),s(e,ll,t),s(e,Ne,t),s(e,sl,t),c($e,e,t),s(e,nl,t),s(e,Re,t),al=!0},p(e,[t]){const Hl={};t&2&&(Hl.$$scope={dirty:t,ctx:e}),I.$set(Hl)},i(e){al||(d(b.$$.fragment,e),d(f.$$.fragment,e),d(x.$$.fragment,e),d(A.$$.fragment,e),d(W.$$.fragment,e),d(_.$$.fragment,e),d(E.$$.fragment,e),d(z.$$.fragment,e),d(H.$$.fragment,e),d(S.$$.fragment,e),d(F.$$.fragment,e),d(L.$$.fragment,e),d(K.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(ae.$$.fragment,e),d(ie.$$.fragment,e),d(oe.$$.fragment,e),d(pe.$$.fragment,e),d(Me.$$.fragment,e),d(I.$$.fragment,e),d(re.$$.fragment,e),d(ue.$$.fragment,e),d(me.$$.fragment,e),d(ye.$$.fragment,e),d(fe.$$.fragment,e),d(xe.$$.fragment,e),d(Be.$$.fragment,e),d(Ae.$$.fragment,e),d(Ge.$$.fragment,e),d(We.$$.fragment,e),d($e.$$.fragment,e),al=!0)},o(e){r(b.$$.fragment,e),r(f.$$.fragment,e),r(x.$$.fragment,e),r(A.$$.fragment,e),r(W.$$.fragment,e),r(_.$$.fragment,e),r(E.$$.fragment,e),r(z.$$.fragment,e),r(H.$$.fragment,e),r(S.$$.fragment,e),r(F.$$.fragment,e),r(L.$$.fragment,e),r(K.$$.fragment,e),r(te.$$.fragment,e),r(se.$$.fragment,e),r(ne.$$.fragment,e),r(ae.$$.fragment,e),r(ie.$$.fragment,e),r(oe.$$.fragment,e),r(pe.$$.fragment,e),r(Me.$$.fragment,e),r(I.$$.fragment,e),r(re.$$.fragment,e),r(ue.$$.fragment,e),r(me.$$.fragment,e),r(ye.$$.fragment,e),r(fe.$$.fragment,e),r(xe.$$.fragment,e),r(Be.$$.fragment,e),r(Ae.$$.fragment,e),r(Ge.$$.fragment,e),r(We.$$.fragment,e),r($e.$$.fragment,e),al=!1},d(e){e&&(l(h),l(m),l(Ee),l(Qe),l(qe),l(U),l(ze),l(g),l(Xe),l(C),l(He),l(Ye),l(B),l(Se),l(Z),l(Fe),l(v),l(Le),l(De),l(k),l(Pe),l(G),l(Oe),l(Ke),l(et),l(N),l(tt),l(y),l(lt),l($),l(st),l(nt),l(R),l(at),l(V),l(it),l(Q),l(ot),l(q),l(pt),l(Mt),l(X),l(Jt),l(ct),l(Y),l(dt),l(rt),l(Tt),l(ut),l(D),l(wt),l(P),l(mt),l(O),l(jt),l(yt),l(ee),l(It),l(ht),l(le),l(bt),l(ft),l(Ut),l(gt),l(Ct),l(xt),l(Bt),l(Zt),l(Je),l(vt),l(ce),l(At),l(kt),l(de),l(Gt),l(Wt),l(Te),l(_t),l(Nt),l(we),l($t),l(Et),l(je),l(Rt),l(Vt),l(Ie),l(Qt),l(he),l(qt),l(be),l(zt),l(Xt),l(Ue),l(Ht),l(ge),l(Yt),l(Ce),l(St),l(Ft),l(Lt),l(Ze),l(Dt),l(ve),l(Pt),l(Ot),l(ke),l(Kt),l(el),l(tl),l(_e),l(ll),l(Ne),l(sl),l(nl),l(Re)),l(w),T(b,e),T(f,e),T(x,e),T(A,e),T(W,e),T(_,e),T(E,e),T(z,e),T(H,e),T(S,e),T(F,e),T(L,e),T(K,e),T(te,e),T(se,e),T(ne,e),T(ae,e),T(ie,e),T(oe,e),T(pe,e),T(Me,e),T(I,e),T(re,e),T(ue,e),T(me,e),T(ye,e),T(fe,e),T(xe,e),T(Be,e),T(Ae,e),T(Ge,e),T(We,e),T($e,e)}}}const os='{"title":"Code Search with Vector Embeddings and Qdrant","local":"code-search-with-vector-embeddings-and-qdrant","sections":[{"title":"The approach","local":"the-approach","sections":[],"depth":3}],"depth":2}';function ps(Ve){return Ll(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ts extends Pl{constructor(w){super(),Ol(this,w,ps,is,Fl,{})}}export{Ts as component};
