import{s as xt,f as jt,n as Gt,o as Ct}from"../chunks/scheduler.65852ee5.js";import{S as Pt,i as Kt,g as j,s as a,r as n,A as Tt,h as M,f as s,c as l,j as ft,u as p,x as k,k as MA,y as Dt,a as e,v as g,d as c,t as i,w as r}from"../chunks/index.aa74147d.js";import{D as Ft,C as o}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as rt,E as Ot}from"../chunks/EditOnGithub.4eda6a96.js";function zt(Mt){let U,oA,rA,kA,d,UA,y,dA,u,ot='<em>Authored by: <a href="https://huggingface.co/merve" rel="nofollow">Merve Noyan</a></em>',yA,B,kt=`Embeddings are semantically meaningful compressions of information. They can be used to do similarity search, zero-shot classification or simply train a new model. Use cases for similarity search include searching for similar products in e-commerce, content search in social media and more.
This notebook walks you through using 🤗transformers, 🤗datasets and FAISS to create and index embeddings from a feature extraction model to later use them for similarity search.
Let’s install necessary libraries.`,uA,m,BA,W,Ut='For this tutorial, we will use <a href="https://huggingface.co/openai/clip-vit-base-patch16" rel="nofollow">CLIP model</a> to extract the features. CLIP is a revolutionary model that introduced joint training of a text encoder and an image encoder to connect two modalities.',mA,I,WA,J,dt='Load the dataset. To keep this notebook light, we will use a small captioning dataset, <a href="https://huggingface.co/datasets/jmhessel/newyorker_caption_contest" rel="nofollow">jmhessel/newyorker_caption_contest</a>.',IA,b,JA,w,yt="See an example.",bA,Z,wA,gA,ut,ZA,S,SA,H,Bt="We don’t have to write any function to embed examples or create an index. 🤗 datasets library’s FAISS integration abstracts these processes. We can simply use <code>map</code> method of the dataset to create a new column with the embeddings for each example like below. Let’s create one for text features on the prompt column.",HA,Q,QA,q,mt="We can do the same and get the image embeddings.",qA,V,VA,R,Wt="Now, we create an index for each column.",RA,f,fA,x,xA,G,GA,C,It="We can now query the dataset with text or image to get similar items from it.",CA,P,PA,K,KA,T,Jt=`['A man is in the snow. A boy with a huge snow shovel is there too. They are outside a house.']
`,TA,D,DA,F,bt="Image similarity inference is similar, where you just call <code>get_image_features</code>.",FA,O,OA,cA,wt,zA,z,Zt="Search for the similar image.",hA,h,XA,X,St="Display the most similar image to the beaver image.",YA,Y,LA,L,Ht=`['Salmon swim upstream but they see a grizzly bear and are in shock. The bear has a smug look on his face when he sees the salmon.']
`,NA,N,EA,E,Qt="We can save the dataset with embeddings with <code>save_faiss_index</code>.",vA,v,$A,$,_A,_,qt=`It’s a good practice to store the embeddings in a dataset repository, so we will create one and push our embeddings there to pull later.
We will login to Hugging Face Hub, create a dataset repository there and push our indexes there and load using <code>snapshot_download</code>.`,At,AA,tt,tA,st,sA,et,eA,Vt="We can load the embeddings to the dataset with no embeddings using <code>load_faiss_index</code>.",at,aA,lt,lA,nt,nA,pt,iA,Rt,gt,pA,ct,jA,it;return d=new Ft({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/faiss_with_hf_datasets_and_clip.ipynb"}]}}),y=new rt({props:{title:"Embedding multimodal data for similarity search using 🤗 transformers, 🤗 datasets and FAISS",local:"embedding-multimodal-data-for-similarity-search-using--transformers--datasets-and-faiss",headingTag:"h1"}}),m=new o({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGRhdGFzZXRzJTIwZmFpc3MtZ3B1JTIwdHJhbnNmb3JtZXJzJTIwc2VudGVuY2VwaWVjZQ==",highlighted:"!pip install -q datasets faiss-gpu transformers sentencepiece",wrap:!1}}),I=new o({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ltYWdlUHJvY2Vzc29yJTJDJTIwQXV0b01vZGVsJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMGZhaXNzJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZjbGlwLXZpdC1iYXNlLXBhdGNoMTYlMjIpLnRvKGRldmljZSklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRmNsaXAtdml0LWJhc2UtcGF0Y2gxNiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZjbGlwLXZpdC1iYXNlLXBhdGNoMTYlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModel, AutoTokenizer
<span class="hljs-keyword">import</span> faiss
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;openai/clip-vit-base-patch16&quot;</span>).to(device)
processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;openai/clip-vit-base-patch16&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai/clip-vit-base-patch16&quot;</span>)`,wrap:!1}}),b=new o({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyam1oZXNzZWwlMkZuZXd5b3JrZXJfY2FwdGlvbl9jb250ZXN0JTIyJTJDJTIwJTIyZXhwbGFuYXRpb24lMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;jmhessel/newyorker_caption_contest&quot;</span>, <span class="hljs-string">&quot;explanation&quot;</span>)`,wrap:!1}}),Z=new o({props:{code:"ZHMlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQlNUIlMjJpbWFnZSUyMiU1RA==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>]',wrap:!1}}),S=new o({props:{code:"ZHMlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQlNUIlMjJpbWFnZV9kZXNjcmlwdGlvbiUyMiU1RA==",highlighted:'ds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image_description&quot;</span>]',wrap:!1}}),Q=new o({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRzJTVCJTIydHJhaW4lMjIlNUQlMEFkc193aXRoX2VtYmVkZGluZ3MlMjAlM0QlMjBkYXRhc2V0Lm1hcCglMEElMjAlMjAlMjAlMjBsYW1iZGElMjBleGFtcGxlJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW1iZWRkaW5ncyUyMiUzQSUyMG1vZGVsLmdldF90ZXh0X2ZlYXR1cmVzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCoqdG9rZW5pemVyKCU1QmV4YW1wbGUlNUIlMjJpbWFnZV9kZXNjcmlwdGlvbiUyMiU1RCU1RCUyQyUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTVCMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC5kZXRhY2goKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC5jcHUoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC5udW1weSgpJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`dataset = ds[<span class="hljs-string">&quot;train&quot;</span>]
ds_with_embeddings = dataset.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> example: {
        <span class="hljs-string">&quot;embeddings&quot;</span>: model.get_text_features(
            **tokenizer([example[<span class="hljs-string">&quot;image_description&quot;</span>]], truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
        )[<span class="hljs-number">0</span>]
        .detach()
        .cpu()
        .numpy()
    }
)`,wrap:!1}}),V=new o({props:{code:"ZHNfd2l0aF9lbWJlZGRpbmdzJTIwJTNEJTIwZHNfd2l0aF9lbWJlZGRpbmdzLm1hcCglMEElMjAlMjAlMjAlMjBsYW1iZGElMjBleGFtcGxlJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW1hZ2VfZW1iZWRkaW5ncyUyMiUzQSUyMG1vZGVsLmdldF9pbWFnZV9mZWF0dXJlcygqKnByb2Nlc3NvciglNUJleGFtcGxlJTVCJTIyaW1hZ2UlMjIlNUQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSklNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLmRldGFjaCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLmNwdSgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLm51bXB5KCklMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`ds_with_embeddings = ds_with_embeddings.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> example: {
        <span class="hljs-string">&quot;image_embeddings&quot;</span>: model.get_image_features(**processor([example[<span class="hljs-string">&quot;image&quot;</span>]], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>))[
            <span class="hljs-number">0</span>
        ]
        .detach()
        .cpu()
        .numpy()
    }
)`,wrap:!1}}),f=new o({props:{code:"JTIzJTIwY3JlYXRlJTIwRkFJU1MlMjBpbmRleCUyMGZvciUyMHRleHQlMjBlbWJlZGRpbmdzJTBBZHNfd2l0aF9lbWJlZGRpbmdzLmFkZF9mYWlzc19pbmRleChjb2x1bW4lM0QlMjJlbWJlZGRpbmdzJTIyKQ==",highlighted:`<span class="hljs-comment"># create FAISS index for text embeddings</span>
ds_with_embeddings.add_faiss_index(column=<span class="hljs-string">&quot;embeddings&quot;</span>)`,wrap:!1}}),x=new o({props:{code:"JTIzJTIwY3JlYXRlJTIwRkFJU1MlMjBpbmRleCUyMGZvciUyMGltYWdlJTIwZW1iZWRkaW5ncyUwQWRzX3dpdGhfZW1iZWRkaW5ncy5hZGRfZmFpc3NfaW5kZXgoY29sdW1uJTNEJTIyaW1hZ2VfZW1iZWRkaW5ncyUyMik=",highlighted:`<span class="hljs-comment"># create FAISS index for image embeddings</span>
ds_with_embeddings.add_faiss_index(column=<span class="hljs-string">&quot;image_embeddings&quot;</span>)`,wrap:!1}}),G=new rt({props:{title:"Querying the data with text prompts",local:"querying-the-data-with-text-prompts",headingTag:"h2"}}),P=new o({props:{code:"cHJtdCUyMCUzRCUyMCUyMmElMjBzbm93eSUyMGRheSUyMiUwQXBybXRfZW1iZWRkaW5nJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMG1vZGVsLmdldF90ZXh0X2ZlYXR1cmVzKCoqdG9rZW5pemVyKCU1QnBybXQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpLnRvKCUyMmN1ZGElMjIpKSU1QjAlNUQlMEElMjAlMjAlMjAlMjAuZGV0YWNoKCklMEElMjAlMjAlMjAlMjAuY3B1KCklMEElMjAlMjAlMjAlMjAubnVtcHkoKSUwQSklMEFzY29yZXMlMkMlMjByZXRyaWV2ZWRfZXhhbXBsZXMlMjAlM0QlMjBkc193aXRoX2VtYmVkZGluZ3MuZ2V0X25lYXJlc3RfZXhhbXBsZXMoJTIyZW1iZWRkaW5ncyUyMiUyQyUyMHBybXRfZW1iZWRkaW5nJTJDJTIwayUzRDEp",highlighted:`prmt = <span class="hljs-string">&quot;a snowy day&quot;</span>
prmt_embedding = (
    model.get_text_features(**tokenizer([prmt], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, truncation=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>))[<span class="hljs-number">0</span>]
    .detach()
    .cpu()
    .numpy()
)
scores, retrieved_examples = ds_with_embeddings.get_nearest_examples(<span class="hljs-string">&quot;embeddings&quot;</span>, prmt_embedding, k=<span class="hljs-number">1</span>)`,wrap:!1}}),K=new o({props:{code:"ZGVmJTIwZG93bnNjYWxlX2ltYWdlcyhpbWFnZSklM0ElMEElMjAlMjAlMjAlMjB3aWR0aCUyMCUzRCUyMDIwMCUwQSUyMCUyMCUyMCUyMHJhdGlvJTIwJTNEJTIwd2lkdGglMjAlMkYlMjBmbG9hdChpbWFnZS5zaXplJTVCMCU1RCklMEElMjAlMjAlMjAlMjBoZWlnaHQlMjAlM0QlMjBpbnQoKGZsb2F0KGltYWdlLnNpemUlNUIxJTVEKSUyMColMjBmbG9hdChyYXRpbykpKSUwQSUyMCUyMCUyMCUyMGltZyUyMCUzRCUyMGltYWdlLnJlc2l6ZSgod2lkdGglMkMlMjBoZWlnaHQpJTJDJTIwSW1hZ2UuUmVzYW1wbGluZy5MQU5DWk9TKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGltZyUwQSUwQSUwQWltYWdlcyUyMCUzRCUyMCU1QmRvd25zY2FsZV9pbWFnZXMoaW1hZ2UpJTIwZm9yJTIwaW1hZ2UlMjBpbiUyMHJldHJpZXZlZF9leGFtcGxlcyU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIzJTIwc2VlJTIwdGhlJTIwY2xvc2VzdCUyMHRleHQlMjBhbmQlMjBpbWFnZSUwQXByaW50KHJldHJpZXZlZF9leGFtcGxlcyU1QiUyMmltYWdlX2Rlc2NyaXB0aW9uJTIyJTVEKSUwQWRpc3BsYXkoaW1hZ2VzJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">downscale_images</span>(<span class="hljs-params">image</span>):
<span class="hljs-meta">... </span>    width = <span class="hljs-number">200</span>
<span class="hljs-meta">... </span>    ratio = width / <span class="hljs-built_in">float</span>(image.size[<span class="hljs-number">0</span>])
<span class="hljs-meta">... </span>    height = <span class="hljs-built_in">int</span>((<span class="hljs-built_in">float</span>(image.size[<span class="hljs-number">1</span>]) * <span class="hljs-built_in">float</span>(ratio)))
<span class="hljs-meta">... </span>    img = image.resize((width, height), Image.Resampling.LANCZOS)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> img


<span class="hljs-meta">&gt;&gt;&gt; </span>images = [downscale_images(image) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> retrieved_examples[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># see the closest text and image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(retrieved_examples[<span class="hljs-string">&quot;image_description&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>display(images[<span class="hljs-number">0</span>])`,wrap:!1}}),D=new rt({props:{title:"Querying the data with image prompts",local:"querying-the-data-with-image-prompts",headingTag:"h2"}}),O=new o({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMjMlMjBpbWFnZSUyMG9mJTIwYSUyMGJlYXZlciUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnRyYW5zZm9ybWVycyUyRmJlYXZlci5wbmclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFkaXNwbGF5KGRvd25zY2FsZV9pbWFnZXMoaW1hZ2UpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># image of a beaver</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/beaver.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>display(downscale_images(image))`,wrap:!1}}),h=new o({props:{code:"aW1nX2VtYmVkZGluZyUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjBtb2RlbC5nZXRfaW1hZ2VfZmVhdHVyZXMoKipwcm9jZXNzb3IoJTVCaW1hZ2UlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpLnRvKCUyMmN1ZGElMjIpKSU1QjAlNUQlMEElMjAlMjAlMjAlMjAuZGV0YWNoKCklMEElMjAlMjAlMjAlMjAuY3B1KCklMEElMjAlMjAlMjAlMjAubnVtcHkoKSUwQSklMEFzY29yZXMlMkMlMjByZXRyaWV2ZWRfZXhhbXBsZXMlMjAlM0QlMjBkc193aXRoX2VtYmVkZGluZ3MuZ2V0X25lYXJlc3RfZXhhbXBsZXMoJTIyaW1hZ2VfZW1iZWRkaW5ncyUyMiUyQyUyMGltZ19lbWJlZGRpbmclMkMlMjBrJTNEMSk=",highlighted:`img_embedding = (
    model.get_image_features(**processor([image], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, truncation=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>))[<span class="hljs-number">0</span>]
    .detach()
    .cpu()
    .numpy()
)
scores, retrieved_examples = ds_with_embeddings.get_nearest_examples(<span class="hljs-string">&quot;image_embeddings&quot;</span>, img_embedding, k=<span class="hljs-number">1</span>)`,wrap:!1}}),Y=new o({props:{code:"aW1hZ2VzJTIwJTNEJTIwJTVCZG93bnNjYWxlX2ltYWdlcyhpbWFnZSklMjBmb3IlMjBpbWFnZSUyMGluJTIwcmV0cmlldmVkX2V4YW1wbGVzJTVCJTIyaW1hZ2UlMjIlNUQlNUQlMEElMjMlMjBzZWUlMjB0aGUlMjBjbG9zZXN0JTIwdGV4dCUyMGFuZCUyMGltYWdlJTBBcHJpbnQocmV0cmlldmVkX2V4YW1wbGVzJTVCJTIyaW1hZ2VfZGVzY3JpcHRpb24lMjIlNUQpJTBBZGlzcGxheShpbWFnZXMlNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>images = [downscale_images(image) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> retrieved_examples[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># see the closest text and image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(retrieved_examples[<span class="hljs-string">&quot;image_description&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>display(images[<span class="hljs-number">0</span>])`,wrap:!1}}),N=new rt({props:{title:"Saving, pushing and loading the embeddings",local:"saving-pushing-and-loading-the-embeddings",headingTag:"h2"}}),v=new o({props:{code:"ZHNfd2l0aF9lbWJlZGRpbmdzLnNhdmVfZmFpc3NfaW5kZXgoJTIyZW1iZWRkaW5ncyUyMiUyQyUyMCUyMmVtYmVkZGluZ3MlMkZlbWJlZGRpbmdzLmZhaXNzJTIyKQ==",highlighted:'ds_with_embeddings.save_faiss_index(<span class="hljs-string">&quot;embeddings&quot;</span>, <span class="hljs-string">&quot;embeddings/embeddings.faiss&quot;</span>)',wrap:!1}}),$=new o({props:{code:"ZHNfd2l0aF9lbWJlZGRpbmdzLnNhdmVfZmFpc3NfaW5kZXgoJTIyaW1hZ2VfZW1iZWRkaW5ncyUyMiUyQyUyMCUyMmVtYmVkZGluZ3MlMkZpbWFnZV9lbWJlZGRpbmdzLmZhaXNzJTIyKQ==",highlighted:'ds_with_embeddings.save_faiss_index(<span class="hljs-string">&quot;image_embeddings&quot;</span>, <span class="hljs-string">&quot;embeddings/image_embeddings.faiss&quot;</span>)',wrap:!1}}),AA=new o({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTJDJTIwbm90ZWJvb2tfbG9naW4lMkMlMjBzbmFwc2hvdF9kb3dubG9hZCUwQSUwQW5vdGVib29rX2xvZ2luKCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, notebook_login, snapshot_download

notebook_login()`,wrap:!1}}),tA=new o({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS5jcmVhdGVfcmVwbyglMjJtZXJ2ZSUyRmZhaXNzX2VtYmVkZGluZ3MlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKSUwQWFwaS51cGxvYWRfZm9sZGVyKCUwQSUyMCUyMCUyMCUyMGZvbGRlcl9wYXRoJTNEJTIyLiUyRmVtYmVkZGluZ3MlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIybWVydmUlMkZmYWlzc19lbWJlZGRpbmdzJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

api = HfApi()
api.create_repo(<span class="hljs-string">&quot;merve/faiss_embeddings&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
api.upload_folder(
    folder_path=<span class="hljs-string">&quot;./embeddings&quot;</span>,
    repo_id=<span class="hljs-string">&quot;merve/faiss_embeddings&quot;</span>,
    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
)`,wrap:!1}}),sA=new o({props:{code:"c25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMm1lcnZlJTJGZmFpc3NfZW1iZWRkaW5ncyUyMiUyQyUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMkMlMjBsb2NhbF9kaXIlM0QlMjJkb3dubG9hZGVkX2VtYmVkZGluZ3MlMjIp",highlighted:'snapshot_download(repo_id=<span class="hljs-string">&quot;merve/faiss_embeddings&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, local_dir=<span class="hljs-string">&quot;downloaded_embeddings&quot;</span>)',wrap:!1}}),aA=new o({props:{code:"ZHMlMjAlM0QlMjBkcyU1QiUyMnRyYWluJTIyJTVEJTBBZHMubG9hZF9mYWlzc19pbmRleCglMjJlbWJlZGRpbmdzJTIyJTJDJTIwJTIyLiUyRmRvd25sb2FkZWRfZW1iZWRkaW5ncyUyRmVtYmVkZGluZ3MuZmFpc3MlMjIpJTBBJTIzJTIwaW5mZXIlMjBhZ2FpbiUwQXBybXQlMjAlM0QlMjAlMjJwZW9wbGUlMjB1bmRlciUyMHRoZSUyMHJhaW4lMjI=",highlighted:`ds = ds[<span class="hljs-string">&quot;train&quot;</span>]
ds.load_faiss_index(<span class="hljs-string">&quot;embeddings&quot;</span>, <span class="hljs-string">&quot;./downloaded_embeddings/embeddings.faiss&quot;</span>)
<span class="hljs-comment"># infer again</span>
prmt = <span class="hljs-string">&quot;people under the rain&quot;</span>`,wrap:!1}}),lA=new o({props:{code:"cHJtdF9lbWJlZGRpbmclMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwbW9kZWwuZ2V0X3RleHRfZmVhdHVyZXMoKip0b2tlbml6ZXIoJTVCcHJtdCU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSkudG8oJTIyY3VkYSUyMikpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMC5kZXRhY2goKSUwQSUyMCUyMCUyMCUyMC5jcHUoKSUwQSUyMCUyMCUyMCUyMC5udW1weSgpJTBBKSUwQSUwQXNjb3JlcyUyQyUyMHJldHJpZXZlZF9leGFtcGxlcyUyMCUzRCUyMGRzLmdldF9uZWFyZXN0X2V4YW1wbGVzKCUyMmVtYmVkZGluZ3MlMjIlMkMlMjBwcm10X2VtYmVkZGluZyUyQyUyMGslM0QxKQ==",highlighted:`prmt_embedding = (
    model.get_text_features(**tokenizer([prmt], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, truncation=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>))[<span class="hljs-number">0</span>]
    .detach()
    .cpu()
    .numpy()
)

scores, retrieved_examples = ds.get_nearest_examples(<span class="hljs-string">&quot;embeddings&quot;</span>, prmt_embedding, k=<span class="hljs-number">1</span>)`,wrap:!1}}),nA=new o({props:{code:"ZGlzcGxheShyZXRyaWV2ZWRfZXhhbXBsZXMlNUIlMjJpbWFnZSUyMiU1RCU1QjAlNUQp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>display(retrieved_examples[<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>])',wrap:!1}}),pA=new Ot({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/faiss_with_hf_datasets_and_clip.md"}}),{c(){U=j("meta"),oA=a(),rA=j("p"),kA=a(),n(d.$$.fragment),UA=a(),n(y.$$.fragment),dA=a(),u=j("p"),u.innerHTML=ot,yA=a(),B=j("p"),B.textContent=kt,uA=a(),n(m.$$.fragment),BA=a(),W=j("p"),W.innerHTML=Ut,mA=a(),n(I.$$.fragment),WA=a(),J=j("p"),J.innerHTML=dt,IA=a(),n(b.$$.fragment),JA=a(),w=j("p"),w.textContent=yt,bA=a(),n(Z.$$.fragment),wA=a(),gA=j("img"),ZA=a(),n(S.$$.fragment),SA=a(),H=j("p"),H.innerHTML=Bt,HA=a(),n(Q.$$.fragment),QA=a(),q=j("p"),q.textContent=mt,qA=a(),n(V.$$.fragment),VA=a(),R=j("p"),R.textContent=Wt,RA=a(),n(f.$$.fragment),fA=a(),n(x.$$.fragment),xA=a(),n(G.$$.fragment),GA=a(),C=j("p"),C.textContent=It,CA=a(),n(P.$$.fragment),PA=a(),n(K.$$.fragment),KA=a(),T=j("pre"),T.textContent=Jt,TA=a(),n(D.$$.fragment),DA=a(),F=j("p"),F.innerHTML=bt,FA=a(),n(O.$$.fragment),OA=a(),cA=j("img"),zA=a(),z=j("p"),z.textContent=Zt,hA=a(),n(h.$$.fragment),XA=a(),X=j("p"),X.textContent=St,YA=a(),n(Y.$$.fragment),LA=a(),L=j("pre"),L.textContent=Ht,NA=a(),n(N.$$.fragment),EA=a(),E=j("p"),E.innerHTML=Qt,vA=a(),n(v.$$.fragment),$A=a(),n($.$$.fragment),_A=a(),_=j("p"),_.innerHTML=qt,At=a(),n(AA.$$.fragment),tt=a(),n(tA.$$.fragment),st=a(),n(sA.$$.fragment),et=a(),eA=j("p"),eA.innerHTML=Vt,at=a(),n(aA.$$.fragment),lt=a(),n(lA.$$.fragment),nt=a(),n(nA.$$.fragment),pt=a(),iA=j("img"),gt=a(),n(pA.$$.fragment),ct=a(),jA=j("p"),this.h()},l(A){const t=Tt("svelte-u9bgzb",document.head);U=M(t,"META",{name:!0,content:!0}),t.forEach(s),oA=l(A),rA=M(A,"P",{}),ft(rA).forEach(s),kA=l(A),p(d.$$.fragment,A),UA=l(A),p(y.$$.fragment,A),dA=l(A),u=M(A,"P",{"data-svelte-h":!0}),k(u)!=="svelte-1qlbcgs"&&(u.innerHTML=ot),yA=l(A),B=M(A,"P",{"data-svelte-h":!0}),k(B)!=="svelte-zwp9uq"&&(B.textContent=kt),uA=l(A),p(m.$$.fragment,A),BA=l(A),W=M(A,"P",{"data-svelte-h":!0}),k(W)!=="svelte-sn5lc0"&&(W.innerHTML=Ut),mA=l(A),p(I.$$.fragment,A),WA=l(A),J=M(A,"P",{"data-svelte-h":!0}),k(J)!=="svelte-1wmuyvg"&&(J.innerHTML=dt),IA=l(A),p(b.$$.fragment,A),JA=l(A),w=M(A,"P",{"data-svelte-h":!0}),k(w)!=="svelte-1gyk1gq"&&(w.textContent=yt),bA=l(A),p(Z.$$.fragment,A),wA=l(A),gA=M(A,"IMG",{src:!0}),ZA=l(A),p(S.$$.fragment,A),SA=l(A),H=M(A,"P",{"data-svelte-h":!0}),k(H)!=="svelte-1t8sl7t"&&(H.innerHTML=Bt),HA=l(A),p(Q.$$.fragment,A),QA=l(A),q=M(A,"P",{"data-svelte-h":!0}),k(q)!=="svelte-hqeotv"&&(q.textContent=mt),qA=l(A),p(V.$$.fragment,A),VA=l(A),R=M(A,"P",{"data-svelte-h":!0}),k(R)!=="svelte-jxb7vn"&&(R.textContent=Wt),RA=l(A),p(f.$$.fragment,A),fA=l(A),p(x.$$.fragment,A),xA=l(A),p(G.$$.fragment,A),GA=l(A),C=M(A,"P",{"data-svelte-h":!0}),k(C)!=="svelte-1ik94z"&&(C.textContent=It),CA=l(A),p(P.$$.fragment,A),PA=l(A),p(K.$$.fragment,A),KA=l(A),T=M(A,"PRE",{"data-svelte-h":!0}),k(T)!=="svelte-uwozqd"&&(T.textContent=Jt),TA=l(A),p(D.$$.fragment,A),DA=l(A),F=M(A,"P",{"data-svelte-h":!0}),k(F)!=="svelte-1rpqt4z"&&(F.innerHTML=bt),FA=l(A),p(O.$$.fragment,A),OA=l(A),cA=M(A,"IMG",{src:!0}),zA=l(A),z=M(A,"P",{"data-svelte-h":!0}),k(z)!=="svelte-dx7tpa"&&(z.textContent=Zt),hA=l(A),p(h.$$.fragment,A),XA=l(A),X=M(A,"P",{"data-svelte-h":!0}),k(X)!=="svelte-l7920"&&(X.textContent=St),YA=l(A),p(Y.$$.fragment,A),LA=l(A),L=M(A,"PRE",{"data-svelte-h":!0}),k(L)!=="svelte-17oljg4"&&(L.textContent=Ht),NA=l(A),p(N.$$.fragment,A),EA=l(A),E=M(A,"P",{"data-svelte-h":!0}),k(E)!=="svelte-19kef5w"&&(E.innerHTML=Qt),vA=l(A),p(v.$$.fragment,A),$A=l(A),p($.$$.fragment,A),_A=l(A),_=M(A,"P",{"data-svelte-h":!0}),k(_)!=="svelte-14p0fu2"&&(_.innerHTML=qt),At=l(A),p(AA.$$.fragment,A),tt=l(A),p(tA.$$.fragment,A),st=l(A),p(sA.$$.fragment,A),et=l(A),eA=M(A,"P",{"data-svelte-h":!0}),k(eA)!=="svelte-1duibn7"&&(eA.innerHTML=Vt),at=l(A),p(aA.$$.fragment,A),lt=l(A),p(lA.$$.fragment,A),nt=l(A),p(nA.$$.fragment,A),pt=l(A),iA=M(A,"IMG",{src:!0}),gt=l(A),p(pA.$$.fragment,A),ct=l(A),jA=M(A,"P",{}),ft(jA).forEach(s),this.h()},h(){MA(U,"name","hf:doc:metadata"),MA(U,"content",ht),jt(gA.src,ut="data:image/jpeg;base64,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")||MA(gA,"src",ut),jt(cA.src,wt="data:image/jpeg;base64,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")||MA(cA,"src",wt),jt(iA.src,Rt="data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwgJC4nICIsIxwcKDcpLDAxNDQ0Hyc5PTgyPC4zNDL/2wBDAQkJCQwLDBgNDRgyIRwhMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjL/wAARCAFEAfQDASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwD3PYKZdv5VhIw4PQfXpU1ZfiG9Ww0K4uX5WJS598KTj8elAHLWrm51S+u+qRsLWI+y8ufxYkH/AHK24vlhUHgnpWNpVs1pptrA5JlEYMhPUufmcn/gRNaD3JXU7ezXGGheVyeoAKqMfXcfyoA3dNQbXc9zgfhT724C/u16nqR6UkTpb2zKM5QDORwSRng9/eqOWlkJPJJ/WgA52nB56cdqhkI4UfU1Bpk7XFh57Pu82aWRDnOF8xgo+m0CiaQljg8nigCS0uUuNSkgLApFsDY5OSCefwwfxq9fShpSowAvGB696w/D8a7tQuxyJbuQgnvtAjH/AKBWixLN1ySaALFkgafcRlVBJzUrOJZgAABnoOKyopnfW7iAORFZwqHUHG6STJAOOuEAOD/fq6H2nrzjNAD7mUGUiPgDjjIqzYRNIGkkLFegyT1qgitLIFXkk4rbjRYIVXPCjr/WgCC8ZIYwFGHPfPSqKSTSSBFdsk4ptzMZZSx6dPwqeB4rOD7VOdqs6ogxklmYKBj1JIAoA0BEqLlnY4HJJrOlvAzkQtgK2CAckHAPNTanex21vK7uBHGpdz2CgEmsDSA66VC8wInnBnlBGCHfLEH6ZA/CgDW8+Un75xT2nfIUMcnAPPeoogArOT8qjOfftVO3SK2ZxCu1WlaQgZOWYlifxJNAGjd3BhQBGJYDk571i3Gsi1mt0ubp0NxMIYgFLbmIJA4Bx35PFVru5a41sxq37m0jBPP3pHB/kv8A6H7VqaXAZ51J+6OWPt/9egDdtYdsQaTJdueSTiqMWpQy6xqNr+78uzWIMP4tzAsSeem3bjjrmrdzcbPkU845PpXP3uoQTCdLeaJ5Vby5jGQWUgDKsR35HB7GgDO1fVypuLsyOkS/dRGwTzgAe5OAPc1C95cQ2zTOzl1QsyByckDOPf0zWZcMbzXrezHMdrH9qlHYsSVjH572+qrRqGqy2t/BYW1hLd3M8LyqEdEVQpUfMSRgEsBkA/Q0APsUvn0mxSa+nS5DRzzPvLF2DBmU5PQ8j2FdLEd6jDsSep3etc1A+uyMANLslJGcG/Y8+nEdaCNr4UBLTS4COpe5kkJP4IKANzRzBdXV3cmZmt7eTyUJc4d1PzsB6A/KPUqx71ipfzak91eyM6JJcOsMRyoSNCUHHHJ2lj/vegFV0i1yKIQp/ZNsi5wI0lkABJJ6lfc9apFNZudSnjbVLZEt41Rmhs+Sz/MRhnOCFC9j97pQBecvuJDuQScfN0/WqFhFcxrctcuxmmuHYANkBc4TH/AQOPXNNew1FXEZ16XLAkL9mhDEDAJBx2yO1U9TsJrPTLq5j1PVHnjiYr++XlsYHyhcYz1wKALOnyNcLcXZdys0xEeW42L8oxz3IJ/4FVgTBpGQOdygFhk5AOcf1rMi0MW0McCatqZWNQiqsygYHHHy1Bp+nR3FvJcPd37CaRipN04JUHavQjsoP40Aa7zqkkMZyWlYqoBz0BJJ56DFT7yvR29eGx/Wuel0YPqqAXOoxwpASsq3jk7ywBAJJxwB9avLpZUY/tXVCMAAeeufz25/WgDTN2ySxxmaQSSE7VDnkAZJ+g7n3HrUOp6neW9ukNrcSi6uXEMGHPysQcuRnoqgk/QDvWHpmmC+L6idS1QI7FbfFyQTEDwScfxHLD2Iq+dDjeZJTf6kZIwQrfaiSoOM9u+BmgDfivryNVRby4IUAAtIST2yT6+taT+Ibh4UVEVGAALdST61xQsri01+xKajfSRSpK0kU025G2qoU9Bg5btW4Cc89aAOnstdiS1P2tpHnBOMADcP/rVWHiGdrpGKgQg/Mg7j6+tYeSADnj6c0AH8OuKAOm1HX4UiCWeS7dXORtH+NZUes3cbljKXBBGH5AzWa2SeOlHJHp7UAWm1K6diTcygHsGIFTQXMjHDSufctms4AD/CplO3BHHtQBfmBkjBB+Ze/tV/Qb0pMIGb5JOOexrLSQkdTQj+XMCOAfTgg0Ad0ADTsVU0+5F1aK+fmHDfUf41bFAABS4pKXNACYzS4pKKADGaXFJS5oATApCOacetMNAABQQMUUp6UARsB1xUL4zVg4qBxQB4/wDE2V18VrtPBtY/5minfEo7PFEY/wCnVP5tRQB7JXM+OSP+EejhbhJ7y3hc+itIoP5jj8a6fFY/iNFk0xUf7plB4OOnI/kKAMOJ983PUtn9aSwJn8R6jM4OyBYrdR6gKZGI+u8D/gNMtSWuFP1qxMx+1W8EeFeaXfIwAB2JgnP1OxfoaANV3by1RjluWfgDLE5PT06VFNL9i02+1A4xa28kwz0JVSf6UqguwA5JP61Y1ayhudCuNOmLCK5iaFyhw2GUg4Pr6UAZOnxiy0Syh7xW8a59woBpu7aNx5A5P0przu93LCAPJhVV3d2cjJ/ADb+JqDUsrouoSDIIt3VT/tMNi/qwoAuaMht/DenIQRJJAs0ueDuf5j/6Ea07CLzJi7D5U556ZqsyhAsa9EUKv0AxVoTrZGK1wDJJE0rHOCoBUDjHq2PwoAqCzht7++uYS4N3MJZVLEruChcgdshQCOnFOJH4np601pNzFQevSqWs3r6fpVxcQqDcACOBT0aViFQfTcwz7UAbOjOlyJJ48lEdogxHDMpwxHtnI+oNW7+cqmwHk9fpRp1imk6Tb2SNuW3iCFj1Zh1Y+5OSfc1m3U5dyx7dBQBRt4JYZbtpZ/NeeYuvGBGgACqOe2CSe5Jralsbeeytxchj5EqzptYrh15B46jtg8VmQIXcHuTWndybVEYPQc0AYviC0udX0e8sradIZ7lPLEjqWVQSN3Q91yPxq4SM8LgZ6dqQHLEnp0BqWLasm9xlV5x2J7UARXE6LmBHBaMjzAP4WIBA+uMVAxEcZc9h+tZmji5Ww33iMl1LLLLMGxksXY5GO2MAe2KsXku2NUB5P3qAMy+uTEq+WoMs8qxpgdWJAJ/Bck+y11D3I0fQ5bwIHlYARIeNxJCqPxJGa5KCI33iqzthyttA07Z/vOdin8hJXS67Eb22SGFwgimidcjIYJIrEfjtxQBPczkMxLZIzz61iyhGkdkRFZ2LMQoBY+p45PuabrN99nt41Vws1xOkCEnoWbr+AyfwpTy3BwD69hQBnafZzRX+qTzIAZ50MbAg7o1jUD6fNv4NV7qInxhpLKSGWzud525DLuiG32OcH8K2raVJ7SOccLIu5c8cEnB/EYNUwok8VWY6gWU5/EvFQA7WtZj8NaSl89u1xJPPHbRRK4UsznA5PbqacbzXN6o+l2MRdiFDagWPAz0EfXrnBxUniCNJrexhKAhtRthyORhwx/8AQakCyza+25HEMFsNjEHazOx3YPqAij/gVAFYvrzfOLXS07FWuJGP4ERj+VVILTW4pboq+mf6RKZiSsjbSVVdo5GR8oxkit1nVkypyD0IOQfxpETauT1NAHPT2WrpdHUJLnTQY7coV8iTaFB3E538E4GeD0qs41gqC1xYoxUEp9nkIBPPJ3j+VbOrEssFoOfPcs4HaNME/gTtX8apyZLMSck96AMXUJdTtrC4uTd2ieVEzYW2ZgSAcDJfr26UltZ6lb2sFsL63RIkCZFsScAAckv/AErRubeK6gkt5kEkcgw6nOGGc02WVo3hQDcZZNuTwQApYn8MUAVjb6l21SPngZtAf/ZqZHFqEk0kS6rgx7dxFmg5IzjJJ56E8d61Vj3ALjA9aoaJmewN2QR9qmkmBP8Ad3ELj/gKrQAi6ZqAQKutTBRwAltEpA9PungfSl8PLOdR1eC51Ce7eCdFRJVUeWhQMCSFGScn8AK17INNeTwmMiONVAcg/MxBJA9QBjPufaorBP8Aifaw2MHdAufpHn+tAEcyt/wlEcJVdi2DSq2OctIqn8PlFXShx05pqxh/E0hI5XTlAP1lY/0q6YwTigCoo5+nrT/LIOe1SGIqxwKmiRXXa3BP86AKpTvUZUgnPT07VZKlWwfxFMZCMnGfWgCHac5B4p4zjp9KcBwB696MY47UAAJUenPWnNll9fSmEYHPSgNjjpQBr6BfmG5ELthHwMHsa6wGvOwzRyh049/eu30y8F5ZrIfvj5WHv/8AXoAvUtNBp1ABmjqaMUmKAFNHNFBxQAhNNzzTu1NPWgBe9BNIBS4oAaaaRTyKQ4oA8Y+Kny+K4h/06J/6E1FHxWB/4SyH/rzT/wBCeigD2esjxGwXT48nBMgx+RrXNYPidiLS3HYyHj6CgDDsm/0jr0BNEFyzzalfINxiItYBxyw+9g+7sAf9yqMl6mnW09265SGNnx3OATgfXpVqwtJEXRtNLZlXN1cDuxAOfzkkB/CgDqtKtVjiUHBEahQfUgcmmazdx2sMk0rYihjMjn0AyT+laUUYiiVB2HP1rkfEsourm2sRyLibLj/plH8zZ9iQq/8AAqAIdOWUWqNOAJ5cyygfwsxzj8OB+FTajHNImnWkcbOk94sty4+6kUWXGfTc6qB681NENzFifck1YibfCsuCPMAYA9Qvb9OfxoAnt4jPcKp5Gct9BVG4dZvEWozqSfKjitBycAgF2x/38UH6Vp2jJBbzXcjYVQeTwAAMmuc0h3l0uK5lUia7LXTg9QZGLAH6AgfhQBeEp8+JASMkkn2A/wAcVr2MIllDMAUXB5GRnr+nWsGCdZrq6hCc25RWfPBYqGIx7Ar+ddVp8Zjs1yME8n8elACX84jTbuxnkk9AO5rm7K8fULGC5KhROvmKozwpyVz77cE+9XNcU31pd2wlaIzRPCJFGSuQRke/NQ2UQjjjjRfljVUUDjgYAGKANOzjCfvWGFUZ/HtVeaUszE988VFf3JW/t9PRsJDH9puCO5OVRfxIY/8AAB60iMJGyDkDk0ARJcb72S2Q5MKKzkdmbOB+Qz+Ip9zL5K4dsE8ke1Q6VZSxXd607KXubtpQwJP7sKqqDkcEBcEVBqs4e6kcHKg/L9OlADjMqQtMSSqjJA5PsAP0qnK5kdie5NPmiL2K5YqTMr4H8QUg4+nSoEOWGeTQBd0ewW1vb3Ut7NJcLGgBHCBAQAPY7iT7mrc8oXcXYBQMkngAetOH7q1jTGMAkj3NY2syk28EIPNxcRREeq7tzf8AjqmgC3M6kkHk+4zg1Q1N3GnvHGxEtyy28ZHZnIXP4Lk/hVoAu+SOvWmXFo8uoWTkkRW6vIeBy5UKv5Av+YoAmcKkaxxjEaqAoHYAcCqlp83iZu7R2APHUbpD/wDEVbCF5AAMknFZ+h4k8R6rc4+9Eiq3qqySoCPb5M/jQBe1UE3mjR/3r0H/AL5ikb+lSaze/wBnaTPchlWVsRxEnA8x2Cp1/wBog03UwW1LRQO905/8gyVZneJxkgMqtgZGRkHrz6etAEccAhijt0OUiUJnuQMc/WpyASAOT6d6rJKxkAC5ycn1qCG9WC01XVXwYoXkCjHURDbgfVg+PrQAtuBdXl/dZyikWkR6jCcv+bkg/wC4KozKVcgdQelaNlAdP0u1tpTmRIwZT3Zz8zH6liawknMeixX1yrB2ha4lUjDKTliuD0IzgCgCUDPX0zkU1LI3Go2sxbHlBwVxnJYAA59hn86arlI4BPxLJtXA6btpJH6GtOyUIzOeuMfQ96AGyRBGIHA6ZoitQIQFQKijAUAADHTgdqaGnkvroOm2BSixE4y5K5ZuvTkAf7prRgAERUc5yfXmgCCLCspB6VUth/xNtYfGAZohn6Qp/jTrKdruS4mXH2dZjFD/ALWwkM34tkD2X3ptjltT1lP7ssJH4xL/AIUAOtWP/CUSg9DYJ+kr1pOuG9DWTAwHilhjB+wKf/IrVtkAsM9CKAIWTcue461GmVc81ZCEEjpUZXPTqKACaPeokHX0qFV6g/lV2MDZjsarOmxzjtQBVdSjEelBORkcgcVPIoZcjrUAGDg0ANz7U0kqfYdqkcbW4OQRmmkZUHuKAEOGX3wfzrR0LUDa3gjkOI5PlPsc8Gs0HacD8KjfIO4HB/qKAPRwfel5rL0S/F7YqGP7yMBW9SB3rTBoAdS02jmgBxNNJoNNA5oAdmk60AUtAAOlBo96D1oAQmjHFApccUAeNfFXcviuDHQ2aH/x56Kt/E9R/wAJLb/9ea/+hvRQB6xWT4hVG0vcwBIkBB7jg1rVkeIldtMAVSQJAWx2GDQBweoxPcyWVoqFklukMxHRY0Jcg/UqB+NdT4cj+1anqF8RlFcW0R7bYwd2P+Bs4/4CK5+4ufsVvLclc+ShcKf4iBwPxOBXZeHLE6dottbtzIqDeTyWY8sfxYk0AacrhImcngKSTXCI/wBq16+uCcrbqtqh/wBo4kkx+cY/4DXWazdx2ljI8rbY1Uu5PQKBkmuS0aNxpVu0q7ZrjNxKD1DSMXI/DIH4UAXp9zJb2iKxa6kCORxtjAy55/2Rj6sK0JHLMSBjngDoPpVHTyZ7+6uc/u4V+zRAdCQQZD+eF/4AatlvnUd80AU/FMzL4fawjOJLpltuOuZCFP5KSfwp6quQqDCqAAPQdBVLU2+06/p8B5EIkunHbIGxf1ckfSrcsq28EkzHAjUuxPQAAkmgCLQ0a8Msg/5b3Urc/wB0MUH6IK625lEFscdcYFc/4Pt2TSrNnHzLboTn1IBP86be3rXGtXu1/wBzaqtuoB4LkB3P1AKD86AC4kLPgHn+prR02EM+T0QZ/E1k2w82RiegrdjX7LpzueGYf/qoA5iCSSfUdYuJUkSR70oA6Ff3caqqEccg8kEE/e9av2n3WYcg8Z7VQ1G7a3tXkVQ8pIVFPRnYhVH0JIz7VqInlRKnUj+dACmRoo3kHBK7c1zGoP5+o6faDo8rTv7rGBj/AMeZD+FdFeOBbqvckk1zkaO3iG4mZGEcdrHGjEcMSzM2D7YXNAGlduBtQdFX9ahgYCUFskZ6VDI5ZieuTRZSrcZZPuhymeCDgkEj2yCKANS9vUhtHuZThI1LMepx/j6VQvrM3U9nJ5hQ2sxl24yH+RlweePvZyO4p1/B9utzCZDGu5GLAA5CsGwfY4wfY1YALkn1NAD4EH3j0HNPL7gT1ySPyqG9ulsNOnnIBEUbSYP8RAyB/SiygeO1ggc7pFUB2JzliMn8zmgCzbLsDTHqDhfrWRp1uljrk1pbBhELSNlDMWIzLMxGT2yxwO1amo3ItoVVFG4ssaA9GdiAM+3c+wNVLJCfFlwSOlhEQT3HmSCgCLxPdPp0en3qKzyRSSsihSSzfZ5dv1GetTwxC3tYIFfekcaruzncQOT+PWovGF6LMaTOUlJivlLeVG0jKvluDwoJxzjpWZB4n02d3Je5jVDtxJayqzHqeNvTGMfWgDobRMuGIzyKZHpcUHh5NMuyJl2FZCMqHYksT1yCTz161VtPEekmNXSS4kXGQYrOZs/klNu/EMLEBLDVHBGQRZSAD8wKALLlppTkkljk1j+I1Zore1CuwnuYo3IXO1d25iT6YXGT61estXt/mnew1XCA8DT5Tz25x/Wsu58QQGYtJZ6lGCfvNZSEfjgH+VAD5bWW41G0n8wCGHzCybeWZlCjBzwAN2frWmAYwFH41hp4isF53XPX/nzmOP8AxyoLTxRbTXV49wbuOIShIQ9rIAyhQS+Qvck9eyigDeu7n7JbS3JXd5SlgvTcRwF/E4H41oWsEsFrHC0haZUAaTqS2OTj65Nc5eazo12bVEv12RzpNKghkYuFyQvC8fNtJ+lXNT1Wy1PTTawXOpQMzJvkgsJy20MCQCEGCcYz2zQBoafYLp2m21irbxBGI95GCxHUkZ6k5J96hsBjXtZU91t2P1KEf0qrP4jRZj5ek6zLnkhLBhgf8CIqXw8bm7vtT1O4tp7aO5kijghnQI4RIwMkZOMszY56CgBoGPFrf9g8Z/7+tW3/AAqaycAeLZV7/wBnr/6NatQHKEenagCfG5Aw6jg/SoXUq/qOtSQHDEHoRiluUKEZ9Mg+ooAamQc+tNmQEEk+1JE+OvQGrEsZC49QCD2xQBQXHIPQ0x0446461IQeo6jig4ZfcUAQEblGPpTAQrVIRtYDHWkdeMgcd6AGOo69j3pnBzUgAZSvcdKhPytigC3pV+2n3wYn923DD2/+tXcqwdQQcggYI6EdjXnDjGGA/Gup8NamJoPskrfvYxlM9WH/ANb+VAHQAUtNBzTqAExRilpKAFoxnrSUooATH5UhFONNPSgBoyWFSMMCowdrA1KSCM0AeWfEiLzPENsf+nRR/wCPvRVj4gj/AIntv/16r/6G9FAHo9UNafbpE57kgfrV+qerQifS5lJIwQcj1BoA89u2WfUNNsTyJ7lXceqR/Ofw3BB+NeloAqgDoOK4HQtKkvPFVzd3MDpBbqLe3DYBkHDO/wBCdoH+4fWu7lfy4Wb0H60Ac94ls49Xs5bKaSRIZGUPsONyhgSvPY9D7E1m3d0bW3lnVA0ijEaY4ZyQFH4sQK1LtiSM8k5zWIw+163BD1jtVNzIP9o5WMf+hn/gIoA1bK2Fjp0VvuLFFwznqzHkn6k5P405G3SMewFOuX2oFxghRx/OooseSTngnHXtQBmWR+0a3ql0eViMdquexVd7Y/GQD/gNR+IZSnh3UCD8zQMi/V/lH6sKdohLaJDOeHvHe6bPXEjFgP8AvkgfhVyTTU1Yx2shYJ5scjBeN2xg2D7ZAz7UAdFp0aWemgkYAHP0HArjrBbuK0c3oRbue4lnlCNuALOSADgZwu0fhXX6tMILVYlOM8Y9q5QlpbiKJCAXfLA5ztHXH6D8aAL1izSazaafEcExtcXBxkiMfKo+pb9ENbWsz7USEcA8kewqPRdJitbu71MPKZbtUV1ZgVUICAV4yOpyM474zVLU5/Ou3I5UcCgDELpfeK7HTt4H2eF7+Re5wdifqzH8BW+7fePoKksYxFpskxUB5WC7sDO0c4+lV3JZwPU0AU79iWSMHnjPPOKrEqkbE9SOKrXjzSeJQpicW8FqSJCPlaR2HH1Cpn/gVOlfIAB70AUNTvDZafcXIGZEQ7F7sxOFH4kgVa0yAWVpDbBs+VGELdNx7n8Tk1SvLU3j2wLlUinSZ1Azv25IXPpuwf8AgOKvo3zDPTuPWgCZLlWvpbRVJaONJGbjA3FsDHr8pNX0QqBnr1xUFugd9wADYGSAMkCrfXLdhwPwoAzdWs5tR02a0hlWKSTaQ7KWAwwbpkcHGDg1qohDbyMEgmo40LuAOtWJAT06fdH0oAyJibnXoIQci2hM7f7zEon6CQ0RW234gQzkAhdIcKOckiZc/wDoQqxpljLHqepXMxQi4lTyiDkrGqKADkcHO84HHNVte0DTEuTqt9JezyGPb5LXTeWoZlwAgIwMgcZwTyc8UAWNV1GC2Sa4nlREjQsQWAJAB7Z61g3Opwad4Tvpxf2xvBbu5CzqW8xgcnGexPbsKludF0drizsrbTLJXkm8yRhChPlx4brjOC2wHnvW1/ZWnRKANPsx6/uF/HtQBWu9a0zT4NPtBqlokbMAzfaEAWNFJxnPfAH41QfxXoU1xIP7VtPlIy3mgg557H86vPZabBc/aIrK2jmClQY41UgEgnoPYYNP8OWU0l3L54UPPcPKwViQqjCrzjrtUZ96AEuvF3h+00dIYtVglmlYArEC5yR0wAawD4htGbKRXzj1WxmI/MrWz4u1EzeI9LtYy3lxySngnBIjYZ/Ddis+6ufIg3hd0jMqIucZYkKP55oAq/8ACQ227H2bUs9h9hl5+ny/zqeDWi7kppWsOBzkWpB/IkVbB+bOcj1qZL2Kz2b0d2lkEaBFzyQTk+gwCSf60AQS+Ipd4/4kutggYANuv/xdXrLX7mRWiHh7W3JU4Ahj6/jJVWadmkYnOPSrenaw1lcJI670BwQOuDQBVm1XUXkJTw9ejP8Az1nhT9A5p0esaurKg8M3bljhfLuoCAfc7hgfgas3upRzXTNChCE5APWkttT8mVWZCQrDOPrQBUtBqE+uPfX2mfYmNuIQReLKGG8sPlAGDyec+2K2x0wepqre38DTMYclScjPGO9Qi/CkA8c8YoAvodpxWiY/tmmEjmWEnI9QaxxOrDcGHXvWro1ztuChIxIMfj2oAxnnMbYxz1FX7C4a8RrcgB1Ush7nuR/UVHrFh5F020fI3KkehqtYM0FyrjIIOQaALMiFWz2Pr61EQVPoD2Fa1/biWIXMIGxxkgfwt3rLHQgigCMjI9/WkGMYNOOQSD1pCPlyOuaAIsFXz3/pTZo8fMBwf51YwHXI4IpF2srIwyD396AKBweO3cUkMr2tykyNhlYFTUkiFWIPY/jimupYYH+cUAd9ZXS3lpHMnRh064PcVZFcf4b1H7PcfZZDhJDhSegb0/pXXg0AOoopMGgBQaKSjNACmmnOfanE03rQAw9aUH5aRjWDq/iGOxJhtwss2fmBJwv5d6AOY+IAVtdt+Rxar/6G9Fc14r1qWbUoGZULCAAk55O9jnr70UAe2VXvwTp0wHoM1YqO5ANlOD02n+RoAyNFTLSyHthc/U81auZ99rGQrL5gDbTwQPfms0yNbeFbyVCVkdGVCOoZsKp+uSKt3KiJkgUkiJBHknJOAP1oAoXJO7BwOAP1rI8OEXIkvj0vZjIpPXygdqfQFVB+rGjxffDTfDt7ctIIiYtiOTjDMQoI+hOfwqPw/GtrYxgRGIuvmGMnJUkDA+oGB+FAGldzEs79cZIB745FVNULWHhi5KZEggKIc872G1f/AB5hUpXzpVTrlgMYznBzijxTtQ6bZA5Et5EHH94IGlP4fuxQAKiwKkCABIkEa46AAACtXR2iimXzHAkmJSJT1Ygbmx9B1rIVizEk9au+RPY3S6lKYzAtl5MChjvWRnLOcEYwQEAIOfl6c0AN1m68y6ZQcgcY+lZukI93q9ywwUjCQJj+8fmb+aD8KgubpFWS4mbEaKWcnsACTWv4NtGWyilmUiZgZpAeSHcliPwzj8KAN6/uYtM0qSV22pEhJP0Hp6+g7mubYl5RkYJPI9Ksa/cG91iHTkOYrVRdXB6gnJEa/wDfQLEf7A9ayLqR1vtLjXeFlvkRyoJG3a55PpkAUAddcL5GnQxjsBx+GayA2ZiewzWnq0uzCDsBWGlwrGYK2WjGGA7EgHH5EGgCldSjzW5OM1TL7gafKdzZ7nnBqsIpftRkMuYigCw7cbWycnOfpx2oAlAI9+eRTZpRAqkgks6xqo6sxIA/xPtWlY2ckjo5jzCT8xPAI70t2LdfEGnwiNQIY5bt8DJyMRr/AOhuR/u0AWbJGWCQumCcbSeDUrHaoAqCfU4IyTNLHAgBO6Vwv86xL3xTYxW081tcfaXiRmC28bSjcBgZKggZOByaAOj02UzwzSAZUzNGh9Qp2k/99A1PPIkbxRM37xwxRe5AAJ/Acc+pFYmmX9zYaZbWq6Fq0jxRqjMYkjBOPmPzuDycnpVe31PUrzWL25j0SQrAFtFEt3Gu0gB35BPJLIDj+760AdVboCyg8DqT6DqayNZil1R4wrEKkySkAZ3BSCB14GQKrpquutdXECafp8XlQozmW7dzly2B8sY5whyM9xzQsWrray3NxqVpbRKpZ/JtCxVQCTy7n37UAVtPiuJtYu7oIQsBFshPTIAZ/wAywB/3a07udgSFByOCQMjPesuw0x4NCinvtT1DfJG1zMkcwiUM+Xb7gB4z61di0DRZ5Y4Z7Jp5pIRK3nzSSbQSByGY89fyNAFCSXbzI4TJ53ED+dbegalpluk8lzqNnEcbVD3KKSO/BNaNv4X8PWls00mj6cqKpdmktkIUAcnJBx61Nex6ZYxxBLS1jErqiGOBQSzYwOB/kUAcTqGo6NDORBqtrKpyQEmViOfYms1ru2vtS06OOSRoFmaSWVLeR1UqjBeQp7kYx6V6PEm5wF+Ueg4GKfdXbbRFCzBV9CeTQBxFxc2kUypC91PwSdthOMH0Py1QfWrXzpU/0kCIKHY2soAYj7v3euMHn1FehQAxIZSSC3A55x3rDtzdaRpLCbY+pXd5IQobKvJI525PoqAE+gQjtQBy39t6YBlr2NFBxmQMgz7kgVbtrm1vATbXUE4B6xSq2D+Br1C2iMcAUktnnnvVe40HSLxi1zpNhOx7y2yMf1FAHnzoysQVO7OP8aaSQORgEc9QK7abwZ4ZnXD6Dp49DHAqEfQrgj8DVdfA2iRkeQt9AB0EN9MB+RY/yoA5IZIyB7YpVQ5yeMetdTL4ItH+5qmrJ6fv1cD/AL6U1WbwPcrxFr8xX0ntI2/9B20AYWSpxzg0sU8sLgo5BByCDg1pS+DtdRgY9R02YD/npbyRk/kzfyqu3h7xBCcyafbTgd7a7wT+Dqv86ALVxrU93aqkyIXU8OOD6GqQu3U5HH9aHtLuFf32k6pGfUW6yr9cxs38qyZ9WsbaUxXM7WzjtdRSQ8dvvgdaAOqsNeEVu0FzEXVjwQcYBqrPexeaSgYr6ng1nQI1xCs0A82Ij78ZDL+YzQ4wD2xQBdN6jDJUg09LlXx61lnpzyaepIGB19ewoA00kCscNwelBODkd+aopIRjPXPftU6TBjg8GgCzOgkiEgGSOoqmeOB19auQyhSVPQ8VVmXZIeeO1AEBzHIGHUHP0rutHvhf2SvnLrw47g//AF64YgFSD1PU1d0W/bT75dzHy3O1x7dvyoA70UtNBBAI7806gApMYpaKAGk0UpppIAJPA9aAKd/ew2Nu0szgAA4Hdj2FecTytPLJI3BZiT25Jq/rN4b3UppFcmMNhMnjA71m5+YEHjNAHL+JiF1CEYH+pH/oTUVJ4ix9vjy3/LIf+hGigD3qq9+xXTLg9DtwKsVT1U40m5/3R/MUAZMp3WujWmcGe5WRvdYw0h/VVH40+Vi0jE9zmq6S+Zq1sAcraaaXI9GlcKD+UbfnU8amSZV6kkCgDH8RwwXDRWlzEksYVHKOMjcDkH6g4IrLEtz/AGtbFMi1EcnmkEZLELt49PvHjvit3XNPvHv5JtgMTYCkEZwBjpWaLOWPBfCgnuaALGjH7X4ifGTHbqsZ5+UsRuPHqBs596n1lIp7+Kd1JkgdzEQcBSQVPH04qt4SlRUW5PBunkuMnuGzt/EKFFZ5vWute1NdxMdv5UKjPG7aXb/0MD8KANS2Qyyqg6lgB+NX/EkblYQrjZEvKZ5yeM4/SotETzbxWHRearAtqpvL7fhbiTbCeceVGSq/gW3t9GFAHOath44LMEg3U6xMB3Xlm49NqkH613egTwi0kG8eaGJZe+Paubg8L317r0VzIVS1t7dvLkJyHlc4IAHPCr1OB8/FdLHYxaZbMgbfLJ958YOB6e1AGVb6dJb/ANoPJcCe4vLl52k27cA4CJ1PCqAB+eKuQaFdHaxlRAcHuSP0qa2TzbpEI6t3rdJAFAHL63cLDORI+RGoLseOAOTXO6M7vpi3Mm1Ddlp3Z2Cqoc5GSTgYXaOT2pniO4vNeubq1gaK0tJb4aaGVd00xGPNOTwihQ+CAScdRXVaZ4W0a0hFzJYpczjlZbw+c4A6YLZx+AFAHHXN/bK5S2337AnJs1MiA+78IPxamWia1ql3Jb21rBbGPbvMpMzLuBIyFIUHAzjceMV3cpDfLgY/ugcD8KsWGnQ6Vb3ckZcyXcxnkLnOGKquBjsAowD0oAw5dIu2ASfXr50UBQtukcCgfgpb/wAerKuvBFtNdPemO8usxBN015I+ACTjlu5PTp7V0U9yFvrW1C5e4ZgOcbQqkk+/YfjWpKPItVjB5PJoA4rTvDVhbXAkTS7WIqc7jCCSR7kZrb1eN3s9MskUFbm+jMgzgeVHmU/qgGPergBZhjk5xj61JqFtFJPaSEuJLQsUKuQMsu0gjuPY9+aAKN3Bc3EpKPkE8LnGaoaRoV3tvJBCYDJdys4kdjkghdwz2IUHjg9q2oJFF/awspLSsQAOwCliT+WPxFa17KUiwOp/lQBgwWUVs8koRPtMqqJZAMFwudufpkgVk+LJymmQacpIlv5Vh467TksR/wAAV66KNDLKqjuQKuhraW1iuFRXRQTEzJkjtxkcZ5/CgDhL95J4ktju/wBLnjtzjjAZhu/8dDV0un2Er65e3km0xyrEiAHJVV3E59yzn8KZdWcd3eWk8hbfbSNIig4UsVZeeOwY4961bO5C6i2nhRvjtlmdu43MyqP/AB00ALrNk2o6VJaLP5Kuyb2C7iyBgWXqMbgCM9s1g6vcNc+I9HtuzSTXLD0CJtH/AI9IK6O9m2qEB5PJ+lc89jK3iKPUd6mGO0eAJ3DNIrE59MKBQBburpLK1eZyQoABxySSQAB7kkCnwReZMAeg+8R0A781kapKZtT0qyB4knaZgD2iUnn23FK23dLOCNHcCW4YhFPUgAk8fTk0AJK4dsDhRwB7UlvYR3V/BO4JMAbb6DcBn8e2fQn1rOFyZNZ+yr9yK3EzkHuzFVH/AI65rprCLZACercn6UAWQKdSDpS0AIcUhA/wpaDQADrRiiigBKOKXtSe9ACEU0oGyCoIIxgjORUmaSgDGuPC2h3LmVtLt45ieZYFML59dyEH9az7rwcHXFtrWoxY6LMUuFHtlxu/8erqaCKAPObvw14js5SYUs9ThIzlGNvIPwJKn8xWe90LRhDqMM2nTHgLeLsVj/suCUb8Gr1TFJJEk0TRyIrxsMMjAFSD2INAHmg+bkHjHBHII9RSgkc9x09q1dU8CBJxceHbldOJzvt8brdj1zsz8vvtK1mT6drmmqX1DS/PiAy02msZgAO5jID/AJBqAJUk4HPQc0+Vw8YbuOnriqVpcwXkQntpUljLEb0OQD3BHY+oOCKnJOOO/UmgBrN79aaSc5HBH8qaT270gOAQD+dAHb+HtSF5Z+U7ZliAHPUjsfw6VtjpXm2mX507UY5j9zOGHqp616Mjq6BlYFSAQR0IoAfQeKTNITQAE1g63qP7mS2hbsQ7A/p/jSa3rgty1tbH970Zx0X2+v8AKuZlu2MJjxyWyzHqR6UAUn46evaomAyP51Oxyck84qLHOaAMPWojJdRNn/lkB+poq3qij7RH/wBcx1+pooA9lqhrMirpUqkEmQhVx65zV6kZFdfmUHaQRnnBFAHGaKLkTapPcx7S8kUMJ4+aKOPIP4s71sWDq1+sZPzhS+MdhgHn8RU2pt+8VR0C5x9azdGlDX2qXvJSIpaoe2VyzH/vpsH/AHKALup3Kqzlmwkakk9cAD2rF1m2mudImMDhJH2wpnglpCEA+vzZ/Cl1Ui6lt7Hkm5k3OB1EaEM3T1O1f+BVq3EW7UdFs9uSZnupB3xGmB/486UAVX0JdOsy7TgpEoVVUYyAMDrXO7YxPJMiKHlILsAAWIGBn8OBmuv1WUXtoUicBSTtIOQwBrlNQs7m1066uUKl44yUHXLkhVGPdiBQBOuovaabdxwNtu7gLb257iSRgoP4ZLfRamvNa0TQWttOuL6G2IiAijYnOxRgE4B446nvUR0eK08R2NkJGnOnW3nysenmMNifoJT+Iq7o0Iv/ABVfXZ5W1VLRD6HAkkx9SyA/7tAGrpviXw/e+Vb2Ot6fPISEVEuFLMT2Ck5yfYVLfy75iB0HH+NUPGNpE9lpsrKE8rVbRzIgAYfvQBzj1IB9qklYtIx9SfzNAF3TIg0zSnB2KQOehPtWjO4WIn2x+JrO0FvN097kgYmmfYduCUU7Vz9dpIPoah16S6abTra3jcxSXIa4lDABI1BbnnPzMFHGeCc0Acb4bzqOtb9pKWjXM2SOGlnncDB7kJHj/gdehXZENssY4GAPwFc74HTzdBsZCeGV5l9w0jMPzBBqz4luCyw2kb4e6nSAH/ZJLP8A+OK9AFy2QTXKg9Bz+VWb+TkJngc4pbBMK0x4zn8hVSd97se5OaAM+2tLi48WQXDRgWlvaOFfIy0juueO2FQdv4q0tRuVQySMfkjUs30AOaswRi3tS54cjANZ8p3sQQCDkEHoR3oAZoEklzYWt1cY3vCszAAAAkAgcfXFTSuWYk8kkk/jUsUSWempHGiohAVVUABVA4A9h2qsSNzFmwqqSxPQADmgBmmAXHieUk/LZ2YB/wB6Vifz2xD/AL6q7dy+ZITngcD6U63tLe0juruBnLXxSRi/YBFUADHAwM4Pcmq4BeUL6nFACXcrWWiXV1H/AK4p5cOOpkY7V/8AHmFXJwtrbRWsZysKKgJ7gACq2p2ss99pNusZ+xwSm5nkzgZjH7tPqXYN9Ept1OieZNK+I0BZmPGABk/lQA/T9txOSrAhGIYjsR1FXUsYYNUutSDuZZ4Y4WUn5QELkYHvvOeay/Bki3HhiwvCwMt7F9rYcZxIxb/2bFXbvUUN7NYpy8UKSOfQMWCj6/ITQBDcSl3POc1Az/LjgD0pc856VDLKscUszZ8uKNpGwMnABJx70AWLTSree+jvZYgZ4FZI35yobBYD2O0Z+lZ1zdC98WXQBPlafbrCMggGSQ7mx9FVBx/eNdImLe0BYYIXJHfOKwZJNzkk8kk0AOsrFH1SWcE+ZOqI/PAVSxH/AKEa6gAAADgDgVjaOmXkkPYBR9T1rZFACg0ppKKACiiigAyKUEU0nmjNACmg4xRmkoAXgUlBNBxigAJpCRimkmvLPEvxIu2vdUstHgcwWLrCbiFv3kkm8IQnBGNzYHBJKN2NAHqoIpAw3EZGQBx3x9K8S0v4ma61/e27zxymZ1+yl4T8oC4L4OODtYkDgOpAwCManhjWZ7PVtQ1EKbhp1C3UpO9Yyh6bwNzlfnJA4LNgAAA0Aet4ppHemW1xFd20VzA4khlRZI3HRlIBBH4YNSjJ47mgDm9W8GaZqmoNqAaezvWXDz2jhGfHTcOQ2PcGsXVNN1jQ9PaTy4dYtI8F2ih8u7jXOC20ErJjqQAp9Aeldfd6tp1lIkV1fW8MjuEVHkAZmPQAZzk9AO9SXN3b2yKZpAofIU9c8UAebW93bXkKzW0qyRtnBGQRg4IIPII6EEZBp5HHHQ+3am30Cf8ACYSPEFCCy3MVAAZnk6n3/dnmnlDyDwM0ARyHIyOo71v6T4s0rR7MW2r6rbW0ob91FK+ZCuP7oycenFYgQnAA5OMD3NdF4P0WyhvdV12G2iSW8uDEjqoGUiJUt06s+9ic8gjsKAL6+NNCcZW5uGB7rZTnI+oSn2/jDQLq8S0j1KMXD42xSq8bNkgYAYDuQB7mtzcf7x/OsHxT80ekAjOdVtuT2Abd/QUAc5qsQt9Sniy3Dk5bqc9/xqiSMYxgVr+JWH9tS54wo/kKxie/egAJxn+WKVAenr2pucdP8mpolLMMetAEF1bb2jPX5O/1NFac8K/u+P4f6migDvjSr91/wpDSr91/woA53XbtLJbi6k5jgjLsPUAE8e56CqOkxSWWjQW8v+uI3zH1kbLN/wCPE1U8TzfatUs9Lzn7ROZpgP8AnlFhjn2LbF/GpNR1A6fpVxebd7xoWRf7zE4UfixA/GgCfQYhqOtX1+eYYWFrF6EJy5H1ckH/AHBWpGwm8XXLHpaWEafjK7Mf0jWpPD2mnStCtbQtukVAXY8lmPLMfqcn8aq2kV1ZHV7u+WOOS8vCYgr7sRKiomfc7ckdt31oAbLsRlSNVSMAKiDgAAcAVpWFsrW2ZEVt7A4YZ6EEfrzWC+nJe6tZXZml3W28RxAjYWcbSxGM5AyBz3NX/Ft+2j+D9RuInCSiHyYWJwBJIQinn0LA0AY+lTpPFqGtSHCX1w8wY8YgT5I//HU3f8CNaHgqJl0eOeRSJroG5cHqGkYvj8MgfhWTrECWnh6PSLb5RKIrCMDspwpP4IGNdfpUYW3ZgoCk4UegHb8OlAGX43fy/Cl3IOTC0c+PaORXJ/JTVbU52t7S4miAMgUiMf3nPCj8WIq5r8Yv7S7syTiWF4eO25SM1jaTOdVi8OqRk3AS6l7jbGgY/wDkQpQB2NnaJY2MFnGPkgjWNfoAB+tZWrTbYriQHHlxMR9QCa2nOyNj6CuW12cRaNqMx6JbSsfwRjQBP4QAg8JadJjgWUAB/wC2YNRXNkLnVrS+eVibVZAkWAVLPgFs+oAIH+8avadC1j4Y021I+dLWJT9QgBpIF8y6QHoDk/TrQBPf3Z0+Gxto42eS5lEYIUlUUKWZiQOOAQM9SRVaMiWbapBIbBAOSDgcHHTtVy/k3SbQcAADP15rJ8IQXRhvLi7t2gllvbiTY/XbvIT81AI9qANrUZUggUO4Ucck4GSQAPxPAqhGnmzBO5IFUvE04a+0uEnMb3o3D1CRu4/8eUH8KvafcIt/DEQWlkjZwuPuqMZY+2SAPUn2NAEZvjeXl6iY8i1kFuhH8TBQXP0BIX6qar6hDNcaTPFAju9wyW5KAkqruqsx9AFJJNSR28NlEYbdCse95MFixJdizEknkkkmtexQxWxcjrz+AoAZfyDeFHAHb0rIsS134sWME+VZWvmvjp5kjEL+So5/4FT7+/SJVkJ3iSZIlCkHLMwUc/jk1q6ZawwCa5VFEk5Xe4HLBQQufpzigCW9l2qEHfk1St4ftEuCAVHDAjII9KS5lLysc8dh7VY0513yIPvqqsfQAkgc++DQBdWCGOUyJEiSbBGWCgHaM4GR2GSQKxrlIft01ykSCeRVR5AMMwXO0E+gycfWlu76STxILQb0htbQzOdpCu7kqoz0OArkj1ZahdtzfWgCL7Qi3KwFv3jIzgf7IIB/VhTtSiK6MImGDd3MFuM+jSKD+G3NU7EG68SX/UrbwwwYAzgnc7fmGSuln06C7jtVm3n7POk6ENj51zjPtycigCLWLgRWresjY/Ada5X7TK13IhiKxKqlZSwO5iTkAe3HJ9a6vU7SG6tWeSQoIQzFxyFAHNYaaQWWFzOMOgfAXkAgHpQBraPIxgUKODkk/oK2BWdp0AiiCg8KMZPetEdKAFHSigUUAAoPWikxxQBTu9UtLN9k8mHIzgAkge+K5bTb241PxLqVnNrN3bsAs9qtsyhGhOVA2uhIYFfm5wdwIx0rW8Q2AkaO5UEEja2B19K5VIXt/F+izKgO5biOUk4IXCMPr8ygf8CoA7JtL1QEeX4hugB2ktoGz+IQUv2PXEbKa1bOPSWwzn8VcVqg55pe/NAGMYfEvQX2j497KXP/AKNp8Mur2qyPqTafLEqkh7ZXRg3YFWJyPfI+la561k6zLiJIR/EST9BQBzut+L7vSdIvL4QxO0UZManI3OcBR1/vECuB8L6UivawE5ER+1TPjG9jlYyf/Ikn1YVp+O3W6bStGD7VuLlbifABPlRkMc+3U/8AAKzo5pdP0gXVzrsVleXFmb4RG2jVSoUBVBJPI+UYBz1oA7BfDumysoa2jdCgiVCAVVTkYA7Z3EEjrXD/AA0tHh1GxnkmY2glFu9uXyCsrTFHIz3KoAevWugGt376fozu4sra+G9ru1ia7cIIixwgQgEnAH3sc+lcn4d1pNM1RrOO8lNtLZWjwieHa6TQyKyR8AAfKzjBzk96APVvDlxr8mg6fbWVtp8dtBbLCLq5lZmLJlGAiUDgbcZLDNbA0OS4B/tTU7u8z1ijP2eLn/ZTBI/3mNc/8Lb25uPDNzBdymSa21C4RnJyzZkZsn/vqu4oA4fxTpds+qeHtLtbWKKAXD3DRRxhVZkjbbkAc4JB+tbV3pzZs7VASqKRntknJq1d22/xBplyE5jjnUt6AhcVpnpQB5tdoqeJdTUH5YkggH4BnP8A6GKYx+btgUTSCXWdZmHR791654RVj/8AZCajYnigCG+uvsdjcXQ6xRM6jpkgHA/E8V6L4dsTpvh3TbJs7obdFfPXdgE/rmvNrmA3j2VivJu7uKNh32htzfohr1tRgADoBigBTWF4k5Oij/qKwdfYMa3SKwfEpAbRT/1FYB+jUAYfiTB1mfPYKPr8orH2k/jnFbPiAg61cevGPyArLUjOP50AM8o9cdvzqxAuW55PpViVNkaDuVFMt0w+R1NAF5xwnH8NFTLEZFBGKKAOuNA+4foP50hpR91h7UAcNfW1umrz3wTN1LGImcsThAxIUDOAMnJwOeM9KqgDVfEemaSh3JDi/uh2VVJEan3L8gf7FSX0ubuXnoxAH0NX9FurW0S7uGRBMEBDEYL4OACfqcD0zQB1vCp6AD9BXOajcmebr8q8AVqalcmNfKBwT94j0rAJ3SexNAF3RstqTJ1WOESMfdmIUfoxq9rtpaX+n+ReQJPF5iSBHGRuUhlP4HmoPD0Z3ajOSCGuBGvGCFRFBH/fRfrU+qPhlTPGKAOO1u/S11S3nkG9bGCS72f35GIiiXHqSzge9d3p0D2WnW9vK++SOMCR/wC82PmP4nJrjdI0u01zWry7vYjIkF8nkDcQubcYBOPvASNIcHjI9q7a5fZbuc84P60AY1xIHuXcdN2ax/AMLtPqLyIyLp8smnQ5GM4lZ2IHphogP92tTG+QDGcsB+tVPA9u+m3PiXTJLlrhrfVGmErLjcJo0kxjPbJFAHT3r7bcgHBJArkvEZJ8M6vxnFlOcf8AbNq1DqU19d3i+Q0Vtby+TEXUq0rAfM2CPugkAHvgnpiqGtxl/COvvgkCwmAPuUNAGxdSYjhjH8MSj9BVGaUpDGiNiS6nS3U9wCSzn8EV6llcsAevyj9MVUdw/iDTrYHmC0nu2HoWKxJ+nmUAXrh97s3qelalsBBZA/7OefU1hTzeU8WE3tJNHEqg4yWYD9OSfYVomW4233ngpGLjy4R/0zCrz+Lbs0AcLDp2o6ndanJNrMkxttVcW8c0SmJQFUgfLhsfOVOGwRng10elXcdnezrqMDWmqXqqsQZt0UyqDhYn4zyWYqQG5zggZrF0qaVfD8VxCM3Wp3TNDuGRumlO0/QJgn2Wuk8XG2XQXguIROjFVRS2z94WCodw+4QxB3DBGMigDnNa8V2ttPZ2Nok11e6g5SBbcA7Ru27mJPyjOcE9SM9K1b613W7Nr1w9wy7ALGHctuhYgKvbzmzgEtx/siub+H3h6K0vV1KZ7m9nEhtIJWTARVXa0pBPyhtmB3AwO5rrPEnnXF9paJG7wx3qtMVGdqhXIJ9t+zJoAx9d8Pz3mkm28Pxw2l6s8UyeTthDbGB6gcYznkH070eBvF1/qcF7o2uoiaxY5w8abFuoQ5QSKP8AeUg4744HSuh0bT2TVr3UZZA5kjSKJduPLQAkjOepbJJ9MDtXn2v2smm+NDrFozGbTp5fNjHAkt5JFdl+ubgEehWgDrH1+2lvGtdPSTU7pWAeK02ssZPTe5IRPoTn2qGzudenku7lJrLThPqaWYUI1w67AFIDEquOHJ4PU1v6FaWqRK1pFFHbnMirEgVSW5zgDqepNWRolpEsawh4lS9a+2g7t0jFi2c5wCWJwMY7UAc7r91rGmtaRxX41Cee4WKO3kgWNWHV23LyoVQSTg9hjmtAMC5IPAqlvW91W71LeGWMtaW+DkAK37w/UuMfRB61ftYhNIiDjcefp3oAPDmkzWd3qd3PIspu7ozRgLjavloiqfcbeo9a27e8t7mMSRvlCxXOMchip/DINErrbQgDgjhcVyb2iaL4WvorR52EcUnlGVy7BpCVVRnsGYYA/nQBbubuSXwUsrMxk1N1RA3JxPKAB9AjfkK0ziWU4/iOAAOgFSXCJb28FmgBSBAqgjONoABHvRaIGm7kD+dAGhEgRAAOgqUdaQDGKUUAKKSiigAoPSig9aAILmEXEDReo4Poe1cBpuoR6hrwu47HUJrS3gwJY7bcCznJGM7sgIARjg5Fddrt7PZQRm3YBmYgkjOAPSuN8CXsy+KvENkqRLHLei5fCYLFkAPP+8hIxxye9AHaDX7PHMV+hPZtPnB/9AoOslziDS9Tm9/s/lj85Ctag4FFAGS13rkpxDpVrED3uL05HvhEP86xZm1ltWzqNzpZgMZAitVkLqcjGWY49cjA7V1c7+XDJJj7qk49wK8/1Of7BYXWozE7YlLk92bsOe5OAKAOI8VzXw1/VdVtFZnsfItLdCAyyEklgo7/AC+ZnP8AfFdFqenaBpfh+NoYrS1g1ApAbuRciKKQEsQTnaNuQAMDLCsS6gitdBtI1v4bpbd/tF1dQNujacuucEHouABg9M1v+DNZOoeGo45YTBJE0kJjGCUUMdgwf9krjPHFAHT+Dtd0nVb+5tNIljlt7GGIebCwKAMWAQH1AXn6iqFpp7ve3dpIpQXNo0GG4O7aGU4/4A9anhCK+0vQLy51q7kMZneZHu9ivFAFGA5T5cghjgcAEVzNr4jnn+Ieo3MxuPsEZgiW38sb7ceWWWVuCcHdIGH3lDjOOcAFXQpdY0nVNcttNubaHdqZnZJ4DIGWSNGHRgRzkZBrv0/4SgkBm0QD1AmJ/LP9a5Oa3trPxVPqFvIrLfMWlQnDGNFQLIAeSFOQeOj57V6JGwaNSrBlKgggggjHUeooA43xH4h1rQlUA2NzcuyRxRJbuiszkKAWLnjqSQOgrrbCd7qzhmlQIzjJA6Yz2zXO+JrNb7xBoVvj5g00o467VCjJ9vMzW3qkgsdAvZE4EFpIy44xtQmgDziybzbFLg/euGe4P1kdn6f8Cp5Iwc9DREAtnaoOBHBGoH0UClIHOT26CgC54atxdeMLTIyLS2ln+hbCL+hevRxivOfDOtaTo+uaoup6hBazStDbRecdq4WPfguflBJm4GQTivQ4pEmQPE6yKRwyNuB+hFADz61g+J+E0d/7uq236sR/Wt059Dn0rlfHV/a2el2nm3CpOuoWkscK/NLIFmQkIg5Y4zwAaAM3XedZuD6Nj9BWajDeAfWrerTG41O4kCPGGIOyUAMvA4IzwfUVRBO4evbFAGxcjOO2FA4+lQwHDjIp4O+1VjxgY/KkgGHz3FAGnCfk49aKdD9zoevaigDpzSjo30opR0b6UAcJeWDC7kG8Ebic/U1NDYRRy6eH+aSS4Mp9BHEN36tsH403UJwb6bB4DkcVLbSrPqUhXkWtpHCDno0hMjf+OiL86ALN9chY5JpGwACzE9AAOaqadtZInkcmMIJHZuu3GSefQVV8QyMdNmgQ/PPtgXPcyMFP/oRNW7yIjQbwR8POFtIh0O6VhHx9AxNAG54dRk8P2TSDEk0fnuP9qQlz+RbFVdQbzZ3GSByBz04rbISNMAYRVwoHYAcVx2nPetayHUDGbgzyFzG+9QCxwAcDAAwMEdQaAIvDPhfVdF04QaZ4hcwoSFW+tFmIzycMCp5Yk8k9asayfEumWNxczaxpc9vHG0rK+nOjKFUk42yc5rZ0C5a5jvFAAigm8lT/AHmCgt+ALY/4CazPHLlvD19Ep5ki8kfWQhP/AGagDO0+w1/U3t5H11bISIHaO2sFDKCoOMuz8jpnBFdRo2h2+irctHPc3NxdSiW4uLpw8kjBQoyQAMAAAAAAU3So1E8hA4Vdo/lUuv3b2WhXc0JxMVEUR/6aOwRf/HmBoArXrl52z24FVdcUp4C1o45aynP/AI4wpdgjRYwSQihQSclgBjknvUniobPBuowjgmylA7dI2oAhjIeCMjugPHpgVZurG0gu/tscCC7kgWJ5h95kUkqOvQEk9Kq6UhlgsgPumFDk+m0VPql5FDdxo74aWXyY1HJYhSenphSSaAM5nEnifRLU9DJNcEe0cZH85BWn4ru2tdEu2QZlEDlPdiCFH5kVPp+nWzzQ6i8Km6iV0jkJOVViNwxnHO0du1YPjV5rqK2sbaTy5rq7ijDjqqq3mMw9wqHHvigDR0fTIENnCUDLYqvlE/wlVKAj3wSPxqXXIvtkscLOBbhgZkxzIo5C/TOM+oGO9TaVLFFMsBY+bMrFF5J2rjJz6fMBn1NUdWvBGt06sDLHC8oUdcAHH8sUAYWlz+IoruRYRp1jbw3Ji8zUFYm9kkLN+72kYHOAeSSDwK2Bes+oGxmCm4SBZpWjBCDLMoAyc87SefSnaRaWfhrwVbhlSFFgWW4kxyzBQWY+pP59q5qw1O/uJ7mZdP8Asl7cSqZXvjshtIhhYw7cbmIy2xTwXwSKAOntNFuf7Ta9m13VwsZEqWsQSO3Cnohwp3njkk5Ge2ax9b06a71O9aCVYBdW6xyTOgYIpwsjAHjIWMYB4yQe1XfD0V1on2vRLjUpNSiSNLq2uZDlikjOGTqeAy5HJ4bHaqF7YajrXiWWwg1B7SzXTtrGJdxMkrkZIPBwiNjPQtmgDo/BguB4R0uW9IFxLAjN8oXJI44HcjBIFa97OttA0hOAoJJ9AOay/tZbWrLTIsGK3chierBIQfT1kTpTPFM5XRr4IfmW2lIPvsOKAOf8NWwt/DGnxhAhljM7Af3pGMh/9Cra0uR5PELRKf3cFsGYf7TsQv5BG/76qpaxeXbQxjjyo1QfgoFXfDnyx6vfNn95eNGhPpEoT/0JXoAt3tys07orA+W20gHocA4/lVLUUzZ6ZbMB/peowhgccrHmU8en7vmqenxT29qxvHQ3U0zyymPJXczEgDIBIC7RkjtW3LdW/wBlUsoHk8qzD7uQQTn6Ej8aAGzSeZMzepzV6xTamSMH/Gs5AWcDuTyK20UKuB35NADx1ooxR2oAKM0UGgANJS/WjmgDI1yMSQRkjIDEfpXK+F7EweM9QcHI8lC2cZy8krDoPTH9a7e/hM1o6gZYcge/Wud8LRebqWqXpH37gxgjuI1VB/48HoA6ukJorkPHurvb6Umj2SNLf6ofJKRAmSK3PEsw9NqngnAyR16UAWdX8XWcCy2+mhtQvAdrLbEFIz/tyH5VPtkn2rlX0u51GRJdbnhu7VHEkenIGECsAQS5JzIecDIA6/LWpd3umaVYRxzNDaadBshjLnaqAkKoPHBPc+vJrLudfsonkEcV0bWCUxTXcUJeKJgAfmIJOCCCGAIx3oAx/E7z6lfrosNskNuyrM7lCiLGpBIXjaAOAeQcngcGrtjpOpQSWt5pD2M8dxbn7RDdOyIZRlwd6gkEguuSMfKPat2LQtP8TWSS+Ys6TwFUuYnLLtJOCOcEgkkZHBpj/DTw9Hvm1GaWbBLusZ8tWB4K7ASFX2ABzzmgDEvPEmo6rqFva3T2rWygTRR6XHJdQoQVBkdsfvmUkbUVdoYgsTjFdV4b8JRWif2teW6HWbpR9oyzYAH3QwJOX6FiSctnnFa+i2GjL9outNsY7dpcK7KuDgDjAzwOc4GBnnrWWuu2OntLFpCy6nKx+aQPthQj1kwdx9QoY+uKAHXegv4guYpL9/KubVsRT28myWIHrtIPTgZBBB7im2114hj1CSztL62v0jzxf2/kvxxjfHx+OysWXVYbK3vbu78TafpczRHy44pI1Ac5xnfvcjOMkAfSuntoNU/0OWHUPtsDojG4ZUQuCAckADg9Rx0oAoaLrp13xnLbXNi1re6VDNDNHv3rlmiIZDgEqRnBIHQ9a2vFLbPCOtt6afcH/wAhtWeqNB8UC+2MJeaNgED5i0U3OfbEoqz40k8vwVrJODutHjAPcsNo/UigDkbhIo5fLjPyKoGffAqOEBpkBHBYZHqKWXdvIz0OOnerekWT3t6qoOAcsfQUAaemaR/aVzJLcxobcvukUqCJDjpgjntnPar0vgXwzLL5sekxWsp/js3e3bP/AGzIreggS3hWKMYVQBipTQBw2neEIZ9T1iFtY15bSCZIUhTVZscxI7HJO7q+MZ4ArWTwzpHhuyur3StOiivdhJunzJM2eDl3Jb8M4q7omWu9bbGCdRYfUCKIf0rXIDKQRkEEYPQg9qAPL3JdixOWJJJPJJPJNNBJPOM+uK29c0VrCUzIQbeRjtA6qfT/AArJVAGyRxQBoRfLYqMc0kRGSegzTUP+j4z0NLGMjpyetAGtZyAQnt839BRUNucRnHrRQB1veo5zIlrM0SF5Ah2qOpPapKVO/wBKAPN7a31KS1Wa+sZoJmVneIqWKDJ4OM5IHUjv0qz4YimTQxdXKNHPeyPdOjghkDEBFPuECAjsa7m5l8mFnJ6DA+p4Fc3cSfIxPJPrQBi35NzrWmWvUCR7l/ZYxgf+POv5V0FxFuvdBscfene8kHoI0OD/AN9OlYWip9u8SX8+ARD5dmnsQPMf896j/gNdHb4uPGd64OUsbKKBR6NIxdv/AB1I6ALusXyado91euMrBEW292IHC/UnAHua53TrVrPTre2mbMwXMrf3pGJZj/30TVzxTcJNcaXpAYF7icXMyd/Kh+Y5HoX8sfjSRASXUSjnLjOfrQBe8MW09poUcd1CYrhpp5JEPJy0rtnPoQeD3FY/iz97AEBHzXdspz6CZCf5V15OFJ9M1yGs4mEJ7C7ibH/bQUAdDpK/6Oz92Y/pWZ4nkL3uhWY4WW8aZz2IijZgD7ltpH0qe6nlt9NsbS3cpc3s6wo46opyzt9Qitj3xVvVZMKqjjJJx9KAKEA8y5jQ85YA/SneIwJrG4g6hrd1x9VIqTS1DXTMf4VJ/HpVfVJVkuJBnr8ooAg8IP5+i2FyTnFlEc+pMa1Df6dBfanaXszSmW0Z2iVZCqlmxyQOuMcAnHqDT/BwaPwTZORtb7NGhB4IIUA1aiAe5jTrlgD+dAGzEDb2QB6qpJ+uM1w73AvPEszkgpZwiFT6SSYZvyUIP+BGur12eRbIRRKxMjYYgHha85srqeCGEQWU17qOoSG5S1i4JVm+VnY8IgXb8x49MnigDstEljk1nWrl3ULp8cVpktgIdvnOT6f6xAT/ALFYb6ul3eySaVYvqBnVIDcO4itzgtgByDv+8c7VYe9Tan4R1i8tRfajcQahem4ilfToiILMAMCexaRsADdJnjOAOMakFlcXmt6W5jRbe28yaYBwQr7NqAcDI+ZjnA6CgCHUrbxFcQxxTz6LAiMrLEltJOAQQRyXXkYBHFUh4XvtcmjOpX+nTiDcUV9M3qpPBO15CCfcg47YrZv9Sil1qWwUgyRQrK/PQMxVfz2mtKw3Q2E0yIHkCkqhbaGIBIGSOM9M44oA5mXw/fWEqmHXUiEcYiVYtOhRFUMWwAOBySelGhab4jjku72DU7GWSWU/Jd2RXcF+RfmRhjhc9D1qbW5bi5soEMJDz3ECTohL7FLrv5A5HUE4HHNdVYQmO2yfvOcn+lAHMaLfava20l5qnhe58+SeeUvbyRyvGGfoFJDY2qnQHIAOO1UdY8R6ddW9zbPctaTyxsipeRPASSCB98AH8DXbX0gitmOcE8f1rlrmVJGMcgDoQdysAQfwoAfpJJt7SW4PAiWWUnB6KC2SOvfOKl0Z2j8G6VvyJbiIXMgPXdIS5z+L1QsvCVhewXptHn0xpUMTmzYIjhlIYNGQUOfXAPoRUF3qGoaSqWt7brdW0CCJLqzU5VVAGXiJJ47lS30FAGmCXmz2FR6vHLLpLxxozNJJEuAMnb5qbjj025J9qoHU4WsbWa3uI3W7u4baOVGBBLSAHn1xnjrW852nHYcUAXrJA9wT6ZPrWsKybZxDApX7znr6CtQDpQA6jFA60ooASlPWiigBCM+1GOaKCaAGSyrBFJM5+SNS5+gyTWZ4etBaaFZ5j2zSxiWXPXc5LsPzY07xEl1JoF5DZxebPMghCZwCHYKxzg4wCTnFaRAAwBgDgAdgKAM/XNXt9C0a61O5yYrdN2xT8zseFRfVicAD1NcrYtE7XU9xd2k+v3hDXccU6ubaNT8sC4PAXue7ZJ6isjx/a3XiDxppOlNIH0axX7XdQISpaX+EMQegBXA7BvfjA8R6xf23iKzsjbTWmlrGHtzpVkjymRcZ28ZjA4XIBBDHPXgA6vW7VEitLq6lt4re2nM7md1VTiNgOpxkFgfwrkYJ9J055ZtF8Q3NlDLL5jJZlZLdWOBwChVc8cAir099p0NsjX3hkwtJh/O1kRy3LkcjAmcY9RgMPbtWXdfEGy1ALZDTdS1SGJt4ZNsyIw6AKqqgx1GAcHoRQBb3eI/Dd0+oaUkMzmTzJo7XMaXAzz5lucqWP9+Nlbvg9D2aa/pcPhJfHEwuvsjxiVrYKHfcx2+X7/Nxzj1OKyreVp4IpjFJEzgExygB1J7HHf8AGudsfD9vL4JvmumublcXMiRPcOIllMjqrrGCFByQemM9qAOsXSfFfjGyjmu3stF0yYLLHYxFpWZSAR5uAAx9iSvqp61vWngHSI41F+1zqTKBxdSERj0AiTCAe2DXTRxLDGsSDCRqFUegAwKxfE/imy8LWEc9ypmuJpBHbWsbASTMSAQuT0Gck9hQBDrmj6euix6ZbWFtDDd3UELJDEEG3zFZugH8Kmue1/UdT03UPs2mSCe8uJNryylgkMfVnYA5OOAACOTUWq+N5ZrsmC11lIUI2wxpaIwYdSWkdj37AYrnH+xajaT3GuW3iUWrK7PsuVLEAk8iM9+oGMUAb9he3UXiPRpNUKG+guTEksDN5U9rcKV3KG5ysqIGB6Egg4IrrfGcX2jQEtskLcX1pExHUq1wgP5iuH3XerW3g23mniXV1vSJYzInmx2yuJQ0ijgNiKMHAwWbjrXdeLphFptpnhzqVmVU+onQ0Acpc20qXbwrFIWDlQu3k812eg6UdNssSAGeQ5cjnaPSprG0bebmfmRuQD/DnvWiBxQAYo46d6KTIVgTwBzn2oAyvDpMlpeSk5El/ckH2ErKP/Qa1qxvCWT4W0+VvvTo1wfcyMXP/oWa2aAKWq232zTZ4gMnbuUe45rgjhTk8D0r0r6155qkBtdQlgIxtbIP+yeRQBEJMAjpU0T8fTiqOc896ngJzjt0oA042+XknrRUKk4FFAHdUqd/pSUq8K3+7QBjeIL1LKxeaQ4jjUyN7gAn8z2rmb4XFxb2wSU2z70eYAZJAwWQHsT0zjpmr3jKYPcadYcH7RKGcHvHGC7Z+pCD/gVZZlZ2yTnJ6e9AGr4Q05rNJA7BnM807MM8mSRmHX/ZIH4VpeH4blbzXrm6t5ITcaifKEg+9GkaIrD2O0kVJpSrZaY1xcEICCzFuMAcfrWibhFkZDwVGT/n2oAz9bdI1jJChjkbsc444+lZEEzb2e35lRGZBtDfMFOMgkcdzyOO4qLWdRW+ld4mzFbs0bv/AAqwwWBPTjue34Vix6Rq3iayn+xr9msGhYRPNlPtbEHGQBkRdzx8/Tp1ANnS9R8W6raTXBl0eOyPFtdC2lJuQOrhDJ8qk/dJJ3DngEVyS6lqmqXF0V8S2FpawKGiae0RDIwYjzArNkRAqQGJyxBIwMZ9SvQLfTUjBztUJk9cAY7VzqwWt5qFuZreGZ45AUaRFYqfUZHH4UAZuk32u6z4gjtilrb3ekaejC4eNpLa4aZgPMjAIJBSM4ycgsQRxWlf22vvMRNrVmhA/wCWGnn/ANmkP8q6eW+himkiL5ljjErKB0UkgZ+pBwPauZn1HzZieuTzQA2Cx8TJZvLZ65ZggjIfTNzMAOQMSAfkKzorfXGvLS1uSZ7qRpJJJVh8pfLXAHy5OOWUZz612+mADT4j3YFvzNU7L/SfEmqXOMrbxxWaHrzgyP8A+hoP+A0ARJaDSNDgslPRicZJx1JwayY9Rgt9fgFxcLDBBC80pY43E/KijHU/fIABJ2ineI9ZkmvTY6YElmjO2SVsmKFvQ4PzMP7oPHciqHgSwa41bUdZn3XLea1vFcyoMhY8KQmAAAW39B+JoA3NTutXvtKu3so/7OgMTBJZ0zPITwNsZ4TOcAsSf9kVetLLSvDNktvbRCFDgMeWeQgAZZjksfcmr15d21jaPc3c0UECDLSSuFUfiT1Ncm+rXOt3X/Er02e6Q9JpiYIQPXLDcR9FIPrQB1cs6NZGYNlCu4Hp9OtY8WqWOlWs91fXkFsuPlE0gQsfbJ5/CornRNVv4Amo60IYFUB7XT0MSgccFyS7fUFfpVG38N6ZCVjtbSJJC2TMU3SN9WOSfxNAGVL4qtbmVmtI7u7ycbre2dlPP94gDH410UesX8WmKo8OalyuSzSQJ+hkNWLrSrPS7Ce9m8yfyIywQnAY9hj3OB1qtreqNaNYWUjqbqQqj4xjIUs5A9OMD3IoAzotUvZJwP8AhHtUJz0VoCce37yt0eKbG3TOoWuo6co/iu7Rwg+rrlR+JpulSoqz3UjYiiQszHoAASf61bub0yxR7AyBlDMDwRkA4PuO9AHP3niOHV5tmnXMM8S5AEMiuT+Rq7pWkNdK0t2jqvAUZwWPrj0qdPD2l6iDNe6dbSsfuu0QDg+oYDIPuDUc1tqekXNtb6ZqBuUnLbLXUN0gQKMnEoO8DoBuD8kUAbS2iwWrQ2yhCQcEknk981x8ySveXMLEFoJRGzA8Z2q2P/HhWtdeJhaYt9UtZdMnc7VklYNC3+7KOB7Btp9qx9E0nUri1aa5QJcTzSXEqFgQhdiQuQTkhcDIPagBF0fEz6jYvFBeR4ciRN0UzDgb17EdnHzD3HFZ03i/+zb6SLX7CTTYCq+VdkmWFm53KXA+XsQSBkdcEV1kthLZWhJbJYjcByAB6ms0hpGaPbuDDDKRkEHsc9RQBPY6/o0yREavYlWOcm4UDGfc1vDXdIP/ADFtPI/6+k/xrCsPDFqGMlnLNYOva3YGMseuY2BTnvgA+9J9svbZ/LE2jXwUkHzYHtnGPcB1P5CgDf8A7c0g9NVsP/AlP8aH17SIkLvqtgqZA3G5QDP51hjXLhV+bw5bu2f+WF1Gw+uWVf5Uj+Ibl0aMeF5WRgQVa4gKsPcbun1oA349a0uZQ0WpWbqehE6EH9anW7t3VSlxCwI4IkBBHqMdq85vLma3kH2bwlHbqeQI3hAyevAfH6VX/tLVZVQDRIAUOUMs8YK/TCsR+FAHqLzRxrmR1UepIFU5dWtlOEYyHtjpXAxRa5OwMaaXbj1zJK2fw2CpJ/DsxjeXxHr7pauR+4DLZwsPQ8l2B7jdz0xQBtav4503S5FguLlBcOQEt4VM0rEngBQDyegzip9I1a+1a4UPp+pWi7d2+6REXjsQGJz9RVHTrnw1p8PlaXaySoSDt0+ycISPVsAE+5Na8OuMwAi0i5iUnGZnjX9ASaAI5dJt0u9VvbeQSzzyx+aituMWEAIxngkYOD2xXmvi3SdetfENvq5fVbnRkV08qxHltGzYXYxQbtpwCW5PbA613lzb3EerzappFyLKe6Ci5jkiEsUxUYVyuQQ4HGQeQACDgUkkKyX1vd32n22p3ZJja5kiRfJjIJGFPUZ47nnPSgDzBI9kwT+w1lnlUstssoUvjGd7De7AZGfMZRzytdTpb6m1uV1CwtLFVAEUVtP5gAwc5AUAY4xjNX9ZkN54ytvkVI7LTmKogwoaSQAfpGRSDO4jPPegBYoi8qKOcsP51DpVvu8EWSn7s89sGz3D3SZH5ZqeKV4pAy8EHIP41n6Zeyx+GtEiPMX2iyLDHPEqnrQB6weST6mqepWsNzYzCazt7vEbFYp0DKxx0OQeD3q0jh1V16MAfwqlq6Xb2RNnIUkVtzY4LDB9fzoA8cTTNelSW7vNO8N6JagktM6oFHXgEqRn0AGfamaZomrtpOp6jp9hGjW0hkhmMsiSTIV+eVYnC5AHKq2AT2HfY16Gy1DXYL3WxHLFa2xOLpsxKxYBcITt3ff5xk+9FpdWPiPR9R0zSLODT7iaMQvcf2cI5BG45Axg/MucZIIByR0oA67Q/Bvhy10xLoWseoG5gib7Rewq8jIEAXGRkE9T3yeT0xJc+EPtCRm0v7qwEc8c0VuW86EFGDLlWOVBIGQrLWFZxeONBsYorbVLPV44FCiDULQwsVAwAJEJ57AsD7mte18f20CqviLT7rQ3JA82bElux/66pkD/AIEBQBrHWbrTs/23ZiKEdb21JkhHu4xuj+pBUd2rYS4ilgWaOWN4WXcrqwKsPXPTHvTYLiG4gWa3mSWJxlJI3DKw9QR1rm9c8HWl/bSi0hhCO4kmsZsi1uWBB+ZR9xif4l/EMOKAOgn1GytlLXF7bRKO8kqqP1NYHiLxXoyaFfxW2tafJdyQPFBFFdIztIwKqAAc5yR0qTQtP8NyI0dpoVhZXdvhZrVrWMSwn3wOQeoYZBHQ1ieKdOhGorA9gLexkAkhextoyXnByHm5U7VOMAHk8k8AUAdKNf8AD2jrFpk2tadBJbIsPlSXKKy7QAMgnjt1pz+LfDca5bX9MA9rtD+mar6Hqi6jBEmoW1vFqLr++EYyjsOMgkZweoB5HTJxU2rRwwJHHBDFE7EklFCnA+g70AO0rxRpGt6hPZaddm4lhjWSQrE4VVJIHzEAEnnABrL8V2+25huAPvqVY+45FNn0O+jkg13SZFGrRpskimYiO7gzny3PYg5Ktzgk54Jp1xqtv4h8PyzxxyQXVpMEubWbAkt3HBVgD+II4IwRQBzi49atxABegqoTt6/nT0cqOvFAGgGGBzRVUScdaKAPRKevRv8AdNMp6fxfQ0AcFd3cGo+OtQRCHXTLVLY4wQJJCXcfXCxjH1rf0e2i3vII1G0AA47+1M1WNEu2KoqlwGYhQCx9Tgdfc1oaXHsslJ6sxP8AQUAUtYnEuoadpvUSObqfv+6iII/OQoPpms3WtattJtZLu7kAPJRM/NK3ZVHUknA4H1ptqbu41vVr+8tpICZVtbZJCMmCMH5uM4DOznB5wBXE6vpNxbeL7NX1WaK11GQE3LLHI6OjlwhLqdqljCqgELxggkjIB0ukaNczafbx6tGscSkyGxXBDysxZnlI4Y7iSFHyjvuPTvIUKRAE5OMk+9cpaaBqNxMfM8S6iFXn93FAhz258s1budIvrRA8HijVw5PCyrBIpPuDHnH0NAF7WmaaFYYWG/dls9hiq2laQu9biWQlkbIUcDPrWI+na+zZ/wCEkXd6HToyD9eev0IrRt9K8VRQbo/EdgWIyFl0r5fbkSA/lQBan0eWBNSmillurm/nDsWCjZGowkagY+Uc4zySxJ61hW2lX9xrz2bhYoo7VZXycnLuQPyCH867OxS8SyjXUJ4J7oZ3yQRmND9FJJGPc1gXsR07xfPqsd7LPNc2KQJpiABSUZiJXbnaBvIBwO+MnAoA3Zbi10nTTNdTLDbwJ88jnAAA/wA4xya57w1a6hqGkCe8EljDezSXbxK2JpBI5ZQx/gGzYMD5uOSOlatnGDNbz38omvpN3kjGEiAGTsU9OwLHk56gHFR6lr3lTyWWmQi9v1wJBu2xQZ6ea+Dj1CjLH0A5oA0X+w6daGV/s9rbwKPnbCIg+prHtri6uLZbfw7p8dlZZZhd3URRPmOSY4hhmJJJyxUEnPNT2OgrI8N9q0xv71fnQyDEUJ/6Zx9FI/vHLe/ata4lEUTEn5jwM+tAHOT6RaQ3SzTvLf3q8/abtt5U+iLgKg/3QPcmt6wg8qEE/fkwWJrK0Zzq0MV4UIifLgE5yMnb+YwfxrZupxDF1wT6daAOb0y+N/YS3obK3lzJMp4OYwxSPB9NqA/jW3p1sV/fMME8KPb1rH0Cyn+yxR3QVJCzySKp+VAWJ2jHGAMDjjitvSb0alpdveomyKdS8YPUoSdp/FcH8aAKGvytLdaXp0Q3SXFz5zL0BSEb+fYv5YP1rCfwxqt3r39o3DggQGJUYjCszAs2c98KAMcY9637u2eLxKuqPNGYo7I28UZHKMzhnY+xCoPXg1c0i6lvdJhvJhtM4Mijj5UJJX/x3BoAxNViW0sLHREO6S+m/fsOP3SYaQn2Pyp/wOr0UbXM4BzyfmPoKqXFs8viKXUnkVoharbwpjlMOWc5z/F8nb+GtuyiEMBkcgFhkk9FH+eaAEvkumit4bQKFMyec5faUiHLY9ScAY/2s9qovKH8XSsT8ljp44/2ppCfzxCPzq7pVzLe6ZDdyjHngyouANqFiUH124zXP2Nx9o1HXLgfde/MK+4ijRD+G7fQBduR9rZ1kQOJOGQgEMD2x6e1EHhW2s4lGnXN5psnUi0mxGSf+mbAp+QFXtOgDMZiMhen1rSxQBh/8VDZKd4stViA5xm2mwPYkox/FRWW/iHTVlIulk06VifkvIvKH/fZ+Q/gxrqbpwkDc8ngfjWSEM7iLghmAKnkEe9AGjpbRS2SvDIkobktG4Yc9OQayNb0Zg7XcC8Ny64xg+o/rV2TwtoM0nmPo9kJCeXSIIx+pUCmjwj4dU7v7FsWbpl4g5/XNAHMRXcUWd88ajvucD+Zp517SYOJNUs1b0+0KT+QOa6lfDOgofl0TTQR3+yR5/lTNS0sizA01I7d1ySsKhNw9OAKAOdGt6TNF9y9u89FtrORsn/eICj6k1QnS+uJAbHTUtIzzuvrkMwH+5GD+RYVJ5soc7ixI4OSScir1tOhx5gJx2BoArw6dqDqBc6vKg7pYxiAfi5LP+RFXbTQbK3kM1tYK8+M+c4MkhP++xJ/Wrsd7CgGy2Qn1Yk1MdTuCMKVUDsFoAyzevuIcYIOMHqPzokvCgGMHIzTrqB7iQyjl25I6ZPrUcenyyrzwfTqaAEXUTnlOakGpSKCVVQR6gGq72E8UyxvEwLdCRwRVqO0UD5uSO1AHN6rHrB119WsltrmN7dIZbVz5bttZiCjgYB+c8EYPqKdaarp7XQh1R5NIlbG1b5PLVyf7r5KH8G/CuoSGJc/Jk+pqZWPltEURo3GGV0DKw9MEc0AYF3DGjsYJYp4gMrJE4ZSMZ6iotK00QeBtCu5FUvLPp7DvtUypn+dWL/wVpt4s9xYWclnesrbZdPf7OWOCACB8hB6HKninaR4Z8Tmx0nTNXu9KTTdNmhcR2qu0kyxcopJAAwwUnjJxyaAO5llit4XmmkSKGMEs7ttVR3yScAD3rmbzWL7WFC6Hb/6If8Al/ukKxH/AHE4aT2Pyr7mrcXhxru6+16/djU5VctBbhNltDzwRGSdzD+8xJz0xXQYz15oA4yz8NRLdC7m8y+vwMC5uACUB5wigBUH0GfUmtMeHt0vmh1icsGJAySRjH1NdAAF6DApcUAMUEKAxyQBk9MnHXFZ2s6WupWLQ7UJ5yrLlXBGCD7H3rTooA8mGj6r4YnZtEmktwD81o5A3D0BOVb2DAnsGArqNC8cwXhNtqaLa3CEB3IKKpJwN6k5jz0BJZCeAxPFdbLDHMpWRVcHsQCP1rnNc8H22pKsts5truIHyZQAdoIwRgghlI4KkEEfnQBp6ppEeoGOeORrXUIAfs93GMsnsR/Eh7qeD2wcEYV7eSX+23vIBb6nag+dCDlWUkASxk/eQ+vUHg4PXGsPE2q+GLtdL1e0eVACI4kJJYDvAxPzAd42O5exYYFa8+s6T4mtIZrS6NtdwSFra725MEmMEMOuD0ZTjI9DggAuaBZMLvzijBFU4yOMmtq4sVuLpZXb5QoGK56XxZdR2MkIsoF1qB0We0knKptOcSo4U7kIHBx1yDgg1RPizxC4IW00iInGMySyf0H86AO5AAUADAAxj2rm/Enh2XUG/tHSpI7bWI0KB24S5j7xSgdVPY4yp5HcHBm8R+KZTiObSYxjqIJM/q5qtc+I9XtYVk1fxHb2NsWCl7WzUOSegG8vuPsBmgDLtdWiubqSyuY3s9Qj/wBZazEbsDjKkcOvuPxxV4HuOag1TSLvVL+1uryAjT1zLG91CqXE0gIIfaMeUOhxwW7gA4qzgliCMH1oAeHOKKVYuPT9KKAPS6evVvoaaetG4KrMxwApOTQBzOoahaXWqXFvb3CSy24CyhDnYxycEjofUdR3rdiIt7JM9FQZ+uKw7pxPdAKoVS/AAAHJ5PHfuadc3Jl1q8iV/wB3bxRQ4Gcbjl2/HBSgBZZM7nPUnr71yuoSzPqzNbyBGjntLENtDY3yCSUcg87AgzjiuguZxBDJKyMyxIZGVerAAnA9z2rHsLCRoNBW45uLnUReXJA4LtHI5H0HAHsooA7qzQRWu5uN2WYngAdefpWZLdJeFZonDxMoKMpyGBHB+h61a1qKK70yewlLiK5jaJ/LbawUjBwR0z0yKzkSO3t1TeRFEgG5iSQoHUn6dzQBL5kNvDNdzkiG3Us+OT9Pqegrc4Xg8HpiuVezuLjwgrxwF5r26gup0JAKxmZGI5PaNQMZ5xWhd6kbYvOIzNK7COCEHBkkb7qg9h1JPYAntQBZ1LUJIXSyslR76VSwD8rCmeZH9uwA5J4HGSM6KCC1ErPPwSZLi6nYAtgcs5PAA7DgKOBipfLTSbGZ7q4RrmXM17cn5VYgc9eiKOAOwHqSTU0mwfXJ1vr9CunoQ1taOMbyORLKPXuqngdTz0AK9vLc+J9fnezmnstKsoFg80IUmmMmHPlk/cUqE+bG4jpjINaghsrGLyIES2soFZyFHCgDLMc9T1JJ5Pel0uKey0y4lukKXl7dTTyKSCVBYhR+CKgqO702XVdFvrWJ1jedBFufONpPzDI6ZXIz2zQBtWM7XNhb3DRmMyxK+w9VyM4+o71geKNRNto2o3KnAt7aR1OcDcFOP1xW/eSiKEheCeAPQVmW9lFfGSO4iWW3IwyOoKtnsQe1AFnS4ItJ0yys5HVWESxqDwWKpnH1wCTVa6mM8pI6ZwB7Uup2KPrFtqDXExkgheJIQQIwXI3ORjOcAAc4A7c1JYQebKXYZVe3qe1ADNTtruLwzqKafH5l/JbSCFQQC0hUheSQPzov1i07Q7LT1XKM0Foqk4yoxkdf7qmtnNctrl0JvEWj2gOQGnnx2+SMr/OQUAN16WSXT5okYi4vpEtIT6NI20n6Bdx+i10F2yW1ssMShVChUUcBVA7fyqBNKgmksbqcMZbSRpogGIVWZChJHf5WOM9M1na7qQs7G9vjyII2dR1yQDgficCgCzaILmZQMFASWPbANSeI5GTQ5YIm2zXbJaRn0MjBCR9ASfwo0qNNMsLG1nkzcSqIwcffYIWb+RJqtqbS3Pi7Q7IQyGCFZ76WTaSu5VEaLnGMnzGOP9mgDZmK2tqViCoEXbGMZC9hxnp7Vy+jaY9hp1vY+YbiYEtJMVwZZGYszEZPViTjPFbuoylmCDovUe5qos6adpl7qchGy1heTngDapY5/LFAGxbGP7MnlMGQA4I6EjIP9aHnSOaKFj88u7aPYDJ/AcfnVPRLdrTQdPgkz5iW6Bz1JYqC35nNMjYXHiO5fgrZ26xA56NId7D8lj/OgCo0d1DqGomdkMcsyvBhySqCNFIIPT5lY8E5zmremxbpWkI4UYH1NQXL75mPqf0FaNghW1BP8RJoAsinDFJSigAopRS0Ac9q+gm4lNxaKu4/eTOMn2+tZ9tol6zDdH5YHdjiuw70gFAGImhOqgmZc+gHFWBpUaRMdzO4UkDoCccCtOigDkhqLRsR9niUg85Ukj9alGo3LDHmbR6KAB+grYvNKt7xjIy7JT/EO5Ht3qmmhOj/AOuXHrg5/KgCiZHkwSxJ9zmpEjY9ASfSteLSoYx8xLH16VbSCOMAIgHv3oAyIrCZ+q4HqeKvwWEUSgsod/U9M+wq4MUGgBoAAwBgDsKdiiigApRQOtFAAaKM5ooASilooAMUYo7UlAFHVdIsNasXs9QtlngbBwcgqRyCpHII6gg5FeZ6t4dutA1FWlvCochLbVHXIfn5YrkDAJ7BuM9ip4Prfaq17ZwX9nLaXMSywTKVeNhkMpoA8smn/tZ4UkQWfiKzQiAM2Y7iP+KPd/Eh4GcBkOCRxzpiJZdPtr6CTfDPkAEYZGHDIw7MDkEeoqpqehJp10NGvXea3cGbT7gviRQvVd3UOnGG6svXODWdDczaRdFLuXMcsoMpAwkwIAE4A+7IvAkUcFfnH3TgA1SSGHYHis3XLQajFZWJZlM97EAygbl2kucEjg/JjI7VuXNpLbuFljZC2SNwxkUzTbQ3fivSUABWBZbh/wAAqj/0M0AdnrFuLiwLFRuQhsenrXIzwBWBAx7130qB42Q9GUg/jXHX8TICCMFWI/pQBDBEpiBIopsJOz8aKAO7qvfErYXBHZD/ADFWT1qnqbhdLuiDkqnIH4UAYVr+8v4FPJLDiq9hMJhfXh5FxeSsD2Kq3lqf++YxUMd+LJnvH+7BE8h+gUmjS4TbaDp0DffFuhbPqVBP6k0AXkAYMSAQcgg8ginSlLa40aWRSPNv/LTA4GYZefpSxrkqg6kijxKREuiorY26jGfwMcg/rQBZuZ/OmJ9TgfQVR1KMzac1sDg3kqWg+jsAxH0Tefwp4JeTI6elSzAf2/plsTxaQS3so/2j+6T/ANCfH0oA0dQnVF8pMKgHPYKMVl6LGt3Kdan/ANWVZLJD1CHG6TB7vxj0XHqaqX+7V7/+zFJMJAe8Yd0J+WMH1bv6KD6iqd3eyaz4hvtMsZmjtrJVtLiaM48vIDSKhH8bfIoP8IQnqRQBZd28Q6mcfNptvLj1FxMp6e6IfwLey89hEgjiVR2HJ9+5rL0i1ihVEhjWOCFQqIowFGMAAelaF3KIYCc8ngUAULqUz3G1TkA4ArTijEUSoOw6+/euciuHbxFp9lHnayyzzHHG1AFAzjuzr+VdBdyiKBj0J4H40AZN1eLcXssKEkxbQ3HGSMjn17/iK1bVFt7UZ6kbmP1rB0TTZIprnz5BK811JcOwBAwSAq49lCj8K2r+URxBB1b+VAGRqd+sEclxIkzqpA2QxGRzkgDCjJP+TWpas9pZyTToqQJGJeSd4GCW3A9MdsE+9VbGLzrkE9F5P9Kf4ltby/0C5sbJVMl0Fgdi20JGxAkb6hd2AOSaAHWlzKdBtJps+dNCrsCckFhuI/DOKr2ljDcX8Ny8SmWFWVZCOVViCQPrtGfpT7qUPLhOFHCr6AVp2kAghA/iPLGgBt7KI4CM4LcD6d6xW02DVyttdxCWDesjKSQCVIYZwfUA46VavphJMQDwOBVvTYtsJkI5Y8fTtQAk9g8+s2N+LnalrFKhh2Z3l9oBzngjb6HOT0q3NJ5ULN6dB79qqaxeNY6RdXKDLqoCAf3iQo/Uim6lKFIhB+7yT70AUXLSvgZLMcZ9SavT6XBeaRPpt0C8E8ZSUA9QevNRadFvlLnkLwD71qEhVJJwByTQBDczeWvH3j0HYdqxtAIbTb3UOCbu5kkDA/eUHy1P/fKCnSX6z38luCfMRBIeOACWAH1+U1ItuumaPZ6bGxYQRKhYjBbAAz9T1oAiVTJKqDnJArfRQqgDoBgfhWNpyb7sHsoJP1rbAoAKAKAKXAAoAM0lKetHAoAMUhOPcUuaaelADjgjIo7UifdxSkUAJS4pMDtS9qAE70p60lFABRRilxQAlFLikoAKUEUUUAB60UUUAFFFB60AANFJSigBaaRT+1MPWgDA8R+HV1qJZEfy7mJlaNvRgeMfqD6gkVxuo6clxFLaXcR27sEAkMpHce/of6V6icGsHXdNSVluQMMflcjvjof6UAcHp2r3NvBa+HdVlEtxaq32S6bg3MQxgEf31GAR3GD6113huzKau10cYazAA7jMjf8AxFcz4n8Mm+tPIcmOdCs1vKCQUccqwI59jjsTV/4fa1NcXc9nqTbLryljiJGN5QuXXjgOu4EgdQQw4OAAegEZrntZgKyk4+VxkD3710OR0B5HUVXu7ZblAp7MDn270AYlhowmtQ7nBJOAMdKK3dm0BVwFAwMUUAT4qOaBLm3likzsZSDg4OKkNKCAD6bTQBzOsaRY3WnzWAVohIAHZD8zKSCRk+o4Psagdw0vQY9B0qW9vEW4w7APKxCD1wCT+lUElDSev+NAFks76hY2sTlXnlBZgcFY0+ZzkdM8L/wOmeI5TLJZuMkLewkY7DcVz+tGkEyahqV+eRAq2UR/2jh5P5oPqtFwBOwB5AZWA9wQRQBoaZF5twCR8q8n61HrTw6bNdX6o8tzcLFEI933ypYJGv1Zzn6k9BWnpsQgsfMPVssfoOlc/wCb/aesy3bH/R7NjHEScBpOQ7fRR8oPruoAdCz6HpgkAW51GeTCKePOuGz+SgDJ9ET2o0jSo9H09bSORpnaR5ppmGGlldizMcDuTx6DA7UWB+3ONYcfumQx2CkYxESC0v1kIGPRFX1NadkqvdJvYAbjtBP3jycD8ifwoA1baEQQBe55b6mqF/N5k20dF4H1q7e3cVlAryHmRxGgHJZjwMfqT7Ams6CM3FyB1HVvpQBp2cQht1B6kZP1NUdRm3SbAeF4/GtKVxHEzEgADIzXP2cqamIJomJinUSK3TKkZoAu20vkXVpahCZJ1klYjoqLgc/UsAKjvZfMmJ7A4H0qvbtcPrWq301tLBFGiWNr5gwZFXLPIB6EsAD3CZp8CGe6VMZBbP4DmgDVsIhFbgn7zc/h2ovZvLiwOp/lUWlWk9jp6Q3Nws8+93kkVdoJZmY4BzwM4HPQVUu5/MmJHIHA+lAD7OEz3AJHyLyfetK5l8qBiDz0H1qOxjEdspIwW5NUtRnLyhAcKv6mgCtGhnuFQHAJ5J7AVvJt2LswUIGCOQR61zN40kOkXc0LYlkC20J/6aSMEBH03ZrpwiooRfuqAAPbGKAM7XY3k0aURxmVg0bbAQCwWRWI5PXAOOaozyNNMTkZZjj8a1NRlCW4XPLH9Kw5pxb29xcnkW8LzH2CqW/pQBo+GiZdFS4JY/aJpZVz1ALtt/DaBird3Oj2ilHDCToynII78iqNul5ZeCoUsIFlv4tPUQRbgoeUR8cngZPc1XggNlp1nYs2TbQJESO5C/MePfNAFPw6hvNb1q5YHalysC5GOI0UY+m53I/OtPUZlFzgtglgqj1PJq1YIEhklIxu4B9QK53U0ubjV9MkiQGCKWV52LYK5jZVwD15bHHSgDo9KQiJ3I6nA/CtEVBaR+Taxr3C5/E1MBzQAtONFJQAtJRmigA7UHrQelGKAEHFOpAKDxQAtIaAeKXrQAneijFFABR7UUHNABRRRQAAYo5paSgApabTu9ACUUtIaADvQBQBS0AL2pKWm0AIRTJYlliaNhlWGDUh60lAFN7GOe0WCcBiowGHUY6YrlNV0tbC8SS5LLZ3TpFLcx4DQyA4hnB7MrHaT3VhnIGK7jFQXVtDe2s1rOgeCZDG6noykYNAHJWt9eWeotLdgCZZPJu1XO1mAHzDPZlIYDsDjsa7AEMoI5BGcjuKoNo8MluyzkvM8Uccko4LFM4bGevJ/lVy3iMFtFCX3lFA3YxnHFACnrRQetFADqUjKsPVTQacvUj2P8qAPMpLxb3xLe+WwaOwQW2QQQJWw7/iB5YPpyKfc3UtvbSTQ273EkallhRgGc+mTgfma19Q0lbe9nMTKBI5kICgEk9c47+9WtJ022MUlxcIHCkBQenTPTvQBXsYJdM0G1tJ2RrohprhkPytLIS7YPcAnA9hRbo00yoOrMBmlvJd0p9PSrGlRo8pDOFZgUTJ5JIJ498AmgCbWdRa30SIWYxPckQ2wYY+Y5AOPQDLH2WsMWiXdzb+G4N32SOIPfPkg+Uc4QkfxSEEk/3c+oqzqd7AdVu76dttjpMLIpHQMVDOfqF2qPdmFWNBt5bHRWursBb6+czz99rHHy/RV2qP92gCw93FdszQMDGjNGABgKVJUj8CCKfo6NdapPcnmC0Bt4vRpTgyN+HyoPcNWXK8WkabM9rCMqzNHEDnfNI/yjr/ABSOM/Wum0ywXStJt7PfvMSfO/eRySWb6liSfrQBkajObzxF5Q5h0+ME+hlkH81T/wBDrR0x4hMYy4EzIWVe+0EAn6ZIFY1jbSwxSvcFTdXE7zzFSSNzHhRnsFCqD325rT0rT7q31rUby5VBE0UMFth8nYoLMSOxLuRj0UUAWNXKvbtbMWCyKQxU4OCCDg+vuKh0S2it4VjiTbFDGsSDrtUAADn2AqK7l82dj2zj8K07OIW9qM9SNzfXFAFLUZi8uwHhev1p2lRfM8h7cD8eawdKvG1G1luzJv8ANuZggznaqyMgX8lz9TXW2kAt7dU7jk/U0AUNTgnOpWVysi/Z4YpgyZO5nbaFYDGOBvzk/wAVZzwT3N1aCDbhZ1aUFiMxgHdjA69Dg9atXN+t1eXMSZK2ziJm7M20MQPpkA+9XNMhwjTEctwPp3oAsXdzHZ2ctzKcRRKWboOBWLM7PMxPUk8e+af4n+0S29nZwRs0c9yhuHBwI40O855/iKheB/Ec0+yi+0Xi5GQvzH8KAJLjS7ie40hQYxaW0xuLgEnczBSEAH+82ev8IrZoqGadUjlwcsigkemc4oAw7u+Fxqt1bjBFuqcj1bdn+Qp0mkJrHh+/sZJZIBewvAZYwNyqRgkZ79etZllaTjVtQmfaRdTRGLBydqxqpz6Hdn8K7CKIRRKg6AYoAYxFtaAZyI0CqTxnGBWHIxL8nOT1rS1OUKqxjvyaq2EKyTeZJgICAM/xMewoAt3biCyVRxkAY/CsKwFzPqkyzIohMqrCAcllCgsT6c5AHoPetfVSNyDtg8VDpUYe6Z+yKfzNAG4BQBQKUUAAJFHegijFABg0dqMUtACYNGKCKBQAo6UhpaQ0AJSijFLQAUhpaSgA5pDmlA5NB60AA5paQDilNACGjNB60DrQAn40A0Y5pQKAClopMjpQAtFKMUUAJSUtIaAA9aQc0uKUUANIopTSUAKetNPSlx3o7UARMOaKVhzRQA4GnL1P0P8AKmilJIUkDJCnGehNAHLa3dKt86DkgAH8qittSjXTGi3qJWckpnB2gDoP0qKfR9SmmZ3iDO7Ek7xjJPfnpXM6cXuJrjUCxMc7BLfB4MSkgMP95txB9MUAbRlZmz65q3pk6gXmrupNtpsbxRD+/LgGQj6ABB77hXPX+ovG0VhZMrajcKdgPIiXODKwHYds9TgetdYbSGPwxp+n23y267C4fkuFYM2T3JIJJ7kmgCjHpEdxp9rbXoMsgkWeVdxAeUksdwzyAxzg8cD0rXvCFYRg5CDGfU9TTIJAswcjO3J59aaga4mUA5LHg/XvQAtpozXV/aX00x+z2pLx24QYaXBAdmz0UE4GOpzngVsXs3lW7c4LcD+tTRxiKJYx0UAZrntZvWl12CwhfCQQme4I9WyqL+PzH/gI9aALNqnn3aDHAOT9BV3XNRXStJmu2GSCqKP7zMwUD8yKbpMW2Npj1bgfQVW8Qpb3cC21yiyRBlkZWPAKkMpyD2IBoAigjEl2qE8A5JPHA9a1NRl8u1IHG44/DvWbFYS3kAZGQKZ4i+4E7kVgzAe5wB6VLq8uZggPKjn69aAILCMS3aDAwCWIH51sX97Dp2n3F9cttht4mlcnjCgEmqWjR/LJIfYVJq/lTWrW0yJJHIDvR1BVh6EdxQBz+gwzHS7Xzh/pNzm4lz1DyEufy3Y+grsEQRxBB0UYrJ0yHfMZMYWMYAHTkcD8K055BFCznsM0AY+pTiS4IB4XjP0q3pEREDSkcscD6VjyyZLE5JPYAkkn0Arp4YhBCsY6KAKAJKxbxTbNcDfve4k81iFAwAAqj3xjrWyeBXM6neBTcXO0uI1LBRyWABOB7+lAFnS4/Mugx6IM/jW9nArK0WKSz0SCW+IFwYRJcHspxkj6DpTob6SbQbe6lwsk8SuQO24Zx+ANAFK8nEs7t2JwPpVFzdNqulJGjfZ1leaZwRgEKVRT9SxPT+Cpz8zAD1/SrNqvmXaA8gcn+dADNRlDXRIOQBg/Wr2jJiGV/wC8QB9AKwrmVfOY57k49s10elIU06LP8QLfgaALw60AUDrRmgAB59qWm0tAC0UdaKACijpRQAUUUUAFFJS0AFJS0lABmigDmloAO1FHakJoACKBilxxzRQAUvam5xTj60AJTGyTwafRQA1OKfSClzQAlNOadSdKACloooAQ0lOppAPWgA5o7UUE0ANxRSbietFAACDTuxwcYHWm5AYLg5IJzjjt3pwHPTsf5UARFVkUnAIIwR6j3ri77TUS6dbUIlumESNVChAAAFAHYdAPSuwEoiVmc4Uc5PTFc6R590QMDc3bpyetAFXTvDomna52IJCoQyhQGIzkLnGcDritW/CW5WBAAkahVH6mtq3iWGNY1GFUVzmozgzSMTnLHFAGfKbqXUbeJEAsikjXEm/BJwAqAZzzkknttA71peGpWu72/YKotrSQW0IGcllUbjn0ycAf7J9azo7jdx610Ph6yis7KZ4xj7RcPOw7bjjP65P1NAGjLLHBBJNM4SONS7seigAkn8K4rSTJcwPqE6bbnUZPtLqeqqQBGn/AUCg++T3rrtSkWLT5y4BVlKkEZBzweK5/SAtxqEcYACIM4HAAAHagDqIYxDAif3VA/GuK1+9Ny6WyPh7u4SBfoWy3/jqtXV6qLp7FktE3O3BIIBA9vr0rj7LSrmXxrYxTr5aWdq90yk5JLMEXp7B6AO6t4hbwKnTAyfqa5q7n866cg9WrpLlJZLWRIWUOykAnoM1yuq6Zc2WlXExlUTNthiVOSZJGCL+rA0AdHpQH9mwNtK7xuwcE4Pfr6YrN1C48y4YdgcflWu4SysQkfEcSBFHsAAK5+JDc3ax55ZutAG7p0XlWiZ6t8351T1q9WJBCG+Y8sPbtWqT5cbEDIUE4HtXEy39pqix31uzGOZA5yckE9RyB0PH4UATQF57yyRGI8y6QEj+6oMjfhhMf8Crs64vRJYpvGEdqhGbWwefbnkmSRVB/JCPxrrZ7hLdQW5JOAB1oAZqE/wBntGIOGb5RWHZRfabxFPKg5Y+w5pNX1NLi4WKI5RRjd2yev+FXfDRS40iG/VWAuV3ru67STg8evX6GgB/ieRo/Dd6sY/eToLdBx96Rggx/31TdUdY2jt0AEcagYHYDgUaza3N5eaYoMa2FvP8Aarly+GJjGY1Ax/ewSc8bMd6y5rsXF0zMcAksx9B1P4YoAsR7Rbl9wJZiOOcY61NZB3aYxjLiIhQeBmsrSmJ8Pac5ILywCdyOctITIef+BVow3i2FjcXBALkhUHvyf/r0AYE2mXdvrU81y0QieCKNFDksCGckkYwB8wxzXbaZOs9jEV/hUKT6kAVw091LcTNK5yWOTXUeF5C+nSKR92Q8/UCgDeHWikFLQAUUlKKAFo7UlLQAUUh60A9aAFNFIeKM0ALxkUUlLQAUUlHNAC0maOtLQAmaBS0lACk80UnejFAASCKUVkeIdVbR9K8+Py/OkljgiMpIRWdgoLY5wOSQOTjHenTahPpXh+6v9TMMs1nFJJL9kyFcKCeAScEjGQScHuRQBq9KK5aTxRKl9ayfZPM02QtC8sAedvPC7iF2AgqD8ue7Z6Y5L7xNqFhd2K3GjOsd60kcMYk3TFwpZQwUFVBxj7xx1J4NAHU0mawYvEM8C+Vq2kX1tcjr9lhkuon90eNTx7MFI9O9ZXiXxJdw2Nswsbyw064vIre5v52ETQxu2CyqCWGeBuIGN2e1AHWHULNbwWZu7cXRGRAZQHI9QvX9KsVxLWz2Nm16NK0nRtOtG85Xu4TNOxHRyEIwT2+ZmOeeeKfaeLtWutQisrfQDekRFriWG5RBC2ThXUk7SRg4LFhnpwaAOyJpGdUUs7KqjqxOB+dctpnjGbWLeU2fh7UTcRzPCyy4jiUqcZ8xsAg9toJ9qp31vqNz4q0qXW9BsruwuFktdkTNci3bG8O4ZAoB2lSfcUAdqGDgMpBU8gg5BpSa5OC1tLDxnb2+gxLBGI5DqcNuMQIMDy8qPlEhboAASuc8YrqyaAA00mlJppoAaSM0U7aO9FADqUdaKKAM3VeLB8eoFYFqSJ4277gaKKAOqkJFu7DrtJrh7xz1zRRQBXjJ3fjXoNsgS1hVRgbB/KiigCvqNpHeW/lSM4AIbKnBzg1DYaXbWT+dGGLkYyxzj6UUUAaNQ/Y7Zb170QoLoxiEy4+YoDkLn0ySfxoooAsAVVvNOg1E2/nmQfZp1uE2MRl16Z9Rz0oooAra3IyWigHhmwazNCJbUDnshI9ulFFAHTSxqVZDyCMH8q4/U7KK2uSkZfGT1OaKKANnw7Ai2zsOrNgnvjFRauxedkJ4C8YoooAWHRLJrRmdGZnRgSW6cHke9allaxWOn21nACIYIliQE5+VVAH6UUUAZviKeSOGOJThXPPrUOjafbyxvJIu/em1lbkEHgjHuKKKAMfUdthqVhp9nHHb2gLoIokCqqpH8oA7DntUczs/yscrnOKKKAL+haXa3wkM6E7SAMHFdPbwxW8YjiRUQHoBRRQBMKXtRRQAlLRRQAUGiigApe1FFACGiiigAooooAD3pKKKAHUUUUAIOtFFFABR2oooAintoLuFoLiJJYnBDI6hlP4GmRWltDbG0it4kt1QKIlQBcHqMdMUUUASRxR28ccMKLHGqgKiKAFA6AAcAe1PFFFACnrUU0MVxG8E0aSxOuHR1DKw9CDwRRRQAskEVzA0M0aSRP8AI0bqCpHuDxRBbw20KQ28McMScLHGoVQPYDiiigCTr1OabLErDymGUcFWGeooooAitLa3tIfJtoI4Ig3CRrtGT1P1qU0UUAN6ClWiigB1FFFAH//Z")||MA(iA,"src",Rt)},m(A,t){Dt(document.head,U),e(A,oA,t),e(A,rA,t),e(A,kA,t),g(d,A,t),e(A,UA,t),g(y,A,t),e(A,dA,t),e(A,u,t),e(A,yA,t),e(A,B,t),e(A,uA,t),g(m,A,t),e(A,BA,t),e(A,W,t),e(A,mA,t),g(I,A,t),e(A,WA,t),e(A,J,t),e(A,IA,t),g(b,A,t),e(A,JA,t),e(A,w,t),e(A,bA,t),g(Z,A,t),e(A,wA,t),e(A,gA,t),e(A,ZA,t),g(S,A,t),e(A,SA,t),e(A,H,t),e(A,HA,t),g(Q,A,t),e(A,QA,t),e(A,q,t),e(A,qA,t),g(V,A,t),e(A,VA,t),e(A,R,t),e(A,RA,t),g(f,A,t),e(A,fA,t),g(x,A,t),e(A,xA,t),g(G,A,t),e(A,GA,t),e(A,C,t),e(A,CA,t),g(P,A,t),e(A,PA,t),g(K,A,t),e(A,KA,t),e(A,T,t),e(A,TA,t),g(D,A,t),e(A,DA,t),e(A,F,t),e(A,FA,t),g(O,A,t),e(A,OA,t),e(A,cA,t),e(A,zA,t),e(A,z,t),e(A,hA,t),g(h,A,t),e(A,XA,t),e(A,X,t),e(A,YA,t),g(Y,A,t),e(A,LA,t),e(A,L,t),e(A,NA,t),g(N,A,t),e(A,EA,t),e(A,E,t),e(A,vA,t),g(v,A,t),e(A,$A,t),g($,A,t),e(A,_A,t),e(A,_,t),e(A,At,t),g(AA,A,t),e(A,tt,t),g(tA,A,t),e(A,st,t),g(sA,A,t),e(A,et,t),e(A,eA,t),e(A,at,t),g(aA,A,t),e(A,lt,t),g(lA,A,t),e(A,nt,t),g(nA,A,t),e(A,pt,t),e(A,iA,t),e(A,gt,t),g(pA,A,t),e(A,ct,t),e(A,jA,t),it=!0},p:Gt,i(A){it||(c(d.$$.fragment,A),c(y.$$.fragment,A),c(m.$$.fragment,A),c(I.$$.fragment,A),c(b.$$.fragment,A),c(Z.$$.fragment,A),c(S.$$.fragment,A),c(Q.$$.fragment,A),c(V.$$.fragment,A),c(f.$$.fragment,A),c(x.$$.fragment,A),c(G.$$.fragment,A),c(P.$$.fragment,A),c(K.$$.fragment,A),c(D.$$.fragment,A),c(O.$$.fragment,A),c(h.$$.fragment,A),c(Y.$$.fragment,A),c(N.$$.fragment,A),c(v.$$.fragment,A),c($.$$.fragment,A),c(AA.$$.fragment,A),c(tA.$$.fragment,A),c(sA.$$.fragment,A),c(aA.$$.fragment,A),c(lA.$$.fragment,A),c(nA.$$.fragment,A),c(pA.$$.fragment,A),it=!0)},o(A){i(d.$$.fragment,A),i(y.$$.fragment,A),i(m.$$.fragment,A),i(I.$$.fragment,A),i(b.$$.fragment,A),i(Z.$$.fragment,A),i(S.$$.fragment,A),i(Q.$$.fragment,A),i(V.$$.fragment,A),i(f.$$.fragment,A),i(x.$$.fragment,A),i(G.$$.fragment,A),i(P.$$.fragment,A),i(K.$$.fragment,A),i(D.$$.fragment,A),i(O.$$.fragment,A),i(h.$$.fragment,A),i(Y.$$.fragment,A),i(N.$$.fragment,A),i(v.$$.fragment,A),i($.$$.fragment,A),i(AA.$$.fragment,A),i(tA.$$.fragment,A),i(sA.$$.fragment,A),i(aA.$$.fragment,A),i(lA.$$.fragment,A),i(nA.$$.fragment,A),i(pA.$$.fragment,A),it=!1},d(A){A&&(s(oA),s(rA),s(kA),s(UA),s(dA),s(u),s(yA),s(B),s(uA),s(BA),s(W),s(mA),s(WA),s(J),s(IA),s(JA),s(w),s(bA),s(wA),s(gA),s(ZA),s(SA),s(H),s(HA),s(QA),s(q),s(qA),s(VA),s(R),s(RA),s(fA),s(xA),s(GA),s(C),s(CA),s(PA),s(KA),s(T),s(TA),s(DA),s(F),s(FA),s(OA),s(cA),s(zA),s(z),s(hA),s(XA),s(X),s(YA),s(LA),s(L),s(NA),s(EA),s(E),s(vA),s($A),s(_A),s(_),s(At),s(tt),s(st),s(et),s(eA),s(at),s(lt),s(nt),s(pt),s(iA),s(gt),s(ct),s(jA)),s(U),r(d,A),r(y,A),r(m,A),r(I,A),r(b,A),r(Z,A),r(S,A),r(Q,A),r(V,A),r(f,A),r(x,A),r(G,A),r(P,A),r(K,A),r(D,A),r(O,A),r(h,A),r(Y,A),r(N,A),r(v,A),r($,A),r(AA,A),r(tA,A),r(sA,A),r(aA,A),r(lA,A),r(nA,A),r(pA,A)}}}const ht='{"title":"Embedding multimodal data for similarity search using 🤗 transformers, 🤗 datasets and FAISS","local":"embedding-multimodal-data-for-similarity-search-using--transformers--datasets-and-faiss","sections":[{"title":"Querying the data with text prompts","local":"querying-the-data-with-text-prompts","sections":[],"depth":2},{"title":"Querying the data with image prompts","local":"querying-the-data-with-image-prompts","sections":[],"depth":2},{"title":"Saving, pushing and loading the embeddings","local":"saving-pushing-and-loading-the-embeddings","sections":[],"depth":2}],"depth":1}';function Xt(Mt){return Ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vt extends Pt{constructor(U){super(),Kt(this,U,Xt,zt,xt,{})}}export{vt as component};
