import{s as dt,n as It,o as ht}from"../chunks/scheduler.39a43cde.js";import{S as Ct,i as ft,g as M,s as n,r as i,A as gt,h as p,f as t,c as a,j as ut,u as y,x as o,k as bt,y as Zt,a as e,v as j,d as J,t as c,w as U}from"../chunks/index.23ec2204.js";import{D as Bt,C as r}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as T,E as Gt}from"../chunks/EditOnGithub.f2d09226.js";function vt(Rs){let m,gl,Cl,Zl,w,Bl,u,Gl,b,Vs='<em>作者: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',vl,d,Ns='这个 notebook 展示了如何使用 <a href="https://huggingface.co/docs/transformers/en/agents" rel="nofollow"><strong>Transformers Agents</strong></a> 来构建出色的<strong>智能体</strong>！',Wl,I,Qs="什么是<strong>智能体</strong>？智能体是由大型语言模型（LLM）驱动的系统，它们使得 LLM（通过精心设计的提示和输出解析）能够使用特定的<em>工具</em>来解决问题。",Al,h,Ss='这些<em>工具</em>基本上是 LLM 自身无法很好执行的功能：例如，对于像 <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B-Instruct" rel="nofollow">Llama-3-70B</a> 这样的文本生成 LLM，这可能是一个图像生成工具、网络搜索工具、计算器…',_l,C,$s='什么是 <strong>Transformers Agents</strong> ？它是我们 <code>transformers</code> 库的一个扩展，提供了构建自己的智能体的构建块！在<a href="https://huggingface.co/docs/transformers/en/agents" rel="nofollow">文档</a>中了解更多信息。',kl,f,Es="让我们看看如何使用它，以及它能解决哪些用例。",Rl,g,Xs="我们从源代码安装 transformers agents ，你可以使用 <code>pip install transformers[agents]</code> 轻松安装。",Vl,Z,Nl,B,Ql,G,Sl,v,xs="对于这个用例，我们想要展示一个能够浏览网络并能够生成图像的智能体。",$l,W,zs="为了构建它，我们只需要准备两个工具：图像生成和网络搜索。",El,A,Ys="<li>对于图像生成，我们从 Hub 加载一个工具，该工具使用 HF 推理 API（无服务器）使用 Stable Diffusion 生成图像。</li> <li>对于网络搜索，我们加载一个 LangChain 工具。</li>",Xl,_,xl,k,Hs='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/agents_db5.png" alt="Image of an Aston Martin DB5"/>',zl,R,Yl,V,qs="快速定义：检索增强生成（RAG）是 <strong><em>“使用大型语言模型（LLM）来回答用户查询，但基于从知识库检索到的信息来构建答案”</em></strong>。",Hl,N,Fs="这种方法相比使用普通或微调的 LLM 有许多优势：列举一些，它允许将答案建立在真实事实的基础上并减少虚构，它允许为 LLM 提供特定领域的知识，并且它允许对知识库中的信息访问进行细粒度控制。",ql,Q,Ls="<li><p>现在假设我们想要执行 RAG，但增加了动态生成某些参数的约束。例如，根据用户查询，我们可能想要将搜索限制在知识库的特定子集，或者我们可能想要调整检索到的文档数量。难点在于：<strong>如何根据用户查询动态调整这些参数？</strong></p></li> <li><p>RAG 的一个常见失败案例是基于用户查询的检索没有返回任何相关的支持文档。<strong>有没有一种方法，在之前的结果不相关时，通过修改查询重新调用检索器来进行迭代？</strong></p></li>",Fl,S,Ps="🔧 好吧，我们可以以简单的方式解决上述问题：我们将<strong>让我们的智能体控制检索器的参数！</strong>",Ll,$,Ks="➡️ 让我们展示如何做到这一点。我们首先加载一个我们想要执行 RAG 的知识库：这个数据集是许多 <code>huggingface</code> 包的文档页面汇总，以 markdown 格式存储。",Pl,E,Kl,X,Ds="现在我们通过处理数据集并将其存储到向量数据库中来准备知识库，以便检索器使用。我们将使用 LangChain，因为它具有用于向量数据库的优秀工具：",Dl,x,Ol,z,Os="现在我们已经准备好了数据库，让我们构建一个基于它回答用户查询的 RAG 系统！",ls,Y,lt="我们希望我们的系统根据查询只从最相关的信息来源中选择。",ss,H,st="我们的文档页面来自以下来源：",ts,q,es,F,tt=`['evaluate', 'course', 'deep-rl-class', 'peft', 'hf-endpoints-documentation', 'blog', 'gradio', 'datasets', 'datasets-server', 'transformers', 'optimum', 'hub-docs', 'pytorch-image-models', 'diffusers']
`,ns,L,as,P,Ms,K,et="要将你的工具分享到 Hub，首先将检索器工具定义单元格中的代码复制粘贴到一个名为例如 <code>retriever.py</code> 的新文件中。",ps,D,nt="当工具从单独的文件加载后，你可以使用以下代码将其推送到 Hub（确保使用具有<code>写入</code>访问权限的 token 登录）",os,O,is,ll,ys,sl,js,tl,at=`Final output:
https://github.com/huggingface/diffusers/blob/main/examples/text_to_image/train_text_to_image_lora.py
`,Js,el,Mt="发生了什么？首先，智能体启动了检索器，并考虑了特定的来源（<code>[&#39;transformers&#39;, &#39;blog&#39;]</code>）。",cs,nl,pt="但是这次检索没有产生足够的结果 ⇒ 没关系！智能体可以迭代之前的结果，因此它只是用不那么严格的搜索参数重新运行了它的检索。",Us,al,ot="因此，研究成功了！",rs,Ml,it="请注意，<strong>使用调用检索器作为工具并可以动态修改查询和其他检索参数的 LLM 智能体</strong>是 RAG 的<strong>更一般的表述</strong>，这也涵盖了像迭代查询优化这样的许多 RAG 改进技术。",ms,pl,Ts,ol,ws,il,yt="正如你所看到的，智能体尝试了给定的代码，遇到错误，分析错误，纠正代码，并在验证代码可以正常工作后返回它！",us,yl,jt="最终的代码是纠正后的代码：",bs,jl,ds,Jl,Jt=`list=[0, 1, 2]

for i in range(4):
    print(list(i))
`,Is,cl,hs,Ul,ct=`设置你自己的 LLM 引擎真的非常简单：
它只需要一个具有以下标准的<code>__call__</code>方法：`,Cs,rl,Ut='<li>接受<a href="https://huggingface.co/docs/transformers/main/en/chat_templating#introduction" rel="nofollow">ChatML 格式</a>的消息列表作为输入并输出答案。</li> <li>接受一个 <code>stop_sequences</code> 参数，以传递生成停止的序列。</li> <li>根据你的 LLM 接受哪种类型的消息角色，你可能还需要转换一些消息角色。</li>',fs,ml,gs,Tl,Zs,wl,rt=`my_list = [0, 1, 2]  # Renamed the list to avoid using the built-in name

for i in range(len(my_list)):  # Changed the range to be within the length of the list
    print(my_list[i])  # Corrected the list access syntax
`,Bs,ul,Gs,bl,mt="上述用例应该让你对我们智能体框架的可能性有了初步了解！",vs,dl,Tt='想要了解更多高级用法，请阅读<a href="https://huggingface.co/docs/transformers/en/transformers_agents" rel="nofollow">文档</a>， 以及<a href="https://github.com/aymeric-roucher/agent_reasoning_benchmark/blob/main/benchmark_gaia.ipynb" rel="nofollow">此实验</a>，它让我们能够基于 Llama-3-70B 构建自己的智能体，并在非常困难的<a href="https://huggingface.co/spaces/gaia-benchmark/leaderboard" rel="nofollow">GAIA 排行榜</a>上击败许多 GPT-4 智能体！',Ws,Il,wt="欢迎所有反馈，这将帮助我们改进框架！ 🚀",As,hl,_s,fl,ks;return w=new Bt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/agents.ipynb"}]}}),u=new T({props:{title:"使用 Transformers Agents 构建具有工具调用超能力的智能体 🦸",local:"使用-transformers-agents-构建具有工具调用超能力的智能体-",headingTag:"h1"}}),Z=new r({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycy5naXQlMjNlZ2clM0R0cmFuc2Zvcm1lcnMlNUJhZ2VudHMlNUQlMjI=",highlighted:'!pip install <span class="hljs-string">&quot;git+https://github.com/huggingface/transformers.git#egg=transformers[agents]&quot;</span>',wrap:!1}}),B=new r({props:{code:"IXBpcCUyMGluc3RhbGwlMjBkYXRhc2V0cyUyMGh1Z2dpbmdmYWNlX2h1YiUyMGxhbmdjaGFpbiUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWNwdSUyMHNlcnBhcGklMjBnb29nbGUtc2VhcmNoLXJlc3VsdHMlMjBvcGVuYWklMjAtcQ==",highlighted:"!pip install datasets huggingface_hub langchain sentence-transformers faiss-cpu serpapi google-search-results openai -q",wrap:!1}}),G=new T({props:{title:"1. 🏞️ 多模态 + 🌐 网络浏览助手",local:"1--多模态---网络浏览助手",headingTag:"h2"}}),_=new r({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRvb2wlMkMlMjBsb2FkX3Rvb2wlMkMlMjBSZWFjdENvZGVBZ2VudCUyQyUyMEhmRW5naW5lJTBBJTBBJTIzJTIwSW1wb3J0JTIwdG9vbCUyMGZyb20lMjBIdWIlMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybS1yaWMlMkZ0ZXh0LXRvLWltYWdlJTIyKSUwQSUwQSUyMyUyMEltcG9ydCUyMHRvb2wlMjBmcm9tJTIwTGFuZ0NoYWluJTBBZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQSUwQWxsbV9lbmdpbmUlMjAlM0QlMjBIZkVuZ2luZSglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLTcwQi1JbnN0cnVjdCUyMiklMEElMjMlMjBJbml0aWFsaXplJTIwdGhlJTIwYWdlbnQlMjB3aXRoJTIwYm90aCUyMHRvb2xzJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCUyQyUyMHNlYXJjaF90b29sJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUpJTBBJTBBJTIzJTIwUnVuJTIwaXQhJTBBcmVzdWx0JTIwJTNEJTIwYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkdlbmVyYXRlJTIwbWUlMjBhJTIwcGhvdG8lMjBvZiUyMHRoZSUyMGNhciUyMHRoYXQlMjBKYW1lcyUyMGJvbmQlMjBkcm92ZSUyMGluJTIwdGhlJTIwbGF0ZXN0JTIwbW92aWUuJTIyJTJDJTBBKSUwQXJlc3VsdA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Tool, load_tool, ReactCodeAgent, HfEngine

<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>)

<span class="hljs-comment"># Import tool from LangChain</span>
<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])


llm_engine = HfEngine(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-comment"># Initialize the agent with both tools</span>
agent = ReactCodeAgent(tools=[image_generation_tool, search_tool], llm_engine=llm_engine)

<span class="hljs-comment"># Run it!</span>
result = agent.run(
    <span class="hljs-string">&quot;Generate me a photo of the car that James bond drove in the latest movie.&quot;</span>,
)
result`,wrap:!1}}),R=new T({props:{title:"2. 📚💬 带有迭代查询优化和来源选择的 RAG",local:"2--带有迭代查询优化和来源选择的-rag",headingTag:"h2"}}),E=new r({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEElMEFrbm93bGVkZ2VfYmFzZSUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJtLXJpYyUyRmh1Z2dpbmdmYWNlX2RvYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> datasets

knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),x=new r({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2NzdG9yZS5kb2N1bWVudCUyMGltcG9ydCUyMERvY3VtZW50JTBBZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW5fY29tbXVuaXR5LmVtYmVkZGluZ3MlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MlMEElMEFzb3VyY2VfZG9jcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMERvY3VtZW50KHBhZ2VfY29udGVudCUzRGRvYyU1QiUyMnRleHQlMjIlNUQlMkMlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZSUyMiUzQSUyMGRvYyU1QiUyMnNvdXJjZSUyMiU1RC5zcGxpdCglMjIlMkYlMjIpJTVCMSU1RCU3RCklMjBmb3IlMjBkb2MlMjBpbiUyMGtub3dsZWRnZV9iYXNlJTBBJTVEJTBBJTBBZG9jc19wcm9jZXNzZWQlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDUwMCkuc3BsaXRfZG9jdW1lbnRzKHNvdXJjZV9kb2NzKSU1QiUzQTEwMDAlNUQlMEElMEFlbWJlZGRpbmdfbW9kZWwlMjAlM0QlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MobW9kZWxfbmFtZSUzRCUyMnRoZW5scGVyJTJGZ3RlLXNtYWxsJTIyKSUwQXZlY3RvcmRiJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoZG9jdW1lbnRzJTNEZG9jc19wcm9jZXNzZWQlMkMlMjBlbWJlZGRpbmclM0RlbWJlZGRpbmdfbW9kZWwp",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]}) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
]

docs_processed = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">500</span>).split_documents(source_docs)[:<span class="hljs-number">1000</span>]

embedding_model = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>)
vectordb = FAISS.from_documents(documents=docs_processed, embedding=embedding_model)`,wrap:!1}}),q=new r({props:{code:"YWxsX3NvdXJjZXMlMjAlM0QlMjBsaXN0KHNldCglNUJkb2MubWV0YWRhdGElNUIlMjJzb3VyY2UlMjIlNUQlMjBmb3IlMjBkb2MlMjBpbiUyMGRvY3NfcHJvY2Vzc2VkJTVEKSklMEFwcmludChhbGxfc291cmNlcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>all_sources = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>([doc.metadata[<span class="hljs-string">&quot;source&quot;</span>] <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs_processed]))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(all_sources)`,wrap:!1}}),L=new r({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_core.vectorstores <span class="hljs-keyword">import</span> VectorStore


<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = (
        <span class="hljs-string">&quot;Retrieves some documents from the knowledge base that have the closest embeddings to the input query.&quot;</span>
    )
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        },
        <span class="hljs-string">&quot;source&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;&quot;</span>},
        <span class="hljs-string">&quot;number_of_documents&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the number of documents to retrieve. Stay under 10 to avoid drowning in docs&quot;</span>,
        },
    }
    output_type = <span class="hljs-string">&quot;text&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, vectordb: VectorStore, all_sources: <span class="hljs-built_in">str</span>, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.vectordb = vectordb
        self.inputs[<span class="hljs-string">&quot;source&quot;</span>][
            <span class="hljs-string">&quot;description&quot;</span>
        ] = <span class="hljs-string">f&quot;The source of the documents to search, as a str representation of a list. Possible values in the list are: <span class="hljs-subst">{all_sources}</span>. If this argument is not provided, all sources will be searched.&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span>, source: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span>, number_of_documents=<span class="hljs-number">7</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>
        number_of_documents = <span class="hljs-built_in">int</span>(number_of_documents)

        <span class="hljs-keyword">if</span> source:
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(source, <span class="hljs-built_in">str</span>) <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;[&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">str</span>(source):  <span class="hljs-comment"># if the source is not representing a list</span>
                source = [source]
            source = json.loads(<span class="hljs-built_in">str</span>(source).replace(<span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>))

        docs = self.vectordb.similarity_search(
            query,
            <span class="hljs-built_in">filter</span>=({<span class="hljs-string">&quot;source&quot;</span>: source} <span class="hljs-keyword">if</span> source <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>),
            k=number_of_documents,
        )

        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(docs) == <span class="hljs-number">0</span>:
            <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;No documents found with this filtering. Try removing the source filter.&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Retrieved documents:\\n\\n&quot;</span> + <span class="hljs-string">&quot;\\n===Document===\\n&quot;</span>.join([doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs])`,wrap:!1}}),P=new T({props:{title:"可选：将你的检索器工具分享到 Hub",local:"可选将你的检索器工具分享到-hub",headingTag:"h3"}}),O=new r({props:{code:"c2hhcmVfdG9faHViJTIwJTNEJTIwRmFsc2UlMEElMEFpZiUyMHNoYXJlX3RvX2h1YiUzQSUwQSUyMCUyMCUyMCUyMGZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBsb2dpbiUwQSUyMCUyMCUyMCUyMGZyb20lMjByZXRyaWV2ZXIlMjBpbXBvcnQlMjBSZXRyaWV2ZXJUb29sJTBBJTBBJTIwJTIwJTIwJTIwbG9naW4oJTIyeW91cl90b2tlbiUyMiklMEElMEElMjAlMjAlMjAlMjB0b29sJTIwJTNEJTIwUmV0cmlldmVyVG9vbCh2ZWN0b3JkYiUyQyUyMGFsbF9zb3VyY2VzKSUwQSUwQSUyMCUyMCUyMCUyMHRvb2wucHVzaF90b19odWIocmVwb19pZCUzRCUyMm0tcmljJTJGcmV0cmlldmVyLXRvb2wlMjIp",highlighted:`share_to_hub = <span class="hljs-literal">False</span>

<span class="hljs-keyword">if</span> share_to_hub:
    <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
    <span class="hljs-keyword">from</span> retriever <span class="hljs-keyword">import</span> RetrieverTool

    login(<span class="hljs-string">&quot;your_token&quot;</span>)

    tool = RetrieverTool(vectordb, all_sources)

    tool.push_to_hub(repo_id=<span class="hljs-string">&quot;m-ric/retriever-tool&quot;</span>)`,wrap:!1}}),ll=new T({props:{title:"运行智能体!",local:"运行智能体",headingTag:"h3"}}),sl=new r({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBIZkVuZ2luZSUyQyUyMFJlYWN0SnNvbkFnZW50JTJDJTIwbG9hZF90b29sJTBBJTBBbGxtX2VuZ2luZSUyMCUzRCUyMEhmRW5naW5lKCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtNzBCLUluc3RydWN0JTIyKSUwQSUwQXJldHJpZXZlcl90b29sJTIwJTNEJTIwbG9hZF90b29sKCUyMm0tcmljJTJGcmV0cmlldmVyLXRvb2wlMjIlMkMlMjB2ZWN0b3JkYiUzRHZlY3RvcmRiJTJDJTIwYWxsX3NvdXJjZXMlM0RhbGxfc291cmNlcyklMEFhZ2VudCUyMCUzRCUyMFJlYWN0SnNvbkFnZW50KHRvb2xzJTNEJTVCcmV0cmlldmVyX3Rvb2wlNUQlMkMlMjBsbG1fZW5naW5lJTNEbGxtX2VuZ2luZSUyQyUyMHZlcmJvc2UlM0QwKSUwQSUwQWFnZW50X291dHB1dCUyMCUzRCUyMGFnZW50LnJ1biglMjJQbGVhc2UlMjBzaG93JTIwbWUlMjBhJTIwTE9SQSUyMGZpbmV0dW5pbmclMjBzY3JpcHQlMjIpJTBBJTBBcHJpbnQoJTIyRmluYWwlMjBvdXRwdXQlM0ElMjIpJTBBcHJpbnQoYWdlbnRfb3V0cHV0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> HfEngine, ReactJsonAgent, load_tool

<span class="hljs-meta">&gt;&gt;&gt; </span>llm_engine = HfEngine(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>retriever_tool = load_tool(<span class="hljs-string">&quot;m-ric/retriever-tool&quot;</span>, vectordb=vectordb, all_sources=all_sources)
<span class="hljs-meta">&gt;&gt;&gt; </span>agent = ReactJsonAgent(tools=[retriever_tool], llm_engine=llm_engine, verbose=<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>agent_output = agent.run(<span class="hljs-string">&quot;Please show me a LORA finetuning script&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),pl=new T({props:{title:"3. 💻 调试 Python 代码",local:"3--调试-python-代码",headingTag:"h2"}}),ol=new r({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlYWN0Q29kZUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCklMEElMEFjb2RlJTIwJTNEJTIwJTIyJTIyJTIyJTBBbGlzdCUzRCU1QjAlMkMlMjAxJTJDJTIwMiU1RCUwQSUwQWZvciUyMGklMjBpbiUyMHJhbmdlKDQpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQobGlzdChpKSklMEElMjIlMjIlMjIlMEElMEFmaW5hbF9hbnN3ZXIlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySSUyMGhhdmUlMjBzb21lJTIwY29kZSUyMHRoYXQlMjBjcmVhdGVzJTIwYSUyMGJ1ZyUzQSUyMHBsZWFzZSUyMGRlYnVnJTIwaXQlMjBhbmQlMjByZXR1cm4lMjB0aGUlMjBmaW5hbCUyMGNvZGUlMjIlMkMlMEElMjAlMjAlMjAlMjBjb2RlJTNEY29kZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ReactCodeAgent

agent = ReactCodeAgent(tools=[])

code = <span class="hljs-string">&quot;&quot;&quot;
list=[0, 1, 2]

for i in range(4):
    print(list(i))
&quot;&quot;&quot;</span>

final_answer = agent.run(
    <span class="hljs-string">&quot;I have some code that creates a bug: please debug it and return the final code&quot;</span>,
    code=code,
)`,wrap:!1}}),jl=new r({props:{code:"cHJpbnQoZmluYWxfYW5zd2VyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(final_answer)',wrap:!1}}),cl=new T({props:{title:"4. 创建你自己的 LLM 引擎（OpenAI）",local:"4-创建你自己的-llm-引擎openai",headingTag:"h2"}}),ml=new r({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI
<span class="hljs-keyword">from</span> transformers.agents.llm_engine <span class="hljs-keyword">import</span> MessageRole, get_clean_message_list

openai_role_conversions = {
    MessageRole.TOOL_RESPONSE: <span class="hljs-string">&quot;user&quot;</span>,
}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">OpenAIEngine</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model_name=<span class="hljs-string">&quot;gpt-4o-2024-05-13&quot;</span></span>):
        self.model_name = model_name
        self.client = OpenAI(
            api_key=os.getenv(<span class="hljs-string">&quot;OPENAI_API_KEY&quot;</span>),
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, messages, stop_sequences=[]</span>):
        <span class="hljs-comment"># Get clean message list</span>
        messages = get_clean_message_list(messages, role_conversions=openai_role_conversions)

        <span class="hljs-comment"># Get LLM output</span>
        response = self.client.chat.completions.create(
            model=self.model_name,
            messages=messages,
            stop=stop_sequences,
        )
        <span class="hljs-keyword">return</span> response.choices[<span class="hljs-number">0</span>].message.content


openai_engine = OpenAIEngine()
agent = ReactCodeAgent(llm_engine=openai_engine, tools=[])

code = <span class="hljs-string">&quot;&quot;&quot;
list=[0, 1, 2]

for i in range(4):
    print(list(i))
&quot;&quot;&quot;</span>

final_answer = agent.run(
    <span class="hljs-string">&quot;I have some code that creates a bug: please debug it and return the final code&quot;</span>,
    code=code,
)`,wrap:!1}}),Tl=new r({props:{code:"cHJpbnQoZmluYWxfYW5zd2VyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(final_answer)',wrap:!1}}),ul=new T({props:{title:"➡️ 结论",local:"-结论",headingTag:"h2"}}),hl=new Gt({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/agents.md"}}),{c(){m=M("meta"),gl=n(),Cl=M("p"),Zl=n(),i(w.$$.fragment),Bl=n(),i(u.$$.fragment),Gl=n(),b=M("p"),b.innerHTML=Vs,vl=n(),d=M("p"),d.innerHTML=Ns,Wl=n(),I=M("p"),I.innerHTML=Qs,Al=n(),h=M("p"),h.innerHTML=Ss,_l=n(),C=M("p"),C.innerHTML=$s,kl=n(),f=M("p"),f.textContent=Es,Rl=n(),g=M("p"),g.innerHTML=Xs,Vl=n(),i(Z.$$.fragment),Nl=n(),i(B.$$.fragment),Ql=n(),i(G.$$.fragment),Sl=n(),v=M("p"),v.textContent=xs,$l=n(),W=M("p"),W.textContent=zs,El=n(),A=M("ul"),A.innerHTML=Ys,Xl=n(),i(_.$$.fragment),xl=n(),k=M("p"),k.innerHTML=Hs,zl=n(),i(R.$$.fragment),Yl=n(),V=M("p"),V.innerHTML=qs,Hl=n(),N=M("p"),N.textContent=Fs,ql=n(),Q=M("ul"),Q.innerHTML=Ls,Fl=n(),S=M("p"),S.innerHTML=Ps,Ll=n(),$=M("p"),$.innerHTML=Ks,Pl=n(),i(E.$$.fragment),Kl=n(),X=M("p"),X.textContent=Ds,Dl=n(),i(x.$$.fragment),Ol=n(),z=M("p"),z.textContent=Os,ls=n(),Y=M("p"),Y.textContent=lt,ss=n(),H=M("p"),H.textContent=st,ts=n(),i(q.$$.fragment),es=n(),F=M("pre"),F.textContent=tt,ns=n(),i(L.$$.fragment),as=n(),i(P.$$.fragment),Ms=n(),K=M("p"),K.innerHTML=et,ps=n(),D=M("p"),D.innerHTML=nt,os=n(),i(O.$$.fragment),is=n(),i(ll.$$.fragment),ys=n(),i(sl.$$.fragment),js=n(),tl=M("pre"),tl.textContent=at,Js=n(),el=M("p"),el.innerHTML=Mt,cs=n(),nl=M("p"),nl.textContent=pt,Us=n(),al=M("p"),al.textContent=ot,rs=n(),Ml=M("p"),Ml.innerHTML=it,ms=n(),i(pl.$$.fragment),Ts=n(),i(ol.$$.fragment),ws=n(),il=M("p"),il.textContent=yt,us=n(),yl=M("p"),yl.textContent=jt,bs=n(),i(jl.$$.fragment),ds=n(),Jl=M("pre"),Jl.textContent=Jt,Is=n(),i(cl.$$.fragment),hs=n(),Ul=M("p"),Ul.innerHTML=ct,Cs=n(),rl=M("ol"),rl.innerHTML=Ut,fs=n(),i(ml.$$.fragment),gs=n(),i(Tl.$$.fragment),Zs=n(),wl=M("pre"),wl.textContent=rt,Bs=n(),i(ul.$$.fragment),Gs=n(),bl=M("p"),bl.textContent=mt,vs=n(),dl=M("p"),dl.innerHTML=Tt,Ws=n(),Il=M("p"),Il.textContent=wt,As=n(),i(hl.$$.fragment),_s=n(),fl=M("p"),this.h()},l(l){const s=gt("svelte-u9bgzb",document.head);m=p(s,"META",{name:!0,content:!0}),s.forEach(t),gl=a(l),Cl=p(l,"P",{}),ut(Cl).forEach(t),Zl=a(l),y(w.$$.fragment,l),Bl=a(l),y(u.$$.fragment,l),Gl=a(l),b=p(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1ouqjzx"&&(b.innerHTML=Vs),vl=a(l),d=p(l,"P",{"data-svelte-h":!0}),o(d)!=="svelte-1aj2n89"&&(d.innerHTML=Ns),Wl=a(l),I=p(l,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1krmqaz"&&(I.innerHTML=Qs),Al=a(l),h=p(l,"P",{"data-svelte-h":!0}),o(h)!=="svelte-adzud6"&&(h.innerHTML=Ss),_l=a(l),C=p(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-4p8oo0"&&(C.innerHTML=$s),kl=a(l),f=p(l,"P",{"data-svelte-h":!0}),o(f)!=="svelte-coem00"&&(f.textContent=Es),Rl=a(l),g=p(l,"P",{"data-svelte-h":!0}),o(g)!=="svelte-v3xboo"&&(g.innerHTML=Xs),Vl=a(l),y(Z.$$.fragment,l),Nl=a(l),y(B.$$.fragment,l),Ql=a(l),y(G.$$.fragment,l),Sl=a(l),v=p(l,"P",{"data-svelte-h":!0}),o(v)!=="svelte-kkdqgb"&&(v.textContent=xs),$l=a(l),W=p(l,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1gjy54v"&&(W.textContent=zs),El=a(l),A=p(l,"UL",{"data-svelte-h":!0}),o(A)!=="svelte-19kqik7"&&(A.innerHTML=Ys),Xl=a(l),y(_.$$.fragment,l),xl=a(l),k=p(l,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1hg95q8"&&(k.innerHTML=Hs),zl=a(l),y(R.$$.fragment,l),Yl=a(l),V=p(l,"P",{"data-svelte-h":!0}),o(V)!=="svelte-na4ngx"&&(V.innerHTML=qs),Hl=a(l),N=p(l,"P",{"data-svelte-h":!0}),o(N)!=="svelte-80vjwa"&&(N.textContent=Fs),ql=a(l),Q=p(l,"UL",{"data-svelte-h":!0}),o(Q)!=="svelte-1b72t5y"&&(Q.innerHTML=Ls),Fl=a(l),S=p(l,"P",{"data-svelte-h":!0}),o(S)!=="svelte-kok7hx"&&(S.innerHTML=Ps),Ll=a(l),$=p(l,"P",{"data-svelte-h":!0}),o($)!=="svelte-1o7very"&&($.innerHTML=Ks),Pl=a(l),y(E.$$.fragment,l),Kl=a(l),X=p(l,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1maw09u"&&(X.textContent=Ds),Dl=a(l),y(x.$$.fragment,l),Ol=a(l),z=p(l,"P",{"data-svelte-h":!0}),o(z)!=="svelte-18cve4f"&&(z.textContent=Os),ls=a(l),Y=p(l,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1uorx1q"&&(Y.textContent=lt),ss=a(l),H=p(l,"P",{"data-svelte-h":!0}),o(H)!=="svelte-152zwsq"&&(H.textContent=st),ts=a(l),y(q.$$.fragment,l),es=a(l),F=p(l,"PRE",{"data-svelte-h":!0}),o(F)!=="svelte-87x3d8"&&(F.textContent=tt),ns=a(l),y(L.$$.fragment,l),as=a(l),y(P.$$.fragment,l),Ms=a(l),K=p(l,"P",{"data-svelte-h":!0}),o(K)!=="svelte-shnfcu"&&(K.innerHTML=et),ps=a(l),D=p(l,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1f95672"&&(D.innerHTML=nt),os=a(l),y(O.$$.fragment,l),is=a(l),y(ll.$$.fragment,l),ys=a(l),y(sl.$$.fragment,l),js=a(l),tl=p(l,"PRE",{"data-svelte-h":!0}),o(tl)!=="svelte-l44zt6"&&(tl.textContent=at),Js=a(l),el=p(l,"P",{"data-svelte-h":!0}),o(el)!=="svelte-1p0xa06"&&(el.innerHTML=Mt),cs=a(l),nl=p(l,"P",{"data-svelte-h":!0}),o(nl)!=="svelte-lx9k8m"&&(nl.textContent=pt),Us=a(l),al=p(l,"P",{"data-svelte-h":!0}),o(al)!=="svelte-ukynxq"&&(al.textContent=ot),rs=a(l),Ml=p(l,"P",{"data-svelte-h":!0}),o(Ml)!=="svelte-b42cxp"&&(Ml.innerHTML=it),ms=a(l),y(pl.$$.fragment,l),Ts=a(l),y(ol.$$.fragment,l),ws=a(l),il=p(l,"P",{"data-svelte-h":!0}),o(il)!=="svelte-exzkfa"&&(il.textContent=yt),us=a(l),yl=p(l,"P",{"data-svelte-h":!0}),o(yl)!=="svelte-yhuzec"&&(yl.textContent=jt),bs=a(l),y(jl.$$.fragment,l),ds=a(l),Jl=p(l,"PRE",{"data-svelte-h":!0}),o(Jl)!=="svelte-1t45l4d"&&(Jl.textContent=Jt),Is=a(l),y(cl.$$.fragment,l),hs=a(l),Ul=p(l,"P",{"data-svelte-h":!0}),o(Ul)!=="svelte-1keb31l"&&(Ul.innerHTML=ct),Cs=a(l),rl=p(l,"OL",{"data-svelte-h":!0}),o(rl)!=="svelte-vma4hg"&&(rl.innerHTML=Ut),fs=a(l),y(ml.$$.fragment,l),gs=a(l),y(Tl.$$.fragment,l),Zs=a(l),wl=p(l,"PRE",{"data-svelte-h":!0}),o(wl)!=="svelte-tgqz6q"&&(wl.textContent=rt),Bs=a(l),y(ul.$$.fragment,l),Gs=a(l),bl=p(l,"P",{"data-svelte-h":!0}),o(bl)!=="svelte-9ugofh"&&(bl.textContent=mt),vs=a(l),dl=p(l,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-1852ggb"&&(dl.innerHTML=Tt),Ws=a(l),Il=p(l,"P",{"data-svelte-h":!0}),o(Il)!=="svelte-w83c4h"&&(Il.textContent=wt),As=a(l),y(hl.$$.fragment,l),_s=a(l),fl=p(l,"P",{}),ut(fl).forEach(t),this.h()},h(){bt(m,"name","hf:doc:metadata"),bt(m,"content",Wt)},m(l,s){Zt(document.head,m),e(l,gl,s),e(l,Cl,s),e(l,Zl,s),j(w,l,s),e(l,Bl,s),j(u,l,s),e(l,Gl,s),e(l,b,s),e(l,vl,s),e(l,d,s),e(l,Wl,s),e(l,I,s),e(l,Al,s),e(l,h,s),e(l,_l,s),e(l,C,s),e(l,kl,s),e(l,f,s),e(l,Rl,s),e(l,g,s),e(l,Vl,s),j(Z,l,s),e(l,Nl,s),j(B,l,s),e(l,Ql,s),j(G,l,s),e(l,Sl,s),e(l,v,s),e(l,$l,s),e(l,W,s),e(l,El,s),e(l,A,s),e(l,Xl,s),j(_,l,s),e(l,xl,s),e(l,k,s),e(l,zl,s),j(R,l,s),e(l,Yl,s),e(l,V,s),e(l,Hl,s),e(l,N,s),e(l,ql,s),e(l,Q,s),e(l,Fl,s),e(l,S,s),e(l,Ll,s),e(l,$,s),e(l,Pl,s),j(E,l,s),e(l,Kl,s),e(l,X,s),e(l,Dl,s),j(x,l,s),e(l,Ol,s),e(l,z,s),e(l,ls,s),e(l,Y,s),e(l,ss,s),e(l,H,s),e(l,ts,s),j(q,l,s),e(l,es,s),e(l,F,s),e(l,ns,s),j(L,l,s),e(l,as,s),j(P,l,s),e(l,Ms,s),e(l,K,s),e(l,ps,s),e(l,D,s),e(l,os,s),j(O,l,s),e(l,is,s),j(ll,l,s),e(l,ys,s),j(sl,l,s),e(l,js,s),e(l,tl,s),e(l,Js,s),e(l,el,s),e(l,cs,s),e(l,nl,s),e(l,Us,s),e(l,al,s),e(l,rs,s),e(l,Ml,s),e(l,ms,s),j(pl,l,s),e(l,Ts,s),j(ol,l,s),e(l,ws,s),e(l,il,s),e(l,us,s),e(l,yl,s),e(l,bs,s),j(jl,l,s),e(l,ds,s),e(l,Jl,s),e(l,Is,s),j(cl,l,s),e(l,hs,s),e(l,Ul,s),e(l,Cs,s),e(l,rl,s),e(l,fs,s),j(ml,l,s),e(l,gs,s),j(Tl,l,s),e(l,Zs,s),e(l,wl,s),e(l,Bs,s),j(ul,l,s),e(l,Gs,s),e(l,bl,s),e(l,vs,s),e(l,dl,s),e(l,Ws,s),e(l,Il,s),e(l,As,s),j(hl,l,s),e(l,_s,s),e(l,fl,s),ks=!0},p:It,i(l){ks||(J(w.$$.fragment,l),J(u.$$.fragment,l),J(Z.$$.fragment,l),J(B.$$.fragment,l),J(G.$$.fragment,l),J(_.$$.fragment,l),J(R.$$.fragment,l),J(E.$$.fragment,l),J(x.$$.fragment,l),J(q.$$.fragment,l),J(L.$$.fragment,l),J(P.$$.fragment,l),J(O.$$.fragment,l),J(ll.$$.fragment,l),J(sl.$$.fragment,l),J(pl.$$.fragment,l),J(ol.$$.fragment,l),J(jl.$$.fragment,l),J(cl.$$.fragment,l),J(ml.$$.fragment,l),J(Tl.$$.fragment,l),J(ul.$$.fragment,l),J(hl.$$.fragment,l),ks=!0)},o(l){c(w.$$.fragment,l),c(u.$$.fragment,l),c(Z.$$.fragment,l),c(B.$$.fragment,l),c(G.$$.fragment,l),c(_.$$.fragment,l),c(R.$$.fragment,l),c(E.$$.fragment,l),c(x.$$.fragment,l),c(q.$$.fragment,l),c(L.$$.fragment,l),c(P.$$.fragment,l),c(O.$$.fragment,l),c(ll.$$.fragment,l),c(sl.$$.fragment,l),c(pl.$$.fragment,l),c(ol.$$.fragment,l),c(jl.$$.fragment,l),c(cl.$$.fragment,l),c(ml.$$.fragment,l),c(Tl.$$.fragment,l),c(ul.$$.fragment,l),c(hl.$$.fragment,l),ks=!1},d(l){l&&(t(gl),t(Cl),t(Zl),t(Bl),t(Gl),t(b),t(vl),t(d),t(Wl),t(I),t(Al),t(h),t(_l),t(C),t(kl),t(f),t(Rl),t(g),t(Vl),t(Nl),t(Ql),t(Sl),t(v),t($l),t(W),t(El),t(A),t(Xl),t(xl),t(k),t(zl),t(Yl),t(V),t(Hl),t(N),t(ql),t(Q),t(Fl),t(S),t(Ll),t($),t(Pl),t(Kl),t(X),t(Dl),t(Ol),t(z),t(ls),t(Y),t(ss),t(H),t(ts),t(es),t(F),t(ns),t(as),t(Ms),t(K),t(ps),t(D),t(os),t(is),t(ys),t(js),t(tl),t(Js),t(el),t(cs),t(nl),t(Us),t(al),t(rs),t(Ml),t(ms),t(Ts),t(ws),t(il),t(us),t(yl),t(bs),t(ds),t(Jl),t(Is),t(hs),t(Ul),t(Cs),t(rl),t(fs),t(gs),t(Zs),t(wl),t(Bs),t(Gs),t(bl),t(vs),t(dl),t(Ws),t(Il),t(As),t(_s),t(fl)),t(m),U(w,l),U(u,l),U(Z,l),U(B,l),U(G,l),U(_,l),U(R,l),U(E,l),U(x,l),U(q,l),U(L,l),U(P,l),U(O,l),U(ll,l),U(sl,l),U(pl,l),U(ol,l),U(jl,l),U(cl,l),U(ml,l),U(Tl,l),U(ul,l),U(hl,l)}}}const Wt='{"title":"使用 Transformers Agents 构建具有工具调用超能力的智能体 🦸","local":"使用-transformers-agents-构建具有工具调用超能力的智能体-","sections":[{"title":"1. 🏞️ 多模态 + 🌐 网络浏览助手","local":"1--多模态---网络浏览助手","sections":[],"depth":2},{"title":"2. 📚💬 带有迭代查询优化和来源选择的 RAG","local":"2--带有迭代查询优化和来源选择的-rag","sections":[{"title":"可选：将你的检索器工具分享到 Hub","local":"可选将你的检索器工具分享到-hub","sections":[],"depth":3},{"title":"运行智能体!","local":"运行智能体","sections":[],"depth":3}],"depth":2},{"title":"3. 💻 调试 Python 代码","local":"3--调试-python-代码","sections":[],"depth":2},{"title":"4. 创建你自己的 LLM 引擎（OpenAI）","local":"4-创建你自己的-llm-引擎openai","sections":[],"depth":2},{"title":"➡️ 结论","local":"-结论","sections":[],"depth":2}],"depth":1}';function At(Rs){return ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nt extends Ct{constructor(m){super(),ft(this,m,At,vt,dt,{})}}export{Nt as component};
