import{s as bo,o as Mo,n as Ft}from"../chunks/scheduler.182ea377.js";import{S as vo,i as wo,g as d,s as n,r as m,A as xo,h as r,f as o,c as s,j as D,u,x as p,k as T,y as a,a as i,v as f,d as g,t as h,w as _}from"../chunks/index.abf12888.js";import{T as yo}from"../chunks/Tip.230e2334.js";import{D as $}from"../chunks/Docstring.93f6f462.js";import{C as _o}from"../chunks/CodeBlock.57fe6e13.js";import{E as ho}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as U}from"../chunks/Heading.16916d63.js";function Do(B){let c,k='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){c=d("p"),c.innerHTML=k},l(v){c=r(v,"P",{"data-svelte-h":!0}),p(c)!=="svelte-1wmc0l4"&&(c.innerHTML=k)},m(v,M){i(v,c,M)},p:Ft,d(v){v&&o(c)}}}function To(B){let c,k="Examples:",v,M,x;return M=new _o({props:{code:"aW1wb3J0JTIwc2NpcHklMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBBdWRpb0xETTJQaXBlbGluZSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJjdnNzcCUyRmF1ZGlvbGRtMiUyMiUwQXBpcGUlMjAlM0QlMjBBdWRpb0xETTJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMGRlZmluZSUyMHRoZSUyMHByb21wdHMlMEFwcm9tcHQlMjAlM0QlMjAlMjJUaGUlMjBzb3VuZCUyMG9mJTIwYSUyMGhhbW1lciUyMGhpdHRpbmclMjBhJTIwd29vZGVuJTIwc3VyZmFjZS4lMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJMb3clMjBxdWFsaXR5LiUyMiUwQSUwQSUyMyUyMHNldCUyMHRoZSUyMHNlZWQlMjBmb3IlMjBnZW5lcmF0b3IlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMCklMEElMEElMjMlMjBydW4lMjB0aGUlMjBnZW5lcmF0aW9uJTBBYXVkaW8lMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRG5lZ2F0aXZlX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMDAlMkMlMEElMjAlMjAlMjAlMjBhdWRpb19sZW5ndGhfaW5fcyUzRDEwLjAlMkMlMEElMjAlMjAlMjAlMjBudW1fd2F2ZWZvcm1zX3Blcl9wcm9tcHQlM0QzJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5hdWRpb3MlMEElMEElMjMlMjBzYXZlJTIwdGhlJTIwYmVzdCUyMGF1ZGlvJTIwc2FtcGxlJTIwKGluZGV4JTIwMCklMjBhcyUyMGElMjAud2F2JTIwZmlsZSUwQXNjaXB5LmlvLndhdmZpbGUud3JpdGUoJTIydGVjaG5vLndhdiUyMiUyQyUyMHJhdGUlM0QxNjAwMCUyQyUyMGRhdGElM0RhdWRpbyU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> scipy
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AudioLDM2Pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;cvssp/audioldm2&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AudioLDM2Pipeline.from_pretrained(repo_id, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define the prompts</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;The sound of a hammer hitting a wooden surface.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;Low quality.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set the seed for generator</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># run the generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    audio_length_in_s=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>    num_waveforms_per_prompt=<span class="hljs-number">3</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>).audios

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save the best audio sample (index 0) as a .wav file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>scipy.io.wavfile.write(<span class="hljs-string">&quot;techno.wav&quot;</span>, rate=<span class="hljs-number">16000</span>, data=audio[<span class="hljs-number">0</span>])`,wrap:!1}}),{c(){c=d("p"),c.textContent=k,v=n(),m(M.$$.fragment)},l(l){c=r(l,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=k),v=s(l),u(M.$$.fragment,l)},m(l,y){i(l,c,y),i(l,v,y),f(M,l,y),x=!0},p:Ft,i(l){x||(g(M.$$.fragment,l),x=!0)},o(l){h(M.$$.fragment,l),x=!1},d(l){l&&(o(c),o(v)),_(M,l)}}}function ko(B){let c,k="Example:",v,M,x;return M=new _o({props:{code:"aW1wb3J0JTIwc2NpcHklMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBBdWRpb0xETTJQaXBlbGluZSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJjdnNzcCUyRmF1ZGlvbGRtMiUyMiUwQXBpcGUlMjAlM0QlMjBBdWRpb0xETTJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMEdldCUyMHRleHQlMjBlbWJlZGRpbmclMjB2ZWN0b3JzJTBBcHJvbXB0X2VtYmVkcyUyQyUyMGF0dGVudGlvbl9tYXNrJTJDJTIwZ2VuZXJhdGVkX3Byb21wdF9lbWJlZHMlMjAlM0QlMjBwaXBlLmVuY29kZV9wcm9tcHQoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyVGVjaG5vJTIwbXVzaWMlMjB3aXRoJTIwYSUyMHN0cm9uZyUyQyUyMHVwYmVhdCUyMHRlbXBvJTIwYW5kJTIwaGlnaCUyMG1lbG9kaWMlMjByaWZmcyUyMiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMEElMjAlMjAlMjAlMjBkb19jbGFzc2lmaWVyX2ZyZWVfZ3VpZGFuY2UlM0RUcnVlJTJDJTBBKSUwQSUwQSUyMyUyMFBhc3MlMjB0ZXh0JTIwZW1iZWRkaW5ncyUyMHRvJTIwcGlwZWxpbmUlMjBmb3IlMjB0ZXh0LWNvbmRpdGlvbmFsJTIwYXVkaW8lMjBnZW5lcmF0aW9uJTBBYXVkaW8lMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdF9lbWJlZHMlM0Rwcm9tcHRfZW1iZWRzJTJDJTBBJTIwJTIwJTIwJTIwYXR0ZW50aW9uX21hc2slM0RhdHRlbnRpb25fbWFzayUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlZF9wcm9tcHRfZW1iZWRzJTNEZ2VuZXJhdGVkX3Byb21wdF9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjAwJTJDJTBBJTIwJTIwJTIwJTIwYXVkaW9fbGVuZ3RoX2luX3MlM0QxMC4wJTJDJTBBKS5hdWRpb3MlNUIwJTVEJTBBJTBBJTIzJTIwc2F2ZSUyMGdlbmVyYXRlZCUyMGF1ZGlvJTIwc2FtcGxlJTBBc2NpcHkuaW8ud2F2ZmlsZS53cml0ZSglMjJ0ZWNobm8ud2F2JTIyJTJDJTIwcmF0ZSUzRDE2MDAwJTJDJTIwZGF0YSUzRGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> scipy
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AudioLDM2Pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;cvssp/audioldm2&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AudioLDM2Pipeline.from_pretrained(repo_id, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get text embedding vectors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_embeds, attention_mask, generated_prompt_embeds = pipe.encode_prompt(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;Techno music with a strong, upbeat tempo and high melodic riffs&quot;</span>,
<span class="hljs-meta">... </span>    device=<span class="hljs-string">&quot;cuda&quot;</span>,
<span class="hljs-meta">... </span>    do_classifier_free_guidance=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pass text embeddings to pipeline for text-conditional audio generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = pipe(
<span class="hljs-meta">... </span>    prompt_embeds=prompt_embeds,
<span class="hljs-meta">... </span>    attention_mask=attention_mask,
<span class="hljs-meta">... </span>    generated_prompt_embeds=generated_prompt_embeds,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    audio_length_in_s=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>).audios[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save generated audio sample</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>scipy.io.wavfile.write(<span class="hljs-string">&quot;techno.wav&quot;</span>, rate=<span class="hljs-number">16000</span>, data=audio)`,wrap:!1}}),{c(){c=d("p"),c.textContent=k,v=n(),m(M.$$.fragment)},l(l){c=r(l,"P",{"data-svelte-h":!0}),p(c)!=="svelte-11lpom8"&&(c.textContent=k),v=s(l),u(M.$$.fragment,l)},m(l,y){i(l,c,y),i(l,v,y),f(M,l,y),x=!0},p:Ft,i(l){x||(g(M.$$.fragment,l),x=!0)},o(l){h(M.$$.fragment,l),x=!1},d(l){l&&(o(c),o(v)),_(M,l)}}}function Ao(B){let c,k,v,M,x,l,y,St='AudioLDM 2 was proposed in <a href="https://arxiv.org/abs/2308.05734" rel="nofollow">AudioLDM 2: Learning Holistic Audio Generation with Self-supervised Pretraining</a> by Haohe Liu et al. AudioLDM 2 takes a text prompt as input and predicts the corresponding audio. It can generate text-conditional sound effects, human speech and music.',Ee,H,Wt='Inspired by <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/overview" rel="nofollow">Stable Diffusion</a>, AudioLDM 2 is a text-to-audio <em>latent diffusion model (LDM)</em> that learns continuous audio representations from text embeddings. Two text encoder models are used to compute the text embeddings from a prompt input: the text-branch of <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clap" rel="nofollow">CLAP</a> and the encoder of <a href="https://huggingface.co/docs/transformers/main/en/model_doc/flan-t5" rel="nofollow">Flan-T5</a>. These text embeddings are then projected to a shared embedding space by an <a href="https://huggingface.co/docs/diffusers/main/api/pipelines/audioldm2#diffusers.AudioLDM2ProjectionModel" rel="nofollow">AudioLDM2ProjectionModel</a>. A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/gpt2" rel="nofollow">GPT2</a> <em>language model (LM)</em> is used to auto-regressively predict eight new embedding vectors, conditional on the projected CLAP and Flan-T5 embeddings. The generated embedding vectors and Flan-T5 text embeddings are used as cross-attention conditioning in the LDM. The <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/audioldm2#diffusers.AudioLDM2UNet2DConditionModel" rel="nofollow">UNet</a> of AudioLDM 2 is unique in the sense that it takes <strong>two</strong> cross-attention embeddings, as opposed to one cross-attention conditioning, as in most other LDMs.',Fe,O,Ht="The abstract of the paper is the following:",Se,Q,Ot='<em>Although audio generation shares commonalities across different types of audio, such as speech, music, and sound effects, designing models for each type requires careful consideration of specific objectives and biases that can significantly differ from those of other types. To bring us closer to a unified perspective of audio generation, this paper proposes a framework that utilizes the same learning method for speech, music, and sound effect generation. Our framework introduces a general representation of audio, called “language of audio” (LOA). Any audio can be translated into LOA based on AudioMAE, a self-supervised pre-trained representation learning model. In the generation process, we translate any modalities into LOA by using a GPT-2 model, and we perform self-supervised audio generation learning with a latent diffusion model conditioned on LOA. The proposed framework naturally brings advantages such as in-context learning abilities and reusable self-supervised pretrained AudioMAE and latent diffusion models. Experiments on the major benchmarks of text-to-audio, text-to-music, and text-to-speech demonstrate state-of-the-art or competitive performance against previous approaches. Our code, pretrained model, and demo are available at <a href="https://audioldm.github.io/audioldm2" rel="nofollow">this https URL</a>.</em>',We,X,Qt='This pipeline was contributed by <a href="https://huggingface.co/sanchit-gandhi" rel="nofollow">sanchit-gandhi</a>. The original codebase can be found at <a href="https://github.com/haoheliu/audioldm2" rel="nofollow">haoheliu/audioldm2</a>.',He,z,Oe,R,Qe,V,Xt="AudioLDM2 comes in three variants. Two of these checkpoints are applicable to the general task of text-to-audio generation. The third checkpoint is trained exclusively on text-to-music generation.",Xe,Y,zt=`All checkpoints share the same model size for the text encoders and VAE. They differ in the size and depth of the UNet.
See table below for details on the three checkpoints:`,ze,K,Rt='<thead><tr><th>Checkpoint</th> <th>Task</th> <th>UNet Model Size</th> <th>Total Model Size</th> <th>Training Data / h</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/cvssp/audioldm2" rel="nofollow">audioldm2</a></td> <td>Text-to-audio</td> <td>350M</td> <td>1.1B</td> <td>1150k</td></tr> <tr><td><a href="https://huggingface.co/cvssp/audioldm2-large" rel="nofollow">audioldm2-large</a></td> <td>Text-to-audio</td> <td>750M</td> <td>1.5B</td> <td>1150k</td></tr> <tr><td><a href="https://huggingface.co/cvssp/audioldm2-music" rel="nofollow">audioldm2-music</a></td> <td>Text-to-music</td> <td>350M</td> <td>1.1B</td> <td>665k</td></tr></tbody>',Re,ee,Ve,te,Vt="<li>Descriptive prompt inputs work best: use adjectives to describe the sound (e.g. “high quality” or “clear”) and make the prompt context specific (e.g. “water stream in a forest” instead of “stream”).</li> <li>It’s best to use general terms like “cat” or “dog” instead of specific names or abstract objects the model may not be familiar with.</li> <li>Using a <strong>negative prompt</strong> can significantly improve the quality of the generated waveform, by guiding the generation away from terms that correspond to poor quality audio. Try using a negative prompt of “Low quality.”</li>",Ye,oe,Ke,ne,Yt="<li>The <em>quality</em> of the predicted audio sample can be controlled by the <code>num_inference_steps</code> argument; higher steps give higher quality audio at the expense of slower inference.</li> <li>The <em>length</em> of the predicted audio sample can be controlled by varying the <code>audio_length_in_s</code> argument.</li>",et,se,tt,ie,Kt="<li>The quality of the generated waveforms can vary significantly based on the seed. Try generating with different seeds until you find a satisfactory generation.</li> <li>Multiple waveforms can be generated in one go: set <code>num_waveforms_per_prompt</code> to a value greater than 1. Automatic scoring will be performed between the generated waveforms and prompt text, and the audios ranked from best to worst accordingly.</li>",ot,ae,eo='The following example demonstrates how to construct good music generation using the aforementioned tips: <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/audioldm2#diffusers.AudioLDM2Pipeline.__call__.example" rel="nofollow">example</a>.',nt,J,st,de,it,b,re,Mt,De,to="Pipeline for text-to-audio generation using AudioLDM2.",vt,Te,oo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,wt,j,le,xt,ke,no="The call function to the pipeline for generation.",yt,I,Dt,q,ce,Tt,Ae,so=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,kt,G,pe,At,$e,io=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,$t,Z,me,Lt,Le,ao=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,jt,C,ue,Ct,je,ro="Encodes the prompt into text encoder hidden states.",Ut,E,Pt,F,fe,Nt,Ce,lo="Generates a sequence of hidden-states from the language model, conditioned on the embedding inputs.",at,ge,dt,L,he,Bt,Ue,co=`A simple linear projection model to map two text embeddings to a shared latent space. It also inserts learned
embedding vectors at the start and end of each text embedding sequence respectively. Each variable appended with
<code>_1</code> refers to that corresponding to the second text encoder. Otherwise, it is from the first.`,Jt,Pe,_e,rt,be,lt,A,Me,It,Ne,po=`A conditional 2D UNet model that takes a noisy sample, conditional state, and a timestep and returns a sample
shaped output. Compared to the vanilla <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>, this variant optionally includes an additional
self-attention layer in each Transformer block, as well as multiple cross-attention layers. It also allows for up
to two cross-attention embeddings, <code>encoder_hidden_states</code> and <code>encoder_hidden_states_1</code>.`,qt,Be,mo=`This model inherits from <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a>. Check the superclass documentation for it’s generic methods implemented
for all models (such as downloading or saving).`,Gt,S,ve,Zt,Je,uo='The <a href="/docs/diffusers/main/en/api/pipelines/audioldm2#diffusers.AudioLDM2UNet2DConditionModel">AudioLDM2UNet2DConditionModel</a> forward method.',ct,we,pt,P,xe,Et,Ie,fo="Output class for audio pipelines.",mt,Ze,ut;return x=new U({props:{title:"AudioLDM 2",local:"audioldm-2",headingTag:"h1"}}),z=new U({props:{title:"Tips",local:"tips",headingTag:"h2"}}),R=new U({props:{title:"Choosing a checkpoint",local:"choosing-a-checkpoint",headingTag:"h3"}}),ee=new U({props:{title:"Constructing a prompt",local:"constructing-a-prompt",headingTag:"h3"}}),oe=new U({props:{title:"Controlling inference",local:"controlling-inference",headingTag:"h3"}}),se=new U({props:{title:"Evaluating generated waveforms:",local:"evaluating-generated-waveforms",headingTag:"h3"}}),J=new yo({props:{$$slots:{default:[Do]},$$scope:{ctx:B}}}),de=new U({props:{title:"AudioLDM2Pipeline",local:"diffusers.AudioLDM2Pipeline",headingTag:"h2"}}),re=new $({props:{name:"class diffusers.AudioLDM2Pipeline",anchor:"diffusers.AudioLDM2Pipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": ClapModel"},{name:"text_encoder_2",val:": T5EncoderModel"},{name:"projection_model",val:": AudioLDM2ProjectionModel"},{name:"language_model",val:": GPT2Model"},{name:"tokenizer",val:": Union"},{name:"tokenizer_2",val:": Union"},{name:"feature_extractor",val:": ClapFeatureExtractor"},{name:"unet",val:": AudioLDM2UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"vocoder",val:": SpeechT5HifiGan"}],parametersDescription:[{anchor:"diffusers.AudioLDM2Pipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.AudioLDM2Pipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clap#transformers.ClapModel" rel="nofollow">ClapModel</a>) &#x2014;
First frozen text-encoder. AudioLDM2 uses the joint audio-text embedding model
<a href="https://huggingface.co/docs/transformers/model_doc/clap#transformers.CLAPTextModelWithProjection" rel="nofollow">CLAP</a>,
specifically the <a href="https://huggingface.co/laion/clap-htsat-unfused" rel="nofollow">laion/clap-htsat-unfused</a> variant. The
text branch is used to encode the text prompt to a prompt embedding. The full audio-text model is used to
rank generated waveforms against the text prompt by computing similarity scores.`,name:"text_encoder"},{anchor:"diffusers.AudioLDM2Pipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5EncoderModel</a>) &#x2014;
Second frozen text-encoder. AudioLDM2 uses the encoder of
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically the
<a href="https://huggingface.co/google/flan-t5-large" rel="nofollow">google/flan-t5-large</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.AudioLDM2Pipeline.projection_model",description:`<strong>projection_model</strong> (<a href="/docs/diffusers/main/en/api/pipelines/audioldm2#diffusers.AudioLDM2ProjectionModel">AudioLDM2ProjectionModel</a>) &#x2014;
A trained model used to linearly project the hidden-states from the first and second text encoder models
and insert learned SOS and EOS token embeddings. The projected hidden-states from the two text encoders are
concatenated to give the input to the language model.`,name:"projection_model"},{anchor:"diffusers.AudioLDM2Pipeline.language_model",description:`<strong>language_model</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Model" rel="nofollow">GPT2Model</a>) &#x2014;
An auto-regressive language model used to generate a sequence of hidden-states conditioned on the projected
outputs from the two text encoders.`,name:"language_model"},{anchor:"diffusers.AudioLDM2Pipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizer" rel="nofollow">RobertaTokenizer</a>) &#x2014;
Tokenizer to tokenize text for the first frozen text-encoder.`,name:"tokenizer"},{anchor:"diffusers.AudioLDM2Pipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/mt5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>) &#x2014;
Tokenizer to tokenize text for the second frozen text-encoder.`,name:"tokenizer_2"},{anchor:"diffusers.AudioLDM2Pipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clap#transformers.ClapFeatureExtractor" rel="nofollow">ClapFeatureExtractor</a>) &#x2014;
Feature extractor to pre-process generated audio waveforms to log-mel spectrograms for automatic scoring.`,name:"feature_extractor"},{anchor:"diffusers.AudioLDM2Pipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded audio latents.`,name:"unet"},{anchor:"diffusers.AudioLDM2Pipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded audio latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.AudioLDM2Pipeline.vocoder",description:`<strong>vocoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5HifiGan" rel="nofollow">SpeechT5HifiGan</a>) &#x2014;
Vocoder of class <code>SpeechT5HifiGan</code> to convert the mel-spectrogram latents to the final audio waveform.`,name:"vocoder"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L103"}}),le=new $({props:{name:"__call__",anchor:"diffusers.AudioLDM2Pipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"audio_length_in_s",val:": Optional = None"},{name:"num_inference_steps",val:": int = 200"},{name:"guidance_scale",val:": float = 3.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_waveforms_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"generated_prompt_embeds",val:": Optional = None"},{name:"negative_generated_prompt_embeds",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"negative_attention_mask",val:": Optional = None"},{name:"max_new_tokens",val:": Optional = None"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": Optional = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"output_type",val:": Optional = 'np'"}],parametersDescription:[{anchor:"diffusers.AudioLDM2Pipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide audio generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.audio_length_in_s",description:`<strong>audio_length_in_s</strong> (<code>int</code>, <em>optional</em>, defaults to 10.24) &#x2014;
The length of the generated audio sample in seconds.`,name:"audio_length_in_s"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 200) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality audio at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.5) &#x2014;
A higher guidance scale value encourages the model to generate audio that is closely linked to the text
<code>prompt</code> at the expense of lower sound quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in audio generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.num_waveforms_per_prompt",description:`<strong>num_waveforms_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of waveforms to generate per prompt. If <code>num_waveforms_per_prompt &gt; 1</code>, then automatic
scoring is performed between the generated outputs and the text prompt. This scoring ranks the
generated waveforms based on their cosine similarity with the text input in the joint text-audio
embedding space.`,name:"num_waveforms_per_prompt"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for spectrogram
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.generated_prompt_embeds",description:`<strong>generated_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings from the GPT2 langauge model. Can be used to easily tweak text inputs,
<em>e.g.</em> prompt weighting. If not provided, text embeddings will be generated from <code>prompt</code> input
argument.`,name:"generated_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.negative_generated_prompt_embeds",description:`<strong>negative_generated_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings from the GPT2 language model. Can be used to easily tweak text
inputs, <em>e.g.</em> prompt weighting. If not provided, negative_prompt_embeds will be computed from
<code>negative_prompt</code> input argument.`,name:"negative_generated_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Pre-computed attention mask to be applied to the <code>prompt_embeds</code>. If not provided, attention mask will
be computed from <code>prompt</code> input argument.`,name:"attention_mask"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.negative_attention_mask",description:`<strong>negative_attention_mask</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Pre-computed attention mask to be applied to the <code>negative_prompt_embeds</code>. If not provided, attention
mask will be computed from <code>negative_prompt</code> input argument.`,name:"negative_attention_mask"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to None) &#x2014;
Number of new tokens to generate with the GPT2 language model. If not provided, number of tokens will
be taken from the config of the model.`,name:"max_new_tokens"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/latent_upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated audio. Choose between <code>&quot;np&quot;</code> to return a NumPy <code>np.ndarray</code> or
<code>&quot;pt&quot;</code> to return a PyTorch <code>torch.Tensor</code> object. Set to <code>&quot;latent&quot;</code> to return the latent diffusion
model (LDM) output.`,name:"output_type"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L732",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/latent_upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/latent_upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),I=new ho({props:{anchor:"diffusers.AudioLDM2Pipeline.__call__.example",$$slots:{default:[To]},$$scope:{ctx:B}}}),ce=new $({props:{name:"disable_vae_slicing",anchor:"diffusers.AudioLDM2Pipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L185"}}),pe=new $({props:{name:"enable_model_cpu_offload",anchor:"diffusers.AudioLDM2Pipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L192"}}),me=new $({props:{name:"enable_vae_slicing",anchor:"diffusers.AudioLDM2Pipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L177"}}),ue=new $({props:{name:"encode_prompt",anchor:"diffusers.AudioLDM2Pipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_waveforms_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"generated_prompt_embeds",val:": Optional = None"},{name:"negative_generated_prompt_embeds",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"negative_attention_mask",val:": Optional = None"},{name:"max_new_tokens",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
torch device`,name:"device"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.num_waveforms_per_prompt",description:`<strong>num_waveforms_per_prompt</strong> (<code>int</code>) &#x2014;
number of waveforms that should be generated per prompt`,name:"num_waveforms_per_prompt"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the audio generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-computed text embeddings from the Flan T5 model. Can be used to easily tweak text inputs, <em>e.g.</em>
prompt weighting. If not provided, text embeddings will be computed from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-computed negative text embeddings from the Flan T5 model. Can be used to easily tweak text inputs,
<em>e.g.</em> prompt weighting. If not provided, negative_prompt_embeds will be computed from
<code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.generated_prompt_embeds",description:`<strong>generated_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings from the GPT2 langauge model. Can be used to easily tweak text inputs,
<em>e.g.</em> prompt weighting. If not provided, text embeddings will be generated from <code>prompt</code> input
argument.`,name:"generated_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.negative_generated_prompt_embeds",description:`<strong>negative_generated_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings from the GPT2 language model. Can be used to easily tweak text
inputs, <em>e.g.</em> prompt weighting. If not provided, negative_prompt_embeds will be computed from
<code>negative_prompt</code> input argument.`,name:"negative_generated_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Pre-computed attention mask to be applied to the <code>prompt_embeds</code>. If not provided, attention mask will
be computed from <code>prompt</code> input argument.`,name:"attention_mask"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.negative_attention_mask",description:`<strong>negative_attention_mask</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Pre-computed attention mask to be applied to the <code>negative_prompt_embeds</code>. If not provided, attention
mask will be computed from <code>negative_prompt</code> input argument.`,name:"negative_attention_mask"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to None) &#x2014;
The number of new tokens to generate with the GPT2 language model.`,name:"max_new_tokens"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L270",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Text embeddings from the Flan T5 model.
attention_mask (<code>torch.LongTensor</code>):
Attention mask to be applied to the <code>prompt_embeds</code>.
generated_prompt_embeds (<code>torch.FloatTensor</code>):
Text embeddings generated from the GPT2 langauge model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>prompt_embeds (<code>torch.FloatTensor</code>)</p>
`}}),E=new ho({props:{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.example",$$slots:{default:[ko]},$$scope:{ctx:B}}}),fe=new $({props:{name:"generate_language_model",anchor:"diffusers.AudioLDM2Pipeline.generate_language_model",parameters:[{name:"inputs_embeds",val:": Tensor = None"},{name:"max_new_tokens",val:": int = 8"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"diffusers.AudioLDM2Pipeline.generate_language_model.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"inputs_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.generate_language_model.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>) &#x2014;
Number of new tokens to generate.`,name:"max_new_tokens"},{anchor:"diffusers.AudioLDM2Pipeline.generate_language_model.model_kwargs",description:`<strong>model_kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of additional model-specific kwargs that will be forwarded to the <code>forward</code>
function of the model.`,name:"model_kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L229",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sequence of generated hidden-states.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>inputs_embeds (</code>torch.FloatTensor<code>of shape</code>(batch_size, sequence_length, hidden_size)\`)</p>
`}}),ge=new U({props:{title:"AudioLDM2ProjectionModel",local:"diffusers.AudioLDM2ProjectionModel",headingTag:"h2"}}),he=new $({props:{name:"class diffusers.AudioLDM2ProjectionModel",anchor:"diffusers.AudioLDM2ProjectionModel",parameters:[{name:"text_encoder_dim",val:""},{name:"text_encoder_1_dim",val:""},{name:"langauge_model_dim",val:""}],parametersDescription:[{anchor:"diffusers.AudioLDM2ProjectionModel.text_encoder_dim",description:`<strong>text_encoder_dim</strong> (<code>int</code>) &#x2014;
Dimensionality of the text embeddings from the first text encoder (CLAP).`,name:"text_encoder_dim"},{anchor:"diffusers.AudioLDM2ProjectionModel.text_encoder_1_dim",description:`<strong>text_encoder_1_dim</strong> (<code>int</code>) &#x2014;
Dimensionality of the text embeddings from the second text encoder (T5 or VITS).`,name:"text_encoder_1_dim"},{anchor:"diffusers.AudioLDM2ProjectionModel.langauge_model_dim",description:`<strong>langauge_model_dim</strong> (<code>int</code>) &#x2014;
Dimensionality of the text embeddings from the language model (GPT2).`,name:"langauge_model_dim"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm2/modeling_audioldm2.py#L82"}}),_e=new $({props:{name:"forward",anchor:"diffusers.AudioLDM2ProjectionModel.forward",parameters:[{name:"hidden_states",val:": Optional = None"},{name:"hidden_states_1",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"attention_mask_1",val:": Optional = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm2/modeling_audioldm2.py#L111"}}),be=new U({props:{title:"AudioLDM2UNet2DConditionModel",local:"diffusers.AudioLDM2UNet2DConditionModel",headingTag:"h2"}}),Me=new $({props:{name:"class diffusers.AudioLDM2UNet2DConditionModel",anchor:"diffusers.AudioLDM2UNet2DConditionModel",parameters:[{name:"sample_size",val:": Optional = None"},{name:"in_channels",val:": int = 4"},{name:"out_channels",val:": int = 4"},{name:"flip_sin_to_cos",val:": bool = True"},{name:"freq_shift",val:": int = 0"},{name:"down_block_types",val:": Tuple = ('CrossAttnDownBlock2D', 'CrossAttnDownBlock2D', 'CrossAttnDownBlock2D', 'DownBlock2D')"},{name:"mid_block_type",val:": Optional = 'UNetMidBlock2DCrossAttn'"},{name:"up_block_types",val:": Tuple = ('UpBlock2D', 'CrossAttnUpBlock2D', 'CrossAttnUpBlock2D', 'CrossAttnUpBlock2D')"},{name:"only_cross_attention",val:": Union = False"},{name:"block_out_channels",val:": Tuple = (320, 640, 1280, 1280)"},{name:"layers_per_block",val:": Union = 2"},{name:"downsample_padding",val:": int = 1"},{name:"mid_block_scale_factor",val:": float = 1"},{name:"act_fn",val:": str = 'silu'"},{name:"norm_num_groups",val:": Optional = 32"},{name:"norm_eps",val:": float = 1e-05"},{name:"cross_attention_dim",val:": Union = 1280"},{name:"transformer_layers_per_block",val:": Union = 1"},{name:"attention_head_dim",val:": Union = 8"},{name:"num_attention_heads",val:": Union = None"},{name:"use_linear_projection",val:": bool = False"},{name:"class_embed_type",val:": Optional = None"},{name:"num_class_embeds",val:": Optional = None"},{name:"upcast_attention",val:": bool = False"},{name:"resnet_time_scale_shift",val:": str = 'default'"},{name:"time_embedding_type",val:": str = 'positional'"},{name:"time_embedding_dim",val:": Optional = None"},{name:"time_embedding_act_fn",val:": Optional = None"},{name:"timestep_post_act",val:": Optional = None"},{name:"time_cond_proj_dim",val:": Optional = None"},{name:"conv_in_kernel",val:": int = 3"},{name:"conv_out_kernel",val:": int = 3"},{name:"projection_class_embeddings_input_dim",val:": Optional = None"},{name:"class_embeddings_concat",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.AudioLDM2UNet2DConditionModel.sample_size",description:`<strong>sample_size</strong> (<code>int</code> or <code>Tuple[int, int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Height and width of input/output sample.`,name:"sample_size"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.in_channels",description:"<strong>in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014; Number of channels in the input sample.",name:"in_channels"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.out_channels",description:"<strong>out_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014; Number of channels in the output.",name:"out_channels"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.flip_sin_to_cos",description:`<strong>flip_sin_to_cos</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to flip the sin to cos in the time embedding.`,name:"flip_sin_to_cos"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.freq_shift",description:"<strong>freq_shift</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014; The frequency shift to apply to the time embedding.",name:"freq_shift"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.down_block_types",description:`<strong>down_block_types</strong> (<code>Tuple[str]</code>, <em>optional</em>, defaults to <code>(&quot;CrossAttnDownBlock2D&quot;, &quot;CrossAttnDownBlock2D&quot;, &quot;CrossAttnDownBlock2D&quot;, &quot;DownBlock2D&quot;)</code>) &#x2014;
The tuple of downsample blocks to use.`,name:"down_block_types"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.mid_block_type",description:`<strong>mid_block_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;UNetMidBlock2DCrossAttn&quot;</code>) &#x2014;
Block type for middle of UNet, it can only be <code>UNetMidBlock2DCrossAttn</code> for AudioLDM2.`,name:"mid_block_type"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.up_block_types",description:`<strong>up_block_types</strong> (<code>Tuple[str]</code>, <em>optional</em>, defaults to <code>(&quot;UpBlock2D&quot;, &quot;CrossAttnUpBlock2D&quot;, &quot;CrossAttnUpBlock2D&quot;, &quot;CrossAttnUpBlock2D&quot;)</code>) &#x2014;
The tuple of upsample blocks to use.`,name:"up_block_types"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.only_cross_attention",description:`<strong>only_cross_attention</strong> (<code>bool</code> or <code>Tuple[bool]</code>, <em>optional</em>, default to <code>False</code>) &#x2014;
Whether to include self-attention in the basic transformer blocks, see
<code>BasicTransformerBlock</code>.`,name:"only_cross_attention"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.block_out_channels",description:`<strong>block_out_channels</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(320, 640, 1280, 1280)</code>) &#x2014;
The tuple of output channels for each block.`,name:"block_out_channels"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.layers_per_block",description:"<strong>layers_per_block</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014; The number of layers per block.",name:"layers_per_block"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.downsample_padding",description:"<strong>downsample_padding</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014; The padding to use for the downsampling convolution.",name:"downsample_padding"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.mid_block_scale_factor",description:"<strong>mid_block_scale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014; The scale factor to use for the mid block.",name:"mid_block_scale_factor"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.act_fn",description:"<strong>act_fn</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014; The activation function to use.",name:"act_fn"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.norm_num_groups",description:`<strong>norm_num_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014; The number of groups to use for the normalization.
If <code>None</code>, normalization and activation layers is skipped in post-processing.`,name:"norm_num_groups"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.norm_eps",description:"<strong>norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-5) &#x2014; The epsilon to use for the normalization.",name:"norm_eps"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.cross_attention_dim",description:`<strong>cross_attention_dim</strong> (<code>int</code> or <code>Tuple[int]</code>, <em>optional</em>, defaults to 1280) &#x2014;
The dimension of the cross attention features.`,name:"cross_attention_dim"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.transformer_layers_per_block",description:`<strong>transformer_layers_per_block</strong> (<code>int</code> or <code>Tuple[int]</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of transformer blocks of type <code>BasicTransformerBlock</code>. Only relevant for
<code>~models.unet_2d_blocks.CrossAttnDownBlock2D</code>, <code>~models.unet_2d_blocks.CrossAttnUpBlock2D</code>,
<code>~models.unet_2d_blocks.UNetMidBlock2DCrossAttn</code>.`,name:"transformer_layers_per_block"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.attention_head_dim",description:"<strong>attention_head_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014; The dimension of the attention heads.",name:"attention_head_dim"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of attention heads. If not defined, defaults to <code>attention_head_dim</code>`,name:"num_attention_heads"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.resnet_time_scale_shift",description:`<strong>resnet_time_scale_shift</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014; Time scale shift config
for ResNet blocks (see <code>ResnetBlock2D</code>). Choose from <code>default</code> or <code>scale_shift</code>.`,name:"resnet_time_scale_shift"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.class_embed_type",description:`<strong>class_embed_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The type of class embedding to use which is ultimately summed with the time embeddings. Choose from <code>None</code>,
<code>&quot;timestep&quot;</code>, <code>&quot;identity&quot;</code>, <code>&quot;projection&quot;</code>, or <code>&quot;simple_projection&quot;</code>.`,name:"class_embed_type"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.num_class_embeds",description:`<strong>num_class_embeds</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Input dimension of the learnable embedding matrix to be projected to <code>time_embed_dim</code>, when performing
class conditioning with <code>class_embed_type</code> equal to <code>None</code>.`,name:"num_class_embeds"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.time_embedding_type",description:`<strong>time_embedding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>positional</code>) &#x2014;
The type of position embedding to use for timesteps. Choose from <code>positional</code> or <code>fourier</code>.`,name:"time_embedding_type"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.time_embedding_dim",description:`<strong>time_embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
An optional override for the dimension of the projected time embedding.`,name:"time_embedding_dim"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.time_embedding_act_fn",description:`<strong>time_embedding_act_fn</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Optional activation function to use only once on the time embeddings before they are passed to the rest of
the UNet. Choose from <code>silu</code>, <code>mish</code>, <code>gelu</code>, and <code>swish</code>.`,name:"time_embedding_act_fn"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.timestep_post_act",description:`<strong>timestep_post_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The second activation function to use in timestep embedding. Choose from <code>silu</code>, <code>mish</code> and <code>gelu</code>.`,name:"timestep_post_act"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.time_cond_proj_dim",description:`<strong>time_cond_proj_dim</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The dimension of <code>cond_proj</code> layer in the timestep embedding.`,name:"time_cond_proj_dim"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.conv_in_kernel",description:"<strong>conv_in_kernel</strong> (<code>int</code>, <em>optional</em>, default to <code>3</code>) &#x2014; The kernel size of <code>conv_in</code> layer.",name:"conv_in_kernel"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.conv_out_kernel",description:"<strong>conv_out_kernel</strong> (<code>int</code>, <em>optional</em>, default to <code>3</code>) &#x2014; The kernel size of <code>conv_out</code> layer.",name:"conv_out_kernel"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.projection_class_embeddings_input_dim",description:`<strong>projection_class_embeddings_input_dim</strong> (<code>int</code>, <em>optional</em>) &#x2014; The dimension of the <code>class_labels</code> input when
<code>class_embed_type=&quot;projection&quot;</code>. Required when <code>class_embed_type=&quot;projection&quot;</code>.`,name:"projection_class_embeddings_input_dim"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.class_embeddings_concat",description:`<strong>class_embeddings_concat</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to concatenate the time
embeddings with the class embeddings.`,name:"class_embeddings_concat"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm2/modeling_audioldm2.py#L148"}}),ve=new $({props:{name:"forward",anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward",parameters:[{name:"sample",val:": FloatTensor"},{name:"timestep",val:": Union"},{name:"encoder_hidden_states",val:": Tensor"},{name:"class_labels",val:": Optional = None"},{name:"timestep_cond",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"encoder_attention_mask",val:": Optional = None"},{name:"return_dict",val:": bool = True"},{name:"encoder_hidden_states_1",val:": Optional = None"},{name:"encoder_attention_mask_1",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
The noisy input tensor with the following shape <code>(batch, channel, height, width)</code>.`,name:"sample"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.timestep",description:"<strong>timestep</strong> (<code>torch.FloatTensor</code> or <code>float</code> or <code>int</code>) &#x2014; The number of timesteps to denoise an input.",name:"timestep"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder hidden states with shape <code>(batch, sequence_length, feature_dim)</code>.`,name:"encoder_hidden_states"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.Tensor</code>) &#x2014;
A cross-attention mask of shape <code>(batch, sequence_length)</code> is applied to <code>encoder_hidden_states</code>. If
<code>True</code> the mask is kept, otherwise if <code>False</code> it is discarded. Mask will be converted into a bias,
which adds large negative values to the attention scores corresponding to &#x201C;discard&#x201D; tokens.`,name:"encoder_attention_mask"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.models.unets.unet_2d_condition.UNet2DConditionOutput">UNet2DConditionOutput</a> instead of a plain
tuple.`,name:"return_dict"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttnProcessor</code>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.encoder_hidden_states_1",description:`<strong>encoder_hidden_states_1</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
A second set of encoder hidden states with shape <code>(batch, sequence_length_2, feature_dim_2)</code>. Can be
used to condition the model on a different set of embeddings to <code>encoder_hidden_states</code>.`,name:"encoder_hidden_states_1"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.encoder_attention_mask_1",description:`<strong>encoder_attention_mask_1</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
A cross-attention mask of shape <code>(batch, sequence_length_2)</code> is applied to <code>encoder_hidden_states_1</code>.
If <code>True</code> the mask is kept, otherwise if <code>False</code> it is discarded. Mask will be converted into a bias,
which adds large negative values to the attention scores corresponding to &#x201C;discard&#x201D; tokens.`,name:"encoder_attention_mask_1"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm2/modeling_audioldm2.py#L662",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is True, an <a
  href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.models.unets.unet_2d_condition.UNet2DConditionOutput"
>UNet2DConditionOutput</a> is returned, otherwise
a <code>tuple</code> is returned where the first element is the sample tensor.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.models.unets.unet_2d_condition.UNet2DConditionOutput"
>UNet2DConditionOutput</a> or <code>tuple</code></p>
`}}),we=new U({props:{title:"AudioPipelineOutput",local:"diffusers.AudioPipelineOutput",headingTag:"h2"}}),xe=new $({props:{name:"class diffusers.AudioPipelineOutput",anchor:"diffusers.AudioPipelineOutput",parameters:[{name:"audios",val:": ndarray"}],parametersDescription:[{anchor:"diffusers.AudioPipelineOutput.audios",description:`<strong>audios</strong> (<code>np.ndarray</code>) &#x2014;
List of denoised audio samples of a NumPy array of shape <code>(batch_size, num_channels, sample_rate)</code>.`,name:"audios"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L130"}}),{c(){c=d("meta"),k=n(),v=d("p"),M=n(),m(x.$$.fragment),l=n(),y=d("p"),y.innerHTML=St,Ee=n(),H=d("p"),H.innerHTML=Wt,Fe=n(),O=d("p"),O.textContent=Ht,Se=n(),Q=d("p"),Q.innerHTML=Ot,We=n(),X=d("p"),X.innerHTML=Qt,He=n(),m(z.$$.fragment),Oe=n(),m(R.$$.fragment),Qe=n(),V=d("p"),V.textContent=Xt,Xe=n(),Y=d("p"),Y.textContent=zt,ze=n(),K=d("table"),K.innerHTML=Rt,Re=n(),m(ee.$$.fragment),Ve=n(),te=d("ul"),te.innerHTML=Vt,Ye=n(),m(oe.$$.fragment),Ke=n(),ne=d("ul"),ne.innerHTML=Yt,et=n(),m(se.$$.fragment),tt=n(),ie=d("ul"),ie.innerHTML=Kt,ot=n(),ae=d("p"),ae.innerHTML=eo,nt=n(),m(J.$$.fragment),st=n(),m(de.$$.fragment),it=n(),b=d("div"),m(re.$$.fragment),Mt=n(),De=d("p"),De.textContent=to,vt=n(),Te=d("p"),Te.innerHTML=oo,wt=n(),j=d("div"),m(le.$$.fragment),xt=n(),ke=d("p"),ke.textContent=no,yt=n(),m(I.$$.fragment),Dt=n(),q=d("div"),m(ce.$$.fragment),Tt=n(),Ae=d("p"),Ae.innerHTML=so,kt=n(),G=d("div"),m(pe.$$.fragment),At=n(),$e=d("p"),$e.innerHTML=io,$t=n(),Z=d("div"),m(me.$$.fragment),Lt=n(),Le=d("p"),Le.textContent=ao,jt=n(),C=d("div"),m(ue.$$.fragment),Ct=n(),je=d("p"),je.textContent=ro,Ut=n(),m(E.$$.fragment),Pt=n(),F=d("div"),m(fe.$$.fragment),Nt=n(),Ce=d("p"),Ce.textContent=lo,at=n(),m(ge.$$.fragment),dt=n(),L=d("div"),m(he.$$.fragment),Bt=n(),Ue=d("p"),Ue.innerHTML=co,Jt=n(),Pe=d("div"),m(_e.$$.fragment),rt=n(),m(be.$$.fragment),lt=n(),A=d("div"),m(Me.$$.fragment),It=n(),Ne=d("p"),Ne.innerHTML=po,qt=n(),Be=d("p"),Be.innerHTML=mo,Gt=n(),S=d("div"),m(ve.$$.fragment),Zt=n(),Je=d("p"),Je.innerHTML=uo,ct=n(),m(we.$$.fragment),pt=n(),P=d("div"),m(xe.$$.fragment),Et=n(),Ie=d("p"),Ie.textContent=fo,mt=n(),Ze=d("p"),this.h()},l(e){const t=xo("svelte-u9bgzb",document.head);c=r(t,"META",{name:!0,content:!0}),t.forEach(o),k=s(e),v=r(e,"P",{}),D(v).forEach(o),M=s(e),u(x.$$.fragment,e),l=s(e),y=r(e,"P",{"data-svelte-h":!0}),p(y)!=="svelte-ta0apn"&&(y.innerHTML=St),Ee=s(e),H=r(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-117z0zb"&&(H.innerHTML=Wt),Fe=s(e),O=r(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-wu27l3"&&(O.textContent=Ht),Se=s(e),Q=r(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1ddltfs"&&(Q.innerHTML=Ot),We=s(e),X=r(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-gffixp"&&(X.innerHTML=Qt),He=s(e),u(z.$$.fragment,e),Oe=s(e),u(R.$$.fragment,e),Qe=s(e),V=r(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1hmv6lf"&&(V.textContent=Xt),Xe=s(e),Y=r(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1hmqwck"&&(Y.textContent=zt),ze=s(e),K=r(e,"TABLE",{"data-svelte-h":!0}),p(K)!=="svelte-qdkw13"&&(K.innerHTML=Rt),Re=s(e),u(ee.$$.fragment,e),Ve=s(e),te=r(e,"UL",{"data-svelte-h":!0}),p(te)!=="svelte-1ry6k60"&&(te.innerHTML=Vt),Ye=s(e),u(oe.$$.fragment,e),Ke=s(e),ne=r(e,"UL",{"data-svelte-h":!0}),p(ne)!=="svelte-jm9a2k"&&(ne.innerHTML=Yt),et=s(e),u(se.$$.fragment,e),tt=s(e),ie=r(e,"UL",{"data-svelte-h":!0}),p(ie)!=="svelte-9fhj5v"&&(ie.innerHTML=Kt),ot=s(e),ae=r(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-18kt9eu"&&(ae.innerHTML=eo),nt=s(e),u(J.$$.fragment,e),st=s(e),u(de.$$.fragment,e),it=s(e),b=r(e,"DIV",{class:!0});var w=D(b);u(re.$$.fragment,w),Mt=s(w),De=r(w,"P",{"data-svelte-h":!0}),p(De)!=="svelte-m23e7a"&&(De.textContent=to),vt=s(w),Te=r(w,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-496sm0"&&(Te.innerHTML=oo),wt=s(w),j=r(w,"DIV",{class:!0});var N=D(j);u(le.$$.fragment,N),xt=s(N),ke=r(N,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-50j04k"&&(ke.textContent=no),yt=s(N),u(I.$$.fragment,N),N.forEach(o),Dt=s(w),q=r(w,"DIV",{class:!0});var ye=D(q);u(ce.$$.fragment,ye),Tt=s(ye),Ae=r(ye,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-1s3c06i"&&(Ae.innerHTML=so),ye.forEach(o),kt=s(w),G=r(w,"DIV",{class:!0});var ft=D(G);u(pe.$$.fragment,ft),At=s(ft),$e=r(ft,"P",{"data-svelte-h":!0}),p($e)!=="svelte-d7vywi"&&($e.innerHTML=io),ft.forEach(o),$t=s(w),Z=r(w,"DIV",{class:!0});var gt=D(Z);u(me.$$.fragment,gt),Lt=s(gt),Le=r(gt,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-14bnrb6"&&(Le.textContent=ao),gt.forEach(o),jt=s(w),C=r(w,"DIV",{class:!0});var qe=D(C);u(ue.$$.fragment,qe),Ct=s(qe),je=r(qe,"P",{"data-svelte-h":!0}),p(je)!=="svelte-16q0ax1"&&(je.textContent=ro),Ut=s(qe),u(E.$$.fragment,qe),qe.forEach(o),Pt=s(w),F=r(w,"DIV",{class:!0});var ht=D(F);u(fe.$$.fragment,ht),Nt=s(ht),Ce=r(ht,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1whwjf0"&&(Ce.textContent=lo),ht.forEach(o),w.forEach(o),at=s(e),u(ge.$$.fragment,e),dt=s(e),L=r(e,"DIV",{class:!0});var Ge=D(L);u(he.$$.fragment,Ge),Bt=s(Ge),Ue=r(Ge,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-eyi7ar"&&(Ue.innerHTML=co),Jt=s(Ge),Pe=r(Ge,"DIV",{class:!0});var go=D(Pe);u(_e.$$.fragment,go),go.forEach(o),Ge.forEach(o),rt=s(e),u(be.$$.fragment,e),lt=s(e),A=r(e,"DIV",{class:!0});var W=D(A);u(Me.$$.fragment,W),It=s(W),Ne=r(W,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-pvv01z"&&(Ne.innerHTML=po),qt=s(W),Be=r(W,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-1hyu2ru"&&(Be.innerHTML=mo),Gt=s(W),S=r(W,"DIV",{class:!0});var _t=D(S);u(ve.$$.fragment,_t),Zt=s(_t),Je=r(_t,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-112grcz"&&(Je.innerHTML=uo),_t.forEach(o),W.forEach(o),ct=s(e),u(we.$$.fragment,e),pt=s(e),P=r(e,"DIV",{class:!0});var bt=D(P);u(xe.$$.fragment,bt),Et=s(bt),Ie=r(bt,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-19ryw33"&&(Ie.textContent=fo),bt.forEach(o),mt=s(e),Ze=r(e,"P",{}),D(Ze).forEach(o),this.h()},h(){T(c,"name","hf:doc:metadata"),T(c,"content",$o),T(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){a(document.head,c),i(e,k,t),i(e,v,t),i(e,M,t),f(x,e,t),i(e,l,t),i(e,y,t),i(e,Ee,t),i(e,H,t),i(e,Fe,t),i(e,O,t),i(e,Se,t),i(e,Q,t),i(e,We,t),i(e,X,t),i(e,He,t),f(z,e,t),i(e,Oe,t),f(R,e,t),i(e,Qe,t),i(e,V,t),i(e,Xe,t),i(e,Y,t),i(e,ze,t),i(e,K,t),i(e,Re,t),f(ee,e,t),i(e,Ve,t),i(e,te,t),i(e,Ye,t),f(oe,e,t),i(e,Ke,t),i(e,ne,t),i(e,et,t),f(se,e,t),i(e,tt,t),i(e,ie,t),i(e,ot,t),i(e,ae,t),i(e,nt,t),f(J,e,t),i(e,st,t),f(de,e,t),i(e,it,t),i(e,b,t),f(re,b,null),a(b,Mt),a(b,De),a(b,vt),a(b,Te),a(b,wt),a(b,j),f(le,j,null),a(j,xt),a(j,ke),a(j,yt),f(I,j,null),a(b,Dt),a(b,q),f(ce,q,null),a(q,Tt),a(q,Ae),a(b,kt),a(b,G),f(pe,G,null),a(G,At),a(G,$e),a(b,$t),a(b,Z),f(me,Z,null),a(Z,Lt),a(Z,Le),a(b,jt),a(b,C),f(ue,C,null),a(C,Ct),a(C,je),a(C,Ut),f(E,C,null),a(b,Pt),a(b,F),f(fe,F,null),a(F,Nt),a(F,Ce),i(e,at,t),f(ge,e,t),i(e,dt,t),i(e,L,t),f(he,L,null),a(L,Bt),a(L,Ue),a(L,Jt),a(L,Pe),f(_e,Pe,null),i(e,rt,t),f(be,e,t),i(e,lt,t),i(e,A,t),f(Me,A,null),a(A,It),a(A,Ne),a(A,qt),a(A,Be),a(A,Gt),a(A,S),f(ve,S,null),a(S,Zt),a(S,Je),i(e,ct,t),f(we,e,t),i(e,pt,t),i(e,P,t),f(xe,P,null),a(P,Et),a(P,Ie),i(e,mt,t),i(e,Ze,t),ut=!0},p(e,[t]){const w={};t&2&&(w.$$scope={dirty:t,ctx:e}),J.$set(w);const N={};t&2&&(N.$$scope={dirty:t,ctx:e}),I.$set(N);const ye={};t&2&&(ye.$$scope={dirty:t,ctx:e}),E.$set(ye)},i(e){ut||(g(x.$$.fragment,e),g(z.$$.fragment,e),g(R.$$.fragment,e),g(ee.$$.fragment,e),g(oe.$$.fragment,e),g(se.$$.fragment,e),g(J.$$.fragment,e),g(de.$$.fragment,e),g(re.$$.fragment,e),g(le.$$.fragment,e),g(I.$$.fragment,e),g(ce.$$.fragment,e),g(pe.$$.fragment,e),g(me.$$.fragment,e),g(ue.$$.fragment,e),g(E.$$.fragment,e),g(fe.$$.fragment,e),g(ge.$$.fragment,e),g(he.$$.fragment,e),g(_e.$$.fragment,e),g(be.$$.fragment,e),g(Me.$$.fragment,e),g(ve.$$.fragment,e),g(we.$$.fragment,e),g(xe.$$.fragment,e),ut=!0)},o(e){h(x.$$.fragment,e),h(z.$$.fragment,e),h(R.$$.fragment,e),h(ee.$$.fragment,e),h(oe.$$.fragment,e),h(se.$$.fragment,e),h(J.$$.fragment,e),h(de.$$.fragment,e),h(re.$$.fragment,e),h(le.$$.fragment,e),h(I.$$.fragment,e),h(ce.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(ue.$$.fragment,e),h(E.$$.fragment,e),h(fe.$$.fragment,e),h(ge.$$.fragment,e),h(he.$$.fragment,e),h(_e.$$.fragment,e),h(be.$$.fragment,e),h(Me.$$.fragment,e),h(ve.$$.fragment,e),h(we.$$.fragment,e),h(xe.$$.fragment,e),ut=!1},d(e){e&&(o(k),o(v),o(M),o(l),o(y),o(Ee),o(H),o(Fe),o(O),o(Se),o(Q),o(We),o(X),o(He),o(Oe),o(Qe),o(V),o(Xe),o(Y),o(ze),o(K),o(Re),o(Ve),o(te),o(Ye),o(Ke),o(ne),o(et),o(tt),o(ie),o(ot),o(ae),o(nt),o(st),o(it),o(b),o(at),o(dt),o(L),o(rt),o(lt),o(A),o(ct),o(pt),o(P),o(mt),o(Ze)),o(c),_(x,e),_(z,e),_(R,e),_(ee,e),_(oe,e),_(se,e),_(J,e),_(de,e),_(re),_(le),_(I),_(ce),_(pe),_(me),_(ue),_(E),_(fe),_(ge,e),_(he),_(_e),_(be,e),_(Me),_(ve),_(we,e),_(xe)}}}const $o='{"title":"AudioLDM 2","local":"audioldm-2","sections":[{"title":"Tips","local":"tips","sections":[{"title":"Choosing a checkpoint","local":"choosing-a-checkpoint","sections":[],"depth":3},{"title":"Constructing a prompt","local":"constructing-a-prompt","sections":[],"depth":3},{"title":"Controlling inference","local":"controlling-inference","sections":[],"depth":3},{"title":"Evaluating generated waveforms:","local":"evaluating-generated-waveforms","sections":[],"depth":3}],"depth":2},{"title":"AudioLDM2Pipeline","local":"diffusers.AudioLDM2Pipeline","sections":[],"depth":2},{"title":"AudioLDM2ProjectionModel","local":"diffusers.AudioLDM2ProjectionModel","sections":[],"depth":2},{"title":"AudioLDM2UNet2DConditionModel","local":"diffusers.AudioLDM2UNet2DConditionModel","sections":[],"depth":2},{"title":"AudioPipelineOutput","local":"diffusers.AudioPipelineOutput","sections":[],"depth":2}],"depth":1}';function Lo(B){return Mo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Io extends vo{constructor(c){super(),wo(this,c,Lo,Ao,bo,{})}}export{Io as component};
