import{s as oi,o as ii,n as G}from"../chunks/scheduler.182ea377.js";import{S as si,i as ai,g as l,s as i,r as g,A as ri,h as d,f as p,c as s,j as U,u as b,x as f,k as j,y as o,a as u,v as _,d as y,t as v,w}from"../chunks/index.abf12888.js";import{T as it}from"../chunks/Tip.230e2334.js";import{D}from"../chunks/Docstring.93f6f462.js";import{C as xe}from"../chunks/CodeBlock.57fe6e13.js";import{E as we}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as sn}from"../chunks/Heading.16916d63.js";function li(T){let n,h='You shouldn’t use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class for training. Individual components (for example, <a href="/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a> and <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) of diffusion pipelines are usually trained individually, so we suggest directly working with them instead.',a,r,m,t,M='Pipelines do not offer any training functionality. You’ll notice PyTorch’s autograd is disabled by decorating the <code>__call__()</code> method with a <a href="https://pytorch.org/docs/stable/generated/torch.no_grad.html" rel="nofollow"><code>torch.no_grad</code></a> decorator because pipelines should not be used for training. If you’re interested in training, please take a look at the <a href="../../training/overview">Training</a> guides instead!';return{c(){n=l("p"),n.innerHTML=h,a=i(),r=l("br"),m=i(),t=l("p"),t.innerHTML=M},l(J){n=d(J,"P",{"data-svelte-h":!0}),f(n)!=="svelte-17t0bk9"&&(n.innerHTML=h),a=s(J),r=d(J,"BR",{}),m=s(J),t=d(J,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1a94ctl"&&(t.innerHTML=M)},m(J,E){u(J,n,E),u(J,a,E),u(J,r,E),u(J,m,E),u(J,t,E)},p:G,d(J){J&&(p(n),p(a),p(r),p(m),p(t))}}}function di(T){let n,h=`If the pipeline already has the correct torch.dtype and torch.device, then it is returned as is. Otherwise,
the returned pipeline is a copy of self with the desired torch.dtype and torch.device.`;return{c(){n=l("p"),n.textContent=h},l(a){n=d(a,"P",{"data-svelte-h":!0}),f(n)!=="svelte-18gkv0g"&&(n.textContent=h)},m(a,r){u(a,n,r)},p:G,d(a){a&&p(n)}}}function pi(T){let n,h="Examples:",a,r,m;return r=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZSUyQyUwQSklMEElMEF0ZXh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiklMEFpbWcyaW1nJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lKCoqdGV4dDJpbWcuY29tcG9uZW50cyklMEFpbnBhaW50JTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lKCoqdGV4dDJpbWcuY29tcG9uZW50cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    StableDiffusionPipeline,
<span class="hljs-meta">... </span>    StableDiffusionImg2ImgPipeline,
<span class="hljs-meta">... </span>    StableDiffusionInpaintPipeline,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text2img = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>img2img = StableDiffusionImg2ImgPipeline(**text2img.components)
<span class="hljs-meta">&gt;&gt;&gt; </span>inpaint = StableDiffusionInpaintPipeline(**text2img.components)`,wrap:!1}}),{c(){n=l("p"),n.textContent=h,a=i(),g(r.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=h),a=s(t),b(r.$$.fragment,t)},m(t,M){u(t,n,M),u(t,a,M),_(r,t,M),m=!0},p:G,i(t){m||(y(r.$$.fragment,t),m=!0)},o(t){v(r.$$.fragment,t),m=!1},d(t){t&&(p(n),p(a)),w(r,t)}}}function ci(T){let n,h=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in with
<code>huggingface-cli login</code>.`;return{c(){n=l("p"),n.innerHTML=h},l(a){n=d(a,"P",{"data-svelte-h":!0}),f(n)!=="svelte-6jnfc0"&&(n.innerHTML=h)},m(a,r){u(a,n,r)},p:G,d(a){a&&p(n)}}}function fi(T){let n,h=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=l("p"),n.innerHTML=h},l(a){n=d(a,"P",{"data-svelte-h":!0}),f(n)!=="svelte-ackzsn"&&(n.innerHTML=h)},m(a,r){u(a,n,r)},p:G,d(a){a&&p(n)}}}function mi(T){let n,h="Examples:",a,r,m;return r=new xe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=l("p"),n.textContent=h,a=i(),g(r.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=h),a=s(t),b(r.$$.fragment,t)},m(t,M){u(t,n,M),u(t,a,M),_(r,t,M),m=!0},p:G,i(t){m||(y(r.$$.fragment,t),m=!0)},o(t){v(r.$$.fragment,t),m=!1},d(t){t&&(p(n),p(a)),w(r,t)}}}function ui(T){let n,h=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=l("p"),n.textContent=h},l(a){n=d(a,"P",{"data-svelte-h":!0}),f(n)!=="svelte-17p1lpg"&&(n.textContent=h)},m(a,r){u(a,n,r)},p:G,d(a){a&&p(n)}}}function hi(T){let n,h="Examples:",a,r,m;return r=new xe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=l("p"),n.textContent=h,a=i(),g(r.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=h),a=s(t),b(r.$$.fragment,t)},m(t,M){u(t,n,M),u(t,a,M),_(r,t,M),m=!0},p:G,i(t){m||(y(r.$$.fragment,t),m=!0)},o(t){v(r.$$.fragment,t),m=!1},d(t){t&&(p(n),p(a)),w(r,t)}}}function gi(T){let n,h="If you get the error message below, you need to finetune the weights for your downstream task:",a,r,m;return r=new xe({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwcnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTIwYmVjYXVzZSUyMHRoZSUyMHNoYXBlcyUyMGRpZCUyMG5vdCUyMG1hdGNoJTNBJTBBLSUyMGNvbnZfaW4ud2VpZ2h0JTNBJTIwZm91bmQlMjBzaGFwZSUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwNCUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwY2hlY2twb2ludCUyMGFuZCUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwOSUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwbW9kZWwlMjBpbnN0YW50aWF0ZWQlMEFZb3UlMjBzaG91bGQlMjBwcm9iYWJseSUyMFRSQUlOJTIwdGhpcyUyMG1vZGVsJTIwb24lMjBhJTIwZG93bi1zdHJlYW0lMjB0YXNrJTIwdG8lMjBiZSUyMGFibGUlMjB0byUyMHVzZSUyMGl0JTIwZm9yJTIwcHJlZGljdGlvbnMlMjBhbmQlMjBpbmZlcmVuY2Uu",highlighted:`Some weights <span class="hljs-keyword">of</span> UNet2DConditionModel were <span class="hljs-keyword">not</span> initialized <span class="hljs-built_in">from</span> <span class="hljs-keyword">the</span> model checkpoint <span class="hljs-keyword">at</span> runwayml/stable-diffusion-v1<span class="hljs-number">-5</span> <span class="hljs-keyword">and</span> are newly initialized because <span class="hljs-keyword">the</span> shapes did <span class="hljs-keyword">not</span> match:
- conv_in.weight: found shape torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">4</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) <span class="hljs-keyword">in</span> <span class="hljs-keyword">the</span> checkpoint <span class="hljs-keyword">and</span> torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">9</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) <span class="hljs-keyword">in</span> <span class="hljs-keyword">the</span> model instantiated
You should probably TRAIN this model <span class="hljs-keyword">on</span> <span class="hljs-title">a</span> <span class="hljs-title">down-stream</span> <span class="hljs-title">task</span> <span class="hljs-title">to</span> <span class="hljs-title">be</span> <span class="hljs-title">able</span> <span class="hljs-title">to</span> <span class="hljs-title">use</span> <span class="hljs-title">it</span> <span class="hljs-title">for</span> <span class="hljs-title">predictions</span> <span class="hljs-title">and</span> <span class="hljs-title">inference</span>.`,wrap:!1}}),{c(){n=l("p"),n.textContent=h,a=i(),g(r.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),f(n)!=="svelte-xueb0m"&&(n.textContent=h),a=s(t),b(r.$$.fragment,t)},m(t,M){u(t,n,M),u(t,a,M),_(r,t,M),m=!0},p:G,i(t){m||(y(r.$$.fragment,t),m=!0)},o(t){v(r.$$.fragment,t),m=!1},d(t){t&&(p(n),p(a)),w(r,t)}}}function bi(T){let n,h=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated</a> models, log-in with
<code>huggingface-cli login</code>.`;return{c(){n=l("p"),n.innerHTML=h},l(a){n=d(a,"P",{"data-svelte-h":!0}),f(n)!=="svelte-x73rgs"&&(n.innerHTML=h)},m(a,r){u(a,n,r)},p:G,d(a){a&&p(n)}}}function _i(T){let n,h="Examples:",a,r,m;return r=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZsZG0tdGV4dDJpbS1sYXJnZS0yNTYlMjIpJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMHRoYXQlMjByZXF1aXJlcyUyMGFuJTIwYXV0aG9yaXphdGlvbiUyMHRva2VuJTBBJTIzJTIwRm9yJTIwbW9yZSUyMGluZm9ybWF0aW9uJTIwb24lMjBhY2Nlc3MlMjB0b2tlbnMlMkMlMjBwbGVhc2UlMjByZWZlciUyMHRvJTIwdGhpcyUyMHNlY3Rpb24lMEElMjMlMjBvZiUyMHRoZSUyMGRvY3VtZW50YXRpb24lNUQoaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRvY3MlMkZodWIlMkZzZWN1cml0eS10b2tlbnMpJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIpJTBBJTBBJTIzJTIwVXNlJTIwYSUyMGRpZmZlcmVudCUyMHNjaGVkdWxlciUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBMTVNEaXNjcmV0ZVNjaGVkdWxlciUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMExNU0Rpc2NyZXRlU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwc2NoZWR1bGVy",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;CompVis/ldm-text2im-large-256&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline that requires an authorization token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For more information on access tokens, please refer to this section</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># of the documentation](https://huggingface.co/docs/hub/security-tokens)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Use a different scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LMSDiscreteScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = LMSDiscreteScheduler.from_config(pipeline.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.scheduler = scheduler`,wrap:!1}}),{c(){n=l("p"),n.textContent=h,a=i(),g(r.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=h),a=s(t),b(r.$$.fragment,t)},m(t,M){u(t,n,M),u(t,a,M),_(r,t,M),m=!0},p:G,i(t){m||(y(r.$$.fragment,t),m=!0)},o(t){v(r.$$.fragment,t),m=!1},d(t){t&&(p(n),p(a)),w(r,t)}}}function yi(T){let n,h="If you get the error message below, you need to finetune the weights for your downstream task:",a,r,m;return r=new xe({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUyMHdlcmUlMjBub3QlMjBpbml0aWFsaXplZCUyMGZyb20lMjB0aGUlMjBtb2RlbCUyMGNoZWNrcG9pbnQlMjBhdCUyMHJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIwYW5kJTIwYXJlJTIwbmV3bHklMjBpbml0aWFsaXplZCUyMGJlY2F1c2UlMjB0aGUlMjBzaGFwZXMlMjBkaWQlMjBub3QlMjBtYXRjaCUzQQ==",highlighted:'Some weights <span class="hljs-keyword">of</span> FlaxUNet2DConditionModel were <span class="hljs-keyword">not</span> initialized <span class="hljs-built_in">from</span> <span class="hljs-keyword">the</span> model checkpoint <span class="hljs-keyword">at</span> runwayml/stable-diffusion-v1<span class="hljs-number">-5</span> <span class="hljs-keyword">and</span> are newly initialized because <span class="hljs-keyword">the</span> shapes did <span class="hljs-keyword">not</span> match:',wrap:!1}}),{c(){n=l("p"),n.textContent=h,a=i(),g(r.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),f(n)!=="svelte-xueb0m"&&(n.textContent=h),a=s(t),b(r.$$.fragment,t)},m(t,M){u(t,n,M),u(t,a,M),_(r,t,M),m=!0},p:G,i(t){m||(y(r.$$.fragment,t),m=!0)},o(t){v(r.$$.fragment,t),m=!1},d(t){t&&(p(n),p(a)),w(r,t)}}}function vi(T){let n,h=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in with
<code>huggingface-cli login</code>.`;return{c(){n=l("p"),n.innerHTML=h},l(a){n=d(a,"P",{"data-svelte-h":!0}),f(n)!=="svelte-6jnfc0"&&(n.innerHTML=h)},m(a,r){u(a,n,r)},p:G,d(a){a&&p(n)}}}function wi(T){let n,h="Examples:",a,r,m;return r=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhEaWZmdXNpb25QaXBlbGluZSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEElMjMlMjBSZXF1aXJlcyUyMHRvJTIwYmUlMjBsb2dnZWQlMjBpbiUyMHRvJTIwSHVnZ2luZyUyMEZhY2UlMjBodWIlMkMlMEElMjMlMjBzZWUlMjBtb3JlJTIwaW4lMjAlNUJ0aGUlMjBkb2N1bWVudGF0aW9uJTVEKGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkb2NzJTJGaHViJTJGc2VjdXJpdHktdG9rZW5zKSUwQXBpcGVsaW5lJTJDJTIwcGFyYW1zJTIwJTNEJTIwRmxheERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJldmlzaW9uJTNEJTIyYmYxNiUyMiUyQyUwQSUyMCUyMCUyMCUyMGR0eXBlJTNEam5wLmJmbG9hdDE2JTJDJTBBKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMkMlMjBidXQlMjB1c2UlMjBhJTIwZGlmZmVyZW50JTIwc2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBZHBtcHAlMkMlMjBkcG1wcF9zdGF0ZSUyMCUzRCUyMEZsYXhEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyJTJDJTBBKSUwQSUwQWRwbV9waXBlJTJDJTIwZHBtX3BhcmFtcyUyMCUzRCUyMEZsYXhTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjByZXZpc2lvbiUzRCUyMmJmMTYlMjIlMkMlMjBkdHlwZSUzRGpucC5iZmxvYXQxNiUyQyUyMHNjaGVkdWxlciUzRGRwbXBwJTBBKSUwQWRwbV9wYXJhbXMlNUIlMjJzY2hlZHVsZXIlMjIlNUQlMjAlM0QlMjBkcG1wcF9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Requires to be logged in to Hugging Face hub,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># see more in [the documentation](https://huggingface.co/docs/hub/security-tokens)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline, params = FlaxDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    revision=<span class="hljs-string">&quot;bf16&quot;</span>,
<span class="hljs-meta">... </span>    dtype=jnp.bfloat16,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline, but use a different scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxDPMSolverMultistepScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dpmpp, dpmpp_state = FlaxDPMSolverMultistepScheduler.from_pretrained(
<span class="hljs-meta">... </span>    model_id,
<span class="hljs-meta">... </span>    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dpm_pipe, dpm_params = FlaxStableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    model_id, revision=<span class="hljs-string">&quot;bf16&quot;</span>, dtype=jnp.bfloat16, scheduler=dpmpp
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dpm_params[<span class="hljs-string">&quot;scheduler&quot;</span>] = dpmpp_state`,wrap:!1}}),{c(){n=l("p"),n.textContent=h,a=i(),g(r.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=h),a=s(t),b(r.$$.fragment,t)},m(t,M){u(t,n,M),u(t,a,M),_(r,t,M),m=!0},p:G,i(t){m||(y(r.$$.fragment,t),m=!0)},o(t){v(r.$$.fragment,t),m=!1},d(t){t&&(p(n),p(a)),w(r,t)}}}function xi(T){let n,h="Examples:",a,r,m;return r=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMiUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMHlvdXIlMjBuYW1lc3BhY2UlMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC11bmV0JTIyLiUwQXVuZXQucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLXVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtdW5ldCUyMi4lMEF1bmV0LnB1c2hfdG9faHViKCUyMnlvdXItb3JnJTJGbXktZmluZXR1bmVkLXVuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to your namespace with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;my-finetuned-unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to an organization with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;your-org/my-finetuned-unet&quot;</span>)`,wrap:!1}}),{c(){n=l("p"),n.textContent=h,a=i(),g(r.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=h),a=s(t),b(r.$$.fragment,t)},m(t,M){u(t,n,M),u(t,a,M),_(r,t,M),m=!0},p:G,i(t){m||(y(r.$$.fragment,t),m=!0)},o(t){v(r.$$.fragment,t),m=!1},d(t){t&&(p(n),p(a)),w(r,t)}}}function $i(T){let n,h,a,r,m,t,M,J="Pipelines provide a simple way to run state-of-the-art diffusion models in inference by bundling all of the necessary components (multiple independently-trained models, schedulers, and processors) into a single end-to-end class. Pipelines are flexible and they can be adapted to use different schedulers or even model components.",E,$e,vo='All pipelines are built from the base <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class which provides basic functionality for loading, downloading, and saving all the components. Specific pipeline types (for example <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>) loaded with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> are automatically detected and the pipeline components are loaded and passed to the <code>__init__</code> function of the pipeline.',St,q,Rt,Me,wo="The table below lists all the pipelines currently available in 🤗 Diffusers and the tasks they support. Click on a pipeline to view its abstract and published paper.",Et,Te,xo='<thead><tr><th>Pipeline</th> <th>Tasks</th></tr></thead> <tbody><tr><td><a href="alt_diffusion">AltDiffusion</a></td> <td>image2image</td></tr> <tr><td><a href="animatediff">AnimateDiff</a></td> <td>text2video</td></tr> <tr><td><a href="attend_and_excite">Attend-and-Excite</a></td> <td>text2image</td></tr> <tr><td><a href="audio_diffusion">Audio Diffusion</a></td> <td>image2audio</td></tr> <tr><td><a href="audioldm">AudioLDM</a></td> <td>text2audio</td></tr> <tr><td><a href="audioldm2">AudioLDM2</a></td> <td>text2audio</td></tr> <tr><td><a href="blip_diffusion">BLIP Diffusion</a></td> <td>text2image</td></tr> <tr><td><a href="consistency_models">Consistency Models</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="controlnet">ControlNet</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="controlnet_sdxl">ControlNet with Stable Diffusion XL</a></td> <td>text2image</td></tr> <tr><td><a href="controlnetxs">ControlNet-XS</a></td> <td>text2image</td></tr> <tr><td><a href="controlnetxs_sdxl">ControlNet-XS with Stable Diffusion XL</a></td> <td>text2image</td></tr> <tr><td><a href="cycle_diffusion">Cycle Diffusion</a></td> <td>image2image</td></tr> <tr><td><a href="dance_diffusion">Dance Diffusion</a></td> <td>unconditional audio generation</td></tr> <tr><td><a href="ddim">DDIM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="ddpm">DDPM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="deepfloyd_if">DeepFloyd IF</a></td> <td>text2image, image2image, inpainting, super-resolution</td></tr> <tr><td><a href="diffedit">DiffEdit</a></td> <td>inpainting</td></tr> <tr><td><a href="dit">DiT</a></td> <td>text2image</td></tr> <tr><td><a href="stable_diffusion/gligen">GLIGEN</a></td> <td>text2image</td></tr> <tr><td><a href="pix2pix">InstructPix2Pix</a></td> <td>image editing</td></tr> <tr><td><a href="kandinsky">Kandinsky 2.1</a></td> <td>text2image, image2image, inpainting, interpolation</td></tr> <tr><td><a href="kandinsky_v22">Kandinsky 2.2</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="kandinsky3">Kandinsky 3</a></td> <td>text2image, image2image</td></tr> <tr><td><a href="latent_consistency_models">Latent Consistency Models</a></td> <td>text2image</td></tr> <tr><td><a href="latent_diffusion">Latent Diffusion</a></td> <td>text2image, super-resolution</td></tr> <tr><td><a href="stable_diffusion/ldm3d_diffusion">LDM3D</a></td> <td>text2image, text-to-3D, text-to-pano, upscaling</td></tr> <tr><td><a href="panorama">MultiDiffusion</a></td> <td>text2image</td></tr> <tr><td><a href="musicldm">MusicLDM</a></td> <td>text2audio</td></tr> <tr><td><a href="paint_by_example">Paint by Example</a></td> <td>inpainting</td></tr> <tr><td><a href="paradigms">ParaDiGMS</a></td> <td>text2image</td></tr> <tr><td><a href="pix2pix_zero">Pix2Pix Zero</a></td> <td>image editing</td></tr> <tr><td><a href="pixart">PixArt-α</a></td> <td>text2image</td></tr> <tr><td><a href="pndm">PNDM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="repaint">RePaint</a></td> <td>inpainting</td></tr> <tr><td><a href="score_sde_ve">Score SDE VE</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="self_attention_guidance">Self-Attention Guidance</a></td> <td>text2image</td></tr> <tr><td><a href="semantic_stable_diffusion">Semantic Guidance</a></td> <td>text2image</td></tr> <tr><td><a href="shap_e">Shap-E</a></td> <td>text-to-3D, image-to-3D</td></tr> <tr><td><a href="spectrogram_diffusion">Spectrogram Diffusion</a></td> <td></td></tr> <tr><td><a href="stable_diffusion/overview">Stable Diffusion</a></td> <td>text2image, image2image, depth2image, inpainting, image variation, latent upscaler, super-resolution</td></tr> <tr><td><a href="model_editing">Stable Diffusion Model Editing</a></td> <td>model editing</td></tr> <tr><td><a href="stable_diffusion/stable_diffusion_xl">Stable Diffusion XL</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="stable_diffusion/sdxl_turbo">Stable Diffusion XL Turbo</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="stable_unclip">Stable unCLIP</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="stochastic_karras_ve">Stochastic Karras VE</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="stable_diffusion/adapter">T2I-Adapter</a></td> <td>text2image</td></tr> <tr><td><a href="text_to_video">Text2Video</a></td> <td>text2video, video2video</td></tr> <tr><td><a href="text_to_video_zero">Text2Video-Zero</a></td> <td>text2video</td></tr> <tr><td><a href="unclip">unCLIP</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="latent_diffusion_uncond">Unconditional Latent Diffusion</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="unidiffuser">UniDiffuser</a></td> <td>text2image, image2text, image variation, text variation, unconditional image generation, unconditional audio generation</td></tr> <tr><td><a href="value_guided_sampling">Value-guided planning</a></td> <td>value guided sampling</td></tr> <tr><td><a href="versatile_diffusion">Versatile Diffusion</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="vq_diffusion">VQ Diffusion</a></td> <td>text2image</td></tr> <tr><td><a href="wuerstchen">Wuerstchen</a></td> <td>text2image</td></tr></tbody>',zt,Ue,Yt,x,je,an,st,$o="Base class for all pipelines.",rn,at,Mo=`<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> stores all components (models, schedulers, and processors) for diffusion pipelines and
provides methods for loading, downloading and saving models. It also includes methods to:`,ln,rt,To="<li>move all PyTorch modules to the device of your choice</li> <li>enable/disable the progress bar for the denoising iteration</li>",dn,lt,Uo="Class attributes:",pn,dt,jo=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li> <li><strong>_optional_components</strong> (<code>List[str]</code>) — List of all optional components that don’t have to be passed to the
pipeline to function (should be overridden by subclasses).</li>`,cn,A,Pe,fn,pt,Po="Call self as a function.",mn,ct,De,un,W,Ze,hn,ft,Do=`Performs Pipeline dtype and/or device conversion. A torch.dtype and torch.device are inferred from the
arguments of <code>self.to(*args, **kwargs).</code>`,gn,O,bn,mt,Zo="Here are the ways to call <code>to</code>:",_n,ut,Jo=`<li><code>to(dtype, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li> <li><code>to(device, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a></li> <li><code>to(device=None, dtype=None, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the
specified <a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a> and
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li>`,yn,H,Je,vn,ht,ko=`The <code>self.components</code> property can be useful to run different pipelines with the same weights and
configurations without reallocating additional memory.`,wn,gt,Co=`Returns (<code>dict</code>):
A dictionary containing all the modules needed to initialize the pipeline.`,xn,K,$n,ee,ke,Mn,bt,Io=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,Tn,te,Ce,Un,_t,Go='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',jn,z,Ie,Pn,yt,Wo="Download and cache a PyTorch diffusion pipeline from pretrained pipeline weights.",Dn,ne,Zn,F,Ge,Jn,vt,Bo=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,kn,oe,Cn,ie,In,se,We,Gn,wt,Ho=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,Wn,ae,Be,Bn,xt,Fo=`Offloads all models to CPU using 🤗 Accelerate, significantly reducing memory usage. When called, the state
dicts of all <code>torch.nn.Module</code> components (except those in <code>self._exclude_from_cpu_offload</code>) are saved to CPU
and then moved to <code>torch.device(&#39;meta&#39;)</code> and loaded to GPU only when their specific submodule has its <code>forward</code>
method called. Offloading happens on a submodule basis. Memory savings are higher than with
<code>enable_model_cpu_offload</code>, but performance is lower.`,Hn,V,He,Fn,$t,Vo=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Vn,re,Nn,le,Xn,k,Fe,Ln,Mt,No="Instantiate a PyTorch diffusion pipeline from pretrained pipeline weights.",Sn,Tt,Xo="The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.",Rn,de,En,pe,zn,ce,Yn,fe,Ve,Qn,Ut,Lo=`Function that offloads all components, removes all model hooks that were added when using
<code>enable_model_cpu_offload</code> and then applies them again. In case the model has not been offloaded this function
is a no-op. Make sure to add this function to the end of the <code>__call__</code> function of your pipeline so that it
functions correctly when applying enable_model_cpu_offload.`,qn,me,Ne,An,jt,So="Convert a NumPy image or a batch of images to a PIL image.",On,ue,Xe,Kn,Pt,Ro=`Save all saveable variables of the pipeline to a directory. A pipeline variable can be saved and loaded if its
class implements both a save and loading method. The pipeline is easily reloaded using the
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> class method.`,Qt,Le,qt,P,Se,eo,Dt,Eo="Base class for Flax-based pipelines.",to,Zt,zo=`<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline">FlaxDiffusionPipeline</a> stores all components (models, schedulers, and processors) for diffusion pipelines and
provides methods for loading, downloading and saving models. It also includes methods to:`,no,Jt,Yo="<li>enable/disable the progress bar for the denoising iteration</li>",oo,kt,Qo="Class attributes:",io,Ct,qo=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li>`,so,C,Re,ao,It,Ao="Instantiate a Flax-based diffusion pipeline from pretrained pipeline weights.",ro,Gt,Oo="The pipeline is set in evaluation mode (`model.eval()) by default and dropout modules are deactivated.",lo,he,po,ge,co,be,fo,_e,Ee,mo,Wt,Ko="Convert a NumPy image or a batch of images to a PIL image.",uo,ye,ze,ho,Bt,ei=`Save all saveable variables of the pipeline to a directory. A pipeline variable can be saved and loaded if its
class implements both a save and loading method. The pipeline is easily reloaded using the
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline.from_pretrained">from_pretrained()</a> class method.`,At,Ye,Ot,X,Qe,go,Ht,ti="A Mixin to push a model, scheduler, or pipeline to the Hugging Face Hub.",bo,Y,qe,_o,Ft,ni="Upload model, scheduler, or pipeline files to the 🤗 Hugging Face Hub.",yo,ve,Kt,Xt,en;return m=new sn({props:{title:"Pipelines",local:"pipelines",headingTag:"h1"}}),q=new it({props:{warning:!0,$$slots:{default:[li]},$$scope:{ctx:T}}}),Ue=new sn({props:{title:"DiffusionPipeline",local:"diffusers.DiffusionPipeline",headingTag:"h2"}}),je=new D({props:{name:"class diffusers.DiffusionPipeline",anchor:"diffusers.DiffusionPipeline",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L569"}}),Pe=new D({props:{name:"__call__",anchor:"diffusers.DiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),De=new D({props:{name:"device",anchor:"diffusers.DiffusionPipeline.device",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L901",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The torch device on which the pipeline is located.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.device</code></p>
`}}),Ze=new D({props:{name:"to",anchor:"diffusers.DiffusionPipeline.to",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.to.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a>`,name:"dtype"},{anchor:"diffusers.DiffusionPipeline.to.device",description:`<strong>device</strong> (<code>torch.Device</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a>`,name:"device"},{anchor:"diffusers.DiffusionPipeline.to.silence_dtype_warnings",description:`<strong>silence_dtype_warnings</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to omit warnings if the target <code>dtype</code> is not compatible with the target <code>device</code>.`,name:"silence_dtype_warnings"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L742",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The pipeline converted to specified <code>dtype</code> and/or <code>dtype</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline"
>DiffusionPipeline</a></p>
`}}),O=new it({props:{$$slots:{default:[di]},$$scope:{ctx:T}}}),Je=new D({props:{name:"components",anchor:"diffusers.DiffusionPipeline.components",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1941"}}),K=new we({props:{anchor:"diffusers.DiffusionPipeline.components.example",$$slots:{default:[pi]},$$scope:{ctx:T}}}),ke=new D({props:{name:"disable_attention_slicing",anchor:"diffusers.DiffusionPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2103"}}),Ce=new D({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2037"}}),Ie=new D({props:{name:"download",anchor:"diffusers.DiffusionPipeline.download",parameters:[{name:"pretrained_model_name",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.download.pretrained_model_name",description:`<strong>pretrained_model_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.`,name:"pretrained_model_name"},{anchor:"diffusers.DiffusionPipeline.download.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>
<p>A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained
pipeline hosted on the Hub. The repository must contain a file called <code>pipeline.py</code> that defines
the custom pipeline.</p>
</li>
<li>
<p>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current <code>main</code> branch of GitHub.</p>
</li>
<li>
<p>A path to a <em>directory</em> (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</p>
</li>
</ul>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>&#x1F9EA; This is an experimental feature and may change in the future.</p>

					</div>
<p>For more information on how to load and create custom pipelines, take a look at <a href="https://huggingface.co/docs/diffusers/main/en/using-diffusers/contribute_pipeline" rel="nofollow">How to contribute a
community pipeline</a>.`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.download.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.download.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.DiffusionPipeline.download.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.download.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.download.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.download.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.DiffusionPipeline.download.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.download.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. It can be a &#x1F917; Diffusers version when loading a
custom pipeline from GitHub, otherwise it defaults to <code>&quot;main&quot;</code> when loading from the Hub.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.download.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.download.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.download.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.download.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"},{anchor:"diffusers.DiffusionPipeline.download.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom pipelines and components defined on the Hub in their own files. This
option should only be set to <code>True</code> for repositories you trust and in which you have read the code, as
it will execute code present on the Hub on your local machine.`,name:"trust_remote_code"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1552",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A path to the downloaded pipeline.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>os.PathLike</code></p>
`}}),ne=new it({props:{$$slots:{default:[ci]},$$scope:{ctx:T}}}),Ge=new D({props:{name:"enable_attention_slicing",anchor:"diffusers.DiffusionPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2063"}}),oe=new it({props:{warning:!0,$$slots:{default:[fi]},$$scope:{ctx:T}}}),ie=new we({props:{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.example",$$slots:{default:[mi]},$$scope:{ctx:T}}}),We=new D({props:{name:"enable_model_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1410"}}),Be=new D({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1499"}}),He=new D({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2002"}}),re=new it({props:{warning:!0,$$slots:{default:[ui]},$$scope:{ctx:T}}}),le=new we({props:{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[hi]},$$scope:{ctx:T}}}),Fe=new D({props:{name:"from_pretrained",anchor:"diffusers.DiffusionPipeline.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_pipeline_directory/</code>) containing pipeline weights
saved using
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">save_pretrained()</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If &#x201C;auto&#x201D; is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>&#x1F9EA; This is an experimental feature and may change in the future.</p>

					</div>
<p>Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>hf-internal-testing/diffusers-dummy-pipeline</code>) of a custom
pipeline hosted on the Hub. The repository must contain a file called pipeline.py that defines
the custom pipeline.</li>
<li>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current main branch of GitHub.</li>
<li>A path to a directory (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</li>
</ul>
<p>For more information on how to load and create custom pipelines, please have a look at <a href="https://huggingface.co/docs/diffusers/using-diffusers/custom_pipeline_overview" rel="nofollow">Loading and
Adding Custom
Pipelines</a>`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. It can be a &#x1F917; Diffusers version when loading a
custom pipeline from GitHub, otherwise it defaults to <code>&quot;main&quot;</code> when loading from the Hub.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.device_map",description:`<strong>device_map</strong> (<code>str</code> or <code>Dict[str, Union[int, str, torch.device]]</code>, <em>optional</em>) &#x2014;
A map that specifies where each submodule should go. It doesn&#x2019;t need to be defined for each
parameter/buffer name; once a given module name is inside, every submodule of it will be sent to the
same device.</p>
<p>Set <code>device_map=&quot;auto&quot;</code> to have &#x1F917; Accelerate automatically compute the most optimized <code>device_map</code>. For
more information about each option see <a href="https://hf.co/docs/accelerate/main/en/usage_guides/big_modeling#designing-a-device-map" rel="nofollow">designing a device
map</a>.`,name:"device_map"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.max_memory",description:`<strong>max_memory</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary device identifier for the maximum memory. Will default to the maximum memory available for
each GPU and the available CPU RAM if unset.`,name:"max_memory"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_folder",description:`<strong>offload_folder</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
The path to offload weights if device_map contains the value <code>&quot;disk&quot;</code>.`,name:"offload_folder"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_state_dict",description:`<strong>offload_state_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, temporarily offloads the CPU state dict to the hard drive to avoid running out of CPU RAM if
the weight of the CPU state dict + the biggest shard of the checkpoint does not fit. Defaults to <code>True</code>
when there is some disk offload.`,name:"offload_state_dict"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components of the specific pipeline
class). The overwritten components are passed directly to the pipelines <code>__init__</code> method. See example
below for more information.`,name:"kwargs"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L931"}}),de=new we({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example",$$slots:{default:[gi]},$$scope:{ctx:T}}}),pe=new it({props:{$$slots:{default:[bi]},$$scope:{ctx:T}}}),ce=new we({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example-2",$$slots:{default:[_i]},$$scope:{ctx:T}}}),Ve=new D({props:{name:"maybe_free_model_hooks",anchor:"diffusers.DiffusionPipeline.maybe_free_model_hooks",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1480"}}),Ne=new D({props:{name:"numpy_to_pil",anchor:"diffusers.DiffusionPipeline.numpy_to_pil",parameters:[{name:"images",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1977"}}),Xe=new D({props:{name:"save_pretrained",anchor:"diffusers.DiffusionPipeline.save_pretrained",parameters:[{name:"save_directory",val:": Union"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": Optional = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save a pipeline to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L624"}}),Le=new sn({props:{title:"FlaxDiffusionPipeline",local:"diffusers.FlaxDiffusionPipeline",headingTag:"h2"}}),Se=new D({props:{name:"class diffusers.FlaxDiffusionPipeline",anchor:"diffusers.FlaxDiffusionPipeline",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L101"}}),Re=new D({props:{name:"from_pretrained",anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>runwayml/stable-diffusion-v1-5</code>) of a pretrained pipeline
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_model_directory</code>) containing the model weights saved
using <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline.save_pretrained">save_pretrained()</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.dtype",description:`<strong>dtype</strong> (<code>str</code> or <code>jnp.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>jnp.dtype</code> and load the model under this dtype. If <code>&quot;auto&quot;</code>, the dtype is
automatically derived from the model&#x2019;s weights.`,name:"dtype"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components) of the specific pipeline
class. The overwritten components are passed directly to the pipelines <code>__init__</code> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L229"}}),he=new we({props:{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.example",$$slots:{default:[yi]},$$scope:{ctx:T}}}),ge=new it({props:{$$slots:{default:[vi]},$$scope:{ctx:T}}}),be=new we({props:{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.example-2",$$slots:{default:[wi]},$$scope:{ctx:T}}}),Ee=new D({props:{name:"numpy_to_pil",anchor:"diffusers.FlaxDiffusionPipeline.numpy_to_pil",parameters:[{name:"images",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L588"}}),ze=new D({props:{name:"save_pretrained",anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained",parameters:[{name:"save_directory",val:": Union"},{name:"params",val:": Union"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to which to save. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L151"}}),Ye=new sn({props:{title:"PushToHubMixin",local:"diffusers.utils.PushToHubMixin",headingTag:"h2"}}),Qe=new D({props:{name:"class diffusers.utils.PushToHubMixin",anchor:"diffusers.utils.PushToHubMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L351"}}),qe=new D({props:{name:"push_to_hub",anchor:"diffusers.utils.PushToHubMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"commit_message",val:": Optional = None"},{name:"private",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your model, scheduler, or pipeline files to. It should
contain your organization name when pushing to an organization. <code>repo_id</code> can also be a path to a local
directory.`,name:"repo_id"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Default to <code>&quot;Upload {object}&quot;</code>.`,name:"commit_message"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. The token generated when running
<code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights to the <code>safetensors</code> format.`,name:"safe_serialization"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L380"}}),ve=new we({props:{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.example",$$slots:{default:[xi]},$$scope:{ctx:T}}}),{c(){n=l("meta"),h=i(),a=l("p"),r=i(),g(m.$$.fragment),t=i(),M=l("p"),M.textContent=J,E=i(),$e=l("p"),$e.innerHTML=vo,St=i(),g(q.$$.fragment),Rt=i(),Me=l("p"),Me.textContent=wo,Et=i(),Te=l("table"),Te.innerHTML=xo,zt=i(),g(Ue.$$.fragment),Yt=i(),x=l("div"),g(je.$$.fragment),an=i(),st=l("p"),st.textContent=$o,rn=i(),at=l("p"),at.innerHTML=Mo,ln=i(),rt=l("ul"),rt.innerHTML=To,dn=i(),lt=l("p"),lt.textContent=Uo,pn=i(),dt=l("ul"),dt.innerHTML=jo,cn=i(),A=l("div"),g(Pe.$$.fragment),fn=i(),pt=l("p"),pt.textContent=Po,mn=i(),ct=l("div"),g(De.$$.fragment),un=i(),W=l("div"),g(Ze.$$.fragment),hn=i(),ft=l("p"),ft.innerHTML=Do,gn=i(),g(O.$$.fragment),bn=i(),mt=l("p"),mt.innerHTML=Zo,_n=i(),ut=l("ul"),ut.innerHTML=Jo,yn=i(),H=l("div"),g(Je.$$.fragment),vn=i(),ht=l("p"),ht.innerHTML=ko,wn=i(),gt=l("p"),gt.innerHTML=Co,xn=i(),g(K.$$.fragment),$n=i(),ee=l("div"),g(ke.$$.fragment),Mn=i(),bt=l("p"),bt.innerHTML=Io,Tn=i(),te=l("div"),g(Ce.$$.fragment),Un=i(),_t=l("p"),_t.innerHTML=Go,jn=i(),z=l("div"),g(Ie.$$.fragment),Pn=i(),yt=l("p"),yt.textContent=Wo,Dn=i(),g(ne.$$.fragment),Zn=i(),F=l("div"),g(Ge.$$.fragment),Jn=i(),vt=l("p"),vt.textContent=Bo,kn=i(),g(oe.$$.fragment),Cn=i(),g(ie.$$.fragment),In=i(),se=l("div"),g(We.$$.fragment),Gn=i(),wt=l("p"),wt.innerHTML=Ho,Wn=i(),ae=l("div"),g(Be.$$.fragment),Bn=i(),xt=l("p"),xt.innerHTML=Fo,Hn=i(),V=l("div"),g(He.$$.fragment),Fn=i(),$t=l("p"),$t.innerHTML=Vo,Vn=i(),g(re.$$.fragment),Nn=i(),g(le.$$.fragment),Xn=i(),k=l("div"),g(Fe.$$.fragment),Ln=i(),Mt=l("p"),Mt.textContent=No,Sn=i(),Tt=l("p"),Tt.innerHTML=Xo,Rn=i(),g(de.$$.fragment),En=i(),g(pe.$$.fragment),zn=i(),g(ce.$$.fragment),Yn=i(),fe=l("div"),g(Ve.$$.fragment),Qn=i(),Ut=l("p"),Ut.innerHTML=Lo,qn=i(),me=l("div"),g(Ne.$$.fragment),An=i(),jt=l("p"),jt.textContent=So,On=i(),ue=l("div"),g(Xe.$$.fragment),Kn=i(),Pt=l("p"),Pt.innerHTML=Ro,Qt=i(),g(Le.$$.fragment),qt=i(),P=l("div"),g(Se.$$.fragment),eo=i(),Dt=l("p"),Dt.textContent=Eo,to=i(),Zt=l("p"),Zt.innerHTML=zo,no=i(),Jt=l("ul"),Jt.innerHTML=Yo,oo=i(),kt=l("p"),kt.textContent=Qo,io=i(),Ct=l("ul"),Ct.innerHTML=qo,so=i(),C=l("div"),g(Re.$$.fragment),ao=i(),It=l("p"),It.textContent=Ao,ro=i(),Gt=l("p"),Gt.textContent=Oo,lo=i(),g(he.$$.fragment),po=i(),g(ge.$$.fragment),co=i(),g(be.$$.fragment),fo=i(),_e=l("div"),g(Ee.$$.fragment),mo=i(),Wt=l("p"),Wt.textContent=Ko,uo=i(),ye=l("div"),g(ze.$$.fragment),ho=i(),Bt=l("p"),Bt.innerHTML=ei,At=i(),g(Ye.$$.fragment),Ot=i(),X=l("div"),g(Qe.$$.fragment),go=i(),Ht=l("p"),Ht.textContent=ti,bo=i(),Y=l("div"),g(qe.$$.fragment),_o=i(),Ft=l("p"),Ft.textContent=ni,yo=i(),g(ve.$$.fragment),Kt=i(),Xt=l("p"),this.h()},l(e){const c=ri("svelte-u9bgzb",document.head);n=d(c,"META",{name:!0,content:!0}),c.forEach(p),h=s(e),a=d(e,"P",{}),U(a).forEach(p),r=s(e),b(m.$$.fragment,e),t=s(e),M=d(e,"P",{"data-svelte-h":!0}),f(M)!=="svelte-eejdx6"&&(M.textContent=J),E=s(e),$e=d(e,"P",{"data-svelte-h":!0}),f($e)!=="svelte-1d3b6kb"&&($e.innerHTML=vo),St=s(e),b(q.$$.fragment,e),Rt=s(e),Me=d(e,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-2xd39c"&&(Me.textContent=wo),Et=s(e),Te=d(e,"TABLE",{"data-svelte-h":!0}),f(Te)!=="svelte-ht6h0o"&&(Te.innerHTML=xo),zt=s(e),b(Ue.$$.fragment,e),Yt=s(e),x=d(e,"DIV",{class:!0});var $=U(x);b(je.$$.fragment,$),an=s($),st=d($,"P",{"data-svelte-h":!0}),f(st)!=="svelte-1neg3rw"&&(st.textContent=$o),rn=s($),at=d($,"P",{"data-svelte-h":!0}),f(at)!=="svelte-1kbb8l4"&&(at.innerHTML=Mo),ln=s($),rt=d($,"UL",{"data-svelte-h":!0}),f(rt)!=="svelte-2a5chx"&&(rt.innerHTML=To),dn=s($),lt=d($,"P",{"data-svelte-h":!0}),f(lt)!=="svelte-wz8va1"&&(lt.textContent=Uo),pn=s($),dt=d($,"UL",{"data-svelte-h":!0}),f(dt)!=="svelte-1ilr6sx"&&(dt.innerHTML=jo),cn=s($),A=d($,"DIV",{class:!0});var Ae=U(A);b(Pe.$$.fragment,Ae),fn=s(Ae),pt=d(Ae,"P",{"data-svelte-h":!0}),f(pt)!=="svelte-1eed40t"&&(pt.textContent=Po),Ae.forEach(p),mn=s($),ct=d($,"DIV",{class:!0});var Lt=U(ct);b(De.$$.fragment,Lt),Lt.forEach(p),un=s($),W=d($,"DIV",{class:!0});var B=U(W);b(Ze.$$.fragment,B),hn=s(B),ft=d(B,"P",{"data-svelte-h":!0}),f(ft)!=="svelte-1vbhnip"&&(ft.innerHTML=Do),gn=s(B),b(O.$$.fragment,B),bn=s(B),mt=d(B,"P",{"data-svelte-h":!0}),f(mt)!=="svelte-5ul9n2"&&(mt.innerHTML=Zo),_n=s(B),ut=d(B,"UL",{"data-svelte-h":!0}),f(ut)!=="svelte-1icy6l9"&&(ut.innerHTML=Jo),B.forEach(p),yn=s($),H=d($,"DIV",{class:!0});var L=U(H);b(Je.$$.fragment,L),vn=s(L),ht=d(L,"P",{"data-svelte-h":!0}),f(ht)!=="svelte-had4mb"&&(ht.innerHTML=ko),wn=s(L),gt=d(L,"P",{"data-svelte-h":!0}),f(gt)!=="svelte-19k67ce"&&(gt.innerHTML=Co),xn=s(L),b(K.$$.fragment,L),L.forEach(p),$n=s($),ee=d($,"DIV",{class:!0});var Oe=U(ee);b(ke.$$.fragment,Oe),Mn=s(Oe),bt=d(Oe,"P",{"data-svelte-h":!0}),f(bt)!=="svelte-1lh0nh5"&&(bt.innerHTML=Io),Oe.forEach(p),Tn=s($),te=d($,"DIV",{class:!0});var Ke=U(te);b(Ce.$$.fragment,Ke),Un=s(Ke),_t=d(Ke,"P",{"data-svelte-h":!0}),f(_t)!=="svelte-1vfte1e"&&(_t.innerHTML=Go),Ke.forEach(p),jn=s($),z=d($,"DIV",{class:!0});var Q=U(z);b(Ie.$$.fragment,Q),Pn=s(Q),yt=d(Q,"P",{"data-svelte-h":!0}),f(yt)!=="svelte-1mfctah"&&(yt.textContent=Wo),Dn=s(Q),b(ne.$$.fragment,Q),Q.forEach(p),Zn=s($),F=d($,"DIV",{class:!0});var S=U(F);b(Ge.$$.fragment,S),Jn=s(S),vt=d(S,"P",{"data-svelte-h":!0}),f(vt)!=="svelte-10jaql7"&&(vt.textContent=Bo),kn=s(S),b(oe.$$.fragment,S),Cn=s(S),b(ie.$$.fragment,S),S.forEach(p),In=s($),se=d($,"DIV",{class:!0});var et=U(se);b(We.$$.fragment,et),Gn=s(et),wt=d(et,"P",{"data-svelte-h":!0}),f(wt)!=="svelte-d7vywi"&&(wt.innerHTML=Ho),et.forEach(p),Wn=s($),ae=d($,"DIV",{class:!0});var tt=U(ae);b(Be.$$.fragment,tt),Bn=s(tt),xt=d(tt,"P",{"data-svelte-h":!0}),f(xt)!=="svelte-n1oyuv"&&(xt.innerHTML=Fo),tt.forEach(p),Hn=s($),V=d($,"DIV",{class:!0});var R=U(V);b(He.$$.fragment,R),Fn=s(R),$t=d(R,"P",{"data-svelte-h":!0}),f($t)!=="svelte-e03q3e"&&($t.innerHTML=Vo),Vn=s(R),b(re.$$.fragment,R),Nn=s(R),b(le.$$.fragment,R),R.forEach(p),Xn=s($),k=d($,"DIV",{class:!0});var I=U(k);b(Fe.$$.fragment,I),Ln=s(I),Mt=d(I,"P",{"data-svelte-h":!0}),f(Mt)!=="svelte-ccbjek"&&(Mt.textContent=No),Sn=s(I),Tt=d(I,"P",{"data-svelte-h":!0}),f(Tt)!=="svelte-1p5vgmd"&&(Tt.innerHTML=Xo),Rn=s(I),b(de.$$.fragment,I),En=s(I),b(pe.$$.fragment,I),zn=s(I),b(ce.$$.fragment,I),I.forEach(p),Yn=s($),fe=d($,"DIV",{class:!0});var nt=U(fe);b(Ve.$$.fragment,nt),Qn=s(nt),Ut=d(nt,"P",{"data-svelte-h":!0}),f(Ut)!=="svelte-zkab0b"&&(Ut.innerHTML=Lo),nt.forEach(p),qn=s($),me=d($,"DIV",{class:!0});var ot=U(me);b(Ne.$$.fragment,ot),An=s(ot),jt=d(ot,"P",{"data-svelte-h":!0}),f(jt)!=="svelte-1gut907"&&(jt.textContent=So),ot.forEach(p),On=s($),ue=d($,"DIV",{class:!0});var tn=U(ue);b(Xe.$$.fragment,tn),Kn=s(tn),Pt=d(tn,"P",{"data-svelte-h":!0}),f(Pt)!=="svelte-1jcmq84"&&(Pt.innerHTML=Ro),tn.forEach(p),$.forEach(p),Qt=s(e),b(Le.$$.fragment,e),qt=s(e),P=d(e,"DIV",{class:!0});var Z=U(P);b(Se.$$.fragment,Z),eo=s(Z),Dt=d(Z,"P",{"data-svelte-h":!0}),f(Dt)!=="svelte-1o1wti6"&&(Dt.textContent=Eo),to=s(Z),Zt=d(Z,"P",{"data-svelte-h":!0}),f(Zt)!=="svelte-1h33ucg"&&(Zt.innerHTML=zo),no=s(Z),Jt=d(Z,"UL",{"data-svelte-h":!0}),f(Jt)!=="svelte-1kk3msp"&&(Jt.innerHTML=Yo),oo=s(Z),kt=d(Z,"P",{"data-svelte-h":!0}),f(kt)!=="svelte-wz8va1"&&(kt.textContent=Qo),io=s(Z),Ct=d(Z,"UL",{"data-svelte-h":!0}),f(Ct)!=="svelte-56flce"&&(Ct.innerHTML=qo),so=s(Z),C=d(Z,"DIV",{class:!0});var N=U(C);b(Re.$$.fragment,N),ao=s(N),It=d(N,"P",{"data-svelte-h":!0}),f(It)!=="svelte-7z61o"&&(It.textContent=Ao),ro=s(N),Gt=d(N,"P",{"data-svelte-h":!0}),f(Gt)!=="svelte-wyh2cr"&&(Gt.textContent=Oo),lo=s(N),b(he.$$.fragment,N),po=s(N),b(ge.$$.fragment,N),co=s(N),b(be.$$.fragment,N),N.forEach(p),fo=s(Z),_e=d(Z,"DIV",{class:!0});var nn=U(_e);b(Ee.$$.fragment,nn),mo=s(nn),Wt=d(nn,"P",{"data-svelte-h":!0}),f(Wt)!=="svelte-1gut907"&&(Wt.textContent=Ko),nn.forEach(p),uo=s(Z),ye=d(Z,"DIV",{class:!0});var on=U(ye);b(ze.$$.fragment,on),ho=s(on),Bt=d(on,"P",{"data-svelte-h":!0}),f(Bt)!=="svelte-spoull"&&(Bt.innerHTML=ei),on.forEach(p),Z.forEach(p),At=s(e),b(Ye.$$.fragment,e),Ot=s(e),X=d(e,"DIV",{class:!0});var Vt=U(X);b(Qe.$$.fragment,Vt),go=s(Vt),Ht=d(Vt,"P",{"data-svelte-h":!0}),f(Ht)!=="svelte-7y8zei"&&(Ht.textContent=ti),bo=s(Vt),Y=d(Vt,"DIV",{class:!0});var Nt=U(Y);b(qe.$$.fragment,Nt),_o=s(Nt),Ft=d(Nt,"P",{"data-svelte-h":!0}),f(Ft)!=="svelte-5nfhmh"&&(Ft.textContent=ni),yo=s(Nt),b(ve.$$.fragment,Nt),Nt.forEach(p),Vt.forEach(p),Kt=s(e),Xt=d(e,"P",{}),U(Xt).forEach(p),this.h()},h(){j(n,"name","hf:doc:metadata"),j(n,"content",Mi),j(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){o(document.head,n),u(e,h,c),u(e,a,c),u(e,r,c),_(m,e,c),u(e,t,c),u(e,M,c),u(e,E,c),u(e,$e,c),u(e,St,c),_(q,e,c),u(e,Rt,c),u(e,Me,c),u(e,Et,c),u(e,Te,c),u(e,zt,c),_(Ue,e,c),u(e,Yt,c),u(e,x,c),_(je,x,null),o(x,an),o(x,st),o(x,rn),o(x,at),o(x,ln),o(x,rt),o(x,dn),o(x,lt),o(x,pn),o(x,dt),o(x,cn),o(x,A),_(Pe,A,null),o(A,fn),o(A,pt),o(x,mn),o(x,ct),_(De,ct,null),o(x,un),o(x,W),_(Ze,W,null),o(W,hn),o(W,ft),o(W,gn),_(O,W,null),o(W,bn),o(W,mt),o(W,_n),o(W,ut),o(x,yn),o(x,H),_(Je,H,null),o(H,vn),o(H,ht),o(H,wn),o(H,gt),o(H,xn),_(K,H,null),o(x,$n),o(x,ee),_(ke,ee,null),o(ee,Mn),o(ee,bt),o(x,Tn),o(x,te),_(Ce,te,null),o(te,Un),o(te,_t),o(x,jn),o(x,z),_(Ie,z,null),o(z,Pn),o(z,yt),o(z,Dn),_(ne,z,null),o(x,Zn),o(x,F),_(Ge,F,null),o(F,Jn),o(F,vt),o(F,kn),_(oe,F,null),o(F,Cn),_(ie,F,null),o(x,In),o(x,se),_(We,se,null),o(se,Gn),o(se,wt),o(x,Wn),o(x,ae),_(Be,ae,null),o(ae,Bn),o(ae,xt),o(x,Hn),o(x,V),_(He,V,null),o(V,Fn),o(V,$t),o(V,Vn),_(re,V,null),o(V,Nn),_(le,V,null),o(x,Xn),o(x,k),_(Fe,k,null),o(k,Ln),o(k,Mt),o(k,Sn),o(k,Tt),o(k,Rn),_(de,k,null),o(k,En),_(pe,k,null),o(k,zn),_(ce,k,null),o(x,Yn),o(x,fe),_(Ve,fe,null),o(fe,Qn),o(fe,Ut),o(x,qn),o(x,me),_(Ne,me,null),o(me,An),o(me,jt),o(x,On),o(x,ue),_(Xe,ue,null),o(ue,Kn),o(ue,Pt),u(e,Qt,c),_(Le,e,c),u(e,qt,c),u(e,P,c),_(Se,P,null),o(P,eo),o(P,Dt),o(P,to),o(P,Zt),o(P,no),o(P,Jt),o(P,oo),o(P,kt),o(P,io),o(P,Ct),o(P,so),o(P,C),_(Re,C,null),o(C,ao),o(C,It),o(C,ro),o(C,Gt),o(C,lo),_(he,C,null),o(C,po),_(ge,C,null),o(C,co),_(be,C,null),o(P,fo),o(P,_e),_(Ee,_e,null),o(_e,mo),o(_e,Wt),o(P,uo),o(P,ye),_(ze,ye,null),o(ye,ho),o(ye,Bt),u(e,At,c),_(Ye,e,c),u(e,Ot,c),u(e,X,c),_(Qe,X,null),o(X,go),o(X,Ht),o(X,bo),o(X,Y),_(qe,Y,null),o(Y,_o),o(Y,Ft),o(Y,yo),_(ve,Y,null),u(e,Kt,c),u(e,Xt,c),en=!0},p(e,[c]){const $={};c&2&&($.$$scope={dirty:c,ctx:e}),q.$set($);const Ae={};c&2&&(Ae.$$scope={dirty:c,ctx:e}),O.$set(Ae);const Lt={};c&2&&(Lt.$$scope={dirty:c,ctx:e}),K.$set(Lt);const B={};c&2&&(B.$$scope={dirty:c,ctx:e}),ne.$set(B);const L={};c&2&&(L.$$scope={dirty:c,ctx:e}),oe.$set(L);const Oe={};c&2&&(Oe.$$scope={dirty:c,ctx:e}),ie.$set(Oe);const Ke={};c&2&&(Ke.$$scope={dirty:c,ctx:e}),re.$set(Ke);const Q={};c&2&&(Q.$$scope={dirty:c,ctx:e}),le.$set(Q);const S={};c&2&&(S.$$scope={dirty:c,ctx:e}),de.$set(S);const et={};c&2&&(et.$$scope={dirty:c,ctx:e}),pe.$set(et);const tt={};c&2&&(tt.$$scope={dirty:c,ctx:e}),ce.$set(tt);const R={};c&2&&(R.$$scope={dirty:c,ctx:e}),he.$set(R);const I={};c&2&&(I.$$scope={dirty:c,ctx:e}),ge.$set(I);const nt={};c&2&&(nt.$$scope={dirty:c,ctx:e}),be.$set(nt);const ot={};c&2&&(ot.$$scope={dirty:c,ctx:e}),ve.$set(ot)},i(e){en||(y(m.$$.fragment,e),y(q.$$.fragment,e),y(Ue.$$.fragment,e),y(je.$$.fragment,e),y(Pe.$$.fragment,e),y(De.$$.fragment,e),y(Ze.$$.fragment,e),y(O.$$.fragment,e),y(Je.$$.fragment,e),y(K.$$.fragment,e),y(ke.$$.fragment,e),y(Ce.$$.fragment,e),y(Ie.$$.fragment,e),y(ne.$$.fragment,e),y(Ge.$$.fragment,e),y(oe.$$.fragment,e),y(ie.$$.fragment,e),y(We.$$.fragment,e),y(Be.$$.fragment,e),y(He.$$.fragment,e),y(re.$$.fragment,e),y(le.$$.fragment,e),y(Fe.$$.fragment,e),y(de.$$.fragment,e),y(pe.$$.fragment,e),y(ce.$$.fragment,e),y(Ve.$$.fragment,e),y(Ne.$$.fragment,e),y(Xe.$$.fragment,e),y(Le.$$.fragment,e),y(Se.$$.fragment,e),y(Re.$$.fragment,e),y(he.$$.fragment,e),y(ge.$$.fragment,e),y(be.$$.fragment,e),y(Ee.$$.fragment,e),y(ze.$$.fragment,e),y(Ye.$$.fragment,e),y(Qe.$$.fragment,e),y(qe.$$.fragment,e),y(ve.$$.fragment,e),en=!0)},o(e){v(m.$$.fragment,e),v(q.$$.fragment,e),v(Ue.$$.fragment,e),v(je.$$.fragment,e),v(Pe.$$.fragment,e),v(De.$$.fragment,e),v(Ze.$$.fragment,e),v(O.$$.fragment,e),v(Je.$$.fragment,e),v(K.$$.fragment,e),v(ke.$$.fragment,e),v(Ce.$$.fragment,e),v(Ie.$$.fragment,e),v(ne.$$.fragment,e),v(Ge.$$.fragment,e),v(oe.$$.fragment,e),v(ie.$$.fragment,e),v(We.$$.fragment,e),v(Be.$$.fragment,e),v(He.$$.fragment,e),v(re.$$.fragment,e),v(le.$$.fragment,e),v(Fe.$$.fragment,e),v(de.$$.fragment,e),v(pe.$$.fragment,e),v(ce.$$.fragment,e),v(Ve.$$.fragment,e),v(Ne.$$.fragment,e),v(Xe.$$.fragment,e),v(Le.$$.fragment,e),v(Se.$$.fragment,e),v(Re.$$.fragment,e),v(he.$$.fragment,e),v(ge.$$.fragment,e),v(be.$$.fragment,e),v(Ee.$$.fragment,e),v(ze.$$.fragment,e),v(Ye.$$.fragment,e),v(Qe.$$.fragment,e),v(qe.$$.fragment,e),v(ve.$$.fragment,e),en=!1},d(e){e&&(p(h),p(a),p(r),p(t),p(M),p(E),p($e),p(St),p(Rt),p(Me),p(Et),p(Te),p(zt),p(Yt),p(x),p(Qt),p(qt),p(P),p(At),p(Ot),p(X),p(Kt),p(Xt)),p(n),w(m,e),w(q,e),w(Ue,e),w(je),w(Pe),w(De),w(Ze),w(O),w(Je),w(K),w(ke),w(Ce),w(Ie),w(ne),w(Ge),w(oe),w(ie),w(We),w(Be),w(He),w(re),w(le),w(Fe),w(de),w(pe),w(ce),w(Ve),w(Ne),w(Xe),w(Le,e),w(Se),w(Re),w(he),w(ge),w(be),w(Ee),w(ze),w(Ye,e),w(Qe),w(qe),w(ve)}}}const Mi='{"title":"Pipelines","local":"pipelines","sections":[{"title":"DiffusionPipeline","local":"diffusers.DiffusionPipeline","sections":[],"depth":2},{"title":"FlaxDiffusionPipeline","local":"diffusers.FlaxDiffusionPipeline","sections":[],"depth":2},{"title":"PushToHubMixin","local":"diffusers.utils.PushToHubMixin","sections":[],"depth":2}],"depth":1}';function Ti(T){return ii(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ci extends si{constructor(n){super(),ai(this,n,Ti,$i,oi,{})}}export{Ci as component};
