import{s as Ce,n as Be,o as xe}from"../chunks/scheduler.7bc62968.js";import{S as Ze,i as ke,g as j,s as n,r as p,A as Qe,h,f as t,c as e,j as $e,u as i,x as J,k as be,y as Ne,a,v as M,d as o,t as c,w as r}from"../chunks/index.66556066.js";import{C as y}from"../chunks/CodeBlock.a759539a.js";import{H as m,E as Ge}from"../chunks/EditOnGithub.46ca76a5.js";function Ee(bn){let T,_l,Fl,Ll,u,Dl,w,Cn=`A Typescript powered wrapper for the Hugging Face Inference Endpoints API. Learn more about Inference Endpoints at <a href="https://huggingface.co/inference-endpoints" rel="nofollow">Hugging Face</a>.
It works with both <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API (serverless)</a> and <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints (dedicated)</a>.`,Pl,g,Bn='You can also try out a live <a href="https://observablehq.com/@huggingface/hello-huggingface-js-inference" rel="nofollow">interactive notebook</a>, see some demos on <a href="https://huggingface.co/huggingfacejs" rel="nofollow">hf.co/huggingfacejs</a>, or watch a <a href="https://scrimba.com/scrim/cod8248f5adfd6e129582c523" rel="nofollow">Scrimba tutorial that explains how Inference Endpoints works</a>.',Kl,f,Ol,d,st,U,lt,I,tt,$,at,b,nt,C,et,B,pt,x,xn='❗<strong>Important note:</strong> Using an access token is optional to get started, however you will be rate limited eventually. Join <a href="https://huggingface.co/join" rel="nofollow">Hugging Face</a> and then visit <a href="https://huggingface.co/settings/tokens" rel="nofollow">access tokens</a> to generate your access token for <strong>free</strong>.',it,Z,Zn="Your access token should be kept private. If you need to protect it in front-end applications, we suggest setting up a proxy server that stores the access token.",Mt,k,ot,Q,kn="You can import the functions you need directly from the module instead of using the <code>HfInference</code> class.",ct,N,rt,G,Qn="This will enable tree-shaking by your bundler.",jt,E,ht,W,Jt,v,Nn="Generates text from an input prompt.",mt,A,Gn='<a href="https://huggingface.co/spaces/huggingfacejs/streaming-text-generation" rel="nofollow">Demo</a>',yt,X,Tt,Y,ut,S,En='Using the <code>chatCompletion</code> method, you can generate text with models compatible with the OpenAI Chat Completion API. All models served by <a href="https://api-inference.huggingface.co/framework/text-generation-inference" rel="nofollow">TGI</a> on Hugging Face support Messages API.',wt,V,Wn='<a href="https://huggingface.co/spaces/huggingfacejs/streaming-chat-completion" rel="nofollow">Demo</a>',gt,R,ft,q,vn="It’s also possible to call Mistral or OpenAI endpoints directly:",dt,z,Ut,F,It,H,An="Tries to fill in a hole with a missing word (token to be precise).",$t,_,bt,L,Ct,D,Xn="Summarizes longer text into shorter text. Be careful, some models have a maximum length of input.",Bt,P,xt,K,Zt,O,Yn="Answers questions based on the context you provide.",kt,ss,Qt,ls,Nt,ts,Gt,as,Et,ns,Sn="Often used for sentiment analysis, this method will assign labels to the given text along with a probability score of that label.",Wt,es,vt,ps,At,is,Vn="Used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.",Xt,Ms,Yt,os,St,cs,Rn="Converts text from one language to another.",Vt,rs,Rt,js,qt,hs,qn="Checks how well an input text fits into a set of labels you provide.",zt,Js,Ft,ms,Ht,ys,zn="This task corresponds to any chatbot-like structure. Models tend to have shorter max_length, so please check with caution when using a given model if you need long-range dependency or not.",_t,Ts,Lt,us,Dt,ws,Fn="Calculate the semantic similarity between one text and a list of other sentences.",Pt,gs,Kt,fs,Ot,ds,sa,Us,Hn="Transcribes speech from an audio file.",la,Is,_n='<a href="https://huggingface.co/spaces/huggingfacejs/speech-recognition-vue" rel="nofollow">Demo</a>',ta,$s,aa,bs,na,Cs,Ln="Assigns labels to the given audio along with a probability score of that label.",ea,Bs,Dn='<a href="https://huggingface.co/spaces/huggingfacejs/audio-classification-vue" rel="nofollow">Demo</a>',pa,xs,ia,Zs,Ma,ks,Pn="Generates natural-sounding speech from text input.",oa,Qs,Kn='<a href="https://scrimba.com/scrim/co8da4d23b49b648f77f4848a?pl=pkVnrP7uP" rel="nofollow">Interactive tutorial</a>',ca,Ns,ra,Gs,ja,Es,On="Outputs one or multiple generated audios from an input audio, commonly used for speech enhancement and source separation.",ha,Ws,Ja,vs,ma,As,ya,Xs,se="Assigns labels to a given image along with a probability score of that label.",Ta,Ys,le='<a href="https://huggingface.co/spaces/huggingfacejs/image-classification-vue" rel="nofollow">Demo</a>',ua,Ss,wa,Vs,ga,Rs,te="Detects objects within an image and returns labels with corresponding bounding boxes and probability scores.",fa,qs,ae='<a href="https://huggingface.co/spaces/huggingfacejs/object-detection-vue" rel="nofollow">Demo</a>',da,zs,Ua,Fs,Ia,Hs,ne="Detects segments within an image and returns labels with corresponding bounding boxes and probability scores.",$a,_s,ba,Ls,Ca,Ds,ee="Outputs text from a given image, commonly used for captioning or optical character recognition.",Ba,Ps,xa,Ks,Za,Os,pe="Creates an image from a text prompt.",ka,sl,ie='<a href="https://huggingface.co/spaces/huggingfacejs/image-to-text" rel="nofollow">Demo</a>',Qa,ll,Na,tl,Ga,al,Me="Image-to-image is the task of transforming a source image to match the characteristics of a target image or a target image domain.",Ea,nl,oe='<a href="https://scrimba.com/scrim/co4834bf9a91cc81cfab07969?pl=pkVnrP7uP" rel="nofollow">Interactive tutorial</a>',Wa,el,va,pl,Aa,il,ce="Checks how well an input image fits into a set of labels you provide.",Xa,Ml,Ya,ol,Sa,cl,Va,rl,re="This task reads some text and outputs raw float values, that are usually consumed as part of a semantic database/semantic search.",Ra,jl,qa,hl,za,Jl,je="Visual Question Answering is the task of answering open-ended questions based on an image. They output natural language responses to natural language questions.",Fa,ml,he='<a href="https://huggingface.co/spaces/huggingfacejs/doc-vis-qa" rel="nofollow">Demo</a>',Ha,yl,_a,Tl,La,ul,Je="Document question answering models take a (document, question) pair as input and return an answer in natural language.",Da,wl,me='<a href="https://huggingface.co/spaces/huggingfacejs/doc-vis-qa" rel="nofollow">Demo</a>',Pa,gl,Ka,fl,Oa,dl,sn,Ul,ye="Tabular regression is the task of predicting a numerical value given a set of attributes.",ln,Il,tn,$l,an,bl,Te="Tabular classification is the task of classifying a target category (a group) based on set of attributes.",nn,Cl,en,Bl,pn,xl,ue="For models with custom parameters / outputs.",Mn,Zl,on,kl,we="You can use any Chat Completion API-compatible provider with the <code>chatCompletion</code> method.",cn,Ql,rn,Nl,jn,Gl,ge='Learn more about using your own inference endpoints <a href="https://hf.co/docs/inference-endpoints/" rel="nofollow">here</a>',hn,El,Jn,Wl,fe=`By default, all calls to the inference endpoint will wait until the model is
loaded. When <a href="https://huggingface.co/docs/inference-endpoints/en/autoscaling#scaling-to-0" rel="nofollow">scaling to
0</a>
is enabled on the endpoint, this can result in non-trivial waiting time. If
you’d rather disable this behavior and handle the endpoint’s returned 500 HTTP
errors yourself, you can do so like so:`,mn,vl,yn,Al,Tn,Xl,un,Yl,wn,Sl,de='We have an informative documentation project called <a href="https://huggingface.co/tasks" rel="nofollow">Tasks</a> to list available models for each task and explain how each task works in detail.',gn,Vl,Ue="It also contains demos, example outputs, and other resources should you want to dig deeper into the ML side of things.",fn,Rl,dn,ql,Ie="<li><code>@huggingface/tasks</code> : Typings only</li>",Un,zl,In,Hl,$n;return u=new m({props:{title:"🤗 Hugging Face Inference Endpoints",local:"-hugging-face-inference-endpoints",headingTag:"h1"}}),f=new m({props:{title:"Getting Started",local:"getting-started",headingTag:"h2"}}),d=new m({props:{title:"Install",local:"install",headingTag:"h3"}}),U=new m({props:{title:"Node",local:"node",headingTag:"h4"}}),I=new y({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBJTBBcG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBJTBBeWFybiUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNl",highlighted:`npm install @huggingface/inference

pnpm add @huggingface/inference

yarn add @huggingface/inference`,wrap:!1}}),$=new m({props:{title:"Deno",local:"deno",headingTag:"h4"}}),b=new y({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIyaHR0cHMlM0ElMkYlMkZlc20uc2glMkYlNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSUyMiUwQSUyRiUyRiUyMG9yJTIwbnBtJTNBJTBBaW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIybnBtJTNBJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjI=",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/inference&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/inference&quot;</span>`,wrap:!1}}),C=new m({props:{title:"Initialize",local:"initialize",headingTag:"h3"}}),B=new y({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJyUwQSUwQWNvbnN0JTIwaGYlMjAlM0QlMjBuZXclMjBIZkluZmVyZW5jZSgneW91ciUyMGFjY2VzcyUyMHRva2VuJyk=",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/inference&#x27;</span>

<span class="hljs-keyword">const</span> hf = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInference</span>(<span class="hljs-string">&#x27;your access token&#x27;</span>)`,wrap:!1}}),k=new m({props:{title:"Tree-shaking",local:"tree-shaking",headingTag:"h4"}}),N=new y({props:{code:"aW1wb3J0JTIwJTdCJTIwdGV4dEdlbmVyYXRpb24lMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlM0IlMEElMEFhd2FpdCUyMHRleHRHZW5lcmF0aW9uKCU3QiUwQSUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwJTIyaGZfLi4uJTIyJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJtb2RlbF9vcl9lbmRwb2ludCUyMiUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMC4uLiUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAuLi4lMEElN0Qp",highlighted:`<span class="hljs-keyword">import</span> { textGeneration } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">await</span> <span class="hljs-title function_">textGeneration</span>({
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;model_or_endpoint&quot;</span>,
  <span class="hljs-attr">inputs</span>: ...,
  <span class="hljs-attr">parameters</span>: ...
})`,wrap:!1}}),E=new m({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),W=new m({props:{title:"Text Generation",local:"text-generation",headingTag:"h3"}}),X=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0R2VuZXJhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdncHQyJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdUaGUlMjBhbnN3ZXIlMjB0byUyMHRoZSUyMHVuaXZlcnNlJTIwaXMnJTBBJTdEKSUwQSUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwb3V0cHV0JTIwb2YlMjBoZi50ZXh0R2VuZXJhdGlvblN0cmVhbSglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMmdvb2dsZSUyRmZsYW4tdDUteHhsJTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ3JlcGVhdCUyMCUyMm9uZSUyMHR3byUyMHRocmVlJTIwZm91ciUyMiclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTIwbWF4X25ld190b2tlbnMlM0ElMjAyNTAlMjAlN0QlMEElN0QpKSUyMCU3QiUwQSUyMCUyMGNvbnNvbGUubG9nKG91dHB1dC50b2tlbi50ZXh0JTJDJTIwb3V0cHV0LmdlbmVyYXRlZF90ZXh0KSUzQiUwQSU3RA==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textGeneration</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;gpt2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>
})

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> output <span class="hljs-keyword">of</span> hf.<span class="hljs-title function_">textGenerationStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;google/flan-t5-xxl&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;repeat &quot;one two three four&quot;&#x27;</span>,
  <span class="hljs-attr">parameters</span>: { <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">250</span> }
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(output.<span class="hljs-property">token</span>.<span class="hljs-property">text</span>, output.<span class="hljs-property">generated_text</span>);
}`,wrap:!1}}),Y=new m({props:{title:"Text Generation (Chat Completion API Compatible)",local:"text-generation-chat-completion-api-compatible",headingTag:"h3"}}),R=new y({props:{code:"JTJGJTJGJTIwTm9uLXN0cmVhbWluZyUyMEFQSSUwQWNvbnN0JTIwb3V0JTIwJTNEJTIwYXdhaXQlMjBoZi5jaGF0Q29tcGxldGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjEtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjBtZXNzYWdlcyUzQSUyMCU1QiU3QiUyMHJvbGUlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwY29udGVudCUzQSUyMCUyMkhlbGxvJTJDJTIwbmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlMjAlN0QlNUQlMkMlMEElMjAlMjBtYXhfdG9rZW5zJTNBJTIwNTEyJTJDJTBBJTIwJTIwdGVtcGVyYXR1cmUlM0ElMjAwLjElMkMlMEElN0QpJTNCJTBBJTBBJTJGJTJGJTIwU3RyZWFtaW5nJTIwQVBJJTBBbGV0JTIwb3V0JTIwJTNEJTIwJTIyJTIyJTNCJTBBZm9yJTIwYXdhaXQlMjAoY29uc3QlMjBjaHVuayUyMG9mJTIwaGYuY2hhdENvbXBsZXRpb25TdHJlYW0oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4xLThCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwbWVzc2FnZXMlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjByb2xlJTNBJTIwJTIydXNlciUyMiUyQyUyMGNvbnRlbnQlM0ElMjAlMjJDYW4lMjB5b3UlMjBoZWxwJTIwbWUlMjBzb2x2ZSUyMGFuJTIwZXF1YXRpb24lM0YlMjIlMjAlN0QlMkMlMEElMjAlMjAlNUQlMkMlMEElMjAlMjBtYXhfdG9rZW5zJTNBJTIwNTEyJTJDJTBBJTIwJTIwdGVtcGVyYXR1cmUlM0ElMjAwLjElMkMlMEElN0QpKSUyMCU3QiUwQSUyMCUyMGlmJTIwKGNodW5rLmNob2ljZXMlMjAlMjYlMjYlMjBjaHVuay5jaG9pY2VzLmxlbmd0aCUyMCUzRSUyMDApJTIwJTdCJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTJCJTNEJTIwY2h1bmsuY2hvaWNlcyU1QjAlNUQuZGVsdGEuY29udGVudCUzQiUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-comment">// Non-streaming API</span>
<span class="hljs-keyword">const</span> out = <span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.1</span>,
});

<span class="hljs-comment">// Streaming API</span>
<span class="hljs-keyword">let</span> out = <span class="hljs-string">&quot;&quot;</span>;
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> hf.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [
    { <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Can you help me solve an equation?&quot;</span> },
  ],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.1</span>,
})) {
  <span class="hljs-keyword">if</span> (chunk.<span class="hljs-property">choices</span> &amp;&amp; chunk.<span class="hljs-property">choices</span>.<span class="hljs-property">length</span> &gt; <span class="hljs-number">0</span>) {
    out += chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>;
  }
}`,wrap:!1}}),z=new y({props:{code:"Y29uc3QlMjBvcGVuYWklMjAlM0QlMjBuZXclMjBIZkluZmVyZW5jZShPUEVOQUlfVE9LRU4pLmVuZHBvaW50KCUyMmh0dHBzJTNBJTJGJTJGYXBpLm9wZW5haS5jb20lMjIpJTNCJTBBJTBBbGV0JTIwb3V0JTIwJTNEJTIwJTIyJTIyJTNCJTBBZm9yJTIwYXdhaXQlMjAoY29uc3QlMjBjaHVuayUyMG9mJTIwb3BlbmFpLmNoYXRDb21wbGV0aW9uU3RyZWFtKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJTIyZ3B0LTMuNS10dXJibyUyMiUyQyUwQSUyMCUyMG1lc3NhZ2VzJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIwcm9sZSUzQSUyMCUyMnVzZXIlMjIlMkMlMjBjb250ZW50JTNBJTIwJTIyQ29tcGxldGUlMjB0aGUlMjBlcXVhdGlvbiUyMDElMkIxJTNEJTIwJTJDanVzdCUyMHRoZSUyMGFuc3dlciUyMiUyMCU3RCUyQyUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMG1heF90b2tlbnMlM0ElMjA1MDAlMkMlMEElMjAlMjB0ZW1wZXJhdHVyZSUzQSUyMDAuMSUyQyUwQSUyMCUyMHNlZWQlM0ElMjAwJTJDJTBBJTdEKSklMjAlN0IlMEElMjAlMjBpZiUyMChjaHVuay5jaG9pY2VzJTIwJTI2JTI2JTIwY2h1bmsuY2hvaWNlcy5sZW5ndGglMjAlM0UlMjAwKSUyMCU3QiUwQSUyMCUyMCUyMCUyMG91dCUyMCUyQiUzRCUyMGNodW5rLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQlM0IlMEElMjAlMjAlN0QlMEElN0QlMEElMEElMkYlMkYlMjBGb3IlMjBtaXN0cmFsJTIwQUklM0ElMEElMkYlMkYlMjBlbmRwb2ludFVybCUzQSUyMCUyMmh0dHBzJTNBJTJGJTJGYXBpLm1pc3RyYWwuYWklMjIlMEElMkYlMkYlMjBtb2RlbCUzQSUyMCUyMm1pc3RyYWwtdGlueSUyMg==",highlighted:`<span class="hljs-keyword">const</span> openai = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInference</span>(<span class="hljs-variable constant_">OPENAI_TOKEN</span>).<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&quot;https://api.openai.com&quot;</span>);

<span class="hljs-keyword">let</span> out = <span class="hljs-string">&quot;&quot;</span>;
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> openai.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;gpt-3.5-turbo&quot;</span>,
  <span class="hljs-attr">messages</span>: [
    { <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Complete the equation 1+1= ,just the answer&quot;</span> },
  ],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">500</span>,
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.1</span>,
  <span class="hljs-attr">seed</span>: <span class="hljs-number">0</span>,
})) {
  <span class="hljs-keyword">if</span> (chunk.<span class="hljs-property">choices</span> &amp;&amp; chunk.<span class="hljs-property">choices</span>.<span class="hljs-property">length</span> &gt; <span class="hljs-number">0</span>) {
    out += chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>;
  }
}

<span class="hljs-comment">// For mistral AI:</span>
<span class="hljs-comment">// endpointUrl: &quot;https://api.mistral.ai&quot;</span>
<span class="hljs-comment">// model: &quot;mistral-tiny&quot;</span>`,wrap:!1}}),F=new m({props:{title:"Fill Mask",local:"fill-mask",headingTag:"h3"}}),_=new y({props:{code:"YXdhaXQlMjBoZi5maWxsTWFzayglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdiZXJ0LWJhc2UtdW5jYXNlZCclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnJTVCTUFTSyU1RCUyMHdvcmxkISclMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">fillMask</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;bert-base-uncased&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;[MASK] world!&#x27;</span>
})`,wrap:!1}}),L=new m({props:{title:"Summarization",local:"summarization",headingTag:"h3"}}),P=new y({props:{code:"YXdhaXQlMjBoZi5zdW1tYXJpemF0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGYmFydC1sYXJnZS1jbm4nJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTBBJTIwJTIwJTIwJTIwJ1RoZSUyMHRvd2VyJTIwaXMlMjAzMjQlMjBtZXRyZXMlMjAoMSUyQzA2MyUyMGZ0KSUyMHRhbGwlMkMlMjBhYm91dCUyMHRoZSUyMHNhbWUlMjBoZWlnaHQlMjBhcyUyMGFuJTIwODEtc3RvcmV5JTIwYnVpbGRpbmclMkMlMjBhbmQlMjB0aGUlMjB0YWxsZXN0JTIwc3RydWN0dXJlJTIwaW4lMjBQYXJpcy4lMjBJdHMlMjBiYXNlJTIwaXMlMjBzcXVhcmUlMkMlMjBtZWFzdXJpbmclMjAxMjUlMjBtZXRyZXMlMjAoNDEwJTIwZnQpJTIwb24lMjBlYWNoJTIwc2lkZS4lMjBEdXJpbmclMjBpdHMlMjBjb25zdHJ1Y3Rpb24lMkMlMjB0aGUlMjBFaWZmZWwlMjBUb3dlciUyMHN1cnBhc3NlZCUyMHRoZSUyMFdhc2hpbmd0b24lMjBNb251bWVudCUyMHRvJTIwYmVjb21lJTIwdGhlJTIwdGFsbGVzdCUyMG1hbi1tYWRlJTIwc3RydWN0dXJlJTIwaW4lMjB0aGUlMjB3b3JsZCUyQyUyMGElMjB0aXRsZSUyMGl0JTIwaGVsZCUyMGZvciUyMDQxJTIweWVhcnMlMjB1bnRpbCUyMHRoZSUyMENocnlzbGVyJTIwQnVpbGRpbmclMjBpbiUyME5ldyUyMFlvcmslMjBDaXR5JTIwd2FzJTIwZmluaXNoZWQlMjBpbiUyMDE5MzAuJyUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBtYXhfbGVuZ3RoJTNBJTIwMTAwJTBBJTIwJTIwJTdEJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">summarization</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/bart-large-cnn&#x27;</span>,
  <span class="hljs-attr">inputs</span>:
    <span class="hljs-string">&#x27;The tower is 324 metres (1,063 ft) tall, about the same height as an 81-storey building, and the tallest structure in Paris. Its base is square, measuring 125 metres (410 ft) on each side. During its construction, the Eiffel Tower surpassed the Washington Monument to become the tallest man-made structure in the world, a title it held for 41 years until the Chrysler Building in New York City was finished in 1930.&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">max_length</span>: <span class="hljs-number">100</span>
  }
})`,wrap:!1}}),K=new m({props:{title:"Question Answering",local:"question-answering",headingTag:"h3"}}),ss=new y({props:{code:"YXdhaXQlMjBoZi5xdWVzdGlvbkFuc3dlcmluZyglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdkZWVwc2V0JTJGcm9iZXJ0YS1iYXNlLXNxdWFkMiclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzQSUyMCdXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YnJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dCUzQSUyMCdUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiclMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">questionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;deepset/roberta-base-squad2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;What is the capital of France?&#x27;</span>,
    <span class="hljs-attr">context</span>: <span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>
  }
})`,wrap:!1}}),ls=new m({props:{title:"Table Question Answering",local:"table-question-answering",headingTag:"h3"}}),ts=new y({props:{code:"YXdhaXQlMjBoZi50YWJsZVF1ZXN0aW9uQW5zd2VyaW5nKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2dvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBxdWVyeSUzQSUyMCdIb3clMjBtYW55JTIwc3RhcnMlMjBkb2VzJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwcmVwb3NpdG9yeSUyMGhhdmUlM0YnJTJDJTBBJTIwJTIwJTIwJTIwdGFibGUlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjBSZXBvc2l0b3J5JTNBJTIwJTVCJ1RyYW5zZm9ybWVycyclMkMlMjAnRGF0YXNldHMnJTJDJTIwJ1Rva2VuaXplcnMnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwU3RhcnMlM0ElMjAlNUInMzY1NDInJTJDJTIwJzQ1MTInJTJDJTIwJzM5MzQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwQ29udHJpYnV0b3JzJTNBJTIwJTVCJzY1MSclMkMlMjAnNzcnJTJDJTIwJzM0JyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdQcm9ncmFtbWluZyUyMGxhbmd1YWdlJyUzQSUyMCU1QidQeXRob24nJTJDJTIwJ1B5dGhvbiclMkMlMjAnUnVzdCUyQyUyMFB5dGhvbiUyMGFuZCUyME5vZGVKUyclNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tableQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;google/tapas-base-finetuned-wtq&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">query</span>: <span class="hljs-string">&#x27;How many stars does the transformers repository have?&#x27;</span>,
    <span class="hljs-attr">table</span>: {
      <span class="hljs-title class_">Repository</span>: [<span class="hljs-string">&#x27;Transformers&#x27;</span>, <span class="hljs-string">&#x27;Datasets&#x27;</span>, <span class="hljs-string">&#x27;Tokenizers&#x27;</span>],
      <span class="hljs-title class_">Stars</span>: [<span class="hljs-string">&#x27;36542&#x27;</span>, <span class="hljs-string">&#x27;4512&#x27;</span>, <span class="hljs-string">&#x27;3934&#x27;</span>],
      <span class="hljs-title class_">Contributors</span>: [<span class="hljs-string">&#x27;651&#x27;</span>, <span class="hljs-string">&#x27;77&#x27;</span>, <span class="hljs-string">&#x27;34&#x27;</span>],
      <span class="hljs-string">&#x27;Programming language&#x27;</span>: [<span class="hljs-string">&#x27;Python&#x27;</span>, <span class="hljs-string">&#x27;Python&#x27;</span>, <span class="hljs-string">&#x27;Rust, Python and NodeJS&#x27;</span>]
    }
  }
})`,wrap:!1}}),as=new m({props:{title:"Text Classification",local:"text-classification",headingTag:"h3"}}),es=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0Q2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2gnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ0klMjBsaWtlJTIweW91LiUyMEklMjBsb3ZlJTIweW91LiclMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;I like you. I love you.&#x27;</span>
})`,wrap:!1}}),ps=new m({props:{title:"Token Classification",local:"token-classification",headingTag:"h3"}}),Ms=new y({props:{code:"YXdhaXQlMjBoZi50b2tlbkNsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2RibWR6JTJGYmVydC1sYXJnZS1jYXNlZC1maW5ldHVuZWQtY29ubGwwMy1lbmdsaXNoJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdNeSUyMG5hbWUlMjBpcyUyMFNhcmFoJTIwSmVzc2ljYSUyMFBhcmtlciUyMGJ1dCUyMHlvdSUyMGNhbiUyMGNhbGwlMjBtZSUyMEplc3NpY2EnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tokenClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;dbmdz/bert-large-cased-finetuned-conll03-english&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Sarah Jessica Parker but you can call me Jessica&#x27;</span>
})`,wrap:!1}}),os=new m({props:{title:"Translation",local:"translation",headingTag:"h3"}}),rs=new y({props:{code:"YXdhaXQlMjBoZi50cmFuc2xhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCd0NS1iYXNlJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdNeSUyMG5hbWUlMjBpcyUyMFdvbGZnYW5nJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmxpbiclMEElN0QpJTBBJTBBYXdhaXQlMjBoZi50cmFuc2xhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRm1iYXJ0LWxhcmdlLTUwLW1hbnktdG8tbWFueS1tbXQnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwdGV4dFRvVHJhbnNsYXRlJTJDJTBBJTIwJTIwcGFyYW1ldGVycyUzQSUyMCU3QiUwQSUyMCUyMCUyMnNyY19sYW5nJTIyJTNBJTIwJTIyZW5fWFglMjIlMkMlMEElMjAlMjAlMjJ0Z3RfbGFuZyUyMiUzQSUyMCUyMmZyX1hYJTIyJTBBJTIwJTdEJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;t5-base&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Wolfgang and I live in Berlin&#x27;</span>
})

<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/mbart-large-50-many-to-many-mmt&#x27;</span>,
  <span class="hljs-attr">inputs</span>: textToTranslate,
  <span class="hljs-attr">parameters</span>: {
  <span class="hljs-string">&quot;src_lang&quot;</span>: <span class="hljs-string">&quot;en_XX&quot;</span>,
  <span class="hljs-string">&quot;tgt_lang&quot;</span>: <span class="hljs-string">&quot;fr_XX&quot;</span>
 }
})`,wrap:!1}}),js=new m({props:{title:"Zero-Shot Classification",local:"zero-shot-classification",headingTag:"h3"}}),Js=new y({props:{code:"YXdhaXQlMjBoZi56ZXJvU2hvdENsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGYmFydC1sYXJnZS1tbmxpJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCdIaSUyQyUyMEklMjByZWNlbnRseSUyMGJvdWdodCUyMGElMjBkZXZpY2UlMjBmcm9tJTIweW91ciUyMGNvbXBhbnklMjBidXQlMjBpdCUyMGlzJTIwbm90JTIwd29ya2luZyUyMGFzJTIwYWR2ZXJ0aXNlZCUyMGFuZCUyMEklMjB3b3VsZCUyMGxpa2UlMjB0byUyMGdldCUyMHJlaW1idXJzZWQhJyUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMjBjYW5kaWRhdGVfbGFiZWxzJTNBJTIwJTVCJ3JlZnVuZCclMkMlMjAnbGVnYWwnJTJDJTIwJ2ZhcSclNUQlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">zeroShotClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>,
  <span class="hljs-attr">inputs</span>: [
    <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>
  ],
  <span class="hljs-attr">parameters</span>: { <span class="hljs-attr">candidate_labels</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>] }
})`,wrap:!1}}),ms=new m({props:{title:"Conversational",local:"conversational",headingTag:"h3"}}),Ts=new y({props:{code:"YXdhaXQlMjBoZi5jb252ZXJzYXRpb25hbCglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdtaWNyb3NvZnQlMkZEaWFsb0dQVC1sYXJnZSclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBwYXN0X3VzZXJfaW5wdXRzJTNBJTIwJTVCJ1doaWNoJTIwbW92aWUlMjBpcyUyMHRoZSUyMGJlc3QlMjAlM0YnJTVEJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3Jlc3BvbnNlcyUzQSUyMCU1QidJdCUyMGlzJTIwRGllJTIwSGFyZCUyMGZvciUyMHN1cmUuJyU1RCUyQyUwQSUyMCUyMCUyMCUyMHRleHQlM0ElMjAnQ2FuJTIweW91JTIwZXhwbGFpbiUyMHdoeSUyMCUzRiclMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">conversational</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;microsoft/DialoGPT-large&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">past_user_inputs</span>: [<span class="hljs-string">&#x27;Which movie is the best ?&#x27;</span>],
    <span class="hljs-attr">generated_responses</span>: [<span class="hljs-string">&#x27;It is Die Hard for sure.&#x27;</span>],
    <span class="hljs-attr">text</span>: <span class="hljs-string">&#x27;Can you explain why ?&#x27;</span>
  }
})`,wrap:!1}}),us=new m({props:{title:"Sentence Similarity",local:"sentence-similarity",headingTag:"h3"}}),gs=new y({props:{code:"YXdhaXQlMjBoZi5zZW50ZW5jZVNpbWlsYXJpdHkoJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnc2VudGVuY2UtdHJhbnNmb3JtZXJzJTJGcGFyYXBocmFzZS14bG0tci1tdWx0aWxpbmd1YWwtdjEnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwc291cmNlX3NlbnRlbmNlJTNBJTIwJ1RoYXQlMjBpcyUyMGElMjBoYXBweSUyMHBlcnNvbiclMkMlMEElMjAlMjAlMjAlMjBzZW50ZW5jZXMlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAnVGhhdCUyMGlzJTIwYSUyMGhhcHB5JTIwZG9nJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdUaGF0JTIwaXMlMjBhJTIwdmVyeSUyMGhhcHB5JTIwcGVyc29uJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdUb2RheSUyMGlzJTIwYSUyMHN1bm55JTIwZGF5JyUwQSUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCU3RCUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">sentenceSimilarity</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;sentence-transformers/paraphrase-xlm-r-multilingual-v1&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">source_sentence</span>: <span class="hljs-string">&#x27;That is a happy person&#x27;</span>,
    <span class="hljs-attr">sentences</span>: [
      <span class="hljs-string">&#x27;That is a happy dog&#x27;</span>,
      <span class="hljs-string">&#x27;That is a very happy person&#x27;</span>,
      <span class="hljs-string">&#x27;Today is a sunny day&#x27;</span>
    ]
  }
})`,wrap:!1}}),fs=new m({props:{title:"Audio",local:"audio",headingTag:"h2"}}),ds=new m({props:{title:"Automatic Speech Recognition",local:"automatic-speech-recognition",headingTag:"h3"}}),$s=new y({props:{code:"YXdhaXQlMjBoZi5hdXRvbWF0aWNTcGVlY2hSZWNvZ25pdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmJyUyQyUwQSUyMCUyMGRhdGElM0ElMjByZWFkRmlsZVN5bmMoJ3Rlc3QlMkZzYW1wbGUxLmZsYWMnKSUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">automaticSpeechRecognition</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/wav2vec2-large-960h-lv60-self&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),bs=new m({props:{title:"Audio Classification",local:"audio-classification",headingTag:"h3"}}),xs=new y({props:{code:"YXdhaXQlMjBoZi5hdWRpb0NsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ3N1cGVyYiUyRmh1YmVydC1sYXJnZS1zdXBlcmItZXInJTJDJTBBJTIwJTIwZGF0YSUzQSUyMHJlYWRGaWxlU3luYygndGVzdCUyRnNhbXBsZTEuZmxhYycpJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">audioClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;superb/hubert-large-superb-er&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),Zs=new m({props:{title:"Text To Speech",local:"text-to-speech",headingTag:"h3"}}),Ns=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0VG9TcGVlY2goJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnZXNwbmV0JTJGa2FuLWJheWFzaGlfbGpzcGVlY2hfdml0cyclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnSGVsbG8lMjB3b3JsZCEnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textToSpeech</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;espnet/kan-bayashi_ljspeech_vits&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;Hello world!&#x27;</span>
})`,wrap:!1}}),Gs=new m({props:{title:"Audio To Audio",local:"audio-to-audio",headingTag:"h3"}}),Ws=new y({props:{code:"YXdhaXQlMjBoZi5hdWRpb1RvQXVkaW8oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnc3BlZWNoYnJhaW4lMkZzZXBmb3JtZXItd2hhbSclMkMlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGc2FtcGxlMS5mbGFjJyklMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">audioToAudio</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;speechbrain/sepformer-wham&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),vs=new m({props:{title:"Computer Vision",local:"computer-vision",headingTag:"h2"}}),As=new m({props:{title:"Image Classification",local:"image-classification",headingTag:"h3"}}),Ss=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZUNsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMGRhdGElM0ElMjByZWFkRmlsZVN5bmMoJ3Rlc3QlMkZjaGVldGFoLnBuZycpJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAnZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageClassification</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cheetah.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;google/vit-base-patch16-224&#x27;</span>
})`,wrap:!1}}),Vs=new m({props:{title:"Object Detection",local:"object-detection",headingTag:"h3"}}),zs=new y({props:{code:"YXdhaXQlMjBoZi5vYmplY3REZXRlY3Rpb24oJTdCJTBBJTIwJTIwZGF0YSUzQSUyMHJlYWRGaWxlU3luYygndGVzdCUyRmNhdHMucG5nJyklMkMlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRmRldHItcmVzbmV0LTUwJyUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">objectDetection</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/detr-resnet-50&#x27;</span>
})`,wrap:!1}}),Fs=new m({props:{title:"Image Segmentation",local:"image-segmentation",headingTag:"h3"}}),_s=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZVNlZ21lbnRhdGlvbiglN0IlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGY2F0cy5wbmcnKSUyQyUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGZGV0ci1yZXNuZXQtNTAtcGFub3B0aWMnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageSegmentation</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/detr-resnet-50-panoptic&#x27;</span>
})`,wrap:!1}}),Ls=new m({props:{title:"Image To Text",local:"image-to-text",headingTag:"h3"}}),Ps=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZVRvVGV4dCglN0IlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGY2F0cy5wbmcnKSUyQyUwQSUyMCUyMG1vZGVsJTNBJTIwJ25scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJyUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageToText</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;nlpconnect/vit-gpt2-image-captioning&#x27;</span>
})`,wrap:!1}}),Ks=new m({props:{title:"Text To Image",local:"text-to-image",headingTag:"h3"}}),ll=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0VG9JbWFnZSglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ2ElMjBwaWN0dXJlJTIwb2YlMjBhJTIwZ3JlZW4lMjBiaXJkJyUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;black-forest-labs/FLUX.1-dev&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;a picture of a green bird&#x27;</span>
})`,wrap:!1}}),tl=new m({props:{title:"Image To Image",local:"image-to-image",headingTag:"h3"}}),el=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZVRvSW1hZ2UoJTdCJTBBJTIwJTIwaW5wdXRzJTNBJTIwbmV3JTIwQmxvYiglNUJyZWFkRmlsZVN5bmMoJTIydGVzdCUyRnN0b3JtdHJvb3Blcl9kZXB0aC5wbmclMjIpJTVEKSUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBwcm9tcHQlM0ElMjAlMjJlbG1vJ3MlMjBsZWN0dXJlJTIyJTJDJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1kZXB0aCUyMiUyQyUwQSU3RCklM0I=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageToImage</span>({
  <span class="hljs-attr">inputs</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&quot;test/stormtrooper_depth.png&quot;</span>)]),
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">prompt</span>: <span class="hljs-string">&quot;elmo&#x27;s lecture&quot;</span>,
  },
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;lllyasviel/sd-controlnet-depth&quot;</span>,
});`,wrap:!1}}),pl=new m({props:{title:"Zero Shot Image Classification",local:"zero-shot-image-classification",headingTag:"h3"}}),Ml=new y({props:{code:"YXdhaXQlMjBoZi56ZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnb3BlbmFpJTJGY2xpcC12aXQtbGFyZ2UtcGF0Y2gxNC0zMzYnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRnBsYWNla2l0dGVuLmNvbSUyRjMwMCUyRjMwMCcpKS5ibG9iKCklMEElMjAlMjAlN0QlMkMlMjAlMjAlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwY2FuZGlkYXRlX2xhYmVscyUzQSUyMCU1QidjYXQnJTJDJTIwJ2RvZyclNUQlMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">zeroShotImageClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;openai/clip-vit-large-patch14-336&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://placekitten.com/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>()
  },  
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">candidate_labels</span>: [<span class="hljs-string">&#x27;cat&#x27;</span>, <span class="hljs-string">&#x27;dog&#x27;</span>]
  }
})`,wrap:!1}}),ol=new m({props:{title:"Multimodal",local:"multimodal",headingTag:"h2"}}),cl=new m({props:{title:"Feature Extraction",local:"feature-extraction",headingTag:"h3"}}),jl=new y({props:{code:"YXdhaXQlMjBoZi5mZWF0dXJlRXh0cmFjdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMnNlbnRlbmNlLXRyYW5zZm9ybWVycyUyRmRpc3RpbGJlcnQtYmFzZS1ubGktbWVhbi10b2tlbnMlMjIlMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlMjJUaGF0JTIwaXMlMjBhJTIwaGFwcHklMjBwZXJzb24lMjIlMkMlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">featureExtraction</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;sentence-transformers/distilbert-base-nli-mean-tokens&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;That is a happy person&quot;</span>,
});`,wrap:!1}}),hl=new m({props:{title:"Visual Question Answering",local:"visual-question-answering",headingTag:"h3"}}),yl=new y({props:{code:"YXdhaXQlMjBoZi52aXN1YWxRdWVzdGlvbkFuc3dlcmluZyglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdkYW5kZWxpbiUyRnZpbHQtYjMyLWZpbmV0dW5lZC12cWEnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0ElMjAnSG93JTIwbWFueSUyMGNhdHMlMjBhcmUlMjBseWluZyUyMGRvd24lM0YnJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRnBsYWNla2l0dGVuLmNvbSUyRjMwMCUyRjMwMCcpKS5ibG9iKCklMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">visualQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;dandelin/vilt-b32-finetuned-vqa&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;How many cats are lying down?&#x27;</span>,
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://placekitten.com/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>()
  }
})`,wrap:!1}}),Tl=new m({props:{title:"Document Question Answering",local:"document-question-answering",headingTag:"h3"}}),gl=new y({props:{code:"YXdhaXQlMjBoZi5kb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ltcGlyYSUyRmxheW91dGxtLWRvY3VtZW50LXFhJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMHF1ZXN0aW9uJTNBJTIwJ0ludm9pY2UlMjBudW1iZXIlM0YnJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGaW1waXJhJTJGZG9jcXVlcnklMkZyZXNvbHZlJTJGMjM1OTIyM2MxODM3YTc1ODc0MDJiZGEwZjI2NDMzODJhNmVlZmVhYiUyRmludm9pY2UucG5nJykpLmJsb2IoKSUyQyUwQSUyMCUyMCU3RCUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">documentQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;impira/layoutlm-document-qa&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;Invoice number?&#x27;</span>,
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&#x27;</span>)).<span class="hljs-title function_">blob</span>(),
  }
})`,wrap:!1}}),fl=new m({props:{title:"Tabular",local:"tabular",headingTag:"h2"}}),dl=new m({props:{title:"Tabular Regression",local:"tabular-regression",headingTag:"h3"}}),Il=new y({props:{code:"YXdhaXQlMjBoZi50YWJ1bGFyUmVncmVzc2lvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwZGF0YSUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlaWdodCUyMiUzQSUyMCU1QiUyMjExLjUyJTIyJTJDJTIwJTIyMTIuNDglMjIlMkMlMjAlMjIxMi4zNzc4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMSUyMiUzQSUyMCU1QiUyMjIzLjIlMjIlMkMlMjAlMjIyNCUyMiUyQyUyMCUyMjIzLjklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJMZW5ndGgyJTIyJTNBJTIwJTVCJTIyMjUuNCUyMiUyQyUyMCUyMjI2LjMlMjIlMkMlMjAlMjIyNi41JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMyUyMiUzQSUyMCU1QiUyMjMwJTIyJTJDJTIwJTIyMzEuMiUyMiUyQyUyMCUyMjMxLjElMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJTcGVjaWVzJTIyJTNBJTIwJTVCJTIyQnJlYW0lMjIlMkMlMjAlMjJCcmVhbSUyMiUyQyUyMCUyMkJyZWFtJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2lkdGglMjIlM0ElMjAlNUIlMjI0LjAyJTIyJTJDJTIwJTIyNC4zMDU2JTIyJTJDJTIwJTIyNC42OTYxJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTdEJTJDJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tabularRegression</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">data</span>: {
      <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
      <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
      <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
      <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
      <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
      <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>]
    },
  },
})`,wrap:!1}}),$l=new m({props:{title:"Tabular Classification",local:"tabular-classification",headingTag:"h3"}}),Cl=new y({props:{code:"YXdhaXQlMjBoZi50YWJ1bGFyQ2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJ2dm1ubm5rdiUyRndpbmUtcXVhbGl0eSUyMiUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMGRhdGElM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmaXhlZF9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyNy40JTIyJTJDJTIwJTIyNy44JTIyJTJDJTIwJTIyMTAuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnZvbGF0aWxlX2FjaWRpdHklMjIlM0ElMjAlNUIlMjIwLjclMjIlMkMlMjAlMjIwLjg4JTIyJTJDJTIwJTIyMC4zMiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmNpdHJpY19hY2lkJTIyJTNBJTIwJTVCJTIyMCUyMiUyQyUyMCUyMjAlMjIlMkMlMjAlMjIwLjQ1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycmVzaWR1YWxfc3VnYXIlMjIlM0ElMjAlNUIlMjIxLjklMjIlMkMlMjAlMjIyLjYlMjIlMkMlMjAlMjI2LjQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJjaGxvcmlkZXMlMjIlM0ElMjAlNUIlMjIwLjA3NiUyMiUyQyUyMCUyMjAuMDk4JTIyJTJDJTIwJTIyMC4wNzMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmcmVlX3N1bGZ1cl9kaW94aWRlJTIyJTNBJTIwJTVCJTIyMTElMjIlMkMlMjAlMjIyNSUyMiUyQyUyMCUyMjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b3RhbF9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjM0JTIyJTJDJTIwJTIyNjclMjIlMkMlMjAlMjIxMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlbnNpdHklMjIlM0ElMjAlNUIlMjIwLjk5NzglMjIlMkMlMjAlMjIwLjk5NjglMjIlMkMlMjAlMjIwLjk5NzYlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJwSCUyMiUzQSUyMCU1QiUyMjMuNTElMjIlMkMlMjAlMjIzLjIlMjIlMkMlMjAlMjIzLjIzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3VscGhhdGVzJTIyJTNBJTIwJTVCJTIyMC41NiUyMiUyQyUyMCUyMjAuNjglMjIlMkMlMjAlMjIwLjgyJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWxjb2hvbCUyMiUzQSUyMCU1QiUyMjkuNCUyMiUyQyUyMCUyMjkuOCUyMiUyQyUyMCUyMjEyLjYlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlN0QlMkMlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tabularClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;vvmnnnkv/wine-quality&quot;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">data</span>: {
      <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
      <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
      <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
      <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
      <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
      <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
      <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
      <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
      <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
      <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
      <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>]
    },
  },
})`,wrap:!1}}),Bl=new m({props:{title:"Custom Calls",local:"custom-calls",headingTag:"h2"}}),Zl=new y({props:{code:"YXdhaXQlMjBoZi5yZXF1ZXN0KCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ215LWN1c3RvbS1tb2RlbCclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnaGVsbG8lMjB3b3JsZCclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BhcmFtJTNBJTIwJ3NvbWUlMjBtYWdpYyclMkMlMEElMjAlMjAlN0QlMEElN0QpJTBBJTBBJTJGJTJGJTIwQ3VzdG9tJTIwc3RyZWFtaW5nJTIwY2FsbCUyQyUyMGZvciUyMG1vZGVscyUyMHdpdGglMjBjdXN0b20lMjBwYXJhbWV0ZXJzJTIwJTJGJTIwb3V0cHV0cyUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwb3V0cHV0JTIwb2YlMjBoZi5zdHJlYW1pbmdSZXF1ZXN0KCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ215LWN1c3RvbS1tb2RlbCclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnaGVsbG8lMjB3b3JsZCclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BhcmFtJTNBJTIwJ3NvbWUlMjBtYWdpYyclMkMlMEElMjAlMjAlN0QlMEElN0QpKSUyMCU3QiUwQSUyMCUyMC4uLiUwQSU3RA==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">request</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;my-custom-model&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;hello world&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">custom_param</span>: <span class="hljs-string">&#x27;some magic&#x27;</span>,
  }
})

<span class="hljs-comment">// Custom streaming call, for models with custom parameters / outputs</span>
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> output <span class="hljs-keyword">of</span> hf.<span class="hljs-title function_">streamingRequest</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;my-custom-model&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;hello world&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">custom_param</span>: <span class="hljs-string">&#x27;some magic&#x27;</span>,
  }
})) {
  ...
}`,wrap:!1}}),Ql=new y({props:{code:"JTJGJTJGJTIwQ2hhdCUyMENvbXBsZXRpb24lMjBFeGFtcGxlJTBBY29uc3QlMjBNSVNUUkFMX0tFWSUyMCUzRCUyMHByb2Nlc3MuZW52Lk1JU1RSQUxfS0VZJTNCJTBBY29uc3QlMjBoZiUyMCUzRCUyMG5ldyUyMEhmSW5mZXJlbmNlKE1JU1RSQUxfS0VZKSUzQiUwQWNvbnN0JTIwZXAlMjAlM0QlMjBoZi5lbmRwb2ludCglMjJodHRwcyUzQSUyRiUyRmFwaS5taXN0cmFsLmFpJTIyKSUzQiUwQWNvbnN0JTIwc3RyZWFtJTIwJTNEJTIwZXAuY2hhdENvbXBsZXRpb25TdHJlYW0oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJtaXN0cmFsLXRpbnklMjIlMkMlMEElMjAlMjBtZXNzYWdlcyUzQSUyMCU1QiU3QiUyMHJvbGUlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwY29udGVudCUzQSUyMCUyMkNvbXBsZXRlJTIwdGhlJTIwZXF1YXRpb24lMjBvbmUlMjAlMkIlMjBvbmUlMjAlM0QlMjAlMkMlMjBqdXN0JTIwdGhlJTIwYW5zd2VyJTIyJTIwJTdEJTVEJTJDJTBBJTdEKSUzQiUwQWxldCUyMG91dCUyMCUzRCUyMCUyMiUyMiUzQiUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwY2h1bmslMjBvZiUyMHN0cmVhbSklMjAlN0IlMEElMjAlMjBpZiUyMChjaHVuay5jaG9pY2VzJTIwJTI2JTI2JTIwY2h1bmsuY2hvaWNlcy5sZW5ndGglMjAlM0UlMjAwKSUyMCU3QiUwQSUyMCUyMCUyMCUyMG91dCUyMCUyQiUzRCUyMGNodW5rLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQlM0IlMEElMjAlMjAlMjAlMjBjb25zb2xlLmxvZyhvdXQpJTNCJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-comment">// Chat Completion Example</span>
<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">MISTRAL_KEY</span> = process.<span class="hljs-property">env</span>.<span class="hljs-property">MISTRAL_KEY</span>;
<span class="hljs-keyword">const</span> hf = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInference</span>(<span class="hljs-variable constant_">MISTRAL_KEY</span>);
<span class="hljs-keyword">const</span> ep = hf.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&quot;https://api.mistral.ai&quot;</span>);
<span class="hljs-keyword">const</span> stream = ep.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;mistral-tiny&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Complete the equation one + one = , just the answer&quot;</span> }],
});
<span class="hljs-keyword">let</span> out = <span class="hljs-string">&quot;&quot;</span>;
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> stream) {
  <span class="hljs-keyword">if</span> (chunk.<span class="hljs-property">choices</span> &amp;&amp; chunk.<span class="hljs-property">choices</span>.<span class="hljs-property">length</span> &gt; <span class="hljs-number">0</span>) {
    out += chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>;
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(out);
  }
}`,wrap:!1}}),Nl=new m({props:{title:"Custom Inference Endpoints",local:"custom-inference-endpoints",headingTag:"h2"}}),El=new y({props:{code:"Y29uc3QlMjBncHQyJTIwJTNEJTIwaGYuZW5kcG9pbnQoJ2h0dHBzJTNBJTJGJTJGeHl6LmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZ3B0MicpJTNCJTBBY29uc3QlMjAlN0IlMjBnZW5lcmF0ZWRfdGV4dCUyMCU3RCUyMCUzRCUyMGF3YWl0JTIwZ3B0Mi50ZXh0R2VuZXJhdGlvbiglN0JpbnB1dHMlM0ElMjAnVGhlJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjB1bml2ZXJzZSUyMGlzJyU3RCklM0IlMEElMEElMkYlMkYlMjBDaGF0JTIwQ29tcGxldGlvbiUyMEV4YW1wbGUlMEFjb25zdCUyMGVwJTIwJTNEJTIwaGYuZW5kcG9pbnQoJTBBJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGbWV0YS1sbGFtYSUyRkxsYW1hLTMuMS04Qi1JbnN0cnVjdCUyMiUwQSklM0IlMEFjb25zdCUyMHN0cmVhbSUyMCUzRCUyMGVwLmNoYXRDb21wbGV0aW9uU3RyZWFtKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJTIydGdpJTIyJTJDJTBBJTIwJTIwbWVzc2FnZXMlM0ElMjAlNUIlN0IlMjByb2xlJTNBJTIwJTIydXNlciUyMiUyQyUyMGNvbnRlbnQlM0ElMjAlMjJDb21wbGV0ZSUyMHRoZSUyMGVxdWF0aW9uJTIwMSUyQjElM0QlMjAlMkNqdXN0JTIwdGhlJTIwYW5zd2VyJTIyJTIwJTdEJTVEJTJDJTBBJTIwJTIwbWF4X3Rva2VucyUzQSUyMDUwMCUyQyUwQSUyMCUyMHRlbXBlcmF0dXJlJTNBJTIwMC4xJTJDJTBBJTIwJTIwc2VlZCUzQSUyMDAlMkMlMEElN0QpJTNCJTBBbGV0JTIwb3V0JTIwJTNEJTIwJTIyJTIyJTNCJTBBZm9yJTIwYXdhaXQlMjAoY29uc3QlMjBjaHVuayUyMG9mJTIwc3RyZWFtKSUyMCU3QiUwQSUyMCUyMGlmJTIwKGNodW5rLmNob2ljZXMlMjAlMjYlMjYlMjBjaHVuay5jaG9pY2VzLmxlbmd0aCUyMCUzRSUyMDApJTIwJTdCJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTJCJTNEJTIwY2h1bmsuY2hvaWNlcyU1QjAlNUQuZGVsdGEuY29udGVudCUzQiUwQSUyMCUyMCUyMCUyMGNvbnNvbGUubG9nKG91dCklM0IlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-keyword">const</span> gpt2 = hf.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&#x27;https://xyz.eu-west-1.aws.endpoints.huggingface.cloud/gpt2&#x27;</span>);
<span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> gpt2.<span class="hljs-title function_">textGeneration</span>({<span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>});

<span class="hljs-comment">// Chat Completion Example</span>
<span class="hljs-keyword">const</span> ep = hf.<span class="hljs-title function_">endpoint</span>(
  <span class="hljs-string">&quot;https://api-inference.huggingface.co/models/meta-llama/Llama-3.1-8B-Instruct&quot;</span>
);
<span class="hljs-keyword">const</span> stream = ep.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;tgi&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Complete the equation 1+1= ,just the answer&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">500</span>,
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.1</span>,
  <span class="hljs-attr">seed</span>: <span class="hljs-number">0</span>,
});
<span class="hljs-keyword">let</span> out = <span class="hljs-string">&quot;&quot;</span>;
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> stream) {
  <span class="hljs-keyword">if</span> (chunk.<span class="hljs-property">choices</span> &amp;&amp; chunk.<span class="hljs-property">choices</span>.<span class="hljs-property">length</span> &gt; <span class="hljs-number">0</span>) {
    out += chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>;
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(out);
  }
}`,wrap:!1}}),vl=new y({props:{code:"Y29uc3QlMjBncHQyJTIwJTNEJTIwaGYuZW5kcG9pbnQoJ2h0dHBzJTNBJTJGJTJGeHl6LmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZ3B0MicpJTNCJTBBY29uc3QlMjAlN0IlMjBnZW5lcmF0ZWRfdGV4dCUyMCU3RCUyMCUzRCUyMGF3YWl0JTIwZ3B0Mi50ZXh0R2VuZXJhdGlvbiglMEElMjAlMjAlN0JpbnB1dHMlM0ElMjAnVGhlJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjB1bml2ZXJzZSUyMGlzJyU3RCUyQyUwQSUyMCUyMCU3QnJldHJ5X29uX2Vycm9yJTNBJTIwZmFsc2UlN0QlMkMlMEEpJTNC",highlighted:`<span class="hljs-keyword">const</span> gpt2 = hf.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&#x27;https://xyz.eu-west-1.aws.endpoints.huggingface.cloud/gpt2&#x27;</span>);
<span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> gpt2.<span class="hljs-title function_">textGeneration</span>(
  {<span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>},
  {<span class="hljs-attr">retry_on_error</span>: <span class="hljs-literal">false</span>},
);`,wrap:!1}}),Al=new m({props:{title:"Running tests",local:"running-tests",headingTag:"h2"}}),Xl=new y({props:{code:"SEZfVE9LRU4lM0QlMjJ5b3VyJTIwYWNjZXNzJTIwdG9rZW4lMjIlMjBwbnBtJTIwcnVuJTIwdGVzdA==",highlighted:"HF_TOKEN=&quot;your access token&quot; pnpm run test",wrap:!1}}),Yl=new m({props:{title:"Finding appropriate models",local:"finding-appropriate-models",headingTag:"h2"}}),Rl=new m({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),zl=new Ge({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/inference/README.md"}}),{c(){T=j("meta"),_l=n(),Fl=j("p"),Ll=n(),p(u.$$.fragment),Dl=n(),w=j("p"),w.innerHTML=Cn,Pl=n(),g=j("p"),g.innerHTML=Bn,Kl=n(),p(f.$$.fragment),Ol=n(),p(d.$$.fragment),st=n(),p(U.$$.fragment),lt=n(),p(I.$$.fragment),tt=n(),p($.$$.fragment),at=n(),p(b.$$.fragment),nt=n(),p(C.$$.fragment),et=n(),p(B.$$.fragment),pt=n(),x=j("p"),x.innerHTML=xn,it=n(),Z=j("p"),Z.textContent=Zn,Mt=n(),p(k.$$.fragment),ot=n(),Q=j("p"),Q.innerHTML=kn,ct=n(),p(N.$$.fragment),rt=n(),G=j("p"),G.textContent=Qn,jt=n(),p(E.$$.fragment),ht=n(),p(W.$$.fragment),Jt=n(),v=j("p"),v.textContent=Nn,mt=n(),A=j("p"),A.innerHTML=Gn,yt=n(),p(X.$$.fragment),Tt=n(),p(Y.$$.fragment),ut=n(),S=j("p"),S.innerHTML=En,wt=n(),V=j("p"),V.innerHTML=Wn,gt=n(),p(R.$$.fragment),ft=n(),q=j("p"),q.textContent=vn,dt=n(),p(z.$$.fragment),Ut=n(),p(F.$$.fragment),It=n(),H=j("p"),H.textContent=An,$t=n(),p(_.$$.fragment),bt=n(),p(L.$$.fragment),Ct=n(),D=j("p"),D.textContent=Xn,Bt=n(),p(P.$$.fragment),xt=n(),p(K.$$.fragment),Zt=n(),O=j("p"),O.textContent=Yn,kt=n(),p(ss.$$.fragment),Qt=n(),p(ls.$$.fragment),Nt=n(),p(ts.$$.fragment),Gt=n(),p(as.$$.fragment),Et=n(),ns=j("p"),ns.textContent=Sn,Wt=n(),p(es.$$.fragment),vt=n(),p(ps.$$.fragment),At=n(),is=j("p"),is.textContent=Vn,Xt=n(),p(Ms.$$.fragment),Yt=n(),p(os.$$.fragment),St=n(),cs=j("p"),cs.textContent=Rn,Vt=n(),p(rs.$$.fragment),Rt=n(),p(js.$$.fragment),qt=n(),hs=j("p"),hs.textContent=qn,zt=n(),p(Js.$$.fragment),Ft=n(),p(ms.$$.fragment),Ht=n(),ys=j("p"),ys.textContent=zn,_t=n(),p(Ts.$$.fragment),Lt=n(),p(us.$$.fragment),Dt=n(),ws=j("p"),ws.textContent=Fn,Pt=n(),p(gs.$$.fragment),Kt=n(),p(fs.$$.fragment),Ot=n(),p(ds.$$.fragment),sa=n(),Us=j("p"),Us.textContent=Hn,la=n(),Is=j("p"),Is.innerHTML=_n,ta=n(),p($s.$$.fragment),aa=n(),p(bs.$$.fragment),na=n(),Cs=j("p"),Cs.textContent=Ln,ea=n(),Bs=j("p"),Bs.innerHTML=Dn,pa=n(),p(xs.$$.fragment),ia=n(),p(Zs.$$.fragment),Ma=n(),ks=j("p"),ks.textContent=Pn,oa=n(),Qs=j("p"),Qs.innerHTML=Kn,ca=n(),p(Ns.$$.fragment),ra=n(),p(Gs.$$.fragment),ja=n(),Es=j("p"),Es.textContent=On,ha=n(),p(Ws.$$.fragment),Ja=n(),p(vs.$$.fragment),ma=n(),p(As.$$.fragment),ya=n(),Xs=j("p"),Xs.textContent=se,Ta=n(),Ys=j("p"),Ys.innerHTML=le,ua=n(),p(Ss.$$.fragment),wa=n(),p(Vs.$$.fragment),ga=n(),Rs=j("p"),Rs.textContent=te,fa=n(),qs=j("p"),qs.innerHTML=ae,da=n(),p(zs.$$.fragment),Ua=n(),p(Fs.$$.fragment),Ia=n(),Hs=j("p"),Hs.textContent=ne,$a=n(),p(_s.$$.fragment),ba=n(),p(Ls.$$.fragment),Ca=n(),Ds=j("p"),Ds.textContent=ee,Ba=n(),p(Ps.$$.fragment),xa=n(),p(Ks.$$.fragment),Za=n(),Os=j("p"),Os.textContent=pe,ka=n(),sl=j("p"),sl.innerHTML=ie,Qa=n(),p(ll.$$.fragment),Na=n(),p(tl.$$.fragment),Ga=n(),al=j("p"),al.textContent=Me,Ea=n(),nl=j("p"),nl.innerHTML=oe,Wa=n(),p(el.$$.fragment),va=n(),p(pl.$$.fragment),Aa=n(),il=j("p"),il.textContent=ce,Xa=n(),p(Ml.$$.fragment),Ya=n(),p(ol.$$.fragment),Sa=n(),p(cl.$$.fragment),Va=n(),rl=j("p"),rl.textContent=re,Ra=n(),p(jl.$$.fragment),qa=n(),p(hl.$$.fragment),za=n(),Jl=j("p"),Jl.textContent=je,Fa=n(),ml=j("p"),ml.innerHTML=he,Ha=n(),p(yl.$$.fragment),_a=n(),p(Tl.$$.fragment),La=n(),ul=j("p"),ul.textContent=Je,Da=n(),wl=j("p"),wl.innerHTML=me,Pa=n(),p(gl.$$.fragment),Ka=n(),p(fl.$$.fragment),Oa=n(),p(dl.$$.fragment),sn=n(),Ul=j("p"),Ul.textContent=ye,ln=n(),p(Il.$$.fragment),tn=n(),p($l.$$.fragment),an=n(),bl=j("p"),bl.textContent=Te,nn=n(),p(Cl.$$.fragment),en=n(),p(Bl.$$.fragment),pn=n(),xl=j("p"),xl.textContent=ue,Mn=n(),p(Zl.$$.fragment),on=n(),kl=j("p"),kl.innerHTML=we,cn=n(),p(Ql.$$.fragment),rn=n(),p(Nl.$$.fragment),jn=n(),Gl=j("p"),Gl.innerHTML=ge,hn=n(),p(El.$$.fragment),Jn=n(),Wl=j("p"),Wl.innerHTML=fe,mn=n(),p(vl.$$.fragment),yn=n(),p(Al.$$.fragment),Tn=n(),p(Xl.$$.fragment),un=n(),p(Yl.$$.fragment),wn=n(),Sl=j("p"),Sl.innerHTML=de,gn=n(),Vl=j("p"),Vl.textContent=Ue,fn=n(),p(Rl.$$.fragment),dn=n(),ql=j("ul"),ql.innerHTML=Ie,Un=n(),p(zl.$$.fragment),In=n(),Hl=j("p"),this.h()},l(s){const l=Qe("svelte-u9bgzb",document.head);T=h(l,"META",{name:!0,content:!0}),l.forEach(t),_l=e(s),Fl=h(s,"P",{}),$e(Fl).forEach(t),Ll=e(s),i(u.$$.fragment,s),Dl=e(s),w=h(s,"P",{"data-svelte-h":!0}),J(w)!=="svelte-6gwev"&&(w.innerHTML=Cn),Pl=e(s),g=h(s,"P",{"data-svelte-h":!0}),J(g)!=="svelte-15l1k62"&&(g.innerHTML=Bn),Kl=e(s),i(f.$$.fragment,s),Ol=e(s),i(d.$$.fragment,s),st=e(s),i(U.$$.fragment,s),lt=e(s),i(I.$$.fragment,s),tt=e(s),i($.$$.fragment,s),at=e(s),i(b.$$.fragment,s),nt=e(s),i(C.$$.fragment,s),et=e(s),i(B.$$.fragment,s),pt=e(s),x=h(s,"P",{"data-svelte-h":!0}),J(x)!=="svelte-ys53zo"&&(x.innerHTML=xn),it=e(s),Z=h(s,"P",{"data-svelte-h":!0}),J(Z)!=="svelte-2l8ybr"&&(Z.textContent=Zn),Mt=e(s),i(k.$$.fragment,s),ot=e(s),Q=h(s,"P",{"data-svelte-h":!0}),J(Q)!=="svelte-62skcu"&&(Q.innerHTML=kn),ct=e(s),i(N.$$.fragment,s),rt=e(s),G=h(s,"P",{"data-svelte-h":!0}),J(G)!=="svelte-88xj6h"&&(G.textContent=Qn),jt=e(s),i(E.$$.fragment,s),ht=e(s),i(W.$$.fragment,s),Jt=e(s),v=h(s,"P",{"data-svelte-h":!0}),J(v)!=="svelte-18cimv4"&&(v.textContent=Nn),mt=e(s),A=h(s,"P",{"data-svelte-h":!0}),J(A)!=="svelte-kjz90x"&&(A.innerHTML=Gn),yt=e(s),i(X.$$.fragment,s),Tt=e(s),i(Y.$$.fragment,s),ut=e(s),S=h(s,"P",{"data-svelte-h":!0}),J(S)!=="svelte-13o9mww"&&(S.innerHTML=En),wt=e(s),V=h(s,"P",{"data-svelte-h":!0}),J(V)!=="svelte-slg7wg"&&(V.innerHTML=Wn),gt=e(s),i(R.$$.fragment,s),ft=e(s),q=h(s,"P",{"data-svelte-h":!0}),J(q)!=="svelte-1daohkt"&&(q.textContent=vn),dt=e(s),i(z.$$.fragment,s),Ut=e(s),i(F.$$.fragment,s),It=e(s),H=h(s,"P",{"data-svelte-h":!0}),J(H)!=="svelte-1mnrr3b"&&(H.textContent=An),$t=e(s),i(_.$$.fragment,s),bt=e(s),i(L.$$.fragment,s),Ct=e(s),D=h(s,"P",{"data-svelte-h":!0}),J(D)!=="svelte-4s1xv3"&&(D.textContent=Xn),Bt=e(s),i(P.$$.fragment,s),xt=e(s),i(K.$$.fragment,s),Zt=e(s),O=h(s,"P",{"data-svelte-h":!0}),J(O)!=="svelte-vnhv92"&&(O.textContent=Yn),kt=e(s),i(ss.$$.fragment,s),Qt=e(s),i(ls.$$.fragment,s),Nt=e(s),i(ts.$$.fragment,s),Gt=e(s),i(as.$$.fragment,s),Et=e(s),ns=h(s,"P",{"data-svelte-h":!0}),J(ns)!=="svelte-vlz10z"&&(ns.textContent=Sn),Wt=e(s),i(es.$$.fragment,s),vt=e(s),i(ps.$$.fragment,s),At=e(s),is=h(s,"P",{"data-svelte-h":!0}),J(is)!=="svelte-qln4hq"&&(is.textContent=Vn),Xt=e(s),i(Ms.$$.fragment,s),Yt=e(s),i(os.$$.fragment,s),St=e(s),cs=h(s,"P",{"data-svelte-h":!0}),J(cs)!=="svelte-yinzpl"&&(cs.textContent=Rn),Vt=e(s),i(rs.$$.fragment,s),Rt=e(s),i(js.$$.fragment,s),qt=e(s),hs=h(s,"P",{"data-svelte-h":!0}),J(hs)!=="svelte-mqluby"&&(hs.textContent=qn),zt=e(s),i(Js.$$.fragment,s),Ft=e(s),i(ms.$$.fragment,s),Ht=e(s),ys=h(s,"P",{"data-svelte-h":!0}),J(ys)!=="svelte-1wq8md5"&&(ys.textContent=zn),_t=e(s),i(Ts.$$.fragment,s),Lt=e(s),i(us.$$.fragment,s),Dt=e(s),ws=h(s,"P",{"data-svelte-h":!0}),J(ws)!=="svelte-tf7teq"&&(ws.textContent=Fn),Pt=e(s),i(gs.$$.fragment,s),Kt=e(s),i(fs.$$.fragment,s),Ot=e(s),i(ds.$$.fragment,s),sa=e(s),Us=h(s,"P",{"data-svelte-h":!0}),J(Us)!=="svelte-1in7idl"&&(Us.textContent=Hn),la=e(s),Is=h(s,"P",{"data-svelte-h":!0}),J(Is)!=="svelte-18afluh"&&(Is.innerHTML=_n),ta=e(s),i($s.$$.fragment,s),aa=e(s),i(bs.$$.fragment,s),na=e(s),Cs=h(s,"P",{"data-svelte-h":!0}),J(Cs)!=="svelte-12s1din"&&(Cs.textContent=Ln),ea=e(s),Bs=h(s,"P",{"data-svelte-h":!0}),J(Bs)!=="svelte-1jpdfy8"&&(Bs.innerHTML=Dn),pa=e(s),i(xs.$$.fragment,s),ia=e(s),i(Zs.$$.fragment,s),Ma=e(s),ks=h(s,"P",{"data-svelte-h":!0}),J(ks)!=="svelte-1h8ubig"&&(ks.textContent=Pn),oa=e(s),Qs=h(s,"P",{"data-svelte-h":!0}),J(Qs)!=="svelte-1edrfzt"&&(Qs.innerHTML=Kn),ca=e(s),i(Ns.$$.fragment,s),ra=e(s),i(Gs.$$.fragment,s),ja=e(s),Es=h(s,"P",{"data-svelte-h":!0}),J(Es)!=="svelte-zj5o06"&&(Es.textContent=On),ha=e(s),i(Ws.$$.fragment,s),Ja=e(s),i(vs.$$.fragment,s),ma=e(s),i(As.$$.fragment,s),ya=e(s),Xs=h(s,"P",{"data-svelte-h":!0}),J(Xs)!=="svelte-1nlp89w"&&(Xs.textContent=se),Ta=e(s),Ys=h(s,"P",{"data-svelte-h":!0}),J(Ys)!=="svelte-10vvvxx"&&(Ys.innerHTML=le),ua=e(s),i(Ss.$$.fragment,s),wa=e(s),i(Vs.$$.fragment,s),ga=e(s),Rs=h(s,"P",{"data-svelte-h":!0}),J(Rs)!=="svelte-d15mev"&&(Rs.textContent=te),fa=e(s),qs=h(s,"P",{"data-svelte-h":!0}),J(qs)!=="svelte-pxrbuw"&&(qs.innerHTML=ae),da=e(s),i(zs.$$.fragment,s),Ua=e(s),i(Fs.$$.fragment,s),Ia=e(s),Hs=h(s,"P",{"data-svelte-h":!0}),J(Hs)!=="svelte-1oenl8f"&&(Hs.textContent=ne),$a=e(s),i(_s.$$.fragment,s),ba=e(s),i(Ls.$$.fragment,s),Ca=e(s),Ds=h(s,"P",{"data-svelte-h":!0}),J(Ds)!=="svelte-66badz"&&(Ds.textContent=ee),Ba=e(s),i(Ps.$$.fragment,s),xa=e(s),i(Ks.$$.fragment,s),Za=e(s),Os=h(s,"P",{"data-svelte-h":!0}),J(Os)!=="svelte-13iv3hh"&&(Os.textContent=pe),ka=e(s),sl=h(s,"P",{"data-svelte-h":!0}),J(sl)!=="svelte-1mgyz4r"&&(sl.innerHTML=ie),Qa=e(s),i(ll.$$.fragment,s),Na=e(s),i(tl.$$.fragment,s),Ga=e(s),al=h(s,"P",{"data-svelte-h":!0}),J(al)!=="svelte-1y7kqaa"&&(al.textContent=Me),Ea=e(s),nl=h(s,"P",{"data-svelte-h":!0}),J(nl)!=="svelte-m8xmew"&&(nl.innerHTML=oe),Wa=e(s),i(el.$$.fragment,s),va=e(s),i(pl.$$.fragment,s),Aa=e(s),il=h(s,"P",{"data-svelte-h":!0}),J(il)!=="svelte-m7q2yg"&&(il.textContent=ce),Xa=e(s),i(Ml.$$.fragment,s),Ya=e(s),i(ol.$$.fragment,s),Sa=e(s),i(cl.$$.fragment,s),Va=e(s),rl=h(s,"P",{"data-svelte-h":!0}),J(rl)!=="svelte-174b8m1"&&(rl.textContent=re),Ra=e(s),i(jl.$$.fragment,s),qa=e(s),i(hl.$$.fragment,s),za=e(s),Jl=h(s,"P",{"data-svelte-h":!0}),J(Jl)!=="svelte-cnruui"&&(Jl.textContent=je),Fa=e(s),ml=h(s,"P",{"data-svelte-h":!0}),J(ml)!=="svelte-hwgezm"&&(ml.innerHTML=he),Ha=e(s),i(yl.$$.fragment,s),_a=e(s),i(Tl.$$.fragment,s),La=e(s),ul=h(s,"P",{"data-svelte-h":!0}),J(ul)!=="svelte-1tpexz3"&&(ul.textContent=Je),Da=e(s),wl=h(s,"P",{"data-svelte-h":!0}),J(wl)!=="svelte-hwgezm"&&(wl.innerHTML=me),Pa=e(s),i(gl.$$.fragment,s),Ka=e(s),i(fl.$$.fragment,s),Oa=e(s),i(dl.$$.fragment,s),sn=e(s),Ul=h(s,"P",{"data-svelte-h":!0}),J(Ul)!=="svelte-1js246c"&&(Ul.textContent=ye),ln=e(s),i(Il.$$.fragment,s),tn=e(s),i($l.$$.fragment,s),an=e(s),bl=h(s,"P",{"data-svelte-h":!0}),J(bl)!=="svelte-7l7zu1"&&(bl.textContent=Te),nn=e(s),i(Cl.$$.fragment,s),en=e(s),i(Bl.$$.fragment,s),pn=e(s),xl=h(s,"P",{"data-svelte-h":!0}),J(xl)!=="svelte-1uv5lul"&&(xl.textContent=ue),Mn=e(s),i(Zl.$$.fragment,s),on=e(s),kl=h(s,"P",{"data-svelte-h":!0}),J(kl)!=="svelte-cw0lq3"&&(kl.innerHTML=we),cn=e(s),i(Ql.$$.fragment,s),rn=e(s),i(Nl.$$.fragment,s),jn=e(s),Gl=h(s,"P",{"data-svelte-h":!0}),J(Gl)!=="svelte-14q869u"&&(Gl.innerHTML=ge),hn=e(s),i(El.$$.fragment,s),Jn=e(s),Wl=h(s,"P",{"data-svelte-h":!0}),J(Wl)!=="svelte-16znzc1"&&(Wl.innerHTML=fe),mn=e(s),i(vl.$$.fragment,s),yn=e(s),i(Al.$$.fragment,s),Tn=e(s),i(Xl.$$.fragment,s),un=e(s),i(Yl.$$.fragment,s),wn=e(s),Sl=h(s,"P",{"data-svelte-h":!0}),J(Sl)!=="svelte-62a9et"&&(Sl.innerHTML=de),gn=e(s),Vl=h(s,"P",{"data-svelte-h":!0}),J(Vl)!=="svelte-1yyf4wc"&&(Vl.textContent=Ue),fn=e(s),i(Rl.$$.fragment,s),dn=e(s),ql=h(s,"UL",{"data-svelte-h":!0}),J(ql)!=="svelte-mopwlb"&&(ql.innerHTML=Ie),Un=e(s),i(zl.$$.fragment,s),In=e(s),Hl=h(s,"P",{}),$e(Hl).forEach(t),this.h()},h(){be(T,"name","hf:doc:metadata"),be(T,"content",We)},m(s,l){Ne(document.head,T),a(s,_l,l),a(s,Fl,l),a(s,Ll,l),M(u,s,l),a(s,Dl,l),a(s,w,l),a(s,Pl,l),a(s,g,l),a(s,Kl,l),M(f,s,l),a(s,Ol,l),M(d,s,l),a(s,st,l),M(U,s,l),a(s,lt,l),M(I,s,l),a(s,tt,l),M($,s,l),a(s,at,l),M(b,s,l),a(s,nt,l),M(C,s,l),a(s,et,l),M(B,s,l),a(s,pt,l),a(s,x,l),a(s,it,l),a(s,Z,l),a(s,Mt,l),M(k,s,l),a(s,ot,l),a(s,Q,l),a(s,ct,l),M(N,s,l),a(s,rt,l),a(s,G,l),a(s,jt,l),M(E,s,l),a(s,ht,l),M(W,s,l),a(s,Jt,l),a(s,v,l),a(s,mt,l),a(s,A,l),a(s,yt,l),M(X,s,l),a(s,Tt,l),M(Y,s,l),a(s,ut,l),a(s,S,l),a(s,wt,l),a(s,V,l),a(s,gt,l),M(R,s,l),a(s,ft,l),a(s,q,l),a(s,dt,l),M(z,s,l),a(s,Ut,l),M(F,s,l),a(s,It,l),a(s,H,l),a(s,$t,l),M(_,s,l),a(s,bt,l),M(L,s,l),a(s,Ct,l),a(s,D,l),a(s,Bt,l),M(P,s,l),a(s,xt,l),M(K,s,l),a(s,Zt,l),a(s,O,l),a(s,kt,l),M(ss,s,l),a(s,Qt,l),M(ls,s,l),a(s,Nt,l),M(ts,s,l),a(s,Gt,l),M(as,s,l),a(s,Et,l),a(s,ns,l),a(s,Wt,l),M(es,s,l),a(s,vt,l),M(ps,s,l),a(s,At,l),a(s,is,l),a(s,Xt,l),M(Ms,s,l),a(s,Yt,l),M(os,s,l),a(s,St,l),a(s,cs,l),a(s,Vt,l),M(rs,s,l),a(s,Rt,l),M(js,s,l),a(s,qt,l),a(s,hs,l),a(s,zt,l),M(Js,s,l),a(s,Ft,l),M(ms,s,l),a(s,Ht,l),a(s,ys,l),a(s,_t,l),M(Ts,s,l),a(s,Lt,l),M(us,s,l),a(s,Dt,l),a(s,ws,l),a(s,Pt,l),M(gs,s,l),a(s,Kt,l),M(fs,s,l),a(s,Ot,l),M(ds,s,l),a(s,sa,l),a(s,Us,l),a(s,la,l),a(s,Is,l),a(s,ta,l),M($s,s,l),a(s,aa,l),M(bs,s,l),a(s,na,l),a(s,Cs,l),a(s,ea,l),a(s,Bs,l),a(s,pa,l),M(xs,s,l),a(s,ia,l),M(Zs,s,l),a(s,Ma,l),a(s,ks,l),a(s,oa,l),a(s,Qs,l),a(s,ca,l),M(Ns,s,l),a(s,ra,l),M(Gs,s,l),a(s,ja,l),a(s,Es,l),a(s,ha,l),M(Ws,s,l),a(s,Ja,l),M(vs,s,l),a(s,ma,l),M(As,s,l),a(s,ya,l),a(s,Xs,l),a(s,Ta,l),a(s,Ys,l),a(s,ua,l),M(Ss,s,l),a(s,wa,l),M(Vs,s,l),a(s,ga,l),a(s,Rs,l),a(s,fa,l),a(s,qs,l),a(s,da,l),M(zs,s,l),a(s,Ua,l),M(Fs,s,l),a(s,Ia,l),a(s,Hs,l),a(s,$a,l),M(_s,s,l),a(s,ba,l),M(Ls,s,l),a(s,Ca,l),a(s,Ds,l),a(s,Ba,l),M(Ps,s,l),a(s,xa,l),M(Ks,s,l),a(s,Za,l),a(s,Os,l),a(s,ka,l),a(s,sl,l),a(s,Qa,l),M(ll,s,l),a(s,Na,l),M(tl,s,l),a(s,Ga,l),a(s,al,l),a(s,Ea,l),a(s,nl,l),a(s,Wa,l),M(el,s,l),a(s,va,l),M(pl,s,l),a(s,Aa,l),a(s,il,l),a(s,Xa,l),M(Ml,s,l),a(s,Ya,l),M(ol,s,l),a(s,Sa,l),M(cl,s,l),a(s,Va,l),a(s,rl,l),a(s,Ra,l),M(jl,s,l),a(s,qa,l),M(hl,s,l),a(s,za,l),a(s,Jl,l),a(s,Fa,l),a(s,ml,l),a(s,Ha,l),M(yl,s,l),a(s,_a,l),M(Tl,s,l),a(s,La,l),a(s,ul,l),a(s,Da,l),a(s,wl,l),a(s,Pa,l),M(gl,s,l),a(s,Ka,l),M(fl,s,l),a(s,Oa,l),M(dl,s,l),a(s,sn,l),a(s,Ul,l),a(s,ln,l),M(Il,s,l),a(s,tn,l),M($l,s,l),a(s,an,l),a(s,bl,l),a(s,nn,l),M(Cl,s,l),a(s,en,l),M(Bl,s,l),a(s,pn,l),a(s,xl,l),a(s,Mn,l),M(Zl,s,l),a(s,on,l),a(s,kl,l),a(s,cn,l),M(Ql,s,l),a(s,rn,l),M(Nl,s,l),a(s,jn,l),a(s,Gl,l),a(s,hn,l),M(El,s,l),a(s,Jn,l),a(s,Wl,l),a(s,mn,l),M(vl,s,l),a(s,yn,l),M(Al,s,l),a(s,Tn,l),M(Xl,s,l),a(s,un,l),M(Yl,s,l),a(s,wn,l),a(s,Sl,l),a(s,gn,l),a(s,Vl,l),a(s,fn,l),M(Rl,s,l),a(s,dn,l),a(s,ql,l),a(s,Un,l),M(zl,s,l),a(s,In,l),a(s,Hl,l),$n=!0},p:Be,i(s){$n||(o(u.$$.fragment,s),o(f.$$.fragment,s),o(d.$$.fragment,s),o(U.$$.fragment,s),o(I.$$.fragment,s),o($.$$.fragment,s),o(b.$$.fragment,s),o(C.$$.fragment,s),o(B.$$.fragment,s),o(k.$$.fragment,s),o(N.$$.fragment,s),o(E.$$.fragment,s),o(W.$$.fragment,s),o(X.$$.fragment,s),o(Y.$$.fragment,s),o(R.$$.fragment,s),o(z.$$.fragment,s),o(F.$$.fragment,s),o(_.$$.fragment,s),o(L.$$.fragment,s),o(P.$$.fragment,s),o(K.$$.fragment,s),o(ss.$$.fragment,s),o(ls.$$.fragment,s),o(ts.$$.fragment,s),o(as.$$.fragment,s),o(es.$$.fragment,s),o(ps.$$.fragment,s),o(Ms.$$.fragment,s),o(os.$$.fragment,s),o(rs.$$.fragment,s),o(js.$$.fragment,s),o(Js.$$.fragment,s),o(ms.$$.fragment,s),o(Ts.$$.fragment,s),o(us.$$.fragment,s),o(gs.$$.fragment,s),o(fs.$$.fragment,s),o(ds.$$.fragment,s),o($s.$$.fragment,s),o(bs.$$.fragment,s),o(xs.$$.fragment,s),o(Zs.$$.fragment,s),o(Ns.$$.fragment,s),o(Gs.$$.fragment,s),o(Ws.$$.fragment,s),o(vs.$$.fragment,s),o(As.$$.fragment,s),o(Ss.$$.fragment,s),o(Vs.$$.fragment,s),o(zs.$$.fragment,s),o(Fs.$$.fragment,s),o(_s.$$.fragment,s),o(Ls.$$.fragment,s),o(Ps.$$.fragment,s),o(Ks.$$.fragment,s),o(ll.$$.fragment,s),o(tl.$$.fragment,s),o(el.$$.fragment,s),o(pl.$$.fragment,s),o(Ml.$$.fragment,s),o(ol.$$.fragment,s),o(cl.$$.fragment,s),o(jl.$$.fragment,s),o(hl.$$.fragment,s),o(yl.$$.fragment,s),o(Tl.$$.fragment,s),o(gl.$$.fragment,s),o(fl.$$.fragment,s),o(dl.$$.fragment,s),o(Il.$$.fragment,s),o($l.$$.fragment,s),o(Cl.$$.fragment,s),o(Bl.$$.fragment,s),o(Zl.$$.fragment,s),o(Ql.$$.fragment,s),o(Nl.$$.fragment,s),o(El.$$.fragment,s),o(vl.$$.fragment,s),o(Al.$$.fragment,s),o(Xl.$$.fragment,s),o(Yl.$$.fragment,s),o(Rl.$$.fragment,s),o(zl.$$.fragment,s),$n=!0)},o(s){c(u.$$.fragment,s),c(f.$$.fragment,s),c(d.$$.fragment,s),c(U.$$.fragment,s),c(I.$$.fragment,s),c($.$$.fragment,s),c(b.$$.fragment,s),c(C.$$.fragment,s),c(B.$$.fragment,s),c(k.$$.fragment,s),c(N.$$.fragment,s),c(E.$$.fragment,s),c(W.$$.fragment,s),c(X.$$.fragment,s),c(Y.$$.fragment,s),c(R.$$.fragment,s),c(z.$$.fragment,s),c(F.$$.fragment,s),c(_.$$.fragment,s),c(L.$$.fragment,s),c(P.$$.fragment,s),c(K.$$.fragment,s),c(ss.$$.fragment,s),c(ls.$$.fragment,s),c(ts.$$.fragment,s),c(as.$$.fragment,s),c(es.$$.fragment,s),c(ps.$$.fragment,s),c(Ms.$$.fragment,s),c(os.$$.fragment,s),c(rs.$$.fragment,s),c(js.$$.fragment,s),c(Js.$$.fragment,s),c(ms.$$.fragment,s),c(Ts.$$.fragment,s),c(us.$$.fragment,s),c(gs.$$.fragment,s),c(fs.$$.fragment,s),c(ds.$$.fragment,s),c($s.$$.fragment,s),c(bs.$$.fragment,s),c(xs.$$.fragment,s),c(Zs.$$.fragment,s),c(Ns.$$.fragment,s),c(Gs.$$.fragment,s),c(Ws.$$.fragment,s),c(vs.$$.fragment,s),c(As.$$.fragment,s),c(Ss.$$.fragment,s),c(Vs.$$.fragment,s),c(zs.$$.fragment,s),c(Fs.$$.fragment,s),c(_s.$$.fragment,s),c(Ls.$$.fragment,s),c(Ps.$$.fragment,s),c(Ks.$$.fragment,s),c(ll.$$.fragment,s),c(tl.$$.fragment,s),c(el.$$.fragment,s),c(pl.$$.fragment,s),c(Ml.$$.fragment,s),c(ol.$$.fragment,s),c(cl.$$.fragment,s),c(jl.$$.fragment,s),c(hl.$$.fragment,s),c(yl.$$.fragment,s),c(Tl.$$.fragment,s),c(gl.$$.fragment,s),c(fl.$$.fragment,s),c(dl.$$.fragment,s),c(Il.$$.fragment,s),c($l.$$.fragment,s),c(Cl.$$.fragment,s),c(Bl.$$.fragment,s),c(Zl.$$.fragment,s),c(Ql.$$.fragment,s),c(Nl.$$.fragment,s),c(El.$$.fragment,s),c(vl.$$.fragment,s),c(Al.$$.fragment,s),c(Xl.$$.fragment,s),c(Yl.$$.fragment,s),c(Rl.$$.fragment,s),c(zl.$$.fragment,s),$n=!1},d(s){s&&(t(_l),t(Fl),t(Ll),t(Dl),t(w),t(Pl),t(g),t(Kl),t(Ol),t(st),t(lt),t(tt),t(at),t(nt),t(et),t(pt),t(x),t(it),t(Z),t(Mt),t(ot),t(Q),t(ct),t(rt),t(G),t(jt),t(ht),t(Jt),t(v),t(mt),t(A),t(yt),t(Tt),t(ut),t(S),t(wt),t(V),t(gt),t(ft),t(q),t(dt),t(Ut),t(It),t(H),t($t),t(bt),t(Ct),t(D),t(Bt),t(xt),t(Zt),t(O),t(kt),t(Qt),t(Nt),t(Gt),t(Et),t(ns),t(Wt),t(vt),t(At),t(is),t(Xt),t(Yt),t(St),t(cs),t(Vt),t(Rt),t(qt),t(hs),t(zt),t(Ft),t(Ht),t(ys),t(_t),t(Lt),t(Dt),t(ws),t(Pt),t(Kt),t(Ot),t(sa),t(Us),t(la),t(Is),t(ta),t(aa),t(na),t(Cs),t(ea),t(Bs),t(pa),t(ia),t(Ma),t(ks),t(oa),t(Qs),t(ca),t(ra),t(ja),t(Es),t(ha),t(Ja),t(ma),t(ya),t(Xs),t(Ta),t(Ys),t(ua),t(wa),t(ga),t(Rs),t(fa),t(qs),t(da),t(Ua),t(Ia),t(Hs),t($a),t(ba),t(Ca),t(Ds),t(Ba),t(xa),t(Za),t(Os),t(ka),t(sl),t(Qa),t(Na),t(Ga),t(al),t(Ea),t(nl),t(Wa),t(va),t(Aa),t(il),t(Xa),t(Ya),t(Sa),t(Va),t(rl),t(Ra),t(qa),t(za),t(Jl),t(Fa),t(ml),t(Ha),t(_a),t(La),t(ul),t(Da),t(wl),t(Pa),t(Ka),t(Oa),t(sn),t(Ul),t(ln),t(tn),t(an),t(bl),t(nn),t(en),t(pn),t(xl),t(Mn),t(on),t(kl),t(cn),t(rn),t(jn),t(Gl),t(hn),t(Jn),t(Wl),t(mn),t(yn),t(Tn),t(un),t(wn),t(Sl),t(gn),t(Vl),t(fn),t(dn),t(ql),t(Un),t(In),t(Hl)),t(T),r(u,s),r(f,s),r(d,s),r(U,s),r(I,s),r($,s),r(b,s),r(C,s),r(B,s),r(k,s),r(N,s),r(E,s),r(W,s),r(X,s),r(Y,s),r(R,s),r(z,s),r(F,s),r(_,s),r(L,s),r(P,s),r(K,s),r(ss,s),r(ls,s),r(ts,s),r(as,s),r(es,s),r(ps,s),r(Ms,s),r(os,s),r(rs,s),r(js,s),r(Js,s),r(ms,s),r(Ts,s),r(us,s),r(gs,s),r(fs,s),r(ds,s),r($s,s),r(bs,s),r(xs,s),r(Zs,s),r(Ns,s),r(Gs,s),r(Ws,s),r(vs,s),r(As,s),r(Ss,s),r(Vs,s),r(zs,s),r(Fs,s),r(_s,s),r(Ls,s),r(Ps,s),r(Ks,s),r(ll,s),r(tl,s),r(el,s),r(pl,s),r(Ml,s),r(ol,s),r(cl,s),r(jl,s),r(hl,s),r(yl,s),r(Tl,s),r(gl,s),r(fl,s),r(dl,s),r(Il,s),r($l,s),r(Cl,s),r(Bl,s),r(Zl,s),r(Ql,s),r(Nl,s),r(El,s),r(vl,s),r(Al,s),r(Xl,s),r(Yl,s),r(Rl,s),r(zl,s)}}}const We='{"title":"🤗 Hugging Face Inference Endpoints","local":"-hugging-face-inference-endpoints","sections":[{"title":"Getting Started","local":"getting-started","sections":[{"title":"Install","local":"install","sections":[{"title":"Node","local":"node","sections":[],"depth":4},{"title":"Deno","local":"deno","sections":[],"depth":4}],"depth":3},{"title":"Initialize","local":"initialize","sections":[{"title":"Tree-shaking","local":"tree-shaking","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Natural Language Processing","local":"natural-language-processing","sections":[{"title":"Text Generation","local":"text-generation","sections":[],"depth":3},{"title":"Text Generation (Chat Completion API Compatible)","local":"text-generation-chat-completion-api-compatible","sections":[],"depth":3},{"title":"Fill Mask","local":"fill-mask","sections":[],"depth":3},{"title":"Summarization","local":"summarization","sections":[],"depth":3},{"title":"Question Answering","local":"question-answering","sections":[],"depth":3},{"title":"Table Question Answering","local":"table-question-answering","sections":[],"depth":3},{"title":"Text Classification","local":"text-classification","sections":[],"depth":3},{"title":"Token Classification","local":"token-classification","sections":[],"depth":3},{"title":"Translation","local":"translation","sections":[],"depth":3},{"title":"Zero-Shot Classification","local":"zero-shot-classification","sections":[],"depth":3},{"title":"Conversational","local":"conversational","sections":[],"depth":3},{"title":"Sentence Similarity","local":"sentence-similarity","sections":[],"depth":3}],"depth":2},{"title":"Audio","local":"audio","sections":[{"title":"Automatic Speech Recognition","local":"automatic-speech-recognition","sections":[],"depth":3},{"title":"Audio Classification","local":"audio-classification","sections":[],"depth":3},{"title":"Text To Speech","local":"text-to-speech","sections":[],"depth":3},{"title":"Audio To Audio","local":"audio-to-audio","sections":[],"depth":3}],"depth":2},{"title":"Computer Vision","local":"computer-vision","sections":[{"title":"Image Classification","local":"image-classification","sections":[],"depth":3},{"title":"Object Detection","local":"object-detection","sections":[],"depth":3},{"title":"Image Segmentation","local":"image-segmentation","sections":[],"depth":3},{"title":"Image To Text","local":"image-to-text","sections":[],"depth":3},{"title":"Text To Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image To Image","local":"image-to-image","sections":[],"depth":3},{"title":"Zero Shot Image Classification","local":"zero-shot-image-classification","sections":[],"depth":3}],"depth":2},{"title":"Multimodal","local":"multimodal","sections":[{"title":"Feature Extraction","local":"feature-extraction","sections":[],"depth":3},{"title":"Visual Question Answering","local":"visual-question-answering","sections":[],"depth":3},{"title":"Document Question Answering","local":"document-question-answering","sections":[],"depth":3}],"depth":2},{"title":"Tabular","local":"tabular","sections":[{"title":"Tabular Regression","local":"tabular-regression","sections":[],"depth":3},{"title":"Tabular Classification","local":"tabular-classification","sections":[],"depth":3}],"depth":2},{"title":"Custom Calls","local":"custom-calls","sections":[],"depth":2},{"title":"Custom Inference Endpoints","local":"custom-inference-endpoints","sections":[],"depth":2},{"title":"Running tests","local":"running-tests","sections":[],"depth":2},{"title":"Finding appropriate models","local":"finding-appropriate-models","sections":[],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2}],"depth":1}';function ve(bn){return xe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ve extends Ze{constructor(T){super(),ke(this,T,ve,Ee,Ce,{})}}export{Ve as component};
