import{s as F,f as P,n as L,o as K}from"../chunks/scheduler.f7e1785c.js";import{S as D,i as O,g as p,s as n,r as R,A as ee,h as c,f as a,c as i,j as V,u as W,x as v,k as r,y as te,a as l,v as Z,d as H,t as Q,w as A}from"../chunks/index.9f8f0838.js";import{C as N}from"../chunks/CodeBlock.b3510e34.js";import{H as ae}from"../chunks/Heading.6643a2f7.js";function le(Y){let o,b,g,J,d,T,m,E=`In this final section on audio classification, we’ll build a <a href="https://gradio.app" rel="nofollow">Gradio</a> demo to showcase the music
classification model that we just trained on the <a href="https://huggingface.co/datasets/marsyas/gtzan" rel="nofollow">GTZAN</a> dataset. The first
thing to do is load up the fine-tuned checkpoint using the <code>pipeline()</code> class - this is very familiar now from the section
on <a href="classification_models">pre-trained models</a>. You can change the <code>model_id</code> to the namespace of your fine-tuned model
on the Hugging Face Hub:`,U,u,$,h,S=`Secondly, we’ll define a function that takes the filepath for an audio input and passes it through the pipeline. Here,
the pipeline automatically takes care of loading the audio file, resampling it to the correct sampling rate, and running
inference with the model. We take the models predictions of <code>preds</code> and format them as a dictionary object to be displayed on the
output:`,_,f,k,w,X="Finally, we launch the Gradio demo using the function we’ve just defined:",B,M,G,y,q="This will launch a Gradio demo similar to the one running on the Hugging Face Space:",C,s,z,I,j,x;return d=new ae({props:{title:"Build a demo with Gradio",local:"build-a-demo-with-gradio",headingTag:"h1"}}),u=new N({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzYW5jaGl0LWdhbmRoaSUyRmRpc3RpbGh1YmVydC1maW5ldHVuZWQtZ3R6YW4lMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXVkaW8tY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

model_id = <span class="hljs-string">&quot;sanchit-gandhi/distilhubert-finetuned-gtzan&quot;</span>
pipe = pipeline(<span class="hljs-string">&quot;audio-classification&quot;</span>, model=model_id)`,wrap:!1}}),f=new N({props:{code:"ZGVmJTIwY2xhc3NpZnlfYXVkaW8oZmlsZXBhdGgpJTNBJTBBJTIwJTIwJTIwJTIwcHJlZHMlMjAlM0QlMjBwaXBlKGZpbGVwYXRoKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjAlN0IlN0QlMEElMjAlMjAlMjAlMjBmb3IlMjBwJTIwaW4lMjBwcmVkcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlNUJwJTVCJTIybGFiZWwlMjIlNUQlNUQlMjAlM0QlMjBwJTVCJTIyc2NvcmUlMjIlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">classify_audio</span>(<span class="hljs-params">filepath</span>):
    preds = pipe(filepath)
    outputs = {}
    <span class="hljs-keyword">for</span> p <span class="hljs-keyword">in</span> preds:
        outputs[p[<span class="hljs-string">&quot;label&quot;</span>]] = p[<span class="hljs-string">&quot;score&quot;</span>]
    <span class="hljs-keyword">return</span> outputs`,wrap:!1}}),M=new N({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWRlbW8lMjAlM0QlMjBnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0RjbGFzc2lmeV9hdWRpbyUyQyUyMGlucHV0cyUzRGdyLkF1ZGlvKHR5cGUlM0QlMjJmaWxlcGF0aCUyMiklMkMlMjBvdXRwdXRzJTNEZ3Iub3V0cHV0cy5MYWJlbCgpJTBBKSUwQWRlbW8ubGF1bmNoKGRlYnVnJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

demo = gr.Interface(
    fn=classify_audio, inputs=gr.Audio(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>), outputs=gr.outputs.Label()
)
demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){o=p("meta"),b=n(),g=p("p"),J=n(),R(d.$$.fragment),T=n(),m=p("p"),m.innerHTML=E,U=n(),R(u.$$.fragment),$=n(),h=p("p"),h.innerHTML=S,_=n(),R(f.$$.fragment),k=n(),w=p("p"),w.textContent=X,B=n(),R(M.$$.fragment),G=n(),y=p("p"),y.textContent=q,C=n(),s=p("iframe"),I=n(),j=p("p"),this.h()},l(e){const t=ee("svelte-u9bgzb",document.head);o=c(t,"META",{name:!0,content:!0}),t.forEach(a),b=i(e),g=c(e,"P",{}),V(g).forEach(a),J=i(e),W(d.$$.fragment,e),T=i(e),m=c(e,"P",{"data-svelte-h":!0}),v(m)!=="svelte-1r0764x"&&(m.innerHTML=E),U=i(e),W(u.$$.fragment,e),$=i(e),h=c(e,"P",{"data-svelte-h":!0}),v(h)!=="svelte-1o13rj8"&&(h.innerHTML=S),_=i(e),W(f.$$.fragment,e),k=i(e),w=c(e,"P",{"data-svelte-h":!0}),v(w)!=="svelte-rqn9c6"&&(w.textContent=X),B=i(e),W(M.$$.fragment,e),G=i(e),y=c(e,"P",{"data-svelte-h":!0}),v(y)!=="svelte-10sf4ix"&&(y.textContent=q),C=i(e),s=c(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),V(s).forEach(a),I=i(e),j=c(e,"P",{}),V(j).forEach(a),this.h()},h(){r(o,"name","hf:doc:metadata"),r(o,"content",se),P(s.src,z="https://course-demos-song-classifier.hf.space")||r(s,"src",z),r(s,"frameborder","0"),r(s,"height","450"),r(s,"title","Gradio app"),r(s,"class","container p-0 flex-grow space-iframe"),r(s,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(s,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){te(document.head,o),l(e,b,t),l(e,g,t),l(e,J,t),Z(d,e,t),l(e,T,t),l(e,m,t),l(e,U,t),Z(u,e,t),l(e,$,t),l(e,h,t),l(e,_,t),Z(f,e,t),l(e,k,t),l(e,w,t),l(e,B,t),Z(M,e,t),l(e,G,t),l(e,y,t),l(e,C,t),l(e,s,t),l(e,I,t),l(e,j,t),x=!0},p:L,i(e){x||(H(d.$$.fragment,e),H(u.$$.fragment,e),H(f.$$.fragment,e),H(M.$$.fragment,e),x=!0)},o(e){Q(d.$$.fragment,e),Q(u.$$.fragment,e),Q(f.$$.fragment,e),Q(M.$$.fragment,e),x=!1},d(e){e&&(a(b),a(g),a(J),a(T),a(m),a(U),a($),a(h),a(_),a(k),a(w),a(B),a(G),a(y),a(C),a(s),a(I),a(j)),a(o),A(d,e),A(u,e),A(f,e),A(M,e)}}}const se='{"title":"Build a demo with Gradio","local":"build-a-demo-with-gradio","sections":[],"depth":1}';function ne(Y){return K(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ce extends D{constructor(o){super(),O(this,o,ne,le,F,{})}}export{ce as component};
