import{s as ee,n as se,o as ae}from"../chunks/scheduler.f6b352c8.js";import{S as te,i as ne,g as M,s as t,r as p,A as Me,h as o,f as s,c as n,j as le,u as c,x as i,k as ql,y as oe,a,v as d,d as u,t as r,w as j}from"../chunks/index.7f38e934.js";import{C as m}from"../chunks/CodeBlock.2a338b68.js";import{H as ie}from"../chunks/Heading.333929c4.js";function pe(Zl){let y,D,V,O,J,K,T,El=`En este curso usaremos la libreria 🤗 Datasets para trabajar con bases de datos de audio. 🤗 Datasets es una libreria de
código abierto para descargar y preparar conjuntos de datos de todos los tipos, incluyendo audio. La libreria ofrece un
acceso fácil a una gran cantidad de conjuntos de datos públicos almacenados en el Hugging Face Hub. Además, 🤗 Datasets incluye
multiples funcionalidades pensadas para simplificar el trabajo con conjuntos de datos de audio para investigadores y desarrolladores.`,ll,w,xl="Para empezar a trabajar con bases de datos de audio, asegurate de tener la librería 🤗 Datasets instalada:",el,h,sl,b,Bl=`Una de las principales características de 🤗 Datasets es la posibilidad de descargar y preparar un conjunto de datos
en una sola linea de código usando la función <code>load_dataset()</code>`,al,A,Ql=`Carguemos y exploremos un conjunto de audios llamado <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a>, el cual contiene
grabaciones de personas haciendo preguntas sobre sistemas electrónicos bancarios en diferentes lenguajes y dialectos.`,tl,f,Wl=`Para cargar MINDS-14, necesitamos copiar el identificador de la base de datos que aparece en el Hub (<code>PolyAI/minds14</code>) y pasarlo
como argumento a la función <code>load_dataset</code>. Tambien especificaremos que solo estamos interesados en el subconjunto de inglés Australiano(<code>en-AU</code>)
y la partición de entrenamiento(“train”):`,nl,C,Ml,I,_l="<strong>Output:</strong>",ol,g,il,G,Rl=`El conjunto de datos contiene 654 audios, cada uno acompañado de su transcripción, una transcripción en inglés, y una etiqueta
que indica la intención de la pregunta de la persona. La columna de audio, contiene la información en bruto del audio. Examinemos
ahora uno de los ejemplos:`,pl,v,cl,$,Fl="<strong>Output:</strong>",dl,k,ul,q,Hl="Puedes ver que la columna de audio se compone de las siguiente información:",rl,Z,Yl="<li><code>path</code>: La ruta al archivo de audio (<code>*.wav</code> en este caso).</li> <li><code>array</code>: Los datos decodificados de audios, representedos como un NumPy array de 1 dimensión.</li> <li><code>sampling_rate</code>. La frecuencia de muestreo del archivo (8,000 Hz en este ejemplo).</li>",jl,E,Sl=`La columna <code>intent_class</code> es de tipo categórico codificado en enteros. Para convertir este número en una texto con significado
podemos usar el método <code>int2str()</code>:`,ml,x,yl,B,Nl="<strong>Output:</strong>",Ul,Q,Jl,W,zl=`Si miras la columna de <code>transcription</code>, puedes ver que en efecto la persona ha grabado un audio haciendo una pregunta sobre
pagar una cuenta.`,Tl,_,Xl=`Si planeas entrenar un clasificador de audio en este subconjunto de datos, no necesitas toda la información contenida en las
columnas del conjunto de datos. Por ejemplo, la información en <code>lang_id</code> sera igual para todos los ejemplos y no nos será útil.
La columna <code>english_transcription&#39; seguramente sera un duplicado de la columna </code>transcription\` en este subconjunto, por lo que
podemos removerla tambien.`,wl,R,Ll="Puedes eliminar características irrelevantes usando el método `<code>remove_columns</code>de 🤗 Datasets",hl,F,bl,H,Vl="<strong>Output:</strong>",Al,Y,fl,S,Pl=`Ahora que hemos cargado e inspeccionado los contenidos del conjunto de datos, ¡escuchemos algunos ejemplos! Usaremos <code>Blocks</code>
y <code>Audio</code> de <code>Gradio</code> para cargar algunos ejemplos del dataset.`,Cl,N,Il,z,Dl="Podemos visulizar tambien algunos de los ejemplos. Grafiquemos ahora la forma de onda del primer ejemplo.",gl,X,Gl,U,Ol='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/waveform_unit1.png" alt="Waveform plot"/>',vl,L,Kl=`¡Pruebalo! Decarga otro dialecto o lenguaje del conjunto MINDS-14, escucha y visualiza ajgunos ejemplos para tener un
sentido de la variación de toda la base de datos. Puedes ver una lista de todos los lenguajes <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">aqui</a>.`,$l,P,kl;return J=new ie({props:{title:"Cargar y explorar una base de datos de audio",local:"cargar-y-explorar-una-base-de-datos-de-audio",headingTag:"h1"}}),h=new m({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTVCYXVkaW8lNUQ=",highlighted:"pip install datasets[audio]",wrap:!1}}),C=new m({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBbWluZHM=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
minds`,wrap:!1}}),g=new m({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmdsaXNoX3RyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5nX2lkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA2NTQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [
            <span class="hljs-string">&quot;path&quot;</span>,
            <span class="hljs-string">&quot;audio&quot;</span>,
            <span class="hljs-string">&quot;transcription&quot;</span>,
            <span class="hljs-string">&quot;english_transcription&quot;</span>,
            <span class="hljs-string">&quot;intent_class&quot;</span>,
            <span class="hljs-string">&quot;lang_id&quot;</span>,
        ],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">654</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),v=new m({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWV4YW1wbGU=",highlighted:`example = minds[<span class="hljs-number">0</span>]
example`,wrap:!1}}),k=new m({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwLjAlMkMlMjAwLjAwMDI0NDE0JTJDJTIwLTAuMDAwMjQ0MTQlMkMlMjAuLi4lMkMlMjAtMC4wMDAyNDQxNCUyQyUyMDAuMDAwMjQ0MTQlMkMlMjAwLjAwMTIyMDclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDgwMDAlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2NyaXB0aW9uJTIyJTNBJTIwJTIySSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwcGF5JTIwbXklMjBlbGVjdHJpY2l0eSUyMGJpbGwlMjB1c2luZyUyMG15JTIwY2FyZCUyMGNhbiUyMHlvdSUyMHBsZWFzZSUyMGFzc2lzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmVuZ2xpc2hfdHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhbmdfaWQlMjIlM0ElMjAyJTJDJTBBJTdE",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [<span class="hljs-number">0.0</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">-0.00024414</span>, ..., <span class="hljs-number">-0.00024414</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">0.0012207</span>],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">8000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;english_transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
    <span class="hljs-comment">&quot;lang_id&quot;</span>: <span class="hljs-number">2</span>,
}`,wrap:!1}}),x=new m({props:{code:"aWQybGFiZWwlMjAlM0QlMjBtaW5kcy5mZWF0dXJlcyU1QiUyMmludGVudF9jbGFzcyUyMiU1RC5pbnQyc3RyJTBBaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCk=",highlighted:`id2label = minds.features[<span class="hljs-string">&quot;intent_class&quot;</span>].int2str
id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])`,wrap:!1}}),Q=new m({props:{code:"JTIycGF5X2JpbGwlMjI=",highlighted:'<span class="hljs-string">&quot;pay_bill&quot;</span>',wrap:!1}}),F=new m({props:{code:"Y29sdW1uc190b19yZW1vdmUlMjAlM0QlMjAlNUIlMjJsYW5nX2lkJTIyJTJDJTIwJTIyZW5nbGlzaF90cmFuc2NyaXB0aW9uJTIyJTVEJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyhjb2x1bW5zX3RvX3JlbW92ZSklMEFtaW5kcw==",highlighted:`columns_to_remove = [<span class="hljs-string">&quot;lang_id&quot;</span>, <span class="hljs-string">&quot;english_transcription&quot;</span>]
minds = minds.remove_columns(columns_to_remove)
minds`,wrap:!1}}),Y=new m({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDY1NCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 654})</span>',wrap:!1}}),N=new m({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlX2F1ZGlvKCklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwbWluZHMuc2h1ZmZsZSgpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTJDJTIwaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCklMEElMEElMEF3aXRoJTIwZ3IuQmxvY2tzKCklMjBhcyUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwZ3IuQ29sdW1uKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBfJTIwaW4lMjByYW5nZSg0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTJDJTIwbGFiZWwlMjAlM0QlMjBnZW5lcmF0ZV9hdWRpbygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwZ3IuQXVkaW8oYXVkaW8lMkMlMjBsYWJlbCUzRGxhYmVsKSUwQSUwQWRlbW8ubGF1bmNoKGRlYnVnJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_audio</span>():
    example = minds.shuffle()[<span class="hljs-number">0</span>]
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    <span class="hljs-keyword">return</span> (
        audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        audio[<span class="hljs-string">&quot;array&quot;</span>],
    ), id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    <span class="hljs-keyword">with</span> gr.Column():
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>):
            audio, label = generate_audio()
            output = gr.Audio(audio, label=label)

demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),X=new m({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQWltcG9ydCUyMG1hdHBsb3RsaWIucHlwbG90JTIwYXMlMjBwbHQlMEFpbXBvcnQlMjBsaWJyb3NhLmRpc3BsYXklMEElMEFhcnJheSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMEElMEFwbHQuZmlndXJlKCkuc2V0X2ZpZ3dpZHRoKDEyKSUwQWxpYnJvc2EuZGlzcGxheS53YXZlc2hvdyhhcnJheSUyQyUyMHNyJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">import</span> librosa
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> librosa.display

array = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
sampling_rate = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.waveshow(array, sr=sampling_rate)`,wrap:!1}}),{c(){y=M("meta"),D=t(),V=M("p"),O=t(),p(J.$$.fragment),K=t(),T=M("p"),T.textContent=El,ll=t(),w=M("p"),w.textContent=xl,el=t(),p(h.$$.fragment),sl=t(),b=M("p"),b.innerHTML=Bl,al=t(),A=M("p"),A.innerHTML=Ql,tl=t(),f=M("p"),f.innerHTML=Wl,nl=t(),p(C.$$.fragment),Ml=t(),I=M("p"),I.innerHTML=_l,ol=t(),p(g.$$.fragment),il=t(),G=M("p"),G.textContent=Rl,pl=t(),p(v.$$.fragment),cl=t(),$=M("p"),$.innerHTML=Fl,dl=t(),p(k.$$.fragment),ul=t(),q=M("p"),q.textContent=Hl,rl=t(),Z=M("ul"),Z.innerHTML=Yl,jl=t(),E=M("p"),E.innerHTML=Sl,ml=t(),p(x.$$.fragment),yl=t(),B=M("p"),B.innerHTML=Nl,Ul=t(),p(Q.$$.fragment),Jl=t(),W=M("p"),W.innerHTML=zl,Tl=t(),_=M("p"),_.innerHTML=Xl,wl=t(),R=M("p"),R.innerHTML=Ll,hl=t(),p(F.$$.fragment),bl=t(),H=M("p"),H.innerHTML=Vl,Al=t(),p(Y.$$.fragment),fl=t(),S=M("p"),S.innerHTML=Pl,Cl=t(),p(N.$$.fragment),Il=t(),z=M("p"),z.textContent=Dl,gl=t(),p(X.$$.fragment),Gl=t(),U=M("div"),U.innerHTML=Ol,vl=t(),L=M("p"),L.innerHTML=Kl,$l=t(),P=M("p"),this.h()},l(l){const e=Me("svelte-u9bgzb",document.head);y=o(e,"META",{name:!0,content:!0}),e.forEach(s),D=n(l),V=o(l,"P",{}),le(V).forEach(s),O=n(l),c(J.$$.fragment,l),K=n(l),T=o(l,"P",{"data-svelte-h":!0}),i(T)!=="svelte-fms3f9"&&(T.textContent=El),ll=n(l),w=o(l,"P",{"data-svelte-h":!0}),i(w)!=="svelte-1o8p9et"&&(w.textContent=xl),el=n(l),c(h.$$.fragment,l),sl=n(l),b=o(l,"P",{"data-svelte-h":!0}),i(b)!=="svelte-1kcnm3r"&&(b.innerHTML=Bl),al=n(l),A=o(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1yiem8x"&&(A.innerHTML=Ql),tl=n(l),f=o(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1ir28gq"&&(f.innerHTML=Wl),nl=n(l),c(C.$$.fragment,l),Ml=n(l),I=o(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1mvdyro"&&(I.innerHTML=_l),ol=n(l),c(g.$$.fragment,l),il=n(l),G=o(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-ivyj94"&&(G.textContent=Rl),pl=n(l),c(v.$$.fragment,l),cl=n(l),$=o(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-1mvdyro"&&($.innerHTML=Fl),dl=n(l),c(k.$$.fragment,l),ul=n(l),q=o(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-hxz5rj"&&(q.textContent=Hl),rl=n(l),Z=o(l,"UL",{"data-svelte-h":!0}),i(Z)!=="svelte-op7a9q"&&(Z.innerHTML=Yl),jl=n(l),E=o(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-ybdd87"&&(E.innerHTML=Sl),ml=n(l),c(x.$$.fragment,l),yl=n(l),B=o(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1mvdyro"&&(B.innerHTML=Nl),Ul=n(l),c(Q.$$.fragment,l),Jl=n(l),W=o(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1v4lcjp"&&(W.innerHTML=zl),Tl=n(l),_=o(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1ufbi3q"&&(_.innerHTML=Xl),wl=n(l),R=o(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-18j6r1l"&&(R.innerHTML=Ll),hl=n(l),c(F.$$.fragment,l),bl=n(l),H=o(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1mvdyro"&&(H.innerHTML=Vl),Al=n(l),c(Y.$$.fragment,l),fl=n(l),S=o(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-ymdrwo"&&(S.innerHTML=Pl),Cl=n(l),c(N.$$.fragment,l),Il=n(l),z=o(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1jx33x4"&&(z.textContent=Dl),gl=n(l),c(X.$$.fragment,l),Gl=n(l),U=o(l,"DIV",{class:!0,"data-svelte-h":!0}),i(U)!=="svelte-1ym6zda"&&(U.innerHTML=Ol),vl=n(l),L=o(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1wmw5cx"&&(L.innerHTML=Kl),$l=n(l),P=o(l,"P",{}),le(P).forEach(s),this.h()},h(){ql(y,"name","hf:doc:metadata"),ql(y,"content",ce),ql(U,"class","flex justify-center")},m(l,e){oe(document.head,y),a(l,D,e),a(l,V,e),a(l,O,e),d(J,l,e),a(l,K,e),a(l,T,e),a(l,ll,e),a(l,w,e),a(l,el,e),d(h,l,e),a(l,sl,e),a(l,b,e),a(l,al,e),a(l,A,e),a(l,tl,e),a(l,f,e),a(l,nl,e),d(C,l,e),a(l,Ml,e),a(l,I,e),a(l,ol,e),d(g,l,e),a(l,il,e),a(l,G,e),a(l,pl,e),d(v,l,e),a(l,cl,e),a(l,$,e),a(l,dl,e),d(k,l,e),a(l,ul,e),a(l,q,e),a(l,rl,e),a(l,Z,e),a(l,jl,e),a(l,E,e),a(l,ml,e),d(x,l,e),a(l,yl,e),a(l,B,e),a(l,Ul,e),d(Q,l,e),a(l,Jl,e),a(l,W,e),a(l,Tl,e),a(l,_,e),a(l,wl,e),a(l,R,e),a(l,hl,e),d(F,l,e),a(l,bl,e),a(l,H,e),a(l,Al,e),d(Y,l,e),a(l,fl,e),a(l,S,e),a(l,Cl,e),d(N,l,e),a(l,Il,e),a(l,z,e),a(l,gl,e),d(X,l,e),a(l,Gl,e),a(l,U,e),a(l,vl,e),a(l,L,e),a(l,$l,e),a(l,P,e),kl=!0},p:se,i(l){kl||(u(J.$$.fragment,l),u(h.$$.fragment,l),u(C.$$.fragment,l),u(g.$$.fragment,l),u(v.$$.fragment,l),u(k.$$.fragment,l),u(x.$$.fragment,l),u(Q.$$.fragment,l),u(F.$$.fragment,l),u(Y.$$.fragment,l),u(N.$$.fragment,l),u(X.$$.fragment,l),kl=!0)},o(l){r(J.$$.fragment,l),r(h.$$.fragment,l),r(C.$$.fragment,l),r(g.$$.fragment,l),r(v.$$.fragment,l),r(k.$$.fragment,l),r(x.$$.fragment,l),r(Q.$$.fragment,l),r(F.$$.fragment,l),r(Y.$$.fragment,l),r(N.$$.fragment,l),r(X.$$.fragment,l),kl=!1},d(l){l&&(s(D),s(V),s(O),s(K),s(T),s(ll),s(w),s(el),s(sl),s(b),s(al),s(A),s(tl),s(f),s(nl),s(Ml),s(I),s(ol),s(il),s(G),s(pl),s(cl),s($),s(dl),s(ul),s(q),s(rl),s(Z),s(jl),s(E),s(ml),s(yl),s(B),s(Ul),s(Jl),s(W),s(Tl),s(_),s(wl),s(R),s(hl),s(bl),s(H),s(Al),s(fl),s(S),s(Cl),s(Il),s(z),s(gl),s(Gl),s(U),s(vl),s(L),s($l),s(P)),s(y),j(J,l),j(h,l),j(C,l),j(g,l),j(v,l),j(k,l),j(x,l),j(Q,l),j(F,l),j(Y,l),j(N,l),j(X,l)}}}const ce='{"title":"Cargar y explorar una base de datos de audio","local":"cargar-y-explorar-una-base-de-datos-de-audio","sections":[],"depth":1}';function de(Zl){return ae(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ye extends te{constructor(y){super(),ne(this,y,de,pe,ee,{})}}export{ye as component};
