import{s as ss,n as ts,o as es}from"../chunks/scheduler.b8dd6794.js";import{S as as,i as Ms,g as n,s as a,r as j,A as ns,h as p,f as t,c as M,j as ls,u as y,x as i,k as Zl,y as ps,a as e,v as o,d as u,t as c,w as m}from"../chunks/index.0a3e3d78.js";import{C as U}from"../chunks/CodeBlock.822b8cc6.js";import{H as is}from"../chunks/Heading.e6dfd430.js";function js(Bl){let r,P,L,O,J,K,T,El=`이 코스에서 우리는 🤗 Datasets 라이브러리를 사용하여 오디오 데이터셋을 다룹니다.🤗 Datasets는 오디오를 포함한 모든 양식의 데이터셋을 다운로드하고 준비할 수 있는 오픈소스 라이브러리입니다.
이 라이브러리는 허깅페이스 허브에서 공개적으로 사용 가능한 머신러닝 데이터셋에 쉽게 접근할 수 있도록 도와줍니다. 무엇보다도, 🤗 Datasets는 연구자와 실무자 모두가 오디오 데이터셋을 쉽게 다룰 수 있도록 만드는 특화 기능들을 여럿 가지고 있습니다.`,ll,w,Ql="시작에 앞서, 🤗 Datasets 라이브러리가 설치돼있는지 확인해주세요:",sl,h,tl,A,Wl="🤗 Datasets의 주된 기능 중 하나는 <code>load_dataset()</code> 파이썬 코드 한줄로 데이터셋을 다운로드하고 준비할 수 있다는것입니다.",el,C,ql='<a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a>라고 하는 오디오 데이터셋을 불러와 다뤄봅시다. 이 데이터셋은 여러 언어와 방언으로 사람들이 인터넷뱅킹에 대해 묻는 내용이 녹음돼있습니다.',al,f,_l="MINDS-14 데이터셋을 불러오기 위해 허브에서의 데이터셋 식별자인 (<code>PolyAI/minds14</code>)를 <code>load_dataset</code> 함수로 넘겨줘야 합니다. 또한 데이터셋의 호주 부분(<code>en-AU</code>)에만 관심이 있고 학습용 데이터에만 관심이 있음을 명시하겠습니다.:",Ml,b,nl,I,xl="<strong>Output:</strong>",pl,k,il,G,Rl="데이터셋은 654개의 오디오 파일로 이뤄져있습니다. 각각의 파일들은 자막, 영어 번역, 그리고 질문자의 의도를 나타내는 레이블(label)이 함께 제공됩니다. 오디오 컬럼(column)에는 원시(raw) 오디오 데이터가 포함되어 있습니다. 예제를 하나 살펴보겠습니다:",jl,$,yl,g,Fl="<strong>Output:</strong>",ol,v,ul,Z,Yl="오디오 컬럼에 여러 feature가 있음을 알 수 있습니다. 각각은 다음과 같습니다:",cl,B,Hl="<li><code>path</code>: 오디오 파일의 경로(이 예제의 경우 <code>*.wav</code>).</li> <li><code>array</code>: 1차원 넘파이 배열로 디코딩된 오디오 데이터.</li> <li><code>sampling_rate</code>: 오디오 파일의 샘플링 속도(이 예제의 경우 8,000 Hz).</li>",ml,E,Sl="<code>intent_class</code>는 오디오 녹음이 어떤 카테고리로 분류되는지 나타냅니다. 이 숫자를 의미있는 문자열로 바꾸려면 <code>int2str()</code> 메소드를 사용하세요:",Ul,Q,rl,W,Nl="<strong>Output:</strong>",dl,q,Jl,_,Xl="<code>transcription</code> feature를 보면 누군가가 청구서를 지불하는 것에 대해 질문하는 녹음의 오디오 파일이란것을 알 수 있습니다.",Tl,x,zl="이 데이터의 부분집합에 대해 오디오 분류기(classifier)를 학습시킬 계획이시라면, 이 모든 feature가 필요하진 않을지도 모릅니다. 예를 들어, <code>lang_id</code>는 모든 예제에서 같은 값을 지니기 때문에 그다지 쓸모 있지 않을겁니다.  <code>english_transcription</code>는 이 호주데이터에선 대부분이 <code>transcription</code>과 같을테니 삭제해도 좋을겁니다.",wl,R,Vl="이런 관계없는 feature는 🤗 Datasets의 <code>remove_columns</code> 메소드를 사용하면 쉽게 제거할 수 있습니다:",hl,F,Al,Y,Ll="<strong>Output:</strong>",Cl,H,fl,S,Dl=`이제 데이터셋의 원시 컨텐츠들을 불러오고 살펴봤으니, 몇개를 들어봅시다!
<code>Gradio</code>의 <code>Blocks</code>와 <code>Audio</code> 기능을 써서 데이터셋의 샘플 몇개를 무작위로 디코딩해보겠습니다:`,bl,N,Il,X,Pl="원하신다면, 예제 몇개를 시각화해보는 것도 좋습니다. 첫번째 예제의 파형을 그려보겠습니다.",kl,z,Gl,d,Ol='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/waveform_unit1.png" alt="Waveform plot"/>',$l,V,Kl='한번 해보세요! MINDS-14 데이터셋의 다른 언어나 방언을 다운로드하여 듣고 시각화를 해보세요. 전체 데이터셋이 어떨지 대략적인 감을 줄겁니다. <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">여기</a>서 가능한 언어들이 무엇인지 확인하실 수 있습니다.',gl,D,vl;return J=new is({props:{title:"오디오 데이터셋 불러오기 및 탐색하기",local:"load-and-explore-an-audio-dataset",headingTag:"h1"}}),h=new U({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTVCYXVkaW8lNUQ=",highlighted:"pip install datasets[audio]",wrap:!1}}),b=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBbWluZHM=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
minds`,wrap:!1}}),k=new U({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmdsaXNoX3RyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5nX2lkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA2NTQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [
            <span class="hljs-string">&quot;path&quot;</span>,
            <span class="hljs-string">&quot;audio&quot;</span>,
            <span class="hljs-string">&quot;transcription&quot;</span>,
            <span class="hljs-string">&quot;english_transcription&quot;</span>,
            <span class="hljs-string">&quot;intent_class&quot;</span>,
            <span class="hljs-string">&quot;lang_id&quot;</span>,
        ],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">654</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),$=new U({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWV4YW1wbGU=",highlighted:`example = minds[<span class="hljs-number">0</span>]
example`,wrap:!1}}),v=new U({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwLjAlMkMlMjAwLjAwMDI0NDE0JTJDJTIwLTAuMDAwMjQ0MTQlMkMlMjAuLi4lMkMlMjAtMC4wMDAyNDQxNCUyQyUyMDAuMDAwMjQ0MTQlMkMlMjAwLjAwMTIyMDclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDgwMDAlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2NyaXB0aW9uJTIyJTNBJTIwJTIySSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwcGF5JTIwbXklMjBlbGVjdHJpY2l0eSUyMGJpbGwlMjB1c2luZyUyMG15JTIwY2FyZCUyMGNhbiUyMHlvdSUyMHBsZWFzZSUyMGFzc2lzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmVuZ2xpc2hfdHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhbmdfaWQlMjIlM0ElMjAyJTJDJTBBJTdE",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [<span class="hljs-number">0.0</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">-0.00024414</span>, ..., <span class="hljs-number">-0.00024414</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">0.0012207</span>],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">8000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;english_transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
    <span class="hljs-comment">&quot;lang_id&quot;</span>: <span class="hljs-number">2</span>,
}`,wrap:!1}}),Q=new U({props:{code:"aWQybGFiZWwlMjAlM0QlMjBtaW5kcy5mZWF0dXJlcyU1QiUyMmludGVudF9jbGFzcyUyMiU1RC5pbnQyc3RyJTBBaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCk=",highlighted:`id2label = minds.features[<span class="hljs-string">&quot;intent_class&quot;</span>].int2str
id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])`,wrap:!1}}),q=new U({props:{code:"JTIycGF5X2JpbGwlMjI=",highlighted:'<span class="hljs-string">&quot;pay_bill&quot;</span>',wrap:!1}}),F=new U({props:{code:"Y29sdW1uc190b19yZW1vdmUlMjAlM0QlMjAlNUIlMjJsYW5nX2lkJTIyJTJDJTIwJTIyZW5nbGlzaF90cmFuc2NyaXB0aW9uJTIyJTVEJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyhjb2x1bW5zX3RvX3JlbW92ZSklMEFtaW5kcw==",highlighted:`columns_to_remove = [<span class="hljs-string">&quot;lang_id&quot;</span>, <span class="hljs-string">&quot;english_transcription&quot;</span>]
minds = minds.remove_columns(columns_to_remove)
minds`,wrap:!1}}),H=new U({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDY1NCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 654})</span>',wrap:!1}}),N=new U({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlX2F1ZGlvKCklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwbWluZHMuc2h1ZmZsZSgpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTJDJTIwaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCklMEElMEElMEF3aXRoJTIwZ3IuQmxvY2tzKCklMjBhcyUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwZ3IuQ29sdW1uKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBfJTIwaW4lMjByYW5nZSg0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTJDJTIwbGFiZWwlMjAlM0QlMjBnZW5lcmF0ZV9hdWRpbygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwZ3IuQXVkaW8oYXVkaW8lMkMlMjBsYWJlbCUzRGxhYmVsKSUwQSUwQWRlbW8ubGF1bmNoKGRlYnVnJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_audio</span>():
    example = minds.shuffle()[<span class="hljs-number">0</span>]
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    <span class="hljs-keyword">return</span> (
        audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        audio[<span class="hljs-string">&quot;array&quot;</span>],
    ), id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    <span class="hljs-keyword">with</span> gr.Column():
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>):
            audio, label = generate_audio()
            output = gr.Audio(audio, label=label)

demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),z=new U({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQWltcG9ydCUyMG1hdHBsb3RsaWIucHlwbG90JTIwYXMlMjBwbHQlMEFpbXBvcnQlMjBsaWJyb3NhLmRpc3BsYXklMEElMEFhcnJheSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMEElMEFwbHQuZmlndXJlKCkuc2V0X2ZpZ3dpZHRoKDEyKSUwQWxpYnJvc2EuZGlzcGxheS53YXZlc2hvdyhhcnJheSUyQyUyMHNyJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">import</span> librosa
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> librosa.display

array = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
sampling_rate = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.waveshow(array, sr=sampling_rate)`,wrap:!1}}),{c(){r=n("meta"),P=a(),L=n("p"),O=a(),j(J.$$.fragment),K=a(),T=n("p"),T.textContent=El,ll=a(),w=n("p"),w.textContent=Ql,sl=a(),j(h.$$.fragment),tl=a(),A=n("p"),A.innerHTML=Wl,el=a(),C=n("p"),C.innerHTML=ql,al=a(),f=n("p"),f.innerHTML=_l,Ml=a(),j(b.$$.fragment),nl=a(),I=n("p"),I.innerHTML=xl,pl=a(),j(k.$$.fragment),il=a(),G=n("p"),G.textContent=Rl,jl=a(),j($.$$.fragment),yl=a(),g=n("p"),g.innerHTML=Fl,ol=a(),j(v.$$.fragment),ul=a(),Z=n("p"),Z.textContent=Yl,cl=a(),B=n("ul"),B.innerHTML=Hl,ml=a(),E=n("p"),E.innerHTML=Sl,Ul=a(),j(Q.$$.fragment),rl=a(),W=n("p"),W.innerHTML=Nl,dl=a(),j(q.$$.fragment),Jl=a(),_=n("p"),_.innerHTML=Xl,Tl=a(),x=n("p"),x.innerHTML=zl,wl=a(),R=n("p"),R.innerHTML=Vl,hl=a(),j(F.$$.fragment),Al=a(),Y=n("p"),Y.innerHTML=Ll,Cl=a(),j(H.$$.fragment),fl=a(),S=n("p"),S.innerHTML=Dl,bl=a(),j(N.$$.fragment),Il=a(),X=n("p"),X.textContent=Pl,kl=a(),j(z.$$.fragment),Gl=a(),d=n("div"),d.innerHTML=Ol,$l=a(),V=n("p"),V.innerHTML=Kl,gl=a(),D=n("p"),this.h()},l(l){const s=ns("svelte-u9bgzb",document.head);r=p(s,"META",{name:!0,content:!0}),s.forEach(t),P=M(l),L=p(l,"P",{}),ls(L).forEach(t),O=M(l),y(J.$$.fragment,l),K=M(l),T=p(l,"P",{"data-svelte-h":!0}),i(T)!=="svelte-18x90bu"&&(T.textContent=El),ll=M(l),w=p(l,"P",{"data-svelte-h":!0}),i(w)!=="svelte-uzdupu"&&(w.textContent=Ql),sl=M(l),y(h.$$.fragment,l),tl=M(l),A=p(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1wm5hs2"&&(A.innerHTML=Wl),el=M(l),C=p(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-14q31j6"&&(C.innerHTML=ql),al=M(l),f=p(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1tpp56k"&&(f.innerHTML=_l),Ml=M(l),y(b.$$.fragment,l),nl=M(l),I=p(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1mvdyro"&&(I.innerHTML=xl),pl=M(l),y(k.$$.fragment,l),il=M(l),G=p(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1cbs7rf"&&(G.textContent=Rl),jl=M(l),y($.$$.fragment,l),yl=M(l),g=p(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1mvdyro"&&(g.innerHTML=Fl),ol=M(l),y(v.$$.fragment,l),ul=M(l),Z=p(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1d02icv"&&(Z.textContent=Yl),cl=M(l),B=p(l,"UL",{"data-svelte-h":!0}),i(B)!=="svelte-dfrof6"&&(B.innerHTML=Hl),ml=M(l),E=p(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-7bttkk"&&(E.innerHTML=Sl),Ul=M(l),y(Q.$$.fragment,l),rl=M(l),W=p(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1mvdyro"&&(W.innerHTML=Nl),dl=M(l),y(q.$$.fragment,l),Jl=M(l),_=p(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-130sq60"&&(_.innerHTML=Xl),Tl=M(l),x=p(l,"P",{"data-svelte-h":!0}),i(x)!=="svelte-1uirimi"&&(x.innerHTML=zl),wl=M(l),R=p(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-fkklyc"&&(R.innerHTML=Vl),hl=M(l),y(F.$$.fragment,l),Al=M(l),Y=p(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1mvdyro"&&(Y.innerHTML=Ll),Cl=M(l),y(H.$$.fragment,l),fl=M(l),S=p(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-lvr4en"&&(S.innerHTML=Dl),bl=M(l),y(N.$$.fragment,l),Il=M(l),X=p(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-8pae74"&&(X.textContent=Pl),kl=M(l),y(z.$$.fragment,l),Gl=M(l),d=p(l,"DIV",{class:!0,"data-svelte-h":!0}),i(d)!=="svelte-1ym6zda"&&(d.innerHTML=Ol),$l=M(l),V=p(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-142ls3y"&&(V.innerHTML=Kl),gl=M(l),D=p(l,"P",{}),ls(D).forEach(t),this.h()},h(){Zl(r,"name","hf:doc:metadata"),Zl(r,"content",ys),Zl(d,"class","flex justify-center")},m(l,s){ps(document.head,r),e(l,P,s),e(l,L,s),e(l,O,s),o(J,l,s),e(l,K,s),e(l,T,s),e(l,ll,s),e(l,w,s),e(l,sl,s),o(h,l,s),e(l,tl,s),e(l,A,s),e(l,el,s),e(l,C,s),e(l,al,s),e(l,f,s),e(l,Ml,s),o(b,l,s),e(l,nl,s),e(l,I,s),e(l,pl,s),o(k,l,s),e(l,il,s),e(l,G,s),e(l,jl,s),o($,l,s),e(l,yl,s),e(l,g,s),e(l,ol,s),o(v,l,s),e(l,ul,s),e(l,Z,s),e(l,cl,s),e(l,B,s),e(l,ml,s),e(l,E,s),e(l,Ul,s),o(Q,l,s),e(l,rl,s),e(l,W,s),e(l,dl,s),o(q,l,s),e(l,Jl,s),e(l,_,s),e(l,Tl,s),e(l,x,s),e(l,wl,s),e(l,R,s),e(l,hl,s),o(F,l,s),e(l,Al,s),e(l,Y,s),e(l,Cl,s),o(H,l,s),e(l,fl,s),e(l,S,s),e(l,bl,s),o(N,l,s),e(l,Il,s),e(l,X,s),e(l,kl,s),o(z,l,s),e(l,Gl,s),e(l,d,s),e(l,$l,s),e(l,V,s),e(l,gl,s),e(l,D,s),vl=!0},p:ts,i(l){vl||(u(J.$$.fragment,l),u(h.$$.fragment,l),u(b.$$.fragment,l),u(k.$$.fragment,l),u($.$$.fragment,l),u(v.$$.fragment,l),u(Q.$$.fragment,l),u(q.$$.fragment,l),u(F.$$.fragment,l),u(H.$$.fragment,l),u(N.$$.fragment,l),u(z.$$.fragment,l),vl=!0)},o(l){c(J.$$.fragment,l),c(h.$$.fragment,l),c(b.$$.fragment,l),c(k.$$.fragment,l),c($.$$.fragment,l),c(v.$$.fragment,l),c(Q.$$.fragment,l),c(q.$$.fragment,l),c(F.$$.fragment,l),c(H.$$.fragment,l),c(N.$$.fragment,l),c(z.$$.fragment,l),vl=!1},d(l){l&&(t(P),t(L),t(O),t(K),t(T),t(ll),t(w),t(sl),t(tl),t(A),t(el),t(C),t(al),t(f),t(Ml),t(nl),t(I),t(pl),t(il),t(G),t(jl),t(yl),t(g),t(ol),t(ul),t(Z),t(cl),t(B),t(ml),t(E),t(Ul),t(rl),t(W),t(dl),t(Jl),t(_),t(Tl),t(x),t(wl),t(R),t(hl),t(Al),t(Y),t(Cl),t(fl),t(S),t(bl),t(Il),t(X),t(kl),t(Gl),t(d),t($l),t(V),t(gl),t(D)),t(r),m(J,l),m(h,l),m(b,l),m(k,l),m($,l),m(v,l),m(Q,l),m(q,l),m(F,l),m(H,l),m(N,l),m(z,l)}}}const ys='{"title":"오디오 데이터셋 불러오기 및 탐색하기","local":"load-and-explore-an-audio-dataset","sections":[],"depth":1}';function os(Bl){return es(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rs extends as{constructor(r){super(),Ms(this,r,os,js,ss,{})}}export{rs as component};
