import{s as Rl,o as Dl,n as no}from"../chunks/scheduler.8c3d61f6.js";import{S as Xl,i as Sl,g as s,s as i,r as p,A as Yl,h as l,f as n,c as a,j as v,u as c,x as d,k as y,y as r,a as o,v as m,d as f,t as u,w as h}from"../chunks/index.da70eac4.js";import{T as ts}from"../chunks/Tip.1d9b8c37.js";import{D as Z}from"../chunks/Docstring.ee4b6913.js";import{C as B}from"../chunks/CodeBlock.00a903b3.js";import{E as ns}from"../chunks/ExampleCodeBlock.f7bd2c1f.js";import{H as w,E as El}from"../chunks/EditOnGithub.1e64e623.js";function Ql(N){let g,T="AnimateDiff tends to work better with finetuned Stable Diffusion models. If you plan on using a scheduler that can clip samples, make sure to disable it by setting <code>clip_sample=False</code> in the scheduler as this can also have an adverse effect on generated samples. Additionally, the AnimateDiff checkpoints can be sensitive to the beta schedule of the scheduler. We recommend setting this to <code>linear</code>.";return{c(){g=s("p"),g.innerHTML=T},l(M){g=l(M,"P",{"data-svelte-h":!0}),d(g)!=="svelte-vnv4xn"&&(g.innerHTML=T)},m(M,b){o(M,g,b)},p:no,d(M){M&&n(g)}}}function Pl(N){let g,T="FreeInit is not really free - the improved quality comes at the cost of extra computation. It requires sampling a few extra times depending on the <code>num_iters</code> parameter that is set when enabling it. Setting the <code>use_fast_sampling</code> parameter to <code>True</code> can improve the overall performance (at the cost of lower quality compared to when <code>use_fast_sampling=False</code> but still better results than vanilla video generation models).";return{c(){g=s("p"),g.innerHTML=T},l(M){g=l(M,"P",{"data-svelte-h":!0}),d(g)!=="svelte-xxwpr5"&&(g.innerHTML=T)},m(M,b){o(M,g,b)},p:no,d(M){M&&n(g)}}}function Ll(N){let g,T='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){g=s("p"),g.innerHTML=T},l(M){g=l(M,"P",{"data-svelte-h":!0}),d(g)!=="svelte-1wmc0l4"&&(g.innerHTML=T)},m(M,b){o(M,g,b)},p:no,d(M){M&&n(g)}}}function Fl(N){let g,T="Examples:",M,b,J;return b=new B({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTW90aW9uQWRhcHRlciUyQyUyMEFuaW1hdGVEaWZmUGlwZWxpbmUlMkMlMjBERElNU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMEElMEFhZGFwdGVyJTIwJTNEJTIwTW90aW9uQWRhcHRlci5mcm9tX3ByZXRyYWluZWQoJTIyZ3VveXd3JTJGYW5pbWF0ZWRpZmYtbW90aW9uLWFkYXB0ZXItdjEtNS0yJTIyKSUwQXBpcGUlMjAlM0QlMjBBbmltYXRlRGlmZlBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJmcmFua2pvc2h1YSUyRnRvb255b3VfYmV0YTYlMjIlMkMlMjBtb3Rpb25fYWRhcHRlciUzRGFkYXB0ZXIpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyKGJldGFfc2NoZWR1bGUlM0QlMjJsaW5lYXIlMjIlMkMlMjBzdGVwc19vZmZzZXQlM0QxJTJDJTIwY2xpcF9zYW1wbGUlM0RGYWxzZSklMEFvdXRwdXQlMjAlM0QlMjBwaXBlKHByb21wdCUzRCUyMkElMjBjb3JnaSUyMHdhbGtpbmclMjBpbiUyMHRoZSUyMHBhcmslMjIpJTBBZnJhbWVzJTIwJTNEJTIwb3V0cHV0LmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fZ2lmKGZyYW1lcyUyQyUyMCUyMmFuaW1hdGlvbi5naWYlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MotionAdapter, AnimateDiffPipeline, DDIMScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-meta">&gt;&gt;&gt; </span>adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AnimateDiffPipeline.from_pretrained(<span class="hljs-string">&quot;frankjoshua/toonyou_beta6&quot;</span>, motion_adapter=adapter)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DDIMScheduler(beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>, steps_offset=<span class="hljs-number">1</span>, clip_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(prompt=<span class="hljs-string">&quot;A corgi walking in the park&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>frames = output.frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),{c(){g=s("p"),g.textContent=T,M=i(),p(b.$$.fragment)},l(_){g=l(_,"P",{"data-svelte-h":!0}),d(g)!=="svelte-kvfsh7"&&(g.textContent=T),M=a(_),c(b.$$.fragment,_)},m(_,j){o(_,g,j),o(_,M,j),m(b,_,j),J=!0},p:no,i(_){J||(f(b.$$.fragment,_),J=!0)},o(_){u(b.$$.fragment,_),J=!1},d(_){_&&(n(g),n(M)),h(b,_)}}}function zl(N){let g,T="Examples:",M,b,J;return b=new B({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffSparseControlNetPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.models <span class="hljs-keyword">import</span> AutoencoderKL, MotionAdapter, SparseControlNetModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.schedulers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif, load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>motion_adapter_id = <span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-3&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet_id = <span class="hljs-string">&quot;guoyww/animatediff-sparsectrl-scribble&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>lora_adapter_id = <span class="hljs-string">&quot;guoyww/animatediff-motion-lora-v1-5-3&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vae_id = <span class="hljs-string">&quot;stabilityai/sd-vae-ft-mse&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>motion_adapter = MotionAdapter.from_pretrained(motion_adapter_id, torch_dtype=torch.float16).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = SparseControlNetModel.from_pretrained(controlnet_id, torch_dtype=torch.float16).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKL.from_pretrained(vae_id, torch_dtype=torch.float16).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = DPMSolverMultistepScheduler.from_pretrained(
<span class="hljs-meta">... </span>    model_id,
<span class="hljs-meta">... </span>    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
<span class="hljs-meta">... </span>    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
<span class="hljs-meta">... </span>    algorithm_type=<span class="hljs-string">&quot;dpmsolver++&quot;</span>,
<span class="hljs-meta">... </span>    use_karras_sigmas=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AnimateDiffSparseControlNetPipeline.from_pretrained(
<span class="hljs-meta">... </span>    model_id,
<span class="hljs-meta">... </span>    motion_adapter=motion_adapter,
<span class="hljs-meta">... </span>    controlnet=controlnet,
<span class="hljs-meta">... </span>    vae=vae,
<span class="hljs-meta">... </span>    scheduler=scheduler,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.load_lora_weights(lora_adapter_id, adapter_name=<span class="hljs-string">&quot;motion_lora&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.fuse_lora(lora_scale=<span class="hljs-number">1.0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;an aerial view of a cyberpunk city, night time, neon lights, masterpiece, high quality&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;low quality, worst quality, letterboxed&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>image_files = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-scribble-1.png&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-scribble-2.png&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-scribble-3.png&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>condition_frame_indices = [<span class="hljs-number">0</span>, <span class="hljs-number">8</span>, <span class="hljs-number">15</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>conditioning_frames = [load_image(img_file) <span class="hljs-keyword">for</span> img_file <span class="hljs-keyword">in</span> image_files]

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">25</span>,
<span class="hljs-meta">... </span>    conditioning_frames=conditioning_frames,
<span class="hljs-meta">... </span>    controlnet_conditioning_scale=<span class="hljs-number">1.0</span>,
<span class="hljs-meta">... </span>    controlnet_frame_indices=condition_frame_indices,
<span class="hljs-meta">... </span>    generator=torch.Generator().manual_seed(<span class="hljs-number">1337</span>),
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_gif(video, <span class="hljs-string">&quot;output.gif&quot;</span>)`,wrap:!1}}),{c(){g=s("p"),g.textContent=T,M=i(),p(b.$$.fragment)},l(_){g=l(_,"P",{"data-svelte-h":!0}),d(g)!=="svelte-kvfsh7"&&(g.textContent=T),M=a(_),c(b.$$.fragment,_)},m(_,j){o(_,g,j),o(_,M,j),m(b,_,j),J=!0},p:no,i(_){J||(f(b.$$.fragment,_),J=!0)},o(_){u(b.$$.fragment,_),J=!1},d(_){_&&(n(g),n(M)),h(b,_)}}}function Hl(N){let g,T="Examples:",M,b,J;return b=new B({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.models <span class="hljs-keyword">import</span> MotionAdapter
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffSDXLPipeline, DDIMScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-meta">&gt;&gt;&gt; </span>adapter = MotionAdapter.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;a-r-r-o-w/animatediff-motion-adapter-sdxl-beta&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = DDIMScheduler.from_pretrained(
<span class="hljs-meta">... </span>    model_id,
<span class="hljs-meta">... </span>    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
<span class="hljs-meta">... </span>    clip_sample=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
<span class="hljs-meta">... </span>    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
<span class="hljs-meta">... </span>    steps_offset=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AnimateDiffSDXLPipeline.from_pretrained(
<span class="hljs-meta">... </span>    model_id,
<span class="hljs-meta">... </span>    motion_adapter=adapter,
<span class="hljs-meta">... </span>    scheduler=scheduler,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># enable memory savings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_vae_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_vae_tiling()

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;a panda surfing in the ocean, realistic, high quality&quot;</span>,
<span class="hljs-meta">... </span>    negative_prompt=<span class="hljs-string">&quot;low quality, worst quality&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">1024</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">1024</span>,
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">16</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>frames = output.frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),{c(){g=s("p"),g.textContent=T,M=i(),p(b.$$.fragment)},l(_){g=l(_,"P",{"data-svelte-h":!0}),d(g)!=="svelte-kvfsh7"&&(g.textContent=T),M=a(_),c(b.$$.fragment,_)},m(_,j){o(_,g,j),o(_,M,j),m(b,_,j),J=!0},p:no,i(_){J||(f(b.$$.fragment,_),J=!0)},o(_){u(b.$$.fragment,_),J=!1},d(_){_&&(n(g),n(M)),h(b,_)}}}function $l(N){let g,T,M,b,J,_,j,io,fe,os='<a href="https://arxiv.org/abs/2307.04725" rel="nofollow">AnimateDiff: Animate Your Personalized Text-to-Image Diffusion Models without Specific Tuning</a> by Yuwei Guo, Ceyuan Yang, Anyi Rao, Yaohui Wang, Yu Qiao, Dahua Lin, Bo Dai.',ao,ue,is="The abstract of the paper is the following:",so,he,as='<em>With the advance of text-to-image models (e.g., Stable Diffusion) and corresponding personalization techniques such as DreamBooth and LoRA, everyone can manifest their imagination into high-quality images at an affordable cost. Subsequently, there is a great demand for image animation techniques to further combine generated static images with motion dynamics. In this report, we propose a practical framework to animate most of the existing personalized text-to-image models once and for all, saving efforts in model-specific tuning. At the core of the proposed framework is to insert a newly initialized motion modeling module into the frozen text-to-image model and train it on video clips to distill reasonable motion priors. Once trained, by simply injecting this motion modeling module, all personalized versions derived from the same base T2I readily become text-driven models that produce diverse and personalized animated images. We conduct our evaluation on several public representative personalized text-to-image models across anime pictures and realistic photographs, and demonstrate that our proposed framework helps these models generate temporally smooth animation clips while preserving the domain and diversity of their outputs. Code and pre-trained weights will be publicly available at <a href="https://animatediff.github.io/" rel="nofollow">this https URL</a>.</em>',lo,ge,ro,_e,ss='<thead><tr><th>Pipeline</th> <th>Tasks</th> <th align="center">Demo</th></tr></thead> <tbody><tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py" rel="nofollow">AnimateDiffPipeline</a></td> <td><em>Text-to-Video Generation with AnimateDiff</em></td> <td align="center"></td></tr> <tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_controlnet.py" rel="nofollow">AnimateDiffControlNetPipeline</a></td> <td><em>Controlled Video-to-Video Generation with AnimateDiff using ControlNet</em></td> <td align="center"></td></tr> <tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_sparsectrl.py" rel="nofollow">AnimateDiffSparseControlNetPipeline</a></td> <td><em>Controlled Video-to-Video Generation with AnimateDiff using SparseCtrl</em></td> <td align="center"></td></tr> <tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_sdxl.py" rel="nofollow">AnimateDiffSDXLPipeline</a></td> <td><em>Video-to-Video Generation with AnimateDiff</em></td> <td align="center"></td></tr> <tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_video2video.py" rel="nofollow">AnimateDiffVideoToVideoPipeline</a></td> <td><em>Video-to-Video Generation with AnimateDiff</em></td> <td align="center"></td></tr> <tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_video2video_controlnet.py" rel="nofollow">AnimateDiffVideoToVideoControlNetPipeline</a></td> <td><em>Video-to-Video Generation with AnimateDiff using ControlNet</em></td> <td align="center"></td></tr></tbody>',po,Me,co,be,ls='Motion Adapter checkpoints can be found under <a href="https://huggingface.co/guoyww/" rel="nofollow">guoyww</a>. These checkpoints are meant to work with any model based on Stable Diffusion 1.4/1.5.',mo,ye,fo,we,uo,Te,rs="AnimateDiff works with a MotionAdapter checkpoint and a Stable Diffusion model checkpoint. The MotionAdapter is a collection of Motion Modules that are responsible for adding coherent motion across image frames. These modules are applied after the Resnet and Attention blocks in Stable Diffusion UNet.",ho,Je,ds="The following example demonstrates how to use a <em>MotionAdapter</em> checkpoint with Diffusers for inference based on StableDiffusion-1.4/1.5.",go,ve,_o,Ue,ps="Here are some sample outputs:",Mo,Ze,cs=`<tbody><tr><td><center>masterpiece, bestquality, sunset.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-realistic-doc.gif" alt="masterpiece, bestquality, sunset" style="width: 300px;"/></center></td></tr></tbody>`,bo,$,yo,je,wo,Ie,ms='AnimateDiff can also be used with ControlNets ControlNet was introduced in <a href="https://huggingface.co/papers/2302.05543" rel="nofollow">Adding Conditional Control to Text-to-Image Diffusion Models</a> by Lvmin Zhang, Anyi Rao, and Maneesh Agrawala. With a ControlNet model, you can provide an additional control image to condition and control Stable Diffusion generation. For example, if you provide depth maps, the ControlNet model generates a video that’ll preserve the spatial information from the depth maps. It is a more flexible and accurate way to control the video generation process.',To,Ce,Jo,Ge,fs="Here are some sample outputs:",vo,q,us=`<tbody><tr><th align="center">Source Video</th> <th align="center">Output Video</th></tr> <tr><td align="center">raccoon playing a guitar
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-vid2vid-input-1.gif" alt="racoon playing a guitar"/></td> <td align="center">a panda, playing a guitar, sitting in a pink boat, in the ocean, mountains in background, realistic, high quality
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-controlnet-output.gif" alt="a panda, playing a guitar, sitting in a pink boat, in the ocean, mountains in background, realistic, high quality"/></td></tr></tbody>`,Uo,We,Zo,xe,hs='<a href="https://arxiv.org/abs/2311.16933" rel="nofollow">SparseCtrl: Adding Sparse Controls to Text-to-Video Diffusion Models</a> for achieving controlled generation in text-to-video diffusion models by Yuwei Guo, Ceyuan Yang, Anyi Rao, Maneesh Agrawala, Dahua Lin, and Bo Dai.',jo,Ve,gs="The abstract from the paper is:",Io,ke,_s='<em>The development of text-to-video (T2V), i.e., generating videos with a given text prompt, has been significantly advanced in recent years. However, relying solely on text prompts often results in ambiguous frame composition due to spatial uncertainty. The research community thus leverages the dense structure signals, e.g., per-frame depth/edge sequences, to enhance controllability, whose collection accordingly increases the burden of inference. In this work, we present SparseCtrl to enable flexible structure control with temporally sparse signals, requiring only one or a few inputs, as shown in Figure 1. It incorporates an additional condition encoder to process these sparse signals while leaving the pre-trained T2V model untouched. The proposed approach is compatible with various modalities, including sketches, depth maps, and RGB images, providing more practical control for video generation and promoting applications such as storyboarding, depth rendering, keyframe animation, and interpolation. Extensive experiments demonstrate the generalization of SparseCtrl on both original and personalized T2V generators. Codes and models will be publicly available at <a href="https://guoyww.github.io/projects/SparseCtrl" rel="nofollow">this https URL</a>.</em>',Co,Be,Ms="SparseCtrl introduces the following checkpoints for controlled text-to-video generation:",Go,Ae,bs='<li><a href="https://huggingface.co/guoyww/animatediff-sparsectrl-scribble" rel="nofollow">SparseCtrl Scribble</a></li> <li><a href="https://huggingface.co/guoyww/animatediff-sparsectrl-rgb" rel="nofollow">SparseCtrl RGB</a></li>',Wo,Ne,xo,Re,Vo,De,ys="Here are some sample outputs:",ko,Xe,ws="<b>an aerial view of a cyberpunk city, night time, neon lights, masterpiece, high quality</b> ",O,Ts='<tbody><tr></tr> <tr><td><center><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-scribble-1.png" alt="scribble-1"/></center></td> <td><center><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-scribble-2.png" alt="scribble-2"/></center></td> <td><center><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-scribble-3.png" alt="scribble-3"/></center></td></tr> <tr><td colspan="3"><center><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-sparsectrl-scribble-results.gif" alt="an aerial view of a cyberpunk city, night time, neon lights, masterpiece, high quality"/></center></td></tr></tbody>',Bo,Se,Ao,Ye,No,Ee,Js="Here are some sample outputs:",Ro,Qe,vs="<b>closeup face photo of man in black clothes, night city street, bokeh, fireworks in background</b> ",K,Us='<tbody><tr></tr> <tr><td><center><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-firework.png" alt="closeup face photo of man in black clothes, night city street, bokeh, fireworks in background"/></center></td> <td><center><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-sparsectrl-rgb-result.gif" alt="closeup face photo of man in black clothes, night city street, bokeh, fireworks in background"/></center></td></tr></tbody>',Do,Pe,Xo,Le,Zs="AnimateDiff can also be used with SDXL models. This is currently an experimental feature as only a beta release of the motion adapter checkpoint is available.",So,Fe,Yo,ze,Eo,He,js="AnimateDiff can also be used to generate visually similar videos or enable style/character/background or other edits starting from an initial video, allowing you to seamlessly explore creative possibilities.",Qo,$e,Po,qe,Is="Here are some sample outputs:",Lo,Oe,Cs=`<tbody><tr><th align="center">Source Video</th> <th align="center">Output Video</th></tr> <tr><td align="center">raccoon playing a guitar
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-vid2vid-input-1.gif" alt="racoon playing a guitar" style="width: 300px;"/></td> <td align="center">panda playing a guitar
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-vid2vid-output-1.gif" alt="panda playing a guitar" style="width: 300px;"/></td></tr> <tr><td align="center">closeup of margot robbie, fireworks in the background, high quality
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-vid2vid-input-2.gif" alt="closeup of margot robbie, fireworks in the background, high quality" style="width: 300px;"/></td> <td align="center">closeup of tony stark, robert downey jr, fireworks
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-vid2vid-output-2.gif" alt="closeup of tony stark, robert downey jr, fireworks" style="width: 300px;"/></td></tr></tbody>`,Fo,Ke,zo,et,Gs='AnimateDiff can be used together with ControlNets to enhance video-to-video generation by allowing for precise control over the output. ControlNet was introduced in <a href="https://huggingface.co/papers/2302.05543" rel="nofollow">Adding Conditional Control to Text-to-Image Diffusion Models</a> by Lvmin Zhang, Anyi Rao, and Maneesh Agrawala, and allows you to condition Stable Diffusion with an additional control image to ensure that the spatial information is preserved throughout the video.',Ho,tt,Ws="This pipeline allows you to condition your generation both on the original video and on a sequence of control images.",$o,nt,qo,ot,xs="Here are some sample outputs:",Oo,ee,Vs=`<tbody><tr><th align="center">Source Video</th> <th align="center">Output Video</th></tr> <tr><td align="center">anime girl, dancing
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/dance.gif" alt="anime girl, dancing"/></td> <td align="center">astronaut in space, dancing
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff_vid2vid_controlnet.gif" alt="astronaut in space, dancing"/></td></tr></tbody>`,Ko,it,ks="<strong>The lights and composition were transferred from the Source Video.</strong>",ei,at,ti,st,Bs="Motion LoRAs are a collection of LoRAs that work with the <code>guoyww/animatediff-motion-adapter-v1-5-2</code> checkpoint. These LoRAs are responsible for adding specific types of motion to the animations.",ni,lt,oi,rt,As=`<tbody><tr><td><center>masterpiece, bestquality, sunset.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-zoom-out-lora.gif" alt="masterpiece, bestquality, sunset" style="width: 300px;"/></center></td></tr></tbody>`,ii,dt,ai,pt,Ns='You can also leverage the <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT</a> backend to combine Motion LoRA’s and create more complex animations.',si,ct,Rs="First install PEFT with",li,mt,ri,ft,Ds="Then you can use the following code to combine Motion LoRAs.",di,ut,pi,ht,Xs=`<tbody><tr><td><center>masterpiece, bestquality, sunset.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-zoom-out-pan-left-lora.gif" alt="masterpiece, bestquality, sunset" style="width: 300px;"/></center></td></tr></tbody>`,ci,gt,mi,_t,Ss='<a href="https://arxiv.org/abs/2312.07537" rel="nofollow">FreeInit: Bridging Initialization Gap in Video Diffusion Models</a> by Tianxing Wu, Chenyang Si, Yuming Jiang, Ziqi Huang, Ziwei Liu.',fi,Mt,Ys="FreeInit is an effective method that improves temporal consistency and overall quality of videos generated using video-diffusion-models without any addition training. It can be applied to AnimateDiff, ModelScope, VideoCrafter and various other video generation models seamlessly at inference time, and works by iteratively refining the latent-initialization noise. More details can be found it the paper.",ui,bt,Es="The following example demonstrates the usage of FreeInit.",hi,yt,gi,te,_i,ne,Mi,wt,Qs=`<tbody><tr><th align="center">Without FreeInit enabled</th> <th align="center">With FreeInit enabled</th></tr> <tr><td align="center">panda playing a guitar
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-no-freeinit.gif" alt="panda playing a guitar" style="width: 300px;"/></td> <td align="center">panda playing a guitar
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-freeinit.gif" alt="panda playing a guitar" style="width: 300px;"/></td></tr></tbody>`,bi,Tt,yi,Jt,Ps='<a href="https://animatelcm.github.io/" rel="nofollow">AnimateLCM</a> is a motion module checkpoint and an <a href="https://huggingface.co/docs/diffusers/using-diffusers/inference_with_lcm_lora" rel="nofollow">LCM LoRA</a> that have been created using a consistency learning strategy that decouples the distillation of the image generation priors and the motion generation priors.',wi,vt,Ti,Ut,Ls=`<tbody><tr><td><center>A space rocket, 4K.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatelcm-output.gif" alt="A space rocket, 4K" style="width: 300px;"/></center></td></tr></tbody>`,Ji,Zt,Fs='AnimateLCM is also compatible with existing <a href="https://huggingface.co/collections/dn6/animatediff-motion-loras-654cb8ad732b9e3cf4d3c17e" rel="nofollow">Motion LoRAs</a>.',vi,jt,Ui,It,zs=`<tbody><tr><td><center>A space rocket, 4K.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatelcm-motion-lora.gif" alt="A space rocket, 4K" style="width: 300px;"/></center></td></tr></tbody>`,Zi,Ct,ji,Gt,Hs="<code>diffusers&gt;=0.30.0</code> supports loading the AnimateDiff checkpoints into the <code>MotionAdapter</code> in their original format via <code>from_single_file</code>",Ii,Wt,Ci,xt,Gi,I,Vt,qi,dn,$s="Pipeline for text-to-video generation.",Oi,pn,qs=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Ki,cn,Os="The pipeline also inherits the following loading methods:",ea,mn,Ks='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',ta,Y,kt,na,fn,el="The call function to the pipeline for generation.",oa,oe,ia,ie,Bt,aa,un,tl="Encodes the prompt into text encoder hidden states.",Wi,At,xi,C,Nt,sa,hn,nl="Pipeline for text-to-video generation with ControlNet guidance.",la,gn,ol=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,ra,_n,il="The pipeline also inherits the following loading methods:",da,Mn,al='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',pa,E,Rt,ca,bn,sl="The call function to the pipeline for generation.",ma,yn,ll="Examples:",fa,ae,Dt,ua,wn,rl="Encodes the prompt into text encoder hidden states.",Vi,Xt,ki,G,St,ha,Tn,dl=`Pipeline for controlled text-to-video generation using the method described in <a href="https://arxiv.org/abs/2311.16933" rel="nofollow">SparseCtrl: Adding Sparse Controls
to Text-to-Video Diffusion Models</a>.`,ga,Jn,pl=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,_a,vn,cl="The pipeline also inherits the following loading methods:",Ma,Un,ml='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',ba,Q,Yt,ya,Zn,fl="The call function to the pipeline for generation.",wa,se,Ta,le,Et,Ja,jn,ul="Encodes the prompt into text encoder hidden states.",Bi,Qt,Ai,U,Pt,va,In,hl="Pipeline for text-to-video generation using Stable Diffusion XL.",Ua,Cn,gl=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Za,Gn,_l="The pipeline also inherits the following loading methods:",ja,Wn,Ml='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',Ia,P,Lt,Ca,xn,bl="Function invoked when calling the pipeline for generation.",Ga,re,Wa,de,Ft,xa,Vn,yl="Encodes the prompt into text encoder hidden states.",Va,pe,zt,ka,kn,wl='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',Ni,Ht,Ri,W,$t,Ba,Bn,Tl="Pipeline for video-to-video generation.",Aa,An,Jl=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Na,Nn,vl="The pipeline also inherits the following loading methods:",Ra,Rn,Ul='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',Da,L,qt,Xa,Dn,Zl="The call function to the pipeline for generation.",Sa,Xn,jl="Examples:",Ya,ce,Ot,Ea,Sn,Il="Encodes the prompt into text encoder hidden states.",Di,Kt,Xi,x,en,Qa,Yn,Cl="Pipeline for video-to-video generation with ControlNet guidance.",Pa,En,Gl=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,La,Qn,Wl="The pipeline also inherits the following loading methods:",Fa,Pn,xl='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',za,F,tn,Ha,Ln,Vl="The call function to the pipeline for generation.",$a,Fn,kl="Examples:",qa,me,nn,Oa,zn,Bl="Encodes the prompt into text encoder hidden states.",Si,on,Yi,S,an,Ka,Hn,Al="Output class for AnimateDiff pipelines.",es,$n,Nl=`PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>`,Ei,sn,Qi,oo,Pi;return J=new w({props:{title:"Text-to-Video Generation with AnimateDiff",local:"text-to-video-generation-with-animatediff",headingTag:"h1"}}),j=new w({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ge=new w({props:{title:"Available Pipelines",local:"available-pipelines",headingTag:"h2"}}),Me=new w({props:{title:"Available checkpoints",local:"available-checkpoints",headingTag:"h2"}}),ye=new w({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),we=new w({props:{title:"AnimateDiffPipeline",local:"animatediffpipeline",headingTag:"h3"}}),ve=new B({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-comment"># Load the motion adapter</span>
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-comment"># load SD 1.5 based finetuned model</span>
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffPipeline.from_pretrained(model_id, motion_adapter=adapter, torch_dtype=torch.float16)
scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipe.scheduler = scheduler

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

output = pipe(
    prompt=(
        <span class="hljs-string">&quot;masterpiece, bestquality, highlydetailed, ultradetailed, sunset, &quot;</span>
        <span class="hljs-string">&quot;orange sky, warm lighting, fishing boats, ocean waves seagulls, &quot;</span>
        <span class="hljs-string">&quot;rippling water, wharf, silhouette, serene atmosphere, dusk, evening glow, &quot;</span>
        <span class="hljs-string">&quot;golden hour, coastal landscape, seaside scenery&quot;</span>
    ),
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),$=new ts({props:{$$slots:{default:[Ql]},$$scope:{ctx:N}}}),je=new w({props:{title:"AnimateDiffControlNetPipeline",local:"animatediffcontrolnetpipeline",headingTag:"h3"}}),Ce=new B({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffControlNetPipeline, AutoencoderKL, ControlNetModel, MotionAdapter, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif, load_video

<span class="hljs-comment"># Additionally, you will need a preprocess videos before they can be used with the ControlNet</span>
<span class="hljs-comment"># HF maintains just the right package for it: \`pip install controlnet_aux\`</span>
<span class="hljs-keyword">from</span> controlnet_aux.processor <span class="hljs-keyword">import</span> ZoeDetector

<span class="hljs-comment"># Download controlnets from https://huggingface.co/lllyasviel/ControlNet-v1-1 to use .from_single_file</span>
<span class="hljs-comment"># Download Diffusers-format controlnets, such as https://huggingface.co/lllyasviel/sd-controlnet-depth, to use .from_pretrained()</span>
controlnet = ControlNetModel.from_single_file(<span class="hljs-string">&quot;control_v11f1p_sd15_depth.pth&quot;</span>, torch_dtype=torch.float16)

<span class="hljs-comment"># We use AnimateLCM for this example but one can use the original motion adapters as well (for example, https://huggingface.co/guoyww/animatediff-motion-adapter-v1-5-3)</span>
motion_adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;wangfuyun/AnimateLCM&quot;</span>)

vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;stabilityai/sd-vae-ft-mse&quot;</span>, torch_dtype=torch.float16)
pipe: AnimateDiffControlNetPipeline = AnimateDiffControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>,
    motion_adapter=motion_adapter,
    controlnet=controlnet,
    vae=vae,
).to(device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config, beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>)
pipe.load_lora_weights(<span class="hljs-string">&quot;wangfuyun/AnimateLCM&quot;</span>, weight_name=<span class="hljs-string">&quot;AnimateLCM_sd15_t2v_lora.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;lcm-lora&quot;</span>)
pipe.set_adapters([<span class="hljs-string">&quot;lcm-lora&quot;</span>], [<span class="hljs-number">0.8</span>])

depth_detector = ZoeDetector.from_pretrained(<span class="hljs-string">&quot;lllyasviel/Annotators&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
video = load_video(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-vid2vid-input-1.gif&quot;</span>)
conditioning_frames = []

<span class="hljs-keyword">with</span> pipe.progress_bar(total=<span class="hljs-built_in">len</span>(video)) <span class="hljs-keyword">as</span> progress_bar:
    <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> video:
        conditioning_frames.append(depth_detector(frame))
        progress_bar.update()

prompt = <span class="hljs-string">&quot;a panda, playing a guitar, sitting in a pink boat, in the ocean, mountains in background, realistic, high quality&quot;</span>
negative_prompt = <span class="hljs-string">&quot;bad quality, worst quality&quot;</span>

video = pipe(
    prompt=prompt,
    negative_prompt=negative_prompt,
    num_frames=<span class="hljs-built_in">len</span>(video),
    num_inference_steps=<span class="hljs-number">10</span>,
    guidance_scale=<span class="hljs-number">2.0</span>,
    conditioning_frames=conditioning_frames,
    generator=torch.Generator().manual_seed(<span class="hljs-number">42</span>),
).frames[<span class="hljs-number">0</span>]

export_to_gif(video, <span class="hljs-string">&quot;animatediff_controlnet.gif&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),We=new w({props:{title:"AnimateDiffSparseControlNetPipeline",local:"animatediffsparsecontrolnetpipeline",headingTag:"h3"}}),Ne=new w({props:{title:"Using SparseCtrl Scribble",local:"using-sparsectrl-scribble",headingTag:"h4"}}),Re=new B({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffSparseControlNetPipeline
<span class="hljs-keyword">from</span> diffusers.models <span class="hljs-keyword">import</span> AutoencoderKL, MotionAdapter, SparseControlNetModel
<span class="hljs-keyword">from</span> diffusers.schedulers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif, load_image


model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
motion_adapter_id = <span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-3&quot;</span>
controlnet_id = <span class="hljs-string">&quot;guoyww/animatediff-sparsectrl-scribble&quot;</span>
lora_adapter_id = <span class="hljs-string">&quot;guoyww/animatediff-motion-lora-v1-5-3&quot;</span>
vae_id = <span class="hljs-string">&quot;stabilityai/sd-vae-ft-mse&quot;</span>
device = <span class="hljs-string">&quot;cuda&quot;</span>

motion_adapter = MotionAdapter.from_pretrained(motion_adapter_id, torch_dtype=torch.float16).to(device)
controlnet = SparseControlNetModel.from_pretrained(controlnet_id, torch_dtype=torch.float16).to(device)
vae = AutoencoderKL.from_pretrained(vae_id, torch_dtype=torch.float16).to(device)
scheduler = DPMSolverMultistepScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    algorithm_type=<span class="hljs-string">&quot;dpmsolver++&quot;</span>,
    use_karras_sigmas=<span class="hljs-literal">True</span>,
)
pipe = AnimateDiffSparseControlNetPipeline.from_pretrained(
    model_id,
    motion_adapter=motion_adapter,
    controlnet=controlnet,
    vae=vae,
    scheduler=scheduler,
    torch_dtype=torch.float16,
).to(device)
pipe.load_lora_weights(lora_adapter_id, adapter_name=<span class="hljs-string">&quot;motion_lora&quot;</span>)
pipe.fuse_lora(lora_scale=<span class="hljs-number">1.0</span>)

prompt = <span class="hljs-string">&quot;an aerial view of a cyberpunk city, night time, neon lights, masterpiece, high quality&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, worst quality, letterboxed&quot;</span>

image_files = [
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-scribble-1.png&quot;</span>,
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-scribble-2.png&quot;</span>,
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-scribble-3.png&quot;</span>
]
condition_frame_indices = [<span class="hljs-number">0</span>, <span class="hljs-number">8</span>, <span class="hljs-number">15</span>]
conditioning_frames = [load_image(img_file) <span class="hljs-keyword">for</span> img_file <span class="hljs-keyword">in</span> image_files]

video = pipe(
    prompt=prompt,
    negative_prompt=negative_prompt,
    num_inference_steps=<span class="hljs-number">25</span>,
    conditioning_frames=conditioning_frames,
    controlnet_conditioning_scale=<span class="hljs-number">1.0</span>,
    controlnet_frame_indices=condition_frame_indices,
    generator=torch.Generator().manual_seed(<span class="hljs-number">1337</span>),
).frames[<span class="hljs-number">0</span>]
export_to_gif(video, <span class="hljs-string">&quot;output.gif&quot;</span>)`,wrap:!1}}),Se=new w({props:{title:"Using SparseCtrl RGB",local:"using-sparsectrl-rgb",headingTag:"h4"}}),Ye=new B({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffSparseControlNetPipeline
<span class="hljs-keyword">from</span> diffusers.models <span class="hljs-keyword">import</span> AutoencoderKL, MotionAdapter, SparseControlNetModel
<span class="hljs-keyword">from</span> diffusers.schedulers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif, load_image


model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
motion_adapter_id = <span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-3&quot;</span>
controlnet_id = <span class="hljs-string">&quot;guoyww/animatediff-sparsectrl-rgb&quot;</span>
lora_adapter_id = <span class="hljs-string">&quot;guoyww/animatediff-motion-lora-v1-5-3&quot;</span>
vae_id = <span class="hljs-string">&quot;stabilityai/sd-vae-ft-mse&quot;</span>
device = <span class="hljs-string">&quot;cuda&quot;</span>

motion_adapter = MotionAdapter.from_pretrained(motion_adapter_id, torch_dtype=torch.float16).to(device)
controlnet = SparseControlNetModel.from_pretrained(controlnet_id, torch_dtype=torch.float16).to(device)
vae = AutoencoderKL.from_pretrained(vae_id, torch_dtype=torch.float16).to(device)
scheduler = DPMSolverMultistepScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    algorithm_type=<span class="hljs-string">&quot;dpmsolver++&quot;</span>,
    use_karras_sigmas=<span class="hljs-literal">True</span>,
)
pipe = AnimateDiffSparseControlNetPipeline.from_pretrained(
    model_id,
    motion_adapter=motion_adapter,
    controlnet=controlnet,
    vae=vae,
    scheduler=scheduler,
    torch_dtype=torch.float16,
).to(device)
pipe.load_lora_weights(lora_adapter_id, adapter_name=<span class="hljs-string">&quot;motion_lora&quot;</span>)

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-firework.png&quot;</span>)

video = pipe(
    prompt=<span class="hljs-string">&quot;closeup face photo of man in black clothes, night city street, bokeh, fireworks in background&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;low quality, worst quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    conditioning_frames=image,
    controlnet_frame_indices=[<span class="hljs-number">0</span>],
    controlnet_conditioning_scale=<span class="hljs-number">1.0</span>,
    generator=torch.Generator().manual_seed(<span class="hljs-number">42</span>),
).frames[<span class="hljs-number">0</span>]
export_to_gif(video, <span class="hljs-string">&quot;output.gif&quot;</span>)`,wrap:!1}}),Pe=new w({props:{title:"AnimateDiffSDXLPipeline",local:"animatediffsdxlpipeline",headingTag:"h3"}}),Fe=new B({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLm1vZGVscyUyMGltcG9ydCUyME1vdGlvbkFkYXB0ZXIlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQW5pbWF0ZURpZmZTRFhMUGlwZWxpbmUlMkMlMjBERElNU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMEElMEFhZGFwdGVyJTIwJTNEJTIwTW90aW9uQWRhcHRlci5mcm9tX3ByZXRyYWluZWQoJTIyZ3VveXd3JTJGYW5pbWF0ZWRpZmYtbW90aW9uLWFkYXB0ZXItc2R4bC1iZXRhJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBjbGlwX3NhbXBsZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwdGltZXN0ZXBfc3BhY2luZyUzRCUyMmxpbnNwYWNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwYmV0YV9zY2hlZHVsZSUzRCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMHN0ZXBzX29mZnNldCUzRDElMkMlMEEpJTBBcGlwZSUyMCUzRCUyMEFuaW1hdGVEaWZmU0RYTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMG1vdGlvbl9hZGFwdGVyJTNEYWRhcHRlciUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUzRHNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMGVuYWJsZSUyMG1lbW9yeSUyMHNhdmluZ3MlMEFwaXBlLmVuYWJsZV92YWVfc2xpY2luZygpJTBBcGlwZS5lbmFibGVfdmFlX3RpbGluZygpJTBBJTBBb3V0cHV0JTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJhJTIwcGFuZGElMjBzdXJmaW5nJTIwaW4lMjB0aGUlMjBvY2VhbiUyQyUyMHJlYWxpc3RpYyUyQyUyMGhpZ2glMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIybG93JTIwcXVhbGl0eSUyQyUyMHdvcnN0JTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMTYlMkMlMEEpJTBBJTBBZnJhbWVzJTIwJTNEJTIwb3V0cHV0LmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fZ2lmKGZyYW1lcyUyQyUyMCUyMmFuaW1hdGlvbi5naWYlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.models <span class="hljs-keyword">import</span> MotionAdapter
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffSDXLPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-sdxl-beta&quot;</span>, torch_dtype=torch.float16)

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipe = AnimateDiffSDXLPipeline.from_pretrained(
    model_id,
    motion_adapter=adapter,
    scheduler=scheduler,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_vae_tiling()

output = pipe(
    prompt=<span class="hljs-string">&quot;a panda surfing in the ocean, realistic, high quality&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;low quality, worst quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">20</span>,
    guidance_scale=<span class="hljs-number">8</span>,
    width=<span class="hljs-number">1024</span>,
    height=<span class="hljs-number">1024</span>,
    num_frames=<span class="hljs-number">16</span>,
)

frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),ze=new w({props:{title:"AnimateDiffVideoToVideoPipeline",local:"animatediffvideotovideopipeline",headingTag:"h3"}}),$e=new B({props:{code:"aW1wb3J0JTIwaW1hZ2VpbyUwQWltcG9ydCUyMHJlcXVlc3RzJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQW5pbWF0ZURpZmZWaWRlb1RvVmlkZW9QaXBlbGluZSUyQyUyMERESU1TY2hlZHVsZXIlMkMlMjBNb3Rpb25BZGFwdGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBJTIzJTIwTG9hZCUyMHRoZSUyMG1vdGlvbiUyMGFkYXB0ZXIlMEFhZGFwdGVyJTIwJTNEJTIwTW90aW9uQWRhcHRlci5mcm9tX3ByZXRyYWluZWQoJTIyZ3VveXd3JTJGYW5pbWF0ZWRpZmYtbW90aW9uLWFkYXB0ZXItdjEtNS0yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUyMyUyMGxvYWQlMjBTRCUyMDEuNSUyMGJhc2VkJTIwZmluZXR1bmVkJTIwbW9kZWwlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMlNHMTYxMjIyJTJGUmVhbGlzdGljX1Zpc2lvbl9WNS4xX25vVkFFJTIyJTBBcGlwZSUyMCUzRCUyMEFuaW1hdGVEaWZmVmlkZW9Ub1ZpZGVvUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwbW90aW9uX2FkYXB0ZXIlM0RhZGFwdGVyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXNjaGVkdWxlciUyMCUzRCUyMERESU1TY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwY2xpcF9zYW1wbGUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHRpbWVzdGVwX3NwYWNpbmclM0QlMjJsaW5zcGFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGJldGFfc2NoZWR1bGUlM0QlMjJsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjBzdGVwc19vZmZzZXQlM0QxJTJDJTBBKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwc2NoZWR1bGVyJTBBJTBBJTIzJTIwZW5hYmxlJTIwbWVtb3J5JTIwc2F2aW5ncyUwQXBpcGUuZW5hYmxlX3ZhZV9zbGljaW5nKCklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBJTIzJTIwaGVscGVyJTIwZnVuY3Rpb24lMjB0byUyMGxvYWQlMjB2aWRlb3MlMEFkZWYlMjBsb2FkX3ZpZGVvKGZpbGVfcGF0aCUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUIlNUQlMEElMEElMjAlMjAlMjAlMjBpZiUyMGZpbGVfcGF0aC5zdGFydHN3aXRoKCgnaHR0cCUzQSUyRiUyRiclMkMlMjAnaHR0cHMlM0ElMkYlMkYnKSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBJZiUyMHRoZSUyMGZpbGVfcGF0aCUyMGlzJTIwYSUyMFVSTCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KGZpbGVfcGF0aCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZS5yYWlzZV9mb3Jfc3RhdHVzKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb250ZW50JTIwJTNEJTIwQnl0ZXNJTyhyZXNwb25zZS5jb250ZW50KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZpZCUyMCUzRCUyMGltYWdlaW8uZ2V0X3JlYWRlcihjb250ZW50KSUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBBc3N1bWluZyUyMGl0J3MlMjBhJTIwbG9jYWwlMjBmaWxlJTIwcGF0aCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZpZCUyMCUzRCUyMGltYWdlaW8uZ2V0X3JlYWRlcihmaWxlX3BhdGgpJTBBJTBBJTIwJTIwJTIwJTIwZm9yJTIwZnJhbWUlMjBpbiUyMHZpZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBpbF9pbWFnZSUyMCUzRCUyMEltYWdlLmZyb21hcnJheShmcmFtZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZXMuYXBwZW5kKHBpbF9pbWFnZSklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbWFnZXMlMEElMEF2aWRlbyUyMCUzRCUyMGxvYWRfdmlkZW8oJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGYW5pbWF0ZWRpZmYtdmlkMnZpZC1pbnB1dC0xLmdpZiUyMiklMEElMEFvdXRwdXQlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHZpZGVvJTIwJTNEJTIwdmlkZW8lMkMlMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJwYW5kYSUyMHBsYXlpbmclMjBhJTIwZ3VpdGFyJTJDJTIwb24lMjBhJTIwYm9hdCUyQyUyMGluJTIwdGhlJTIwb2NlYW4lMkMlMjBoaWdoJTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmJhZCUyMHF1YWxpdHklMkMlMjB3b3JzZSUyMHF1YWxpdHklMjIlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuNSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSUyQyUwQSUyMCUyMCUyMCUyMHN0cmVuZ3RoJTNEMC41JTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEdG9yY2guR2VuZXJhdG9yKCUyMmNwdSUyMikubWFudWFsX3NlZWQoNDIpJTJDJTBBKSUwQWZyYW1lcyUyMCUzRCUyMG91dHB1dC5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX2dpZihmcmFtZXMlMkMlMjAlMjJhbmltYXRpb24uZ2lmJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> imageio
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffVideoToVideoPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-comment"># Load the motion adapter</span>
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-comment"># load SD 1.5 based finetuned model</span>
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffVideoToVideoPipeline.from_pretrained(model_id, motion_adapter=adapter, torch_dtype=torch.float16)
scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipe.scheduler = scheduler

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># helper function to load videos</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">load_video</span>(<span class="hljs-params">file_path: <span class="hljs-built_in">str</span></span>):
    images = []

    <span class="hljs-keyword">if</span> file_path.startswith((<span class="hljs-string">&#x27;http://&#x27;</span>, <span class="hljs-string">&#x27;https://&#x27;</span>)):
        <span class="hljs-comment"># If the file_path is a URL</span>
        response = requests.get(file_path)
        response.raise_for_status()
        content = BytesIO(response.content)
        vid = imageio.get_reader(content)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-comment"># Assuming it&#x27;s a local file path</span>
        vid = imageio.get_reader(file_path)

    <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> vid:
        pil_image = Image.fromarray(frame)
        images.append(pil_image)

    <span class="hljs-keyword">return</span> images

video = load_video(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-vid2vid-input-1.gif&quot;</span>)

output = pipe(
    video = video,
    prompt=<span class="hljs-string">&quot;panda playing a guitar, on a boat, in the ocean, high quality&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    strength=<span class="hljs-number">0.5</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),Ke=new w({props:{title:"AnimateDiffVideoToVideoControlNetPipeline",local:"animatediffvideotovideocontrolnetpipeline",headingTag:"h3"}}),nt=new B({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

<span class="hljs-keyword">from</span> controlnet_aux.processor <span class="hljs-keyword">import</span> OpenposeDetector
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffVideoToVideoControlNetPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif, load_video
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL, ControlNetModel, MotionAdapter, LCMScheduler

<span class="hljs-comment"># Load the ControlNet</span>
controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-openpose&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-comment"># Load the motion adapter</span>
motion_adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;wangfuyun/AnimateLCM&quot;</span>)
<span class="hljs-comment"># Load SD 1.5 based finetuned model</span>
vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;stabilityai/sd-vae-ft-mse&quot;</span>, torch_dtype=torch.float16)
pipe = AnimateDiffVideoToVideoControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>,
    motion_adapter=motion_adapter,
    controlnet=controlnet,
    vae=vae,
).to(device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16)

<span class="hljs-comment"># Enable LCM to speed up inference</span>
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config, beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>)
pipe.load_lora_weights(<span class="hljs-string">&quot;wangfuyun/AnimateLCM&quot;</span>, weight_name=<span class="hljs-string">&quot;AnimateLCM_sd15_t2v_lora.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;lcm-lora&quot;</span>)
pipe.set_adapters([<span class="hljs-string">&quot;lcm-lora&quot;</span>], [<span class="hljs-number">0.8</span>])

video = load_video(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/dance.gif&quot;</span>)
video = [frame.convert(<span class="hljs-string">&quot;RGB&quot;</span>) <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> video]

prompt = <span class="hljs-string">&quot;astronaut in space, dancing&quot;</span>
negative_prompt = <span class="hljs-string">&quot;bad quality, worst quality, jpeg artifacts, ugly&quot;</span>

<span class="hljs-comment"># Create controlnet preprocessor</span>
open_pose = OpenposeDetector.from_pretrained(<span class="hljs-string">&quot;lllyasviel/Annotators&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Preprocess controlnet images</span>
conditioning_frames = []
<span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> tqdm(video):
    conditioning_frames.append(open_pose(frame))

strength = <span class="hljs-number">0.8</span>
<span class="hljs-keyword">with</span> torch.inference_mode():
    video = pipe(
        video=video,
        prompt=prompt,
        negative_prompt=negative_prompt,
        num_inference_steps=<span class="hljs-number">10</span>,
        guidance_scale=<span class="hljs-number">2.0</span>,
        controlnet_conditioning_scale=<span class="hljs-number">0.75</span>,
        conditioning_frames=conditioning_frames,
        strength=strength,
        generator=torch.Generator().manual_seed(<span class="hljs-number">42</span>),
    ).frames[<span class="hljs-number">0</span>]

video = [frame.resize(conditioning_frames[<span class="hljs-number">0</span>].size) <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> video]
export_to_gif(video, <span class="hljs-string">f&quot;animatediff_vid2vid_controlnet.gif&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),at=new w({props:{title:"Using Motion LoRAs",local:"using-motion-loras",headingTag:"h2"}}),lt=new B({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-comment"># Load the motion adapter</span>
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-comment"># load SD 1.5 based finetuned model</span>
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffPipeline.from_pretrained(model_id, motion_adapter=adapter, torch_dtype=torch.float16)
pipe.load_lora_weights(
    <span class="hljs-string">&quot;guoyww/animatediff-motion-lora-zoom-out&quot;</span>, adapter_name=<span class="hljs-string">&quot;zoom-out&quot;</span>
)

scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipe.scheduler = scheduler

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

output = pipe(
    prompt=(
        <span class="hljs-string">&quot;masterpiece, bestquality, highlydetailed, ultradetailed, sunset, &quot;</span>
        <span class="hljs-string">&quot;orange sky, warm lighting, fishing boats, ocean waves seagulls, &quot;</span>
        <span class="hljs-string">&quot;rippling water, wharf, silhouette, serene atmosphere, dusk, evening glow, &quot;</span>
        <span class="hljs-string">&quot;golden hour, coastal landscape, seaside scenery&quot;</span>
    ),
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),dt=new w({props:{title:"Using Motion LoRAs with PEFT",local:"using-motion-loras-with-peft",headingTag:"h2"}}),mt=new B({props:{code:"cGlwJTIwaW5zdGFsbCUyMHBlZnQ=",highlighted:"pip install peft",wrap:!1}}),ut=new B({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-comment"># Load the motion adapter</span>
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-comment"># load SD 1.5 based finetuned model</span>
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffPipeline.from_pretrained(model_id, motion_adapter=adapter, torch_dtype=torch.float16)

pipe.load_lora_weights(
    <span class="hljs-string">&quot;diffusers/animatediff-motion-lora-zoom-out&quot;</span>, adapter_name=<span class="hljs-string">&quot;zoom-out&quot;</span>,
)
pipe.load_lora_weights(
    <span class="hljs-string">&quot;diffusers/animatediff-motion-lora-pan-left&quot;</span>, adapter_name=<span class="hljs-string">&quot;pan-left&quot;</span>,
)
pipe.set_adapters([<span class="hljs-string">&quot;zoom-out&quot;</span>, <span class="hljs-string">&quot;pan-left&quot;</span>], adapter_weights=[<span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>])

scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipe.scheduler = scheduler

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

output = pipe(
    prompt=(
        <span class="hljs-string">&quot;masterpiece, bestquality, highlydetailed, ultradetailed, sunset, &quot;</span>
        <span class="hljs-string">&quot;orange sky, warm lighting, fishing boats, ocean waves seagulls, &quot;</span>
        <span class="hljs-string">&quot;rippling water, wharf, silhouette, serene atmosphere, dusk, evening glow, &quot;</span>
        <span class="hljs-string">&quot;golden hour, coastal landscape, seaside scenery&quot;</span>
    ),
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),gt=new w({props:{title:"Using FreeInit",local:"using-freeinit",headingTag:"h2"}}),yt=new B({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MotionAdapter, AnimateDiffPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>)
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffPipeline.from_pretrained(model_id, motion_adapter=adapter, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>
)

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_vae_tiling()

<span class="hljs-comment"># enable FreeInit</span>
<span class="hljs-comment"># Refer to the enable_free_init documentation for a full list of configurable parameters</span>
pipe.enable_free_init(method=<span class="hljs-string">&quot;butterworth&quot;</span>, use_fast_sampling=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># run inference</span>
output = pipe(
    prompt=<span class="hljs-string">&quot;a panda playing a guitar, on a boat, in the ocean, high quality&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">20</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">666</span>),
)

<span class="hljs-comment"># disable FreeInit</span>
pipe.disable_free_init()

frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),te=new ts({props:{warning:!0,$$slots:{default:[Pl]},$$scope:{ctx:N}}}),ne=new ts({props:{$$slots:{default:[Ll]},$$scope:{ctx:N}}}),Tt=new w({props:{title:"Using AnimateLCM",local:"using-animatelcm",headingTag:"h2"}}),vt=new B({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQW5pbWF0ZURpZmZQaXBlbGluZSUyQyUyMExDTVNjaGVkdWxlciUyQyUyME1vdGlvbkFkYXB0ZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX2dpZiUwQSUwQWFkYXB0ZXIlMjAlM0QlMjBNb3Rpb25BZGFwdGVyLmZyb21fcHJldHJhaW5lZCglMjJ3YW5nZnV5dW4lMkZBbmltYXRlTENNJTIyKSUwQXBpcGUlMjAlM0QlMjBBbmltYXRlRGlmZlBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJlbWlsaWFuSlIlMkZlcGlDUmVhbGlzbSUyMiUyQyUyMG1vdGlvbl9hZGFwdGVyJTNEYWRhcHRlciklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMExDTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWclMkMlMjBiZXRhX3NjaGVkdWxlJTNEJTIybGluZWFyJTIyKSUwQSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMoJTIyd2FuZ2Z1eXVuJTJGQW5pbWF0ZUxDTSUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIyc2QxNV9sb3JhX2JldGEuc2FmZXRlbnNvcnMlMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJsY20tbG9yYSUyMiklMEElMEFwaXBlLmVuYWJsZV92YWVfc2xpY2luZygpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQW91dHB1dCUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyQSUyMHNwYWNlJTIwcm9ja2V0JTIwd2l0aCUyMHRyYWlscyUyMG9mJTIwc21va2UlMjBiZWhpbmQlMjBpdCUyMGxhdW5jaGluZyUyMGludG8lMjBzcGFjZSUyMGZyb20lMjB0aGUlMjBkZXNlcnQlMkMlMjA0ayUyQyUyMGhpZ2glMjByZXNvbHV0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyYmFkJTIwcXVhbGl0eSUyQyUyMHdvcnNlJTIwcXVhbGl0eSUyQyUyMGxvdyUyMHJlc29sdXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDEuNSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q2JTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEdG9yY2guR2VuZXJhdG9yKCUyMmNwdSUyMikubWFudWFsX3NlZWQoMCklMkMlMEEpJTBBZnJhbWVzJTIwJTNEJTIwb3V0cHV0LmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fZ2lmKGZyYW1lcyUyQyUyMCUyMmFuaW1hdGVsY20uZ2lmJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, LCMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;wangfuyun/AnimateLCM&quot;</span>)
pipe = AnimateDiffPipeline.from_pretrained(<span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>, motion_adapter=adapter)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config, beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>)

pipe.load_lora_weights(<span class="hljs-string">&quot;wangfuyun/AnimateLCM&quot;</span>, weight_name=<span class="hljs-string">&quot;sd15_lora_beta.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;lcm-lora&quot;</span>)

pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

output = pipe(
    prompt=<span class="hljs-string">&quot;A space rocket with trails of smoke behind it launching into space from the desert, 4k, high resolution&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality, low resolution&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">1.5</span>,
    num_inference_steps=<span class="hljs-number">6</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animatelcm.gif&quot;</span>)`,wrap:!1}}),jt=new B({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQW5pbWF0ZURpZmZQaXBlbGluZSUyQyUyMExDTVNjaGVkdWxlciUyQyUyME1vdGlvbkFkYXB0ZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX2dpZiUwQSUwQWFkYXB0ZXIlMjAlM0QlMjBNb3Rpb25BZGFwdGVyLmZyb21fcHJldHJhaW5lZCglMjJ3YW5nZnV5dW4lMkZBbmltYXRlTENNJTIyKSUwQXBpcGUlMjAlM0QlMjBBbmltYXRlRGlmZlBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJlbWlsaWFuSlIlMkZlcGlDUmVhbGlzbSUyMiUyQyUyMG1vdGlvbl9hZGFwdGVyJTNEYWRhcHRlciklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMExDTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWclMkMlMjBiZXRhX3NjaGVkdWxlJTNEJTIybGluZWFyJTIyKSUwQSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMoJTIyd2FuZ2Z1eXVuJTJGQW5pbWF0ZUxDTSUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIyc2QxNV9sb3JhX2JldGEuc2FmZXRlbnNvcnMlMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJsY20tbG9yYSUyMiklMEFwaXBlLmxvYWRfbG9yYV93ZWlnaHRzKCUyMmd1b3l3dyUyRmFuaW1hdGVkaWZmLW1vdGlvbi1sb3JhLXRpbHQtdXAlMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJ0aWx0LXVwJTIyKSUwQSUwQXBpcGUuc2V0X2FkYXB0ZXJzKCU1QiUyMmxjbS1sb3JhJTIyJTJDJTIwJTIydGlsdC11cCUyMiU1RCUyQyUyMCU1QjEuMCUyQyUyMDAuOCU1RCklMEFwaXBlLmVuYWJsZV92YWVfc2xpY2luZygpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQW91dHB1dCUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyQSUyMHNwYWNlJTIwcm9ja2V0JTIwd2l0aCUyMHRyYWlscyUyMG9mJTIwc21va2UlMjBiZWhpbmQlMjBpdCUyMGxhdW5jaGluZyUyMGludG8lMjBzcGFjZSUyMGZyb20lMjB0aGUlMjBkZXNlcnQlMkMlMjA0ayUyQyUyMGhpZ2glMjByZXNvbHV0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyYmFkJTIwcXVhbGl0eSUyQyUyMHdvcnNlJTIwcXVhbGl0eSUyQyUyMGxvdyUyMHJlc29sdXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDEuNSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q2JTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEdG9yY2guR2VuZXJhdG9yKCUyMmNwdSUyMikubWFudWFsX3NlZWQoMCklMkMlMEEpJTBBZnJhbWVzJTIwJTNEJTIwb3V0cHV0LmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fZ2lmKGZyYW1lcyUyQyUyMCUyMmFuaW1hdGVsY20tbW90aW9uLWxvcmEuZ2lmJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, LCMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;wangfuyun/AnimateLCM&quot;</span>)
pipe = AnimateDiffPipeline.from_pretrained(<span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>, motion_adapter=adapter)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config, beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>)

pipe.load_lora_weights(<span class="hljs-string">&quot;wangfuyun/AnimateLCM&quot;</span>, weight_name=<span class="hljs-string">&quot;sd15_lora_beta.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;lcm-lora&quot;</span>)
pipe.load_lora_weights(<span class="hljs-string">&quot;guoyww/animatediff-motion-lora-tilt-up&quot;</span>, adapter_name=<span class="hljs-string">&quot;tilt-up&quot;</span>)

pipe.set_adapters([<span class="hljs-string">&quot;lcm-lora&quot;</span>, <span class="hljs-string">&quot;tilt-up&quot;</span>], [<span class="hljs-number">1.0</span>, <span class="hljs-number">0.8</span>])
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

output = pipe(
    prompt=<span class="hljs-string">&quot;A space rocket with trails of smoke behind it launching into space from the desert, 4k, high resolution&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality, low resolution&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">1.5</span>,
    num_inference_steps=<span class="hljs-number">6</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animatelcm-motion-lora.gif&quot;</span>)`,wrap:!1}}),Ct=new w({props:{title:"Using from_single_file with the MotionAdapter",local:"using-fromsinglefile-with-the-motionadapter",headingTag:"h2"}}),Wt=new B({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyME1vdGlvbkFkYXB0ZXIlMEElMEFja3B0X3BhdGglMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGTGlnaHRyaWNrcyUyRkxvbmdBbmltYXRlRGlmZiUyRmJsb2IlMkZtYWluJTJGbHRfbG9uZ19tbV8zMl9mcmFtZXMuY2twdCUyMiUwQSUwQWFkYXB0ZXIlMjAlM0QlMjBNb3Rpb25BZGFwdGVyLmZyb21fc2luZ2xlX2ZpbGUoY2twdF9wYXRoJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUlMjAlM0QlMjBBbmltYXRlRGlmZlBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJlbWlsaWFuSlIlMkZlcGlDUmVhbGlzbSUyMiUyQyUyMG1vdGlvbl9hZGFwdGVyJTNEYWRhcHRlcik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MotionAdapter

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/Lightricks/LongAnimateDiff/blob/main/lt_long_mm_32_frames.ckpt&quot;</span>

adapter = MotionAdapter.from_single_file(ckpt_path, torch_dtype=torch.float16)
pipe = AnimateDiffPipeline.from_pretrained(<span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>, motion_adapter=adapter)`,wrap:!1}}),xt=new w({props:{title:"AnimateDiffPipeline",local:"diffusers.AnimateDiffPipeline",headingTag:"h2"}}),Vt=new Z({props:{name:"class diffusers.AnimateDiffPipeline",anchor:"diffusers.AnimateDiffPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": Union"},{name:"motion_adapter",val:": MotionAdapter"},{name:"scheduler",val:": Union"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.AnimateDiffPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.AnimateDiffPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.AnimateDiffPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> used to create a UNetMotionModel to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.AnimateDiffPipeline.motion_adapter",description:`<strong>motion_adapter</strong> (<code>MotionAdapter</code>) &#x2014;
A <code>MotionAdapter</code> to be used in combination with <code>unet</code> to denoise the encoded video latents.`,name:"motion_adapter"},{anchor:"diffusers.AnimateDiffPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L69"}}),kt=new Z({props:{name:"__call__",anchor:"diffusers.AnimateDiffPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"num_frames",val:": Optional = 16"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_videos_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"decode_chunk_size",val:": int = 16"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.AnimateDiffPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.AnimateDiffPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.AnimateDiffPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of video frames that are generated. Defaults to 16 frames which at 8 frames per seconds
amounts to 2 seconds of video.`,name:"num_frames"},{anchor:"diffusers.AnimateDiffPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.AnimateDiffPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.AnimateDiffPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.AnimateDiffPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.AnimateDiffPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.AnimateDiffPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.AnimateDiffPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.Tensor</code>, <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.AnimateDiffPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.AnimateDiffPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AnimateDiffPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.AnimateDiffPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.AnimateDiffPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.AnimateDiffPipeline.__call__.decode_chunk_size",description:`<strong>decode_chunk_size</strong> (<code>int</code>, defaults to <code>16</code>) &#x2014;
The number of frames to decode at a time when calling <code>decode_latents</code> method.`,name:"decode_chunk_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L563",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.pipelines.animatediff.AnimateDiffPipelineOutput"
>AnimateDiffPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.pipelines.animatediff.AnimateDiffPipelineOutput"
>AnimateDiffPipelineOutput</a> or <code>tuple</code></p>
`}}),oe=new ns({props:{anchor:"diffusers.AnimateDiffPipeline.__call__.example",$$slots:{default:[Fl]},$$scope:{ctx:N}}}),Bt=new Z({props:{name:"encode_prompt",anchor:"diffusers.AnimateDiffPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L146"}}),At=new w({props:{title:"AnimateDiffControlNetPipeline",local:"diffusers.AnimateDiffControlNetPipeline",headingTag:"h2"}}),Nt=new Z({props:{name:"class diffusers.AnimateDiffControlNetPipeline",anchor:"diffusers.AnimateDiffControlNetPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": Union"},{name:"motion_adapter",val:": MotionAdapter"},{name:"controlnet",val:": Union"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"feature_extractor",val:": Optional = None"},{name:"image_encoder",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffControlNetPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.AnimateDiffControlNetPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.AnimateDiffControlNetPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.AnimateDiffControlNetPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> used to create a UNetMotionModel to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.AnimateDiffControlNetPipeline.motion_adapter",description:`<strong>motion_adapter</strong> (<code>MotionAdapter</code>) &#x2014;
A <code>MotionAdapter</code> to be used in combination with <code>unet</code> to denoise the encoded video latents.`,name:"motion_adapter"},{anchor:"diffusers.AnimateDiffControlNetPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_controlnet.py#L106"}}),Rt=new Z({props:{name:"__call__",anchor:"diffusers.AnimateDiffControlNetPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"num_frames",val:": Optional = 16"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_videos_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Union = None"},{name:"conditioning_frames",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"controlnet_conditioning_scale",val:": Union = 1.0"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": Union = 0.0"},{name:"control_guidance_end",val:": Union = 1.0"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"decode_chunk_size",val:": int = 16"}],parametersDescription:[{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of video frames that are generated. Defaults to 16 frames which at 8 frames per seconds
amounts to 2 seconds of video.`,name:"num_frames"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.ip_adapter_image",description:`<strong>ip_adapter_image</strong> (<code>PipelineImageInput</code>, <em>optional</em>) &#x2014;
Optional image input to work with IP Adapters.`,name:"ip_adapter_image"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.conditioning_frames",description:`<strong>conditioning_frames</strong> (<code>List[PipelineImageInput]</code>, <em>optional</em>) &#x2014;
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If multiple
ControlNets are specified, images must be passed as a list such that each element of the list can be
correctly batched for input to a single ControlNet.`,name:"conditioning_frames"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.Tensor</code>, <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
The ControlNet encoder tries to recognize the content of the input image even if you remove all
prompts. A <code>guidance_scale</code> value between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.AnimateDiffControlNetPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_controlnet.py#L706",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.pipelines.animatediff.AnimateDiffPipelineOutput"
>AnimateDiffPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.pipelines.animatediff.AnimateDiffPipelineOutput"
>AnimateDiffPipelineOutput</a> or <code>tuple</code></p>
`}}),Dt=new Z({props:{name:"encode_prompt",anchor:"diffusers.AnimateDiffControlNetPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffControlNetPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.AnimateDiffControlNetPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.AnimateDiffControlNetPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.AnimateDiffControlNetPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffControlNetPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffControlNetPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffControlNetPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.AnimateDiffControlNetPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_controlnet.py#L184"}}),Xt=new w({props:{title:"AnimateDiffSparseControlNetPipeline",local:"diffusers.AnimateDiffSparseControlNetPipeline",headingTag:"h2"}}),St=new Z({props:{name:"class diffusers.AnimateDiffSparseControlNetPipeline",anchor:"diffusers.AnimateDiffSparseControlNetPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": Union"},{name:"motion_adapter",val:": MotionAdapter"},{name:"controlnet",val:": SparseControlNetModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> used to create a UNetMotionModel to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.motion_adapter",description:`<strong>motion_adapter</strong> (<code>MotionAdapter</code>) &#x2014;
A <code>MotionAdapter</code> to be used in combination with <code>unet</code> to denoise the encoded video latents.`,name:"motion_adapter"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_sparsectrl.py#L123"}}),Yt=new Z({props:{name:"__call__",anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_frames",val:": int = 16"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"conditioning_frames",val:": Optional = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"controlnet_conditioning_scale",val:": Union = 1.0"},{name:"controlnet_frame_indices",val:": List = [0]"},{name:"guess_mode",val:": bool = False"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"}],parametersDescription:[{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of video frames that are generated. Defaults to 16 frames which at 8 frames per seconds
amounts to 2 seconds of video.`,name:"num_frames"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__.conditioning_frames",description:`<strong>conditioning_frames</strong> (<code>List[PipelineImageInput]</code>, <em>optional</em>) &#x2014;
The SparseControlNet input to provide guidance to the <code>unet</code> for generation.`,name:"conditioning_frames"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.Tensor</code>, <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__.controlnet_frame_indices",description:`<strong>controlnet_frame_indices</strong> (<code>List[int]</code>) &#x2014;
The indices where the conditioning frames must be applied for generation. Multiple frames can be
provided to guide the model to generate similar structure outputs, where the <code>unet</code> can
&#x201C;fill-in-the-gaps&#x201D; for interpolation videos, or a single frame could be provided for general expected
structure. Must have the same length as <code>conditioning_frames</code>.`,name:"controlnet_frame_indices"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_sparsectrl.py#L702",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.pipelines.animatediff.AnimateDiffPipelineOutput"
>AnimateDiffPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.pipelines.animatediff.AnimateDiffPipelineOutput"
>AnimateDiffPipelineOutput</a> or <code>tuple</code></p>
`}}),se=new ns({props:{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.__call__.example",$$slots:{default:[zl]},$$scope:{ctx:N}}}),Et=new Z({props:{name:"encode_prompt",anchor:"diffusers.AnimateDiffSparseControlNetPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.AnimateDiffSparseControlNetPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_sparsectrl.py#L198"}}),Qt=new w({props:{title:"AnimateDiffSDXLPipeline",local:"diffusers.AnimateDiffSDXLPipeline",headingTag:"h2"}}),Pt=new Z({props:{name:"class diffusers.AnimateDiffSDXLPipeline",anchor:"diffusers.AnimateDiffSDXLPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": Union"},{name:"motion_adapter",val:": MotionAdapter"},{name:"scheduler",val:": Union"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.AnimateDiffSDXLPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.AnimateDiffSDXLPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion XL uses the text portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.AnimateDiffSDXLPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code> CLIPTextModelWithProjection</code>) &#x2014;
Second frozen text-encoder. Stable Diffusion XL uses the text and pool portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.AnimateDiffSDXLPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.AnimateDiffSDXLPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.AnimateDiffSDXLPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.AnimateDiffSDXLPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.AnimateDiffSDXLPipeline.force_zeros_for_empty_prompt",description:`<strong>force_zeros_for_empty_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;True&quot;</code>) &#x2014;
Whether the negative prompt embeddings shall be forced to always be set to 0. Also see the config of
<code>stabilityai/stable-diffusion-xl-base-1-0</code>.`,name:"force_zeros_for_empty_prompt"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_sdxl.py#L189"}}),Lt=new Z({props:{name:"__call__",anchor:"diffusers.AnimateDiffSDXLPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"prompt_2",val:": Union = None"},{name:"num_frames",val:": int = 16"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": List = None"},{name:"sigmas",val:": List = None"},{name:"denoising_end",val:": Optional = None"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": Union = None"},{name:"negative_prompt_2",val:": Union = None"},{name:"num_videos_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": Optional = None"},{name:"crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"target_size",val:": Optional = None"},{name:"negative_original_size",val:": Optional = None"},{name:"negative_crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"negative_target_size",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"}],parametersDescription:[{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the video generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders
num_frames &#x2014;
The number of video frames that are generated. Defaults to 16 frames which at 8 frames per seconds
amounts to 2 seconds of video.`,name:"prompt_2"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated video. This is set to 1024 by default for the best results.
Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"height"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated video. This is set to 1024 by default for the best results.
Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"width"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality video at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise as determined by the discrete timesteps selected by the
scheduler. The denoising_end parameter should ideally be utilized when this pipeline forms a part of a
&#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>`,name:"denoising_end"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower video quality.`,name:"guidance_scale"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the video generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the video generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. If not provided, embeddings are computed from the
<code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated video. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.AnimateDiffPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be as same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_sdxl.py#L840",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.pipelines.animatediff.AnimateDiffPipelineOutput"
>AnimateDiffPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.pipelines.animatediff.AnimateDiffPipelineOutput"
>AnimateDiffPipelineOutput</a> or <code>tuple</code></p>
`}}),re=new ns({props:{anchor:"diffusers.AnimateDiffSDXLPipeline.__call__.example",$$slots:{default:[Hl]},$$scope:{ctx:N}}}),Ft=new Z({props:{name:"encode_prompt",anchor:"diffusers.AnimateDiffSDXLPipeline.encode_prompt",parameters:[{name:"prompt",val:": str"},{name:"prompt_2",val:": Optional = None"},{name:"device",val:": Optional = None"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": Optional = None"},{name:"negative_prompt_2",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffSDXLPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.AnimateDiffSDXLPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt_2"},{anchor:"diffusers.AnimateDiffSDXLPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_videos_per_prompt"},{anchor:"diffusers.AnimateDiffSDXLPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.AnimateDiffSDXLPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffSDXLPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.AnimateDiffSDXLPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffSDXLPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffSDXLPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.AnimateDiffSDXLPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.AnimateDiffSDXLPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.AnimateDiffSDXLPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_sdxl.py#L304"}}),zt=new Z({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.AnimateDiffSDXLPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:": Tensor"},{name:"embedding_dim",val:": int = 512"},{name:"dtype",val:": dtype = torch.float32"}],parametersDescription:[{anchor:"diffusers.AnimateDiffSDXLPipeline.get_guidance_scale_embedding.w",description:`<strong>w</strong> (<code>torch.Tensor</code>) &#x2014;
Generate embedding vectors with a specified guidance scale to subsequently enrich timestep embeddings.`,name:"w"},{anchor:"diffusers.AnimateDiffSDXLPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimension of the embeddings to generate.`,name:"embedding_dim"},{anchor:"diffusers.AnimateDiffSDXLPipeline.get_guidance_scale_embedding.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
Data type of the generated embeddings.`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_sdxl.py#L775",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(w), embedding_dim)</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),Ht=new w({props:{title:"AnimateDiffVideoToVideoPipeline",local:"diffusers.AnimateDiffVideoToVideoPipeline",headingTag:"h2"}}),$t=new Z({props:{name:"class diffusers.AnimateDiffVideoToVideoPipeline",anchor:"diffusers.AnimateDiffVideoToVideoPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"motion_adapter",val:": MotionAdapter"},{name:"scheduler",val:": Union"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> used to create a UNetMotionModel to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.motion_adapter",description:`<strong>motion_adapter</strong> (<code>MotionAdapter</code>) &#x2014;
A <code>MotionAdapter</code> to be used in combination with <code>unet</code> to denoise the encoded video latents.`,name:"motion_adapter"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_video2video.py#L173"}}),qt=new Z({props:{name:"__call__",anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__",parameters:[{name:"video",val:": List = None"},{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"enforce_inference_steps",val:": bool = False"},{name:"timesteps",val:": Optional = None"},{name:"sigmas",val:": Optional = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"strength",val:": float = 0.8"},{name:"negative_prompt",val:": Union = None"},{name:"num_videos_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"decode_chunk_size",val:": int = 16"}],parametersDescription:[{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.video",description:`<strong>video</strong> (<code>List[PipelineImageInput]</code>) &#x2014;
The input video to condition the generation on. Must be a list of images/frames of the video.`,name:"video"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Higher strength leads to more differences between original video and generated video.`,name:"strength"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.Tensor</code>, <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>AnimateDiffPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.decode_chunk_size",description:`<strong>decode_chunk_size</strong> (<code>int</code>, defaults to <code>16</code>) &#x2014;
The number of frames to decode at a time when calling <code>decode_latents</code> method.`,name:"decode_chunk_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_video2video.py#L743",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.pipelines.animatediff.AnimateDiffPipelineOutput"
>pipelines.animatediff.pipeline_output.AnimateDiffPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.pipelines.animatediff.AnimateDiffPipelineOutput"
>pipelines.animatediff.pipeline_output.AnimateDiffPipelineOutput</a> or <code>tuple</code></p>
`}}),Ot=new Z({props:{name:"encode_prompt",anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_video2video.py#L249"}}),Kt=new w({props:{title:"AnimateDiffVideoToVideoControlNetPipeline",local:"diffusers.AnimateDiffVideoToVideoControlNetPipeline",headingTag:"h2"}}),en=new Z({props:{name:"class diffusers.AnimateDiffVideoToVideoControlNetPipeline",anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"motion_adapter",val:": MotionAdapter"},{name:"controlnet",val:": Union"},{name:"scheduler",val:": Union"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> used to create a UNetMotionModel to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.motion_adapter",description:`<strong>motion_adapter</strong> (<code>MotionAdapter</code>) &#x2014;
A <code>MotionAdapter</code> to be used in combination with <code>unet</code> to denoise the encoded video latents.`,name:"motion_adapter"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.controlnet",description:`<strong>controlnet</strong> (<a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> or <code>List[ControlNetModel]</code> or <code>Tuple[ControlNetModel]</code> or <code>MultiControlNetModel</code>) &#x2014;
Provides additional conditioning to the <code>unet</code> during the denoising process. If you set multiple
ControlNets as a list, the outputs from each ControlNet are added together to create one combined
additional conditioning.`,name:"controlnet"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_video2video_controlnet.py#L185"}}),tn=new Z({props:{name:"__call__",anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__",parameters:[{name:"video",val:": List = None"},{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"enforce_inference_steps",val:": bool = False"},{name:"timesteps",val:": Optional = None"},{name:"sigmas",val:": Optional = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"strength",val:": float = 0.8"},{name:"negative_prompt",val:": Union = None"},{name:"num_videos_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"conditioning_frames",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"controlnet_conditioning_scale",val:": Union = 1.0"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": Union = 0.0"},{name:"control_guidance_end",val:": Union = 1.0"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"decode_chunk_size",val:": int = 16"}],parametersDescription:[{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.video",description:`<strong>video</strong> (<code>List[PipelineImageInput]</code>) &#x2014;
The input video to condition the generation on. Must be a list of images/frames of the video.`,name:"video"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Higher strength leads to more differences between original video and generated video.`,name:"strength"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.conditioning_frames",description:`<strong>conditioning_frames</strong> (<code>List[PipelineImageInput]</code>, <em>optional</em>) &#x2014;
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If multiple
ControlNets are specified, images must be passed as a list such that each element of the list can be
correctly batched for input to a single ControlNet.`,name:"conditioning_frames"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.Tensor</code>, <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>AnimateDiffPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
The ControlNet encoder tries to recognize the content of the input image even if you remove all
prompts. A <code>guidance_scale</code> value between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.__call__.decode_chunk_size",description:`<strong>decode_chunk_size</strong> (<code>int</code>, defaults to <code>16</code>) &#x2014;
The number of frames to decode at a time when calling <code>decode_latents</code> method.`,name:"decode_chunk_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_video2video_controlnet.py#L902",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.pipelines.animatediff.AnimateDiffPipelineOutput"
>pipelines.animatediff.pipeline_output.AnimateDiffPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.pipelines.animatediff.AnimateDiffPipelineOutput"
>pipelines.animatediff.pipeline_output.AnimateDiffPipelineOutput</a> or <code>tuple</code></p>
`}}),nn=new Z({props:{name:"encode_prompt",anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.AnimateDiffVideoToVideoControlNetPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_video2video_controlnet.py#L274"}}),on=new w({props:{title:"AnimateDiffPipelineOutput",local:"diffusers.pipelines.animatediff.AnimateDiffPipelineOutput",headingTag:"h2"}}),an=new Z({props:{name:"class diffusers.pipelines.animatediff.AnimateDiffPipelineOutput",anchor:"diffusers.pipelines.animatediff.AnimateDiffPipelineOutput",parameters:[{name:"frames",val:": Union"}],parametersDescription:[{anchor:"diffusers.pipelines.animatediff.AnimateDiffPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_output.py#L11"}}),sn=new El({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/animatediff.md"}}),{c(){g=s("meta"),T=i(),M=s("p"),b=i(),p(J.$$.fragment),_=i(),p(j.$$.fragment),io=i(),fe=s("p"),fe.innerHTML=os,ao=i(),ue=s("p"),ue.textContent=is,so=i(),he=s("p"),he.innerHTML=as,lo=i(),p(ge.$$.fragment),ro=i(),_e=s("table"),_e.innerHTML=ss,po=i(),p(Me.$$.fragment),co=i(),be=s("p"),be.innerHTML=ls,mo=i(),p(ye.$$.fragment),fo=i(),p(we.$$.fragment),uo=i(),Te=s("p"),Te.textContent=rs,ho=i(),Je=s("p"),Je.innerHTML=ds,go=i(),p(ve.$$.fragment),_o=i(),Ue=s("p"),Ue.textContent=ps,Mo=i(),Ze=s("table"),Ze.innerHTML=cs,bo=i(),p($.$$.fragment),yo=i(),p(je.$$.fragment),wo=i(),Ie=s("p"),Ie.innerHTML=ms,To=i(),p(Ce.$$.fragment),Jo=i(),Ge=s("p"),Ge.textContent=fs,vo=i(),q=s("table"),q.innerHTML=us,Uo=i(),p(We.$$.fragment),Zo=i(),xe=s("p"),xe.innerHTML=hs,jo=i(),Ve=s("p"),Ve.textContent=gs,Io=i(),ke=s("p"),ke.innerHTML=_s,Co=i(),Be=s("p"),Be.textContent=Ms,Go=i(),Ae=s("ul"),Ae.innerHTML=bs,Wo=i(),p(Ne.$$.fragment),xo=i(),p(Re.$$.fragment),Vo=i(),De=s("p"),De.textContent=ys,ko=i(),Xe=s("center"),Xe.innerHTML=ws,O=s("table"),O.innerHTML=Ts,Bo=i(),p(Se.$$.fragment),Ao=i(),p(Ye.$$.fragment),No=i(),Ee=s("p"),Ee.textContent=Js,Ro=i(),Qe=s("center"),Qe.innerHTML=vs,K=s("table"),K.innerHTML=Us,Do=i(),p(Pe.$$.fragment),Xo=i(),Le=s("p"),Le.textContent=Zs,So=i(),p(Fe.$$.fragment),Yo=i(),p(ze.$$.fragment),Eo=i(),He=s("p"),He.textContent=js,Qo=i(),p($e.$$.fragment),Po=i(),qe=s("p"),qe.textContent=Is,Lo=i(),Oe=s("table"),Oe.innerHTML=Cs,Fo=i(),p(Ke.$$.fragment),zo=i(),et=s("p"),et.innerHTML=Gs,Ho=i(),tt=s("p"),tt.textContent=Ws,$o=i(),p(nt.$$.fragment),qo=i(),ot=s("p"),ot.textContent=xs,Oo=i(),ee=s("table"),ee.innerHTML=Vs,Ko=i(),it=s("p"),it.innerHTML=ks,ei=i(),p(at.$$.fragment),ti=i(),st=s("p"),st.innerHTML=Bs,ni=i(),p(lt.$$.fragment),oi=i(),rt=s("table"),rt.innerHTML=As,ii=i(),p(dt.$$.fragment),ai=i(),pt=s("p"),pt.innerHTML=Ns,si=i(),ct=s("p"),ct.textContent=Rs,li=i(),p(mt.$$.fragment),ri=i(),ft=s("p"),ft.textContent=Ds,di=i(),p(ut.$$.fragment),pi=i(),ht=s("table"),ht.innerHTML=Xs,ci=i(),p(gt.$$.fragment),mi=i(),_t=s("p"),_t.innerHTML=Ss,fi=i(),Mt=s("p"),Mt.textContent=Ys,ui=i(),bt=s("p"),bt.textContent=Es,hi=i(),p(yt.$$.fragment),gi=i(),p(te.$$.fragment),_i=i(),p(ne.$$.fragment),Mi=i(),wt=s("table"),wt.innerHTML=Qs,bi=i(),p(Tt.$$.fragment),yi=i(),Jt=s("p"),Jt.innerHTML=Ps,wi=i(),p(vt.$$.fragment),Ti=i(),Ut=s("table"),Ut.innerHTML=Ls,Ji=i(),Zt=s("p"),Zt.innerHTML=Fs,vi=i(),p(jt.$$.fragment),Ui=i(),It=s("table"),It.innerHTML=zs,Zi=i(),p(Ct.$$.fragment),ji=i(),Gt=s("p"),Gt.innerHTML=Hs,Ii=i(),p(Wt.$$.fragment),Ci=i(),p(xt.$$.fragment),Gi=i(),I=s("div"),p(Vt.$$.fragment),qi=i(),dn=s("p"),dn.textContent=$s,Oi=i(),pn=s("p"),pn.innerHTML=qs,Ki=i(),cn=s("p"),cn.textContent=Os,ea=i(),mn=s("ul"),mn.innerHTML=Ks,ta=i(),Y=s("div"),p(kt.$$.fragment),na=i(),fn=s("p"),fn.textContent=el,oa=i(),p(oe.$$.fragment),ia=i(),ie=s("div"),p(Bt.$$.fragment),aa=i(),un=s("p"),un.textContent=tl,Wi=i(),p(At.$$.fragment),xi=i(),C=s("div"),p(Nt.$$.fragment),sa=i(),hn=s("p"),hn.textContent=nl,la=i(),gn=s("p"),gn.innerHTML=ol,ra=i(),_n=s("p"),_n.textContent=il,da=i(),Mn=s("ul"),Mn.innerHTML=al,pa=i(),E=s("div"),p(Rt.$$.fragment),ca=i(),bn=s("p"),bn.textContent=sl,ma=i(),yn=s("p"),yn.textContent=ll,fa=i(),ae=s("div"),p(Dt.$$.fragment),ua=i(),wn=s("p"),wn.textContent=rl,Vi=i(),p(Xt.$$.fragment),ki=i(),G=s("div"),p(St.$$.fragment),ha=i(),Tn=s("p"),Tn.innerHTML=dl,ga=i(),Jn=s("p"),Jn.innerHTML=pl,_a=i(),vn=s("p"),vn.textContent=cl,Ma=i(),Un=s("ul"),Un.innerHTML=ml,ba=i(),Q=s("div"),p(Yt.$$.fragment),ya=i(),Zn=s("p"),Zn.textContent=fl,wa=i(),p(se.$$.fragment),Ta=i(),le=s("div"),p(Et.$$.fragment),Ja=i(),jn=s("p"),jn.textContent=ul,Bi=i(),p(Qt.$$.fragment),Ai=i(),U=s("div"),p(Pt.$$.fragment),va=i(),In=s("p"),In.textContent=hl,Ua=i(),Cn=s("p"),Cn.innerHTML=gl,Za=i(),Gn=s("p"),Gn.textContent=_l,ja=i(),Wn=s("ul"),Wn.innerHTML=Ml,Ia=i(),P=s("div"),p(Lt.$$.fragment),Ca=i(),xn=s("p"),xn.textContent=bl,Ga=i(),p(re.$$.fragment),Wa=i(),de=s("div"),p(Ft.$$.fragment),xa=i(),Vn=s("p"),Vn.textContent=yl,Va=i(),pe=s("div"),p(zt.$$.fragment),ka=i(),kn=s("p"),kn.innerHTML=wl,Ni=i(),p(Ht.$$.fragment),Ri=i(),W=s("div"),p($t.$$.fragment),Ba=i(),Bn=s("p"),Bn.textContent=Tl,Aa=i(),An=s("p"),An.innerHTML=Jl,Na=i(),Nn=s("p"),Nn.textContent=vl,Ra=i(),Rn=s("ul"),Rn.innerHTML=Ul,Da=i(),L=s("div"),p(qt.$$.fragment),Xa=i(),Dn=s("p"),Dn.textContent=Zl,Sa=i(),Xn=s("p"),Xn.textContent=jl,Ya=i(),ce=s("div"),p(Ot.$$.fragment),Ea=i(),Sn=s("p"),Sn.textContent=Il,Di=i(),p(Kt.$$.fragment),Xi=i(),x=s("div"),p(en.$$.fragment),Qa=i(),Yn=s("p"),Yn.textContent=Cl,Pa=i(),En=s("p"),En.innerHTML=Gl,La=i(),Qn=s("p"),Qn.textContent=Wl,Fa=i(),Pn=s("ul"),Pn.innerHTML=xl,za=i(),F=s("div"),p(tn.$$.fragment),Ha=i(),Ln=s("p"),Ln.textContent=Vl,$a=i(),Fn=s("p"),Fn.textContent=kl,qa=i(),me=s("div"),p(nn.$$.fragment),Oa=i(),zn=s("p"),zn.textContent=Bl,Si=i(),p(on.$$.fragment),Yi=i(),S=s("div"),p(an.$$.fragment),Ka=i(),Hn=s("p"),Hn.textContent=Al,es=i(),$n=s("p"),$n.innerHTML=Nl,Ei=i(),p(sn.$$.fragment),Qi=i(),oo=s("p"),this.h()},l(e){const t=Yl("svelte-u9bgzb",document.head);g=l(t,"META",{name:!0,content:!0}),t.forEach(n),T=a(e),M=l(e,"P",{}),v(M).forEach(n),b=a(e),c(J.$$.fragment,e),_=a(e),c(j.$$.fragment,e),io=a(e),fe=l(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-1heixsu"&&(fe.innerHTML=os),ao=a(e),ue=l(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-wu27l3"&&(ue.textContent=is),so=a(e),he=l(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-17654bv"&&(he.innerHTML=as),lo=a(e),c(ge.$$.fragment,e),ro=a(e),_e=l(e,"TABLE",{"data-svelte-h":!0}),d(_e)!=="svelte-r57ep6"&&(_e.innerHTML=ss),po=a(e),c(Me.$$.fragment,e),co=a(e),be=l(e,"P",{"data-svelte-h":!0}),d(be)!=="svelte-1eu5pwh"&&(be.innerHTML=ls),mo=a(e),c(ye.$$.fragment,e),fo=a(e),c(we.$$.fragment,e),uo=a(e),Te=l(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-q9bvzo"&&(Te.textContent=rs),ho=a(e),Je=l(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-o3l8n4"&&(Je.innerHTML=ds),go=a(e),c(ve.$$.fragment,e),_o=a(e),Ue=l(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-1pxzje"&&(Ue.textContent=ps),Mo=a(e),Ze=l(e,"TABLE",{"data-svelte-h":!0}),d(Ze)!=="svelte-5250wa"&&(Ze.innerHTML=cs),bo=a(e),c($.$$.fragment,e),yo=a(e),c(je.$$.fragment,e),wo=a(e),Ie=l(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-d4p8de"&&(Ie.innerHTML=ms),To=a(e),c(Ce.$$.fragment,e),Jo=a(e),Ge=l(e,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-1pxzje"&&(Ge.textContent=fs),vo=a(e),q=l(e,"TABLE",{align:!0,"data-svelte-h":!0}),d(q)!=="svelte-17jw58u"&&(q.innerHTML=us),Uo=a(e),c(We.$$.fragment,e),Zo=a(e),xe=l(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-cfw4dv"&&(xe.innerHTML=hs),jo=a(e),Ve=l(e,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-1cwsb16"&&(Ve.textContent=gs),Io=a(e),ke=l(e,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-uew8uc"&&(ke.innerHTML=_s),Co=a(e),Be=l(e,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-1vgzuo0"&&(Be.textContent=Ms),Go=a(e),Ae=l(e,"UL",{"data-svelte-h":!0}),d(Ae)!=="svelte-1135q6s"&&(Ae.innerHTML=bs),Wo=a(e),c(Ne.$$.fragment,e),xo=a(e),c(Re.$$.fragment,e),Vo=a(e),De=l(e,"P",{"data-svelte-h":!0}),d(De)!=="svelte-1pxzje"&&(De.textContent=ys),ko=a(e),Xe=l(e,"CENTER",{"data-svelte-h":!0}),d(Xe)!=="svelte-1a6zue0"&&(Xe.innerHTML=ws),O=l(e,"TABLE",{align:!0,"data-svelte-h":!0}),d(O)!=="svelte-1yjcm20"&&(O.innerHTML=Ts),Bo=a(e),c(Se.$$.fragment,e),Ao=a(e),c(Ye.$$.fragment,e),No=a(e),Ee=l(e,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-1pxzje"&&(Ee.textContent=Js),Ro=a(e),Qe=l(e,"CENTER",{"data-svelte-h":!0}),d(Qe)!=="svelte-5k7u1e"&&(Qe.innerHTML=vs),K=l(e,"TABLE",{align:!0,"data-svelte-h":!0}),d(K)!=="svelte-14oq4l5"&&(K.innerHTML=Us),Do=a(e),c(Pe.$$.fragment,e),Xo=a(e),Le=l(e,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-hcpa8p"&&(Le.textContent=Zs),So=a(e),c(Fe.$$.fragment,e),Yo=a(e),c(ze.$$.fragment,e),Eo=a(e),He=l(e,"P",{"data-svelte-h":!0}),d(He)!=="svelte-v5wx3"&&(He.textContent=js),Qo=a(e),c($e.$$.fragment,e),Po=a(e),qe=l(e,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1pxzje"&&(qe.textContent=Is),Lo=a(e),Oe=l(e,"TABLE",{"data-svelte-h":!0}),d(Oe)!=="svelte-1hj8351"&&(Oe.innerHTML=Cs),Fo=a(e),c(Ke.$$.fragment,e),zo=a(e),et=l(e,"P",{"data-svelte-h":!0}),d(et)!=="svelte-t77lll"&&(et.innerHTML=Gs),Ho=a(e),tt=l(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-1tvfm6v"&&(tt.textContent=Ws),$o=a(e),c(nt.$$.fragment,e),qo=a(e),ot=l(e,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-1pxzje"&&(ot.textContent=xs),Oo=a(e),ee=l(e,"TABLE",{align:!0,"data-svelte-h":!0}),d(ee)!=="svelte-tjy703"&&(ee.innerHTML=Vs),Ko=a(e),it=l(e,"P",{"data-svelte-h":!0}),d(it)!=="svelte-xbdauq"&&(it.innerHTML=ks),ei=a(e),c(at.$$.fragment,e),ti=a(e),st=l(e,"P",{"data-svelte-h":!0}),d(st)!=="svelte-u1dwwg"&&(st.innerHTML=Bs),ni=a(e),c(lt.$$.fragment,e),oi=a(e),rt=l(e,"TABLE",{"data-svelte-h":!0}),d(rt)!=="svelte-16prig"&&(rt.innerHTML=As),ii=a(e),c(dt.$$.fragment,e),ai=a(e),pt=l(e,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-1gecok3"&&(pt.innerHTML=Ns),si=a(e),ct=l(e,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-26fcye"&&(ct.textContent=Rs),li=a(e),c(mt.$$.fragment,e),ri=a(e),ft=l(e,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-1e37vkb"&&(ft.textContent=Ds),di=a(e),c(ut.$$.fragment,e),pi=a(e),ht=l(e,"TABLE",{"data-svelte-h":!0}),d(ht)!=="svelte-3p6096"&&(ht.innerHTML=Xs),ci=a(e),c(gt.$$.fragment,e),mi=a(e),_t=l(e,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-a52po1"&&(_t.innerHTML=Ss),fi=a(e),Mt=l(e,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-i9hpov"&&(Mt.textContent=Ys),ui=a(e),bt=l(e,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-1qq4ux4"&&(bt.textContent=Es),hi=a(e),c(yt.$$.fragment,e),gi=a(e),c(te.$$.fragment,e),_i=a(e),c(ne.$$.fragment,e),Mi=a(e),wt=l(e,"TABLE",{"data-svelte-h":!0}),d(wt)!=="svelte-178x3s7"&&(wt.innerHTML=Qs),bi=a(e),c(Tt.$$.fragment,e),yi=a(e),Jt=l(e,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-10musd5"&&(Jt.innerHTML=Ps),wi=a(e),c(vt.$$.fragment,e),Ti=a(e),Ut=l(e,"TABLE",{"data-svelte-h":!0}),d(Ut)!=="svelte-1rjpilt"&&(Ut.innerHTML=Ls),Ji=a(e),Zt=l(e,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-1q8gfh6"&&(Zt.innerHTML=Fs),vi=a(e),c(jt.$$.fragment,e),Ui=a(e),It=l(e,"TABLE",{"data-svelte-h":!0}),d(It)!=="svelte-17fpusd"&&(It.innerHTML=zs),Zi=a(e),c(Ct.$$.fragment,e),ji=a(e),Gt=l(e,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-l2zwkj"&&(Gt.innerHTML=Hs),Ii=a(e),c(Wt.$$.fragment,e),Ci=a(e),c(xt.$$.fragment,e),Gi=a(e),I=l(e,"DIV",{class:!0});var V=v(I);c(Vt.$$.fragment,V),qi=a(V),dn=l(V,"P",{"data-svelte-h":!0}),d(dn)!=="svelte-19ipoo4"&&(dn.textContent=$s),Oi=a(V),pn=l(V,"P",{"data-svelte-h":!0}),d(pn)!=="svelte-496sm0"&&(pn.innerHTML=qs),Ki=a(V),cn=l(V,"P",{"data-svelte-h":!0}),d(cn)!=="svelte-14s6m4u"&&(cn.textContent=Os),ea=a(V),mn=l(V,"UL",{"data-svelte-h":!0}),d(mn)!=="svelte-14drd6k"&&(mn.innerHTML=Ks),ta=a(V),Y=l(V,"DIV",{class:!0});var z=v(Y);c(kt.$$.fragment,z),na=a(z),fn=l(z,"P",{"data-svelte-h":!0}),d(fn)!=="svelte-50j04k"&&(fn.textContent=el),oa=a(z),c(oe.$$.fragment,z),z.forEach(n),ia=a(V),ie=l(V,"DIV",{class:!0});var ln=v(ie);c(Bt.$$.fragment,ln),aa=a(ln),un=l(ln,"P",{"data-svelte-h":!0}),d(un)!=="svelte-16q0ax1"&&(un.textContent=tl),ln.forEach(n),V.forEach(n),Wi=a(e),c(At.$$.fragment,e),xi=a(e),C=l(e,"DIV",{class:!0});var k=v(C);c(Nt.$$.fragment,k),sa=a(k),hn=l(k,"P",{"data-svelte-h":!0}),d(hn)!=="svelte-p8e5gq"&&(hn.textContent=nl),la=a(k),gn=l(k,"P",{"data-svelte-h":!0}),d(gn)!=="svelte-496sm0"&&(gn.innerHTML=ol),ra=a(k),_n=l(k,"P",{"data-svelte-h":!0}),d(_n)!=="svelte-14s6m4u"&&(_n.textContent=il),da=a(k),Mn=l(k,"UL",{"data-svelte-h":!0}),d(Mn)!=="svelte-14drd6k"&&(Mn.innerHTML=al),pa=a(k),E=l(k,"DIV",{class:!0});var H=v(E);c(Rt.$$.fragment,H),ca=a(H),bn=l(H,"P",{"data-svelte-h":!0}),d(bn)!=="svelte-50j04k"&&(bn.textContent=sl),ma=a(H),yn=l(H,"P",{"data-svelte-h":!0}),d(yn)!=="svelte-kvfsh7"&&(yn.textContent=ll),H.forEach(n),fa=a(k),ae=l(k,"DIV",{class:!0});var rn=v(ae);c(Dt.$$.fragment,rn),ua=a(rn),wn=l(rn,"P",{"data-svelte-h":!0}),d(wn)!=="svelte-16q0ax1"&&(wn.textContent=rl),rn.forEach(n),k.forEach(n),Vi=a(e),c(Xt.$$.fragment,e),ki=a(e),G=l(e,"DIV",{class:!0});var R=v(G);c(St.$$.fragment,R),ha=a(R),Tn=l(R,"P",{"data-svelte-h":!0}),d(Tn)!=="svelte-9vx9pu"&&(Tn.innerHTML=dl),ga=a(R),Jn=l(R,"P",{"data-svelte-h":!0}),d(Jn)!=="svelte-496sm0"&&(Jn.innerHTML=pl),_a=a(R),vn=l(R,"P",{"data-svelte-h":!0}),d(vn)!=="svelte-14s6m4u"&&(vn.textContent=cl),Ma=a(R),Un=l(R,"UL",{"data-svelte-h":!0}),d(Un)!=="svelte-14drd6k"&&(Un.innerHTML=ml),ba=a(R),Q=l(R,"DIV",{class:!0});var qn=v(Q);c(Yt.$$.fragment,qn),ya=a(qn),Zn=l(qn,"P",{"data-svelte-h":!0}),d(Zn)!=="svelte-50j04k"&&(Zn.textContent=fl),wa=a(qn),c(se.$$.fragment,qn),qn.forEach(n),Ta=a(R),le=l(R,"DIV",{class:!0});var Li=v(le);c(Et.$$.fragment,Li),Ja=a(Li),jn=l(Li,"P",{"data-svelte-h":!0}),d(jn)!=="svelte-16q0ax1"&&(jn.textContent=ul),Li.forEach(n),R.forEach(n),Bi=a(e),c(Qt.$$.fragment,e),Ai=a(e),U=l(e,"DIV",{class:!0});var A=v(U);c(Pt.$$.fragment,A),va=a(A),In=l(A,"P",{"data-svelte-h":!0}),d(In)!=="svelte-1tviodw"&&(In.textContent=hl),Ua=a(A),Cn=l(A,"P",{"data-svelte-h":!0}),d(Cn)!=="svelte-wu1jmh"&&(Cn.innerHTML=gl),Za=a(A),Gn=l(A,"P",{"data-svelte-h":!0}),d(Gn)!=="svelte-14s6m4u"&&(Gn.textContent=_l),ja=a(A),Wn=l(A,"UL",{"data-svelte-h":!0}),d(Wn)!=="svelte-9wc0dt"&&(Wn.innerHTML=Ml),Ia=a(A),P=l(A,"DIV",{class:!0});var On=v(P);c(Lt.$$.fragment,On),Ca=a(On),xn=l(On,"P",{"data-svelte-h":!0}),d(xn)!=="svelte-v78lg8"&&(xn.textContent=bl),Ga=a(On),c(re.$$.fragment,On),On.forEach(n),Wa=a(A),de=l(A,"DIV",{class:!0});var Fi=v(de);c(Ft.$$.fragment,Fi),xa=a(Fi),Vn=l(Fi,"P",{"data-svelte-h":!0}),d(Vn)!=="svelte-16q0ax1"&&(Vn.textContent=yl),Fi.forEach(n),Va=a(A),pe=l(A,"DIV",{class:!0});var zi=v(pe);c(zt.$$.fragment,zi),ka=a(zi),kn=l(zi,"P",{"data-svelte-h":!0}),d(kn)!=="svelte-vo59ec"&&(kn.innerHTML=wl),zi.forEach(n),A.forEach(n),Ni=a(e),c(Ht.$$.fragment,e),Ri=a(e),W=l(e,"DIV",{class:!0});var D=v(W);c($t.$$.fragment,D),Ba=a(D),Bn=l(D,"P",{"data-svelte-h":!0}),d(Bn)!=="svelte-19djzsa"&&(Bn.textContent=Tl),Aa=a(D),An=l(D,"P",{"data-svelte-h":!0}),d(An)!=="svelte-496sm0"&&(An.innerHTML=Jl),Na=a(D),Nn=l(D,"P",{"data-svelte-h":!0}),d(Nn)!=="svelte-14s6m4u"&&(Nn.textContent=vl),Ra=a(D),Rn=l(D,"UL",{"data-svelte-h":!0}),d(Rn)!=="svelte-14drd6k"&&(Rn.innerHTML=Ul),Da=a(D),L=l(D,"DIV",{class:!0});var Kn=v(L);c(qt.$$.fragment,Kn),Xa=a(Kn),Dn=l(Kn,"P",{"data-svelte-h":!0}),d(Dn)!=="svelte-50j04k"&&(Dn.textContent=Zl),Sa=a(Kn),Xn=l(Kn,"P",{"data-svelte-h":!0}),d(Xn)!=="svelte-kvfsh7"&&(Xn.textContent=jl),Kn.forEach(n),Ya=a(D),ce=l(D,"DIV",{class:!0});var Hi=v(ce);c(Ot.$$.fragment,Hi),Ea=a(Hi),Sn=l(Hi,"P",{"data-svelte-h":!0}),d(Sn)!=="svelte-16q0ax1"&&(Sn.textContent=Il),Hi.forEach(n),D.forEach(n),Di=a(e),c(Kt.$$.fragment,e),Xi=a(e),x=l(e,"DIV",{class:!0});var X=v(x);c(en.$$.fragment,X),Qa=a(X),Yn=l(X,"P",{"data-svelte-h":!0}),d(Yn)!=="svelte-1w5cp98"&&(Yn.textContent=Cl),Pa=a(X),En=l(X,"P",{"data-svelte-h":!0}),d(En)!=="svelte-496sm0"&&(En.innerHTML=Gl),La=a(X),Qn=l(X,"P",{"data-svelte-h":!0}),d(Qn)!=="svelte-14s6m4u"&&(Qn.textContent=Wl),Fa=a(X),Pn=l(X,"UL",{"data-svelte-h":!0}),d(Pn)!=="svelte-14drd6k"&&(Pn.innerHTML=xl),za=a(X),F=l(X,"DIV",{class:!0});var eo=v(F);c(tn.$$.fragment,eo),Ha=a(eo),Ln=l(eo,"P",{"data-svelte-h":!0}),d(Ln)!=="svelte-50j04k"&&(Ln.textContent=Vl),$a=a(eo),Fn=l(eo,"P",{"data-svelte-h":!0}),d(Fn)!=="svelte-kvfsh7"&&(Fn.textContent=kl),eo.forEach(n),qa=a(X),me=l(X,"DIV",{class:!0});var $i=v(me);c(nn.$$.fragment,$i),Oa=a($i),zn=l($i,"P",{"data-svelte-h":!0}),d(zn)!=="svelte-16q0ax1"&&(zn.textContent=Bl),$i.forEach(n),X.forEach(n),Si=a(e),c(on.$$.fragment,e),Yi=a(e),S=l(e,"DIV",{class:!0});var to=v(S);c(an.$$.fragment,to),Ka=a(to),Hn=l(to,"P",{"data-svelte-h":!0}),d(Hn)!=="svelte-8gpkil"&&(Hn.textContent=Al),es=a(to),$n=l(to,"P",{"data-svelte-h":!0}),d($n)!=="svelte-gk6g69"&&($n.innerHTML=Nl),to.forEach(n),Ei=a(e),c(sn.$$.fragment,e),Qi=a(e),oo=l(e,"P",{}),v(oo).forEach(n),this.h()},h(){y(g,"name","hf:doc:metadata"),y(g,"content",ql),y(q,"align","center"),y(O,"align","center"),y(K,"align","center"),y(ee,"align","center"),y(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){r(document.head,g),o(e,T,t),o(e,M,t),o(e,b,t),m(J,e,t),o(e,_,t),m(j,e,t),o(e,io,t),o(e,fe,t),o(e,ao,t),o(e,ue,t),o(e,so,t),o(e,he,t),o(e,lo,t),m(ge,e,t),o(e,ro,t),o(e,_e,t),o(e,po,t),m(Me,e,t),o(e,co,t),o(e,be,t),o(e,mo,t),m(ye,e,t),o(e,fo,t),m(we,e,t),o(e,uo,t),o(e,Te,t),o(e,ho,t),o(e,Je,t),o(e,go,t),m(ve,e,t),o(e,_o,t),o(e,Ue,t),o(e,Mo,t),o(e,Ze,t),o(e,bo,t),m($,e,t),o(e,yo,t),m(je,e,t),o(e,wo,t),o(e,Ie,t),o(e,To,t),m(Ce,e,t),o(e,Jo,t),o(e,Ge,t),o(e,vo,t),o(e,q,t),o(e,Uo,t),m(We,e,t),o(e,Zo,t),o(e,xe,t),o(e,jo,t),o(e,Ve,t),o(e,Io,t),o(e,ke,t),o(e,Co,t),o(e,Be,t),o(e,Go,t),o(e,Ae,t),o(e,Wo,t),m(Ne,e,t),o(e,xo,t),m(Re,e,t),o(e,Vo,t),o(e,De,t),o(e,ko,t),o(e,Xe,t),o(e,O,t),o(e,Bo,t),m(Se,e,t),o(e,Ao,t),m(Ye,e,t),o(e,No,t),o(e,Ee,t),o(e,Ro,t),o(e,Qe,t),o(e,K,t),o(e,Do,t),m(Pe,e,t),o(e,Xo,t),o(e,Le,t),o(e,So,t),m(Fe,e,t),o(e,Yo,t),m(ze,e,t),o(e,Eo,t),o(e,He,t),o(e,Qo,t),m($e,e,t),o(e,Po,t),o(e,qe,t),o(e,Lo,t),o(e,Oe,t),o(e,Fo,t),m(Ke,e,t),o(e,zo,t),o(e,et,t),o(e,Ho,t),o(e,tt,t),o(e,$o,t),m(nt,e,t),o(e,qo,t),o(e,ot,t),o(e,Oo,t),o(e,ee,t),o(e,Ko,t),o(e,it,t),o(e,ei,t),m(at,e,t),o(e,ti,t),o(e,st,t),o(e,ni,t),m(lt,e,t),o(e,oi,t),o(e,rt,t),o(e,ii,t),m(dt,e,t),o(e,ai,t),o(e,pt,t),o(e,si,t),o(e,ct,t),o(e,li,t),m(mt,e,t),o(e,ri,t),o(e,ft,t),o(e,di,t),m(ut,e,t),o(e,pi,t),o(e,ht,t),o(e,ci,t),m(gt,e,t),o(e,mi,t),o(e,_t,t),o(e,fi,t),o(e,Mt,t),o(e,ui,t),o(e,bt,t),o(e,hi,t),m(yt,e,t),o(e,gi,t),m(te,e,t),o(e,_i,t),m(ne,e,t),o(e,Mi,t),o(e,wt,t),o(e,bi,t),m(Tt,e,t),o(e,yi,t),o(e,Jt,t),o(e,wi,t),m(vt,e,t),o(e,Ti,t),o(e,Ut,t),o(e,Ji,t),o(e,Zt,t),o(e,vi,t),m(jt,e,t),o(e,Ui,t),o(e,It,t),o(e,Zi,t),m(Ct,e,t),o(e,ji,t),o(e,Gt,t),o(e,Ii,t),m(Wt,e,t),o(e,Ci,t),m(xt,e,t),o(e,Gi,t),o(e,I,t),m(Vt,I,null),r(I,qi),r(I,dn),r(I,Oi),r(I,pn),r(I,Ki),r(I,cn),r(I,ea),r(I,mn),r(I,ta),r(I,Y),m(kt,Y,null),r(Y,na),r(Y,fn),r(Y,oa),m(oe,Y,null),r(I,ia),r(I,ie),m(Bt,ie,null),r(ie,aa),r(ie,un),o(e,Wi,t),m(At,e,t),o(e,xi,t),o(e,C,t),m(Nt,C,null),r(C,sa),r(C,hn),r(C,la),r(C,gn),r(C,ra),r(C,_n),r(C,da),r(C,Mn),r(C,pa),r(C,E),m(Rt,E,null),r(E,ca),r(E,bn),r(E,ma),r(E,yn),r(C,fa),r(C,ae),m(Dt,ae,null),r(ae,ua),r(ae,wn),o(e,Vi,t),m(Xt,e,t),o(e,ki,t),o(e,G,t),m(St,G,null),r(G,ha),r(G,Tn),r(G,ga),r(G,Jn),r(G,_a),r(G,vn),r(G,Ma),r(G,Un),r(G,ba),r(G,Q),m(Yt,Q,null),r(Q,ya),r(Q,Zn),r(Q,wa),m(se,Q,null),r(G,Ta),r(G,le),m(Et,le,null),r(le,Ja),r(le,jn),o(e,Bi,t),m(Qt,e,t),o(e,Ai,t),o(e,U,t),m(Pt,U,null),r(U,va),r(U,In),r(U,Ua),r(U,Cn),r(U,Za),r(U,Gn),r(U,ja),r(U,Wn),r(U,Ia),r(U,P),m(Lt,P,null),r(P,Ca),r(P,xn),r(P,Ga),m(re,P,null),r(U,Wa),r(U,de),m(Ft,de,null),r(de,xa),r(de,Vn),r(U,Va),r(U,pe),m(zt,pe,null),r(pe,ka),r(pe,kn),o(e,Ni,t),m(Ht,e,t),o(e,Ri,t),o(e,W,t),m($t,W,null),r(W,Ba),r(W,Bn),r(W,Aa),r(W,An),r(W,Na),r(W,Nn),r(W,Ra),r(W,Rn),r(W,Da),r(W,L),m(qt,L,null),r(L,Xa),r(L,Dn),r(L,Sa),r(L,Xn),r(W,Ya),r(W,ce),m(Ot,ce,null),r(ce,Ea),r(ce,Sn),o(e,Di,t),m(Kt,e,t),o(e,Xi,t),o(e,x,t),m(en,x,null),r(x,Qa),r(x,Yn),r(x,Pa),r(x,En),r(x,La),r(x,Qn),r(x,Fa),r(x,Pn),r(x,za),r(x,F),m(tn,F,null),r(F,Ha),r(F,Ln),r(F,$a),r(F,Fn),r(x,qa),r(x,me),m(nn,me,null),r(me,Oa),r(me,zn),o(e,Si,t),m(on,e,t),o(e,Yi,t),o(e,S,t),m(an,S,null),r(S,Ka),r(S,Hn),r(S,es),r(S,$n),o(e,Ei,t),m(sn,e,t),o(e,Qi,t),o(e,oo,t),Pi=!0},p(e,[t]){const V={};t&2&&(V.$$scope={dirty:t,ctx:e}),$.$set(V);const z={};t&2&&(z.$$scope={dirty:t,ctx:e}),te.$set(z);const ln={};t&2&&(ln.$$scope={dirty:t,ctx:e}),ne.$set(ln);const k={};t&2&&(k.$$scope={dirty:t,ctx:e}),oe.$set(k);const H={};t&2&&(H.$$scope={dirty:t,ctx:e}),se.$set(H);const rn={};t&2&&(rn.$$scope={dirty:t,ctx:e}),re.$set(rn)},i(e){Pi||(f(J.$$.fragment,e),f(j.$$.fragment,e),f(ge.$$.fragment,e),f(Me.$$.fragment,e),f(ye.$$.fragment,e),f(we.$$.fragment,e),f(ve.$$.fragment,e),f($.$$.fragment,e),f(je.$$.fragment,e),f(Ce.$$.fragment,e),f(We.$$.fragment,e),f(Ne.$$.fragment,e),f(Re.$$.fragment,e),f(Se.$$.fragment,e),f(Ye.$$.fragment,e),f(Pe.$$.fragment,e),f(Fe.$$.fragment,e),f(ze.$$.fragment,e),f($e.$$.fragment,e),f(Ke.$$.fragment,e),f(nt.$$.fragment,e),f(at.$$.fragment,e),f(lt.$$.fragment,e),f(dt.$$.fragment,e),f(mt.$$.fragment,e),f(ut.$$.fragment,e),f(gt.$$.fragment,e),f(yt.$$.fragment,e),f(te.$$.fragment,e),f(ne.$$.fragment,e),f(Tt.$$.fragment,e),f(vt.$$.fragment,e),f(jt.$$.fragment,e),f(Ct.$$.fragment,e),f(Wt.$$.fragment,e),f(xt.$$.fragment,e),f(Vt.$$.fragment,e),f(kt.$$.fragment,e),f(oe.$$.fragment,e),f(Bt.$$.fragment,e),f(At.$$.fragment,e),f(Nt.$$.fragment,e),f(Rt.$$.fragment,e),f(Dt.$$.fragment,e),f(Xt.$$.fragment,e),f(St.$$.fragment,e),f(Yt.$$.fragment,e),f(se.$$.fragment,e),f(Et.$$.fragment,e),f(Qt.$$.fragment,e),f(Pt.$$.fragment,e),f(Lt.$$.fragment,e),f(re.$$.fragment,e),f(Ft.$$.fragment,e),f(zt.$$.fragment,e),f(Ht.$$.fragment,e),f($t.$$.fragment,e),f(qt.$$.fragment,e),f(Ot.$$.fragment,e),f(Kt.$$.fragment,e),f(en.$$.fragment,e),f(tn.$$.fragment,e),f(nn.$$.fragment,e),f(on.$$.fragment,e),f(an.$$.fragment,e),f(sn.$$.fragment,e),Pi=!0)},o(e){u(J.$$.fragment,e),u(j.$$.fragment,e),u(ge.$$.fragment,e),u(Me.$$.fragment,e),u(ye.$$.fragment,e),u(we.$$.fragment,e),u(ve.$$.fragment,e),u($.$$.fragment,e),u(je.$$.fragment,e),u(Ce.$$.fragment,e),u(We.$$.fragment,e),u(Ne.$$.fragment,e),u(Re.$$.fragment,e),u(Se.$$.fragment,e),u(Ye.$$.fragment,e),u(Pe.$$.fragment,e),u(Fe.$$.fragment,e),u(ze.$$.fragment,e),u($e.$$.fragment,e),u(Ke.$$.fragment,e),u(nt.$$.fragment,e),u(at.$$.fragment,e),u(lt.$$.fragment,e),u(dt.$$.fragment,e),u(mt.$$.fragment,e),u(ut.$$.fragment,e),u(gt.$$.fragment,e),u(yt.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(Tt.$$.fragment,e),u(vt.$$.fragment,e),u(jt.$$.fragment,e),u(Ct.$$.fragment,e),u(Wt.$$.fragment,e),u(xt.$$.fragment,e),u(Vt.$$.fragment,e),u(kt.$$.fragment,e),u(oe.$$.fragment,e),u(Bt.$$.fragment,e),u(At.$$.fragment,e),u(Nt.$$.fragment,e),u(Rt.$$.fragment,e),u(Dt.$$.fragment,e),u(Xt.$$.fragment,e),u(St.$$.fragment,e),u(Yt.$$.fragment,e),u(se.$$.fragment,e),u(Et.$$.fragment,e),u(Qt.$$.fragment,e),u(Pt.$$.fragment,e),u(Lt.$$.fragment,e),u(re.$$.fragment,e),u(Ft.$$.fragment,e),u(zt.$$.fragment,e),u(Ht.$$.fragment,e),u($t.$$.fragment,e),u(qt.$$.fragment,e),u(Ot.$$.fragment,e),u(Kt.$$.fragment,e),u(en.$$.fragment,e),u(tn.$$.fragment,e),u(nn.$$.fragment,e),u(on.$$.fragment,e),u(an.$$.fragment,e),u(sn.$$.fragment,e),Pi=!1},d(e){e&&(n(T),n(M),n(b),n(_),n(io),n(fe),n(ao),n(ue),n(so),n(he),n(lo),n(ro),n(_e),n(po),n(co),n(be),n(mo),n(fo),n(uo),n(Te),n(ho),n(Je),n(go),n(_o),n(Ue),n(Mo),n(Ze),n(bo),n(yo),n(wo),n(Ie),n(To),n(Jo),n(Ge),n(vo),n(q),n(Uo),n(Zo),n(xe),n(jo),n(Ve),n(Io),n(ke),n(Co),n(Be),n(Go),n(Ae),n(Wo),n(xo),n(Vo),n(De),n(ko),n(Xe),n(O),n(Bo),n(Ao),n(No),n(Ee),n(Ro),n(Qe),n(K),n(Do),n(Xo),n(Le),n(So),n(Yo),n(Eo),n(He),n(Qo),n(Po),n(qe),n(Lo),n(Oe),n(Fo),n(zo),n(et),n(Ho),n(tt),n($o),n(qo),n(ot),n(Oo),n(ee),n(Ko),n(it),n(ei),n(ti),n(st),n(ni),n(oi),n(rt),n(ii),n(ai),n(pt),n(si),n(ct),n(li),n(ri),n(ft),n(di),n(pi),n(ht),n(ci),n(mi),n(_t),n(fi),n(Mt),n(ui),n(bt),n(hi),n(gi),n(_i),n(Mi),n(wt),n(bi),n(yi),n(Jt),n(wi),n(Ti),n(Ut),n(Ji),n(Zt),n(vi),n(Ui),n(It),n(Zi),n(ji),n(Gt),n(Ii),n(Ci),n(Gi),n(I),n(Wi),n(xi),n(C),n(Vi),n(ki),n(G),n(Bi),n(Ai),n(U),n(Ni),n(Ri),n(W),n(Di),n(Xi),n(x),n(Si),n(Yi),n(S),n(Ei),n(Qi),n(oo)),n(g),h(J,e),h(j,e),h(ge,e),h(Me,e),h(ye,e),h(we,e),h(ve,e),h($,e),h(je,e),h(Ce,e),h(We,e),h(Ne,e),h(Re,e),h(Se,e),h(Ye,e),h(Pe,e),h(Fe,e),h(ze,e),h($e,e),h(Ke,e),h(nt,e),h(at,e),h(lt,e),h(dt,e),h(mt,e),h(ut,e),h(gt,e),h(yt,e),h(te,e),h(ne,e),h(Tt,e),h(vt,e),h(jt,e),h(Ct,e),h(Wt,e),h(xt,e),h(Vt),h(kt),h(oe),h(Bt),h(At,e),h(Nt),h(Rt),h(Dt),h(Xt,e),h(St),h(Yt),h(se),h(Et),h(Qt,e),h(Pt),h(Lt),h(re),h(Ft),h(zt),h(Ht,e),h($t),h(qt),h(Ot),h(Kt,e),h(en),h(tn),h(nn),h(on,e),h(an),h(sn,e)}}}const ql='{"title":"Text-to-Video Generation with AnimateDiff","local":"text-to-video-generation-with-animatediff","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Available Pipelines","local":"available-pipelines","sections":[],"depth":2},{"title":"Available checkpoints","local":"available-checkpoints","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"AnimateDiffPipeline","local":"animatediffpipeline","sections":[],"depth":3},{"title":"AnimateDiffControlNetPipeline","local":"animatediffcontrolnetpipeline","sections":[],"depth":3},{"title":"AnimateDiffSparseControlNetPipeline","local":"animatediffsparsecontrolnetpipeline","sections":[{"title":"Using SparseCtrl Scribble","local":"using-sparsectrl-scribble","sections":[],"depth":4},{"title":"Using SparseCtrl RGB","local":"using-sparsectrl-rgb","sections":[],"depth":4}],"depth":3},{"title":"AnimateDiffSDXLPipeline","local":"animatediffsdxlpipeline","sections":[],"depth":3},{"title":"AnimateDiffVideoToVideoPipeline","local":"animatediffvideotovideopipeline","sections":[],"depth":3},{"title":"AnimateDiffVideoToVideoControlNetPipeline","local":"animatediffvideotovideocontrolnetpipeline","sections":[],"depth":3}],"depth":2},{"title":"Using Motion LoRAs","local":"using-motion-loras","sections":[],"depth":2},{"title":"Using Motion LoRAs with PEFT","local":"using-motion-loras-with-peft","sections":[],"depth":2},{"title":"Using FreeInit","local":"using-freeinit","sections":[],"depth":2},{"title":"Using AnimateLCM","local":"using-animatelcm","sections":[],"depth":2},{"title":"Using from_single_file with the MotionAdapter","local":"using-fromsinglefile-with-the-motionadapter","sections":[],"depth":2},{"title":"AnimateDiffPipeline","local":"diffusers.AnimateDiffPipeline","sections":[],"depth":2},{"title":"AnimateDiffControlNetPipeline","local":"diffusers.AnimateDiffControlNetPipeline","sections":[],"depth":2},{"title":"AnimateDiffSparseControlNetPipeline","local":"diffusers.AnimateDiffSparseControlNetPipeline","sections":[],"depth":2},{"title":"AnimateDiffSDXLPipeline","local":"diffusers.AnimateDiffSDXLPipeline","sections":[],"depth":2},{"title":"AnimateDiffVideoToVideoPipeline","local":"diffusers.AnimateDiffVideoToVideoPipeline","sections":[],"depth":2},{"title":"AnimateDiffVideoToVideoControlNetPipeline","local":"diffusers.AnimateDiffVideoToVideoControlNetPipeline","sections":[],"depth":2},{"title":"AnimateDiffPipelineOutput","local":"diffusers.pipelines.animatediff.AnimateDiffPipelineOutput","sections":[],"depth":2}],"depth":1}';function Ol(N){return Dl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sr extends Xl{constructor(g){super(),Sl(this,g,Ol,$l,Rl,{})}}export{sr as component};
