import{s as Ia,o as va,n as dn}from"../chunks/scheduler.182ea377.js";import{S as Wa,i as Ga,g as i,s,r as m,A as Ba,h as o,f as n,c as l,j as _,u as f,x as p,k as U,y as r,a,v as u,d as M,t as h,w as g}from"../chunks/index.abf12888.js";import{T as Fn}from"../chunks/Tip.230e2334.js";import{D as I}from"../chunks/Docstring.93f6f462.js";import{C as Qe}from"../chunks/CodeBlock.57fe6e13.js";import{E as Ca}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as v}from"../chunks/Heading.16916d63.js";function xa(G){let d,T="AnimateDiff tends to work better with finetuned Stable Diffusion models. If you plan on using a scheduler that can clip samples, make sure to disable it by setting <code>clip_sample=False</code> in the scheduler as this can also have an adverse effect on generated samples. Additionally, the AnimateDiff checkpoints can be sensitive to the beta schedule of the scheduler. We recommend setting this to <code>linear</code>.";return{c(){d=i("p"),d.innerHTML=T},l(b){d=o(b,"P",{"data-svelte-h":!0}),p(d)!=="svelte-vnv4xn"&&(d.innerHTML=T)},m(b,J){a(b,d,J)},p:dn,d(b){b&&n(d)}}}function ka(G){let d,T="FreeInit is not really free - the improved quality comes at the cost of extra computation. It requires sampling a few extra times depending on the <code>num_iters</code> parameter that is set when enabling it. Setting the <code>use_fast_sampling</code> parameter to <code>True</code> can improve the overall performance (at the cost of lower quality compared to when <code>use_fast_sampling=False</code> but still better results than vanilla video generation models).";return{c(){d=i("p"),d.innerHTML=T},l(b){d=o(b,"P",{"data-svelte-h":!0}),p(d)!=="svelte-xxwpr5"&&(d.innerHTML=T)},m(b,J){a(b,d,J)},p:dn,d(b){b&&n(d)}}}function Va(G){let d,T='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){d=i("p"),d.innerHTML=T},l(b){d=o(b,"P",{"data-svelte-h":!0}),p(d)!=="svelte-1wmc0l4"&&(d.innerHTML=T)},m(b,J){a(b,d,J)},p:dn,d(b){b&&n(d)}}}function Aa(G){let d,T="Examples:",b,J,j;return J=new Qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTW90aW9uQWRhcHRlciUyQyUyMEFuaW1hdGVEaWZmUGlwZWxpbmUlMkMlMjBERElNU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMEElMEFhZGFwdGVyJTIwJTNEJTIwTW90aW9uQWRhcHRlci5mcm9tX3ByZXRyYWluZWQoJTIyZ3VveXd3JTJGYW5pbWF0ZWRpZmYtbW90aW9uLWFkYXB0ZXItdjEtNS0yJTIyKSUwQXBpcGUlMjAlM0QlMjBBbmltYXRlRGlmZlBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJmcmFua2pvc2h1YSUyRnRvb255b3VfYmV0YTYlMjIlMkMlMjBtb3Rpb25fYWRhcHRlciUzRGFkYXB0ZXIpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyKGJldGFfc2NoZWR1bGUlM0QlMjJsaW5lYXIlMjIlMkMlMjBzdGVwc19vZmZzZXQlM0QxJTJDJTIwY2xpcF9zYW1wbGUlM0RGYWxzZSklMEFvdXRwdXQlMjAlM0QlMjBwaXBlKHByb21wdCUzRCUyMkElMjBjb3JnaSUyMHdhbGtpbmclMjBpbiUyMHRoZSUyMHBhcmslMjIpJTBBZnJhbWVzJTIwJTNEJTIwb3V0cHV0LmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fZ2lmKGZyYW1lcyUyQyUyMCUyMmFuaW1hdGlvbi5naWYlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MotionAdapter, AnimateDiffPipeline, DDIMScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-meta">&gt;&gt;&gt; </span>adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AnimateDiffPipeline.from_pretrained(<span class="hljs-string">&quot;frankjoshua/toonyou_beta6&quot;</span>, motion_adapter=adapter)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DDIMScheduler(beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>, steps_offset=<span class="hljs-number">1</span>, clip_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(prompt=<span class="hljs-string">&quot;A corgi walking in the park&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>frames = output.frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=T,b=s(),m(J.$$.fragment)},l(w){d=o(w,"P",{"data-svelte-h":!0}),p(d)!=="svelte-kvfsh7"&&(d.textContent=T),b=l(w),f(J.$$.fragment,w)},m(w,W){a(w,d,W),a(w,b,W),u(J,w,W),j=!0},p:dn,i(w){j||(M(J.$$.fragment,w),j=!0)},o(w){h(J.$$.fragment,w),j=!1},d(w){w&&(n(d),n(b)),g(J,w)}}}function $a(G){let d,T,b,J,j,w,W,mt,H,Xn='<a href="https://arxiv.org/abs/2307.04725" rel="nofollow">AnimateDiff: Animate Your Personalized Text-to-Image Diffusion Models without Specific Tuning</a> by Yuwei Guo, Ceyuan Yang, Anyi Rao, Yaohui Wang, Yu Qiao, Dahua Lin, Bo Dai.',ft,z,Dn="The abstract of the paper is the following:",ut,q,Yn='<em>With the advance of text-to-image models (e.g., Stable Diffusion) and corresponding personalization techniques such as DreamBooth and LoRA, everyone can manifest their imagination into high-quality images at an affordable cost. Subsequently, there is a great demand for image animation techniques to further combine generated static images with motion dynamics. In this report, we propose a practical framework to animate most of the existing personalized text-to-image models once and for all, saving efforts in model-specific tuning. At the core of the proposed framework is to insert a newly initialized motion modeling module into the frozen text-to-image model and train it on video clips to distill reasonable motion priors. Once trained, by simply injecting this motion modeling module, all personalized versions derived from the same base T2I readily become text-driven models that produce diverse and personalized animated images. We conduct our evaluation on several public representative personalized text-to-image models across anime pictures and realistic photographs, and demonstrate that our proposed framework helps these models generate temporally smooth animation clips while preserving the domain and diversity of their outputs. Code and pre-trained weights will be publicly available at <a href="https://animatediff.github.io/" rel="nofollow">this https URL</a>.</em>',Mt,P,ht,L,Sn='<thead><tr><th>Pipeline</th> <th>Tasks</th> <th align="center">Demo</th></tr></thead> <tbody><tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py" rel="nofollow">AnimateDiffPipeline</a></td> <td><em>Text-to-Video Generation with AnimateDiff</em></td> <td align="center"></td></tr> <tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_video2video.py" rel="nofollow">AnimateDiffVideoToVideoPipeline</a></td> <td><em>Video-to-Video Generation with AnimateDiff</em></td> <td align="center"></td></tr></tbody>',gt,K,yt,O,Qn='Motion Adapter checkpoints can be found under <a href="https://huggingface.co/guoyww/" rel="nofollow">guoyww</a>. These checkpoints are meant to work with any model based on Stable Diffusion 1.4/1.5.',bt,ee,wt,te,Jt,ne,Nn="AnimateDiff works with a MotionAdapter checkpoint and a Stable Diffusion model checkpoint. The MotionAdapter is a collection of Motion Modules that are responsible for adding coherent motion across image frames. These modules are applied after the Resnet and Attention blocks in Stable Diffusion UNet.",Tt,ae,Hn="The following example demonstrates how to use a <em>MotionAdapter</em> checkpoint with Diffusers for inference based on StableDiffusion-1.4/1.5.",_t,se,Ut,le,zn="Here are some sample outputs:",jt,ie,qn=`<tbody><tr><td><center>masterpiece, bestquality, sunset.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-realistic-doc.gif" alt="masterpiece, bestquality, sunset" style="width: 300px;"/></center></td></tr></tbody>`,Zt,V,It,oe,vt,re,Pn="AnimateDiff can also be used to generate visually similar videos or enable style/character/background or other edits starting from an initial video, allowing you to seamlessly explore creative possibilities.",Wt,pe,Gt,de,Ln="Here are some sample outputs:",Bt,ce,Kn=`<tbody><tr><th align="center">Source Video</th> <th align="center">Output Video</th></tr> <tr><td align="center">raccoon playing a guitar
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-vid2vid-input-1.gif" alt="racoon playing a guitar" style="width: 300px;"/></td> <td align="center">panda playing a guitar
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-vid2vid-output-1.gif" alt="panda playing a guitar" style="width: 300px;"/></td></tr> <tr><td align="center">closeup of margot robbie, fireworks in the background, high quality
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-vid2vid-input-2.gif" alt="closeup of margot robbie, fireworks in the background, high quality" style="width: 300px;"/></td> <td align="center">closeup of tony stark, robert downey jr, fireworks
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-vid2vid-output-2.gif" alt="closeup of tony stark, robert downey jr, fireworks" style="width: 300px;"/></td></tr></tbody>`,Ct,me,xt,fe,On="Motion LoRAs are a collection of LoRAs that work with the <code>guoyww/animatediff-motion-adapter-v1-5-2</code> checkpoint. These LoRAs are responsible for adding specific types of motion to the animations.",kt,ue,Vt,Me,ea=`<tbody><tr><td><center>masterpiece, bestquality, sunset.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-zoom-out-lora.gif" alt="masterpiece, bestquality, sunset" style="width: 300px;"/></center></td></tr></tbody>`,At,he,$t,ge,ta='You can also leverage the <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT</a> backend to combine Motion LoRA’s and create more complex animations.',Rt,ye,na="First install PEFT with",Et,be,Ft,we,aa="Then you can use the following code to combine Motion LoRAs.",Xt,Je,Dt,Te,sa=`<tbody><tr><td><center>masterpiece, bestquality, sunset.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-zoom-out-pan-left-lora.gif" alt="masterpiece, bestquality, sunset" style="width: 300px;"/></center></td></tr></tbody>`,Yt,_e,St,Ue,la='<a href="https://arxiv.org/abs/2312.07537" rel="nofollow">FreeInit: Bridging Initialization Gap in Video Diffusion Models</a> by Tianxing Wu, Chenyang Si, Yuming Jiang, Ziqi Huang, Ziwei Liu.',Qt,je,ia="FreeInit is an effective method that improves temporal consistency and overall quality of videos generated using video-diffusion-models without any addition training. It can be applied to AnimateDiff, ModelScope, VideoCrafter and various other video generation models seamlessly at inference time, and works by iteratively refining the latent-initialization noise. More details can be found it the paper.",Nt,Ze,oa="The following example demonstrates the usage of FreeInit.",Ht,Ie,zt,A,qt,$,Pt,ve,Lt,c,We,cn,Ne,ra="Pipeline for text-to-video generation.",mn,He,pa=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,fn,ze,da="The pipeline also inherits the following loading methods:",un,qe,ca='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',Mn,B,Ge,hn,Pe,ma="The call function to the pipeline for generation.",gn,R,yn,E,Be,bn,Le,fa="Disables the FreeInit mechanism if enabled.",wn,F,Ce,Jn,Ke,ua="Disables the FreeU mechanism if enabled.",Tn,X,xe,_n,Oe,Ma=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Un,D,ke,jn,et,ha=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Zn,C,Ve,In,tt,ga='Enables the FreeInit mechanism as in <a href="https://arxiv.org/abs/2312.07537" rel="nofollow">https://arxiv.org/abs/2312.07537</a>.',vn,nt,ya='This implementation has been adapted from the <a href="https://github.com/TianxingWu/FreeInit" rel="nofollow">official repository</a>.',Wn,Z,Ae,Gn,at,ba='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',Bn,st,wa="The suffixes after the scaling factors represent the stages where they are being applied.",Cn,lt,Ja=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,xn,Y,$e,kn,it,Ta=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Vn,S,Re,An,ot,_a=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,$n,Q,Ee,Rn,rt,Ua="Encodes the prompt into text encoder hidden states.",Kt,Fe,ja="<li>enable_freeu</li> <li>disable_freeu</li> <li>enable_free_init</li> <li>disable_free_init</li> <li>enable_vae_slicing</li> <li>disable_vae_slicing</li> <li>enable_vae_tiling</li> <li>disable_vae_tiling</li>",Ot,Xe,en,x,De,En,pt,Za="Output class for AnimateDiff pipelines.",tn,ct,nn;return j=new v({props:{title:"Text-to-Video Generation with AnimateDiff",local:"text-to-video-generation-with-animatediff",headingTag:"h1"}}),W=new v({props:{title:"Overview",local:"overview",headingTag:"h2"}}),P=new v({props:{title:"Available Pipelines",local:"available-pipelines",headingTag:"h2"}}),K=new v({props:{title:"Available checkpoints",local:"available-checkpoints",headingTag:"h2"}}),ee=new v({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),te=new v({props:{title:"AnimateDiffPipeline",local:"animatediffpipeline",headingTag:"h3"}}),se=new Qe({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-comment"># Load the motion adapter</span>
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-comment"># load SD 1.5 based finetuned model</span>
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffPipeline.from_pretrained(model_id, motion_adapter=adapter, torch_dtype=torch.float16)
scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipe.scheduler = scheduler

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

output = pipe(
    prompt=(
        <span class="hljs-string">&quot;masterpiece, bestquality, highlydetailed, ultradetailed, sunset, &quot;</span>
        <span class="hljs-string">&quot;orange sky, warm lighting, fishing boats, ocean waves seagulls, &quot;</span>
        <span class="hljs-string">&quot;rippling water, wharf, silhouette, serene atmosphere, dusk, evening glow, &quot;</span>
        <span class="hljs-string">&quot;golden hour, coastal landscape, seaside scenery&quot;</span>
    ),
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)
`,wrap:!1}}),V=new Fn({props:{$$slots:{default:[xa]},$$scope:{ctx:G}}}),oe=new v({props:{title:"AnimateDiffVideoToVideoPipeline",local:"animatediffvideotovideopipeline",headingTag:"h3"}}),pe=new Qe({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> imageio
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffVideoToVideoPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-comment"># Load the motion adapter</span>
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-comment"># load SD 1.5 based finetuned model</span>
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffVideoToVideoPipeline.from_pretrained(model_id, motion_adapter=adapter, torch_dtype=torch.float16)
scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipe.scheduler = scheduler

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># helper function to load videos</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">load_video</span>(<span class="hljs-params">file_path: <span class="hljs-built_in">str</span></span>):
    images = []

    <span class="hljs-keyword">if</span> file_path.startswith((<span class="hljs-string">&#x27;http://&#x27;</span>, <span class="hljs-string">&#x27;https://&#x27;</span>)):
        <span class="hljs-comment"># If the file_path is a URL</span>
        response = requests.get(file_path)
        response.raise_for_status()
        content = BytesIO(response.content)
        vid = imageio.get_reader(content)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-comment"># Assuming it&#x27;s a local file path</span>
        vid = imageio.get_reader(file_path)

    <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> vid:
        pil_image = Image.fromarray(frame)
        images.append(pil_image)

    <span class="hljs-keyword">return</span> images

video = load_video(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-vid2vid-input-1.gif&quot;</span>)

output = pipe(
    video = video,
    prompt=<span class="hljs-string">&quot;panda playing a guitar, on a boat, in the ocean, high quality&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    strength=<span class="hljs-number">0.5</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),me=new v({props:{title:"Using Motion LoRAs",local:"using-motion-loras",headingTag:"h2"}}),ue=new Qe({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-comment"># Load the motion adapter</span>
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-comment"># load SD 1.5 based finetuned model</span>
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffPipeline.from_pretrained(model_id, motion_adapter=adapter, torch_dtype=torch.float16)
pipe.load_lora_weights(
    <span class="hljs-string">&quot;guoyww/animatediff-motion-lora-zoom-out&quot;</span>, adapter_name=<span class="hljs-string">&quot;zoom-out&quot;</span>
)

scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipe.scheduler = scheduler

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

output = pipe(
    prompt=(
        <span class="hljs-string">&quot;masterpiece, bestquality, highlydetailed, ultradetailed, sunset, &quot;</span>
        <span class="hljs-string">&quot;orange sky, warm lighting, fishing boats, ocean waves seagulls, &quot;</span>
        <span class="hljs-string">&quot;rippling water, wharf, silhouette, serene atmosphere, dusk, evening glow, &quot;</span>
        <span class="hljs-string">&quot;golden hour, coastal landscape, seaside scenery&quot;</span>
    ),
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)
`,wrap:!1}}),he=new v({props:{title:"Using Motion LoRAs with PEFT",local:"using-motion-loras-with-peft",headingTag:"h2"}}),be=new Qe({props:{code:"cGlwJTIwaW5zdGFsbCUyMHBlZnQ=",highlighted:"pip install peft",wrap:!1}}),Je=new Qe({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-comment"># Load the motion adapter</span>
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-comment"># load SD 1.5 based finetuned model</span>
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffPipeline.from_pretrained(model_id, motion_adapter=adapter, torch_dtype=torch.float16)

pipe.load_lora_weights(
    <span class="hljs-string">&quot;diffusers/animatediff-motion-lora-zoom-out&quot;</span>, adapter_name=<span class="hljs-string">&quot;zoom-out&quot;</span>,
)
pipe.load_lora_weights(
    <span class="hljs-string">&quot;diffusers/animatediff-motion-lora-pan-left&quot;</span>, adapter_name=<span class="hljs-string">&quot;pan-left&quot;</span>,
)
pipe.set_adapters([<span class="hljs-string">&quot;zoom-out&quot;</span>, <span class="hljs-string">&quot;pan-left&quot;</span>], adapter_weights=[<span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>])

scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipe.scheduler = scheduler

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

output = pipe(
    prompt=(
        <span class="hljs-string">&quot;masterpiece, bestquality, highlydetailed, ultradetailed, sunset, &quot;</span>
        <span class="hljs-string">&quot;orange sky, warm lighting, fishing boats, ocean waves seagulls, &quot;</span>
        <span class="hljs-string">&quot;rippling water, wharf, silhouette, serene atmosphere, dusk, evening glow, &quot;</span>
        <span class="hljs-string">&quot;golden hour, coastal landscape, seaside scenery&quot;</span>
    ),
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)
`,wrap:!1}}),_e=new v({props:{title:"Using FreeInit",local:"using-freeinit",headingTag:"h2"}}),Ie=new Qe({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MotionAdapter, AnimateDiffPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>)
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffPipeline.from_pretrained(model_id, motion_adapter=adapter, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>
)

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_vae_tiling()

<span class="hljs-comment"># enable FreeInit</span>
<span class="hljs-comment"># Refer to the enable_free_init documentation for a full list of configurable parameters</span>
pipe.enable_free_init(method=<span class="hljs-string">&quot;butterworth&quot;</span>, use_fast_sampling=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># run inference</span>
output = pipe(
    prompt=<span class="hljs-string">&quot;a panda playing a guitar, on a boat, in the ocean, high quality&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">20</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">666</span>),
)

<span class="hljs-comment"># disable FreeInit</span>
pipe.disable_free_init()

frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),A=new Fn({props:{warning:!0,$$slots:{default:[ka]},$$scope:{ctx:G}}}),$=new Fn({props:{$$slots:{default:[Va]},$$scope:{ctx:G}}}),ve=new v({props:{title:"AnimateDiffPipeline",local:"diffusers.AnimateDiffPipeline",headingTag:"h2"}}),We=new I({props:{name:"class diffusers.AnimateDiffPipeline",anchor:"diffusers.AnimateDiffPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"motion_adapter",val:": MotionAdapter"},{name:"scheduler",val:": Union"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.AnimateDiffPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.AnimateDiffPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.AnimateDiffPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> used to create a UNetMotionModel to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.AnimateDiffPipeline.motion_adapter",description:`<strong>motion_adapter</strong> (<code>MotionAdapter</code>) &#x2014;
A <code>MotionAdapter</code> to be used in combination with <code>unet</code> to denoise the encoded video latents.`,name:"motion_adapter"},{anchor:"diffusers.AnimateDiffPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L155"}}),Ge=new I({props:{name:"__call__",anchor:"diffusers.AnimateDiffPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"num_frames",val:": Optional = 16"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_videos_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.AnimateDiffPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.AnimateDiffPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.AnimateDiffPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of video frames that are generated. Defaults to 16 frames which at 8 frames per seconds
amounts to 2 seconds of video.`,name:"num_frames"},{anchor:"diffusers.AnimateDiffPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.AnimateDiffPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.AnimateDiffPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.AnimateDiffPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.AnimateDiffPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.AnimateDiffPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.FloatTensor</code>, <code>PIL.Image</code> or
<code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.AnimateDiffPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.AnimateDiffPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AnimateDiffPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.AnimateDiffPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.AnimateDiffPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeine class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L838",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> or <code>tuple</code></p>
`}}),R=new Ca({props:{anchor:"diffusers.AnimateDiffPipeline.__call__.example",$$slots:{default:[Aa]},$$scope:{ctx:G}}}),Be=new I({props:{name:"disable_free_init",anchor:"diffusers.AnimateDiffPipeline.disable_free_init",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L562"}}),Ce=new I({props:{name:"disable_freeu",anchor:"diffusers.AnimateDiffPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L510"}}),xe=new I({props:{name:"disable_vae_slicing",anchor:"diffusers.AnimateDiffPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L462"}}),ke=new I({props:{name:"disable_vae_tiling",anchor:"diffusers.AnimateDiffPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L479"}}),Ve=new I({props:{name:"enable_free_init",anchor:"diffusers.AnimateDiffPipeline.enable_free_init",parameters:[{name:"num_iters",val:": int = 3"},{name:"use_fast_sampling",val:": bool = False"},{name:"method",val:": str = 'butterworth'"},{name:"order",val:": int = 4"},{name:"spatial_stop_frequency",val:": float = 0.25"},{name:"temporal_stop_frequency",val:": float = 0.25"},{name:"generator",val:": Generator = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.enable_free_init.num_iters",description:`<strong>num_iters</strong> (<code>int</code>, <em>optional</em>, defaults to <code>3</code>) &#x2014;
Number of FreeInit noise re-initialization iterations.`,name:"num_iters"},{anchor:"diffusers.AnimateDiffPipeline.enable_free_init.use_fast_sampling",description:`<strong>use_fast_sampling</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to speedup sampling procedure at the cost of probably lower quality results. Enables
the &#x201C;Coarse-to-Fine Sampling&#x201D; strategy, as mentioned in the paper, if set to <code>True</code>.`,name:"use_fast_sampling"},{anchor:"diffusers.AnimateDiffPipeline.enable_free_init.method",description:`<strong>method</strong> (<code>str</code>, <em>optional</em>, defaults to <code>butterworth</code>) &#x2014;
Must be one of <code>butterworth</code>, <code>ideal</code> or <code>gaussian</code> to use as the filtering method for the
FreeInit low pass filter.`,name:"method"},{anchor:"diffusers.AnimateDiffPipeline.enable_free_init.order",description:`<strong>order</strong> (<code>int</code>, <em>optional</em>, defaults to <code>4</code>) &#x2014;
Order of the filter used in <code>butterworth</code> method. Larger values lead to <code>ideal</code> method behaviour
whereas lower values lead to <code>gaussian</code> method behaviour.`,name:"order"},{anchor:"diffusers.AnimateDiffPipeline.enable_free_init.spatial_stop_frequency",description:`<strong>spatial_stop_frequency</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.25</code>) &#x2014;
Normalized stop frequency for spatial dimensions. Must be between 0 to 1. Referred to as <code>d_s</code> in
the original implementation.`,name:"spatial_stop_frequency"},{anchor:"diffusers.AnimateDiffPipeline.enable_free_init.temporal_stop_frequency",description:`<strong>temporal_stop_frequency</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.25</code>) &#x2014;
Normalized stop frequency for temporal dimensions. Must be between 0 to 1. Referred to as <code>d_t</code> in
the original implementation.`,name:"temporal_stop_frequency"},{anchor:"diffusers.AnimateDiffPipeline.enable_free_init.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>, defaults to <code>0.25</code>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
FreeInit generation deterministic.`,name:"generator"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L518"}}),Ae=new I({props:{name:"enable_freeu",anchor:"diffusers.AnimateDiffPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.AnimateDiffPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.AnimateDiffPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.AnimateDiffPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L487"}}),$e=new I({props:{name:"enable_vae_slicing",anchor:"diffusers.AnimateDiffPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L454"}}),Re=new I({props:{name:"enable_vae_tiling",anchor:"diffusers.AnimateDiffPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L470"}}),Ee=new I({props:{name:"encode_prompt",anchor:"diffusers.AnimateDiffPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L223"}}),Xe=new v({props:{title:"AnimateDiffPipelineOutput",local:"diffusers.pipelines.animatediff.AnimateDiffPipelineOutput",headingTag:"h2"}}),De=new I({props:{name:"class diffusers.pipelines.animatediff.AnimateDiffPipelineOutput",anchor:"diffusers.pipelines.animatediff.AnimateDiffPipelineOutput",parameters:[{name:"frames",val:": Union"}],parametersDescription:[{anchor:"diffusers.pipelines.animatediff.AnimateDiffPipelineOutput.frames",description:`<strong>frames</strong> (<code>List[List[PIL.Image.Image]]</code> or <code>torch.Tensor</code> or <code>np.ndarray</code>) &#x2014;
List of PIL Images of length <code>batch_size</code> or torch.Tensor or np.ndarray of shape
<code>(batch_size, num_frames, height, width, num_channels)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_output.py#L11"}}),{c(){d=i("meta"),T=s(),b=i("p"),J=s(),m(j.$$.fragment),w=s(),m(W.$$.fragment),mt=s(),H=i("p"),H.innerHTML=Xn,ft=s(),z=i("p"),z.textContent=Dn,ut=s(),q=i("p"),q.innerHTML=Yn,Mt=s(),m(P.$$.fragment),ht=s(),L=i("table"),L.innerHTML=Sn,gt=s(),m(K.$$.fragment),yt=s(),O=i("p"),O.innerHTML=Qn,bt=s(),m(ee.$$.fragment),wt=s(),m(te.$$.fragment),Jt=s(),ne=i("p"),ne.textContent=Nn,Tt=s(),ae=i("p"),ae.innerHTML=Hn,_t=s(),m(se.$$.fragment),Ut=s(),le=i("p"),le.textContent=zn,jt=s(),ie=i("table"),ie.innerHTML=qn,Zt=s(),m(V.$$.fragment),It=s(),m(oe.$$.fragment),vt=s(),re=i("p"),re.textContent=Pn,Wt=s(),m(pe.$$.fragment),Gt=s(),de=i("p"),de.textContent=Ln,Bt=s(),ce=i("table"),ce.innerHTML=Kn,Ct=s(),m(me.$$.fragment),xt=s(),fe=i("p"),fe.innerHTML=On,kt=s(),m(ue.$$.fragment),Vt=s(),Me=i("table"),Me.innerHTML=ea,At=s(),m(he.$$.fragment),$t=s(),ge=i("p"),ge.innerHTML=ta,Rt=s(),ye=i("p"),ye.textContent=na,Et=s(),m(be.$$.fragment),Ft=s(),we=i("p"),we.textContent=aa,Xt=s(),m(Je.$$.fragment),Dt=s(),Te=i("table"),Te.innerHTML=sa,Yt=s(),m(_e.$$.fragment),St=s(),Ue=i("p"),Ue.innerHTML=la,Qt=s(),je=i("p"),je.textContent=ia,Nt=s(),Ze=i("p"),Ze.textContent=oa,Ht=s(),m(Ie.$$.fragment),zt=s(),m(A.$$.fragment),qt=s(),m($.$$.fragment),Pt=s(),m(ve.$$.fragment),Lt=s(),c=i("div"),m(We.$$.fragment),cn=s(),Ne=i("p"),Ne.textContent=ra,mn=s(),He=i("p"),He.innerHTML=pa,fn=s(),ze=i("p"),ze.textContent=da,un=s(),qe=i("ul"),qe.innerHTML=ca,Mn=s(),B=i("div"),m(Ge.$$.fragment),hn=s(),Pe=i("p"),Pe.textContent=ma,gn=s(),m(R.$$.fragment),yn=s(),E=i("div"),m(Be.$$.fragment),bn=s(),Le=i("p"),Le.textContent=fa,wn=s(),F=i("div"),m(Ce.$$.fragment),Jn=s(),Ke=i("p"),Ke.textContent=ua,Tn=s(),X=i("div"),m(xe.$$.fragment),_n=s(),Oe=i("p"),Oe.innerHTML=Ma,Un=s(),D=i("div"),m(ke.$$.fragment),jn=s(),et=i("p"),et.innerHTML=ha,Zn=s(),C=i("div"),m(Ve.$$.fragment),In=s(),tt=i("p"),tt.innerHTML=ga,vn=s(),nt=i("p"),nt.innerHTML=ya,Wn=s(),Z=i("div"),m(Ae.$$.fragment),Gn=s(),at=i("p"),at.innerHTML=ba,Bn=s(),st=i("p"),st.textContent=wa,Cn=s(),lt=i("p"),lt.innerHTML=Ja,xn=s(),Y=i("div"),m($e.$$.fragment),kn=s(),it=i("p"),it.textContent=Ta,Vn=s(),S=i("div"),m(Re.$$.fragment),An=s(),ot=i("p"),ot.textContent=_a,$n=s(),Q=i("div"),m(Ee.$$.fragment),Rn=s(),rt=i("p"),rt.textContent=Ua,Kt=s(),Fe=i("ul"),Fe.innerHTML=ja,Ot=s(),m(Xe.$$.fragment),en=s(),x=i("div"),m(De.$$.fragment),En=s(),pt=i("p"),pt.textContent=Za,tn=s(),ct=i("p"),this.h()},l(e){const t=Ba("svelte-u9bgzb",document.head);d=o(t,"META",{name:!0,content:!0}),t.forEach(n),T=l(e),b=o(e,"P",{}),_(b).forEach(n),J=l(e),f(j.$$.fragment,e),w=l(e),f(W.$$.fragment,e),mt=l(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1heixsu"&&(H.innerHTML=Xn),ft=l(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-wu27l3"&&(z.textContent=Dn),ut=l(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-17654bv"&&(q.innerHTML=Yn),Mt=l(e),f(P.$$.fragment,e),ht=l(e),L=o(e,"TABLE",{"data-svelte-h":!0}),p(L)!=="svelte-2pawus"&&(L.innerHTML=Sn),gt=l(e),f(K.$$.fragment,e),yt=l(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1eu5pwh"&&(O.innerHTML=Qn),bt=l(e),f(ee.$$.fragment,e),wt=l(e),f(te.$$.fragment,e),Jt=l(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-q9bvzo"&&(ne.textContent=Nn),Tt=l(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-o3l8n4"&&(ae.innerHTML=Hn),_t=l(e),f(se.$$.fragment,e),Ut=l(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1pxzje"&&(le.textContent=zn),jt=l(e),ie=o(e,"TABLE",{"data-svelte-h":!0}),p(ie)!=="svelte-5250wa"&&(ie.innerHTML=qn),Zt=l(e),f(V.$$.fragment,e),It=l(e),f(oe.$$.fragment,e),vt=l(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-v5wx3"&&(re.textContent=Pn),Wt=l(e),f(pe.$$.fragment,e),Gt=l(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1pxzje"&&(de.textContent=Ln),Bt=l(e),ce=o(e,"TABLE",{"data-svelte-h":!0}),p(ce)!=="svelte-1hj8351"&&(ce.innerHTML=Kn),Ct=l(e),f(me.$$.fragment,e),xt=l(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-u1dwwg"&&(fe.innerHTML=On),kt=l(e),f(ue.$$.fragment,e),Vt=l(e),Me=o(e,"TABLE",{"data-svelte-h":!0}),p(Me)!=="svelte-16prig"&&(Me.innerHTML=ea),At=l(e),f(he.$$.fragment,e),$t=l(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1gecok3"&&(ge.innerHTML=ta),Rt=l(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-26fcye"&&(ye.textContent=na),Et=l(e),f(be.$$.fragment,e),Ft=l(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1e37vkb"&&(we.textContent=aa),Xt=l(e),f(Je.$$.fragment,e),Dt=l(e),Te=o(e,"TABLE",{"data-svelte-h":!0}),p(Te)!=="svelte-3p6096"&&(Te.innerHTML=sa),Yt=l(e),f(_e.$$.fragment,e),St=l(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-a52po1"&&(Ue.innerHTML=la),Qt=l(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-i9hpov"&&(je.textContent=ia),Nt=l(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1qq4ux4"&&(Ze.textContent=oa),Ht=l(e),f(Ie.$$.fragment,e),zt=l(e),f(A.$$.fragment,e),qt=l(e),f($.$$.fragment,e),Pt=l(e),f(ve.$$.fragment,e),Lt=l(e),c=o(e,"DIV",{class:!0});var y=_(c);f(We.$$.fragment,y),cn=l(y),Ne=o(y,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-19ipoo4"&&(Ne.textContent=ra),mn=l(y),He=o(y,"P",{"data-svelte-h":!0}),p(He)!=="svelte-496sm0"&&(He.innerHTML=pa),fn=l(y),ze=o(y,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-14s6m4u"&&(ze.textContent=da),un=l(y),qe=o(y,"UL",{"data-svelte-h":!0}),p(qe)!=="svelte-jjuyoc"&&(qe.innerHTML=ca),Mn=l(y),B=o(y,"DIV",{class:!0});var k=_(B);f(Ge.$$.fragment,k),hn=l(k),Pe=o(k,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-50j04k"&&(Pe.textContent=ma),gn=l(k),f(R.$$.fragment,k),k.forEach(n),yn=l(y),E=o(y,"DIV",{class:!0});var Ye=_(E);f(Be.$$.fragment,Ye),bn=l(Ye),Le=o(Ye,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-14r83"&&(Le.textContent=fa),Ye.forEach(n),wn=l(y),F=o(y,"DIV",{class:!0});var Se=_(F);f(Ce.$$.fragment,Se),Jn=l(Se),Ke=o(Se,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-psupw6"&&(Ke.textContent=ua),Se.forEach(n),Tn=l(y),X=o(y,"DIV",{class:!0});var an=_(X);f(xe.$$.fragment,an),_n=l(an),Oe=o(an,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-1s3c06i"&&(Oe.innerHTML=Ma),an.forEach(n),Un=l(y),D=o(y,"DIV",{class:!0});var sn=_(D);f(ke.$$.fragment,sn),jn=l(sn),et=o(sn,"P",{"data-svelte-h":!0}),p(et)!=="svelte-pkn4ui"&&(et.innerHTML=ha),sn.forEach(n),Zn=l(y),C=o(y,"DIV",{class:!0});var dt=_(C);f(Ve.$$.fragment,dt),In=l(dt),tt=o(dt,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-1llfxku"&&(tt.innerHTML=ga),vn=l(dt),nt=o(dt,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-1adhw15"&&(nt.innerHTML=ya),dt.forEach(n),Wn=l(y),Z=o(y,"DIV",{class:!0});var N=_(Z);f(Ae.$$.fragment,N),Gn=l(N),at=o(N,"P",{"data-svelte-h":!0}),p(at)!=="svelte-1f3tmq1"&&(at.innerHTML=ba),Bn=l(N),st=o(N,"P",{"data-svelte-h":!0}),p(st)!=="svelte-xjijlp"&&(st.textContent=wa),Cn=l(N),lt=o(N,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-hy0nzs"&&(lt.innerHTML=Ja),N.forEach(n),xn=l(y),Y=o(y,"DIV",{class:!0});var ln=_(Y);f($e.$$.fragment,ln),kn=l(ln),it=o(ln,"P",{"data-svelte-h":!0}),p(it)!=="svelte-14bnrb6"&&(it.textContent=Ta),ln.forEach(n),Vn=l(y),S=o(y,"DIV",{class:!0});var on=_(S);f(Re.$$.fragment,on),An=l(on),ot=o(on,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-1xwrf7t"&&(ot.textContent=_a),on.forEach(n),$n=l(y),Q=o(y,"DIV",{class:!0});var rn=_(Q);f(Ee.$$.fragment,rn),Rn=l(rn),rt=o(rn,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-16q0ax1"&&(rt.textContent=Ua),rn.forEach(n),y.forEach(n),Kt=l(e),Fe=o(e,"UL",{"data-svelte-h":!0}),p(Fe)!=="svelte-1piu0vk"&&(Fe.innerHTML=ja),Ot=l(e),f(Xe.$$.fragment,e),en=l(e),x=o(e,"DIV",{class:!0});var pn=_(x);f(De.$$.fragment,pn),En=l(pn),pt=o(pn,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-8gpkil"&&(pt.textContent=Za),pn.forEach(n),tn=l(e),ct=o(e,"P",{}),_(ct).forEach(n),this.h()},h(){U(d,"name","hf:doc:metadata"),U(d,"content",Ra),U(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){r(document.head,d),a(e,T,t),a(e,b,t),a(e,J,t),u(j,e,t),a(e,w,t),u(W,e,t),a(e,mt,t),a(e,H,t),a(e,ft,t),a(e,z,t),a(e,ut,t),a(e,q,t),a(e,Mt,t),u(P,e,t),a(e,ht,t),a(e,L,t),a(e,gt,t),u(K,e,t),a(e,yt,t),a(e,O,t),a(e,bt,t),u(ee,e,t),a(e,wt,t),u(te,e,t),a(e,Jt,t),a(e,ne,t),a(e,Tt,t),a(e,ae,t),a(e,_t,t),u(se,e,t),a(e,Ut,t),a(e,le,t),a(e,jt,t),a(e,ie,t),a(e,Zt,t),u(V,e,t),a(e,It,t),u(oe,e,t),a(e,vt,t),a(e,re,t),a(e,Wt,t),u(pe,e,t),a(e,Gt,t),a(e,de,t),a(e,Bt,t),a(e,ce,t),a(e,Ct,t),u(me,e,t),a(e,xt,t),a(e,fe,t),a(e,kt,t),u(ue,e,t),a(e,Vt,t),a(e,Me,t),a(e,At,t),u(he,e,t),a(e,$t,t),a(e,ge,t),a(e,Rt,t),a(e,ye,t),a(e,Et,t),u(be,e,t),a(e,Ft,t),a(e,we,t),a(e,Xt,t),u(Je,e,t),a(e,Dt,t),a(e,Te,t),a(e,Yt,t),u(_e,e,t),a(e,St,t),a(e,Ue,t),a(e,Qt,t),a(e,je,t),a(e,Nt,t),a(e,Ze,t),a(e,Ht,t),u(Ie,e,t),a(e,zt,t),u(A,e,t),a(e,qt,t),u($,e,t),a(e,Pt,t),u(ve,e,t),a(e,Lt,t),a(e,c,t),u(We,c,null),r(c,cn),r(c,Ne),r(c,mn),r(c,He),r(c,fn),r(c,ze),r(c,un),r(c,qe),r(c,Mn),r(c,B),u(Ge,B,null),r(B,hn),r(B,Pe),r(B,gn),u(R,B,null),r(c,yn),r(c,E),u(Be,E,null),r(E,bn),r(E,Le),r(c,wn),r(c,F),u(Ce,F,null),r(F,Jn),r(F,Ke),r(c,Tn),r(c,X),u(xe,X,null),r(X,_n),r(X,Oe),r(c,Un),r(c,D),u(ke,D,null),r(D,jn),r(D,et),r(c,Zn),r(c,C),u(Ve,C,null),r(C,In),r(C,tt),r(C,vn),r(C,nt),r(c,Wn),r(c,Z),u(Ae,Z,null),r(Z,Gn),r(Z,at),r(Z,Bn),r(Z,st),r(Z,Cn),r(Z,lt),r(c,xn),r(c,Y),u($e,Y,null),r(Y,kn),r(Y,it),r(c,Vn),r(c,S),u(Re,S,null),r(S,An),r(S,ot),r(c,$n),r(c,Q),u(Ee,Q,null),r(Q,Rn),r(Q,rt),a(e,Kt,t),a(e,Fe,t),a(e,Ot,t),u(Xe,e,t),a(e,en,t),a(e,x,t),u(De,x,null),r(x,En),r(x,pt),a(e,tn,t),a(e,ct,t),nn=!0},p(e,[t]){const y={};t&2&&(y.$$scope={dirty:t,ctx:e}),V.$set(y);const k={};t&2&&(k.$$scope={dirty:t,ctx:e}),A.$set(k);const Ye={};t&2&&(Ye.$$scope={dirty:t,ctx:e}),$.$set(Ye);const Se={};t&2&&(Se.$$scope={dirty:t,ctx:e}),R.$set(Se)},i(e){nn||(M(j.$$.fragment,e),M(W.$$.fragment,e),M(P.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(te.$$.fragment,e),M(se.$$.fragment,e),M(V.$$.fragment,e),M(oe.$$.fragment,e),M(pe.$$.fragment,e),M(me.$$.fragment,e),M(ue.$$.fragment,e),M(he.$$.fragment,e),M(be.$$.fragment,e),M(Je.$$.fragment,e),M(_e.$$.fragment,e),M(Ie.$$.fragment,e),M(A.$$.fragment,e),M($.$$.fragment,e),M(ve.$$.fragment,e),M(We.$$.fragment,e),M(Ge.$$.fragment,e),M(R.$$.fragment,e),M(Be.$$.fragment,e),M(Ce.$$.fragment,e),M(xe.$$.fragment,e),M(ke.$$.fragment,e),M(Ve.$$.fragment,e),M(Ae.$$.fragment,e),M($e.$$.fragment,e),M(Re.$$.fragment,e),M(Ee.$$.fragment,e),M(Xe.$$.fragment,e),M(De.$$.fragment,e),nn=!0)},o(e){h(j.$$.fragment,e),h(W.$$.fragment,e),h(P.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(se.$$.fragment,e),h(V.$$.fragment,e),h(oe.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(ue.$$.fragment,e),h(he.$$.fragment,e),h(be.$$.fragment,e),h(Je.$$.fragment,e),h(_e.$$.fragment,e),h(Ie.$$.fragment,e),h(A.$$.fragment,e),h($.$$.fragment,e),h(ve.$$.fragment,e),h(We.$$.fragment,e),h(Ge.$$.fragment,e),h(R.$$.fragment,e),h(Be.$$.fragment,e),h(Ce.$$.fragment,e),h(xe.$$.fragment,e),h(ke.$$.fragment,e),h(Ve.$$.fragment,e),h(Ae.$$.fragment,e),h($e.$$.fragment,e),h(Re.$$.fragment,e),h(Ee.$$.fragment,e),h(Xe.$$.fragment,e),h(De.$$.fragment,e),nn=!1},d(e){e&&(n(T),n(b),n(J),n(w),n(mt),n(H),n(ft),n(z),n(ut),n(q),n(Mt),n(ht),n(L),n(gt),n(yt),n(O),n(bt),n(wt),n(Jt),n(ne),n(Tt),n(ae),n(_t),n(Ut),n(le),n(jt),n(ie),n(Zt),n(It),n(vt),n(re),n(Wt),n(Gt),n(de),n(Bt),n(ce),n(Ct),n(xt),n(fe),n(kt),n(Vt),n(Me),n(At),n($t),n(ge),n(Rt),n(ye),n(Et),n(Ft),n(we),n(Xt),n(Dt),n(Te),n(Yt),n(St),n(Ue),n(Qt),n(je),n(Nt),n(Ze),n(Ht),n(zt),n(qt),n(Pt),n(Lt),n(c),n(Kt),n(Fe),n(Ot),n(en),n(x),n(tn),n(ct)),n(d),g(j,e),g(W,e),g(P,e),g(K,e),g(ee,e),g(te,e),g(se,e),g(V,e),g(oe,e),g(pe,e),g(me,e),g(ue,e),g(he,e),g(be,e),g(Je,e),g(_e,e),g(Ie,e),g(A,e),g($,e),g(ve,e),g(We),g(Ge),g(R),g(Be),g(Ce),g(xe),g(ke),g(Ve),g(Ae),g($e),g(Re),g(Ee),g(Xe,e),g(De)}}}const Ra='{"title":"Text-to-Video Generation with AnimateDiff","local":"text-to-video-generation-with-animatediff","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Available Pipelines","local":"available-pipelines","sections":[],"depth":2},{"title":"Available checkpoints","local":"available-checkpoints","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"AnimateDiffPipeline","local":"animatediffpipeline","sections":[],"depth":3},{"title":"AnimateDiffVideoToVideoPipeline","local":"animatediffvideotovideopipeline","sections":[],"depth":3}],"depth":2},{"title":"Using Motion LoRAs","local":"using-motion-loras","sections":[],"depth":2},{"title":"Using Motion LoRAs with PEFT","local":"using-motion-loras-with-peft","sections":[],"depth":2},{"title":"Using FreeInit","local":"using-freeinit","sections":[],"depth":2},{"title":"AnimateDiffPipeline","local":"diffusers.AnimateDiffPipeline","sections":[],"depth":2},{"title":"AnimateDiffPipelineOutput","local":"diffusers.pipelines.animatediff.AnimateDiffPipelineOutput","sections":[],"depth":2}],"depth":1}';function Ea(G){return va(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ha extends Wa{constructor(d){super(),Ga(this,d,Ea,$a,Ia,{})}}export{Ha as component};
