import{s as Ye,n as Be,o as Te}from"../chunks/scheduler.9bc65507.js";import{S as ze,i as xe,g as i,s as n,r as p,A as Ve,h as o,f as s,c as l,j as Je,u as r,x as m,k as Ne,l as be,y as Fe,a,v as u,d as f,t as b,w as h}from"../chunks/index.707bf1b6.js";import{C as F}from"../chunks/CodeBlock.54a9f38d.js";import{H as he}from"../chunks/Heading.342b1fa6.js";function Xe(ge){let c,S,X,G,y,I,k,de="Backbones are models used for feature extraction for computer vision tasks. One can use a model as backbone in two ways:",E,j,Me="<li>initializing <code>AutoBackbone</code> class with a pretrained model,</li> <li>initializing a supported backbone configuration and passing it to the model architecture.</li>",Q,w,L,C,ye=`You can use <code>AutoBackbone</code> class to initialize a model as a backbone and get the feature maps for any stage. You can define <code>out_indices</code> to indicate the index of the layers which you would like to get the feature maps from. You can also use <code>out_features</code> if you know the name of the layers. You can use them interchangeably. If you are using both <code>out_indices</code> and <code>out_features</code>, ensure they are consistent. Not passing any of the feature map arguments will make the backbone yield the feature maps of the last layer.
To visualize how stages look like, let’s take the Swin model. Each stage is responsible from feature extraction, outputting feature maps.`,A,g,ke='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/Swin%20Stages.png"/>',P,v,je="Illustrating feature maps of the first stage looks like below.",q,d,we='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/Swin%20Stage%201.png"/>',K,$,Ce="Let’s see with an example. Note that <code>out_indices=(0,)</code> results in yielding the stem of the model. Stem refers to the stage before the first feature extraction stage. In above diagram, it refers to patch partition. We would like to have the feature maps from stem, first, and second stage of the model.",D,U,O,Z,ve="<code>feature_maps</code> object now has three feature maps, each can be accessed like below. Say we would like to get the feature map of the stem.",ee,W,te,_,$e="We can get the feature maps of first and second stages like below.",se,R,ae,J,ne,N,Ue="In computer vision, models consist of backbone, neck, and a head. Backbone extracts the features, neck enhances the extracted features and head is used for the main task (e.g. object detection).",le,M,Ze='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/Backbone.png"/>',ie,Y,We='You can initialize such multiple-stage model with Backbone API. Initialize the config of the backbone of your choice first. Initialize the neck config by passing the backbone config in. Then, initialize the head with the neck’s config. To illustrate this, below you can see how to initialize the <a href="../model_doc/maskformer">MaskFormer</a> model with instance segmentation head with <a href="../model_doc/resnet">ResNet</a> backbone.',oe,B,me,T,_e="You can also initialize a backbone with random weights to initialize the model neck with it.",ce,z,pe,x,Re="<code>timm</code> models are also supported in transformers through <code>TimmBackbone</code> and <code>TimmBackboneConfig</code>.",re,V,ue,H,fe;return y=new he({props:{title:"Backbones",local:"backbones",headingTag:"h1"}}),w=new he({props:{title:"Using AutoBackbone",local:"using-autobackbone",headingTag:"h2"}}),U=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9CYWNrYm9uZSUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnN3aW4tdGlueS1wYXRjaDQtd2luZG93Ny0yMjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvQmFja2JvbmUuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnN3aW4tdGlueS1wYXRjaDQtd2luZG93Ny0yMjQlMjIlMkMlMjBvdXRfaW5kaWNlcyUzRCgwJTJDMSUyQzIpKSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFmZWF0dXJlX21hcHMlMjAlM0QlMjBvdXRwdXRzLmZlYXR1cmVfbWFwcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoBackbone
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoBackbone.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>, out_indices=(<span class="hljs-number">0</span>,<span class="hljs-number">1</span>,<span class="hljs-number">2</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>feature_maps = outputs.feature_maps`,wrap:!1}}),W=new F({props:{code:"bGlzdChmZWF0dXJlX21hcHMlNUIwJTVELnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(feature_maps[<span class="hljs-number">0</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">96</span>, <span class="hljs-number">56</span>, <span class="hljs-number">56</span>]`,wrap:!1}}),R=new F({props:{code:"bGlzdChmZWF0dXJlX21hcHMlNUIxJTVELnNoYXBlKSUwQWxpc3QoZmVhdHVyZV9tYXBzJTVCMiU1RC5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(feature_maps[<span class="hljs-number">1</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">96</span>, <span class="hljs-number">56</span>, <span class="hljs-number">56</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(feature_maps[<span class="hljs-number">2</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">192</span>, <span class="hljs-number">28</span>, <span class="hljs-number">28</span>]`,wrap:!1}}),J=new he({props:{title:"Initializing Backbone Configuration",local:"initializing-backbone-configuration",headingTag:"h2"}}),B=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hc2tGb3JtZXJDb25maWclMkMlMjBNYXNrRm9ybWVyRm9ySW5zdGFuY2VTZWdtZW50YXRpb24lMkMlMjBSZXNOZXRDb25maWclMEElMEFiYWNrYm9uZV9jb25maWclMjAlM0QlMjBSZXNOZXRDb25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnJlc25ldC01MCUyMiklMEFjb25maWclMjAlM0QlMjBNYXNrRm9ybWVyQ29uZmlnKGJhY2tib25lX2NvbmZpZyUzRGJhY2tib25lX2NvbmZpZyklMEFtb2RlbCUyMCUzRCUyME1hc2tGb3JtZXJGb3JJbnN0YW5jZVNlZ21lbnRhdGlvbihjb25maWcp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MaskFormerConfig, MaskFormerForInstanceSegmentation, ResNetConfig

backbone_config = ResNetConfig.from_pretrained(<span class="hljs-string">&quot;microsoft/resnet-50&quot;</span>)
config = MaskFormerConfig(backbone_config=backbone_config)
model = MaskFormerForInstanceSegmentation(config)`,wrap:!1}}),z=new F({props:{code:"YmFja2JvbmVfY29uZmlnJTIwJTNEJTIwUmVzTmV0Q29uZmlnKCklMEFjb25maWclMjAlM0QlMjBNYXNrRm9ybWVyQ29uZmlnKGJhY2tib25lX2NvbmZpZyUzRGJhY2tib25lX2NvbmZpZyklMEFtb2RlbCUyMCUzRCUyME1hc2tGb3JtZXJGb3JJbnN0YW5jZVNlZ21lbnRhdGlvbihjb25maWcp",highlighted:`backbone_config = ResNetConfig()
config = MaskFormerConfig(backbone_config=backbone_config)
model = MaskFormerForInstanceSegmentation(config)`,wrap:!1}}),V=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRpbW1CYWNrYm9uZUNvbmZpZyUyQyUyMFRpbW1CYWNrYm9uZSUwQSUwQWJhY2tib25lX2NvbmZpZyUyMCUzRCUyMFRpbW1CYWNrYm9uZUNvbmZpZyglMjJyZXNuZXQ1MCUyMiklMEFtb2RlbCUyMCUzRCUyMFRpbW1CYWNrYm9uZShjb25maWclM0RiYWNrYm9uZV9jb25maWcp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TimmBackboneConfig, TimmBackbone

backbone_config = TimmBackboneConfig(<span class="hljs-string">&quot;resnet50&quot;</span>)
model = TimmBackbone(config=backbone_config)`,wrap:!1}}),{c(){c=i("meta"),S=n(),X=i("p"),G=n(),p(y.$$.fragment),I=n(),k=i("p"),k.textContent=de,E=n(),j=i("ul"),j.innerHTML=Me,Q=n(),p(w.$$.fragment),L=n(),C=i("p"),C.innerHTML=ye,A=n(),g=i("div"),g.innerHTML=ke,P=n(),v=i("p"),v.textContent=je,q=n(),d=i("div"),d.innerHTML=we,K=n(),$=i("p"),$.innerHTML=Ce,D=n(),p(U.$$.fragment),O=n(),Z=i("p"),Z.innerHTML=ve,ee=n(),p(W.$$.fragment),te=n(),_=i("p"),_.textContent=$e,se=n(),p(R.$$.fragment),ae=n(),p(J.$$.fragment),ne=n(),N=i("p"),N.textContent=Ue,le=n(),M=i("div"),M.innerHTML=Ze,ie=n(),Y=i("p"),Y.innerHTML=We,oe=n(),p(B.$$.fragment),me=n(),T=i("p"),T.textContent=_e,ce=n(),p(z.$$.fragment),pe=n(),x=i("p"),x.innerHTML=Re,re=n(),p(V.$$.fragment),ue=n(),H=i("p"),this.h()},l(e){const t=Ve("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(s),S=l(e),X=o(e,"P",{}),Je(X).forEach(s),G=l(e),r(y.$$.fragment,e),I=l(e),k=o(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1832fle"&&(k.textContent=de),E=l(e),j=o(e,"UL",{"data-svelte-h":!0}),m(j)!=="svelte-19aqc1k"&&(j.innerHTML=Me),Q=l(e),r(w.$$.fragment,e),L=l(e),C=o(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-4yx6a9"&&(C.innerHTML=ye),A=l(e),g=o(e,"DIV",{style:!0,"data-svelte-h":!0}),m(g)!=="svelte-1r87dp3"&&(g.innerHTML=ke),P=l(e),v=o(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-1s6jmuf"&&(v.textContent=je),q=l(e),d=o(e,"DIV",{style:!0,"data-svelte-h":!0}),m(d)!=="svelte-1fx8pms"&&(d.innerHTML=we),K=l(e),$=o(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-19u2lr1"&&($.innerHTML=Ce),D=l(e),r(U.$$.fragment,e),O=l(e),Z=o(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-8vtz8w"&&(Z.innerHTML=ve),ee=l(e),r(W.$$.fragment,e),te=l(e),_=o(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1ifuecp"&&(_.textContent=$e),se=l(e),r(R.$$.fragment,e),ae=l(e),r(J.$$.fragment,e),ne=l(e),N=o(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-evb9c8"&&(N.textContent=Ue),le=l(e),M=o(e,"DIV",{style:!0,"data-svelte-h":!0}),m(M)!=="svelte-vf43ph"&&(M.innerHTML=Ze),ie=l(e),Y=o(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-mk9p6v"&&(Y.innerHTML=We),oe=l(e),r(B.$$.fragment,e),me=l(e),T=o(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-noz6gh"&&(T.textContent=_e),ce=l(e),r(z.$$.fragment,e),pe=l(e),x=o(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-tvty3m"&&(x.innerHTML=Re),re=l(e),r(V.$$.fragment,e),ue=l(e),H=o(e,"P",{}),Je(H).forEach(s),this.h()},h(){Ne(c,"name","hf:doc:metadata"),Ne(c,"content",He),be(g,"text-align","center"),be(d,"text-align","center"),be(M,"text-align","center")},m(e,t){Fe(document.head,c),a(e,S,t),a(e,X,t),a(e,G,t),u(y,e,t),a(e,I,t),a(e,k,t),a(e,E,t),a(e,j,t),a(e,Q,t),u(w,e,t),a(e,L,t),a(e,C,t),a(e,A,t),a(e,g,t),a(e,P,t),a(e,v,t),a(e,q,t),a(e,d,t),a(e,K,t),a(e,$,t),a(e,D,t),u(U,e,t),a(e,O,t),a(e,Z,t),a(e,ee,t),u(W,e,t),a(e,te,t),a(e,_,t),a(e,se,t),u(R,e,t),a(e,ae,t),u(J,e,t),a(e,ne,t),a(e,N,t),a(e,le,t),a(e,M,t),a(e,ie,t),a(e,Y,t),a(e,oe,t),u(B,e,t),a(e,me,t),a(e,T,t),a(e,ce,t),u(z,e,t),a(e,pe,t),a(e,x,t),a(e,re,t),u(V,e,t),a(e,ue,t),a(e,H,t),fe=!0},p:Be,i(e){fe||(f(y.$$.fragment,e),f(w.$$.fragment,e),f(U.$$.fragment,e),f(W.$$.fragment,e),f(R.$$.fragment,e),f(J.$$.fragment,e),f(B.$$.fragment,e),f(z.$$.fragment,e),f(V.$$.fragment,e),fe=!0)},o(e){b(y.$$.fragment,e),b(w.$$.fragment,e),b(U.$$.fragment,e),b(W.$$.fragment,e),b(R.$$.fragment,e),b(J.$$.fragment,e),b(B.$$.fragment,e),b(z.$$.fragment,e),b(V.$$.fragment,e),fe=!1},d(e){e&&(s(S),s(X),s(G),s(I),s(k),s(E),s(j),s(Q),s(L),s(C),s(A),s(g),s(P),s(v),s(q),s(d),s(K),s($),s(D),s(O),s(Z),s(ee),s(te),s(_),s(se),s(ae),s(ne),s(N),s(le),s(M),s(ie),s(Y),s(oe),s(me),s(T),s(ce),s(pe),s(x),s(re),s(ue),s(H)),s(c),h(y,e),h(w,e),h(U,e),h(W,e),h(R,e),h(J,e),h(B,e),h(z,e),h(V,e)}}}const He='{"title":"Backbones","local":"backbones","sections":[{"title":"Using AutoBackbone","local":"using-autobackbone","sections":[],"depth":2},{"title":"Initializing Backbone Configuration","local":"initializing-backbone-configuration","sections":[],"depth":2}],"depth":1}';function Se(ge){return Te(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Le extends ze{constructor(c){super(),xe(this,c,Se,Xe,Ye,{})}}export{Le as component};
