import{s as bn,o as Jn,n as jn}from"../chunks/scheduler.f7e1785c.js";import{S as Un,i as vn,g as i,s as n,r as c,A as kn,h as o,f as s,c as a,j as Tn,u as p,x as r,k as U,y as Cn,a as l,v as h,d as u,t as d,w as m,m as yt,n as Mt}from"../chunks/index.9f8f0838.js";import{T as rl}from"../chunks/Tip.4575d9cf.js";import{C as y}from"../chunks/CodeBlock.b3510e34.js";import{H as J}from"../chunks/Heading.6643a2f7.js";function $n(k){let w;return{c(){w=yt(`The following section requires the use of a microphone to record a voice input. Since Google Colab machines do not
    have microphone compatibility, it is recommended to run this section locally, either on your CPU, or on a GPU if you
    have local access. The checkpoint sizes have been selected as those small enough to run adequately fast on CPU, so
    you will still get good performance without a GPU.`)},l(f){w=Mt(f,`The following section requires the use of a microphone to record a voice input. Since Google Colab machines do not
    have microphone compatibility, it is recommended to run this section locally, either on your CPU, or on a GPU if you
    have local access. The checkpoint sizes have been selected as those small enough to run adequately fast on CPU, so
    you will still get good performance without a GPU.`)},m(f,T){l(f,w,T)},d(f){f&&s(w)}}}function In(k){let w,f,T="Whisper Small English",v,g,N='"openai/whisper-small.en"',b;return{c(){w=yt("If you're using a GPU, you can increase the checkpoint size to use the "),f=i("a"),f.textContent=T,v=yt(` 
    checkpoint, which will return better transcription accuracy and still be within the required latency threshold. Simply swap the 
    model id to: `),g=i("code"),g.textContent=N,b=yt("."),this.h()},l(M){w=Mt(M,"If you're using a GPU, you can increase the checkpoint size to use the "),f=o(M,"A",{href:!0,"data-svelte-h":!0}),r(f)!=="svelte-1vwlxrf"&&(f.textContent=T),v=Mt(M,` 
    checkpoint, which will return better transcription accuracy and still be within the required latency threshold. Simply swap the 
    model id to: `),g=o(M,"CODE",{"data-svelte-h":!0}),r(g)!=="svelte-1roca6s"&&(g.textContent=N),b=Mt(M,"."),this.h()},h(){U(f,"href","https://huggingface.co/openai/whisper-small.en")},m(M,j){l(M,w,j),l(M,f,j),l(M,v,j),l(M,g,j),l(M,b,j)},p:jn,d(M){M&&(s(w),s(f),s(v),s(g),s(b))}}}function xn(k){let w;return{c(){w=yt(`Note that the first time calling this will trigger the model weights to be downloaded, which might take 
    some time depending on your Hub download speed.`)},l(f){w=Mt(f,`Note that the first time calling this will trigger the model weights to be downloaded, which might take 
    some time depending on your Hub download speed.`)},m(f,T){l(f,w,T)},d(f){f&&s(w)}}}function Zn(k){let w,f,T,v,g,N,b,M=`In this section, we’ll piece together three models that we’ve already had hands-on experience with to build an end-to-end
voice assistant called <strong>Marvin</strong> 🤖. Like Amazon’s Alexa or Apple’s Siri, Marvin is a virtual voice assistant who
responds to a particular ‘wake word’, then listens out for a spoken query, and finally responds with a spoken answer.`,j,L,cl="We can break down the voice assistant pipeline into four stages, each of which requires a standalone model:",gt,C,pl='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/voice_assistant.png"/>',Tt,S,bt,V,hl=`Voice assistants are constantly listening to the audio inputs coming through your device’s microphone, however they only
boot into action when a particular ‘wake word’ or ‘trigger word’ is spoken.`,Jt,A,ul=`The wake word detection task is handled by a small on-device audio classification model, which is much smaller and lighter
than the speech recognition model, often only several millions of parameters compared to several hundred millions for
speech recognition. Thus, it can be run continuously on your device without draining your battery. Only when the wake
word is detected is the larger speech recognition model launched, and afterwards it is shut down again.`,jt,q,Ut,Y,dl=`The next stage in the pipeline is transcribing the spoken query to text. In practice, transferring audio files from your
local device to the Cloud is slow due to the large nature of audio files, so it’s more efficient to transcribe them
directly using an automatic speech recognition (ASR) model on-device rather than using a model in the Cloud. The on-device
model might be smaller and thus less accurate than one hosted in the Cloud, but the faster inference speed makes it
worthwhile since we can run speech recognition in near real-time, our spoken audio utterance being transcribed as we say it.`,vt,Q,ml="We’re very familiar with the speech recognition process now, so this should be a piece of cake!",kt,E,Ct,R,fl=`Now that we know what the user asked, we need to generate a response! The best candidate models for this task are
<em>large language models (LLMs)</em>, since they are effectively able to understand the semantics of the text query and
generate a suitable response.`,$t,z,wl=`Since our text query is small (just a few text tokens), and language models large (many billions of parameters), the most
efficient way of running LLM inference is to send our text query from our device to an LLM running in the Cloud,
generate a text response, and return the response back to the device.`,It,X,xt,F,yl=`Finally, we’ll use a text-to-speech (TTS) model to synthesise the text response as spoken speech. This is done
on-device, but you could feasibly run a TTS model in the Cloud, generating the audio output and transferring it back to
the device.`,Zt,P,Ml="Again, we’ve done this several times now, so the process will be very familiar!",Wt,$,_t,D,Ht,K,gl=`The first stage in the voice assistant pipeline is detecting whether the wake word was spoken, and we need to find ourselves
an appropriate pre-trained model for this task! You’ll remember from the section on <a href="../chapter4/classification_models">pre-trained models for audio classification</a>
that <a href="https://huggingface.co/datasets/speech_commands" rel="nofollow">Speech Commands</a> is a dataset of spoken words designed to
evaluate audio classification models on 15+ simple command words like <code>&quot;up&quot;</code>, <code>&quot;down&quot;</code>, <code>&quot;yes&quot;</code> and <code>&quot;no&quot;</code>, as well as a
<code>&quot;silence&quot;</code> label to classify no speech. Take a minute to listen through the samples on the datasets viewer on
the Hub and re-acquaint yourself with the Speech Commands dataset: <a href="https://huggingface.co/datasets/speech_commands/viewer/v0.01/train" rel="nofollow">datasets viewer</a>.`,Bt,O,Tl=`We can take an audio classification model pre-trained on the Speech Commands dataset and pick one of these simple command
words to be our chosen wake word. Out of the 15+ possible command words, if the model predicts our chosen wake word with the
highest probability, we can be fairly certain that the wake word has been said.`,Gt,ee,bl='Let’s head to the Hugging Face Hub and click on the “Models” tab: <a href="https://huggingface.co/models" rel="nofollow">https://huggingface.co/models</a>',Nt,te,Jl="This is going to bring up all the models on the Hugging Face Hub, sorted by downloads in the past 30 days:",Lt,I,jl='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/all_models.png"/>',St,se,Ul=`You’ll notice on the left-hand side that we have a selection of tabs that we can select to filter models by task, library,
dataset, etc. Scroll down and select the task “Audio Classification” from the list of audio tasks:`,Vt,x,vl='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/by_audio_classification.png"/>',At,le,kl=`We’re now presented with the sub-set of 500+ audio classification models on the Hub. To further refine this selection, we
can filter models by dataset. Click on the tab “Datasets”, and in the search box type “speech_commands”. As you begin typing,
you’ll see the selection for <code>speech_commands</code> appear underneath the search tab. You can click this button to filter all
audio classification models to those fine-tuned on the Speech Commands dataset:`,qt,Z,Cl='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/by_speech_commands.png"/>',Yt,ne,$l=`Great! We see that we have six pre-trained models available to us for this specific dataset and task (although there may
be new models added if you’re reading at a later date!). You’ll recognise the first of these models as the <a href="https://huggingface.co/MIT/ast-finetuned-speech-commands-v2" rel="nofollow">Audio Spectrogram Transformer checkpoint</a>
that we used in Unit 4 example. We’ll use this checkpoint again for our wake word detection task.`,Qt,ae,Il="Let’s go ahead and load the checkpoint using the <code>pipeline</code> class:",Et,ie,Rt,oe,xl="We can check what labels the model was trained on by checking the <code>id2label</code> attribute in the model config:",zt,re,Xt,ce,Zl=`Alright! We see that the model was trained on 35 class labels, including some simple command words that we described above,
as well as some particular objects like <code>&quot;bed&quot;</code>, <code>&quot;house&quot;</code> and <code>&quot;cat&quot;</code>. We see that there is one name in these class labels:
id 27 corresponds to the label <strong>“marvin”</strong>:`,Ft,pe,Pt,he,Dt,ue,Wl=`Perfect! We can use this name as our wake word for our voice assistant, similar to how “Alexa” is used for Amazon’s Alexa,
or “Hey Siri” is used for Apple’s Siri. Of all the possible labels, if the model predicts <code>&quot;marvin&quot;</code> with the highest class
probability, we can be fairly sure that our chosen wake word has been said.`,Kt,de,_l=`Now we need to define a function that is constantly listening to our device’s microphone input, and continuously
passes the audio to the classification model for inference. To do this, we’ll use a handy helper function that comes
with 🤗 Transformers called <a href="https://github.com/huggingface/transformers/blob/fb78769b9c053876ed7ae152ee995b0439a4462a/src/transformers/pipelines/audio_utils.py#L98" rel="nofollow"><code>ffmpeg_microphone_live</code></a>.`,Ot,me,Hl=`This function forwards small chunks of audio of specified length <code>chunk_length_s</code> to the model to be classified. To ensure that
we get smooth boundaries across chunks of audio, we run a sliding window across our audio with stride <code>chunk_length_s / 6</code>.
So that we don’t have to wait for the entire first chunk to be recorded before we start inferring, we also define a minimal
temporary audio input length <code>stream_chunk_s</code> that is forwarded to the model before <code>chunk_length_s</code> time is reached.`,es,fe,Bl=`The function <code>ffmpeg_microphone_live</code> returns a <em>generator</em> object, yielding a sequence of audio chunks that can each
be passed to the classification model to make a prediction. We can pass this generator directly to the <code>pipeline</code>,
which in turn returns a sequence of output predictions, one for each chunk of audio input. We can inspect the class
label probabilities for each audio chunk, and stop our wake word detection loop when we detect that the wake word
has been spoken.`,ts,we,Gl=`We’ll use a very simple criteria for classifying whether our wake word was spoken: if the class label with the highest
probability was our wake word, and this probability exceeds a threshold <code>prob_threshold</code>, we declare that the wake word
as having been spoken. Using a probability threshold to gate our classifier this way ensures that the wake word is not
erroneously predicted if the audio input is noise, which is typically when the model is very uncertain and all the class
label probabilities low. You might want to tune this probability threshold, or explore more sophisticated means for
the wake word decision through an <a href="https://en.wikipedia.org/wiki/Entropy_(information_theory)" rel="nofollow"><em>entropy</em></a> (or uncertainty) based metric.`,ss,ye,ls,Me,Nl=`Let’s give this function a try to see how it works! We’ll set the flag <code>debug=True</code> to print out the prediction for each
chunk of audio. Let the model run for a few seconds to see the kinds of predictions that it makes when there is no speech
input, then clearly say the wake word <code>&quot;marvin&quot;</code> and watch the class label prediction for <code>&quot;marvin&quot;</code> spike to near 1:`,ns,ge,as,Te,is,be,Ll=`Awesome! As we expect, the model generates garbage predictions for the first few seconds. There is no speech input, so the
model makes close to random predictions, but with very low probability. As soon as we say the wake word, the model predicts
<code>&quot;marvin&quot;</code> with probability close to 1 and terminates the loop, signalling that the wake word has been detected and that the
ASR system should be activated!`,os,Je,rs,je,Sl=`Once again, we’ll use the Whisper model for our speech transcription system. Specifically, we’ll load the <a href="https://huggingface.co/openai/whisper-base.en" rel="nofollow">Whisper Base English</a>
checkpoint, since it’s small enough to give good inference speed with reasonable transcription accuracy. We’ll use a trick
to get near real-time transcription by being clever with how we forward our audio inputs to the model. As before, feel
free to use any speech recognition checkpoint on <a href="https://huggingface.co/models?pipeline_tag=automatic-speech-recognition&amp;library=transformers&amp;sort=trending" rel="nofollow">the Hub</a>,
including Wav2Vec2, MMS ASR or other Whisper checkpoints:`,cs,Ue,ps,W,hs,ve,Vl=`We can now define a function to record our microphone input and transcribe the corresponding text. With the <code>ffmpeg_microphone_live</code>
helper function, we can control how ‘real-time’ our speech recognition model is. Using a smaller <code>stream_chunk_s</code> lends
itself to more real-time speech recognition, since we divide our input audio into smaller chunks and transcribe them on
the fly. However, this comes at the expense of poorer accuracy, since there’s less context for the model to infer from.`,us,ke,Al=`As we’re transcribing the speech, we also need to have an idea of when the user <strong>stops</strong> speaking, so that we can terminate
the recording. For simplicity, we’ll terminate our microphone recording after the first <code>chunk_length_s</code> (which is set to
5 seconds by default), but you can experiment with using a <a href="https://huggingface.co/models?pipeline_tag=voice-activity-detection&amp;sort=trending" rel="nofollow">voice activity detection (VAD)</a>
model to predict when the user has stopped speaking.`,ds,Ce,ms,$e,ql=`Let’s give this a go and see how we get on! Once the microphone is live, start speaking and watch your transcription
appear in semi real-time:`,fs,Ie,ws,xe,ys,Ze,Yl=`Nice! You can adjust the maximum audio length <code>chunk_length_s</code> based on how fast or slow you speak (increase it if you
felt like you didn’t have enough time to speak, decrease it if you were left waiting at the end), and the
<code>stream_chunk_s</code> for the real-time factor. Just pass these as arguments to the <code>transcribe</code> function.`,Ms,We,gs,_e,Ql=`Now that we have our spoken query transcribed, we want to generate a meaningful response. To do this, we’ll use an LLM
hosted on the Cloud. Specifically, we’ll pick an LLM on the Hugging Face Hub and use the <a href="https://huggingface.co/inference-api" rel="nofollow">Inference API</a>
to easily query the model.`,Ts,He,El=`First, let’s head over to the Hugging Face Hub. To find our LLM, we’ll use the <a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">🤗 Open LLM Leaderboard</a>,
a Space that ranks LLM models by performance over four generation tasks. We’ll search by “instruct” to filter out models
that have been instruction fine-tuned, since these should work better for our querying task:`,bs,_,Rl='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/llm_leaderboard.png"/>',Js,Be,zl=`We’ll use the <a href="https://huggingface.co/tiiuae/falcon-7b-instruct" rel="nofollow">tiiuae/falcon-7b-instruct</a> checkpoint by <a href="https://www.tii.ae/" rel="nofollow">TII</a>,
a 7B parameter decoder-only LM fine-tuned on a mixture of chat and instruction datasets. You can use any LLM on the Hugging
Face Hub that has the “Hosted inference API” enabled, just look out for the widget on the right-side of the model card:`,js,H,Xl='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/inference_api.png"/>',Us,Ge,Fl=`The Inference API allows us to send a HTTP request from our local machine to the LLM hosted on the Hub, and returns the
response as a <code>json</code> file. All we need to provide is our Hugging Face Hub token (which we retrieve directly from our Hugging Face
Hub folder) and the model id of the LLM we wish to query:`,vs,Ne,ks,Le,Pl="Let’s give it a try with a test input!",Cs,Se,$s,Ve,Is,Ae,Dl=`You’ll notice just how fast inference is using the Inference API - we only have to send a small number of text tokens
from our local machine to the hosted model, so the communication cost is very low. The LLM is hosted on GPU accelerators,
so inference runs very quickly. Finally, the generated response is transferred back from the model to our local machine,
again with low communication overhead.`,xs,qe,Zs,Ye,Kl=`And now we’re ready to get the final spoken output! Once again, we’ll use the Microsoft <a href="https://huggingface.co/microsoft/speecht5_tts" rel="nofollow">SpeechT5 TTS</a>
model for English TTS, but you can use any TTS model of your choice. Let’s go ahead and load the processor and model:`,Ws,Qe,_s,Ee,Ol="And also the speaker embeddings:",Hs,Re,Bs,ze,en='We’ll re-use the <code>synthesise</code> function that we defined in the previous chapter on <a href="speech-to-speech">Speech-to-speech translation</a>:',Gs,Xe,Ns,Fe,tn="Let’s quickly verify this works as expected:",Ls,Pe,Ss,De,sn="Nice job 👍",Vs,Ke,As,Oe,ln=`Now that we’ve defined a function for each of the four stages of the voice assistant pipeline, all that’s left to do is
piece them together to get our end-to-end voice assistant. We’ll simply concatenate the four stages, starting with
wake word detection (<code>launch_fn</code>), speech transcription, querying the LLM, and finally speech synthesis.`,qs,et,Ys,tt,nn="Try it out with a few prompts! Here are some examples to get you started:",Qs,st,an="<li><em>What is the hottest country in the world?</em></li> <li><em>How do Transformer models work?</em></li> <li><em>Do you know Spanish?</em></li>",Es,lt,on=`And with that, we have our end-to-end voice assistant complete, made using the 🤗 audio tools you’ve learnt throughout
this course, with a sprinkling of LLM magic at the end. There are several extensions that we could make to improve the
voice assistant. Firstly, the audio classification model classifies 35 different labels. We could use a smaller, more
lightweight binary classification model that only predicts whether the wake word was spoken or not. Secondly, we pre-load
all the models ahead and keep them running on our device. If we wanted to save power, we would only load each model at
the time it was required, and subsequently un-load them afterwards. Thirdly, we’re missing a voice activity detection model
in our transcription function, transcribing for a fixed amount of time, which in some cases is too long, and in others too
short.`,Rs,nt,zs,at,rn=`So far, we’ve seen how we can generate speech outputs with our voice assistant Marvin. To finish, we’ll demonstrate how
we can generalise these speech outputs to text, audio and image.`,Xs,it,cn=`We’ll use <a href="https://huggingface.co/docs/transformers/transformers_agents" rel="nofollow">Transformers Agents</a> to build our assistant.
Transformers Agents provides a natural language API on top of the 🤗 Transformers and Diffusers libraries, interpreting
a natural language input using an LLM with carefully crafted prompts, and using a set of curated tools to provide
multimodal outputs.`,Fs,ot,pn=`Let’s go ahead and instantiate an agent. There are <a href="https://huggingface.co/docs/transformers/transformers_agents#quickstart" rel="nofollow">three LLMs available</a>
for Transformers Agents, two of which are open-source and free on the Hugging Face Hub. The third is a model from OpenAI
that requires an OpenAI API key. We’ll use the free <a href="https://huggingface.co/bigcode/starcoder" rel="nofollow">Bigcode Starcoder</a> model
in this example, but you can also try either of the other LLMs available:`,Ps,rt,Ds,ct,hn=`To use the agent, we simply have to call <code>agent.run</code> with our text prompt. As an example, we’ll get it to generate an
image of a cat 🐈 (that hopefully looks a bit better than this emoji):`,Ks,pt,Os,B,un='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/generated_cat.png"/>',el,G,tl,ht,dn=`Easy as that! The Agent interpreted our prompt, and used <a href="https://huggingface.co/docs/diffusers/using-diffusers/conditional_image_generation" rel="nofollow">Stable Diffusion</a>
under the hood to generate the image, without us having to worry about loading the model, writing the function or executing
the code.`,sl,ut,mn=`We can now replace our LLM query function and text synthesis step with our Transformers Agent in our voice assistant,
since the Agent is going to take care of both of these steps for us:`,ll,dt,nl,mt,fn=`Try speaking the same prompt “Generate an image of a cat” and see how the system gets on. If you ask the Agent a simple
question / answer query, the Agent will respond with a text answer. You can encourage it to generate multimodal outputs
by asking it to return an image or speech. For example, you can ask it to: “Generate an image of a cat, caption it, and
speak the caption”.`,al,ft,wn=`While the Agent is more flexible than our first iteration Marvin 🤖 assistant, generalising the voice assistant task in this way
may lead to inferior performance on standard voice assistant queries. To recover performance, you can try using a
more performant LLM checkpoint, such as the one from OpenAI, or define a set of <a href="https://huggingface.co/docs/transformers/transformers_agents#custom-tools" rel="nofollow">custom tools</a>
that are specific to the voice assistant task.`,il,wt,ol;return g=new J({props:{title:"Creating a voice assistant",local:"creating-a-voice-assistant",headingTag:"h1"}}),S=new J({props:{title:"1. Wake word detection",local:"1-wake-word-detection",headingTag:"h3"}}),q=new J({props:{title:"2. Speech transcription",local:"2-speech-transcription",headingTag:"h3"}}),E=new J({props:{title:"3. Language model query",local:"3-language-model-query",headingTag:"h3"}}),X=new J({props:{title:"4. Synthesise speech",local:"4-synthesise-speech",headingTag:"h3"}}),$=new rl({props:{$$slots:{default:[$n]},$$scope:{ctx:k}}}),D=new J({props:{title:"Wake word detection",local:"wake-word-detection",headingTag:"h2"}}),ie=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTNBMCUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEFjbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYXVkaW8tY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMk1JVCUyRmFzdC1maW5ldHVuZWQtc3BlZWNoLWNvbW1hbmRzLXYyJTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;MIT/ast-finetuned-speech-commands-v2&quot;</span>, device=device
)`,wrap:!1}}),re=new y({props:{code:"Y2xhc3NpZmllci5tb2RlbC5jb25maWcuaWQybGFiZWw=",highlighted:"classifier.model.config.id2label",wrap:!1}}),pe=new y({props:{code:"Y2xhc3NpZmllci5tb2RlbC5jb25maWcuaWQybGFiZWwlNUIyNyU1RA==",highlighted:'classifier.model.config.id2label[<span class="hljs-number">27</span>]',wrap:!1}}),he=new y({props:{code:"J21hcnZpbic=",highlighted:'<span class="hljs-symbol">&#x27;marvin</span>&#x27;',wrap:!1}}),ye=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers.pipelines.audio_utils <span class="hljs-keyword">import</span> ffmpeg_microphone_live


<span class="hljs-keyword">def</span> <span class="hljs-title function_">launch_fn</span>(<span class="hljs-params">
    wake_word=<span class="hljs-string">&quot;marvin&quot;</span>,
    prob_threshold=<span class="hljs-number">0.5</span>,
    chunk_length_s=<span class="hljs-number">2.0</span>,
    stream_chunk_s=<span class="hljs-number">0.25</span>,
    debug=<span class="hljs-literal">False</span>,
</span>):
    <span class="hljs-keyword">if</span> wake_word <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> classifier.model.config.label2id.keys():
        <span class="hljs-keyword">raise</span> ValueError(
            <span class="hljs-string">f&quot;Wake word <span class="hljs-subst">{wake_word}</span> not in set of valid class labels, pick a wake word in the set <span class="hljs-subst">{classifier.model.config.label2id.keys()}</span>.&quot;</span>
        )

    sampling_rate = classifier.feature_extractor.sampling_rate

    mic = ffmpeg_microphone_live(
        sampling_rate=sampling_rate,
        chunk_length_s=chunk_length_s,
        stream_chunk_s=stream_chunk_s,
    )

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Listening for wake word...&quot;</span>)
    <span class="hljs-keyword">for</span> prediction <span class="hljs-keyword">in</span> classifier(mic):
        prediction = prediction[<span class="hljs-number">0</span>]
        <span class="hljs-keyword">if</span> debug:
            <span class="hljs-built_in">print</span>(prediction)
        <span class="hljs-keyword">if</span> prediction[<span class="hljs-string">&quot;label&quot;</span>] == wake_word:
            <span class="hljs-keyword">if</span> prediction[<span class="hljs-string">&quot;score&quot;</span>] &gt; prob_threshold:
                <span class="hljs-keyword">return</span> <span class="hljs-literal">True</span>`,wrap:!1}}),ge=new y({props:{code:"bGF1bmNoX2ZuKGRlYnVnJTNEVHJ1ZSk=",highlighted:'launch_fn(debug=<span class="hljs-literal">True</span>)',wrap:!1}}),Te=new y({props:{code:"TGlzdGVuaW5nJTIwZm9yJTIwd2FrZSUyMHdvcmQuLi4lMEElN0Inc2NvcmUnJTNBJTIwMC4wNTUzMjYxMDc4ODk0MTM4MzQlMkMlMjAnbGFiZWwnJTNBJTIwJ29uZSclN0QlMEElN0Inc2NvcmUnJTNBJTIwMC4wNTk5OTg1NjgxNDc0MjA4OCUyQyUyMCdsYWJlbCclM0ElMjAnb2ZmJyU3RCUwQSU3QidzY29yZSclM0ElMjAwLjEyODI3NDg0MzA5NjczMzElMkMlMjAnbGFiZWwnJTNBJTIwJ2ZpdmUnJTdEJTBBJTdCJ3Njb3JlJyUzQSUyMDAuMDczMTAxMTAzMzA1ODE2NjUlMkMlMjAnbGFiZWwnJTNBJTIwJ2ZvbGxvdyclN0QlMEElN0Inc2NvcmUnJTNBJTIwMC4wNjYzNDgwOTgyMTg0NDEwMSUyQyUyMCdsYWJlbCclM0ElMjAnZm9sbG93JyU3RCUwQSU3QidzY29yZSclM0ElMjAwLjA1OTkyNjQyNDE3NTUwMDg3JTJDJTIwJ2xhYmVsJyUzQSUyMCd0cmVlJyU3RCUwQSU3QidzY29yZSclM0ElMjAwLjA1OTkyNjQyNDE3NTUwMDg3JTJDJTIwJ2xhYmVsJyUzQSUyMCd0cmVlJyU3RCUwQSU3QidzY29yZSclM0ElMjAwLjk5OTkxMzIxNTYzNzIwNyUyQyUyMCdsYWJlbCclM0ElMjAnbWFydmluJyU3RA==",highlighted:`Listening for wake word...
{&#x27;score&#x27;: 0.055326107889413834, &#x27;label&#x27;: &#x27;one&#x27;}
{&#x27;score&#x27;: 0.05999856814742088, &#x27;label&#x27;: &#x27;off&#x27;}
{&#x27;score&#x27;: 0.1282748430967331, &#x27;label&#x27;: &#x27;five&#x27;}
{&#x27;score&#x27;: 0.07310110330581665, &#x27;label&#x27;: &#x27;follow&#x27;}
{&#x27;score&#x27;: 0.06634809821844101, &#x27;label&#x27;: &#x27;follow&#x27;}
{&#x27;score&#x27;: 0.05992642417550087, &#x27;label&#x27;: &#x27;tree&#x27;}
{&#x27;score&#x27;: 0.05992642417550087, &#x27;label&#x27;: &#x27;tree&#x27;}
{&#x27;score&#x27;: 0.999913215637207, &#x27;label&#x27;: &#x27;marvin&#x27;}`,wrap:!1}}),Je=new J({props:{title:"Speech transcription",local:"speech-transcription",headingTag:"h2"}}),Ue=new y({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJvcGVuYWklMkZ3aGlzcGVyLWJhc2UuZW4lMjIlMkMlMjBkZXZpY2UlM0RkZXZpY2UlMEEp",highlighted:`transcriber = pipeline(
    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-base.en&quot;</span>, device=device
)`,wrap:!1}}),W=new rl({props:{$$slots:{default:[In]},$$scope:{ctx:k}}}),Ce=new y({props:{code:"aW1wb3J0JTIwc3lzJTBBJTBBJTBBZGVmJTIwdHJhbnNjcmliZShjaHVua19sZW5ndGhfcyUzRDUuMCUyQyUyMHN0cmVhbV9jaHVua19zJTNEMS4wKSUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlMjAlM0QlMjB0cmFuc2NyaWJlci5mZWF0dXJlX2V4dHJhY3Rvci5zYW1wbGluZ19yYXRlJTBBJTBBJTIwJTIwJTIwJTIwbWljJTIwJTNEJTIwZmZtcGVnX21pY3JvcGhvbmVfbGl2ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzYW1wbGluZ19yYXRlJTNEc2FtcGxpbmdfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEY2h1bmtfbGVuZ3RoX3MlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdHJlYW1fY2h1bmtfcyUzRHN0cmVhbV9jaHVua19zJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMlN0YXJ0JTIwc3BlYWtpbmcuLi4lMjIpJTBBJTIwJTIwJTIwJTIwZm9yJTIwaXRlbSUyMGluJTIwdHJhbnNjcmliZXIobWljJTJDJTIwZ2VuZXJhdGVfa3dhcmdzJTNEJTdCJTIybWF4X25ld190b2tlbnMlMjIlM0ElMjAxMjglN0QpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3lzLnN0ZG91dC53cml0ZSglMjIlNUMwMzMlNUJLJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGl0ZW0lNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwZW5kJTNEJTIyJTVDciUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMG5vdCUyMGl0ZW0lNUIlMjJwYXJ0aWFsJTIyJTVEJTVCMCU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaXRlbSU1QiUyMnRleHQlMjIlNUQ=",highlighted:`<span class="hljs-keyword">import</span> sys


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe</span>(<span class="hljs-params">chunk_length_s=<span class="hljs-number">5.0</span>, stream_chunk_s=<span class="hljs-number">1.0</span></span>):
    sampling_rate = transcriber.feature_extractor.sampling_rate

    mic = ffmpeg_microphone_live(
        sampling_rate=sampling_rate,
        chunk_length_s=chunk_length_s,
        stream_chunk_s=stream_chunk_s,
    )

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Start speaking...&quot;</span>)
    <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> transcriber(mic, generate_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">128</span>}):
        sys.stdout.write(<span class="hljs-string">&quot;\\033[K&quot;</span>)
        <span class="hljs-built_in">print</span>(item[<span class="hljs-string">&quot;text&quot;</span>], end=<span class="hljs-string">&quot;\\r&quot;</span>)
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> item[<span class="hljs-string">&quot;partial&quot;</span>][<span class="hljs-number">0</span>]:
            <span class="hljs-keyword">break</span>

    <span class="hljs-keyword">return</span> item[<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),Ie=new y({props:{code:"dHJhbnNjcmliZSgp",highlighted:"transcribe()",wrap:!1}}),xe=new y({props:{code:"U3RhcnQlMjBzcGVha2luZy4uLiUwQSUyMEhleSUyQyUyMHRoaXMlMjBpcyUyMGElMjB0ZXN0JTIwd2l0aCUyMHRoZSUyMHdoaXNwZXIlMjBtb2RlbC4=",highlighted:`Start speaking...
 Hey, this is a test with the whisper model.`,wrap:!1}}),We=new J({props:{title:"Language model query",local:"language-model-query",headingTag:"h2"}}),Ne=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRm9sZGVyJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMEFkZWYlMjBxdWVyeSh0ZXh0JTJDJTIwbW9kZWxfaWQlM0QlMjJ0aWl1YWUlMkZmYWxjb24tN2ItaW5zdHJ1Y3QlMjIpJTNBJTBBJTIwJTIwJTIwJTIwYXBpX3VybCUyMCUzRCUyMGYlMjJodHRwcyUzQSUyRiUyRmFwaS1pbmZlcmVuY2UuaHVnZ2luZ2ZhY2UuY28lMkZtb2RlbHMlMkYlN0Jtb2RlbF9pZCU3RCUyMiUwQSUyMCUyMCUyMCUyMGhlYWRlcnMlMjAlM0QlMjAlN0IlMjJBdXRob3JpemF0aW9uJTIyJTNBJTIwZiUyMkJlYXJlciUyMCU3QkhmRm9sZGVyKCkuZ2V0X3Rva2VuKCklN0QlMjIlN0QlMEElMjAlMjAlMjAlMjBwYXlsb2FkJTIwJTNEJTIwJTdCJTIyaW5wdXRzJTIyJTNBJTIwdGV4dCU3RCUwQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJRdWVyeWluZy4uLiUzQSUyMCU3QnRleHQlN0QlMjIpJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5wb3N0KGFwaV91cmwlMkMlMjBoZWFkZXJzJTNEaGVhZGVycyUyQyUyMGpzb24lM0RwYXlsb2FkKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHJlc3BvbnNlLmpzb24oKSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCU1Qmxlbih0ZXh0KSUyMCUyQiUyMDElMjAlM0ElNUQ=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFolder
<span class="hljs-keyword">import</span> requests


<span class="hljs-keyword">def</span> <span class="hljs-title function_">query</span>(<span class="hljs-params">text, model_id=<span class="hljs-string">&quot;tiiuae/falcon-7b-instruct&quot;</span></span>):
    api_url = <span class="hljs-string">f&quot;https://api-inference.huggingface.co/models/<span class="hljs-subst">{model_id}</span>&quot;</span>
    headers = {<span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{HfFolder().get_token()}</span>&quot;</span>}
    payload = {<span class="hljs-string">&quot;inputs&quot;</span>: text}

    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Querying...: <span class="hljs-subst">{text}</span>&quot;</span>)
    response = requests.post(api_url, headers=headers, json=payload)
    <span class="hljs-keyword">return</span> response.json()[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-built_in">len</span>(text) + <span class="hljs-number">1</span> :]`,wrap:!1}}),Se=new y({props:{code:"cXVlcnkoJTIyV2hhdCUyMGRvZXMlMjBIdWdnaW5nJTIwRmFjZSUyMGRvJTNGJTIyKQ==",highlighted:'query(<span class="hljs-string">&quot;What does Hugging Face do?&quot;</span>)',wrap:!1}}),Ve=new y({props:{code:"J0h1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwY29tcGFueSUyMHRoYXQlMjBwcm92aWRlcyUyMG5hdHVyYWwlMjBsYW5ndWFnZSUyMHByb2Nlc3NpbmclMjBhbmQlMjBtYWNoaW5lJTIwbGVhcm5pbmclMjB0b29scyUyMGZvciUyMGRldmVsb3BlcnMuJTIwVGhleSc=",highlighted:'<span class="hljs-comment">&#x27;Hugging Face is a company that provides natural language processing and machine learning tools for developers. They&#x27;</span>',wrap:!1}}),qe=new J({props:{title:"Synthesise speech",local:"synthesise-speech",headingTag:"h2"}}),Qe=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTJDJTIwU3BlZWNoVDVGb3JUZXh0VG9TcGVlY2glMkMlMjBTcGVlY2hUNUhpZmlHYW4lMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBTcGVlY2hUNVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGc3BlZWNodDVfdHRzJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwU3BlZWNoVDVGb3JUZXh0VG9TcGVlY2guZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMikudG8oZGV2aWNlKSUwQXZvY29kZXIlMjAlM0QlMjBTcGVlY2hUNUhpZmlHYW4uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X2hpZmlnYW4lMjIpLnRvKGRldmljZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor, SpeechT5ForTextToSpeech, SpeechT5HifiGan

processor = SpeechT5Processor.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>)

model = SpeechT5ForTextToSpeech.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>).to(device)
vocoder = SpeechT5HifiGan.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_hifigan&quot;</span>).to(device)`,wrap:!1}}),Re=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZW1iZWRkaW5nc19kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMk1hdHRoaWpzJTJGY211LWFyY3RpYy14dmVjdG9ycyUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjB0b3JjaC50ZW5zb3IoZW1iZWRkaW5nc19kYXRhc2V0JTVCNzMwNiU1RCU1QiUyMnh2ZWN0b3IlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

embeddings_dataset = load_dataset(<span class="hljs-string">&quot;Matthijs/cmu-arctic-xvectors&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
speaker_embeddings = torch.tensor(embeddings_dataset[<span class="hljs-number">7306</span>][<span class="hljs-string">&quot;xvector&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),Xe=new y({props:{code:"ZGVmJTIwc3ludGhlc2lzZSh0ZXh0KSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTIwJTIwJTIwJTIwc3BlZWNoJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGVfc3BlZWNoKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RC50byhkZXZpY2UpJTJDJTIwc3BlYWtlcl9lbWJlZGRpbmdzLnRvKGRldmljZSklMkMlMjB2b2NvZGVyJTNEdm9jb2RlciUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVlY2guY3B1KCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">synthesise</span>(<span class="hljs-params">text</span>):
    inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    speech = model.generate_speech(
        inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].to(device), speaker_embeddings.to(device), vocoder=vocoder
    )
    <span class="hljs-keyword">return</span> speech.cpu()`,wrap:!1}}),Pe=new y({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBYXVkaW8lMjAlM0QlMjBzeW50aGVzaXNlKCUwQSUyMCUyMCUyMCUyMCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwY29tcGFueSUyMHRoYXQlMjBwcm92aWRlcyUyMG5hdHVyYWwlMjBsYW5ndWFnZSUyMHByb2Nlc3NpbmclMjBhbmQlMjBtYWNoaW5lJTIwbGVhcm5pbmclMjB0b29scyUyMGZvciUyMGRldmVsb3BlcnMuJTIyJTBBKSUwQSUwQUF1ZGlvKGF1ZGlvJTJDJTIwcmF0ZSUzRDE2MDAwKQ==",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

audio = synthesise(
    <span class="hljs-string">&quot;Hugging Face is a company that provides natural language processing and machine learning tools for developers.&quot;</span>
)

Audio(audio, rate=<span class="hljs-number">16000</span>)`,wrap:!1}}),Ke=new J({props:{title:"Marvin 🤖",local:"marvin-",headingTag:"h2"}}),et=new y({props:{code:"bGF1bmNoX2ZuKCklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwdHJhbnNjcmliZSgpJTBBcmVzcG9uc2UlMjAlM0QlMjBxdWVyeSh0cmFuc2NyaXB0aW9uKSUwQWF1ZGlvJTIwJTNEJTIwc3ludGhlc2lzZShyZXNwb25zZSklMEElMEFBdWRpbyhhdWRpbyUyQyUyMHJhdGUlM0QxNjAwMCUyQyUyMGF1dG9wbGF5JTNEVHJ1ZSk=",highlighted:`launch_fn()
transcription = transcribe()
response = query(transcription)
audio = synthesise(response)

Audio(audio, rate=<span class="hljs-number">16000</span>, autoplay=<span class="hljs-literal">True</span>)`,wrap:!1}}),nt=new J({props:{title:"Generalise to anything 🪄",local:"generalise-to-anything-",headingTag:"h2"}}),rt=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhmQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMEhmQWdlbnQoJTBBJTIwJTIwJTIwJTIwdXJsX2VuZHBvaW50JTNEJTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGYmlnY29kZSUyRnN0YXJjb2RlciUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HfAgent

agent = HfAgent(
    url_endpoint=<span class="hljs-string">&quot;https://api-inference.huggingface.co/models/bigcode/starcoder&quot;</span>
)`,wrap:!1}}),pt=new y({props:{code:"YWdlbnQucnVuKCUyMkdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMG9mJTIwYSUyMGNhdCUyMik=",highlighted:'agent.run(<span class="hljs-string">&quot;Generate an image of a cat&quot;</span>)',wrap:!1}}),G=new rl({props:{$$slots:{default:[xn]},$$scope:{ctx:k}}}),dt=new y({props:{code:"bGF1bmNoX2ZuKCklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwdHJhbnNjcmliZSgpJTBBYWdlbnQucnVuKHRyYW5zY3JpcHRpb24p",highlighted:`launch_fn()
transcription = transcribe()
agent.run(transcription)`,wrap:!1}}),{c(){w=i("meta"),f=n(),T=i("p"),v=n(),c(g.$$.fragment),N=n(),b=i("p"),b.innerHTML=M,j=n(),L=i("p"),L.textContent=cl,gt=n(),C=i("div"),C.innerHTML=pl,Tt=n(),c(S.$$.fragment),bt=n(),V=i("p"),V.textContent=hl,Jt=n(),A=i("p"),A.textContent=ul,jt=n(),c(q.$$.fragment),Ut=n(),Y=i("p"),Y.textContent=dl,vt=n(),Q=i("p"),Q.textContent=ml,kt=n(),c(E.$$.fragment),Ct=n(),R=i("p"),R.innerHTML=fl,$t=n(),z=i("p"),z.textContent=wl,It=n(),c(X.$$.fragment),xt=n(),F=i("p"),F.textContent=yl,Zt=n(),P=i("p"),P.textContent=Ml,Wt=n(),c($.$$.fragment),_t=n(),c(D.$$.fragment),Ht=n(),K=i("p"),K.innerHTML=gl,Bt=n(),O=i("p"),O.textContent=Tl,Gt=n(),ee=i("p"),ee.innerHTML=bl,Nt=n(),te=i("p"),te.textContent=Jl,Lt=n(),I=i("div"),I.innerHTML=jl,St=n(),se=i("p"),se.textContent=Ul,Vt=n(),x=i("div"),x.innerHTML=vl,At=n(),le=i("p"),le.innerHTML=kl,qt=n(),Z=i("div"),Z.innerHTML=Cl,Yt=n(),ne=i("p"),ne.innerHTML=$l,Qt=n(),ae=i("p"),ae.innerHTML=Il,Et=n(),c(ie.$$.fragment),Rt=n(),oe=i("p"),oe.innerHTML=xl,zt=n(),c(re.$$.fragment),Xt=n(),ce=i("p"),ce.innerHTML=Zl,Ft=n(),c(pe.$$.fragment),Pt=n(),c(he.$$.fragment),Dt=n(),ue=i("p"),ue.innerHTML=Wl,Kt=n(),de=i("p"),de.innerHTML=_l,Ot=n(),me=i("p"),me.innerHTML=Hl,es=n(),fe=i("p"),fe.innerHTML=Bl,ts=n(),we=i("p"),we.innerHTML=Gl,ss=n(),c(ye.$$.fragment),ls=n(),Me=i("p"),Me.innerHTML=Nl,ns=n(),c(ge.$$.fragment),as=n(),c(Te.$$.fragment),is=n(),be=i("p"),be.innerHTML=Ll,os=n(),c(Je.$$.fragment),rs=n(),je=i("p"),je.innerHTML=Sl,cs=n(),c(Ue.$$.fragment),ps=n(),c(W.$$.fragment),hs=n(),ve=i("p"),ve.innerHTML=Vl,us=n(),ke=i("p"),ke.innerHTML=Al,ds=n(),c(Ce.$$.fragment),ms=n(),$e=i("p"),$e.textContent=ql,fs=n(),c(Ie.$$.fragment),ws=n(),c(xe.$$.fragment),ys=n(),Ze=i("p"),Ze.innerHTML=Yl,Ms=n(),c(We.$$.fragment),gs=n(),_e=i("p"),_e.innerHTML=Ql,Ts=n(),He=i("p"),He.innerHTML=El,bs=n(),_=i("div"),_.innerHTML=Rl,Js=n(),Be=i("p"),Be.innerHTML=zl,js=n(),H=i("div"),H.innerHTML=Xl,Us=n(),Ge=i("p"),Ge.innerHTML=Fl,vs=n(),c(Ne.$$.fragment),ks=n(),Le=i("p"),Le.textContent=Pl,Cs=n(),c(Se.$$.fragment),$s=n(),c(Ve.$$.fragment),Is=n(),Ae=i("p"),Ae.textContent=Dl,xs=n(),c(qe.$$.fragment),Zs=n(),Ye=i("p"),Ye.innerHTML=Kl,Ws=n(),c(Qe.$$.fragment),_s=n(),Ee=i("p"),Ee.textContent=Ol,Hs=n(),c(Re.$$.fragment),Bs=n(),ze=i("p"),ze.innerHTML=en,Gs=n(),c(Xe.$$.fragment),Ns=n(),Fe=i("p"),Fe.textContent=tn,Ls=n(),c(Pe.$$.fragment),Ss=n(),De=i("p"),De.textContent=sn,Vs=n(),c(Ke.$$.fragment),As=n(),Oe=i("p"),Oe.innerHTML=ln,qs=n(),c(et.$$.fragment),Ys=n(),tt=i("p"),tt.textContent=nn,Qs=n(),st=i("ul"),st.innerHTML=an,Es=n(),lt=i("p"),lt.textContent=on,Rs=n(),c(nt.$$.fragment),zs=n(),at=i("p"),at.textContent=rn,Xs=n(),it=i("p"),it.innerHTML=cn,Fs=n(),ot=i("p"),ot.innerHTML=pn,Ps=n(),c(rt.$$.fragment),Ds=n(),ct=i("p"),ct.innerHTML=hn,Ks=n(),c(pt.$$.fragment),Os=n(),B=i("div"),B.innerHTML=un,el=n(),c(G.$$.fragment),tl=n(),ht=i("p"),ht.innerHTML=dn,sl=n(),ut=i("p"),ut.textContent=mn,ll=n(),c(dt.$$.fragment),nl=n(),mt=i("p"),mt.textContent=fn,al=n(),ft=i("p"),ft.innerHTML=wn,il=n(),wt=i("p"),this.h()},l(e){const t=kn("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(s),f=a(e),T=o(e,"P",{}),Tn(T).forEach(s),v=a(e),p(g.$$.fragment,e),N=a(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-11bxms2"&&(b.innerHTML=M),j=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-m7grsz"&&(L.textContent=cl),gt=a(e),C=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(C)!=="svelte-1tdavdk"&&(C.innerHTML=pl),Tt=a(e),p(S.$$.fragment,e),bt=a(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-win72"&&(V.textContent=hl),Jt=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1lk8spd"&&(A.textContent=ul),jt=a(e),p(q.$$.fragment,e),Ut=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-npjebc"&&(Y.textContent=dl),vt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-eowjnn"&&(Q.textContent=ml),kt=a(e),p(E.$$.fragment,e),Ct=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-s64ikd"&&(R.innerHTML=fl),$t=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-k3i71h"&&(z.textContent=wl),It=a(e),p(X.$$.fragment,e),xt=a(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-fhg2dn"&&(F.textContent=yl),Zt=a(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1yl3el9"&&(P.textContent=Ml),Wt=a(e),p($.$$.fragment,e),_t=a(e),p(D.$$.fragment,e),Ht=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-11xidww"&&(K.innerHTML=gl),Bt=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1s0beaa"&&(O.textContent=Tl),Gt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1yre5xi"&&(ee.innerHTML=bl),Nt=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-csh5dy"&&(te.textContent=Jl),Lt=a(e),I=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(I)!=="svelte-bqfzrn"&&(I.innerHTML=jl),St=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-6zblrj"&&(se.textContent=Ul),Vt=a(e),x=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(x)!=="svelte-1t2za6k"&&(x.innerHTML=vl),At=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-7t6r33"&&(le.innerHTML=kl),qt=a(e),Z=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(Z)!=="svelte-1sstogo"&&(Z.innerHTML=Cl),Yt=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1mp71ex"&&(ne.innerHTML=$l),Qt=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1wcx2fs"&&(ae.innerHTML=Il),Et=a(e),p(ie.$$.fragment,e),Rt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1h82zgp"&&(oe.innerHTML=xl),zt=a(e),p(re.$$.fragment,e),Xt=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1ezdz2s"&&(ce.innerHTML=Zl),Ft=a(e),p(pe.$$.fragment,e),Pt=a(e),p(he.$$.fragment,e),Dt=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1yzqpu5"&&(ue.innerHTML=Wl),Kt=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-swzzsy"&&(de.innerHTML=_l),Ot=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-d8mgn1"&&(me.innerHTML=Hl),es=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1dht7iu"&&(fe.innerHTML=Bl),ts=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1fw82gd"&&(we.innerHTML=Gl),ss=a(e),p(ye.$$.fragment,e),ls=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-elfuuf"&&(Me.innerHTML=Nl),ns=a(e),p(ge.$$.fragment,e),as=a(e),p(Te.$$.fragment,e),is=a(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-17ytkn3"&&(be.innerHTML=Ll),os=a(e),p(Je.$$.fragment,e),rs=a(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-x83m7j"&&(je.innerHTML=Sl),cs=a(e),p(Ue.$$.fragment,e),ps=a(e),p(W.$$.fragment,e),hs=a(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-jjozqo"&&(ve.innerHTML=Vl),us=a(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-16oab1u"&&(ke.innerHTML=Al),ds=a(e),p(Ce.$$.fragment,e),ms=a(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1h6pf22"&&($e.textContent=ql),fs=a(e),p(Ie.$$.fragment,e),ws=a(e),p(xe.$$.fragment,e),ys=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1hk7buj"&&(Ze.innerHTML=Yl),Ms=a(e),p(We.$$.fragment,e),gs=a(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-dq0etq"&&(_e.innerHTML=Ql),Ts=a(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-pt2fmn"&&(He.innerHTML=El),bs=a(e),_=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(_)!=="svelte-bxbti"&&(_.innerHTML=Rl),Js=a(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-q4fxjc"&&(Be.innerHTML=zl),js=a(e),H=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(H)!=="svelte-dbv2wd"&&(H.innerHTML=Xl),Us=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1p7tgmz"&&(Ge.innerHTML=Fl),vs=a(e),p(Ne.$$.fragment,e),ks=a(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-138rkn9"&&(Le.textContent=Pl),Cs=a(e),p(Se.$$.fragment,e),$s=a(e),p(Ve.$$.fragment,e),Is=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1nbwfmv"&&(Ae.textContent=Dl),xs=a(e),p(qe.$$.fragment,e),Zs=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1qk4wbi"&&(Ye.innerHTML=Kl),Ws=a(e),p(Qe.$$.fragment,e),_s=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-1twafdm"&&(Ee.textContent=Ol),Hs=a(e),p(Re.$$.fragment,e),Bs=a(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-15rml10"&&(ze.innerHTML=en),Gs=a(e),p(Xe.$$.fragment,e),Ns=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-1xqi1hq"&&(Fe.textContent=tn),Ls=a(e),p(Pe.$$.fragment,e),Ss=a(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-2evwpg"&&(De.textContent=sn),Vs=a(e),p(Ke.$$.fragment,e),As=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-a1o8gg"&&(Oe.innerHTML=ln),qs=a(e),p(et.$$.fragment,e),Ys=a(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-19hw34h"&&(tt.textContent=nn),Qs=a(e),st=o(e,"UL",{"data-svelte-h":!0}),r(st)!=="svelte-41mgch"&&(st.innerHTML=an),Es=a(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-infbj7"&&(lt.textContent=on),Rs=a(e),p(nt.$$.fragment,e),zs=a(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-11bcz2b"&&(at.textContent=rn),Xs=a(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-x0jm20"&&(it.innerHTML=cn),Fs=a(e),ot=o(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-zis204"&&(ot.innerHTML=pn),Ps=a(e),p(rt.$$.fragment,e),Ds=a(e),ct=o(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1id51x6"&&(ct.innerHTML=hn),Ks=a(e),p(pt.$$.fragment,e),Os=a(e),B=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(B)!=="svelte-1ggy3u7"&&(B.innerHTML=un),el=a(e),p(G.$$.fragment,e),tl=a(e),ht=o(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-n30ots"&&(ht.innerHTML=dn),sl=a(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1w2aefi"&&(ut.textContent=mn),ll=a(e),p(dt.$$.fragment,e),nl=a(e),mt=o(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-k11338"&&(mt.textContent=fn),al=a(e),ft=o(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-sxpcjd"&&(ft.innerHTML=wn),il=a(e),wt=o(e,"P",{}),Tn(wt).forEach(s),this.h()},h(){U(w,"name","hf:doc:metadata"),U(w,"content",Wn),U(C,"class","flex justify-center"),U(I,"class","flex justify-center"),U(x,"class","flex justify-center"),U(Z,"class","flex justify-center"),U(_,"class","flex justify-center"),U(H,"class","flex justify-center"),U(B,"class","flex justify-center")},m(e,t){Cn(document.head,w),l(e,f,t),l(e,T,t),l(e,v,t),h(g,e,t),l(e,N,t),l(e,b,t),l(e,j,t),l(e,L,t),l(e,gt,t),l(e,C,t),l(e,Tt,t),h(S,e,t),l(e,bt,t),l(e,V,t),l(e,Jt,t),l(e,A,t),l(e,jt,t),h(q,e,t),l(e,Ut,t),l(e,Y,t),l(e,vt,t),l(e,Q,t),l(e,kt,t),h(E,e,t),l(e,Ct,t),l(e,R,t),l(e,$t,t),l(e,z,t),l(e,It,t),h(X,e,t),l(e,xt,t),l(e,F,t),l(e,Zt,t),l(e,P,t),l(e,Wt,t),h($,e,t),l(e,_t,t),h(D,e,t),l(e,Ht,t),l(e,K,t),l(e,Bt,t),l(e,O,t),l(e,Gt,t),l(e,ee,t),l(e,Nt,t),l(e,te,t),l(e,Lt,t),l(e,I,t),l(e,St,t),l(e,se,t),l(e,Vt,t),l(e,x,t),l(e,At,t),l(e,le,t),l(e,qt,t),l(e,Z,t),l(e,Yt,t),l(e,ne,t),l(e,Qt,t),l(e,ae,t),l(e,Et,t),h(ie,e,t),l(e,Rt,t),l(e,oe,t),l(e,zt,t),h(re,e,t),l(e,Xt,t),l(e,ce,t),l(e,Ft,t),h(pe,e,t),l(e,Pt,t),h(he,e,t),l(e,Dt,t),l(e,ue,t),l(e,Kt,t),l(e,de,t),l(e,Ot,t),l(e,me,t),l(e,es,t),l(e,fe,t),l(e,ts,t),l(e,we,t),l(e,ss,t),h(ye,e,t),l(e,ls,t),l(e,Me,t),l(e,ns,t),h(ge,e,t),l(e,as,t),h(Te,e,t),l(e,is,t),l(e,be,t),l(e,os,t),h(Je,e,t),l(e,rs,t),l(e,je,t),l(e,cs,t),h(Ue,e,t),l(e,ps,t),h(W,e,t),l(e,hs,t),l(e,ve,t),l(e,us,t),l(e,ke,t),l(e,ds,t),h(Ce,e,t),l(e,ms,t),l(e,$e,t),l(e,fs,t),h(Ie,e,t),l(e,ws,t),h(xe,e,t),l(e,ys,t),l(e,Ze,t),l(e,Ms,t),h(We,e,t),l(e,gs,t),l(e,_e,t),l(e,Ts,t),l(e,He,t),l(e,bs,t),l(e,_,t),l(e,Js,t),l(e,Be,t),l(e,js,t),l(e,H,t),l(e,Us,t),l(e,Ge,t),l(e,vs,t),h(Ne,e,t),l(e,ks,t),l(e,Le,t),l(e,Cs,t),h(Se,e,t),l(e,$s,t),h(Ve,e,t),l(e,Is,t),l(e,Ae,t),l(e,xs,t),h(qe,e,t),l(e,Zs,t),l(e,Ye,t),l(e,Ws,t),h(Qe,e,t),l(e,_s,t),l(e,Ee,t),l(e,Hs,t),h(Re,e,t),l(e,Bs,t),l(e,ze,t),l(e,Gs,t),h(Xe,e,t),l(e,Ns,t),l(e,Fe,t),l(e,Ls,t),h(Pe,e,t),l(e,Ss,t),l(e,De,t),l(e,Vs,t),h(Ke,e,t),l(e,As,t),l(e,Oe,t),l(e,qs,t),h(et,e,t),l(e,Ys,t),l(e,tt,t),l(e,Qs,t),l(e,st,t),l(e,Es,t),l(e,lt,t),l(e,Rs,t),h(nt,e,t),l(e,zs,t),l(e,at,t),l(e,Xs,t),l(e,it,t),l(e,Fs,t),l(e,ot,t),l(e,Ps,t),h(rt,e,t),l(e,Ds,t),l(e,ct,t),l(e,Ks,t),h(pt,e,t),l(e,Os,t),l(e,B,t),l(e,el,t),h(G,e,t),l(e,tl,t),l(e,ht,t),l(e,sl,t),l(e,ut,t),l(e,ll,t),h(dt,e,t),l(e,nl,t),l(e,mt,t),l(e,al,t),l(e,ft,t),l(e,il,t),l(e,wt,t),ol=!0},p(e,[t]){const yn={};t&2&&(yn.$$scope={dirty:t,ctx:e}),$.$set(yn);const Mn={};t&2&&(Mn.$$scope={dirty:t,ctx:e}),W.$set(Mn);const gn={};t&2&&(gn.$$scope={dirty:t,ctx:e}),G.$set(gn)},i(e){ol||(u(g.$$.fragment,e),u(S.$$.fragment,e),u(q.$$.fragment,e),u(E.$$.fragment,e),u(X.$$.fragment,e),u($.$$.fragment,e),u(D.$$.fragment,e),u(ie.$$.fragment,e),u(re.$$.fragment,e),u(pe.$$.fragment,e),u(he.$$.fragment,e),u(ye.$$.fragment,e),u(ge.$$.fragment,e),u(Te.$$.fragment,e),u(Je.$$.fragment,e),u(Ue.$$.fragment,e),u(W.$$.fragment,e),u(Ce.$$.fragment,e),u(Ie.$$.fragment,e),u(xe.$$.fragment,e),u(We.$$.fragment,e),u(Ne.$$.fragment,e),u(Se.$$.fragment,e),u(Ve.$$.fragment,e),u(qe.$$.fragment,e),u(Qe.$$.fragment,e),u(Re.$$.fragment,e),u(Xe.$$.fragment,e),u(Pe.$$.fragment,e),u(Ke.$$.fragment,e),u(et.$$.fragment,e),u(nt.$$.fragment,e),u(rt.$$.fragment,e),u(pt.$$.fragment,e),u(G.$$.fragment,e),u(dt.$$.fragment,e),ol=!0)},o(e){d(g.$$.fragment,e),d(S.$$.fragment,e),d(q.$$.fragment,e),d(E.$$.fragment,e),d(X.$$.fragment,e),d($.$$.fragment,e),d(D.$$.fragment,e),d(ie.$$.fragment,e),d(re.$$.fragment,e),d(pe.$$.fragment,e),d(he.$$.fragment,e),d(ye.$$.fragment,e),d(ge.$$.fragment,e),d(Te.$$.fragment,e),d(Je.$$.fragment,e),d(Ue.$$.fragment,e),d(W.$$.fragment,e),d(Ce.$$.fragment,e),d(Ie.$$.fragment,e),d(xe.$$.fragment,e),d(We.$$.fragment,e),d(Ne.$$.fragment,e),d(Se.$$.fragment,e),d(Ve.$$.fragment,e),d(qe.$$.fragment,e),d(Qe.$$.fragment,e),d(Re.$$.fragment,e),d(Xe.$$.fragment,e),d(Pe.$$.fragment,e),d(Ke.$$.fragment,e),d(et.$$.fragment,e),d(nt.$$.fragment,e),d(rt.$$.fragment,e),d(pt.$$.fragment,e),d(G.$$.fragment,e),d(dt.$$.fragment,e),ol=!1},d(e){e&&(s(f),s(T),s(v),s(N),s(b),s(j),s(L),s(gt),s(C),s(Tt),s(bt),s(V),s(Jt),s(A),s(jt),s(Ut),s(Y),s(vt),s(Q),s(kt),s(Ct),s(R),s($t),s(z),s(It),s(xt),s(F),s(Zt),s(P),s(Wt),s(_t),s(Ht),s(K),s(Bt),s(O),s(Gt),s(ee),s(Nt),s(te),s(Lt),s(I),s(St),s(se),s(Vt),s(x),s(At),s(le),s(qt),s(Z),s(Yt),s(ne),s(Qt),s(ae),s(Et),s(Rt),s(oe),s(zt),s(Xt),s(ce),s(Ft),s(Pt),s(Dt),s(ue),s(Kt),s(de),s(Ot),s(me),s(es),s(fe),s(ts),s(we),s(ss),s(ls),s(Me),s(ns),s(as),s(is),s(be),s(os),s(rs),s(je),s(cs),s(ps),s(hs),s(ve),s(us),s(ke),s(ds),s(ms),s($e),s(fs),s(ws),s(ys),s(Ze),s(Ms),s(gs),s(_e),s(Ts),s(He),s(bs),s(_),s(Js),s(Be),s(js),s(H),s(Us),s(Ge),s(vs),s(ks),s(Le),s(Cs),s($s),s(Is),s(Ae),s(xs),s(Zs),s(Ye),s(Ws),s(_s),s(Ee),s(Hs),s(Bs),s(ze),s(Gs),s(Ns),s(Fe),s(Ls),s(Ss),s(De),s(Vs),s(As),s(Oe),s(qs),s(Ys),s(tt),s(Qs),s(st),s(Es),s(lt),s(Rs),s(zs),s(at),s(Xs),s(it),s(Fs),s(ot),s(Ps),s(Ds),s(ct),s(Ks),s(Os),s(B),s(el),s(tl),s(ht),s(sl),s(ut),s(ll),s(nl),s(mt),s(al),s(ft),s(il),s(wt)),s(w),m(g,e),m(S,e),m(q,e),m(E,e),m(X,e),m($,e),m(D,e),m(ie,e),m(re,e),m(pe,e),m(he,e),m(ye,e),m(ge,e),m(Te,e),m(Je,e),m(Ue,e),m(W,e),m(Ce,e),m(Ie,e),m(xe,e),m(We,e),m(Ne,e),m(Se,e),m(Ve,e),m(qe,e),m(Qe,e),m(Re,e),m(Xe,e),m(Pe,e),m(Ke,e),m(et,e),m(nt,e),m(rt,e),m(pt,e),m(G,e),m(dt,e)}}}const Wn='{"title":"Creating a voice assistant","local":"creating-a-voice-assistant","sections":[{"title":"1. Wake word detection","local":"1-wake-word-detection","sections":[],"depth":3},{"title":"2. Speech transcription","local":"2-speech-transcription","sections":[],"depth":3},{"title":"3. Language model query","local":"3-language-model-query","sections":[],"depth":3},{"title":"4. Synthesise speech","local":"4-synthesise-speech","sections":[],"depth":3},{"title":"Wake word detection","local":"wake-word-detection","sections":[],"depth":2},{"title":"Speech transcription","local":"speech-transcription","sections":[],"depth":2},{"title":"Language model query","local":"language-model-query","sections":[],"depth":2},{"title":"Synthesise speech","local":"synthesise-speech","sections":[],"depth":2},{"title":"Marvin 🤖","local":"marvin-","sections":[],"depth":2},{"title":"Generalise to anything 🪄","local":"generalise-to-anything-","sections":[],"depth":2}],"depth":1}';function _n(k){return Jn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sn extends Un{constructor(w){super(),vn(this,w,_n,Zn,bn,{})}}export{Sn as component};
