import{s as fn,o as yn,n as hn}from"../chunks/scheduler.f7e1785c.js";import{S as Tn,i as vn,g as i,s as n,r as u,A as Jn,h as r,f as s,c as a,j as dn,u as p,x as o,k as b,y as wn,a as l,v as c,d as m,t as d,w as M,m as tl,n as sl}from"../chunks/index.9f8f0838.js";import{T as Mn}from"../chunks/Tip.4575d9cf.js";import{C as f}from"../chunks/CodeBlock.b3510e34.js";import{H as v}from"../chunks/Heading.6643a2f7.js";function bn(ct){let y,h,J='"openai/whisper-small.en"',w;return{c(){y=tl("Si vous utilisez un GPU, vous pouvez augmenter la taille du modèle à utiliser, ce qui permettra d'obtenir une meilleure précision de transcription tout en respectant le seuil de latence requis. Il suffit de remplacer l'identifiant du modèle par : "),h=i("code"),h.textContent=J,w=tl(".")},l(T){y=sl(T,"Si vous utilisez un GPU, vous pouvez augmenter la taille du modèle à utiliser, ce qui permettra d'obtenir une meilleure précision de transcription tout en respectant le seuil de latence requis. Il suffit de remplacer l'identifiant du modèle par : "),h=r(T,"CODE",{"data-svelte-h":!0}),o(h)!=="svelte-1roca6s"&&(h.textContent=J),w=sl(T,".")},m(T,g){l(T,y,g),l(T,h,g),l(T,w,g)},p:hn,d(T){T&&(s(y),s(h),s(w))}}}function gn(ct){let y;return{c(){y=tl("Notez que la première fois que vous appelez cette fonction, les poids du modèle sont téléchargés, ce qui peut prendre un certain temps en fonction de votre connexion internet.")},l(h){y=sl(h,"Notez que la première fois que vous appelez cette fonction, les poids du modèle sont téléchargés, ce qui peut prendre un certain temps en fonction de votre connexion internet.")},m(h,J){l(h,y,J)},d(h){h&&s(y)}}}function jn(ct){let y,h,J,w,T,g,k,ll="Dans cette section, nous allons rassembler trois modèles déjà vus pour construire un assistant vocal de bout en bout baptisé <strong>Marvin</strong> 🤖. Comme Alexa d’Amazon ou Siri d’Apple, Marvin est un assistant vocal répondant à un mot déclencheur particulier, écoutant ensuite une requête vocale et répond enfin par une réponse vocale.",dt,H,nl="Nous pouvons décomposer le pipeline de l’assistant vocal en quatre étapes, chacune d’entre elles nécessitant un modèle autonome :",Mt,j,al='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/voice_assistant.png"/>',ft,B,yt,N,il="Les assistants vocaux écoutent en permanence les entrées audio provenant du microphone de votre appareil, mais ils ne se mettent en action que lorsqu’un mot déclencheur (ou mot de réveil) particulier est prononcé.",ht,W,rl="La tâche de détection des mots déclencheurs est gérée par un petit modèle de classification audio sur l’appareil, qui est beaucoup plus petit et plus léger que le modèle de reconnaissance vocale, ne comportant souvent que quelques millions de paramètres, contre plusieurs centaines de millions pour la reconnaissance vocale. Il peut donc être exécuté en continu sur l’appareil sans en épuiser la batterie. Ce n’est que lorsque le mot de réveil est détecté que le modèle de reconnaissance vocale, plus grand, est lancé, avant d’être à nouveau arrêté.",Tt,G,vt,L,ol="L’étape suivante du processus consiste à transcrire la requête vocale en texte. Dans la pratique, le transfert des fichiers audio de votre appareil local vers le <em>cloud</em> est lent en raison de la nature volumineuse des fichiers audio. Il est donc plus efficace de les transcrire directement à l’aide d’un modèle d’ASR sur l’appareil plutôt qu’à l’aide d’un modèle dans le <em>cloud</em>. Le modèle sur l’appareil peut être plus petit et donc moins précis qu’un modèle hébergé dans le <em>cloud</em>, mais la vitesse d’inférence plus rapide en vaut la peine puisque nous pouvons exécuter la reconnaissance vocale quasiment en temps réel, notre énoncé audio étant transcrit au fur et à mesure que nous le prononçons.",Jt,V,ul="Nous sommes maintenant très familiers avec le processus de reconnaissance vocale, donc cela devrait être un jeu d’enfant !",wt,z,bt,S,pl="Maintenant que nous savons ce que l’utilisateur a demandé, nous devons générer une réponse ! Les meilleurs modèles candidats pour cette tâche sont les <em>grands modèles de langage (LLM)</em>, car ils sont effectivement capables de comprendre la sémantique de la requête textuelle et de générer une réponse appropriée.",gt,A,cl="Puisque notre requête textuelle est petite (juste quelques <em>tokens</em>), et les modèles de langage volumineux (plusieurs milliards de paramètres), la façon la plus efficace d’exécuter l’inférence est d’envoyer notre requête textuelle de notre appareil à un LLM fonctionnant dans le <em>cloud</em>, de générer une réponse textuelle, et de renvoyer la réponse à l’appareil.",jt,Q,Ut,E,ml="Enfin, nous utiliserons un modèle de synthèse vocale pour synthétiser la réponse textuelle sous forme de parole. Cette opération s’effectue sur l’appareil, mais il est tout à fait possible d’exécuter un modèle de synthèse vocale dans le <em>cloud</em>, en générant la sortie audio et en la transférant vers l’appareil.",Ct,Y,dl="Encore une fois, nous avons fait cela plusieurs fois maintenant, donc le processus sera très familier !",$t,R,It,X,Ml='La première étape du pipeline de l’assistant vocal consiste à détecter si le mot déclencheur a été prononcé, et nous devons donc trouver un modèle pré-entraîné approprié pour cette tâche ! Vous vous souviendrez de la section sur les <a href="../chapiter4/classification_models">modèles pré-entraînés pour la classification audio</a> que <a href="https://huggingface.co/datasets/speech_commands" rel="nofollow">Speech Commands</a> est un jeu de données de mots prononcés conçu pour évaluer les modèles de classification audio sur plus de 15 mots de commande simples comme <code>up</code>, <code>down</code>, <code>yes</code> et <code>no</code>, ainsi qu’un label <code>silence</code> pour classer l’absence de parole. Prenez une minute pour écouter les échantillons sur le visualisateur de jeux de données du <em>Hub</em> et vous familiariser à nouveau avec le jeu de données : <a href="https://huggingface.co/datasets/speech_commands/viewer/v0.01/train" rel="nofollow">visualisateur</a>.',xt,P,fl="Nous pouvons utiliser un modèle de classification audio pré-entraîné sur le jeu de données Speech Commands et choisir l’un de ces mots de commande simples comme mot déclencheur. Parmi plus de 15 mots de commande possibles, si le modèle prédit avec la plus grande probabilité le mot que nous avons choisi, nous pouvons être quasiment certains que ce mot de déclencheur a été prononcé.",qt,F,yl='Rendez-vous sur le <em>Hub</em> et cliquez sur l’onglet <em>Models</em> : <a href="https://huggingface.co/models" rel="nofollow">https://huggingface.co/models</a>. Cela va faire apparaître tous les modèles sur le <em>Hub</em> :',Zt,U,hl='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/all_models.png"/>',_t,D,Tl="Vous remarquerez sur le côté gauche que nous avons une sélection d’onglets que nous pouvons sélectionner pour filtrer les modèles par tâche, bibliothèque, jeu de données, etc. Faites défiler vers le bas et sélectionnez la tâche <em>Audio Classification</em> dans la liste des tâches audio :",kt,C,vl='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/by_audio_classification.png"/>',Ht,K,Jl="Nous sommes maintenant en présence d’un sous-ensemble de plus de 500 modèles de classification audio sur le <em>Hub</em>. Pour affiner cette sélection, nous pouvons filtrer les modèles par jeu de données. Cliquez sur l’onglet <em>Datasets</em> et dans la barre de recherche, tapez <em>speech_commands</em>. Vous pouvez cliquer sur ce bouton pour filtrer tous les modèles de classification audio vers ceux qui ont été <em>finetuné</em> sur le jeu de données Speech Commands :",Bt,$,wl='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/by_speech_commands.png"/>',Nt,O,bl='Bien , nous constatons que nous disposons de six modèles pré-entraînés pour ce jeu de données et cette tâche spécifiques (bien que de nouveaux modèles puissent être ajoutés si vous lisez à une date ultérieure !) Vous reconnaîtrez le premier de ces modèles comme le <a href="https://huggingface.co/MIT/ast-finetuned-speech-commands-v2" rel="nofollow"><em>Spectrogram Transformer</em></a> que nous avons utilisé dans l’exemple de l’unité 4. Nous utiliserons à nouveau ce <em>checkpoint</em> pour notre tâche de détection de mots déclencheur.',Wt,ee,gl="Chargeons le <em>checkpoint</em> à l’aide de la classe <code>pipeline</code> :",Gt,te,Lt,se,jl="Nous pouvons vérifier sur quelles étiquettes le modèle a été entraîné en vérifiant l’attribut <code>id2label</code> dans la configuration du modèle :",Vt,le,zt,ne,Ul="Nous voyons que le modèle a été entraîné sur 35 étiquettes de classe, y compris quelques mots déclencheurs simples que nous avons décrits ci-dessus, ainsi que quelques objets particuliers comme <code>bed</code>, <code>house</code> et <code>cat</code>. Nous voyons qu’il y a un nom dans ces étiquettes de classe : id 27 correspond à l’étiquette <strong><code>marvin</code></strong> :",St,ae,At,ie,Qt,re,Cl="Parfait ! Nous pouvons utiliser ce nom comme mot délchencheur de notre assistant vocal, de la même manière qu’on utilise “Alexa” pour l’Alexa d’Amazon, ou “Hey Siri” pour le Siri d’Apple. Parmi toutes les étiquettes possibles, si le modèle prédit “marvin” avec la probabilité de classe la plus élevée, nous pouvons être sûrs que le mot de réveil que nous avons choisi a été prononcé.",Et,oe,$l='Nous devons maintenant définir une fonction qui écoute en permanence le microphone de notre appareil et qui transmet continuellement l’audio au modèle de classification pour inférence. Pour ce faire, nous allons utiliser une fonction d’aide pratique fournie avec 🤗 <em>Transformers</em> appelée <a href="https://github.com/huggingface/transformers/blob/fb78769b9c053876ed7ae152ee995b0439a4462a/src/transformers/pipelines/audio_utils.py#L98" rel="nofollow"><code>ffmpeg_microphone_live</code></a>.',Yt,ue,Il=`Cette fonction transmet de petits morceaux d’audio d’une longueur spécifiée <code>chunk_length_s</code> au classifieur. Pour s’assurer que nous obtenons des frontières lisses entre les morceaux d’audio, nous lançons une fenêtre coulissante à travers notre audio avec un pas de <code>chunk_length_s / 6</code>.
Pour que nous n’ayons pas à attendre que tout le premier morceau soit enregistré avant de commencer l’inférence, nous définissons également une longueur d’entrée audio temporaire minimale <code>stream_chunk_s</code> qui est transmise au modèle avant que le temps <code>chunk_length_s</code> ne soit atteint.`,Rt,pe,xl="La fonction <code>ffmpeg_microphone_live</code> renvoie un objet <em>generator</em>, produisant une séquence de morceaux audio qui peuvent chacun être transmis au modèle de classification pour faire une prédiction. Nous pouvons passer ce générateur directement au <code>pipeline</code>, qui à son tour retourne une séquence de prédictions de sortie, une pour chaque morceau d’entrée audio. Nous pouvons inspecter les probabilités des classes pour chaque morceau d’audio, et arrêter notre boucle de détection de mot de réveil lorsque nous détectons que le mot de réveil a été prononcé.",Xt,ce,ql='Nous utiliserons un critère très simple pour déterminer si notre mot de réveil a été prononcé : si l’étiquette de classe ayant la probabilité la plus élevée est celle de notre mot, et que cette probabilité dépasse un seuil <code>prob_threshold</code>, nous déclarons que le mot déclencheur a été prononcé. L’utilisation d’un seuil de probabilité pour contrôler notre classifieur garantit que le mot déclencheur  n’est pas prédit par erreur si l’entrée audio est un bruit, ce qui est typiquement le cas lorsque le modèle est très incertain et que toutes les probabilités d’étiquettes de classe sont faibles. Vous voudrez peut-être ajuster ce seuil de probabilité ou explorer des moyens plus sophistiqués par le biais d’une métrique basée sur l’<a href="https://fr.wikipedia.org/wiki/Entropie_de_Shannon" rel="nofollow"><em>entropie</em></a>.',Pt,me,Ft,de,Zl="Essayons cette fonction pour voir comment elle fonctionne ! Nous allons mettre <code>debug=True</code> pour afficher la prédiction pour chaque morceau d’audio. Laissons le modèle fonctionner pendant quelques secondes pour voir le type de prédictions qu’il fait lorsqu’il n’y a pas de parole, puis prononçons clairement le mot de réveil <em>marvin</em> et regardons sa prédiction monter en flèche à près de 1 :",Dt,Me,Kt,fe,Ot,ye,_l="Génial ! Comme nous nous y attendions, le modèle génère des prédictions erronées pendant les premières secondes. Il n’y a pas d’entrée vocale, donc le modèle fait des prédictions presque aléatoires, mais avec une très faible probabilité. Dès que nous prononçons le mot de réveil, le modèle prédit <em>marvin</em> avec une probabilité proche de 1 et termine la boucle, signalant que le mot de réveil a été détecté et que le système ASR doit être activé !",es,he,ts,Te,kl='Une fois de plus, nous utiliserons le modèle Whisper pour notre système de transcription de la parole. Plus précisément, nous chargerons le <em>checkpoint</em> <a href="https://huggingface.co/openai/whisper-base.en" rel="nofollow"><em>Whisper Base English</em></a>, car il est suffisamment petit pour donner une bonne vitesse d’inférence avec une précision de transcription raisonnable. Nous utiliserons une astuce pour obtenir une transcription presque en temps réel en étant astucieux sur la façon dont nous transmettons nos entrées audio au modèle. Comme auparavant, vous pouvez utiliser n’importe quel modèle de reconnaissance vocale sur le <a href="https://huggingface.co/models?pipeline_tag=automatic-speech-recognition&amp;library=transformers&amp;sort=trending" rel="nofollow"><em>Hub</em></a>, y compris Wav2Vec2, MMS ASR ou d’autres tailles de Whisper :',ss,ve,ls,I,ns,Je,Hl="Nous pouvons maintenant définir une fonction pour enregistrer l’entrée de notre microphone et transcrire le texte correspondant. Avec la fonction d’aide <code>ffmpeg_microphone_live</code>, nous pouvons contrôler le degré de “temps réel” de notre modèle de reconnaissance vocale. L’utilisation d’un <code>stream_chunk_s</code> plus petit se prête à une reconnaissance vocale davantage en temps réel, puisque nous divisons notre audio d’entrée en plus petits morceaux et que nous les transcrivons à la volée. Cependant, cela se fait au détriment de la précision, puisqu’il y a moins de contexte pour le modèle à déduire.",as,we,Bl='Lors de la transcription de la parole, nous devons également avoir une idée du moment où l’utilisateur <strong>s’arrête</strong> de parler, afin de pouvoir mettre fin à l’enregistrement. Pour des raisons de simplicité, nous mettrons fin à l’enregistrement après le premier <code>chunk_length_s</code> (qui est fixé à 5 secondes par défaut), mais vous pouvez essayer d’utiliser un modèle de <a href="https://huggingface.co/models?pipeline_tag=voice-activity-detection&amp;sort=trending" rel="nofollow">détection de l’activité vocale (VAD pour <em>voice activity detection</em>)</a> pour prédire quand l’utilisateur s’est arrêté de parler.',is,be,rs,ge,Nl="Essayons et voyons comment nous nous débrouillerons ! Une fois que le microphone est activé, commencez à parler et regardez votre transcription apparaître en semi-temps réel :",os,je,us,Ue,ps,Ce,Wl="Bien, vous pouvez ajuster la longueur maximale de l’audio <code>chunk_length_s</code> en fonction de la rapidité ou de la lenteur avec laquelle vous parlez (augmentez-la si vous avez l’impression de ne pas avoir assez de temps pour parler, diminuez-la si vous êtes resté dans l’expectative à la fin), et le <code>stream_chunk_s</code> pour le facteur temps réel. Il suffit de passer ces arguments à la fonction <code>transcribe</code>.",cs,$e,ms,Ie,Gl='Maintenant que notre requête vocale a été transcrite, nous voulons générer une réponse significative. Pour ce faire, nous utiliserons un LLM hébergé sur le <em>cloud</em>. Plus précisément, nous choisissons un LLM sur le <em>Hub</em> et utilisons l’<a href="https://huggingface.co/inference-api" rel="nofollow">API Inference</a> pour interroger facilement le modèle.',ds,xe,Ll='Trouvons notre LLM sur le <em>Hub</em> en utilisant l’<a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">🤗 <em>Open LLM Leaderboard</em></a>, un <em>Space</em> qui classe les LLM par performance sur quatre tâches de génération. Nous effectuerons une recherche par “instruct” pour filtrer les modèles qui ont été <em>finetuné</em> car devraient mieux fonctionner pour notre tâche de requêtage :',Ms,x,Vl='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/llm_leaderboard.png"/>',fs,qe,zl='Nous utiliserons le <em>checkpoint</em> <a href="https://huggingface.co/tiiuae/falcon-7b-instruct" rel="nofollow">tiiuae/falcon-7b-instruct</a> par <a href="https://www.tii.ae/" rel="nofollow">TII</a>, un <em>transformer</em> décodeur de paramètres 7B <em>finetuné</em> sur un mélange de jeux de données de chat et d’instructions. Vous pouvez utiliser n’importe quel LLM du <em>Hub</em> ayant l’”<em>Hosted inference API</em>” activé. Il suffit de regarder le widget sur le côté droit de la carte du modèle :',ys,q,Sl='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/inference_api.png"/>',hs,Ze,Al="L’API Inference nous permet d’envoyer une requête HTTP depuis notre machine locale vers le LLM hébergé sur le <em>Hub</em>, et renvoie la réponse sous la forme d’un fichier <code>json</code>. Tout ce que nous devons fournir est notre <em>token</em> d’authentification au <em>Hub</em> et l’identifiant du modèle du LLM que nous souhaitons interroger :",Ts,_e,vs,ke,Ql="Essayons-le avec une entrée de test !",Js,He,ws,Be,bs,Ne,El="Vous remarquerez à quel point l’inférence est rapide en utilisant l’API Inference. Nous n’avons qu’à envoyer un petit nombre de <em>tokens</em> de texte de notre machine locale au modèle hébergé, le coût de communication est donc très faible. Le LLM est hébergé sur des GPU, de sorte que l’inférence s’exécute très rapidement. Enfin, la réponse générée est transférée du modèle à notre machine locale, toujours avec un faible coût de communication.",gs,We,js,Ge,Yl='Et maintenant, nous sommes prêts à obtenir la sortie vocale finale ! Une fois de plus, nous utiliserons le modèle <a href="https://huggingface.co/microsoft/speecht5_tts" rel="nofollow">SpeechT5 TTS</a> de Microsoft mais vous pouvez utiliser n’importe quel modèle TTS de votre choix. Chargeons le processeur et le modèle :',Us,Le,Cs,Ve,Rl="Et aussi l’enchâssement des locuteurs :",$s,ze,Is,Se,Xl='Nous allons réutiliser la fonction <code>synthesise</code> que nous avons définie dans le chapitre <a href="speech-to-speech">précédent</a> :',xs,Ae,qs,Qe,Pl="Vérifions rapidement que cela fonctionne comme prévu :",Zs,Ee,_s,Ye,Fl="Joli travail 👍",ks,Re,Hs,Xe,Dl="Maintenant que nous avons défini une fonction pour chacune des quatre étapes du pipeline de l’assistant vocal, il ne reste plus qu’à les assembler pour obtenir notre assistant vocal de bout en bout. Nous allons simplement concaténer les quatre étapes, en commençant par la détection du mot de réveil (<code>launch_fn</code>), la transcription de la parole, le requêtage du LLM, et enfin la synthèse de la parole.",Bs,Pe,Ns,Fe,Kl="Essayez-le avec quelques demandes ! Voici quelques exemples pour vous aider à démarrer :",Ws,De,Ol="<li>*Quel est le pays le plus chaud du monde ?</li> <li><em>Comment fonctionnent les </em>transformers* ?</li> <li>*Connais-tu l’espagnol ?</li>",Gs,Ke,en="Et avec cela, nous avons notre assistant vocal complet, réalisé à l’aide des outils audio que vous avez appris tout au long de ce cours, avec une pincée de magie LLM à la fin. Il y a plusieurs extensions que nous pourrions faire pour améliorer l’assistant vocal. Tout d’abord, le modèle de classification audio classifie 35 étiquettes différentes. Nous pourrions utiliser un modèle de classification binaire plus petit et plus léger qui prédit uniquement si le mot de réveil a été prononcé ou non. Deuxièmement, nous préchargeons tous les modèles à l’avance et les laissons tourner sur notre appareil. Si nous voulions économiser de l’énergie, nous ne chargerions chaque modèle qu’au moment où il est nécessaire, et nous le déchargerions par la suite. Troisièmement, il manque un modèle de détection de l’activité vocale dans notre fonction de transcription, qui transcrit pendant une durée fixe, parfois trop longue, parfois trop courte.",Ls,Oe,Vs,et,tn="Jusqu’à présent, nous avons vu comment générer des sorties vocales avec notre assistant vocal Marvin. Pour terminer, nous allons montrer comment nous pouvons généraliser ces sorties vocales au texte, à l’audio et à l’image.",zs,tt,sn=`Nous utiliserons <a href="https://huggingface.co/docs/transformers/transformers_agents" rel="nofollow"><em>Transformers Agents</em></a> pour créer notre assistant.
<em>Transformers Agents</em> fournit une API de langage naturel au-dessus des bibliothèques 🤗 <em>Transformers</em> et <em>Diffusers</em>, interprétant une entrée de langage naturel en utilisant un LLM avec des prompts soigneusement conçus, et en utilisant un ensemble d’outils pour fournir des sorties multimodales.`,Ss,st,ln='Allons-y et instançons un agent. Il y a <a href="https://huggingface.co/docs/transformers/transformers_agents#quickstart" rel="nofollow">trois LLM disponibles</a> pour <em>Transformers Agents</em>, dont deux sont open-source et gratuits sur le <em>Hub</em>. Le troisième est un modèle d’OpenAI qui nécessite une clé API OpenAI. Nous utiliserons le modèle gratuit <a href="https://huggingface.co/bigcode/starcoder" rel="nofollow">Bigcode Starcoder</a> dans cet exemple, mais vous pouvez également essayer l’un ou l’autre des autres LLM disponibles :',As,lt,Qs,nt,nn="Pour utiliser l’agent, il suffit d’appeler <code>agent.run</code> avec notre prompt de texte. A titre d’exemple, nous allons lui faire générer une image d’un chat 🐈 (qui, espérons-le, ait l’air un peu mieux que cet emoji) :",Es,at,Ys,Z,an='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/generated_cat.png"/>',Rs,_,Xs,it,rn='C’est aussi simple que cela ! L’agent a interprété notre prompt et a utilisé <a href="https://huggingface.co/docs/diffusers/using-diffusers/conditional_image_generation" rel="nofollow">Stable Diffusion</a> pour générer l’image, sans que nous ayons à nous soucier du chargement du modèle, de l’écriture de la fonction ou de l’exécution du code.',Ps,rt,on="Nous pouvons maintenant remplacer notre fonction de requête LLM et l’étape de synthèse de texte par notre <em>Transformers Agent</em> dans notre assistant vocal, puisque l’Agent va s’occuper de ces deux étapes pour nous :",Fs,ot,Ds,ut,un="Essayez de prononcer le même prompt “Générer une image d’un chat” (en anglais “Generate an image of a cat”) et voyez comment le système s’en sort. Si vous posez à l’agent une simple requête de type question/réponse, l’agent répondra par un texte. Vous pouvez l’encourager à générer des sorties multimodales en lui demandant de renvoyer une image ou de la parole. Par exemple, vous pouvez lui demander de générer une image d’un chat, la légender et prononcer la légende (“Generate an image of a cat, caption it, and speak the caption”).",Ks,pt,pn='Bien que l’agent soit plus flexible que notre première itération de l’assistant Marvin 🤖, cette généralisation peut conduire à des performances inférieures sur les requêtes standard de l’assistant vocal. Pour récupérer des performances, vous pouvez essayer d’utiliser un LLM plus performant, comme celui d’OpenAI, ou définir un ensemble d’<a href="https://huggingface.co/docs/transformers/transformers_agents#custom-tools" rel="nofollow">outils personnalisés</a> spécifiques à la tâche d’assistant vocal.',Os,mt,el;return T=new v({props:{title:"Créer un assistant vocal",local:"créer-un-assistant-vocal",headingTag:"h1"}}),B=new v({props:{title:"1. Détection du mot déclencheur",local:"1-détection-du-mot-déclencheur",headingTag:"h3"}}),G=new v({props:{title:"2. Transcription de la parole",local:"2-transcription-de-la-parole",headingTag:"h3"}}),z=new v({props:{title:"3. Requêter le modèle de langage",local:"3-requêter-le-modèle-de-langage",headingTag:"h3"}}),Q=new v({props:{title:"4. Synthétiser la réponse",local:"4-synthétiser-la-réponse",headingTag:"h3"}}),R=new v({props:{title:"Détection des mots déclencheur",local:"détection-des-mots-déclencheur",headingTag:"h2"}}),te=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTNBMCUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEFjbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYXVkaW8tY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMk1JVCUyRmFzdC1maW5ldHVuZWQtc3BlZWNoLWNvbW1hbmRzLXYyJTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;MIT/ast-finetuned-speech-commands-v2&quot;</span>, device=device
)`,wrap:!1}}),le=new f({props:{code:"Y2xhc3NpZmllci5tb2RlbC5jb25maWcuaWQybGFiZWw=",highlighted:"classifier.model.config.id2label",wrap:!1}}),ae=new f({props:{code:"Y2xhc3NpZmllci5tb2RlbC5jb25maWcuaWQybGFiZWwlNUIyNyU1RA==",highlighted:'classifier.model.config.id2label[<span class="hljs-number">27</span>]',wrap:!1}}),ie=new f({props:{code:"J21hcnZpbic=",highlighted:'<span class="hljs-symbol">&#x27;marvin</span>&#x27;',wrap:!1}}),me=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers.pipelines.audio_utils <span class="hljs-keyword">import</span> ffmpeg_microphone_live


<span class="hljs-keyword">def</span> <span class="hljs-title function_">launch_fn</span>(<span class="hljs-params">
    wake_word=<span class="hljs-string">&quot;marvin&quot;</span>,
    prob_threshold=<span class="hljs-number">0.5</span>,
    chunk_length_s=<span class="hljs-number">2.0</span>,
    stream_chunk_s=<span class="hljs-number">0.25</span>,
    debug=<span class="hljs-literal">False</span>,
</span>):
    <span class="hljs-keyword">if</span> wake_word <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> classifier.model.config.label2id.keys():
        <span class="hljs-keyword">raise</span> ValueError(
            <span class="hljs-string">f&quot;Wake word <span class="hljs-subst">{wake_word}</span> not in set of valid class labels, pick a wake word in the set <span class="hljs-subst">{classifier.model.config.label2id.keys()}</span>.&quot;</span>
        )

    sampling_rate = classifier.feature_extractor.sampling_rate

    mic = ffmpeg_microphone_live(
        sampling_rate=sampling_rate,
        chunk_length_s=chunk_length_s,
        stream_chunk_s=stream_chunk_s,
    )

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Listening for wake word...&quot;</span>)
    <span class="hljs-keyword">for</span> prediction <span class="hljs-keyword">in</span> classifier(mic):
        prediction = prediction[<span class="hljs-number">0</span>]
        <span class="hljs-keyword">if</span> debug:
            <span class="hljs-built_in">print</span>(prediction)
        <span class="hljs-keyword">if</span> prediction[<span class="hljs-string">&quot;label&quot;</span>] == wake_word:
            <span class="hljs-keyword">if</span> prediction[<span class="hljs-string">&quot;score&quot;</span>] &gt; prob_threshold:
                <span class="hljs-keyword">return</span> <span class="hljs-literal">True</span>`,wrap:!1}}),Me=new f({props:{code:"bGF1bmNoX2ZuKGRlYnVnJTNEVHJ1ZSk=",highlighted:'launch_fn(debug=<span class="hljs-literal">True</span>)',wrap:!1}}),fe=new f({props:{code:"TGlzdGVuaW5nJTIwZm9yJTIwd2FrZSUyMHdvcmQuLi4lMEElN0Inc2NvcmUnJTNBJTIwMC4wNTUzMjYxMDc4ODk0MTM4MzQlMkMlMjAnbGFiZWwnJTNBJTIwJ29uZSclN0QlMEElN0Inc2NvcmUnJTNBJTIwMC4wNTk5OTg1NjgxNDc0MjA4OCUyQyUyMCdsYWJlbCclM0ElMjAnb2ZmJyU3RCUwQSU3QidzY29yZSclM0ElMjAwLjEyODI3NDg0MzA5NjczMzElMkMlMjAnbGFiZWwnJTNBJTIwJ2ZpdmUnJTdEJTBBJTdCJ3Njb3JlJyUzQSUyMDAuMDczMTAxMTAzMzA1ODE2NjUlMkMlMjAnbGFiZWwnJTNBJTIwJ2ZvbGxvdyclN0QlMEElN0Inc2NvcmUnJTNBJTIwMC4wNjYzNDgwOTgyMTg0NDEwMSUyQyUyMCdsYWJlbCclM0ElMjAnZm9sbG93JyU3RCUwQSU3QidzY29yZSclM0ElMjAwLjA1OTkyNjQyNDE3NTUwMDg3JTJDJTIwJ2xhYmVsJyUzQSUyMCd0cmVlJyU3RCUwQSU3QidzY29yZSclM0ElMjAwLjA1OTkyNjQyNDE3NTUwMDg3JTJDJTIwJ2xhYmVsJyUzQSUyMCd0cmVlJyU3RCUwQSU3QidzY29yZSclM0ElMjAwLjk5OTkxMzIxNTYzNzIwNyUyQyUyMCdsYWJlbCclM0ElMjAnbWFydmluJyU3RA==",highlighted:`Listening for wake word...
{&#x27;score&#x27;: 0.055326107889413834, &#x27;label&#x27;: &#x27;one&#x27;}
{&#x27;score&#x27;: 0.05999856814742088, &#x27;label&#x27;: &#x27;off&#x27;}
{&#x27;score&#x27;: 0.1282748430967331, &#x27;label&#x27;: &#x27;five&#x27;}
{&#x27;score&#x27;: 0.07310110330581665, &#x27;label&#x27;: &#x27;follow&#x27;}
{&#x27;score&#x27;: 0.06634809821844101, &#x27;label&#x27;: &#x27;follow&#x27;}
{&#x27;score&#x27;: 0.05992642417550087, &#x27;label&#x27;: &#x27;tree&#x27;}
{&#x27;score&#x27;: 0.05992642417550087, &#x27;label&#x27;: &#x27;tree&#x27;}
{&#x27;score&#x27;: 0.999913215637207, &#x27;label&#x27;: &#x27;marvin&#x27;}`,wrap:!1}}),he=new v({props:{title:"Transcription de la parole",local:"transcription-de-la-parole",headingTag:"h2"}}),ve=new f({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJvcGVuYWklMkZ3aGlzcGVyLWJhc2UuZW4lMjIlMkMlMjBkZXZpY2UlM0RkZXZpY2UlMEEp",highlighted:`transcriber = pipeline(
    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-base.en&quot;</span>, device=device
)`,wrap:!1}}),I=new Mn({props:{$$slots:{default:[bn]},$$scope:{ctx:ct}}}),be=new f({props:{code:"aW1wb3J0JTIwc3lzJTBBJTBBJTBBZGVmJTIwdHJhbnNjcmliZShjaHVua19sZW5ndGhfcyUzRDUuMCUyQyUyMHN0cmVhbV9jaHVua19zJTNEMS4wKSUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlMjAlM0QlMjB0cmFuc2NyaWJlci5mZWF0dXJlX2V4dHJhY3Rvci5zYW1wbGluZ19yYXRlJTBBJTBBJTIwJTIwJTIwJTIwbWljJTIwJTNEJTIwZmZtcGVnX21pY3JvcGhvbmVfbGl2ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzYW1wbGluZ19yYXRlJTNEc2FtcGxpbmdfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEY2h1bmtfbGVuZ3RoX3MlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdHJlYW1fY2h1bmtfcyUzRHN0cmVhbV9jaHVua19zJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMlN0YXJ0JTIwc3BlYWtpbmcuLi4lMjIpJTBBJTIwJTIwJTIwJTIwZm9yJTIwaXRlbSUyMGluJTIwdHJhbnNjcmliZXIobWljJTJDJTIwZ2VuZXJhdGVfa3dhcmdzJTNEJTdCJTIybWF4X25ld190b2tlbnMlMjIlM0ElMjAxMjglN0QpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3lzLnN0ZG91dC53cml0ZSglMjIlNUMwMzMlNUJLJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGl0ZW0lNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwZW5kJTNEJTIyJTVDciUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMG5vdCUyMGl0ZW0lNUIlMjJwYXJ0aWFsJTIyJTVEJTVCMCU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaXRlbSU1QiUyMnRleHQlMjIlNUQ=",highlighted:`<span class="hljs-keyword">import</span> sys


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe</span>(<span class="hljs-params">chunk_length_s=<span class="hljs-number">5.0</span>, stream_chunk_s=<span class="hljs-number">1.0</span></span>):
    sampling_rate = transcriber.feature_extractor.sampling_rate

    mic = ffmpeg_microphone_live(
        sampling_rate=sampling_rate,
        chunk_length_s=chunk_length_s,
        stream_chunk_s=stream_chunk_s,
    )

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Start speaking...&quot;</span>)
    <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> transcriber(mic, generate_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">128</span>}):
        sys.stdout.write(<span class="hljs-string">&quot;\\033[K&quot;</span>)
        <span class="hljs-built_in">print</span>(item[<span class="hljs-string">&quot;text&quot;</span>], end=<span class="hljs-string">&quot;\\r&quot;</span>)
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> item[<span class="hljs-string">&quot;partial&quot;</span>][<span class="hljs-number">0</span>]:
            <span class="hljs-keyword">break</span>

    <span class="hljs-keyword">return</span> item[<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),je=new f({props:{code:"dHJhbnNjcmliZSgp",highlighted:"transcribe()",wrap:!1}}),Ue=new f({props:{code:"U3RhcnQlMjBzcGVha2luZy4uLiUwQSUyMEhleSUyQyUyMHRoaXMlMjBpcyUyMGElMjB0ZXN0JTIwd2l0aCUyMHRoZSUyMHdoaXNwZXIlMjBtb2RlbC4=",highlighted:`Start speaking...
 Hey, this is a test with the whisper model.`,wrap:!1}}),$e=new v({props:{title:"Requêter le modèle de langue",local:"requêter-le-modèle-de-langue",headingTag:"h2"}}),_e=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRm9sZGVyJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMEFkZWYlMjBxdWVyeSh0ZXh0JTJDJTIwbW9kZWxfaWQlM0QlMjJ0aWl1YWUlMkZmYWxjb24tN2ItaW5zdHJ1Y3QlMjIpJTNBJTBBJTIwJTIwJTIwJTIwYXBpX3VybCUyMCUzRCUyMGYlMjJodHRwcyUzQSUyRiUyRmFwaS1pbmZlcmVuY2UuaHVnZ2luZ2ZhY2UuY28lMkZtb2RlbHMlMkYlN0Jtb2RlbF9pZCU3RCUyMiUwQSUyMCUyMCUyMCUyMGhlYWRlcnMlMjAlM0QlMjAlN0IlMjJBdXRob3JpemF0aW9uJTIyJTNBJTIwZiUyMkJlYXJlciUyMCU3QkhmRm9sZGVyKCkuZ2V0X3Rva2VuKCklN0QlMjIlN0QlMEElMjAlMjAlMjAlMjBwYXlsb2FkJTIwJTNEJTIwJTdCJTIyaW5wdXRzJTIyJTNBJTIwdGV4dCU3RCUwQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJRdWVyeWluZy4uLiUzQSUyMCU3QnRleHQlN0QlMjIpJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5wb3N0KGFwaV91cmwlMkMlMjBoZWFkZXJzJTNEaGVhZGVycyUyQyUyMGpzb24lM0RwYXlsb2FkKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHJlc3BvbnNlLmpzb24oKSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCU1Qmxlbih0ZXh0KSUyMCUyQiUyMDElMjAlM0ElNUQ=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFolder
<span class="hljs-keyword">import</span> requests


<span class="hljs-keyword">def</span> <span class="hljs-title function_">query</span>(<span class="hljs-params">text, model_id=<span class="hljs-string">&quot;tiiuae/falcon-7b-instruct&quot;</span></span>):
    api_url = <span class="hljs-string">f&quot;https://api-inference.huggingface.co/models/<span class="hljs-subst">{model_id}</span>&quot;</span>
    headers = {<span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{HfFolder().get_token()}</span>&quot;</span>}
    payload = {<span class="hljs-string">&quot;inputs&quot;</span>: text}

    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Querying...: <span class="hljs-subst">{text}</span>&quot;</span>)
    response = requests.post(api_url, headers=headers, json=payload)
    <span class="hljs-keyword">return</span> response.json()[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-built_in">len</span>(text) + <span class="hljs-number">1</span> :]`,wrap:!1}}),He=new f({props:{code:"cXVlcnkoJTIyV2hhdCUyMGRvZXMlMjBIdWdnaW5nJTIwRmFjZSUyMGRvJTNGJTIyKQ==",highlighted:'query(<span class="hljs-string">&quot;What does Hugging Face do?&quot;</span>)',wrap:!1}}),Be=new f({props:{code:"J0h1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwY29tcGFueSUyMHRoYXQlMjBwcm92aWRlcyUyMG5hdHVyYWwlMjBsYW5ndWFnZSUyMHByb2Nlc3NpbmclMjBhbmQlMjBtYWNoaW5lJTIwbGVhcm5pbmclMjB0b29scyUyMGZvciUyMGRldmVsb3BlcnMuJTIwVGhleSc=",highlighted:'<span class="hljs-comment">&#x27;Hugging Face is a company that provides natural language processing and machine learning tools for developers. They&#x27;</span>',wrap:!1}}),We=new v({props:{title:"Synthétiser la parole",local:"synthétiser-la-parole",headingTag:"h2"}}),Le=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTJDJTIwU3BlZWNoVDVGb3JUZXh0VG9TcGVlY2glMkMlMjBTcGVlY2hUNUhpZmlHYW4lMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBTcGVlY2hUNVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGc3BlZWNodDVfdHRzJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwU3BlZWNoVDVGb3JUZXh0VG9TcGVlY2guZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMikudG8oZGV2aWNlKSUwQXZvY29kZXIlMjAlM0QlMjBTcGVlY2hUNUhpZmlHYW4uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X2hpZmlnYW4lMjIpLnRvKGRldmljZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor, SpeechT5ForTextToSpeech, SpeechT5HifiGan

processor = SpeechT5Processor.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>)

model = SpeechT5ForTextToSpeech.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>).to(device)
vocoder = SpeechT5HifiGan.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_hifigan&quot;</span>).to(device)`,wrap:!1}}),ze=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZW1iZWRkaW5nc19kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMk1hdHRoaWpzJTJGY211LWFyY3RpYy14dmVjdG9ycyUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjB0b3JjaC50ZW5zb3IoZW1iZWRkaW5nc19kYXRhc2V0JTVCNzMwNiU1RCU1QiUyMnh2ZWN0b3IlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

embeddings_dataset = load_dataset(<span class="hljs-string">&quot;Matthijs/cmu-arctic-xvectors&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
speaker_embeddings = torch.tensor(embeddings_dataset[<span class="hljs-number">7306</span>][<span class="hljs-string">&quot;xvector&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),Ae=new f({props:{code:"ZGVmJTIwc3ludGhlc2lzZSh0ZXh0KSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTIwJTIwJTIwJTIwc3BlZWNoJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGVfc3BlZWNoKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RC50byhkZXZpY2UpJTJDJTIwc3BlYWtlcl9lbWJlZGRpbmdzLnRvKGRldmljZSklMkMlMjB2b2NvZGVyJTNEdm9jb2RlciUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVlY2guY3B1KCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">synthesise</span>(<span class="hljs-params">text</span>):
    inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    speech = model.generate_speech(
        inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].to(device), speaker_embeddings.to(device), vocoder=vocoder
    )
    <span class="hljs-keyword">return</span> speech.cpu()`,wrap:!1}}),Ee=new f({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBYXVkaW8lMjAlM0QlMjBzeW50aGVzaXNlKCUwQSUyMCUyMCUyMCUyMCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwY29tcGFueSUyMHRoYXQlMjBwcm92aWRlcyUyMG5hdHVyYWwlMjBsYW5ndWFnZSUyMHByb2Nlc3NpbmclMjBhbmQlMjBtYWNoaW5lJTIwbGVhcm5pbmclMjB0b29scyUyMGZvciUyMGRldmVsb3BlcnMuJTIyJTBBKSUwQSUwQUF1ZGlvKGF1ZGlvJTJDJTIwcmF0ZSUzRDE2MDAwKQ==",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

audio = synthesise(
    <span class="hljs-string">&quot;Hugging Face is a company that provides natural language processing and machine learning tools for developers.&quot;</span>
)

Audio(audio, rate=<span class="hljs-number">16000</span>)`,wrap:!1}}),Re=new v({props:{title:"Marvin 🤖",local:"marvin-",headingTag:"h2"}}),Pe=new f({props:{code:"bGF1bmNoX2ZuKCklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwdHJhbnNjcmliZSgpJTBBcmVzcG9uc2UlMjAlM0QlMjBxdWVyeSh0cmFuc2NyaXB0aW9uKSUwQWF1ZGlvJTIwJTNEJTIwc3ludGhlc2lzZShyZXNwb25zZSklMEElMEFBdWRpbyhhdWRpbyUyQyUyMHJhdGUlM0QxNjAwMCUyQyUyMGF1dG9wbGF5JTNEVHJ1ZSk=",highlighted:`launch_fn()
transcription = transcribe()
response = query(transcription)
audio = synthesise(response)

Audio(audio, rate=<span class="hljs-number">16000</span>, autoplay=<span class="hljs-literal">True</span>)`,wrap:!1}}),Oe=new v({props:{title:"Généralisation 🪄",local:"généralisation-",headingTag:"h2"}}),lt=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhmQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMEhmQWdlbnQoJTBBJTIwJTIwJTIwJTIwdXJsX2VuZHBvaW50JTNEJTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGYmlnY29kZSUyRnN0YXJjb2RlciUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HfAgent

agent = HfAgent(
    url_endpoint=<span class="hljs-string">&quot;https://api-inference.huggingface.co/models/bigcode/starcoder&quot;</span>
)`,wrap:!1}}),at=new f({props:{code:"YWdlbnQucnVuKCUyMkdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMG9mJTIwYSUyMGNhdCUyMik=",highlighted:'agent.run(<span class="hljs-string">&quot;Generate an image of a cat&quot;</span>)',wrap:!1}}),_=new Mn({props:{$$slots:{default:[gn]},$$scope:{ctx:ct}}}),ot=new f({props:{code:"bGF1bmNoX2ZuKCklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwdHJhbnNjcmliZSgpJTBBYWdlbnQucnVuKHRyYW5zY3JpcHRpb24p",highlighted:`launch_fn()
transcription = transcribe()
agent.run(transcription)`,wrap:!1}}),{c(){y=i("meta"),h=n(),J=i("p"),w=n(),u(T.$$.fragment),g=n(),k=i("p"),k.innerHTML=ll,dt=n(),H=i("p"),H.textContent=nl,Mt=n(),j=i("div"),j.innerHTML=al,ft=n(),u(B.$$.fragment),yt=n(),N=i("p"),N.textContent=il,ht=n(),W=i("p"),W.textContent=rl,Tt=n(),u(G.$$.fragment),vt=n(),L=i("p"),L.innerHTML=ol,Jt=n(),V=i("p"),V.textContent=ul,wt=n(),u(z.$$.fragment),bt=n(),S=i("p"),S.innerHTML=pl,gt=n(),A=i("p"),A.innerHTML=cl,jt=n(),u(Q.$$.fragment),Ut=n(),E=i("p"),E.innerHTML=ml,Ct=n(),Y=i("p"),Y.textContent=dl,$t=n(),u(R.$$.fragment),It=n(),X=i("p"),X.innerHTML=Ml,xt=n(),P=i("p"),P.textContent=fl,qt=n(),F=i("p"),F.innerHTML=yl,Zt=n(),U=i("div"),U.innerHTML=hl,_t=n(),D=i("p"),D.innerHTML=Tl,kt=n(),C=i("div"),C.innerHTML=vl,Ht=n(),K=i("p"),K.innerHTML=Jl,Bt=n(),$=i("div"),$.innerHTML=wl,Nt=n(),O=i("p"),O.innerHTML=bl,Wt=n(),ee=i("p"),ee.innerHTML=gl,Gt=n(),u(te.$$.fragment),Lt=n(),se=i("p"),se.innerHTML=jl,Vt=n(),u(le.$$.fragment),zt=n(),ne=i("p"),ne.innerHTML=Ul,St=n(),u(ae.$$.fragment),At=n(),u(ie.$$.fragment),Qt=n(),re=i("p"),re.textContent=Cl,Et=n(),oe=i("p"),oe.innerHTML=$l,Yt=n(),ue=i("p"),ue.innerHTML=Il,Rt=n(),pe=i("p"),pe.innerHTML=xl,Xt=n(),ce=i("p"),ce.innerHTML=ql,Pt=n(),u(me.$$.fragment),Ft=n(),de=i("p"),de.innerHTML=Zl,Dt=n(),u(Me.$$.fragment),Kt=n(),u(fe.$$.fragment),Ot=n(),ye=i("p"),ye.innerHTML=_l,es=n(),u(he.$$.fragment),ts=n(),Te=i("p"),Te.innerHTML=kl,ss=n(),u(ve.$$.fragment),ls=n(),u(I.$$.fragment),ns=n(),Je=i("p"),Je.innerHTML=Hl,as=n(),we=i("p"),we.innerHTML=Bl,is=n(),u(be.$$.fragment),rs=n(),ge=i("p"),ge.textContent=Nl,os=n(),u(je.$$.fragment),us=n(),u(Ue.$$.fragment),ps=n(),Ce=i("p"),Ce.innerHTML=Wl,cs=n(),u($e.$$.fragment),ms=n(),Ie=i("p"),Ie.innerHTML=Gl,ds=n(),xe=i("p"),xe.innerHTML=Ll,Ms=n(),x=i("div"),x.innerHTML=Vl,fs=n(),qe=i("p"),qe.innerHTML=zl,ys=n(),q=i("div"),q.innerHTML=Sl,hs=n(),Ze=i("p"),Ze.innerHTML=Al,Ts=n(),u(_e.$$.fragment),vs=n(),ke=i("p"),ke.textContent=Ql,Js=n(),u(He.$$.fragment),ws=n(),u(Be.$$.fragment),bs=n(),Ne=i("p"),Ne.innerHTML=El,gs=n(),u(We.$$.fragment),js=n(),Ge=i("p"),Ge.innerHTML=Yl,Us=n(),u(Le.$$.fragment),Cs=n(),Ve=i("p"),Ve.textContent=Rl,$s=n(),u(ze.$$.fragment),Is=n(),Se=i("p"),Se.innerHTML=Xl,xs=n(),u(Ae.$$.fragment),qs=n(),Qe=i("p"),Qe.textContent=Pl,Zs=n(),u(Ee.$$.fragment),_s=n(),Ye=i("p"),Ye.textContent=Fl,ks=n(),u(Re.$$.fragment),Hs=n(),Xe=i("p"),Xe.innerHTML=Dl,Bs=n(),u(Pe.$$.fragment),Ns=n(),Fe=i("p"),Fe.textContent=Kl,Ws=n(),De=i("ul"),De.innerHTML=Ol,Gs=n(),Ke=i("p"),Ke.textContent=en,Ls=n(),u(Oe.$$.fragment),Vs=n(),et=i("p"),et.textContent=tn,zs=n(),tt=i("p"),tt.innerHTML=sn,Ss=n(),st=i("p"),st.innerHTML=ln,As=n(),u(lt.$$.fragment),Qs=n(),nt=i("p"),nt.innerHTML=nn,Es=n(),u(at.$$.fragment),Ys=n(),Z=i("div"),Z.innerHTML=an,Rs=n(),u(_.$$.fragment),Xs=n(),it=i("p"),it.innerHTML=rn,Ps=n(),rt=i("p"),rt.innerHTML=on,Fs=n(),u(ot.$$.fragment),Ds=n(),ut=i("p"),ut.textContent=un,Ks=n(),pt=i("p"),pt.innerHTML=pn,Os=n(),mt=i("p"),this.h()},l(e){const t=Jn("svelte-u9bgzb",document.head);y=r(t,"META",{name:!0,content:!0}),t.forEach(s),h=a(e),J=r(e,"P",{}),dn(J).forEach(s),w=a(e),p(T.$$.fragment,e),g=a(e),k=r(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-tg0ggc"&&(k.innerHTML=ll),dt=a(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-14c3q6f"&&(H.textContent=nl),Mt=a(e),j=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(j)!=="svelte-1tdavdk"&&(j.innerHTML=al),ft=a(e),p(B.$$.fragment,e),yt=a(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1y77khl"&&(N.textContent=il),ht=a(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1h7snzx"&&(W.textContent=rl),Tt=a(e),p(G.$$.fragment,e),vt=a(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1vqp24e"&&(L.innerHTML=ol),Jt=a(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-culcbv"&&(V.textContent=ul),wt=a(e),p(z.$$.fragment,e),bt=a(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-i9y1ji"&&(S.innerHTML=pl),gt=a(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-6yx07k"&&(A.innerHTML=cl),jt=a(e),p(Q.$$.fragment,e),Ut=a(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1cot5xl"&&(E.innerHTML=ml),Ct=a(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-mecbdc"&&(Y.textContent=dl),$t=a(e),p(R.$$.fragment,e),It=a(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1oj0xah"&&(X.innerHTML=Ml),xt=a(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-hgxdoi"&&(P.textContent=fl),qt=a(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-9ucsv6"&&(F.innerHTML=yl),Zt=a(e),U=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-bqfzrn"&&(U.innerHTML=hl),_t=a(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1qzwi7i"&&(D.innerHTML=Tl),kt=a(e),C=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(C)!=="svelte-1t2za6k"&&(C.innerHTML=vl),Ht=a(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1nol91b"&&(K.innerHTML=Jl),Bt=a(e),$=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o($)!=="svelte-1sstogo"&&($.innerHTML=wl),Nt=a(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-sza0tm"&&(O.innerHTML=bl),Wt=a(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1o7jcs2"&&(ee.innerHTML=gl),Gt=a(e),p(te.$$.fragment,e),Lt=a(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1h48dil"&&(se.innerHTML=jl),Vt=a(e),p(le.$$.fragment,e),zt=a(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-s19qkx"&&(ne.innerHTML=Ul),St=a(e),p(ae.$$.fragment,e),At=a(e),p(ie.$$.fragment,e),Qt=a(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-a7herd"&&(re.textContent=Cl),Et=a(e),oe=r(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-egaeir"&&(oe.innerHTML=$l),Yt=a(e),ue=r(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-1smdkik"&&(ue.innerHTML=Il),Rt=a(e),pe=r(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1gfk8as"&&(pe.innerHTML=xl),Xt=a(e),ce=r(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1jp2v4e"&&(ce.innerHTML=ql),Pt=a(e),p(me.$$.fragment,e),Ft=a(e),de=r(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-stmoet"&&(de.innerHTML=Zl),Dt=a(e),p(Me.$$.fragment,e),Kt=a(e),p(fe.$$.fragment,e),Ot=a(e),ye=r(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-1dqu0vd"&&(ye.innerHTML=_l),es=a(e),p(he.$$.fragment,e),ts=a(e),Te=r(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-1th4kxf"&&(Te.innerHTML=kl),ss=a(e),p(ve.$$.fragment,e),ls=a(e),p(I.$$.fragment,e),ns=a(e),Je=r(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-t1n4rc"&&(Je.innerHTML=Hl),as=a(e),we=r(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-17fgw8c"&&(we.innerHTML=Bl),is=a(e),p(be.$$.fragment,e),rs=a(e),ge=r(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-6iwnn"&&(ge.textContent=Nl),os=a(e),p(je.$$.fragment,e),us=a(e),p(Ue.$$.fragment,e),ps=a(e),Ce=r(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-1ytvxur"&&(Ce.innerHTML=Wl),cs=a(e),p($e.$$.fragment,e),ms=a(e),Ie=r(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-drr1b9"&&(Ie.innerHTML=Gl),ds=a(e),xe=r(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-1d8kkxt"&&(xe.innerHTML=Ll),Ms=a(e),x=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(x)!=="svelte-bxbti"&&(x.innerHTML=Vl),fs=a(e),qe=r(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-1ekx8no"&&(qe.innerHTML=zl),ys=a(e),q=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(q)!=="svelte-dbv2wd"&&(q.innerHTML=Sl),hs=a(e),Ze=r(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-1t8opn1"&&(Ze.innerHTML=Al),Ts=a(e),p(_e.$$.fragment,e),vs=a(e),ke=r(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-1mg61tn"&&(ke.textContent=Ql),Js=a(e),p(He.$$.fragment,e),ws=a(e),p(Be.$$.fragment,e),bs=a(e),Ne=r(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1ogvnn7"&&(Ne.innerHTML=El),gs=a(e),p(We.$$.fragment,e),js=a(e),Ge=r(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-3yvzni"&&(Ge.innerHTML=Yl),Us=a(e),p(Le.$$.fragment,e),Cs=a(e),Ve=r(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-1md7a16"&&(Ve.textContent=Rl),$s=a(e),p(ze.$$.fragment,e),Is=a(e),Se=r(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-r9c37d"&&(Se.innerHTML=Xl),xs=a(e),p(Ae.$$.fragment,e),qs=a(e),Qe=r(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-1d12aw"&&(Qe.textContent=Pl),Zs=a(e),p(Ee.$$.fragment,e),_s=a(e),Ye=r(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-1ebhllh"&&(Ye.textContent=Fl),ks=a(e),p(Re.$$.fragment,e),Hs=a(e),Xe=r(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-17ty0f8"&&(Xe.innerHTML=Dl),Bs=a(e),p(Pe.$$.fragment,e),Ns=a(e),Fe=r(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-1xytbda"&&(Fe.textContent=Kl),Ws=a(e),De=r(e,"UL",{"data-svelte-h":!0}),o(De)!=="svelte-1cz5pe3"&&(De.innerHTML=Ol),Gs=a(e),Ke=r(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-q4qq62"&&(Ke.textContent=en),Ls=a(e),p(Oe.$$.fragment,e),Vs=a(e),et=r(e,"P",{"data-svelte-h":!0}),o(et)!=="svelte-ooesv8"&&(et.textContent=tn),zs=a(e),tt=r(e,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-t9t6ex"&&(tt.innerHTML=sn),Ss=a(e),st=r(e,"P",{"data-svelte-h":!0}),o(st)!=="svelte-9iwj4e"&&(st.innerHTML=ln),As=a(e),p(lt.$$.fragment,e),Qs=a(e),nt=r(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-ib8url"&&(nt.innerHTML=nn),Es=a(e),p(at.$$.fragment,e),Ys=a(e),Z=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(Z)!=="svelte-1ggy3u7"&&(Z.innerHTML=an),Rs=a(e),p(_.$$.fragment,e),Xs=a(e),it=r(e,"P",{"data-svelte-h":!0}),o(it)!=="svelte-m72s8x"&&(it.innerHTML=rn),Ps=a(e),rt=r(e,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-xriz9b"&&(rt.innerHTML=on),Fs=a(e),p(ot.$$.fragment,e),Ds=a(e),ut=r(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1vq36q6"&&(ut.textContent=un),Ks=a(e),pt=r(e,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-1ni61ir"&&(pt.innerHTML=pn),Os=a(e),mt=r(e,"P",{}),dn(mt).forEach(s),this.h()},h(){b(y,"name","hf:doc:metadata"),b(y,"content",Un),b(j,"class","flex justify-center"),b(U,"class","flex justify-center"),b(C,"class","flex justify-center"),b($,"class","flex justify-center"),b(x,"class","flex justify-center"),b(q,"class","flex justify-center"),b(Z,"class","flex justify-center")},m(e,t){wn(document.head,y),l(e,h,t),l(e,J,t),l(e,w,t),c(T,e,t),l(e,g,t),l(e,k,t),l(e,dt,t),l(e,H,t),l(e,Mt,t),l(e,j,t),l(e,ft,t),c(B,e,t),l(e,yt,t),l(e,N,t),l(e,ht,t),l(e,W,t),l(e,Tt,t),c(G,e,t),l(e,vt,t),l(e,L,t),l(e,Jt,t),l(e,V,t),l(e,wt,t),c(z,e,t),l(e,bt,t),l(e,S,t),l(e,gt,t),l(e,A,t),l(e,jt,t),c(Q,e,t),l(e,Ut,t),l(e,E,t),l(e,Ct,t),l(e,Y,t),l(e,$t,t),c(R,e,t),l(e,It,t),l(e,X,t),l(e,xt,t),l(e,P,t),l(e,qt,t),l(e,F,t),l(e,Zt,t),l(e,U,t),l(e,_t,t),l(e,D,t),l(e,kt,t),l(e,C,t),l(e,Ht,t),l(e,K,t),l(e,Bt,t),l(e,$,t),l(e,Nt,t),l(e,O,t),l(e,Wt,t),l(e,ee,t),l(e,Gt,t),c(te,e,t),l(e,Lt,t),l(e,se,t),l(e,Vt,t),c(le,e,t),l(e,zt,t),l(e,ne,t),l(e,St,t),c(ae,e,t),l(e,At,t),c(ie,e,t),l(e,Qt,t),l(e,re,t),l(e,Et,t),l(e,oe,t),l(e,Yt,t),l(e,ue,t),l(e,Rt,t),l(e,pe,t),l(e,Xt,t),l(e,ce,t),l(e,Pt,t),c(me,e,t),l(e,Ft,t),l(e,de,t),l(e,Dt,t),c(Me,e,t),l(e,Kt,t),c(fe,e,t),l(e,Ot,t),l(e,ye,t),l(e,es,t),c(he,e,t),l(e,ts,t),l(e,Te,t),l(e,ss,t),c(ve,e,t),l(e,ls,t),c(I,e,t),l(e,ns,t),l(e,Je,t),l(e,as,t),l(e,we,t),l(e,is,t),c(be,e,t),l(e,rs,t),l(e,ge,t),l(e,os,t),c(je,e,t),l(e,us,t),c(Ue,e,t),l(e,ps,t),l(e,Ce,t),l(e,cs,t),c($e,e,t),l(e,ms,t),l(e,Ie,t),l(e,ds,t),l(e,xe,t),l(e,Ms,t),l(e,x,t),l(e,fs,t),l(e,qe,t),l(e,ys,t),l(e,q,t),l(e,hs,t),l(e,Ze,t),l(e,Ts,t),c(_e,e,t),l(e,vs,t),l(e,ke,t),l(e,Js,t),c(He,e,t),l(e,ws,t),c(Be,e,t),l(e,bs,t),l(e,Ne,t),l(e,gs,t),c(We,e,t),l(e,js,t),l(e,Ge,t),l(e,Us,t),c(Le,e,t),l(e,Cs,t),l(e,Ve,t),l(e,$s,t),c(ze,e,t),l(e,Is,t),l(e,Se,t),l(e,xs,t),c(Ae,e,t),l(e,qs,t),l(e,Qe,t),l(e,Zs,t),c(Ee,e,t),l(e,_s,t),l(e,Ye,t),l(e,ks,t),c(Re,e,t),l(e,Hs,t),l(e,Xe,t),l(e,Bs,t),c(Pe,e,t),l(e,Ns,t),l(e,Fe,t),l(e,Ws,t),l(e,De,t),l(e,Gs,t),l(e,Ke,t),l(e,Ls,t),c(Oe,e,t),l(e,Vs,t),l(e,et,t),l(e,zs,t),l(e,tt,t),l(e,Ss,t),l(e,st,t),l(e,As,t),c(lt,e,t),l(e,Qs,t),l(e,nt,t),l(e,Es,t),c(at,e,t),l(e,Ys,t),l(e,Z,t),l(e,Rs,t),c(_,e,t),l(e,Xs,t),l(e,it,t),l(e,Ps,t),l(e,rt,t),l(e,Fs,t),c(ot,e,t),l(e,Ds,t),l(e,ut,t),l(e,Ks,t),l(e,pt,t),l(e,Os,t),l(e,mt,t),el=!0},p(e,[t]){const cn={};t&2&&(cn.$$scope={dirty:t,ctx:e}),I.$set(cn);const mn={};t&2&&(mn.$$scope={dirty:t,ctx:e}),_.$set(mn)},i(e){el||(m(T.$$.fragment,e),m(B.$$.fragment,e),m(G.$$.fragment,e),m(z.$$.fragment,e),m(Q.$$.fragment,e),m(R.$$.fragment,e),m(te.$$.fragment,e),m(le.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(me.$$.fragment,e),m(Me.$$.fragment,e),m(fe.$$.fragment,e),m(he.$$.fragment,e),m(ve.$$.fragment,e),m(I.$$.fragment,e),m(be.$$.fragment,e),m(je.$$.fragment,e),m(Ue.$$.fragment,e),m($e.$$.fragment,e),m(_e.$$.fragment,e),m(He.$$.fragment,e),m(Be.$$.fragment,e),m(We.$$.fragment,e),m(Le.$$.fragment,e),m(ze.$$.fragment,e),m(Ae.$$.fragment,e),m(Ee.$$.fragment,e),m(Re.$$.fragment,e),m(Pe.$$.fragment,e),m(Oe.$$.fragment,e),m(lt.$$.fragment,e),m(at.$$.fragment,e),m(_.$$.fragment,e),m(ot.$$.fragment,e),el=!0)},o(e){d(T.$$.fragment,e),d(B.$$.fragment,e),d(G.$$.fragment,e),d(z.$$.fragment,e),d(Q.$$.fragment,e),d(R.$$.fragment,e),d(te.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(ie.$$.fragment,e),d(me.$$.fragment,e),d(Me.$$.fragment,e),d(fe.$$.fragment,e),d(he.$$.fragment,e),d(ve.$$.fragment,e),d(I.$$.fragment,e),d(be.$$.fragment,e),d(je.$$.fragment,e),d(Ue.$$.fragment,e),d($e.$$.fragment,e),d(_e.$$.fragment,e),d(He.$$.fragment,e),d(Be.$$.fragment,e),d(We.$$.fragment,e),d(Le.$$.fragment,e),d(ze.$$.fragment,e),d(Ae.$$.fragment,e),d(Ee.$$.fragment,e),d(Re.$$.fragment,e),d(Pe.$$.fragment,e),d(Oe.$$.fragment,e),d(lt.$$.fragment,e),d(at.$$.fragment,e),d(_.$$.fragment,e),d(ot.$$.fragment,e),el=!1},d(e){e&&(s(h),s(J),s(w),s(g),s(k),s(dt),s(H),s(Mt),s(j),s(ft),s(yt),s(N),s(ht),s(W),s(Tt),s(vt),s(L),s(Jt),s(V),s(wt),s(bt),s(S),s(gt),s(A),s(jt),s(Ut),s(E),s(Ct),s(Y),s($t),s(It),s(X),s(xt),s(P),s(qt),s(F),s(Zt),s(U),s(_t),s(D),s(kt),s(C),s(Ht),s(K),s(Bt),s($),s(Nt),s(O),s(Wt),s(ee),s(Gt),s(Lt),s(se),s(Vt),s(zt),s(ne),s(St),s(At),s(Qt),s(re),s(Et),s(oe),s(Yt),s(ue),s(Rt),s(pe),s(Xt),s(ce),s(Pt),s(Ft),s(de),s(Dt),s(Kt),s(Ot),s(ye),s(es),s(ts),s(Te),s(ss),s(ls),s(ns),s(Je),s(as),s(we),s(is),s(rs),s(ge),s(os),s(us),s(ps),s(Ce),s(cs),s(ms),s(Ie),s(ds),s(xe),s(Ms),s(x),s(fs),s(qe),s(ys),s(q),s(hs),s(Ze),s(Ts),s(vs),s(ke),s(Js),s(ws),s(bs),s(Ne),s(gs),s(js),s(Ge),s(Us),s(Cs),s(Ve),s($s),s(Is),s(Se),s(xs),s(qs),s(Qe),s(Zs),s(_s),s(Ye),s(ks),s(Hs),s(Xe),s(Bs),s(Ns),s(Fe),s(Ws),s(De),s(Gs),s(Ke),s(Ls),s(Vs),s(et),s(zs),s(tt),s(Ss),s(st),s(As),s(Qs),s(nt),s(Es),s(Ys),s(Z),s(Rs),s(Xs),s(it),s(Ps),s(rt),s(Fs),s(Ds),s(ut),s(Ks),s(pt),s(Os),s(mt)),s(y),M(T,e),M(B,e),M(G,e),M(z,e),M(Q,e),M(R,e),M(te,e),M(le,e),M(ae,e),M(ie,e),M(me,e),M(Me,e),M(fe,e),M(he,e),M(ve,e),M(I,e),M(be,e),M(je,e),M(Ue,e),M($e,e),M(_e,e),M(He,e),M(Be,e),M(We,e),M(Le,e),M(ze,e),M(Ae,e),M(Ee,e),M(Re,e),M(Pe,e),M(Oe,e),M(lt,e),M(at,e),M(_,e),M(ot,e)}}}const Un='{"title":"Créer un assistant vocal","local":"créer-un-assistant-vocal","sections":[{"title":"1. Détection du mot déclencheur","local":"1-détection-du-mot-déclencheur","sections":[],"depth":3},{"title":"2. Transcription de la parole","local":"2-transcription-de-la-parole","sections":[],"depth":3},{"title":"3. Requêter le modèle de langage","local":"3-requêter-le-modèle-de-langage","sections":[],"depth":3},{"title":"4. Synthétiser la réponse","local":"4-synthétiser-la-réponse","sections":[],"depth":3},{"title":"Détection des mots déclencheur","local":"détection-des-mots-déclencheur","sections":[],"depth":2},{"title":"Transcription de la parole","local":"transcription-de-la-parole","sections":[],"depth":2},{"title":"Requêter le modèle de langue","local":"requêter-le-modèle-de-langue","sections":[],"depth":2},{"title":"Synthétiser la parole","local":"synthétiser-la-parole","sections":[],"depth":2},{"title":"Marvin 🤖","local":"marvin-","sections":[],"depth":2},{"title":"Généralisation 🪄","local":"généralisation-","sections":[],"depth":2}],"depth":1}';function Cn(ct){return yn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _n extends Tn{constructor(y){super(),vn(this,y,Cn,jn,fn,{})}}export{_n as component};
