import{s as ys,o as fs}from"../chunks/scheduler.f7e1785c.js";import{S as hs,i as Js,g as i,s as n,r as o,A as Ts,h as u,f as t,c as a,j as js,u as p,x as r,k as Qe,y as Us,a as l,v as d,d as c,t as M,w as m,m as ws,n as bs}from"../chunks/index.9f8f0838.js";import{T as vs}from"../chunks/Tip.4575d9cf.js";import{C as y}from"../chunks/CodeBlock.b3510e34.js";import{H as Ee}from"../chunks/Heading.6643a2f7.js";function gs(ne){let j;return{c(){j=ws(`💡 Quelques informations sur le rééchantillonnage: Si un signal audio a été échantillonné à 8 kHz, de sorte qu'il a 8000 lectures d'échantillon par seconde, nous savons que l'audio ne contient aucune fréquence supérieure à 4 kHz. 
Ceci est garanti par le théorème d'échantillonnage de Nyquist. Pour cette raison, nous pouvons être certains qu'entre les points d'échantillonnage, le signal continu d'origine fait toujours une courbe lisse.
L'augmentation du prélèvement vers un taux d'échantillonnage plus élevé consiste alors à calculer des valeurs d'échantillonnage supplémentaires qui se situent entre les valeurs existantes, en approximant cette courbe. 
Le sous-échantillonnage, cependant, nécessite que nous filtrons d'abord toutes les fréquences qui seraient supérieures à la nouvelle limite de Nyquist, avant d'estimer les nouveaux points d'échantillonnage. 
En d'autres termes, vous ne pouvez pas sous-échantillonner d'un facteur 2x en jetant simplement tous les autres échantillons - cela créera des distorsions dans le signal appelées alias. 
Faire un rééchantillonnage correct est délicat et mieux laissé à des bibliothèques bien testées telles que librosa ou 🤗 *Datasets*.`)},l(f){j=bs(f,`💡 Quelques informations sur le rééchantillonnage: Si un signal audio a été échantillonné à 8 kHz, de sorte qu'il a 8000 lectures d'échantillon par seconde, nous savons que l'audio ne contient aucune fréquence supérieure à 4 kHz. 
Ceci est garanti par le théorème d'échantillonnage de Nyquist. Pour cette raison, nous pouvons être certains qu'entre les points d'échantillonnage, le signal continu d'origine fait toujours une courbe lisse.
L'augmentation du prélèvement vers un taux d'échantillonnage plus élevé consiste alors à calculer des valeurs d'échantillonnage supplémentaires qui se situent entre les valeurs existantes, en approximant cette courbe. 
Le sous-échantillonnage, cependant, nécessite que nous filtrons d'abord toutes les fréquences qui seraient supérieures à la nouvelle limite de Nyquist, avant d'estimer les nouveaux points d'échantillonnage. 
En d'autres termes, vous ne pouvez pas sous-échantillonner d'un facteur 2x en jetant simplement tous les autres échantillons - cela créera des distorsions dans le signal appelées alias. 
Faire un rééchantillonnage correct est délicat et mieux laissé à des bibliothèques bien testées telles que librosa ou 🤗 *Datasets*.`)},m(f,T){l(f,j,T)},d(f){f&&t(j)}}}function Is(ne){let j,f,T,ae,U,ie,w,Le=`Le chargement d’un jeu de données avec 🤗 <em>Datasets</em> n’est que la moitié du plaisir.
Si vous prévoyez de l’utiliser pour entraîner un modèle ou pour exécuter l’inférence, vous devrez d’abord prétraiter les données. En général, cela impliquera les étapes suivantes:`,ue,b,Fe="<li>Rééchantillonnage des données audio</li> <li>Filtrage du jeu de données</li> <li>Conversion des données audio en entrée attendue du modèle</li>",re,v,oe,g,Se=`La fonction <code>load_dataset</code> télécharge des exemples audio avec le taux d’échantillonnage avec lequel ils ont été publiés.
Ce n’est pas toujours le taux d’échantillonnage attendu par un modèle que vous prévoyez d’entraîner ou d’utiliser pour l’inférence.
S’il existe un écart entre les taux d’échantillonnage, vous pouvez rééchantillonner l’audio à la fréquence d’échantillonnage attendue du modèle.
La plupart des modèles pré-entraînés disponibles ont été pré-entraînés sur des jeux de données audio à une fréquence d’échantillonnage de 16 kHz.
Lorsque nous avons exploré le jeu de données MINDS-14, vous avez peut-être remarqué qu’il est échantillonné à 8 kHz, ce qui signifie que nous devrons probablement le suréchantillonner.
Pour ce faire, utilisez la méthode <code>cast_column</code> de 🤗 Datasets.
Cette opération ne modifie pas l’audio sur place, mais plutôt les signaux aux jeux de données pour rééchantillonner les exemples audio à la volée lorsqu’ils sont chargés.
Le code suivant définira la fréquence d’échantillonnage à 16 kHz :`,pe,I,de,C,De="Rechargez le premier exemple audio dans le jeu de données MINDS-14 et vérifiez qu’il a été rééchantillonné à la « fréquence d’échantillonnage » souhaitée :",ce,q,Me,A,Pe="<strong>Sortie :</strong>",me,x,je,$,Oe="Vous remarquerez peut-être que les valeurs de tableau sont maintenant également différentes. C’est parce que nous avons maintenant deux fois plus de valeurs d’amplitude pour chacune d’entre elles que nous avions auparavant.",ye,h,fe,B,he,R,Ke=`Vous devrez peut-être filtrer les données en fonction de certains critères. L’un des cas courants consiste à limiter les exemples audio à une certaine durée.
Par exemple, nous pourrions vouloir filtrer tous les exemples de plus de 20 secondes pour éviter les erreurs de mémoire insuffisante lors de l’entraînement d’un modèle.
Nous pouvons le faire en utilisant la  méthode <code>filter</code> de 🤗 <em>Datasets</em> et en lui passant une fonction avec une logique de filtrage. Commençons par écrire une fonction qui indique quels exemples conserver et lesquels rejeter.
Cette fonction, <code>is_audio_length_in_range&#39;, renvoie </code>True<code>si un échantillon est inférieur à 20s et</code>False\` s’il est plus long que 20s.`,Je,z,Te,G,es=`La fonction de filtrage peut être appliquée à la colonne d’un jeu de données, mais nous n’avons pas de colonne avec une durée de piste audio dans ce jeu de données.
Cependant, nous pouvons en créer un, filtrer en fonction des valeurs de cette colonne, puis le supprimer.`,Ue,_,we,Z,ss="<strong>Sortie :</strong>",be,k,ve,V,ts="Nous pouvons vérifier que le jeu de données a été filtré de 654 exemples à 624.",ge,W,Ie,N,ls=`L’un des aspects les plus difficiles de l’utilisation d’ensembles de données audio consiste à préparer les données dans le bon format pour la formation des modèles.
Comme vous l’avez vu, les données audio brutes se présentent sous la forme d’un tableau de valeurs d’échantillon.
Cependant, les modèles pré-entraînés, que vous les utilisiez pour l’inférence ou que vous souhaitiez les finetuner pour votre tâche, s’attendent à ce que les données brutes soient converties en fonctionnalités d’entrée.
Les exigences pour les caractéristiques d’entrée peuvent varier d’un modèle à l’autre. Elles dépendent de l’architecture du modèle et des données avec lesquelles il a été pré-entraîné.
La bonne nouvelle est que, pour chaque modèle audio pris en charge, 🤗 <em>Transformers</em> offrent une classe d’extracteur de caractéristiques qui peut convertir les données audio brutes en caractéristiques d’entrée attendues par le modèle.`,Ce,H,ns=`Alors, que fait un extracteur de caractéristiques avec les données audio brutes ? Jetons un coup d’œil à l’extracteur de caractéristiques de <a href="https://cdn.openai.com/papers/whisper.pdf" rel="nofollow">Whisper</a> pour comprendre certaines transformations d’extraction de caractéristiques courantes.
Whisper est un modèle pré-entraîné pour la reconnaissance vocale automatique (ASR) publié en septembre 2022 par Alec Radford et al. d’OpenAI.
Tout d’abord, l’extracteur de fonction Whisper pave / tronque un batch d’exemples audio de sorte que tous les exemples ont une longueur d’entrée de 30s.
Les exemples plus courts sont complétés à 30s en ajoutant des zéros à la fin de la séquence (les zéros dans un signal audio correspondent à l’absence de signal ou au silence). Les exemples de plus de 30 ans sont tronqués à 30 s.
Étant donné que tous les éléments du batch sont rembourrés/tronqués à une longueur maximale dans l’espace d’entrée, il n’y a pas besoin d’un masque d’attention.
Whisper est unique à cet égard, la plupart des autres modèles audio nécessitent un masque d’attention qui détaille où les séquences ont été rembourrées, et donc où elles doivent être ignorées dans le mécanisme d’auto-attention.
Whisper est entraîné pour fonctionner sans masque d’attention et déduire directement des signaux vocaux où ignorer les entrées.
La deuxième opération effectuée par l’extracteur de fonctions Whisper consiste à convertir les matrices audio rembourrées en spectrogrammes log-mel.
Ces spectrogrammes décrivent comment les fréquences d’un signal changent au fil du temps, exprimées sur l’échelle mel et mesurées en décibels (la partie log) pour rendre les fréquences et les amplitudes plus représentatives de l’audition humaine.
Toutes ces transformations peuvent être appliquées à vos données audio brutes avec quelques lignes de code.
Allons de l’avant et chargeons l’extracteur de caractéristiques à partir du <em>checkpoint</em> de Whisper pré-entraîné pour être prêt pour nos données audio:`,qe,X,Ae,Y,as="Ensuite, vous pouvez écrire une fonction pour pré-traiter un seul exemple audio en le faisant passer par le <code>feature_extractor</code>.",xe,E,$e,Q,is="Nous pouvons appliquer la fonction de préparation des données à tous nos exemples d’entraînement en utilisant la méthode <code>map</code> de 🤗 <em>Datasets</em> :",Be,L,Re,F,us="<strong>Sortie :</strong>",ze,S,Ge,D,rs=`Aussi simple que cela, nous avons maintenant des spectrogrammes log-mel comme <code>input_features</code> dans le jeu de données.
Visualisons-le pour l’un des exemples de <code>minds</code> :`,_e,P,Ze,J,os='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/log_mel_whisper.png" alt="Log mel spectrogram plot"/>',ke,O,ps="Vous pouvez maintenant voir à quoi ressemble l’entrée audio du modèle Whisper après le prétraitement.",Ve,K,ds=`La classe d’extracteur de caractéristiques du modèle se charge de transformer les données audio brutes au format attendu par le modèle. Cependant, de nombreuses tâches impliquant l’audio sont multimodales, par exemple la reconnaissance vocale.
Dans de tels cas, 🤗 <em>Transformers</em> offrent également des tokeniseurs spécifiques au modèle pour traiter les entrées de texte. Pour une plongée approfondie dans les tokeniseurs, veuillez vous référer à notre <a href="https://huggingface.co/learn/nlp-course/fr/chapter2/4" rel="nofollow">cours de NLP</a>.`,We,ee,cs=`Vous pouvez charger séparément l’extracteur de caractéristiques et le tokeniseur pour Whisper et d’autres modèles multimodaux, ou vous pouvez charger les deux via un processeur.
Pour rendre les choses encore plus simples, utilisez <code>AutoProcessor</code> pour charger l’extracteur de caractéristiques et le processeur d’un modèle à partir d’un <em>checkpoint</em>, comme ceci :`,Ne,se,He,te,Ms=`Nous avons illustré ici les étapes fondamentales de préparation des données. Bien entendu, les données personnalisées peuvent nécessiter un prétraitement plus complexe.
Dans ce cas, vous pouvez étendre la fonction <code>prepare_dataset</code> pour effectuer n’importe quel type de transformations de données personnalisées.
Avec 🤗 <em>Datasets</em>, si vous pouvez l’écrire en tant que fonction Python, vous pouvez l’appliquer à votre jeu de données !`,Xe,le,Ye;return U=new Ee({props:{title:"Prétraitement d’un jeu de données audio",local:"prétraitement-dun-jeu-de-données-audio",headingTag:"h1"}}),v=new Ee({props:{title:"Rééchantillonnage des données audio",local:"rééchantillonnage-des-données-audio",headingTag:"h2"}}),I=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))`,wrap:!1}}),q=new y({props:{code:"bWluZHMlNUIwJTVE",highlighted:'minds[<span class="hljs-number">0</span>]',wrap:!1}}),x=new y({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAyLjA2MzQyNDNlLTA1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS45NDM3ODM3ZS0wNCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIuMjQxOTM0MGUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjA5LjM4NTI4NjJlLTA0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS4xMzAyNDUyZS0wMyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDcuMTUzMTQyOWUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDE2MDAwJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSU3RCUwQQ==",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [
                <span class="hljs-number">2.0634243e-05</span>,
                <span class="hljs-number">1.9437837e-04</span>,
                <span class="hljs-number">2.2419340e-04</span>,
                ...,
                <span class="hljs-number">9.3852862e-04</span>,
                <span class="hljs-number">1.1302452e-03</span>,
                <span class="hljs-number">7.1531429e-04</span>,
            ],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
}
`,wrap:!1}}),h=new vs({props:{$$slots:{default:[gs]},$$scope:{ctx:ne}}}),B=new Ee({props:{title:"Filtrage du jeu de données",local:"filtrage-du-jeu-de-données",headingTag:"h2"}}),z=new y({props:{code:"TUFYX0RVUkFUSU9OX0lOX1NFQ09ORFMlMjAlM0QlMjAyMC4wJTBBJTBBJTBBZGVmJTIwaXNfYXVkaW9fbGVuZ3RoX2luX3JhbmdlKGlucHV0X2xlbmd0aCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dF9sZW5ndGglMjAlM0MlMjBNQVhfRFVSQVRJT05fSU5fU0VDT05EUw==",highlighted:`MAX_DURATION_IN_SECONDS = <span class="hljs-number">20.0</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_audio_length_in_range</span>(<span class="hljs-params">input_length</span>):
    <span class="hljs-keyword">return</span> input_length &lt; MAX_DURATION_IN_SECONDS`,wrap:!1}}),_=new y({props:{code:"JTIzJTIwVXRpbGlzZXolMjBsaWJyb3NhJTIwcG91ciUyMG9idGVuaXIlMjBsYSUyMGR1ciVDMyVBOWUlMjBkZSUyMGwnZXhlbXBsZSUyMCVDMyVBMCUyMHBhcnRpciUyMGR1JTIwZmljaGllciUyMGF1ZGlvJTBBbmV3X2NvbHVtbiUyMCUzRCUyMCU1QmxpYnJvc2EuZ2V0X2R1cmF0aW9uKHBhdGglM0R4KSUyMGZvciUyMHglMjBpbiUyMG1pbmRzJTVCJTIycGF0aCUyMiU1RCU1RCUwQW1pbmRzJTIwJTNEJTIwbWluZHMuYWRkX2NvbHVtbiglMjJkdXJhdGlvbiUyMiUyQyUyMG5ld19jb2x1bW4pJTBBJTBBJTIzJTIwdXRpbGlzZXIlMjBsYSUyMG0lQzMlQTl0aG9kZSUyMCU2MGZpbHRlciU2MCUyMGRlJTIwJUYwJTlGJUE0JTk3JTIwRGF0YXNldHMlMjBwb3VyJTIwYXBwbGlxdWVyJTIwbGElMjBmb25jdGlvbiUyMGRlJTIwZmlsdHJhZ2UlMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmZpbHRlcihpc19hdWRpb19sZW5ndGhfaW5fcmFuZ2UlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyZHVyYXRpb24lMjIlNUQpJTBBJTBBJTIzJTIwc3VwcHJpbWVyJTIwbGElMjBjb2xvbm5lJTIwZCdhc3Npc3RhbmNlJTIwdGVtcG9yYWlyZSUwQW1pbmRzJTIwJTNEJTIwbWluZHMucmVtb3ZlX2NvbHVtbnMoJTVCJTIyZHVyYXRpb24lMjIlNUQpJTBBbWluZHM=",highlighted:`<span class="hljs-comment"># Utilisez librosa pour obtenir la durée de l&#x27;exemple à partir du fichier audio</span>
new_column = [librosa.get_duration(path=x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> minds[<span class="hljs-string">&quot;path&quot;</span>]]
minds = minds.add_column(<span class="hljs-string">&quot;duration&quot;</span>, new_column)

<span class="hljs-comment"># utiliser la méthode \`filter\` de 🤗 Datasets pour appliquer la fonction de filtrage</span>
minds = minds.<span class="hljs-built_in">filter</span>(is_audio_length_in_range, input_columns=[<span class="hljs-string">&quot;duration&quot;</span>])

<span class="hljs-comment"># supprimer la colonne d&#x27;assistance temporaire</span>
minds = minds.remove_columns([<span class="hljs-string">&quot;duration&quot;</span>])
minds`,wrap:!1}}),k=new y({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDYyNCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 624})</span>',wrap:!1}}),W=new Ee({props:{title:"Prétraitement des données audio",local:"prétraitement-des-données-audio",headingTag:"h2"}}),X=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJGZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBXaGlzcGVyRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci1zbWFsbCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperFeatureExtractor

feature_extractor = WhisperFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),E=new y({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTIwcGFkZGluZyUzRFRydWUlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZmVhdHVyZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    features = feature_extractor(
        audio[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>], padding=<span class="hljs-literal">True</span>
    )
    <span class="hljs-keyword">return</span> features`,wrap:!1}}),L=new y({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5tYXAocHJlcGFyZV9kYXRhc2V0KSUwQW1pbmRz",highlighted:`minds = minds.<span class="hljs-built_in">map</span>(prepare_dataset)
minds`,wrap:!1}}),S=new y({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMjAlMjJpbnB1dF9mZWF0dXJlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNjI0JTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>, <span class="hljs-string">&quot;input_features&quot;</span>],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">624</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),P=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWlucHV0X2ZlYXR1cmVzJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmlucHV0X2ZlYXR1cmVzJTIyJTVEJTBBJTBBcGx0LmZpZ3VyZSgpLnNldF9maWd3aWR0aCgxMiklMEFsaWJyb3NhLmRpc3BsYXkuc3BlY3Nob3coJTBBJTIwJTIwJTIwJTIwbnAuYXNhcnJheShpbnB1dF9mZWF0dXJlcyU1QjAlNUQpJTJDJTBBJTIwJTIwJTIwJTIweF9heGlzJTNEJTIydGltZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHlfYXhpcyUzRCUyMm1lbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNyJTNEZmVhdHVyZV9leHRyYWN0b3Iuc2FtcGxpbmdfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMGhvcF9sZW5ndGglM0RmZWF0dXJlX2V4dHJhY3Rvci5ob3BfbGVuZ3RoJTJDJTBBKSUwQXBsdC5jb2xvcmJhcigp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

example = minds[<span class="hljs-number">0</span>]
input_features = example[<span class="hljs-string">&quot;input_features&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.specshow(
    np.asarray(input_features[<span class="hljs-number">0</span>]),
    x_axis=<span class="hljs-string">&quot;time&quot;</span>,
    y_axis=<span class="hljs-string">&quot;mel&quot;</span>,
    sr=feature_extractor.sampling_rate,
    hop_length=feature_extractor.hop_length,
)
plt.colorbar()`,wrap:!1}}),se=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),{c(){j=i("meta"),f=n(),T=i("p"),ae=n(),o(U.$$.fragment),ie=n(),w=i("p"),w.innerHTML=Le,ue=n(),b=i("ul"),b.innerHTML=Fe,re=n(),o(v.$$.fragment),oe=n(),g=i("p"),g.innerHTML=Se,pe=n(),o(I.$$.fragment),de=n(),C=i("p"),C.textContent=De,ce=n(),o(q.$$.fragment),Me=n(),A=i("p"),A.innerHTML=Pe,me=n(),o(x.$$.fragment),je=n(),$=i("p"),$.textContent=Oe,ye=n(),o(h.$$.fragment),fe=n(),o(B.$$.fragment),he=n(),R=i("p"),R.innerHTML=Ke,Je=n(),o(z.$$.fragment),Te=n(),G=i("p"),G.textContent=es,Ue=n(),o(_.$$.fragment),we=n(),Z=i("p"),Z.innerHTML=ss,be=n(),o(k.$$.fragment),ve=n(),V=i("p"),V.textContent=ts,ge=n(),o(W.$$.fragment),Ie=n(),N=i("p"),N.innerHTML=ls,Ce=n(),H=i("p"),H.innerHTML=ns,qe=n(),o(X.$$.fragment),Ae=n(),Y=i("p"),Y.innerHTML=as,xe=n(),o(E.$$.fragment),$e=n(),Q=i("p"),Q.innerHTML=is,Be=n(),o(L.$$.fragment),Re=n(),F=i("p"),F.innerHTML=us,ze=n(),o(S.$$.fragment),Ge=n(),D=i("p"),D.innerHTML=rs,_e=n(),o(P.$$.fragment),Ze=n(),J=i("div"),J.innerHTML=os,ke=n(),O=i("p"),O.textContent=ps,Ve=n(),K=i("p"),K.innerHTML=ds,We=n(),ee=i("p"),ee.innerHTML=cs,Ne=n(),o(se.$$.fragment),He=n(),te=i("p"),te.innerHTML=Ms,Xe=n(),le=i("p"),this.h()},l(e){const s=Ts("svelte-u9bgzb",document.head);j=u(s,"META",{name:!0,content:!0}),s.forEach(t),f=a(e),T=u(e,"P",{}),js(T).forEach(t),ae=a(e),p(U.$$.fragment,e),ie=a(e),w=u(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-mdqbw0"&&(w.innerHTML=Le),ue=a(e),b=u(e,"UL",{"data-svelte-h":!0}),r(b)!=="svelte-yk9hcg"&&(b.innerHTML=Fe),re=a(e),p(v.$$.fragment,e),oe=a(e),g=u(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-ivzlq3"&&(g.innerHTML=Se),pe=a(e),p(I.$$.fragment,e),de=a(e),C=u(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-538ngx"&&(C.textContent=De),ce=a(e),p(q.$$.fragment,e),Me=a(e),A=u(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-dbzevp"&&(A.innerHTML=Pe),me=a(e),p(x.$$.fragment,e),je=a(e),$=u(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-164hhon"&&($.textContent=Oe),ye=a(e),p(h.$$.fragment,e),fe=a(e),p(B.$$.fragment,e),he=a(e),R=u(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-mbvv6"&&(R.innerHTML=Ke),Je=a(e),p(z.$$.fragment,e),Te=a(e),G=u(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-8vpyeu"&&(G.textContent=es),Ue=a(e),p(_.$$.fragment,e),we=a(e),Z=u(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-dbzevp"&&(Z.innerHTML=ss),be=a(e),p(k.$$.fragment,e),ve=a(e),V=u(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-tdnd34"&&(V.textContent=ts),ge=a(e),p(W.$$.fragment,e),Ie=a(e),N=u(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-9jm202"&&(N.innerHTML=ls),Ce=a(e),H=u(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-18oi0yw"&&(H.innerHTML=ns),qe=a(e),p(X.$$.fragment,e),Ae=a(e),Y=u(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-iag9pm"&&(Y.innerHTML=as),xe=a(e),p(E.$$.fragment,e),$e=a(e),Q=u(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1le6nsz"&&(Q.innerHTML=is),Be=a(e),p(L.$$.fragment,e),Re=a(e),F=u(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-dbzevp"&&(F.innerHTML=us),ze=a(e),p(S.$$.fragment,e),Ge=a(e),D=u(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-ojjqz9"&&(D.innerHTML=rs),_e=a(e),p(P.$$.fragment,e),Ze=a(e),J=u(e,"DIV",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-csckl"&&(J.innerHTML=os),ke=a(e),O=u(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-y12i6c"&&(O.textContent=ps),Ve=a(e),K=u(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-19a55if"&&(K.innerHTML=ds),We=a(e),ee=u(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1sqx47z"&&(ee.innerHTML=cs),Ne=a(e),p(se.$$.fragment,e),He=a(e),te=u(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-172ihj8"&&(te.innerHTML=Ms),Xe=a(e),le=u(e,"P",{}),js(le).forEach(t),this.h()},h(){Qe(j,"name","hf:doc:metadata"),Qe(j,"content",Cs),Qe(J,"class","flex justify-center")},m(e,s){Us(document.head,j),l(e,f,s),l(e,T,s),l(e,ae,s),d(U,e,s),l(e,ie,s),l(e,w,s),l(e,ue,s),l(e,b,s),l(e,re,s),d(v,e,s),l(e,oe,s),l(e,g,s),l(e,pe,s),d(I,e,s),l(e,de,s),l(e,C,s),l(e,ce,s),d(q,e,s),l(e,Me,s),l(e,A,s),l(e,me,s),d(x,e,s),l(e,je,s),l(e,$,s),l(e,ye,s),d(h,e,s),l(e,fe,s),d(B,e,s),l(e,he,s),l(e,R,s),l(e,Je,s),d(z,e,s),l(e,Te,s),l(e,G,s),l(e,Ue,s),d(_,e,s),l(e,we,s),l(e,Z,s),l(e,be,s),d(k,e,s),l(e,ve,s),l(e,V,s),l(e,ge,s),d(W,e,s),l(e,Ie,s),l(e,N,s),l(e,Ce,s),l(e,H,s),l(e,qe,s),d(X,e,s),l(e,Ae,s),l(e,Y,s),l(e,xe,s),d(E,e,s),l(e,$e,s),l(e,Q,s),l(e,Be,s),d(L,e,s),l(e,Re,s),l(e,F,s),l(e,ze,s),d(S,e,s),l(e,Ge,s),l(e,D,s),l(e,_e,s),d(P,e,s),l(e,Ze,s),l(e,J,s),l(e,ke,s),l(e,O,s),l(e,Ve,s),l(e,K,s),l(e,We,s),l(e,ee,s),l(e,Ne,s),d(se,e,s),l(e,He,s),l(e,te,s),l(e,Xe,s),l(e,le,s),Ye=!0},p(e,[s]){const ms={};s&2&&(ms.$$scope={dirty:s,ctx:e}),h.$set(ms)},i(e){Ye||(c(U.$$.fragment,e),c(v.$$.fragment,e),c(I.$$.fragment,e),c(q.$$.fragment,e),c(x.$$.fragment,e),c(h.$$.fragment,e),c(B.$$.fragment,e),c(z.$$.fragment,e),c(_.$$.fragment,e),c(k.$$.fragment,e),c(W.$$.fragment,e),c(X.$$.fragment,e),c(E.$$.fragment,e),c(L.$$.fragment,e),c(S.$$.fragment,e),c(P.$$.fragment,e),c(se.$$.fragment,e),Ye=!0)},o(e){M(U.$$.fragment,e),M(v.$$.fragment,e),M(I.$$.fragment,e),M(q.$$.fragment,e),M(x.$$.fragment,e),M(h.$$.fragment,e),M(B.$$.fragment,e),M(z.$$.fragment,e),M(_.$$.fragment,e),M(k.$$.fragment,e),M(W.$$.fragment,e),M(X.$$.fragment,e),M(E.$$.fragment,e),M(L.$$.fragment,e),M(S.$$.fragment,e),M(P.$$.fragment,e),M(se.$$.fragment,e),Ye=!1},d(e){e&&(t(f),t(T),t(ae),t(ie),t(w),t(ue),t(b),t(re),t(oe),t(g),t(pe),t(de),t(C),t(ce),t(Me),t(A),t(me),t(je),t($),t(ye),t(fe),t(he),t(R),t(Je),t(Te),t(G),t(Ue),t(we),t(Z),t(be),t(ve),t(V),t(ge),t(Ie),t(N),t(Ce),t(H),t(qe),t(Ae),t(Y),t(xe),t($e),t(Q),t(Be),t(Re),t(F),t(ze),t(Ge),t(D),t(_e),t(Ze),t(J),t(ke),t(O),t(Ve),t(K),t(We),t(ee),t(Ne),t(He),t(te),t(Xe),t(le)),t(j),m(U,e),m(v,e),m(I,e),m(q,e),m(x,e),m(h,e),m(B,e),m(z,e),m(_,e),m(k,e),m(W,e),m(X,e),m(E,e),m(L,e),m(S,e),m(P,e),m(se,e)}}}const Cs='{"title":"Prétraitement d’un jeu de données audio","local":"prétraitement-dun-jeu-de-données-audio","sections":[{"title":"Rééchantillonnage des données audio","local":"rééchantillonnage-des-données-audio","sections":[],"depth":2},{"title":"Filtrage du jeu de données","local":"filtrage-du-jeu-de-données","sections":[],"depth":2},{"title":"Prétraitement des données audio","local":"prétraitement-des-données-audio","sections":[],"depth":2}],"depth":1}';function qs(ne){return fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zs extends hs{constructor(j){super(),Js(this,j,qs,Is,ys,{})}}export{zs as component};
