import{s as Ps,n as Os,o as qs}from"../chunks/scheduler.7bc62968.js";import{S as le,i as se,g as M,s as a,r as j,m as il,H as rs,A as ee,h as p,f as e,c as t,j as ol,u as J,x as i,n as yl,B as ms,k as $s,y as o,a as n,v as c,d as T,t as w,w as r}from"../chunks/index.2f8492b0.js";import{C as ne}from"../chunks/CodeBlock.4e96d6f7.js";import{H as U,E as ae}from"../chunks/EditOnGithub.2a9ce03a.js";function te(us){let u,cl,jl,Tl,h,wl,C,Us="In this chapter we will go through a convolutional architecture called GoogleNet.",rl,b,ml,A,Is="The Inception architecture, a convolutional neural network (CNN) designed for tasks in computer vision such as classification and detection, stands out due to its efficiency. It contains fewer than 7 million parameters and is significantly more compact than its predecessors, being 9 times smaller than AlexNet and 22 times smaller than VGG16. This architecture gained recognition in the ImageNet 2014 challenge, where Google’s adaptation, named GoogLeNet (a tribute to LeNet), set new benchmarks in performance while utilizing fewer parameters compared to previous leading methods.",ul,d,Ul,f,hs="Before the advent of the Inception architecture, models like AlexNet and VGG demonstrated the benefits of deeper network structures. However, deeper networks typically entail more computational steps and can lead to issues such as overfitting and the vanishing gradient problem. The Inception architecture offers a solution, enabling the training of complex CNNs with a reduced count of floating-point parameters.",Il,x,hl,g,Cs="In prior networks, such as AlexNet or VGG, the fundamental block is the convolution layer itself. However, Lin et al. 2013, introduced the concept of Network In Network, arguing that a single convolution is not necessarily a correct fundamental building block. It ought to be more complex. So, inspired by that, the Inception model authors decided to have a more complex building block called the Inception Module, aptly named after the famous movie - “The Inception” (dream in dream).",Cl,k,bs="The Inception Module insists on applying convolution filters of different kernel sizes for feature extraction at multiple scales. For any input feature map, it applies a $1 \\times 1$ convolution, a 3x3 convolution, and a 5x5 convolution in parallel. In addition to convolution a max pooling operation is also applied. All four operations have padding and stride in such a way as to have the same spatial dimension. These features are concatenated and form the input to the next stage. See Figure 1.",bl,v,As='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/inception_naive.png" alt="inception_naive"/>',Al,B,ds="Figure 1: Naive Inception Module",dl,Q,fs="As we can see applying multiple convolutions at multiple scales with bigger kernel sizes, like 5x5, can increase the number of parameters drastically. This problem is pronounced as the input feature size (channel size) increases. So as we go deep in the network stacking these “Inception Modules”, the computation will increase drastically. The simple solution is to reduce the number of features wherever computational requirements seem to increase. The major pain points of high computation are the convolution layers. The feature dimension is reduced by a computationally inexpensive $1 \\times 1$ convolution just before the 3x3 and 5x5 convolution. Let’s see it with an example.",fl,N,xs="We want to convert a feature map of (\\ S \\times S \\times 128 \\) to (\\ S \\times S \\times 256 \\) via a 5x5 convolution. The number of parameters (excluding biases) is 5<em>5</em>128*256 = 819,200. However, if we reduce the feature dimension first by a $1 \\times 1$ convolution to 64, then the number of parameters(excluding biases) is (\\ 1\\times 1\\times 128\\times 64 + 5\\times 5\\times 64\\times 256 = 8,192 + 409,600 = 417,792 \\). That means the number of parameters was reduced by almost half!",xl,E,gs="We would also want to reduce the output features of max pooling before concatenating with the output feature map. So, we add one more (\\ 1\\times 1 \\) convolution after the max-pooling layer. We also add a ReLU activation after each (\\ 1\\times 1 \\) convolution increasing non-linearity and complexity of the module. See Figure 2.",gl,G,ks='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/inception_reduced.png" alt="inception_reduced"/>',kl,Z,vs="Figure 2: Inception Module",vl,z,Bs="Also, because of the parallel operations of convolutions at multiple scales, we are ensuring more operations without going deeper into the network, essentially mitigating the vanishing gradient problem.",Bl,D,Ql,S,Qs="In prior networks, like AlexNet or VGG, the final layers would be a few fully connected layers. These fully connected layers, due to their large number of units would contribute to most of the parameters in a network. For example, 89% of the parameters of VGG16 are in the final three fully connected layers. 95% of parameters in AlexNet are in the final fully connected layers. This need can be attributed to the premise that a Convolutional layer is not necessarily complex enough.",Nl,_,El,V,Ns="Before the advent of the Inception architecture, models like AlexNet and VGG demonstrated the benefits of deeper network structures. However, deeper networks typically entail more computational steps and can lead to issues such as overfitting and the vanishing gradient problem. The Inception architecture offers a solution, enabling the training of complex CNNs with a reduced count of floating-point parameters.",Gl,H,Es="In a conventional CNN design, layers are typically categorized as either pooling or convolution layers, with specific sizes for convolution filters. Although layering different sizes of convolution filters is beneficial for various tasks, it can rapidly increase the total number of parameters. The Inception architecture takes a different approach by running the convolution filters of various sizes (1x1, 3x3, 5x5) in parallel.  That means it is possible to get different lower-dimensional embeddings -and hence, more information- from the same higher-dimensional features using these parallel processes! These are then integrated with max pooling into a unified component known as the Inception module. The GoogLeNet architecture is composed of a series of 9 such Inception modules. This configuration allows the network to maintain flexibility and learn complex tasks without a substantial increase in depth.",Zl,Y,Gs="However, with an Inception block at our disposal, we do not need fully connected layers and a simple average pooling along the spatial dimensions should be enough. This was also derived from the Network in Network paper. However, GoogLeNet included one fully connected layer. They reported an increase of 0.6% in top-1 accuracy.",zl,W,Zs="GoogLeNet has only 15% of the parameters in the fully connected layers.",Dl,X,Sl,I,os,_l,Fs='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mn>1</mn><mo>×</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> 1 \\times 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7278em;vertical-align:-0.0833em;"></span><span class="mord">1</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Vl,Hl,R,zs="The paper introduces the auxiliary classifiers - branch out a few small classifiers from the layers in between and add the loss from these classifiers to the total loss(with less weightage). This ensures that the layers close to the input also receive gradients of decent magnitude.",Yl,$,Ds="The auxiliary classifier consists of",Wl,y,F,ys,Xl,Ls='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mn>5</mn><mo>×</mo><mn>5</mn></mrow><annotation encoding="application/x-tex"> 5 \\times 5 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7278em;vertical-align:-0.0833em;"></span><span class="mord">5</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">5</span></span></span></span>',Rl,js,L,Js,$l,Ks='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mn>1</mn><mo>×</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> 1 \\times 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7278em;vertical-align:-0.0833em;"></span><span class="mord">1</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Fl,cs,tl,Ss="A fully connected layer with 1024 units and rectified linear activation.",Ts,Ml,_s="A dropout layer with 70% ratio of dropped outputs.",ws,pl,Vs="A linear layer with softmax loss as the classifier.",Ll,K,Hs="These auxiliary classifiers are removed at inference time. However, minimal gains are achieved from using auxiliary classifiers (0.5%).",Kl,P,Ys='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/googlenet_auxiliary_classifier.jpg" alt="googlenet_aux_clf"/>',Pl,O,Ws="Figure 3: An Auxiliary Classifier",Ol,q,ql,ll,Xs="The complete architecture of GoogLeNet is shown in Figure below. All convolutions, including inside the inception block, use ReLU activation. It starts with two convolution(s) and max-pooling blocks. This is followed by a block of two inception modules (3a and 3b) and a max pooling. This follows a block of 5 inception blocks (4a, 4b, 4c, 4d, 4e) and a max pooling after. The auxiliary classifiers are taken out from outputs of 4a and 4d. Two inception blocks follow (5a and 5b). After this, an average pooling and a fully connected layer of 128 units are used.",ls,sl,Rs=`<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/googlenet_architecture.png" alt="googlenet_arch"/>
Figure 4: Complete GoogLeNet Architecture`,ss,el,es,nl,ns,al,as,Jl,ts;return h=new U({props:{title:"GoogLeNet",local:"googlenet",headingTag:"h1"}}),b=new U({props:{title:"Overview",local:"overview",headingTag:"h2"}}),d=new U({props:{title:"Architectural Innovations",local:"architectural-innovations",headingTag:"h3"}}),x=new U({props:{title:"The Inception “Network In Network” Module",local:"the-inception-network-in-network-module",headingTag:"h4"}}),D=new U({props:{title:"Average Pooling",local:"average-pooling",headingTag:"h4"}}),_=new U({props:{title:"Architectural Innovations",local:"architectural-innovations",headingTag:"h3"}}),X=new U({props:{title:"Auxiliary Classifiers",local:"auxiliary-classifiers",headingTag:"h4"}}),q=new U({props:{title:"Architecture - GoogLeNet",local:"architecture---googlenet",headingTag:"h3"}}),el=new U({props:{title:"Code",local:"code",headingTag:"h3"}}),nl=new ne({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn


<span class="hljs-keyword">class</span> <span class="hljs-title class_">BaseConv2d</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, in_channels, out_channels, **kwargs</span>):
        <span class="hljs-built_in">super</span>(BaseConv2d, self).__init__()
        self.conv = nn.Conv2d(in_channels, out_channels, **kwargs)
        self.relu = nn.ReLU()

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = self.conv(x)
        x = self.relu(x)
        <span class="hljs-keyword">return</span> x


<span class="hljs-keyword">class</span> <span class="hljs-title class_">InceptionModule</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, in_channels, n1x1, n3x3red, n3x3, n5x5red, n5x5, pool_proj</span>):
        <span class="hljs-built_in">super</span>(InceptionModule, self).__init__()

        self.b1 = BaseConv2d(in_channels, n1x1, kernel_size=<span class="hljs-number">1</span>)

        self.b1 = nn.Sequential(
            nn.Conv2d(in_channels, n1x1, kernel_size=<span class="hljs-number">1</span>),
            nn.ReLU(<span class="hljs-literal">True</span>),
        )

        self.b2 = nn.Sequential(
            BaseConv2d(in_channels, n3x3red, kernel_size=<span class="hljs-number">1</span>),
            BaseConv2d(n3x3red, n3x3, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
        )

        self.b3 = nn.Sequential(
            BaseConv2d(in_channels, n5x5red, kernel_size=<span class="hljs-number">1</span>),
            BaseConv2d(n5x5red, n5x5, kernel_size=<span class="hljs-number">5</span>, padding=<span class="hljs-number">2</span>),
        )

        self.b4 = nn.Sequential(
            nn.MaxPool2d(<span class="hljs-number">3</span>, stride=<span class="hljs-number">1</span>, padding=<span class="hljs-number">1</span>),
            BaseConv2d(in_channels, pool_proj, kernel_size=<span class="hljs-number">1</span>),
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        y1 = self.b1(x)
        y2 = self.b2(x)
        y3 = self.b3(x)
        y4 = self.b4(x)
        <span class="hljs-keyword">return</span> torch.cat([y1, y2, y3, y4], <span class="hljs-number">1</span>)


<span class="hljs-keyword">class</span> <span class="hljs-title class_">AuxiliaryClassifier</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, in_channels, num_classes, dropout=<span class="hljs-number">0.7</span></span>):
        <span class="hljs-built_in">super</span>(AuxiliaryClassifier, self).__init__()
        self.pool = nn.AvgPool2d(<span class="hljs-number">5</span>, stride=<span class="hljs-number">3</span>)
        self.conv = BaseConv2d(in_channels, <span class="hljs-number">128</span>, kernel_size=<span class="hljs-number">1</span>)
        self.relu = nn.ReLU(<span class="hljs-literal">True</span>)
        self.flatten = nn.Flatten()
        self.fc1 = nn.Linear(<span class="hljs-number">2048</span>, <span class="hljs-number">1024</span>)
        self.dropout = nn.Dropout(dropout)
        self.fc2 = nn.Linear(<span class="hljs-number">1024</span>, num_classes)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = self.pool(x)
        x = self.conv(x)
        x = self.flatten(x)
        x = self.fc1(x)
        x = self.relu(x)
        x = self.dropout(x)
        x = self.fc2(x)
        <span class="hljs-keyword">return</span> x


<span class="hljs-keyword">class</span> <span class="hljs-title class_">GoogLeNet</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, use_aux=<span class="hljs-literal">True</span></span>):
        <span class="hljs-built_in">super</span>(GoogLeNet, self).__init__()

        self.use_aux = use_aux
        <span class="hljs-comment">## block 1</span>
        self.conv1 = BaseConv2d(<span class="hljs-number">3</span>, <span class="hljs-number">64</span>, kernel_size=<span class="hljs-number">7</span>, stride=<span class="hljs-number">2</span>, padding=<span class="hljs-number">3</span>)
        self.lrn1 = nn.LocalResponseNorm(<span class="hljs-number">5</span>, alpha=<span class="hljs-number">0.0001</span>, beta=<span class="hljs-number">0.75</span>)
        self.maxpool1 = nn.MaxPool2d(<span class="hljs-number">3</span>, stride=<span class="hljs-number">2</span>, padding=<span class="hljs-number">1</span>)

        <span class="hljs-comment">## block 2</span>
        self.conv2 = BaseConv2d(<span class="hljs-number">64</span>, <span class="hljs-number">64</span>, kernel_size=<span class="hljs-number">1</span>)
        self.conv3 = BaseConv2d(<span class="hljs-number">64</span>, <span class="hljs-number">192</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>)
        self.lrn2 = nn.LocalResponseNorm(<span class="hljs-number">5</span>, alpha=<span class="hljs-number">0.0001</span>, beta=<span class="hljs-number">0.75</span>)
        self.maxpool2 = nn.MaxPool2d(<span class="hljs-number">3</span>, stride=<span class="hljs-number">2</span>, padding=<span class="hljs-number">1</span>)

        <span class="hljs-comment">## block 3</span>
        self.inception3a = InceptionModule(<span class="hljs-number">192</span>, <span class="hljs-number">64</span>, <span class="hljs-number">96</span>, <span class="hljs-number">128</span>, <span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">32</span>)
        self.inception3b = InceptionModule(<span class="hljs-number">256</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">192</span>, <span class="hljs-number">32</span>, <span class="hljs-number">96</span>, <span class="hljs-number">64</span>)
        self.maxpool3 = nn.MaxPool2d(<span class="hljs-number">3</span>, stride=<span class="hljs-number">2</span>, padding=<span class="hljs-number">1</span>)

        <span class="hljs-comment">## block 4</span>
        self.inception4a = InceptionModule(<span class="hljs-number">480</span>, <span class="hljs-number">192</span>, <span class="hljs-number">96</span>, <span class="hljs-number">208</span>, <span class="hljs-number">16</span>, <span class="hljs-number">48</span>, <span class="hljs-number">64</span>)
        self.inception4b = InceptionModule(<span class="hljs-number">512</span>, <span class="hljs-number">160</span>, <span class="hljs-number">112</span>, <span class="hljs-number">224</span>, <span class="hljs-number">24</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>)
        self.inception4c = InceptionModule(<span class="hljs-number">512</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">256</span>, <span class="hljs-number">24</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>)
        self.inception4d = InceptionModule(<span class="hljs-number">512</span>, <span class="hljs-number">112</span>, <span class="hljs-number">144</span>, <span class="hljs-number">288</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>)
        self.inception4e = InceptionModule(<span class="hljs-number">528</span>, <span class="hljs-number">256</span>, <span class="hljs-number">160</span>, <span class="hljs-number">320</span>, <span class="hljs-number">32</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>)
        self.maxpool4 = nn.MaxPool2d(<span class="hljs-number">3</span>, stride=<span class="hljs-number">2</span>, padding=<span class="hljs-number">1</span>)

        <span class="hljs-comment">## block 5</span>
        self.inception5a = InceptionModule(<span class="hljs-number">832</span>, <span class="hljs-number">256</span>, <span class="hljs-number">160</span>, <span class="hljs-number">320</span>, <span class="hljs-number">32</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>)
        self.inception5b = InceptionModule(<span class="hljs-number">832</span>, <span class="hljs-number">384</span>, <span class="hljs-number">192</span>, <span class="hljs-number">384</span>, <span class="hljs-number">48</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>)

        <span class="hljs-comment">## auxiliary classifier</span>
        <span class="hljs-keyword">if</span> self.use_aux:
            self.aux1 = AuxiliaryClassifier(<span class="hljs-number">512</span>, <span class="hljs-number">1000</span>)
            self.aux2 = AuxiliaryClassifier(<span class="hljs-number">528</span>, <span class="hljs-number">1000</span>)

        <span class="hljs-comment">## block 6</span>
        self.avgpool = nn.AvgPool2d(<span class="hljs-number">7</span>, stride=<span class="hljs-number">1</span>)
        self.dropout = nn.Dropout(<span class="hljs-number">0.4</span>)
        self.fc = nn.Linear(<span class="hljs-number">1024</span>, <span class="hljs-number">1000</span>)

        self.pre_layers = nn.Sequential(
            nn.Conv2d(<span class="hljs-number">3</span>, <span class="hljs-number">64</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(<span class="hljs-literal">True</span>),
        )

        self.inception_blocks = nn.Sequential(
            InceptionModule(<span class="hljs-number">64</span>, <span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">32</span>, <span class="hljs-number">16</span>, <span class="hljs-number">8</span>, <span class="hljs-number">8</span>),
            InceptionModule(<span class="hljs-number">64</span>, <span class="hljs-number">24</span>, <span class="hljs-number">32</span>, <span class="hljs-number">48</span>, <span class="hljs-number">16</span>, <span class="hljs-number">12</span>, <span class="hljs-number">12</span>),
            nn.MaxPool2d(<span class="hljs-number">3</span>, stride=<span class="hljs-number">2</span>, padding=<span class="hljs-number">1</span>),
            InceptionModule(<span class="hljs-number">96</span>, <span class="hljs-number">24</span>, <span class="hljs-number">32</span>, <span class="hljs-number">48</span>, <span class="hljs-number">16</span>, <span class="hljs-number">12</span>, <span class="hljs-number">12</span>),
            InceptionModule(<span class="hljs-number">96</span>, <span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">48</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>),
            InceptionModule(<span class="hljs-number">96</span>, <span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">48</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>),
            InceptionModule(<span class="hljs-number">96</span>, <span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">48</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>),
            InceptionModule(<span class="hljs-number">96</span>, <span class="hljs-number">32</span>, <span class="hljs-number">32</span>, <span class="hljs-number">48</span>, <span class="hljs-number">16</span>, <span class="hljs-number">24</span>, <span class="hljs-number">24</span>),
            nn.MaxPool2d(<span class="hljs-number">3</span>, stride=<span class="hljs-number">2</span>, padding=<span class="hljs-number">1</span>),
            InceptionModule(<span class="hljs-number">128</span>, <span class="hljs-number">32</span>, <span class="hljs-number">48</span>, <span class="hljs-number">64</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>),
            InceptionModule(<span class="hljs-number">128</span>, <span class="hljs-number">32</span>, <span class="hljs-number">48</span>, <span class="hljs-number">64</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>),
        )

        self.output_net = nn.Sequential(
            nn.AdaptiveAvgPool2d((<span class="hljs-number">1</span>, <span class="hljs-number">1</span>)), nn.Flatten(), nn.Linear(<span class="hljs-number">128</span>, <span class="hljs-number">100</span>)
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-comment">## block 1</span>
        x = self.conv1(x)
        x = self.maxpool1(x)
        x = self.lrn1(x)

        <span class="hljs-comment">## block 2</span>
        x = self.conv2(x)
        x = self.conv3(x)
        x = self.lrn2(x)
        x = self.maxpool2(x)

        <span class="hljs-comment">## block 3</span>
        x = self.inception3a(x)
        x = self.inception3b(x)
        x = self.maxpool3(x)

        <span class="hljs-comment">## block 4</span>
        x = self.inception4a(x)
        <span class="hljs-keyword">if</span> self.use_aux:
            aux1 = self.aux1(x)
        x = self.inception4b(x)
        x = self.inception4c(x)
        x = self.inception4d(x)
        <span class="hljs-keyword">if</span> self.use_aux:
            aux2 = self.aux2(x)
        x = self.inception4e(x)
        x = self.maxpool4(x)

        <span class="hljs-comment">## block 5</span>
        x = self.inception5a(x)
        x = self.inception5b(x)

        <span class="hljs-comment">## block 6</span>
        x = self.avgpool(x)
        x = torch.flatten(x, <span class="hljs-number">1</span>)
        x = self.dropout(x)
        x = self.fc(x)

        <span class="hljs-keyword">if</span> self.use_aux:
            <span class="hljs-keyword">return</span> x, aux1, aux2
        <span class="hljs-keyword">else</span>:
            <span class="hljs-keyword">return</span> x`,wrap:!1}}),al=new ae({props:{source:"https://github.com/johko/computer-vision-course/blob/main/chapters/en/unit2/cnns/googlenet.mdx"}}),{c(){u=M("meta"),cl=a(),jl=M("p"),Tl=a(),j(h.$$.fragment),wl=a(),C=M("p"),C.textContent=Us,rl=a(),j(b.$$.fragment),ml=a(),A=M("p"),A.textContent=Is,ul=a(),j(d.$$.fragment),Ul=a(),f=M("p"),f.textContent=hs,Il=a(),j(x.$$.fragment),hl=a(),g=M("p"),g.textContent=Cs,Cl=a(),k=M("p"),k.textContent=bs,bl=a(),v=M("p"),v.innerHTML=As,Al=a(),B=M("p"),B.textContent=ds,dl=a(),Q=M("p"),Q.textContent=fs,fl=a(),N=M("p"),N.innerHTML=xs,xl=a(),E=M("p"),E.textContent=gs,gl=a(),G=M("p"),G.innerHTML=ks,kl=a(),Z=M("p"),Z.textContent=vs,vl=a(),z=M("p"),z.textContent=Bs,Bl=a(),j(D.$$.fragment),Ql=a(),S=M("p"),S.textContent=Qs,Nl=a(),j(_.$$.fragment),El=a(),V=M("p"),V.textContent=Ns,Gl=a(),H=M("p"),H.textContent=Es,Zl=a(),Y=M("p"),Y.textContent=Gs,zl=a(),W=M("p"),W.textContent=Zs,Dl=a(),j(X.$$.fragment),Sl=a(),I=M("p"),os=il("With the introduction of compute saving"),_l=new rs(!1),Vl=il(" convolution and the replacement of multiple fully connected layers with average pooling, the parameters of this network are reduced significantly, which means we can add more layers and go deeper into the network. However, stacking layers can cause the problem of vanishing gradient, where the gradients get smaller and close to zero while propagating back to the initial layers of the network."),Hl=a(),R=M("p"),R.textContent=zs,Yl=a(),$=M("p"),$.textContent=Ds,Wl=a(),y=M("ul"),F=M("li"),ys=il("An average pooling layer with"),Xl=new rs(!1),Rl=il(" filter size and stride 3."),js=a(),L=M("li"),Js=il("A"),$l=new rs(!1),Fl=il(" convolution with 128 filters for dimension reduction and rectified linear activation."),cs=a(),tl=M("li"),tl.textContent=Ss,Ts=a(),Ml=M("li"),Ml.textContent=_s,ws=a(),pl=M("li"),pl.textContent=Vs,Ll=a(),K=M("p"),K.textContent=Hs,Kl=a(),P=M("p"),P.innerHTML=Ys,Pl=a(),O=M("p"),O.textContent=Ws,Ol=a(),j(q.$$.fragment),ql=a(),ll=M("p"),ll.textContent=Xs,ls=a(),sl=M("p"),sl.innerHTML=Rs,ss=a(),j(el.$$.fragment),es=a(),j(nl.$$.fragment),ns=a(),j(al.$$.fragment),as=a(),Jl=M("p"),this.h()},l(l){const s=ee("svelte-u9bgzb",document.head);u=p(s,"META",{name:!0,content:!0}),s.forEach(e),cl=t(l),jl=p(l,"P",{}),ol(jl).forEach(e),Tl=t(l),J(h.$$.fragment,l),wl=t(l),C=p(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-xslj5l"&&(C.textContent=Us),rl=t(l),J(b.$$.fragment,l),ml=t(l),A=p(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-a1s7z3"&&(A.textContent=Is),ul=t(l),J(d.$$.fragment,l),Ul=t(l),f=p(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1v203bk"&&(f.textContent=hs),Il=t(l),J(x.$$.fragment,l),hl=t(l),g=p(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-z24t8v"&&(g.textContent=Cs),Cl=t(l),k=p(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-7ihfvy"&&(k.textContent=bs),bl=t(l),v=p(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-o31koc"&&(v.innerHTML=As),Al=t(l),B=p(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-16ratth"&&(B.textContent=ds),dl=t(l),Q=p(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1sqb65w"&&(Q.textContent=fs),fl=t(l),N=p(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-12r3jjo"&&(N.innerHTML=xs),xl=t(l),E=p(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-snbukh"&&(E.textContent=gs),gl=t(l),G=p(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-hswu6s"&&(G.innerHTML=ks),kl=t(l),Z=p(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-10lkpf"&&(Z.textContent=vs),vl=t(l),z=p(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-tdwvb3"&&(z.textContent=Bs),Bl=t(l),J(D.$$.fragment,l),Ql=t(l),S=p(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1qbnxjr"&&(S.textContent=Qs),Nl=t(l),J(_.$$.fragment,l),El=t(l),V=p(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1v203bk"&&(V.textContent=Ns),Gl=t(l),H=p(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-tsnk6g"&&(H.textContent=Es),Zl=t(l),Y=p(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-12625s8"&&(Y.textContent=Gs),zl=t(l),W=p(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-18qz3gm"&&(W.textContent=Zs),Dl=t(l),J(X.$$.fragment,l),Sl=t(l),I=p(l,"P",{});var Ms=ol(I);os=yl(Ms,"With the introduction of compute saving"),_l=ms(Ms,!1),Vl=yl(Ms," convolution and the replacement of multiple fully connected layers with average pooling, the parameters of this network are reduced significantly, which means we can add more layers and go deeper into the network. However, stacking layers can cause the problem of vanishing gradient, where the gradients get smaller and close to zero while propagating back to the initial layers of the network."),Ms.forEach(e),Hl=t(l),R=p(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-76pfk2"&&(R.textContent=zs),Yl=t(l),$=p(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-meutr"&&($.textContent=Ds),Wl=t(l),y=p(l,"UL",{});var m=ol(y);F=p(m,"LI",{});var ps=ol(F);ys=yl(ps,"An average pooling layer with"),Xl=ms(ps,!1),Rl=yl(ps," filter size and stride 3."),ps.forEach(e),js=t(m),L=p(m,"LI",{});var is=ol(L);Js=yl(is,"A"),$l=ms(is,!1),Fl=yl(is," convolution with 128 filters for dimension reduction and rectified linear activation."),is.forEach(e),cs=t(m),tl=p(m,"LI",{"data-svelte-h":!0}),i(tl)!=="svelte-1n9c038"&&(tl.textContent=Ss),Ts=t(m),Ml=p(m,"LI",{"data-svelte-h":!0}),i(Ml)!=="svelte-tksu1v"&&(Ml.textContent=_s),ws=t(m),pl=p(m,"LI",{"data-svelte-h":!0}),i(pl)!=="svelte-i097ho"&&(pl.textContent=Vs),m.forEach(e),Ll=t(l),K=p(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-4uto13"&&(K.textContent=Hs),Kl=t(l),P=p(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-1low2wu"&&(P.innerHTML=Ys),Pl=t(l),O=p(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-5sbbdp"&&(O.textContent=Ws),Ol=t(l),J(q.$$.fragment,l),ql=t(l),ll=p(l,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-1e43aaq"&&(ll.textContent=Xs),ls=t(l),sl=p(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-1rdgdjr"&&(sl.innerHTML=Rs),ss=t(l),J(el.$$.fragment,l),es=t(l),J(nl.$$.fragment,l),ns=t(l),J(al.$$.fragment,l),as=t(l),Jl=p(l,"P",{}),ol(Jl).forEach(e),this.h()},h(){$s(u,"name","hf:doc:metadata"),$s(u,"content",Me),_l.a=Vl,Xl.a=Rl,$l.a=Fl},m(l,s){o(document.head,u),n(l,cl,s),n(l,jl,s),n(l,Tl,s),c(h,l,s),n(l,wl,s),n(l,C,s),n(l,rl,s),c(b,l,s),n(l,ml,s),n(l,A,s),n(l,ul,s),c(d,l,s),n(l,Ul,s),n(l,f,s),n(l,Il,s),c(x,l,s),n(l,hl,s),n(l,g,s),n(l,Cl,s),n(l,k,s),n(l,bl,s),n(l,v,s),n(l,Al,s),n(l,B,s),n(l,dl,s),n(l,Q,s),n(l,fl,s),n(l,N,s),n(l,xl,s),n(l,E,s),n(l,gl,s),n(l,G,s),n(l,kl,s),n(l,Z,s),n(l,vl,s),n(l,z,s),n(l,Bl,s),c(D,l,s),n(l,Ql,s),n(l,S,s),n(l,Nl,s),c(_,l,s),n(l,El,s),n(l,V,s),n(l,Gl,s),n(l,H,s),n(l,Zl,s),n(l,Y,s),n(l,zl,s),n(l,W,s),n(l,Dl,s),c(X,l,s),n(l,Sl,s),n(l,I,s),o(I,os),_l.m(Fs,I),o(I,Vl),n(l,Hl,s),n(l,R,s),n(l,Yl,s),n(l,$,s),n(l,Wl,s),n(l,y,s),o(y,F),o(F,ys),Xl.m(Ls,F),o(F,Rl),o(y,js),o(y,L),o(L,Js),$l.m(Ks,L),o(L,Fl),o(y,cs),o(y,tl),o(y,Ts),o(y,Ml),o(y,ws),o(y,pl),n(l,Ll,s),n(l,K,s),n(l,Kl,s),n(l,P,s),n(l,Pl,s),n(l,O,s),n(l,Ol,s),c(q,l,s),n(l,ql,s),n(l,ll,s),n(l,ls,s),n(l,sl,s),n(l,ss,s),c(el,l,s),n(l,es,s),c(nl,l,s),n(l,ns,s),c(al,l,s),n(l,as,s),n(l,Jl,s),ts=!0},p:Os,i(l){ts||(T(h.$$.fragment,l),T(b.$$.fragment,l),T(d.$$.fragment,l),T(x.$$.fragment,l),T(D.$$.fragment,l),T(_.$$.fragment,l),T(X.$$.fragment,l),T(q.$$.fragment,l),T(el.$$.fragment,l),T(nl.$$.fragment,l),T(al.$$.fragment,l),ts=!0)},o(l){w(h.$$.fragment,l),w(b.$$.fragment,l),w(d.$$.fragment,l),w(x.$$.fragment,l),w(D.$$.fragment,l),w(_.$$.fragment,l),w(X.$$.fragment,l),w(q.$$.fragment,l),w(el.$$.fragment,l),w(nl.$$.fragment,l),w(al.$$.fragment,l),ts=!1},d(l){l&&(e(cl),e(jl),e(Tl),e(wl),e(C),e(rl),e(ml),e(A),e(ul),e(Ul),e(f),e(Il),e(hl),e(g),e(Cl),e(k),e(bl),e(v),e(Al),e(B),e(dl),e(Q),e(fl),e(N),e(xl),e(E),e(gl),e(G),e(kl),e(Z),e(vl),e(z),e(Bl),e(Ql),e(S),e(Nl),e(El),e(V),e(Gl),e(H),e(Zl),e(Y),e(zl),e(W),e(Dl),e(Sl),e(I),e(Hl),e(R),e(Yl),e($),e(Wl),e(y),e(Ll),e(K),e(Kl),e(P),e(Pl),e(O),e(Ol),e(ql),e(ll),e(ls),e(sl),e(ss),e(es),e(ns),e(as),e(Jl)),e(u),r(h,l),r(b,l),r(d,l),r(x,l),r(D,l),r(_,l),r(X,l),r(q,l),r(el,l),r(nl,l),r(al,l)}}}const Me='{"title":"GoogLeNet","local":"googlenet","sections":[{"title":"Overview","local":"overview","sections":[{"title":"Architectural Innovations","local":"architectural-innovations","sections":[{"title":"The Inception “Network In Network” Module","local":"the-inception-network-in-network-module","sections":[],"depth":4},{"title":"Average Pooling","local":"average-pooling","sections":[],"depth":4}],"depth":3},{"title":"Architectural Innovations","local":"architectural-innovations","sections":[{"title":"Auxiliary Classifiers","local":"auxiliary-classifiers","sections":[],"depth":4}],"depth":3},{"title":"Architecture - GoogLeNet","local":"architecture---googlenet","sections":[],"depth":3},{"title":"Code","local":"code","sections":[],"depth":3}],"depth":2}],"depth":1}';function pe(us){return qs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Je extends le{constructor(u){super(),se(this,u,pe,te,Ps,{})}}export{Je as component};
