import{s as Ha,n as Xa,o as Sa}from"../chunks/scheduler.7bc62968.js";import{S as Qa,i as Aa,g as i,s as n,r as E,m as Ds,H as la,A as La,h as p,f as e,c as l,j as ls,u as Y,x as m,n as Ks,B as ia,k as Ba,y as as,a as t,v as P,d as D,t as K,w as O}from"../chunks/index.2f8492b0.js";import{C as qa}from"../chunks/CodeBlock.4e96d6f7.js";import{H as is,E as Ea}from"../chunks/EditOnGithub.2a9ce03a.js";function Ya(pa){let r,ps,es,ms,c,rs,h,ma=`Neural Radiance Fields are a way of storing a 3D scene within a neural network. This way of storing and representing a scene is often called an implicit representation, since the scene parameters are fully represented by the underlying Multi-Layer Perceptron (MLP).
(As compared to an explicit representation that stores scene parameters like colour or density explicitly in voxel grids.)
This novel way of representing a scene showed very impressive results in the task of <a href="https://en.wikipedia.org/wiki/View_synthesis" rel="nofollow">novel view synthesis</a>, the task of interpolating novel views from camera perspectives that are not in the training set.
Furthermore, it allows us to store large scenes with a smaller memory footprint than explicit representation, since we merely need to store the weights of our neural network compared to voxel grids, which increase in memory size by a cubic term.`,os,u,cs,y,ra=`The field of NeRFs is relatively young with the first publication by <a href="https://www.matthewtancik.com/nerf" rel="nofollow">Mildenhall et al.</a> appearing in 2020.
Since then, a vast number of papers have been published and fast advancements have been made.
Since 2020, more than 620 preprints and publications have been released, with more than 250 repositories on GitHub. <em>(as of Dec 2023, statistics from <a href="https://paperswithcode.com/method/nerf" rel="nofollow">paperswithcode.com</a>)</em>`,hs,d,oa=`Since the first formulation of NeRFs requires long training times (up to days on beefy GPUs), there have been a lot of advancements towards faster training and inference.
An important leap was NVIDIA’s <a href="https://nvlabs.github.io/instant-ngp/" rel="nofollow">Instant-ngp</a>, which was released in 2022.
While the model architecture used in this approach is similar to existing ones, the authors introduced a novel encoding method that uses trainable hash-tables.
Thanks to this type of encoding, we can shrink the MLP down significantly without loosing reconstruction quality.
This novel approach was faster to train and query while performing on par quality wise with then state-of-the-art methods.
<a href="https://jonbarron.info/mipnerf360/" rel="nofollow">Mipnerf-360</a>, which was also released in 2022, is also worth mentioning.
Again, the model architecture is the same as for most NeRFs, but the authors introduced a novel scene contraction that allows us to represent scenes that are unbounded in all directions, which is important for real-world applications.
<a href="https://jonbarron.info/zipnerf/" rel="nofollow">Zip-NeRF</a>, released in 2023, combines recent advancements like the encoding from <a href="https://nvlabs.github.io/instant-ngp/" rel="nofollow">Instant-ngp</a> and the scene contraction from <a href="https://jonbarron.info/mipnerf360/" rel="nofollow">Mipnerf-360</a> to handle real-world situation whilst decreasing training times to under an hour.
<em>(this is still measured on beefy GPUs to be fair)</em>`,us,g,ca="Since the field of NeRFs is rapidly evolving, we added a section <code>sota</code> at the end where we will tease the latest research and the possible future direction of NeRFs.",ys,f,ha="But now enough with the history, let’s dive into the intrinsics of NeRFs! 🚀🚀",ds,v,gs,b,ua=`The fundamental idea behind NeRFs is to represent a scene as a continuous function that maps a position, $\\mathbf{x} \\in \\mathbb{R}^{3}$, and a viewing direction, $\\boldsymbol{\\theta} \\in \\mathbb{R}^{2}$, to a colour $\\mathbf{c} \\in \\mathbb{R}^{3}$ and volume density $\\sigma \\in \\mathbb{R}^{1}$.
As neural networks can serve as universal function approximators, we can approximate this continuous function that represents the scene with a simple Multi-Layer Perceptron (MLP) $F_{\\mathrm{\\Theta}} : (\\mathbf{x}, \\boldsymbol{\\theta}) \\to (\\mathbf{c},\\sigma)$.`,fs,w,ya="A simple NeRF pipeline can be summarized with the following picture:",vs,M,da='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/nerf_pipeline.png" alt="nerf_pipeline"/>',bs,T,ga='Image from: <a href="https://www.matthewtancik.com/nerf" rel="nofollow">Mildenhall et al. (2020)</a>',ws,J,fa="<strong>(a)</strong> Sample points and viewing directions along camera rays and pass them through the network.",Ms,U,va="<strong>(b)</strong> Network output is a colour vector and density value for each sample.",Ts,j,ba="<strong>(c)</strong> Combine the outputs of the network via volumetric rendering to go from discrete samples in 3D space to a 2D image.",Js,C,wa="<strong>(d)</strong> Compute the loss and update network gradients via backpropagation to represent scene.",Us,x,Ma="This is overview is very high level, so for a better understanding, let’s go into the details of the volume rendering and the used loss function.",js,_,Ta="<strong>Volume Rendering</strong>",Cs,o,Os,ss,Ja="differentiable",sa,xs,$a='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi mathvariant="bold">C</mi><mo stretchy="false">(</mo><mi mathvariant="bold">r</mi><mo stretchy="false">)</mo><mo>=</mo><msubsup><mo>∫</mo><msub><mi>t</mi><mi>n</mi></msub><msub><mi>t</mi><mi>f</mi></msub></msubsup><mi>T</mi><mo stretchy="false">(</mo><mi>t</mi><mo stretchy="false">)</mo><mi>σ</mi><mo stretchy="false">(</mo><mi mathvariant="bold">r</mi><mo stretchy="false">(</mo><mi>t</mi><mo stretchy="false">)</mo><mo stretchy="false">)</mo><mi mathvariant="bold">c</mi><mo stretchy="false">(</mo><mi mathvariant="bold">r</mi><mo stretchy="false">(</mo><mi>t</mi><mo stretchy="false">)</mo><mo separator="true">,</mo><mi mathvariant="bold">d</mi><mo stretchy="false">)</mo><mi>d</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">\\mathbf{C}(\\mathbf{r}) = \\int_{t_n}^{t_f}T(t)\\sigma(\\mathbf{r}(t))\\mathbf{c}(\\mathbf{r}(t),\\mathbf{d})dt</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathbf">C</span><span class="mopen">(</span><span class="mord mathbf">r</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:2.5555em;vertical-align:-1.012em;"></span><span class="mop"><span class="mop op-symbol large-op" style="margin-right:0.44445em;position:relative;top:-0.0011em;">∫</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.5435em;"><span style="top:-1.7881em;margin-left:-0.4445em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight"><span class="mord mathnormal mtight">t</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1645em;"><span style="top:-2.357em;margin-left:0em;margin-right:0.0714em;"><span class="pstrut" style="height:2.5em;"></span><span class="sizing reset-size3 size1 mtight"><span class="mord mathnormal mtight">n</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.143em;"><span></span></span></span></span></span></span></span></span></span><span style="top:-3.8129em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight"><span class="mord mathnormal mtight">t</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3448em;"><span style="top:-2.3488em;margin-left:0em;margin-right:0.0714em;"><span class="pstrut" style="height:2.5em;"></span><span class="sizing reset-size3 size1 mtight"><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2901em;"><span></span></span></span></span></span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.012em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">T</span><span class="mopen">(</span><span class="mord mathnormal">t</span><span class="mclose">)</span><span class="mord mathnormal" style="margin-right:0.03588em;">σ</span><span class="mopen">(</span><span class="mord mathbf">r</span><span class="mopen">(</span><span class="mord mathnormal">t</span><span class="mclose">))</span><span class="mord mathbf">c</span><span class="mopen">(</span><span class="mord mathbf">r</span><span class="mopen">(</span><span class="mord mathnormal">t</span><span class="mclose">)</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathbf">d</span><span class="mclose">)</span><span class="mord mathnormal">d</span><span class="mord mathnormal">t</span></span></span></span></span>',_s,I,Ua=`In the equation above, $\\mathbf{C}(\\mathbf{r})$ is the expected colour of a camera ray $\\mathbf{r}(t)=\\mathbf{o}+t\\mathbf{d}$, where $\\mathbf{o} \\in \\mathbb{R}^{3}$ is the origin of the camera, $\\boldsymbol{d} \\in \\mathbb{R}^{3}$ is the viewing direction as a 3D unit vector and $t \\in \\mathbb{R}_+$ is the distance along the ray.
$t_n$ and $t_f$ stand for the near and far bounds of the ray, respectively.
$T(t)$ denotes the accumulated transmittance along ray $\\mathbf{r}(t)$ from $t_n$ to $t$.`,Is,z,aa,zs,Va='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi><mover accent="true"><mi mathvariant="bold-italic">C</mi><mo>^</mo></mover></mi><mo stretchy="false">(</mo><mi mathvariant="bold">r</mi><mo stretchy="false">)</mo><mo>=</mo><munderover><mo>∑</mo><mrow><mi>i</mi><mo>=</mo><mn>1</mn></mrow><mi>N</mi></munderover><msub><mi>T</mi><mi>i</mi></msub><mo stretchy="false">(</mo><mn>1</mn><mo>−</mo><mi>exp</mi><mo>⁡</mo><mo stretchy="false">(</mo><mo>−</mo><msub><mi>σ</mi><mi>i</mi></msub><msub><mi>δ</mi><mi>i</mi></msub><mo stretchy="false">)</mo><mo stretchy="false">)</mo><msub><mi mathvariant="bold">c</mi><mi>i</mi></msub><mtext> </mtext><mo separator="true">,</mo><mtext> where </mtext><msub><mi>T</mi><mi>i</mi></msub><mo>=</mo><mi>exp</mi><mo>⁡</mo><mo fence="false" stretchy="true" minsize="2.4em" maxsize="2.4em">(</mo><mo>−</mo><munderover><mo>∑</mo><mrow><mi>j</mi><mo>=</mo><mn>1</mn></mrow><mrow><mi>i</mi><mo>−</mo><mn>1</mn></mrow></munderover><msub><mi>σ</mi><mi>j</mi></msub><msub><mi>δ</mi><mi>j</mi></msub><mo fence="false" stretchy="true" minsize="2.4em" maxsize="2.4em">)</mo></mrow><annotation encoding="application/x-tex">\\boldsymbol{\\hat{C}}(\\mathbf{r})=\\sum_{i=1}^{N}T_i (1-\\exp(-\\sigma_i \\delta_i)) \\mathbf{c}_i\\,, \\textrm{ where }T_i=\\exp \\bigg(-\\sum_{j=1}^{i-1} \\sigma_j \\delta_j \\bigg)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1995em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9495em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord boldsymbol" style="margin-right:0.06979em;">C</span></span><span style="top:-3.2551em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2875em;"><span class="mord mathbf">^</span></span></span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord mathbf">r</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:3.106em;vertical-align:-1.2777em;"></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.8283em;"><span style="top:-1.8723em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span><span class="mrel mtight">=</span><span class="mord mtight">1</span></span></span></span><span style="top:-3.05em;"><span class="pstrut" style="height:3.05em;"></span><span><span class="mop op-symbol large-op">∑</span></span></span><span style="top:-4.3em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.2777em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.13889em;">T</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.1389em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord">1</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mop">exp</span><span class="mopen">(</span><span class="mord">−</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">σ</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03785em;">δ</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.0379em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">))</span><span class="mord"><span class="mord mathbf">c</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord text"><span class="mord textrm"> where </span></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.13889em;">T</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.1389em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:2.4em;vertical-align:-0.95em;"></span><span class="mop">exp</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="delimsizing size3">(</span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:3.2254em;vertical-align:-1.4138em;"></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.8117em;"><span style="top:-1.8723em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span><span class="mrel mtight">=</span><span class="mord mtight">1</span></span></span></span><span style="top:-3.05em;"><span class="pstrut" style="height:3.05em;"></span><span><span class="mop op-symbol large-op">∑</span></span></span><span style="top:-4.3em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span><span class="mbin mtight">−</span><span class="mord mtight">1</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.4138em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">σ</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03785em;">δ</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.0379em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mord"><span class="delimsizing size3">)</span></span></span></span></span></span>',ks,k,ja="Below, you can see a schematic visualisation of a discretized camera ray in order to get a better sense of the variables from above:",Rs,R,Ca='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/nerf_ray_visualisation.png" alt="ray_image"/>',Zs,Z,xa="<strong>Loss formulation</strong>",Ws,W,ea,Fs,Ga=`<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><msub><mi mathvariant="script">L</mi><mrow><mi mathvariant="normal">r</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">c</mi><mi mathvariant="normal">o</mi><mi mathvariant="normal">n</mi></mrow></msub><mo stretchy="false">(</mo><mi><mover accent="true"><mi mathvariant="bold-italic">C</mi><mo>^</mo></mover></mi><mo separator="true">,</mo><mi><msup><mi mathvariant="bold-italic">C</mi><mo mathvariant="bold-italic">∗</mo></msup></mi><mo stretchy="false">)</mo><mo>=</mo><msup><mrow><mo fence="true">∥</mo><mi><mover accent="true"><mi mathvariant="bold-italic">C</mi><mo>^</mo></mover></mi><mo>−</mo><mi><msup><mi mathvariant="bold-italic">C</mi><mo mathvariant="bold-italic">∗</mo></msup></mi><mo fence="true">∥</mo></mrow><mn>2</mn></msup></mrow><annotation encoding="application/x-tex">\\mathcal{L}_{\\rm recon}(\\boldsymbol{\\hat{C}},\\boldsymbol{C^*}) = \\left\\|\\boldsymbol{\\hat{C}}-\\boldsymbol{C^*}\\right\\|^2</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1995em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathcal">L</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight"><span class="mord mathrm mtight">recon</span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9495em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord boldsymbol" style="margin-right:0.06979em;">C</span></span><span style="top:-3.2551em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2875em;"><span class="mord mathbf">^</span></span></span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord"><span class="mord"><span class="mord boldsymbol" style="margin-right:0.06979em;">C</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7436em;"><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mbin mathbf mtight">∗</span></span></span></span></span></span></span></span></span></span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:2.004em;vertical-align:-0.65em;"></span><span class="minner"><span class="minner"><span class="mopen"><span class="delimsizing mult"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.15em;"><span style="top:-3.15em;"><span class="pstrut" style="height:3.8em;"></span><span style="width:0.556em;height:1.800em;"><svg xmlns="http://www.w3.org/2000/svg" width='0.556em' height='1.800em' viewBox='0 0 556 1800'><path d='M145 15 v585 v600 v585 c2.667,10,9.667,15,21,15
c10,0,16.667,-5,20,-15 v-585 v-600 v-585 c-2.667,-10,-9.667,-15,-21,-15
c-10,0,-16.667,5,-20,15z M188 15 H145 v585 v600 v585 h43z
M367 15 v585 v600 v585 c2.667,10,9.667,15,21,15
c10,0,16.667,-5,20,-15 v-585 v-600 v-585 c-2.667,-10,-9.667,-15,-21,-15
c-10,0,-16.667,5,-20,15z M410 15 H367 v585 v600 v585 h43z'/></svg></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.65em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9495em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord boldsymbol" style="margin-right:0.06979em;">C</span></span><span style="top:-3.2551em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2875em;"><span class="mord mathbf">^</span></span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord"><span class="mord"><span class="mord"><span class="mord boldsymbol" style="margin-right:0.06979em;">C</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7436em;"><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mbin mathbf mtight">∗</span></span></span></span></span></span></span></span></span></span><span class="mclose"><span class="delimsizing mult"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.15em;"><span style="top:-3.15em;"><span class="pstrut" style="height:3.8em;"></span><span style="width:0.556em;height:1.800em;"><svg xmlns="http://www.w3.org/2000/svg" width='0.556em' height='1.800em' viewBox='0 0 556 1800'><path d='M145 15 v585 v600 v585 c2.667,10,9.667,15,21,15
c10,0,16.667,-5,20,-15 v-585 v-600 v-585 c-2.667,-10,-9.667,-15,-21,-15
c-10,0,-16.667,5,-20,15z M188 15 H145 v585 v600 v585 h43z
M367 15 v585 v600 v585 c2.667,10,9.667,15,21,15
c10,0,16.667,-5,20,-15 v-585 v-600 v-585 c-2.667,-10,-9.667,-15,-21,-15
c-10,0,-16.667,5,-20,15z M410 15 H367 v585 v600 v585 h43z'/></svg></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.65em;"><span></span></span></span></span></span></span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:1.354em;"><span style="top:-3.6029em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span></span></span></span></span>`,Ns,F,_a=",where $\\boldsymbol{\\hat{C}}$ is the rendered pixel colour and $\\boldsymbol{C}^*$ is the ground truth pixel colour.",Bs,N,Ia="<strong>Additional remarks</strong>",$s,B,za=`It is very hard to describe the whole NeRF pipeline in detail within a single chapter.
The explanations above are important to understand the basic concepts and similar if not identical in every NeRF model.
However, some additional tricks are needed to obtain a well performing model.`,Vs,$,ka=`First of all, it is necesarry to encode input signals in order to capture high-frequency variations in colour and geometry.
The practice of encoding inputs before passing them through a neural network is not unique to the NeRF domain but also widely adopted in other ML domains like for example Natural Language Processing (NLP).
A very simple encoding where we map the inputs to a higher dimensional space, enabling us to capture high frequency variations in scene parameters could look as follows:`,Gs,V,Hs,G,Ra="The output should look something like the image below:",Xs,H,Za='<img src="https://huggingface.co/datasets/hf-vision/course-assets/blob/main/nerf_encodings.png" alt="encoding"/>',Ss,X,Wa=`The second trick worth mentioning is that most methods use smart approaches to sample points in space.
Essentially, we want to avoid sampling in regions where the scene is empty.
There are various approaches to concentrate samples in regions that contribute most to the final image, but the most prominent one is to use a second network, often called <em>proposal network</em> so that no compute is wasted.
If you are interested in the inner workings and optimisation of such a <em>proposal network</em>, feel free to dig into the publication of <a href="https://jonbarron.info/mipnerf360/" rel="nofollow">Mipnerf-360</a>, where it was first proposed.`,Qs,S,As,Q,Fa=`To get the full experience when training your first NeRF, I recommend taking a look at the awesome <a href="https://colab.research.google.com/github/nerfstudio-project/nerfstudio/blob/main/colab/demo.ipynb" rel="nofollow">Google Colab notebook from the nerfstudio team</a>.
There, you can upload images of a scene of your choice and train a NeRF. You could for example fit a model to represent your living room. 🎉🎉`,Ls,A,qs,L,Na=`The field is rapidly evolving and the number of new publications is almost exploding.
Concerning training and rendering speed, <a href="https://vr-nerf.github.io" rel="nofollow">VR-NeRF</a> and <a href="https://smerf-3d.github.io" rel="nofollow">SMERF</a> show very promising results.
We believe that we will soon be able to stream a real-world scene in real-time on an edge device, and this is a huge leap towards a realistic <em>Metaverse</em>.
However, the research in the field of NeRFs is not only focusing on training and inference speed, but encompasses various directions like, Generative NeRFs, Pose Estimation, Deformable NeRFs, Compositionality and many more.
If you are interested in a curated list of NeRF publications, checkout <a href="https://github.com/awesome-NeRF/awesome-NeRF" rel="nofollow">Awesome-NeRF</a>.`,Es,q,Ys,ts,Ps;return c=new is({props:{title:"Neural Radiance Fields (NeRFs)",local:"neural-radiance-fields-nerfs",headingTag:"h1"}}),u=new is({props:{title:"Short History 📖",local:"short-history-",headingTag:"h2"}}),v=new is({props:{title:"Underlying approach (Vanilla NeRF) 📘🔍",local:"underlying-approach-vanilla-nerf-",headingTag:"h2"}}),V=new qa({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> mediapy <span class="hljs-keyword">as</span> media
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-keyword">def</span> <span class="hljs-title function_">positional_encoding</span>(<span class="hljs-params">in_tensor, num_frequencies, min_freq_exp, max_freq_exp</span>):
    <span class="hljs-string">&quot;&quot;&quot;Function for positional encoding.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># Scale input tensor to [0, 2 * pi]</span>
    scaled_in_tensor = <span class="hljs-number">2</span> * np.pi * in_tensor
    <span class="hljs-comment"># Generate frequency spectrum</span>
    freqs = <span class="hljs-number">2</span> ** torch.linspace(
        min_freq_exp, max_freq_exp, num_frequencies, device=in_tensor.device
    )
    <span class="hljs-comment"># Generate encodings</span>
    scaled_inputs = scaled_in_tensor.unsqueeze(-<span class="hljs-number">1</span>) * freqs
    encoded_inputs = torch.cat(
        [torch.sin(scaled_inputs), torch.cos(scaled_inputs)], dim=-<span class="hljs-number">1</span>
    )
    <span class="hljs-keyword">return</span> encoded_inputs.view(*in_tensor.shape[:-<span class="hljs-number">1</span>], -<span class="hljs-number">1</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">visualize_grid</span>(<span class="hljs-params">grid, encoded_images, resolution</span>):
    <span class="hljs-string">&quot;&quot;&quot;Helper Function to visualize grid.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># Split the grid into separate channels for x and y</span>
    x_channel, y_channel = grid[..., <span class="hljs-number">0</span>], grid[..., <span class="hljs-number">1</span>]
    <span class="hljs-comment"># Show the original grid</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Input Values:&quot;</span>)
    media.show_images([x_channel, y_channel], cmap=<span class="hljs-string">&quot;plasma&quot;</span>, border=<span class="hljs-literal">True</span>)
    <span class="hljs-comment"># Show the encoded grid</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Encoded Values:&quot;</span>)
    num_channels_to_visualize = <span class="hljs-built_in">min</span>(
        <span class="hljs-number">8</span>, encoded_images.shape[-<span class="hljs-number">1</span>]
    )  <span class="hljs-comment"># Visualize up to 8 channels</span>
    encoded_images_to_show = encoded_images.view(resolution, resolution, -<span class="hljs-number">1</span>).permute(
        <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>
    )[:num_channels_to_visualize]
    media.show_images(encoded_images_to_show, vmin=-<span class="hljs-number">1</span>, vmax=<span class="hljs-number">1</span>, cmap=<span class="hljs-string">&quot;plasma&quot;</span>, border=<span class="hljs-literal">True</span>)


<span class="hljs-comment"># Parameters similar to your NeRFEncoding example</span>
num_frequencies = <span class="hljs-number">4</span>
min_freq_exp = <span class="hljs-number">0</span>
max_freq_exp = <span class="hljs-number">6</span>
resolution = <span class="hljs-number">128</span>

<span class="hljs-comment"># Generate a 2D grid of points in the range [0, 1]</span>
x_samples = torch.linspace(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, resolution)
y_samples = torch.linspace(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, resolution)
grid = torch.stack(
    torch.meshgrid(x_samples, y_samples), dim=-<span class="hljs-number">1</span>
)  <span class="hljs-comment"># [resolution, resolution, 2]</span>

<span class="hljs-comment"># Apply positional encoding</span>
encoded_grid = positional_encoding(grid, num_frequencies, min_freq_exp, max_freq_exp)

<span class="hljs-comment"># Visualize result</span>
visualize_grid(grid, encoded_grid, resolution)`,wrap:!1}}),S=new is({props:{title:"Train your own NeRF",local:"train-your-own-nerf",headingTag:"h2"}}),A=new is({props:{title:"Current advancements in the field",local:"sota",headingTag:"h2"}}),q=new Ea({props:{source:"https://github.com/johko/computer-vision-course/blob/main/chapters/en/unit8/nerf.mdx"}}),{c(){r=i("meta"),ps=n(),es=i("p"),ms=n(),E(c.$$.fragment),rs=n(),h=i("p"),h.innerHTML=ma,os=n(),E(u.$$.fragment),cs=n(),y=i("p"),y.innerHTML=ra,hs=n(),d=i("p"),d.innerHTML=oa,us=n(),g=i("p"),g.innerHTML=ca,ys=n(),f=i("p"),f.textContent=ha,ds=n(),E(v.$$.fragment),gs=n(),b=i("p"),b.textContent=ua,fs=n(),w=i("p"),w.textContent=ya,vs=n(),M=i("p"),M.innerHTML=da,bs=n(),T=i("p"),T.innerHTML=ga,ws=n(),J=i("p"),J.innerHTML=fa,Ms=n(),U=i("p"),U.innerHTML=va,Ts=n(),j=i("p"),j.innerHTML=ba,Js=n(),C=i("p"),C.innerHTML=wa,Us=n(),x=i("p"),x.textContent=Ma,js=n(),_=i("p"),_.innerHTML=Ta,Cs=n(),o=i("p"),Os=Ds(`The principles behind the process of volumetric rendering are well established in classical computer graphics pipelines and do not stem from NeRFs.
What is important for the use case of NeRFs is that this step is `),ss=i("strong"),ss.textContent=Ja,sa=Ds(` in order to allow for backpropagation. The simplest form of volumetric rendering in NeRFs can be formulated as follows:
`),xs=new la(!1),_s=n(),I=i("p"),I.textContent=Ua,Is=n(),z=i("p"),aa=Ds(`After discretization, the equation above can be computed as the following sum:
`),zs=new la(!1),ks=n(),k=i("p"),k.textContent=ja,Rs=n(),R=i("p"),R.innerHTML=Ca,Zs=n(),Z=i("p"),Z.innerHTML=xa,Ws=n(),W=i("p"),ea=Ds(`As the discretized volumetric rendeing equation is fully differentiable, the weights of the underlying neural network can then be trained using a reconstruction loss on the rendered pixels.
Many NeRF approaches use a pixel-wise error term that can be written as follows:
`),Fs=new la(!1),Ns=n(),F=i("p"),F.textContent=_a,Bs=n(),N=i("p"),N.innerHTML=Ia,$s=n(),B=i("p"),B.textContent=za,Vs=n(),$=i("p"),$.textContent=ka,Gs=n(),E(V.$$.fragment),Hs=n(),G=i("p"),G.textContent=Ra,Xs=n(),H=i("p"),H.innerHTML=Za,Ss=n(),X=i("p"),X.innerHTML=Wa,Qs=n(),E(S.$$.fragment),As=n(),Q=i("p"),Q.innerHTML=Fa,Ls=n(),E(A.$$.fragment),qs=n(),L=i("p"),L.innerHTML=Na,Es=n(),E(q.$$.fragment),Ys=n(),ts=i("p"),this.h()},l(s){const a=La("svelte-u9bgzb",document.head);r=p(a,"META",{name:!0,content:!0}),a.forEach(e),ps=l(s),es=p(s,"P",{}),ls(es).forEach(e),ms=l(s),Y(c.$$.fragment,s),rs=l(s),h=p(s,"P",{"data-svelte-h":!0}),m(h)!=="svelte-jul4ou"&&(h.innerHTML=ma),os=l(s),Y(u.$$.fragment,s),cs=l(s),y=p(s,"P",{"data-svelte-h":!0}),m(y)!=="svelte-b8xglz"&&(y.innerHTML=ra),hs=l(s),d=p(s,"P",{"data-svelte-h":!0}),m(d)!=="svelte-16j6utc"&&(d.innerHTML=oa),us=l(s),g=p(s,"P",{"data-svelte-h":!0}),m(g)!=="svelte-1oqw5y8"&&(g.innerHTML=ca),ys=l(s),f=p(s,"P",{"data-svelte-h":!0}),m(f)!=="svelte-pma9sc"&&(f.textContent=ha),ds=l(s),Y(v.$$.fragment,s),gs=l(s),b=p(s,"P",{"data-svelte-h":!0}),m(b)!=="svelte-3tnuk1"&&(b.textContent=ua),fs=l(s),w=p(s,"P",{"data-svelte-h":!0}),m(w)!=="svelte-y9lvf0"&&(w.textContent=ya),vs=l(s),M=p(s,"P",{"data-svelte-h":!0}),m(M)!=="svelte-1rmodno"&&(M.innerHTML=da),bs=l(s),T=p(s,"P",{"data-svelte-h":!0}),m(T)!=="svelte-1ka629u"&&(T.innerHTML=ga),ws=l(s),J=p(s,"P",{"data-svelte-h":!0}),m(J)!=="svelte-1tobfln"&&(J.innerHTML=fa),Ms=l(s),U=p(s,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1c917er"&&(U.innerHTML=va),Ts=l(s),j=p(s,"P",{"data-svelte-h":!0}),m(j)!=="svelte-1oxe61n"&&(j.innerHTML=ba),Js=l(s),C=p(s,"P",{"data-svelte-h":!0}),m(C)!=="svelte-9jqkju"&&(C.innerHTML=wa),Us=l(s),x=p(s,"P",{"data-svelte-h":!0}),m(x)!=="svelte-105mi7d"&&(x.textContent=Ma),js=l(s),_=p(s,"P",{"data-svelte-h":!0}),m(_)!=="svelte-8gnilz"&&(_.innerHTML=Ta),Cs=l(s),o=p(s,"P",{});var ns=ls(o);Os=Ks(ns,`The principles behind the process of volumetric rendering are well established in classical computer graphics pipelines and do not stem from NeRFs.
What is important for the use case of NeRFs is that this step is `),ss=p(ns,"STRONG",{"data-svelte-h":!0}),m(ss)!=="svelte-tu9yc4"&&(ss.textContent=Ja),sa=Ks(ns,` in order to allow for backpropagation. The simplest form of volumetric rendering in NeRFs can be formulated as follows:
`),xs=ia(ns,!1),ns.forEach(e),_s=l(s),I=p(s,"P",{"data-svelte-h":!0}),m(I)!=="svelte-cxj60j"&&(I.textContent=Ua),Is=l(s),z=p(s,"P",{});var ta=ls(z);aa=Ks(ta,`After discretization, the equation above can be computed as the following sum:
`),zs=ia(ta,!1),ta.forEach(e),ks=l(s),k=p(s,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1lchi64"&&(k.textContent=ja),Rs=l(s),R=p(s,"P",{"data-svelte-h":!0}),m(R)!=="svelte-130vc1o"&&(R.innerHTML=Ca),Zs=l(s),Z=p(s,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1ylz9no"&&(Z.innerHTML=xa),Ws=l(s),W=p(s,"P",{});var na=ls(W);ea=Ks(na,`As the discretized volumetric rendeing equation is fully differentiable, the weights of the underlying neural network can then be trained using a reconstruction loss on the rendered pixels.
Many NeRF approaches use a pixel-wise error term that can be written as follows:
`),Fs=ia(na,!1),na.forEach(e),Ns=l(s),F=p(s,"P",{"data-svelte-h":!0}),m(F)!=="svelte-qt58wn"&&(F.textContent=_a),Bs=l(s),N=p(s,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1fogha9"&&(N.innerHTML=Ia),$s=l(s),B=p(s,"P",{"data-svelte-h":!0}),m(B)!=="svelte-900j4b"&&(B.textContent=za),Vs=l(s),$=p(s,"P",{"data-svelte-h":!0}),m($)!=="svelte-wakkft"&&($.textContent=ka),Gs=l(s),Y(V.$$.fragment,s),Hs=l(s),G=p(s,"P",{"data-svelte-h":!0}),m(G)!=="svelte-v8crjg"&&(G.textContent=Ra),Xs=l(s),H=p(s,"P",{"data-svelte-h":!0}),m(H)!=="svelte-cyuxuu"&&(H.innerHTML=Za),Ss=l(s),X=p(s,"P",{"data-svelte-h":!0}),m(X)!=="svelte-92cgsm"&&(X.innerHTML=Wa),Qs=l(s),Y(S.$$.fragment,s),As=l(s),Q=p(s,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-zhe5l7"&&(Q.innerHTML=Fa),Ls=l(s),Y(A.$$.fragment,s),qs=l(s),L=p(s,"P",{"data-svelte-h":!0}),m(L)!=="svelte-z2v2y8"&&(L.innerHTML=Na),Es=l(s),Y(q.$$.fragment,s),Ys=l(s),ts=p(s,"P",{}),ls(ts).forEach(e),this.h()},h(){Ba(r,"name","hf:doc:metadata"),Ba(r,"content",Pa),xs.a=null,zs.a=null,Fs.a=null},m(s,a){as(document.head,r),t(s,ps,a),t(s,es,a),t(s,ms,a),P(c,s,a),t(s,rs,a),t(s,h,a),t(s,os,a),P(u,s,a),t(s,cs,a),t(s,y,a),t(s,hs,a),t(s,d,a),t(s,us,a),t(s,g,a),t(s,ys,a),t(s,f,a),t(s,ds,a),P(v,s,a),t(s,gs,a),t(s,b,a),t(s,fs,a),t(s,w,a),t(s,vs,a),t(s,M,a),t(s,bs,a),t(s,T,a),t(s,ws,a),t(s,J,a),t(s,Ms,a),t(s,U,a),t(s,Ts,a),t(s,j,a),t(s,Js,a),t(s,C,a),t(s,Us,a),t(s,x,a),t(s,js,a),t(s,_,a),t(s,Cs,a),t(s,o,a),as(o,Os),as(o,ss),as(o,sa),xs.m($a,o),t(s,_s,a),t(s,I,a),t(s,Is,a),t(s,z,a),as(z,aa),zs.m(Va,z),t(s,ks,a),t(s,k,a),t(s,Rs,a),t(s,R,a),t(s,Zs,a),t(s,Z,a),t(s,Ws,a),t(s,W,a),as(W,ea),Fs.m(Ga,W),t(s,Ns,a),t(s,F,a),t(s,Bs,a),t(s,N,a),t(s,$s,a),t(s,B,a),t(s,Vs,a),t(s,$,a),t(s,Gs,a),P(V,s,a),t(s,Hs,a),t(s,G,a),t(s,Xs,a),t(s,H,a),t(s,Ss,a),t(s,X,a),t(s,Qs,a),P(S,s,a),t(s,As,a),t(s,Q,a),t(s,Ls,a),P(A,s,a),t(s,qs,a),t(s,L,a),t(s,Es,a),P(q,s,a),t(s,Ys,a),t(s,ts,a),Ps=!0},p:Xa,i(s){Ps||(D(c.$$.fragment,s),D(u.$$.fragment,s),D(v.$$.fragment,s),D(V.$$.fragment,s),D(S.$$.fragment,s),D(A.$$.fragment,s),D(q.$$.fragment,s),Ps=!0)},o(s){K(c.$$.fragment,s),K(u.$$.fragment,s),K(v.$$.fragment,s),K(V.$$.fragment,s),K(S.$$.fragment,s),K(A.$$.fragment,s),K(q.$$.fragment,s),Ps=!1},d(s){s&&(e(ps),e(es),e(ms),e(rs),e(h),e(os),e(cs),e(y),e(hs),e(d),e(us),e(g),e(ys),e(f),e(ds),e(gs),e(b),e(fs),e(w),e(vs),e(M),e(bs),e(T),e(ws),e(J),e(Ms),e(U),e(Ts),e(j),e(Js),e(C),e(Us),e(x),e(js),e(_),e(Cs),e(o),e(_s),e(I),e(Is),e(z),e(ks),e(k),e(Rs),e(R),e(Zs),e(Z),e(Ws),e(W),e(Ns),e(F),e(Bs),e(N),e($s),e(B),e(Vs),e($),e(Gs),e(Hs),e(G),e(Xs),e(H),e(Ss),e(X),e(Qs),e(As),e(Q),e(Ls),e(qs),e(L),e(Es),e(Ys),e(ts)),e(r),O(c,s),O(u,s),O(v,s),O(V,s),O(S,s),O(A,s),O(q,s)}}}const Pa='{"title":"Neural Radiance Fields (NeRFs)","local":"neural-radiance-fields-nerfs","sections":[{"title":"Short History 📖","local":"short-history-","sections":[],"depth":2},{"title":"Underlying approach (Vanilla NeRF) 📘🔍","local":"underlying-approach-vanilla-nerf-","sections":[],"depth":2},{"title":"Train your own NeRF","local":"train-your-own-nerf","sections":[],"depth":2},{"title":"Current advancements in the field","local":"sota","sections":[],"depth":2}],"depth":1}';function Da(pa){return Sa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ee extends Qa{constructor(r){super(),Aa(this,r,Da,Ya,Ha,{})}}export{ee as component};
