import{s as qa,n as Aa,o as Ga}from"../chunks/scheduler.389d799c.js";import{S as ka,i as Qa,g as J,s as l,r as p,A as Sa,h as d,f as a,c as e,j as Wa,u as i,x as j,k as Ca,y as Za,a as n,v as u,d as M,t as o,w as T}from"../chunks/index.8f81d18f.js";import{C as r}from"../chunks/CodeBlock.3845caa1.js";import{H as c}from"../chunks/Heading.41733039.js";function Ea(ia){let y,Ht,Et,Vt,m,Rt,h,ua=`Inference Endpoints offers out-of-the-box support for Machine Learning tasks from the Transformers, Sentence-Transformers and Diffusers libraries. Below is a table of Hugging Face managed supported tasks for Inference Endpoint. These tasks don’t require any form of code or <a href="/docs/inference-endpoints/guides/docs/guides/custom_container">“custom container”</a> to deploy an Endpoint.
If you want to customize any of the tasks below, or want to write your own custom task, check out the <a href="/docs/inference-endpoints/guides/custom_handler">“Create your own inference handler”</a> section for more information.`,vt,w,Ma="<thead><tr><th>Task</th> <th>Framework</th> <th>Out of the box Support</th></tr></thead> <tbody><tr><td>Text To Image</td> <td>Diffusers</td> <td>✅</td></tr> <tr><td>Text Classification</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Zero Shot Classification</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Token Classifiation</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Question Answering</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Fill Mask</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Summarization</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Translation</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Text to Text Generation</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Text Generation</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Feature Extraction</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Sentence Embeddings</td> <td>Sentence Transformers</td> <td>✅</td></tr> <tr><td>Sentence similarity</td> <td>Sentence Transformers</td> <td>✅</td></tr> <tr><td>Ranking</td> <td>Sentence Transformers</td> <td>✅</td></tr> <tr><td>Image Classification</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Automatic Speech Recognition</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Audio Classification</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Object Detection</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Image Segmentation</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Table Question Answering</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Conversational</td> <td>Transformers</td> <td>✅</td></tr> <tr><td>Custom</td> <td>Custom</td> <td>✅</td></tr> <tr><td>Visual Question Answering</td> <td>Transformers</td> <td>❌</td></tr> <tr><td>Zero Shot Image Classification</td> <td>Transformers</td> <td>❌</td></tr></tbody>",xt,I,Xt,U,oa="See the following request examples for some of the tasks:",Yt,$,zt,f,Ft,B,Lt,g,Dt,b,_t,W,Pt,C,Ot,q,Kt,A,ts,G,ss,k,as,Q,ns,S,ls,Z,es,E,ps,N,is,H,us,V,Ms,R,os,v,Ts,x,rs,X,cs,Y,Js,z,ds,F,js,L,ys,D,ms,_,hs,P,ws,O,Ta="Image Classification can receive <code>json</code> payloads or binary data from a <code>image</code> directly.",Is,K,ra="<strong>JSON</strong>",Us,tt,$s,st,ca="<strong>Binary</strong>",fs,at,Bs,nt,gs,lt,Ja="Automatic Speech Recognition can receive <code>json</code> payloads or binary data from a <code>audio</code> directly.",bs,et,da="<strong>JSON</strong>",Ws,pt,Cs,it,ja="<strong>Binary</strong>",qs,ut,As,Mt,Gs,ot,ya="Audio Classification can receive <code>json</code> payloads or binary data from a <code>audio</code> directly.",ks,Tt,ma="<strong>JSON</strong>",Qs,rt,Ss,ct,ha="<strong>Binary</strong>",Zs,Jt,Es,dt,Ns,jt,wa="Object Detection can receive <code>json</code> payloads or binary data from a <code>image</code> directly.",Hs,yt,Ia="<strong>JSON</strong>",Vs,mt,Rs,ht,Ua="<strong>Binary</strong>",vs,wt,xs,It,Xs,Ut,$a="Image Segmentation can receive <code>json</code> payloads or binary data from a <code>image</code> directly.",Ys,$t,fa="<strong>JSON</strong>",zs,ft,Fs,Bt,Ba="<strong>Binary</strong>",Ls,gt,Ds,bt,_s,Wt,Ps,Ct,Os,qt,Ks,At,ta,Gt,sa,kt,aa,Qt,ga="You can add additional parameters, which are supported by the <code>pipelines</code> api from transformers.",na,St,ba="For Example if you have a <code>text-generation</code> pipeline you can provide <code>generation_kwargs</code> for <code>repetition_penalty</code> or <code>max_length</code>",la,Zt,ea,Nt,pa;return m=new c({props:{title:"Supported Transformers & Diffusers Tasks",local:"supported-transformers--diffusers-tasks",headingTag:"h1"}}),I=new c({props:{title:"Example Request payloads",local:"example-request-payloads",headingTag:"h2"}}),$=new c({props:{title:"Custom Handler",local:"custom-handler",headingTag:"h3"}}),f=new r({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMGlzJTIwYSUyMHNhbXBsZSUyMGlucHV0JTIyJTJDJTBBJTIwJTIwJTIybW9yZURhdGElMjIlM0ElMjAxJTJDJTBBJTIwJTIwJTIyY3VzdG9tVGFzayUyMiUzQSUyMHRydWUlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This is a sample input&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;moreData&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;customTask&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),B=new c({props:{title:"Text Classification",local:"text-classification",headingTag:"h3"}}),g=new r({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzZW5lcnklMjBpbiUyMHlvdXIlMjBtaW5kJTIwc28lMjB3ZWxsJTIwSSUyMHdvdWxkJTIwcmVjb21lbmQlMjBpdCUwQSUyMCUyMGV2ZW4lMjB0byUyMHBlb3BsZSUyMHdobyUyMGhhdGUlMjB2aWQuJTIwZ2FtZSUyMG11c2ljISUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the senery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),b=new c({props:{title:"Zero Shot Classification",local:"zero-shot-classification",headingTag:"h3"}}),W=new r({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIySGklMkMlMjBJJTIwcmVjZW50bHklMjBib3VnaHQlMjBhJTIwZGV2aWNlJTIwZnJvbSUyMHlvdXIlMjBjb21wYW55JTIwYnV0JTIwaXQlMjBpcyUyMG5vdCUyMHdvcmtpbmclMjBhcyUyMGFkdmVydGlzZWQlMjBhbmQlMjBJJTIwd291bGQlMjBsaWtlJTIwdG8lMjBnZXQlMjByZWltYnVyc2VkISUyMiUyQyUwQSUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJjYW5kaWRhdGVfbGFiZWxzJTIyJTNBJTIwJTVCJTIycmVmdW5kJTIyJTJDJTIwJTIybGVnYWwlMjIlMkMlMjAlMjJmYXElMjIlNUQlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;candidate_labels&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;refund&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;legal&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;faq&quot;</span><span class="hljs-punctuation">]</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),C=new c({props:{title:"Token Classifiation",local:"token-classifiation",headingTag:"h3"}}),q=new r({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzZW5lcnklMjBpbiUyMHlvdXIlMjBtaW5kJTIwc28lMjB3ZWxsJTIwSSUyMHdvdWxkJTIwcmVjb21lbmQlMjBpdCUwQSUyMCUyMGV2ZW4lMjB0byUyMHBlb3BsZSUyMHdobyUyMGhhdGUlMjB2aWQuJTIwZ2FtZSUyMG11c2ljISUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the senery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),A=new c({props:{title:"Question Answering",local:"question-answering",headingTag:"h3"}}),G=new r({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycXVlc3Rpb24lMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB1c2VkJTIwZm9yJTIwaW5mZXJlbmNlJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29udGV4dCUyMiUzQSUyMCUyMk15JTIwTmFtZSUyMGlzJTIwUGhpbGlwcCUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBOdXJlbWJlcmcuJTIwVGhpcyUyMG1vZGVsJTIwaXMlMjB1c2VkJTIwd2l0aCUyMHNhZ2VtYWtlciUyMGZvciUyMGluZmVyZW5jZS4lMjIlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;question&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What is used for inference?&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;context&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;My Name is Philipp and I live in Nuremberg. This model is used with sagemaker for inference.&quot;</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),k=new c({props:{title:"Fill Mask",local:"fill-mask",headingTag:"h3"}}),Q=new r({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjAlM0NtYXNrJTNFISUyMEl0JTIwcGFpbnRzJTIwdGhlJTIwc2VuZXJ5JTIwaW4lMjB5b3VyJTIwbWluZCUyMHNvJTIwd2VsbCUyMEklMjB3b3VsZCUyMHJlY29tZW5kJTIwaXQlMEElMjAlMjBldmVuJTIwdG8lMjBwZW9wbGUlMjB3aG8lMjBoYXRlJTIwdmlkLiUyMGdhbWUlMjBtdXNpYyElMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was &lt;mask&gt;! It paints the senery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),S=new c({props:{title:"Summarization",local:"summarization",headingTag:"h3"}}),Z=new r({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzZW5lcnklMjBpbiUyMHlvdXIlMjBtaW5kJTIwc28lMjB3ZWxsJTIwSSUyMHdvdWxkJTIwcmVjb21lbmQlMjBpdCUwQSUyMCUyMGV2ZW4lMjB0byUyMHBlb3BsZSUyMHdobyUyMGhhdGUlMjB2aWQuJTIwZ2FtZSUyMG11c2ljISUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the senery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),E=new c({props:{title:"Translation",local:"translation",headingTag:"h3"}}),N=new r({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzZW5lcnklMjBpbiUyMHlvdXIlMjBtaW5kJTIwc28lMjB3ZWxsJTIwSSUyMHdvdWxkJTIwcmVjb21lbmQlMjBpdCUwQSUyMCUyMGV2ZW4lMjB0byUyMHBlb3BsZSUyMHdobyUyMGhhdGUlMjB2aWQuJTIwZ2FtZSUyMG11c2ljISUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the senery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),H=new c({props:{title:"Text to Text Generation",local:"text-to-text-generation",headingTag:"h3"}}),V=new r({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzZW5lcnklMjBpbiUyMHlvdXIlMjBtaW5kJTIwc28lMjB3ZWxsJTIwSSUyMHdvdWxkJTIwcmVjb21lbmQlMjBpdCUwQSUyMCUyMGV2ZW4lMjB0byUyMHBlb3BsZSUyMHdobyUyMGhhdGUlMjB2aWQuJTIwZ2FtZSUyMG11c2ljISUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the senery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),R=new c({props:{title:"Text Generation",local:"text-generation",headingTag:"h3"}}),v=new r({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzZW5lcnklMjBpbiUyMHlvdXIlMjBtaW5kJTIwc28lMjB3ZWxsJTIwSSUyMHdvdWxkJTIwcmVjb21lbmQlMjBpdCUwQSUyMCUyMGV2ZW4lMjB0byUyMHBlb3BsZSUyMHdobyUyMGhhdGUlMjB2aWQuJTIwZ2FtZSUyMG11c2ljISUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the senery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),x=new c({props:{title:"Feature Extraction",local:"feature-extraction",headingTag:"h3"}}),X=new r({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzZW5lcnklMjBpbiUyMHlvdXIlMjBtaW5kJTIwc28lMjB3ZWxsJTIwSSUyMHdvdWxkJTIwcmVjb21lbmQlMjBpdCUwQSUyMCUyMGV2ZW4lMjB0byUyMHBlb3BsZSUyMHdobyUyMGhhdGUlMjB2aWQuJTIwZ2FtZSUyMG11c2ljISUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the senery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Y=new c({props:{title:"Sentence Embeddings",local:"sentence-embeddings",headingTag:"h3"}}),z=new r({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzZW5lcnklMjBpbiUyMHlvdXIlMjBtaW5kJTIwc28lMjB3ZWxsJTIwSSUyMHdvdWxkJTIwcmVjb21lbmQlMjBpdCUwQSUyMCUyMGV2ZW4lMjB0byUyMHBlb3BsZSUyMHdobyUyMGhhdGUlMjB2aWQuJTIwZ2FtZSUyMG11c2ljISUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;This sound track was beautiful! It paints the senery in your mind so well I would recomend it
  even to people who hate vid. game music!&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),F=new c({props:{title:"Sentence similarity",local:"sentence-similarity",headingTag:"h3"}}),L=new r({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTVCJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIyJTJDJTIwJTIySXQlMjBwYWludHMlMjB0aGUlMjBzZW5lcnklMjBpbiUyMHlvdXIlMjBtaW5kJTIwc28lMjB3ZWxsJTIyJTVEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;This sound track was beautiful!&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;It paints the senery in your mind so well&quot;</span><span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),D=new c({props:{title:"Ranking",local:"ranking",headingTag:"h3"}}),_=new r({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTVCJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIyJTJDJTIwJTIySXQlMjBwYWludHMlMjB0aGUlMjBzZW5lcnklMjBpbiUyMHlvdXIlMjBtaW5kJTIwc28lMjB3ZWxsJTIyJTVEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;This sound track was beautiful!&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;It paints the senery in your mind so well&quot;</span><span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),P=new c({props:{title:"Image Classification",local:"image-classification",headingTag:"h3"}}),tt=new r({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyJTJGOWolMkY0QUFRU2taSlJnQUJBUUVCTEFFc0FBRCUyRjJ3QkRBQU1DQWdJJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/9j/4AAQSkZJRgABAQEBLAEsAAD/2wBDAAMCAgI&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),at=new r({props:{code:"Y3VybCUyMC0tcmVxdWVzdCUyMFBPU1QlMjAlNUMlMEElMjAlMjAtLXVybCUyMGh0dHBzJTNBJTJGJTJGJTdCRU5EUE9JTlQlN0QlMkYlMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdDb250ZW50LVR5cGUlM0ElMjBpbWFnZSUyRmpwZyclMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdBdXRob3JpemF0aW9uJTNBJTIwQmVhcmVyJTIwJTdCSEZfVE9LRU4lN0QnJTIwJTVDJTBBJTIwJTIwLS1kYXRhLWJpbmFyeSUyMCclNDB0ZXN0LmpwZyc=",highlighted:`curl --request POST \\
  --url https://{ENDPOINT}/ \\
  --header <span class="hljs-string">&#x27;Content-Type: image/jpg&#x27;</span> \\
  --header <span class="hljs-string">&#x27;Authorization: Bearer {HF_TOKEN}&#x27;</span> \\
  --data-binary <span class="hljs-string">&#x27;@test.jpg&#x27;</span>`,wrap:!1}}),nt=new c({props:{title:"Automatic Speech Recognition",local:"automatic-speech-recognition",headingTag:"h3"}}),pt=new r({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyJTJGOWolMkY0QUFRU2taSlJnQUJBUUVCTEFFc0FBRCUyRjJ3QkRBQU1DQWdJJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/9j/4AAQSkZJRgABAQEBLAEsAAD/2wBDAAMCAgI&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ut=new r({props:{code:"Y3VybCUyMC0tcmVxdWVzdCUyMFBPU1QlMjAlNUMlMEElMjAlMjAtLXVybCUyMGh0dHBzJTNBJTJGJTJGJTdCRU5EUE9JTlQlN0QlMkYlMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdDb250ZW50LVR5cGUlM0ElMjBhdWRpbyUyRngtZmxhYyclMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdBdXRob3JpemF0aW9uJTNBJTIwQmVhcmVyJTIwJTdCSEZfVE9LRU4lN0QnJTIwJTVDJTBBJTIwJTIwLS1kYXRhLWJpbmFyeSUyMCclNDBzYW1wbGUuZmxhYyc=",highlighted:`curl --request POST \\
  --url https://{ENDPOINT}/ \\
  --header <span class="hljs-string">&#x27;Content-Type: audio/x-flac&#x27;</span> \\
  --header <span class="hljs-string">&#x27;Authorization: Bearer {HF_TOKEN}&#x27;</span> \\
  --data-binary <span class="hljs-string">&#x27;@sample.flac&#x27;</span>`,wrap:!1}}),Mt=new c({props:{title:"Audio Classification",local:"audio-classification",headingTag:"h3"}}),rt=new r({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyJTJGOWolMkY0QUFRU2taSlJnQUJBUUVCTEFFc0FBRCUyRjJ3QkRBQU1DQWdJJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/9j/4AAQSkZJRgABAQEBLAEsAAD/2wBDAAMCAgI&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Jt=new r({props:{code:"Y3VybCUyMC0tcmVxdWVzdCUyMFBPU1QlMjAlNUMlMEElMjAlMjAtLXVybCUyMGh0dHBzJTNBJTJGJTJGJTdCRU5EUE9JTlQlN0QlMkYlMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdDb250ZW50LVR5cGUlM0ElMjBhdWRpbyUyRngtZmxhYyclMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdBdXRob3JpemF0aW9uJTNBJTIwQmVhcmVyJTIwJTdCSEZfVE9LRU4lN0QnJTIwJTVDJTBBJTIwJTIwLS1kYXRhLWJpbmFyeSUyMCclNDBzYW1wbGUuZmxhYyc=",highlighted:`curl --request POST \\
  --url https://{ENDPOINT}/ \\
  --header <span class="hljs-string">&#x27;Content-Type: audio/x-flac&#x27;</span> \\
  --header <span class="hljs-string">&#x27;Authorization: Bearer {HF_TOKEN}&#x27;</span> \\
  --data-binary <span class="hljs-string">&#x27;@sample.flac&#x27;</span>`,wrap:!1}}),dt=new c({props:{title:"Object Detection",local:"object-detection",headingTag:"h3"}}),mt=new r({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyJTJGOWolMkY0QUFRU2taSlJnQUJBUUVCTEFFc0FBRCUyRjJ3QkRBQU1DQWdJJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/9j/4AAQSkZJRgABAQEBLAEsAAD/2wBDAAMCAgI&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),wt=new r({props:{code:"Y3VybCUyMC0tcmVxdWVzdCUyMFBPU1QlMjAlNUMlMEElMjAlMjAtLXVybCUyMGh0dHBzJTNBJTJGJTJGJTdCRU5EUE9JTlQlN0QlMkYlMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdDb250ZW50LVR5cGUlM0ElMjBpbWFnZSUyRmpwZyclMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdBdXRob3JpemF0aW9uJTNBJTIwQmVhcmVyJTIwJTdCSEZfVE9LRU4lN0QnJTIwJTVDJTBBJTIwJTIwLS1kYXRhLWJpbmFyeSUyMCclNDB0ZXN0LmpwZyc=",highlighted:`curl --request POST \\
  --url https://{ENDPOINT}/ \\
  --header <span class="hljs-string">&#x27;Content-Type: image/jpg&#x27;</span> \\
  --header <span class="hljs-string">&#x27;Authorization: Bearer {HF_TOKEN}&#x27;</span> \\
  --data-binary <span class="hljs-string">&#x27;@test.jpg&#x27;</span>`,wrap:!1}}),It=new c({props:{title:"Image Segmentation",local:"image-segmentation",headingTag:"h3"}}),ft=new r({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyJTJGOWolMkY0QUFRU2taSlJnQUJBUUVCTEFFc0FBRCUyRjJ3QkRBQU1DQWdJJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/9j/4AAQSkZJRgABAQEBLAEsAAD/2wBDAAMCAgI&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),gt=new r({props:{code:"Y3VybCUyMC0tcmVxdWVzdCUyMFBPU1QlMjAlNUMlMEElMjAlMjAtLXVybCUyMGh0dHBzJTNBJTJGJTJGJTdCRU5EUE9JTlQlN0QlMkYlMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdDb250ZW50LVR5cGUlM0ElMjBpbWFnZSUyRmpwZyclMjAlNUMlMEElMjAlMjAtLWhlYWRlciUyMCdBdXRob3JpemF0aW9uJTNBJTIwQmVhcmVyJTIwJTdCSEZfVE9LRU4lN0QnJTIwJTVDJTBBJTIwJTIwLS1kYXRhLWJpbmFyeSUyMCclNDB0ZXN0LmpwZyc=",highlighted:`curl --request POST \\
  --url https://{ENDPOINT}/ \\
  --header <span class="hljs-string">&#x27;Content-Type: image/jpg&#x27;</span> \\
  --header <span class="hljs-string">&#x27;Authorization: Bearer {HF_TOKEN}&#x27;</span> \\
  --data-binary <span class="hljs-string">&#x27;@test.jpg&#x27;</span>`,wrap:!1}}),bt=new c({props:{title:"Table Question Answering",local:"table-question-answering",headingTag:"h3"}}),Wt=new r({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycXVlcnklMjIlM0ElMjAlMjJIb3clMjBtYW55JTIwc3RhcnMlMjBkb2VzJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwcmVwb3NpdG9yeSUyMGhhdmUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0YWJsZSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMlJlcG9zaXRvcnklMjIlM0ElMjAlNUIlMjJUcmFuc2Zvcm1lcnMlMjIlMkMlMjAlMjJEYXRhc2V0cyUyMiUyQyUyMCUyMlRva2VuaXplcnMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJTdGFycyUyMiUzQSUyMCU1QiUyMjM2NTQyJTIyJTJDJTIwJTIyNDUxMiUyMiUyQyUyMCUyMjM5MzQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJDb250cmlidXRvcnMlMjIlM0ElMjAlNUIlMjI2NTElMjIlMkMlMjAlMjI3NyUyMiUyQyUyMCUyMjM0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyUHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUyMiUzQSUyMCU1QiUyMlB5dGhvbiUyMiUyQyUyMCUyMlB5dGhvbiUyMiUyQyUyMCUyMlJ1c3QlMkMlMjBQeXRob24lMjBhbmQlMjBOb2RlSlMlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;query&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;table&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;Repository&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;Transformers&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;Datasets&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;Tokenizers&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;Stars&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;36542&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;4512&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;3934&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;Contributors&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;651&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;77&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;34&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;Programming language&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;Python&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;Python&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;Rust, Python and NodeJS&quot;</span><span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ct=new c({props:{title:"Conversational",local:"conversational",headingTag:"h3"}}),qt=new r({props:{code:"JTdCJTIyaW5wdXRzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBtb3ZpZSUyMGlzJTIwdGhlJTIwYmVzdCUyMCUzRiUyMiUwQSUyMCUyMCU3RCUyQyUwQSUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQncyUyMERpZSUyMEhhcmQlMjBmb3IlMjBzdXJlLiUyMiUwQSUyMCUyMCU3RCUyQyUwQSUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkNhbiUyMHlvdSUyMGV4cGxhaW4lMjB3aHklM0YlMjIlMEElMjAlMjAlN0QlMEElNUQlN0Q=",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
  <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Which movie is the best ?&quot;</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;It&#x27;s Die Hard for sure.&quot;</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Can you explain why?&quot;</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),At=new c({props:{title:"Text To Image",local:"text-to-image",headingTag:"h3"}}),Gt=new r({props:{code:"JTdCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIycmVhbGlzdGljJTIwcmVuZGVyJTIwcG9ydHJhaXQlMjByZWFsaXN0aWMlMjByZW5kZXIlMjBwb3J0cmFpdCUyMG9mJTIwZ3JvdXAlMjBvZiUyMGZseWluZyUyMGJsdWUlMjB3aGFsZXMlMjB0b3dhcmRzJTIwdGhlJTIwbW9vbiUyQyUyMGludHJpY2F0ZSUyQyUyMHRveSUyQyUyMHNjaSUyMC0lMjBmaSUyQyUyMGV4dHJlbWVseSUyMGRldGFpbGVkJTJDJTIwZGlnaXRhbCUyMHBhaW50aW5nJTJDJTIwc2N1bHB0ZWQlMjBpbiUyMHpicnVzaCUyQyUyMGFydHN0YXRpb24lMkMlMjBjb25jZXB0JTIwYXJ0JTJDJTIwc21vb3RoJTJDJTIwc2hhcnAlMjBmb2N1cyUyQyUyMGlsbHVzdHJhdGlvbiUyQyUyMGNoaWFyb3NjdXJvJTIwbGlnaHRpbmclMkMlMjBnb2xkZW4lMjByYXRpbyUyQyUyMGluY3JlZGlibGUlMjBhcnQlMjBieSUyMGFydGdlcm0lMjBhbmQlMjBncmVnJTIwcnV0a293c2tpJTIwYW5kJTIwYWxwaG9uc2UlMjBtdWNoYSUyMGFuZCUyMHNpbW9uJTIwc3RhbGVuaGFnJTIyJTJDJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>        
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;realistic render portrait realistic render portrait of group of flying blue whales towards the moon, intricate, toy, sci - fi, extremely detailed, digital painting, sculpted in zbrush, artstation, concept art, smooth, sharp focus, illustration, chiaroscuro lighting, golden ratio, incredible art by artgerm and greg rutkowski and alphonse mucha and simon stalenhag&quot;</span><span class="hljs-punctuation">,</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),kt=new c({props:{title:"Additional parameters",local:"additional-parameters",headingTag:"h3"}}),Zt=new r({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIySHVnZ2luZyUyMEZhY2UlMkMlMjB0aGUlMjB3aW5uZXIlMjBvZiUyMFZlbnR1cmVCZWF0JUUyJTgwJTk5cyUyMElubm92YXRpb24lMjBpbiUyME5hdHVyYWwlMjBMYW5ndWFnZSUyMFByb2Nlc3MlMkZVbmRlcnN0YW5kaW5nJTIwQXdhcmQlMjBmb3IlMjAyMDIxJTJDJTIwaXMlMjBsb29raW5nJTIwdG8lMjBsZXZlbCUyMHRoZSUyMHBsYXlpbmclMjBmaWVsZC4lMjBUaGUlMjB0ZWFtJTJDJTIwbGF1bmNoZWQlMjBieSUyMENsJUMzJUE5bWVudCUyMERlbGFuZ3VlJTIwYW5kJTIwSnVsaWVuJTIwQ2hhdW1vbmQlMjBpbiUyMDIwMTYlMkMlMjB3YXMlMjByZWNvZ25pemVkJTIwZm9yJTIwaXRzJTIwd29yayUyMGluJTIwZGVtb2NyYXRpemluZyUyME5MUCUyQyUyMHRoZSUyMGdsb2JhbCUyMG1hcmtldCUyMHZhbHVlJTIwZm9yJTIwd2hpY2glMjBpcyUyMGV4cGVjdGVkJTIwdG8lMjBoaXQlMjAlMjQzNS4xJTIwYmlsbGlvbiUyMGJ5JTIwMjAyNi4lMjBUaGlzJTIwd2VlayUyQyUyMEdvb2dsZSVFMiU4MCU5OXMlMjBmb3JtZXIlMjBoZWFkJTIwb2YlMjBFdGhpY2FsJTIwQUklMjBNYXJnYXJldCUyME1pdGNoZWxsJTIwam9pbmVkJTIwdGhlJTIwdGVhbS4lMjIlMkMlMEElMjAlMjAlMjJwYXJhbWV0ZXJzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycmVwZXRpdGlvbl9wZW5hbHR5JTIyJTNBJTIwNC4wJTJDJTBBJTIwJTIwJTIwJTIwJTIybWF4X2xlbmd0aCUyMiUzQSUyMDEyOCUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Hugging Face, the winner of VentureBeat’s Innovation in Natural Language Process/Understanding Award for 2021, is looking to level the playing field. The team, launched by Clément Delangue and Julien Chaumond in 2016, was recognized for its work in democratizing NLP, the global market value for which is expected to hit $35.1 billion by 2026. This week, Google’s former head of Ethical AI Margaret Mitchell joined the team.&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;repetition_penalty&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">4.0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;max_length&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">128</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),{c(){y=J("meta"),Ht=l(),Et=J("p"),Vt=l(),p(m.$$.fragment),Rt=l(),h=J("p"),h.innerHTML=ua,vt=l(),w=J("table"),w.innerHTML=Ma,xt=l(),p(I.$$.fragment),Xt=l(),U=J("p"),U.textContent=oa,Yt=l(),p($.$$.fragment),zt=l(),p(f.$$.fragment),Ft=l(),p(B.$$.fragment),Lt=l(),p(g.$$.fragment),Dt=l(),p(b.$$.fragment),_t=l(),p(W.$$.fragment),Pt=l(),p(C.$$.fragment),Ot=l(),p(q.$$.fragment),Kt=l(),p(A.$$.fragment),ts=l(),p(G.$$.fragment),ss=l(),p(k.$$.fragment),as=l(),p(Q.$$.fragment),ns=l(),p(S.$$.fragment),ls=l(),p(Z.$$.fragment),es=l(),p(E.$$.fragment),ps=l(),p(N.$$.fragment),is=l(),p(H.$$.fragment),us=l(),p(V.$$.fragment),Ms=l(),p(R.$$.fragment),os=l(),p(v.$$.fragment),Ts=l(),p(x.$$.fragment),rs=l(),p(X.$$.fragment),cs=l(),p(Y.$$.fragment),Js=l(),p(z.$$.fragment),ds=l(),p(F.$$.fragment),js=l(),p(L.$$.fragment),ys=l(),p(D.$$.fragment),ms=l(),p(_.$$.fragment),hs=l(),p(P.$$.fragment),ws=l(),O=J("p"),O.innerHTML=Ta,Is=l(),K=J("p"),K.innerHTML=ra,Us=l(),p(tt.$$.fragment),$s=l(),st=J("p"),st.innerHTML=ca,fs=l(),p(at.$$.fragment),Bs=l(),p(nt.$$.fragment),gs=l(),lt=J("p"),lt.innerHTML=Ja,bs=l(),et=J("p"),et.innerHTML=da,Ws=l(),p(pt.$$.fragment),Cs=l(),it=J("p"),it.innerHTML=ja,qs=l(),p(ut.$$.fragment),As=l(),p(Mt.$$.fragment),Gs=l(),ot=J("p"),ot.innerHTML=ya,ks=l(),Tt=J("p"),Tt.innerHTML=ma,Qs=l(),p(rt.$$.fragment),Ss=l(),ct=J("p"),ct.innerHTML=ha,Zs=l(),p(Jt.$$.fragment),Es=l(),p(dt.$$.fragment),Ns=l(),jt=J("p"),jt.innerHTML=wa,Hs=l(),yt=J("p"),yt.innerHTML=Ia,Vs=l(),p(mt.$$.fragment),Rs=l(),ht=J("p"),ht.innerHTML=Ua,vs=l(),p(wt.$$.fragment),xs=l(),p(It.$$.fragment),Xs=l(),Ut=J("p"),Ut.innerHTML=$a,Ys=l(),$t=J("p"),$t.innerHTML=fa,zs=l(),p(ft.$$.fragment),Fs=l(),Bt=J("p"),Bt.innerHTML=Ba,Ls=l(),p(gt.$$.fragment),Ds=l(),p(bt.$$.fragment),_s=l(),p(Wt.$$.fragment),Ps=l(),p(Ct.$$.fragment),Os=l(),p(qt.$$.fragment),Ks=l(),p(At.$$.fragment),ta=l(),p(Gt.$$.fragment),sa=l(),p(kt.$$.fragment),aa=l(),Qt=J("p"),Qt.innerHTML=ga,na=l(),St=J("p"),St.innerHTML=ba,la=l(),p(Zt.$$.fragment),ea=l(),Nt=J("p"),this.h()},l(t){const s=Sa("svelte-u9bgzb",document.head);y=d(s,"META",{name:!0,content:!0}),s.forEach(a),Ht=e(t),Et=d(t,"P",{}),Wa(Et).forEach(a),Vt=e(t),i(m.$$.fragment,t),Rt=e(t),h=d(t,"P",{"data-svelte-h":!0}),j(h)!=="svelte-5da42z"&&(h.innerHTML=ua),vt=e(t),w=d(t,"TABLE",{"data-svelte-h":!0}),j(w)!=="svelte-hg5euz"&&(w.innerHTML=Ma),xt=e(t),i(I.$$.fragment,t),Xt=e(t),U=d(t,"P",{"data-svelte-h":!0}),j(U)!=="svelte-fqnqo8"&&(U.textContent=oa),Yt=e(t),i($.$$.fragment,t),zt=e(t),i(f.$$.fragment,t),Ft=e(t),i(B.$$.fragment,t),Lt=e(t),i(g.$$.fragment,t),Dt=e(t),i(b.$$.fragment,t),_t=e(t),i(W.$$.fragment,t),Pt=e(t),i(C.$$.fragment,t),Ot=e(t),i(q.$$.fragment,t),Kt=e(t),i(A.$$.fragment,t),ts=e(t),i(G.$$.fragment,t),ss=e(t),i(k.$$.fragment,t),as=e(t),i(Q.$$.fragment,t),ns=e(t),i(S.$$.fragment,t),ls=e(t),i(Z.$$.fragment,t),es=e(t),i(E.$$.fragment,t),ps=e(t),i(N.$$.fragment,t),is=e(t),i(H.$$.fragment,t),us=e(t),i(V.$$.fragment,t),Ms=e(t),i(R.$$.fragment,t),os=e(t),i(v.$$.fragment,t),Ts=e(t),i(x.$$.fragment,t),rs=e(t),i(X.$$.fragment,t),cs=e(t),i(Y.$$.fragment,t),Js=e(t),i(z.$$.fragment,t),ds=e(t),i(F.$$.fragment,t),js=e(t),i(L.$$.fragment,t),ys=e(t),i(D.$$.fragment,t),ms=e(t),i(_.$$.fragment,t),hs=e(t),i(P.$$.fragment,t),ws=e(t),O=d(t,"P",{"data-svelte-h":!0}),j(O)!=="svelte-14yog2z"&&(O.innerHTML=Ta),Is=e(t),K=d(t,"P",{"data-svelte-h":!0}),j(K)!=="svelte-1r1eo5z"&&(K.innerHTML=ra),Us=e(t),i(tt.$$.fragment,t),$s=e(t),st=d(t,"P",{"data-svelte-h":!0}),j(st)!=="svelte-1n8meou"&&(st.innerHTML=ca),fs=e(t),i(at.$$.fragment,t),Bs=e(t),i(nt.$$.fragment,t),gs=e(t),lt=d(t,"P",{"data-svelte-h":!0}),j(lt)!=="svelte-54to2d"&&(lt.innerHTML=Ja),bs=e(t),et=d(t,"P",{"data-svelte-h":!0}),j(et)!=="svelte-1r1eo5z"&&(et.innerHTML=da),Ws=e(t),i(pt.$$.fragment,t),Cs=e(t),it=d(t,"P",{"data-svelte-h":!0}),j(it)!=="svelte-1n8meou"&&(it.innerHTML=ja),qs=e(t),i(ut.$$.fragment,t),As=e(t),i(Mt.$$.fragment,t),Gs=e(t),ot=d(t,"P",{"data-svelte-h":!0}),j(ot)!=="svelte-od4k9j"&&(ot.innerHTML=ya),ks=e(t),Tt=d(t,"P",{"data-svelte-h":!0}),j(Tt)!=="svelte-1r1eo5z"&&(Tt.innerHTML=ma),Qs=e(t),i(rt.$$.fragment,t),Ss=e(t),ct=d(t,"P",{"data-svelte-h":!0}),j(ct)!=="svelte-1n8meou"&&(ct.innerHTML=ha),Zs=e(t),i(Jt.$$.fragment,t),Es=e(t),i(dt.$$.fragment,t),Ns=e(t),jt=d(t,"P",{"data-svelte-h":!0}),j(jt)!=="svelte-exmdnu"&&(jt.innerHTML=wa),Hs=e(t),yt=d(t,"P",{"data-svelte-h":!0}),j(yt)!=="svelte-1r1eo5z"&&(yt.innerHTML=Ia),Vs=e(t),i(mt.$$.fragment,t),Rs=e(t),ht=d(t,"P",{"data-svelte-h":!0}),j(ht)!=="svelte-1n8meou"&&(ht.innerHTML=Ua),vs=e(t),i(wt.$$.fragment,t),xs=e(t),i(It.$$.fragment,t),Xs=e(t),Ut=d(t,"P",{"data-svelte-h":!0}),j(Ut)!=="svelte-1u7uxpp"&&(Ut.innerHTML=$a),Ys=e(t),$t=d(t,"P",{"data-svelte-h":!0}),j($t)!=="svelte-1r1eo5z"&&($t.innerHTML=fa),zs=e(t),i(ft.$$.fragment,t),Fs=e(t),Bt=d(t,"P",{"data-svelte-h":!0}),j(Bt)!=="svelte-1n8meou"&&(Bt.innerHTML=Ba),Ls=e(t),i(gt.$$.fragment,t),Ds=e(t),i(bt.$$.fragment,t),_s=e(t),i(Wt.$$.fragment,t),Ps=e(t),i(Ct.$$.fragment,t),Os=e(t),i(qt.$$.fragment,t),Ks=e(t),i(At.$$.fragment,t),ta=e(t),i(Gt.$$.fragment,t),sa=e(t),i(kt.$$.fragment,t),aa=e(t),Qt=d(t,"P",{"data-svelte-h":!0}),j(Qt)!=="svelte-rzvc6s"&&(Qt.innerHTML=ga),na=e(t),St=d(t,"P",{"data-svelte-h":!0}),j(St)!=="svelte-194vab0"&&(St.innerHTML=ba),la=e(t),i(Zt.$$.fragment,t),ea=e(t),Nt=d(t,"P",{}),Wa(Nt).forEach(a),this.h()},h(){Ca(y,"name","hf:doc:metadata"),Ca(y,"content",Na)},m(t,s){Za(document.head,y),n(t,Ht,s),n(t,Et,s),n(t,Vt,s),u(m,t,s),n(t,Rt,s),n(t,h,s),n(t,vt,s),n(t,w,s),n(t,xt,s),u(I,t,s),n(t,Xt,s),n(t,U,s),n(t,Yt,s),u($,t,s),n(t,zt,s),u(f,t,s),n(t,Ft,s),u(B,t,s),n(t,Lt,s),u(g,t,s),n(t,Dt,s),u(b,t,s),n(t,_t,s),u(W,t,s),n(t,Pt,s),u(C,t,s),n(t,Ot,s),u(q,t,s),n(t,Kt,s),u(A,t,s),n(t,ts,s),u(G,t,s),n(t,ss,s),u(k,t,s),n(t,as,s),u(Q,t,s),n(t,ns,s),u(S,t,s),n(t,ls,s),u(Z,t,s),n(t,es,s),u(E,t,s),n(t,ps,s),u(N,t,s),n(t,is,s),u(H,t,s),n(t,us,s),u(V,t,s),n(t,Ms,s),u(R,t,s),n(t,os,s),u(v,t,s),n(t,Ts,s),u(x,t,s),n(t,rs,s),u(X,t,s),n(t,cs,s),u(Y,t,s),n(t,Js,s),u(z,t,s),n(t,ds,s),u(F,t,s),n(t,js,s),u(L,t,s),n(t,ys,s),u(D,t,s),n(t,ms,s),u(_,t,s),n(t,hs,s),u(P,t,s),n(t,ws,s),n(t,O,s),n(t,Is,s),n(t,K,s),n(t,Us,s),u(tt,t,s),n(t,$s,s),n(t,st,s),n(t,fs,s),u(at,t,s),n(t,Bs,s),u(nt,t,s),n(t,gs,s),n(t,lt,s),n(t,bs,s),n(t,et,s),n(t,Ws,s),u(pt,t,s),n(t,Cs,s),n(t,it,s),n(t,qs,s),u(ut,t,s),n(t,As,s),u(Mt,t,s),n(t,Gs,s),n(t,ot,s),n(t,ks,s),n(t,Tt,s),n(t,Qs,s),u(rt,t,s),n(t,Ss,s),n(t,ct,s),n(t,Zs,s),u(Jt,t,s),n(t,Es,s),u(dt,t,s),n(t,Ns,s),n(t,jt,s),n(t,Hs,s),n(t,yt,s),n(t,Vs,s),u(mt,t,s),n(t,Rs,s),n(t,ht,s),n(t,vs,s),u(wt,t,s),n(t,xs,s),u(It,t,s),n(t,Xs,s),n(t,Ut,s),n(t,Ys,s),n(t,$t,s),n(t,zs,s),u(ft,t,s),n(t,Fs,s),n(t,Bt,s),n(t,Ls,s),u(gt,t,s),n(t,Ds,s),u(bt,t,s),n(t,_s,s),u(Wt,t,s),n(t,Ps,s),u(Ct,t,s),n(t,Os,s),u(qt,t,s),n(t,Ks,s),u(At,t,s),n(t,ta,s),u(Gt,t,s),n(t,sa,s),u(kt,t,s),n(t,aa,s),n(t,Qt,s),n(t,na,s),n(t,St,s),n(t,la,s),u(Zt,t,s),n(t,ea,s),n(t,Nt,s),pa=!0},p:Aa,i(t){pa||(M(m.$$.fragment,t),M(I.$$.fragment,t),M($.$$.fragment,t),M(f.$$.fragment,t),M(B.$$.fragment,t),M(g.$$.fragment,t),M(b.$$.fragment,t),M(W.$$.fragment,t),M(C.$$.fragment,t),M(q.$$.fragment,t),M(A.$$.fragment,t),M(G.$$.fragment,t),M(k.$$.fragment,t),M(Q.$$.fragment,t),M(S.$$.fragment,t),M(Z.$$.fragment,t),M(E.$$.fragment,t),M(N.$$.fragment,t),M(H.$$.fragment,t),M(V.$$.fragment,t),M(R.$$.fragment,t),M(v.$$.fragment,t),M(x.$$.fragment,t),M(X.$$.fragment,t),M(Y.$$.fragment,t),M(z.$$.fragment,t),M(F.$$.fragment,t),M(L.$$.fragment,t),M(D.$$.fragment,t),M(_.$$.fragment,t),M(P.$$.fragment,t),M(tt.$$.fragment,t),M(at.$$.fragment,t),M(nt.$$.fragment,t),M(pt.$$.fragment,t),M(ut.$$.fragment,t),M(Mt.$$.fragment,t),M(rt.$$.fragment,t),M(Jt.$$.fragment,t),M(dt.$$.fragment,t),M(mt.$$.fragment,t),M(wt.$$.fragment,t),M(It.$$.fragment,t),M(ft.$$.fragment,t),M(gt.$$.fragment,t),M(bt.$$.fragment,t),M(Wt.$$.fragment,t),M(Ct.$$.fragment,t),M(qt.$$.fragment,t),M(At.$$.fragment,t),M(Gt.$$.fragment,t),M(kt.$$.fragment,t),M(Zt.$$.fragment,t),pa=!0)},o(t){o(m.$$.fragment,t),o(I.$$.fragment,t),o($.$$.fragment,t),o(f.$$.fragment,t),o(B.$$.fragment,t),o(g.$$.fragment,t),o(b.$$.fragment,t),o(W.$$.fragment,t),o(C.$$.fragment,t),o(q.$$.fragment,t),o(A.$$.fragment,t),o(G.$$.fragment,t),o(k.$$.fragment,t),o(Q.$$.fragment,t),o(S.$$.fragment,t),o(Z.$$.fragment,t),o(E.$$.fragment,t),o(N.$$.fragment,t),o(H.$$.fragment,t),o(V.$$.fragment,t),o(R.$$.fragment,t),o(v.$$.fragment,t),o(x.$$.fragment,t),o(X.$$.fragment,t),o(Y.$$.fragment,t),o(z.$$.fragment,t),o(F.$$.fragment,t),o(L.$$.fragment,t),o(D.$$.fragment,t),o(_.$$.fragment,t),o(P.$$.fragment,t),o(tt.$$.fragment,t),o(at.$$.fragment,t),o(nt.$$.fragment,t),o(pt.$$.fragment,t),o(ut.$$.fragment,t),o(Mt.$$.fragment,t),o(rt.$$.fragment,t),o(Jt.$$.fragment,t),o(dt.$$.fragment,t),o(mt.$$.fragment,t),o(wt.$$.fragment,t),o(It.$$.fragment,t),o(ft.$$.fragment,t),o(gt.$$.fragment,t),o(bt.$$.fragment,t),o(Wt.$$.fragment,t),o(Ct.$$.fragment,t),o(qt.$$.fragment,t),o(At.$$.fragment,t),o(Gt.$$.fragment,t),o(kt.$$.fragment,t),o(Zt.$$.fragment,t),pa=!1},d(t){t&&(a(Ht),a(Et),a(Vt),a(Rt),a(h),a(vt),a(w),a(xt),a(Xt),a(U),a(Yt),a(zt),a(Ft),a(Lt),a(Dt),a(_t),a(Pt),a(Ot),a(Kt),a(ts),a(ss),a(as),a(ns),a(ls),a(es),a(ps),a(is),a(us),a(Ms),a(os),a(Ts),a(rs),a(cs),a(Js),a(ds),a(js),a(ys),a(ms),a(hs),a(ws),a(O),a(Is),a(K),a(Us),a($s),a(st),a(fs),a(Bs),a(gs),a(lt),a(bs),a(et),a(Ws),a(Cs),a(it),a(qs),a(As),a(Gs),a(ot),a(ks),a(Tt),a(Qs),a(Ss),a(ct),a(Zs),a(Es),a(Ns),a(jt),a(Hs),a(yt),a(Vs),a(Rs),a(ht),a(vs),a(xs),a(Xs),a(Ut),a(Ys),a($t),a(zs),a(Fs),a(Bt),a(Ls),a(Ds),a(_s),a(Ps),a(Os),a(Ks),a(ta),a(sa),a(aa),a(Qt),a(na),a(St),a(la),a(ea),a(Nt)),a(y),T(m,t),T(I,t),T($,t),T(f,t),T(B,t),T(g,t),T(b,t),T(W,t),T(C,t),T(q,t),T(A,t),T(G,t),T(k,t),T(Q,t),T(S,t),T(Z,t),T(E,t),T(N,t),T(H,t),T(V,t),T(R,t),T(v,t),T(x,t),T(X,t),T(Y,t),T(z,t),T(F,t),T(L,t),T(D,t),T(_,t),T(P,t),T(tt,t),T(at,t),T(nt,t),T(pt,t),T(ut,t),T(Mt,t),T(rt,t),T(Jt,t),T(dt,t),T(mt,t),T(wt,t),T(It,t),T(ft,t),T(gt,t),T(bt,t),T(Wt,t),T(Ct,t),T(qt,t),T(At,t),T(Gt,t),T(kt,t),T(Zt,t)}}}const Na='{"title":"Supported Transformers & Diffusers Tasks","local":"supported-transformers--diffusers-tasks","sections":[{"title":"Example Request payloads","local":"example-request-payloads","sections":[{"title":"Custom Handler","local":"custom-handler","sections":[],"depth":3},{"title":"Text Classification","local":"text-classification","sections":[],"depth":3},{"title":"Zero Shot Classification","local":"zero-shot-classification","sections":[],"depth":3},{"title":"Token Classifiation","local":"token-classifiation","sections":[],"depth":3},{"title":"Question Answering","local":"question-answering","sections":[],"depth":3},{"title":"Fill Mask","local":"fill-mask","sections":[],"depth":3},{"title":"Summarization","local":"summarization","sections":[],"depth":3},{"title":"Translation","local":"translation","sections":[],"depth":3},{"title":"Text to Text Generation","local":"text-to-text-generation","sections":[],"depth":3},{"title":"Text Generation","local":"text-generation","sections":[],"depth":3},{"title":"Feature Extraction","local":"feature-extraction","sections":[],"depth":3},{"title":"Sentence Embeddings","local":"sentence-embeddings","sections":[],"depth":3},{"title":"Sentence similarity","local":"sentence-similarity","sections":[],"depth":3},{"title":"Ranking","local":"ranking","sections":[],"depth":3},{"title":"Image Classification","local":"image-classification","sections":[],"depth":3},{"title":"Automatic Speech Recognition","local":"automatic-speech-recognition","sections":[],"depth":3},{"title":"Audio Classification","local":"audio-classification","sections":[],"depth":3},{"title":"Object Detection","local":"object-detection","sections":[],"depth":3},{"title":"Image Segmentation","local":"image-segmentation","sections":[],"depth":3},{"title":"Table Question Answering","local":"table-question-answering","sections":[],"depth":3},{"title":"Conversational","local":"conversational","sections":[],"depth":3},{"title":"Text To Image","local":"text-to-image","sections":[],"depth":3},{"title":"Additional parameters","local":"additional-parameters","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ha(ia){return Ga(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xa extends ka{constructor(y){super(),Qa(this,y,Ha,Ea,qa,{})}}export{Xa as component};
