import{s as Ke,n as Oe,o as tn}from"../chunks/scheduler.9039eef2.js";import{S as en,i as nn,g as i,s as l,r as p,A as an,h as r,f as n,c as s,j as qe,u as c,x as o,k as De,y as ln,a,v as d,d as m,t as M,w as u}from"../chunks/index.cdcc3d35.js";import{C as h}from"../chunks/CodeBlock.e3ac94d9.js";import{H as ut}from"../chunks/Heading.96ce3702.js";function sn(he){let y,ht,mt,yt,w,wt,T,ye='This tutorial will help you to get started with <a href="https://aws.amazon.com/machine-learning/trainium/?nc1=h_ls" rel="nofollow">AWS Trainium</a> and Hugging Face Transformers. It will cover how to set up a Trainium instance on AWS, load &amp; fine-tune a transformers model for text-classification',Tt,f,we="You will learn how to:",ft,U,Te='<li><a href="#1-setup-aws-environment">Setup AWS environment</a></li> <li><a href="#2-load-and-process-the-dataset">Load and process the dataset</a></li> <li><a href="#3-fine-tune-bert-using-hugging-face-transformers">Fine-tune BERT using Hugging Face Transformers and Optimum Neuron</a></li>',Ut,J,fe='Before we can start, make sure you have a <a href="https://huggingface.co/join" rel="nofollow">Hugging Face Account</a> to save artifacts and experiments.',Jt,g,gt,b,Ue='<a href="https://aws.amazon.com/de/ec2/instance-types/trn1/" rel="nofollow">AWS Trainium (Trn1)</a> is a purpose-built EC2 for deep learning (DL) training workloads. Trainium is the successor of <a href="https://aws.amazon.com/ec2/instance-types/inf1/?nc1=h_ls" rel="nofollow">AWS Inferentia</a> focused on high-performance training workloads claiming up to 50% cost-to-train savings over comparable GPU-based instances.',bt,C,Je="Trainium has been optimized for training natural language processing, computer vision, and recommender models used. The accelerator supports a wide range of data types, including FP32, TF32, BF16, FP16, UINT8, and configurable FP8.",Ct,j,ge='The biggest Trainium instance, the <code>trn1.32xlarge</code> comes with over 500GB of memory, making it easy to fine-tune ~10B parameter models on a single instance. Below you will find an overview of the available instance types. More details <a href="https://aws.amazon.com/de/ec2/instance-types/trn1/#Product_details" rel="nofollow">here</a>:',jt,I,be="<thead><tr><th>instance size</th> <th>accelerators</th> <th>accelerator memory</th> <th>vCPU</th> <th>CPU Memory</th> <th>price per hour</th></tr></thead> <tbody><tr><td>trn1.2xlarge</td> <td>1</td> <td>32</td> <td>8</td> <td>32</td> <td>$1.34</td></tr> <tr><td>trn1.32xlarge</td> <td>16</td> <td>512</td> <td>128</td> <td>512</td> <td>$21.50</td></tr> <tr><td>trn1n.32xlarge (2x bandwidth)</td> <td>16</td> <td>512</td> <td>128</td> <td>512</td> <td>$24.78</td></tr></tbody>",It,vt,Wt,v,Ce="Now we know what Trainium offers, let’s get started. 🚀",Gt,W,je="<em>Note: This tutorial was created on a trn1.2xlarge AWS EC2 Instance.</em>",_t,G,Bt,_,Ie='In this example, we will use the <code>trn1.2xlarge</code> instance on AWS with 1 Accelerator, including two Neuron Cores and the <a href="https://aws.amazon.com/marketplace/pp/prodview-gr3e6yiscria2" rel="nofollow">Hugging Face Neuron Deep Learning AMI</a>.',Zt,B,ve='This blog post doesn’t cover how to create the instance in detail. You can check out my previous blog about <a href="https://www.philschmid.de/setup-aws-trainium" rel="nofollow">“Setting up AWS Trainium for Hugging Face Transformers”</a>, which includes a step-by-step guide on setting up the environment.',Ft,Z,We="Once the instance is up and running, we can ssh into it. But instead of developing inside a terminal we want to use a <code>Jupyter</code> environment, which we can use for preparing our dataset and launching the training. For this, we need to add a port for forwarding in the <code>ssh</code> command, which will tunnel our localhost traffic to the Trainium instance.",$t,F,Rt,$,Ge="We can now start our <strong><code>jupyter</code></strong> server.",kt,R,Xt,k,_e="You should see a familiar <strong><code>jupyter</code></strong> output with a URL to the notebook.",xt,X,Be="<strong><code>http://localhost:8080/?token=8c1739aff1755bd7958c4cfccc8d08cb5da5234f61f129a9</code></strong>",Ht,x,Ze="We can click on it, and a <strong><code>jupyter</code></strong> environment opens in our local browser.",zt,H,Fe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/optimum/neuron/tutorial-fine-tune-bert-jupyter.png" alt="jupyter.webp"/>',Qt,z,$e="We are going to use the Jupyter environment only for preparing the dataset and then <code>torchrun</code> for launching our training script on both neuron cores for distributed training. Lets create a new notebook and get started.",Vt,Q,At,V,Re='We are training a Text Classification model on the <a href="https://huggingface.co/datasets/philschmid/emotion" rel="nofollow">emotion</a> dataset to keep the example straightforward. The <code>emotion</code> is a dataset of English Twitter messages with six basic emotions: anger, fear, joy, love, sadness, and surprise.',Yt,A,ke='We will use the <code>load_dataset()</code> method from the <a href="https://huggingface.co/docs/datasets/index" rel="nofollow">🤗 Datasets</a> library to load the <code>emotion</code>.',Nt,Y,Lt,N,Xe="Let’s check out an example of the dataset.",St,L,Et,S,xe='We must convert our “Natural Language” to token IDs to train our model. This is done by a Tokenizer, which tokenizes the inputs (including converting the tokens to their corresponding IDs in the pre-trained vocabulary). if you want to learn more about this, out <a href="https://huggingface.co/course/chapter6/1?fw=pt" rel="nofollow">chapter 6</a> of the <a href="https://huggingface.co/course/chapter1/1" rel="nofollow">Hugging Face Course</a>.',Pt,E,He="Our Neuron Accelerator expects a fixed shape of inputs. We need to truncate or pad all samples to the same length.",qt,P,Dt,q,Kt,D,ze='Normally you would use the <a href="https://huggingface.co/docs/transformers/v4.19.4/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> and <a href="https://huggingface.co/docs/transformers/v4.19.4/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a> to fine-tune PyTorch-based transformer models.',Ot,K,Qe='But together with AWS, we have developed a <code>NeuronTrainer</code> to improve performance, robustness, and safety when training on Trainium instances. The <code>NeuronTrainer</code> also comes with a <a href="https://www.notion.so/Getting-started-with-AWS-Trainium-and-Hugging-Face-Transformers-8428c72556194aed9c393de101229dcf" rel="nofollow">model cache</a>, which allows us to use precompiled models and configuration from Hugging Face Hub to skip the compilation step, which would be needed at the beginning of training. This can reduce the training time by ~3x.',te,O,Ve="The <code>NeuronTrainer</code> is part of the <code>optimum-neuron</code> library and can be used as a 1-to-1 replacement for the <code>Trainer</code>. You only have to adjust the import in your training script.",ee,tt,ne,et,Ae='We prepared a simple <a href="https://github.com/philschmid/aws-neuron-samples/blob/main/training/scripts/train.py" rel="nofollow">train.py</a> training script based on the <a href="https://www.philschmid.de/getting-started-pytorch-2-0-transformers#3-fine-tune--evaluate-bert-model-with-the-hugging-face-trainer" rel="nofollow">“Getting started with Pytorch 2.0 and Hugging Face Transformers”</a> blog post with the <code>NeuronTrainer</code>. Below is an excerpt',ae,nt,le,at,Ye='We can load the training script into our environment using the <code>wget</code> command or manually copy it into the notebook from <a href="https://github.com/huggingface/optimum-neuron/blob/notebooks/text-classification/scripts/train.py" rel="nofollow">here</a>.',se,lt,ie,st,Ne="We will use <code>torchrun</code> to launch our training script on both neuron cores for distributed training. <code>torchrun</code> is a tool that automatically distributes a PyTorch model across multiple accelerators. We can pass the number of accelerators as <code>nproc_per_node</code> arguments alongside our hyperparameters.",re,it,Le="We’ll use the following command to launch training:",oe,rt,pe,ot,Se="<em><strong>Note</strong>: If you see bad, bad accuracy, you might want to deactivate <code>bf16</code> for now.</em>",ce,pt,Ee="After 9 minutes the training was completed and achieved an excellent f1 score of <code>0.914</code>.",de,ct,me,dt,Pe="Last but not least, terminate the EC2 instance to avoid unnecessary charges. Looking at the price-performance, our training only cost <strong><code>20ct</code></strong> (<strong><code>1.34$/h * 0.15h = 0.20$</code></strong>)",Me,Mt,ue;return w=new ut({props:{title:"Fine-tune BERT for Text Classification on AWS Trainium",local:"fine-tune-bert-for-text-classification-on-aws-trainium",headingTag:"h1"}}),g=new ut({props:{title:"Quick intro: AWS Trainium",local:"quick-intro-aws-trainium",headingTag:"h2"}}),G=new ut({props:{title:"1. Setup AWS environment",local:"1-setup-aws-environment",headingTag:"h2"}}),F=new h({props:{code:"UFVCTElDX0ROUyUzRCUyMiUyMiUyMCUyMyUyMElQJTIwYWRkcmVzcyUyQyUyMGUuZy4lMjBlYzItMy04MC0uLi4uJTBBS0VZX1BBVEglM0QlMjIlMjIlMjAlMjMlMjBsb2NhbCUyMHBhdGglMjB0byUyMGtleSUyQyUyMGUuZy4lMjBzc2glMkZ0cm4ucGVtJTBBJTBBc3NoJTIwLUwlMjA4MDgwJTNBbG9jYWxob3N0JTNBODA4MCUyMC1pJTIwJTI0JTdCS0VZX05BTUUlN0QucGVtJTIwdWJ1bnR1JTQwJTI0UFVCTElDX0ROUw==",highlighted:`PUBLIC_DNS=<span class="hljs-string">&quot;&quot;</span> <span class="hljs-comment"># IP address, e.g. ec2-3-80-....</span>
KEY_PATH=<span class="hljs-string">&quot;&quot;</span> <span class="hljs-comment"># local path to key, e.g. ssh/trn.pem</span>

ssh -L 8080:localhost:8080 -i <span class="hljs-variable">\${KEY_NAME}</span>.pem ubuntu@<span class="hljs-variable">$PUBLIC_DNS</span>`,wrap:!1}}),R=new h({props:{code:"cHl0aG9uJTIwLW0lMjBub3RlYm9vayUyMC0tYWxsb3ctcm9vdCUyMC0tcG9ydCUzRDgwODA=",highlighted:"python -m notebook --allow-root --port=8080",wrap:!1}}),Q=new ut({props:{title:"2. Load and process the dataset",local:"2-load-and-process-the-dataset",headingTag:"h2"}}),Y=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwRGF0YXNldCUyMGlkJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldCUwQWRhdGFzZXRfaWQlMjAlM0QlMjAlMjJwaGlsc2NobWlkJTJGZW1vdGlvbiUyMiUwQSUwQSUyMyUyMExvYWQlMjByYXclMjBkYXRhc2V0JTBBcmF3X2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoZGF0YXNldF9pZCklMEElMEFwcmludChmJTIyVHJhaW4lMjBkYXRhc2V0JTIwc2l6ZSUzQSUyMCU3QmxlbihyYXdfZGF0YXNldCU1Qid0cmFpbiclNUQpJTdEJTIyKSUwQXByaW50KGYlMjJUZXN0JTIwZGF0YXNldCUyMHNpemUlM0ElMjAlN0JsZW4ocmF3X2RhdGFzZXQlNUIndGVzdCclNUQpJTdEJTIyKSUwQSUwQSUyMyUyMFRyYWluJTIwZGF0YXNldCUyMHNpemUlM0ElMjAxNjAwMCUwQSUyMyUyMFRlc3QlMjBkYXRhc2V0JTIwc2l6ZSUzQSUyMDIwMDA=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Dataset id from huggingface.co/dataset</span>
dataset_id = <span class="hljs-string">&quot;philschmid/emotion&quot;</span>

<span class="hljs-comment"># Load raw dataset</span>
raw_dataset = load_dataset(dataset_id)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Train dataset size: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(raw_dataset[<span class="hljs-string">&#x27;train&#x27;</span>])}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Test dataset size: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(raw_dataset[<span class="hljs-string">&#x27;test&#x27;</span>])}</span>&quot;</span>)

<span class="hljs-comment"># Train dataset size: 16000</span>
<span class="hljs-comment"># Test dataset size: 2000</span>`,wrap:!1}}),L=new h({props:{code:"ZnJvbSUyMHJhbmRvbSUyMGltcG9ydCUyMHJhbmRyYW5nZSUwQSUwQXJhbmRvbV9pZCUyMCUzRCUyMHJhbmRyYW5nZShsZW4ocmF3X2RhdGFzZXQlNUIndHJhaW4nJTVEKSklMEFyYXdfZGF0YXNldCU1Qid0cmFpbiclNUQlNUJyYW5kb21faWQlNUQlMEElMjMlMjAlN0IndGV4dCclM0ElMjAnaSUyMGZlZWwlMjBpc29sYXRlZCUyMGFuZCUyMGFsb25lJTIwaW4lMjBteSUyMHRyYWRlJyUyQyUyMCdsYWJlbCclM0ElMjAwJTdE",highlighted:`<span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randrange

random_id = randrange(<span class="hljs-built_in">len</span>(raw_dataset[<span class="hljs-string">&#x27;train&#x27;</span>]))
raw_dataset[<span class="hljs-string">&#x27;train&#x27;</span>][random_id]
<span class="hljs-comment"># {&#x27;text&#x27;: &#x27;i feel isolated and alone in my trade&#x27;, &#x27;label&#x27;: 0}</span>`,wrap:!1}}),P=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFpbXBvcnQlMjBvcyUwQSUyMyUyME1vZGVsJTIwaWQlMjB0byUyMGxvYWQlMjB0aGUlMjB0b2tlbml6ZXIlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyJTBBc2F2ZV9kYXRhc2V0X3BhdGglMjAlM0QlMjAlMjJsbV9kYXRhc2V0JTIyJTBBJTIzJTIwTG9hZCUyMFRva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUwQSUyMyUyMFRva2VuaXplJTIwaGVscGVyJTIwZnVuY3Rpb24lMEFkZWYlMjB0b2tlbml6ZShiYXRjaCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIoYmF0Y2glNUIndGV4dCclNUQlMkMlMjBwYWRkaW5nJTNEJ21heF9sZW5ndGgnJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUlMkNyZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFRva2VuaXplJTIwZGF0YXNldCUwQXJhd19kYXRhc2V0JTIwJTNEJTIwJTIwcmF3X2RhdGFzZXQucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMjAlMjMlMjB0byUyMG1hdGNoJTIwVHJhaW5lciUwQXRva2VuaXplZF9kYXRhc2V0JTIwJTNEJTIwcmF3X2RhdGFzZXQubWFwKHRva2VuaXplJTJDJTIwYmF0Y2hlZCUzRFRydWUlMkMlMjByZW1vdmVfY29sdW1ucyUzRCU1QiUyMnRleHQlMjIlNUQpJTBBdG9rZW5pemVkX2RhdGFzZXQlMjAlM0QlMjB0b2tlbml6ZWRfZGF0YXNldC53aXRoX2Zvcm1hdCglMjJ0b3JjaCUyMiklMEElMEElMjMlMjBzYXZlJTIwZGF0YXNldCUyMHRvJTIwZGlzayUwQXRva2VuaXplZF9kYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQuc2F2ZV90b19kaXNrKG9zLnBhdGguam9pbihzYXZlX2RhdGFzZXRfcGF0aCUyQyUyMnRyYWluJTIyKSklMEF0b2tlbml6ZWRfZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQuc2F2ZV90b19kaXNrKG9zLnBhdGguam9pbihzYXZlX2RhdGFzZXRfcGF0aCUyQyUyMmV2YWwlMjIpKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">import</span> os
<span class="hljs-comment"># Model id to load the tokenizer</span>
model_id = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
save_dataset_path = <span class="hljs-string">&quot;lm_dataset&quot;</span>
<span class="hljs-comment"># Load Tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)

<span class="hljs-comment"># Tokenize helper function</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">batch</span>):
    <span class="hljs-keyword">return</span> tokenizer(batch[<span class="hljs-string">&#x27;text&#x27;</span>], padding=<span class="hljs-string">&#x27;max_length&#x27;</span>, truncation=<span class="hljs-literal">True</span>,return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-comment"># Tokenize dataset</span>
raw_dataset =  raw_dataset.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>) <span class="hljs-comment"># to match Trainer</span>
tokenized_dataset = raw_dataset.<span class="hljs-built_in">map</span>(tokenize, batched=<span class="hljs-literal">True</span>, remove_columns=[<span class="hljs-string">&quot;text&quot;</span>])
tokenized_dataset = tokenized_dataset.with_format(<span class="hljs-string">&quot;torch&quot;</span>)

<span class="hljs-comment"># save dataset to disk</span>
tokenized_dataset[<span class="hljs-string">&quot;train&quot;</span>].save_to_disk(os.path.join(save_dataset_path,<span class="hljs-string">&quot;train&quot;</span>))
tokenized_dataset[<span class="hljs-string">&quot;test&quot;</span>].save_to_disk(os.path.join(save_dataset_path,<span class="hljs-string">&quot;eval&quot;</span>))`,wrap:!1}}),q=new ut({props:{title:"3. Fine-tune BERT using Hugging Face Transformers",local:"3-fine-tune-bert-using-hugging-face-transformers",headingTag:"h2"}}),tt=new h({props:{code:"LSUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUcmFpbmVyJTBBJTJCJTIwZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uVHJhaW5lciUyMGFzJTIwVHJhaW5lcg==",highlighted:`<span class="hljs-deletion">- from transformers import Trainer</span>
<span class="hljs-addition">+ from optimum.neuron import NeuronTrainer as Trainer</span>`,wrap:!1}}),nt=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uVHJhaW5lciUyMGFzJTIwVHJhaW5lciUwQSUwQWRlZiUyMHBhcnNlX2FyZ3MoKSUzQSUwQSUwOS4uLiUwQSUwQWRlZiUyMHRyYWluaW5nX2Z1bmN0aW9uKGFyZ3MpJTNBJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwbG9hZCUyMGRhdGFzZXQlMjBmcm9tJTIwZGlzayUyMGFuZCUyMHRva2VuaXplciUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2Zyb21fZGlzayhvcy5wYXRoLmpvaW4oYXJncy5kYXRhc2V0X3BhdGglMkMlMjAlMjJ0cmFpbiUyMikpJTBBJTA5JTA5Li4uJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRG93bmxvYWQlMjB0aGUlMjBtb2RlbCUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyRm1vZGVscyUwQSUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXJncy5tb2RlbF9pZCUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUwOSUwOSUwOS4uLiUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBDcmVhdGUlMjBUcmFpbmVyJTIwaW5zdGFuY2UlMEElMjAlMjAlMjAlMjB0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRGV2YWxfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBTdGFydCUyMHRyYWluaW5nJTBBJTIwJTIwJTIwJTIwdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronTrainer <span class="hljs-keyword">as</span> Trainer

<span class="hljs-keyword">def</span> <span class="hljs-title function_">parse_args</span>():
	...

<span class="hljs-keyword">def</span> <span class="hljs-title function_">training_function</span>(<span class="hljs-params">args</span>):

    <span class="hljs-comment"># load dataset from disk and tokenizer</span>
    train_dataset = load_from_disk(os.path.join(args.dataset_path, <span class="hljs-string">&quot;train&quot;</span>))
		...

    <span class="hljs-comment"># Download the model from huggingface.co/models</span>
    model = AutoModelForSequenceClassification.from_pretrained(
        args.model_id, num_labels=num_labels, label2id=label2id, id2label=id2label
    )

    training_args = TrainingArguments(
			...
    )

    <span class="hljs-comment"># Create Trainer instance</span>
    trainer = Trainer(
        model=model,
        args=training_args,
        train_dataset=train_dataset,
        eval_dataset=eval_dataset,
        compute_metrics=compute_metrics,
    )

    <span class="hljs-comment"># Start training</span>
    trainer.train()`,wrap:!1}}),lt=new h({props:{code:"IXdnZXQlMjBodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZodWdnaW5nZmFjZSUyRm9wdGltdW0tbmV1cm9uJTJGbm90ZWJvb2tzJTJGdGV4dC1jbGFzc2lmaWNhdGlvbiUyRnNjcmlwdHMlMkZ0cmFpbi5weQ==",highlighted:"!wget https://raw.githubusercontent.com/huggingface/optimum-neuron/notebooks/text-classification/scripts/train.py",wrap:!1}}),rt=new h({props:{code:"IXRvcmNocnVuJTIwLS1ucHJvY19wZXJfbm9kZSUzRDIlMjBzY3JpcHRzJTJGdHJhaW4ucHklMjAlNUMlMEElMjAtLW1vZGVsX2lkJTIwYmVydC1iYXNlLXVuY2FzZWQlMjAlNUMlMEElMjAtLWRhdGFzZXRfcGF0aCUyMGxtX2RhdGFzZXQlMjAlNUMlMEElMjAtLWxyJTIwNWUtNSUyMCU1QyUwQSUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwMTYlMjAlNUMlMEElMjAtLWJmMTYlMjBUcnVlJTIwJTVDJTBBJTIwLS1lcG9jaHMlMjAz",highlighted:`!torchrun --nproc_per_node=2 scripts/train.py \\
 --model_id bert-base-uncased \\
 --dataset_path lm_dataset \\
 --lr 5e-5 \\
 --per_device_train_batch_size 16 \\
 --bf16 True \\
 --epochs 3`,wrap:!1}}),ct=new h({props:{code:"KioqKiolMjB0cmFpbiUyMG1ldHJpY3MlMjAqKioqKiUwQSUyMCUyMGVwb2NoJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMy4wJTBBJTIwJTIwdHJhaW5fcnVudGltZSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCUyMCUyMCUyMDAlM0EwOCUzQTMwJTBBJTIwJTIwdHJhaW5fc2FtcGxlcyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCUyMCUyMCUyMCUyMCUyMDE2MDAwJTBBJTIwJTIwdHJhaW5fc2FtcGxlc19wZXJfc2Vjb25kJTIwJTNEJTIwJTIwJTIwJTIwJTIwOTYuMzM3JTBBJTBBKioqKiolMjBldmFsJTIwbWV0cmljcyUyMCoqKioqJTBBJTIwJTIwZXZhbF9mMSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCUyMCUyMCUyMCUyMCUyMDAuOTE0JTBBJTIwJTIwZXZhbF9ydW50aW1lJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTIwJTIwJTIwMCUzQTAwJTNBMDg=",highlighted:`***** train metrics *****
  epoch                    =        3.0
  train_runtime            =    0:08:30
  train_samples            =      16000
  train_samples_per_second =     96.337

***** <span class="hljs-built_in">eval</span> metrics *****
  eval_f1                  =      0.914
  eval_runtime             =    0:00:08`,wrap:!1}}),{c(){y=i("meta"),ht=l(),mt=i("p"),yt=l(),p(w.$$.fragment),wt=l(),T=i("p"),T.innerHTML=ye,Tt=l(),f=i("p"),f.textContent=we,ft=l(),U=i("ol"),U.innerHTML=Te,Ut=l(),J=i("p"),J.innerHTML=fe,Jt=l(),p(g.$$.fragment),gt=l(),b=i("p"),b.innerHTML=Ue,bt=l(),C=i("p"),C.textContent=Je,Ct=l(),j=i("p"),j.innerHTML=ge,jt=l(),I=i("table"),I.innerHTML=be,It=l(),vt=i("hr"),Wt=l(),v=i("p"),v.textContent=Ce,Gt=l(),W=i("p"),W.innerHTML=je,_t=l(),p(G.$$.fragment),Bt=l(),_=i("p"),_.innerHTML=Ie,Zt=l(),B=i("p"),B.innerHTML=ve,Ft=l(),Z=i("p"),Z.innerHTML=We,$t=l(),p(F.$$.fragment),Rt=l(),$=i("p"),$.innerHTML=Ge,kt=l(),p(R.$$.fragment),Xt=l(),k=i("p"),k.innerHTML=_e,xt=l(),X=i("p"),X.innerHTML=Be,Ht=l(),x=i("p"),x.innerHTML=Ze,zt=l(),H=i("p"),H.innerHTML=Fe,Qt=l(),z=i("p"),z.innerHTML=$e,Vt=l(),p(Q.$$.fragment),At=l(),V=i("p"),V.innerHTML=Re,Yt=l(),A=i("p"),A.innerHTML=ke,Nt=l(),p(Y.$$.fragment),Lt=l(),N=i("p"),N.textContent=Xe,St=l(),p(L.$$.fragment),Et=l(),S=i("p"),S.innerHTML=xe,Pt=l(),E=i("p"),E.textContent=He,qt=l(),p(P.$$.fragment),Dt=l(),p(q.$$.fragment),Kt=l(),D=i("p"),D.innerHTML=ze,Ot=l(),K=i("p"),K.innerHTML=Qe,te=l(),O=i("p"),O.innerHTML=Ve,ee=l(),p(tt.$$.fragment),ne=l(),et=i("p"),et.innerHTML=Ae,ae=l(),p(nt.$$.fragment),le=l(),at=i("p"),at.innerHTML=Ye,se=l(),p(lt.$$.fragment),ie=l(),st=i("p"),st.innerHTML=Ne,re=l(),it=i("p"),it.textContent=Le,oe=l(),p(rt.$$.fragment),pe=l(),ot=i("p"),ot.innerHTML=Se,ce=l(),pt=i("p"),pt.innerHTML=Ee,de=l(),p(ct.$$.fragment),me=l(),dt=i("p"),dt.innerHTML=Pe,Me=l(),Mt=i("p"),this.h()},l(t){const e=an("svelte-u9bgzb",document.head);y=r(e,"META",{name:!0,content:!0}),e.forEach(n),ht=s(t),mt=r(t,"P",{}),qe(mt).forEach(n),yt=s(t),c(w.$$.fragment,t),wt=s(t),T=r(t,"P",{"data-svelte-h":!0}),o(T)!=="svelte-fq2j94"&&(T.innerHTML=ye),Tt=s(t),f=r(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1hahfn0"&&(f.textContent=we),ft=s(t),U=r(t,"OL",{"data-svelte-h":!0}),o(U)!=="svelte-i2dg6s"&&(U.innerHTML=Te),Ut=s(t),J=r(t,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1dtnb6s"&&(J.innerHTML=fe),Jt=s(t),c(g.$$.fragment,t),gt=s(t),b=r(t,"P",{"data-svelte-h":!0}),o(b)!=="svelte-i1bq8"&&(b.innerHTML=Ue),bt=s(t),C=r(t,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1xmmjdv"&&(C.textContent=Je),Ct=s(t),j=r(t,"P",{"data-svelte-h":!0}),o(j)!=="svelte-f3jgz1"&&(j.innerHTML=ge),jt=s(t),I=r(t,"TABLE",{"data-svelte-h":!0}),o(I)!=="svelte-1ch8aud"&&(I.innerHTML=be),It=s(t),vt=r(t,"HR",{}),Wt=s(t),v=r(t,"P",{"data-svelte-h":!0}),o(v)!=="svelte-6n93f4"&&(v.textContent=Ce),Gt=s(t),W=r(t,"P",{"data-svelte-h":!0}),o(W)!=="svelte-xlynlq"&&(W.innerHTML=je),_t=s(t),c(G.$$.fragment,t),Bt=s(t),_=r(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-6ygvsn"&&(_.innerHTML=Ie),Zt=s(t),B=r(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1p685c9"&&(B.innerHTML=ve),Ft=s(t),Z=r(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1w4fiht"&&(Z.innerHTML=We),$t=s(t),c(F.$$.fragment,t),Rt=s(t),$=r(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-cmik5i"&&($.innerHTML=Ge),kt=s(t),c(R.$$.fragment,t),Xt=s(t),k=r(t,"P",{"data-svelte-h":!0}),o(k)!=="svelte-si97e0"&&(k.innerHTML=_e),xt=s(t),X=r(t,"P",{"data-svelte-h":!0}),o(X)!=="svelte-7s5jat"&&(X.innerHTML=Be),Ht=s(t),x=r(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-yorl3n"&&(x.innerHTML=Ze),zt=s(t),H=r(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-krn90s"&&(H.innerHTML=Fe),Qt=s(t),z=r(t,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1op3czr"&&(z.innerHTML=$e),Vt=s(t),c(Q.$$.fragment,t),At=s(t),V=r(t,"P",{"data-svelte-h":!0}),o(V)!=="svelte-nodub0"&&(V.innerHTML=Re),Yt=s(t),A=r(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1ab0i1h"&&(A.innerHTML=ke),Nt=s(t),c(Y.$$.fragment,t),Lt=s(t),N=r(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-udg7sq"&&(N.textContent=Xe),St=s(t),c(L.$$.fragment,t),Et=s(t),S=r(t,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1vv5g70"&&(S.innerHTML=xe),Pt=s(t),E=r(t,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1iixhur"&&(E.textContent=He),qt=s(t),c(P.$$.fragment,t),Dt=s(t),c(q.$$.fragment,t),Kt=s(t),D=r(t,"P",{"data-svelte-h":!0}),o(D)!=="svelte-spmis1"&&(D.innerHTML=ze),Ot=s(t),K=r(t,"P",{"data-svelte-h":!0}),o(K)!=="svelte-iqzsb"&&(K.innerHTML=Qe),te=s(t),O=r(t,"P",{"data-svelte-h":!0}),o(O)!=="svelte-c0yi33"&&(O.innerHTML=Ve),ee=s(t),c(tt.$$.fragment,t),ne=s(t),et=r(t,"P",{"data-svelte-h":!0}),o(et)!=="svelte-9f48rl"&&(et.innerHTML=Ae),ae=s(t),c(nt.$$.fragment,t),le=s(t),at=r(t,"P",{"data-svelte-h":!0}),o(at)!=="svelte-z4rrh7"&&(at.innerHTML=Ye),se=s(t),c(lt.$$.fragment,t),ie=s(t),st=r(t,"P",{"data-svelte-h":!0}),o(st)!=="svelte-1tr68b8"&&(st.innerHTML=Ne),re=s(t),it=r(t,"P",{"data-svelte-h":!0}),o(it)!=="svelte-folbj9"&&(it.textContent=Le),oe=s(t),c(rt.$$.fragment,t),pe=s(t),ot=r(t,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-161fdea"&&(ot.innerHTML=Se),ce=s(t),pt=r(t,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-dotc0h"&&(pt.innerHTML=Ee),de=s(t),c(ct.$$.fragment,t),me=s(t),dt=r(t,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-1iox2bz"&&(dt.innerHTML=Pe),Me=s(t),Mt=r(t,"P",{}),qe(Mt).forEach(n),this.h()},h(){De(y,"name","hf:doc:metadata"),De(y,"content",rn)},m(t,e){ln(document.head,y),a(t,ht,e),a(t,mt,e),a(t,yt,e),d(w,t,e),a(t,wt,e),a(t,T,e),a(t,Tt,e),a(t,f,e),a(t,ft,e),a(t,U,e),a(t,Ut,e),a(t,J,e),a(t,Jt,e),d(g,t,e),a(t,gt,e),a(t,b,e),a(t,bt,e),a(t,C,e),a(t,Ct,e),a(t,j,e),a(t,jt,e),a(t,I,e),a(t,It,e),a(t,vt,e),a(t,Wt,e),a(t,v,e),a(t,Gt,e),a(t,W,e),a(t,_t,e),d(G,t,e),a(t,Bt,e),a(t,_,e),a(t,Zt,e),a(t,B,e),a(t,Ft,e),a(t,Z,e),a(t,$t,e),d(F,t,e),a(t,Rt,e),a(t,$,e),a(t,kt,e),d(R,t,e),a(t,Xt,e),a(t,k,e),a(t,xt,e),a(t,X,e),a(t,Ht,e),a(t,x,e),a(t,zt,e),a(t,H,e),a(t,Qt,e),a(t,z,e),a(t,Vt,e),d(Q,t,e),a(t,At,e),a(t,V,e),a(t,Yt,e),a(t,A,e),a(t,Nt,e),d(Y,t,e),a(t,Lt,e),a(t,N,e),a(t,St,e),d(L,t,e),a(t,Et,e),a(t,S,e),a(t,Pt,e),a(t,E,e),a(t,qt,e),d(P,t,e),a(t,Dt,e),d(q,t,e),a(t,Kt,e),a(t,D,e),a(t,Ot,e),a(t,K,e),a(t,te,e),a(t,O,e),a(t,ee,e),d(tt,t,e),a(t,ne,e),a(t,et,e),a(t,ae,e),d(nt,t,e),a(t,le,e),a(t,at,e),a(t,se,e),d(lt,t,e),a(t,ie,e),a(t,st,e),a(t,re,e),a(t,it,e),a(t,oe,e),d(rt,t,e),a(t,pe,e),a(t,ot,e),a(t,ce,e),a(t,pt,e),a(t,de,e),d(ct,t,e),a(t,me,e),a(t,dt,e),a(t,Me,e),a(t,Mt,e),ue=!0},p:Oe,i(t){ue||(m(w.$$.fragment,t),m(g.$$.fragment,t),m(G.$$.fragment,t),m(F.$$.fragment,t),m(R.$$.fragment,t),m(Q.$$.fragment,t),m(Y.$$.fragment,t),m(L.$$.fragment,t),m(P.$$.fragment,t),m(q.$$.fragment,t),m(tt.$$.fragment,t),m(nt.$$.fragment,t),m(lt.$$.fragment,t),m(rt.$$.fragment,t),m(ct.$$.fragment,t),ue=!0)},o(t){M(w.$$.fragment,t),M(g.$$.fragment,t),M(G.$$.fragment,t),M(F.$$.fragment,t),M(R.$$.fragment,t),M(Q.$$.fragment,t),M(Y.$$.fragment,t),M(L.$$.fragment,t),M(P.$$.fragment,t),M(q.$$.fragment,t),M(tt.$$.fragment,t),M(nt.$$.fragment,t),M(lt.$$.fragment,t),M(rt.$$.fragment,t),M(ct.$$.fragment,t),ue=!1},d(t){t&&(n(ht),n(mt),n(yt),n(wt),n(T),n(Tt),n(f),n(ft),n(U),n(Ut),n(J),n(Jt),n(gt),n(b),n(bt),n(C),n(Ct),n(j),n(jt),n(I),n(It),n(vt),n(Wt),n(v),n(Gt),n(W),n(_t),n(Bt),n(_),n(Zt),n(B),n(Ft),n(Z),n($t),n(Rt),n($),n(kt),n(Xt),n(k),n(xt),n(X),n(Ht),n(x),n(zt),n(H),n(Qt),n(z),n(Vt),n(At),n(V),n(Yt),n(A),n(Nt),n(Lt),n(N),n(St),n(Et),n(S),n(Pt),n(E),n(qt),n(Dt),n(Kt),n(D),n(Ot),n(K),n(te),n(O),n(ee),n(ne),n(et),n(ae),n(le),n(at),n(se),n(ie),n(st),n(re),n(it),n(oe),n(pe),n(ot),n(ce),n(pt),n(de),n(me),n(dt),n(Me),n(Mt)),n(y),u(w,t),u(g,t),u(G,t),u(F,t),u(R,t),u(Q,t),u(Y,t),u(L,t),u(P,t),u(q,t),u(tt,t),u(nt,t),u(lt,t),u(rt,t),u(ct,t)}}}const rn='{"title":"Fine-tune BERT for Text Classification on AWS Trainium","local":"fine-tune-bert-for-text-classification-on-aws-trainium","sections":[{"title":"Quick intro: AWS Trainium","local":"quick-intro-aws-trainium","sections":[],"depth":2},{"title":"1. Setup AWS environment","local":"1-setup-aws-environment","sections":[],"depth":2},{"title":"2. Load and process the dataset","local":"2-load-and-process-the-dataset","sections":[],"depth":2},{"title":"3. Fine-tune BERT using Hugging Face Transformers","local":"3-fine-tune-bert-using-hugging-face-transformers","sections":[],"depth":2}],"depth":1}';function on(he){return tn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Mn extends en{constructor(y){super(),nn(this,y,on,sn,Ke,{})}}export{Mn as component};
