import{s as Aa,o as Qa,n as Xa}from"../chunks/scheduler.c57aa7ef.js";import{S as qa,i as Va,g as i,s,r as p,A as Fa,h as o,f as a,c as n,j as Wa,u as d,x as r,k as La,y as Ha,a as l,v as m,d as h,t as f,w as u}from"../chunks/index.c50cb18e.js";import{T as Ga}from"../chunks/Tip.9268b0ca.js";import{C as w}from"../chunks/CodeBlock.34f0a53d.js";import{H as y,E as Ea}from"../chunks/EditOnGithub.958a8a49.js";function za(Le){let c,T='Learn more about how PEFT works with quantization in the <a href="quantization">Quantization</a> guide.';return{c(){c=i("p"),c.innerHTML=T},l(M){c=o(M,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1nbpolx"&&(c.innerHTML=T)},m(M,b){l(M,c,b)},p:Xa,d(M){M&&a(c)}}}function xa(Le){let c,T='There are several supported methods for <code>combination_type</code>. Refer to the <a href="../package_reference/lora#peft.LoraModel.add_weighted_adapter">documentation</a> for more details. Note that “svd” as the <code>combination_type</code> is not supported when using <code>torch.float16</code> or <code>torch.bfloat16</code> as the datatype.';return{c(){c=i("p"),c.innerHTML=T},l(M){c=o(M,"P",{"data-svelte-h":!0}),r(c)!=="svelte-19y7vpj"&&(c.innerHTML=T)},m(M,b){l(M,c,b)},p:Xa,d(M){M&&a(c)}}}function Ya(Le){let c,T,M,b,_,Xe,Z,Kt='LoRA is low-rank decomposition method to reduce the number of trainable parameters which speeds up finetuning large models and uses less memory. In PEFT, using LoRA is as easy as setting up a <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> and wrapping it with <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> to create a trainable <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',Ae,j,Ot="This guide explores in more detail other options and features for using LoRA.",Qe,$,qe,U,ea='The initialization of LoRA weights is controlled by the parameter <code>init_lora_weights</code> in <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. By default, PEFT initializes LoRA weights with Kaiming-uniform for weight A and zeros for weight B resulting in an identity transform (same as the reference <a href="https://github.com/microsoft/LoRA" rel="nofollow">implementation</a>).',Ve,k,ta='It is also possible to pass <code>init_lora_weights=&quot;gaussian&quot;</code>. As the name suggests, this initializes weight A with a Gaussian distribution and zeros for weight B (this is how <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">Diffusers</a> initializes LoRA weights).',Fe,v,He,R,aa="There is also an option to set <code>init_lora_weights=False</code> which is useful for debugging and testing. This should be the only time you use this option. When choosing this option, the LoRA weights are initialized such that they do <em>not</em> result in an identity transform.",Ee,B,ze,I,xe,C,Ye,W,la='When quantizing the base model for QLoRA training, consider using the <a href="https://arxiv.org/abs/2310.08659" rel="nofollow">LoftQ initialization</a>, which has been shown to improve performance when training quantized models. The idea is that the LoRA weights are initialized such that the quantization error is minimized. To use LoftQ, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',Ne,L,sa="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",Se,G,Pe,X,na="An easier but more limited way to apply LoftQ initialization is to use the convenience function <code>replace_lora_weights_loftq</code>. This takes the quantized PEFT model as input and replaces the LoRA weights in-place with their LoftQ-initialized counterparts.",De,A,Ke,Q,ia='<code>replace_lora_weights_loftq</code> also allows you to pass a <code>callback</code> argument to give you more control over which layers should be modified or not, which empirically can improve the results quite a lot. To see a more elaborate example of this, check out <a href="https://github.com/huggingface/peft/blob/main/examples/loftq_finetuning/LoftQ_weight_replacement.ipynb" rel="nofollow">this notebook</a>.',Oe,q,oa="<code>replace_lora_weights_loftq</code> implements only one iteration step of LoftQ. This means that only the LoRA weights are updated, instead of iteratevily updating LoRA weights and quantized base model weights. This may lead to lower performance but has the advantage that we can use the original quantized weights derived from the base model, instead of having to keep an extra copy of modified quantized weights. Whether this tradeoff is worthwhile depends on the use case.",et,V,ra="At the moment, <code>replace_lora_weights_loftq</code> has these additional limitations:",tt,F,pa="<li>Model files must be stored as a <code>safetensors</code> file.</li> <li>Only bitsandbytes 4bit quantization is supported.</li>",at,g,lt,H,st,E,da='Another way to initialize <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> is with the <a href="https://huggingface.co/papers/2312.03732" rel="nofollow">rank-stabilized LoRA (rsLoRA)</a> method. The LoRA architecture scales each adapter during every forward pass by a fixed scalar which is set at initialization and depends on the rank <code>r</code>. The scalar is given by <code>lora_alpha/r</code> in the original implementation, but rsLoRA uses <code>lora_alpha/math.sqrt(r)</code> which stabilizes the adapters and increases the performance potential from using a higher <code>r</code>.',nt,z,it,x,ot,Y,ma='This technique decomposes the updates of the weights into two parts, magnitude and direction. Direction is handled by normal LoRA, whereas the magnitude is handled by a separate learnable parameter. This can improve the performance of LoRA, especially at low ranks. For more information on DoRA, see  <a href="https://arxiv.org/abs/2402.09353" rel="nofollow">https://arxiv.org/abs/2402.09353</a>.',rt,N,pt,S,dt,P,ha='<li>DoRA only supports linear and Conv2d layers at the momement.</li> <li>DoRA introduces a bigger overhead than pure LoRA, so it is recommended to merge weights for inference, see <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">LoraModel.merge_and_unload()</a>.</li> <li>DoRA should work with weights quantized with bitsandbytes (“QDoRA”). However, issues have been reported when using QDoRA with DeepSpeed Zero2.</li>',mt,D,ht,K,fa='The default LoRA settings in PEFT add trainable weights to the query and value layers of each attention block. But <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a>, which adds trainable weights to all the linear layers of a transformer model, can provide performance equal to a fully finetuned model. To apply LoRA to all the linear layers, like in QLoRA, set <code>target_modules=&quot;all-linear&quot;</code> (easier than specifying individual modules by name which can vary depending on the architecture).',ft,O,ut,ee,ct,te,ua='An approach used to improve the performance of models is to expand a model by duplicating layers in the model to build a larger model from a pretrained model of a given size. For example increasing a 7B model to a 10B model as described in the <a href="https://arxiv.org/abs/2312.15166" rel="nofollow">SOLAR</a> paper. PEFT LoRA supports this kind of expansion in a memory efficient manner that supports further fine-tuning using LoRA adapters attached to the layers post replication of the layers. The replicated layers do not take additional memory as they share the underlying weights so the only additional memory required is the memory for the adapter weights. To use this feature you would create a config with the <code>layer_replication</code> argument.',Mt,ae,wt,le,ca='Assuming the original model had 5 layers <code>[0, 1, 2 ,3, 4]</code>, this would create a model with 7 layers arranged as <code>[0, 1, 2, 3, 2, 3, 4]</code>. This follows the <a href="https://github.com/arcee-ai/mergekit" rel="nofollow">mergekit</a> pass through merge convention where sequences of layers specified as start inclusive and end exclusive tuples are stacked to build the final model. Each layer in the final model gets its own distinct set of LoRA adpaters.',yt,se,Ma=`<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B" rel="nofollow">Fewshot-Metamath-OrcaVicuna-Mistral-10B</a> is an example of a model trained using this method on Mistral-7B expanded to 10B. The
<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B/blob/main/adapter_config.json" rel="nofollow">adapter_config.json</a> shows a sample LoRA adapter config applying this method for fine-tuning.`,Tt,ne,bt,ie,wa='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA adapter. To eliminate latency, use the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model. This allows you to use the newly merged model as a standalone model. The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function doesn’t keep the adapter weights in memory.',gt,oe,Jt,re,ya='If you need to keep a copy of the weights so you can unmerge the adapter later or delete and load different ones, you should use the <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_adapter">merge_adapter()</a> function instead. Now you have the option to use <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unmerge_adapter">unmerge_adapter()</a> to return the base model.',_t,pe,Zt,de,Ta='The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> function is useful for merging multiple LoRAs into a new adapter based on a user provided weighting scheme in the <code>weights</code> parameter. Below is an end-to-end example.',jt,me,ba="First load the base model:",$t,he,Ut,fe,ga="Then we load the first adapter:",kt,ue,vt,ce,Ja="Then load a different adapter and merge it with the first one:",Rt,Me,Bt,J,It,we,_a="Now, perform inference:",Ct,ye,Wt,Te,Lt,be,Za='Adapters can be loaded onto a pretrained model with <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>, which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.set_adapter">set_adapter()</a> function.',Gt,ge,Xt,Je,ja='To return the base model, you could use <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.unload">unload()</a> to unload all of the LoRA modules or <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.delete_adapter">delete_adapter()</a> to delete the adapter entirely.',At,_e,Qt,Ze,qt,je,$a="Normally, each inference batch has to use the same adapter(s) in PEFT. This can sometimes be annoying, because we may have batches that contain samples intended to be used with different LoRA adapters. For example, we could have a base model that works well in English and two more LoRA adapters, one for French and one for German. Usually, we would have to split our batches such that each batch only contains samples of one of the languages, we cannot combine different languages in the same batch.",Vt,$e,Ua="Thankfully, it is possible to mix different LoRA adapters in the same batch using the <code>adapter_name</code> argument. Below, we show an examle of how this works in practice. First, let’s load the base model, English, and the two adapters, French and German, like this:",Ft,Ue,Ht,ke,ka="Now, we want to generate text on a sample that contains all three languages: The first three samples are in English, the next three are in French, and the last three are in German. We can use the <code>adapter_names</code> argument to specify which adapter to use for each sample. Since our base model is used for English, we use the special string <code>&quot;__base__&quot;</code> for these samples. For the next three samples, we indicate the adapter name of the French LoRA fine-tune, in this case <code>&quot;adapter_fr&quot;</code>. For the last three samples, we indicate the adapter name of the German LoRA fine-tune, in this case <code>&quot;adapter_de&quot;</code>. This way, we can use the base model and the two adapters in a single batch.",Et,ve,zt,Re,va="Note that the order does not matter here, i.e. the samples in the batch don’t need to be grouped by adapter as in the example above. We just need to ensure that the <code>adapter_names</code> argument is aligned correctly with the samples.",xt,Be,Yt,Ie,Ra="Using this features has some drawbacks, namely:",Nt,Ce,Ba='<li>It only works for inference, not for training.</li> <li>Disabling adapters using the <code>with model.disable_adapter()</code> context takes precedence over <code>adapter_names</code>.</li> <li>You cannot pass <code>adapter_names</code> when some adapter weights where merged with base weight using the <code>merge_adapter</code> method. Please unmerge all adapters first by calling <code>model.unmerge_adapter()</code>.</li> <li>For obvious reasons, this cannot be used after calling <code>merge_and_unload()</code>, since all the LoRA adapters will be merged into the base weights in this case.</li> <li>This feature does not currently work with DoRA, so set <code>use_dora=False</code> in your <code>LoraConfig</code> if you want to use it.</li> <li>There is an expected overhead for inference with <code>adapter_names</code>, especially if the amount of different adapters in the batch is high. This is because the batch size is effectively reduced to the number of samples per adapter. If runtime performance is your top priority, try the following:<ul><li>Increase the batch size.</li> <li>Try to avoid having a large number of different adapters in the same batch, prefer homogeneous batches. This can be achieved by buffering samples with the same adapter and only perform inference with a small handfull of different adapters.</li> <li>Take a look at alternative implementations such as <a href="https://github.com/predibase/lorax" rel="nofollow">LoRAX</a>, <a href="https://github.com/punica-ai/punica" rel="nofollow">punica</a>, or <a href="https://github.com/S-LoRA/S-LoRA" rel="nofollow">S-LoRA</a>, which are specialized to work with a large number of different adapters.</li></ul></li>',St,We,Pt,Ge,Dt;return _=new y({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),$=new y({props:{title:"Initialization",local:"initialization",headingTag:"h2"}}),v=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmdhdXNzaWFuJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;gaussian&quot;</span>, ...)`,wrap:!1}}),B=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzREZhbHNlJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-literal">False</span>, ...)`,wrap:!1}}),I=new y({props:{title:"LoftQ",local:"loftq",headingTag:"h3"}}),C=new y({props:{title:"Standard approach",local:"standard-approach",headingTag:"h4"}}),G=new y({props:{title:"A more convienient way",local:"a-more-convienient-way",headingTag:"h4"}}),A=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjByZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjAuLi4pJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCguLi4lMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyklMEElMjMlMjBub3RlJTNBJTIwZG9uJ3QlMjBwYXNzJTIwaW5pdF9sb3JhX3dlaWdodHMlM0QlMjJsb2Z0cSUyMiUyMG9yJTIwbG9mdHFfY29uZmlnISUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIpJTBBcGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBsb3JhX2NvbmZpZyklMEFyZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cShwZWZ0X21vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> replace_lora_weights_loftq
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

bnb_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, ...)
base_model = AutoModelForCausalLM.from_pretrained(..., quantization_config=bnb_config)
<span class="hljs-comment"># note: don&#x27;t pass init_lora_weights=&quot;loftq&quot; or loftq_config!</span>
lora_config = LoraConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>)
peft_model = get_peft_model(base_model, lora_config)
replace_lora_weights_loftq(peft_model)`,wrap:!1}}),g=new Ga({props:{$$slots:{default:[za]},$$scope:{ctx:Le}}}),H=new y({props:{title:"Rank-stabilized LoRA",local:"rank-stabilized-lora",headingTag:"h3"}}),z=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfcnNsb3JhJTNEVHJ1ZSUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_rslora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),x=new y({props:{title:"Weight-Decomposed Low-Rank Adaptation (DoRA)",local:"weight-decomposed-low-rank-adaptation-dora",headingTag:"h3"}}),N=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfZG9yYSUzRFRydWUlMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),S=new y({props:{title:"Caveats",local:"caveats",headingTag:"h4"}}),D=new y({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),O=new w({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),ee=new y({props:{title:"Memory efficient Layer Replication with LoRA",local:"memory-efficient-layer-replication-with-lora",headingTag:"h3"}}),ae=new w({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhsYXllcl9yZXBsaWNhdGlvbiUzRCU1QiU1QjAlMkM0JTVEJTJDJTIwJTVCMiUyQzUlNUQlNUQlMkMlMjAuLi4p",highlighted:'config = LoraConfig(layer_replication=[[<span class="hljs-number">0</span>,<span class="hljs-number">4</span>], [<span class="hljs-number">2</span>,<span class="hljs-number">5</span>]], ...)',wrap:!1}}),ne=new y({props:{title:"Merge adapters",local:"merge-adapters",headingTag:"h2"}}),oe=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FuZF91bmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_and_unload()`,wrap:!1}}),pe=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FkYXB0ZXIoKSUwQSUwQSUyMyUyMHVubWVyZ2UlMjB0aGUlMjBMb1JBJTIwbGF5ZXJzJTIwZnJvbSUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsLnVubWVyZ2VfYWRhcHRlcigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_adapter()

<span class="hljs-comment"># unmerge the LoRA layers from the base model</span>
model.unmerge_adapter()`,wrap:!1}}),he=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">import</span> torch

base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),ue=new w({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1zZnQtbG9yYSUyMiUwQW1vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnNmdCUyMik=",highlighted:`peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id, adapter_name=<span class="hljs-string">&quot;sft&quot;</span>)`,wrap:!1}}),Me=new w({props:{code:"d2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTIwJTNEJTIwJTIyc2Z0LWRwbyUyMiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjJhbGlnbm1lbnQtaGFuZGJvb2slMkZ6ZXBoeXItN2ItZHBvLWxvcmElMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJkcG8lMjIpJTBBbW9kZWwuYWRkX3dlaWdodGVkX2FkYXB0ZXIoJTBBJTIwJTIwJTIwJTIwYWRhcHRlcnMlM0QlNUIlMjJzZnQlMjIlMkMlMjAlMjJkcG8lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTNEJTVCMC43JTJDJTIwMC4zJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEd2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwY29tYmluYXRpb25fdHlwZSUzRCUyMmxpbmVhciUyMiUwQSklMEFtb2RlbC5zZXRfYWRhcHRlcih3ZWlnaHRlZF9hZGFwdGVyX25hbWUp",highlighted:`weighted_adapter_name = <span class="hljs-string">&quot;sft-dpo&quot;</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)
model.add_weighted_adapter(
    adapters=[<span class="hljs-string">&quot;sft&quot;</span>, <span class="hljs-string">&quot;dpo&quot;</span>],
    weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>],
    adapter_name=weighted_adapter_name,
    combination_type=<span class="hljs-string">&quot;linear&quot;</span>
)
model.set_adapter(weighted_adapter_name)`,wrap:!1}}),J=new Ga({props:{$$slots:{default:[xa]},$$scope:{ctx:Le}}}),ye=new w({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oJTIyY3VkYSUyMiklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBb3V0cHV0cyUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQXByaW50KG91dHB1dHMp",highlighted:`tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
outputs = tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(outputs)`,wrap:!1}}),Te=new y({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),ge=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQSUwQSUyMyUyMGxvYWQlMjBkaWZmZXJlbnQlMjBhZGFwdGVyJTBBbW9kZWwubG9hZF9hZGFwdGVyKCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1kcG8tbG9yYSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRwbyUyMiklMEElMEElMjMlMjBzZXQlMjBhZGFwdGVyJTIwYXMlMjBhY3RpdmUlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJkcG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)

<span class="hljs-comment"># load different adapter</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)

<span class="hljs-comment"># set adapter as active</span>
model.set_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),_e=new w({props:{code:"JTIzJTIwdW5sb2FkJTIwYWRhcHRlciUwQW1vZGVsLnVubG9hZCgpJTBBJTBBJTIzJTIwZGVsZXRlJTIwYWRhcHRlciUwQW1vZGVsLmRlbGV0ZV9hZGFwdGVyKCUyMmRwbyUyMik=",highlighted:`<span class="hljs-comment"># unload adapter</span>
model.unload()

<span class="hljs-comment"># delete adapter</span>
model.delete_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),Ze=new y({props:{title:"Inference with different LoRA adapters in the same batch",local:"inference-with-different-lora-adapters-in-the-same-batch",headingTag:"h2"}}),Ue=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMjMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBGcmVuY2glMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMCUzQ3BhdGglM0UlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJhZGFwdGVyX2ZyJTIyKSUwQSUyMyUyMG5leHQlMkMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBHZXJtYW4lMEFwZWZ0X21vZGVsLmxvYWRfYWRhcHRlciglM0NwYXRoJTNFJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlcl9kZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model_id = ...
tokenizer = AutoTokenizer.from_pretrained(model_id)

model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-comment"># load the LoRA adapter for French</span>
peft_model = PeftModel.from_pretrained(model, &lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_fr&quot;</span>)
<span class="hljs-comment"># next, load the LoRA adapter for German</span>
peft_model.load_adapter(&lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_de&quot;</span>)`,wrap:!1}}),ve=new w({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIZWxsbyUyQyUyMG15JTIwY2F0JTIwaXMlMjBhd2Vzb21lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySGVsbG8lMkMlMjBteSUyMGZpc2glMjBpcyUyMGdyZWF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBjaGllbiUyMGVzdCUyMG1pZ25vbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlNhbHV0JTJDJTIwbW9uJTIwY2hhdCUyMGVzdCUyMGclQzMlQTluaWFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBwb2lzc29uJTIwZXN0JTIwc3VwZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBIdW5kJTIwaXN0JTIwcyVDMyVCQyVDMyU5RiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhhbGxvJTJDJTIwbWVpbmUlMjBLYXR6ZSUyMGlzdCUyMHRvbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBGaXNjaCUyMGlzdCUyMGdybyVDMyU5RmFydGlnJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBKSUwQSUwQWFkYXB0ZXJfbmFtZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJfX2Jhc2VfXyUyMiUyQyUyMCUyMl9fYmFzZV9fJTIyJTJDJTIwJTIyX19iYXNlX18lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2ZyJTIyJTJDJTIwJTIyYWRhcHRlcl9mciUyMiUyQyUyMCUyMmFkYXB0ZXJfZnIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2RlJTIyJTJDJTIwJTIyYWRhcHRlcl9kZSUyMiUyQyUyMCUyMmFkYXB0ZXJfZGUlMjIlMkMlMEElNUQlMEFvdXRwdXQlMjAlM0QlMjBwZWZ0X21vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYWRhcHRlcl9uYW1lcyUzRGFkYXB0ZXJfbmFtZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKQ==",highlighted:`inputs = tokenizer(
    [
        <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>,
        <span class="hljs-string">&quot;Hello, my cat is awesome&quot;</span>,
        <span class="hljs-string">&quot;Hello, my fish is great&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chien est mignon&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chat est génial&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon poisson est super&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Hund ist süß&quot;</span>,
        <span class="hljs-string">&quot;Hallo, meine Katze ist toll&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Fisch ist großartig&quot;</span>,
    ],
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    padding=<span class="hljs-literal">True</span>,
)

adapter_names = [
    <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>,
    <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>,
    <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>,
]
output = peft_model.generate(**inputs, adapter_names=adapter_names, max_new_tokens=<span class="hljs-number">20</span>)`,wrap:!1}}),Be=new y({props:{title:"Caveats",local:"caveats",headingTag:"h3"}}),We=new Ea({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/lora.md"}}),{c(){c=i("meta"),T=s(),M=i("p"),b=s(),p(_.$$.fragment),Xe=s(),Z=i("p"),Z.innerHTML=Kt,Ae=s(),j=i("p"),j.textContent=Ot,Qe=s(),p($.$$.fragment),qe=s(),U=i("p"),U.innerHTML=ea,Ve=s(),k=i("p"),k.innerHTML=ta,Fe=s(),p(v.$$.fragment),He=s(),R=i("p"),R.innerHTML=aa,Ee=s(),p(B.$$.fragment),ze=s(),p(I.$$.fragment),xe=s(),p(C.$$.fragment),Ye=s(),W=i("p"),W.innerHTML=la,Ne=s(),L=i("p"),L.innerHTML=sa,Se=s(),p(G.$$.fragment),Pe=s(),X=i("p"),X.innerHTML=na,De=s(),p(A.$$.fragment),Ke=s(),Q=i("p"),Q.innerHTML=ia,Oe=s(),q=i("p"),q.innerHTML=oa,et=s(),V=i("p"),V.innerHTML=ra,tt=s(),F=i("ul"),F.innerHTML=pa,at=s(),p(g.$$.fragment),lt=s(),p(H.$$.fragment),st=s(),E=i("p"),E.innerHTML=da,nt=s(),p(z.$$.fragment),it=s(),p(x.$$.fragment),ot=s(),Y=i("p"),Y.innerHTML=ma,rt=s(),p(N.$$.fragment),pt=s(),p(S.$$.fragment),dt=s(),P=i("ul"),P.innerHTML=ha,mt=s(),p(D.$$.fragment),ht=s(),K=i("p"),K.innerHTML=fa,ft=s(),p(O.$$.fragment),ut=s(),p(ee.$$.fragment),ct=s(),te=i("p"),te.innerHTML=ua,Mt=s(),p(ae.$$.fragment),wt=s(),le=i("p"),le.innerHTML=ca,yt=s(),se=i("p"),se.innerHTML=Ma,Tt=s(),p(ne.$$.fragment),bt=s(),ie=i("p"),ie.innerHTML=wa,gt=s(),p(oe.$$.fragment),Jt=s(),re=i("p"),re.innerHTML=ya,_t=s(),p(pe.$$.fragment),Zt=s(),de=i("p"),de.innerHTML=Ta,jt=s(),me=i("p"),me.textContent=ba,$t=s(),p(he.$$.fragment),Ut=s(),fe=i("p"),fe.textContent=ga,kt=s(),p(ue.$$.fragment),vt=s(),ce=i("p"),ce.textContent=Ja,Rt=s(),p(Me.$$.fragment),Bt=s(),p(J.$$.fragment),It=s(),we=i("p"),we.textContent=_a,Ct=s(),p(ye.$$.fragment),Wt=s(),p(Te.$$.fragment),Lt=s(),be=i("p"),be.innerHTML=Za,Gt=s(),p(ge.$$.fragment),Xt=s(),Je=i("p"),Je.innerHTML=ja,At=s(),p(_e.$$.fragment),Qt=s(),p(Ze.$$.fragment),qt=s(),je=i("p"),je.textContent=$a,Vt=s(),$e=i("p"),$e.innerHTML=Ua,Ft=s(),p(Ue.$$.fragment),Ht=s(),ke=i("p"),ke.innerHTML=ka,Et=s(),p(ve.$$.fragment),zt=s(),Re=i("p"),Re.innerHTML=va,xt=s(),p(Be.$$.fragment),Yt=s(),Ie=i("p"),Ie.textContent=Ra,Nt=s(),Ce=i("ul"),Ce.innerHTML=Ba,St=s(),p(We.$$.fragment),Pt=s(),Ge=i("p"),this.h()},l(e){const t=Fa("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(a),T=n(e),M=o(e,"P",{}),Wa(M).forEach(a),b=n(e),d(_.$$.fragment,e),Xe=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-38uxl6"&&(Z.innerHTML=Kt),Ae=n(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-ovsn32"&&(j.textContent=Ot),Qe=n(e),d($.$$.fragment,e),qe=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-j883mf"&&(U.innerHTML=ea),Ve=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1fujb7a"&&(k.innerHTML=ta),Fe=n(e),d(v.$$.fragment,e),He=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-mwvui1"&&(R.innerHTML=aa),Ee=n(e),d(B.$$.fragment,e),ze=n(e),d(I.$$.fragment,e),xe=n(e),d(C.$$.fragment,e),Ye=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1ts8vpq"&&(W.innerHTML=la),Ne=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-7f0aai"&&(L.innerHTML=sa),Se=n(e),d(G.$$.fragment,e),Pe=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-14vtcq9"&&(X.innerHTML=na),De=n(e),d(A.$$.fragment,e),Ke=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1nywyxh"&&(Q.innerHTML=ia),Oe=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1d2jix1"&&(q.innerHTML=oa),et=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-yl8kok"&&(V.innerHTML=ra),tt=n(e),F=o(e,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-12tl4fy"&&(F.innerHTML=pa),at=n(e),d(g.$$.fragment,e),lt=n(e),d(H.$$.fragment,e),st=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-omuw13"&&(E.innerHTML=da),nt=n(e),d(z.$$.fragment,e),it=n(e),d(x.$$.fragment,e),ot=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1ukfkwt"&&(Y.innerHTML=ma),rt=n(e),d(N.$$.fragment,e),pt=n(e),d(S.$$.fragment,e),dt=n(e),P=o(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-1lkjk8m"&&(P.innerHTML=ha),mt=n(e),d(D.$$.fragment,e),ht=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-15vxux2"&&(K.innerHTML=fa),ft=n(e),d(O.$$.fragment,e),ut=n(e),d(ee.$$.fragment,e),ct=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1mosto0"&&(te.innerHTML=ua),Mt=n(e),d(ae.$$.fragment,e),wt=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1safyei"&&(le.innerHTML=ca),yt=n(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-foj0wd"&&(se.innerHTML=Ma),Tt=n(e),d(ne.$$.fragment,e),bt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1c3h9aa"&&(ie.innerHTML=wa),gt=n(e),d(oe.$$.fragment,e),Jt=n(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-m3cr6r"&&(re.innerHTML=ya),_t=n(e),d(pe.$$.fragment,e),Zt=n(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-kbqhpl"&&(de.innerHTML=Ta),jt=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1mwdwt1"&&(me.textContent=ba),$t=n(e),d(he.$$.fragment,e),Ut=n(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-nuhu05"&&(fe.textContent=ga),kt=n(e),d(ue.$$.fragment,e),vt=n(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1n53hd9"&&(ce.textContent=Ja),Rt=n(e),d(Me.$$.fragment,e),Bt=n(e),d(J.$$.fragment,e),It=n(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-qwbdkg"&&(we.textContent=_a),Ct=n(e),d(ye.$$.fragment,e),Wt=n(e),d(Te.$$.fragment,e),Lt=n(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-ke62q2"&&(be.innerHTML=Za),Gt=n(e),d(ge.$$.fragment,e),Xt=n(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-cvmoj6"&&(Je.innerHTML=ja),At=n(e),d(_e.$$.fragment,e),Qt=n(e),d(Ze.$$.fragment,e),qt=n(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1fq5tpu"&&(je.textContent=$a),Vt=n(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-6zt8d6"&&($e.innerHTML=Ua),Ft=n(e),d(Ue.$$.fragment,e),Ht=n(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-6wkyom"&&(ke.innerHTML=ka),Et=n(e),d(ve.$$.fragment,e),zt=n(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1o40ch6"&&(Re.innerHTML=va),xt=n(e),d(Be.$$.fragment,e),Yt=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-fpz5mj"&&(Ie.textContent=Ra),Nt=n(e),Ce=o(e,"UL",{"data-svelte-h":!0}),r(Ce)!=="svelte-1jk1r7d"&&(Ce.innerHTML=Ba),St=n(e),d(We.$$.fragment,e),Pt=n(e),Ge=o(e,"P",{}),Wa(Ge).forEach(a),this.h()},h(){La(c,"name","hf:doc:metadata"),La(c,"content",Na)},m(e,t){Ha(document.head,c),l(e,T,t),l(e,M,t),l(e,b,t),m(_,e,t),l(e,Xe,t),l(e,Z,t),l(e,Ae,t),l(e,j,t),l(e,Qe,t),m($,e,t),l(e,qe,t),l(e,U,t),l(e,Ve,t),l(e,k,t),l(e,Fe,t),m(v,e,t),l(e,He,t),l(e,R,t),l(e,Ee,t),m(B,e,t),l(e,ze,t),m(I,e,t),l(e,xe,t),m(C,e,t),l(e,Ye,t),l(e,W,t),l(e,Ne,t),l(e,L,t),l(e,Se,t),m(G,e,t),l(e,Pe,t),l(e,X,t),l(e,De,t),m(A,e,t),l(e,Ke,t),l(e,Q,t),l(e,Oe,t),l(e,q,t),l(e,et,t),l(e,V,t),l(e,tt,t),l(e,F,t),l(e,at,t),m(g,e,t),l(e,lt,t),m(H,e,t),l(e,st,t),l(e,E,t),l(e,nt,t),m(z,e,t),l(e,it,t),m(x,e,t),l(e,ot,t),l(e,Y,t),l(e,rt,t),m(N,e,t),l(e,pt,t),m(S,e,t),l(e,dt,t),l(e,P,t),l(e,mt,t),m(D,e,t),l(e,ht,t),l(e,K,t),l(e,ft,t),m(O,e,t),l(e,ut,t),m(ee,e,t),l(e,ct,t),l(e,te,t),l(e,Mt,t),m(ae,e,t),l(e,wt,t),l(e,le,t),l(e,yt,t),l(e,se,t),l(e,Tt,t),m(ne,e,t),l(e,bt,t),l(e,ie,t),l(e,gt,t),m(oe,e,t),l(e,Jt,t),l(e,re,t),l(e,_t,t),m(pe,e,t),l(e,Zt,t),l(e,de,t),l(e,jt,t),l(e,me,t),l(e,$t,t),m(he,e,t),l(e,Ut,t),l(e,fe,t),l(e,kt,t),m(ue,e,t),l(e,vt,t),l(e,ce,t),l(e,Rt,t),m(Me,e,t),l(e,Bt,t),m(J,e,t),l(e,It,t),l(e,we,t),l(e,Ct,t),m(ye,e,t),l(e,Wt,t),m(Te,e,t),l(e,Lt,t),l(e,be,t),l(e,Gt,t),m(ge,e,t),l(e,Xt,t),l(e,Je,t),l(e,At,t),m(_e,e,t),l(e,Qt,t),m(Ze,e,t),l(e,qt,t),l(e,je,t),l(e,Vt,t),l(e,$e,t),l(e,Ft,t),m(Ue,e,t),l(e,Ht,t),l(e,ke,t),l(e,Et,t),m(ve,e,t),l(e,zt,t),l(e,Re,t),l(e,xt,t),m(Be,e,t),l(e,Yt,t),l(e,Ie,t),l(e,Nt,t),l(e,Ce,t),l(e,St,t),m(We,e,t),l(e,Pt,t),l(e,Ge,t),Dt=!0},p(e,[t]){const Ia={};t&2&&(Ia.$$scope={dirty:t,ctx:e}),g.$set(Ia);const Ca={};t&2&&(Ca.$$scope={dirty:t,ctx:e}),J.$set(Ca)},i(e){Dt||(h(_.$$.fragment,e),h($.$$.fragment,e),h(v.$$.fragment,e),h(B.$$.fragment,e),h(I.$$.fragment,e),h(C.$$.fragment,e),h(G.$$.fragment,e),h(A.$$.fragment,e),h(g.$$.fragment,e),h(H.$$.fragment,e),h(z.$$.fragment,e),h(x.$$.fragment,e),h(N.$$.fragment,e),h(S.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(ae.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(pe.$$.fragment,e),h(he.$$.fragment,e),h(ue.$$.fragment,e),h(Me.$$.fragment,e),h(J.$$.fragment,e),h(ye.$$.fragment,e),h(Te.$$.fragment,e),h(ge.$$.fragment,e),h(_e.$$.fragment,e),h(Ze.$$.fragment,e),h(Ue.$$.fragment,e),h(ve.$$.fragment,e),h(Be.$$.fragment,e),h(We.$$.fragment,e),Dt=!0)},o(e){f(_.$$.fragment,e),f($.$$.fragment,e),f(v.$$.fragment,e),f(B.$$.fragment,e),f(I.$$.fragment,e),f(C.$$.fragment,e),f(G.$$.fragment,e),f(A.$$.fragment,e),f(g.$$.fragment,e),f(H.$$.fragment,e),f(z.$$.fragment,e),f(x.$$.fragment,e),f(N.$$.fragment,e),f(S.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),f(ee.$$.fragment,e),f(ae.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(pe.$$.fragment,e),f(he.$$.fragment,e),f(ue.$$.fragment,e),f(Me.$$.fragment,e),f(J.$$.fragment,e),f(ye.$$.fragment,e),f(Te.$$.fragment,e),f(ge.$$.fragment,e),f(_e.$$.fragment,e),f(Ze.$$.fragment,e),f(Ue.$$.fragment,e),f(ve.$$.fragment,e),f(Be.$$.fragment,e),f(We.$$.fragment,e),Dt=!1},d(e){e&&(a(T),a(M),a(b),a(Xe),a(Z),a(Ae),a(j),a(Qe),a(qe),a(U),a(Ve),a(k),a(Fe),a(He),a(R),a(Ee),a(ze),a(xe),a(Ye),a(W),a(Ne),a(L),a(Se),a(Pe),a(X),a(De),a(Ke),a(Q),a(Oe),a(q),a(et),a(V),a(tt),a(F),a(at),a(lt),a(st),a(E),a(nt),a(it),a(ot),a(Y),a(rt),a(pt),a(dt),a(P),a(mt),a(ht),a(K),a(ft),a(ut),a(ct),a(te),a(Mt),a(wt),a(le),a(yt),a(se),a(Tt),a(bt),a(ie),a(gt),a(Jt),a(re),a(_t),a(Zt),a(de),a(jt),a(me),a($t),a(Ut),a(fe),a(kt),a(vt),a(ce),a(Rt),a(Bt),a(It),a(we),a(Ct),a(Wt),a(Lt),a(be),a(Gt),a(Xt),a(Je),a(At),a(Qt),a(qt),a(je),a(Vt),a($e),a(Ft),a(Ht),a(ke),a(Et),a(zt),a(Re),a(xt),a(Yt),a(Ie),a(Nt),a(Ce),a(St),a(Pt),a(Ge)),a(c),u(_,e),u($,e),u(v,e),u(B,e),u(I,e),u(C,e),u(G,e),u(A,e),u(g,e),u(H,e),u(z,e),u(x,e),u(N,e),u(S,e),u(D,e),u(O,e),u(ee,e),u(ae,e),u(ne,e),u(oe,e),u(pe,e),u(he,e),u(ue,e),u(Me,e),u(J,e),u(ye,e),u(Te,e),u(ge,e),u(_e,e),u(Ze,e),u(Ue,e),u(ve,e),u(Be,e),u(We,e)}}}const Na='{"title":"LoRA","local":"lora","sections":[{"title":"Initialization","local":"initialization","sections":[{"title":"LoftQ","local":"loftq","sections":[{"title":"Standard approach","local":"standard-approach","sections":[],"depth":4},{"title":"A more convienient way","local":"a-more-convienient-way","sections":[],"depth":4}],"depth":3},{"title":"Rank-stabilized LoRA","local":"rank-stabilized-lora","sections":[],"depth":3},{"title":"Weight-Decomposed Low-Rank Adaptation (DoRA)","local":"weight-decomposed-low-rank-adaptation-dora","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":4}],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3},{"title":"Memory efficient Layer Replication with LoRA","local":"memory-efficient-layer-replication-with-lora","sections":[],"depth":3}],"depth":2},{"title":"Merge adapters","local":"merge-adapters","sections":[],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[],"depth":2},{"title":"Inference with different LoRA adapters in the same batch","local":"inference-with-different-lora-adapters-in-the-same-batch","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":3}],"depth":2}],"depth":1}';function Sa(Le){return Qa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tl extends qa{constructor(c){super(),Va(this,c,Sa,Ya,Aa,{})}}export{tl as component};
