import{s as Ce,n as Le,o as Be}from"../chunks/scheduler.c57aa7ef.js";import{S as ze,i as Qe,g as s,s as n,r as p,A as ke,h as o,f as l,c as i,j as qe,u as m,x as r,k as ve,y as Ze,a,v as f,d as u,t as d,w as h}from"../chunks/index.c50cb18e.js";import{C as M}from"../chunks/CodeBlock.34f0a53d.js";import{H as b,E as Ue}from"../chunks/EditOnGithub.958a8a49.js";function xe(ee){let c,pt,ot,mt,g,ft,w,le="Quantization represents data with fewer bits, making it a useful technique for reducing memory-usage and accelerating inference especially when it comes to large language models (LLMs). There are several ways to quantize a model including:",ut,y,ae='<li>optimizing which model weights are quantized with the <a href="https://hf.co/papers/2306.00978" rel="nofollow">AWQ</a> algorithm</li> <li>independently quantizing each row of a weight matrix with the <a href="https://hf.co/papers/2210.17323" rel="nofollow">GPTQ</a> algorithm</li> <li>quantizing to 8-bit and 4-bit precision with the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> library</li> <li>quantizing to as low as 2-bit precision with the <a href="https://arxiv.org/abs/2401.06118" rel="nofollow">AQLM</a> algorithm</li>',dt,T,ne='However, after a model is quantized it isn’t typically further trained for downstream tasks because training can be unstable due to the lower precision of the weights and activations. But since PEFT methods only add <em>extra</em> trainable parameters, this allows you to train a quantized model with a PEFT adapter on top! Combining quantization with PEFT can be a good strategy for training even the largest models on a single GPU. For example, <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> is a method that quantizes a model to 4-bits and then trains it with LoRA. This method allows you to finetune a 65B parameter model on a single 48GB GPU!',ht,J,ie="In this guide, you’ll see how to quantize a model to 4-bits and train it with LoRA.",Mt,_,ct,$,se='<a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> is a quantization library with a Transformers integration. With this integration, you can quantize a model to 8 or 4-bits and enable many other options by configuring the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a> class. For example, you can:',bt,j,oe="<li>set <code>load_in_4bit=True</code> to quantize the model to 4-bits when you load it</li> <li>set <code>bnb_4bit_quant_type=&quot;nf4&quot;</code> to use a special 4-bit data type for weights initialized from a normal distribution</li> <li>set <code>bnb_4bit_use_double_quant=True</code> to use a nested quantization scheme to quantize the already quantized weights</li> <li>set <code>bnb_4bit_compute_dtype=torch.bfloat16</code> to use bfloat16 for faster computation</li>",gt,q,wt,v,re='Pass the <code>config</code> to the <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method.',yt,C,Tt,L,pe='Next, you should call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.prepare_model_for_kbit_training">prepare_model_for_kbit_training()</a> function to preprocess the quantized model for training.',Jt,B,_t,z,me="Now that the quantized model is ready, let’s set up a configuration.",$t,Q,jt,k,fe='Create a <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> with the following parameters (or choose your own):',qt,Z,vt,U,ue='Then use the <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function to create a <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> from the quantized model and configuration.',Ct,x,Lt,I,de="You’re all set for training with whichever training method you prefer!",Bt,A,zt,W,he='<a href="https://hf.co/papers/2310.08659" rel="nofollow">LoftQ</a> initializes LoRA weights such that the quantization error is minimized, and it can improve performance when training quantized models. To get started, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',Qt,E,Me="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",kt,R,Zt,X,ce="QLoRA adds trainable weights to all the linear layers in the transformer architecture. Since the attribute names for these linear layers can vary across architectures, set <code>target_modules</code> to <code>&quot;all-linear&quot;</code> to add LoRA to all the linear layers:",Ut,H,xt,G,It,F,be='Additive Quantization of Language Models (<a href="https://arxiv.org/abs/2401.06118" rel="nofollow">AQLM</a>) is a Large Language Models compression method. It quantizes multiple weights together and takes advantage of interdependencies between them. AQLM represents groups of 8-16 weights as a sum of multiple vector codes. This allows it to compress models down to as low as 2-bit with considerably low accuracy losses.',At,N,ge='Since the AQLM quantization process is computationally expensive, a use of prequantized models is recommended. A partial list of available models can be found in the official aqlm <a href="https://github.com/Vahe1994/AQLM" rel="nofollow">repository</a>.',Wt,V,we="The models support LoRA adapter tuning. To tune the quantized model you’ll need to install the <code>aqlm</code> inference library: <code>pip install aqlm&gt;=1.0.2</code>. Finetuned LoRA adapters shall be saved separately, as merging them with AQLM quantized weights is not possible.",Et,Y,Rt,P,ye='You can refer to the <a href="https://colab.research.google.com/drive/12GTp1FCj5_0SnnNQH18h_2XFh9vS_guX?usp=sharing" rel="nofollow">Google Colab</a> example for an overview of AQLM+LoRA finetuning.',Xt,S,Ht,D,Te='You can also perform LoRA fine-tuning on EETQ quantized models. <a href="https://github.com/NetEase-FuXi/EETQ" rel="nofollow">EETQ</a> package offers simple and efficient way to perform 8-bit quantization, which is claimed to be faster than the <code>LLM.int8()</code> algorithm. First, make sure that you have a transformers version that is compatible with EETQ (e.g. by installing it from latest pypi or from source).',Gt,K,Ft,O,Je='Pass the <code>config</code> to the <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method.',Nt,tt,Vt,et,_e="and create a <code>LoraConfig</code> and pass it to <code>get_peft_model</code>:",Yt,lt,Pt,at,St,nt,$e="If you’re interested in learning more about quantization, the following may be helpful:",Dt,it,je='<li>Learn more about details about QLoRA and check out some benchmarks on its impact in the <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">Making LLMs even more accessible with bitsandbytes, 4-bit quantization and QLoRA</a> blog post.</li> <li>Read more about different quantization schemes in the Transformers <a href="https://hf.co/docs/transformers/main/quantization" rel="nofollow">Quantization</a> guide.</li>',Kt,st,Ot,rt,te;return g=new b({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),_=new b({props:{title:"Quantize a model",local:"quantize-a-model",headingTag:"h2"}}),q=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
)`,wrap:!1}}),C=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=config)`,wrap:!1}}),B=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nJTBBJTBBbW9kZWwlMjAlM0QlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nKG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> prepare_model_for_kbit_training

model = prepare_model_for_kbit_training(model)`,wrap:!1}}),Q=new b({props:{title:"LoraConfig",local:"loraconfig",headingTag:"h2"}}),Z=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJTIyb19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4wNSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)`,wrap:!1}}),x=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = get_peft_model(model, config)`,wrap:!1}}),A=new b({props:{title:"LoftQ initialization",local:"loftq-initialization",headingTag:"h3"}}),R=new b({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),H=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),G=new b({props:{title:"AQLM quantization",local:"aqlm-quantization",headingTag:"h2"}}),Y=new M({props:{code:"cXVhbnRpemVkX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkJsYWNrU2Ftb3JleiUyRk1peHRyYWwtOHg3Yi1BUUxNLTJCaXQtMXgxNi1oZi10ZXN0LWRpc3BhdGNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUlMkMlMEEpJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEElMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`quantized_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;BlackSamorez/Mixtral-8x7b-AQLM-2Bit-1x16-hf-test-dispatch&quot;</span>,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, low_cpu_mem_usage=<span class="hljs-literal">True</span>,
)

peft_config = LoraConfig(...)

quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),S=new b({props:{title:"EETQ quantization",local:"eetq-quantization",headingTag:"h2"}}),K=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwRWV0cUNvbmZpZyUwQSUwQWNvbmZpZyUyMCUzRCUyMEVldHFDb25maWcoJTIyaW50OCUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> EetqConfig

config = EetqConfig(<span class="hljs-string">&quot;int8&quot;</span>)`,wrap:!1}}),tt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=config)`,wrap:!1}}),lt=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0Q4JTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X21vZHVsZXMlM0QlNUIlMjJxX3Byb2olMjIlMkMlMjAlMjJrX3Byb2olMjIlMkMlMjAlMjJ2X3Byb2olMjIlMkMlMjAlMjJvX3Byb2olMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

model = get_peft_model(model, config)`,wrap:!1}}),at=new b({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),st=new Ue({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/quantization.md"}}),{c(){c=s("meta"),pt=n(),ot=s("p"),mt=n(),p(g.$$.fragment),ft=n(),w=s("p"),w.textContent=le,ut=n(),y=s("ul"),y.innerHTML=ae,dt=n(),T=s("p"),T.innerHTML=ne,ht=n(),J=s("p"),J.textContent=ie,Mt=n(),p(_.$$.fragment),ct=n(),$=s("p"),$.innerHTML=se,bt=n(),j=s("ul"),j.innerHTML=oe,gt=n(),p(q.$$.fragment),wt=n(),v=s("p"),v.innerHTML=re,yt=n(),p(C.$$.fragment),Tt=n(),L=s("p"),L.innerHTML=pe,Jt=n(),p(B.$$.fragment),_t=n(),z=s("p"),z.textContent=me,$t=n(),p(Q.$$.fragment),jt=n(),k=s("p"),k.innerHTML=fe,qt=n(),p(Z.$$.fragment),vt=n(),U=s("p"),U.innerHTML=ue,Ct=n(),p(x.$$.fragment),Lt=n(),I=s("p"),I.textContent=de,Bt=n(),p(A.$$.fragment),zt=n(),W=s("p"),W.innerHTML=he,Qt=n(),E=s("p"),E.innerHTML=Me,kt=n(),p(R.$$.fragment),Zt=n(),X=s("p"),X.innerHTML=ce,Ut=n(),p(H.$$.fragment),xt=n(),p(G.$$.fragment),It=n(),F=s("p"),F.innerHTML=be,At=n(),N=s("p"),N.innerHTML=ge,Wt=n(),V=s("p"),V.innerHTML=we,Et=n(),p(Y.$$.fragment),Rt=n(),P=s("p"),P.innerHTML=ye,Xt=n(),p(S.$$.fragment),Ht=n(),D=s("p"),D.innerHTML=Te,Gt=n(),p(K.$$.fragment),Ft=n(),O=s("p"),O.innerHTML=Je,Nt=n(),p(tt.$$.fragment),Vt=n(),et=s("p"),et.innerHTML=_e,Yt=n(),p(lt.$$.fragment),Pt=n(),p(at.$$.fragment),St=n(),nt=s("p"),nt.textContent=$e,Dt=n(),it=s("ul"),it.innerHTML=je,Kt=n(),p(st.$$.fragment),Ot=n(),rt=s("p"),this.h()},l(t){const e=ke("svelte-u9bgzb",document.head);c=o(e,"META",{name:!0,content:!0}),e.forEach(l),pt=i(t),ot=o(t,"P",{}),qe(ot).forEach(l),mt=i(t),m(g.$$.fragment,t),ft=i(t),w=o(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-famg4s"&&(w.textContent=le),ut=i(t),y=o(t,"UL",{"data-svelte-h":!0}),r(y)!=="svelte-27c91"&&(y.innerHTML=ae),dt=i(t),T=o(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-142xot4"&&(T.innerHTML=ne),ht=i(t),J=o(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1demhiu"&&(J.textContent=ie),Mt=i(t),m(_.$$.fragment,t),ct=i(t),$=o(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-p0gbf4"&&($.innerHTML=se),bt=i(t),j=o(t,"UL",{"data-svelte-h":!0}),r(j)!=="svelte-hfynw8"&&(j.innerHTML=oe),gt=i(t),m(q.$$.fragment,t),wt=i(t),v=o(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-pxonbi"&&(v.innerHTML=re),yt=i(t),m(C.$$.fragment,t),Tt=i(t),L=o(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1i20kxq"&&(L.innerHTML=pe),Jt=i(t),m(B.$$.fragment,t),_t=i(t),z=o(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-11mx7fc"&&(z.textContent=me),$t=i(t),m(Q.$$.fragment,t),jt=i(t),k=o(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-16xpk8c"&&(k.innerHTML=fe),qt=i(t),m(Z.$$.fragment,t),vt=i(t),U=o(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-rnh6oi"&&(U.innerHTML=ue),Ct=i(t),m(x.$$.fragment,t),Lt=i(t),I=o(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-xd402n"&&(I.textContent=de),Bt=i(t),m(A.$$.fragment,t),zt=i(t),W=o(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-f32n60"&&(W.innerHTML=he),Qt=i(t),E=o(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-7f0aai"&&(E.innerHTML=Me),kt=i(t),m(R.$$.fragment,t),Zt=i(t),X=o(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1c7jiea"&&(X.innerHTML=ce),Ut=i(t),m(H.$$.fragment,t),xt=i(t),m(G.$$.fragment,t),It=i(t),F=o(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-h7ytse"&&(F.innerHTML=be),At=i(t),N=o(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-120mr43"&&(N.innerHTML=ge),Wt=i(t),V=o(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-wlm3ol"&&(V.innerHTML=we),Et=i(t),m(Y.$$.fragment,t),Rt=i(t),P=o(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1f1bzer"&&(P.innerHTML=ye),Xt=i(t),m(S.$$.fragment,t),Ht=i(t),D=o(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-16tz5mo"&&(D.innerHTML=Te),Gt=i(t),m(K.$$.fragment,t),Ft=i(t),O=o(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-pxonbi"&&(O.innerHTML=Je),Nt=i(t),m(tt.$$.fragment,t),Vt=i(t),et=o(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1wgonl8"&&(et.innerHTML=_e),Yt=i(t),m(lt.$$.fragment,t),Pt=i(t),m(at.$$.fragment,t),St=i(t),nt=o(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-agdyn7"&&(nt.textContent=$e),Dt=i(t),it=o(t,"UL",{"data-svelte-h":!0}),r(it)!=="svelte-83nivc"&&(it.innerHTML=je),Kt=i(t),m(st.$$.fragment,t),Ot=i(t),rt=o(t,"P",{}),qe(rt).forEach(l),this.h()},h(){ve(c,"name","hf:doc:metadata"),ve(c,"content",Ie)},m(t,e){Ze(document.head,c),a(t,pt,e),a(t,ot,e),a(t,mt,e),f(g,t,e),a(t,ft,e),a(t,w,e),a(t,ut,e),a(t,y,e),a(t,dt,e),a(t,T,e),a(t,ht,e),a(t,J,e),a(t,Mt,e),f(_,t,e),a(t,ct,e),a(t,$,e),a(t,bt,e),a(t,j,e),a(t,gt,e),f(q,t,e),a(t,wt,e),a(t,v,e),a(t,yt,e),f(C,t,e),a(t,Tt,e),a(t,L,e),a(t,Jt,e),f(B,t,e),a(t,_t,e),a(t,z,e),a(t,$t,e),f(Q,t,e),a(t,jt,e),a(t,k,e),a(t,qt,e),f(Z,t,e),a(t,vt,e),a(t,U,e),a(t,Ct,e),f(x,t,e),a(t,Lt,e),a(t,I,e),a(t,Bt,e),f(A,t,e),a(t,zt,e),a(t,W,e),a(t,Qt,e),a(t,E,e),a(t,kt,e),f(R,t,e),a(t,Zt,e),a(t,X,e),a(t,Ut,e),f(H,t,e),a(t,xt,e),f(G,t,e),a(t,It,e),a(t,F,e),a(t,At,e),a(t,N,e),a(t,Wt,e),a(t,V,e),a(t,Et,e),f(Y,t,e),a(t,Rt,e),a(t,P,e),a(t,Xt,e),f(S,t,e),a(t,Ht,e),a(t,D,e),a(t,Gt,e),f(K,t,e),a(t,Ft,e),a(t,O,e),a(t,Nt,e),f(tt,t,e),a(t,Vt,e),a(t,et,e),a(t,Yt,e),f(lt,t,e),a(t,Pt,e),f(at,t,e),a(t,St,e),a(t,nt,e),a(t,Dt,e),a(t,it,e),a(t,Kt,e),f(st,t,e),a(t,Ot,e),a(t,rt,e),te=!0},p:Le,i(t){te||(u(g.$$.fragment,t),u(_.$$.fragment,t),u(q.$$.fragment,t),u(C.$$.fragment,t),u(B.$$.fragment,t),u(Q.$$.fragment,t),u(Z.$$.fragment,t),u(x.$$.fragment,t),u(A.$$.fragment,t),u(R.$$.fragment,t),u(H.$$.fragment,t),u(G.$$.fragment,t),u(Y.$$.fragment,t),u(S.$$.fragment,t),u(K.$$.fragment,t),u(tt.$$.fragment,t),u(lt.$$.fragment,t),u(at.$$.fragment,t),u(st.$$.fragment,t),te=!0)},o(t){d(g.$$.fragment,t),d(_.$$.fragment,t),d(q.$$.fragment,t),d(C.$$.fragment,t),d(B.$$.fragment,t),d(Q.$$.fragment,t),d(Z.$$.fragment,t),d(x.$$.fragment,t),d(A.$$.fragment,t),d(R.$$.fragment,t),d(H.$$.fragment,t),d(G.$$.fragment,t),d(Y.$$.fragment,t),d(S.$$.fragment,t),d(K.$$.fragment,t),d(tt.$$.fragment,t),d(lt.$$.fragment,t),d(at.$$.fragment,t),d(st.$$.fragment,t),te=!1},d(t){t&&(l(pt),l(ot),l(mt),l(ft),l(w),l(ut),l(y),l(dt),l(T),l(ht),l(J),l(Mt),l(ct),l($),l(bt),l(j),l(gt),l(wt),l(v),l(yt),l(Tt),l(L),l(Jt),l(_t),l(z),l($t),l(jt),l(k),l(qt),l(vt),l(U),l(Ct),l(Lt),l(I),l(Bt),l(zt),l(W),l(Qt),l(E),l(kt),l(Zt),l(X),l(Ut),l(xt),l(It),l(F),l(At),l(N),l(Wt),l(V),l(Et),l(Rt),l(P),l(Xt),l(Ht),l(D),l(Gt),l(Ft),l(O),l(Nt),l(Vt),l(et),l(Yt),l(Pt),l(St),l(nt),l(Dt),l(it),l(Kt),l(Ot),l(rt)),l(c),h(g,t),h(_,t),h(q,t),h(C,t),h(B,t),h(Q,t),h(Z,t),h(x,t),h(A,t),h(R,t),h(H,t),h(G,t),h(Y,t),h(S,t),h(K,t),h(tt,t),h(lt,t),h(at,t),h(st,t)}}}const Ie='{"title":"Quantization","local":"quantization","sections":[{"title":"Quantize a model","local":"quantize-a-model","sections":[],"depth":2},{"title":"LoraConfig","local":"loraconfig","sections":[{"title":"LoftQ initialization","local":"loftq-initialization","sections":[],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3}],"depth":2},{"title":"AQLM quantization","local":"aqlm-quantization","sections":[],"depth":2},{"title":"EETQ quantization","local":"eetq-quantization","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Ae(ee){return Be(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class He extends ze{constructor(c){super(),Qe(this,c,Ae,xe,Ce,{})}}export{He as component};
