import{s as Qt,n as Nt,o as qt}from"../chunks/scheduler.c57aa7ef.js";import{S as At,i as Kt,g as i,s as l,r as p,A as Dt,h as r,f as s,c as n,j as zt,u as d,x as o,k as St,y as Ot,a,v as m,d as h,t as c,w as f}from"../chunks/index.c50cb18e.js";import{C as u}from"../chunks/CodeBlock.34f0a53d.js";import{H as y,E as es}from"../chunks/EditOnGithub.958a8a49.js";function ts(ut){let g,ge,fe,ye,w,we,M,gt="If you encounter any issue when using PEFT, please check the following list of common issues and their solutions.",Me,b,be,_,yt="Examples often rely on the most recent package versions, so please ensure they’re up-to-date. In particular, check the following package versions:",_e,T,wt="<li><code>peft</code></li> <li><code>transformers</code></li> <li><code>accelerate</code></li> <li><code>torch</code></li>",Te,j,Mt="In general, you can update the package version by running this command inside your Python environment:",je,x,xe,v,bt="Installing PEFT from source is useful for keeping up with the latest developments:",ve,$,$e,J,Je,Z,_t='This error probably occurred because the model was loaded with <code>torch_dtype=torch.float16</code> and then used in an automatic mixed precision (AMP) context, e.g. by setting <code>fp16=True</code> in the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class from 🤗 Transformers. The reason is that when using AMP, trainable weights should never use fp16. To make this work without loading the whole model in fp32, add the following to your code:',Ze,k,ke,U,Tt='Alternatively, you can use the <a href="/docs/peft/main/en/package_reference/peft_model#peft.cast_mixed_precision_params">cast_mixed_precision_params()</a> function to correctly cast the weights:',Ue,C,Ce,W,We,B,jt='There can be several reasons for getting a poor result from a loaded PEFT model which are listed below. If you’re still unable to troubleshoot the problem, see if anyone else had a similar <a href="https://github.com/huggingface/peft/issues" rel="nofollow">issue</a> on GitHub, and if you can’t find any, open a new issue.',Be,G,xt="When opening an issue, it helps a lot if you provide a minimal code example that reproduces the issue. Also, please report if the loaded model performs at the same level as the model did before fine-tuning, if it performs at a random level, or if it is only slightly worse than expected. This information helps us identify the problem more quickly.",Ge,R,Re,F,vt="If your model outputs are not exactly the same as previous runs, there could be an issue with random elements. For example:",Fe,I,$t='<li>please ensure it is in <code>.eval()</code> mode, which is important, for instance, if the model uses dropout</li> <li>if you use <a href="https://huggingface.co/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate" rel="nofollow">generate</a> on a language model, there could be random sampling, so obtaining the same result requires setting a random seed</li> <li>if you used quantization and merged the weights, small deviations are expected due to rounding errors</li>',Ie,H,He,X,Jt='Please ensure that you load the model correctly. A common error is trying to load a <em>trained</em> model with <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> which is incorrect. Instead, the loading code should look like this:',Xe,V,Ve,L,Le,Y,Zt="For some tasks, it is important to correctly configure <code>modules_to_save</code> in the config to account for randomly initialized layers.",Ye,E,kt="As an example, this is necessary if you use LoRA to fine-tune a language model for sequence classification because 🤗 Transformers adds a randomly initialized classification head on top of the model. If you do not add this layer to <code>modules_to_save</code>, the classification head won’t be saved. The next time you load the model, you’ll get a <em>different</em> randomly initialized classification head, resulting in completely different results.",Ee,P,Ut="PEFT tries to correctly guess the <code>modules_to_save</code> if you provide the <code>task_type</code> argument in the config. This should work for transformers models that follow the standard naming scheme. It is always a good idea to double check though because we can’t guarantee all models follow the naming scheme.",Pe,z,Ct="When you load a transformers model that has randomly initialized layers, you should see a warning along the lines of:",ze,S,Se,Q,Wt="The mentioned layers should be added to <code>modules_to_save</code> in the config to avoid the described problem.",Qe,N,Ne,q,Bt="For many language fine-tuning tasks, extending the model’s vocabulary is necessary since new tokens are being introduced. This requires extending the embedding layer to account for the new tokens and also storing the embedding layer in addition to the adapter weights when saving the adapter.",qe,A,Gt="Save the embedding layer by adding it to the <code>target_modules</code> of the config. The embedding layer name must follow the standard naming scheme from Transformers. For example, the Mistral config could look like this:",Ae,K,Ke,D,Rt='Once added to <code>target_modules</code>, PEFT automatically stores the embedding layer when saving the adapter if the model has the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.get_input_embeddings" rel="nofollow">get_input_embeddings</a> and <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.get_output_embeddings" rel="nofollow">get_output_embeddings</a>. This is generally the case for Transformers models.',De,O,Ft="If the model’s embedding layer doesn’t follow the Transformer’s naming scheme, you can still save it by manually passing <code>save_embedding_layers=True</code> when saving the adapter:",Oe,ee,et,te,It="For inference, load the base model first and resize it the same way you did before you trained the model. After you’ve resized the base model, you can load the PEFT checkpoint.",tt,se,Ht='For a complete example, please check out <a href="https://github.com/huggingface/peft/blob/main/examples/causal_language_modeling/peft_lora_clm_with_additional_tokens.ipynb" rel="nofollow">this notebook</a>.',st,ae,at,le,Xt='Sometimes a PEFT model can end up in a bad state, especially when handling multiple adapters. There can be some confusion around what adapters exist, which one is active, which one is merged, etc. To help investigate this issue, call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.get_layer_status">get_layer_status()</a> and the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.get_model_status">get_model_status()</a> methods.',lt,ne,Vt='The <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.get_layer_status">get_layer_status()</a> method gives you a detailed overview of each targeted layer’s active, merged, and available adapters.',nt,ie,it,re,Lt="In the model state output, you should look out for entries that say <code>&quot;irregular&quot;</code>. This means PEFT detected an inconsistent state in the model. For instance, if <code>merged_adapters=&quot;irregular&quot;</code>, it means that for at least one adapter, it was merged on some target modules but not on others. The inference results will most likely be incorrect as a result.",rt,oe,Yt="The best way to resolve this issue is to reload the whole model and adapter checkpoint(s). Ensure that you don’t perform any incorrect operations on the model, e.g. manually merging adapters on some modules but not others.",ot,pe,Et="Convert the layer status into a pandas <code>DataFrame</code> for an easier visual inspection.",pt,de,dt,me,Pt='It is possible to get this information for non-PEFT models if they are using PEFT layers under the hood, but some information like the <code>base_model_type</code> or the <code>peft_types</code> cannot be determined in that case. As an example, you can call this on a <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">diffusers</a> model like so:',mt,he,ht,ce,ct,ue,ft;return w=new y({props:{title:"Troubleshooting",local:"troubleshooting",headingTag:"h1"}}),b=new y({props:{title:"Examples don’t work",local:"examples-dont-work",headingTag:"h2"}}),x=new u({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjAlM0NwYWNrYWdlX25hbWUlM0U=",highlighted:"python -m pip install -U &lt;package_name&gt;",wrap:!1}}),$=new u({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZwZWZ0",highlighted:"python -m pip install git+https://github.com/huggingface/peft",wrap:!1}}),J=new y({props:{title:"ValueError: Attempting to unscale FP16 gradients",local:"valueerror-attempting-to-unscale-fp16-gradients",headingTag:"h2"}}),k=new u({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKC4uLiklMEElMEElMjMlMjBhZGQlMjB0aGlzJTNBJTBBZm9yJTIwcGFyYW0lMjBpbiUyMG1vZGVsLnBhcmFtZXRlcnMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwcGFyYW0ucmVxdWlyZXNfZ3JhZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcmFtLmRhdGElMjAlM0QlMjBwYXJhbS5kYXRhLmZsb2F0KCklMEElMEElMjMlMjBwcm9jZWVkJTIwYXMlMjB1c3VhbCUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKG1vZGVsJTNEcGVmdF9tb2RlbCUyQyUyMGZwMTYlM0RUcnVlJTJDJTIwLi4uKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`peft_model = get_peft_model(...)

<span class="hljs-comment"># add this:</span>
<span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.parameters():
    <span class="hljs-keyword">if</span> param.requires_grad:
        param.data = param.data.<span class="hljs-built_in">float</span>()

<span class="hljs-comment"># proceed as usual</span>
trainer = Trainer(model=peft_model, fp16=<span class="hljs-literal">True</span>, ...)
trainer.train()`,wrap:!1}}),C=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBjYXN0X21peGVkX3ByZWNpc2lvbl9wYXJhbXMlMEElMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwoLi4uKSUwQWNhc3RfbWl4ZWRfcHJlY2lzaW9uX3BhcmFtcyhwZWZ0X21vZGVsJTJDJTIwZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQSUyMyUyMHByb2NlZWQlMjBhcyUyMHVzdWFsJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0RwZWZ0X21vZGVsJTJDJTIwZnAxNiUzRFRydWUlMkMlMjAuLi4pJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> cast_mixed_precision_params

peft_model = get_peft_model(...)
cast_mixed_precision_params(peft_model, dtype=torch.float16)

<span class="hljs-comment"># proceed as usual</span>
trainer = Trainer(model=peft_model, fp16=<span class="hljs-literal">True</span>, ...)
trainer.train()`,wrap:!1}}),W=new y({props:{title:"Bad results from a loaded PEFT model",local:"bad-results-from-a-loaded-peft-model",headingTag:"h2"}}),R=new y({props:{title:"Random deviations",local:"random-deviations",headingTag:"h3"}}),H=new y({props:{title:"Incorrectly loaded model",local:"incorrectly-loaded-model",headingTag:"h3"}}),V=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMkMlMjBQZWZ0Q29uZmlnJTBBJTBBYmFzZV9tb2RlbCUyMCUzRCUyMC4uLiUyMCUyMCUyMyUyMHRvJTIwbG9hZCUyMHRoZSUyMGJhc2UlMjBtb2RlbCUyQyUyMHVzZSUyMHRoZSUyMHNhbWUlMjBjb2RlJTIwYXMlMjB3aGVuJTIweW91JTIwdHJhaW5lZCUyMGl0JTBBY29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQocGVmdF9tb2RlbF9pZCklMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel, PeftConfig

base_model = ...  <span class="hljs-comment"># to load the base model, use the same code as when you trained it</span>
config = PeftConfig.from_pretrained(peft_model_id)
peft_model = PeftModel.from_pretrained(base_model, peft_model_id)`,wrap:!1}}),L=new y({props:{title:"Randomly initialized layers",local:"randomly-initialized-layers",headingTag:"h3"}}),S=new u({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMCUzQ01PREVMJTNFJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwJTNDSUQlM0UlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTNBJTIwJTVCJTNDTEFZRVJfTkFNRVMlM0UlNUQuJTBBWW91JTIwc2hvdWxkJTIwcHJvYmFibHklMjBUUkFJTiUyMHRoaXMlMjBtb2RlbCUyMG9uJTIwYSUyMGRvd24tc3RyZWFtJTIwdGFzayUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1c2UlMjBpdCUyMGZvciUyMHByZWRpY3Rpb25zJTIwYW5kJTIwaW5mZXJlbmNlLg==",highlighted:`<span class="hljs-keyword">Some</span> weights <span class="hljs-keyword">of</span> &lt;MODEL&gt; were <span class="hljs-keyword">not</span> initialized <span class="hljs-keyword">from</span> the model <span class="hljs-keyword">checkpoint</span> at &lt;ID&gt; <span class="hljs-keyword">and</span> are newly initialized: [&lt;LAYER_NAMES&gt;].
You should probably TRAIN this model <span class="hljs-keyword">on</span> a down-stream task <span class="hljs-keyword">to</span> be able <span class="hljs-keyword">to</span> use it <span class="hljs-keyword">for</span> predictions <span class="hljs-keyword">and</span> inference.`,wrap:!1}}),N=new y({props:{title:"Extending the vocabulary",local:"extending-the-vocabulary",headingTag:"h3"}}),K=new u({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4lMkMlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmVtYmVkX3Rva2VucyUyMiUyQyUyMCUyMmxtX2hlYWQlMjIlMkMlMjAlMjJxX3Byb2olMjIlMkMlMjAlMjJ2X3Byb2olMjIlNUQp",highlighted:'config = LoraConfig(..., target_modules=[<span class="hljs-string">&quot;embed_tokens&quot;</span>, <span class="hljs-string">&quot;lm_head&quot;</span>, <span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>])',wrap:!1}}),ee=new u({props:{code:"bW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbCguLi4pJTBBJTIzJTIwdHJhaW4lMjB0aGUlMjBtb2RlbCUwQW1vZGVsLnNhdmVfYWRhcHRlciglMjJteV9hZGFwdGVyJTIyJTJDJTIwc2F2ZV9lbWJlZGRpbmdfbGF5ZXJzJTNEVHJ1ZSk=",highlighted:`model = get_peft_model(...)
<span class="hljs-comment"># train the model</span>
model.save_adapter(<span class="hljs-string">&quot;my_adapter&quot;</span>, save_embedding_layers=<span class="hljs-literal">True</span>)`,wrap:!1}}),ae=new y({props:{title:"Check layer and model status",local:"check-layer-and-model-status",headingTag:"h3"}}),ie=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwZ2V0X3BlZnRfbW9kZWwlMkMlMjBMb3JhQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBMb3JhQ29uZmlnKCkpJTBBJTBBbW9kZWwuZ2V0X2xheWVyX3N0YXR1cygpJTBBJTBBbW9kZWwuZ2V0X21vZGVsX3N0YXR1cygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model, LoraConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;google/flan-t5-small&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = get_peft_model(model, LoraConfig())

<span class="hljs-meta">&gt;&gt;&gt; </span>model.get_layer_status()
[TunerLayerStatus(name=<span class="hljs-string">&#x27;model.encoder.block.0.layer.0.SelfAttention.q&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>]),
 TunerLayerStatus(name=<span class="hljs-string">&#x27;model.encoder.block.0.layer.0.SelfAttention.v&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>]),
...]

<span class="hljs-meta">&gt;&gt;&gt; </span>model.get_model_status()
TunerModelStatus(
    base_model_type=<span class="hljs-string">&#x27;T5Model&#x27;</span>,
    adapter_model_type=<span class="hljs-string">&#x27;LoraModel&#x27;</span>,
    peft_types={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-string">&#x27;LORA&#x27;</span>},
    trainable_params=<span class="hljs-number">344064</span>,
    total_params=<span class="hljs-number">60855680</span>,
    num_adapter_layers=<span class="hljs-number">48</span>,
    enabled=<span class="hljs-literal">True</span>,
    active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
    merged_adapters=[],
    requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
    available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
)`,wrap:!1}}),de=new u({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwYXNkaWN0JTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQWRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lKGFzZGljdChsYXllciklMjBmb3IlMjBsYXllciUyMGluJTIwbW9kZWwuZ2V0X2xheWVyX3N0YXR1cygpKQ==",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> asdict
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

df = pd.DataFrame(asdict(layer) <span class="hljs-keyword">for</span> layer <span class="hljs-keyword">in</span> model.get_layer_status())`,wrap:!1}}),he=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMGdldF9tb2RlbF9zdGF0dXMlMkMlMjBnZXRfbGF5ZXJfc3RhdHVzJTBBJTBBcGF0aCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBbG9yYV9pZCUyMCUzRCUyMCUyMnRha3VtYTEwNCUyRmxvcmEtdGVzdC10ZXh0LWVuY29kZXItbG9yYS10YXJnZXQlMjIlMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHBhdGglMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZS5sb2FkX2xvcmFfd2VpZ2h0cyhsb3JhX2lkJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlci0xJTIyKSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMobG9yYV9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmFkYXB0ZXItMiUyMiklMEFnZXRfbGF5ZXJfc3RhdHVzKHBpcGUudGV4dF9lbmNvZGVyKSUwQSUwQWdldF9tb2RlbF9zdGF0dXMocGlwZS51bmV0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_model_status, get_layer_status

<span class="hljs-meta">&gt;&gt;&gt; </span>path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>lora_id = <span class="hljs-string">&quot;takuma104/lora-test-text-encoder-lora-target&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(path, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.load_lora_weights(lora_id, adapter_name=<span class="hljs-string">&quot;adapter-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.load_lora_weights(lora_id, adapter_name=<span class="hljs-string">&quot;adapter-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>get_layer_status(pipe.text_encoder)
[TunerLayerStatus(name=<span class="hljs-string">&#x27;text_model.encoder.layers.0.self_attn.k_proj&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;adapter-1&#x27;</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>]),
 TunerLayerStatus(name=<span class="hljs-string">&#x27;text_model.encoder.layers.0.self_attn.v_proj&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;adapter-1&#x27;</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>]),
...]

<span class="hljs-meta">&gt;&gt;&gt; </span>get_model_status(pipe.unet)
TunerModelStatus(
    base_model_type=<span class="hljs-string">&#x27;other&#x27;</span>,
    adapter_model_type=<span class="hljs-string">&#x27;None&#x27;</span>,
    peft_types={},
    trainable_params=<span class="hljs-number">797184</span>,
    total_params=<span class="hljs-number">861115332</span>,
    num_adapter_layers=<span class="hljs-number">128</span>,
    enabled=<span class="hljs-literal">True</span>,
    active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
    merged_adapters=[],
    requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
    available_adapters=[<span class="hljs-string">&#x27;adapter-1&#x27;</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>],
)`,wrap:!1}}),ce=new es({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/troubleshooting.md"}}),{c(){g=i("meta"),ge=l(),fe=i("p"),ye=l(),p(w.$$.fragment),we=l(),M=i("p"),M.textContent=gt,Me=l(),p(b.$$.fragment),be=l(),_=i("p"),_.textContent=yt,_e=l(),T=i("ul"),T.innerHTML=wt,Te=l(),j=i("p"),j.textContent=Mt,je=l(),p(x.$$.fragment),xe=l(),v=i("p"),v.textContent=bt,ve=l(),p($.$$.fragment),$e=l(),p(J.$$.fragment),Je=l(),Z=i("p"),Z.innerHTML=_t,Ze=l(),p(k.$$.fragment),ke=l(),U=i("p"),U.innerHTML=Tt,Ue=l(),p(C.$$.fragment),Ce=l(),p(W.$$.fragment),We=l(),B=i("p"),B.innerHTML=jt,Be=l(),G=i("p"),G.textContent=xt,Ge=l(),p(R.$$.fragment),Re=l(),F=i("p"),F.textContent=vt,Fe=l(),I=i("ol"),I.innerHTML=$t,Ie=l(),p(H.$$.fragment),He=l(),X=i("p"),X.innerHTML=Jt,Xe=l(),p(V.$$.fragment),Ve=l(),p(L.$$.fragment),Le=l(),Y=i("p"),Y.innerHTML=Zt,Ye=l(),E=i("p"),E.innerHTML=kt,Ee=l(),P=i("p"),P.innerHTML=Ut,Pe=l(),z=i("p"),z.textContent=Ct,ze=l(),p(S.$$.fragment),Se=l(),Q=i("p"),Q.innerHTML=Wt,Qe=l(),p(N.$$.fragment),Ne=l(),q=i("p"),q.textContent=Bt,qe=l(),A=i("p"),A.innerHTML=Gt,Ae=l(),p(K.$$.fragment),Ke=l(),D=i("p"),D.innerHTML=Rt,De=l(),O=i("p"),O.innerHTML=Ft,Oe=l(),p(ee.$$.fragment),et=l(),te=i("p"),te.textContent=It,tt=l(),se=i("p"),se.innerHTML=Ht,st=l(),p(ae.$$.fragment),at=l(),le=i("p"),le.innerHTML=Xt,lt=l(),ne=i("p"),ne.innerHTML=Vt,nt=l(),p(ie.$$.fragment),it=l(),re=i("p"),re.innerHTML=Lt,rt=l(),oe=i("p"),oe.textContent=Yt,ot=l(),pe=i("p"),pe.innerHTML=Et,pt=l(),p(de.$$.fragment),dt=l(),me=i("p"),me.innerHTML=Pt,mt=l(),p(he.$$.fragment),ht=l(),p(ce.$$.fragment),ct=l(),ue=i("p"),this.h()},l(e){const t=Dt("svelte-u9bgzb",document.head);g=r(t,"META",{name:!0,content:!0}),t.forEach(s),ge=n(e),fe=r(e,"P",{}),zt(fe).forEach(s),ye=n(e),d(w.$$.fragment,e),we=n(e),M=r(e,"P",{"data-svelte-h":!0}),o(M)!=="svelte-wwms7a"&&(M.textContent=gt),Me=n(e),d(b.$$.fragment,e),be=n(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-18nlz3r"&&(_.textContent=yt),_e=n(e),T=r(e,"UL",{"data-svelte-h":!0}),o(T)!=="svelte-ccv654"&&(T.innerHTML=wt),Te=n(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1cuqjyb"&&(j.textContent=Mt),je=n(e),d(x.$$.fragment,e),xe=n(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-h5ykrw"&&(v.textContent=bt),ve=n(e),d($.$$.fragment,e),$e=n(e),d(J.$$.fragment,e),Je=n(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-oa0e54"&&(Z.innerHTML=_t),Ze=n(e),d(k.$$.fragment,e),ke=n(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-p7trz1"&&(U.innerHTML=Tt),Ue=n(e),d(C.$$.fragment,e),Ce=n(e),d(W.$$.fragment,e),We=n(e),B=r(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-ns8zue"&&(B.innerHTML=jt),Be=n(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-lfc2ft"&&(G.textContent=xt),Ge=n(e),d(R.$$.fragment,e),Re=n(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-16feh"&&(F.textContent=vt),Fe=n(e),I=r(e,"OL",{"data-svelte-h":!0}),o(I)!=="svelte-1fvhlks"&&(I.innerHTML=$t),Ie=n(e),d(H.$$.fragment,e),He=n(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-q1qqrd"&&(X.innerHTML=Jt),Xe=n(e),d(V.$$.fragment,e),Ve=n(e),d(L.$$.fragment,e),Le=n(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-5heszj"&&(Y.innerHTML=Zt),Ye=n(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-c4824l"&&(E.innerHTML=kt),Ee=n(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1ou3c35"&&(P.innerHTML=Ut),Pe=n(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1g4txs2"&&(z.textContent=Ct),ze=n(e),d(S.$$.fragment,e),Se=n(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1fbeum6"&&(Q.innerHTML=Wt),Qe=n(e),d(N.$$.fragment,e),Ne=n(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-15igmai"&&(q.textContent=Bt),qe=n(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1cgzlph"&&(A.innerHTML=Gt),Ae=n(e),d(K.$$.fragment,e),Ke=n(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-kwgcwv"&&(D.innerHTML=Rt),De=n(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-ucua6z"&&(O.innerHTML=Ft),Oe=n(e),d(ee.$$.fragment,e),et=n(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-nkv7o7"&&(te.textContent=It),tt=n(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-a0ibfa"&&(se.innerHTML=Ht),st=n(e),d(ae.$$.fragment,e),at=n(e),le=r(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1f0hxdh"&&(le.innerHTML=Xt),lt=n(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1ygf8mz"&&(ne.innerHTML=Vt),nt=n(e),d(ie.$$.fragment,e),it=n(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1gb1r7d"&&(re.innerHTML=Lt),rt=n(e),oe=r(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-19sfzdf"&&(oe.textContent=Yt),ot=n(e),pe=r(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-18r4lni"&&(pe.innerHTML=Et),pt=n(e),d(de.$$.fragment,e),dt=n(e),me=r(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-17rnlhh"&&(me.innerHTML=Pt),mt=n(e),d(he.$$.fragment,e),ht=n(e),d(ce.$$.fragment,e),ct=n(e),ue=r(e,"P",{}),zt(ue).forEach(s),this.h()},h(){St(g,"name","hf:doc:metadata"),St(g,"content",ss)},m(e,t){Ot(document.head,g),a(e,ge,t),a(e,fe,t),a(e,ye,t),m(w,e,t),a(e,we,t),a(e,M,t),a(e,Me,t),m(b,e,t),a(e,be,t),a(e,_,t),a(e,_e,t),a(e,T,t),a(e,Te,t),a(e,j,t),a(e,je,t),m(x,e,t),a(e,xe,t),a(e,v,t),a(e,ve,t),m($,e,t),a(e,$e,t),m(J,e,t),a(e,Je,t),a(e,Z,t),a(e,Ze,t),m(k,e,t),a(e,ke,t),a(e,U,t),a(e,Ue,t),m(C,e,t),a(e,Ce,t),m(W,e,t),a(e,We,t),a(e,B,t),a(e,Be,t),a(e,G,t),a(e,Ge,t),m(R,e,t),a(e,Re,t),a(e,F,t),a(e,Fe,t),a(e,I,t),a(e,Ie,t),m(H,e,t),a(e,He,t),a(e,X,t),a(e,Xe,t),m(V,e,t),a(e,Ve,t),m(L,e,t),a(e,Le,t),a(e,Y,t),a(e,Ye,t),a(e,E,t),a(e,Ee,t),a(e,P,t),a(e,Pe,t),a(e,z,t),a(e,ze,t),m(S,e,t),a(e,Se,t),a(e,Q,t),a(e,Qe,t),m(N,e,t),a(e,Ne,t),a(e,q,t),a(e,qe,t),a(e,A,t),a(e,Ae,t),m(K,e,t),a(e,Ke,t),a(e,D,t),a(e,De,t),a(e,O,t),a(e,Oe,t),m(ee,e,t),a(e,et,t),a(e,te,t),a(e,tt,t),a(e,se,t),a(e,st,t),m(ae,e,t),a(e,at,t),a(e,le,t),a(e,lt,t),a(e,ne,t),a(e,nt,t),m(ie,e,t),a(e,it,t),a(e,re,t),a(e,rt,t),a(e,oe,t),a(e,ot,t),a(e,pe,t),a(e,pt,t),m(de,e,t),a(e,dt,t),a(e,me,t),a(e,mt,t),m(he,e,t),a(e,ht,t),m(ce,e,t),a(e,ct,t),a(e,ue,t),ft=!0},p:Nt,i(e){ft||(h(w.$$.fragment,e),h(b.$$.fragment,e),h(x.$$.fragment,e),h($.$$.fragment,e),h(J.$$.fragment,e),h(k.$$.fragment,e),h(C.$$.fragment,e),h(W.$$.fragment,e),h(R.$$.fragment,e),h(H.$$.fragment,e),h(V.$$.fragment,e),h(L.$$.fragment,e),h(S.$$.fragment,e),h(N.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(de.$$.fragment,e),h(he.$$.fragment,e),h(ce.$$.fragment,e),ft=!0)},o(e){c(w.$$.fragment,e),c(b.$$.fragment,e),c(x.$$.fragment,e),c($.$$.fragment,e),c(J.$$.fragment,e),c(k.$$.fragment,e),c(C.$$.fragment,e),c(W.$$.fragment,e),c(R.$$.fragment,e),c(H.$$.fragment,e),c(V.$$.fragment,e),c(L.$$.fragment,e),c(S.$$.fragment,e),c(N.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(de.$$.fragment,e),c(he.$$.fragment,e),c(ce.$$.fragment,e),ft=!1},d(e){e&&(s(ge),s(fe),s(ye),s(we),s(M),s(Me),s(be),s(_),s(_e),s(T),s(Te),s(j),s(je),s(xe),s(v),s(ve),s($e),s(Je),s(Z),s(Ze),s(ke),s(U),s(Ue),s(Ce),s(We),s(B),s(Be),s(G),s(Ge),s(Re),s(F),s(Fe),s(I),s(Ie),s(He),s(X),s(Xe),s(Ve),s(Le),s(Y),s(Ye),s(E),s(Ee),s(P),s(Pe),s(z),s(ze),s(Se),s(Q),s(Qe),s(Ne),s(q),s(qe),s(A),s(Ae),s(Ke),s(D),s(De),s(O),s(Oe),s(et),s(te),s(tt),s(se),s(st),s(at),s(le),s(lt),s(ne),s(nt),s(it),s(re),s(rt),s(oe),s(ot),s(pe),s(pt),s(dt),s(me),s(mt),s(ht),s(ct),s(ue)),s(g),f(w,e),f(b,e),f(x,e),f($,e),f(J,e),f(k,e),f(C,e),f(W,e),f(R,e),f(H,e),f(V,e),f(L,e),f(S,e),f(N,e),f(K,e),f(ee,e),f(ae,e),f(ie,e),f(de,e),f(he,e),f(ce,e)}}}const ss='{"title":"Troubleshooting","local":"troubleshooting","sections":[{"title":"Examples don’t work","local":"examples-dont-work","sections":[],"depth":2},{"title":"ValueError: Attempting to unscale FP16 gradients","local":"valueerror-attempting-to-unscale-fp16-gradients","sections":[],"depth":2},{"title":"Bad results from a loaded PEFT model","local":"bad-results-from-a-loaded-peft-model","sections":[{"title":"Random deviations","local":"random-deviations","sections":[],"depth":3},{"title":"Incorrectly loaded model","local":"incorrectly-loaded-model","sections":[],"depth":3},{"title":"Randomly initialized layers","local":"randomly-initialized-layers","sections":[],"depth":3},{"title":"Extending the vocabulary","local":"extending-the-vocabulary","sections":[],"depth":3},{"title":"Check layer and model status","local":"check-layer-and-model-status","sections":[],"depth":3}],"depth":2}],"depth":1}';function as(ut){return qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class os extends At{constructor(g){super(),Kt(this,g,as,ts,Qt,{})}}export{os as component};
