import{s as vt,n as bt,o as $t}from"../chunks/scheduler.924d507e.js";import{S as xt,i as yt,g as n,s as r,r as g,A as Tt,h as s,f as o,c as a,j as x,u as h,x as i,k as y,y as t,a as c,v as _,d as v,t as b,w as $}from"../chunks/index.0ece89e8.js";import{D as P}from"../chunks/Docstring.5956222d.js";import{H as Xe}from"../chunks/Heading.c9bff43c.js";function wt(Ye){let B,ge,me,he,j,_e,E,Ze="A tuner (or adapter) is a module that can be plugged into a <code>torch.nn.Module</code>. <code>BaseTuner</code> base class for other tuners and provides shared methods and attributes for preparing an adapter configuration and replacing a target module with the adapter module. <code>BaseTunerLayer</code> is a base class for adapter layers. It offers methods and attributes for managing adapters such as activating and disabling adapters.",ve,H,be,l,I,Le,z,et=`A base tuner model that provides the common methods and attributes for all tuners that are injectable into a
torch.nn.Module`,Be,W,tt="For adding a new Tuner class, one needs to overwrite the following methods:",Pe,G,rt=`<li><strong>_prepare_adapter_config</strong>:
A private method to eventually prepare the adapter config, for example in case the field <code>target_modules</code> is
missing.</li> <li><strong>_check_target_module_exists</strong>:
A helper private method to check if the passed module’s key name matches any of the target modules in the
adatper_config.</li> <li><strong>_create_and_replace</strong>:
A private method to create and replace the target module with the adapter module.</li> <li><strong>_check_target_module_exists</strong>:
A private helper method to check if the passed module’s key name matches any of the target modules in the
adatper_config.</li>`,De,J,at="The easiest is to check what is done in the <code>peft.tuners.lora.LoraModel</code> class.",Me,T,A,ke,K,nt=`Creates adapter layers and replaces the target modules with the adapter layers. This method is called under the
hood by <code>peft.mapping.get_peft_model</code> if a non-prompt tuning adapter class is passed.`,je,Q,st="The corresponding PEFT config is directly retrieved from the <code>peft_config</code> attribute of the BaseTuner class.",Ee,w,V,He,X,ot="This method merges the adapter layers into the base model.",Ie,Y,lt=`Merging adapters can lead to a speed up of the forward pass. A copy of the adapter weights is still kept in
memory, which is required to unmerge the adapters. In order to merge the adapter weights without keeping them
in memory, please call <code>merge_and_unload</code>.`,Ae,D,N,Ve,Z,dt="This method unmerges all merged adapter layers from the base model.",$e,q,xe,p,U,Ne,ee,it="A tuner layer mixin that provides the common methods and attributes for all tuners.",qe,m,F,Ue,te,pt="Delete an adapter from the layer",Fe,re,ut="This should be called on all adapter layers, or else we will get an inconsistent state.",Se,ae,ct=`This method will also set a new active adapter if the deleted adapter was an active adapter. It is important
that the new adapter is chosen in a deterministic way, so that the same adapter is chosen on all layers.`,Oe,C,S,Re,ne,mt="Toggle the enabling and disabling of adapters",ze,se,ft="Takes care of setting the requires_grad flag for the adapter weights.",We,L,O,Ge,oe,gt="(Recursively) get the base_layer.",Je,le,ht="This is necessary for the case that the tuner layer wraps another tuner layer.",Ke,M,R,Qe,de,_t="Set the active adapter(s).",ye,fe,Te;return j=new Xe({props:{title:"Tuners",local:"tuners",headingTag:"h1"}}),H=new Xe({props:{title:"BaseTuner",local:"peft.tuners.tuners_utils.BaseTuner",headingTag:"h2"}}),I=new P({props:{name:"class peft.tuners.tuners_utils.BaseTuner",anchor:"peft.tuners.tuners_utils.BaseTuner",parameters:[{name:"model",val:""},{name:"peft_config",val:": Union[PeftConfig, dict[str, PeftConfig]]"},{name:"adapter_name",val:": str"}],parametersDescription:[{anchor:"peft.tuners.tuners_utils.BaseTuner.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
The model to which the adapter tuner layers will be attached.`,name:"model"},{anchor:"peft.tuners.tuners_utils.BaseTuner.forward",description:`<strong>forward</strong> (<code>Callable</code>) &#x2014;
The forward method of the model.`,name:"forward"},{anchor:"peft.tuners.tuners_utils.BaseTuner.peft_config",description:`<strong>peft_config</strong> (<code>Union[</code>PeftConfig<code>, dict[str, PeftConfig]]</code>) &#x2014;
The adapter configuration object, it should be a dictionary of <code>str</code> to <code>PeftConfig</code> objects. One can also
pass a PeftConfig object and a new adapter will be created with the default name <code>adapter</code> or create a new
dictionary with a key <code>adapter_name</code> and a value of that peft config.`,name:"peft_config"},{anchor:"peft.tuners.tuners_utils.BaseTuner.config",description:`<strong>config</strong> (<code>dict[str, Any]</code>) &#x2014;
The model configuration object, it should be a dictionary of <code>str</code> to <code>Any</code> objects.`,name:"config"}],source:"https://github.com/huggingface/peft/blob/v0.7.1/src/peft/tuners/tuners_utils.py#L35"}}),A=new P({props:{name:"inject_adapter",anchor:"peft.tuners.tuners_utils.BaseTuner.inject_adapter",parameters:[{name:"model",val:": nn.Module"},{name:"adapter_name",val:": str"}],parametersDescription:[{anchor:"peft.tuners.tuners_utils.BaseTuner.inject_adapter.model",description:`<strong>model</strong> (<code>nn.Module</code>) &#x2014;
The model to be tuned.`,name:"model"},{anchor:"peft.tuners.tuners_utils.BaseTuner.inject_adapter.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>) &#x2014;
The adapter name.`,name:"adapter_name"}],source:"https://github.com/huggingface/peft/blob/v0.7.1/src/peft/tuners/tuners_utils.py#L188"}}),V=new P({props:{name:"merge_adapter",anchor:"peft.tuners.tuners_utils.BaseTuner.merge_adapter",parameters:[{name:"adapter_names",val:": Optional[list[str]] = None"}],parametersDescription:[{anchor:"peft.tuners.tuners_utils.BaseTuner.merge_adapter.safe_merge",description:`<strong>safe_merge</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, the merge operation will be performed in a copy of the original weights and check for NaNs
before merging the weights. This is useful if you want to check if the merge operation will produce
NaNs. Defaults to <code>False</code>.`,name:"safe_merge"},{anchor:"peft.tuners.tuners_utils.BaseTuner.merge_adapter.adapter_names",description:`<strong>adapter_names</strong> (<code>list[str]</code>, <em>optional</em>) &#x2014;
The list of adapter names that should be merged. If <code>None</code>, all active adapters will be merged.
Defaults to <code>None</code>.`,name:"adapter_names"}],source:"https://github.com/huggingface/peft/blob/v0.7.1/src/peft/tuners/tuners_utils.py#L268"}}),N=new P({props:{name:"unmerge_adapter",anchor:"peft.tuners.tuners_utils.BaseTuner.unmerge_adapter",parameters:[],source:"https://github.com/huggingface/peft/blob/v0.7.1/src/peft/tuners/tuners_utils.py#L289"}}),q=new Xe({props:{title:"BaseTunerLayer",local:"peft.tuners.tuners_utils.BaseTunerLayer",headingTag:"h2"}}),U=new P({props:{name:"class peft.tuners.tuners_utils.BaseTunerLayer",anchor:"peft.tuners.tuners_utils.BaseTunerLayer",parameters:[],parametersDescription:[{anchor:"peft.tuners.tuners_utils.BaseTunerLayer.is_plugable",description:`<strong>is_plugable</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the adapter layer can be plugged to any pytorch module`,name:"is_plugable"},{anchor:"peft.tuners.tuners_utils.BaseTunerLayer.active_adapters",description:`<strong>active_adapters</strong> (Union[List<code>str</code>, <code>str</code>], <em>optional</em>) &#x2014;
The name of the active adapter.`,name:"active_adapters"}],source:"https://github.com/huggingface/peft/blob/v0.7.1/src/peft/tuners/tuners_utils.py#L306"}}),F=new P({props:{name:"delete_adapter",anchor:"peft.tuners.tuners_utils.BaseTunerLayer.delete_adapter",parameters:[{name:"adapter_name",val:": str"}],parametersDescription:[{anchor:"peft.tuners.tuners_utils.BaseTunerLayer.delete_adapter.adapter_name",description:"<strong>adapter_name</strong> (<code>str</code>) &#x2014; The name of the adapter to delete",name:"adapter_name"}],source:"https://github.com/huggingface/peft/blob/v0.7.1/src/peft/tuners/tuners_utils.py#L439"}}),S=new P({props:{name:"enable_adapters",anchor:"peft.tuners.tuners_utils.BaseTunerLayer.enable_adapters",parameters:[{name:"enabled",val:": bool"}],parametersDescription:[{anchor:"peft.tuners.tuners_utils.BaseTunerLayer.enable_adapters.enabled",description:"<strong>enabled</strong> (bool) &#x2014; True to enable adapters, False to disable adapters",name:"enabled"}],source:"https://github.com/huggingface/peft/blob/v0.7.1/src/peft/tuners/tuners_utils.py#L388"}}),O=new P({props:{name:"get_base_layer",anchor:"peft.tuners.tuners_utils.BaseTunerLayer.get_base_layer",parameters:[],source:"https://github.com/huggingface/peft/blob/v0.7.1/src/peft/tuners/tuners_utils.py#L333"}}),R=new P({props:{name:"set_adapter",anchor:"peft.tuners.tuners_utils.BaseTunerLayer.set_adapter",parameters:[{name:"adapter_names",val:": str | list[str]"}],parametersDescription:[{anchor:"peft.tuners.tuners_utils.BaseTunerLayer.set_adapter.adapter_name",description:"<strong>adapter_name</strong> (<code>str</code> or <code>List[str]</code>) &#x2014; Name of the adapter(s) to be activated.",name:"adapter_name"}],source:"https://github.com/huggingface/peft/blob/v0.7.1/src/peft/tuners/tuners_utils.py#L406"}}),{c(){B=n("meta"),ge=r(),me=n("p"),he=r(),g(j.$$.fragment),_e=r(),E=n("p"),E.innerHTML=Ze,ve=r(),g(H.$$.fragment),be=r(),l=n("div"),g(I.$$.fragment),Le=r(),z=n("p"),z.textContent=et,Be=r(),W=n("p"),W.textContent=tt,Pe=r(),G=n("ul"),G.innerHTML=rt,De=r(),J=n("p"),J.innerHTML=at,Me=r(),T=n("div"),g(A.$$.fragment),ke=r(),K=n("p"),K.innerHTML=nt,je=r(),Q=n("p"),Q.innerHTML=st,Ee=r(),w=n("div"),g(V.$$.fragment),He=r(),X=n("p"),X.textContent=ot,Ie=r(),Y=n("p"),Y.innerHTML=lt,Ae=r(),D=n("div"),g(N.$$.fragment),Ve=r(),Z=n("p"),Z.textContent=dt,$e=r(),g(q.$$.fragment),xe=r(),p=n("div"),g(U.$$.fragment),Ne=r(),ee=n("p"),ee.textContent=it,qe=r(),m=n("div"),g(F.$$.fragment),Ue=r(),te=n("p"),te.textContent=pt,Fe=r(),re=n("p"),re.textContent=ut,Se=r(),ae=n("p"),ae.textContent=ct,Oe=r(),C=n("div"),g(S.$$.fragment),Re=r(),ne=n("p"),ne.textContent=mt,ze=r(),se=n("p"),se.textContent=ft,We=r(),L=n("div"),g(O.$$.fragment),Ge=r(),oe=n("p"),oe.textContent=gt,Je=r(),le=n("p"),le.textContent=ht,Ke=r(),M=n("div"),g(R.$$.fragment),Qe=r(),de=n("p"),de.textContent=_t,ye=r(),fe=n("p"),this.h()},l(e){const d=Tt("svelte-u9bgzb",document.head);B=s(d,"META",{name:!0,content:!0}),d.forEach(o),ge=a(e),me=s(e,"P",{}),x(me).forEach(o),he=a(e),h(j.$$.fragment,e),_e=a(e),E=s(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-dsnslo"&&(E.innerHTML=Ze),ve=a(e),h(H.$$.fragment,e),be=a(e),l=s(e,"DIV",{class:!0});var u=x(l);h(I.$$.fragment,u),Le=a(u),z=s(u,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1k0hvlq"&&(z.textContent=et),Be=a(u),W=s(u,"P",{"data-svelte-h":!0}),i(W)!=="svelte-fkgwsm"&&(W.textContent=tt),Pe=a(u),G=s(u,"UL",{"data-svelte-h":!0}),i(G)!=="svelte-19u1lfp"&&(G.innerHTML=rt),De=a(u),J=s(u,"P",{"data-svelte-h":!0}),i(J)!=="svelte-1sc4mfu"&&(J.innerHTML=at),Me=a(u),T=s(u,"DIV",{class:!0});var ie=x(T);h(A.$$.fragment,ie),ke=a(ie),K=s(ie,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1ybn6sj"&&(K.innerHTML=nt),je=a(ie),Q=s(ie,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-fvf2kw"&&(Q.innerHTML=st),ie.forEach(o),Ee=a(u),w=s(u,"DIV",{class:!0});var pe=x(w);h(V.$$.fragment,pe),He=a(pe),X=s(pe,"P",{"data-svelte-h":!0}),i(X)!=="svelte-kun7ud"&&(X.textContent=ot),Ie=a(pe),Y=s(pe,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1f1s101"&&(Y.innerHTML=lt),pe.forEach(o),Ae=a(u),D=s(u,"DIV",{class:!0});var we=x(D);h(N.$$.fragment,we),Ve=a(we),Z=s(we,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-2eloeq"&&(Z.textContent=dt),we.forEach(o),u.forEach(o),$e=a(e),h(q.$$.fragment,e),xe=a(e),p=s(e,"DIV",{class:!0});var f=x(p);h(U.$$.fragment,f),Ne=a(f),ee=s(f,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-1fdxdjn"&&(ee.textContent=it),qe=a(f),m=s(f,"DIV",{class:!0});var k=x(m);h(F.$$.fragment,k),Ue=a(k),te=s(k,"P",{"data-svelte-h":!0}),i(te)!=="svelte-950rwb"&&(te.textContent=pt),Fe=a(k),re=s(k,"P",{"data-svelte-h":!0}),i(re)!=="svelte-1nnxg1l"&&(re.textContent=ut),Se=a(k),ae=s(k,"P",{"data-svelte-h":!0}),i(ae)!=="svelte-1vxxy19"&&(ae.textContent=ct),k.forEach(o),Oe=a(f),C=s(f,"DIV",{class:!0});var ue=x(C);h(S.$$.fragment,ue),Re=a(ue),ne=s(ue,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-2or2k8"&&(ne.textContent=mt),ze=a(ue),se=s(ue,"P",{"data-svelte-h":!0}),i(se)!=="svelte-ujp0ui"&&(se.textContent=ft),ue.forEach(o),We=a(f),L=s(f,"DIV",{class:!0});var ce=x(L);h(O.$$.fragment,ce),Ge=a(ce),oe=s(ce,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-6rdpda"&&(oe.textContent=gt),Je=a(ce),le=s(ce,"P",{"data-svelte-h":!0}),i(le)!=="svelte-dptqqh"&&(le.textContent=ht),ce.forEach(o),Ke=a(f),M=s(f,"DIV",{class:!0});var Ce=x(M);h(R.$$.fragment,Ce),Qe=a(Ce),de=s(Ce,"P",{"data-svelte-h":!0}),i(de)!=="svelte-8teaja"&&(de.textContent=_t),Ce.forEach(o),f.forEach(o),ye=a(e),fe=s(e,"P",{}),x(fe).forEach(o),this.h()},h(){y(B,"name","hf:doc:metadata"),y(B,"content",Ct),y(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(l,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,d){t(document.head,B),c(e,ge,d),c(e,me,d),c(e,he,d),_(j,e,d),c(e,_e,d),c(e,E,d),c(e,ve,d),_(H,e,d),c(e,be,d),c(e,l,d),_(I,l,null),t(l,Le),t(l,z),t(l,Be),t(l,W),t(l,Pe),t(l,G),t(l,De),t(l,J),t(l,Me),t(l,T),_(A,T,null),t(T,ke),t(T,K),t(T,je),t(T,Q),t(l,Ee),t(l,w),_(V,w,null),t(w,He),t(w,X),t(w,Ie),t(w,Y),t(l,Ae),t(l,D),_(N,D,null),t(D,Ve),t(D,Z),c(e,$e,d),_(q,e,d),c(e,xe,d),c(e,p,d),_(U,p,null),t(p,Ne),t(p,ee),t(p,qe),t(p,m),_(F,m,null),t(m,Ue),t(m,te),t(m,Fe),t(m,re),t(m,Se),t(m,ae),t(p,Oe),t(p,C),_(S,C,null),t(C,Re),t(C,ne),t(C,ze),t(C,se),t(p,We),t(p,L),_(O,L,null),t(L,Ge),t(L,oe),t(L,Je),t(L,le),t(p,Ke),t(p,M),_(R,M,null),t(M,Qe),t(M,de),c(e,ye,d),c(e,fe,d),Te=!0},p:bt,i(e){Te||(v(j.$$.fragment,e),v(H.$$.fragment,e),v(I.$$.fragment,e),v(A.$$.fragment,e),v(V.$$.fragment,e),v(N.$$.fragment,e),v(q.$$.fragment,e),v(U.$$.fragment,e),v(F.$$.fragment,e),v(S.$$.fragment,e),v(O.$$.fragment,e),v(R.$$.fragment,e),Te=!0)},o(e){b(j.$$.fragment,e),b(H.$$.fragment,e),b(I.$$.fragment,e),b(A.$$.fragment,e),b(V.$$.fragment,e),b(N.$$.fragment,e),b(q.$$.fragment,e),b(U.$$.fragment,e),b(F.$$.fragment,e),b(S.$$.fragment,e),b(O.$$.fragment,e),b(R.$$.fragment,e),Te=!1},d(e){e&&(o(ge),o(me),o(he),o(_e),o(E),o(ve),o(be),o(l),o($e),o(xe),o(p),o(ye),o(fe)),o(B),$(j,e),$(H,e),$(I),$(A),$(V),$(N),$(q,e),$(U),$(F),$(S),$(O),$(R)}}}const Ct='{"title":"Tuners","local":"tuners","sections":[{"title":"BaseTuner","local":"peft.tuners.tuners_utils.BaseTuner","sections":[],"depth":2},{"title":"BaseTunerLayer","local":"peft.tuners.tuners_utils.BaseTunerLayer","sections":[],"depth":2}],"depth":1}';function Lt(Ye){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kt extends xt{constructor(B){super(),yt(this,B,Lt,wt,vt,{})}}export{kt as component};
