import{s as ee,n as le,o as ae}from"../chunks/scheduler.c57aa7ef.js";import{S as se,i as ne,g as i,s,r as c,A as ie,h as p,f as l,c as n,j as te,u as o,x as r,k as Vt,y as pe,a,v as d,d as m,t as f,w as h}from"../chunks/index.c50cb18e.js";import{C as q}from"../chunks/CodeBlock.34f0a53d.js";import{H as w}from"../chunks/Heading.c7d7e0e7.js";function re(Yt){let u,K,P,O,y,tt,J,Et='<a href="https://pytorch.org/docs/stable/fsdp.html" rel="nofollow">Fully sharded data parallel</a> (FSDP) is developed for distributed training of large pretrained models up to 1T parameters. FSDP achieves this by sharding the model parameters, gradients, and optimizer states across data parallel processes and it can also offload sharded model parameters to a CPU. The memory efficiency afforded by FSDP allows you to scale training to larger batch or model sizes.',et,_,vt="Both of these features are supported in 🤗 Accelerate, and you can use them with 🤗 PEFT.",lt,g,at,j,Gt='This section of guide will help you learn how to use our DeepSpeed <a href="https://github.com/huggingface/peft/blob/main/examples/sft/train.py" rel="nofollow">training script</a> for performing SFT. You’ll configure the script to do SFT (supervised fine-tuning) of Llama-70B model with LoRA and FSDP on 8xH100 80GB GPUs on a single machine. You can configure it to scale to multiple machines by changing the accelerate config.',st,b,nt,U,Nt='Start by running the following command to <a href="https://huggingface.co/docs/accelerate/quicktour#launching-your-distributed-script" rel="nofollow">create a FSDP configuration file</a> with 🤗 Accelerate. The <code>--config_file</code> flag allows you to save the configuration file to a specific location, otherwise it is saved as a <code>default_config.yaml</code> file in the 🤗 Accelerate cache.',it,F,Ct="The configuration file is used to set the default options when you launch the training script.",pt,B,rt,W,St="You’ll be asked a few questions about your setup, and configure the following arguments. In this example, you’ll answer the questionnaire as shown in the image below.",ct,M,$t='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/fsdp-peft-config.png"/>',ot,Z,kt="Creating Accelerate's config to use FSDP",dt,I,At='Once this is done, the corresponding config should look like below and you can find it in config folder at <a href="https://github.com/huggingface/peft/blob/main/examples/sft/configs/fsdp_config.yaml" rel="nofollow">fsdp_config.yaml</a>:',mt,X,ft,R,ht,V,xt='The launch command is available at <a href="https://github.com/huggingface/peft/blob/main/examples/sft/run_peft_fsdp.sh" rel="nofollow">run_peft_fsdp.sh</a> and it is also shown below:',ut,Y,Mt,E,Lt='Notice that we are using LoRA with  rank=8, alpha=16 and targeting all linear layers. We are passing the FSDP config file and finetuning the 70B Llama model on a subset of the <a href="https://huggingface.co/datasets/HuggingFaceH4/ultrachat_200k" rel="nofollow">ultrachat dataset</a>.',Tt,v,wt,G,Ht="Let’s dive a little deeper into the script so you can see what’s going on, and understand how it works.",yt,N,Qt="The first thing to know is that the script uses FSDP for distributed training as the FSDP config has been passed. The <code>SFTTrainer</code> class handles all the heavy lifting of creating PEFT model using the peft config that is passed. After that when you call <code>trainer.train()</code>, Trainer internally uses 🤗 Accelerate to prepare model, optimizer and trainer using the FSDP config to create FSDP wrapped model which is then trained. The main code snippet is below:",Jt,C,_t,S,zt="Here, one main thing to note currently when using FSDP with PEFT is that <code>use_orig_params</code> needs to be <code>False</code> to realize GPU memory savings. Due to <code>use_orig_params=False</code>, the auto wrap policy for FSDP needs to change so that trainable and non-trainable parameters are wrapped separately. This is done by the code snippt below which uses the util function <code>fsdp_auto_wrap_policy</code> from PEFT:",gt,$,jt,k,bt,A,Pt="In the above example, the memory consumed per GPU is  72-80 GB (90-98%) as seen in the screenshot below. The slight increase in GPU memory at the end is when saving the model using <code>FULL_STATE_DICT</code> state dict type instead of the <code>SHARDED_STATE_DICT</code> so that the model has adapter weights that can be loaded normally with <code>from_pretrained</code> method during inference:",Ut,T,Dt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/peft_fsdp_mem_usage.png"/>',Ft,x,qt="GPU memory usage for the training run",Bt,L,Wt,H,Kt='You can also refer the <a href="https://github.com/facebookresearch/llama-recipes/?tab=readme-ov-file#fine-tuning" rel="nofollow">llama-recipes</a> repo and <a href="https://llama.meta.com/get-started/#fine-tuning" rel="nofollow">Getting started with Llama</a> guide on how to finetune using FSDP and PEFT.',Zt,Q,It,z,Ot="<li>Merging when using PEFT and FSDP is currently unsupported and will raise error.</li> <li>Passing <code>modules_to_save</code> config parameter to is untested at present.</li> <li>GPU Memory saving when using CPU Offloading is untested at present.</li>",Xt,D,Rt;return y=new w({props:{title:"Fully Sharded Data Parallel",local:"fully-sharded-data-parallel",headingTag:"h1"}}),g=new w({props:{title:"Use PEFT and FSDP",local:"use-peft-and-fsdp",headingTag:"h1"}}),b=new w({props:{title:"Configuration",local:"configuration",headingTag:"h2"}}),B=new q({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMC0tY29uZmlnX2ZpbGUlMjBmc2RwX2NvbmZpZy55YW1s",highlighted:"accelerate config --config_file fsdp_config.yaml",wrap:!1}}),X=new q({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWJ1ZyUzQSUyMGZhbHNlJTBBZGlzdHJpYnV0ZWRfdHlwZSUzQSUyMEZTRFAlMEFkb3duY2FzdF9iZjE2JTNBJTIwJ25vJyUwQWZzZHBfY29uZmlnJTNBJTBBJTIwJTIwZnNkcF9hdXRvX3dyYXBfcG9saWN5JTNBJTIwVFJBTlNGT1JNRVJfQkFTRURfV1JBUCUwQSUyMCUyMGZzZHBfYmFja3dhcmRfcHJlZmV0Y2glM0ElMjBCQUNLV0FSRF9QUkUlMEElMjAlMjBmc2RwX2NwdV9yYW1fZWZmaWNpZW50X2xvYWRpbmclM0ElMjB0cnVlJTBBJTIwJTIwZnNkcF9mb3J3YXJkX3ByZWZldGNoJTNBJTIwZmFsc2UlMEElMjAlMjBmc2RwX29mZmxvYWRfcGFyYW1zJTNBJTIwZmFsc2UlMEElMjAlMjBmc2RwX3NoYXJkaW5nX3N0cmF0ZWd5JTNBJTIwRlVMTF9TSEFSRCUwQSUyMCUyMGZzZHBfc3RhdGVfZGljdF90eXBlJTNBJTIwU0hBUkRFRF9TVEFURV9ESUNUJTBBJTIwJTIwZnNkcF9zeW5jX21vZHVsZV9zdGF0ZXMlM0ElMjB0cnVlJTBBJTIwJTIwZnNkcF91c2Vfb3JpZ19wYXJhbXMlM0ElMjBmYWxzZSUwQW1hY2hpbmVfcmFuayUzQSUyMDAlMEFtYWluX3RyYWluaW5nX2Z1bmN0aW9uJTNBJTIwbWFpbiUwQW1peGVkX3ByZWNpc2lvbiUzQSUyMGJmMTYlMEFudW1fbWFjaGluZXMlM0ElMjAxJTBBbnVtX3Byb2Nlc3NlcyUzQSUyMDglMEFyZHp2X2JhY2tlbmQlM0ElMjBzdGF0aWMlMEFzYW1lX25ldHdvcmslM0ElMjB0cnVlJTBBdHB1X2VudiUzQSUyMCU1QiU1RCUwQXRwdV91c2VfY2x1c3RlciUzQSUyMGZhbHNlJTBBdHB1X3VzZV9zdWRvJTNBJTIwZmFsc2UlMEF1c2VfY3B1JTNBJTIwZmFsc2U=",highlighted:`<span class="hljs-attr">compute_environment:</span> <span class="hljs-string">LOCAL_MACHINE</span>
<span class="hljs-attr">debug:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">FSDP</span>
<span class="hljs-attr">downcast_bf16:</span> <span class="hljs-string">&#x27;no&#x27;</span>
<span class="hljs-attr">fsdp_config:</span>
  <span class="hljs-attr">fsdp_auto_wrap_policy:</span> <span class="hljs-string">TRANSFORMER_BASED_WRAP</span>
  <span class="hljs-attr">fsdp_backward_prefetch:</span> <span class="hljs-string">BACKWARD_PRE</span>
  <span class="hljs-attr">fsdp_cpu_ram_efficient_loading:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_forward_prefetch:</span> <span class="hljs-literal">false</span>
  <span class="hljs-attr">fsdp_offload_params:</span> <span class="hljs-literal">false</span>
  <span class="hljs-attr">fsdp_sharding_strategy:</span> <span class="hljs-string">FULL_SHARD</span>
  <span class="hljs-attr">fsdp_state_dict_type:</span> <span class="hljs-string">SHARDED_STATE_DICT</span>
  <span class="hljs-attr">fsdp_sync_module_states:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_use_orig_params:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">machine_rank:</span> <span class="hljs-number">0</span>
<span class="hljs-attr">main_training_function:</span> <span class="hljs-string">main</span>
<span class="hljs-attr">mixed_precision:</span> <span class="hljs-string">bf16</span>
<span class="hljs-attr">num_machines:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">num_processes:</span> <span class="hljs-number">8</span>
<span class="hljs-attr">rdzv_backend:</span> <span class="hljs-string">static</span>
<span class="hljs-attr">same_network:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">tpu_env:</span> []
<span class="hljs-attr">tpu_use_cluster:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">tpu_use_sudo:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">use_cpu:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),R=new w({props:{title:"Launch command",local:"launch-command",headingTag:"h2"}}),Y=new q({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tY29uZmlnX2ZpbGUlMjAlMjJjb25maWdzJTJGZnNkcF9jb25maWcueWFtbCUyMiUyMCUyMHRyYWluLnB5JTIwJTVDJTBBLS1zZWVkJTIwMTAwJTIwJTVDJTBBLS1tb2RlbF9uYW1lX29yX3BhdGglMjAlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03MGItaGYlMjIlMjAlNUMlMEEtLWRhdGFzZXRfbmFtZSUyMCUyMnNtYW5ncnVsJTJGdWx0cmFjaGF0LTEway1jaGF0bWwlMjIlMjAlNUMlMEEtLWNoYXRfdGVtcGxhdGVfZm9ybWF0JTIwJTIyY2hhdG1sJTIyJTIwJTVDJTBBLS1hZGRfc3BlY2lhbF90b2tlbnMlMjBGYWxzZSUyMCU1QyUwQS0tYXBwZW5kX2NvbmNhdF90b2tlbiUyMEZhbHNlJTIwJTVDJTBBLS1zcGxpdHMlMjAlMjJ0cmFpbiUyQ3Rlc3QlMjIlMjAlNUMlMEEtLW1heF9zZXFfbGVuJTIwMjA0OCUyMCU1QyUwQS0tbnVtX3RyYWluX2Vwb2NocyUyMDElMjAlNUMlMEEtLWxvZ2dpbmdfc3RlcHMlMjA1JTIwJTVDJTBBLS1sb2dfbGV2ZWwlMjAlMjJpbmZvJTIyJTIwJTVDJTBBLS1sb2dnaW5nX3N0cmF0ZWd5JTIwJTIyc3RlcHMlMjIlMjAlNUMlMEEtLWV2YWx1YXRpb25fc3RyYXRlZ3klMjAlMjJlcG9jaCUyMiUyMCU1QyUwQS0tc2F2ZV9zdHJhdGVneSUyMCUyMmVwb2NoJTIyJTIwJTVDJTBBLS1wdXNoX3RvX2h1YiUyMCU1QyUwQS0taHViX3ByaXZhdGVfcmVwbyUyMFRydWUlMjAlNUMlMEEtLWh1Yl9zdHJhdGVneSUyMCUyMmV2ZXJ5X3NhdmUlMjIlMjAlNUMlMEEtLWJmMTYlMjBUcnVlJTIwJTVDJTBBLS1wYWNraW5nJTIwVHJ1ZSUyMCU1QyUwQS0tbGVhcm5pbmdfcmF0ZSUyMDFlLTQlMjAlNUMlMEEtLWxyX3NjaGVkdWxlcl90eXBlJTIwJTIyY29zaW5lJTIyJTIwJTVDJTBBLS13ZWlnaHRfZGVjYXklMjAxZS00JTIwJTVDJTBBLS13YXJtdXBfcmF0aW8lMjAwLjAlMjAlNUMlMEEtLW1heF9ncmFkX25vcm0lMjAxLjAlMjAlNUMlMEEtLW91dHB1dF9kaXIlMjAlMjJsbGFtYS1zZnQtbG9yYS1mc2RwJTIyJTIwJTVDJTBBLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjA4JTIwJTVDJTBBLS1wZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUyMDglMjAlNUMlMEEtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMDQlMjAlNUMlMEEtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjBUcnVlJTIwJTVDJTBBLS11c2VfcmVlbnRyYW50JTIwRmFsc2UlMjAlNUMlMEEtLWRhdGFzZXRfdGV4dF9maWVsZCUyMCUyMmNvbnRlbnQlMjIlMjAlNUMlMEEtLXVzZV9mbGFzaF9hdHRuJTIwVHJ1ZSUyMCU1QyUwQS0tdXNlX3BlZnRfbG9yYSUyMFRydWUlMjAlNUMlMEEtLWxvcmFfciUyMDglMjAlNUMlMEEtLWxvcmFfYWxwaGElMjAxNiUyMCU1QyUwQS0tbG9yYV9kcm9wb3V0JTIwMC4xJTIwJTVDJTBBLS1sb3JhX3RhcmdldF9tb2R1bGVzJTIwJTIyYWxsLWxpbmVhciUyMiUyMCU1QyUwQS0tdXNlXzRiaXRfcXVhbnRpemF0aW9uJTIwRmFsc2U=",highlighted:`accelerate launch --config_file <span class="hljs-string">&quot;configs/fsdp_config.yaml&quot;</span>  train.py \\
--seed 100 \\
--model_name_or_path <span class="hljs-string">&quot;meta-llama/Llama-2-70b-hf&quot;</span> \\
--dataset_name <span class="hljs-string">&quot;smangrul/ultrachat-10k-chatml&quot;</span> \\
--chat_template_format <span class="hljs-string">&quot;chatml&quot;</span> \\
--add_special_tokens False \\
--append_concat_token False \\
--splits <span class="hljs-string">&quot;train,test&quot;</span> \\
--max_seq_len 2048 \\
--num_train_epochs 1 \\
--logging_steps 5 \\
--log_level <span class="hljs-string">&quot;info&quot;</span> \\
--logging_strategy <span class="hljs-string">&quot;steps&quot;</span> \\
--evaluation_strategy <span class="hljs-string">&quot;epoch&quot;</span> \\
--save_strategy <span class="hljs-string">&quot;epoch&quot;</span> \\
--push_to_hub \\
--hub_private_repo True \\
--hub_strategy <span class="hljs-string">&quot;every_save&quot;</span> \\
--bf16 True \\
--packing True \\
--learning_rate 1e-4 \\
--lr_scheduler_type <span class="hljs-string">&quot;cosine&quot;</span> \\
--weight_decay 1e-4 \\
--warmup_ratio 0.0 \\
--max_grad_norm 1.0 \\
--output_dir <span class="hljs-string">&quot;llama-sft-lora-fsdp&quot;</span> \\
--per_device_train_batch_size 8 \\
--per_device_eval_batch_size 8 \\
--gradient_accumulation_steps 4 \\
--gradient_checkpointing True \\
--use_reentrant False \\
--dataset_text_field <span class="hljs-string">&quot;content&quot;</span> \\
--use_flash_attn True \\
--use_peft_lora True \\
--lora_r 8 \\
--lora_alpha 16 \\
--lora_dropout 0.1 \\
--lora_target_modules <span class="hljs-string">&quot;all-linear&quot;</span> \\
--use_4bit_quantization False`,wrap:!1}}),v=new w({props:{title:"The important parts",local:"the-important-parts",headingTag:"h2"}}),C=new q({props:{code:"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",highlighted:`<span class="hljs-comment"># trainer</span>
trainer = SFTTrainer(
    model=model,
    tokenizer=tokenizer,
    args=training_args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
    peft_config=peft_config,
    packing=data_args.packing,
    dataset_kwargs={
        <span class="hljs-string">&quot;append_concat_token&quot;</span>: data_args.append_concat_token,
        <span class="hljs-string">&quot;add_special_tokens&quot;</span>: data_args.add_special_tokens,
    },
    dataset_text_field=data_args.dataset_text_field,
    max_seq_length=data_args.max_seq_length,
)
trainer.accelerator.<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{trainer.model}</span>&quot;</span>)
<span class="hljs-keyword">if</span> model_args.use_peft_lora:
    <span class="hljs-comment"># handle PEFT+FSDP case</span>
    trainer.model.print_trainable_parameters()
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">getattr</span>(trainer.accelerator.state, <span class="hljs-string">&quot;fsdp_plugin&quot;</span>, <span class="hljs-literal">None</span>):
        <span class="hljs-keyword">from</span> peft.utils.other <span class="hljs-keyword">import</span> fsdp_auto_wrap_policy

        fsdp_plugin = trainer.accelerator.state.fsdp_plugin
        fsdp_plugin.auto_wrap_policy = fsdp_auto_wrap_policy(trainer.model)

<span class="hljs-comment"># train</span>
checkpoint = <span class="hljs-literal">None</span>
<span class="hljs-keyword">if</span> training_args.resume_from_checkpoint <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    checkpoint = training_args.resume_from_checkpoint
trainer.train(resume_from_checkpoint=checkpoint)

<span class="hljs-comment"># saving final model</span>
<span class="hljs-keyword">if</span> trainer.is_fsdp_enabled:
    trainer.accelerator.state.fsdp_plugin.set_state_dict_type(<span class="hljs-string">&quot;FULL_STATE_DICT&quot;</span>)
trainer.save_model()`,wrap:!1}}),$=new q({props:{code:"aWYlMjBnZXRhdHRyKHRyYWluZXIuYWNjZWxlcmF0b3Iuc3RhdGUlMkMlMjAlMjJmc2RwX3BsdWdpbiUyMiUyQyUyME5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwZnJvbSUyMHBlZnQudXRpbHMub3RoZXIlMjBpbXBvcnQlMjBmc2RwX2F1dG9fd3JhcF9wb2xpY3klMEElMEElMjAlMjAlMjAlMjBmc2RwX3BsdWdpbiUyMCUzRCUyMHRyYWluZXIuYWNjZWxlcmF0b3Iuc3RhdGUuZnNkcF9wbHVnaW4lMEElMjAlMjAlMjAlMjBmc2RwX3BsdWdpbi5hdXRvX3dyYXBfcG9saWN5JTIwJTNEJTIwZnNkcF9hdXRvX3dyYXBfcG9saWN5KHRyYWluZXIubW9kZWwp",highlighted:`if getattr(trainer.accelerator.<span class="hljs-keyword">state</span>, <span class="hljs-string">&quot;fsdp_plugin&quot;</span>, None):
    <span class="hljs-keyword">from</span> peft.utils.other import fsdp_auto_wrap_policy

    fsdp_plugin = trainer.accelerator.<span class="hljs-keyword">state</span>.fsdp_plugin
    fsdp_plugin.auto_wrap_policy = fsdp_auto_wrap_policy(trainer.model)`,wrap:!1}}),k=new w({props:{title:"Memory usage",local:"memory-usage",headingTag:"h2"}}),L=new w({props:{title:"More resources",local:"more-resources",headingTag:"h2"}}),Q=new w({props:{title:"Caveats",local:"caveats",headingTag:"h2"}}),{c(){u=i("meta"),K=s(),P=i("p"),O=s(),c(y.$$.fragment),tt=s(),J=i("p"),J.innerHTML=Et,et=s(),_=i("p"),_.textContent=vt,lt=s(),c(g.$$.fragment),at=s(),j=i("p"),j.innerHTML=Gt,st=s(),c(b.$$.fragment),nt=s(),U=i("p"),U.innerHTML=Nt,it=s(),F=i("p"),F.textContent=Ct,pt=s(),c(B.$$.fragment),rt=s(),W=i("p"),W.textContent=St,ct=s(),M=i("div"),M.innerHTML=$t,ot=s(),Z=i("small"),Z.textContent=kt,dt=s(),I=i("p"),I.innerHTML=At,mt=s(),c(X.$$.fragment),ft=s(),c(R.$$.fragment),ht=s(),V=i("p"),V.innerHTML=xt,ut=s(),c(Y.$$.fragment),Mt=s(),E=i("p"),E.innerHTML=Lt,Tt=s(),c(v.$$.fragment),wt=s(),G=i("p"),G.textContent=Ht,yt=s(),N=i("p"),N.innerHTML=Qt,Jt=s(),c(C.$$.fragment),_t=s(),S=i("p"),S.innerHTML=zt,gt=s(),c($.$$.fragment),jt=s(),c(k.$$.fragment),bt=s(),A=i("p"),A.innerHTML=Pt,Ut=s(),T=i("div"),T.innerHTML=Dt,Ft=s(),x=i("small"),x.textContent=qt,Bt=s(),c(L.$$.fragment),Wt=s(),H=i("p"),H.innerHTML=Kt,Zt=s(),c(Q.$$.fragment),It=s(),z=i("ol"),z.innerHTML=Ot,Xt=s(),D=i("p"),this.h()},l(t){const e=ie("svelte-u9bgzb",document.head);u=p(e,"META",{name:!0,content:!0}),e.forEach(l),K=n(t),P=p(t,"P",{}),te(P).forEach(l),O=n(t),o(y.$$.fragment,t),tt=n(t),J=p(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1552p1b"&&(J.innerHTML=Et),et=n(t),_=p(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1o8k4c8"&&(_.textContent=vt),lt=n(t),o(g.$$.fragment,t),at=n(t),j=p(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-14llqsi"&&(j.innerHTML=Gt),st=n(t),o(b.$$.fragment,t),nt=n(t),U=p(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-zjx7c1"&&(U.innerHTML=Nt),it=n(t),F=p(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1oar51z"&&(F.textContent=Ct),pt=n(t),o(B.$$.fragment,t),rt=n(t),W=p(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1dbl6fp"&&(W.textContent=St),ct=n(t),M=p(t,"DIV",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-j046au"&&(M.innerHTML=$t),ot=n(t),Z=p(t,"SMALL",{"data-svelte-h":!0}),r(Z)!=="svelte-rynbwn"&&(Z.textContent=kt),dt=n(t),I=p(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1iebck7"&&(I.innerHTML=At),mt=n(t),o(X.$$.fragment,t),ft=n(t),o(R.$$.fragment,t),ht=n(t),V=p(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1vkau4u"&&(V.innerHTML=xt),ut=n(t),o(Y.$$.fragment,t),Mt=n(t),E=p(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1ymw855"&&(E.innerHTML=Lt),Tt=n(t),o(v.$$.fragment,t),wt=n(t),G=p(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-y7jq4k"&&(G.textContent=Ht),yt=n(t),N=p(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1p9fmwx"&&(N.innerHTML=Qt),Jt=n(t),o(C.$$.fragment,t),_t=n(t),S=p(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-w1wqr8"&&(S.innerHTML=zt),gt=n(t),o($.$$.fragment,t),jt=n(t),o(k.$$.fragment,t),bt=n(t),A=p(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1l81qml"&&(A.innerHTML=Pt),Ut=n(t),T=p(t,"DIV",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-1w1ze4b"&&(T.innerHTML=Dt),Ft=n(t),x=p(t,"SMALL",{"data-svelte-h":!0}),r(x)!=="svelte-8v78s3"&&(x.textContent=qt),Bt=n(t),o(L.$$.fragment,t),Wt=n(t),H=p(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-yjfr5u"&&(H.innerHTML=Kt),Zt=n(t),o(Q.$$.fragment,t),It=n(t),z=p(t,"OL",{"data-svelte-h":!0}),r(z)!=="svelte-12w73be"&&(z.innerHTML=Ot),Xt=n(t),D=p(t,"P",{}),te(D).forEach(l),this.h()},h(){Vt(u,"name","hf:doc:metadata"),Vt(u,"content",ce),Vt(M,"class","flex justify-center"),Vt(T,"class","flex justify-center")},m(t,e){pe(document.head,u),a(t,K,e),a(t,P,e),a(t,O,e),d(y,t,e),a(t,tt,e),a(t,J,e),a(t,et,e),a(t,_,e),a(t,lt,e),d(g,t,e),a(t,at,e),a(t,j,e),a(t,st,e),d(b,t,e),a(t,nt,e),a(t,U,e),a(t,it,e),a(t,F,e),a(t,pt,e),d(B,t,e),a(t,rt,e),a(t,W,e),a(t,ct,e),a(t,M,e),a(t,ot,e),a(t,Z,e),a(t,dt,e),a(t,I,e),a(t,mt,e),d(X,t,e),a(t,ft,e),d(R,t,e),a(t,ht,e),a(t,V,e),a(t,ut,e),d(Y,t,e),a(t,Mt,e),a(t,E,e),a(t,Tt,e),d(v,t,e),a(t,wt,e),a(t,G,e),a(t,yt,e),a(t,N,e),a(t,Jt,e),d(C,t,e),a(t,_t,e),a(t,S,e),a(t,gt,e),d($,t,e),a(t,jt,e),d(k,t,e),a(t,bt,e),a(t,A,e),a(t,Ut,e),a(t,T,e),a(t,Ft,e),a(t,x,e),a(t,Bt,e),d(L,t,e),a(t,Wt,e),a(t,H,e),a(t,Zt,e),d(Q,t,e),a(t,It,e),a(t,z,e),a(t,Xt,e),a(t,D,e),Rt=!0},p:le,i(t){Rt||(m(y.$$.fragment,t),m(g.$$.fragment,t),m(b.$$.fragment,t),m(B.$$.fragment,t),m(X.$$.fragment,t),m(R.$$.fragment,t),m(Y.$$.fragment,t),m(v.$$.fragment,t),m(C.$$.fragment,t),m($.$$.fragment,t),m(k.$$.fragment,t),m(L.$$.fragment,t),m(Q.$$.fragment,t),Rt=!0)},o(t){f(y.$$.fragment,t),f(g.$$.fragment,t),f(b.$$.fragment,t),f(B.$$.fragment,t),f(X.$$.fragment,t),f(R.$$.fragment,t),f(Y.$$.fragment,t),f(v.$$.fragment,t),f(C.$$.fragment,t),f($.$$.fragment,t),f(k.$$.fragment,t),f(L.$$.fragment,t),f(Q.$$.fragment,t),Rt=!1},d(t){t&&(l(K),l(P),l(O),l(tt),l(J),l(et),l(_),l(lt),l(at),l(j),l(st),l(nt),l(U),l(it),l(F),l(pt),l(rt),l(W),l(ct),l(M),l(ot),l(Z),l(dt),l(I),l(mt),l(ft),l(ht),l(V),l(ut),l(Mt),l(E),l(Tt),l(wt),l(G),l(yt),l(N),l(Jt),l(_t),l(S),l(gt),l(jt),l(bt),l(A),l(Ut),l(T),l(Ft),l(x),l(Bt),l(Wt),l(H),l(Zt),l(It),l(z),l(Xt),l(D)),l(u),h(y,t),h(g,t),h(b,t),h(B,t),h(X,t),h(R,t),h(Y,t),h(v,t),h(C,t),h($,t),h(k,t),h(L,t),h(Q,t)}}}const ce='{"title":"Fully Sharded Data Parallel","local":"fully-sharded-data-parallel","sections":[],"depth":1}';function oe(Yt){return ae(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ue extends se{constructor(u){super(),ne(this,u,oe,re,ee,{})}}export{ue as component};
