import{s as kt,o as Ht,n as St}from"../chunks/scheduler.9bc65507.js";import{S as Wt,i as Gt,g as a,s,r as d,A as Rt,h as i,f as n,c as o,j as Bt,u as p,x as r,k as It,y as Vt,a as l,v as m,d as c,t as h,w as u}from"../chunks/index.707bf1b6.js";import{T as Nt}from"../chunks/Tip.c2ecdbf4.js";import{C as pe}from"../chunks/CodeBlock.54a9f38d.js";import{H as y}from"../chunks/Heading.342b1fa6.js";function Qt(ce){let f,T=`This is the very beginning of our experiments with TorchScript and we are still
exploring its capabilities with variable-input-size models. It is a focus of interest to
us and we will deepen our analysis in upcoming releases, with more code examples, a more
flexible implementation, and benchmarks comparing Python-based codes with compiled
TorchScript.`;return{c(){f=a("p"),f.textContent=T},l(M){f=i(M,"P",{"data-svelte-h":!0}),r(f)!=="svelte-3gxwq2"&&(f.textContent=T)},m(M,de){l(M,f,de)},p:St,d(M){M&&n(f)}}}function zt(ce){let f,T,M,de,g,he,w,ue,b,st='According to the <a href="https://pytorch.org/docs/stable/jit.html" rel="nofollow">TorchScript documentation</a>:',fe,J,ot="<p>TorchScript is a way to create serializable and optimizable models from PyTorch code.</p>",Me,v,at=`There are two PyTorch modules, <a href="https://pytorch.org/docs/stable/jit.html" rel="nofollow">JIT and
TRACE</a>, that allow developers to export their
models to be reused in other programs like efficiency-oriented C++ programs.`,ye,U,it=`We provide an interface that allows you to export 🤗 Transformers models to TorchScript
so they can be reused in a different environment than PyTorch-based Python programs.
Here, we explain how to export and use our models using TorchScript.`,we,$,rt="Exporting a model requires two things:",Te,j,dt="<li>model instantiation with the <code>torchscript</code> flag</li> <li>a forward pass with dummy inputs</li>",ge,C,pt=`These necessities imply several things developers should be careful about as detailed
below.`,be,Z,Je,_,mt=`The <code>torchscript</code> flag is necessary because most of the 🤗 Transformers language models
have tied weights between their <code>Embedding</code> layer and their <code>Decoding</code> layer.
TorchScript does not allow you to export models that have tied weights, so it is
necessary to untie and clone the weights beforehand.`,ve,x,ct=`Models instantiated with the <code>torchscript</code> flag have their <code>Embedding</code> layer and
<code>Decoding</code> layer separated, which means that they should not be trained down the line.
Training would desynchronize the two layers, leading to unexpected results.`,Ue,B,ht=`This is not the case for models that do not have a language model head, as those do not
have tied weights. These models can be safely exported without the <code>torchscript</code> flag.`,$e,I,je,k,ut=`The dummy inputs are used for a models forward pass. While the inputs’ values are
propagated through the layers, PyTorch keeps track of the different operations executed
on each tensor. These recorded operations are then used to create the <em>trace</em> of the
model.`,Ce,H,ft=`The trace is created relative to the inputs’ dimensions. It is therefore constrained by
the dimensions of the dummy input, and will not work for any other sequence length or
batch size. When trying with a different size, the following error is raised:`,Ze,S,_e,W,Mt=`We recommended you trace the model with a dummy input size at least as large as the
largest input that will be fed to the model during inference. Padding can help fill the
missing values. However, since the model is traced with a larger input size, the
dimensions of the matrix will also be large, resulting in more calculations.`,xe,G,yt=`Be careful of the total number of operations done on each input and follow the
performance closely when exporting varying sequence-length models.`,Be,R,Ie,V,wt=`This section demonstrates how to save and load models as well as how to use the trace
for inference.`,ke,N,He,Q,Tt=`To export a <code>BertModel</code> with TorchScript, instantiate <code>BertModel</code> from the <code>BertConfig</code>
class and then save it to disk under the filename <code>traced_bert.pt</code>:`,Se,z,We,X,Ge,E,gt=`Now you can load the previously saved <code>BertModel</code>, <code>traced_bert.pt</code>, from disk and use
it on the previously initialised <code>dummy_input</code>:`,Re,L,Ve,A,Ne,P,bt="Use the traced model for inference by using its <code>__call__</code> dunder method:",Qe,Y,ze,F,Xe,D,Jt=`AWS introduced the <a href="https://aws.amazon.com/ec2/instance-types/inf1/" rel="nofollow">Amazon EC2 Inf1</a>
instance family for low cost, high performance machine learning inference in the cloud.
The Inf1 instances are powered by the AWS Inferentia chip, a custom-built hardware
accelerator, specializing in deep learning inferencing workloads. <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/#" rel="nofollow">AWS
Neuron</a> is the SDK for
Inferentia that supports tracing and optimizing transformers models for deployment on
Inf1. The Neuron SDK provides:`,Ee,q,vt=`<li>Easy-to-use API with one line of code change to trace and optimize a TorchScript
model for inference in the cloud.</li> <li>Out of the box performance optimizations for <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/neuron-guide/benchmark/%3E" rel="nofollow">improved
cost-performance</a>.</li> <li>Support for Hugging Face transformers models built with either
<a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/src/examples/pytorch/bert_tutorial/tutorial_pretrained_bert.html" rel="nofollow">PyTorch</a>
or
<a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/src/examples/tensorflow/huggingface_bert/huggingface_bert.html" rel="nofollow">TensorFlow</a>.</li>`,Le,K,Ae,O,Ut=`Transformers models based on the <a href="https://huggingface.co/docs/transformers/main/model_doc/bert" rel="nofollow">BERT (Bidirectional Encoder Representations from
Transformers)</a>
architecture, or its variants such as
<a href="https://huggingface.co/docs/transformers/main/model_doc/distilbert" rel="nofollow">distilBERT</a> and
<a href="https://huggingface.co/docs/transformers/main/model_doc/roberta" rel="nofollow">roBERTa</a> run best on
Inf1 for non-generative tasks such as extractive question answering, sequence
classification, and token classification. However, text generation tasks can still be
adapted to run on Inf1 according to this <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/src/examples/pytorch/transformers-marianmt.html" rel="nofollow">AWS Neuron MarianMT
tutorial</a>.
More information about models that can be converted out of the box on Inferentia can be
found in the <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/neuron-guide/models/models-inferentia.html#models-inferentia" rel="nofollow">Model Architecture
Fit</a>
section of the Neuron documentation.`,Pe,ee,Ye,te,$t=`Using AWS Neuron to convert models requires a <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/neuron-guide/neuron-frameworks/pytorch-neuron/index.html#installation-guide" rel="nofollow">Neuron SDK
environment</a>
which comes preconfigured on <a href="https://docs.aws.amazon.com/dlami/latest/devguide/tutorial-inferentia-launching.html" rel="nofollow">AWS Deep Learning
AMI</a>.`,Fe,ne,De,le,jt=`Convert a model for AWS NEURON using the same code from <a href="torchscript#using-torchscript-in-python">Using TorchScript in
Python</a> to trace a <code>BertModel</code>. Import the
<code>torch.neuron</code> framework extension to access the components of the Neuron SDK through a
Python API:`,qe,se,Ke,oe,Ct="You only need to modify the following line:",Oe,ae,et,ie,Zt="This enables the Neuron SDK to trace the model and optimize it for Inf1 instances.",tt,re,_t=`To learn more about AWS Neuron SDK features, tools, example tutorials and latest
updates, please see the <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/index.html" rel="nofollow">AWS NeuronSDK
documentation</a>.`,nt,me,lt;return g=new y({props:{title:"Export to TorchScript",local:"export-to-torchscript",headingTag:"h1"}}),w=new Nt({props:{$$slots:{default:[Qt]},$$scope:{ctx:ce}}}),Z=new y({props:{title:"TorchScript flag and tied weights",local:"torchscript-flag-and-tied-weights",headingTag:"h2"}}),I=new y({props:{title:"Dummy inputs and standard lengths",local:"dummy-inputs-and-standard-lengths",headingTag:"h2"}}),S=new pe({props:{code:"JTYwVGhlJTIwZXhwYW5kZWQlMjBzaXplJTIwb2YlMjB0aGUlMjB0ZW5zb3IlMjAoMyklMjBtdXN0JTIwbWF0Y2glMjB0aGUlMjBleGlzdGluZyUyMHNpemUlMjAoNyklMjBhdCUyMG5vbi1zaW5nbGV0b24lMjBkaW1lbnNpb24lMjAyJTYw",highlighted:'`The expanded <span class="hljs-built_in">size</span> of the tensor (<span class="hljs-number">3</span>) must match the existing <span class="hljs-built_in">size</span> (<span class="hljs-number">7</span>) at non-singleton <span class="hljs-keyword">dimension</span> <span class="hljs-number">2</span>`',wrap:!1}}),R=new y({props:{title:"Using TorchScript in Python",local:"using-torchscript-in-python",headingTag:"h2"}}),N=new y({props:{title:"Saving a model",local:"saving-a-model",headingTag:"h3"}}),z=new pe({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertModel, BertTokenizer, BertConfig
<span class="hljs-keyword">import</span> torch

enc = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)

<span class="hljs-comment"># Tokenizing input text</span>
text = <span class="hljs-string">&quot;[CLS] Who was Jim Henson ? [SEP] Jim Henson was a puppeteer [SEP]&quot;</span>
tokenized_text = enc.tokenize(text)

<span class="hljs-comment"># Masking one of the input tokens</span>
masked_index = <span class="hljs-number">8</span>
tokenized_text[masked_index] = <span class="hljs-string">&quot;[MASK]&quot;</span>
indexed_tokens = enc.convert_tokens_to_ids(tokenized_text)
segments_ids = [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]

<span class="hljs-comment"># Creating a dummy input</span>
tokens_tensor = torch.tensor([indexed_tokens])
segments_tensors = torch.tensor([segments_ids])
dummy_input = [tokens_tensor, segments_tensors]

<span class="hljs-comment"># Initializing the model with the torchscript flag</span>
<span class="hljs-comment"># Flag set to True even though it is not necessary as this model does not have an LM Head.</span>
config = BertConfig(
    vocab_size_or_config_json_file=<span class="hljs-number">32000</span>,
    hidden_size=<span class="hljs-number">768</span>,
    num_hidden_layers=<span class="hljs-number">12</span>,
    num_attention_heads=<span class="hljs-number">12</span>,
    intermediate_size=<span class="hljs-number">3072</span>,
    torchscript=<span class="hljs-literal">True</span>,
)

<span class="hljs-comment"># Instantiating the model</span>
model = BertModel(config)

<span class="hljs-comment"># The model needs to be in evaluation mode</span>
model.<span class="hljs-built_in">eval</span>()

<span class="hljs-comment"># If you are instantiating the model with *from_pretrained* you can also easily set the TorchScript flag</span>
model = BertModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>, torchscript=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Creating the trace</span>
traced_model = torch.jit.trace(model, [tokens_tensor, segments_tensors])
torch.jit.save(traced_model, <span class="hljs-string">&quot;traced_bert.pt&quot;</span>)`,wrap:!1}}),X=new y({props:{title:"Loading a model",local:"loading-a-model",headingTag:"h3"}}),L=new pe({props:{code:"bG9hZGVkX21vZGVsJTIwJTNEJTIwdG9yY2guaml0LmxvYWQoJTIydHJhY2VkX2JlcnQucHQlMjIpJTBBbG9hZGVkX21vZGVsLmV2YWwoKSUwQSUwQWFsbF9lbmNvZGVyX2xheWVycyUyQyUyMHBvb2xlZF9vdXRwdXQlMjAlM0QlMjBsb2FkZWRfbW9kZWwoKmR1bW15X2lucHV0KQ==",highlighted:`loaded_model = torch.jit.load(<span class="hljs-string">&quot;traced_bert.pt&quot;</span>)
loaded_model.<span class="hljs-built_in">eval</span>()

all_encoder_layers, pooled_output = loaded_model(*dummy_input)`,wrap:!1}}),A=new y({props:{title:"Using a traced model for inference",local:"using-a-traced-model-for-inference",headingTag:"h3"}}),Y=new pe({props:{code:"dHJhY2VkX21vZGVsKHRva2Vuc190ZW5zb3IlMkMlMjBzZWdtZW50c190ZW5zb3JzKQ==",highlighted:"traced_model(tokens_tensor, segments_tensors)",wrap:!1}}),F=new y({props:{title:"Deploy Hugging Face TorchScript models to AWS with the Neuron SDK",local:"deploy-hugging-face-torchscript-models-to-aws-with-the-neuron-sdk",headingTag:"h2"}}),K=new y({props:{title:"Implications",local:"implications",headingTag:"h3"}}),ee=new y({props:{title:"Dependencies",local:"dependencies",headingTag:"h3"}}),ne=new y({props:{title:"Converting a model for AWS Neuron",local:"converting-a-model-for-aws-neuron",headingTag:"h3"}}),se=new pe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRNb2RlbCUyQyUyMEJlcnRUb2tlbml6ZXIlMkMlMjBCZXJ0Q29uZmlnJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5uZXVyb24=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertModel, BertTokenizer, BertConfig
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.neuron`,wrap:!1}}),ae=new pe({props:{code:"LSUyMHRvcmNoLmppdC50cmFjZShtb2RlbCUyQyUyMCU1QnRva2Vuc190ZW5zb3IlMkMlMjBzZWdtZW50c190ZW5zb3JzJTVEKSUwQSUyQiUyMHRvcmNoLm5ldXJvbi50cmFjZShtb2RlbCUyQyUyMCU1QnRva2VuX3RlbnNvciUyQyUyMHNlZ21lbnRzX3RlbnNvcnMlNUQp",highlighted:`<span class="hljs-deletion">- torch.jit.trace(model, [tokens_tensor, segments_tensors])</span>
<span class="hljs-addition">+ torch.neuron.trace(model, [token_tensor, segments_tensors])</span>`,wrap:!1}}),{c(){f=a("meta"),T=s(),M=a("p"),de=s(),d(g.$$.fragment),he=s(),d(w.$$.fragment),ue=s(),b=a("p"),b.innerHTML=st,fe=s(),J=a("blockquote"),J.innerHTML=ot,Me=s(),v=a("p"),v.innerHTML=at,ye=s(),U=a("p"),U.textContent=it,we=s(),$=a("p"),$.textContent=rt,Te=s(),j=a("ul"),j.innerHTML=dt,ge=s(),C=a("p"),C.textContent=pt,be=s(),d(Z.$$.fragment),Je=s(),_=a("p"),_.innerHTML=mt,ve=s(),x=a("p"),x.innerHTML=ct,Ue=s(),B=a("p"),B.innerHTML=ht,$e=s(),d(I.$$.fragment),je=s(),k=a("p"),k.innerHTML=ut,Ce=s(),H=a("p"),H.textContent=ft,Ze=s(),d(S.$$.fragment),_e=s(),W=a("p"),W.textContent=Mt,xe=s(),G=a("p"),G.textContent=yt,Be=s(),d(R.$$.fragment),Ie=s(),V=a("p"),V.textContent=wt,ke=s(),d(N.$$.fragment),He=s(),Q=a("p"),Q.innerHTML=Tt,Se=s(),d(z.$$.fragment),We=s(),d(X.$$.fragment),Ge=s(),E=a("p"),E.innerHTML=gt,Re=s(),d(L.$$.fragment),Ve=s(),d(A.$$.fragment),Ne=s(),P=a("p"),P.innerHTML=bt,Qe=s(),d(Y.$$.fragment),ze=s(),d(F.$$.fragment),Xe=s(),D=a("p"),D.innerHTML=Jt,Ee=s(),q=a("ol"),q.innerHTML=vt,Le=s(),d(K.$$.fragment),Ae=s(),O=a("p"),O.innerHTML=Ut,Pe=s(),d(ee.$$.fragment),Ye=s(),te=a("p"),te.innerHTML=$t,Fe=s(),d(ne.$$.fragment),De=s(),le=a("p"),le.innerHTML=jt,qe=s(),d(se.$$.fragment),Ke=s(),oe=a("p"),oe.textContent=Ct,Oe=s(),d(ae.$$.fragment),et=s(),ie=a("p"),ie.textContent=Zt,tt=s(),re=a("p"),re.innerHTML=_t,nt=s(),me=a("p"),this.h()},l(e){const t=Rt("svelte-u9bgzb",document.head);f=i(t,"META",{name:!0,content:!0}),t.forEach(n),T=o(e),M=i(e,"P",{}),Bt(M).forEach(n),de=o(e),p(g.$$.fragment,e),he=o(e),p(w.$$.fragment,e),ue=o(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-16vv52d"&&(b.innerHTML=st),fe=o(e),J=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(J)!=="svelte-143rw8d"&&(J.innerHTML=ot),Me=o(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1ntf3wg"&&(v.innerHTML=at),ye=o(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-3e4o7k"&&(U.textContent=it),we=o(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1mmf9kh"&&($.textContent=rt),Te=o(e),j=i(e,"UL",{"data-svelte-h":!0}),r(j)!=="svelte-1yusujd"&&(j.innerHTML=dt),ge=o(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-9awfof"&&(C.textContent=pt),be=o(e),p(Z.$$.fragment,e),Je=o(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-qq8y9a"&&(_.innerHTML=mt),ve=o(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-rijh7h"&&(x.innerHTML=ct),Ue=o(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1cg0vrq"&&(B.innerHTML=ht),$e=o(e),p(I.$$.fragment,e),je=o(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1an8gt1"&&(k.innerHTML=ut),Ce=o(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1pagcqs"&&(H.textContent=ft),Ze=o(e),p(S.$$.fragment,e),_e=o(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-e7h40q"&&(W.textContent=Mt),xe=o(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-k3vdvp"&&(G.textContent=yt),Be=o(e),p(R.$$.fragment,e),Ie=o(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-3ddxtn"&&(V.textContent=wt),ke=o(e),p(N.$$.fragment,e),He=o(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1y405n0"&&(Q.innerHTML=Tt),Se=o(e),p(z.$$.fragment,e),We=o(e),p(X.$$.fragment,e),Ge=o(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-uqg1ob"&&(E.innerHTML=gt),Re=o(e),p(L.$$.fragment,e),Ve=o(e),p(A.$$.fragment,e),Ne=o(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1prvnq1"&&(P.innerHTML=bt),Qe=o(e),p(Y.$$.fragment,e),ze=o(e),p(F.$$.fragment,e),Xe=o(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1kac3or"&&(D.innerHTML=Jt),Ee=o(e),q=i(e,"OL",{"data-svelte-h":!0}),r(q)!=="svelte-1h435mi"&&(q.innerHTML=vt),Le=o(e),p(K.$$.fragment,e),Ae=o(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1kv7oct"&&(O.innerHTML=Ut),Pe=o(e),p(ee.$$.fragment,e),Ye=o(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-f2qubg"&&(te.innerHTML=$t),Fe=o(e),p(ne.$$.fragment,e),De=o(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1flzoza"&&(le.innerHTML=jt),qe=o(e),p(se.$$.fragment,e),Ke=o(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-uv51ic"&&(oe.textContent=Ct),Oe=o(e),p(ae.$$.fragment,e),et=o(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1dylit2"&&(ie.textContent=Zt),tt=o(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-u8nslf"&&(re.innerHTML=_t),nt=o(e),me=i(e,"P",{}),Bt(me).forEach(n),this.h()},h(){It(f,"name","hf:doc:metadata"),It(f,"content",Xt)},m(e,t){Vt(document.head,f),l(e,T,t),l(e,M,t),l(e,de,t),m(g,e,t),l(e,he,t),m(w,e,t),l(e,ue,t),l(e,b,t),l(e,fe,t),l(e,J,t),l(e,Me,t),l(e,v,t),l(e,ye,t),l(e,U,t),l(e,we,t),l(e,$,t),l(e,Te,t),l(e,j,t),l(e,ge,t),l(e,C,t),l(e,be,t),m(Z,e,t),l(e,Je,t),l(e,_,t),l(e,ve,t),l(e,x,t),l(e,Ue,t),l(e,B,t),l(e,$e,t),m(I,e,t),l(e,je,t),l(e,k,t),l(e,Ce,t),l(e,H,t),l(e,Ze,t),m(S,e,t),l(e,_e,t),l(e,W,t),l(e,xe,t),l(e,G,t),l(e,Be,t),m(R,e,t),l(e,Ie,t),l(e,V,t),l(e,ke,t),m(N,e,t),l(e,He,t),l(e,Q,t),l(e,Se,t),m(z,e,t),l(e,We,t),m(X,e,t),l(e,Ge,t),l(e,E,t),l(e,Re,t),m(L,e,t),l(e,Ve,t),m(A,e,t),l(e,Ne,t),l(e,P,t),l(e,Qe,t),m(Y,e,t),l(e,ze,t),m(F,e,t),l(e,Xe,t),l(e,D,t),l(e,Ee,t),l(e,q,t),l(e,Le,t),m(K,e,t),l(e,Ae,t),l(e,O,t),l(e,Pe,t),m(ee,e,t),l(e,Ye,t),l(e,te,t),l(e,Fe,t),m(ne,e,t),l(e,De,t),l(e,le,t),l(e,qe,t),m(se,e,t),l(e,Ke,t),l(e,oe,t),l(e,Oe,t),m(ae,e,t),l(e,et,t),l(e,ie,t),l(e,tt,t),l(e,re,t),l(e,nt,t),l(e,me,t),lt=!0},p(e,[t]){const xt={};t&2&&(xt.$$scope={dirty:t,ctx:e}),w.$set(xt)},i(e){lt||(c(g.$$.fragment,e),c(w.$$.fragment,e),c(Z.$$.fragment,e),c(I.$$.fragment,e),c(S.$$.fragment,e),c(R.$$.fragment,e),c(N.$$.fragment,e),c(z.$$.fragment,e),c(X.$$.fragment,e),c(L.$$.fragment,e),c(A.$$.fragment,e),c(Y.$$.fragment,e),c(F.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(ne.$$.fragment,e),c(se.$$.fragment,e),c(ae.$$.fragment,e),lt=!0)},o(e){h(g.$$.fragment,e),h(w.$$.fragment,e),h(Z.$$.fragment,e),h(I.$$.fragment,e),h(S.$$.fragment,e),h(R.$$.fragment,e),h(N.$$.fragment,e),h(z.$$.fragment,e),h(X.$$.fragment,e),h(L.$$.fragment,e),h(A.$$.fragment,e),h(Y.$$.fragment,e),h(F.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(ne.$$.fragment,e),h(se.$$.fragment,e),h(ae.$$.fragment,e),lt=!1},d(e){e&&(n(T),n(M),n(de),n(he),n(ue),n(b),n(fe),n(J),n(Me),n(v),n(ye),n(U),n(we),n($),n(Te),n(j),n(ge),n(C),n(be),n(Je),n(_),n(ve),n(x),n(Ue),n(B),n($e),n(je),n(k),n(Ce),n(H),n(Ze),n(_e),n(W),n(xe),n(G),n(Be),n(Ie),n(V),n(ke),n(He),n(Q),n(Se),n(We),n(Ge),n(E),n(Re),n(Ve),n(Ne),n(P),n(Qe),n(ze),n(Xe),n(D),n(Ee),n(q),n(Le),n(Ae),n(O),n(Pe),n(Ye),n(te),n(Fe),n(De),n(le),n(qe),n(Ke),n(oe),n(Oe),n(et),n(ie),n(tt),n(re),n(nt),n(me)),n(f),u(g,e),u(w,e),u(Z,e),u(I,e),u(S,e),u(R,e),u(N,e),u(z,e),u(X,e),u(L,e),u(A,e),u(Y,e),u(F,e),u(K,e),u(ee,e),u(ne,e),u(se,e),u(ae,e)}}}const Xt='{"title":"Export to TorchScript","local":"export-to-torchscript","sections":[{"title":"TorchScript flag and tied weights","local":"torchscript-flag-and-tied-weights","sections":[],"depth":2},{"title":"Dummy inputs and standard lengths","local":"dummy-inputs-and-standard-lengths","sections":[],"depth":2},{"title":"Using TorchScript in Python","local":"using-torchscript-in-python","sections":[{"title":"Saving a model","local":"saving-a-model","sections":[],"depth":3},{"title":"Loading a model","local":"loading-a-model","sections":[],"depth":3},{"title":"Using a traced model for inference","local":"using-a-traced-model-for-inference","sections":[],"depth":3}],"depth":2},{"title":"Deploy Hugging Face TorchScript models to AWS with the Neuron SDK","local":"deploy-hugging-face-torchscript-models-to-aws-with-the-neuron-sdk","sections":[{"title":"Implications","local":"implications","sections":[],"depth":3},{"title":"Dependencies","local":"dependencies","sections":[],"depth":3},{"title":"Converting a model for AWS Neuron","local":"converting-a-model-for-aws-neuron","sections":[],"depth":3}],"depth":2}],"depth":1}';function Et(ce){return Ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dt extends Wt{constructor(f){super(),Gt(this,f,Et,zt,kt,{})}}export{Dt as component};
