import{s as Al,f as Fl,n as Nl,o as Bl}from"../chunks/scheduler.9039eef2.js";import{S as ql,i as El,g as r,s as l,r as m,A as Zl,h as s,f as a,c as o,j as b,u as c,x as d,k as M,l as Wl,y as i,a as n,v as h,d as u,t as f,w as g}from"../chunks/index.ded8f90d.js";import{D as v}from"../chunks/Docstring.2eae8017.js";import{C as $t}from"../chunks/CodeBlock.8580f3e8.js";import{H as y,E as Rl}from"../chunks/EditOnGithub.b5540897.js";function Ll($n){let C,Ot,It,Pt,Z,Dt,W,On='TRL supports the DPO Trainer for training language models from preference data, as described in the paper <a href="https://arxiv.org/abs/2305.18290" rel="nofollow">Direct Preference Optimization: Your Language Model is Secretly a Reward Model</a> by Rafailov et al., 2023. For a full example have a look at  <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/dpo.py" rel="nofollow"><code>examples/scripts/dpo.py</code></a>.',kt,R,Pn="The first step as always is to train your SFT model, to ensure the data we train on is in-distribution for the DPO algorithm.",At,L,Ft,H,Dn="Fine-tuning a language model via DPO consists of two steps and is easier than PPO:",Nt,Q,kn="<li><strong>Data collection</strong>: Gather a preference dataset with positive and negative selected pairs of generation, given a prompt.</li> <li><strong>Optimization</strong>: Maximize the log-likelihood of the DPO loss directly.</li>",Bt,z,An='DPO-compatible datasets can be found with <a href="https://huggingface.co/datasets?other=dpo" rel="nofollow">the tag <code>dpo</code> on Hugging Face Hub</a>.',qt,G,Fn='This process is illustrated in the sketch below (from <a href="https://arxiv.org/pdf/2305.18290.pdf" rel="nofollow">figure 1 of the original paper</a>):',Et,x,Nn,Zt,X,Bn='Read more about DPO algorithm in the <a href="https://arxiv.org/pdf/2305.18290.pdf" rel="nofollow">original paper</a>.',Wt,S,Rt,Y,qn='The DPO trainer expects a very specific format for the dataset. Since the model will be trained to directly optimize the preference of which sentence is the most relevant, given two sentences. We provide an example from the <a href="https://huggingface.co/datasets/Anthropic/hh-rlhf" rel="nofollow"><code>Anthropic/hh-rlhf</code></a> dataset below:',Lt,$,En='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/rlhf-antropic-example.png" ,="" width="50%"/>',Ht,V,Zn="Therefore the final dataset object should contain these 3 entries if you use the default <code>DPODataCollatorWithPadding</code> data collator. The entries should be named:",Qt,K,Wn="<li><code>prompt</code></li> <li><code>chosen</code></li> <li><code>rejected</code></li>",zt,ee,Rn="for example:",Gt,te,Xt,ae,Ln="where the <code>prompt</code> contains the context inputs, <code>chosen</code> contains the corresponding chosen responses and <code>rejected</code> contains the corresponding negative (rejected) responses. As can be seen a prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.",St,ne,Yt,le,Hn="The DPO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",Vt,oe,Kt,re,Qn="For a detailed example have a look at the <code>examples/scripts/dpo.py</code> script. At a high level we need to initialize the <code>DPOTrainer</code> with a <code>model</code> we wish to train, a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response, the <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).",ea,se,ta,ie,zn="After this one can then call:",aa,de,na,pe,Gn="Note that the <code>beta</code> is the temperature parameter for the DPO loss, typically something in the range of <code>0.1</code> to <code>0.5</code>. We ignore the reference model as <code>beta</code> -&gt; 0.",la,me,oa,ce,Xn="Given the preference data, we can fit a binary classifier according to the Bradley-Terry model and in fact the DPO authors propose the sigmoid loss on the normalized likelihood via the <code>logsigmoid</code> to fit a logistic regression.",ra,he,Sn='The <a href="https://arxiv.org/abs/2309.06657" rel="nofollow">RSO</a> authors propose to use a hinge loss on the normalized likelihood from the <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper. The <code>DPOTrainer</code> can be switched to this loss via the <code>loss_type=&quot;hinge&quot;</code> argument and the <code>beta</code> in this case is the reciprocal of the margin.',sa,ue,Yn='The <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> authors provide a deeper theoretical understanding of the DPO algorithms and identify an issue with overfitting and propose an alternative loss which can be used via the <code>loss_type=&quot;ipo&quot;</code> argument to the trainer. Note that the <code>beta</code>  parameter is the reciprocal of the gap between the log-likelihood ratios of the chosen vs the rejected completion pair and thus the smaller the <code>beta</code> the larger this gaps is. As per the paper the loss is averaged over log-likelihoods of the completion (unlike DPO which is summed only).',ia,fe,Vn='The <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> is a tweak on the DPO loss where we assume that the preference labels are noisy with some probability that can be passed to the <code>DPOTrainer</code> via <code>label_smoothing</code> argument (between 0 and 0.5) and then a conservative DPO loss is used. Use the <code>loss_type=&quot;cdpo&quot;</code> argument to the trainer to use it.',da,ge,Kn='The <a href="https://arxiv.org/abs/2402.01306" rel="nofollow">KTO</a> authors directly maximize the utility of LLM generations instead of the log-likelihood of preferences. To use preference data with KTO, we recommend breaking up the n preferences into 2n examples and using <a href="kto_trainer"><code>KTOTrainer</code></a> (i.e., treating the data like an unpaired feedback dataset). Although it is possible to pass in <code>loss_type=&quot;kto_pair&quot;</code> into DPOTrainer, this is a highly simplified version of KTO that we <em>do not recommend</em> in most cases. Please use <a href="kto_trainer"><code>KTOTrainer</code></a> when possible.',pa,_e,el='The <a href="https://arxiv.org/abs/2404.04656" rel="nofollow">BCO</a> authors train a binary classifier whose logit serves as a reward so that the classifier maps {prompt, chosen completion} pairs to 1 and {prompt, rejected completion} pairs to 0. The <code>DPOTrainer</code> can be switched to this loss via the <code>loss_type=&quot;bco_pair&quot;</code> argument.',ma,Me,ca,be,tl="While training and evaluating we record the following reward metrics:",ha,ve,al="<li><code>rewards/chosen</code>: the mean difference between the log probabilities of the policy model and the reference model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean difference between the log probabilities of the policy model and the reference model for the rejected responses scaled by beta</li> <li><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li>",ua,ye,fa,Te,nl='You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is fully compatible with <code>SFTTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama, Qwen, Deepseek etc) and Mistral architectures. Some benchmarks for DPO listed below:',ga,we,ll="<thead><tr><th>GPU</th> <th>Model</th> <th>Dataset</th> <th>🤗</th> <th>🤗 + Flash Attention 2</th> <th>🦥 Unsloth</th> <th>🦥 VRAM saved</th></tr></thead> <tbody><tr><td>A100 40G</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.24x</td> <td><strong>1.88x</strong></td> <td>-11.6%</td></tr> <tr><td>Tesla T4</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.09x</td> <td><strong>1.55x</strong></td> <td>-18.6%</td></tr></tbody>",_a,Je,ol='First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLanguageModel</code> as follows:',Ma,Ue,ba,je,rl='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',va,Ce,ya,Ie,sl="You have three main options (plus several variants) for how the reference model works when using PEFT, assuming the model that you would like to further enhance with DPO was tuned using (Q)LoRA.",Ta,xe,il="<li>Simply create two instances of the model, each loading your adapter - works fine but is very inefficient.</li> <li>Merge the adapter into the base model, create another adapter on top, then leave the <code>model_ref</code> param null, in which case DPOTrainer will unload the adapter for reference inference - efficient, but has potential downsides discussed below.</li> <li>Load the adapter twice with different names, then use <code>set_adapter</code> during training to swap between the adapter being DPO’d and the reference adapter - slightly less efficient compared to 2 (~adapter size VRAM overhead), but avoids the pitfalls.</li>",wa,$e,Ja,Oe,dl='As suggested by <a href="https://medium.com/@bnjmn_marie/dont-merge-your-lora-adapter-into-a-4-bit-llm-65b6da287997" rel="nofollow">Benjamin Marie</a>, the best option for merging QLoRA adapters is to first dequantize the base model, then merge the adapter. Something similar to <a href="https://github.com/jondurbin/qlora/blob/main/qmerge.py" rel="nofollow">this script</a>.',Ua,Pe,pl="However, after using this approach, you will have an unquantized base model. Therefore, to use QLoRA for DPO, you will need to re-quantize the merged model or use the unquantized merge (resulting in higher memory demand).",ja,De,Ca,ke,ml="To avoid the downsides with option 2, you can load your fine-tuned adapter into the model twice, with different names, and set the model/ref adapter names in DPOTrainer.",Ia,Ae,cl="For example:",xa,Fe,$a,Ne,Oa,p,Be,za,at,hl="Initialize DPOTrainer.",Ga,O,qe,Xa,nt,ul=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,Sa,P,Ee,Ya,lt,fl="Computes log probabilities of the reference model for a single padded batch of a DPO specific dataset.",Va,w,Ze,Ka,ot,gl="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",en,rt,_l="We do this to avoid doing two forward passes, because it’s faster for FSDP.",tn,D,We,an,st,Ml="Concatenate the chosen and rejected inputs into a single tensor.",nn,k,Re,ln,it,bl="Compute the DPO loss for a batch of policy and reference model log probabilities.",on,J,Le,rn,dt,vl=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,sn,pt,yl="Works both with or without labels.",dn,A,He,pn,mt,Tl="Compute the log probabilities of the given labels under the given logits.",mn,F,Qe,cn,ct,wl="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",hn,N,ze,un,ht,Jl="Generate samples from the model and reference model for the given batch of inputs.",fn,U,Ge,gn,ut,Ul="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",_n,ft,jl="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",Mn,j,Xe,bn,gt,Cl="Returns the training <code>~torch.utils.data.DataLoader</code>.",vn,_t,Il="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",yn,B,Se,Tn,Mt,xl="Log <code>logs</code> on the various objects watching training, including stored metrics.",wn,q,Ye,Jn,bt,$l="Context manager for handling null reference model (that is, peft adapter manipulation).",Un,T,Ve,jn,vt,Ol="Tokenize a single row from a DPO specific dataset.",Cn,yt,Pl=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,In,Tt,Dl=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,Pa,Ke,Da,I,et,xn,wt,kl="Initialize DPOConfig.",ka,tt,Aa,xt,Fa;return Z=new y({props:{title:"DPO Trainer",local:"dpo-trainer",headingTag:"h1"}}),L=new y({props:{title:"How DPO works",local:"how-dpo-works",headingTag:"h2"}}),S=new y({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),te=new $t({props:{code:"ZHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhpJTIwbmljZSUyMHRvJTIwbWVldCUyMHlvdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBhbSUyMGZpbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwYW0lMjBub3QlMjBmaW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdHMlMjBpdCUyMHRvJTIweW91JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySSUyMGRvbnQlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhc2NyaXB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQyUyQiUyQiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkMlMkIlMkIlMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`dpo_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;hello&quot;</span>,
        <span class="hljs-string">&quot;how are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;I am fine&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I am not fine&quot;</span>,
        <span class="hljs-string">&quot;Whats it to you?&quot;</span>,
        <span class="hljs-string">&quot;I dont have a name&quot;</span>,
        <span class="hljs-string">&quot;Javascript&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
    ],
}`,wrap:!1}}),ne=new y({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),oe=new y({props:{title:"Using the DPOTrainer",local:"using-the-dpotrainer",headingTag:"h2"}}),se=new $t({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMERQT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBKSUwQWRwb190cmFpbmVyJTIwJTNEJTIwRFBPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX3JlZiUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`training_args = DPOConfig(
    beta=<span class="hljs-number">0.1</span>,
)
dpo_trainer = DPOTrainer(
    model,
    model_ref,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),de=new $t({props:{code:"ZHBvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"dpo_trainer.train()",wrap:!1}}),me=new y({props:{title:"Loss functions",local:"loss-functions",headingTag:"h2"}}),Me=new y({props:{title:"Logging",local:"logging",headingTag:"h2"}}),ye=new y({props:{title:"Accelerate DPO fine-tuning using unsloth",local:"accelerate-dpo-fine-tuning-using-unsloth",headingTag:"h2"}}),Ue=new $t({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DPOConfig, DPOTrainer
<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel

max_seq_length = <span class="hljs-number">2048</span> <span class="hljs-comment"># Supports automatic RoPE Scaling, so choose any number.</span>

<span class="hljs-comment"># Load model</span>
model, tokenizer = FastLanguageModel.from_pretrained(
    model_name = <span class="hljs-string">&quot;unsloth/zephyr-sft&quot;</span>,
    max_seq_length = max_seq_length,
    dtype = <span class="hljs-literal">None</span>, <span class="hljs-comment"># None for auto detection. Float16 for Tesla T4, V100, Bfloat16 for Ampere+</span>
    load_in_4bit = <span class="hljs-literal">True</span>, <span class="hljs-comment"># Use 4bit quantization to reduce memory usage. Can be False.</span>
    <span class="hljs-comment"># token = &quot;hf_...&quot;, # use one if using gated models like meta-llama/Llama-2-7b-hf</span>
)

<span class="hljs-comment"># Do model patching and add fast LoRA weights</span>
model = FastLanguageModel.get_peft_model(
    model,
    r = <span class="hljs-number">16</span>,
    target_modules = [<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>,
                      <span class="hljs-string">&quot;gate_proj&quot;</span>, <span class="hljs-string">&quot;up_proj&quot;</span>, <span class="hljs-string">&quot;down_proj&quot;</span>,],
    lora_alpha = <span class="hljs-number">16</span>,
    lora_dropout = <span class="hljs-number">0</span>, <span class="hljs-comment"># Dropout = 0 is currently optimized</span>
    bias = <span class="hljs-string">&quot;none&quot;</span>,    <span class="hljs-comment"># Bias = &quot;none&quot; is currently optimized</span>
    use_gradient_checkpointing = <span class="hljs-literal">True</span>,
    random_state = <span class="hljs-number">3407</span>,
)

training_args = DPOConfig(
    output_dir=<span class="hljs-string">&quot;./output&quot;</span>,
    beta=<span class="hljs-number">0.1</span>,
)

dpo_trainer = DPOTrainer(
    model,
    ref_model=<span class="hljs-literal">None</span>,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)
dpo_trainer.train()`,wrap:!1}}),Ce=new y({props:{title:"Reference model considerations with PEFT",local:"reference-model-considerations-with-peft",headingTag:"h2"}}),$e=new y({props:{title:"Downsides to merging QLoRA before DPO (approach 2)",local:"downsides-to-merging-qlora-before-dpo-approach-2",headingTag:"h3"}}),De=new y({props:{title:"Using option 3 - load the adapter twice",local:"using-option-3---load-the-adapter-twice",headingTag:"h3"}}),Fe=new $t({props:{code:"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",highlighted:`<span class="hljs-comment"># Load the base model.</span>
bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    llm_int8_threshold=<span class="hljs-number">6.0</span>,
    llm_int8_has_fp16_weight=<span class="hljs-literal">False</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/mixtral-8x7b-v0.1&quot;</span>,
    load_in_4bit=<span class="hljs-literal">True</span>,
    quantization_config=bnb_config,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># Load the adapter.</span>
model = PeftModel.from_pretrained(
    model,
    <span class="hljs-string">&quot;/path/to/peft&quot;</span>,
    is_trainable=<span class="hljs-literal">True</span>,
    adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
)
<span class="hljs-comment"># Load the adapter a second time, with a different name, which will be our reference model.</span>
model.load_adapter(<span class="hljs-string">&quot;/path/to/peft&quot;</span>, adapter_name=<span class="hljs-string">&quot;reference&quot;</span>)

<span class="hljs-comment"># Initialize the trainer, without a ref_model param.</span>
training_args = DPOConfig(
    model_adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
    ref_adapter_name=<span class="hljs-string">&quot;reference&quot;</span>,
)
dpo_trainer = DPOTrainer(
    model,
    args=training_args,
    ...
)`,wrap:!1}}),Ne=new y({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),Be=new v({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"},{name:"force_use_ref_model",val:": bool = False"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>DPOConfig</code>) &#x2014;
The DPO config arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L67"}}),qe=new v({props:{name:"build_tokenized_answer",anchor:"trl.DPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L666"}}),Ee=new v({props:{name:"compute_reference_log_probs",anchor:"trl.DPOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L874"}}),Ze=new v({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1090"}}),We=new v({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L898",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),Re=new v({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L960",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the DPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),Le=new v({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1311"}}),He=new v({props:{name:"get_batch_logps",anchor:"trl.DPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1052",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),Qe=new v({props:{name:"get_batch_loss_metrics",anchor:"trl.DPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1137"}}),ze=new v({props:{name:"get_batch_samples",anchor:"trl.DPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1221"}}),Ge=new v({props:{name:"get_eval_dataloader",anchor:"trl.DPOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L614"}}),Xe=new v({props:{name:"get_train_dataloader",anchor:"trl.DPOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L571"}}),Se=new v({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1361"}}),Ye=new v({props:{name:"null_ref_context",anchor:"trl.DPOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L862"}}),Ve=new v({props:{name:"tokenize_row",anchor:"trl.DPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L716"}}),Ke=new y({props:{title:"DPOConfig",local:"trl.DPOConfig",headingTag:"h2"}}),et=new v({props:{name:"class trl.DPOConfig",anchor:"trl.DPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"},{name:"force_use_ref_model",val:": bool = False"}],parametersDescription:[{anchor:"trl.DPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in DPO loss. Higher beta means less divergence from the initial policy. For the IPO loss, beta is the regularization parameter denoted by tau in the paper.`,name:"beta"},{anchor:"trl.DPOConfig.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, defaults to 0) &#x2014;
The robust DPO label smoothing parameter from the <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> report that should be between 0 and 0.5.`,name:"label_smoothing"},{anchor:"trl.DPOConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
The type of DPO loss to use. Either <code>&quot;sigmoid&quot;</code> the default DPO loss,<code>&quot;hinge&quot;</code> loss from <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper, <code>&quot;ipo&quot;</code> from <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> paper,
<code>&quot;kto_pair&quot;</code> from the HALOs <a href="https://github.com/ContextualAI/HALOs/blob/main/assets/report.pdf" rel="nofollow">report</a>, or <code>&quot;bco_pair&quot;</code> from <a href="https://arxiv.org/abs/2404.04656" rel="nofollow">BCO</a> paper.`,name:"loss_type"},{anchor:"trl.DPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.DPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.DPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.DPOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.DPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.DPOConfig.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.DPOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.DPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.DPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.DPOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities for training and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.`,name:"precompute_ref_log_probs"},{anchor:"trl.DPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
The number of workers to use to tokenize the data. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.DPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"model_init_kwargs"},{anchor:"trl.DPOConfig.ref_model_init_kwargs",description:`<strong>ref_model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the ref model from a string`,name:"ref_model_init_kwargs"},{anchor:"trl.DPOConfig.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.DPOConfig.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"},{anchor:"trl.DPOConfig.reference_free",description:`<strong>reference_free</strong> (<code>bool</code> defaults to <code>False</code>) &#x2014;
If True, we ignore the <em>provided</em> reference model and implicitly use a reference model that assigns equal probability to all responses.`,name:"reference_free"},{anchor:"trl.DPOConfig.force_use_ref_model",description:`<strong>force_use_ref_model</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
In case one passes a PEFT model for the active model and you want to use a different model for the ref_model, set this flag to <code>True</code>.`,name:"force_use_ref_model"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_config.py#L20"}}),tt=new Rl({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/dpo_trainer.mdx"}}),{c(){C=r("meta"),Ot=l(),It=r("p"),Pt=l(),m(Z.$$.fragment),Dt=l(),W=r("p"),W.innerHTML=On,kt=l(),R=r("p"),R.textContent=Pn,At=l(),m(L.$$.fragment),Ft=l(),H=r("p"),H.textContent=Dn,Nt=l(),Q=r("ol"),Q.innerHTML=kn,Bt=l(),z=r("p"),z.innerHTML=An,qt=l(),G=r("p"),G.innerHTML=Fn,Et=l(),x=r("img"),Zt=l(),X=r("p"),X.innerHTML=Bn,Wt=l(),m(S.$$.fragment),Rt=l(),Y=r("p"),Y.innerHTML=qn,Lt=l(),$=r("div"),$.innerHTML=En,Ht=l(),V=r("p"),V.innerHTML=Zn,Qt=l(),K=r("ul"),K.innerHTML=Wn,zt=l(),ee=r("p"),ee.textContent=Rn,Gt=l(),m(te.$$.fragment),Xt=l(),ae=r("p"),ae.innerHTML=Ln,St=l(),m(ne.$$.fragment),Yt=l(),le=r("p"),le.innerHTML=Hn,Vt=l(),m(oe.$$.fragment),Kt=l(),re=r("p"),re.innerHTML=Qn,ea=l(),m(se.$$.fragment),ta=l(),ie=r("p"),ie.textContent=zn,aa=l(),m(de.$$.fragment),na=l(),pe=r("p"),pe.innerHTML=Gn,la=l(),m(me.$$.fragment),oa=l(),ce=r("p"),ce.innerHTML=Xn,ra=l(),he=r("p"),he.innerHTML=Sn,sa=l(),ue=r("p"),ue.innerHTML=Yn,ia=l(),fe=r("p"),fe.innerHTML=Vn,da=l(),ge=r("p"),ge.innerHTML=Kn,pa=l(),_e=r("p"),_e.innerHTML=el,ma=l(),m(Me.$$.fragment),ca=l(),be=r("p"),be.textContent=tl,ha=l(),ve=r("ul"),ve.innerHTML=al,ua=l(),m(ye.$$.fragment),fa=l(),Te=r("p"),Te.innerHTML=nl,ga=l(),we=r("table"),we.innerHTML=ll,_a=l(),Je=r("p"),Je.innerHTML=ol,Ma=l(),m(Ue.$$.fragment),ba=l(),je=r("p"),je.innerHTML=rl,va=l(),m(Ce.$$.fragment),ya=l(),Ie=r("p"),Ie.textContent=sl,Ta=l(),xe=r("ol"),xe.innerHTML=il,wa=l(),m($e.$$.fragment),Ja=l(),Oe=r("p"),Oe.innerHTML=dl,Ua=l(),Pe=r("p"),Pe.textContent=pl,ja=l(),m(De.$$.fragment),Ca=l(),ke=r("p"),ke.textContent=ml,Ia=l(),Ae=r("p"),Ae.textContent=cl,xa=l(),m(Fe.$$.fragment),$a=l(),m(Ne.$$.fragment),Oa=l(),p=r("div"),m(Be.$$.fragment),za=l(),at=r("p"),at.textContent=hl,Ga=l(),O=r("div"),m(qe.$$.fragment),Xa=l(),nt=r("p"),nt.innerHTML=ul,Sa=l(),P=r("div"),m(Ee.$$.fragment),Ya=l(),lt=r("p"),lt.textContent=fl,Va=l(),w=r("div"),m(Ze.$$.fragment),Ka=l(),ot=r("p"),ot.textContent=gl,en=l(),rt=r("p"),rt.textContent=_l,tn=l(),D=r("div"),m(We.$$.fragment),an=l(),st=r("p"),st.textContent=Ml,nn=l(),k=r("div"),m(Re.$$.fragment),ln=l(),it=r("p"),it.textContent=bl,on=l(),J=r("div"),m(Le.$$.fragment),rn=l(),dt=r("p"),dt.innerHTML=vl,sn=l(),pt=r("p"),pt.textContent=yl,dn=l(),A=r("div"),m(He.$$.fragment),pn=l(),mt=r("p"),mt.textContent=Tl,mn=l(),F=r("div"),m(Qe.$$.fragment),cn=l(),ct=r("p"),ct.textContent=wl,hn=l(),N=r("div"),m(ze.$$.fragment),un=l(),ht=r("p"),ht.textContent=Jl,fn=l(),U=r("div"),m(Ge.$$.fragment),gn=l(),ut=r("p"),ut.innerHTML=Ul,_n=l(),ft=r("p"),ft.innerHTML=jl,Mn=l(),j=r("div"),m(Xe.$$.fragment),bn=l(),gt=r("p"),gt.innerHTML=Cl,vn=l(),_t=r("p"),_t.innerHTML=Il,yn=l(),B=r("div"),m(Se.$$.fragment),Tn=l(),Mt=r("p"),Mt.innerHTML=xl,wn=l(),q=r("div"),m(Ye.$$.fragment),Jn=l(),bt=r("p"),bt.textContent=$l,Un=l(),T=r("div"),m(Ve.$$.fragment),jn=l(),vt=r("p"),vt.textContent=Ol,Cn=l(),yt=r("p"),yt.textContent=Pl,In=l(),Tt=r("p"),Tt.textContent=Dl,Pa=l(),m(Ke.$$.fragment),Da=l(),I=r("div"),m(et.$$.fragment),xn=l(),wt=r("p"),wt.textContent=kl,ka=l(),m(tt.$$.fragment),Aa=l(),xt=r("p"),this.h()},l(e){const t=Zl("svelte-u9bgzb",document.head);C=s(t,"META",{name:!0,content:!0}),t.forEach(a),Ot=o(e),It=s(e,"P",{}),b(It).forEach(a),Pt=o(e),c(Z.$$.fragment,e),Dt=o(e),W=s(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-5p7twb"&&(W.innerHTML=On),kt=o(e),R=s(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-xh4sh7"&&(R.textContent=Pn),At=o(e),c(L.$$.fragment,e),Ft=o(e),H=s(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-e9zjgv"&&(H.textContent=Dn),Nt=o(e),Q=s(e,"OL",{"data-svelte-h":!0}),d(Q)!=="svelte-1fzn07o"&&(Q.innerHTML=kn),Bt=o(e),z=s(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-11tyi92"&&(z.innerHTML=An),qt=o(e),G=s(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-lms3te"&&(G.innerHTML=Fn),Et=o(e),x=s(e,"IMG",{width:!0,alt:!0,src:!0}),Zt=o(e),X=s(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1yw8azb"&&(X.innerHTML=Bn),Wt=o(e),c(S.$$.fragment,e),Rt=o(e),Y=s(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-dcawbe"&&(Y.innerHTML=qn),Lt=o(e),$=s(e,"DIV",{style:!0,"data-svelte-h":!0}),d($)!=="svelte-z15c7z"&&($.innerHTML=En),Ht=o(e),V=s(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-cb9b0v"&&(V.innerHTML=Zn),Qt=o(e),K=s(e,"UL",{"data-svelte-h":!0}),d(K)!=="svelte-17vxuta"&&(K.innerHTML=Wn),zt=o(e),ee=s(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1gl9mvz"&&(ee.textContent=Rn),Gt=o(e),c(te.$$.fragment,e),Xt=o(e),ae=s(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1a8oxjk"&&(ae.innerHTML=Ln),St=o(e),c(ne.$$.fragment,e),Yt=o(e),le=s(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-174yw9s"&&(le.innerHTML=Hn),Vt=o(e),c(oe.$$.fragment,e),Kt=o(e),re=s(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-1wn9xrv"&&(re.innerHTML=Qn),ea=o(e),c(se.$$.fragment,e),ta=o(e),ie=s(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1lg6q1l"&&(ie.textContent=zn),aa=o(e),c(de.$$.fragment,e),na=o(e),pe=s(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-1ac5mum"&&(pe.innerHTML=Gn),la=o(e),c(me.$$.fragment,e),oa=o(e),ce=s(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-7nvktz"&&(ce.innerHTML=Xn),ra=o(e),he=s(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-bl9wh7"&&(he.innerHTML=Sn),sa=o(e),ue=s(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1quvcuu"&&(ue.innerHTML=Yn),ia=o(e),fe=s(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-x8vvul"&&(fe.innerHTML=Vn),da=o(e),ge=s(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-m3f292"&&(ge.innerHTML=Kn),pa=o(e),_e=s(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-nj941x"&&(_e.innerHTML=el),ma=o(e),c(Me.$$.fragment,e),ca=o(e),be=s(e,"P",{"data-svelte-h":!0}),d(be)!=="svelte-132s7j9"&&(be.textContent=tl),ha=o(e),ve=s(e,"UL",{"data-svelte-h":!0}),d(ve)!=="svelte-1oji3mm"&&(ve.innerHTML=al),ua=o(e),c(ye.$$.fragment,e),fa=o(e),Te=s(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-2145zu"&&(Te.innerHTML=nl),ga=o(e),we=s(e,"TABLE",{"data-svelte-h":!0}),d(we)!=="svelte-435mua"&&(we.innerHTML=ll),_a=o(e),Je=s(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1p74c9x"&&(Je.innerHTML=ol),Ma=o(e),c(Ue.$$.fragment,e),ba=o(e),je=s(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-1o18rwj"&&(je.innerHTML=rl),va=o(e),c(Ce.$$.fragment,e),ya=o(e),Ie=s(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-4infz6"&&(Ie.textContent=sl),Ta=o(e),xe=s(e,"OL",{"data-svelte-h":!0}),d(xe)!=="svelte-1p7od7"&&(xe.innerHTML=il),wa=o(e),c($e.$$.fragment,e),Ja=o(e),Oe=s(e,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-rqj7uy"&&(Oe.innerHTML=dl),Ua=o(e),Pe=s(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-1xhv3st"&&(Pe.textContent=pl),ja=o(e),c(De.$$.fragment,e),Ca=o(e),ke=s(e,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-a0kxee"&&(ke.textContent=ml),Ia=o(e),Ae=s(e,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-1gkqha7"&&(Ae.textContent=cl),xa=o(e),c(Fe.$$.fragment,e),$a=o(e),c(Ne.$$.fragment,e),Oa=o(e),p=s(e,"DIV",{class:!0});var _=b(p);c(Be.$$.fragment,_),za=o(_),at=s(_,"P",{"data-svelte-h":!0}),d(at)!=="svelte-n6cc8y"&&(at.textContent=hl),Ga=o(_),O=s(_,"DIV",{class:!0});var Na=b(O);c(qe.$$.fragment,Na),Xa=o(Na),nt=s(Na,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-mcz8nm"&&(nt.innerHTML=ul),Na.forEach(a),Sa=o(_),P=s(_,"DIV",{class:!0});var Ba=b(P);c(Ee.$$.fragment,Ba),Ya=o(Ba),lt=s(Ba,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-10t1062"&&(lt.textContent=fl),Ba.forEach(a),Va=o(_),w=s(_,"DIV",{class:!0});var Jt=b(w);c(Ze.$$.fragment,Jt),Ka=o(Jt),ot=s(Jt,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-16i1nac"&&(ot.textContent=gl),en=o(Jt),rt=s(Jt,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-tgti68"&&(rt.textContent=_l),Jt.forEach(a),tn=o(_),D=s(_,"DIV",{class:!0});var qa=b(D);c(We.$$.fragment,qa),an=o(qa),st=s(qa,"P",{"data-svelte-h":!0}),d(st)!=="svelte-1cvsgkk"&&(st.textContent=Ml),qa.forEach(a),nn=o(_),k=s(_,"DIV",{class:!0});var Ea=b(k);c(Re.$$.fragment,Ea),ln=o(Ea),it=s(Ea,"P",{"data-svelte-h":!0}),d(it)!=="svelte-ymgxq7"&&(it.textContent=bl),Ea.forEach(a),on=o(_),J=s(_,"DIV",{class:!0});var Ut=b(J);c(Le.$$.fragment,Ut),rn=o(Ut),dt=s(Ut,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-8qlty5"&&(dt.innerHTML=vl),sn=o(Ut),pt=s(Ut,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-1tyo99t"&&(pt.textContent=yl),Ut.forEach(a),dn=o(_),A=s(_,"DIV",{class:!0});var Za=b(A);c(He.$$.fragment,Za),pn=o(Za),mt=s(Za,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-4nmimv"&&(mt.textContent=Tl),Za.forEach(a),mn=o(_),F=s(_,"DIV",{class:!0});var Wa=b(F);c(Qe.$$.fragment,Wa),cn=o(Wa),ct=s(Wa,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-11q8u7l"&&(ct.textContent=wl),Wa.forEach(a),hn=o(_),N=s(_,"DIV",{class:!0});var Ra=b(N);c(ze.$$.fragment,Ra),un=o(Ra),ht=s(Ra,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-18uwvbi"&&(ht.textContent=Jl),Ra.forEach(a),fn=o(_),U=s(_,"DIV",{class:!0});var jt=b(U);c(Ge.$$.fragment,jt),gn=o(jt),ut=s(jt,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-xesobz"&&(ut.innerHTML=Ul),_n=o(jt),ft=s(jt,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-qg43tm"&&(ft.innerHTML=jl),jt.forEach(a),Mn=o(_),j=s(_,"DIV",{class:!0});var Ct=b(j);c(Xe.$$.fragment,Ct),bn=o(Ct),gt=s(Ct,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-dkae9b"&&(gt.innerHTML=Cl),vn=o(Ct),_t=s(Ct,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-hmd5cw"&&(_t.innerHTML=Il),Ct.forEach(a),yn=o(_),B=s(_,"DIV",{class:!0});var La=b(B);c(Se.$$.fragment,La),Tn=o(La),Mt=s(La,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-nqksfz"&&(Mt.innerHTML=xl),La.forEach(a),wn=o(_),q=s(_,"DIV",{class:!0});var Ha=b(q);c(Ye.$$.fragment,Ha),Jn=o(Ha),bt=s(Ha,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-17kjsy4"&&(bt.textContent=$l),Ha.forEach(a),Un=o(_),T=s(_,"DIV",{class:!0});var E=b(T);c(Ve.$$.fragment,E),jn=o(E),vt=s(E,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-1861yti"&&(vt.textContent=Ol),Cn=o(E),yt=s(E,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-1mn1gnw"&&(yt.textContent=Pl),In=o(E),Tt=s(E,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-1xvpyih"&&(Tt.textContent=Dl),E.forEach(a),_.forEach(a),Pa=o(e),c(Ke.$$.fragment,e),Da=o(e),I=s(e,"DIV",{class:!0});var Qa=b(I);c(et.$$.fragment,Qa),xn=o(Qa),wt=s(Qa,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-1va94c9"&&(wt.textContent=kl),Qa.forEach(a),ka=o(e),c(tt.$$.fragment,e),Aa=o(e),xt=s(e,"P",{}),b(xt).forEach(a),this.h()},h(){M(C,"name","hf:doc:metadata"),M(C,"content",Hl),M(x,"width","835"),M(x,"alt","Screenshot 2024-03-19 at 12 39 41"),Fl(x.src,Nn="https://github.com/huggingface/trl/assets/49240599/9150fac6-3d88-4ca2-8ec6-2a6f3473216d")||M(x,"src",Nn),Wl($,"text-align","center"),M(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,C),n(e,Ot,t),n(e,It,t),n(e,Pt,t),h(Z,e,t),n(e,Dt,t),n(e,W,t),n(e,kt,t),n(e,R,t),n(e,At,t),h(L,e,t),n(e,Ft,t),n(e,H,t),n(e,Nt,t),n(e,Q,t),n(e,Bt,t),n(e,z,t),n(e,qt,t),n(e,G,t),n(e,Et,t),n(e,x,t),n(e,Zt,t),n(e,X,t),n(e,Wt,t),h(S,e,t),n(e,Rt,t),n(e,Y,t),n(e,Lt,t),n(e,$,t),n(e,Ht,t),n(e,V,t),n(e,Qt,t),n(e,K,t),n(e,zt,t),n(e,ee,t),n(e,Gt,t),h(te,e,t),n(e,Xt,t),n(e,ae,t),n(e,St,t),h(ne,e,t),n(e,Yt,t),n(e,le,t),n(e,Vt,t),h(oe,e,t),n(e,Kt,t),n(e,re,t),n(e,ea,t),h(se,e,t),n(e,ta,t),n(e,ie,t),n(e,aa,t),h(de,e,t),n(e,na,t),n(e,pe,t),n(e,la,t),h(me,e,t),n(e,oa,t),n(e,ce,t),n(e,ra,t),n(e,he,t),n(e,sa,t),n(e,ue,t),n(e,ia,t),n(e,fe,t),n(e,da,t),n(e,ge,t),n(e,pa,t),n(e,_e,t),n(e,ma,t),h(Me,e,t),n(e,ca,t),n(e,be,t),n(e,ha,t),n(e,ve,t),n(e,ua,t),h(ye,e,t),n(e,fa,t),n(e,Te,t),n(e,ga,t),n(e,we,t),n(e,_a,t),n(e,Je,t),n(e,Ma,t),h(Ue,e,t),n(e,ba,t),n(e,je,t),n(e,va,t),h(Ce,e,t),n(e,ya,t),n(e,Ie,t),n(e,Ta,t),n(e,xe,t),n(e,wa,t),h($e,e,t),n(e,Ja,t),n(e,Oe,t),n(e,Ua,t),n(e,Pe,t),n(e,ja,t),h(De,e,t),n(e,Ca,t),n(e,ke,t),n(e,Ia,t),n(e,Ae,t),n(e,xa,t),h(Fe,e,t),n(e,$a,t),h(Ne,e,t),n(e,Oa,t),n(e,p,t),h(Be,p,null),i(p,za),i(p,at),i(p,Ga),i(p,O),h(qe,O,null),i(O,Xa),i(O,nt),i(p,Sa),i(p,P),h(Ee,P,null),i(P,Ya),i(P,lt),i(p,Va),i(p,w),h(Ze,w,null),i(w,Ka),i(w,ot),i(w,en),i(w,rt),i(p,tn),i(p,D),h(We,D,null),i(D,an),i(D,st),i(p,nn),i(p,k),h(Re,k,null),i(k,ln),i(k,it),i(p,on),i(p,J),h(Le,J,null),i(J,rn),i(J,dt),i(J,sn),i(J,pt),i(p,dn),i(p,A),h(He,A,null),i(A,pn),i(A,mt),i(p,mn),i(p,F),h(Qe,F,null),i(F,cn),i(F,ct),i(p,hn),i(p,N),h(ze,N,null),i(N,un),i(N,ht),i(p,fn),i(p,U),h(Ge,U,null),i(U,gn),i(U,ut),i(U,_n),i(U,ft),i(p,Mn),i(p,j),h(Xe,j,null),i(j,bn),i(j,gt),i(j,vn),i(j,_t),i(p,yn),i(p,B),h(Se,B,null),i(B,Tn),i(B,Mt),i(p,wn),i(p,q),h(Ye,q,null),i(q,Jn),i(q,bt),i(p,Un),i(p,T),h(Ve,T,null),i(T,jn),i(T,vt),i(T,Cn),i(T,yt),i(T,In),i(T,Tt),n(e,Pa,t),h(Ke,e,t),n(e,Da,t),n(e,I,t),h(et,I,null),i(I,xn),i(I,wt),n(e,ka,t),h(tt,e,t),n(e,Aa,t),n(e,xt,t),Fa=!0},p:Nl,i(e){Fa||(u(Z.$$.fragment,e),u(L.$$.fragment,e),u(S.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(se.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(Me.$$.fragment,e),u(ye.$$.fragment,e),u(Ue.$$.fragment,e),u(Ce.$$.fragment,e),u($e.$$.fragment,e),u(De.$$.fragment,e),u(Fe.$$.fragment,e),u(Ne.$$.fragment,e),u(Be.$$.fragment,e),u(qe.$$.fragment,e),u(Ee.$$.fragment,e),u(Ze.$$.fragment,e),u(We.$$.fragment,e),u(Re.$$.fragment,e),u(Le.$$.fragment,e),u(He.$$.fragment,e),u(Qe.$$.fragment,e),u(ze.$$.fragment,e),u(Ge.$$.fragment,e),u(Xe.$$.fragment,e),u(Se.$$.fragment,e),u(Ye.$$.fragment,e),u(Ve.$$.fragment,e),u(Ke.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),Fa=!0)},o(e){f(Z.$$.fragment,e),f(L.$$.fragment,e),f(S.$$.fragment,e),f(te.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(se.$$.fragment,e),f(de.$$.fragment,e),f(me.$$.fragment,e),f(Me.$$.fragment,e),f(ye.$$.fragment,e),f(Ue.$$.fragment,e),f(Ce.$$.fragment,e),f($e.$$.fragment,e),f(De.$$.fragment,e),f(Fe.$$.fragment,e),f(Ne.$$.fragment,e),f(Be.$$.fragment,e),f(qe.$$.fragment,e),f(Ee.$$.fragment,e),f(Ze.$$.fragment,e),f(We.$$.fragment,e),f(Re.$$.fragment,e),f(Le.$$.fragment,e),f(He.$$.fragment,e),f(Qe.$$.fragment,e),f(ze.$$.fragment,e),f(Ge.$$.fragment,e),f(Xe.$$.fragment,e),f(Se.$$.fragment,e),f(Ye.$$.fragment,e),f(Ve.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),Fa=!1},d(e){e&&(a(Ot),a(It),a(Pt),a(Dt),a(W),a(kt),a(R),a(At),a(Ft),a(H),a(Nt),a(Q),a(Bt),a(z),a(qt),a(G),a(Et),a(x),a(Zt),a(X),a(Wt),a(Rt),a(Y),a(Lt),a($),a(Ht),a(V),a(Qt),a(K),a(zt),a(ee),a(Gt),a(Xt),a(ae),a(St),a(Yt),a(le),a(Vt),a(Kt),a(re),a(ea),a(ta),a(ie),a(aa),a(na),a(pe),a(la),a(oa),a(ce),a(ra),a(he),a(sa),a(ue),a(ia),a(fe),a(da),a(ge),a(pa),a(_e),a(ma),a(ca),a(be),a(ha),a(ve),a(ua),a(fa),a(Te),a(ga),a(we),a(_a),a(Je),a(Ma),a(ba),a(je),a(va),a(ya),a(Ie),a(Ta),a(xe),a(wa),a(Ja),a(Oe),a(Ua),a(Pe),a(ja),a(Ca),a(ke),a(Ia),a(Ae),a(xa),a($a),a(Oa),a(p),a(Pa),a(Da),a(I),a(ka),a(Aa),a(xt)),a(C),g(Z,e),g(L,e),g(S,e),g(te,e),g(ne,e),g(oe,e),g(se,e),g(de,e),g(me,e),g(Me,e),g(ye,e),g(Ue,e),g(Ce,e),g($e,e),g(De,e),g(Fe,e),g(Ne,e),g(Be),g(qe),g(Ee),g(Ze),g(We),g(Re),g(Le),g(He),g(Qe),g(ze),g(Ge),g(Xe),g(Se),g(Ye),g(Ve),g(Ke,e),g(et),g(tt,e)}}}const Hl='{"title":"DPO Trainer","local":"dpo-trainer","sections":[{"title":"How DPO works","local":"how-dpo-works","sections":[],"depth":2},{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the DPOTrainer","local":"using-the-dpotrainer","sections":[],"depth":2},{"title":"Loss functions","local":"loss-functions","sections":[],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"Accelerate DPO fine-tuning using unsloth","local":"accelerate-dpo-fine-tuning-using-unsloth","sections":[],"depth":2},{"title":"Reference model considerations with PEFT","local":"reference-model-considerations-with-peft","sections":[{"title":"Downsides to merging QLoRA before DPO (approach 2)","local":"downsides-to-merging-qlora-before-dpo-approach-2","sections":[],"depth":3},{"title":"Using option 3 - load the adapter twice","local":"using-option-3---load-the-adapter-twice","sections":[],"depth":3}],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2},{"title":"DPOConfig","local":"trl.DPOConfig","sections":[],"depth":2}],"depth":1}';function Ql($n){return Bl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vl extends ql{constructor(C){super(),El(this,C,Ql,Ll,Al,{})}}export{Vl as component};
