import{s as Ht,n as zt,o as Qt}from"../chunks/scheduler.9039eef2.js";import{S as St,i as Zt,g as l,s as a,r as m,A as Ft,h as i,f as n,c as r,j as _,u as h,x as d,k as v,l as Rt,y as s,a as o,v as g,d as u,t as M,w as f}from"../chunks/index.ded8f90d.js";import{D as $}from"../chunks/Docstring.a2ba2b54.js";import{C as Mt}from"../chunks/CodeBlock.8580f3e8.js";import{H as ye}from"../chunks/Heading.f027f30d.js";function Xt(ft){let b,ve,Te,be,I,we,P,yt='TRL supports the DPO Trainer for training language models from preference data, as described in the paper <a href="https://arxiv.org/abs/2305.18290" rel="nofollow">Direct Preference Optimization: Your Language Model is Secretly a Reward Model</a> by Rafailov et al., 2023. For a full example have a look at  <a href="https://github.com/huggingface/trl/blob/main/examples/dpo.py" rel="nofollow"><code>examples/dpo.py</code></a>.',je,D,Tt="The first step as always is to train your SFT model, to ensure the data we train on is in-distribution for the DPO algorithm.",Ue,A,Ce,O,_t='The DPO trainer expects a very specific format for the dataset. Since the model will be trained to directly optimize the preference of which sentence is the most relevant, given two sentences. We provide an example from the <a href="https://huggingface.co/datasets/Anthropic/hh-rlhf" rel="nofollow"><code>Anthropic/hh-rlhf</code></a> dataset below:',Je,w,vt='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/rlhf-antropic-example.png" ,="" width="50%"/>',xe,q,bt="Therefore the final dataset object should contain these 3 entries if you use the default <code>DPODataCollatorWithPadding</code> data collator. The entries should be named:",$e,k,wt="<li><code>prompt</code></li> <li><code>chosen</code></li> <li><code>rejected</code></li>",Ie,L,jt="for example:",Pe,E,De,N,Ut="where the <code>prompt</code> contains the context inputs, <code>chosen</code> contains the corresponding chosen responses and <code>rejected</code> contains the corresponding negative (rejected) responses. As can be seen a prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.",Ae,W,Oe,B,Ct="The DPO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",qe,H,ke,z,Jt="For a detailed example have a look at the <code>examples/dpo.py</code> script. At a high level we need to initialize the <code>DPOTrainer</code> with a <code>model</code> we wish to train, a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response, the <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).",Le,Q,Ee,S,xt="After this one can then call:",Ne,Z,We,F,$t="Note that the <code>beta</code> is the temperature parameter for the DPO loss, typically something in the range of <code>0.1</code> to <code>0.5</code>. We ignore the reference model as <code>beta</code> -&gt; 0.",Be,R,He,X,It="While training and evaluating we record the following reward metrics:",ze,G,Pt="<li><code>rewards/chosen</code>: the mean difference between the log probabilities of the policy model and the reference model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean difference between the log probabilities of the policy model and the reference model for the rejected responses scaled by beta</li> <li><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li>",Qe,V,Se,c,Y,Ke,le,Dt="Initialize DPOTrainer.",et,y,K,tt,ie,At="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",nt,se,Ot="We do this to avoid doing two forward passes, because it’s faster for FSDP.",at,j,ee,rt,de,qt="Concatenate the chosen and rejected inputs into a single tensor.",ot,U,te,lt,ce,kt="Compute the DPO loss for a batch of policy and reference model log probabilities.",it,T,ne,st,pe,Lt=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,dt,me,Et="Works both with or without labels.",ct,C,ae,pt,he,Nt="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",mt,J,re,ht,ge,Wt="Generate samples from the model and reference model for the given batch of inputs.",gt,x,oe,ut,ue,Bt="Log <code>logs</code> on the various objects watching training, including stored metrics.",Ze,_e,Fe;return I=new ye({props:{title:"DPO Trainer",local:"dpo-trainer",headingTag:"h1"}}),A=new ye({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),E=new Mt({props:{code:"ZHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhpJTIwbmljZSUyMHRvJTIwbWVldCUyMHlvdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBhbSUyMGZpbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwYW0lMjBub3QlMjBmaW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdHMlMjBpdCUyMHRvJTIweW91JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySSUyMGRvbnQlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhc2NyaXB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQyUyQiUyQiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkMlMkIlMkIlMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`dpo_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;hello&quot;</span>,
        <span class="hljs-string">&quot;how are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;I am fine&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I am not fine&quot;</span>,
        <span class="hljs-string">&quot;Whats it to you?&quot;</span>,
        <span class="hljs-string">&quot;I dont have a name&quot;</span>,
        <span class="hljs-string">&quot;Javascript&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
    ],
}`,wrap:!1}}),W=new ye({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),H=new ye({props:{title:"Using the DPOTrainer",local:"using-the-dpotrainer",headingTag:"h2"}}),Q=new Mt({props:{code:"JTIwZHBvX3RyYWluZXIlMjAlM0QlMjBEUE9UcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfcmVmJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:` dpo_trainer = DPOTrainer(
    model,
    model_ref,
    args=training_args,
    beta=<span class="hljs-number">0.1</span>,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),Z=new Mt({props:{code:"ZHBvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"dpo_trainer.train()",wrap:!1}}),R=new ye({props:{title:"Logging",local:"logging",headingTag:"h2"}}),V=new ye({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),Y=new $({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module] = None"},{name:"ref_model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, NoneType] = None"},{name:"beta",val:": float = 0.1"},{name:"args",val:": TrainingArguments = None"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"},{name:"model_init",val:": typing.Union[typing.Callable[[], transformers.modeling_utils.PreTrainedModel], NoneType] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"max_prompt_length",val:": typing.Optional[int] = None"},{name:"max_target_length",val:": typing.Optional[int] = None"},{name:"peft_config",val:": typing.Optional[typing.Dict] = None"},{name:"is_encoder_decoder",val:": typing.Optional[bool] = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalLoopOutput], typing.Dict], NoneType] = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in DPO loss. Higher beta means less divergence from the initial policy.`,name:"beta"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>transformers.TrainingArguments</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.DPOTrainer.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value. This argument is required if you want to use the default data collator.`,name:"padding_value"},{anchor:"trl.DPOTrainer.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.DPOTrainer.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.DPOTrainer.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.DPOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.DPOTrainer.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/v0.7.2/trl/trainer/dpo_trainer.py#L46"}}),K=new $({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"}],source:"https://github.com/huggingface/trl/blob/v0.7.2/trl/trainer/dpo_trainer.py#L399"}}),ee=new $({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"}],source:"https://github.com/huggingface/trl/blob/v0.7.2/trl/trainer/dpo_trainer.py#L289",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),te=new $({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"reference_free",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/v0.7.2/trl/trainer/dpo_trainer.py#L328",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the DPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),ne=new $({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": typing.Optional[bool] = None"},{name:"ignore_keys",val:": typing.Optional[typing.List[str]] = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/v0.7.2/trl/trainer/dpo_trainer.py#L590"}}),ae=new $({props:{name:"get_batch_metrics",anchor:"trl.DPOTrainer.get_batch_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"},{name:"train_eval",val:": typing.Literal['train', 'eval'] = 'train'"}],source:"https://github.com/huggingface/trl/blob/v0.7.2/trl/trainer/dpo_trainer.py#L437"}}),re=new $({props:{name:"get_batch_samples",anchor:"trl.DPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": typing.Dict[str, torch.LongTensor]"}],source:"https://github.com/huggingface/trl/blob/v0.7.2/trl/trainer/dpo_trainer.py#L510"}}),oe=new $({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": typing.Dict[str, float]"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/v0.7.2/trl/trainer/dpo_trainer.py#L639"}}),{c(){b=l("meta"),ve=a(),Te=l("p"),be=a(),m(I.$$.fragment),we=a(),P=l("p"),P.innerHTML=yt,je=a(),D=l("p"),D.textContent=Tt,Ue=a(),m(A.$$.fragment),Ce=a(),O=l("p"),O.innerHTML=_t,Je=a(),w=l("div"),w.innerHTML=vt,xe=a(),q=l("p"),q.innerHTML=bt,$e=a(),k=l("ul"),k.innerHTML=wt,Ie=a(),L=l("p"),L.textContent=jt,Pe=a(),m(E.$$.fragment),De=a(),N=l("p"),N.innerHTML=Ut,Ae=a(),m(W.$$.fragment),Oe=a(),B=l("p"),B.innerHTML=Ct,qe=a(),m(H.$$.fragment),ke=a(),z=l("p"),z.innerHTML=Jt,Le=a(),m(Q.$$.fragment),Ee=a(),S=l("p"),S.textContent=xt,Ne=a(),m(Z.$$.fragment),We=a(),F=l("p"),F.innerHTML=$t,Be=a(),m(R.$$.fragment),He=a(),X=l("p"),X.textContent=It,ze=a(),G=l("ul"),G.innerHTML=Pt,Qe=a(),m(V.$$.fragment),Se=a(),c=l("div"),m(Y.$$.fragment),Ke=a(),le=l("p"),le.textContent=Dt,et=a(),y=l("div"),m(K.$$.fragment),tt=a(),ie=l("p"),ie.textContent=At,nt=a(),se=l("p"),se.textContent=Ot,at=a(),j=l("div"),m(ee.$$.fragment),rt=a(),de=l("p"),de.textContent=qt,ot=a(),U=l("div"),m(te.$$.fragment),lt=a(),ce=l("p"),ce.textContent=kt,it=a(),T=l("div"),m(ne.$$.fragment),st=a(),pe=l("p"),pe.innerHTML=Lt,dt=a(),me=l("p"),me.textContent=Et,ct=a(),C=l("div"),m(ae.$$.fragment),pt=a(),he=l("p"),he.textContent=Nt,mt=a(),J=l("div"),m(re.$$.fragment),ht=a(),ge=l("p"),ge.textContent=Wt,gt=a(),x=l("div"),m(oe.$$.fragment),ut=a(),ue=l("p"),ue.innerHTML=Bt,Ze=a(),_e=l("p"),this.h()},l(e){const t=Ft("svelte-u9bgzb",document.head);b=i(t,"META",{name:!0,content:!0}),t.forEach(n),ve=r(e),Te=i(e,"P",{}),_(Te).forEach(n),be=r(e),h(I.$$.fragment,e),we=r(e),P=i(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-mupna9"&&(P.innerHTML=yt),je=r(e),D=i(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-xh4sh7"&&(D.textContent=Tt),Ue=r(e),h(A.$$.fragment,e),Ce=r(e),O=i(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-dcawbe"&&(O.innerHTML=_t),Je=r(e),w=i(e,"DIV",{style:!0,"data-svelte-h":!0}),d(w)!=="svelte-z15c7z"&&(w.innerHTML=vt),xe=r(e),q=i(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-cb9b0v"&&(q.innerHTML=bt),$e=r(e),k=i(e,"UL",{"data-svelte-h":!0}),d(k)!=="svelte-17vxuta"&&(k.innerHTML=wt),Ie=r(e),L=i(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1gl9mvz"&&(L.textContent=jt),Pe=r(e),h(E.$$.fragment,e),De=r(e),N=i(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1a8oxjk"&&(N.innerHTML=Ut),Ae=r(e),h(W.$$.fragment,e),Oe=r(e),B=i(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-174yw9s"&&(B.innerHTML=Ct),qe=r(e),h(H.$$.fragment,e),ke=r(e),z=i(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-18wrw32"&&(z.innerHTML=Jt),Le=r(e),h(Q.$$.fragment,e),Ee=r(e),S=i(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-1lg6q1l"&&(S.textContent=xt),Ne=r(e),h(Z.$$.fragment,e),We=r(e),F=i(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-1ac5mum"&&(F.innerHTML=$t),Be=r(e),h(R.$$.fragment,e),He=r(e),X=i(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-132s7j9"&&(X.textContent=It),ze=r(e),G=i(e,"UL",{"data-svelte-h":!0}),d(G)!=="svelte-1oji3mm"&&(G.innerHTML=Pt),Qe=r(e),h(V.$$.fragment,e),Se=r(e),c=i(e,"DIV",{class:!0});var p=_(c);h(Y.$$.fragment,p),Ke=r(p),le=i(p,"P",{"data-svelte-h":!0}),d(le)!=="svelte-n6cc8y"&&(le.textContent=Dt),et=r(p),y=i(p,"DIV",{class:!0});var Me=_(y);h(K.$$.fragment,Me),tt=r(Me),ie=i(Me,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-16i1nac"&&(ie.textContent=At),nt=r(Me),se=i(Me,"P",{"data-svelte-h":!0}),d(se)!=="svelte-tgti68"&&(se.textContent=Ot),Me.forEach(n),at=r(p),j=i(p,"DIV",{class:!0});var Re=_(j);h(ee.$$.fragment,Re),rt=r(Re),de=i(Re,"P",{"data-svelte-h":!0}),d(de)!=="svelte-1cvsgkk"&&(de.textContent=qt),Re.forEach(n),ot=r(p),U=i(p,"DIV",{class:!0});var Xe=_(U);h(te.$$.fragment,Xe),lt=r(Xe),ce=i(Xe,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-ymgxq7"&&(ce.textContent=kt),Xe.forEach(n),it=r(p),T=i(p,"DIV",{class:!0});var fe=_(T);h(ne.$$.fragment,fe),st=r(fe),pe=i(fe,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-8qlty5"&&(pe.innerHTML=Lt),dt=r(fe),me=i(fe,"P",{"data-svelte-h":!0}),d(me)!=="svelte-1tyo99t"&&(me.textContent=Et),fe.forEach(n),ct=r(p),C=i(p,"DIV",{class:!0});var Ge=_(C);h(ae.$$.fragment,Ge),pt=r(Ge),he=i(Ge,"P",{"data-svelte-h":!0}),d(he)!=="svelte-11q8u7l"&&(he.textContent=Nt),Ge.forEach(n),mt=r(p),J=i(p,"DIV",{class:!0});var Ve=_(J);h(re.$$.fragment,Ve),ht=r(Ve),ge=i(Ve,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-18uwvbi"&&(ge.textContent=Wt),Ve.forEach(n),gt=r(p),x=i(p,"DIV",{class:!0});var Ye=_(x);h(oe.$$.fragment,Ye),ut=r(Ye),ue=i(Ye,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-nqksfz"&&(ue.innerHTML=Bt),Ye.forEach(n),p.forEach(n),Ze=r(e),_e=i(e,"P",{}),_(_e).forEach(n),this.h()},h(){v(b,"name","hf:doc:metadata"),v(b,"content",Gt),Rt(w,"text-align","center"),v(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){s(document.head,b),o(e,ve,t),o(e,Te,t),o(e,be,t),g(I,e,t),o(e,we,t),o(e,P,t),o(e,je,t),o(e,D,t),o(e,Ue,t),g(A,e,t),o(e,Ce,t),o(e,O,t),o(e,Je,t),o(e,w,t),o(e,xe,t),o(e,q,t),o(e,$e,t),o(e,k,t),o(e,Ie,t),o(e,L,t),o(e,Pe,t),g(E,e,t),o(e,De,t),o(e,N,t),o(e,Ae,t),g(W,e,t),o(e,Oe,t),o(e,B,t),o(e,qe,t),g(H,e,t),o(e,ke,t),o(e,z,t),o(e,Le,t),g(Q,e,t),o(e,Ee,t),o(e,S,t),o(e,Ne,t),g(Z,e,t),o(e,We,t),o(e,F,t),o(e,Be,t),g(R,e,t),o(e,He,t),o(e,X,t),o(e,ze,t),o(e,G,t),o(e,Qe,t),g(V,e,t),o(e,Se,t),o(e,c,t),g(Y,c,null),s(c,Ke),s(c,le),s(c,et),s(c,y),g(K,y,null),s(y,tt),s(y,ie),s(y,nt),s(y,se),s(c,at),s(c,j),g(ee,j,null),s(j,rt),s(j,de),s(c,ot),s(c,U),g(te,U,null),s(U,lt),s(U,ce),s(c,it),s(c,T),g(ne,T,null),s(T,st),s(T,pe),s(T,dt),s(T,me),s(c,ct),s(c,C),g(ae,C,null),s(C,pt),s(C,he),s(c,mt),s(c,J),g(re,J,null),s(J,ht),s(J,ge),s(c,gt),s(c,x),g(oe,x,null),s(x,ut),s(x,ue),o(e,Ze,t),o(e,_e,t),Fe=!0},p:zt,i(e){Fe||(u(I.$$.fragment,e),u(A.$$.fragment,e),u(E.$$.fragment,e),u(W.$$.fragment,e),u(H.$$.fragment,e),u(Q.$$.fragment,e),u(Z.$$.fragment,e),u(R.$$.fragment,e),u(V.$$.fragment,e),u(Y.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(oe.$$.fragment,e),Fe=!0)},o(e){M(I.$$.fragment,e),M(A.$$.fragment,e),M(E.$$.fragment,e),M(W.$$.fragment,e),M(H.$$.fragment,e),M(Q.$$.fragment,e),M(Z.$$.fragment,e),M(R.$$.fragment,e),M(V.$$.fragment,e),M(Y.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(te.$$.fragment,e),M(ne.$$.fragment,e),M(ae.$$.fragment,e),M(re.$$.fragment,e),M(oe.$$.fragment,e),Fe=!1},d(e){e&&(n(ve),n(Te),n(be),n(we),n(P),n(je),n(D),n(Ue),n(Ce),n(O),n(Je),n(w),n(xe),n(q),n($e),n(k),n(Ie),n(L),n(Pe),n(De),n(N),n(Ae),n(Oe),n(B),n(qe),n(ke),n(z),n(Le),n(Ee),n(S),n(Ne),n(We),n(F),n(Be),n(He),n(X),n(ze),n(G),n(Qe),n(Se),n(c),n(Ze),n(_e)),n(b),f(I,e),f(A,e),f(E,e),f(W,e),f(H,e),f(Q,e),f(Z,e),f(R,e),f(V,e),f(Y),f(K),f(ee),f(te),f(ne),f(ae),f(re),f(oe)}}}const Gt='{"title":"DPO Trainer","local":"dpo-trainer","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the DPOTrainer","local":"using-the-dpotrainer","sections":[],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2}],"depth":1}';function Vt(ft){return Qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class an extends St{constructor(b){super(),Zt(this,b,Vt,Xt,Ht,{})}}export{an as component};
