import{s as Ie,n as Ue,o as fe}from"../chunks/scheduler.69131cc3.js";import{S as Ge,i as Ce,g as i,s,r as M,A as be,h as o,f as l,c as n,j as ue,u as w,x as c,k as je,y as ge,a,v as p,d,t as J,w as T}from"../chunks/index.e1f30d73.js";import{C as ie}from"../chunks/CodeBlock.30cef355.js";import{H as X}from"../chunks/Heading.0aab6758.js";function Ae(oe){let r,W,z,_,y,S,m,ce=`Local SGD is a technique for distributed training where gradients are not synchronized every step. Thus, each process updates its own version of the model weights and after a given number of steps these weights are synchronized by averaging across all processes. This improves communication efficiency and can lead to substantial training speed up especially when a computer lacks a faster interconnect such as NVLink.
Unlike gradient accumulation (where improving communication efficiency requires increasing the effective batch size), Local SGD does not require changing a batch size or a learning rate / schedule. However, if necessary, Local SGD can be combined with gradient accumulation as well.`,x,h,re="In this tutorial you will see how to quickly setup  Local SGD 🤗 Accelerate. Compared to a standard Accelerate setup, this requires only two extra lines of code.",N,u,Me="This example will use a very simplistic PyTorch training loop that performs gradient accumulation every two batches:",Y,j,F,I,E,U,we="First the code shown earlier will be converted to use 🤗 Accelerate  with neither a LocalSGD or a gradient accumulation helper:",L,f,H,G,Q,C,pe=`All that is left now is to let 🤗 Accelerate handle model parameter synchronization <strong>and</strong> the gradient accumulation for us. For simplicity let us assume we need to synchronize every 8 steps. This is
achieved by adding one <code>with LocalSGD</code> statement and one call <code>local_sgd.step()</code> after every optimizer step:`,D,b,K,g,de="Under the hood, the Local SGD code <strong>disables</strong> automatic gradient synchornization (but accumulation still works as expected!). Instead it averages model parameters every <code>local_sgd_steps</code> steps (as well as in the end of the training loop).",P,A,q,v,Je='The current implementation works only with basic multi-GPU (or multi-CPU) training without, e.g., <a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed.</a>.',O,B,ee,Z,Te=`Although we are not aware of the true origins of this simple approach, the idea of local SGD is quite old and goes
back to at least:`,te,V,ye=`Zhang, J., De Sa, C., Mitliagkas, I., &amp; Ré, C. (2016). <a href="https://arxiv.org/abs/1606.07365" rel="nofollow">Parallel SGD: When does averaging help?. arXiv preprint
arXiv:1606.07365.</a>`,le,$,me="We credit the term Local SGD to the following paper (but there might be earlier references we are not aware of).",ae,R,he=`Stich, Sebastian Urban. <a href="https://arxiv.org/abs/1805.09767" rel="nofollow">“Local SGD Converges Fast and Communicates Little.” ICLR 2019-International Conference on
Learning Representations. No. CONF. 2019.</a>`,se,k,ne;return y=new X({props:{title:"Using Local SGD with 🤗 Accelerate",local:"using-local-sgd-with--accelerate",headingTag:"h1"}}),j=new ie({props:{code:"ZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsLnRvKGRldmljZSklMEElMEFncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAlM0QlMjAyJTBBJTBBZm9yJTIwaW5kZXglMkMlMjBiYXRjaCUyMGluJTIwZW51bWVyYXRlKHRyYWluaW5nX2RhdGFsb2FkZXIpJTNBJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwaW5wdXRzLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjB0YXJnZXRzJTIwJTNEJTIwdGFyZ2V0cy50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zcyUyMCUyRiUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUwQSUyMCUyMCUyMCUyMGxvc3MuYmFja3dhcmQoKSUwQSUyMCUyMCUyMCUyMGlmJTIwKGluZGV4JTIwJTJCJTIwMSklMjAlMjUlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCk=",highlighted:`device = <span class="hljs-string">&quot;cuda&quot;</span>
model.to(device)

gradient_accumulation_steps = <span class="hljs-number">2</span>

<span class="hljs-keyword">for</span> index, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(training_dataloader):
    inputs, targets = batch
    inputs = inputs.to(device)
    targets = targets.to(device)
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
    loss = loss / gradient_accumulation_steps
    loss.backward()
    <span class="hljs-keyword">if</span> (index + <span class="hljs-number">1</span>) % gradient_accumulation_steps == <span class="hljs-number">0</span>:
        optimizer.step()
        scheduler.step()
        optimizer.zero_grad()`,wrap:!1}}),I=new X({props:{title:"Converting it to 🤗 Accelerate",local:"converting-it-to--accelerate",headingTag:"h2"}}),f=new ie({props:{code:"JTJCJTIwZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUyQiUyMGFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQSUyQiUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyQyUyMHNjaGVkdWxlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBJTJCJTIwJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTBBJTJCJTIwKSUwQSUwQSUyMCUyMGZvciUyMGluZGV4JTJDJTIwYmF0Y2glMjBpbiUyMGVudW1lcmF0ZSh0cmFpbmluZ19kYXRhbG9hZGVyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQS0lMjAlMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjBpbnB1dHMudG8oZGV2aWNlKSUwQS0lMjAlMjAlMjAlMjAlMjB0YXJnZXRzJTIwJTNEJTIwdGFyZ2V0cy50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zcyUyMCUyRiUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUwQSUyQiUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjAoaW5kZXglMkIxKSUyMCUyNSUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NoZWR1bGVyLnN0ZXAoKQ==",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
<span class="hljs-addition">+ accelerator = Accelerator()</span>

<span class="hljs-addition">+ model, optimizer, training_dataloader, scheduler = accelerator.prepare(</span>
<span class="hljs-addition">+     model, optimizer, training_dataloader, scheduler</span>
<span class="hljs-addition">+ )</span>

  for index, batch in enumerate(training_dataloader):
      inputs, targets = batch
<span class="hljs-deletion">-     inputs = inputs.to(device)</span>
<span class="hljs-deletion">-     targets = targets.to(device)</span>
      outputs = model(inputs)
      loss = loss_function(outputs, targets)
      loss = loss / gradient_accumulation_steps
<span class="hljs-addition">+     accelerator.backward(loss)</span>
      if (index+1) % gradient_accumulation_steps == 0:
          optimizer.step()
          scheduler.step()`,wrap:!1}}),G=new X({props:{title:"Letting 🤗 Accelerate handle model synchronization",local:"letting--accelerate-handle-model-synchronization",headingTag:"h2"}}),b=new ie({props:{code:"JTJCbG9jYWxfc2dkX3N0ZXBzJTNEOCUwQSUwQSUyQndpdGglMjBMb2NhbFNHRChhY2NlbGVyYXRvciUzRGFjY2VsZXJhdG9yJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGxvY2FsX3NnZF9zdGVwcyUzRDglMkMlMjBlbmFibGVkJTNEVHJ1ZSklMjBhcyUyMGxvY2FsX3NnZCUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbmluZ19kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMGFjY2VsZXJhdG9yLmFjY3VtdWxhdGUobW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzY2hlZHVsZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9jYWxfc2dkLnN0ZXAoKQ==",highlighted:`<span class="hljs-addition">+local_sgd_steps=8</span>

<span class="hljs-addition">+with LocalSGD(accelerator=accelerator, model=model, local_sgd_steps=8, enabled=True) as local_sgd:</span>
    for batch in training_dataloader:
        with accelerator.accumulate(model):
            inputs, targets = batch
            outputs = model(inputs)
            loss = loss_function(outputs, targets)
            accelerator.backward(loss)
            optimizer.step()
            scheduler.step()
            optimizer.zero_grad()
<span class="hljs-addition">+           local_sgd.step()</span>`,wrap:!1}}),A=new X({props:{title:"Limitations",local:"limitations",headingTag:"h2"}}),B=new X({props:{title:"References",local:"references",headingTag:"h2"}}),{c(){r=i("meta"),W=s(),z=i("p"),_=s(),M(y.$$.fragment),S=s(),m=i("p"),m.textContent=ce,x=s(),h=i("p"),h.textContent=re,N=s(),u=i("p"),u.textContent=Me,Y=s(),M(j.$$.fragment),F=s(),M(I.$$.fragment),E=s(),U=i("p"),U.textContent=we,L=s(),M(f.$$.fragment),H=s(),M(G.$$.fragment),Q=s(),C=i("p"),C.innerHTML=pe,D=s(),M(b.$$.fragment),K=s(),g=i("p"),g.innerHTML=de,P=s(),M(A.$$.fragment),q=s(),v=i("p"),v.innerHTML=Je,O=s(),M(B.$$.fragment),ee=s(),Z=i("p"),Z.textContent=Te,te=s(),V=i("p"),V.innerHTML=ye,le=s(),$=i("p"),$.textContent=me,ae=s(),R=i("p"),R.innerHTML=he,se=s(),k=i("p"),this.h()},l(e){const t=be("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(l),W=n(e),z=o(e,"P",{}),ue(z).forEach(l),_=n(e),w(y.$$.fragment,e),S=n(e),m=o(e,"P",{"data-svelte-h":!0}),c(m)!=="svelte-1gzsxbq"&&(m.textContent=ce),x=n(e),h=o(e,"P",{"data-svelte-h":!0}),c(h)!=="svelte-dv4kyt"&&(h.textContent=re),N=n(e),u=o(e,"P",{"data-svelte-h":!0}),c(u)!=="svelte-n9bxrd"&&(u.textContent=Me),Y=n(e),w(j.$$.fragment,e),F=n(e),w(I.$$.fragment,e),E=n(e),U=o(e,"P",{"data-svelte-h":!0}),c(U)!=="svelte-1kr8lcs"&&(U.textContent=we),L=n(e),w(f.$$.fragment,e),H=n(e),w(G.$$.fragment,e),Q=n(e),C=o(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-16a3mop"&&(C.innerHTML=pe),D=n(e),w(b.$$.fragment,e),K=n(e),g=o(e,"P",{"data-svelte-h":!0}),c(g)!=="svelte-u0v7uu"&&(g.innerHTML=de),P=n(e),w(A.$$.fragment,e),q=n(e),v=o(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-1fij5y0"&&(v.innerHTML=Je),O=n(e),w(B.$$.fragment,e),ee=n(e),Z=o(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-1uio6eh"&&(Z.textContent=Te),te=n(e),V=o(e,"P",{"data-svelte-h":!0}),c(V)!=="svelte-tb25yv"&&(V.innerHTML=ye),le=n(e),$=o(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-5vkth6"&&($.textContent=me),ae=n(e),R=o(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-7r2o7s"&&(R.innerHTML=he),se=n(e),k=o(e,"P",{}),ue(k).forEach(l),this.h()},h(){je(r,"name","hf:doc:metadata"),je(r,"content",ve)},m(e,t){ge(document.head,r),a(e,W,t),a(e,z,t),a(e,_,t),p(y,e,t),a(e,S,t),a(e,m,t),a(e,x,t),a(e,h,t),a(e,N,t),a(e,u,t),a(e,Y,t),p(j,e,t),a(e,F,t),p(I,e,t),a(e,E,t),a(e,U,t),a(e,L,t),p(f,e,t),a(e,H,t),p(G,e,t),a(e,Q,t),a(e,C,t),a(e,D,t),p(b,e,t),a(e,K,t),a(e,g,t),a(e,P,t),p(A,e,t),a(e,q,t),a(e,v,t),a(e,O,t),p(B,e,t),a(e,ee,t),a(e,Z,t),a(e,te,t),a(e,V,t),a(e,le,t),a(e,$,t),a(e,ae,t),a(e,R,t),a(e,se,t),a(e,k,t),ne=!0},p:Ue,i(e){ne||(d(y.$$.fragment,e),d(j.$$.fragment,e),d(I.$$.fragment,e),d(f.$$.fragment,e),d(G.$$.fragment,e),d(b.$$.fragment,e),d(A.$$.fragment,e),d(B.$$.fragment,e),ne=!0)},o(e){J(y.$$.fragment,e),J(j.$$.fragment,e),J(I.$$.fragment,e),J(f.$$.fragment,e),J(G.$$.fragment,e),J(b.$$.fragment,e),J(A.$$.fragment,e),J(B.$$.fragment,e),ne=!1},d(e){e&&(l(W),l(z),l(_),l(S),l(m),l(x),l(h),l(N),l(u),l(Y),l(F),l(E),l(U),l(L),l(H),l(Q),l(C),l(D),l(K),l(g),l(P),l(q),l(v),l(O),l(ee),l(Z),l(te),l(V),l(le),l($),l(ae),l(R),l(se),l(k)),l(r),T(y,e),T(j,e),T(I,e),T(f,e),T(G,e),T(b,e),T(A,e),T(B,e)}}}const ve='{"title":"Using Local SGD with 🤗 Accelerate","local":"using-local-sgd-with--accelerate","sections":[{"title":"Converting it to 🤗 Accelerate","local":"converting-it-to--accelerate","sections":[],"depth":2},{"title":"Letting 🤗 Accelerate handle model synchronization","local":"letting--accelerate-handle-model-synchronization","sections":[],"depth":2},{"title":"Limitations","local":"limitations","sections":[],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function Be(oe){return fe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ze extends Ge{constructor(r){super(),Ce(this,r,Be,Ae,Ie,{})}}export{ze as component};
